/* global RD3_DesktopManager, RD3_ClientParams, RD3_Glb */

// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe CmdList: gestisce la lista in memoria
// di tutti i command set dell'applicazione
// ************************************************

function CommandList()
{
  // Proprieta' di questo oggetto di modello
  this.Identifier = "cmh";        // Identificatore di questo oggetto
  this.SuppressMenu = false;      // Se vero il menu' laterale non sara' visibile
  this.AutoSuppress = true;       // vero se in caso mobile il menu' si sopprime quando si gira il dispositivo
  this.ForceVerticalMenu = false; // vero se vogliamo forzare il menu verticale anche con l'app mobile orizzontale
  //
  this.MenuButton = null;     // Bottone per far apparire il menu' principale (o la form docked) in caso di menu' soppresso
  //
  // Oggetti secondari gestiti da questo oggetto di modello
  this.CommandSets = new Array(); // Elenco dei command set (di primo livello)
  //
  // Struttura per la definizione delle caratteristiche degli eventi di questo oggetto
  this.ClickEventDef = RD3_Glb.EVENT_CLIENTSIDE; // Il click sul suppressmenu deve avvenire come evento server asincrono
  //
  // Variabili di questo oggetto
  this.ToolbarHeight = 0;         // Altezza della Toolbar, impostata nell'AdaptLayout
  this.MenuBarOpen = false;       // Vera se la menubar e' aperta o meno
  this.ForceMenuBar = false;      // Vera se la menubar e' aperta nello smartphone
  //
  // Variabili di collegamento con il DOM
  this.Realized = false; // Se vero, gli oggetti del DOM sono gia' stati creati
  //
  // Indica quale comando e' attivo nel menu' principale di tipo mobile
  this.ActiveCommand = null;
  this.IDScroll = null;					 // Oggetto scroller per mobile
  this.Expanding = false;				 // Vero durante l'espansione o il collassamento di un menu'
  this.ShowGroups = false;       // Menu' mobile a gruppi?
  //
  this.ClientCommands = new HashTable(true); // Lista dei command set creati lato client (popup client)
}


// *******************************************************************
// Inizializza questo CommandList leggendo i dati da un nodo <cmh> XML
// *******************************************************************
CommandList.prototype.LoadFromXml = function (node, torealize)
{
  if (node.nodeName !== this.Identifier)
    return;
  //
  // Inizializzo le proprieta' locali
  this.LoadProperties(node);
  //
  var objlist = node.childNodes;
  var n = objlist.length;
  //
  // Ciclo su tutti i nodi che rappresentano oggetti figli
  for (var i = 0; i < n; i++)
  {
    var objnode = objlist.item(i);
    var nome = objnode.nodeName;
    //
    // In base al tipo di oggetto, invio il messaggio di caricamento
    switch (nome)
    {
      case "cms":
        {
          // Leggo il commandset contenuto (potrebbe gia' esistere)
          var newcmd = RD3_DesktopManager.ObjectMap[objnode.getAttribute("id")];
          if (newcmd)
          {
            // Lo sostituisco, quindi dovro' derealizzare il precedente
            if (torealize)
              newcmd.Unrealize();
          }
          else
          {
            // Creo il nuovo timer
            newcmd = new Command();
            this.CommandSets.push(newcmd);
          }
          newcmd.LoadFromXml(objnode);
          //
          if (torealize) {
            var wep = RD3_DesktopManager.WebEntryPoint;
            newcmd.Realize(wep.HasSideMenu() ? wep.MenuBox : wep.SideMenuBox, wep.RightHeaderCommandsList);
          }
        }
        break;
    }
  }
};


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
CommandList.prototype.ChangeProperties = function (node)
{
  // Semplicemente setto le proprieta' a partire dal nodo
  this.LoadProperties(node);
};


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
CommandList.prototype.LoadProperties = function (node)
{
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i = 0; i < n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch (nome)
    {
      case "sup":
        this.SetSuppressMenu(valore === "1", true);
        break;

      case "clk":
        this.ClickEventDef = parseInt(attrnode.nodeValue);
        break;

      case "sma":
        RD3_ClientParams.GFXDef["sidebar"] = valore;
        break;

      case "id":
        this.Identifier = valore;
        RD3_DesktopManager.ObjectMap.add(valore, this);
        break;
    }
  }
};


// ***************************************************************
// Aggiunge un nuovo figlio a questo oggetto
// ***************************************************************
CommandList.prototype.InsertChild = function(node)
{
  var objlist = node.childNodes;
	var n = objlist.length;
	//
	// Ciclo su tutti i nodi che rappresentano oggetti figli
	for (var i=0; i<n; i++) 
  {
		var objnode = objlist.item(i);
		var nome = objnode.nodeName;
		if (nome == "cms")
		{	
      var wasMenu = this.HasMenu();
      //
		  // Creo il nuovo command set
    	var newcmd = new Command();
      this.CommandSets.push(newcmd);
      newcmd.LoadFromXml(objnode);
      //
      if (this.Realized)
      	newcmd.Realize(RD3_DesktopManager.WebEntryPoint.MenuBox, RD3_DesktopManager.WebEntryPoint.ToolBarBox);
      //
      // Se il comando  di form, lo comunico
      if (newcmd.ToolCont != -1)
        this.ActiveFormChanged();
      //
      // Se e' il primo menu (sono passato da non averlo ad averne uno) "spingo" il suppress menu cosi'
      // il menu "appare"
      if (!wasMenu && this.HasMenu())
        this.SetSuppressMenu();
    }
  }
}


// *******************************************************************
// Setter del SuppressMenu
// *******************************************************************
CommandList.prototype.SetSuppressMenu = function (value, fromSrv)
{
  var old = this.SuppressMenu;
  if (value !== undefined)
    this.SuppressMenu = value;
  //
  if (this.Realized && (old !== this.SuppressMenu || value == undefined)) {
    // Mostro/nascondo il menu box ed il pulsante per gestire il menu
    this.MainMenuContainer.style.display = this.SuppressMenu ? "none" : "";
    RD3_DesktopManager.WebEntryPoint.AdjustMenuVisibility();
  }
};


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM, mentre parenttool indica dove devono
// essere realizzati se si tratta di Toolbar
// ***************************************************************
CommandList.prototype.Realize = function (parent, parenttool)
{
  var n = this.CommandSets.length;
  for (var i = 0; i < n; i++)
    this.CommandSets[i].Realize(parent, parenttool);
  //
  // Eseguo l'impostazione iniziale delle mie proprieta'
  this.Realized = true;
  this.MainMenuContainer = parent;
  this.SetSuppressMenu();
};


// ********************************************************************************
// Calcola le dimensioni dei div in base alla dimensione del contenuto
// ********************************************************************************
CommandList.prototype.AdaptLayout = function ()
{
  
};


// ********************************************************************
// Aggiusta le immagini nei separatori fra i menu' di primo livello
// ********************************************************************
CommandList.prototype.AdaptFirstLevelSeparator = function ()
{
  
};

// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
CommandList.prototype.Unrealize = function ()
{
  // Passo il messaggio a tutti i miei figli
  var n = this.CommandSets.length;
  for (var i = 0; i < n; i++)
    this.CommandSets[i].Unrealize();
  //
  this.ClosePopup();
  //
  // Mi rimuovo dalla mappa
  RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  this.Realized = false;
};


// ********************************************************************************
// Chiude gli eventuali popup aperti
// ********************************************************************************
CommandList.prototype.ClosePopup = function (filtobj)
{
  // Passo il messaggio a tutti i miei figli
  var n = this.CommandSets.length;
  for (var i = 0; i < n; i++)
  {
    this.CommandSets[i].ClosePopup(filtobj);
  }
  //
  // Nascondo anche il calendario
  if (RD3_DesktopManager.WebEntryPoint.CalPopup)
  {
    if (RD3_DesktopManager.WebEntryPoint.CalPopup.getAttribute("idjustopened") === "1")
      RD3_DesktopManager.WebEntryPoint.CalPopup.setAttribute("idjustopened", "");
    else
      RD3_DesktopManager.WebEntryPoint.CalPopup.style.display = "none";
  }
  //
  // e il task bar menu
  if (RD3_DesktopManager.WebEntryPoint.TaskbarMenuBox && filtobj === null)
  {
    var fx = new GFX("taskbar", false, RD3_DesktopManager.WebEntryPoint.TaskbarMenuBox, false);
    RD3_GFXManager.AddEffect(fx);
  }
  //
  n = this.ClientCommands.length;
  for (var i = 0; i < n; i++)
    this.ClientCommands.GetItem(i).ClosePopup(filtobj);
  //
  this.MenuBarOpen = false;
};


// ********************************************************************************
// Segnala che la form attiva e' cambiata: cicla su tutti i figli passandogli il
// messaggio
// ********************************************************************************
CommandList.prototype.ActiveFormChanged = function ()
{
  var n = this.CommandSets.length;
  for (var i = 0; i < n; i++) {
    var c = this.CommandSets[i];
    c.ActiveFormChanged();
  }
};


// ********************************************************************************
// Gestore evento di click sul bottone suppressmenu
// ********************************************************************************
CommandList.prototype.OnClick = function (evento)
{
  
};


// **********************************************************************
// Gestisco la pressione dei tasti FK
// formidx: indice della form, se -1 allora tutte le form
// frameidx: indice del frame, se -1 allora tutti i frame
// **********************************************************************
CommandList.prototype.HandleFunctionKeys = function (eve, formidx, frameidx)
{
  var code = (eve.charCode) ? eve.charCode : eve.keyCode;
  var ok = false;
  //
  // Passo il messaggio a tutti i cmdset
  var n = this.CommandSets.length;
  for (var i = 0; i < n && !ok; i++) 
  {
    var c = this.CommandSets[i];
    //
    ok = c.HandleFunctionKeys(eve, formidx, frameidx);
  }
  //
  return ok;
};


// *******************************************************************
// Gestione acceleratori
// *******************************************************************
CommandList.prototype.HandleAccell = function (eve, code)
{
  
};


// *******************************************************************
// Gestione Drop generico
// *******************************************************************
CommandList.prototype.ComputeDropList = function (list, dragobj)
{
  
};


// *************************************************************************
// Una form multipla si e' chiusa: devo fare l'Unrealize dei suoi commandSet
// *************************************************************************
CommandList.prototype.CloseMultipleForm = function (FormIdx)
{
  // Passo il messaggio a tutti i miei figli
  var n = this.CommandSets.length;
  for (var i = n - 1; i >= 0; i--) {
    if (this.CommandSets[i].FormIndex === FormIdx)
    {
      this.CommandSets[i].Unrealize();
      this.CommandSets.splice(i, 1);
    }
  }
};


// *************************************************************************
// Realizza la lista innestata per il menu' mobile
// *************************************************************************
CommandList.prototype.RealizeMobileMenu = function (cmdlist, parentdiv)
{
  
};


// ********************************************************************************
// Gestore evento di click sul bottone suppressmenu
// ********************************************************************************
CommandList.prototype.OnMenuButton = function (evento)
{
  
};


// ********************************************************************************
// Ho chiuso il menu' principale aperto nel popover
// ********************************************************************************
CommandList.prototype.OnClosePopup = function (popup)
{
  
};


// ********************************************************************************
// Converto gli stili di una form per essere di tipo popover
// ********************************************************************************
CommandList.prototype.ConvertFormPopover = function (fl, fd)
{
  
};



// ********************************************************************************
// Ho chiuso il menu' principale aperto nel popover
// ********************************************************************************
CommandList.prototype.ConvertClassPopover = function (fl)
{
  
};


// ********************************************************************************
// Devo sopprimere il menu'?
// ********************************************************************************
CommandList.prototype.ShouldSuppressMenu = function ()
{
  
};


// ********************************************************************************
// Mostra o meno il bottone, in funzione della docked e del menu
// ********************************************************************************
CommandList.prototype.ShowMenuButton = function ()
{
  
};

// ********************************************************************************
// Imposta la caption del menu' button
// ********************************************************************************
CommandList.prototype.SetMenuButtonCaption = function (txt)
{
  
};


// ********************************************************************************
// Mostra o nasconde il menu' usando un'animazione slide
// ********************************************************************************
CommandList.prototype.SlideMenu = function (show)
{
  
};


// *******************************************************************
// Gestisce animazione combo mobile
// *******************************************************************
CommandList.prototype.OnEndAnimation = function (ev)
{
  
};


// *******************************************************************
// Torna vero se c'e' almeno un menu' visibile
// *******************************************************************
CommandList.prototype.HasMenu = function ()
{
  var n = this.CommandSets.length;
  for (var i = 0; i < n; i++)
  {
    var c = this.CommandSets[i];
    if (c.IsMenu && c.ToolCont < 0 && c.IsVisible())
      return true;
  }
  //
  return false;
};

// *******************************************************************
// Gestisce il comando back girandolo ai commandset;
// ritorna True se e' stato gestito
// *******************************************************************
CommandList.prototype.HandleBackButton = function ()
{
  var n = this.CommandSets.length;
  for (var i = 0; i < n; i++)
  {
    var c = this.CommandSets[i];
    if (c.HandleBackButton())
      return true;
  }
  //
  return false;
};


// *******************************************************************
// Chiamato quando cambia il colore di accento
// *******************************************************************
CommandList.prototype.AccentColorChanged = function (reg, newc)
{
  
};
