var taskDummy = [];

function IDdxGantt(pform)
{
  CustomElement.call(this, pform);
}

IDdxGantt.prototype = new CustomElement();

IDdxGantt.Init = function() {
  if(IDdxGantt.inited){
    return
  }
  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/js/dx.all.js", "JS");
  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/css/dx.light.css", "CSS");
  CustomElement.LoadRequirements("https://cdn3.devexpress.com/jslib/21.2.6/js/dx-gantt.min.js", "JS");
  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/css/dx-gantt.min.css", "CSS");
  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/css/gantt-custom.css", "CSS");
  IDdxGantt.inited = true;
}

IDdxGantt.Init();

Object.defineProperty(IDdxGantt.prototype, "tasks", {
  get: function () {
    return this.tasks;
  },
  set: function (value) {
    // se c'e il gantt va distrutto probabilmente

    this._tasks = value;
    if (this.gantt)
      this.Realize(IDdxGantt.Realize, IDdxGantt.cls);
    else {
      if(IDdxGantt.Realize){
        this.Realize(IDdxGantt.Realize, IDdxGantt.cls);
      }
    }
  }
});


IDdxGantt.prototype.Realize = function (parent, cls) {
  //
  if(!this._tasks){
    IDdxGantt.Realize = parent;
    IDdxGantt.cls = cls;
    return;
  }


  if(!IDdxGantt.inited || this._tasks.length == 0) {
    IDdxGantt.Realize = parent;
    IDdxGantt.cls = cls;
    return;
  }

  CustomElement.prototype.Realize.call(this, parent, cls);
  var pthis = this;
  
  this.ganttDiv = document.createElement("div");
  this.ganttDiv.setAttribute("id","myGantt");
  parent.appendChild(this.ganttDiv);

  if (this.gantt) {
    this.gantt.dispose();
  }
  
  window.setTimeout( function () {
    var pthis = this;
    DevExpress.localization.locale('it-IT');
    $('#myGantt').dxGantt({ 
      height: 500,
      width: 1000,
      scaleType: "years",
      tasks: {
        dataSource: this._tasks,
        colorExpr: "taskColor",
      },
      showRowLines: true,
      firstDayOfWeek: 1,
      toolbar: {
        items: [
          'zoomIn', 
          'zoomOut',
          /*
          {
            widget: 'dxButton',
            options: {
              text: 'Mesi',
              stylingMode: 'text',
              onClick() {
                IDdxGantt.prototype.setOptions([{name: 'scaleType', value: 'months'},]);
               // pthis.gantt.option("scaleType", "months");
              },
            },
          },*/
        ],
      },
      columns: [{
        allowFiltering: true,
        dataField: 'title',
        caption: 'Task',
        width: 300,
      }, {
        dataField: 'description',
        caption: 'Descrizione',
        width: 150,
      },],
      editing: {
        enabled: true,
      },
      validation: {
        autoUpdateParentTasks: true,
      },
      scaleType: "weeks",
      taskListWidth: 500,
      taskTitlePosition: 'inside',
      onTaskInserting: function (e) {
        console.log("task inserito");
      },
      onTaskDeleting: function (e) {
        console.log("task eliminato");
      },
      onInitialized: function(info) {
        if(info)
          pthis.SendEvent("Initialized", []);
      },
      onTaskEditDialogShowing: function (e) {
        e.cancel = true;
      },
  });

              
    this.gantt = $('#myGantt').dxGantt("instance");
  }.bind(this), 500);
}

// custom procedure to udpate the dxScheduler Configuration
// from inde: USE an IDMAP that will be decoded in "data"
IDdxGantt.prototype.updateConfiguration = function(data) {
  $('#myGantt').dxScheduler(data);
}


IDdxGantt.prototype.addTasks = function(taskInfo) {
  this.gantt.insertTask(taskInfo);
}

// this procedure delete an Appointment from the dxScheduler
IDdxGantt.prototype.deleteTask = function(data) {
  if(data!=""){
    this.gantt.deleteTask(data);
  }
}

// this procedure changes language of this Gantt
IDdxGantt.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}


// this procedure changes the Options in the configuration IDdxGantt 
IDdxGantt.prototype.setOptions = function(options) {
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      if(currentOption){
        oName = currentOption.name;
        oValue = currentOption.value;
        if(oName && oValue){
          if(this.gantt){
            this.gantt.option(oName, oValue);
          }
        }
      }
      
    }
  }
}

// this procedure changes language of this scheduler
IDdxGantt.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

// this procedure delete an Appointment from the dxScheduler
IDdxGantt.prototype.checkdatasource = function() {
 console.log(this.gantt._dataSource._items);
}

IDdxGantt.prototype.Unrealize = function ()
{
  if (this.gantt)
    this.gantt.dispose();
  delete this.gantt;
  //
  if (this.ganttDiv.parentNode)
    this.ganttDiv.parentNode.removeChild(this.ganttDiv);
  delete this.ganttDiv;
}


// this procedure moves the focus of Gantt on the destinationDate passed as arg
IDdxGantt.prototype.focusOnDate = function(destinationDate) {
  this.gantt.scrollToDate(destinationDate);
}

/*
  Buttons js
*/
function test(buttonID,eventID){
  console.log("test has been pressed: "+ eventID);
  RD3_SendCommand("@button@button=" + buttonID + ";Event="+ eventID);
}