function IDdxCalendar(pform)
{
  CustomElement.call(this, pform);
}

IDdxCalendar.prototype = new CustomElement();

IDdxCalendar.Init = function() {
  if(IDdxCalendar.inited){
    return
  }
  IDdxCalendar.inited = true;
  //CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/js/dx.all.js", "JS", function () { IDdxCalendar.inited = true; });
  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/css/dx.light.css", "CSS");
}

IDdxCalendar.Init();

Object.defineProperty(IDdxCalendar.prototype, "options", {
  get: function () {
    return this.options;
  },
  set: function (value) {
    if (this.calendar) {
      var opt = (typeof value === String ? JSON.parse(value) : value);
      var keys = Object.keys(opt);
        for (var i = 0; i < keys.length; i++)
          this.calendar.setOption(prop, opt[prop]);
    }
    else
      this._options = value;
  }
});


IDdxCalendar.prototype.Realize = function (parent, cls) {
  //
  if(!IDdxCalendar.inited) {
    IDdxCalendar.Realize = parent;
    return;
  }
  //
  CustomElement.prototype.Realize.call(this, parent, cls);
  var pthis = this;
  
  this.calendarDiv = document.createElement("div");
  this.calendarDiv.setAttribute("id","myCalendar");
  parent.appendChild(this.calendarDiv);

  if (this.calendar) {
    this.calendar.destroy();
  }
  
  function Show(data){
    this.calendar = $('#myCalendar').dxCalendar(data);
  }

  
  
  window.setTimeout( function () {
    var pthis = this;
    
    $('#myCalendar').dxCalendar( { 
      height: 600,
      width: 600,
      value: new Date('03-14-2022'),
      views: ['month'],
      dateSerializationFormat: 'yyyy-MM-ddTHH:mm:ss',
      currentView: 'month',
      currentDate: new Date(2021, 5, 2, 11, 30),
      firstDayOfWeek: 1,
      startDayHour: 8,
      endDayHour: 18,
      showAllDayPanel: false,
      height: 600,
      timezone: 'Europe/London',
      min: new Date('03-05-2022'),
      max: new Date('04-17-2022'),
      cellTemplate: function (cellData, cellIndex, cellElement) {
        const blue = $("<span>").css('color', 'blue')
                                .text(cellData.text);
        const black = $("<span>").text(cellData.text);
        return (cellIndex == 5 || cellIndex == 6) ? blue : black;
      },

      onValueChanged: function (e) {
        pthis.SendEvent("ValueChanged", [e.value]);
      }, 
      onInitialized: function (e) {
        pthis.SendEvent("Inizialized", [e.value]);
      }, 
      onDisposing: function (e) {
        pthis.SendEvent("Disposing", [e.value]);
      }, 
      onOptionChanged: function(data) {
        if(data.name == "zoomLevel") {
          pthis.SendEvent("OptionChanged", [data.value]);
        }   
     }
    } );

    this.calendar = $('#myCalendar').dxCalendar("instance");
  }.bind(this), 350);
  this.calendar = $('#myCalendar').dxCalendar("dispose");

  function getCellTemplate(data) {
    let cssClass = '';

    if (data.view === 'month') {
      if (isWeekend(data.date)) { cssClass = 'weekend'; }

      $.each(holydays, (_, item) => {
        if (data.date.getDate() === item[0] && data.date.getMonth() === item[1]) {
          cssClass = 'holyday';
          return false;
        }
        return true;
      });
    }

    return `<span class='${cssClass}'>${data.text}</span>`;
  }
}

// custom procedure to udpate the dxCalendar Configuration
// from inde: USE an IDMAP that will be decoded in "data"
IDdxCalendar.prototype.updateConfiguration = function(data) {
  this.calendar = $('#myCalendar').dxCalendar(data);
}

// this procedure changes the Options in the configuration IDdxScheduler 
IDdxCalendar.prototype.setOptions = function(options) {
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      oName = currentOption.name;
      oValue = currentOption.value;
      if(oName && oValue){
        this.calendar.option(oName, oValue);
      }
    }
  }
}

// this procedure changes language of this calendar
IDdxCalendar.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}


IDdxCalendar.prototype.Unrealize = function ()
{
  delete this.calendar;
  //
  if (this.calendarDiv.parentNode)
    this.calendarDiv.parentNode.removeChild(this.calendarDiv);
  delete this.calendarDiv;
}
