function IDcalendarRangePicker(pform)
{
  // Call base constructor
  CustomElement.call(this, pform);
}

IDcalendarRangePicker.prototype = new CustomElement();

IDcalendarRangePicker.Init = function() {
  if(IDcalendarRangePicker.inited){
    return
  }
  IDcalendarRangePicker.inited = true;
}

IDcalendarRangePicker.Init();

Object.defineProperty(IDcalendarRangePicker.prototype, "options", {
  get: function () {
    return this.options;
  },
  set: function (value) {
    if (this.calendar) {
      var opt = (typeof value === String ? JSON.parse(value) : value);
      var keys = Object.keys(opt);
        for (var i = 0; i < keys.length; i++)
          this.calendar.setOption(prop, opt[prop]);
    }
    else
      this._options = value;
  }
});


IDcalendarRangePicker.prototype.Realize = function (parent, cls) {
  //
  if(!IDcalendarRangePicker.inited) {
    IDcalendarRangePicker.Realize = parent;
    return;
  }
  //
  CustomElement.prototype.Realize.call(this, parent, cls);
  var pthis = this;
  
  this.calendarDiv = document.createElement("div");
  this.calendarDiv.setAttribute("id","calendarRP");
  parent.appendChild(this.calendarDiv);

  if (this.calendar) {
    this.calendar.destroy();
  }
  
  window.setTimeout( function () {
    var pthis = this;
    DevExpress.localization.locale(navigator.language);
    $('#calendarRP').dxScheduler({ 
        height: 300, 
        width: 300,          
        currentView: 'month',
        view: ['month'],

        dataCellTemplate(itemData, itemIndex, itemElement) {
          const date = itemData.startDate;
          const element = $('<div />');
    
          /*
          if (isDisabled) {
            element.addClass('disable-date');
          } else if (isDinner(date)) {
            element.addClass('dinner');
          }
    
          const isMonth = this.option('currentView') === 'month';
          if (isMonth) {
            element.text(date.getDate());
            element.addClass('dx-scheduler-date-table-cell-text');
          }
    */
          return itemElement;
        },

        onAppointmentAdded: function(event) {
          if(event)
            pthis.SendEvent("AppointmentAdded", [event.appointmentData]);
        }, 

        onAppointmentAdding: function(event) {
          if(event)
            pthis.SendEvent("AppointmentAdding", [event.appointmentData]);
        }, 

        onAppointmentClick: function(event) {
          if(event){

            pthis.SendEvent("AppointmentClick", [event.appointmentData]);
          }
        }, 

        onAppointmentContextMenu: function(event) {
          if(event)
            pthis.SendEvent("AppointmentContextMenu", [event.appointmentData]);
        }, 

        // double click on event
        onAppointmentDblClick: function(event) {
          if(event)
            pthis.SendEvent("AppointmentDblClick", [event.appointmentData]);
        }, 

        onAppointmentDeleted: function(event) {
          if(event)
            pthis.SendEvent("AppointmentDeleted", [event.appointmentData]);
        }, 

        onAppointmentDeleting: function(event) {
          if(event)
            pthis.SendEvent("AppointmentDeleting", [event.appointmentData]);
        }, 

        onAppointmentFormOpening: function(event) {
          if(event)
            pthis.SendEvent("AppointmentFormOpening", [event.appointmentData]);
        }, 

        onAppointmentRendered: function(event) {
          if(event)
            pthis.SendEvent("AppointmentRendered", [event.appointmentData]);
        }, 
        onAppointmentUpdated: function(event) {
          if(event)
            pthis.SendEvent("AppointmentUpdated", [event.appointmentData]);
        }, 
        onAppointmentUpdating: function(event) {
          if(event)
            pthis.SendEvent("AppointmentUpdating", [event.oldData, event.newData]);
        }, 
        onCellClick: function(event) {
          if(event)
            pthis.SendEvent("CellClick", [event.cellData]);
        }, 
        onCellContextMenu : function(event) {
          if(event)
            pthis.SendEvent("CellContextMenu", [event.cellData]);
        }, 
        onContentReady  : function(event) {
          if(event)
            pthis.SendEvent("ContentReady", [event.element]);
        },
        onDisposing: function(info) {
          if(info)
            pthis.SendEvent("Disposing ", [info.value]);
        },
        onInitialized: function(info) {
          if(info)
            pthis.SendEvent("Initialized", [info.element]);
        },
        onOptionChanged: function(data) {
          if(data.name == "selectedCellData") {
            pthis.SendEvent("selectionRange", [data.name, data.value[0].startDate, data.value[0].endDate]);
          }
        }
      });
                    
    this.calendar = $('#calendarRP').dxScheduler("instance");
  }.bind(this), 350);

  this.calendar = $('#calendarRP').dxScheduler("dispose");
}

// custom procedure to udpate the dxScheduler Configuration
// from inde: USE an IDMAP that will be decoded in "data"
IDcalendarRangePicker.prototype.updateConfiguration = function(data) {
  this.calendar = $('#calendarRP').dxScheduler(data);
}

// this procedure adds an Appointment in the dxScheduler
// from inde: USE an IDMAP in which store  text, employeeID, startDate and endDate
// to avoid inserting 2 times the same event, before inserting the event in the calendar we check if already exists 
IDcalendarRangePicker.prototype.addEvent = function(data) {
  searchEvent = IDcalendarRangePicker.prototype.findEvent(this.calendar._dataSource._items, data);
  if(!searchEvent){
    this.calendar.addAppointment (data);
  }
}

IDcalendarRangePicker.prototype.findEvent = function(datasource, data) {
  if(data){
    if(data.ID){
      searchedID = data.ID
      dataSourceLenght = datasource.length;
      for(i = 0; i < dataSourceLenght; i++){
        if(datasource[i]){
          currentID = datasource[i].ID;
          if(currentID == searchedID){
            return datasource[i];
          }
        }
      }
    }
  }
}


// this procedure delete an Appointment from the dxScheduler
IDcalendarRangePicker.prototype.deleteEvent = function(data) {
  if(data){
    if(data.ID){
      var foundEvent = IDcalendarRangePicker.prototype.findEvent(this.calendar._dataSource._items, data);
      if(foundEvent){
        this.calendar.deleteAppointment(this.calendar._dataSource._items[i]);
      }
    }
  }
}

// this procedure changes the Options in the configuration IDcalendarRangePicker 
IDcalendarRangePicker.prototype.setOptions = function(options) {
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      oName = currentOption.name;
      oValue = currentOption.value;
      if(oName && oValue){
        this.calendar.option(oName, oValue);
      }
    }
  }
}

// this procedure delete an Appointment from the dxScheduler
IDcalendarRangePicker.prototype.checkdatasource = function() {
 console.log(this.calendar._dataSource._items);
}

IDcalendarRangePicker.prototype.Unrealize = function ()
{
  if (this.calendar)
    this.calendar.dispose();
  delete this.calendar;
  //
  if (this.calendarDiv.parentNode)
    this.calendarDiv.parentNode.removeChild(this.calendarDiv);
  delete this.calendarDiv;
}

