/*
 * Instant Developer Cloud
 * Copyright Pro Gamma Spa 2000-2021
 * All rights reserved
 */

var Client = Client || {};


/**
 * @class A simple timer
 * @param {Object} widget
 * @param {View|Element} parent - the parent element
 * @param {View} view
 */
Client.IdfIndicator = function (widget, parent, view)
{
  // Set default values
  widget = Object.assign({
    enabled: true,
    visible: true,
    alignment: Client.IdfIndicator.alignments.LEFT,
    clickEventDef: Client.IdfMessagesPump?.eventTypes.ACTIVE
  }, widget);
  //
  Client.Widget.call(this, widget, parent, view);
};


// Make Client.IdfCommand extend Client.Widget
Client.IdfIndicator.prototype = new Client.Widget();


Client.IdfIndicator.transPropMap = {
  frm: "viewId",
  ena: "enabled",
  vis: "visible",
  img: "image",
  ali: "alignment"
};

Client.IdfIndicator.alignments = {
  LEFT: 2,
  CENTER: 3,
  RIGHT: 4
};

/**
 * Convert properties values
 * @param {Object} props
 */
Client.IdfIndicator.convertPropValues = function (props)
{
  props = props || {};
  //
  for (let p in props) {
    switch (p) {
      case Client.IdfIndicator.transPropMap.frm:
        if (props[p])
          props[p] = "frm:" + parseInt(props[p]);
        break;

      case Client.IdfIndicator.transPropMap.ali:
        props[p] = parseInt(props[p]);
        break;

      case Client.IdfIndicator.transPropMap.ena:
      case Client.IdfIndicator.transPropMap.vis:
        props[p] = props[p] === "1";
        break;
    }
  }
};


/**
 * Update inner elements properties
 * @param {Object} props
 */
Client.IdfIndicator.prototype.updateElement = function (props)
{
  Client.Widget.prototype.updateElement.call(this, props);
  //
  for (let p in props) {
    let v = props[p];
    switch (p) {
      case "width":
//        this.setWidth(v);
        break;

      case "tooltip":
//        this.setTooltip(v);
        break;

      case "enabled":
//        this.setEnabled(v);
        break;

      case "visible":
//        this.setVisible(v);
        break;

      case "caption":
//        this.setCaption(v);
        break;

      case "image":
//        this.setImage(v);
        break;

      case "alignment":
//        this.setAlignment(v);
        break;
    }
  }
};
