/*!
 * DevExtreme (dx.viz.debug.js)
 * Version: 23.1.6
 * Build date: Fri Oct 13 2023
 *
 * Copyright (c) 2012 - 2023 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function() {
    var __webpack_modules__ = {
        66798:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/common/m_charts.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.registerPattern = exports.registerGradient = exports.default = void 0;
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                var graphicObjects = {};
                exports.registerPattern = function(options) {
                    var id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: "pattern"
                    }, options);
                    return id
                };
                exports.registerGradient = function(type, options) {
                    var id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: type
                    }, options);
                    return id
                };
                var _default = {
                    getGraphicObjects: function() {
                        return graphicObjects
                    }
                };
                exports.default = _default
            },
        60082:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/m_utils.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _position = __webpack_require__( /*! ../../../core/utils/position */ 37518);
                var _size = __webpack_require__( /*! ../../../core/utils/size */ 58664);
                var _string = __webpack_require__( /*! ../../../core/utils/string */ 68752);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/variable_wrapper */ 26974));
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 58201);
                var _data_source = __webpack_require__( /*! ../../../data/data_source/data_source */ 85273);
                var _utils = __webpack_require__( /*! ../../../data/data_source/utils */ 9234);
                var _utils2 = __webpack_require__( /*! ../../../data/utils */ 16454);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../events/core/events_engine */ 55994));
                var _format_helper = _interopRequireDefault(__webpack_require__( /*! ../../../format_helper */ 30343));
                var _load_panel = _interopRequireDefault(__webpack_require__( /*! ../../../ui/load_panel */ 97218));
                var _filtering = _interopRequireDefault(__webpack_require__( /*! ../../../ui/shared/filtering */ 18740));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                var DATE_INTERVAL_SELECTORS = {
                    year: function(value) {
                        return value && value.getFullYear()
                    },
                    month: function(value) {
                        return value && value.getMonth() + 1
                    },
                    day: function(value) {
                        return value && value.getDate()
                    },
                    quarter: function(value) {
                        return value && Math.floor(value.getMonth() / 3) + 1
                    },
                    hour: function(value) {
                        return value && value.getHours()
                    },
                    minute: function(value) {
                        return value && value.getMinutes()
                    },
                    second: function(value) {
                        return value && value.getSeconds()
                    }
                };
                var getIntervalSelector = function() {
                    var data = arguments[1];
                    var value = this.calculateCellValue(data);
                    if (!(0, _type.isDefined)(value)) {
                        return null
                    }
                    if (isDateType(this.dataType)) {
                        var nameIntervalSelector = arguments[0];
                        return DATE_INTERVAL_SELECTORS[nameIntervalSelector](value)
                    }
                    if ("number" === this.dataType) {
                        var groupInterval = arguments[0];
                        return Math.floor(Number(value) / groupInterval) * groupInterval
                    }
                };
                var equalSelectors = function(selector1, selector2) {
                    if ((0, _type.isFunction)(selector1) && (0, _type.isFunction)(selector2)) {
                        if (selector1.originalCallback && selector2.originalCallback) {
                            return selector1.originalCallback === selector2.originalCallback && selector1.columnIndex === selector2.columnIndex
                        }
                    }
                    return selector1 === selector2
                };

                function isDateType(dataType) {
                    return "date" === dataType || "datetime" === dataType
                }
                var setEmptyText = function($container) {
                    $container.get(0).textContent = "\xa0"
                };
                var normalizeSortingInfo = function(sort) {
                    sort = sort || [];
                    var result = (0, _utils2.normalizeSortingInfo)(sort);
                    for (var i = 0; i < sort.length; i++) {
                        if (sort && sort[i] && void 0 !== sort[i].isExpanded) {
                            result[i].isExpanded = sort[i].isExpanded
                        }
                        if (sort && sort[i] && void 0 !== sort[i].groupInterval) {
                            result[i].groupInterval = sort[i].groupInterval
                        }
                    }
                    return result
                };
                var formatValue = function(value, options) {
                    var valueText = _format_helper.default.format(value, options.format) || value && value.toString() || "";
                    var formatObject = {
                        value: value,
                        valueText: options.getDisplayFormat ? options.getDisplayFormat(valueText) : valueText,
                        target: options.target || "row",
                        groupInterval: options.groupInterval
                    };
                    return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
                };
                var getSummaryText = function(summaryItem, summaryTexts) {
                    var displayFormat = summaryItem.displayFormat || summaryItem.columnCaption && summaryTexts["".concat(summaryItem.summaryType, "OtherColumn")] || summaryTexts[summaryItem.summaryType];
                    return formatValue(summaryItem.value, {
                        format: summaryItem.valueFormat,
                        getDisplayFormat: function(valueText) {
                            return displayFormat ? (0, _string.format)(displayFormat, valueText, summaryItem.columnCaption) : valueText
                        },
                        customizeText: summaryItem.customizeText
                    })
                };
                var getWidgetInstance = function($element) {
                    var editorData = $element.data && $element.data();
                    var dxComponents = editorData && editorData.dxComponents;
                    var widgetName = dxComponents && dxComponents[0];
                    return widgetName && editorData[widgetName]
                };
                var _default = {
                    renderNoDataText: function($element) {
                        $element = $element || this.element();
                        if (!$element) {
                            return
                        }
                        var noDataClass = this.addWidgetPrefix("nodata");
                        var noDataElement = $element.find(".".concat(noDataClass)).last();
                        var isVisible = this._dataController.isEmpty();
                        var isLoading = this._dataController.isLoading();
                        if (!noDataElement.length) {
                            noDataElement = (0, _renderer.default)("<span>").addClass(noDataClass)
                        }
                        if (!noDataElement.parent().is($element)) {
                            noDataElement.appendTo($element)
                        }
                        if (isVisible && !isLoading) {
                            noDataElement.removeClass("dx-hidden").text(this._getNoDataText())
                        } else {
                            noDataElement.addClass("dx-hidden")
                        }
                    },
                    renderLoadPanel: function($element, $container, isLocalStore) {
                        var loadPanelOptions;
                        this._loadPanel && this._loadPanel.$element().remove();
                        loadPanelOptions = this.option("loadPanel");
                        if (loadPanelOptions && ("auto" === loadPanelOptions.enabled ? !isLocalStore : loadPanelOptions.enabled)) {
                            loadPanelOptions = (0, _extend.extend)({
                                shading: false,
                                message: loadPanelOptions.text,
                                container: $container
                            }, loadPanelOptions);
                            this._loadPanel = this._createComponent((0, _renderer.default)("<div>").appendTo($container), _load_panel.default, loadPanelOptions)
                        } else {
                            this._loadPanel = null
                        }
                    },
                    calculateLoadPanelPosition: function($element) {
                        var $window = (0, _renderer.default)((0, _window.getWindow)());
                        if ((0, _size.getHeight)($element) > (0, _size.getHeight)($window)) {
                            return {
                                of: $window,
                                boundary: $element,
                                collision: "fit"
                            }
                        }
                        return {
                            of: $element
                        }
                    },
                    getIndexByKey: function(key, items, keyName) {
                        var index = -1;
                        if (void 0 !== key && Array.isArray(items)) {
                            keyName = arguments.length <= 2 ? "key" : keyName;
                            for (var i = 0; i < items.length; i++) {
                                var item = (0, _type.isDefined)(keyName) ? items[i][keyName] : items[i];
                                if ((0, _common.equalByValue)(key, item)) {
                                    index = i;
                                    break
                                }
                            }
                        }
                        return index
                    },
                    combineFilters: function(filters, operation) {
                        var _a;
                        var resultFilter = [];
                        operation = operation || "and";
                        for (var i = 0; i < filters.length; i++) {
                            if (!filters[i]) {
                                continue
                            }
                            if (1 === (null === (_a = filters[i]) || void 0 === _a ? void 0 : _a.length) && "!" === filters[i][0]) {
                                if ("and" === operation) {
                                    return ["!"]
                                }
                                if ("or" === operation) {
                                    continue
                                }
                            }
                            if (resultFilter.length) {
                                resultFilter.push(operation)
                            }
                            resultFilter.push(filters[i])
                        }
                        if (1 === resultFilter.length) {
                            resultFilter = resultFilter[0]
                        }
                        if (resultFilter.length) {
                            return resultFilter
                        }
                        return
                    },
                    checkChanges: function(changes, changeNames) {
                        var changesWithChangeNamesCount = 0;
                        for (var i = 0; i < changeNames.length; i++) {
                            if (changes[changeNames[i]]) {
                                changesWithChangeNamesCount++
                            }
                        }
                        return changes.length && changes.length === changesWithChangeNamesCount
                    },
                    equalFilterParameters: function equalFilterParameters(filter1, filter2) {
                        if (Array.isArray(filter1) && Array.isArray(filter2)) {
                            if (filter1.length !== filter2.length) {
                                return false
                            }
                            for (var i = 0; i < filter1.length; i++) {
                                if (!equalFilterParameters(filter1[i], filter2[i])) {
                                    return false
                                }
                            }
                            return true
                        }
                        if ((0, _type.isFunction)(filter1) && filter1.columnIndex >= 0 && (0, _type.isFunction)(filter2) && filter2.columnIndex >= 0) {
                            return filter1.columnIndex === filter2.columnIndex && (0, _data.toComparable)(filter1.filterValue) === (0, _data.toComparable)(filter2.filterValue) && (0, _data.toComparable)(filter1.selectedFilterOperation) === (0, _data.toComparable)(filter2.selectedFilterOperation)
                        }
                        return (0, _data.toComparable)(filter1) == (0, _data.toComparable)(filter2)
                    },
                    proxyMethod: function(instance, methodName, defaultResult) {
                        if (!instance[methodName]) {
                            instance[methodName] = function() {
                                var dataSource = this._dataSource;
                                return dataSource ? dataSource[methodName].apply(dataSource, arguments) : defaultResult
                            }
                        }
                    },
                    formatValue: formatValue,
                    getFormatOptionsByColumn: function(column, target) {
                        return {
                            format: column.format,
                            getDisplayFormat: column.getDisplayFormat,
                            customizeText: column.customizeText,
                            target: target,
                            trueText: column.trueText,
                            falseText: column.falseText
                        }
                    },
                    getDisplayValue: function(column, value, data, rowType) {
                        if (column.displayValueMap && void 0 !== column.displayValueMap[value]) {
                            return column.displayValueMap[value]
                        }
                        if (column.calculateDisplayValue && data && "group" !== rowType) {
                            return column.calculateDisplayValue(data)
                        }
                        if (column.lookup && !("group" === rowType && (column.calculateGroupValue || column.calculateDisplayValue))) {
                            return column.lookup.calculateCellValue(value)
                        }
                        return value
                    },
                    getGroupRowSummaryText: function(summaryItems, summaryTexts) {
                        var result = "(";
                        for (var i = 0; i < summaryItems.length; i++) {
                            var summaryItem = summaryItems[i];
                            result += (i > 0 ? ", " : "") + getSummaryText(summaryItem, summaryTexts)
                        }
                        return result + ")"
                    },
                    getSummaryText: getSummaryText,
                    normalizeSortingInfo: normalizeSortingInfo,
                    getFormatByDataType: function(dataType) {
                        switch (dataType) {
                            case "date":
                                return "shortDate";
                            case "datetime":
                                return "shortDateShortTime";
                            default:
                                return
                        }
                    },
                    getHeaderFilterGroupParameters: function(column, remoteGrouping) {
                        var result = [];
                        var dataField = column.dataField || column.name;
                        var groupInterval = _filtering.default.getGroupInterval(column);
                        if (groupInterval) {
                            (0, _iterator.each)(groupInterval, (function(index, interval) {
                                result.push(remoteGrouping ? {
                                    selector: dataField,
                                    groupInterval: interval,
                                    isExpanded: index < groupInterval.length - 1
                                } : getIntervalSelector.bind(column, interval))
                            }));
                            return result
                        }
                        if (remoteGrouping) {
                            result = [{
                                selector: dataField,
                                isExpanded: false
                            }]
                        } else {
                            result = function(data) {
                                var result = column.calculateCellValue(data);
                                if (void 0 === result || "" === result) {
                                    result = null
                                }
                                return result
                            };
                            if (column.sortingMethod) {
                                result = [{
                                    selector: result,
                                    compare: column.sortingMethod.bind(column)
                                }]
                            }
                        }
                        return result
                    },
                    equalSortParameters: function(sortParameters1, sortParameters2, ignoreIsExpanded) {
                        sortParameters1 = normalizeSortingInfo(sortParameters1);
                        sortParameters2 = normalizeSortingInfo(sortParameters2);
                        if (Array.isArray(sortParameters1) && Array.isArray(sortParameters2)) {
                            if (sortParameters1.length !== sortParameters2.length) {
                                return false
                            }
                            for (var i = 0; i < sortParameters1.length; i++) {
                                if (!equalSelectors(sortParameters1[i].selector, sortParameters2[i].selector) || sortParameters1[i].desc !== sortParameters2[i].desc || sortParameters1[i].groupInterval !== sortParameters2[i].groupInterval || !ignoreIsExpanded && Boolean(sortParameters1[i].isExpanded) !== Boolean(sortParameters2[i].isExpanded)) {
                                    return false
                                }
                            }
                            return true
                        }
                        return (!sortParameters1 || !sortParameters1.length) === (!sortParameters2 || !sortParameters2.length)
                    },
                    getPointsByColumns: function(items, pointCreated, isVertical, startColumnIndex) {
                        var cellsLength = items.length;
                        var notCreatePoint = false;
                        var item;
                        var offset;
                        var columnIndex = startColumnIndex || 0;
                        var result = [];
                        var rtlEnabled;
                        for (var i = 0; i <= cellsLength; i++) {
                            if (i < cellsLength) {
                                item = items.eq(i);
                                offset = item.offset();
                                rtlEnabled = "rtl" === item.css("direction")
                            }
                            var point = {
                                index: columnIndex,
                                x: offset ? offset.left + (!isVertical && rtlEnabled ^ i === cellsLength ? (0, _position.getBoundingRect)(item[0]).width : 0) : 0,
                                y: offset ? offset.top + (isVertical && i === cellsLength ? (0, _position.getBoundingRect)(item[0]).height : 0) : 0,
                                columnIndex: columnIndex
                            };
                            if (!isVertical && i > 0) {
                                var prevItemOffset = items.eq(i - 1).offset();
                                if (prevItemOffset.top < point.y) {
                                    point.y = prevItemOffset.top
                                }
                            }
                            if (pointCreated) {
                                notCreatePoint = pointCreated(point)
                            }
                            if (!notCreatePoint) {
                                result.push(point)
                            }
                            columnIndex++
                        }
                        return result
                    },
                    getExpandCellTemplate: function() {
                        return {
                            allowRenderToDetachedContainer: true,
                            render: function(container, options) {
                                var $container = (0, _renderer.default)(container);
                                if ((0, _type.isDefined)(options.value) && !(options.data && options.data.isContinuation) && !options.row.isNewRow) {
                                    var rowsView = options.component.getView("rowsView");
                                    $container.addClass("dx-datagrid-expand").addClass("dx-selection-disabled");
                                    (0, _renderer.default)("<div>").addClass(options.value ? "dx-datagrid-group-opened" : "dx-datagrid-group-closed").appendTo($container);
                                    rowsView.setAria("label", options.value ? rowsView.localize("dxDataGrid-ariaCollapse") : rowsView.localize("dxDataGrid-ariaExpand"), $container)
                                } else {
                                    setEmptyText($container)
                                }
                            }
                        }
                    },
                    setEmptyText: setEmptyText,
                    isDateType: isDateType,
                    getSelectionRange: function(focusedElement) {
                        try {
                            if (focusedElement) {
                                return {
                                    selectionStart: focusedElement.selectionStart,
                                    selectionEnd: focusedElement.selectionEnd
                                }
                            }
                        } catch (e) {}
                        return {}
                    },
                    setSelectionRange: function(focusedElement, selectionRange) {
                        try {
                            if (focusedElement && focusedElement.setSelectionRange) {
                                focusedElement.setSelectionRange(selectionRange.selectionStart, selectionRange.selectionEnd)
                            }
                        } catch (e) {}
                    },
                    focusAndSelectElement: function(component, $element) {
                        var isFocused = $element.is(":focus");
                        _events_engine.default.trigger($element, "focus");
                        var isSelectTextOnEditingStart = component.option("editing.selectTextOnEditStart");
                        var element = $element.get(0);
                        if (!isFocused && isSelectTextOnEditingStart && $element.is(".dx-texteditor-input") && !$element.is("[readonly]")) {
                            var editor = getWidgetInstance($element.closest(".dx-texteditor"));
                            (0, _deferred.when)(editor && editor._loadItemDeferred).done((function() {
                                element.select()
                            }))
                        }
                    },
                    getWidgetInstance: getWidgetInstance,
                    getLastResizableColumnIndex: function(columns, resultWidths) {
                        var hasResizableColumns = columns.some((function(column) {
                            return column && !column.command && !column.fixed && false !== column.allowResizing
                        }));
                        var lastColumnIndex;
                        for (lastColumnIndex = columns.length - 1; columns[lastColumnIndex]; lastColumnIndex--) {
                            var column = columns[lastColumnIndex];
                            var width = resultWidths && resultWidths[lastColumnIndex];
                            var allowResizing = !hasResizableColumns || false !== column.allowResizing;
                            if (!column.command && !column.fixed && "adaptiveHidden" !== width && allowResizing) {
                                break
                            }
                        }
                        return lastColumnIndex
                    },
                    isElementInCurrentGrid: function(controller, $element) {
                        if ($element && $element.length) {
                            var $grid = $element.closest(".".concat(controller.getWidgetContainerClass())).parent();
                            return $grid.is(controller.component.$element())
                        }
                        return false
                    },
                    isVirtualRowRendering: function(that) {
                        var rowRenderingMode = that.option("scrolling.rowRenderingMode");
                        var isVirtualMode = "virtual" === that.option("scrolling.mode");
                        var isAppendMode = "infinite" === that.option("scrolling.mode");
                        if (false === that.option("scrolling.legacyMode") && (isVirtualMode || isAppendMode)) {
                            return true
                        }
                        return "virtual" === rowRenderingMode
                    },
                    getPixelRatio: function(window) {
                        return window.devicePixelRatio || 1
                    },
                    getContentHeightLimit: function(browser) {
                        if (browser.mozilla) {
                            return 8e6
                        }
                        return 15e6 / this.getPixelRatio((0, _window.getWindow)())
                    },
                    normalizeLookupDataSource: function(lookup) {
                        var lookupDataSourceOptions;
                        if (lookup.items) {
                            lookupDataSourceOptions = lookup.items
                        } else {
                            lookupDataSourceOptions = lookup.dataSource;
                            if ((0, _type.isFunction)(lookupDataSourceOptions) && !_variable_wrapper.default.isWrapped(lookupDataSourceOptions)) {
                                lookupDataSourceOptions = lookupDataSourceOptions({})
                            }
                        }
                        return (0, _utils.normalizeDataSourceOptions)(lookupDataSourceOptions)
                    },
                    getWrappedLookupDataSource: function(column, dataSource, filter) {
                        var _this = this;
                        if (!dataSource) {
                            return []
                        }
                        var lookupDataSourceOptions = this.normalizeLookupDataSource(column.lookup);
                        if (column.calculateCellValue !== column.defaultCalculateCellValue) {
                            return lookupDataSourceOptions
                        }
                        var hasGroupPaging = dataSource.remoteOperations().groupPaging;
                        var hasLookupOptimization = column.displayField && (0, _type.isString)(column.displayField);
                        var cachedUniqueRelevantItems;
                        var previousTake;
                        var previousSkip;
                        var sliceItems = function(items, loadOptions) {
                            var _a;
                            var start = null !== (_a = loadOptions.skip) && void 0 !== _a ? _a : 0;
                            var end = loadOptions.take ? start + loadOptions.take : items.length;
                            return items.slice(start, end)
                        };
                        var loadUniqueRelevantItems = function(loadOptions) {
                            var group = function(group) {
                                if (!Array.isArray(group)) {
                                    group = [group]
                                }
                                return group.map((function(item, i) {
                                    if ((0, _type.isString)(item)) {
                                        return {
                                            selector: item,
                                            isExpanded: i < group.length - 1
                                        }
                                    }
                                    return item
                                }))
                            }(hasLookupOptimization ? [column.dataField, column.displayField] : column.dataField);
                            var d = new _deferred.Deferred;
                            var canUseCache = cachedUniqueRelevantItems && (!hasGroupPaging || loadOptions.skip === previousSkip && loadOptions.take === previousTake);
                            if (canUseCache) {
                                d.resolve(sliceItems(cachedUniqueRelevantItems, loadOptions))
                            } else {
                                previousSkip = loadOptions.skip;
                                previousTake = loadOptions.take;
                                dataSource.load({
                                    filter: filter,
                                    group: group,
                                    take: hasGroupPaging ? loadOptions.take : void 0,
                                    skip: hasGroupPaging ? loadOptions.skip : void 0
                                }).done((function(items) {
                                    cachedUniqueRelevantItems = items;
                                    d.resolve(hasGroupPaging ? items : sliceItems(items, loadOptions))
                                })).fail(d.fail)
                            }
                            return d
                        };
                        var lookupDataSource = _extends(_extends({}, lookupDataSourceOptions), {
                            __dataGridSourceFilter: filter,
                            load: function(loadOptions) {
                                var d = new _deferred.Deferred;
                                loadUniqueRelevantItems(loadOptions).done((function(items) {
                                    if (0 === items.length) {
                                        d.resolve([]);
                                        return
                                    }
                                    var filter = _this.combineFilters(items.flatMap((function(data) {
                                        return data.key
                                    })).map((function(key) {
                                        return [column.lookup.valueExpr, key]
                                    })), "or");
                                    var newDataSource = new _data_source.DataSource(_extends(_extends(_extends({}, lookupDataSourceOptions), loadOptions), {
                                        filter: _this.combineFilters([filter, loadOptions.filter], "and"),
                                        paginate: false
                                    }));
                                    newDataSource.load().done(d.resolve).fail(d.fail)
                                })).fail(d.fail);
                                return d
                            },
                            key: column.lookup.valueExpr,
                            byKey: function(key) {
                                var d = (0, _deferred.Deferred)();
                                this.load({
                                    filter: [column.lookup.valueExpr, "=", key]
                                }).done((function(arr) {
                                    d.resolve(arr[0])
                                }));
                                return d.promise()
                            }
                        });
                        return lookupDataSource
                    },
                    logHeaderFilterDeprecatedWarningIfNeed: function(component) {
                        var logWarning = component._logDeprecatedOptionWarning.bind(component);
                        if ((0, _type.isDefined)(component.option("headerFilter.allowSearch"))) {
                            logWarning("headerFilter.allowSearch", {
                                since: "23.1",
                                alias: "headerFilter.search.enabled"
                            })
                        }
                        if ((0, _type.isDefined)(component.option("headerFilter.searchTimeout"))) {
                            logWarning("headerFilter.searchTimeout", {
                                since: "23.1",
                                alias: "headerFilter.search.timeout"
                            })
                        }
                        var specificName = "dxPivotGrid" === component.NAME ? "dataSource.fields" : "columns";
                        var columns = component.option(specificName);
                        if (!Array.isArray(columns)) {
                            return
                        }! function logSpecificDeprecatedWarningIfNeed(columns) {
                            columns.forEach((function(column) {
                                var _a;
                                var headerFilter = column.headerFilter || {};
                                if ((0, _type.isDefined)(headerFilter.allowSearch)) {
                                    logWarning("".concat(specificName, "[].headerFilter.allowSearch"), {
                                        since: "23.1",
                                        alias: "".concat(specificName, "[].headerFilter.search.enabled")
                                    })
                                }
                                if ((0, _type.isDefined)(headerFilter.searchMode)) {
                                    logWarning("".concat(specificName, "[].headerFilter.searchMode"), {
                                        since: "23.1",
                                        alias: "".concat(specificName, "[].headerFilter.search.mode")
                                    })
                                }
                                if (null === (_a = column.columns) || void 0 === _a ? void 0 : _a.length) {
                                    logSpecificDeprecatedWarningIfNeed(column.columns)
                                }
                            }))
                        }(columns)
                    }
                };
                exports.default = _default
            },
        86988:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/m_draggable.js ***!
              \***********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _position = _interopRequireDefault(__webpack_require__( /*! ../animation/position */ 49387));
                var _translator = __webpack_require__( /*! ../animation/translator */ 31648);
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../core/component_registrator */ 99393));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../core/dom_component */ 13046));
                var _element = __webpack_require__( /*! ../core/element */ 6415);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _empty_template = __webpack_require__( /*! ../core/templates/empty_template */ 10688);
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _inflector = __webpack_require__( /*! ../core/utils/inflector */ 78008);
                var _position2 = __webpack_require__( /*! ../core/utils/position */ 37518);
                var _size = __webpack_require__( /*! ../core/utils/size */ 58664);
                var _string = __webpack_require__( /*! ../core/utils/string */ 68752);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _view_port = __webpack_require__( /*! ../core/utils/view_port */ 77695);
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _drag = __webpack_require__( /*! ../events/drag */ 23174);
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../events/pointer */ 93786));
                var _index = __webpack_require__( /*! ../events/utils/index */ 39611);
                var _animator = _interopRequireDefault(__webpack_require__( /*! ../ui/scroll_view/animator */ 6866));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }

                function _defineProperty(obj, key, value) {
                    key = function(arg) {
                        var key = function(input, hint) {
                            if ("object" !== _typeof(input) || null === input) {
                                return input
                            }
                            var prim = input[Symbol.toPrimitive];
                            if (void 0 !== prim) {
                                var res = prim.call(input, hint || "default");
                                if ("object" !== _typeof(res)) {
                                    return res
                                }
                                throw new TypeError("@@toPrimitive must return a primitive value.")
                            }
                            return ("string" === hint ? String : Number)(input)
                        }(arg, "string");
                        return "symbol" === _typeof(key) ? key : String(key)
                    }(key);
                    if (key in obj) {
                        Object.defineProperty(obj, key, {
                            value: value,
                            enumerable: true,
                            configurable: true,
                            writable: true
                        })
                    } else {
                        obj[key] = value
                    }
                    return obj
                }
                var window = (0, _window.getWindow)();
                var DRAGGABLE = "dxDraggable";
                var DRAGSTART_EVENT_NAME = (0, _index.addNamespace)(_drag.start, DRAGGABLE);
                var DRAG_EVENT_NAME = (0, _index.addNamespace)(_drag.move, DRAGGABLE);
                var DRAGEND_EVENT_NAME = (0, _index.addNamespace)(_drag.end, DRAGGABLE);
                var DRAG_ENTER_EVENT_NAME = (0, _index.addNamespace)(_drag.enter, DRAGGABLE);
                var DRAGEND_LEAVE_EVENT_NAME = (0, _index.addNamespace)(_drag.leave, DRAGGABLE);
                var POINTERDOWN_EVENT_NAME = (0, _index.addNamespace)(_pointer.default.down, DRAGGABLE);
                var KEYDOWN_EVENT_NAME = (0, _index.addNamespace)("keydown", DRAGGABLE);
                var targetDraggable;
                var sourceDraggable;
                var getMousePosition = function(event) {
                    return {
                        x: event.pageX - (0, _renderer.default)(window).scrollLeft(),
                        y: event.pageY - (0, _renderer.default)(window).scrollTop()
                    }
                };
                var ScrollHelper = function() {
                    function ScrollHelper(orientation, component) {
                        this._$scrollableAtPointer = null;
                        this._preventScroll = true;
                        this._component = component;
                        if ("vertical" === orientation) {
                            this._scrollValue = "scrollTop";
                            this._overFlowAttr = "overflowY";
                            this._sizeAttr = "height";
                            this._scrollSizeProp = "scrollHeight";
                            this._clientSizeProp = "clientHeight";
                            this._limitProps = {
                                start: "top",
                                end: "bottom"
                            }
                        } else {
                            this._scrollValue = "scrollLeft";
                            this._overFlowAttr = "overflowX";
                            this._sizeAttr = "width";
                            this._scrollSizeProp = "scrollWidth";
                            this._clientSizeProp = "clientWidth";
                            this._limitProps = {
                                start: "left",
                                end: "right"
                            }
                        }
                    }
                    var _proto = ScrollHelper.prototype;
                    _proto.updateScrollable = function(elements, mousePosition) {
                        var _this = this;
                        var isScrollableFound = false;
                        elements.some((function(element) {
                            var $element = (0, _renderer.default)(element);
                            var isTargetOverOverlayWrapper = $element.hasClass("dx-overlay-wrapper");
                            var isTargetOverOverlayContent = $element.hasClass("dx-overlay-content");
                            if (isTargetOverOverlayWrapper || isTargetOverOverlayContent) {
                                return true
                            }
                            isScrollableFound = _this._trySetScrollable(element, mousePosition);
                            return isScrollableFound
                        }));
                        if (!isScrollableFound) {
                            this._$scrollableAtPointer = null;
                            this._scrollSpeed = 0
                        }
                    };
                    _proto.isScrolling = function() {
                        return !!this._scrollSpeed
                    };
                    _proto.isScrollable = function($element) {
                        return ("auto" === $element.css(this._overFlowAttr) || $element.hasClass("dx-scrollable-container")) && $element.prop(this._scrollSizeProp) > Math.ceil("width" === this._sizeAttr ? (0, _size.getWidth)($element) : (0, _size.getHeight)($element))
                    };
                    _proto._trySetScrollable = function(element, mousePosition) {
                        var $element = (0, _renderer.default)(element);
                        var distanceToBorders;
                        var sensitivity = this._component.option("scrollSensitivity");
                        var isScrollable = this.isScrollable($element);
                        if (isScrollable) {
                            distanceToBorders = this._calculateDistanceToBorders($element, mousePosition);
                            if (sensitivity > distanceToBorders[this._limitProps.start]) {
                                if (!this._preventScroll) {
                                    this._scrollSpeed = -this._calculateScrollSpeed(distanceToBorders[this._limitProps.start]);
                                    this._$scrollableAtPointer = $element
                                }
                            } else if (sensitivity > distanceToBorders[this._limitProps.end]) {
                                if (!this._preventScroll) {
                                    this._scrollSpeed = this._calculateScrollSpeed(distanceToBorders[this._limitProps.end]);
                                    this._$scrollableAtPointer = $element
                                }
                            } else {
                                isScrollable = false;
                                this._preventScroll = false
                            }
                        }
                        return isScrollable
                    };
                    _proto._calculateDistanceToBorders = function($area, mousePosition) {
                        var area = $area.get(0);
                        var areaBoundingRect;
                        if (area) {
                            areaBoundingRect = (0, _position2.getBoundingRect)(area);
                            return {
                                left: mousePosition.x - areaBoundingRect.left,
                                top: mousePosition.y - areaBoundingRect.top,
                                right: areaBoundingRect.right - mousePosition.x,
                                bottom: areaBoundingRect.bottom - mousePosition.y
                            }
                        }
                        return {}
                    };
                    _proto._calculateScrollSpeed = function(distance) {
                        var component = this._component;
                        var sensitivity = component.option("scrollSensitivity");
                        var maxSpeed = component.option("scrollSpeed");
                        return Math.ceil(Math.pow((sensitivity - distance) / sensitivity, 2) * maxSpeed)
                    };
                    _proto.scrollByStep = function() {
                        if (this._$scrollableAtPointer && this._scrollSpeed) {
                            if (this._$scrollableAtPointer.hasClass("dx-scrollable-container")) {
                                var $scrollable = this._$scrollableAtPointer.closest(".dx-scrollable");
                                var scrollableInstance = $scrollable.data("dxScrollable") || $scrollable.data("dxScrollView");
                                if (scrollableInstance) {
                                    var nextScrollPosition = scrollableInstance.scrollOffset()[this._limitProps.start] + this._scrollSpeed;
                                    scrollableInstance.scrollTo(_defineProperty({}, this._limitProps.start, nextScrollPosition))
                                }
                            } else {
                                var _nextScrollPosition = this._$scrollableAtPointer[this._scrollValue]() + this._scrollSpeed;
                                this._$scrollableAtPointer[this._scrollValue](_nextScrollPosition)
                            }
                            var dragMoveArgs = this._component._dragMoveArgs;
                            if (dragMoveArgs) {
                                this._component._dragMoveHandler(dragMoveArgs)
                            }
                        }
                    };
                    _proto.reset = function() {
                        this._$scrollableAtPointer = null;
                        this._scrollSpeed = 0;
                        this._preventScroll = true
                    };
                    _proto.isOutsideScrollable = function($scrollable, event) {
                        if (!$scrollable) {
                            return false
                        }
                        var scrollableSize = (0, _position2.getBoundingRect)($scrollable.get(0));
                        var start = scrollableSize[this._limitProps.start];
                        var size = scrollableSize[this._sizeAttr];
                        var mousePosition = getMousePosition(event);
                        var location = "width" === this._sizeAttr ? mousePosition.x : mousePosition.y;
                        return location < start || location > start + size
                    };
                    return ScrollHelper
                }();
                var ScrollAnimator = _animator.default.inherit({
                    ctor: function(strategy) {
                        this.callBase();
                        this._strategy = strategy
                    },
                    _step: function() {
                        var horizontalScrollHelper = this._strategy._horizontalScrollHelper;
                        var verticalScrollHelper = this._strategy._verticalScrollHelper;
                        horizontalScrollHelper && horizontalScrollHelper.scrollByStep();
                        verticalScrollHelper && verticalScrollHelper.scrollByStep()
                    }
                });
                var Draggable = _dom_component.default.inherit({
                    reset: _common.noop,
                    dragMove: _common.noop,
                    dragEnter: _common.noop,
                    dragLeave: _common.noop,
                    dragEnd: function(sourceEvent) {
                        var sourceDraggable = this._getSourceDraggable();
                        sourceDraggable._fireRemoveEvent(sourceEvent);
                        return (0, _deferred.Deferred)().resolve()
                    },
                    _fireRemoveEvent: _common.noop,
                    _getDefaultOptions: function() {
                        return (0, _extend.extend)(this.callBase(), {
                            onDragStart: null,
                            onDragMove: null,
                            onDragEnd: null,
                            onDragEnter: null,
                            onDragLeave: null,
                            onDragCancel: null,
                            onCancelByEsc: false,
                            onDrop: null,
                            immediate: true,
                            dragDirection: "both",
                            boundary: void 0,
                            boundOffset: 0,
                            allowMoveByClick: false,
                            itemData: null,
                            container: void 0,
                            dragTemplate: void 0,
                            contentTemplate: "content",
                            handle: "",
                            filter: "",
                            clone: false,
                            autoScroll: true,
                            scrollSpeed: 30,
                            scrollSensitivity: 60,
                            group: void 0,
                            data: void 0
                        })
                    },
                    _setOptionsByReference: function() {
                        this.callBase.apply(this, arguments);
                        (0, _extend.extend)(this._optionsByReference, {
                            component: true,
                            group: true,
                            itemData: true,
                            data: true
                        })
                    },
                    _init: function() {
                        this.callBase();
                        this._attachEventHandlers();
                        this._scrollAnimator = new ScrollAnimator(this);
                        this._horizontalScrollHelper = new ScrollHelper("horizontal", this);
                        this._verticalScrollHelper = new ScrollHelper("vertical", this);
                        this._initScrollTop = 0;
                        this._initScrollLeft = 0
                    },
                    _normalizeCursorOffset: function(offset) {
                        if ((0, _type.isObject)(offset)) {
                            offset = {
                                h: offset.x,
                                v: offset.y
                            }
                        }
                        offset = (0, _common.splitPair)(offset).map((function(value) {
                            return parseFloat(value)
                        }));
                        return {
                            left: offset[0],
                            top: 1 === offset.length ? offset[0] : offset[1]
                        }
                    },
                    _getNormalizedCursorOffset: function(offset, options) {
                        if ((0, _type.isFunction)(offset)) {
                            offset = offset.call(this, options)
                        }
                        return this._normalizeCursorOffset(offset)
                    },
                    _calculateElementOffset: function(options) {
                        var elementOffset;
                        var dragElementOffset;
                        var event = options.event;
                        var $element = (0, _renderer.default)(options.itemElement);
                        var $dragElement = (0, _renderer.default)(options.dragElement);
                        var isCloned = this._dragElementIsCloned();
                        var cursorOffset = this.option("cursorOffset");
                        var normalizedCursorOffset = {
                            left: 0,
                            top: 0
                        };
                        var currentLocate = this._initialLocate = (0, _translator.locate)($dragElement);
                        if (isCloned || options.initialOffset || cursorOffset) {
                            elementOffset = options.initialOffset || $element.offset();
                            if (cursorOffset) {
                                normalizedCursorOffset = this._getNormalizedCursorOffset(cursorOffset, options);
                                if (isFinite(normalizedCursorOffset.left)) {
                                    elementOffset.left = event.pageX
                                }
                                if (isFinite(normalizedCursorOffset.top)) {
                                    elementOffset.top = event.pageY
                                }
                            }
                            dragElementOffset = $dragElement.offset();
                            elementOffset.top -= dragElementOffset.top + (normalizedCursorOffset.top || 0) - currentLocate.top;
                            elementOffset.left -= dragElementOffset.left + (normalizedCursorOffset.left || 0) - currentLocate.left
                        }
                        return elementOffset
                    },
                    _initPosition: function(options) {
                        var $dragElement = (0, _renderer.default)(options.dragElement);
                        var elementOffset = this._calculateElementOffset(options);
                        if (elementOffset) {
                            this._move(elementOffset, $dragElement)
                        }
                        this._startPosition = (0, _translator.locate)($dragElement)
                    },
                    _startAnimator: function() {
                        if (!this._scrollAnimator.inProgress()) {
                            this._scrollAnimator.start()
                        }
                    },
                    _stopAnimator: function() {
                        this._scrollAnimator.stop()
                    },
                    _addWidgetPrefix: function(className) {
                        var componentName = this.NAME;
                        return (0, _inflector.dasherize)(componentName) + (className ? "-".concat(className) : "")
                    },
                    _getItemsSelector: function() {
                        return this.option("filter") || ""
                    },
                    _$content: function() {
                        var $element = this.$element();
                        var $wrapper = $element.children(".dx-template-wrapper");
                        return $wrapper.length ? $wrapper : $element
                    },
                    _attachEventHandlers: function() {
                        var _this2 = this;
                        if (this.option("disabled")) {
                            return
                        }
                        var $element = this._$content();
                        var itemsSelector = this._getItemsSelector();
                        var allowMoveByClick = this.option("allowMoveByClick");
                        var data = {
                            direction: this.option("dragDirection"),
                            immediate: this.option("immediate"),
                            checkDropTarget: function($target, event) {
                                var targetGroup = _this2.option("group");
                                var sourceGroup = _this2._getSourceDraggable().option("group");
                                var $scrollable = _this2._getScrollable($target);
                                if (_this2._verticalScrollHelper.isOutsideScrollable($scrollable, event) || _this2._horizontalScrollHelper.isOutsideScrollable($scrollable, event)) {
                                    return false
                                }
                                return sourceGroup && sourceGroup === targetGroup
                            }
                        };
                        if (allowMoveByClick) {
                            $element = this._getArea();
                            _events_engine.default.on($element, POINTERDOWN_EVENT_NAME, data, this._pointerDownHandler.bind(this))
                        }
                        if (">" === itemsSelector[0]) {
                            itemsSelector = itemsSelector.slice(1)
                        }
                        _events_engine.default.on($element, DRAGSTART_EVENT_NAME, itemsSelector, data, this._dragStartHandler.bind(this));
                        _events_engine.default.on($element, DRAG_EVENT_NAME, data, this._dragMoveHandler.bind(this));
                        _events_engine.default.on($element, DRAGEND_EVENT_NAME, data, this._dragEndHandler.bind(this));
                        _events_engine.default.on($element, DRAG_ENTER_EVENT_NAME, data, this._dragEnterHandler.bind(this));
                        _events_engine.default.on($element, DRAGEND_LEAVE_EVENT_NAME, data, this._dragLeaveHandler.bind(this));
                        if (this.option("onCancelByEsc")) {
                            _events_engine.default.on($element, KEYDOWN_EVENT_NAME, this._keydownHandler.bind(this))
                        }
                    },
                    _dragElementIsCloned: function() {
                        return this._$dragElement && this._$dragElement.hasClass(this._addWidgetPrefix("clone"))
                    },
                    _getDragTemplateArgs: function($element, $container) {
                        return {
                            container: (0, _element.getPublicElement)($container),
                            model: {
                                itemData: this.option("itemData"),
                                itemElement: (0, _element.getPublicElement)($element)
                            }
                        }
                    },
                    _createDragElement: function($element) {
                        var result = $element;
                        var clone = this.option("clone");
                        var $container = this._getContainer();
                        var template = this.option("dragTemplate");
                        if (template) {
                            template = this._getTemplate(template);
                            result = (0, _renderer.default)("<div>").appendTo($container);
                            template.render(this._getDragTemplateArgs($element, result))
                        } else if (clone) {
                            result = (0, _renderer.default)("<div>").appendTo($container);
                            $element.clone().css({
                                width: $element.css("width"),
                                height: $element.css("height")
                            }).appendTo(result)
                        }
                        return result.toggleClass(this._addWidgetPrefix("clone"), result.get(0) !== $element.get(0)).toggleClass("dx-rtl", this.option("rtlEnabled"))
                    },
                    _resetDragElement: function() {
                        if (this._dragElementIsCloned()) {
                            this._$dragElement.remove()
                        } else {
                            this._toggleDraggingClass(false)
                        }
                        this._$dragElement = null
                    },
                    _resetSourceElement: function() {
                        this._toggleDragSourceClass(false);
                        this._$sourceElement = null
                    },
                    _detachEventHandlers: function() {
                        _events_engine.default.off(this._$content(), ".".concat(DRAGGABLE));
                        _events_engine.default.off(this._getArea(), ".".concat(DRAGGABLE))
                    },
                    _move: function(position, $element) {
                        (0, _translator.move)($element || this._$dragElement, position)
                    },
                    _getDraggableElement: function(e) {
                        var $sourceElement = this._getSourceElement();
                        if ($sourceElement) {
                            return $sourceElement
                        }
                        var allowMoveByClick = this.option("allowMoveByClick");
                        if (allowMoveByClick) {
                            return this.$element()
                        }
                        var $target = (0, _renderer.default)(e && e.target);
                        var itemsSelector = this._getItemsSelector();
                        if (">" === itemsSelector[0]) {
                            var $items = this._$content().find(itemsSelector);
                            if (!$items.is($target)) {
                                $target = $target.closest($items)
                            }
                        }
                        return $target
                    },
                    _getSourceElement: function() {
                        var draggable = this._getSourceDraggable();
                        return draggable._$sourceElement
                    },
                    _pointerDownHandler: function(e) {
                        if ((0, _index.needSkipEvent)(e)) {
                            return
                        }
                        var position = {};
                        var $element = this.$element();
                        var dragDirection = this.option("dragDirection");
                        if ("horizontal" === dragDirection || "both" === dragDirection) {
                            position.left = e.pageX - $element.offset().left + (0, _translator.locate)($element).left - (0, _size.getWidth)($element) / 2
                        }
                        if ("vertical" === dragDirection || "both" === dragDirection) {
                            position.top = e.pageY - $element.offset().top + (0, _translator.locate)($element).top - (0, _size.getHeight)($element) / 2
                        }
                        this._move(position, $element);
                        this._getAction("onDragMove")(this._getEventArgs(e))
                    },
                    _isValidElement: function(event, $element) {
                        var handle = this.option("handle");
                        var $target = (0, _renderer.default)(event.originalEvent && event.originalEvent.target);
                        if (handle && !$target.closest(handle).length) {
                            return false
                        }
                        if (!$element.length) {
                            return false
                        }
                        return !$element.is(".dx-state-disabled, .dx-state-disabled *")
                    },
                    _dragStartHandler: function(e) {
                        var $element = this._getDraggableElement(e);
                        this.dragInProgress = true;
                        if (!this._isValidElement(e, $element)) {
                            e.cancel = true;
                            return
                        }
                        if (this._$sourceElement) {
                            return
                        }
                        var dragStartArgs = this._getDragStartArgs(e, $element);
                        this._getAction("onDragStart")(dragStartArgs);
                        if (dragStartArgs.cancel) {
                            e.cancel = true;
                            return
                        }
                        this.option("itemData", dragStartArgs.itemData);
                        this._setSourceDraggable();
                        this._$sourceElement = $element;
                        var initialOffset = $element.offset();
                        if (!this._hasClonedDraggable() && this.option("autoScroll")) {
                            this._initScrollTop = this._getScrollableScrollTop();
                            this._initScrollLeft = this._getScrollableScrollLeft();
                            initialOffset = this._getDraggableElementOffset(initialOffset.left, initialOffset.top)
                        }
                        var $dragElement = this._$dragElement = this._createDragElement($element);
                        this._toggleDraggingClass(true);
                        this._toggleDragSourceClass(true);
                        this._setGestureCoverCursor($dragElement.children());
                        var isFixedPosition = "fixed" === $dragElement.css("position");
                        this._initPosition((0, _extend.extend)({}, dragStartArgs, {
                            dragElement: $dragElement.get(0),
                            initialOffset: isFixedPosition && initialOffset
                        }));
                        this._getAction("onDraggableElementShown")(_extends(_extends({}, dragStartArgs), {
                            dragElement: $dragElement
                        }));
                        var $area = this._getArea();
                        var areaOffset = this._getAreaOffset($area);
                        var boundOffset = this._getBoundOffset();
                        var areaWidth = (0, _size.getOuterWidth)($area);
                        var areaHeight = (0, _size.getOuterHeight)($area);
                        var elementWidth = (0, _size.getWidth)($dragElement);
                        var elementHeight = (0, _size.getHeight)($dragElement);
                        var startOffset_left = $dragElement.offset().left - areaOffset.left,
                            startOffset_top = $dragElement.offset().top - areaOffset.top;
                        if ($area.length) {
                            e.maxLeftOffset = startOffset_left - boundOffset.left;
                            e.maxRightOffset = areaWidth - startOffset_left - elementWidth - boundOffset.right;
                            e.maxTopOffset = startOffset_top - boundOffset.top;
                            e.maxBottomOffset = areaHeight - startOffset_top - elementHeight - boundOffset.bottom
                        }
                        if (this.option("autoScroll")) {
                            this._startAnimator()
                        }
                    },
                    _getAreaOffset: function($area) {
                        var offset = $area && _position.default.offset($area);
                        return offset || {
                            left: 0,
                            top: 0
                        }
                    },
                    _toggleDraggingClass: function(value) {
                        this._$dragElement && this._$dragElement.toggleClass(this._addWidgetPrefix("dragging"), value)
                    },
                    _toggleDragSourceClass: function(value, $element) {
                        var $sourceElement = $element || this._$sourceElement;
                        $sourceElement && $sourceElement.toggleClass(this._addWidgetPrefix("source"), value)
                    },
                    _setGestureCoverCursor: function($element) {
                        (0, _renderer.default)(".".concat("dx-gesture-cover")).css("cursor", $element.css("cursor"))
                    },
                    _getBoundOffset: function() {
                        var boundOffset = this.option("boundOffset");
                        if ((0, _type.isFunction)(boundOffset)) {
                            boundOffset = boundOffset.call(this)
                        }
                        return (0, _string.quadToObject)(boundOffset)
                    },
                    _getArea: function() {
                        var area = this.option("boundary");
                        if ((0, _type.isFunction)(area)) {
                            area = area.call(this)
                        }
                        return (0, _renderer.default)(area)
                    },
                    _getContainer: function() {
                        var container = this.option("container");
                        if (void 0 === container) {
                            container = (0, _view_port.value)()
                        }
                        return (0, _renderer.default)(container)
                    },
                    _getDraggableElementOffset: function(initialOffsetX, initialOffsetY) {
                        var _a, _b, _c, _d;
                        var initScrollTop = this._initScrollTop;
                        var initScrollLeft = this._initScrollLeft;
                        var scrollTop = this._getScrollableScrollTop();
                        var scrollLeft = this._getScrollableScrollLeft();
                        var elementPosition = (0, _renderer.default)(this.element()).css("position");
                        var isFixedPosition = "fixed" === elementPosition;
                        var result = {
                            left: (null !== (_b = null === (_a = this._startPosition) || void 0 === _a ? void 0 : _a.left) && void 0 !== _b ? _b : 0) + initialOffsetX,
                            top: (null !== (_d = null === (_c = this._startPosition) || void 0 === _c ? void 0 : _c.top) && void 0 !== _d ? _d : 0) + initialOffsetY
                        };
                        if (isFixedPosition || this._hasClonedDraggable()) {
                            return result
                        }
                        return {
                            left: (0, _type.isNumeric)(scrollLeft) ? result.left + scrollLeft - initScrollLeft : result.left,
                            top: (0, _type.isNumeric)(scrollTop) ? result.top + scrollTop - initScrollTop : result.top
                        }
                    },
                    _hasClonedDraggable: function() {
                        return this.option("clone") || this.option("dragTemplate")
                    },
                    _dragMoveHandler: function(e) {
                        this._dragMoveArgs = e;
                        if (!this._$dragElement) {
                            e.cancel = true;
                            return
                        }
                        var offset = this._getDraggableElementOffset(e.offset.x, e.offset.y);
                        this._move(offset);
                        this._updateScrollable(e);
                        var eventArgs = this._getEventArgs(e);
                        this._getAction("onDragMove")(eventArgs);
                        if (true === eventArgs.cancel) {
                            return
                        }
                        var targetDraggable = this._getTargetDraggable();
                        targetDraggable.dragMove(e, scrollBy)
                    },
                    _updateScrollable: function(e) {
                        if (this.option("autoScroll")) {
                            var mousePosition = getMousePosition(e);
                            var allObjects = _dom_adapter.default.elementsFromPoint(mousePosition.x, mousePosition.y, this.$element().get(0));
                            this._verticalScrollHelper.updateScrollable(allObjects, mousePosition);
                            this._horizontalScrollHelper.updateScrollable(allObjects, mousePosition)
                        }
                    },
                    _getScrollable: function($element) {
                        var _this3 = this;
                        var $scrollable;
                        $element.parents().toArray().some((function(parent) {
                            var $parent = (0, _renderer.default)(parent);
                            if (_this3._horizontalScrollHelper.isScrollable($parent) || _this3._verticalScrollHelper.isScrollable($parent)) {
                                $scrollable = $parent;
                                return true
                            }
                            return false
                        }));
                        return $scrollable
                    },
                    _getScrollableScrollTop: function() {
                        var _a, _b;
                        return null !== (_b = null === (_a = this._getScrollable((0, _renderer.default)(this.element()))) || void 0 === _a ? void 0 : _a.scrollTop()) && void 0 !== _b ? _b : 0
                    },
                    _getScrollableScrollLeft: function() {
                        var _a, _b;
                        return null !== (_b = null === (_a = this._getScrollable((0, _renderer.default)(this.element()))) || void 0 === _a ? void 0 : _a.scrollLeft()) && void 0 !== _b ? _b : 0
                    },
                    _defaultActionArgs: function() {
                        var args = this.callBase.apply(this, arguments);
                        var component = this.option("component");
                        if (component) {
                            args.component = component;
                            args.element = component.element()
                        }
                        return args
                    },
                    _getEventArgs: function(e) {
                        var sourceDraggable = this._getSourceDraggable();
                        var targetDraggable = this._getTargetDraggable();
                        return {
                            event: e,
                            itemData: sourceDraggable.option("itemData"),
                            itemElement: (0, _element.getPublicElement)(sourceDraggable._$sourceElement),
                            fromComponent: sourceDraggable.option("component") || sourceDraggable,
                            toComponent: targetDraggable.option("component") || targetDraggable,
                            fromData: sourceDraggable.option("data"),
                            toData: targetDraggable.option("data")
                        }
                    },
                    _getDragStartArgs: function(e, $itemElement) {
                        var args = this._getEventArgs(e);
                        return {
                            event: args.event,
                            itemData: args.itemData,
                            itemElement: $itemElement,
                            fromData: args.fromData
                        }
                    },
                    _revertItemToInitialPosition: function() {
                        !this._dragElementIsCloned() && this._move(this._initialLocate, this._$sourceElement)
                    },
                    _dragEndHandler: function(e) {
                        var _this4 = this;
                        var d = (0, _deferred.Deferred)();
                        var dragEndEventArgs = this._getEventArgs(e);
                        var dropEventArgs = this._getEventArgs(e);
                        var targetDraggable = this._getTargetDraggable();
                        var needRevertPosition = true;
                        this.dragInProgress = false;
                        try {
                            this._getAction("onDragEnd")(dragEndEventArgs)
                        } finally {
                            (0, _deferred.when)((0, _deferred.fromPromise)(dragEndEventArgs.cancel)).done((function(cancel) {
                                if (!cancel) {
                                    if (targetDraggable !== _this4) {
                                        targetDraggable._getAction("onDrop")(dropEventArgs)
                                    }
                                    if (!dropEventArgs.cancel) {
                                        needRevertPosition = false;
                                        (0, _deferred.when)((0, _deferred.fromPromise)(targetDraggable.dragEnd(dragEndEventArgs))).always(d.resolve);
                                        return
                                    }
                                }
                                d.resolve()
                            })).fail(d.resolve);
                            d.done((function() {
                                if (needRevertPosition) {
                                    _this4._revertItemToInitialPosition()
                                }
                                _this4._resetDragOptions(targetDraggable)
                            }))
                        }
                    },
                    _isTargetOverAnotherDraggable: function(e) {
                        var _this5 = this;
                        var sourceDraggable = this._getSourceDraggable();
                        if (this === sourceDraggable) {
                            return false
                        }
                        var $dragElement = sourceDraggable._$dragElement;
                        var $sourceDraggableElement = sourceDraggable.$element();
                        var $targetDraggableElement = this.$element();
                        var mousePosition = getMousePosition(e);
                        var elements = _dom_adapter.default.elementsFromPoint(mousePosition.x, mousePosition.y, this.element());
                        var firstWidgetElement = elements.filter((function(element) {
                            var $element = (0, _renderer.default)(element);
                            if ($element.hasClass(_this5._addWidgetPrefix())) {
                                return !$element.closest($dragElement).length
                            }
                            return false
                        }))[0];
                        var $sourceElement = this._getSourceElement();
                        var isTargetOverItself = firstWidgetElement === $sourceDraggableElement.get(0);
                        var isTargetOverNestedDraggable = (0, _renderer.default)(firstWidgetElement).closest($sourceElement).length;
                        return !firstWidgetElement || firstWidgetElement === $targetDraggableElement.get(0) && !isTargetOverItself && !isTargetOverNestedDraggable
                    },
                    _dragEnterHandler: function(e) {
                        this._fireDragEnterEvent(e);
                        if (this._isTargetOverAnotherDraggable(e)) {
                            this._setTargetDraggable()
                        }
                        var sourceDraggable = this._getSourceDraggable();
                        sourceDraggable.dragEnter(e)
                    },
                    _dragLeaveHandler: function(e) {
                        this._fireDragLeaveEvent(e);
                        this._resetTargetDraggable();
                        if (this !== this._getSourceDraggable()) {
                            this.reset()
                        }
                        var sourceDraggable = this._getSourceDraggable();
                        sourceDraggable.dragLeave(e)
                    },
                    _keydownHandler: function(e) {
                        if (this.dragInProgress && "Escape" === e.key) {
                            this._keydownEscapeHandler(e)
                        }
                    },
                    _keydownEscapeHandler: function(e) {
                        var $sourceElement = this._getSourceElement();
                        if (!$sourceElement) {
                            return
                        }
                        var dragCancelEventArgs = this._getEventArgs(e);
                        this._getAction("onDragCancel")(dragCancelEventArgs);
                        if (dragCancelEventArgs.cancel) {
                            return
                        }
                        this.dragInProgress = false;
                        null === sourceDraggable || void 0 === sourceDraggable ? void 0 : sourceDraggable._toggleDraggingClass(false);
                        this._detachEventHandlers();
                        this._revertItemToInitialPosition();
                        var targetDraggable = this._getTargetDraggable();
                        this._resetDragOptions(targetDraggable);
                        this._attachEventHandlers()
                    },
                    _getAction: function(name) {
                        return this["_".concat(name, "Action")] || this._createActionByOption(name)
                    },
                    _getAnonymousTemplateName: function() {
                        return "content"
                    },
                    _initTemplates: function() {
                        if (!this.option("contentTemplate")) {
                            return
                        }
                        this._templateManager.addDefaultTemplates({
                            content: new _empty_template.EmptyTemplate
                        });
                        this.callBase.apply(this, arguments)
                    },
                    _render: function() {
                        this.callBase();
                        this.$element().addClass(this._addWidgetPrefix());
                        var transclude = this._templateManager.anonymousTemplateName === this.option("contentTemplate");
                        var template = this._getTemplateByOption("contentTemplate");
                        if (template) {
                            (0, _renderer.default)(template.render({
                                container: this.element(),
                                transclude: transclude
                            }))
                        }
                    },
                    _optionChanged: function(args) {
                        var name = args.name;
                        switch (name) {
                            case "onDragStart":
                            case "onDragMove":
                            case "onDragEnd":
                            case "onDrop":
                            case "onDragEnter":
                            case "onDragLeave":
                            case "onDragCancel":
                            case "onDraggableElementShown":
                                this["_".concat(name, "Action")] = this._createActionByOption(name);
                                break;
                            case "dragTemplate":
                            case "contentTemplate":
                            case "container":
                            case "clone":
                                break;
                            case "allowMoveByClick":
                            case "dragDirection":
                            case "disabled":
                            case "boundary":
                            case "filter":
                            case "immediate":
                                this._resetDragElement();
                                this._detachEventHandlers();
                                this._attachEventHandlers();
                                break;
                            case "onCancelByEsc":
                                this._keydownHandler();
                                break;
                            case "autoScroll":
                                this._verticalScrollHelper.reset();
                                this._horizontalScrollHelper.reset();
                                break;
                            case "scrollSensitivity":
                            case "scrollSpeed":
                            case "boundOffset":
                            case "handle":
                            case "group":
                            case "data":
                            case "itemData":
                                break;
                            default:
                                this.callBase(args)
                        }
                    },
                    _getTargetDraggable: function() {
                        return targetDraggable || this
                    },
                    _getSourceDraggable: function() {
                        return sourceDraggable || this
                    },
                    _setTargetDraggable: function() {
                        var currentGroup = this.option("group");
                        var sourceDraggable = this._getSourceDraggable();
                        if (currentGroup && currentGroup === sourceDraggable.option("group")) {
                            targetDraggable = this
                        }
                    },
                    _setSourceDraggable: function() {
                        sourceDraggable = this
                    },
                    _resetSourceDraggable: function() {
                        sourceDraggable = null
                    },
                    _resetTargetDraggable: function() {
                        targetDraggable = null
                    },
                    _resetDragOptions: function(targetDraggable) {
                        this.reset();
                        targetDraggable.reset();
                        this._stopAnimator();
                        this._horizontalScrollHelper.reset();
                        this._verticalScrollHelper.reset();
                        this._resetDragElement();
                        this._resetSourceElement();
                        this._resetTargetDraggable();
                        this._resetSourceDraggable()
                    },
                    _dispose: function() {
                        this.callBase();
                        this._detachEventHandlers();
                        this._resetDragElement();
                        this._resetTargetDraggable();
                        this._resetSourceDraggable();
                        this._$sourceElement = null;
                        this._stopAnimator()
                    },
                    _fireDragEnterEvent: function(sourceEvent) {
                        var args = this._getEventArgs(sourceEvent);
                        this._getAction("onDragEnter")(args)
                    },
                    _fireDragLeaveEvent: function(sourceEvent) {
                        var args = this._getEventArgs(sourceEvent);
                        this._getAction("onDragLeave")(args)
                    }
                });
                (0, _component_registrator.default)(DRAGGABLE, Draggable);
                var _default = Draggable;
                exports.default = _default
            },
        90006:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/m_date_adapter.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _date = (obj = __webpack_require__( /*! ../../core/utils/date */ 91198), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) {
                            descriptor.writable = true
                        }
                        Object.defineProperty(target, (arg = descriptor.key, key = void 0, key = function(input, hint) {
                            if ("object" !== _typeof(input) || null === input) {
                                return input
                            }
                            var prim = input[Symbol.toPrimitive];
                            if (void 0 !== prim) {
                                var res = prim.call(input, hint || "default");
                                if ("object" !== _typeof(res)) {
                                    return res
                                }
                                throw new TypeError("@@toPrimitive must return a primitive value.")
                            }
                            return ("string" === hint ? String : Number)(input)
                        }(arg, "string"), "symbol" === _typeof(key) ? key : String(key)), descriptor)
                    }
                    var arg, key
                }
                var toMs = _date.default.dateToMilliseconds;
                var DateAdapterCore = function() {
                    function DateAdapterCore(source) {
                        this._source = new Date(source.getTime ? source.getTime() : source)
                    }
                    var _proto = DateAdapterCore.prototype;
                    _proto.result = function() {
                        return this._source
                    };
                    _proto.getTimezoneOffset = function() {
                        var format = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : void 0;
                        var value = this._source.getTimezoneOffset();
                        if ("minute" === format) {
                            return value * toMs("minute")
                        }
                        return value
                    };
                    _proto.getTime = function() {
                        return this._source.getTime()
                    };
                    _proto.setTime = function(value) {
                        this._source.setTime(value);
                        return this
                    };
                    _proto.addTime = function(value) {
                        this._source.setTime(this._source.getTime() + value);
                        return this
                    };
                    _proto.setMinutes = function(value) {
                        this._source.setMinutes(value);
                        return this
                    };
                    _proto.addMinutes = function(value) {
                        this._source.setMinutes(this._source.getMinutes() + value);
                        return this
                    };
                    _proto.subtractMinutes = function(value) {
                        this._source.setMinutes(this._source.getMinutes() - value);
                        return this
                    };
                    ! function(Constructor, protoProps, staticProps) {
                        if (protoProps) {
                            _defineProperties(Constructor.prototype, protoProps)
                        }
                        if (staticProps) {
                            _defineProperties(Constructor, staticProps)
                        }
                        Object.defineProperty(Constructor, "prototype", {
                            writable: false
                        });
                        return Constructor
                    }(DateAdapterCore, [{
                        key: "source",
                        get: function() {
                            return this._source
                        }
                    }]);
                    return DateAdapterCore
                }();
                var _default = function(date) {
                    return new DateAdapterCore(date)
                };
                exports.default = _default
            },
        57880:
            /*!***************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/m_utils_time_zone.js ***!
              \***************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _date = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/date */ 91198));
                var _m_date_adapter = _interopRequireDefault(__webpack_require__( /*! ./m_date_adapter */ 90006));
                var _m_utils_timezones_data = _interopRequireDefault(__webpack_require__( /*! ./timezones/m_utils_timezones_data */ 23778));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _slicedToArray(arr, i) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return arr
                        }
                    }(arr) || function(arr, i) {
                        var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
                        if (null != _i) {
                            var _s, _e, _x, _r, _arr = [],
                                _n = !0,
                                _d = !1;
                            try {
                                if (_x = (_i = _i.call(arr)).next, 0 === i) {
                                    if (Object(_i) !== _i) {
                                        return
                                    }
                                    _n = !1
                                } else {
                                    for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0) {}
                                }
                            } catch (err) {
                                _d = !0, _e = err
                            } finally {
                                try {
                                    if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) {
                                        return
                                    }
                                } finally {
                                    if (_d) {
                                        throw _e
                                    }
                                }
                            }
                            return _arr
                        }
                    }(arr, i) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr, i) || function() {
                        throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var toMs = _date.default.dateToMilliseconds;
                var createUTCDate = function(date) {
                    return new Date(Date.UTC(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes()))
                };
                var getTimezoneOffsetChangeInMinutes = function(startDate, endDate, updatedStartDate, updatedEndDate) {
                    return getDaylightOffset(updatedStartDate, updatedEndDate) - getDaylightOffset(startDate, endDate)
                };
                var getDaylightOffset = function(startDate, endDate) {
                    return new Date(startDate).getTimezoneOffset() - new Date(endDate).getTimezoneOffset()
                };
                var calculateTimezoneByValue = function(timezone) {
                    var date = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : new Date;
                    if ("string" === typeof timezone) {
                        var dateUtc = createUTCDate(date);
                        return _m_utils_timezones_data.default.getTimeZoneOffsetById(timezone, dateUtc.getTime())
                    }
                    return timezone
                };
                var _getDaylightOffsetByTimezone = function(startDate, endDate, timeZone) {
                    return calculateTimezoneByValue(timeZone, startDate) - calculateTimezoneByValue(timeZone, endDate)
                };
                var isTimezoneChangeInDate = function(date) {
                    var startDayDate = new Date(new Date(date).setHours(0, 0, 0, 0));
                    var endDayDate = new Date(new Date(date).setHours(23, 59, 59, 0));
                    return startDayDate.getTimezoneOffset() - endDayDate.getTimezoneOffset() !== 0
                };
                var getClientTimezoneOffset = function() {
                    var date = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : new Date;
                    return 6e4 * date.getTimezoneOffset()
                };
                var hasDSTInLocalTimeZone = function() {
                    var _getExtremeDates = getExtremeDates(),
                        _getExtremeDates2 = _slicedToArray(_getExtremeDates, 2),
                        startDate = _getExtremeDates2[0],
                        endDate = _getExtremeDates2[1];
                    return startDate.getTimezoneOffset() !== endDate.getTimezoneOffset()
                };
                var isEqualLocalTimeZoneByDeclaration = function(timeZoneName, date) {
                    var year = date.getFullYear();
                    var getOffset = function(date) {
                        return -date.getTimezoneOffset() / 60
                    };
                    var getDateAndMoveHourBack = function(dateStamp) {
                        return new Date(dateStamp - 36e5)
                    };
                    var configTuple = _m_utils_timezones_data.default.getTimeZoneDeclarationTuple(timeZoneName, year);
                    var _configTuple = _slicedToArray(configTuple, 2),
                        summerTime = _configTuple[0],
                        winterTime = _configTuple[1];
                    var noDSTInTargetTimeZone = configTuple.length < 2;
                    if (noDSTInTargetTimeZone) {
                        var targetTimeZoneOffset = _m_utils_timezones_data.default.getTimeZoneOffsetById(timeZoneName, date);
                        var localTimeZoneOffset = getOffset(date);
                        if (targetTimeZoneOffset !== localTimeZoneOffset) {
                            return false
                        }
                        return !hasDSTInLocalTimeZone()
                    }
                    var localSummerOffset = getOffset(new Date(summerTime.date));
                    var localWinterOffset = getOffset(new Date(winterTime.date));
                    if (localSummerOffset !== summerTime.offset) {
                        return false
                    }
                    if (localSummerOffset === getOffset(getDateAndMoveHourBack(summerTime.date))) {
                        return false
                    }
                    if (localWinterOffset !== winterTime.offset) {
                        return false
                    }
                    if (localWinterOffset === getOffset(getDateAndMoveHourBack(winterTime.date))) {
                        return false
                    }
                    return true
                };
                var getExtremeDates = function() {
                    var nowDate = new Date(Date.now());
                    var startDate = new Date;
                    var endDate = new Date;
                    startDate.setFullYear(nowDate.getFullYear(), 0, 1);
                    endDate.setFullYear(nowDate.getFullYear(), 6, 1);
                    return [startDate, endDate]
                };
                var utils = {
                    getDaylightOffset: getDaylightOffset,
                    getDaylightOffsetInMs: function(startDate, endDate) {
                        return getDaylightOffset(startDate, endDate) * toMs("minute")
                    },
                    getTimezoneOffsetChangeInMinutes: getTimezoneOffsetChangeInMinutes,
                    getTimezoneOffsetChangeInMs: function(startDate, endDate, updatedStartDate, updatedEndDate) {
                        return getTimezoneOffsetChangeInMinutes(startDate, endDate, updatedStartDate, updatedEndDate) * toMs("minute")
                    },
                    calculateTimezoneByValue: calculateTimezoneByValue,
                    getCorrectedDateByDaylightOffsets: function(convertedOriginalStartDate, convertedDate, date, timeZone, startDateTimezone) {
                        var daylightOffsetByCommonTimezone = _getDaylightOffsetByTimezone(convertedOriginalStartDate, convertedDate, timeZone);
                        var daylightOffsetByAppointmentTimezone = _getDaylightOffsetByTimezone(convertedOriginalStartDate, convertedDate, startDateTimezone);
                        var diff = daylightOffsetByCommonTimezone - daylightOffsetByAppointmentTimezone;
                        return new Date(date.getTime() - diff * toMs("hour"))
                    },
                    isSameAppointmentDates: function(startDate, endDate) {
                        endDate = new Date(endDate.getTime() - 1);
                        return _date.default.sameDate(startDate, endDate)
                    },
                    correctRecurrenceExceptionByTimezone: function(exception, exceptionByStartDate, timeZone, startDateTimeZone) {
                        var isBackConversion = arguments.length > 4 && void 0 !== arguments[4] ? arguments[4] : false;
                        var timezoneOffset = (exception.getTimezoneOffset() - exceptionByStartDate.getTimezoneOffset()) / 60;
                        if (startDateTimeZone) {
                            timezoneOffset = _getDaylightOffsetByTimezone(exceptionByStartDate, exception, startDateTimeZone)
                        } else if (timeZone) {
                            timezoneOffset = _getDaylightOffsetByTimezone(exceptionByStartDate, exception, timeZone)
                        }
                        return new Date(exception.getTime() + (isBackConversion ? -1 : 1) * timezoneOffset * toMs("hour"))
                    },
                    getClientTimezoneOffset: getClientTimezoneOffset,
                    getDiffBetweenClientTimezoneOffsets: function() {
                        var firstDate = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : new Date;
                        var secondDate = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : new Date;
                        return getClientTimezoneOffset(firstDate) - getClientTimezoneOffset(secondDate)
                    },
                    createUTCDateWithLocalOffset: function(date) {
                        if (!date) {
                            return null
                        }
                        return new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()))
                    },
                    createDateFromUTCWithLocalOffset: function(date) {
                        var result = (0, _m_date_adapter.default)(date);
                        var timezoneOffsetBeforeInMin = result.getTimezoneOffset();
                        result.addTime(result.getTimezoneOffset("minute"));
                        result.subtractMinutes(timezoneOffsetBeforeInMin - result.getTimezoneOffset());
                        return result.source
                    },
                    createUTCDate: createUTCDate,
                    isTimezoneChangeInDate: isTimezoneChangeInDate,
                    getDateWithoutTimezoneChange: function(date) {
                        var clonedDate = new Date(date);
                        if (isTimezoneChangeInDate(clonedDate)) {
                            var result = new Date(clonedDate);
                            return new Date(result.setDate(result.getDate() + 1))
                        }
                        return clonedDate
                    },
                    hasDSTInLocalTimeZone: hasDSTInLocalTimeZone,
                    isEqualLocalTimeZone: function(timeZoneName) {
                        var date = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : new Date;
                        if (Intl) {
                            var localTimeZoneName = Intl.DateTimeFormat().resolvedOptions().timeZone;
                            if (localTimeZoneName === timeZoneName) {
                                return true
                            }
                        }
                        return isEqualLocalTimeZoneByDeclaration(timeZoneName, date)
                    },
                    isEqualLocalTimeZoneByDeclaration: isEqualLocalTimeZoneByDeclaration,
                    getTimeZones: function() {
                        var date = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : new Date;
                        var dateInUTC = createUTCDate(date);
                        return _m_utils_timezones_data.default.getDisplayedTimeZones(dateInUTC.getTime())
                    },
                    setOffsetsToDate: function(targetDate, offsetsArray) {
                        var newDateMs = offsetsArray.reduce((function(result, offset) {
                            return result + offset
                        }), targetDate.getTime());
                        return new Date(newDateMs)
                    }
                };
                var _default = utils;
                exports.default = _default
            },
        23778:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/timezones/m_utils_timezones_data.js ***!
              \******************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 17381));
                var _math = __webpack_require__( /*! ../../../core/utils/math */ 60810);
                var _query = _interopRequireDefault(__webpack_require__( /*! ../../../data/query */ 96687));
                var _timezones_data = _interopRequireDefault(__webpack_require__( /*! ./timezones_data */ 28882));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var parseTimezone = function(timeZoneConfig) {
                    var offsets = timeZoneConfig.offsets;
                    var offsetIndices = timeZoneConfig.offsetIndices;
                    var untils = timeZoneConfig.untils;
                    var offsetList = offsets.split("|").map((function(value) {
                        return parseInt(value)
                    }));
                    var offsetIndexList = offsetIndices.split("").map((function(value) {
                        return parseInt(value)
                    }));
                    var dateList = (value = untils, value.split("|").map((function(until) {
                        if ("Infinity" === until) {
                            return null
                        }
                        return 1e3 * parseInt(until, 36)
                    }))).map((accumulator = 0, function(value) {
                        return accumulator += value
                    }));
                    var accumulator;
                    var value;
                    return {
                        offsetList: offsetList,
                        offsetIndexList: offsetIndexList,
                        dateList: dateList
                    }
                };
                var TimeZoneCache = function() {
                    function TimeZoneCache() {
                        this.map = new Map
                    }
                    var _proto = TimeZoneCache.prototype;
                    _proto.tryGet = function(id) {
                        if (!this.map.get(id)) {
                            var config = timeZoneDataUtils.getTimezoneById(id);
                            if (!config) {
                                return false
                            }
                            var timeZoneInfo = parseTimezone(config);
                            this.map.set(id, timeZoneInfo)
                        }
                        return this.map.get(id)
                    };
                    return TimeZoneCache
                }();
                var tzCache = new TimeZoneCache;
                var timeZoneDataUtils = {
                    _tzCache: tzCache,
                    _timeZones: _timezones_data.default.zones,
                    getDisplayedTimeZones: function(timestamp) {
                        var _this = this;
                        var timeZones = this._timeZones.map((function(timezone) {
                            var timeZoneInfo = parseTimezone(timezone);
                            var offset = _this.getUtcOffset(timeZoneInfo, timestamp);
                            var title = "(GMT ".concat(_this.formatOffset(offset), ") ").concat(_this.formatId(timezone.id));
                            return {
                                offset: offset,
                                title: title,
                                id: timezone.id
                            }
                        }));
                        return (0, _query.default)(timeZones).sortBy("offset").toArray()
                    },
                    formatOffset: function(offset) {
                        var hours = Math.floor(offset);
                        var minutesInDecimal = offset - hours;
                        var signString = (0, _math.sign)(offset) >= 0 ? "+" : "-";
                        var hoursString = "0".concat(Math.abs(hours)).slice(-2);
                        var minutesString = minutesInDecimal > 0 ? ":".concat(60 * minutesInDecimal) : ":00";
                        return signString + hoursString + minutesString
                    },
                    formatId: function(id) {
                        return id.split("/").join(" - ").split("_").join(" ")
                    },
                    getTimezoneById: function(id) {
                        if (!id) {
                            return
                        }
                        var tzList = this._timeZones;
                        for (var i = 0; i < tzList.length; i++) {
                            var currentId = tzList[i].id;
                            if (currentId === id) {
                                return tzList[i]
                            }
                        }
                        _errors.default.log("W0009", id);
                        return
                    },
                    getTimeZoneOffsetById: function(id, timestamp) {
                        var timeZoneInfo = tzCache.tryGet(id);
                        return timeZoneInfo ? this.getUtcOffset(timeZoneInfo, timestamp) : void 0
                    },
                    getTimeZoneDeclarationTuple: function(id, year) {
                        var timeZoneInfo = tzCache.tryGet(id);
                        return timeZoneInfo ? this.getTimeZoneDeclarationTupleCore(timeZoneInfo, year) : []
                    },
                    getTimeZoneDeclarationTupleCore: function(timeZoneInfo, year) {
                        var offsetList = timeZoneInfo.offsetList;
                        var offsetIndexList = timeZoneInfo.offsetIndexList;
                        var dateList = timeZoneInfo.dateList;
                        var tupleResult = [];
                        for (var i = 0; i < dateList.length; i++) {
                            var currentDate = dateList[i];
                            var currentYear = new Date(currentDate).getFullYear();
                            if (currentYear === year) {
                                var offset = offsetList[offsetIndexList[i + 1]];
                                tupleResult.push({
                                    date: currentDate,
                                    offset: -offset / 60
                                })
                            }
                            if (currentYear > year) {
                                break
                            }
                        }
                        return tupleResult
                    },
                    getUtcOffset: function(timeZoneInfo, dateTimeStamp) {
                        var offsetList = timeZoneInfo.offsetList;
                        var offsetIndexList = timeZoneInfo.offsetIndexList;
                        var dateList = timeZoneInfo.dateList;
                        var lastIntervalStartIndex = dateList.length - 1 - 1;
                        var index = lastIntervalStartIndex;
                        while (index >= 0 && dateTimeStamp < dateList[index]) {
                            index--
                        }
                        var offset = offsetList[offsetIndexList[index + 1]];
                        return -offset / 60 || offset
                    }
                };
                var _default = timeZoneDataUtils;
                exports.default = _default
            },
        28882:
            /*!**********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/timezones/timezones_data.js ***!
              \**********************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                exports.default = {
                    zones: [{
                        id: "Africa/Abidjan",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Accra",
                        untils: "-r507yk|1e3pak|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|Infinity",
                        offsets: "0.8667|0|-20",
                        offsetIndices: "012121212121212121212121212121212121212121212121"
                    }, {
                        id: "Africa/Addis_Ababa",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Algiers",
                        untils: "-uozn3l|2qx1nl|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|53c00|9idxc0|3i040|51mw0|253uk0|9o2k0|92040|8l3s0|jutc0|4uy840|3rdzw0|46xc00|7x6o0|2xco40|8n180|7x9g0|9d440|kiqg0|9d440|9q2s0|9cyk0|Infinity",
                        offsets: "-9.35|0|-60|-120",
                        offsetIndices: "0121212121212121232321212122321212"
                    }, {
                        id: "Africa/Asmara",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Asmera",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Bamako",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Bangui",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Banjul",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Bissau",
                        untils: "-u9rek0|wvoyo0|Infinity",
                        offsets: "62.3333|60|0",
                        offsetIndices: "012"
                    }, {
                        id: "Africa/Blantyre",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Brazzaville",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Bujumbura",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Cairo",
                        untils: "-fdls80|40d80|a31g0|7x3w0|a4w40|aqyk0|80ys0|b07w0|7tk40|b07w0|8jhg0|a8fw0|60go40|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|f9x80|3i040|eluk0|462s0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|b5rw0|7m5g0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|aqvs0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7k580|b5xg0|6u7w0|bvus0|6h980|c8tg0|64ak0|cyqs0|5anw0|1jms0|12t80|1w22s0|25p80|1sw40|2vmk0|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Africa/Casablanca",
                        untils: "-tblt9g|di7nxg|3huk0|51k40|2znuk0|2dp9g0|776k0|8nt2s0|657w0|3ifxg0|3jp80|va040|4qak0|e1ms0|7pp80|cnms0|3afw0|2xi840|xqqk0|bp56s0|4qak0|e1ms0|45x80|d2g40|51ek0|c8tg0|64ak0|e1sc0|47uo0|1leo0|23xc0|asw00|3lmo0|1qyo0|40g00|7x6o0|4mo00|1stc0|4deo0|7x6o0|3ylc0|1stc0|51hc0|7x6o0|3lmo0|1stc0|5reo0|7k800|2vpc0|25s00|64dc0|7k800|2iqo0|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|25s00|g7c00|1stc0|g7c00|25s00|Infinity",
                        offsets: "30.3333|0|-60",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Africa/Ceuta",
                        untils: "-qyiys0|7x3w0|2vt440|8sqs0|ssyk0|8n6s0|9px80|905g0|a2yo0|902o0|k69dc0|657w0|3ifxg0|3jp80|va040|4qak0|e1ms0|7pp80|cnms0|3afw0|2xi840|129us0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Africa/Conakry",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Dakar",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Dar_es_Salaam",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Djibouti",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Douala",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/El_Aaiun",
                        untils: "-isdxk0|m2g0c0|vek0|4qak0|e1ms0|7pp80|cnms0|3afw0|fke5g0|4qak0|e1ms0|45x80|d2g40|51ek0|c8tg0|64ak0|e1sc0|47uo0|1leo0|23xc0|asw00|3lmo0|1qyo0|40g00|7x6o0|4mo00|1stc0|4deo0|7x6o0|3ylc0|1stc0|51hc0|7x6o0|3lmo0|1stc0|5reo0|7k800|2vpc0|25s00|64dc0|7k800|2iqo0|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|25s00|g7c00|1stc0|g7c00|25s00|Infinity",
                        offsets: "52.8|60|0|-60",
                        offsetIndices: "012323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Africa/Freetown",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Gaborone",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Harare",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Johannesburg",
                        untils: "-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",
                        offsets: "-90|-120|-180",
                        offsetIndices: "012121"
                    }, {
                        id: "Africa/Juba",
                        untils: "-kcrsis|kixuys|8l6k0|a4w40|8n180|a6qs0|8n180|a31g0|8ovw0|a16s0|8qqk0|9zc40|8sl80|9xhg0|8wak0|9ts40|8y580|a4w40|8n180|a31g0|8ovw0|a16s0|8sl80|9xhg0|8ufw0|9vms0|8wak0|9ts40|8y580|a4w40|8ovw0|a16s0|8qqk0|7frw40|Infinity",
                        offsets: "-126.4667|-120|-180",
                        offsetIndices: "01212121212121212121212121212121212"
                    }, {
                        id: "Africa/Kampala",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Khartoum",
                        untils: "-kcrsow|kixv4w|8l6k0|a4w40|8n180|a6qs0|8n180|a31g0|8ovw0|a16s0|8qqk0|9zc40|8sl80|9xhg0|8wak0|9ts40|8y580|a4w40|8n180|a31g0|8ovw0|a16s0|8sl80|9xhg0|8ufw0|9vms0|8wak0|9ts40|8y580|a4w40|8ovw0|a16s0|8qqk0|7frw40|9ac180|Infinity",
                        offsets: "-130.1333|-120|-180",
                        offsetIndices: "012121212121212121212121212121212121"
                    }, {
                        id: "Africa/Kigali",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Kinshasa",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Lagos",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Libreville",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Lome",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Luanda",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Lubumbashi",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Lusaka",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Malabo",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Maputo",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Maseru",
                        untils: "-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",
                        offsets: "-90|-120|-180",
                        offsetIndices: "012121"
                    }, {
                        id: "Africa/Mbabane",
                        untils: "-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",
                        offsets: "-90|-120|-180",
                        offsetIndices: "012121"
                    }, {
                        id: "Africa/Mogadishu",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Monrovia",
                        untils: "-qj6zc4|rl202a|Infinity",
                        offsets: "43.1333|44.5|0",
                        offsetIndices: "012"
                    }, {
                        id: "Africa/Nairobi",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Ndjamena",
                        untils: "-u9rk4c|zdk5cc|7iak0|Infinity",
                        offsets: "-60.2|-60|-120",
                        offsetIndices: "0121"
                    }, {
                        id: "Africa/Niamey",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Nouakchott",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Ouagadougou",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Porto-Novo",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Sao_Tome",
                        untils: "-u9rhc0|1jbm840|irxc0|Infinity",
                        offsets: "36.75|0|-60",
                        offsetIndices: "0121"
                    }, {
                        id: "Africa/Timbuktu",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Tripoli",
                        untils: "-q3gfrw|gl6ajw|422c0|xado0|4bbo0|wrpg0|4s580|1kdpg0|c05bw0|4mqs0|9et80|9d440|9et80|9eys0|9et80|9mdg0|95jw0|9io40|9cyk0|99es0|9et80|9eys0|9et80|9d440|9et80|b2840|3cf3w0|9kis0|9et80|7vqyw0|75eo0|asw00|Infinity",
                        offsets: "-52.7333|-60|-120",
                        offsetIndices: "012121212121212121212121212122122"
                    }, {
                        id: "Africa/Tunis",
                        untils: "-uozn3l|enxevl|b5uo0|53c00|u8w00|7x9g0|c8w80|7k800|z3w0|ew40|8bx80|9d440|9nx00|925o0|8l100|gi3440|7k800|b9k00|7vc00|51mw00|5ytc0|9d1c0|9d1c0|b9k00|7thc0|7m0tc0|7tk40|93us0|b5uo0|7k800|b5uo0|7x6o0|asw00|Infinity",
                        offsets: "-9.35|-60|-120",
                        offsetIndices: "0121212121212121212121212121212121"
                    }, {
                        id: "Africa/Windhoek",
                        untils: "-yvtdi0|kn7o60|9cyk0|oj2nw0|235k00|8lho0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "-90|-120|-180|-60",
                        offsetIndices: "01211313131313131313131313131313131313131313131313131"
                    }, {
                        id: "America/Adak",
                        untils: "-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "660|600|540",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Anchorage",
                        untils: "-ek1qo0|1tyx80|2e400|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "600|540|480",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Anguilla",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Antigua",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Araguaina",
                        untils: "-t85j2o|99k8mo|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|2yl440|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|51udg0|64ak0|Infinity",
                        offsets: "192.8|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Argentina/Buenos_Aires",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323232323232"
                    }, {
                        id: "America/Argentina/Catamarca",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132321232"
                    }, {
                        id: "America/Argentina/ComodRivadavia",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132321232"
                    }, {
                        id: "America/Argentina/Cordoba",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132323232"
                    }, {
                        id: "America/Argentina/Jujuy",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|c8w80|776k0|ag040|7k2g0|bvus0|776k0|7qcg40|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323121323232"
                    }, {
                        id: "America/Argentina/La_Rioja",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6qik0|3g880|8jbw0|6u7w0|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323231232321232"
                    }, {
                        id: "America/Argentina/Mendoza",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bktk0|71mk0|bqas0|73h80|bvus0|773s0|5unes0|6hes0|1p7mk0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232312121321232"
                    }, {
                        id: "America/Argentina/Rio_Gallegos",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323232321232"
                    }, {
                        id: "America/Argentina/Salta",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323231323232"
                    }, {
                        id: "America/Argentina/San_Juan",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6qik0|3g880|8jbw0|6u7w0|bvus0|776k0|5v2840|2txg0|1sgak0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323231232321232"
                    }, {
                        id: "America/Argentina/San_Luis",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|7pp80|b2aw0|71mk0|4qg40|6s8ik0|2txg0|1sgak0|14nw0|2gys0|b5xg0|7k580|b5xg0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323121212321212"
                    }, {
                        id: "America/Argentina/Tucuman",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|mas0|1um2k0|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121212323232313232123232"
                    }, {
                        id: "America/Argentina/Ushuaia",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|5v0dg0|12ys0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323232321232"
                    }, {
                        id: "America/Aruba",
                        untils: "-u7lckd|rlo7qd|Infinity",
                        offsets: "275.7833|270|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/Asuncion",
                        untils: "-jy93zk|ldwofk|s4vw0|s6w40|7tek0|b0dg0|7rjw0|b0dg0|7rjw0|b0dg0|9cyk0|9eys0|9et80|9eys0|9cyk0|9eys0|9cyk0|9eys0|9cyk0|9eys0|9et80|9eys0|9cyk0|9eys0|9cyk0|9eys0|9cyk0|9eys0|9et80|9eys0|9cyk0|ahus0|8a2k0|9eys0|9cyk0|9o840|7k580|b7s40|93p80|9gtg0|7nuk0|b42s0|7lzw0|b5xg0|7tek0|b9ms0|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|7kas0|b5rw0|7x9g0|ast80|a31g0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|776k0|biw40|8zzw0|905g0|9px80|905g0|9px80|9d440|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|Infinity",
                        offsets: "230.6667|240|180",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Atikokan",
                        untils: "-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101111"
                    }, {
                        id: "America/Atka",
                        untils: "-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "660|600|540",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Bahia_Banderas",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|asqg0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "421|420|360|480|300",
                        offsetIndices: "0121212131212121212121212121212121212142424242424242424242424242424242424242424242424242424242"
                    }, {
                        id: "America/Bahia",
                        untils: "-t85kv8|99kaf8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|4irc40|6u7w0|Infinity",
                        offsets: "154.0667|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Barbados",
                        untils: "-o0aiaj|46b400|npv1mj|5rbw0|a31g0|8n180|a31g0|8n180|ag040|84ik0|Infinity",
                        offsets: "238.4833|240|180",
                        offsetIndices: "00121212121"
                    }, {
                        id: "America/Belem",
                        untils: "-t85j0s|99k8ks|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|Infinity",
                        offsets: "193.9333|180|120",
                        offsetIndices: "012121212121212121212121212121"
                    }, {
                        id: "America/Belize",
                        untils: "-u52ic0|3edkc0|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|g2t2q0|3e580|4mcys0|2vmk0|Infinity",
                        offsets: "352.8|360|330|300",
                        offsetIndices: "01212121212121212121212121212121212121212121212121213131"
                    }, {
                        id: "America/Blanc-Sablon",
                        untils: "-qzp0o0|a2vw0|c5jxg0|1tzdw0|2dnc0|Infinity",
                        offsets: "240|180",
                        offsetIndices: "010110"
                    }, {
                        id: "America/Boa_Vista",
                        untils: "-t85grk|99k93k|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|62xk40|7k580|biw40|cvw0|Infinity",
                        offsets: "242.6667|240|180",
                        offsetIndices: "0121212121212121212121212121212121"
                    }, {
                        id: "America/Bogota",
                        untils: "-srdoy8|14f1hi8|ha580|Infinity",
                        offsets: "296.2667|300|240",
                        offsetIndices: "0121"
                    }, {
                        id: "America/Boise",
                        untils: "-r0emw0|ast80|7x9g0|ast80|1um840|9s7jw0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|51k40|doik0|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420|360",
                        offsetIndices: "0101012212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Buenos_Aires",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323232323232"
                    }, {
                        id: "America/Cambridge_Bay",
                        untils: "-q3gdc0|bjeec0|1tz5k0|2dvo0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x6o0|ast80|ct40|7kj40|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|420|360|300",
                        offsetIndices: "0122131212121212121212121212121212121212121212233221212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Campo_Grande",
                        untils: "-t85hvw|99ka7w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",
                        offsets: "218.4667|240|180",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Cancun",
                        untils: "-p1u7c0|vauo00|7ggw40|afuk0|8a840|afuk0|8a840|64ak0|4bms0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|51k40|Infinity",
                        offsets: "347.0667|360|300|240",
                        offsetIndices: "0123232321212121212121212121212121212121212"
                    }, {
                        id: "America/Caracas",
                        untils: "-u7lcxw|rlo83w|meoxm0|4dps00|Infinity",
                        offsets: "267.6667|270|240",
                        offsetIndices: "01212"
                    }, {
                        id: "America/Catamarca",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132321232"
                    }, {
                        id: "America/Cayenne",
                        untils: "-uj7yb4|tcw6r4|Infinity",
                        offsets: "209.3333|240|180",
                        offsetIndices: "012"
                    }, {
                        id: "America/Cayman",
                        untils: "-w757vc|Infinity",
                        offsets: "319.6|300",
                        offsetIndices: "01"
                    }, {
                        id: "America/Chicago",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bvus0|776k0|7kas0|b5rw0|9d440|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|7x9g0|dbjw0|8a840|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Chihuahua",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|xes2s0|afuk0|8a840|afuk0|8aaw0|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "424.3333|420|360|300",
                        offsetIndices: "0121212323221212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Coral_Harbour",
                        untils: "-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101111"
                    }, {
                        id: "America/Cordoba",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132323232"
                    }, {
                        id: "America/Costa_Rica",
                        untils: "-pjw8fn|ubtl3n|51ek0|doo40|51ek0|5jso40|8drw0|acas0|2xh80|Infinity",
                        offsets: "336.2167|360|300",
                        offsetIndices: "0121212121"
                    }, {
                        id: "America/Creston",
                        untils: "-rshz80|vbus0|Infinity",
                        offsets: "420|480",
                        offsetIndices: "010"
                    }, {
                        id: "America/Cuiaba",
                        untils: "-t85hm4|99k9y4|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|w5hg0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",
                        offsets: "224.3333|240|180",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Curacao",
                        untils: "-u7lckd|rlo7qd|Infinity",
                        offsets: "275.7833|270|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/Danmarkshavn",
                        untils: "-rvusjk|x8nx3k|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|53hk0|Infinity",
                        offsets: "74.6667|180|120|0",
                        offsetIndices: "01212121212121212121212121212121213"
                    }, {
                        id: "America/Dawson_Creek",
                        untils: "-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|69uk0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "0101101010101010101010101010101010101010101010101010101011"
                    }, {
                        id: "America/Dawson",
                        untils: "-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|465k00|3e2is0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",
                        offsets: "540|480|420",
                        offsetIndices: "01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Denver",
                        untils: "-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Detroit",
                        untils: "-xx8dyd|5eraud|dyeyk0|1tzb40|2dq40|1c9440|7x3w0|9rlbxo|71s2c|9d440|9cyk0|2cmdg0|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "332.1833|360|300|240",
                        offsetIndices: "0123323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Dominica",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Edmonton",
                        untils: "-x1yazk|629ink|a2vw0|8n6s0|29ek0|h6lg0|9px80|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|9l0g40|1tz5k0|2dvo0|tj1g0|7x3w0|ctzk40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "453.8667|420|360",
                        offsetIndices: "0121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Eirunepe",
                        untils: "-t85f28|99ka68|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|7hg2s0|2t2t80|Infinity",
                        offsets: "279.4667|300|240",
                        offsetIndices: "0121212121212121212121212121212121"
                    }, {
                        id: "America/El_Salvador",
                        untils: "-pkm4tc|ymao5c|7k580|b5xg0|7k580|Infinity",
                        offsets: "356.8|360|300",
                        offsetIndices: "012121"
                    }, {
                        id: "America/Ensenada",
                        untils: "-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "468.0667|420|480",
                        offsetIndices: "012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Fort_Nelson",
                        untils: "-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "01011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "America/Fort_Wayne",
                        untils: "-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Fortaleza",
                        untils: "-t85kvc|99kafc|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|puk0|id6s0|6h980|Infinity",
                        offsets: "154|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121"
                    }, {
                        id: "America/Glace_Bay",
                        untils: "-z94kwc|89fk8c|a2vw0|c5jxg0|1tzdw0|2dnc0|3y8g40|7x3w0|9pa5g0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "239.8|240|180",
                        offsetIndices: "012122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Godthab",
                        untils: "-rvumf4|x8nqz4|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "206.9333|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Goose_Bay",
                        untils: "-qzp20k|a2vw0|8kjbw0|kzjyk|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|6y2s0|22420|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "210.8667|150.8667|210|150|240|180|120",
                        offsetIndices: "010232323232323233232323232323232323232323232323232323232324545454545454545454545454545454545454545454546454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454"
                    }, {
                        id: "America/Grand_Turk",
                        untils: "-u85og2|z3brw2|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|18ais0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "307.1667|300|240",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121222121212121212121212121212121212121212121"
                    }, {
                        id: "America/Grenada",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Guadeloupe",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Guatemala",
                        untils: "-qqqskk|ss0akk|4ofw0|4tidg0|6djw0|3wwas0|8n180|7n5ms0|7x3w0|Infinity",
                        offsets: "362.0667|360|300",
                        offsetIndices: "0121212121"
                    }, {
                        id: "America/Guayaquil",
                        untils: "-kcr84o|wb620o|3jp80|Infinity",
                        offsets: "314|300|240",
                        offsetIndices: "0121"
                    }, {
                        id: "America/Guyana",
                        untils: "-smcak8|vj4sz8|81rf90|Infinity",
                        offsets: "232.6667|225|180|240",
                        offsetIndices: "0123"
                    }, {
                        id: "America/Halifax",
                        untils: "-z94k80|777go0|9et80|st9o0|a2vw0|ssyk0|5rbw0|cv1g0|69uk0|c6ys0|6kyk0|ci2s0|67zw0|ci2s0|6w2k0|bu040|7lzw0|bu040|66580|bu040|7lzw0|bu040|64ak0|cls40|5v180|cv1g0|6j3w0|c6ys0|79180|b42s0|7lzw0|b42s0|7yyk0|bu040|64ak0|dbpg0|66580|cls40|5ed80|bu040|7lzw0|b42s0|7lzw0|cjxg0|66580|bh1g0|7lzw0|b42s0|7lzw0|6uj00|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|1cm2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "254.4|240|180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Havana",
                        untils: "-n7762o|1icfyo|69uk0|62s040|4ofw0|e1ms0|51ek0|e1ms0|4ofw0|1fhs40|4ofw0|e1ms0|4ofw0|9s9k40|67zw0|cedg0|6h980|9o840|7yyk0|b5xg0|7k580|bvus0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|8a2k0|ag040|8bx80|ae5g0|8drw0|acas0|9cyk0|9d440|9px80|905g0|9px80|9q2s0|7x3w0|8a840|ast80|7x9g0|ast80|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|905g0|a2vw0|905g0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|8n400|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|7x6o0|1cm000|6uao0|bvs00|779c0|bitc0|6uao0|bvs00|779c0|bvs00|779c0|c8qo0|779c0|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|Infinity",
                        offsets: "329.6|300|240",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Hermosillo",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "443.8667|420|360|480",
                        offsetIndices: "0121212131212121"
                    }, {
                        id: "America/Indiana/Indianapolis",
                        untils: "-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Knox",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Indiana/Marengo",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|2wsas0|7x3w0|1c9440|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|465h80|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|fvt9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0101011010101010101010101212121212111212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Petersburg",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|501ek0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|sfzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|eu02o0|asw00|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "01010110101010101010101010101010101010101010101010111011212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Tell_City",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|501ek0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|1tw580|9d440|9cyk0|9d440|9cvs0|9d440|9cyk0|ihslg0|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "01010110101010101010101010101021211010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Indiana/Vevay",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|4gyis0|7txx80|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|hfzhg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101101212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Vincennes",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|3fidg0|7x3w0|asys0|7x3w0|b5rw0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|2lz980|9cyk0|9d440|9cyk0|ihslg0|asw00|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "01010110101010101010101010101010121211011212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Winamac",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|465h80|9cyk0|9d440|9cyk0|ihslg0|asw00|6udg0|c8l40|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "01010110101010101010101010101010101010121211021212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indianapolis",
                        untils: "-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Inuvik",
                        untils: "-8ve5c0|6fce80|9q000|71i2w0|ipzw0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|480|360|420",
                        offsetIndices: "0121323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "America/Iqaluit",
                        untils: "-eb6ao0|1l3h80|2dq40|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7xc80|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|240|300|180|360",
                        offsetIndices: "01123212121212121212121212121212121212121212142212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Jamaica",
                        untils: "-u85og2|wbl182|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|Infinity",
                        offsets: "307.1667|300|240",
                        offsetIndices: "0121212121212121212121"
                    }, {
                        id: "America/Jujuy",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|c8w80|776k0|ag040|7k2g0|bvus0|776k0|7qcg40|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323121323232"
                    }, {
                        id: "America/Juneau",
                        untils: "-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9d1c0|9d1c0|9cyk0|9d440|9px80|905g0|9px80|1leo0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420|540",
                        offsetIndices: "01101010101010101010101010001010122020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202"
                    }, {
                        id: "America/Kentucky/Louisville",
                        untils: "-r0esg0|ast80|7x9g0|ast80|sg5g0|6bp80|a98o40|7x3w0|6w840|1tz8c0|2dsw0|ast9o|1sw2c|21gis0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|4bh80|3j3xc0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0101010101101010101010101010101010101121212121212111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Kentucky/Monticello",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|bs6g40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0101011010101010101010101010101010101010101010101010101010101010101010101121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Knox_IN",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Kralendijk",
                        untils: "-u7lckd|rlo7qd|Infinity",
                        offsets: "275.7833|270|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/La_Paz",
                        untils: "-jxzspo|84ik0|Infinity",
                        offsets: "272.6|212.6|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/Lima",
                        untils: "-w25lpo|fcxjlo|4ml80|93us0|9cyk0|9d440|9cyk0|nw16s0|4ml80|e5c40|4ml80|1fr1g0|4ml80|1yiys0|4ml80|Infinity",
                        offsets: "308.6|300|240",
                        offsetIndices: "0121212121212121"
                    }, {
                        id: "America/Los_Angeles",
                        untils: "-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Louisville",
                        untils: "-r0esg0|ast80|7x9g0|ast80|sg5g0|6bp80|a98o40|7x3w0|6w840|1tz8c0|2dsw0|ast9o|1sw2c|21gis0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|4bh80|3j3xc0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0101010101101010101010101010101010101121212121212111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Lower_Princes",
                        untils: "-u7lckd|rlo7qd|Infinity",
                        offsets: "275.7833|270|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/Maceio",
                        untils: "-t85ldw|99kaxw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|2yl440|64ak0|1wf1g0|7k580|biw40|puk0|id6s0|6h980|Infinity",
                        offsets: "142.8667|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121"
                    }, {
                        id: "America/Managua",
                        untils: "-ijh6oo|ka1i0o|xqqk0|24p6s0|53980|dmtg0|53980|60itw0|dq240|53es0|235h80|4beis0|8zzw0|at4c0|7x140|Infinity",
                        offsets: "345.2|360|300",
                        offsetIndices: "0121212121212121"
                    }, {
                        id: "America/Manaus",
                        untils: "-t85gvw|99k97w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|Infinity",
                        offsets: "240.0667|240|180",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "America/Marigot",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Martinique",
                        untils: "-umcvcs|zz5x4s|8zzw0|Infinity",
                        offsets: "244.3333|240|180",
                        offsetIndices: "0121"
                    }, {
                        id: "America/Matamoros",
                        untils: "-p1u7c0|ykt480|ast80|3vppg0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "400|360|300",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Mazatlan",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "425.6667|420|360|480",
                        offsetIndices: "0121212131212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Mendoza",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bktk0|71mk0|bqas0|73h80|bvus0|773s0|5unes0|6hes0|1p7mk0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232312121321232"
                    }, {
                        id: "America/Menominee",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|a7n9g0|9px80|1at9g0|2396k0|9d1c0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "01010110101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Merida",
                        untils: "-p1u7c0|vauo00|hoyk0|6ys0c0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "358.4667|360|300",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Metlakatla",
                        untils: "-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|gpc840|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|3ylc0|2itg0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420|540",
                        offsetIndices: "01101010101010101010101010101010102020200202020202020202020202020202020202020202"
                    }, {
                        id: "America/Mexico_City",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|3knek0|776k0|rf440|5t6k0|1evk40|71mk0|30p1g0|8n180|nufxo0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "396.6|420|360|300",
                        offsetIndices: "012121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Miquelon",
                        untils: "-ulmyxk|zzqbdk|3m59g0|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "224.6667|240|180|120",
                        offsetIndices: "012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Moncton",
                        untils: "-z94i40|89fhg0|a2vw0|7mqqo0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|dmtg0|64ak0|cao40|6fek0|bkqs0|7iak0|6y5k0|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|s36s0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a2lo|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6uiyc|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240|180",
                        offsetIndices: "012121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Monterrey",
                        untils: "-p1u7c0|ykt480|ast80|3vppg0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "401.2667|360|300",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Montevideo",
                        untils: "-w4mll9|67elc0|1s74p9|9et80|9exe0|9czy0|9exe0|9czy0|3ydyq0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7k6m0|9q1e0|9czy0|asxe0|7x5a0|6do20|ppvy0|4mmm0|8g9qq0|901a0|38pe0|2inw0|2nf9g0|8zzw0|1e3s40|9o3y0|q8he0|2kik0|yxhg0|4bh80|s36s0|2vl60|905g0|5rg20|51ek0|weqs0|3yik0|e1ms0|4ofw0|erk40|3yik0|2vs40|gk7w0|41iys0|3wnw0|erk40|4bh80|c8tg0|64ak0|c8tg0|6u7w0|c8tg0|6h980|bvus0|6u7w0|614qs0|9q2s0|a31g0|7x3w0|ag040|8a2k0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|ag040|8a2k0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "224.85|240|180|210|150|120|90",
                        offsetIndices: "001232323232323232323232324242525242525264252525252525252525252525252525252525252525252"
                    }, {
                        id: "America/Montreal",
                        untils: "-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Montserrat",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Nassau",
                        untils: "-u6m4c6|r7u7s6|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "309.5|300|240",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/New_York",
                        untils: "-r0ev80|ast80|7x9g0|ast80|7x9g0|b5rw0|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tzb40|2dq40|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Nipigon",
                        untils: "-qzoxw0|a2vw0|bfxjw0|pmdk0|1tzb40|2dq40|ewvus0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "010111010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Nome",
                        untils: "-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l6c0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "660|600|540|480",
                        offsetIndices: "011001010101010101010101010101010122323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Noronha",
                        untils: "-t85lzw|99k8rw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",
                        offsets: "129.6667|120|60",
                        offsetIndices: "0121212121212121212121212121212121212121"
                    }, {
                        id: "America/North_Dakota/Beulah",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360|300",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101011212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/North_Dakota/Center",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a5c0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360|300",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101011212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/North_Dakota/New_Salem",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a5c0|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360|300",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Nuuk",
                        untils: "-rvumf4|x8nqz4|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "206.9333|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Ojinaga",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|xes2s0|afuk0|8a840|afuk0|8aaw0|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "417.6667|420|360|300",
                        offsetIndices: "0121212323221212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Panama",
                        untils: "-w757vc|Infinity",
                        offsets: "319.6|300",
                        offsetIndices: "01"
                    }, {
                        id: "America/Pangnirtung",
                        untils: "-pkmlc0|b0ke00|1tzdw0|2dnc0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|asw00|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7xc80|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|240|180|120|300|360",
                        offsetIndices: "012213121212121212121212121212121212114141414154414141414141414141414141414141414141414141414141414141414141414141414141414"
                    }, {
                        id: "America/Paramaribo",
                        untils: "-usj4g8|cixc0c|5lydbk|kcrm6c|Infinity",
                        offsets: "220.6667|220.8667|220.6|210|180",
                        offsetIndices: "01234"
                    }, {
                        id: "America/Phoenix",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|zjedo|4olg0|9et80|bs6lmc|9cyk0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101010"
                    }, {
                        id: "America/Port_of_Spain",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Port-au-Prince",
                        untils: "-rmk9ac|ylcf6c|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8aaw0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|3vpjw0|ast80|7x9g0|ast80|2stv00|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|pkg40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "289|300|240",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Porto_Acre",
                        untils: "-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",
                        offsets: "271.2|300|240",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "America/Porto_Velho",
                        untils: "-t85g60|99k8i0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|Infinity",
                        offsets: "255.6|240|180",
                        offsetIndices: "012121212121212121212121212121"
                    }, {
                        id: "America/Puerto_Rico",
                        untils: "-efsnk0|1ppu40|2dnc0|Infinity",
                        offsets: "240|180",
                        offsetIndices: "0110"
                    }, {
                        id: "America/Punta_Arenas",
                        untils: "-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|2fnh80|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|Infinity",
                        offsets: "282.7667|300|240|180",
                        offsetIndices: "0102021212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "America/Rainy_River",
                        untils: "-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|ewvus0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "010111010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Rankin_Inlet",
                        untils: "-6s8lc0|4c6oo0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|360|240|300",
                        offsetIndices: "012131313131313131313131313131313131313131313331313131313131313131313131313131313131313131313131313131313131313131313131"
                    }, {
                        id: "America/Recife",
                        untils: "-t85ljc|99kb3c|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",
                        offsets: "139.6|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121"
                    }, {
                        id: "America/Regina",
                        untils: "-xkq9yc|6l1hmc|a2vw0|60enw0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|1b6840|9cyk0|9d440|8zzw0|9q2s0|9cyk0|9q2s0|9cyk0|9d440|9cyk0|66gc0|1tz5k0|2dvo0|a31g0|9cyk0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|tj1g0|9cyk0|9d440|Infinity",
                        offsets: "418.6|420|360",
                        offsetIndices: "012121212121212121212121221212121212121212121212121212"
                    }, {
                        id: "America/Resolute",
                        untils: "-bnp9c0|97nco0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|360|240|300",
                        offsetIndices: "012131313131313131313131313131313131313131313331313131313331313131313131313131313131313131313131313131313131313131313131"
                    }, {
                        id: "America/Rio_Branco",
                        untils: "-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",
                        offsets: "271.2|300|240",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "America/Rosario",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132323232"
                    }, {
                        id: "America/Santa_Isabel",
                        untils: "-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "468.0667|420|480",
                        offsetIndices: "012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Santarem",
                        untils: "-t85hvc|99ka7c|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|Infinity",
                        offsets: "218.8|240|180",
                        offsetIndices: "0121212121212121212121212121212"
                    }, {
                        id: "America/Santiago",
                        untils: "-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|229zw0|2gt80|awo40|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "282.7667|300|240|180",
                        offsetIndices: "010202121212121212321232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "America/Santo_Domingo",
                        untils: "-j6hz1c|hiw29c|67zw0|1dy840|62ha0|cnle0|4h2m0|elyq0|47ta0|ei9e0|4bim0|eek20|4dda0|ecpe0|dkmtg0|1stc0|Infinity",
                        offsets: "280|300|240|270",
                        offsetIndices: "01213131313131212"
                    }, {
                        id: "America/Sao_Paulo",
                        untils: "-t85jd8|99k8x8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5k02s0|6onw0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",
                        offsets: "186.4667|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Scoresbysund",
                        untils: "-rvurxk|x8ntpk|902o0|9cvs0|9cyk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "87.8667|120|60|0",
                        offsetIndices: "0121323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Shiprock",
                        untils: "-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Sitka",
                        untils: "-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1leo0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420|540",
                        offsetIndices: "01101010101010101010101010101010122020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202"
                    }, {
                        id: "America/St_Barthelemy",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/St_Johns",
                        untils: "-ris3ck|8bx80|ar440|a2vw0|9tjs0|53980|dkys0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|7tmw0|1wfuk|8zzw0|a3480|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "210.8667|150.8667|210|150|90",
                        offsetIndices: "01010101010101010101010101010101010102323232323232323323232323232323232323232323232323232323232323232323232323232323232323232323232323232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/St_Kitts",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/St_Lucia",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/St_Thomas",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/St_Vincent",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Swift_Current",
                        untils: "-xkq9d4|6l1h14|a2vw0|c5jxg0|1tz5k0|2dvo0|asys0|8n180|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|3yles0|9cyk0|s36s0|9cyk0|9d440|7x3w0|b5xg0|7k580|5j4lg0|Infinity",
                        offsets: "431.3333|420|360",
                        offsetIndices: "012122121212121212121212"
                    }, {
                        id: "America/Tegucigalpa",
                        untils: "-pfzh6k|yho0ik|7k580|b5xg0|7k580|96x1g0|4qak0|Infinity",
                        offsets: "348.8667|360|300",
                        offsetIndices: "01212121"
                    }, {
                        id: "America/Thule",
                        untils: "-rvuj9g|12yzilg|9cyk0|9d440|9cyk0|9q2s0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "275.1333|240|180",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Thunder_Bay",
                        untils: "-vbavc0|gr8qs0|1tzb40|2dq40|ctmlg0|9cyk0|9d440|9px80|9d440|9cyk0|s36s0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Tijuana",
                        untils: "-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "468.0667|420|480",
                        offsetIndices: "012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Toronto",
                        untils: "-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Tortola",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Vancouver",
                        untils: "-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "0101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Virgin",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Whitehorse",
                        untils: "-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|tiyo0|6qp440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",
                        offsets: "540|480|420",
                        offsetIndices: "01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Winnipeg",
                        untils: "-s0s7c0|7k580|tj700|a2vw0|9ok840|6u7w0|2a5hg0|1tz8c0|2dsw0|biw40|7x3w0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b7s40|7tek0|autg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|7x3w0|1cm2s0|7k580|1cm2s0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Yakutat",
                        untils: "-ek1tg0|1tz000|2e180|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1lbw0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "540|480",
                        offsetIndices: "01101010101010101010101010101010100101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Yellowknife",
                        untils: "-i9m2o0|3pk3o0|1tz5k0|2dvo0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|420|360|300",
                        offsetIndices: "012213121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Antarctica/Casey",
                        untils: "-irxc0|lag4o0|73bo0|uz1o0|60l80|2fnh80|pz9g0|Infinity",
                        offsets: "0|-480|-660",
                        offsetIndices: "01212121"
                    }, {
                        id: "Antarctica/Davis",
                        untils: "-6rmdc0|42jdw0|27wgs0|l8uss0|7eqs0|unmk0|60qs0|Infinity",
                        offsets: "0|-420|-300",
                        offsetIndices: "01012121"
                    }, {
                        id: "Antarctica/DumontDUrville",
                        untils: "-c05eo0|2mks80|2i72g0|Infinity",
                        offsets: "0|-600",
                        offsetIndices: "0101"
                    }, {
                        id: "Antarctica/Macquarie",
                        untils: "-rsj4w0|8zzw0|11wqk0|f4kh40|a6p8g0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660|0",
                        offsetIndices: "0102010101010101010101010101010101010101010101010101010101010101010101010101010101010101011"
                    }, {
                        id: "Antarctica/Mawson",
                        untils: "-8aelc0|t22y80|Infinity",
                        offsets: "0|-360|-300",
                        offsetIndices: "012"
                    }, {
                        id: "Antarctica/McMurdo",
                        untils: "-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-690|-750|-720|-780",
                        offsetIndices: "01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Antarctica/Palmer",
                        untils: "-2lxhc0|31ho0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|46b6s0|8c2s0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|Infinity",
                        offsets: "0|180|240|120",
                        offsetIndices: "0121212121213121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Antarctica/Rothera",
                        untils: "3lxs00|Infinity",
                        offsets: "0|180",
                        offsetIndices: "01"
                    }, {
                        id: "Antarctica/South_Pole",
                        untils: "-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-690|-750|-720|-780",
                        offsetIndices: "01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Antarctica/Syowa",
                        untils: "-6qsqo0|Infinity",
                        offsets: "0|-180",
                        offsetIndices: "01"
                    }, {
                        id: "Antarctica/Troll",
                        untils: "ibruo0|27pg0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-120",
                        offsetIndices: "00101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Antarctica/Vostok",
                        untils: "-6aaao0|Infinity",
                        offsets: "0|-360",
                        offsetIndices: "01"
                    }, {
                        id: "Arctic/Longyearbyen",
                        untils: "-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Aden",
                        untils: "-bwgbbg|Infinity",
                        offsets: "-186.8667|-180",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Almaty",
                        untils: "-nu1a90|37a0d0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|Infinity",
                        offsets: "-307.8|-300|-360|-420",
                        offsetIndices: "012323232323232323232321232323232323232323232323232"
                    }, {
                        id: "Asia/Amman",
                        untils: "-kcrtbk|m566fk|60l80|awo40|7v980|awo40|7v980|ayis0|9gnw0|9b9g0|7v980|autg0|7v980|3e6840|9et80|9io40|9cyk0|9d440|9cyk0|9d440|9px80|ayis0|7rjw0|ag040|8a2k0|9zc40|8drw0|a31g0|8zzw0|9d440|9cyk0|9d440|8n180|ag040|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|epmo0|4deo0|9o5c0|9ew00|9b6o0|9ew00|9d1c0|9d1c0|9d1c0|asw00|7x6o0|afxc0|8n400|9d1c0|9d1c0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|wel80|51k40|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|Infinity",
                        offsets: "-143.7333|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Anadyr",
                        untils: "-nu1sv8|379zj8|qi27w0|9et80|is040|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",
                        offsets: "-709.9333|-720|-780|-840|-660",
                        offsetIndices: "01232121212121212121214121212121212121212121212121212121212141"
                    }, {
                        id: "Asia/Aqtau",
                        untils: "-nu15b4|379y74|qrh3w0|iruk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-201.0667|-240|-300|-360",
                        offsetIndices: "012323232323232323232123232312121212121212121212"
                    }, {
                        id: "Asia/Aqtobe",
                        untils: "-nu16l4|379zh4|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|Infinity",
                        offsets: "-228.6667|-240|-300|-360",
                        offsetIndices: "0123232323232323232321232323232323232323232323232"
                    }, {
                        id: "Asia/Ashgabat",
                        untils: "-nu16t8|379zp8|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|Infinity",
                        offsets: "-233.5333|-240|-300|-360",
                        offsetIndices: "0123232323232323232323212"
                    }, {
                        id: "Asia/Ashkhabad",
                        untils: "-nu16t8|379zp8|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|Infinity",
                        offsets: "-233.5333|-240|-300|-360",
                        offsetIndices: "0123232323232323232323212"
                    }, {
                        id: "Asia/Atyrau",
                        untils: "-nu15m8|37a1a8|qrh140|iruk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|j3440|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-207.7333|-180|-300|-360|-240",
                        offsetIndices: "01232323232323232323242323232323232324242424242"
                    }, {
                        id: "Asia/Baghdad",
                        untils: "-r50g80|xkn3w0|7v980|9b9g0|9gnw0|9eys0|9et80|9d440|9b9g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9f1k0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|Infinity",
                        offsets: "-177.6|-180|-240",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Bahrain",
                        untils: "-q3gmvk|rctnrk|Infinity",
                        offsets: "-206.1333|-240|-180",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Baku",
                        untils: "-nu158c|h4tkwc|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9d1c0|239ew0|asw00|7x3w0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-199.4|-180|-240|-300",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Bangkok",
                        untils: "-pysda4|Infinity",
                        offsets: "-402.0667|-420",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Barnaul",
                        untils: "-q4ljic|5hu6uc|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|38fo0|64og0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",
                        offsets: "-335|-360|-420|-480",
                        offsetIndices: "0123232323232323232323212323232321212121212121212121212121212121212"
                    }, {
                        id: "Asia/Beirut",
                        untils: "-pyzew0|aunw0|88dg0|9et80|8yas0|a2vw0|a31g0|7k580|hjqo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|5lhs40|56yk0|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|autg0|7v980|2wxus0|8n180|a4w40|8n180|a4w40|8n180|a4w40|8n180|bs5g0|71mk0|alk40|86d80|a4w40|8n180|a4w40|8n180|a6qs0|80t80|905g0|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Bishkek",
                        untils: "-nu19tc|379zxc|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|h8dc0|bkl80|8n180|a31g0|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9db20|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|Infinity",
                        offsets: "-298.4|-300|-360|-420",
                        offsetIndices: "012323232323232323232321212121212121212121212121212"
                    }, {
                        id: "Asia/Brunei",
                        untils: "-mvofy4|3khxs4|Infinity",
                        offsets: "-459.6667|-450|-480",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Calcutta",
                        untils: "-xehava|innm9a|bmfw0|5lxg0|1mn180|Infinity",
                        offsets: "-321.1667|-330|-390",
                        offsetIndices: "012121"
                    }, {
                        id: "Asia/Chita",
                        untils: "-q4cfog|5hkxgg|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnew0|Infinity",
                        offsets: "-453.8667|-480|-540|-600",
                        offsetIndices: "012323232323232323232321232323232323232323232323232323232323232312"
                    }, {
                        id: "Asia/Choibalsan",
                        untils: "-xmct7c|11sndrc|2qk2k0|9eqg0|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|s6qk0|3nc0c0|9ct00|9d9o0|9ct00|Infinity",
                        offsets: "-458|-420|-480|-600|-540",
                        offsetIndices: "0123434343434343434343434343434343434343434343424242"
                    }, {
                        id: "Asia/Chongqing",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "Asia/Chungking",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "Asia/Colombo",
                        untils: "-xehask|isle6k|cajy0|1mp2u0|qetjw0|7x5a0|4xvqq0|Infinity",
                        offsets: "-319.5333|-330|-360|-390",
                        offsetIndices: "01231321"
                    }, {
                        id: "Asia/Dacca",
                        untils: "-eqtpow|bmgyw|5lxg0|4qknw0|u4ijy0|a1400|Infinity",
                        offsets: "-353.3333|-390|-330|-360|-420",
                        offsetIndices: "0121343"
                    }, {
                        id: "Asia/Damascus",
                        untils: "-q3gk20|5k6q0|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|k4hk40|7yyk0|awo40|7tek0|b0dg0|7v980|awo40|7tek0|alk40|887w0|awo40|7v980|ayis0|7v980|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|6bp80|cg840|6bp80|2eh1g0|8zzw0|9ts40|8zzw0|pvk40|c33w0|7cw40|cjrw0|6zxg0|btuk0|7rpg0|9gnw0|9d440|9cyk0|9et80|9et80|9rxg0|91uk0|92040|9et80|9o840|9et80|9d440|9et80|9eys0|9et80|9b9g0|9gnw0|99es0|9iik0|9d440|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|9eys0|9et80|9d440|9et80|9d440|8y580|9q2s0|b5rw0|7x9g0|aunw0|7ig40|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|Infinity",
                        offsets: "-145.2|-120|-180",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Dhaka",
                        untils: "-eqtpow|bmgyw|5lxg0|4qknw0|u4ijy0|a1400|Infinity",
                        offsets: "-353.3333|-390|-330|-360|-420",
                        offsetIndices: "0121343"
                    }, {
                        id: "Asia/Dili",
                        untils: "-u9s4l8|fqcu98|hufs00|cpz440|Infinity",
                        offsets: "-502.3333|-480|-540",
                        offsetIndices: "01212"
                    }, {
                        id: "Asia/Dubai",
                        untils: "-q3gnko|Infinity",
                        offsets: "-221.2|-240",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Dushanbe",
                        untils: "-nu18qo|379yuo|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|hp440|Infinity",
                        offsets: "-275.2|-300|-360|-420",
                        offsetIndices: "012323232323232323232321"
                    }, {
                        id: "Asia/Famagusta",
                        untils: "-p4bqac|rvhy2c|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|8h8w0|leog0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-135.8|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Gaza",
                        untils: "-ffv9k0|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|5hoqs0|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|1sns0|3p6is0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|66as0|4vxc0|8n400|a2yo0|8n400|a2yo0|8n400|asw00|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|8n400|a2yo0|8ulg0|97ek0|8y580|9ts40|8hms0|a4qk0|7x3w0|asys0|8a5c0|ahs1o|71mic|bzk5o|69uic|cg840|902o0|9q000|9cyk0|9d440|ast80|7z440|aqyk0|7z6w0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010100101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Harbin",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "Asia/Hebron",
                        untils: "-ffv9k0|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|5hoqs0|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|1sns0|3p6is0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|66as0|4vxc0|8n400|a2yo0|8n400|a2yo0|8n400|asw00|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|8n400|a2yo0|8ulg0|97ek0|8y580|9ts40|8hms0|a4qk0|82nw0|anes0|8a5c0|afxc0|73h80|bzk5o|69uic|1hs40|1lbw0|9d440|902o0|9q000|9cyk0|9d440|ast80|7z440|aqyk0|7z6w0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Ho_Chi_Minh",
                        untils: "-x56934|2isioa|gj25iu|15ct80|8so00|tmtk0|4azjw0|2cmao0|8285c0|Infinity",
                        offsets: "-426.6667|-426.5|-420|-480|-540",
                        offsetIndices: "0123423232"
                    }, {
                        id: "Asia/Hong_Kong",
                        untils: "-y0i0s0|j44dk0|5k000|4d4y0|2195i0|7x3w0|bj320|6uao0|bvs00|7x6o0|9d1c0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|ast80|77c40|biqk0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",
                        offsets: "-456.7|-480|-540|-510",
                        offsetIndices: "0123212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Hovd",
                        untils: "-xmcoz0|11sncb0|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",
                        offsets: "-366.6|-360|-420|-480",
                        offsetIndices: "012323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Irkutsk",
                        untils: "-q28gn5|5fh175|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-417.0833|-420|-480|-540",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Istanbul",
                        untils: "-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",
                        offsets: "-116.9333|-120|-180|-240",
                        offsetIndices: "0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"
                    }, {
                        id: "Asia/Jakarta",
                        untils: "-o0bdpc|4lzxc0|4wdzjc|1tu960|1cx860|11jta0|74uc20|Infinity",
                        offsets: "-427.2|-440|-450|-540|-480|-420",
                        offsetIndices: "01232425"
                    }, {
                        id: "Asia/Jayapura",
                        untils: "-jebm20|66bqe0|a37vy0|Infinity",
                        offsets: "-562.8|-540|-570",
                        offsetIndices: "0121"
                    }, {
                        id: "Asia/Jerusalem",
                        untils: "-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",
                        offsets: "-140.6667|-120|-180|-240",
                        offsetIndices: "012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Kabul",
                        untils: "-d1pkg0|Infinity",
                        offsets: "-240|-270",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Kamchatka",
                        untils: "-olrupo|3z045o|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",
                        offsets: "-634.6|-660|-720|-780",
                        offsetIndices: "012323232323232323232321232323232323232323232323232323232323212"
                    }, {
                        id: "Asia/Karachi",
                        untils: "-wvpb30|im3zt0|1mn180|33xpg0|a63o20|g72qo0|9cyk0|2y85g0|7v980|8hms0|aaak0|Infinity",
                        offsets: "-268.2|-330|-390|-300|-360",
                        offsetIndices: "012133434343"
                    }, {
                        id: "Asia/Kashgar",
                        untils: "-lx5pjw|Infinity",
                        offsets: "-350.3333|-360",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Kathmandu",
                        untils: "-q3gt4s|yg2lus|Infinity",
                        offsets: "-341.2667|-330|-345",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Katmandu",
                        untils: "-q3gt4s|yg2lus|Infinity",
                        offsets: "-341.2667|-330|-345",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Khandyga",
                        untils: "-q4cjrp|5hl1jp|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|3fx40|4h6s0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|8ql00|1mlho0|Infinity",
                        offsets: "-542.2167|-480|-540|-600|-660",
                        offsetIndices: "0123232323232323232323212323232323232323232323232343434343434343432"
                    }, {
                        id: "Asia/Kolkata",
                        untils: "-xehava|innm9a|bmfw0|5lxg0|1mn180|Infinity",
                        offsets: "-321.1667|-330|-390",
                        offsetIndices: "012121"
                    }, {
                        id: "Asia/Krasnoyarsk",
                        untils: "-q37l72|5gg8j2|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-371.4333|-360|-420|-480",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Kuala_Lumpur",
                        untils: "-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",
                        offsets: "-415.4167|-420|-440|-450|-540|-480",
                        offsetIndices: "0123435"
                    }, {
                        id: "Asia/Kuching",
                        untils: "-mvof3k|3khwxk|1epvy0|4ohqo|e5a9c|4ohqo|e3flc|4ohqo|e3flc|4ohqo|e3flc|4ohqo|e5a9c|4ohqo|e3flc|4ohqo|3ajlc|1v2qk0|Infinity",
                        offsets: "-441.3333|-450|-480|-500|-540",
                        offsetIndices: "0123232323232323242"
                    }, {
                        id: "Asia/Kuwait",
                        untils: "-bwgbbg|Infinity",
                        offsets: "-186.8667|-180",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Macao",
                        untils: "-y0i2cy|jdvyoy|6onw0|ac580|8fs40|7v980|11luw0|awlc0|7vc00|ac800|bko00|7x6o0|9d1c0|7vc00|asw00|7x6o0|asw00|7x6o0|auqo0|88ao0|asw00|7x6o0|asw00|779c0|bitc0|779c0|bvs00|6uao0|bw1q0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cvs0|9d6w0|9cvs0|9d6w0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",
                        offsets: "-454.1667|-480|-540|-600",
                        offsetIndices: "012323212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Macau",
                        untils: "-y0i2cy|jdvyoy|6onw0|ac580|8fs40|7v980|11luw0|awlc0|7vc00|ac800|bko00|7x6o0|9d1c0|7vc00|asw00|7x6o0|asw00|7x6o0|auqo0|88ao0|asw00|7x6o0|asw00|779c0|bitc0|779c0|bvs00|6uao0|bw1q0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cvs0|9d6w0|9cvs0|9d6w0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",
                        offsets: "-454.1667|-480|-540|-600",
                        offsetIndices: "012323212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Magadan",
                        untils: "-nu1nxc|37a05c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|s39k0|Infinity",
                        offsets: "-603.2|-600|-660|-720",
                        offsetIndices: "012323232323232323232321232323232323232323232323232323232323232312"
                    }, {
                        id: "Asia/Makassar",
                        untils: "-q3gzg0|6p5hc0|4u87w0|1w02k0|Infinity",
                        offsets: "-477.6|-480|-540",
                        offsetIndices: "00121"
                    }, {
                        id: "Asia/Manila",
                        untils: "-hb5y80|4qak0|2qidg0|1b2d80|4xf440|442k0|cdqdg0|9et80|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "010101010"
                    }, {
                        id: "Asia/Muscat",
                        untils: "-q3gnko|Infinity",
                        offsets: "-221.2|-240",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Nicosia",
                        untils: "-p4bq6g|rvhxyg|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-133.4667|-120|-180",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Novokuznetsk",
                        untils: "-nu36tc|37bu5c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",
                        offsets: "-348.8|-360|-420|-480",
                        offsetIndices: "012323232323232323232321232323232323232323232323232323232323212"
                    }, {
                        id: "Asia/Novosibirsk",
                        untils: "-q4do0s|5hmbcs|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|2vh00|6hn40|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|wrpg0|Infinity",
                        offsets: "-331.6667|-360|-420|-480",
                        offsetIndices: "0123232323232323232323212323212121212121212121212121212121212121212"
                    }, {
                        id: "Asia/Omsk",
                        untils: "-q5xmx6|5j6d16|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-293.5|-300|-360|-420",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Oral",
                        untils: "-nu15ic|37a16c|qi2540|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|9d1c0|5reo0|cyo00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-205.4|-180|-300|-360|-240",
                        offsetIndices: "01232323232323232424242424242424242424242424242"
                    }, {
                        id: "Asia/Phnom_Penh",
                        untils: "-pysda4|Infinity",
                        offsets: "-402.0667|-420",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Pontianak",
                        untils: "-w6piww|cse2o0|4tnu2w|1wkei0|1cx860|11jta0|74uc20|cixam0|Infinity",
                        offsets: "-437.3333|-450|-540|-480|-420",
                        offsetIndices: "001213134"
                    }, {
                        id: "Asia/Pyongyang",
                        untils: "-w895yc|1yh10c|hk5da0|10ipmo0|1f4qo0|Infinity",
                        offsets: "-503|-510|-540",
                        offsetIndices: "012212"
                    }, {
                        id: "Asia/Qatar",
                        untils: "-q3gmvk|rctnrk|Infinity",
                        offsets: "-206.1333|-240|-180",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Qostanay",
                        untils: "-nu17s4|37a0o4|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-254.4667|-240|-300|-360",
                        offsetIndices: "012323232323232323232123232323232323232323232323"
                    }, {
                        id: "Asia/Qyzylorda",
                        untils: "-nu184g|37a10g|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|ohhc0|cyo00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|7osl00|Infinity",
                        offsets: "-261.8667|-240|-300|-360",
                        offsetIndices: "01232323232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Rangoon",
                        untils: "-q3gv5b|bnjp3b|1kh520|Infinity",
                        offsets: "-384.7833|-390|-540",
                        offsetIndices: "0121"
                    }, {
                        id: "Asia/Riyadh",
                        untils: "-bwgbbg|Infinity",
                        offsets: "-186.8667|-180",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Saigon",
                        untils: "-x56934|2isioa|gj25iu|15ct80|8so00|tmtk0|4azjw0|2cmao0|8285c0|Infinity",
                        offsets: "-426.6667|-426.5|-420|-480|-540",
                        offsetIndices: "0123423232"
                    }, {
                        id: "Asia/Sakhalin",
                        untils: "-xl87rc|kvnarc|ikvh40|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|iq5g0|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",
                        offsets: "-570.8|-540|-660|-720|-600",
                        offsetIndices: "01232323232323232323232423232323232424242424242424242424242424242"
                    }, {
                        id: "Asia/Samarkand",
                        untils: "-nu18eh|37a1ah|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|Infinity",
                        offsets: "-267.8833|-240|-300|-360",
                        offsetIndices: "01232323232323232323232"
                    }, {
                        id: "Asia/Seoul",
                        untils: "-w8966g|1yh18g|hkx5a0|1faao0|5cik0|ae5g0|8a2k0|ae5g0|8bx80|c8tg0|6h980|1bj6s0|l3aq0|6j3w0|d2g40|6u7w0|b5xg0|776k0|biw40|776k0|biw40|776k0|biw40|776k0|grs40|dfqxi0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-507.8667|-510|-540|-600|-570",
                        offsetIndices: "012232323232141414141414123232"
                    }, {
                        id: "Asia/Shanghai",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "Asia/Singapore",
                        untils: "-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",
                        offsets: "-415.4167|-420|-440|-450|-540|-480",
                        offsetIndices: "0123435"
                    }, {
                        id: "Asia/Srednekolymsk",
                        untils: "-nu1ogs|37a0os|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-614.8667|-600|-660|-720",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Taipei",
                        untils: "-gtzfk0|45slc0|c51c0|75bw0|a31g0|aaak0|9d440|7v980|awo40|7v980|awo40|7v980|awo40|7v980|7tk40|clmk0|7rpg0|b07w0|7rpg0|b07w0|7rpg0|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|cjxg0|69uk0|ci2s0|69uk0|6its40|9et80|9d440|9et80|1yf9g0|4qak0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Tashkent",
                        untils: "-nu18tz|379yxz|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|Infinity",
                        offsets: "-277.1833|-300|-360|-420",
                        offsetIndices: "012323232323232323232321"
                    }, {
                        id: "Asia/Tbilisi",
                        untils: "-nu14an|h4tjyn|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9cvs0|9cyk0|9d440|9cyk0|9d440|ipzw0|9cyk0|9q2s0|tivw0|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|4ofw0|6hn40|7k800|Infinity",
                        offsets: "-179.1833|-180|-240|-300",
                        offsetIndices: "0123232323232323232323212121232323232323232323212"
                    }, {
                        id: "Asia/Tehran",
                        untils: "-s6m6uw|fnolc0|gm3h4w|777y0|b07w0|3pes0|42c20|9cyk0|9gtg0|9kd80|5ja5g0|7avw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|1av440|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|Infinity",
                        offsets: "-205.7333|-210|-240|-300|-270",
                        offsetIndices: "00123214141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141"
                    }, {
                        id: "Asia/Tel_Aviv",
                        untils: "-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",
                        offsets: "-140.6667|-120|-180|-240",
                        offsetIndices: "012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Thimbu",
                        untils: "-bojclo|kxymno|Infinity",
                        offsets: "-358.6|-330|-360",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Thimphu",
                        untils: "-bojclo|kxymno|Infinity",
                        offsets: "-358.6|-330|-360",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Tokyo",
                        untils: "-bb4900|6uao0|afxc0|8a5c0|c8qo0|6hc00|c8qo0|6hc00|Infinity",
                        offsets: "-540|-600",
                        offsetIndices: "010101010"
                    }, {
                        id: "Asia/Tomsk",
                        untils: "-q3zbqf|5h7z2f|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|1leo0|97k40|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|tw040|Infinity",
                        offsets: "-339.85|-360|-420|-480",
                        offsetIndices: "0123232323232323232323212323232323232323232323212121212121212121212"
                    }, {
                        id: "Asia/Ujung_Pandang",
                        untils: "-q3gzg0|6p5hc0|4u87w0|1w02k0|Infinity",
                        offsets: "-477.6|-480|-540",
                        offsetIndices: "00121"
                    }, {
                        id: "Asia/Ulaanbaatar",
                        untils: "-xmcrsk|11sncck|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",
                        offsets: "-427.5333|-420|-480|-540",
                        offsetIndices: "012323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Ulan_Bator",
                        untils: "-xmcrsk|11sncck|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",
                        offsets: "-427.5333|-420|-480|-540",
                        offsetIndices: "012323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Urumqi",
                        untils: "-lx5pjw|Infinity",
                        offsets: "-350.3333|-360",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Ust-Nera",
                        untils: "-q4cl6u|5hl2yu|qi27w0|9eno0|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|8ql00|1mlho0|Infinity",
                        offsets: "-572.9|-480|-540|-720|-660|-600",
                        offsetIndices: "012343434343434343434345434343434343434343434343434343434343434345"
                    }, {
                        id: "Asia/Vientiane",
                        untils: "-pysda4|Infinity",
                        offsets: "-402.0667|-420",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Vladivostok",
                        untils: "-oligf7|3yqvf7|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-527.5167|-540|-600|-660",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Yakutsk",
                        untils: "-q4cioy|5hl0gy|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-518.9667|-480|-540|-600",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Yangon",
                        untils: "-q3gv5b|bnjp3b|1kh520|Infinity",
                        offsets: "-384.7833|-390|-540",
                        offsetIndices: "0121"
                    }, {
                        id: "Asia/Yekaterinburg",
                        untils: "-rx5hw9|1kybx4|5pfyv5|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-242.55|-225.0833|-240|-300|-360",
                        offsetIndices: "012343434343434343434343234343434343434343434343434343434343434343"
                    }, {
                        id: "Asia/Yerevan",
                        untils: "-nu148o|h4tjwo|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|11t180|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|Infinity",
                        offsets: "-178|-180|-240|-300",
                        offsetIndices: "0123232323232323232323212121212323232323232323232323232323232"
                    }, {
                        id: "Atlantic/Azores",
                        untils: "-u9rbs0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5qbjo0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9cyk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "114.5333|120|60|0",
                        offsetIndices: "01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121232323232323232323232323232323233323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Atlantic/Bermuda",
                        untils: "-kvj2fu|n4pr3u|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "259.3|240|180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Atlantic/Canary",
                        untils: "-oytbtc|ctvupc|hhq7s0|905g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "61.6|60|0|-60",
                        offsetIndices: "01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Atlantic/Cape_Verde",
                        untils: "-u9rbs0|g06lc0|1mn180|fpqwc0|Infinity",
                        offsets: "94.0667|120|60",
                        offsetIndices: "01212"
                    }, {
                        id: "Atlantic/Faeroe",
                        untils: "-wcehew|127keuw|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "27.0667|0|-60",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Atlantic/Faroe",
                        untils: "-wcehew|127keuw|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "27.0667|0|-60",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Atlantic/Jan_Mayen",
                        untils: "-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Atlantic/Madeira",
                        untils: "-u9rek0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5qbjo0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "67.6|60|0|-60",
                        offsetIndices: "01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Atlantic/Reykjavik",
                        untils: "-wcwx9c|4rpd9c|ci2s0|69uk0|du840|4xp80|du840|p7bw0|4w040|9bdzw0|9d6w0|64g40|cyl80|64dc0|clpc0|6hc00|bvs00|6uao0|bvs00|6uao0|bvs00|6uao0|c8qo0|6hc00|c8qo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|Infinity",
                        offsets: "88|60|0",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Atlantic/South_Georgia",
                        untils: "Infinity",
                        offsets: "120",
                        offsetIndices: "0"
                    }, {
                        id: "Atlantic/St_Helena",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Atlantic/Stanley",
                        untils: "-u63pac|dbvxqc|8zzw0|9q2s0|8zzw0|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|4xp80|l1pus0|7k580|b5rw0|77c40|biqk0|id6s0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|biqk0|77c40|biqk0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|biqk0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5xg0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|77c40|biqk0|77c40|biqk0|77c40|Infinity",
                        offsets: "231.4|240|180|120",
                        offsetIndices: "012121212121212323212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Australia/ACT",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Adelaide",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|7k800|b5uo0|6uao0|c8qo0|779c0|bitc0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Brisbane",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "01010101010101010"
                    }, {
                        id: "Australia/Broken_Hill",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Canberra",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Currie",
                        untils: "-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Darwin",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "010101010"
                    }, {
                        id: "Australia/Eucla",
                        untils: "-rnstlc|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-525|-585",
                        offsetIndices: "0101010101010101010"
                    }, {
                        id: "Australia/Hobart",
                        untils: "-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|c9tms0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/LHI",
                        untils: "5tp880|c8uu0|6u7w0|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|777y0|b5w20|7k6m0|biuq0|7k6m0|biuq0|777y0|biuq0|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|7x820|asum0|b5w20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7x5a0|asxe0|7k6m0|b5w20|8a3y0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9pym0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|Infinity",
                        offsets: "-600|-630|-690|-660",
                        offsetIndices: "0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313"
                    }, {
                        id: "Australia/Lindeman",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "010101010101010101010"
                    }, {
                        id: "Australia/Lord_Howe",
                        untils: "5tp880|c8uu0|6u7w0|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|777y0|b5w20|7k6m0|biuq0|7k6m0|biuq0|777y0|biuq0|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|7x820|asum0|b5w20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7x5a0|asxe0|7k6m0|b5w20|8a3y0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9pym0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|Infinity",
                        offsets: "-600|-630|-690|-660",
                        offsetIndices: "0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313"
                    }, {
                        id: "Australia/Melbourne",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|b5uo0|7x6o0|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/North",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "010101010"
                    }, {
                        id: "Australia/NSW",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Perth",
                        untils: "-rnsric|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "0101010101010101010"
                    }, {
                        id: "Australia/Queensland",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "01010101010101010"
                    }, {
                        id: "Australia/South",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|7k800|b5uo0|6uao0|c8qo0|779c0|bitc0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Sydney",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Tasmania",
                        untils: "-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|c9tms0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Victoria",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|b5uo0|7x6o0|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/West",
                        untils: "-rnsric|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "0101010101010101010"
                    }, {
                        id: "Australia/Yancowinna",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Brazil/Acre",
                        untils: "-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",
                        offsets: "271.2|300|240",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "Brazil/DeNoronha",
                        untils: "-t85lzw|99k8rw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",
                        offsets: "129.6667|120|60",
                        offsetIndices: "0121212121212121212121212121212121212121"
                    }, {
                        id: "Brazil/East",
                        untils: "-t85jd8|99k8x8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5k02s0|6onw0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",
                        offsets: "186.4667|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Brazil/West",
                        untils: "-t85gvw|99k97w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|Infinity",
                        offsets: "240.0667|240|180",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "Canada/Atlantic",
                        untils: "-z94k80|777go0|9et80|st9o0|a2vw0|ssyk0|5rbw0|cv1g0|69uk0|c6ys0|6kyk0|ci2s0|67zw0|ci2s0|6w2k0|bu040|7lzw0|bu040|66580|bu040|7lzw0|bu040|64ak0|cls40|5v180|cv1g0|6j3w0|c6ys0|79180|b42s0|7lzw0|b42s0|7yyk0|bu040|64ak0|dbpg0|66580|cls40|5ed80|bu040|7lzw0|b42s0|7lzw0|cjxg0|66580|bh1g0|7lzw0|b42s0|7lzw0|6uj00|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|1cm2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "254.4|240|180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Canada/Central",
                        untils: "-s0s7c0|7k580|tj700|a2vw0|9ok840|6u7w0|2a5hg0|1tz8c0|2dsw0|biw40|7x3w0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b7s40|7tek0|autg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|7x3w0|1cm2s0|7k580|1cm2s0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Canada/Eastern",
                        untils: "-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Canada/Mountain",
                        untils: "-x1yazk|629ink|a2vw0|8n6s0|29ek0|h6lg0|9px80|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|9l0g40|1tz5k0|2dvo0|tj1g0|7x3w0|ctzk40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "453.8667|420|360",
                        offsetIndices: "0121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Canada/Newfoundland",
                        untils: "-ris3ck|8bx80|ar440|a2vw0|9tjs0|53980|dkys0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|7tmw0|1wfuk|8zzw0|a3480|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "210.8667|150.8667|210|150|90",
                        offsetIndices: "01010101010101010101010101010101010102323232323232323323232323232323232323232323232323232323232323232323232323232323232323232323232323232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Canada/Pacific",
                        untils: "-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "0101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Canada/Saskatchewan",
                        untils: "-xkq9yc|6l1hmc|a2vw0|60enw0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|1b6840|9cyk0|9d440|8zzw0|9q2s0|9cyk0|9q2s0|9cyk0|9d440|9cyk0|66gc0|1tz5k0|2dvo0|a31g0|9cyk0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|tj1g0|9cyk0|9d440|Infinity",
                        offsets: "418.6|420|360",
                        offsetIndices: "012121212121212121212121221212121212121212121212121212"
                    }, {
                        id: "Canada/Yukon",
                        untils: "-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|tiyo0|6qp440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",
                        offsets: "540|480|420",
                        offsetIndices: "01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "CET",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Chile/Continental",
                        untils: "-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|229zw0|2gt80|awo40|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "282.7667|300|240|180",
                        offsetIndices: "010202121212121212321232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Chile/EasterIsland",
                        untils: "-jhfaew|ivmeuw|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|iq2o0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "437.4667|420|360|300",
                        offsetIndices: "012121212121212121212121212123232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "CST6CDT",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Cuba",
                        untils: "-n7762o|1icfyo|69uk0|62s040|4ofw0|e1ms0|51ek0|e1ms0|4ofw0|1fhs40|4ofw0|e1ms0|4ofw0|9s9k40|67zw0|cedg0|6h980|9o840|7yyk0|b5xg0|7k580|bvus0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|8a2k0|ag040|8bx80|ae5g0|8drw0|acas0|9cyk0|9d440|9px80|905g0|9px80|9q2s0|7x3w0|8a840|ast80|7x9g0|ast80|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|905g0|a2vw0|905g0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|8n400|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|7x6o0|1cm000|6uao0|bvs00|779c0|bitc0|6uao0|bvs00|779c0|bvs00|779c0|c8qo0|779c0|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|Infinity",
                        offsets: "329.6|300|240",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "EET",
                        untils: "3s9ms0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Egypt",
                        untils: "-fdls80|40d80|a31g0|7x3w0|a4w40|aqyk0|80ys0|b07w0|7tk40|b07w0|8jhg0|a8fw0|60go40|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|f9x80|3i040|eluk0|462s0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|b5rw0|7m5g0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|aqvs0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7k580|b5xg0|6u7w0|bvus0|6h980|c8tg0|64ak0|cyqs0|5anw0|1jms0|12t80|1w22s0|25p80|1sw40|2vmk0|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Eire",
                        untils: "-rzcmlr|6uao0|9pytr|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|3g8800|8a5c0|bvs00|8n400|a2yo0|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "25.35|-34.65|0|-60",
                        offsetIndices: "01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "EST",
                        untils: "Infinity",
                        offsets: "300",
                        offsetIndices: "0"
                    }, {
                        id: "EST5EDT",
                        untils: "-r0ev80|ast80|7x9g0|ast80|bmtus0|1tzb40|2dq40|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Etc/GMT-0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-1",
                        untils: "Infinity",
                        offsets: "-60",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-10",
                        untils: "Infinity",
                        offsets: "-600",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-11",
                        untils: "Infinity",
                        offsets: "-660",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-12",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-13",
                        untils: "Infinity",
                        offsets: "-780",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-14",
                        untils: "Infinity",
                        offsets: "-840",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-2",
                        untils: "Infinity",
                        offsets: "-120",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-3",
                        untils: "Infinity",
                        offsets: "-180",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-4",
                        untils: "Infinity",
                        offsets: "-240",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-5",
                        untils: "Infinity",
                        offsets: "-300",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-6",
                        untils: "Infinity",
                        offsets: "-360",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-7",
                        untils: "Infinity",
                        offsets: "-420",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-8",
                        untils: "Infinity",
                        offsets: "-480",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-9",
                        untils: "Infinity",
                        offsets: "-540",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+1",
                        untils: "Infinity",
                        offsets: "60",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+10",
                        untils: "Infinity",
                        offsets: "600",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+11",
                        untils: "Infinity",
                        offsets: "660",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+12",
                        untils: "Infinity",
                        offsets: "720",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+2",
                        untils: "Infinity",
                        offsets: "120",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+3",
                        untils: "Infinity",
                        offsets: "180",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+4",
                        untils: "Infinity",
                        offsets: "240",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+5",
                        untils: "Infinity",
                        offsets: "300",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+6",
                        untils: "Infinity",
                        offsets: "360",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+7",
                        untils: "Infinity",
                        offsets: "420",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+8",
                        untils: "Infinity",
                        offsets: "480",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+9",
                        untils: "Infinity",
                        offsets: "540",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/Greenwich",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/UCT",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/Universal",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/UTC",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/Zulu",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Europe/Amsterdam",
                        untils: "-s0dvkk|7v980|a51o0|7x6o0|a2yo0|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9b6o0|a2yo0|c51c0|6l1c0|902o0|9q000|ci000|682o0|bgyo0|79400|bitc0|779c0|bmio0|7gio0|bbeo0|7eo00|bd9c0|7ctc0|bf400|7ayo0|bvs00|6uao0|bko00|7idc0|b9k00|7gio0|bbeo0|7eo00|bf400|7ayo0|btxc0|21uc0|4uaz8|bitc0|779c0|bko00|7idc0|bd3s0|1aarpc|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-19.5333|-79.5333|-80|-20|-120|-60",
                        offsetIndices: "010101010101010101010101010101010101010101012323234545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545"
                    }, {
                        id: "Europe/Andorra",
                        untils: "-c4xmo0|k3ctg0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Astrakhan",
                        untils: "-nu2zkc|37bv8c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",
                        offsets: "-192.2|-180|-240|-300",
                        offsetIndices: "012323232323232323212121212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Athens",
                        untils: "-rvv0cg|8bjasg|2vmk0|4hiw40|16ik0|scog0|7lx40|9o2k0|9eys0|4atzw0|6djw0|bplus0|bq800|71uw0|9d1c0|902o0|91xc0|9o5c0|905g0|9qgo0|9akg0|9iik0|99980|9dcg0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-94.8667|-120|-180|-60",
                        offsetIndices: "012121313121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Belfast",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Belgrade",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Berlin",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|2o7w0|6bs00|2txg0|7k800|91xc0|9b9g0|1sqk0|2inw0|51k40|a2yo0|8n400|9q000|902o0|fx91c0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120|-180",
                        offsetIndices: "01010101010101210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Bratislava",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|b5uo0|7vc00|2vs40|4bk00|2vmk0|8n400|a2yo0|8n400|9o5c0|91xc0|fe6000|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120|0",
                        offsetIndices: "01010101010101010201010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Brussels",
                        untils: "-ss5uo0|rrx80|7vc00|a4yw0|7x6o0|asw00|7x6o0|2wh40|5omo0|b5uo0|6uao0|cyo00|7ayo0|bko00|7rmo0|a2yo0|a2yo0|8n400|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|90b00|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|4deo0|1a36k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8l9c0|clpc0|79400|fwu800|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0121212101010101010101010101010101010101010101010101212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Bucharest",
                        untils: "-k29zi0|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|kp0dc0|6h980|9q000|905g0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9cvs0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9cyk0|9d440|9cyk0|9q2s0|ast80|7xhs0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-104.4|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Budapest",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|a31g0|8n180|autg0|bgvw0|b5jeg0|th9k0|7k800|9q000|9d1c0|9d1c0|awd00|9ew00|7q0c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|a4tc0|9q000|1va2g0|6u7w0|bxpg0|6u7w0|cjxg0|64ak0|cluw0|64g40|br3ek0|905g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Busingen",
                        untils: "-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Chisinau",
                        untils: "-r2p1bo|70f1to|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|geqo0|ha580|oc8g0|7k800|9q000|9d1c0|7cl00|j3pbw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|25p80|7kdk0|9d1c0|9d1c0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xf00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-115|-104.4|-120|-180|-60|-240",
                        offsetIndices: "012323232323232323232424235353535353535353535323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Copenhagen",
                        untils: "-rzo2w0|75bw0|cbs2w0|1aco80|7k800|9q000|9d1c0|9d1c0|9d1c0|6y000|dbmo0|6bs00|clpc0|51hc0|e1k00|4oio0|giutc0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Dublin",
                        untils: "-rzcmlr|6uao0|9pytr|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|3g8800|8a5c0|bvs00|8n400|a2yo0|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "25.35|-34.65|0|-60",
                        offsetIndices: "01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Gibraltar",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|d0tp80|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "010101010101010101010101010101010101010101010101012121212121010121010101010101010101012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Guernsey",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Helsinki",
                        untils: "-peghyd|ax3tqd|9gqo0|k31s80|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-99.8167|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Isle_of_Man",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Istanbul",
                        untils: "-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",
                        offsets: "-116.9333|-120|-180|-240",
                        offsetIndices: "0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"
                    }, {
                        id: "Europe/Jersey",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Kaliningrad",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|el00|z6o0|9kd80|82tg0|i9avw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-60|-120|-180|-240",
                        offsetIndices: "01010101010101121232323232323232322121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Kiev",
                        untils: "-nu11ng|37a03g|5vd6k0|kzv40|7k800|9q000|1oyg0|jipzs0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|51ek0|neqw0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-122.0667|-120|-180|-60|-240",
                        offsetIndices: "0121313242424242424242424242121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Kirov",
                        untils: "-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-198.8|-180|-240|-300",
                        offsetIndices: "01232323232323232321212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Lisbon",
                        untils: "-u9rhc0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5gyl40|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "36.75|0|-60|-120",
                        offsetIndices: "012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121212121212121212121212121212121212122323232212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Ljubljana",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/London",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Luxembourg",
                        untils: "-y89550|68l290|75hg0|ast80|796s0|at1k0|7x6o0|3lh40|4zmo0|b6300|6u2c0|cytk0|7at40|bktk0|7rh40|a31g0|a2vw0|8n9k0|8zx40|9q2s0|9et80|9b9g0|a2vw0|8n6s0|9px80|905g0|a2vw0|905g0|a2vw0|8ncc0|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|42ao0|1aeak0|7k800|9q000|9d1c0|8n400|a2yo0|8l9c0|clpc0|79400|fwu800|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-24.6|-60|-120|0",
                        offsetIndices: "0121212131313131313131313131313131313131313131313131212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Madrid",
                        untils: "-qzlus0|8yas0|9cyk0|9eys0|2d2vw0|8sqs0|ssyk0|8n6s0|9px80|905g0|a2yo0|902o0|a2vw0|8n6s0|40lh80|5k2s0|9cyk0|1frw0|7z1c0|j1c80|8a2k0|13yt80|685g0|brzw0|8n6s0|a2vw0|8n6s0|a2vw0|8n6s0|a2vw0|8n6s0|1clx80|7x9g0|cswik0|905g0|9px80|905g0|8zzw0|9d440|9px80|905g0|9q5k0|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "010101010101010101210121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Malta",
                        untils: "-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9b6o0|8n400|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|9b6o0|9d1c0|ahs00|7m2o0|b45k0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|a4w40|8y580|9q2s0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Mariehamn",
                        untils: "-peghyd|ax3tqd|9gqo0|k31s80|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-99.8167|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Minsk",
                        untils: "-nu113c|379zjc|5r1mk0|pbf40|7k800|9q000|9d1c0|4oac0|j6dmk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|sg2o0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|Infinity",
                        offsets: "-110|-120|-180|-60|-240",
                        offsetIndices: "01213131242424242424242424221212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Monaco",
                        untils: "-uozn3l|2qx1nl|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|bko00|7rmo0|a2yo0|bvs00|6uao0|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51po0|mdbo0|7x3w0|7x9g0|c8w80|7k800|9q000|9d1c0|9nzs0|922w0|8l9c0|fxlx80|9cyk0|9q5k0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-9.35|0|-60|-120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Moscow",
                        untils: "-rx5dmh|ipzua|97hc0|7yyk0|5i840|d9p80|1jwk7|2cvk0|s8o00|1qvw0|8fpc0|1jms0|is040|412as0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-150.2833|-151.3167|-211.3167|-271.3167|-240|-180|-300|-120",
                        offsetIndices: "012132345464575454545454545454545455754545454545454545454545454545454545454545"
                    }, {
                        id: "Europe/Nicosia",
                        untils: "-p4bq6g|rvhxyg|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-133.4667|-120|-180",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Oslo",
                        untils: "-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Paris",
                        untils: "-uozn1x|2qx1lx|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|bko00|7rmo0|a2yo0|bvs00|6uao0|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51po0|5p8w0|18rcc0|7k800|9q000|9d1c0|7efo0|29k40|922w0|8l9c0|fxlx80|9cyk0|9q5k0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-9.35|0|-60|-120",
                        offsetIndices: "0121212121212121212121212121212121212121212121212123232332323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Podgorica",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Prague",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|b5uo0|7vc00|2vs40|4bk00|2vmk0|8n400|a2yo0|8n400|9o5c0|91xc0|fe6000|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120|0",
                        offsetIndices: "01010101010101010201010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Riga",
                        untils: "-qznlky|7x6o0|a4tc0|2mg00|3myns0|7fhlky|gz180|p5v40|7k800|9q000|9d1c0|9d1c0|k7s0|j14ns0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|asw00|7x6o0|asw00|7x6o0|b5uo0|qaao0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-96.5667|-156.5667|-120|-180|-60|-240",
                        offsetIndices: "010102324242435353535353535353323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Rome",
                        untils: "-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Samara",
                        untils: "-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|jt1g0|89zs0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",
                        offsets: "-200.3333|-180|-240|-300",
                        offsetIndices: "0123232323232323232121232323232323232323232323232323232323212"
                    }, {
                        id: "Europe/San_Marino",
                        untils: "-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Sarajevo",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Saratov",
                        untils: "-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|13m040|Infinity",
                        offsets: "-184.3|-180|-240|-300",
                        offsetIndices: "012323232323232321212121212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Simferopol",
                        untils: "-nu12ao|37a0qo|5xiyk0|iu340|7k800|9q000|9d1c0|iac0|jajmk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|eeio0|wrjw0|9cyk0|9d440|9cyk0|9d440|1sqk0|7k580|9d440|9cyk0|9q2s0|at4c0|7x9g0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x3w0|asqg0|Infinity",
                        offsets: "-136|-120|-180|-60|-240",
                        offsetIndices: "012131312424242424242424242121212424242212121212121212121212121212121212142"
                    }, {
                        id: "Europe/Skopje",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Sofia",
                        untils: "-e6dzw0|7k800|9q000|9d1c0|9d1c0|9d440|hqq240|9eys0|9o2k0|92040|9o2k0|90880|9pug0|90b00|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xhs0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-120|-60|-180",
                        offsetIndices: "01010102020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"
                    }, {
                        id: "Europe/Stockholm",
                        untils: "-rzo2w0|75hg0|x5bew0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Tallinn",
                        untils: "-r3exx0|3re10|7x6o0|et6g0|ygov0|a1zgd0|ktx80|l94g0|7k800|9q000|9d1c0|8uac0|j27mk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asys0|7x6o0|b5uo0|19dc00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-99|-60|-120|-180|-240",
                        offsetIndices: "012102321212343434343434343433232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Tirane",
                        untils: "-t85vo8|dt2gw8|18pew0|7k800|m800|g7ot40|7rjw0|autg0|7x3w0|ayis0|7x3w0|b5xg0|7k580|b42s0|7lzw0|b42s0|7lzw0|b42s0|7x3w0|ahus0|7x3w0|b5xg0|7x3w0|a4w40|8jbw0|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-79.3333|-60|-120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Tiraspol",
                        untils: "-r2p1bo|70f1to|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|geqo0|ha580|oc8g0|7k800|9q000|9d1c0|7cl00|j3pbw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|25p80|7kdk0|9d1c0|9d1c0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xf00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-115|-104.4|-120|-180|-60|-240",
                        offsetIndices: "012323232323232323232424235353535353535353535323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Ulyanovsk",
                        untils: "-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",
                        offsets: "-193.6|-180|-240|-300|-120",
                        offsetIndices: "01232323232323232321214121212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Uzhgorod",
                        untils: "-fizzw0|1cm000|7k800|9q000|9d1c0|al900|cnms0|int140|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|eeio0|e1sc0|iprk0|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120|-180|-240",
                        offsetIndices: "010101023232323232323232320121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Vaduz",
                        untils: "-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Vatican",
                        untils: "-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Vienna",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|t6000|8a5c0|a7a800|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|iio0|ivmo0|91xc0|9b6o0|9d1c0|a2yo0|8n400|gfyyg0|8zzw0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Vilnius",
                        untils: "-rns980|1g224o|e75nc|4kqk0|acbs40|gpp40|pits0|7k800|9q000|9d1c0|65zo0|j4vx80|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x9g0|asw00|7x6o0|b5uo0|1s3eo0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-84|-95.6|-60|-120|-180|-240",
                        offsetIndices: "012324323234545454545454545443434343434343434332334343434343434343434343434343434343434343434343434343434343434343434343"
                    }, {
                        id: "Europe/Volgograd",
                        untils: "-q3cw84|5glrw4|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|239c40|Infinity",
                        offsets: "-177.6667|-180|-240|-300",
                        offsetIndices: "012323232323232321212121212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Warsaw",
                        untils: "-se9yk0|dvyc0|7ves0|a4yw0|7x6o0|asw00|7x6o0|aunw0|7x6o0|1evbs0|9fcwc0|18cao0|7k800|9q000|9d1c0|9gnw0|an980|9kd80|8fs40|922w0|ar1c0|7x6o0|a2yo0|8n400|9q000|902o0|4013w0|64dc0|9d1c0|9d1c0|clpc0|6hc00|9d1c0|9d1c0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|clpc0|64dc0|6j4tc0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-84|-60|-120|-180",
                        offsetIndices: "012121223212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Zagreb",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Zaporozhye",
                        untils: "-nu12hc|37a0xc|5u1180|mc0g0|7k800|9q000|12qg0|jjc7s0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9cvs0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-140|-120|-180|-60|-240",
                        offsetIndices: "01213132424242424242424242422121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Zurich",
                        untils: "-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "GB-Eire",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "GB",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "GMT-0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "GMT",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "GMT+0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "GMT0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Greenwich",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Hongkong",
                        untils: "-y0i0s0|j44dk0|5k000|4d4y0|2195i0|7x3w0|bj320|6uao0|bvs00|7x6o0|9d1c0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|ast80|77c40|biqk0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",
                        offsets: "-456.7|-480|-540|-510",
                        offsetIndices: "0123212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "HST",
                        untils: "Infinity",
                        offsets: "600",
                        offsetIndices: "0"
                    }, {
                        id: "Iceland",
                        untils: "-wcwx9c|4rpd9c|ci2s0|69uk0|du840|4xp80|du840|p7bw0|4w040|9bdzw0|9d6w0|64g40|cyl80|64dc0|clpc0|6hc00|bvs00|6uao0|bvs00|6uao0|bvs00|6uao0|c8qo0|6hc00|c8qo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|Infinity",
                        offsets: "88|60|0",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Indian/Antananarivo",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Indian/Chagos",
                        untils: "-wvpc2s|1ag64us|Infinity",
                        offsets: "-289.6667|-300|-360",
                        offsetIndices: "012"
                    }, {
                        id: "Indian/Christmas",
                        untils: "Infinity",
                        offsets: "-420",
                        offsetIndices: "0"
                    }, {
                        id: "Indian/Cocos",
                        untils: "Infinity",
                        offsets: "-390",
                        offsetIndices: "0"
                    }, {
                        id: "Indian/Comoro",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Indian/Kerguelen",
                        untils: "-afrs00|Infinity",
                        offsets: "0|-300",
                        offsetIndices: "01"
                    }, {
                        id: "Indian/Mahe",
                        untils: "-x6pjlo|Infinity",
                        offsets: "-221.8|-240",
                        offsetIndices: "01"
                    }, {
                        id: "Indian/Maldives",
                        untils: "-57x6y0|Infinity",
                        offsets: "-294|-300",
                        offsetIndices: "01"
                    }, {
                        id: "Indian/Mauritius",
                        untils: "-wvp9bc|13jnu7c|8bx80|dd0wc0|7x3w0|Infinity",
                        offsets: "-230|-240|-300",
                        offsetIndices: "012121"
                    }, {
                        id: "Indian/Mayotte",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Indian/Reunion",
                        untils: "-uks29s|Infinity",
                        offsets: "-221.8667|-240",
                        offsetIndices: "01"
                    }, {
                        id: "Iran",
                        untils: "-s6m6uw|fnolc0|gm3h4w|777y0|b07w0|3pes0|42c20|9cyk0|9gtg0|9kd80|5ja5g0|7avw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|1av440|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|Infinity",
                        offsets: "-205.7333|-210|-240|-300|-270",
                        offsetIndices: "00123214141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141"
                    }, {
                        id: "Israel",
                        untils: "-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",
                        offsets: "-140.6667|-120|-180|-240",
                        offsetIndices: "012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Jamaica",
                        untils: "-u85og2|wbl182|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|Infinity",
                        offsets: "307.1667|300|240",
                        offsetIndices: "0121212121212121212121"
                    }, {
                        id: "Japan",
                        untils: "-bb4900|6uao0|afxc0|8a5c0|c8qo0|6hc00|c8qo0|6hc00|Infinity",
                        offsets: "-540|-600",
                        offsetIndices: "010101010"
                    }, {
                        id: "Kwajalein",
                        untils: "-h817w0|27sas0|1hjus0|ddxug0|cgv6k0|Infinity",
                        offsets: "-660|-600|-540|720|-720",
                        offsetIndices: "012034"
                    }, {
                        id: "Libya",
                        untils: "-q3gfrw|gl6ajw|422c0|xado0|4bbo0|wrpg0|4s580|1kdpg0|c05bw0|4mqs0|9et80|9d440|9et80|9eys0|9et80|9mdg0|95jw0|9io40|9cyk0|99es0|9et80|9eys0|9et80|9d440|9et80|b2840|3cf3w0|9kis0|9et80|7vqyw0|75eo0|asw00|Infinity",
                        offsets: "-52.7333|-60|-120",
                        offsetIndices: "012121212121212121212121212122122"
                    }, {
                        id: "MET",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Mexico/BajaNorte",
                        untils: "-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "468.0667|420|480",
                        offsetIndices: "012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Mexico/BajaSur",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "425.6667|420|360|480",
                        offsetIndices: "0121212131212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Mexico/General",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|3knek0|776k0|rf440|5t6k0|1evk40|71mk0|30p1g0|8n180|nufxo0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "396.6|420|360|300",
                        offsetIndices: "012121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "MST",
                        untils: "Infinity",
                        offsets: "420",
                        offsetIndices: "0"
                    }, {
                        id: "MST7MDT",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Navajo",
                        untils: "-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "NZ-CHAT",
                        untils: "-ciya10|f1tq90|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-735|-765|-825",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "NZ",
                        untils: "-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-690|-750|-720|-780",
                        offsetIndices: "01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Pacific/Apia",
                        untils: "-usiiv4|kcrmt4|vp3la0|9odo0|902o0|4zbk0|4qog0|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "686.9333|690|660|600|-840|-780",
                        offsetIndices: "01232345454545454545454545454545454545454545454545454545454"
                    }, {
                        id: "Pacific/Auckland",
                        untils: "-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-690|-750|-720|-780",
                        offsetIndices: "01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Pacific/Bougainville",
                        untils: "-ecsh40|1n05g0|1071c40|Infinity",
                        offsets: "-600|-540|-660",
                        offsetIndices: "0102"
                    }, {
                        id: "Pacific/Chatham",
                        untils: "-ciya10|f1tq90|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-735|-765|-825",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Pacific/Chuuk",
                        untils: "-su4zs0|29hes0|bkenw0|29fk40|Infinity",
                        offsets: "-600|-540",
                        offsetIndices: "01010"
                    }, {
                        id: "Pacific/Easter",
                        untils: "-jhfaew|ivmeuw|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|iq2o0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "437.4667|420|360|300",
                        offsetIndices: "012121212121212121212121212123232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Pacific/Efate",
                        untils: "-u964i4|11f4ba4|9cyk0|awo40|7tek0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|64ak0|e1ms0|4ofw0|Infinity",
                        offsets: "-673.2667|-660|-720",
                        offsetIndices: "0121212121212121212121"
                    }, {
                        id: "Pacific/Enderbury",
                        untils: "535io0|7yiqk0|Infinity",
                        offsets: "720|660|-780",
                        offsetIndices: "012"
                    }, {
                        id: "Pacific/Fakaofo",
                        untils: "lx0jw0|Infinity",
                        offsets: "660|-780",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Fiji",
                        untils: "-sa2x4w|17bs00w|64dc0|cyo00|5reo0|53a5c0|64dc0|asw00|6uao0|bvs00|4oio0|e1k00|4oio0|eeio0|4bh80|erk40|3ylc0|erhc0|3ylc0|f4g00|3lmo0|f4g00|3lmo0|f4g00|3lmo0|fheo0|38o00|fheo0|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|f4g00|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|f4g00|3lmo0|Infinity",
                        offsets: "-715.7333|-720|-780",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Pacific/Funafuti",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Galapagos",
                        untils: "-kcr62o|spdryo|3lsas0|3jp80|Infinity",
                        offsets: "358.4|300|360",
                        offsetIndices: "01212"
                    }, {
                        id: "Pacific/Gambier",
                        untils: "-tvndoc|Infinity",
                        offsets: "539.8|540",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Guadalcanal",
                        untils: "-tvowac|Infinity",
                        offsets: "-639.8|-660",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Guam",
                        untils: "-en8eg0|1dl9g0|7s1k40|txp80|3frms0|qdrpo|7kgac|3ljw0|c8tg0|6u7w0|bvus0|6u7w0|16uo40|3ljw0|16aas0|4ivxo|cls2c|6h980|c65zw0|Infinity",
                        offsets: "-600|-540|-660",
                        offsetIndices: "01020202020202020200"
                    }, {
                        id: "Pacific/Honolulu",
                        untils: "-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",
                        offsets: "630|570|600",
                        offsetIndices: "0101102"
                    }, {
                        id: "Pacific/Johnston",
                        untils: "-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",
                        offsets: "630|570|600",
                        offsetIndices: "0101102"
                    }, {
                        id: "Pacific/Kiritimati",
                        untils: "535eyo|7yirhc|Infinity",
                        offsets: "640|600|-840",
                        offsetIndices: "012"
                    }, {
                        id: "Pacific/Kosrae",
                        untils: "-su52k0|29hhk0|9cmd40|27sas0|29fk40|cm2540|f9l3w0|Infinity",
                        offsets: "-660|-540|-600|-720",
                        offsetIndices: "01021030"
                    }, {
                        id: "Pacific/Kwajalein",
                        untils: "-h817w0|27sas0|1hjus0|ddxug0|cgv6k0|Infinity",
                        offsets: "-660|-600|-540|720|-720",
                        offsetIndices: "012034"
                    }, {
                        id: "Pacific/Majuro",
                        untils: "-su52k0|29hhk0|9cmd40|27sas0|1h6w40|deat40|Infinity",
                        offsets: "-660|-540|-600|-720",
                        offsetIndices: "0102103"
                    }, {
                        id: "Pacific/Marquesas",
                        untils: "-tvncu0|Infinity",
                        offsets: "558|570",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Midway",
                        untils: "-usij20|Infinity",
                        offsets: "682.8|660",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Nauru",
                        untils: "-pjxiws|ba66ys|1kwca0|hfzda0|Infinity",
                        offsets: "-667.6667|-690|-540|-720",
                        offsetIndices: "01213"
                    }, {
                        id: "Pacific/Niue",
                        untils: "-9wyz6o|ehcj4o|Infinity",
                        offsets: "680|690|660",
                        offsetIndices: "012"
                    }, {
                        id: "Pacific/Norfolk",
                        untils: "-9x0ps0|cfj8q0|6hc00|l6nk00|239aq0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-672|-690|-750|-660|-720",
                        offsetIndices: "012134343434343434343434343434343434343434"
                    }, {
                        id: "Pacific/Noumea",
                        untils: "-u9645o|ye0ixo|4dbw0|ecqs0|4f6k0|99p700|4oio0|Infinity",
                        offsets: "-665.8|-660|-720",
                        offsetIndices: "01212121"
                    }, {
                        id: "Pacific/Pago_Pago",
                        untils: "-usij20|Infinity",
                        offsets: "682.8|660",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Palau",
                        untils: "Infinity",
                        offsets: "-540",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Pitcairn",
                        untils: "es2cy0|Infinity",
                        offsets: "510|480",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Pohnpei",
                        untils: "-su52k0|29hhk0|9cmd40|27sas0|29fk40|Infinity",
                        offsets: "-660|-540|-600",
                        offsetIndices: "010210"
                    }, {
                        id: "Pacific/Ponape",
                        untils: "-su52k0|29hhk0|9cmd40|27sas0|29fk40|Infinity",
                        offsets: "-660|-540|-600",
                        offsetIndices: "010210"
                    }, {
                        id: "Pacific/Port_Moresby",
                        untils: "Infinity",
                        offsets: "-600",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Rarotonga",
                        untils: "4mj960|5rbw0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|Infinity",
                        offsets: "630|570|600",
                        offsetIndices: "012121212121212121212121212"
                    }, {
                        id: "Pacific/Saipan",
                        untils: "-en8eg0|1dl9g0|7s1k40|txp80|3frms0|qdrpo|7kgac|3ljw0|c8tg0|6u7w0|bvus0|6u7w0|16uo40|3ljw0|16aas0|4ivxo|cls2c|6h980|c65zw0|Infinity",
                        offsets: "-600|-540|-660",
                        offsetIndices: "01020202020202020200"
                    }, {
                        id: "Pacific/Samoa",
                        untils: "-usij20|Infinity",
                        offsets: "682.8|660",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Tahiti",
                        untils: "-tvnayw|Infinity",
                        offsets: "598.2667|600",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Tarawa",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Tongatapu",
                        untils: "-f4vrlc|uo2edc|8fpc0|bvs00|4bh80|eelg0|4bh80|7pmis0|3lmo0|Infinity",
                        offsets: "-740|-780|-840",
                        offsetIndices: "0121212121"
                    }, {
                        id: "Pacific/Truk",
                        untils: "-su4zs0|29hes0|bkenw0|29fk40|Infinity",
                        offsets: "-600|-540",
                        offsetIndices: "01010"
                    }, {
                        id: "Pacific/Wake",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Wallis",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Yap",
                        untils: "-su4zs0|29hes0|bkenw0|29fk40|Infinity",
                        offsets: "-600|-540",
                        offsetIndices: "01010"
                    }, {
                        id: "Poland",
                        untils: "-se9yk0|dvyc0|7ves0|a4yw0|7x6o0|asw00|7x6o0|aunw0|7x6o0|1evbs0|9fcwc0|18cao0|7k800|9q000|9d1c0|9gnw0|an980|9kd80|8fs40|922w0|ar1c0|7x6o0|a2yo0|8n400|9q000|902o0|4013w0|64dc0|9d1c0|9d1c0|clpc0|6hc00|9d1c0|9d1c0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|clpc0|64dc0|6j4tc0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-84|-60|-120|-180",
                        offsetIndices: "012121223212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Portugal",
                        untils: "-u9rhc0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5gyl40|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "36.75|0|-60|-120",
                        offsetIndices: "012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121212121212121212121212121212121212122323232212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "PRC",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "PST8PDT",
                        untils: "-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "ROC",
                        untils: "-gtzfk0|45slc0|c51c0|75bw0|a31g0|aaak0|9d440|7v980|awo40|7v980|awo40|7v980|awo40|7v980|7tk40|clmk0|7rpg0|b07w0|7rpg0|b07w0|7rpg0|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|cjxg0|69uk0|ci2s0|69uk0|6its40|9et80|9d440|9et80|1yf9g0|4qak0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010101010101010"
                    }, {
                        id: "ROK",
                        untils: "-w8966g|1yh18g|hkx5a0|1faao0|5cik0|ae5g0|8a2k0|ae5g0|8bx80|c8tg0|6h980|1bj6s0|l3aq0|6j3w0|d2g40|6u7w0|b5xg0|776k0|biw40|776k0|biw40|776k0|biw40|776k0|grs40|dfqxi0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-507.8667|-510|-540|-600|-570",
                        offsetIndices: "012232323232141414141414123232"
                    }, {
                        id: "Singapore",
                        untils: "-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",
                        offsets: "-415.4167|-420|-440|-450|-540|-480",
                        offsetIndices: "0123435"
                    }, {
                        id: "Turkey",
                        untils: "-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",
                        offsets: "-116.9333|-120|-180|-240",
                        offsetIndices: "0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"
                    }, {
                        id: "UCT",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Universal",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "US/Alaska",
                        untils: "-ek1qo0|1tyx80|2e400|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "600|540|480",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "US/Aleutian",
                        untils: "-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "660|600|540",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "US/Arizona",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|zjedo|4olg0|9et80|bs6lmc|9cyk0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101010"
                    }, {
                        id: "US/Central",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bvus0|776k0|7kas0|b5rw0|9d440|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|7x9g0|dbjw0|8a840|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/East-Indiana",
                        untils: "-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "US/Eastern",
                        untils: "-r0ev80|ast80|7x9g0|ast80|7x9g0|b5rw0|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tzb40|2dq40|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Hawaii",
                        untils: "-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",
                        offsets: "630|570|600",
                        offsetIndices: "0101102"
                    }, {
                        id: "US/Indiana-Starke",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Michigan",
                        untils: "-xx8dyd|5eraud|dyeyk0|1tzb40|2dq40|1c9440|7x3w0|9rlbxo|71s2c|9d440|9cyk0|2cmdg0|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "332.1833|360|300|240",
                        offsetIndices: "0123323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "US/Mountain",
                        untils: "-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Pacific-New",
                        untils: "-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Pacific",
                        untils: "-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Samoa",
                        untils: "-usij20|Infinity",
                        offsets: "682.8|660",
                        offsetIndices: "01"
                    }, {
                        id: "UTC",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "W-SU",
                        untils: "-rx5dmh|ipzua|97hc0|7yyk0|5i840|d9p80|1jwk7|2cvk0|s8o00|1qvw0|8fpc0|1jms0|is040|412as0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-150.2833|-151.3167|-211.3167|-271.3167|-240|-180|-300|-120",
                        offsetIndices: "012132345464575454545454545454545455754545454545454545454545454545454545454545"
                    }, {
                        id: "WET",
                        untils: "3s9ms0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Zulu",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }]
                }
            },
        41690:
            /*!*************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/chart_components/m_advanced_chart.js ***!
              \*************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.AdvancedChart = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _extend2 = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _base_axis = __webpack_require__( /*! ../../../viz/axes/base_axis */ 41278);
                var _series_family = __webpack_require__( /*! ../../../viz/core/series_family */ 1939);
                var _utils = __webpack_require__( /*! ../../../viz/core/utils */ 19157);
                var _range_data_calculator = (obj = __webpack_require__( /*! ../../../viz/series/helpers/range_data_calculator */ 63407), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _range = __webpack_require__( /*! ../../../viz/translators/range */ 21177);
                var _m_base_chart = __webpack_require__( /*! ./m_base_chart */ 14107);

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _defineProperty(obj, key, value) {
                    key = function(arg) {
                        var key = function(input, hint) {
                            if ("object" !== _typeof(input) || null === input) {
                                return input
                            }
                            var prim = input[Symbol.toPrimitive];
                            if (void 0 !== prim) {
                                var res = prim.call(input, hint || "default");
                                if ("object" !== _typeof(res)) {
                                    return res
                                }
                                throw new TypeError("@@toPrimitive must return a primitive value.")
                            }
                            return ("string" === hint ? String : Number)(input)
                        }(arg, "string");
                        return "symbol" === _typeof(key) ? key : String(key)
                    }(key);
                    if (key in obj) {
                        Object.defineProperty(obj, key, {
                            value: value,
                            enumerable: true,
                            configurable: true,
                            writable: true
                        })
                    } else {
                        obj[key] = value
                    }
                    return obj
                }
                var isArray = Array.isArray;

                function prepareAxis(axisOptions) {
                    if (isArray(axisOptions)) {
                        return 0 === axisOptions.length ? [{}] : axisOptions
                    }
                    return [axisOptions]
                }

                function setAxisVisualRangeByOption(arg, axis, isDirectOption, index) {
                    var options;
                    var visualRange;
                    if (isDirectOption) {
                        visualRange = arg.value;
                        options = {
                            skipEventRising: true
                        };
                        var wrappedVisualRange = wrapVisualRange(arg.fullName, visualRange);
                        if (wrappedVisualRange) {
                            options = {
                                allowPartialUpdate: true
                            };
                            visualRange = wrappedVisualRange
                        }
                    } else {
                        visualRange = ((0, _type.isDefined)(index) ? arg.value[index] : arg.value).visualRange
                    }
                    axis.visualRange(visualRange, options)
                }

                function wrapVisualRange(fullName, value) {
                    var pathElements = fullName.split(".");
                    var destElem = pathElements.at(-1);
                    if ("endValue" === destElem || "startValue" === destElem) {
                        return _defineProperty({}, destElem, value)
                    }
                    return
                }
                var AdvancedChart = _m_base_chart.BaseChart.inherit({
                    _fontFields: ["".concat("commonAxisSettings", ".label.").concat("font"), "".concat("commonAxisSettings", ".title.").concat("font")],
                    _partialOptionChangesMap: {
                        visualRange: "VISUAL_RANGE",
                        _customVisualRange: "VISUAL_RANGE",
                        strips: "REFRESH_AXES",
                        constantLines: "REFRESH_AXES"
                    },
                    _partialOptionChangesPath: {
                        argumentAxis: ["strips", "constantLines", "visualRange", "_customVisualRange"],
                        valueAxis: ["strips", "constantLines", "visualRange", "_customVisualRange"]
                    },
                    _initCore: function() {
                        this._panesClipRects = {};
                        this.callBase()
                    },
                    _disposeCore: function() {
                        var disposeObjectsInArray = this._disposeObjectsInArray;
                        var panesClipRects = this._panesClipRects;
                        this.callBase();
                        disposeObjectsInArray.call(panesClipRects, "fixed");
                        disposeObjectsInArray.call(panesClipRects, "base");
                        disposeObjectsInArray.call(panesClipRects, "wide");
                        this._panesClipRects = null;
                        this._labelsAxesGroup.linkOff();
                        this._labelsAxesGroup.dispose();
                        this._labelsAxesGroup = null
                    },
                    _dispose: function() {
                        var disposeObjectsInArray = this._disposeObjectsInArray;
                        this.callBase();
                        this.panes = null;
                        if (this._legend) {
                            this._legend.dispose();
                            this._legend = null
                        }
                        disposeObjectsInArray.call(this, "panesBackground");
                        disposeObjectsInArray.call(this, "seriesFamilies");
                        this._disposeAxes()
                    },
                    _createPanes: function() {
                        this._cleanPanesClipRects("fixed");
                        this._cleanPanesClipRects("base");
                        this._cleanPanesClipRects("wide")
                    },
                    _cleanPanesClipRects: function(clipArrayName) {
                        var clipArray = this._panesClipRects[clipArrayName];
                        (clipArray || []).forEach((function(clipRect) {
                            null === clipRect || void 0 === clipRect ? void 0 : clipRect.dispose()
                        }));
                        this._panesClipRects[clipArrayName] = []
                    },
                    _getElementsClipRectID: function(paneName) {
                        var clipShape = this._panesClipRects.fixed[this._getPaneIndex(paneName)];
                        return null === clipShape || void 0 === clipShape ? void 0 : clipShape.id
                    },
                    _getPaneIndex: function(paneName) {
                        var name = paneName || "default";
                        return this.panes.findIndex((function(pane) {
                            return pane.name === name
                        }))
                    },
                    _updateSize: function() {
                        this.callBase();
                        (0, _utils.setCanvasValues)(this._canvas)
                    },
                    _reinitAxes: function() {
                        this.panes = this._createPanes();
                        this._populateAxes();
                        this._axesReinitialized = true
                    },
                    _populateAxes: function() {
                        var _this = this;
                        var panes = this.panes;
                        var rotated = this._isRotated();
                        var argumentAxesOptions = prepareAxis(this.option("argumentAxis") || {})[0];
                        var valueAxisOption = this.option("valueAxis");
                        var valueAxesOptions = prepareAxis(valueAxisOption || {});
                        var argumentAxesPopulatedOptions;
                        var valueAxesPopulatedOptions = [];
                        var axisNames = [];
                        var valueAxesCounter = 0;
                        var paneWithNonVirtualAxis;
                        var crosshairMargins = this._getCrosshairMargins();

                        function getNextAxisName() {
                            var name = "defaultAxisName" + String(valueAxesCounter);
                            valueAxesCounter += 1;
                            return name
                        }
                        if (rotated) {
                            paneWithNonVirtualAxis = "right" === argumentAxesOptions.position ? panes[panes.length - 1].name : panes[0].name
                        } else {
                            paneWithNonVirtualAxis = "top" === argumentAxesOptions.position ? panes[0].name : panes[panes.length - 1].name
                        }
                        argumentAxesPopulatedOptions = (0, _utils.map)(panes, (function(pane) {
                            var virtual = pane.name !== paneWithNonVirtualAxis;
                            return _this._populateAxesOptions("argumentAxis", argumentAxesOptions, {
                                pane: pane.name,
                                name: null,
                                optionPath: "argumentAxis",
                                crosshairMargin: rotated ? crosshairMargins.x : crosshairMargins.y
                            }, rotated, virtual)
                        }));
                        valueAxesOptions.forEach((function(axisOptions, priority) {
                            var _a;
                            var axisPanes = [];
                            var name = axisOptions.name;
                            if (name && axisNames.includes(name)) {
                                _this._incidentOccurred("E2102");
                                return
                            }
                            if (name) {
                                axisNames.push(name)
                            }
                            if (axisOptions.pane) {
                                axisPanes.push(axisOptions.pane)
                            }
                            if (null === (_a = axisOptions.panes) || void 0 === _a ? void 0 : _a.length) {
                                axisPanes = axisPanes.concat(axisOptions.panes.slice(0))
                            }
                            axisPanes = (0, _utils.unique)(axisPanes);
                            if (!axisPanes.length) {
                                axisPanes.push(void 0)
                            }
                            axisPanes.forEach((function(pane) {
                                var optionPath = isArray(valueAxisOption) ? "valueAxis[".concat(String(priority), "]") : "valueAxis";
                                valueAxesPopulatedOptions.push(_this._populateAxesOptions("valueAxis", axisOptions, {
                                    name: name || getNextAxisName(),
                                    pane: pane,
                                    priority: priority,
                                    optionPath: optionPath,
                                    crosshairMargin: rotated ? crosshairMargins.y : crosshairMargins.x
                                }, rotated))
                            }))
                        }));
                        this._redesignAxes(argumentAxesPopulatedOptions, true, paneWithNonVirtualAxis);
                        this._redesignAxes(valueAxesPopulatedOptions, false)
                    },
                    _redesignAxes: function(options, isArgumentAxes, paneWithNonVirtualAxis) {
                        var _this2 = this;
                        var axesBasis = [];
                        var axes = isArgumentAxes ? this._argumentAxes : this._valueAxes;
                        options.forEach((function(opt) {
                            var curAxes = null === axes || void 0 === axes ? void 0 : axes.filter((function(a) {
                                return a.name === opt.name && (!(0, _type.isDefined)(opt.pane) && _this2.panes.some((function(p) {
                                    return p.name === a.pane
                                })) || a.pane === opt.pane)
                            }));
                            if (null === curAxes || void 0 === curAxes ? void 0 : curAxes.length) {
                                curAxes.forEach((function(axis) {
                                    var axisTypes = function(groupsData, axis, isArgumentAxes) {
                                        if (isArgumentAxes) {
                                            return {
                                                argumentAxisType: groupsData.argumentAxisType,
                                                argumentType: groupsData.argumentType
                                            }
                                        }
                                        var _groupsData$groups$fi = groupsData.groups.find((function(g) {
                                                return g.valueAxis === axis
                                            })),
                                            valueAxisType = _groupsData$groups$fi.valueAxisType,
                                            valueType = _groupsData$groups$fi.valueType;
                                        return {
                                            valueAxisType: valueAxisType,
                                            valueType: valueType
                                        }
                                    }(_this2._groupsData, axis, isArgumentAxes);
                                    axis.updateOptions(opt);
                                    if (isArgumentAxes) {
                                        axis.setTypes(axisTypes.argumentAxisType, axisTypes.argumentType, "argumentType")
                                    } else {
                                        axis.setTypes(axisTypes.valueAxisType, axisTypes.valueType, "valueType")
                                    }
                                    axis.validate();
                                    axesBasis.push({
                                        axis: axis
                                    })
                                }))
                            } else {
                                axesBasis.push({
                                    options: opt
                                })
                            }
                        }));
                        if (axes) {
                            (0, _iterator.reverseEach)(axes, (function(index, axis) {
                                if (!axesBasis.some((function(basis) {
                                        return basis.axis && basis.axis === axis
                                    }))) {
                                    _this2._disposeAxis(index, isArgumentAxes)
                                }
                            }))
                        } else if (isArgumentAxes) {
                            axes = this._argumentAxes = []
                        } else {
                            axes = this._valueAxes = []
                        }
                        axesBasis.forEach((function(basis) {
                            var axis = basis.axis;
                            if (basis.axis && isArgumentAxes) {
                                basis.axis.isVirtual = basis.axis.pane !== paneWithNonVirtualAxis
                            } else if (basis.options) {
                                axis = _this2._createAxis(isArgumentAxes, basis.options, isArgumentAxes ? basis.options.pane !== paneWithNonVirtualAxis : void 0);
                                axes.push(axis)
                            }
                            axis.applyVisualRangeSetter(_this2._getVisualRangeSetter())
                        }))
                    },
                    _disposeAxis: function(index, isArgumentAxis) {
                        var axes = isArgumentAxis ? this._argumentAxes : this._valueAxes;
                        var axis = axes[index];
                        if (!axis) {
                            return
                        }
                        axis.dispose();
                        axes.splice(index, 1)
                    },
                    _disposeAxes: function() {
                        var disposeObjectsInArray = this._disposeObjectsInArray;
                        disposeObjectsInArray.call(this, "_argumentAxes");
                        disposeObjectsInArray.call(this, "_valueAxes")
                    },
                    _appendAdditionalSeriesGroups: function() {
                        this._crosshairCursorGroup.linkAppend();
                        if (this._scrollBar) {
                            this._scrollBarGroup.linkAppend()
                        }
                    },
                    _getLegendTargets: function() {
                        var _this3 = this;
                        return (this.series || []).map((function(s) {
                            var item = _this3._getLegendOptions(s);
                            item.legendData.series = s;
                            if (!s.getOptions().showInLegend) {
                                item.legendData.visible = false
                            }
                            return item
                        }))
                    },
                    _legendItemTextField: "name",
                    _seriesPopulatedHandlerCore: function() {
                        this._processSeriesFamilies();
                        this._processValueAxisFormat()
                    },
                    _renderTrackers: function() {
                        for (var i = 0; i < this.series.length; i += 1) {
                            this.series[i].drawTrackers()
                        }
                    },
                    _specialProcessSeries: function() {
                        this._processSeriesFamilies()
                    },
                    _processSeriesFamilies: function() {
                        var _this4 = this;
                        var _a;
                        var types = [];
                        var families = [];
                        var paneSeries;
                        var themeManager = this._themeManager;
                        var negativesAsZeroes = themeManager.getOptions("negativesAsZeroes");
                        var negativesAsZeros = themeManager.getOptions("negativesAsZeros");
                        var familyOptions = {
                            minBubbleSize: themeManager.getOptions("minBubbleSize"),
                            maxBubbleSize: themeManager.getOptions("maxBubbleSize"),
                            barGroupPadding: themeManager.getOptions("barGroupPadding"),
                            barGroupWidth: themeManager.getOptions("barGroupWidth"),
                            negativesAsZeroes: (0, _type.isDefined)(negativesAsZeroes) ? negativesAsZeroes : negativesAsZeros
                        };
                        if (null === (_a = this.seriesFamilies) || void 0 === _a ? void 0 : _a.length) {
                            this.seriesFamilies.forEach((function(family) {
                                family.updateOptions(familyOptions);
                                family.adjustSeriesValues()
                            }));
                            return
                        }
                        this.series.forEach((function(item) {
                            if (!types.includes(item.type)) {
                                types.push(item.type)
                            }
                        }));
                        this._getLayoutTargets().forEach((function(pane) {
                            paneSeries = _this4._getSeriesForPane(pane.name);
                            types.forEach((function(type) {
                                var family = new _series_family.SeriesFamily({
                                    type: type,
                                    pane: pane.name,
                                    minBubbleSize: familyOptions.minBubbleSize,
                                    maxBubbleSize: familyOptions.maxBubbleSize,
                                    barGroupPadding: familyOptions.barGroupPadding,
                                    barGroupWidth: familyOptions.barGroupWidth,
                                    negativesAsZeroes: familyOptions.negativesAsZeroes,
                                    rotated: _this4._isRotated()
                                });
                                family.add(paneSeries);
                                family.adjustSeriesValues();
                                families.push(family)
                            }))
                        }));
                        this.seriesFamilies = families
                    },
                    _updateSeriesDimensions: function() {
                        var seriesFamilies = this.seriesFamilies || [];
                        for (var i = 0; i < seriesFamilies.length; i += 1) {
                            var family = seriesFamilies[i];
                            family.updateSeriesValues();
                            family.adjustSeriesDimensions()
                        }
                    },
                    _getLegendCallBack: function(series) {
                        var _a;
                        return null === (_a = this._legend) || void 0 === _a ? void 0 : _a.getActionCallback(series)
                    },
                    _appendAxesGroups: function() {
                        this._stripsGroup.linkAppend();
                        this._gridGroup.linkAppend();
                        this._axesGroup.linkAppend();
                        this._labelsAxesGroup.linkAppend();
                        this._constantLinesGroup.linkAppend();
                        this._stripLabelAxesGroup.linkAppend();
                        this._scaleBreaksGroup.linkAppend()
                    },
                    _populateMarginOptions: function() {
                        var _this5 = this;
                        var bubbleSize = (size = this.getSize(), panesCount = this.panes.length, maxSize = this._themeManager.getOptions("maxBubbleSize"), rotated = this._isRotated(), width = rotated ? size.width / panesCount : size.width, height = rotated ? size.height : size.height / panesCount, Math.min(width, height) * maxSize);
                        var size, panesCount, maxSize, rotated, width, height;
                        var argumentMarginOptions = {};
                        this._valueAxes.forEach((function(valueAxis) {
                            var groupSeries = _this5.series.filter((function(series) {
                                return series.getValueAxis() === valueAxis
                            }));
                            var marginOptions = {};
                            groupSeries.forEach((function(series) {
                                if (series.isVisible()) {
                                    var seriesMarginOptions = function(marginOptions, bubbleSize) {
                                        if (marginOptions.processBubbleSize) {
                                            marginOptions.size = bubbleSize
                                        }
                                        return marginOptions
                                    }(series.getMarginOptions(), bubbleSize);
                                    marginOptions = (0, _utils.mergeMarginOptions)(marginOptions, seriesMarginOptions);
                                    argumentMarginOptions = (0, _utils.mergeMarginOptions)(argumentMarginOptions, seriesMarginOptions)
                                }
                            }));
                            valueAxis.setMarginOptions(marginOptions)
                        }));
                        this._argumentAxes.forEach((function(a) {
                            return a.setMarginOptions(argumentMarginOptions)
                        }))
                    },
                    _populateBusinessRange: function(updatedAxis, keepRange) {
                        var _this6 = this;
                        var rotated = this._isRotated();
                        var series = this._getVisibleSeries();
                        var argRanges = {};
                        var commonArgRange = new _range.Range({
                            rotated: !!rotated
                        });
                        var getPaneName = function(axis) {
                            return axis.pane || "default"
                        };
                        this.panes.forEach((function(p) {
                            argRanges[p.name] = new _range.Range({
                                rotated: !!rotated
                            })
                        }));
                        this._valueAxes.forEach((function(valueAxis) {
                            var groupRange = new _range.Range({
                                rotated: !!rotated,
                                pane: valueAxis.pane,
                                axis: valueAxis.name
                            });
                            var groupSeries = series.filter((function(series) {
                                return series.getValueAxis() === valueAxis
                            }));
                            groupSeries.forEach((function(series) {
                                var seriesRange = series.getRangeData();
                                groupRange.addRange(seriesRange.val);
                                argRanges[getPaneName(valueAxis)].addRange(seriesRange.arg)
                            }));
                            if (!updatedAxis || updatedAxis && groupSeries.length && valueAxis === updatedAxis) {
                                valueAxis.setGroupSeries(groupSeries);
                                valueAxis.setBusinessRange(groupRange, _this6._axesReinitialized || keepRange, _this6._argumentAxes[0]._lastVisualRangeUpdateMode)
                            }
                        }));
                        if (!updatedAxis || updatedAxis && series.length) {
                            Object.keys(argRanges).forEach((function(p) {
                                return commonArgRange.addRange(argRanges[p])
                            }));
                            var commonInterval = commonArgRange.interval;
                            this._argumentAxes.forEach((function(a) {
                                var _a;
                                var currentInterval = null !== (_a = argRanges[getPaneName(a)].interval) && void 0 !== _a ? _a : commonInterval;
                                a.setBusinessRange(new _range.Range(_extends(_extends({}, commonArgRange), {
                                    interval: currentInterval
                                })), _this6._axesReinitialized, void 0, _this6._groupsData.categories)
                            }))
                        }
                        this._populateMarginOptions()
                    },
                    getArgumentAxis: function() {
                        return (this._argumentAxes || []).find((function(a) {
                            return !a.isVirtual
                        }))
                    },
                    getValueAxis: function(name) {
                        var _this7 = this;
                        return (this._valueAxes || []).find((0, _type.isDefined)(name) ? function(a) {
                            return a.name === name
                        } : function(a) {
                            return a.pane === _this7.defaultPane
                        })
                    },
                    _getGroupsData: function() {
                        var _this8 = this;
                        var groups = [];
                        this._valueAxes.forEach((function(axis) {
                            groups.push({
                                series: _this8.series.filter((function(series) {
                                    return series.getValueAxis() === axis
                                })),
                                valueAxis: axis,
                                valueOptions: axis.getOptions()
                            })
                        }));
                        return {
                            groups: groups,
                            argumentAxes: this._argumentAxes,
                            argumentOptions: this._argumentAxes[0].getOptions()
                        }
                    },
                    _groupSeries: function() {
                        this._correctValueAxes(false);
                        this._groupsData = this._getGroupsData()
                    },
                    _processValueAxisFormat: function() {
                        var axesWithFullStackedFormat = [];
                        this.series.forEach((function(series) {
                            var axis = series.getValueAxis();
                            if (series.isFullStackedSeries()) {
                                axis.setPercentLabelFormat();
                                axesWithFullStackedFormat.push(axis)
                            }
                        }));
                        this._valueAxes.forEach((function(axis) {
                            if (!axesWithFullStackedFormat.includes(axis)) {
                                axis.resetAutoLabelFormat()
                            }
                        }))
                    },
                    _populateAxesOptions: function(typeSelector, userOptions, axisOptions, rotated, virtual) {
                        var preparedUserOptions = this._prepareStripsAndConstantLines(typeSelector, userOptions, rotated);
                        var options = (0, _extend2.extend)(true, {}, preparedUserOptions, axisOptions, this._prepareAxisOptions(typeSelector, preparedUserOptions, rotated));
                        if (virtual) {
                            options.visible = false;
                            options.tick.visible = false;
                            options.minorTick.visible = false;
                            options.label.visible = false;
                            options.title = {}
                        }
                        return options
                    },
                    _getValFilter: function(series) {
                        return _range_data_calculator.default.getViewPortFilter(series.getValueAxis().visualRange() || {})
                    },
                    _createAxis: function(isArgumentAxes, options, virtual) {
                        var _this9 = this;
                        var typeSelector = isArgumentAxes ? "argumentAxis" : "valueAxis";
                        var renderingSettings = (0, _extend2.extend)({
                            renderer: this._renderer,
                            incidentOccurred: this._incidentOccurred,
                            eventTrigger: this._eventTrigger,
                            axisClass: isArgumentAxes ? "arg" : "val",
                            widgetClass: "dxc",
                            stripsGroup: this._stripsGroup,
                            stripLabelAxesGroup: this._stripLabelAxesGroup,
                            constantLinesGroup: this._constantLinesGroup,
                            scaleBreaksGroup: this._scaleBreaksGroup,
                            axesContainerGroup: this._axesGroup,
                            labelsAxesGroup: this._labelsAxesGroup,
                            gridGroup: this._gridGroup,
                            isArgumentAxis: isArgumentAxes,
                            getTemplate: function(template) {
                                return _this9._getTemplate(template)
                            }
                        }, this._getAxisRenderingOptions(typeSelector));
                        var axis = new _base_axis.Axis(renderingSettings);
                        axis.updateOptions(options);
                        axis.isVirtual = virtual;
                        return axis
                    },
                    _applyVisualRangeByVirtualAxes: function() {
                        return false
                    },
                    _applyCustomVisualRangeOption: function(axis, range) {
                        if (axis.getOptions().optionPath) {
                            this._parseVisualRangeOption("".concat(axis.getOptions().optionPath, ".visualRange"), range)
                        }
                    },
                    _getVisualRangeSetter: function() {
                        var _this10 = this;
                        return function(axis, _ref2) {
                            var skipEventRising = _ref2.skipEventRising,
                                range = _ref2.range;
                            _this10._applyCustomVisualRangeOption(axis, range);
                            axis.setCustomVisualRange(range);
                            axis.skipEventRising = skipEventRising;
                            if (!_this10._applyVisualRangeByVirtualAxes(axis, range)) {
                                if (_this10._applyingChanges) {
                                    _this10._change_VISUAL_RANGE()
                                } else {
                                    _this10._requestChange(["VISUAL_RANGE"])
                                }
                            }
                        }
                    },
                    _getTrackerSettings: function() {
                        return (0, _extend2.extend)(this.callBase(), {
                            argumentAxis: this.getArgumentAxis()
                        })
                    },
                    _prepareStripsAndConstantLines: function(typeSelector, userOptions, rotated) {
                        userOptions = this._themeManager.getOptions(typeSelector, userOptions, rotated);
                        if (userOptions.strips) {
                            userOptions.strips.forEach((function(line, i) {
                                userOptions.strips[i] = (0, _extend2.extend)(true, {}, userOptions.stripStyle, line)
                            }))
                        }
                        if (userOptions.constantLines) {
                            userOptions.constantLines.forEach((function(line, i) {
                                userOptions.constantLines[i] = (0, _extend2.extend)(true, {}, userOptions.constantLineStyle, line)
                            }))
                        }
                        return userOptions
                    },
                    refresh: function() {
                        this._disposeAxes();
                        this.callBase()
                    },
                    _layoutAxes: function(drawAxes) {
                        drawAxes();
                        var needSpace = this.checkForMoreSpaceForPanesCanvas();
                        if (needSpace) {
                            var rect = this._rect.slice();
                            var size = this._layout.backward(rect, rect, [needSpace.width, needSpace.height]);
                            needSpace.width = Math.max(0, size[0]);
                            needSpace.height = Math.max(0, size[1]);
                            this._canvas = this._createCanvasFromRect(rect);
                            drawAxes(needSpace)
                        }
                    },
                    checkForMoreSpaceForPanesCanvas: function() {
                        return this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(), this._isRotated())
                    },
                    _parseVisualRangeOption: function(fullName, value) {
                        var _this11 = this;
                        var _a;
                        var name = fullName.split(/[.[]/)[0];
                        var index = fullName.match(/\d+/g);
                        index = (0, _type.isDefined)(index) ? parseInt(index[0], 10) : index;
                        if (fullName.indexOf("visualRange") > 0) {
                            if ("object" !== (0, _type.type)(value)) {
                                value = null !== (_a = wrapVisualRange(fullName, value)) && void 0 !== _a ? _a : value
                            }
                            this._setCustomVisualRange(name, index, value)
                        } else if (("object" === (0, _type.type)(value) || isArray(value)) && name.indexOf("Axis") > 0 && JSON.stringify(value).indexOf("visualRange") > 0) {
                            if ((0, _type.isDefined)(value.visualRange)) {
                                this._setCustomVisualRange(name, index, value.visualRange)
                            } else if (isArray(value)) {
                                value.forEach((function(a, i) {
                                    if ((0, _type.isDefined)(a.visualRange)) {
                                        _this11._setCustomVisualRange(name, i, a.visualRange)
                                    }
                                }))
                            }
                        }
                    },
                    _setCustomVisualRange: function(axesName, index, value) {
                        var options = this._options.silent(axesName);
                        if (!options) {
                            return
                        }
                        if (!(0, _type.isDefined)(index)) {
                            options._customVisualRange = value
                        } else {
                            options[index]._customVisualRange = value
                        }
                        this._axesReinitialized = true
                    },
                    _raiseZoomEndHandlers: function() {
                        this._valueAxes.forEach((function(axis) {
                            return axis.handleZoomEnd()
                        }))
                    },
                    _setOptionsByReference: function() {
                        this.callBase();
                        (0, _extend2.extend)(this._optionsByReference, {
                            "valueAxis.visualRange": true
                        })
                    },
                    _notifyOptionChanged: function(option, value) {
                        this.callBase.apply(this, arguments);
                        if (!this._optionChangedLocker) {
                            this._parseVisualRangeOption(option, value)
                        }
                    },
                    _notifyVisualRange: function() {
                        var _this12 = this;
                        this._valueAxes.forEach((function(axis) {
                            var axisPath = axis.getOptions().optionPath;
                            if (axisPath) {
                                var path = "".concat(axisPath, ".visualRange");
                                var visualRange = (0, _utils.convertVisualRangeObject)(axis.visualRange(), !isArray(_this12.option(path)));
                                if (!axis.skipEventRising || !(0, _utils.rangesAreEqual)(visualRange, _this12.option(path))) {
                                    if (!_this12.option(axisPath) && "valueAxis" !== axisPath) {
                                        _this12.option(axisPath, {
                                            name: axis.name,
                                            visualRange: visualRange
                                        })
                                    } else {
                                        _this12.option(path, visualRange)
                                    }
                                } else {
                                    axis.skipEventRising = null
                                }
                            }
                        }))
                    },
                    _notify: function() {
                        this.callBase();
                        this._axesReinitialized = false;
                        if (true !== this.option("disableTwoWayBinding")) {
                            this.skipOptionsRollBack = true;
                            this._notifyVisualRange();
                            this.skipOptionsRollBack = false
                        }
                    },
                    _getAxesForScaling: function() {
                        return this._valueAxes
                    },
                    _getAxesByOptionPath: function(arg, isDirectOption, optionName) {
                        var sourceAxes = this._getAxesForScaling();
                        var axes = [];
                        if (isDirectOption) {
                            var axisPath;
                            if (arg.fullName) {
                                axisPath = arg.fullName.slice(0, arg.fullName.indexOf("."))
                            }
                            axes = sourceAxes.filter((function(a) {
                                return a.getOptions().optionPath === axisPath
                            }))
                        } else if ("object" === (0, _type.type)(arg.value)) {
                            axes = sourceAxes.filter((function(a) {
                                return a.getOptions().optionPath === arg.name
                            }))
                        } else if (isArray(arg.value)) {
                            arg.value.forEach((function(v, index) {
                                var axis = sourceAxes.filter((function(a) {
                                    return a.getOptions().optionPath === "".concat(arg.name, "[").concat(index, "]")
                                }))[0];
                                if ((0, _type.isDefined)(v[optionName]) && (0, _type.isDefined)(axis)) {
                                    axes[index] = axis
                                }
                            }))
                        }
                        return axes
                    },
                    _optionChanged: function(arg) {
                        if (!this._optionChangedLocker) {
                            var axes;
                            var isDirectOption = arg.fullName.indexOf("visualRange") > 0 ? true : this.getPartialChangeOptionsName(arg).indexOf("visualRange") > -1 ? false : void 0;
                            if ((0, _type.isDefined)(isDirectOption)) {
                                axes = this._getAxesByOptionPath(arg, isDirectOption, "visualRange");
                                if (axes) {
                                    if (axes.length > 1 || isArray(arg.value)) {
                                        axes.forEach((function(a, index) {
                                            return setAxisVisualRangeByOption(arg, a, isDirectOption, index)
                                        }))
                                    } else if (1 === axes.length) {
                                        setAxisVisualRangeByOption(arg, axes[0], isDirectOption)
                                    }
                                }
                            }
                        }
                        this.callBase(arg)
                    },
                    _change_VISUAL_RANGE: function() {
                        this._recreateSizeDependentObjects(false);
                        if (!this._changes.has("FULL_RENDER")) {
                            var resizePanesOnZoom = this.option("resizePanesOnZoom");
                            this._doRender({
                                force: true,
                                drawTitle: false,
                                drawLegend: false,
                                adjustAxes: null !== resizePanesOnZoom && void 0 !== resizePanesOnZoom ? resizePanesOnZoom : this.option("adjustAxesOnZoom") || false,
                                animate: false
                            });
                            this._raiseZoomEndHandlers()
                        }
                    },
                    resetVisualRange: function() {
                        var _this13 = this;
                        this._valueAxes.forEach((function(axis) {
                            axis.resetVisualRange(false);
                            _this13._applyCustomVisualRangeOption(axis)
                        }));
                        this._requestChange(["VISUAL_RANGE"])
                    },
                    _getCrosshairMargins: function() {
                        return {
                            x: 0,
                            y: 0
                        }
                    },
                    _legendDataField: "series",
                    _adjustSeriesLabels: _common.noop,
                    _correctValueAxes: _common.noop
                });
                exports.AdvancedChart = AdvancedChart
            },
        14107:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/chart_components/m_base_chart.js ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.overlapping = exports.BaseChart = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../events/core/events_engine */ 55994));
                var _index = __webpack_require__( /*! ../../../events/utils/index */ 39611);
                var _layout_manager = __webpack_require__( /*! ../../../viz/chart_components/layout_manager */ 61189);
                var trackerModule = function(obj, nodeInterop) {
                    if (!nodeInterop && obj && obj.__esModule) {
                        return obj
                    }
                    if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                        return {
                            default: obj
                        }
                    }
                    var cache = _getRequireWildcardCache(nodeInterop);
                    if (cache && cache.has(obj)) {
                        return cache.get(obj)
                    }
                    var newObj = {};
                    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var key in obj) {
                        if ("default" !== key && Object.prototype.hasOwnProperty.call(obj, key)) {
                            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                            if (desc && (desc.get || desc.set)) {
                                Object.defineProperty(newObj, key, desc)
                            } else {
                                newObj[key] = obj[key]
                            }
                        }
                    }
                    newObj.default = obj;
                    if (cache) {
                        cache.set(obj, newObj)
                    }
                    return newObj
                }(__webpack_require__( /*! ../../../viz/chart_components/tracker */ 19957));
                var _chart_theme_manager = __webpack_require__( /*! ../../../viz/components/chart_theme_manager */ 99327);
                var _data_validator = __webpack_require__( /*! ../../../viz/components/data_validator */ 45865);
                var _legend = __webpack_require__( /*! ../../../viz/components/legend */ 16342);
                var _data_source = __webpack_require__( /*! ../../../viz/core/data_source */ 1539);
                var _export = __webpack_require__( /*! ../../../viz/core/export */ 82454);
                var _loading_indicator = __webpack_require__( /*! ../../../viz/core/loading_indicator */ 64758);
                var _title = __webpack_require__( /*! ../../../viz/core/title */ 17384);
                var _tooltip = __webpack_require__( /*! ../../../viz/core/tooltip */ 14371);
                var _utils = __webpack_require__( /*! ../../../viz/core/utils */ 19157);
                var _base_series = __webpack_require__( /*! ../../../viz/series/base_series */ 54932);
                var _m_base_widget = _interopRequireDefault(__webpack_require__( /*! ../core/m_base_widget */ 55845));
                var _rolling_stock = __webpack_require__( /*! ./rolling_stock */ 56136);

                function _getRequireWildcardCache(nodeInterop) {
                    if ("function" !== typeof WeakMap) {
                        return null
                    }
                    var cacheBabelInterop = new WeakMap;
                    var cacheNodeInterop = new WeakMap;
                    return (_getRequireWildcardCache = function(nodeInterop) {
                        return nodeInterop ? cacheNodeInterop : cacheBabelInterop
                    })(nodeInterop)
                }

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var isArray = Array.isArray;
                var ACTIONS_BY_PRIORITY = ["_reinit", "_updateDataSource", "_dataInit", "_forceRender", "_resize"];

                function checkHeightRollingStock(rollingStocks, stubCanvas) {
                    var canvasSize = stubCanvas.end - stubCanvas.start;
                    var size = 0;
                    rollingStocks.forEach((function(rollingStock) {
                        size += rollingStock.getBoundingRect().width
                    }));
                    while (canvasSize < size) {
                        size -= findAndKillSmallValue(rollingStocks)
                    }
                }

                function findAndKillSmallValue(rollingStocks) {
                    var smallestObject = rollingStocks.reduce((function(prev, rollingStock, index) {
                        if (!rollingStock) {
                            return prev
                        }
                        var value = rollingStock.value();
                        return value < prev.value ? {
                            value: value,
                            rollingStock: rollingStock,
                            index: index
                        } : prev
                    }), {
                        rollingStock: void 0,
                        value: 1 / 0,
                        index: void 0
                    });
                    smallestObject.rollingStock.getLabels()[0].draw(false);
                    var _smallestObject$rolli = smallestObject.rollingStock.getBoundingRect(),
                        width = _smallestObject$rolli.width;
                    rollingStocks[smallestObject.index] = null;
                    return width
                }

                function checkStackOverlap(rollingStocks) {
                    var i;
                    var j;
                    var iLength;
                    var jLength;
                    var overlap = false;
                    for (i = 0, iLength = rollingStocks.length - 1; i < iLength; i++) {
                        for (j = i + 1, jLength = rollingStocks.length; j < jLength; j++) {
                            if (i !== j && checkStacksOverlapping(rollingStocks[i], rollingStocks[j], true)) {
                                overlap = true;
                                break
                            }
                        }
                        if (overlap) {
                            break
                        }
                    }
                    return overlap
                }

                function checkStacksOverlapping(firstRolling, secondRolling, inTwoSides) {
                    if (!firstRolling || !secondRolling) {
                        return
                    }
                    var firstRect = firstRolling.getBoundingRect();
                    var secondRect = secondRolling.getBoundingRect();
                    var oppositeOverlapping = inTwoSides ? firstRect.oppositeStart <= secondRect.oppositeStart && firstRect.oppositeEnd > secondRect.oppositeStart || secondRect.oppositeStart <= firstRect.oppositeStart && secondRect.oppositeEnd > firstRect.oppositeStart : true;
                    return firstRect.end > secondRect.start && oppositeOverlapping
                }

                function sortRollingStocksByValue(rollingStocks) {
                    var positiveRollingStocks = [];
                    var negativeRollingStocks = [];
                    rollingStocks.forEach((function(stock) {
                        if (stock.value() > 0) {
                            positiveRollingStocks.push(stock)
                        } else {
                            negativeRollingStocks.unshift(stock)
                        }
                    }));
                    return positiveRollingStocks.concat(negativeRollingStocks)
                }

                function prepareOverlapStacks(rollingStocks) {
                    var root;
                    for (var i = 0; i < rollingStocks.length - 1; i += 1) {
                        var currentRollingStock = root || rollingStocks[i];
                        if (checkStacksOverlapping(currentRollingStock, rollingStocks[i + 1])) {
                            currentRollingStock.toChain(rollingStocks[i + 1]);
                            rollingStocks[i + 1] = null;
                            root = currentRollingStock
                        } else {
                            root = rollingStocks[i + 1] || currentRollingStock
                        }
                    }
                }

                function rollingStocksIsOut(rollingStock, canvas) {
                    return rollingStock.getBoundingRect().end > canvas.end
                }

                function moveRollingStock(rollingStocks, canvas) {
                    for (var i = 0; i < rollingStocks.length; i += 1) {
                        var currentRollingStock = rollingStocks[i];
                        var shouldSetCanvas = true;
                        if (null !== currentRollingStock && rollingStocksIsOut(currentRollingStock, canvas)) {
                            var currentBBox = currentRollingStock.getBoundingRect();
                            for (var j = i + 1; j < rollingStocks.length; j += 1) {
                                var nextRollingStock = rollingStocks[j];
                                if (nextRollingStock) {
                                    var nextBBox = nextRollingStock.getBoundingRect();
                                    if (nextBBox.end > currentBBox.start - (currentBBox.end - canvas.end)) {
                                        nextRollingStock.toChain(currentRollingStock);
                                        shouldSetCanvas = false;
                                        break
                                    }
                                }
                            }
                        }
                        if (shouldSetCanvas) {
                            null === currentRollingStock || void 0 === currentRollingStock ? void 0 : currentRollingStock.setRollingStockInCanvas(canvas)
                        }
                    }
                }
                var overlapping = {
                    resolveLabelOverlappingInOneDirection: function(points, canvas, isRotated, isInverted, shiftFunction) {
                        var customSorting = arguments.length > 5 && void 0 !== arguments[5] ? arguments[5] : function() {
                            return 0
                        };
                        var rollingStocks = [];
                        var stubCanvas = {
                            start: isRotated ? canvas.left : canvas.top,
                            end: isRotated ? canvas.width - canvas.right : canvas.height - canvas.bottom
                        };
                        var hasStackedSeries = false;
                        var sortRollingStocks;
                        points.forEach((function(p) {
                            if (!p) {
                                return
                            }
                            hasStackedSeries = hasStackedSeries || p.series.isStackedSeries() || p.series.isFullStackedSeries();
                            p.getLabels().forEach((function(l) {
                                if (l.isVisible()) {
                                    rollingStocks.push(new _rolling_stock.RollingStock(l, isRotated, shiftFunction))
                                }
                            }))
                        }));
                        if (hasStackedSeries) {
                            if (Number(!isRotated) ^ Number(isInverted)) {
                                rollingStocks.reverse()
                            }
                            sortRollingStocks = isInverted ? rollingStocks : sortRollingStocksByValue(rollingStocks)
                        } else {
                            var rollingStocksTmp = rollingStocks.slice();
                            sortRollingStocks = rollingStocks.sort((function(a, b) {
                                return customSorting(a, b) || a.getInitialPosition() - b.getInitialPosition() || rollingStocksTmp.indexOf(a) - rollingStocksTmp.indexOf(b)
                            }))
                        }
                        if (!checkStackOverlap(sortRollingStocks)) {
                            return false
                        }
                        checkHeightRollingStock(sortRollingStocks, stubCanvas);
                        prepareOverlapStacks(sortRollingStocks);
                        sortRollingStocks.reverse();
                        moveRollingStock(sortRollingStocks, stubCanvas);
                        return true
                    }
                };
                exports.overlapping = overlapping;
                var BaseChart = _m_base_widget.default.inherit({
                    _eventsMap: {
                        onSeriesClick: {
                            name: "seriesClick"
                        },
                        onPointClick: {
                            name: "pointClick"
                        },
                        onArgumentAxisClick: {
                            name: "argumentAxisClick"
                        },
                        onLegendClick: {
                            name: "legendClick"
                        },
                        onSeriesSelectionChanged: {
                            name: "seriesSelectionChanged"
                        },
                        onPointSelectionChanged: {
                            name: "pointSelectionChanged"
                        },
                        onSeriesHoverChanged: {
                            name: "seriesHoverChanged"
                        },
                        onPointHoverChanged: {
                            name: "pointHoverChanged"
                        },
                        onDone: {
                            name: "done",
                            actionSettings: {
                                excludeValidators: ["disabled"]
                            }
                        },
                        onZoomStart: {
                            name: "zoomStart"
                        },
                        onZoomEnd: {
                            name: "zoomEnd"
                        }
                    },
                    _fontFields: ["legend.".concat("font"), "legend.title.".concat("font"), "legend.title.subtitle.".concat("font"), "commonSeriesSettings.label.".concat("font")],
                    _rootClassPrefix: "dxc",
                    _rootClass: "dxc-chart",
                    _initialChanges: ["INIT"],
                    _themeDependentChanges: ["REFRESH_SERIES_REINIT"],
                    _getThemeManagerOptions: function() {
                        var themeOptions = this.callBase.apply(this, arguments);
                        themeOptions.options = this.option();
                        return themeOptions
                    },
                    _createThemeManager: function() {
                        var chartOption = this.option();
                        var themeManager = new _chart_theme_manager.ThemeManager(this._getThemeManagerOptions());
                        themeManager.setTheme(chartOption.theme, chartOption.rtlEnabled);
                        return themeManager
                    },
                    _initCore: function() {
                        this._canvasClipRect = this._renderer.clipRect();
                        this._createHtmlStructure();
                        this._createLegend();
                        this._createTracker();
                        this._needHandleRenderComplete = true;
                        this.layoutManager = new _layout_manager.LayoutManager;
                        this._createScrollBar();
                        _events_engine.default.on(this._$element, "contextmenu", (function(event) {
                            if ((0, _index.isTouchEvent)(event) || (0, _index.isPointerEvent)(event)) {
                                event.preventDefault()
                            }
                        }));
                        _events_engine.default.on(this._$element, "MSHoldVisual", (function(event) {
                            event.preventDefault()
                        }))
                    },
                    _getLayoutItems: _common.noop,
                    _layoutManagerOptions: function() {
                        return this._themeManager.getOptions("adaptiveLayout")
                    },
                    _reinit: function() {
                        (0, _utils.setCanvasValues)(this._canvas);
                        this._reinitAxes();
                        this._requestChange(["DATA_SOURCE", "DATA_INIT", "CORRECT_AXIS", "FULL_RENDER"])
                    },
                    _correctAxes: _common.noop,
                    _createHtmlStructure: function() {
                        var _this = this;
                        var renderer = this._renderer;
                        var root = renderer.root;
                        var createConstantLinesGroup = function() {
                            return renderer.g().attr({
                                class: "dxc-constant-lines-group"
                            }).linkOn(root, "constant-lines")
                        };
                        this._constantLinesGroup = {
                            dispose: function() {
                                this.under.dispose();
                                this.above.dispose()
                            },
                            linkOff: function() {
                                this.under.linkOff();
                                this.above.linkOff()
                            },
                            clear: function() {
                                this.under.linkRemove().clear();
                                this.above.linkRemove().clear()
                            },
                            linkAppend: function() {
                                this.under.linkAppend();
                                this.above.linkAppend()
                            }
                        };
                        this._labelsAxesGroup = renderer.g().attr({
                            class: "dxc-elements-axes-group"
                        });
                        var appendLabelsAxesGroup = function() {
                            _this._labelsAxesGroup.linkOn(root, "elements")
                        };
                        this._backgroundRect = renderer.rect().attr({
                            fill: "gray",
                            opacity: 1e-4
                        }).append(root);
                        this._panesBackgroundGroup = renderer.g().attr({
                            class: "dxc-background"
                        }).append(root);
                        this._stripsGroup = renderer.g().attr({
                            class: "dxc-strips-group"
                        }).linkOn(root, "strips");
                        this._gridGroup = renderer.g().attr({
                            class: "dxc-grids-group"
                        }).linkOn(root, "grids");
                        this._panesBorderGroup = renderer.g().attr({
                            class: "dxc-border"
                        }).linkOn(root, "border");
                        this._axesGroup = renderer.g().attr({
                            class: "dxc-axes-group"
                        }).linkOn(root, "axes");
                        this._executeAppendBeforeSeries(appendLabelsAxesGroup);
                        this._stripLabelAxesGroup = renderer.g().attr({
                            class: "dxc-strips-labels-group"
                        }).linkOn(root, "strips-labels");
                        this._constantLinesGroup.under = createConstantLinesGroup();
                        this._seriesGroup = renderer.g().attr({
                            class: "dxc-series-group"
                        }).linkOn(root, "series");
                        this._executeAppendAfterSeries(appendLabelsAxesGroup);
                        this._constantLinesGroup.above = createConstantLinesGroup();
                        this._scaleBreaksGroup = renderer.g().attr({
                            class: "dxc-scale-breaks"
                        }).linkOn(root, "scale-breaks");
                        this._labelsGroup = renderer.g().attr({
                            class: "dxc-labels-group"
                        }).linkOn(root, "labels");
                        this._crosshairCursorGroup = renderer.g().attr({
                            class: "dxc-crosshair-cursor"
                        }).linkOn(root, "crosshair");
                        this._legendGroup = renderer.g().attr({
                            class: "dxc-legend",
                            "clip-path": this._getCanvasClipRectID()
                        }).linkOn(root, "legend").linkAppend(root).enableLinks();
                        this._scrollBarGroup = renderer.g().attr({
                            class: "dxc-scroll-bar"
                        }).linkOn(root, "scroll-bar")
                    },
                    _executeAppendBeforeSeries: function() {},
                    _executeAppendAfterSeries: function() {},
                    _disposeObjectsInArray: function(propName, fieldNames) {
                        (this[propName] || []).forEach((function(item) {
                            if (fieldNames && item) {
                                fieldNames.forEach((function(field) {
                                    var _a;
                                    null === (_a = item[field]) || void 0 === _a ? void 0 : _a.dispose()
                                }))
                            } else {
                                null === item || void 0 === item ? void 0 : item.dispose()
                            }
                        }));
                        this[propName] = null
                    },
                    _disposeCore: function() {
                        var _this2 = this;
                        var disposeObject = function(propName) {
                            if (_this2[propName]) {
                                _this2[propName].dispose();
                                _this2[propName] = null
                            }
                        };
                        var unlinkGroup = function(name) {
                            _this2[name].linkOff()
                        };
                        var disposeObjectsInArray = this._disposeObjectsInArray;
                        this._renderer.stopAllAnimations();
                        disposeObjectsInArray.call(this, "series");
                        disposeObject("_tracker");
                        disposeObject("_crosshair");
                        this.layoutManager = this._userOptions = this._canvas = this._groupsData = null;
                        unlinkGroup("_stripsGroup");
                        unlinkGroup("_gridGroup");
                        unlinkGroup("_axesGroup");
                        unlinkGroup("_constantLinesGroup");
                        unlinkGroup("_stripLabelAxesGroup");
                        unlinkGroup("_panesBorderGroup");
                        unlinkGroup("_seriesGroup");
                        unlinkGroup("_labelsGroup");
                        unlinkGroup("_crosshairCursorGroup");
                        unlinkGroup("_legendGroup");
                        unlinkGroup("_scrollBarGroup");
                        unlinkGroup("_scaleBreaksGroup");
                        disposeObject("_canvasClipRect");
                        disposeObject("_panesBackgroundGroup");
                        disposeObject("_backgroundRect");
                        disposeObject("_stripsGroup");
                        disposeObject("_gridGroup");
                        disposeObject("_axesGroup");
                        disposeObject("_constantLinesGroup");
                        disposeObject("_stripLabelAxesGroup");
                        disposeObject("_panesBorderGroup");
                        disposeObject("_seriesGroup");
                        disposeObject("_labelsGroup");
                        disposeObject("_crosshairCursorGroup");
                        disposeObject("_legendGroup");
                        disposeObject("_scrollBarGroup");
                        disposeObject("_scaleBreaksGroup")
                    },
                    _getAnimationOptions: function() {
                        return this._themeManager.getOptions("animation")
                    },
                    _getDefaultSize: function() {
                        return {
                            width: 400,
                            height: 400
                        }
                    },
                    _getOption: function(name) {
                        return this._themeManager.getOptions(name)
                    },
                    _applySize: function(rect) {
                        this._rect = rect.slice();
                        if (!this._changes.has("FULL_RENDER")) {
                            this._processRefreshData("_resize")
                        }
                    },
                    _resize: function() {
                        this._doRender(this.__renderOptions || {
                            animate: false,
                            isResize: true
                        })
                    },
                    _trackerType: "ChartTracker",
                    _createTracker: function() {
                        this._tracker = new trackerModule[this._trackerType]({
                            seriesGroup: this._seriesGroup,
                            renderer: this._renderer,
                            tooltip: this._tooltip,
                            legend: this._legend,
                            eventTrigger: this._eventTrigger
                        })
                    },
                    _getTrackerSettings: function() {
                        return (0, _extend.extend)({
                            chart: this
                        }, this._getSelectionModes())
                    },
                    _getSelectionModes: function() {
                        var themeManager = this._themeManager;
                        return {
                            seriesSelectionMode: themeManager.getOptions("seriesSelectionMode"),
                            pointSelectionMode: themeManager.getOptions("pointSelectionMode")
                        }
                    },
                    _updateTracker: function(trackerCanvases) {
                        this._tracker.update(this._getTrackerSettings());
                        this._tracker.setCanvases({
                            left: 0,
                            right: this._canvas.width,
                            top: 0,
                            bottom: this._canvas.height
                        }, trackerCanvases)
                    },
                    _createCanvasFromRect: function(rect) {
                        var currentCanvas = this._canvas;
                        return (0, _utils.setCanvasValues)({
                            left: rect[0],
                            top: rect[1],
                            right: currentCanvas.width - rect[2],
                            bottom: currentCanvas.height - rect[3],
                            width: currentCanvas.width,
                            height: currentCanvas.height
                        })
                    },
                    _doRender: function(_options) {
                        if (0 === this._canvas.width && 0 === this._canvas.height) {
                            return
                        }
                        this._resetIsReady();
                        var drawOptions = this._prepareDrawOptions(_options);
                        var recreateCanvas = drawOptions.recreateCanvas;
                        this._preserveOriginalCanvas();
                        if (recreateCanvas) {
                            this.__currentCanvas = this._canvas
                        } else {
                            this._canvas = this.__currentCanvas
                        }
                        recreateCanvas && this._updateCanvasClipRect(this._canvas);
                        this._canvas = this._createCanvasFromRect(this._rect);
                        this._renderer.stopAllAnimations(true);
                        this._cleanGroups();
                        var startTime = new Date;
                        this._renderElements(drawOptions);
                        this._lastRenderingTime = Number(new Date) - Number(startTime)
                    },
                    _preserveOriginalCanvas: function() {
                        this.__originalCanvas = this._canvas;
                        this._canvas = (0, _extend.extend)({}, this._canvas)
                    },
                    _layoutAxes: _common.noop,
                    _renderElements: function(drawOptions) {
                        var _this3 = this;
                        var preparedOptions = this._prepareToRender(drawOptions);
                        var isRotated = this._isRotated();
                        var isLegendInside = this._isLegendInside();
                        var trackerCanvases = [];
                        (0, _extend.extend)({}, this._canvas);
                        var argBusinessRange;
                        var zoomMinArg;
                        var zoomMaxArg;
                        this._renderer.lock();
                        if (drawOptions.drawLegend && this._legend) {
                            this._legendGroup.linkAppend()
                        }
                        this.layoutManager.setOptions(this._layoutManagerOptions());
                        var layoutTargets = this._getLayoutTargets();
                        this._layoutAxes((function(needSpace) {
                            var axisDrawOptions = needSpace ? (0, _extend.extend)({}, drawOptions, {
                                animate: false,
                                recreateCanvas: true
                            }) : drawOptions;
                            var canvas = _this3._renderAxes(axisDrawOptions, preparedOptions);
                            _this3._shrinkAxes(needSpace, canvas)
                        }));
                        this._applyClipRects(preparedOptions);
                        this._appendSeriesGroups();
                        this._createCrosshairCursor();
                        layoutTargets.forEach((function(_ref) {
                            var canvas = _ref.canvas;
                            trackerCanvases.push({
                                left: canvas.left,
                                right: canvas.width - canvas.right,
                                top: canvas.top,
                                bottom: canvas.height - canvas.bottom
                            })
                        }));
                        if (this._scrollBar) {
                            argBusinessRange = this._argumentAxes[0].getTranslator().getBusinessRange();
                            if ("discrete" === argBusinessRange.axisType && argBusinessRange.categories && argBusinessRange.categories.length <= 1 || "discrete" !== argBusinessRange.axisType && argBusinessRange.min === argBusinessRange.max) {
                                zoomMinArg = zoomMaxArg = void 0
                            } else {
                                zoomMinArg = argBusinessRange.minVisible;
                                zoomMaxArg = argBusinessRange.maxVisible
                            }
                            this._scrollBar.init(argBusinessRange, !this._argumentAxes[0].getOptions().valueMarginsEnabled).setPosition(zoomMinArg, zoomMaxArg)
                        }
                        this._updateTracker(trackerCanvases);
                        this._updateLegendPosition(drawOptions, isLegendInside);
                        this._applyPointMarkersAutoHiding();
                        this._renderSeries(drawOptions, isRotated, isLegendInside);
                        this._renderGraphicObjects();
                        this._renderer.unlock()
                    },
                    _updateLegendPosition: _common.noop,
                    _createCrosshairCursor: _common.noop,
                    _appendSeriesGroups: function() {
                        this._seriesGroup.linkAppend();
                        this._labelsGroup.linkAppend();
                        this._appendAdditionalSeriesGroups()
                    },
                    _renderSeries: function(drawOptions, isRotated, isLegendInside) {
                        this._calculateSeriesLayout(drawOptions, isRotated);
                        this._renderSeriesElements(drawOptions, isLegendInside)
                    },
                    _calculateSeriesLayout: function(drawOptions, isRotated) {
                        drawOptions.hideLayoutLabels = this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(), isRotated) && !this._themeManager.getOptions("adaptiveLayout").keepLabels;
                        this._updateSeriesDimensions(drawOptions)
                    },
                    _getArgFilter: function() {
                        return function() {
                            return true
                        }
                    },
                    _getValFilter: function() {
                        return function() {
                            return true
                        }
                    },
                    _getPointsToAnimation: function(series) {
                        var _this4 = this;
                        var argViewPortFilter = this._getArgFilter();
                        return series.map((function(s) {
                            var valViewPortFilter = _this4._getValFilter(s);
                            return s.getPoints().filter((function(p) {
                                return p.getOptions().visible && argViewPortFilter(p.argument) && (valViewPortFilter(p.getMinValue(true)) || valViewPortFilter(p.getMaxValue(true)))
                            })).length
                        }))
                    },
                    _renderSeriesElements: function(drawOptions, isLegendInside) {
                        var _this5 = this;
                        var series = this.series;
                        var resolveLabelOverlapping = this._themeManager.getOptions("resolveLabelOverlapping");
                        var pointsToAnimation = this._getPointsToAnimation(series);
                        series.forEach((function(singleSeries, index) {
                            _this5._applyExtraSettings(singleSeries, drawOptions);
                            var animationEnabled = drawOptions.animate && pointsToAnimation[index] <= drawOptions.animationPointsLimit && _this5._renderer.animationEnabled();
                            singleSeries.draw(animationEnabled, drawOptions.hideLayoutLabels, _this5._getLegendCallBack(singleSeries))
                        }));
                        if ("none" === resolveLabelOverlapping) {
                            this._adjustSeriesLabels(false)
                        } else {
                            this._locateLabels(resolveLabelOverlapping)
                        }
                        this._renderTrackers(isLegendInside);
                        this._tracker.repairTooltip();
                        this._renderExtraElements();
                        this._clearCanvas();
                        this._seriesElementsDrawn = true
                    },
                    _changesApplied: function() {
                        if (this._seriesElementsDrawn) {
                            this._seriesElementsDrawn = false;
                            this._drawn();
                            this._renderCompleteHandler()
                        }
                    },
                    _locateLabels: function(resolveLabelOverlapping) {
                        this._resolveLabelOverlapping(resolveLabelOverlapping)
                    },
                    _renderExtraElements: function() {},
                    _clearCanvas: function() {
                        this._canvas = this.__originalCanvas
                    },
                    _resolveLabelOverlapping: function(resolveLabelOverlapping) {
                        var func;
                        switch (resolveLabelOverlapping) {
                            case "stack":
                                func = this._resolveLabelOverlappingStack;
                                break;
                            case "hide":
                                func = this._resolveLabelOverlappingHide;
                                break;
                            case "shift":
                                func = this._resolveLabelOverlappingShift
                        }
                        return (0, _type.isFunction)(func) && func.call(this)
                    },
                    _getVisibleSeries: function() {
                        return (0, _common.grep)(this.getAllSeries(), (function(series) {
                            return series.isVisible()
                        }))
                    },
                    _resolveLabelOverlappingHide: function() {
                        var labels = [];
                        var currentLabel;
                        var nextLabel;
                        var currentLabelRect;
                        var nextLabelRect;
                        var i;
                        var j;
                        var points;
                        var series = this._getVisibleSeries();
                        for (i = 0; i < series.length; i++) {
                            points = series[i].getVisiblePoints();
                            for (j = 0; j < points.length; j++) {
                                labels.push.apply(labels, points[j].getLabels())
                            }
                        }
                        for (i = 0; i < labels.length; i++) {
                            currentLabel = labels[i];
                            if (!currentLabel.isVisible()) {
                                continue
                            }
                            currentLabelRect = currentLabel.getBoundingRect();
                            for (j = i + 1; j < labels.length; j++) {
                                nextLabel = labels[j];
                                nextLabelRect = nextLabel.getBoundingRect();
                                if (firstRect = currentLabelRect, secondRect = nextLabelRect, (firstRect.x <= secondRect.x && secondRect.x <= firstRect.x + firstRect.width || firstRect.x >= secondRect.x && firstRect.x <= secondRect.x + secondRect.width) && (firstRect.y <= secondRect.y && secondRect.y <= firstRect.y + firstRect.height || firstRect.y >= secondRect.y && firstRect.y <= secondRect.y + secondRect.height)) {
                                    nextLabel.draw(false)
                                }
                            }
                        }
                        var firstRect, secondRect
                    },
                    _cleanGroups: function() {
                        this._stripsGroup.linkRemove().clear();
                        this._gridGroup.linkRemove().clear();
                        this._axesGroup.linkRemove().clear();
                        this._constantLinesGroup.clear();
                        this._stripLabelAxesGroup.linkRemove().clear();
                        this._labelsGroup.linkRemove().clear();
                        this._crosshairCursorGroup.linkRemove().clear();
                        this._scaleBreaksGroup.linkRemove().clear()
                    },
                    _allowLegendInsidePosition: function() {
                        return false
                    },
                    _createLegend: function() {
                        var legendSettings = (legendDataField = this._legendDataField, formatObjectFields = (name = legendDataField, {
                            nameField: "".concat(name, "Name"),
                            colorField: "".concat(name, "Color"),
                            indexField: "".concat(name, "Index")
                        }), {
                            getFormatObject: function(data) {
                                var res = {};
                                res[formatObjectFields.indexField] = data.id;
                                res[formatObjectFields.colorField] = data.states.normal.fill;
                                res[formatObjectFields.nameField] = data.text;
                                return res
                            },
                            textField: formatObjectFields.nameField
                        });
                        var legendDataField, formatObjectFields, name;
                        this._legend = new _legend.Legend({
                            renderer: this._renderer,
                            widget: this,
                            group: this._legendGroup,
                            backgroundClass: "dxc-border",
                            itemGroupClass: "dxc-item",
                            titleGroupClass: "dxc-title",
                            textField: legendSettings.textField,
                            getFormatObject: legendSettings.getFormatObject,
                            allowInsidePosition: this._allowLegendInsidePosition()
                        });
                        this._updateLegend();
                        this._layout.add(this._legend)
                    },
                    _updateLegend: function() {
                        var themeManager = this._themeManager;
                        var legendOptions = themeManager.getOptions("legend");
                        var legendData = this._getLegendData();
                        legendOptions.containerBackgroundColor = themeManager.getOptions("containerBackgroundColor");
                        legendOptions._incidentOccurred = this._incidentOccurred;
                        this._legend.update(legendData, legendOptions, themeManager.theme("legend").title);
                        this._change(["LAYOUT"])
                    },
                    _prepareDrawOptions: function(drawOptions) {
                        var animationOptions = this._getAnimationOptions();
                        var options = (0, _extend.extend)({}, {
                            force: false,
                            adjustAxes: true,
                            drawLegend: true,
                            drawTitle: true,
                            animate: animationOptions.enabled,
                            animationPointsLimit: animationOptions.maxPointCountSupported
                        }, drawOptions, this.__renderOptions);
                        if (!(0, _type.isDefined)(options.recreateCanvas)) {
                            options.recreateCanvas = options.adjustAxes && options.drawLegend && options.drawTitle
                        }
                        return options
                    },
                    _processRefreshData: function(newRefreshAction) {
                        var currentRefreshActionPosition = ACTIONS_BY_PRIORITY.indexOf(this._currentRefreshData);
                        var newRefreshActionPosition = ACTIONS_BY_PRIORITY.indexOf(newRefreshAction);
                        if (!this._currentRefreshData || currentRefreshActionPosition >= 0 && newRefreshActionPosition < currentRefreshActionPosition) {
                            this._currentRefreshData = newRefreshAction
                        }
                        this._requestChange(["REFRESH"])
                    },
                    _getLegendData: function() {
                        return (0, _utils.map)(this._getLegendTargets(), (function(item) {
                            var legendData = item.legendData;
                            var style = item.getLegendStyles;
                            var opacity = style.normal.opacity;
                            if (!item.visible) {
                                if (!(0, _type.isDefined)(opacity) || opacity > .3) {
                                    opacity = .3
                                }
                                legendData.textOpacity = .3
                            }
                            var opacityStyle = {
                                opacity: opacity
                            };
                            legendData.states = {
                                hover: (0, _extend.extend)({}, style.hover, opacityStyle),
                                selection: (0, _extend.extend)({}, style.selection, opacityStyle),
                                normal: (0, _extend.extend)({}, style.normal, opacityStyle)
                            };
                            return legendData
                        }))
                    },
                    _getLegendOptions: function(item) {
                        return {
                            legendData: {
                                text: item[this._legendItemTextField],
                                id: item.index,
                                visible: true
                            },
                            getLegendStyles: item.getLegendStyles(),
                            visible: item.isVisible()
                        }
                    },
                    _disposeSeries: function(seriesIndex) {
                        var _a;
                        if (this.series) {
                            if ((0, _type.isDefined)(seriesIndex)) {
                                this.series[seriesIndex].dispose();
                                this.series.splice(seriesIndex, 1)
                            } else {
                                this.series.forEach((function(s) {
                                    return s.dispose()
                                }));
                                this.series.length = 0
                            }
                        }
                        if (!(null === (_a = this.series) || void 0 === _a ? void 0 : _a.length)) {
                            this.series = []
                        }
                    },
                    _disposeSeriesFamilies: function() {
                        (this.seriesFamilies || []).forEach((function(family) {
                            family.dispose()
                        }));
                        this.seriesFamilies = null;
                        this._needHandleRenderComplete = true
                    },
                    _optionChanged: function(arg) {
                        this._themeManager.resetOptions(arg.name);
                        this.callBase.apply(this, arguments)
                    },
                    _applyChanges: function() {
                        this._themeManager.update(this._options.silent());
                        this.callBase.apply(this, arguments)
                    },
                    _optionChangesMap: {
                        animation: "ANIMATION",
                        dataSource: "DATA_SOURCE",
                        palette: "PALETTE",
                        paletteExtensionMode: "PALETTE",
                        legend: "FORCE_DATA_INIT",
                        seriesTemplate: "FORCE_DATA_INIT",
                        export: "FORCE_RENDER",
                        valueAxis: "AXES_AND_PANES",
                        argumentAxis: "AXES_AND_PANES",
                        commonAxisSettings: "AXES_AND_PANES",
                        panes: "AXES_AND_PANES",
                        commonPaneSettings: "AXES_AND_PANES",
                        defaultPane: "AXES_AND_PANES",
                        containerBackgroundColor: "AXES_AND_PANES",
                        rotated: "ROTATED",
                        autoHidePointMarkers: "REFRESH_SERIES_REINIT",
                        customizePoint: "REFRESH_SERIES_REINIT",
                        customizeLabel: "REFRESH_SERIES_REINIT",
                        scrollBar: "SCROLL_BAR"
                    },
                    _optionChangesOrder: ["ROTATED", "PALETTE", "REFRESH_SERIES_REINIT", "USE_SPIDER_WEB", "AXES_AND_PANES", "INIT", "REINIT", "DATA_SOURCE", "REFRESH_SERIES_DATA_INIT", "DATA_INIT", "FORCE_DATA_INIT", "REFRESH_AXES", "CORRECT_AXIS"],
                    _customChangesOrder: ["ANIMATION", "REFRESH_SERIES_FAMILIES", "FORCE_FIRST_DRAWING", "FORCE_DRAWING", "FORCE_RENDER", "VISUAL_RANGE", "SCROLL_BAR", "REINIT", "REFRESH", "FULL_RENDER"],
                    _change_ANIMATION: function() {
                        this._renderer.updateAnimationOptions(this._getAnimationOptions())
                    },
                    _change_DATA_SOURCE: function() {
                        this._needHandleRenderComplete = true;
                        this._updateDataSource()
                    },
                    _change_PALETTE: function() {
                        this._themeManager.updatePalette();
                        this._refreshSeries("DATA_INIT")
                    },
                    _change_REFRESH_SERIES_DATA_INIT: function() {
                        this._refreshSeries("DATA_INIT")
                    },
                    _change_DATA_INIT: function() {
                        if ((!this.series || this.needToPopulateSeries) && !this._changes.has("FORCE_DATA_INIT")) {
                            this._dataInit()
                        }
                    },
                    _change_FORCE_DATA_INIT: function() {
                        this._dataInit()
                    },
                    _change_REFRESH_SERIES_FAMILIES: function() {
                        this._processSeriesFamilies();
                        this._populateBusinessRange();
                        this._processRefreshData("_forceRender")
                    },
                    _change_FORCE_RENDER: function() {
                        this._processRefreshData("_forceRender")
                    },
                    _change_AXES_AND_PANES: function() {
                        this._refreshSeries("INIT")
                    },
                    _change_ROTATED: function() {
                        this._createScrollBar();
                        this._refreshSeries("INIT")
                    },
                    _change_REFRESH_SERIES_REINIT: function() {
                        this._refreshSeries("INIT")
                    },
                    _change_REFRESH_AXES: function() {
                        (0, _utils.setCanvasValues)(this._canvas);
                        this._reinitAxes();
                        this._requestChange(["CORRECT_AXIS", "FULL_RENDER"])
                    },
                    _change_SCROLL_BAR: function() {
                        this._createScrollBar();
                        this._processRefreshData("_forceRender")
                    },
                    _change_REINIT: function() {
                        this._processRefreshData("_reinit")
                    },
                    _change_FORCE_DRAWING: function() {
                        this._resetComponentsAnimation()
                    },
                    _change_FORCE_FIRST_DRAWING: function() {
                        this._resetComponentsAnimation(true)
                    },
                    _resetComponentsAnimation: function(isFirstDrawing) {
                        this.series.forEach((function(s) {
                            s.resetApplyingAnimation(isFirstDrawing)
                        }));
                        this._resetAxesAnimation(isFirstDrawing)
                    },
                    _resetAxesAnimation: _common.noop,
                    _refreshSeries: function(actionName) {
                        this.needToPopulateSeries = true;
                        this._requestChange([actionName])
                    },
                    _change_CORRECT_AXIS: function() {
                        this._correctAxes()
                    },
                    _doRefresh: function() {
                        var methodName = this._currentRefreshData;
                        if (methodName) {
                            this._currentRefreshData = null;
                            this._renderer.stopAllAnimations(true);
                            this[methodName]()
                        }
                    },
                    _updateCanvasClipRect: function(canvas) {
                        var width = Math.max(canvas.width - canvas.left - canvas.right, 0);
                        var height = Math.max(canvas.height - canvas.top - canvas.bottom, 0);
                        this._canvasClipRect.attr({
                            x: canvas.left,
                            y: canvas.top,
                            width: width,
                            height: height
                        });
                        this._backgroundRect.attr({
                            x: canvas.left,
                            y: canvas.top,
                            width: width,
                            height: height
                        })
                    },
                    _getCanvasClipRectID: function() {
                        return this._canvasClipRect.id
                    },
                    _dataSourceChangedHandler: function() {
                        if (this._changes.has("INIT")) {
                            this._requestChange(["DATA_INIT"])
                        } else {
                            this._requestChange(["FORCE_DATA_INIT"])
                        }
                    },
                    _dataInit: function() {
                        this._dataSpecificInit(true)
                    },
                    _processSingleSeries: function(singleSeries) {
                        singleSeries.createPoints(false)
                    },
                    _handleSeriesDataUpdated: function() {
                        var _this6 = this;
                        if (this._getVisibleSeries().some((function(s) {
                                return s.useAggregation()
                            }))) {
                            this._populateMarginOptions()
                        }
                        this.series.forEach((function(s) {
                            return _this6._processSingleSeries(s)
                        }), this)
                    },
                    _dataSpecificInit: function(needRedraw) {
                        if (!this.series || this.needToPopulateSeries) {
                            this.series = this._populateSeries()
                        }
                        this._repopulateSeries();
                        this._seriesPopulatedHandlerCore();
                        this._populateBusinessRange();
                        this._tracker.updateSeries(this.series, this._changes.has("INIT"));
                        this._updateLegend();
                        if (needRedraw) {
                            this._requestChange(["FULL_RENDER"])
                        }
                    },
                    _forceRender: function() {
                        this._doRender({
                            force: true
                        })
                    },
                    _repopulateSeries: function() {
                        var themeManager = this._themeManager;
                        var data = this._dataSourceItems();
                        var dataValidatorOptions = themeManager.getOptions("dataPrepareSettings");
                        var seriesTemplate = themeManager.getOptions("seriesTemplate");
                        if (seriesTemplate) {
                            this._populateSeries(data)
                        }
                        this._groupSeries();
                        var parsedData = (0, _data_validator.validateData)(data, this._groupsData, this._incidentOccurred, dataValidatorOptions);
                        themeManager.resetPalette();
                        this.series.forEach((function(singleSeries) {
                            singleSeries.updateData(parsedData[singleSeries.getArgumentField()])
                        }));
                        this._handleSeriesDataUpdated()
                    },
                    _renderCompleteHandler: function() {
                        var allSeriesInited = true;
                        if (this._needHandleRenderComplete) {
                            this.series.forEach((function(s) {
                                allSeriesInited = allSeriesInited && s.canRenderCompleteHandle()
                            }));
                            if (allSeriesInited) {
                                this._needHandleRenderComplete = false;
                                this._eventTrigger("done", {
                                    target: this
                                })
                            }
                        }
                    },
                    _dataIsReady: function() {
                        return (0, _type.isDefined)(this.option("dataSource")) && this._dataIsLoaded()
                    },
                    _populateSeriesOptions: function(data) {
                        var _this7 = this;
                        var themeManager = this._themeManager;
                        var seriesTemplate = themeManager.getOptions("seriesTemplate");
                        var seriesOptions = seriesTemplate ? (0, _utils.processSeriesTemplate)(seriesTemplate, data || []) : this.option("series");
                        var allSeriesOptions = isArray(seriesOptions) ? seriesOptions : seriesOptions ? [seriesOptions] : [];
                        var extraOptions = this._getExtraOptions();
                        var particularSeriesOptions;
                        var seriesTheme;
                        var seriesThemes = [];
                        var seriesVisibilityChanged = function(target) {
                            _this7._specialProcessSeries();
                            _this7._populateBusinessRange(target && target.getValueAxis(), true);
                            _this7._renderer.stopAllAnimations(true);
                            _this7._updateLegend();
                            _this7._requestChange(["FULL_RENDER"])
                        };
                        for (var i = 0; i < allSeriesOptions.length; i++) {
                            particularSeriesOptions = (0, _extend.extend)(true, {}, allSeriesOptions[i], extraOptions);
                            if (!(0, _type.isDefined)(particularSeriesOptions.name) || "" === particularSeriesOptions.name) {
                                particularSeriesOptions.name = "Series ".concat((i + 1).toString())
                            }
                            particularSeriesOptions.rotated = this._isRotated();
                            particularSeriesOptions.customizePoint = themeManager.getOptions("customizePoint");
                            particularSeriesOptions.customizeLabel = themeManager.getOptions("customizeLabel");
                            particularSeriesOptions.visibilityChanged = seriesVisibilityChanged;
                            particularSeriesOptions.incidentOccurred = this._incidentOccurred;
                            seriesTheme = themeManager.getOptions("series", particularSeriesOptions, allSeriesOptions.length);
                            if (this._checkPaneName(seriesTheme)) {
                                seriesThemes.push(seriesTheme)
                            }
                        }
                        return seriesThemes
                    },
                    _populateSeries: function(data) {
                        var _this8 = this;
                        var _a;
                        var seriesBasis = [];
                        var incidentOccurred = this._incidentOccurred;
                        var seriesThemes = this._populateSeriesOptions(data);
                        var particularSeries;
                        var disposeSeriesFamilies = false;
                        this.needToPopulateSeries = false;
                        seriesThemes.forEach((function(theme) {
                            var _a;
                            var curSeries = null === (_a = _this8.series) || void 0 === _a ? void 0 : _a.find((function(s) {
                                return s.name === theme.name && !seriesBasis.map((function(sb) {
                                    return sb.series
                                })).includes(s)
                            }));
                            if (curSeries && curSeries.type === theme.type) {
                                seriesBasis.push({
                                    series: curSeries,
                                    options: theme
                                })
                            } else {
                                seriesBasis.push({
                                    options: theme
                                });
                                disposeSeriesFamilies = true
                            }
                        }));
                        0 !== (null === (_a = this.series) || void 0 === _a ? void 0 : _a.length) && this._tracker.clearHover();
                        (0, _iterator.reverseEach)(this.series, (function(index, series) {
                            if (!seriesBasis.some((function(s) {
                                    return series === s.series
                                }))) {
                                _this8._disposeSeries(index);
                                disposeSeriesFamilies = true
                            }
                        }));
                        !disposeSeriesFamilies && (disposeSeriesFamilies = seriesBasis.some((function(sb) {
                            return sb.series.name !== seriesThemes[sb.series.index].name
                        })));
                        this.series = [];
                        disposeSeriesFamilies && this._disposeSeriesFamilies();
                        this._themeManager.resetPalette();
                        var eventPipe = function(data) {
                            _this8.series.forEach((function(currentSeries) {
                                currentSeries.notify(data)
                            }))
                        };
                        seriesBasis.forEach((function(basis) {
                            var _a, _b;
                            var seriesTheme = basis.options;
                            var argumentAxis = null !== (_b = null === (_a = _this8._argumentAxes) || void 0 === _a ? void 0 : _a.filter((function(a) {
                                return a.pane === seriesTheme.pane
                            }))[0]) && void 0 !== _b ? _b : _this8.getArgumentAxis();
                            var renderSettings = {
                                commonSeriesModes: _this8._getSelectionModes(),
                                argumentAxis: argumentAxis,
                                valueAxis: _this8._getValueAxis(seriesTheme.pane, seriesTheme.axis)
                            };
                            if (basis.series) {
                                particularSeries = basis.series;
                                particularSeries.updateOptions(seriesTheme, renderSettings)
                            } else {
                                particularSeries = new _base_series.Series((0, _extend.extend)({
                                    renderer: _this8._renderer,
                                    seriesGroup: _this8._seriesGroup,
                                    labelsGroup: _this8._labelsGroup,
                                    eventTrigger: _this8._eventTrigger,
                                    eventPipe: eventPipe,
                                    incidentOccurred: incidentOccurred
                                }, renderSettings), seriesTheme)
                            }
                            if (!particularSeries.isUpdated) {
                                incidentOccurred("E2101", [seriesTheme.type])
                            } else {
                                particularSeries.index = _this8.series.length;
                                _this8.series.push(particularSeries)
                            }
                        }));
                        return this.series
                    },
                    getStackedPoints: function(point) {
                        var stackName = point.series.getStackName();
                        return this._getVisibleSeries().reduce((function(stackPoints, series) {
                            if (!(0, _type.isDefined)(series.getStackName()) || !(0, _type.isDefined)(stackName) || stackName === series.getStackName()) {
                                stackPoints = stackPoints.concat(series.getPointsByArg(point.argument))
                            }
                            return stackPoints
                        }), [])
                    },
                    getAllSeries: function() {
                        return (this.series || []).slice()
                    },
                    getSeriesByName: function(name) {
                        var found = (this.series || []).find((function(singleSeries) {
                            return singleSeries.name === name
                        }));
                        return found || null
                    },
                    getSeriesByPos: function(pos) {
                        return (this.series || [])[pos]
                    },
                    clearSelection: function() {
                        this._tracker.clearSelection()
                    },
                    hideTooltip: function() {
                        this._tracker._hideTooltip()
                    },
                    clearHover: function() {
                        this._tracker.clearHover()
                    },
                    render: function(renderOptions) {
                        this.__renderOptions = renderOptions;
                        this.__forceRender = renderOptions && renderOptions.force;
                        this.callBase.apply(this, arguments);
                        this.__renderOptions = this.__forceRender = null;
                        return this
                    },
                    refresh: function() {
                        this._disposeSeries();
                        this._disposeSeriesFamilies();
                        this._requestChange(["CONTAINER_SIZE", "REFRESH_SERIES_REINIT"])
                    },
                    _getMinSize: function() {
                        var adaptiveLayout = this._layoutManagerOptions();
                        return [adaptiveLayout.width, adaptiveLayout.height]
                    },
                    _change_REFRESH: function() {
                        if (!this._changes.has("INIT")) {
                            this._doRefresh()
                        } else {
                            this._currentRefreshData = null
                        }
                    },
                    _change_FULL_RENDER: function() {
                        this._forceRender()
                    },
                    _change_INIT: function() {
                        this._reinit()
                    },
                    _stopCurrentHandling: function() {
                        this._tracker.stopCurrentHandling()
                    }
                });
                exports.BaseChart = BaseChart;
                ["series", "commonSeriesSettings", "dataPrepareSettings", "seriesSelectionMode", "pointSelectionMode", "synchronizeMultiAxes", "resolveLabelsOverlapping"].forEach((function(name) {
                    BaseChart.prototype._optionChangesMap[name] = "REFRESH_SERIES_DATA_INIT"
                }));
                ["adaptiveLayout", "crosshair", "resolveLabelOverlapping", "adjustOnZoom", "stickyHovering"].forEach((function(name) {
                    BaseChart.prototype._optionChangesMap[name] = "FORCE_RENDER"
                }));
                ["minBubbleSize", "maxBubbleSize", "barGroupPadding", "barGroupWidth", "negativesAsZeroes", "negativesAsZeros"].forEach((function(name) {
                    BaseChart.prototype._optionChangesMap[name] = "REFRESH_SERIES_FAMILIES"
                }));
                BaseChart.addPlugin(_export.plugin);
                BaseChart.addPlugin(_title.plugin);
                BaseChart.addPlugin(_data_source.plugin);
                BaseChart.addPlugin(_tooltip.plugin);
                BaseChart.addPlugin(_loading_indicator.plugin);
                var _change_TITLE = BaseChart.prototype._change_TITLE;
                BaseChart.prototype._change_TITLE = function() {
                    _change_TITLE.apply(this, arguments);
                    this._change(["FORCE_RENDER"])
                }
            },
        56136:
            /*!**********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/chart_components/rolling_stock.js ***!
              \**********************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.RollingStock = void 0;
                var RollingStock = function() {
                    function RollingStock(label, isRotated, shiftFunction) {
                        var bBox = label.getBoundingRect();
                        var x = bBox.x;
                        var y = bBox.y;
                        var endX = bBox.x + bBox.width;
                        var endY = bBox.y + bBox.height;
                        this.labels = [label];
                        this.shiftFunction = shiftFunction;
                        this.bBox = {
                            start: isRotated ? x : y,
                            width: isRotated ? bBox.width : bBox.height,
                            end: isRotated ? endX : endY,
                            oppositeStart: isRotated ? y : x,
                            oppositeEnd: isRotated ? endY : endX
                        };
                        this.initialPosition = isRotated ? bBox.x : bBox.y
                    }
                    var _proto = RollingStock.prototype;
                    _proto.toChain = function(nextRollingStock) {
                        var nextRollingStockBBox = nextRollingStock.getBoundingRect();
                        nextRollingStock.shift(nextRollingStockBBox.start - this.bBox.end);
                        this.changeBoxWidth(nextRollingStockBBox.width);
                        this.labels = this.labels.concat(nextRollingStock.labels)
                    };
                    _proto.getBoundingRect = function() {
                        return this.bBox
                    };
                    _proto.shift = function(shiftLength) {
                        var _this = this;
                        this.labels.forEach((function(label) {
                            var bBox = label.getBoundingRect();
                            var coords = _this.shiftFunction(bBox, shiftLength);
                            if (!label.hideInsideLabel(coords)) {
                                label.shift(coords.x, coords.y)
                            }
                        }));
                        this.bBox.end -= shiftLength;
                        this.bBox.start -= shiftLength
                    };
                    _proto.setRollingStockInCanvas = function(canvas) {
                        if (this.bBox.end > canvas.end) {
                            this.shift(this.bBox.end - canvas.end)
                        }
                    };
                    _proto.getLabels = function() {
                        return this.labels
                    };
                    _proto.value = function() {
                        return this.labels[0].getData().value
                    };
                    _proto.getInitialPosition = function() {
                        return this.initialPosition
                    };
                    _proto.changeBoxWidth = function(width) {
                        this.bBox.end += width;
                        this.bBox.width += width
                    };
                    return RollingStock
                }();
                exports.RollingStock = RollingStock
            },
        55845:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/m_base_widget.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../core/devices */ 20530));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 73349));
                var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_component */ 13046));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../core/utils/size */ 58664);
                var _type2 = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 58201);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../events/core/events_engine */ 55994));
                var _base_theme_manager = __webpack_require__( /*! ../../../viz/core/base_theme_manager */ 43637);
                var _base_widget = __webpack_require__( /*! ../../../viz/core/base_widget.utils */ 98469);
                var _errors_warnings = _interopRequireDefault(__webpack_require__( /*! ../../../viz/core/errors_warnings */ 80726));
                var _helpers = __webpack_require__( /*! ../../../viz/core/helpers */ 3603);
                var _layout = _interopRequireDefault(__webpack_require__( /*! ../../../viz/core/layout */ 94551));
                var _renderer2 = __webpack_require__( /*! ../../../viz/core/renderers/renderer */ 56453);
                var _utils = __webpack_require__( /*! ../../../viz/core/utils */ 19157);
                var _m_charts = _interopRequireDefault(__webpack_require__( /*! ../../common/m_charts */ 66798));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                var floor = Math.floor;
                var log = _errors_warnings.default.log;
                var baseOptionMethod = _dom_component.default.prototype.option;

                function getTrue() {
                    return true
                }

                function getFalse() {
                    return false
                }

                function defaultOnIncidentOccurred(e) {
                    if (!e.component._eventsStrategy.hasEvent("incidentOccurred")) {
                        log.apply(null, [e.target.id].concat(e.target.args || []))
                    }
                }

                function pickPositiveValue(values) {
                    return values.reduce((function(result, value) {
                        return value > 0 && !result ? value : result
                    }), 0)
                }

                function callForEach(functions) {
                    functions.forEach((function(c) {
                        return c()
                    }))
                }

                function floorCanvasDimensions(canvas) {
                    return _extends(_extends({}, canvas), {
                        height: floor(canvas.height),
                        width: floor(canvas.width)
                    })
                }
                var isServerSide = !(0, _window.hasWindow)();
                var baseWidget = isServerSide ? function() {
                    var emptyComponentConfig = {
                        _initTemplates: function() {},
                        ctor: function(element, options) {
                            this.callBase(element, options);
                            var sizedElement = _dom_adapter.default.createElement("div");
                            var width = options && (0, _type2.isNumeric)(options.width) ? "".concat(options.width, "px") : "100%";
                            var height = options && (0, _type2.isNumeric)(options.height) ? "".concat(options.height, "px") : "".concat(this._getDefaultSize().height, "px");
                            _dom_adapter.default.setStyle(sizedElement, "width", width);
                            _dom_adapter.default.setStyle(sizedElement, "height", height);
                            _dom_adapter.default.setClass(sizedElement, "dx-sized-element", false);
                            _dom_adapter.default.insertElement(element, sizedElement)
                        }
                    };
                    var EmptyComponent = _dom_component.default.inherit(emptyComponentConfig);
                    var originalInherit = EmptyComponent.inherit;
                    EmptyComponent.inherit = function(config) {
                        Object.keys(config).forEach((function(field) {
                            if ((0, _type2.isFunction)(config[field]) && "_" !== field.substr(0, 1) && "option" !== field || "_dispose" === field || "_optionChanged" === field) {
                                config[field] = _common.noop
                            }
                        }));
                        return originalInherit.call(this, config)
                    };
                    return EmptyComponent
                }() : _dom_component.default.inherit({
                    _eventsMap: {
                        onIncidentOccurred: {
                            name: "incidentOccurred",
                            actionSettings: {
                                excludeValidators: ["disabled"]
                            }
                        },
                        onDrawn: {
                            name: "drawn",
                            actionSettings: {
                                excludeValidators: ["disabled"]
                            }
                        }
                    },
                    _getDefaultOptions: function() {
                        return (0, _extend.extend)(this.callBase(), {
                            onIncidentOccurred: defaultOnIncidentOccurred
                        })
                    },
                    _useLinks: true,
                    _init: function() {
                        var _this = this;
                        this._$element.children(".".concat("dx-sized-element")).remove();
                        this._graphicObjects = {};
                        this.callBase.apply(this, arguments);
                        this._changesLocker = 0;
                        this._optionChangedLocker = 0;
                        this._asyncFirstDrawing = true;
                        this._changes = (0, _helpers.changes)();
                        this._suspendChanges();
                        this._themeManager = this._createThemeManager();
                        this._themeManager.setCallback((function() {
                            _this._requestChange(_this._themeDependentChanges)
                        }));
                        this._renderElementAttributes();
                        this._initRenderer();
                        var useLinks = this._useLinks;
                        if (useLinks) {
                            this._renderer.root.enableLinks().virtualLink("core").virtualLink("peripheral")
                        }
                        this._renderVisibilityChange();
                        this._attachVisibilityChangeHandlers();
                        this._toggleParentsScrollSubscription(this._isVisible());
                        this._initEventTrigger();
                        this._incidentOccurred = (0, _base_widget.createIncidentOccurred)(this.NAME, this._eventTrigger);
                        this._layout = new _layout.default;
                        if (useLinks) {
                            this._renderer.root.linkAfter("core")
                        }
                        this._initPlugins();
                        this._initCore();
                        if (useLinks) {
                            this._renderer.root.linkAfter()
                        }
                        this._change(this._initialChanges)
                    },
                    _createThemeManager: function() {
                        return new _base_theme_manager.BaseThemeManager(this._getThemeManagerOptions())
                    },
                    _getThemeManagerOptions: function() {
                        return {
                            themeSection: this._themeSection,
                            fontFields: this._fontFields
                        }
                    },
                    _initialChanges: ["LAYOUT", "RESIZE_HANDLER", "THEME", "DISABLED"],
                    _initPlugins: function() {
                        var _this2 = this;
                        (0, _iterator.each)(this._plugins, (function(_, plugin) {
                            plugin.init.call(_this2)
                        }))
                    },
                    _disposePlugins: function() {
                        var _this3 = this;
                        (0, _iterator.each)(this._plugins.slice().reverse(), (function(_, plugin) {
                            plugin.dispose.call(_this3)
                        }))
                    },
                    _change: function(codes) {
                        this._changes.add(codes)
                    },
                    _suspendChanges: function() {
                        this._changesLocker += 1
                    },
                    _resumeChanges: function() {
                        if (0 === --this._changesLocker && this._changes.count() > 0 && !this._applyingChanges) {
                            this._renderer.lock();
                            this._applyingChanges = true;
                            this._applyChanges();
                            this._changes.reset();
                            this._applyingChanges = false;
                            this._changesApplied();
                            this._renderer.unlock();
                            if (this._optionsQueue) {
                                this._applyQueuedOptions()
                            }
                            this.resolveItemsDeferred(this._legend ? [this._legend] : []);
                            this._optionChangedLocker += 1;
                            this._notify();
                            this._optionChangedLocker -= 1
                        }
                    },
                    resolveItemsDeferred: function(items) {
                        this._resolveDeferred(this._getTemplatesItems(items))
                    },
                    _collectTemplatesFromItems: function(items) {
                        return items.reduce((function(prev, i) {
                            return {
                                items: prev.items.concat(i.getTemplatesDef()),
                                groups: prev.groups.concat(i.getTemplatesGroups())
                            }
                        }), {
                            items: [],
                            groups: []
                        })
                    },
                    _getTemplatesItems: function(items) {
                        var elements = this._collectTemplatesFromItems(items);
                        var extraItems = this._getExtraTemplatesItems();
                        return {
                            items: extraItems.items.concat(elements.items),
                            groups: extraItems.groups.concat(elements.groups),
                            launchRequest: [extraItems.launchRequest],
                            doneRequest: [extraItems.doneRequest]
                        }
                    },
                    _getExtraTemplatesItems: function() {
                        return {
                            items: [],
                            groups: [],
                            launchRequest: function() {},
                            doneRequest: function() {}
                        }
                    },
                    _resolveDeferred: function(_ref) {
                        var _this4 = this;
                        var items = _ref.items,
                            launchRequest = _ref.launchRequest,
                            doneRequest = _ref.doneRequest,
                            groups = _ref.groups;
                        this._setGroupsVisibility(groups, "hidden");
                        if (this._changesApplying) {
                            this._changesApplying = false;
                            callForEach(doneRequest);
                            return
                        }
                        var syncRendering = true;
                        _deferred.when.apply(this, items).done((function() {
                            if (syncRendering) {
                                _this4._setGroupsVisibility(groups, "visible");
                                return
                            }
                            callForEach(launchRequest);
                            _this4._changesApplying = true;
                            var changes = ["LAYOUT", "FULL_RENDER"];
                            if (_this4._asyncFirstDrawing) {
                                changes.push("FORCE_FIRST_DRAWING");
                                _this4._asyncFirstDrawing = false
                            } else {
                                changes.push("FORCE_DRAWING")
                            }
                            _this4._requestChange(changes);
                            _this4._setGroupsVisibility(groups, "visible")
                        }));
                        syncRendering = false
                    },
                    _setGroupsVisibility: function(groups, visibility) {
                        groups.forEach((function(g) {
                            return g.attr({
                                visibility: visibility
                            })
                        }))
                    },
                    _applyQueuedOptions: function() {
                        var queue = this._optionsQueue;
                        this._optionsQueue = null;
                        this.beginUpdate();
                        (0, _iterator.each)(queue, (function(_, action) {
                            action()
                        }));
                        this.endUpdate()
                    },
                    _requestChange: function(codes) {
                        this._suspendChanges();
                        this._change(codes);
                        this._resumeChanges()
                    },
                    _applyChanges: function() {
                        var changes = this._changes;
                        var order = this._totalChangesOrder;
                        var changesOrderLength = order.length;
                        for (var i = 0; i < changesOrderLength; i += 1) {
                            if (changes.has(order[i])) {
                                this["_change_".concat(order[i])]()
                            }
                        }
                    },
                    _optionChangesOrder: ["EVENTS", "THEME", "RENDERER", "RESIZE_HANDLER"],
                    _layoutChangesOrder: ["ELEMENT_ATTR", "CONTAINER_SIZE", "LAYOUT"],
                    _customChangesOrder: ["DISABLED"],
                    _change_EVENTS: function() {
                        this._eventTrigger.applyChanges()
                    },
                    _change_THEME: function() {
                        this._setThemeAndRtl()
                    },
                    _change_RENDERER: function() {
                        this._setRendererOptions()
                    },
                    _change_RESIZE_HANDLER: function() {
                        this._setupResizeHandler()
                    },
                    _change_ELEMENT_ATTR: function() {
                        this._renderElementAttributes();
                        this._change(["CONTAINER_SIZE"])
                    },
                    _change_CONTAINER_SIZE: function() {
                        this._updateSize()
                    },
                    _change_LAYOUT: function() {
                        this._setContentSize()
                    },
                    _change_DISABLED: function() {
                        var renderer = this._renderer;
                        var root = renderer.root;
                        if (this.option("disabled")) {
                            this._initDisabledState = root.attr("pointer-events");
                            root.attr({
                                "pointer-events": "none",
                                filter: renderer.getGrayScaleFilter().id
                            })
                        } else if ("none" === root.attr("pointer-events")) {
                            root.attr({
                                "pointer-events": (0, _type2.isDefined)(this._initDisabledState) ? this._initDisabledState : null,
                                filter: null
                            })
                        }
                    },
                    _themeDependentChanges: ["RENDERER"],
                    _initRenderer: function() {
                        var rawCanvas = this._calculateRawCanvas();
                        this._canvas = floorCanvasDimensions(rawCanvas);
                        this._renderer = new _renderer2.Renderer({
                            cssClass: "".concat(this._rootClassPrefix, " ").concat(this._rootClass),
                            pathModified: this.option("pathModified"),
                            container: this._$element[0]
                        });
                        this._renderer.resize(this._canvas.width, this._canvas.height)
                    },
                    _disposeRenderer: function() {
                        this._renderer.dispose()
                    },
                    _disposeGraphicObjects: function() {
                        var _this5 = this;
                        Object.keys(this._graphicObjects).forEach((function(id) {
                            _this5._graphicObjects[id].dispose()
                        }));
                        this._graphicObjects = null
                    },
                    _getAnimationOptions: _common.noop,
                    render: function() {
                        this._requestChange(["CONTAINER_SIZE"]);
                        var visible = this._isVisible();
                        this._toggleParentsScrollSubscription(visible);
                        !visible && this._stopCurrentHandling()
                    },
                    _toggleParentsScrollSubscription: function(subscribe) {
                        var $parents = (0, _renderer.default)(this._renderer.root.element).parents();
                        if ("generic" === _devices.default.real().platform) {
                            $parents = $parents.add((0, _window.getWindow)())
                        }
                        this._proxiedTargetParentsScrollHandler = this._proxiedTargetParentsScrollHandler || function() {
                            this._stopCurrentHandling()
                        }.bind(this);
                        _events_engine.default.off((0, _renderer.default)("").add(this._$prevRootParents), "scroll.viz_widgets", this._proxiedTargetParentsScrollHandler);
                        if (subscribe) {
                            _events_engine.default.on($parents, "scroll.viz_widgets", this._proxiedTargetParentsScrollHandler);
                            this._$prevRootParents = $parents
                        }
                    },
                    _stopCurrentHandling: _common.noop,
                    _dispose: function() {
                        if (this._disposed) {
                            return
                        }
                        this.callBase.apply(this, arguments);
                        this._toggleParentsScrollSubscription(false);
                        this._removeResizeHandler();
                        this._layout.dispose();
                        this._eventTrigger.dispose();
                        this._disposeCore();
                        this._disposePlugins();
                        this._disposeGraphicObjects();
                        this._disposeRenderer();
                        this._themeManager.dispose();
                        this._themeManager = null;
                        this._renderer = null;
                        this._eventTrigger = null
                    },
                    _initEventTrigger: function() {
                        var _this6 = this;
                        this._eventTrigger = (0, _base_widget.createEventTrigger)(this._eventsMap, (function(name, actionSettings) {
                            return _this6._createActionByOption(name, actionSettings)
                        }))
                    },
                    _calculateRawCanvas: function() {
                        var _this7 = this;
                        var size = this.option("size") || {};
                        var margin = this.option("margin") || {};
                        var defaultCanvas = this._getDefaultSize() || {};
                        var getSizeOfSide = function(size, side, getter) {
                            if ((value = size[side], (0, _type2.isDefined)(value) && value > 0) || !(0, _window.hasWindow)()) {
                                return 0
                            }
                            var value;
                            var elementSize = getter(_this7._$element);
                            return elementSize <= 1 ? 0 : elementSize
                        };
                        var elementWidth = getSizeOfSide(size, "width", (function(x) {
                            return (0, _size.getWidth)(x)
                        }));
                        var elementHeight = getSizeOfSide(size, "height", (function(x) {
                            return (0, _size.getHeight)(x)
                        }));
                        var canvas = {
                            width: size.width <= 0 ? 0 : pickPositiveValue([size.width, elementWidth, defaultCanvas.width]),
                            height: size.height <= 0 ? 0 : pickPositiveValue([size.height, elementHeight, defaultCanvas.height]),
                            left: pickPositiveValue([margin.left, defaultCanvas.left]),
                            top: pickPositiveValue([margin.top, defaultCanvas.top]),
                            right: pickPositiveValue([margin.right, defaultCanvas.right]),
                            bottom: pickPositiveValue([margin.bottom, defaultCanvas.bottom])
                        };
                        if (canvas.width - canvas.left - canvas.right <= 0 || canvas.height - canvas.top - canvas.bottom <= 0) {
                            canvas = {
                                width: 0,
                                height: 0
                            }
                        }
                        return canvas
                    },
                    _updateSize: function() {
                        var rawCanvas = this._calculateRawCanvas();
                        if ((canvas1 = this._canvas, canvas2 = rawCanvas, sizeLessThreshold = ["width", "height"].every((function(key) {
                                return Math.abs(canvas1[key] - canvas2[key]) < 1
                            })), canvasCoordsIsEqual = ["left", "right", "top", "bottom"].every((function(key) {
                                return canvas1[key] === canvas2[key]
                            })), !(sizeLessThreshold && canvasCoordsIsEqual)) || this.__forceRender) {
                            this._canvas = floorCanvasDimensions(rawCanvas);
                            this._recreateSizeDependentObjects(true);
                            this._renderer.resize(this._canvas.width, this._canvas.height);
                            this._change(["LAYOUT"])
                        }
                        var canvas1, canvas2, sizeLessThreshold, canvasCoordsIsEqual
                    },
                    _recreateSizeDependentObjects: _common.noop,
                    _getMinSize: function() {
                        return [0, 0]
                    },
                    _getAlignmentRect: _common.noop,
                    _setContentSize: function() {
                        var canvas = this._canvas;
                        var layout = this._layout;
                        var rect = canvas.width > 0 && canvas.height > 0 ? [canvas.left, canvas.top, canvas.width - canvas.right, canvas.height - canvas.bottom] : [0, 0, 0, 0];
                        rect = layout.forward(rect, this._getMinSize());
                        var nextRect = this._applySize(rect) || rect;
                        layout.backward(nextRect, this._getAlignmentRect() || nextRect)
                    },
                    _getOption: function(name, isScalar) {
                        var theme = this._themeManager.theme(name);
                        var option = this.option(name);
                        return isScalar ? void 0 !== option ? option : theme : (0, _extend.extend)(true, {}, theme, option)
                    },
                    _setupResizeHandler: function() {
                        var _this8 = this;
                        var redrawOnResize = (0, _utils.parseScalar)(this._getOption("redrawOnResize", true), true);
                        if (this._disposeResizeHandler) {
                            this._removeResizeHandler()
                        }
                        this._disposeResizeHandler = (0, _base_widget.createResizeHandler)(this._$element[0], redrawOnResize, (function() {
                            return _this8._requestChange(["CONTAINER_SIZE"])
                        }))
                    },
                    _removeResizeHandler: function() {
                        if (this._disposeResizeHandler) {
                            this._disposeResizeHandler();
                            this._disposeResizeHandler = null
                        }
                    },
                    _onBeginUpdate: _common.noop,
                    beginUpdate: function() {
                        if (this._initialized && this._isUpdateAllowed()) {
                            this._onBeginUpdate();
                            this._suspendChanges()
                        }
                        this.callBase.apply(this, arguments);
                        return this
                    },
                    endUpdate: function() {
                        this.callBase();
                        this._isUpdateAllowed() && this._resumeChanges();
                        return this
                    },
                    option: function(name) {
                        if (this._initialized && this._applyingChanges && (arguments.length > 1 || (0, _type2.isObject)(name))) {
                            this._optionsQueue = this._optionsQueue || [];
                            this._optionsQueue.push(this._getActionForUpdating(arguments))
                        } else {
                            return baseOptionMethod.apply(this, arguments)
                        }
                    },
                    _getActionForUpdating: function(args) {
                        var _this9 = this;
                        return function() {
                            baseOptionMethod.apply(_this9, args)
                        }
                    },
                    _clean: _common.noop,
                    _render: _common.noop,
                    _optionChanged: function(arg) {
                        var _this10 = this;
                        if (this._optionChangedLocker) {
                            return
                        }
                        var partialChanges = this.getPartialChangeOptionsName(arg);
                        var changes = [];
                        if (partialChanges.length > 0) {
                            partialChanges.forEach((function(pc) {
                                return changes.push(_this10._partialOptionChangesMap[pc])
                            }))
                        } else {
                            changes.push(this._optionChangesMap[arg.name])
                        }
                        changes = changes.filter((function(c) {
                            return !!c
                        }));
                        if (this._eventTrigger.change(arg.name)) {
                            this._change(["EVENTS"])
                        } else if (changes.length > 0) {
                            this._change(changes)
                        } else {
                            this.callBase.apply(this, arguments)
                        }
                    },
                    _notify: _common.noop,
                    _changesApplied: _common.noop,
                    _optionChangesMap: {
                        size: "CONTAINER_SIZE",
                        margin: "CONTAINER_SIZE",
                        redrawOnResize: "RESIZE_HANDLER",
                        theme: "THEME",
                        rtlEnabled: "THEME",
                        encodeHtml: "THEME",
                        elementAttr: "ELEMENT_ATTR",
                        disabled: "DISABLED"
                    },
                    _partialOptionChangesMap: {},
                    _partialOptionChangesPath: {},
                    getPartialChangeOptionsName: function(changedOption) {
                        var _this11 = this;
                        var fullName = changedOption.fullName;
                        var sections = fullName.split(/[.]/);
                        var name = changedOption.name;
                        var value = changedOption.value;
                        var options = this._partialOptionChangesPath[name];
                        var partialChangeOptionsName = [];
                        if (options) {
                            if (true === options) {
                                partialChangeOptionsName.push(name)
                            } else {
                                options.forEach((function(op) {
                                    fullName.indexOf(op) >= 0 && partialChangeOptionsName.push(op)
                                }));
                                if (1 === sections.length) {
                                    if ("object" === (0, _type2.type)(value)) {
                                        this._addOptionsNameForPartialUpdate(value, options, partialChangeOptionsName)
                                    } else if ("array" === (0, _type2.type)(value)) {
                                        if (value.length > 0 && value.every((function(item) {
                                                return _this11._checkOptionsForPartialUpdate(item, options)
                                            }))) {
                                            value.forEach((function(item) {
                                                _this11._addOptionsNameForPartialUpdate(item, options, partialChangeOptionsName)
                                            }))
                                        }
                                    }
                                }
                            }
                        }
                        return partialChangeOptionsName.filter((function(value, index, self) {
                            return self.indexOf(value) === index
                        }))
                    },
                    _checkOptionsForPartialUpdate: function(optionObject, options) {
                        return !Object.keys(optionObject).some((function(key) {
                            return -1 === options.indexOf(key)
                        }))
                    },
                    _addOptionsNameForPartialUpdate: function(optionObject, options, partialChangeOptionsName) {
                        var optionKeys = Object.keys(optionObject);
                        if (this._checkOptionsForPartialUpdate(optionObject, options)) {
                            optionKeys.forEach((function(key) {
                                return options.indexOf(key) > -1 && partialChangeOptionsName.push(key)
                            }))
                        }
                    },
                    _visibilityChanged: function() {
                        this.render()
                    },
                    _setThemeAndRtl: function() {
                        this._themeManager.setTheme(this.option("theme"), this.option("rtlEnabled"))
                    },
                    _getRendererOptions: function() {
                        return {
                            rtl: this.option("rtlEnabled"),
                            encodeHtml: this.option("encodeHtml"),
                            animation: this._getAnimationOptions()
                        }
                    },
                    _setRendererOptions: function() {
                        this._renderer.setOptions(this._getRendererOptions())
                    },
                    svg: function() {
                        return this._renderer.svg()
                    },
                    getSize: function() {
                        var canvas = this._canvas || {};
                        return {
                            width: canvas.width,
                            height: canvas.height
                        }
                    },
                    isReady: getFalse,
                    _dataIsReady: getTrue,
                    _resetIsReady: function() {
                        this.isReady = getFalse
                    },
                    _renderGraphicObjects: function() {
                        var _this12 = this;
                        var renderer = this._renderer;
                        var graphics = _m_charts.default.getGraphicObjects();
                        Object.keys(graphics).forEach((function(id) {
                            if (!_this12._graphicObjects[id]) {
                                var _graphics$id = graphics[id],
                                    _type = _graphics$id.type,
                                    colors = _graphics$id.colors,
                                    rotationAngle = _graphics$id.rotationAngle,
                                    template = _graphics$id.template,
                                    width = _graphics$id.width,
                                    height = _graphics$id.height;
                                switch (_type) {
                                    case "linear":
                                        _this12._graphicObjects[id] = renderer.linearGradient(colors, id, rotationAngle);
                                        break;
                                    case "radial":
                                        _this12._graphicObjects[id] = renderer.radialGradient(colors, id);
                                        break;
                                    case "pattern":
                                        _this12._graphicObjects[id] = renderer.customPattern(id, _this12._getTemplate(template), width, height)
                                }
                            }
                        }))
                    },
                    _drawn: function() {
                        var _this13 = this;
                        this.isReady = getFalse;
                        if (this._dataIsReady()) {
                            this._renderer.onEndAnimation((function() {
                                _this13.isReady = getTrue
                            }))
                        }
                        this._eventTrigger("drawn", {})
                    }
                });
                var _default = baseWidget;
                exports.default = _default;
                (0, _helpers.replaceInherit)(baseWidget)
            },
        4096:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/m_chart.js ***!
              \***********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 99393));
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _math = __webpack_require__( /*! ../../core/utils/math */ 60810);
                var _size = __webpack_require__( /*! ../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 58201);
                var _crosshair = __webpack_require__( /*! ../../viz/chart_components/crosshair */ 97574);
                var _layout_manager = __webpack_require__( /*! ../../viz/chart_components/layout_manager */ 61189);
                var _multi_axes_synchronizer = _interopRequireDefault(__webpack_require__( /*! ../../viz/chart_components/multi_axes_synchronizer */ 42597));
                var _scroll_bar = __webpack_require__( /*! ../../viz/chart_components/scroll_bar */ 97882);
                var _shutter_zoom = _interopRequireDefault(__webpack_require__( /*! ../../viz/chart_components/shutter_zoom */ 70714));
                var _zoom_and_pan = _interopRequireDefault(__webpack_require__( /*! ../../viz/chart_components/zoom_and_pan */ 59345));
                var _annotations = __webpack_require__( /*! ../../viz/core/annotations */ 77129);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);
                var _range_data_calculator = _interopRequireDefault(__webpack_require__( /*! ../../viz/series/helpers/range_data_calculator */ 63407));
                var _range = __webpack_require__( /*! ../../viz/translators/range */ 21177);
                var _utils2 = __webpack_require__( /*! ../../viz/utils */ 34434);
                var _m_advanced_chart = __webpack_require__( /*! ./chart_components/m_advanced_chart */ 41690);
                var _m_base_chart = __webpack_require__( /*! ./chart_components/m_base_chart */ 14107);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var DEFAULT_PANES = [{
                    name: "default",
                    border: {}
                }];
                var isArray = Array.isArray;

                function changeVisibilityAxisGrids(axis, gridVisibility, minorGridVisibility) {
                    var gridOpt = axis.getOptions().grid;
                    var minorGridOpt = axis.getOptions().minorGrid;
                    gridOpt.visible = gridVisibility;
                    minorGridOpt && (minorGridOpt.visible = minorGridVisibility)
                }

                function compareAxes(a, b) {
                    return a.priority - b.priority
                }

                function doesPaneExist(panes, paneName) {
                    var found = false;
                    (0, _iterator.each)(panes, (function(_, pane) {
                        if (pane.name === paneName) {
                            found = true;
                            return false
                        }
                        return
                    }));
                    return found
                }

                function accumulate(field, src1, src2, auxSpacing) {
                    var val1 = src1[field] || 0;
                    var val2 = src2[field] || 0;
                    return val1 + val2 + (val1 && val2 ? auxSpacing : 0)
                }

                function pickMax(field, src1, src2) {
                    return pickMaxValue(src1[field], src2[field])
                }

                function pickMaxValue(val1, val2) {
                    return Math.max(val1 || 0, val2 || 0)
                }

                function getAxisMargins(axis) {
                    return axis.getMargins()
                }

                function getHorizontalAxesMargins(axes, getMarginsFunc) {
                    return axes.reduce((function(margins, axis) {
                        var _a;
                        var axisMargins = getMarginsFunc(axis);
                        var paneMargins = margins.panes[axis.pane] = margins.panes[axis.pane] || {};
                        var spacing = axis.getMultipleAxesSpacing();
                        paneMargins.top = accumulate("top", paneMargins, axisMargins, spacing);
                        paneMargins.bottom = accumulate("bottom", paneMargins, axisMargins, spacing);
                        paneMargins.left = pickMax("left", paneMargins, axisMargins);
                        paneMargins.right = pickMax("right", paneMargins, axisMargins);
                        margins.top = pickMax("top", paneMargins, margins);
                        margins.bottom = pickMax("bottom", paneMargins, margins);
                        margins.left = pickMax("left", paneMargins, margins);
                        margins.right = pickMax("right", paneMargins, margins);
                        var orthogonalAxis = null === (_a = axis.getOrthogonalAxis) || void 0 === _a ? void 0 : _a.call(axis);
                        var shouldResetPositionMargin = (null === orthogonalAxis || void 0 === orthogonalAxis ? void 0 : orthogonalAxis.customPositionIsAvailable()) && (!axis.customPositionIsBoundaryOrthogonalAxis() || !orthogonalAxis.customPositionEqualsToPredefined());
                        if (shouldResetPositionMargin) {
                            margins[orthogonalAxis.getResolvedBoundaryPosition()] = 0
                        }
                        return margins
                    }), {
                        panes: {}
                    })
                }

                function getVerticalAxesMargins(axes) {
                    return axes.reduce((function(margins, axis) {
                        var axisMargins = axis.getMargins();
                        var paneMargins = margins.panes[axis.pane] = margins.panes[axis.pane] || {};
                        var spacing = axis.getMultipleAxesSpacing();
                        paneMargins.top = pickMax("top", paneMargins, axisMargins);
                        paneMargins.bottom = pickMax("bottom", paneMargins, axisMargins);
                        paneMargins.left = accumulate("left", paneMargins, axisMargins, spacing);
                        paneMargins.right = accumulate("right", paneMargins, axisMargins, spacing);
                        margins.top = pickMax("top", paneMargins, margins);
                        margins.bottom = pickMax("bottom", paneMargins, margins);
                        margins.left = pickMax("left", paneMargins, margins);
                        margins.right = pickMax("right", paneMargins, margins);
                        return margins
                    }), {
                        panes: {}
                    })
                }

                function performActionOnAxes(axes, action, actionArgument1, actionArgument2, actionArgument3) {
                    axes.forEach((function(axis) {
                        axis[action](null === actionArgument1 || void 0 === actionArgument1 ? void 0 : actionArgument1[axis.pane], (null === actionArgument2 || void 0 === actionArgument2 ? void 0 : actionArgument2[axis.pane]) || actionArgument2, actionArgument3)
                    }))
                }

                function shrinkCanvases(isRotated, canvases, sizes, verticalMargins, horizontalMargins) {
                    function getMargin(side, margins, pane) {
                        var m = !(isRotated ? ["left", "right"] : ["top", "bottom"]).includes(side) ? margins : margins.panes[pane] || {};
                        return m[side]
                    }

                    function getMaxMargin(side, margins1, margins2, pane) {
                        return pickMaxValue(getMargin(side, margins1, pane), getMargin(side, margins2, pane))
                    }
                    var getOriginalField = function(field) {
                        return "original".concat(field[0].toUpperCase()).concat(field.slice(1))
                    };

                    function shrink(canvases, paneNames, sizeField, startMargin, endMargin, oppositeMargins) {
                        paneNames = paneNames.sort((function(p1, p2) {
                            return canvases[p2][startMargin] - canvases[p1][startMargin]
                        }));
                        paneNames.forEach((function(pane) {
                            var canvas = canvases[pane];
                            oppositeMargins.forEach((function(margin) {
                                canvas[margin] = canvas[getOriginalField(margin)] + getMaxMargin(margin, verticalMargins, horizontalMargins, pane)
                            }))
                        }));
                        var firstPane = canvases[paneNames[0]];
                        var initialEmptySpace = firstPane[sizeField] - firstPane[getOriginalField(endMargin)] - canvases[paneNames.at(-1)][getOriginalField(startMargin)];
                        var emptySpace = paneNames.reduce((function(space, paneName) {
                            var maxStartMargin = getMaxMargin(startMargin, verticalMargins, horizontalMargins, paneName);
                            var maxEndMargin = getMaxMargin(endMargin, verticalMargins, horizontalMargins, paneName);
                            return space - maxStartMargin - maxEndMargin
                        }), initialEmptySpace) - _utils.PANE_PADDING * (paneNames.length - 1);
                        emptySpace -= Object.keys(sizes).reduce((function(prev, key) {
                            var currentHeight = !(0, _utils.isRelativeHeightPane)(sizes[key]) ? sizes[key].height : 0;
                            return prev + currentHeight
                        }), 0);
                        var initialOffset = firstPane[sizeField] - firstPane[getOriginalField(endMargin)] - (emptySpace < 0 ? emptySpace : 0);
                        paneNames.reduce((function(offset, pane) {
                            var canvas = canvases[pane];
                            var paneSize = sizes[pane];
                            offset -= getMaxMargin(endMargin, verticalMargins, horizontalMargins, pane);
                            canvas[endMargin] = firstPane[sizeField] - offset;
                            offset -= !(0, _utils.isRelativeHeightPane)(paneSize) ? paneSize.height : Math.floor(emptySpace * paneSize.height);
                            canvas[startMargin] = offset;
                            offset -= getMaxMargin(startMargin, verticalMargins, horizontalMargins, pane) + _utils.PANE_PADDING;
                            return offset
                        }), initialOffset)
                    }
                    var paneNames = Object.keys(canvases);
                    if (!isRotated) {
                        shrink(canvases, paneNames, "height", "top", "bottom", ["left", "right"])
                    } else {
                        shrink(canvases, paneNames, "width", "left", "right", ["top", "bottom"])
                    }
                    return canvases
                }

                function drawAxesWithTicks(axes, condition, canvases, panesBorderOptions) {
                    if (condition) {
                        performActionOnAxes(axes, "createTicks", canvases);
                        _multi_axes_synchronizer.default.synchronize(axes)
                    }
                    performActionOnAxes(axes, "draw", !condition && canvases, panesBorderOptions)
                }

                function shiftAxis(side1, side2) {
                    var shifts = {};
                    return function(axis) {
                        if (!axis.customPositionIsAvailable() || axis.customPositionEqualsToPredefined()) {
                            var shift = shifts[axis.pane] = shifts[axis.pane] || {
                                top: 0,
                                left: 0,
                                bottom: 0,
                                right: 0
                            };
                            var spacing = axis.getMultipleAxesSpacing();
                            var margins = axis.getMargins();
                            axis.shift(shift);
                            shift[side1] = accumulate(side1, shift, margins, spacing);
                            shift[side2] = accumulate(side2, shift, margins, spacing)
                        } else {
                            axis.shift({
                                top: 0,
                                left: 0,
                                bottom: 0,
                                right: 0
                            })
                        }
                    }
                }

                function getCommonSize(side, margins) {
                    var size = 0;
                    var paneMargins;
                    Object.keys(margins.panes).forEach((function(pane) {
                        paneMargins = margins.panes[pane];
                        size += "height" === side ? paneMargins.top + paneMargins.bottom : paneMargins.left + paneMargins.right
                    }));
                    return size
                }

                function checkUsedSpace(sizeShortage, side, axes, getMarginFunc) {
                    var size = 0;
                    if (sizeShortage[side] > 0) {
                        size = getCommonSize(side, getMarginFunc(axes, getAxisMargins));
                        performActionOnAxes(axes, "hideTitle");
                        sizeShortage[side] -= size - getCommonSize(side, getMarginFunc(axes, getAxisMargins))
                    }
                    if (sizeShortage[side] > 0) {
                        performActionOnAxes(axes, "hideOuterElements")
                    }
                }
                var isOverlay = function(currentPoint, overlayPoint, pointRadius) {
                    var pointHitsLeftBorder = overlayPoint.x - pointRadius <= currentPoint.x;
                    var pointHitsRightBorder = overlayPoint.x + pointRadius >= currentPoint.x;
                    var pointHitsTopBorder = overlayPoint.y - pointRadius <= currentPoint.y;
                    var pointHitsBottomBorder = overlayPoint.y + pointRadius >= currentPoint.y;
                    var isPointOverlappedHorizontally = pointHitsLeftBorder && pointHitsRightBorder;
                    var isPointOverlappedVertically = pointHitsTopBorder && pointHitsBottomBorder;
                    return isPointOverlappedHorizontally && isPointOverlappedVertically
                };
                var isPointOverlapped = function(currentPoint, points, skipSamePointsComparing) {
                    var radiusPoint = currentPoint.getOptions().size / 2;
                    for (var i = 0; i < points.length; i += 1) {
                        if (!skipSamePointsComparing) {
                            var isXCoordinateSame = points[i].x === currentPoint.x;
                            var isYCoordinateSame = points[i].y === currentPoint.y;
                            if (isXCoordinateSame && isYCoordinateSame) {
                                continue
                            }
                        }
                        if (isOverlay(currentPoint, points[i], radiusPoint)) {
                            return true
                        }
                    }
                    return false
                };
                var dxChart = _m_advanced_chart.AdvancedChart.inherit({
                    _themeSection: "chart",
                    _fontFields: ["crosshair.label.font"],
                    _initCore: function() {
                        this.paneAxis = {};
                        this.callBase()
                    },
                    _init: function() {
                        this._containerInitialHeight = (0, _window.hasWindow)() ? (0, _size.getHeight)(this._$element) : 0;
                        this.callBase()
                    },
                    _correctAxes: function() {
                        this._correctValueAxes(true)
                    },
                    _setDeprecatedOptions: function() {
                        this.callBase();
                        (0, _extend2.extend)(this._deprecatedOptions, {
                            "argumentAxis.aggregateByCategory": {
                                since: "23.1",
                                message: "Use the aggregation.enabled property"
                            }
                        })
                    },
                    _getExtraOptions: _common.noop,
                    _createPanes: function() {
                        var panes = this.option("panes");
                        var panesNameCounter = 0;
                        var defaultPane;
                        if (!panes || isArray(panes) && !panes.length) {
                            panes = DEFAULT_PANES
                        }
                        this.callBase();
                        defaultPane = this.option("defaultPane");
                        panes = (0, _extend2.extend)(true, [], isArray(panes) ? panes : [panes]);
                        (0, _iterator.each)(panes, (function(_, pane) {
                            pane.name = !(0, _type.isDefined)(pane.name) ? "default" + panesNameCounter++ : pane.name
                        }));
                        if ((0, _type.isDefined)(defaultPane)) {
                            if (!doesPaneExist(panes, defaultPane)) {
                                this._incidentOccurred("W2101", [defaultPane]);
                                defaultPane = panes[panes.length - 1].name
                            }
                        } else {
                            defaultPane = panes[panes.length - 1].name
                        }
                        this.defaultPane = defaultPane;
                        panes = this._isRotated() ? panes.reverse() : panes;
                        return panes
                    },
                    _getAxisRenderingOptions: function() {
                        return {
                            axisType: "xyAxes",
                            drawingType: "linear"
                        }
                    },
                    _prepareAxisOptions: function(typeSelector, userOptions, rotated) {
                        return {
                            isHorizontal: "argumentAxis" === typeSelector !== rotated,
                            containerColor: this._themeManager.getOptions("containerBackgroundColor")
                        }
                    },
                    _checkPaneName: function(seriesTheme) {
                        var paneList = (0, _utils.map)(this.panes, (function(pane) {
                            return pane.name
                        }));
                        seriesTheme.pane = seriesTheme.pane || this.defaultPane;
                        return paneList.includes(seriesTheme.pane)
                    },
                    _initCustomPositioningAxes: function() {
                        var _this = this;
                        var argumentAxis = this.getArgumentAxis();
                        var valueAxisName = argumentAxis.getOptions().customPositionAxis;
                        var valueAxis = this._valueAxes.find((function(v) {
                            return v.pane === argumentAxis.pane && (!valueAxisName || valueAxisName === v.name)
                        }));
                        this._valueAxes.forEach((function(v) {
                            if (argumentAxis !== v.getOrthogonalAxis()) {
                                v.getOrthogonalAxis = function() {
                                    return argumentAxis
                                };
                                v.customPositionIsBoundaryOrthogonalAxis = function() {
                                    return argumentAxis.customPositionIsBoundary()
                                }
                            }
                        }));
                        if ((0, _type.isDefined)(valueAxis) && valueAxis !== argumentAxis.getOrthogonalAxis()) {
                            argumentAxis.getOrthogonalAxis = function() {
                                return valueAxis
                            };
                            argumentAxis.customPositionIsBoundaryOrthogonalAxis = function() {
                                return _this._valueAxes.some((function(v) {
                                    return v.customPositionIsBoundary()
                                }))
                            }
                        } else if ((0, _type.isDefined)(argumentAxis.getOrthogonalAxis()) && !(0, _type.isDefined)(valueAxis)) {
                            argumentAxis.getOrthogonalAxis = _common.noop
                        }
                    },
                    _getAllAxes: function() {
                        return this._argumentAxes.concat(this._valueAxes)
                    },
                    _resetAxesAnimation: function(isFirstDrawing, isHorizontal) {
                        var axes;
                        if ((0, _type.isDefined)(isHorizontal)) {
                            axes = isHorizontal ^ this._isRotated() ? this._argumentAxes : this._valueAxes
                        } else {
                            axes = this._getAllAxes()
                        }
                        axes.forEach((function(a) {
                            a.resetApplyingAnimation(isFirstDrawing)
                        }))
                    },
                    _axesBoundaryPositioning: function() {
                        var allAxes = this._getAllAxes();
                        var boundaryStateChanged = false;
                        allAxes.forEach((function(a) {
                            if (!a.customPositionIsAvailable()) {
                                return
                            }
                            var prevBoundaryState = a.customPositionIsBoundary();
                            a._customBoundaryPosition = a.getCustomBoundaryPosition();
                            boundaryStateChanged = boundaryStateChanged || prevBoundaryState !== a.customPositionIsBoundary()
                        }));
                        return boundaryStateChanged
                    },
                    _getCrosshairMargins: function() {
                        var crosshairOptions = this._getCrosshairOptions() || {};
                        var crosshairEnabled = crosshairOptions.enabled;
                        var margins = (0, _crosshair.getMargins)();
                        var horizontalLabel = (0, _extend2.extend)(true, {}, crosshairOptions.label, crosshairOptions.horizontalLine.label);
                        var verticalLabel = (0, _extend2.extend)(true, {}, crosshairOptions.label, crosshairOptions.verticalLine.label);
                        return {
                            x: crosshairEnabled && crosshairOptions.horizontalLine.visible && horizontalLabel.visible ? margins.x : 0,
                            y: crosshairEnabled && crosshairOptions.verticalLine.visible && verticalLabel.visible ? margins.y : 0
                        }
                    },
                    _getValueAxis: function(paneName, axisName) {
                        var valueAxes = this._valueAxes;
                        var valueAxisOptions = this.option("valueAxis") || {};
                        var valueAxesOptions = isArray(valueAxisOptions) ? valueAxisOptions : [valueAxisOptions];
                        var rotated = this._isRotated();
                        var crosshairMargins = this._getCrosshairMargins();
                        var axisOptions;
                        var axis;
                        axisName = axisName || function(axes, paneName, defaultPane) {
                            var result;
                            for (var i = 0; i < axes.length; i += 1) {
                                if (axes[i].pane === paneName || void 0 === axes[i].pane && paneName === defaultPane) {
                                    result = axes[i].name;
                                    break
                                }
                            }
                            if (!result) {
                                result = axes[0].name
                            }
                            return result
                        }(valueAxes, paneName, this.defaultPane);
                        axis = function findAxis(paneName, axisName, axes) {
                            var axisByName = axes.find((function(axis) {
                                return axis.name === axisName && axis.pane === paneName
                            }));
                            if (axisByName) {
                                return axisByName
                            }
                            if (paneName) {
                                return findAxis(void 0, axisName, axes)
                            }
                        }(paneName, axisName, valueAxes);
                        if (!axis) {
                            axisOptions = function(valueAxes, valueAxesOptions, axisName) {
                                var result;
                                var axInd;
                                for (axInd = 0; axInd < valueAxesOptions.length; axInd += 1) {
                                    if (valueAxesOptions[axInd].name === axisName) {
                                        result = valueAxesOptions[axInd];
                                        result.priority = axInd;
                                        break
                                    }
                                }
                                if (!result) {
                                    for (axInd = 0; axInd < valueAxes.length; axInd += 1) {
                                        if (valueAxes[axInd].name === axisName) {
                                            result = valueAxes[axInd].getOptions();
                                            result.priority = valueAxes[axInd].priority;
                                            break
                                        }
                                    }
                                }
                                return result
                            }(valueAxes, valueAxesOptions, axisName);
                            if (!axisOptions) {
                                this._incidentOccurred("W2102", [axisName]);
                                axisOptions = {
                                    name: axisName,
                                    priority: valueAxes.length
                                }
                            }
                            axis = this._createAxis(false, this._populateAxesOptions("valueAxis", axisOptions, {
                                pane: paneName,
                                name: axisName,
                                optionPath: isArray(valueAxisOptions) ? "valueAxis[".concat(axisOptions.priority, "]") : "valueAxis",
                                crosshairMargin: rotated ? crosshairMargins.y : crosshairMargins.x
                            }, rotated));
                            axis.applyVisualRangeSetter(this._getVisualRangeSetter());
                            valueAxes.push(axis)
                        }
                        axis.setPane(paneName);
                        return axis
                    },
                    _correctValueAxes: function(needHideGrids) {
                        var _this2 = this;
                        var synchronizeMultiAxes = this._themeManager.getOptions("synchronizeMultiAxes");
                        var valueAxes = this._valueAxes;
                        var paneWithAxis = {};
                        this.series.forEach((function(series) {
                            var axis = series.getValueAxis();
                            paneWithAxis[axis.pane] = true
                        }));
                        this.panes.forEach((function(pane) {
                            var paneName = pane.name;
                            if (!paneWithAxis[paneName]) {
                                _this2._getValueAxis(paneName)
                            }
                            if (needHideGrids && synchronizeMultiAxes) {
                                ! function(axesForPane) {
                                    var axisShown = false;
                                    var hiddenStubAxis = [];
                                    var minorGridVisibility = axesForPane.some((function(axis) {
                                        var minorGridOptions = axis.getOptions().minorGrid;
                                        return null === minorGridOptions || void 0 === minorGridOptions ? void 0 : minorGridOptions.visible
                                    }));
                                    var gridVisibility = axesForPane.some((function(axis) {
                                        var gridOptions = axis.getOptions().grid;
                                        return null === gridOptions || void 0 === gridOptions ? void 0 : gridOptions.visible
                                    }));
                                    if (axesForPane.length > 1) {
                                        axesForPane.forEach((function(axis) {
                                            var gridOpt = axis.getOptions().grid;
                                            if (axisShown) {
                                                changeVisibilityAxisGrids(axis, false, false)
                                            } else if (null === gridOpt || void 0 === gridOpt ? void 0 : gridOpt.visible) {
                                                if (axis.getTranslator().getBusinessRange().isEmpty()) {
                                                    changeVisibilityAxisGrids(axis, false, false);
                                                    hiddenStubAxis.push(axis)
                                                } else {
                                                    axisShown = true;
                                                    changeVisibilityAxisGrids(axis, gridVisibility, minorGridVisibility)
                                                }
                                            }
                                        }));
                                        if (!axisShown && hiddenStubAxis.length) {
                                            changeVisibilityAxisGrids(hiddenStubAxis[0], gridVisibility, minorGridVisibility)
                                        }
                                    }
                                }(valueAxes.filter((function(axis) {
                                    return axis.pane === paneName
                                })))
                            }
                        }));
                        this._valueAxes = valueAxes.filter((function(axis) {
                            if (!axis.pane) {
                                axis.setPane(_this2.defaultPane)
                            }
                            var paneExists = doesPaneExist(_this2.panes, axis.pane);
                            if (!paneExists) {
                                axis.dispose();
                                axis = null
                            }
                            return paneExists
                        })).sort(compareAxes);
                        var defaultAxis = this.getValueAxis();
                        this._valueAxes.forEach((function(axis) {
                            var _axis$getOptions = axis.getOptions(),
                                optionPath = _axis$getOptions.optionPath;
                            if (optionPath) {
                                var axesWithSamePath = _this2._valueAxes.filter((function(a) {
                                    return a.getOptions().optionPath === optionPath
                                }));
                                if (axesWithSamePath.length > 1) {
                                    if (axesWithSamePath.some((function(a) {
                                            return a === defaultAxis
                                        }))) {
                                        axesWithSamePath.forEach((function(a) {
                                            if (a !== defaultAxis) {
                                                a.getOptions().optionPath = null
                                            }
                                        }))
                                    } else {
                                        axesWithSamePath.forEach((function(a, i) {
                                            if (0 !== i) {
                                                a.getOptions().optionPath = null
                                            }
                                        }))
                                    }
                                }
                            }
                        }))
                    },
                    _getSeriesForPane: function(paneName) {
                        var paneSeries = [];
                        (0, _iterator.each)(this.series, (function(_, oneSeries) {
                            if (oneSeries.pane === paneName) {
                                paneSeries.push(oneSeries)
                            }
                        }));
                        return paneSeries
                    },
                    _createPanesBorderOptions: function() {
                        var commonBorderOptions = this._themeManager.getOptions("commonPaneSettings").border;
                        var panesBorderOptions = {};
                        this.panes.forEach((function(pane) {
                            panesBorderOptions[pane.name] = (0, _extend2.extend)(true, {}, commonBorderOptions, pane.border)
                        }));
                        return panesBorderOptions
                    },
                    _createScrollBar: function() {
                        var _a;
                        var scrollBarOptions = this._themeManager.getOptions("scrollBar") || {};
                        var scrollBarGroup = this._scrollBarGroup;
                        if (scrollBarOptions.visible) {
                            scrollBarOptions.rotated = this._isRotated();
                            this._scrollBar = (this._scrollBar || new _scroll_bar.ScrollBar(this._renderer, scrollBarGroup)).update(scrollBarOptions)
                        } else {
                            scrollBarGroup.linkRemove();
                            null === (_a = this._scrollBar) || void 0 === _a ? void 0 : _a.dispose();
                            this._scrollBar = null
                        }
                    },
                    _executeAppendAfterSeries: function(append) {
                        append()
                    },
                    _prepareToRender: function() {
                        var panesBorderOptions = this._createPanesBorderOptions();
                        this._createPanesBackground();
                        this._appendAxesGroups();
                        this._adjustViewport();
                        return panesBorderOptions
                    },
                    _adjustViewport: function() {
                        var adjustOnZoom = this._themeManager.getOptions("adjustOnZoom");
                        if (!adjustOnZoom) {
                            return
                        }
                        this._valueAxes.forEach((function(axis) {
                            return axis.adjust()
                        }))
                    },
                    _recreateSizeDependentObjects: function(isCanvasChanged) {
                        var _this3 = this;
                        var series = this._getVisibleSeries();
                        var useAggregation = series.some((function(s) {
                            return s.useAggregation()
                        }));
                        var zoomChanged = this._isZooming();
                        if (!useAggregation) {
                            return
                        }
                        this._argumentAxes.forEach((function(axis) {
                            axis.updateCanvas(_this3._canvas, true)
                        }));
                        series.forEach((function(series) {
                            if (series.useAggregation() && (isCanvasChanged || zoomChanged || !series._useAllAggregatedPoints)) {
                                series.createPoints()
                            }
                        }));
                        this._processSeriesFamilies()
                    },
                    _isZooming: function() {
                        var argumentAxis = this.getArgumentAxis();
                        if (!(null === argumentAxis || void 0 === argumentAxis ? void 0 : argumentAxis.getTranslator())) {
                            return false
                        }
                        var businessRange = argumentAxis.getTranslator().getBusinessRange();
                        var zoomRange = argumentAxis.getViewport();
                        var min = zoomRange ? zoomRange.min : 0;
                        var max = zoomRange ? zoomRange.max : 0;
                        if ("logarithmic" === businessRange.axisType) {
                            min = (0, _utils.getLog)(min, businessRange.base);
                            max = (0, _utils.getLog)(max, businessRange.base)
                        }
                        var viewportDistance = "discrete" === businessRange.axisType ? (0, _utils.getCategoriesInfo)(businessRange.categories, min, max).categories.length : Math.abs(max - min);
                        var precision = (0, _math.getPrecision)(viewportDistance);
                        precision = precision > 1 ? Math.pow(10, precision - 2) : 1;
                        var zoomChanged = Math.round((this._zoomLength - viewportDistance) * precision) / precision !== 0;
                        this._zoomLength = viewportDistance;
                        return zoomChanged
                    },
                    _handleSeriesDataUpdated: function() {
                        var _this4 = this;
                        var viewport = new _range.Range;
                        this.series.forEach((function(s) {
                            viewport.addRange(s.getArgumentRange())
                        }));
                        this._argumentAxes.forEach((function(axis) {
                            axis.updateCanvas(_this4._canvas, true);
                            axis.setBusinessRange(viewport, _this4._axesReinitialized)
                        }));
                        this.callBase()
                    },
                    _isLegendInside: function() {
                        return this._legend && "inside" === this._legend.getPosition()
                    },
                    _isRotated: function() {
                        return this._themeManager.getOptions("rotated")
                    },
                    _getLayoutTargets: function() {
                        return this.panes
                    },
                    _applyClipRects: function(panesBorderOptions) {
                        this._drawPanesBorders(panesBorderOptions);
                        this._createClipRectsForPanes();
                        this._applyClipRectsForAxes();
                        this._fillPanesBackground()
                    },
                    _updateLegendPosition: function(drawOptions, legendHasInsidePosition) {
                        if (drawOptions.drawLegend && this._legend && legendHasInsidePosition) {
                            var panes = this.panes;
                            var newCanvas = (0, _extend2.extend)({}, panes[0].canvas);
                            var layoutManager = new _layout_manager.LayoutManager;
                            newCanvas.right = panes[panes.length - 1].canvas.right;
                            newCanvas.bottom = panes[panes.length - 1].canvas.bottom;
                            layoutManager.layoutInsideLegend(this._legend, newCanvas)
                        }
                    },
                    _allowLegendInsidePosition: function() {
                        return true
                    },
                    _applyExtraSettings: function(series) {
                        var paneIndex = this._getPaneIndex(series.pane);
                        var panesClipRects = this._panesClipRects;
                        var wideClipRect = panesClipRects.wide[paneIndex];
                        series.setClippingParams(panesClipRects.base[paneIndex].id, null === wideClipRect || void 0 === wideClipRect ? void 0 : wideClipRect.id, this._getPaneBorderVisibility(paneIndex))
                    },
                    _updatePanesCanvases: function(drawOptions) {
                        if (!drawOptions.recreateCanvas) {
                            return
                        }(0, _utils.updatePanesCanvases)(this.panes, this._canvas, this._isRotated())
                    },
                    _normalizePanesHeight: function() {
                        (0, _utils.normalizePanesHeight)(this.panes)
                    },
                    _renderScaleBreaks: function() {
                        this._valueAxes.concat(this._argumentAxes).forEach((function(axis) {
                            axis.drawScaleBreaks()
                        }))
                    },
                    _getArgFilter: function() {
                        return _range_data_calculator.default.getViewPortFilter(this.getArgumentAxis().visualRange() || {})
                    },
                    _hidePointsForSingleSeriesIfNeeded: function(series) {
                        var seriesPoints = series.getPoints();
                        var overlappedPointsCount = 0;
                        for (var i = 0; i < seriesPoints.length; i += 1) {
                            var currentPoint = seriesPoints[i];
                            var overlappingPoints = seriesPoints.slice(i + 1);
                            overlappedPointsCount += Number(isPointOverlapped(currentPoint, overlappingPoints));
                            if (overlappedPointsCount > seriesPoints.length / 2) {
                                series.autoHidePointMarkers = true;
                                break
                            }
                        }
                    },
                    _applyAutoHidePointMarkers: function(filteredSeries) {
                        var overlappingPoints = [];
                        var overlappedPointsCalculator = function(pointsCount, currentPoint) {
                            return pointsCount + isPointOverlapped(currentPoint, overlappingPoints, true)
                        };
                        for (var i = filteredSeries.length - 1; i >= 0; i -= 1) {
                            var currentSeries = filteredSeries[i];
                            if (!currentSeries.autoHidePointMarkersEnabled()) {
                                continue
                            }
                            currentSeries.autoHidePointMarkers = false;
                            this._hidePointsForSingleSeriesIfNeeded(currentSeries);
                            if (!currentSeries.autoHidePointMarkers) {
                                var seriesPoints = currentSeries.getPoints();
                                var overlappingPointsCount = seriesPoints.reduce(overlappedPointsCalculator, 0);
                                if (overlappingPointsCount < seriesPoints.length) {
                                    overlappingPoints = overlappingPoints.concat(seriesPoints)
                                } else {
                                    currentSeries.autoHidePointMarkers = true
                                }
                            }
                        }
                    },
                    _applyPointMarkersAutoHiding: function() {
                        var _this5 = this;
                        var allSeries = this.series;
                        if (!this._themeManager.getOptions("autoHidePointMarkers")) {
                            allSeries.forEach((function(s) {
                                s.autoHidePointMarkers = false
                            }));
                            return
                        }
                        this.panes.forEach((function(_ref) {
                            var borderCoords = _ref.borderCoords,
                                name = _ref.name;
                            var series = allSeries.filter((function(s) {
                                return s.pane === name && s.usePointsToDefineAutoHiding()
                            }));
                            series.forEach((function(singleSeries) {
                                singleSeries.prepareCoordinatesForPoints()
                            }));
                            var argAxis = _this5.getArgumentAxis();
                            var markersInfo = function(allSeries, filteredSeries, argAxis) {
                                var series = [];
                                var overloadedSeries = {};
                                var argVisualRange = argAxis.visualRange();
                                var argTranslator = argAxis.getTranslator();
                                var argViewPortFilter = _range_data_calculator.default.getViewPortFilter(argVisualRange || {});
                                filteredSeries.forEach((function(s) {
                                    var valAxis = s.getValueAxis();
                                    var valVisualRange = valAxis.getCanvasRange();
                                    var valTranslator = valAxis.getTranslator();
                                    var seriesIndex = allSeries.indexOf(s);
                                    var valViewPortFilter = _range_data_calculator.default.getViewPortFilter(valVisualRange || {});
                                    overloadedSeries[seriesIndex] = {};
                                    filteredSeries.forEach((function(sr) {
                                        overloadedSeries[seriesIndex][allSeries.indexOf(sr)] = 0
                                    }));
                                    var seriesPoints = [];
                                    var pointsInViewport = s.getPoints().filter((function(p) {
                                        return p.getOptions().visible && argViewPortFilter(p.argument) && (valViewPortFilter(p.getMinValue(true)) || valViewPortFilter(p.getMaxValue(true)))
                                    }));
                                    pointsInViewport.forEach((function(p) {
                                        var tp = {
                                            seriesIndex: seriesIndex,
                                            argument: p.argument,
                                            value: p.getMaxValue(true),
                                            size: p.bubbleSize || p.getOptions().size,
                                            x: void 0,
                                            y: void 0
                                        };
                                        if (p.getMinValue(true) !== p.getMaxValue(true)) {
                                            var mp = (0, _extend2.extend)({}, tp);
                                            mp.value = p.getMinValue(true);
                                            mp.x = argTranslator.to(mp.argument, 1);
                                            mp.y = valTranslator.to(mp.value, 1);
                                            seriesPoints.push(mp)
                                        }
                                        tp.x = argTranslator.to(tp.argument, 1);
                                        tp.y = valTranslator.to(tp.value, 1);
                                        seriesPoints.push(tp)
                                    }));
                                    overloadedSeries[seriesIndex].pointsCount = seriesPoints.length;
                                    overloadedSeries[seriesIndex].total = 0;
                                    overloadedSeries[seriesIndex].continuousSeries = 0;
                                    series.push({
                                        name: s.name,
                                        index: seriesIndex,
                                        points: seriesPoints
                                    })
                                }));
                                return {
                                    series: series,
                                    overloadedSeries: overloadedSeries
                                }
                            }(allSeries, series, argAxis);
                            ! function(canvas, markersInfo, series) {
                                var area = canvas.width * canvas.height;
                                var seriesPoints = markersInfo.series;
                                var _loop = function(i) {
                                    var currentSeries = series.filter((function(s) {
                                        return s.name === seriesPoints[i].name
                                    }))[0];
                                    var points = seriesPoints[i].points;
                                    var pointSize = points.length ? points[0].size : 0;
                                    var pointsArea = pointSize * pointSize * points.length;
                                    if (currentSeries.autoHidePointMarkersEnabled() && pointsArea >= area / seriesPoints.length) {
                                        var index = seriesPoints[i].index;
                                        currentSeries.autoHidePointMarkers = true;
                                        seriesPoints.splice(i, 1);
                                        series.splice(series.indexOf(currentSeries), 1);
                                        markersInfo.overloadedSeries[index] = null
                                    }
                                };
                                for (var i = seriesPoints.length - 1; i >= 0; i -= 1) {
                                    _loop(i)
                                }
                            }(borderCoords, markersInfo, series);
                            if (markersInfo.series.length) {
                                var argVisualRange = argAxis.visualRange();
                                var argAxisIsDiscrete = "discrete" === argAxis.getOptions().type;
                                var sortingCallback = argAxisIsDiscrete ? function(p1, p2) {
                                    return argVisualRange.categories.indexOf(p1.argument) - argVisualRange.categories.indexOf(p2.argument)
                                } : function(p1, p2) {
                                    return p1.argument - p2.argument
                                };
                                var points = [];
                                markersInfo.series.forEach((function(s) {
                                    points = points.concat(s.points)
                                }));
                                points.sort(sortingCallback);
                                ! function(points, overloadedSeries) {
                                    var isContinuousSeries = false;
                                    for (var i = 0; i < points.length - 1; i += 1) {
                                        var curPoint = points[i];
                                        var size = curPoint.size;
                                        if ((0, _type.isDefined)(curPoint.x) && (0, _type.isDefined)(curPoint.y)) {
                                            for (var j = i + 1; j < points.length; j += 1) {
                                                var nextPoint = points[j];
                                                var nextX = null === nextPoint || void 0 === nextPoint ? void 0 : nextPoint.x;
                                                var nextY = null === nextPoint || void 0 === nextPoint ? void 0 : nextPoint.y;
                                                if (!(0, _type.isDefined)(nextX) || Math.abs(curPoint.x - nextX) >= size) {
                                                    isContinuousSeries = isContinuousSeries && j !== i + 1;
                                                    break
                                                } else {
                                                    var distance = (0, _type.isDefined)(nextX) && (0, _type.isDefined)(nextY) && Math.sqrt(Math.pow(curPoint.x - nextX, 2) + Math.pow(curPoint.y - nextY, 2));
                                                    if (distance && distance < size) {
                                                        overloadedSeries[curPoint.seriesIndex][nextPoint.seriesIndex] += 1;
                                                        overloadedSeries[curPoint.seriesIndex].total += 1;
                                                        if (!isContinuousSeries) {
                                                            overloadedSeries[curPoint.seriesIndex].continuousSeries += 1;
                                                            isContinuousSeries = true
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }(points, markersInfo.overloadedSeries);
                                _this5._applyAutoHidePointMarkers(series)
                            }
                        }))
                    },
                    _renderAxes: function(drawOptions, panesBorderOptions) {
                        var _this6 = this;

                        function calculateTitlesWidth(axes) {
                            return axes.map((function(axis) {
                                if (!axis.getTitle) {
                                    return 0
                                }
                                var title = axis.getTitle();
                                return title ? title.bBox.width : 0
                            }))
                        }
                        var rotated = this._isRotated();
                        var synchronizeMultiAxes = this._themeManager.getOptions("synchronizeMultiAxes");
                        var scrollBar = this._scrollBar ? [this._scrollBar] : [];
                        var extendedArgAxes = this._isArgumentAxisBeforeScrollBar() ? this._argumentAxes.concat(scrollBar) : scrollBar.concat(this._argumentAxes);
                        var verticalAxes = rotated ? this._argumentAxes : this._valueAxes;
                        var verticalElements = rotated ? extendedArgAxes : this._valueAxes;
                        var horizontalAxes = rotated ? this._valueAxes : this._argumentAxes;
                        var horizontalElements = rotated ? this._valueAxes : extendedArgAxes;
                        var allAxes = verticalAxes.concat(horizontalAxes);
                        var allElements = allAxes.concat(scrollBar);
                        var verticalAxesFirstDrawing = verticalAxes.some((function(v) {
                            return v.isFirstDrawing()
                        }));
                        this._normalizePanesHeight();
                        this._updatePanesCanvases(drawOptions);
                        var panesCanvases = this.panes.reduce((function(canvases, pane) {
                            canvases[pane.name] = (0, _extend2.extend)({}, pane.canvas);
                            return canvases
                        }), {});
                        var paneSizes = this.panes.reduce((function(sizes, pane) {
                            sizes[pane.name] = {
                                height: pane.height,
                                unit: pane.unit
                            };
                            return sizes
                        }), {});
                        var cleanPanesCanvases = (0, _extend2.extend)(true, {}, panesCanvases);
                        this._initCustomPositioningAxes();
                        var needCustomAdjustAxes = this._axesBoundaryPositioning();
                        if (!drawOptions.adjustAxes && !needCustomAdjustAxes) {
                            drawAxesWithTicks(verticalAxes, !rotated && synchronizeMultiAxes, panesCanvases, panesBorderOptions);
                            drawAxesWithTicks(horizontalAxes, rotated && synchronizeMultiAxes, panesCanvases, panesBorderOptions);
                            performActionOnAxes(allAxes, "prepareAnimation");
                            this._renderScaleBreaks();
                            horizontalAxes.forEach((function(a) {
                                return a.resolveOverlappingForCustomPositioning(verticalAxes)
                            }));
                            verticalAxes.forEach((function(a) {
                                return a.resolveOverlappingForCustomPositioning(horizontalAxes)
                            }));
                            return false
                        }
                        if (needCustomAdjustAxes) {
                            allAxes.forEach((function(a) {
                                return a.customPositionIsAvailable() && a.shift({
                                    top: 0,
                                    left: 0,
                                    bottom: 0,
                                    right: 0
                                })
                            }))
                        }
                        if (this._scrollBar) {
                            this._scrollBar.setPane(this.panes)
                        }
                        var vAxesMargins = {
                            panes: {},
                            left: 0,
                            right: 0
                        };
                        var hAxesMargins = getHorizontalAxesMargins(horizontalElements, (function(axis) {
                            return axis.estimateMargins(panesCanvases[axis.pane])
                        }));
                        panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins);
                        var drawAxesAndSetCanvases = function(isHorizontal) {
                            var axes = isHorizontal ? horizontalAxes : verticalAxes;
                            var condition = (isHorizontal ? rotated : !rotated) && synchronizeMultiAxes;
                            drawAxesWithTicks(axes, condition, panesCanvases, panesBorderOptions);
                            if (isHorizontal) {
                                hAxesMargins = getHorizontalAxesMargins(horizontalElements, getAxisMargins)
                            } else {
                                vAxesMargins = getVerticalAxesMargins(verticalElements)
                            }
                            panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins)
                        };
                        drawAxesAndSetCanvases(false);
                        drawAxesAndSetCanvases(true);
                        if (!this._changesApplying && this._estimateTickIntervals(verticalAxes, panesCanvases)) {
                            drawAxesAndSetCanvases(false)
                        }
                        var oldTitlesWidth = calculateTitlesWidth(verticalAxes);
                        var visibleSeries = this._getVisibleSeries();
                        var pointsToAnimation = this._getPointsToAnimation(visibleSeries);
                        var axesIsAnimated = function(drawOptions, pointsToAnimation) {
                            var pointsCount = pointsToAnimation.reduce((function(sum, count) {
                                return sum + count
                            }), 0) / pointsToAnimation.length;
                            return drawOptions.animate && pointsCount <= drawOptions.animationPointsLimit
                        }(drawOptions, pointsToAnimation);
                        performActionOnAxes(allElements, "updateSize", panesCanvases, axesIsAnimated);
                        horizontalElements.forEach(shiftAxis("top", "bottom"));
                        verticalElements.forEach(shiftAxis("left", "right"));
                        this._renderScaleBreaks();
                        this.panes.forEach((function(pane) {
                            (0, _extend2.extend)(pane.canvas, panesCanvases[pane.name])
                        }));
                        this._valueAxes.forEach((function(axis) {
                            axis.setInitRange()
                        }));
                        verticalAxes.forEach((function(axis, i) {
                            var _a;
                            if (null === (_a = axis.hasWrap) || void 0 === _a ? void 0 : _a.call(axis)) {
                                var title = axis.getTitle();
                                var newTitleWidth = title ? title.bBox.width : 0;
                                var offset = newTitleWidth - oldTitlesWidth[i];
                                if ("right" === axis.getOptions().position) {
                                    vAxesMargins.right += offset
                                } else {
                                    vAxesMargins.left += offset;
                                    _this6.panes.forEach((function(_ref2) {
                                        var name = _ref2.name;
                                        vAxesMargins.panes[name].left += offset
                                    }))
                                }
                                panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins);
                                performActionOnAxes(allElements, "updateSize", panesCanvases, false, false);
                                oldTitlesWidth = calculateTitlesWidth(verticalAxes)
                            }
                        }));
                        if (verticalAxes.some((function(v) {
                                return v.customPositionIsAvailable() && v.getCustomPosition() !== v._axisPosition
                            }))) {
                            axesIsAnimated && this._resetAxesAnimation(verticalAxesFirstDrawing, false);
                            performActionOnAxes(verticalAxes, "updateSize", panesCanvases, axesIsAnimated)
                        }
                        horizontalAxes.forEach((function(a) {
                            return a.resolveOverlappingForCustomPositioning(verticalAxes)
                        }));
                        verticalAxes.forEach((function(a) {
                            return a.resolveOverlappingForCustomPositioning(horizontalAxes)
                        }));
                        return cleanPanesCanvases
                    },
                    _getExtraTemplatesItems: function() {
                        var allAxes = (this._argumentAxes || []).concat(this._valueAxes || []);
                        var elements = this._collectTemplatesFromItems(allAxes);
                        return {
                            items: elements.items,
                            groups: elements.groups,
                            launchRequest: function() {
                                allAxes.forEach((function(a) {
                                    a.setRenderedState(true)
                                }))
                            },
                            doneRequest: function() {
                                allAxes.forEach((function(a) {
                                    a.setRenderedState(false)
                                }))
                            }
                        }
                    },
                    _estimateTickIntervals: function(axes, canvases) {
                        return axes.some((function(axis) {
                            return axis.estimateTickInterval(canvases[axis.pane])
                        }))
                    },
                    checkForMoreSpaceForPanesCanvas: function() {
                        var rotated = this._isRotated();
                        var panesAreCustomSized = this.panes.filter((function(p) {
                            return p.unit
                        })).length === this.panes.length;
                        var needSpace = false;
                        if (panesAreCustomSized) {
                            var needHorizontalSpace = 0;
                            var needVerticalSpace = 0;
                            if (rotated) {
                                var argAxisRightMargin = this.getArgumentAxis().getMargins().right;
                                var rightPanesIndent = Math.min.apply(Math, _toConsumableArray(this.panes.map((function(p) {
                                    return p.canvas.right
                                }))));
                                needHorizontalSpace = this._canvas.right + argAxisRightMargin - rightPanesIndent
                            } else {
                                var argAxisBottomMargin = this.getArgumentAxis().getMargins().bottom;
                                var bottomPanesIndent = Math.min.apply(Math, _toConsumableArray(this.panes.map((function(p) {
                                    return p.canvas.bottom
                                }))));
                                needVerticalSpace = this._canvas.bottom + argAxisBottomMargin - bottomPanesIndent
                            }
                            needSpace = needHorizontalSpace > 0 || needVerticalSpace > 0 ? {
                                width: needHorizontalSpace,
                                height: needVerticalSpace
                            } : false;
                            if (0 !== needVerticalSpace) {
                                var realSize = this.getSize();
                                var customSize = this.option("size");
                                var container = this._$element[0];
                                var containerHasStyledHeight = !!parseInt(container.style.height, 10) || 0 !== this._containerInitialHeight;
                                if (!rotated && !(null === customSize || void 0 === customSize ? void 0 : customSize.height) && !containerHasStyledHeight) {
                                    this._forceResize(realSize.width, realSize.height + needVerticalSpace);
                                    needSpace = false
                                }
                            }
                        } else {
                            needSpace = this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(), rotated, (function(pane) {
                                return {
                                    width: rotated && !!pane.unit,
                                    height: !rotated && !!pane.unit
                                }
                            }))
                        }
                        return needSpace
                    },
                    _forceResize: function(width, height) {
                        this._renderer.resize(width, height);
                        this._updateSize();
                        this._setContentSize();
                        this._preserveOriginalCanvas();
                        this._updateCanvasClipRect(this._canvas)
                    },
                    _shrinkAxes: function(sizeShortage, panesCanvases) {
                        if (!sizeShortage || !panesCanvases) {
                            return
                        }
                        this._renderer.stopAllAnimations(true);
                        var rotated = this._isRotated();
                        var scrollBar = this._scrollBar ? [this._scrollBar] : [];
                        var extendedArgAxes = this._isArgumentAxisBeforeScrollBar() ? this._argumentAxes.concat(scrollBar) : scrollBar.concat(this._argumentAxes);
                        var verticalAxes = rotated ? extendedArgAxes : this._valueAxes;
                        var horizontalAxes = rotated ? this._valueAxes : extendedArgAxes;
                        var allAxes = verticalAxes.concat(horizontalAxes);
                        if (sizeShortage.width || sizeShortage.height) {
                            checkUsedSpace(sizeShortage, "height", horizontalAxes, getHorizontalAxesMargins);
                            checkUsedSpace(sizeShortage, "width", verticalAxes, getVerticalAxesMargins);
                            performActionOnAxes(allAxes, "updateSize", panesCanvases);
                            var paneSizes = this.panes.reduce((function(sizes, pane) {
                                sizes[pane.name] = {
                                    height: pane.height,
                                    unit: pane.unit
                                };
                                return sizes
                            }), {});
                            panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, getVerticalAxesMargins(verticalAxes), getHorizontalAxesMargins(horizontalAxes, getAxisMargins));
                            performActionOnAxes(allAxes, "updateSize", panesCanvases);
                            horizontalAxes.forEach(shiftAxis("top", "bottom"));
                            verticalAxes.forEach(shiftAxis("left", "right"));
                            this.panes.forEach((function(pane) {
                                return (0, _extend2.extend)(pane.canvas, panesCanvases[pane.name])
                            }))
                        }
                    },
                    _isArgumentAxisBeforeScrollBar: function() {
                        var _a;
                        var argumentAxis = this.getArgumentAxis();
                        if (this._scrollBar) {
                            var argAxisPosition = argumentAxis.getResolvedBoundaryPosition();
                            var argAxisLabelPosition = null === (_a = argumentAxis.getOptions().label) || void 0 === _a ? void 0 : _a.position;
                            var scrollBarPosition = this._scrollBar.getOptions().position;
                            return argumentAxis.hasNonBoundaryPosition() || scrollBarPosition === argAxisPosition && argAxisLabelPosition !== scrollBarPosition
                        }
                        return false
                    },
                    _getPanesParameters: function() {
                        var panes = this.panes;
                        var params = [];
                        for (var i = 0; i < panes.length; i += 1) {
                            if (this._getPaneBorderVisibility(i)) {
                                params.push({
                                    coords: panes[i].borderCoords,
                                    clipRect: this._panesClipRects.fixed[i]
                                })
                            }
                        }
                        return params
                    },
                    _createCrosshairCursor: function() {
                        var options = this._themeManager.getOptions("crosshair") || {};
                        var argumentAxis = this.getArgumentAxis();
                        var axes = this._isRotated() ? [this._valueAxes, [argumentAxis]] : [
                            [argumentAxis], this._valueAxes
                        ];
                        var parameters = {
                            canvas: this._getCommonCanvas(),
                            panes: this._getPanesParameters(),
                            axes: axes
                        };
                        if (!(null === options || void 0 === options ? void 0 : options.enabled)) {
                            return
                        }
                        if (this._crosshair) {
                            this._crosshair.update(options, parameters)
                        } else {
                            this._crosshair = new _crosshair.Crosshair(this._renderer, options, parameters, this._crosshairCursorGroup)
                        }
                        this._crosshair.render()
                    },
                    _getCommonCanvas: function() {
                        var commonCanvas;
                        var panes = this.panes;
                        for (var i = 0; i < panes.length; i += 1) {
                            var canvas = panes[i].canvas;
                            if (!commonCanvas) {
                                commonCanvas = (0, _extend2.extend)({}, canvas)
                            } else {
                                commonCanvas.right = canvas.right;
                                commonCanvas.bottom = canvas.bottom
                            }
                        }
                        return commonCanvas
                    },
                    _createPanesBackground: function() {
                        var defaultBackgroundColor = this._themeManager.getOptions("commonPaneSettings").backgroundColor;
                        var renderer = this._renderer;
                        var rects = [];
                        this._panesBackgroundGroup.clear();
                        for (var i = 0; i < this.panes.length; i += 1) {
                            var backgroundColor = this.panes[i].backgroundColor || defaultBackgroundColor;
                            if (!backgroundColor || "none" === backgroundColor) {
                                rects.push(null);
                                continue
                            }
                            var rect = renderer.rect(0, 0, 0, 0).attr({
                                fill: (0, _utils.extractColor)(backgroundColor),
                                "stroke-width": 0
                            }).append(this._panesBackgroundGroup);
                            rects.push(rect)
                        }
                        this.panesBackground = rects
                    },
                    _fillPanesBackground: function() {
                        var _this7 = this;
                        (0, _iterator.each)(this.panes, (function(i, pane) {
                            var bc = pane.borderCoords;
                            if (null !== _this7.panesBackground[i]) {
                                _this7.panesBackground[i].attr({
                                    x: bc.left,
                                    y: bc.top,
                                    width: bc.width,
                                    height: bc.height
                                })
                            }
                        }))
                    },
                    _calcPaneBorderCoords: function(pane) {
                        var canvas = pane.canvas;
                        var bc = pane.borderCoords = pane.borderCoords || {};
                        bc.left = canvas.left;
                        bc.top = canvas.top;
                        bc.right = canvas.width - canvas.right;
                        bc.bottom = canvas.height - canvas.bottom;
                        bc.width = Math.max(bc.right - bc.left, 0);
                        bc.height = Math.max(bc.bottom - bc.top, 0)
                    },
                    _drawPanesBorders: function(panesBorderOptions) {
                        var _this8 = this;
                        var rotated = this._isRotated();
                        this._panesBorderGroup.linkRemove().clear();
                        (0, _iterator.each)(this.panes, (function(i, pane) {
                            var borderOptions = panesBorderOptions[pane.name];
                            var attr = {
                                fill: "none",
                                stroke: borderOptions.color,
                                "stroke-opacity": borderOptions.opacity,
                                "stroke-width": borderOptions.width,
                                dashStyle: borderOptions.dashStyle,
                                "stroke-linecap": "square"
                            };
                            _this8._calcPaneBorderCoords(pane, rotated);
                            if (!borderOptions.visible) {
                                return
                            }
                            var bc = pane.borderCoords;
                            var segmentRectParams = (0, _utils2.prepareSegmentRectPoints)(bc.left, bc.top, bc.width, bc.height, borderOptions);
                            _this8._renderer.path(segmentRectParams.points, segmentRectParams.pathType).attr(attr).append(_this8._panesBorderGroup)
                        }));
                        this._panesBorderGroup.linkAppend()
                    },
                    _createClipRect: function(clipArray, index, left, top, width, height) {
                        var clipRect = clipArray[index];
                        if (!clipRect) {
                            clipRect = this._renderer.clipRect(left, top, width, height);
                            clipArray[index] = clipRect
                        } else {
                            clipRect.attr({
                                x: left,
                                y: top,
                                width: width,
                                height: height
                            })
                        }
                    },
                    _createClipRectsForPanes: function() {
                        var _this9 = this;
                        var canvas = this._canvas;
                        (0, _iterator.each)(this.panes, (function(i, pane) {
                            var needWideClipRect = false;
                            var bc = pane.borderCoords;
                            var left = bc.left;
                            var top = bc.top;
                            var width = bc.width;
                            var height = bc.height;
                            var panesClipRects = _this9._panesClipRects;
                            _this9._createClipRect(panesClipRects.fixed, i, left, top, width, height);
                            _this9._createClipRect(panesClipRects.base, i, left, top, width, height);
                            (0, _iterator.each)(_this9.series, (function(_, series) {
                                if (series.pane === pane.name && (series.isFinancialSeries() || series.areErrorBarsVisible())) {
                                    needWideClipRect = true
                                }
                            }));
                            if (needWideClipRect) {
                                if (_this9._isRotated()) {
                                    top = 0;
                                    height = canvas.height
                                } else {
                                    left = 0;
                                    width = canvas.width
                                }
                                _this9._createClipRect(panesClipRects.wide, i, left, top, width, height)
                            } else {
                                panesClipRects.wide[i] = null
                            }
                        }))
                    },
                    _applyClipRectsForAxes: function() {
                        var axes = this._getAllAxes();
                        var chartCanvasClipRectID = this._getCanvasClipRectID();
                        for (var i = 0; i < axes.length; i += 1) {
                            var elementsClipRectID = this._getElementsClipRectID(axes[i].pane);
                            axes[i].applyClipRects(elementsClipRectID, chartCanvasClipRectID)
                        }
                    },
                    _getPaneBorderVisibility: function(paneIndex) {
                        var _a;
                        var commonPaneBorderVisible = this._themeManager.getOptions("commonPaneSettings").border.visible;
                        var pane = this.panes[paneIndex];
                        var paneVisibility = null === (_a = null === pane || void 0 === pane ? void 0 : pane.border) || void 0 === _a ? void 0 : _a.visible;
                        return void 0 === paneVisibility ? commonPaneBorderVisible : paneVisibility
                    },
                    _getCanvasForPane: function(paneName) {
                        var _a;
                        return null === (_a = this.panes.find((function(pane) {
                            return pane.name === paneName
                        }))) || void 0 === _a ? void 0 : _a.canvas
                    },
                    _getTrackerSettings: function() {
                        return (0, _extend2.extend)(this.callBase(), {
                            chart: this,
                            rotated: this._isRotated(),
                            crosshair: this._getCrosshairOptions().enabled ? this._crosshair : null,
                            stickyHovering: this._themeManager.getOptions("stickyHovering")
                        })
                    },
                    _resolveLabelOverlappingStack: function() {
                        var _this10 = this;
                        var isRotated = this._isRotated();
                        var shiftDirection = isRotated ? function(box, length) {
                            return {
                                x: box.x - length,
                                y: box.y
                            }
                        } : function(box, length) {
                            return {
                                x: box.x,
                                y: box.y - length
                            }
                        };
                        var processor = function(a, b) {
                            var coordPosition = isRotated ? 1 : 0;
                            var figureCenter1 = a.labels[0].getFigureCenter()[coordPosition];
                            var figureCenter12 = b.labels[0].getFigureCenter()[coordPosition];
                            if (figureCenter1 - figureCenter12 === 0) {
                                var translator = a.labels[0].getPoint().series.getValueAxis().getTranslator();
                                var direction = translator.isInverted() ? -1 : 1;
                                return (a.value() - b.value()) * direction
                            }
                            return 0
                        };
                        (0, _iterator.each)(this._getStackPoints(), (function(_, stacks) {
                            (0, _iterator.each)(stacks, (function(_, points) {
                                var isInverted = points[0].series.getValueAxis().getOptions().inverted;
                                _m_base_chart.overlapping.resolveLabelOverlappingInOneDirection(points, _this10._getCommonCanvas(), isRotated, isInverted, shiftDirection, processor)
                            }))
                        }))
                    },
                    _getStackPoints: function() {
                        var stackPoints = {};
                        var visibleSeries = this._getVisibleSeries();
                        (0, _iterator.each)(visibleSeries, (function(_, singleSeries) {
                            var points = singleSeries.getPoints();
                            var stackName = singleSeries.getStackName() || null;
                            (0, _iterator.each)(points, (function(_, point) {
                                var argument = point.argument;
                                if (!stackPoints[argument]) {
                                    stackPoints[argument] = {}
                                }
                                if (!stackPoints[argument][stackName]) {
                                    stackPoints[argument][stackName] = []
                                }
                                stackPoints[argument][stackName].push(point)
                            }))
                        }));
                        return stackPoints
                    },
                    _getCrosshairOptions: function() {
                        return this._getOption("crosshair")
                    },
                    zoomArgument: function(min, max) {
                        if (!this._initialized || !(0, _type.isDefined)(min) && !(0, _type.isDefined)(max)) {
                            return
                        }
                        this.getArgumentAxis().visualRange([min, max])
                    },
                    resetVisualRange: function() {
                        var _this11 = this;
                        var axes = this._argumentAxes;
                        var nonVirtualArgumentAxis = this.getArgumentAxis();
                        axes.forEach((function(axis) {
                            axis.resetVisualRange(nonVirtualArgumentAxis !== axis);
                            _this11._applyCustomVisualRangeOption(axis)
                        }));
                        this.callBase()
                    },
                    getVisibleArgumentBounds: function() {
                        var translator = this._argumentAxes[0].getTranslator();
                        var range = translator.getBusinessRange();
                        var isDiscrete = "discrete" === range.axisType;
                        var categories = range.categories;
                        return {
                            minVisible: isDiscrete ? range.minVisible || categories[0] : range.minVisible,
                            maxVisible: isDiscrete ? range.maxVisible || categories[categories.length - 1] : range.maxVisible
                        }
                    },
                    _change_FULL_RENDER: function() {
                        this.callBase();
                        if (this._changes.has("VISUAL_RANGE")) {
                            this._raiseZoomEndHandlers()
                        }
                    },
                    _getAxesForScaling: function() {
                        return [this.getArgumentAxis()].concat(this._valueAxes)
                    },
                    _applyVisualRangeByVirtualAxes: function(axis, range) {
                        if (axis.isArgumentAxis) {
                            if (axis !== this.getArgumentAxis()) {
                                return true
                            }
                            this._argumentAxes.filter((function(a) {
                                return a !== axis
                            })).forEach((function(a) {
                                return a.visualRange(range, {
                                    start: true,
                                    end: true
                                })
                            }))
                        }
                        return false
                    },
                    _raiseZoomEndHandlers: function() {
                        this._argumentAxes.forEach((function(axis) {
                            return axis.handleZoomEnd()
                        }));
                        this.callBase()
                    },
                    _setOptionsByReference: function() {
                        this.callBase();
                        (0, _extend2.extend)(this._optionsByReference, {
                            "argumentAxis.visualRange": true
                        })
                    },
                    option: function() {
                        var option = this.callBase.apply(this, arguments);
                        var valueAxis = this._options.silent("valueAxis");
                        if ("array" === (0, _type.type)(valueAxis)) {
                            for (var i = 0; i < valueAxis.length; i += 1) {
                                var optionPath = "valueAxis[".concat(i, "].visualRange");
                                this._optionsByReference[optionPath] = true
                            }
                        }
                        return option
                    },
                    _notifyVisualRange: function() {
                        var argAxis = this._argumentAxes[0];
                        var argumentVisualRange = (0, _utils.convertVisualRangeObject)(argAxis.visualRange(), !isArray(this.option("argumentAxis.visualRange")));
                        if (!argAxis.skipEventRising || !(0, _utils.rangesAreEqual)(argumentVisualRange, this.option("argumentAxis.visualRange"))) {
                            this.option("argumentAxis.visualRange", argumentVisualRange)
                        } else {
                            argAxis.skipEventRising = null
                        }
                        this.callBase()
                    }
                });
                dxChart.addPlugin(_shutter_zoom.default);
                dxChart.addPlugin(_zoom_and_pan.default);
                dxChart.addPlugin(_annotations.plugins.core);
                dxChart.addPlugin(_annotations.plugins.chart);
                (0, _component_registrator.default)("dxChart", dxChart);
                var _default = dxChart;
                exports.default = _default
            },
        88647:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/m_pie_chart.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 99393));
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _consts = _interopRequireDefault(__webpack_require__( /*! ../../viz/components/consts */ 32410));
                var _annotations = __webpack_require__( /*! ../../viz/core/annotations */ 77129);
                var _center_template = __webpack_require__( /*! ../../viz/core/center_template */ 56672);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);
                var _range = __webpack_require__( /*! ../../viz/translators/range */ 21177);
                var _translator1d = __webpack_require__( /*! ../../viz/translators/translator1d */ 17953);
                var _m_base_chart = __webpack_require__( /*! ./chart_components/m_base_chart */ 14107);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var states = _consts.default.states;
                var seriesSpacing = _consts.default.pieSeriesSpacing;
                var NORMAL_STATE = states.normalMark;
                var HOVER_STATE = states.hoverMark;
                var SELECTED_STATE = states.selectedMark;
                var LEGEND_ACTIONS = [states.resetItem, states.applyHover, states.applySelected, states.applySelected];

                function shiftInColumnFunction(box, length) {
                    return {
                        x: box.x,
                        y: box.y - length
                    }
                }

                function dividePoints(series, points) {
                    return series.getVisiblePoints().reduce((function(r, point) {
                        var angle = (0, _utils.normalizeAngle)(point.middleAngle);
                        (angle <= 90 || angle >= 270 ? r.right : r.left).push(point);
                        return r
                    }), points || {
                        left: [],
                        right: []
                    })
                }

                function resolveOverlappedLabels(points, shiftCallback, inverseDirection, canvas) {
                    var overlapped;
                    if (inverseDirection) {
                        points.left.reverse();
                        points.right.reverse()
                    }
                    overlapped = _m_base_chart.overlapping.resolveLabelOverlappingInOneDirection(points.left, canvas, false, false, shiftCallback);
                    return _m_base_chart.overlapping.resolveLabelOverlappingInOneDirection(points.right, canvas, false, false, shiftCallback) || overlapped
                }

                function correctPercentValue(value) {
                    if ((0, _type.isNumeric)(value)) {
                        if (value > 1) {
                            value = 1
                        } else if (value < 0) {
                            value = 0
                        }
                    } else {
                        value = void 0
                    }
                    return value
                }
                var pieSizeEqualizer = function() {
                    function removeFromList(list, item) {
                        return list.filter((function(li) {
                            return li !== item
                        }))
                    }
                    var pies = [];
                    var timers = {};
                    return {
                        queue: function(pie) {
                            var group = pie.getSizeGroup();
                            pies = (list = pies, item = pie, removeFromList(list, item).concat(item));
                            var list, item;
                            clearTimeout(timers[group]);
                            timers[group] = setTimeout((function() {
                                ! function(group, allPies) {
                                    var pies = allPies.filter((function(p) {
                                        return p._isVisible() && p.getSizeGroup() === group
                                    }));
                                    var minRadius = Math.min.apply(null, pies.map((function(p) {
                                        return p.getSizeGroupLayout().radius
                                    })));
                                    var minPie = pies.filter((function(p) {
                                        return p.getSizeGroupLayout().radius === minRadius
                                    }));
                                    pies.forEach((function(p) {
                                        return p.render({
                                            force: true,
                                            sizeGroupLayout: minPie.length ? minPie[0].getSizeGroupLayout() : {}
                                        })
                                    }))
                                }(group, pies)
                            }))
                        },
                        remove: function(pie) {
                            pies = removeFromList(pies, pie);
                            if (!pies.length) {
                                timers = {}
                            }
                        }
                    }
                }();
                var dxPieChart = _m_base_chart.BaseChart.inherit({
                    _themeSection: "pie",
                    _layoutManagerOptions: function() {
                        return (0, _extend2.extend)(true, {}, this.callBase(), {
                            piePercentage: correctPercentValue(this._themeManager.getOptions("diameter")),
                            minPiePercentage: correctPercentValue(this._themeManager.getOptions("minDiameter"))
                        })
                    },
                    _optionChangesMap: {
                        diameter: "REINIT",
                        minDiameter: "REINIT",
                        sizeGroup: "REINIT"
                    },
                    _disposeCore: function() {
                        pieSizeEqualizer.remove(this);
                        this.callBase()
                    },
                    _groupSeries: function() {
                        var _a;
                        var series = this.series;
                        this._groupsData = {
                            groups: [{
                                series: series,
                                valueOptions: {
                                    valueType: "numeric"
                                }
                            }],
                            argumentOptions: null === (_a = series[0]) || void 0 === _a ? void 0 : _a.getOptions()
                        }
                    },
                    getArgumentAxis: function() {
                        return null
                    },
                    _getValueAxis: function() {
                        var translator = (new _translator1d.Translator1D).setCodomain(360, 0);
                        return {
                            getTranslator: function() {
                                return translator
                            },
                            setBusinessRange: function(range) {
                                translator.setDomain(range.min, range.max)
                            }
                        }
                    },
                    _populateBusinessRange: function() {
                        this.series.map((function(series) {
                            var range = new _range.Range;
                            range.addRange(series.getRangeData().val);
                            series.getValueAxis().setBusinessRange(range);
                            return range
                        }))
                    },
                    _specialProcessSeries: function() {
                        (0, _iterator.each)(this.series, (function(_, singleSeries) {
                            singleSeries.arrangePoints()
                        }))
                    },
                    _checkPaneName: function() {
                        return true
                    },
                    _processSingleSeries: function(singleSeries) {
                        this.callBase(singleSeries);
                        singleSeries.arrangePoints()
                    },
                    _handleSeriesDataUpdated: function() {
                        var maxPointCount = 0;
                        this.series.forEach((function(s) {
                            maxPointCount = Math.max(s.getPointsCount(), maxPointCount)
                        }));
                        this.series.forEach((function(s) {
                            s.setMaxPointsCount(maxPointCount)
                        }));
                        this.callBase()
                    },
                    _getLegendOptions: function(item) {
                        var legendItem = this.callBase(item);
                        var legendData = legendItem.legendData;
                        legendData.argument = item.argument;
                        legendData.argumentIndex = item.argumentIndex;
                        legendData.points = [item];
                        return legendItem
                    },
                    _getLegendTargets: function() {
                        var _this = this;
                        var itemsByArgument = {};
                        (this.series || []).forEach((function(series) {
                            series.getPoints().forEach((function(point) {
                                var argument = point.argument.valueOf();
                                var index = series.getPointsByArg(argument).indexOf(point);
                                var key = argument.valueOf().toString() + index;
                                itemsByArgument[key] = itemsByArgument[key] || [];
                                var argumentCount = itemsByArgument[key].push(point);
                                point.index = itemsByArgument[key][argumentCount - 2] ? itemsByArgument[key][argumentCount - 2].index : Object.keys(itemsByArgument).length - 1;
                                point.argumentIndex = index
                            }))
                        }));
                        var items = [];
                        (0, _iterator.each)(itemsByArgument, (function(_, points) {
                            points.forEach((function(point, index) {
                                if (0 === index) {
                                    items.push(_this._getLegendOptions(point));
                                    return
                                }
                                var item = items[items.length - 1];
                                item.legendData.points.push(point);
                                if (!item.visible) {
                                    item.visible = point.isVisible()
                                }
                            }))
                        }));
                        return items
                    },
                    _getLayoutTargets: function() {
                        return [{
                            canvas: this._canvas
                        }]
                    },
                    _getLayoutSeries: function(series, drawOptions) {
                        var layout;
                        var canvas = this._canvas;
                        var drawnLabels = false;
                        layout = this.layoutManager.applyPieChartSeriesLayout(canvas, series, true);
                        series.forEach((function(singleSeries) {
                            singleSeries.correctPosition(layout, canvas);
                            drawnLabels = singleSeries.drawLabelsWOPoints() || drawnLabels
                        }));
                        if (drawnLabels) {
                            layout = this.layoutManager.applyPieChartSeriesLayout(canvas, series, drawOptions.hideLayoutLabels)
                        }
                        series.forEach((function(singleSeries) {
                            singleSeries.hideLabels()
                        }));
                        this._sizeGroupLayout = {
                            x: layout.centerX,
                            y: layout.centerY,
                            radius: layout.radiusOuter,
                            drawOptions: drawOptions
                        };
                        return layout
                    },
                    _getLayoutSeriesForEqualPies: function(series, sizeGroupLayout) {
                        var canvas = this._canvas;
                        var layout = this.layoutManager.applyEqualPieChartLayout(series, sizeGroupLayout);
                        series.forEach((function(s) {
                            s.correctPosition(layout, canvas);
                            s.drawLabelsWOPoints()
                        }));
                        this.layoutManager.correctPieLabelRadius(series, layout, canvas);
                        return layout
                    },
                    _updateSeriesDimensions: function(drawOptions) {
                        var visibleSeries = this._getVisibleSeries();
                        var lengthVisibleSeries = visibleSeries.length;
                        var innerRad;
                        var delta;
                        var layout;
                        var sizeGroupLayout = drawOptions.sizeGroupLayout;
                        if (lengthVisibleSeries) {
                            layout = sizeGroupLayout ? this._getLayoutSeriesForEqualPies(visibleSeries, sizeGroupLayout) : this._getLayoutSeries(visibleSeries, drawOptions);
                            delta = (layout.radiusOuter - layout.radiusInner - seriesSpacing * (lengthVisibleSeries - 1)) / lengthVisibleSeries;
                            innerRad = layout.radiusInner;
                            this._setGeometry(layout);
                            visibleSeries.forEach((function(singleSeries) {
                                singleSeries.correctRadius({
                                    radiusInner: innerRad,
                                    radiusOuter: innerRad + delta
                                });
                                innerRad += delta + seriesSpacing
                            }))
                        }
                    },
                    _renderSeries: function(drawOptions, isRotated, isLegendInside) {
                        this._calculateSeriesLayout(drawOptions, isRotated);
                        if (!drawOptions.sizeGroupLayout && this.getSizeGroup()) {
                            pieSizeEqualizer.queue(this);
                            this._clearCanvas();
                            return
                        }
                        this._renderSeriesElements(drawOptions, isLegendInside)
                    },
                    _getCenter: function() {
                        return this._center
                    },
                    getInnerRadius: function() {
                        return this._innerRadius
                    },
                    _getLegendCallBack: function() {
                        var _this2 = this;
                        var legend = this._legend;
                        var items = this._getLegendTargets().map((function(i) {
                            return i.legendData
                        }));
                        return function(target) {
                            items.forEach((function(data) {
                                var points = [];
                                var callback = legend.getActionCallback({
                                    index: data.id
                                });
                                _this2.series.forEach((function(series) {
                                    var seriesPoints = series.getPointsByKeys(data.argument, data.argumentIndex);
                                    points.push.apply(points, seriesPoints)
                                }));
                                if (target && target.argument === data.argument && target.argumentIndex === data.argumentIndex) {
                                    points.push(target)
                                }
                                callback(function(points) {
                                    var state = NORMAL_STATE;
                                    points.forEach((function(point) {
                                        var _a;
                                        var seriesOptions = null === (_a = point.series) || void 0 === _a ? void 0 : _a.getOptions();
                                        var pointState = point.fullState;
                                        if ("none" === (null === seriesOptions || void 0 === seriesOptions ? void 0 : seriesOptions.hoverMode)) {
                                            pointState &= ~HOVER_STATE
                                        }
                                        if ("none" === (null === seriesOptions || void 0 === seriesOptions ? void 0 : seriesOptions.selectionMode)) {
                                            pointState &= ~SELECTED_STATE
                                        }
                                        state |= pointState
                                    }));
                                    return LEGEND_ACTIONS[state]
                                }(points))
                            }))
                        }
                    },
                    _locateLabels: function(resolveLabelOverlapping) {
                        var iterationCount = 0;
                        var labelsWereOverlapped;
                        var wordWrapApplied;
                        do {
                            wordWrapApplied = this._adjustSeriesLabels("shift" === resolveLabelOverlapping);
                            labelsWereOverlapped = this._resolveLabelOverlapping(resolveLabelOverlapping)
                        } while ((labelsWereOverlapped || wordWrapApplied) && ++iterationCount < 5)
                    },
                    _adjustSeriesLabels: function(moveLabelsFromCenter) {
                        return this.series.reduce((function(r, s) {
                            return s.adjustLabels(moveLabelsFromCenter) || r
                        }), false)
                    },
                    _applyExtraSettings: _common.noop,
                    _resolveLabelOverlappingShift: function() {
                        var _this3 = this;
                        var inverseDirection = "anticlockwise" === this.option("segmentsDirection");
                        var seriesByPosition = this.series.reduce((function(r, s) {
                            (r[s.getOptions().label.position] || r.outside).push(s);
                            return r
                        }), {
                            inside: [],
                            columns: [],
                            outside: []
                        });
                        var labelsOverlapped = false;
                        if (seriesByPosition.inside.length > 0) {
                            var pointsToResolve = seriesByPosition.inside.reduce((function(r, singleSeries) {
                                var visiblePoints = singleSeries.getVisiblePoints();
                                return visiblePoints.reduce((function(r, point) {
                                    r.left.push(point);
                                    return r
                                }), r)
                            }), {
                                left: [],
                                right: []
                            });
                            labelsOverlapped = resolveOverlappedLabels(pointsToResolve, shiftInColumnFunction, inverseDirection, this._canvas) || labelsOverlapped
                        }
                        labelsOverlapped = seriesByPosition.columns.reduce((function(r, singleSeries) {
                            return resolveOverlappedLabels(dividePoints(singleSeries), shiftInColumnFunction, inverseDirection, _this3._canvas) || r
                        }), labelsOverlapped);
                        if (seriesByPosition.outside.length > 0) {
                            labelsOverlapped = resolveOverlappedLabels(seriesByPosition.outside.reduce((function(r, singleSeries) {
                                return dividePoints(singleSeries, r)
                            }), null), (function(box, length) {
                                return (0, _utils.getVerticallyShiftedAngularCoords)(box, -length, _this3._center)
                            }), inverseDirection, this._canvas) || labelsOverlapped
                        }
                        return labelsOverlapped
                    },
                    _setGeometry: function(_ref) {
                        var x = _ref.centerX,
                            y = _ref.centerY,
                            radiusInner = _ref.radiusInner;
                        this._center = {
                            x: x,
                            y: y
                        };
                        this._innerRadius = radiusInner
                    },
                    _disposeSeries: function() {
                        this.callBase.apply(this, arguments);
                        this._abstractSeries = null
                    },
                    _legendDataField: "point",
                    _legendItemTextField: "argument",
                    _applyPointMarkersAutoHiding: _common.noop,
                    _renderTrackers: _common.noop,
                    _trackerType: "PieTracker",
                    _createScrollBar: _common.noop,
                    _updateAxesLayout: _common.noop,
                    _applyClipRects: _common.noop,
                    _appendAdditionalSeriesGroups: _common.noop,
                    _prepareToRender: _common.noop,
                    _isLegendInside: _common.noop,
                    _renderAxes: _common.noop,
                    _shrinkAxes: _common.noop,
                    _isRotated: _common.noop,
                    _seriesPopulatedHandlerCore: _common.noop,
                    _reinitAxes: _common.noop,
                    _correctAxes: _common.noop,
                    _getExtraOptions: function() {
                        return {
                            startAngle: this.option("startAngle"),
                            innerRadius: this.option("innerRadius"),
                            segmentsDirection: this.option("segmentsDirection"),
                            type: this.option("type")
                        }
                    },
                    getSizeGroup: function() {
                        return this._themeManager.getOptions("sizeGroup")
                    },
                    getSizeGroupLayout: function() {
                        return this._sizeGroupLayout || {}
                    }
                });
                (0, _iterator.each)(["startAngle", "innerRadius", "segmentsDirection", "type"], (function(_, name) {
                    dxPieChart.prototype._optionChangesMap[name] = "REFRESH_SERIES_DATA_INIT"
                }));
                dxPieChart.addPlugin(_center_template.plugins.pieChart);
                dxPieChart.addPlugin(_annotations.plugins.core);
                dxPieChart.addPlugin(_annotations.plugins.pieChart);
                (0, _component_registrator.default)("dxPieChart", dxPieChart);
                var _default = dxPieChart;
                exports.default = _default
            },
        86139:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/m_polar_chart.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = (obj = __webpack_require__( /*! ../../core/component_registrator */ 99393), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _annotations = __webpack_require__( /*! ../../viz/core/annotations */ 77129);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);
                var _m_advanced_chart = __webpack_require__( /*! ./chart_components/m_advanced_chart */ 41690);
                var dxPolarChart = _m_advanced_chart.AdvancedChart.inherit({
                    _themeSection: "polar",
                    _createPanes: function() {
                        this.callBase();
                        return [{
                            name: "default"
                        }]
                    },
                    _checkPaneName: function() {
                        return true
                    },
                    _getAxisRenderingOptions: function(typeSelector) {
                        var isArgumentAxis = "argumentAxis" === typeSelector;
                        var type = isArgumentAxis ? "circular" : "linear";
                        var useSpiderWeb = this.option("useSpiderWeb");
                        if (useSpiderWeb) {
                            type += "Spider"
                        }
                        return {
                            axisType: "polarAxes",
                            drawingType: type
                        }
                    },
                    _executeAppendBeforeSeries: function(append) {
                        append()
                    },
                    _prepareAxisOptions: function(typeSelector, axisOptions) {
                        var isArgumentAxis = "argumentAxis" === typeSelector;
                        var themeManager = this._themeManager;
                        var axisUserOptions = this.option("argumentAxis");
                        var argumentAxisOptions = themeManager.getOptions("argumentAxis", axisUserOptions) || {};
                        var startAngle = isFinite(argumentAxisOptions.startAngle) ? (0, _utils.normalizeAngle)(argumentAxisOptions.startAngle) : 0;
                        return {
                            type: this.option("useSpiderWeb") && isArgumentAxis ? "discrete" : axisOptions.type,
                            isHorizontal: true,
                            showCustomBoundaryTicks: isArgumentAxis,
                            startAngle: startAngle,
                            endAngle: startAngle + 360
                        }
                    },
                    _optionChangesMap: {
                        useSpiderWeb: "USE_SPIDER_WEB"
                    },
                    _change_USE_SPIDER_WEB: function() {
                        this._disposeAxes();
                        this._requestChange(["AXES_AND_PANES"])
                    },
                    _getExtraOptions: function() {
                        return {
                            spiderWidget: this.option("useSpiderWeb")
                        }
                    },
                    _prepareToRender: function() {
                        this._appendAxesGroups();
                        return {}
                    },
                    _calcCanvas: function() {
                        var canvas = (0, _extend.extend)({}, this._canvas);
                        var argumentAxis = this.getArgumentAxis();
                        var margins = argumentAxis.getMargins();
                        Object.keys(margins).forEach((function(margin) {
                            canvas[margin] = canvas["original".concat(margin[0].toUpperCase()).concat(margin.slice(1))] + margins[margin]
                        }));
                        return canvas
                    },
                    _renderAxes: function() {
                        var valueAxis = this._getValueAxis();
                        var argumentAxis = this.getArgumentAxis();
                        argumentAxis.draw(this._canvas);
                        valueAxis.setSpiderTicks(argumentAxis.getSpiderTicks());
                        var canvas = this._calcCanvas();
                        argumentAxis.updateSize(canvas);
                        valueAxis.draw(canvas);
                        return canvas
                    },
                    _getValueAxis: function() {
                        return this._valueAxes[0]
                    },
                    _shrinkAxes: function(sizeStorage) {
                        var valueAxis = this._getValueAxis();
                        var argumentAxis = this.getArgumentAxis();
                        if (sizeStorage && (sizeStorage.width || sizeStorage.height)) {
                            argumentAxis.hideOuterElements();
                            var canvas = this._calcCanvas();
                            argumentAxis.updateSize(canvas);
                            valueAxis.updateSize(canvas)
                        }
                    },
                    checkForMoreSpaceForPanesCanvas: function() {
                        return this.layoutManager.needMoreSpaceForPanesCanvas([{
                            canvas: this.getArgumentAxis().getCanvas()
                        }], this._isRotated())
                    },
                    _getLayoutTargets: function() {
                        return [{
                            canvas: this._canvas
                        }]
                    },
                    _getSeriesForPane: function() {
                        return this.series
                    },
                    _applyClipRects: function() {
                        var canvasClipRectID = this._getCanvasClipRectID();
                        this._createClipPathForPane();
                        this.getArgumentAxis().applyClipRects(this._getElementsClipRectID(), canvasClipRectID);
                        this._getValueAxis().applyClipRects(this._getElementsClipRectID(), canvasClipRectID)
                    },
                    _createClipPathForPane: function() {
                        var valueAxis = this._getValueAxis();
                        var center = valueAxis.getCenter();
                        var radius = valueAxis.getRadius();
                        var panesClipRects = this._panesClipRects;
                        center = {
                            x: Math.round(center.x),
                            y: Math.round(center.y)
                        };
                        this._createClipCircle(panesClipRects.fixed, center.x, center.y, radius);
                        this._createClipCircle(panesClipRects.base, center.x, center.y, radius);
                        if (this.series.some((function(s) {
                                return s.areErrorBarsVisible()
                            }))) {
                            this._createClipCircle(panesClipRects.wide, center.x, center.y, radius)
                        } else {
                            panesClipRects.wide[0] = null
                        }
                    },
                    _createClipCircle: function(clipArray, left, top, radius) {
                        var clipCircle = clipArray[0];
                        if (!clipCircle) {
                            clipCircle = this._renderer.clipCircle(left, top, radius);
                            clipArray[0] = clipCircle
                        } else {
                            clipCircle.attr({
                                cx: left,
                                cy: top,
                                r: radius
                            })
                        }
                    },
                    _applyExtraSettings: function(series) {
                        var wideClipRect = this._panesClipRects.wide[0];
                        series.setClippingParams(this._panesClipRects.base[0].id, wideClipRect && wideClipRect.id, false, false)
                    },
                    getActualAngle: function(angle) {
                        return this.getArgumentAxis().getOptions().inverted ? 360 - angle : angle
                    },
                    getXYFromPolar: function(angle, radius, argument, value) {
                        var layoutInfo = {
                            angle: void 0,
                            radius: void 0,
                            x: void 0,
                            y: void 0
                        };
                        if (!(0, _type.isDefined)(angle) && !(0, _type.isDefined)(radius) && !(0, _type.isDefined)(argument) && !(0, _type.isDefined)(value)) {
                            return layoutInfo
                        }
                        var argAxis = this.getArgumentAxis();
                        var startAngle = argAxis.getAngles()[0];
                        var argAngle;
                        var translatedRadius;
                        if ((0, _type.isDefined)(argument)) {
                            argAngle = argAxis.getTranslator().translate(argument)
                        } else if (isFinite(angle)) {
                            argAngle = this.getActualAngle(angle)
                        } else if (!(0, _type.isDefined)(angle)) {
                            argAngle = 0
                        }
                        if ((0, _type.isDefined)(value)) {
                            translatedRadius = this.getValueAxis().getTranslator().translate(value)
                        } else if (isFinite(radius)) {
                            translatedRadius = radius
                        } else if (!(0, _type.isDefined)(radius)) {
                            translatedRadius = argAxis.getRadius()
                        }
                        if ((0, _type.isDefined)(argAngle) && (0, _type.isDefined)(translatedRadius)) {
                            var coords = (0, _utils.convertPolarToXY)(argAxis.getCenter(), startAngle, argAngle, translatedRadius);
                            (0, _extend.extend)(layoutInfo, coords, {
                                angle: argAxis.getTranslatedAngle(argAngle),
                                radius: translatedRadius
                            })
                        }
                        return layoutInfo
                    },
                    _applyPointMarkersAutoHiding: _common.noop,
                    _createScrollBar: _common.noop,
                    _isRotated: _common.noop,
                    _getCrosshairOptions: _common.noop,
                    _isLegendInside: _common.noop
                });
                dxPolarChart.addPlugin(_annotations.plugins.core);
                dxPolarChart.addPlugin(_annotations.plugins.polarChart);
                (0, _component_registrator.default)("dxPolarChart", dxPolarChart);
                var _default = dxPolarChart;
                exports.default = _default
            },
        23908:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/easing.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.convertTransitionTimingFuncToEasing = void 0;
                exports.getEasing = function(name) {
                    return easing[name]
                };
                exports.setEasing = function(value) {
                    easing = value
                };
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var CSS_TRANSITION_EASING_REGEX = /cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/;
                var TransitionTimingFuncMap = {
                    linear: "cubic-bezier(0, 0, 1, 1)",
                    swing: "cubic-bezier(0.445, 0.05, 0.55, 0.95)",
                    ease: "cubic-bezier(0.25, 0.1, 0.25, 1)",
                    "ease-in": "cubic-bezier(0.42, 0, 1, 1)",
                    "ease-out": "cubic-bezier(0, 0, 0.58, 1)",
                    "ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)"
                };
                var polynomBezier = function(x1, y1, x2, y2) {
                    var Cx = 3 * x1;
                    var Bx = 3 * (x2 - x1) - Cx;
                    var Ax = 1 - Cx - Bx;
                    var Cy = 3 * y1;
                    var By = 3 * (y2 - y1) - Cy;
                    var Ay = 1 - Cy - By;
                    var bezierX = function(t) {
                        return t * (Cx + t * (Bx + t * Ax))
                    };
                    var derivativeX = function(t) {
                        return Cx + t * (2 * Bx + 3 * t * Ax)
                    };
                    return function(t) {
                        return function(t) {
                            return t * (Cy + t * (By + t * Ay))
                        }(function(t) {
                            var x = t;
                            var i = 0;
                            var z;
                            while (i < 14) {
                                z = bezierX(x) - t;
                                if (Math.abs(z) < .001) {
                                    break
                                }
                                x -= z / derivativeX(x);
                                i++
                            }
                            return x
                        }(t))
                    }
                };
                var easing = {};
                exports.convertTransitionTimingFuncToEasing = function(cssTransitionEasing) {
                    cssTransitionEasing = TransitionTimingFuncMap[cssTransitionEasing] || cssTransitionEasing;
                    var coeffs = cssTransitionEasing.match(CSS_TRANSITION_EASING_REGEX);
                    var forceName;
                    if (!coeffs) {
                        forceName = "linear";
                        coeffs = TransitionTimingFuncMap[forceName].match(CSS_TRANSITION_EASING_REGEX)
                    }
                    coeffs = coeffs.slice(1, 5);
                    for (var i = 0; i < coeffs.length; i++) {
                        coeffs[i] = parseFloat(coeffs[i])
                    }
                    var easingName = forceName || "cubicbezier_" + coeffs.join("_").replace(/\./g, "p");
                    if (!(0, _type.isFunction)(easing[easingName])) {
                        easing[easingName] = function(x, t, b, c, d) {
                            return c * polynomBezier(coeffs[0], coeffs[1], coeffs[2], coeffs[3])(t / d) + b
                        }
                    }
                    return easingName
                }
            },
        90057:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/frame.js ***!
              \****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.cancelAnimationFrame = function() {
                    setAnimationFrameMethods();
                    cancel.apply(window, arguments)
                };
                exports.requestAnimationFrame = function() {
                    setAnimationFrameMethods();
                    return request.apply(window, arguments)
                };
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _call_once = (obj = __webpack_require__( /*! ../core/utils/call_once */ 39618), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var window = (0, _window.hasWindow)() ? (0, _window.getWindow)() : {};
                var request = function(callback) {
                    return setTimeout(callback, 1e3 / 60)
                };
                var cancel = function(requestID) {
                    clearTimeout(requestID)
                };
                var setAnimationFrameMethods = (0, _call_once.default)((function() {
                    var nativeRequest = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame;
                    var nativeCancel = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
                    if (nativeRequest && nativeCancel) {
                        request = nativeRequest;
                        cancel = nativeCancel
                    }
                }))
            },
        87209:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/fx.js ***!
              \*************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 17381));
                var _element = __webpack_require__( /*! ../core/element */ 6415);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _translator = __webpack_require__( /*! ./translator */ 31648);
                var _easing = __webpack_require__( /*! ./easing */ 23908);
                var _frame = __webpack_require__( /*! ./frame */ 90057);
                var _support = __webpack_require__( /*! ../core/utils/support */ 60137);
                var _position = _interopRequireDefault(__webpack_require__( /*! ./position */ 49387));
                var _remove = __webpack_require__( /*! ../events/remove */ 29007);
                var _index = __webpack_require__( /*! ../events/utils/index */ 39611);
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                var window = (0, _window.getWindow)();
                var removeEventName = (0, _index.addNamespace)(_remove.removeEvent, "dxFX");
                var RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i;
                var TransitionAnimationStrategy = {
                    initAnimation: function($element, config) {
                        $element.css({
                            transitionProperty: "none"
                        });
                        if ("string" === typeof config.from) {
                            $element.addClass(config.from)
                        } else {
                            setProps($element, config.from)
                        }
                        var that = this;
                        var deferred = new _deferred.Deferred;
                        var cleanupWhen = config.cleanupWhen;
                        config.transitionAnimation = {
                            deferred: deferred,
                            finish: function() {
                                that._finishTransition($element);
                                if (cleanupWhen) {
                                    (0, _deferred.when)(deferred, cleanupWhen).always((function() {
                                        that._cleanup($element, config)
                                    }))
                                } else {
                                    that._cleanup($element, config)
                                }
                                deferred.resolveWith($element, [config, $element])
                            }
                        };
                        this._completeAnimationCallback($element, config).done((function() {
                            config.transitionAnimation.finish()
                        })).fail((function() {
                            deferred.rejectWith($element, [config, $element])
                        }));
                        if (!config.duration) {
                            config.transitionAnimation.finish()
                        }
                        $element.css("transform")
                    },
                    animate: function($element, config) {
                        this._startAnimation($element, config);
                        return config.transitionAnimation.deferred.promise()
                    },
                    _completeAnimationCallback: function($element, config) {
                        var that = this;
                        var startTime = Date.now() + config.delay;
                        var deferred = new _deferred.Deferred;
                        var transitionEndFired = new _deferred.Deferred;
                        var simulatedTransitionEndFired = new _deferred.Deferred;
                        var simulatedEndEventTimer;
                        var transitionEndEventFullName = (0, _support.transitionEndEventName)() + ".dxFX";
                        config.transitionAnimation.cleanup = function() {
                            clearTimeout(simulatedEndEventTimer);
                            clearTimeout(waitForJSCompleteTimer);
                            _events_engine.default.off($element, transitionEndEventFullName);
                            _events_engine.default.off($element, removeEventName)
                        };
                        _events_engine.default.one($element, transitionEndEventFullName, (function() {
                            if (Date.now() - startTime >= config.duration) {
                                transitionEndFired.reject()
                            }
                        }));
                        _events_engine.default.off($element, removeEventName);
                        _events_engine.default.on($element, removeEventName, (function() {
                            that.stop($element, config);
                            deferred.reject()
                        }));
                        var waitForJSCompleteTimer = setTimeout((function() {
                            simulatedEndEventTimer = setTimeout((function() {
                                simulatedTransitionEndFired.reject()
                            }), config.duration + config.delay + fx._simulatedTransitionEndDelay);
                            (0, _deferred.when)(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                                deferred.resolve()
                            }.bind(this))
                        }));
                        return deferred.promise()
                    },
                    _startAnimation: function($element, config) {
                        $element.css({
                            transitionProperty: "all",
                            transitionDelay: config.delay + "ms",
                            transitionDuration: config.duration + "ms",
                            transitionTimingFunction: config.easing
                        });
                        if ("string" === typeof config.to) {
                            $element[0].className += " " + config.to
                        } else if (config.to) {
                            setProps($element, config.to)
                        }
                    },
                    _finishTransition: function($element) {
                        $element.css("transition", "none")
                    },
                    _cleanup: function($element, config) {
                        config.transitionAnimation.cleanup();
                        if ("string" === typeof config.from) {
                            $element.removeClass(config.from);
                            $element.removeClass(config.to)
                        }
                    },
                    stop: function($element, config, jumpToEnd) {
                        if (!config) {
                            return
                        }
                        if (jumpToEnd) {
                            config.transitionAnimation.finish()
                        } else {
                            if ((0, _type.isPlainObject)(config.to)) {
                                (0, _iterator.each)(config.to, (function(key) {
                                    $element.css(key, $element.css(key))
                                }))
                            }
                            this._finishTransition($element);
                            this._cleanup($element, config)
                        }
                    }
                };
                var FrameAnimationStrategy = {
                    initAnimation: function($element, config) {
                        setProps($element, config.from)
                    },
                    animate: function($element, config) {
                        var deferred = new _deferred.Deferred;
                        var that = this;
                        if (!config) {
                            return deferred.reject().promise()
                        }(0, _iterator.each)(config.to, (function(prop) {
                            if (void 0 === config.from[prop]) {
                                config.from[prop] = that._normalizeValue($element.css(prop))
                            }
                        }));
                        if (config.to.transform) {
                            config.from.transform = that._parseTransform(config.from.transform);
                            config.to.transform = that._parseTransform(config.to.transform)
                        }
                        config.frameAnimation = {
                            to: config.to,
                            from: config.from,
                            currentValue: config.from,
                            easing: (0, _easing.convertTransitionTimingFuncToEasing)(config.easing),
                            duration: config.duration,
                            startTime: (new Date).valueOf(),
                            finish: function() {
                                this.currentValue = this.to;
                                this.draw();
                                (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId);
                                deferred.resolve()
                            },
                            draw: function() {
                                if (config.draw) {
                                    config.draw(this.currentValue);
                                    return
                                }
                                var currentValue = (0, _extend.extend)({}, this.currentValue);
                                if (currentValue.transform) {
                                    currentValue.transform = (0, _iterator.map)(currentValue.transform, (function(value, prop) {
                                        if ("translate" === prop) {
                                            return (0, _translator.getTranslateCss)(value)
                                        } else if ("scale" === prop) {
                                            return "scale(" + value + ")"
                                        } else if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    })).join(" ")
                                }
                                $element.css(currentValue)
                            }
                        };
                        if (config.delay) {
                            config.frameAnimation.startTime += config.delay;
                            config.frameAnimation.delayTimeout = setTimeout((function() {
                                that._startAnimation($element, config)
                            }), config.delay)
                        } else {
                            that._startAnimation($element, config)
                        }
                        return deferred.promise()
                    },
                    _startAnimation: function($element, config) {
                        _events_engine.default.off($element, removeEventName);
                        _events_engine.default.on($element, removeEventName, (function() {
                            if (config.frameAnimation) {
                                (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId)
                            }
                        }));
                        this._animationStep($element, config)
                    },
                    _parseTransform: function(transformString) {
                        var result = {};
                        (0, _iterator.each)(transformString.match(/\w+\d*\w*\([^)]*\)\s*/g), (function(i, part) {
                            var translateData = (0, _translator.parseTranslate)(part);
                            var scaleData = part.match(/scale\((.+?)\)/);
                            var rotateData = part.match(/(rotate.)\((.+)deg\)/);
                            if (translateData) {
                                result.translate = translateData
                            }
                            if (scaleData && scaleData[1]) {
                                result.scale = parseFloat(scaleData[1])
                            }
                            if (rotateData && rotateData[1]) {
                                result[rotateData[1]] = parseFloat(rotateData[2])
                            }
                        }));
                        return result
                    },
                    stop: function($element, config, jumpToEnd) {
                        var frameAnimation = config && config.frameAnimation;
                        if (!frameAnimation) {
                            return
                        }(0, _frame.cancelAnimationFrame)(frameAnimation.animationFrameId);
                        clearTimeout(frameAnimation.delayTimeout);
                        if (jumpToEnd) {
                            frameAnimation.finish()
                        }
                        delete config.frameAnimation
                    },
                    _animationStep: function($element, config) {
                        var frameAnimation = config && config.frameAnimation;
                        if (!frameAnimation) {
                            return
                        }
                        var now = (new Date).valueOf();
                        if (now >= frameAnimation.startTime + frameAnimation.duration) {
                            frameAnimation.finish();
                            return
                        }
                        frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                        frameAnimation.draw();
                        var that = this;
                        frameAnimation.animationFrameId = (0, _frame.requestAnimationFrame)((function() {
                            that._animationStep($element, config)
                        }))
                    },
                    _calcStepValue: function(frameAnimation, currentDuration) {
                        return function calcValueRecursively(from, to) {
                            var result = Array.isArray(to) ? [] : {};
                            (0, _iterator.each)(to, (function(propName, endPropValue) {
                                if ("string" === typeof endPropValue && false === parseFloat(endPropValue)) {
                                    return true
                                }
                                result[propName] = "object" === _typeof(endPropValue) ? calcValueRecursively(from[propName], endPropValue) : function(propName) {
                                    var x = currentDuration / frameAnimation.duration;
                                    var t = currentDuration;
                                    var b = 1 * from[propName];
                                    var c = to[propName] - from[propName];
                                    var d = frameAnimation.duration;
                                    return (0, _easing.getEasing)(frameAnimation.easing)(x, t, b, c, d)
                                }(propName)
                            }));
                            return result
                        }(frameAnimation.from, frameAnimation.to)
                    },
                    _normalizeValue: function(value) {
                        var numericValue = parseFloat(value);
                        if (false === numericValue) {
                            return value
                        }
                        return numericValue
                    }
                };
                var FallbackToNoAnimationStrategy = {
                    initAnimation: function() {},
                    animate: function() {
                        return (new _deferred.Deferred).resolve().promise()
                    },
                    stop: _common.noop,
                    isSynchronous: true
                };
                var baseConfigValidator = function(config, animationType, validate, typeMessage) {
                    (0, _iterator.each)(["from", "to"], (function() {
                        if (!validate(config[this])) {
                            throw _errors.default.Error("E0010", animationType, this, typeMessage)
                        }
                    }))
                };
                var isObjectConfigValidator = function(config, animationType) {
                    return baseConfigValidator(config, animationType, (function(target) {
                        return (0, _type.isPlainObject)(target)
                    }), "a plain object")
                };
                var CssAnimationConfigurator = {
                    validateConfig: function(config) {
                        ! function(config, animationType) {
                            return baseConfigValidator(config, animationType, (function(target) {
                                return "string" === typeof target
                            }), "a string")
                        }(config, "css")
                    },
                    setup: function() {}
                };
                var positionAliases = {
                    top: {
                        my: "bottom center",
                        at: "top center"
                    },
                    bottom: {
                        my: "top center",
                        at: "bottom center"
                    },
                    right: {
                        my: "left center",
                        at: "right center"
                    },
                    left: {
                        my: "right center",
                        at: "left center"
                    }
                };
                var SlideAnimationConfigurator = {
                    validateConfig: function(config) {
                        isObjectConfigValidator(config, "slide")
                    },
                    setup: function($element, config) {
                        var location = (0, _translator.locate)($element);
                        if ("slide" !== config.type) {
                            var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                            positioningConfig.position = (0, _extend.extend)({
                                of: window
                            }, positionAliases[config.direction]);
                            setupPosition($element, positioningConfig)
                        }
                        this._setUpConfig(location, config.from);
                        this._setUpConfig(location, config.to);
                        (0, _translator.clearCache)($element)
                    },
                    _setUpConfig: function(location, config) {
                        config.left = "left" in config ? config.left : "+=0";
                        config.top = "top" in config ? config.top : "+=0";
                        this._initNewPosition(location, config)
                    },
                    _initNewPosition: function(location, config) {
                        var position = {
                            left: config.left,
                            top: config.top
                        };
                        delete config.left;
                        delete config.top;
                        var relativeValue = this._getRelativeValue(position.left);
                        if (void 0 !== relativeValue) {
                            position.left = relativeValue + location.left
                        } else {
                            config.left = 0
                        }
                        relativeValue = this._getRelativeValue(position.top);
                        if (void 0 !== relativeValue) {
                            position.top = relativeValue + location.top
                        } else {
                            config.top = 0
                        }
                        config.transform = (0, _translator.getTranslateCss)({
                            x: position.left,
                            y: position.top
                        })
                    },
                    _getRelativeValue: function(value) {
                        var relativeValue;
                        if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                            return parseInt(relativeValue[1] + "1") * relativeValue[2]
                        }
                    }
                };
                var FadeAnimationConfigurator = {
                    setup: function($element, config) {
                        var _from$opacity, _to$opacity;
                        var from = config.from;
                        var to = config.to;
                        var defaultFromOpacity = "fadeOut" === config.type ? 1 : 0;
                        var defaultToOpacity = "fadeOut" === config.type ? 0 : 1;
                        var fromOpacity = (0, _type.isPlainObject)(from) ? String(null !== (_from$opacity = from.opacity) && void 0 !== _from$opacity ? _from$opacity : defaultFromOpacity) : String(from);
                        var toOpacity = (0, _type.isPlainObject)(to) ? String(null !== (_to$opacity = to.opacity) && void 0 !== _to$opacity ? _to$opacity : defaultToOpacity) : String(to);
                        if (!config.skipElementInitialStyles) {
                            fromOpacity = $element.css("opacity")
                        }
                        switch (config.type) {
                            case "fadeIn":
                                toOpacity = 1;
                                break;
                            case "fadeOut":
                                toOpacity = 0
                        }
                        config.from = {
                            visibility: "visible",
                            opacity: fromOpacity
                        };
                        config.to = {
                            opacity: toOpacity
                        }
                    }
                };
                var PopAnimationConfigurator = {
                    validateConfig: function(config) {
                        isObjectConfigValidator(config, "pop")
                    },
                    setup: function($element, config) {
                        var from = config.from;
                        var to = config.to;
                        var fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity");
                        var toOpacity = "opacity" in to ? to.opacity : 1;
                        var fromScale = "scale" in from ? from.scale : 0;
                        var toScale = "scale" in to ? to.scale : 1;
                        config.from = {
                            opacity: fromOpacity
                        };
                        var translate = (0, _translator.getTranslate)($element);
                        config.from.transform = this._getCssTransform(translate, fromScale);
                        config.to = {
                            opacity: toOpacity
                        };
                        config.to.transform = this._getCssTransform(translate, toScale)
                    },
                    _getCssTransform: function(translate, scale) {
                        return (0, _translator.getTranslateCss)(translate) + "scale(" + scale + ")"
                    }
                };
                var animationConfigurators = {
                    custom: {
                        setup: function() {}
                    },
                    slide: SlideAnimationConfigurator,
                    slideIn: SlideAnimationConfigurator,
                    slideOut: SlideAnimationConfigurator,
                    fade: FadeAnimationConfigurator,
                    fadeIn: FadeAnimationConfigurator,
                    fadeOut: FadeAnimationConfigurator,
                    pop: PopAnimationConfigurator,
                    css: CssAnimationConfigurator
                };
                var defaultJSConfig = {
                    type: "custom",
                    from: {},
                    to: {},
                    duration: 400,
                    start: _common.noop,
                    complete: _common.noop,
                    easing: "ease",
                    delay: 0
                };
                var defaultCssConfig = {
                    duration: 400,
                    easing: "ease",
                    delay: 0
                };

                function setupAnimationOnElement() {
                    var $element = this.element;
                    var config = this.config;
                    setupPosition($element, config.from);
                    setupPosition($element, config.to);
                    this.configurator.setup($element, config);
                    $element.data("dxAnimData", this);
                    if (fx.off) {
                        config.duration = 0;
                        config.delay = 0
                    }
                    this.strategy.initAnimation($element, config);
                    if (config.start) {
                        var element = (0, _element.getPublicElement)($element);
                        config.start.apply(this, [element, config])
                    }
                }
                var startAnimationOnElement = function() {
                    var animation = this;
                    var $element = animation.element;
                    var config = animation.config;
                    animation.isStarted = true;
                    return animation.strategy.animate($element, config).done((function() {
                        ! function(animation) {
                            var $element = animation.element;
                            var config = animation.config;
                            $element.removeData("dxAnimData");
                            if (config.complete) {
                                var element = (0, _element.getPublicElement)($element);
                                config.complete.apply(this, [element, config])
                            }
                            animation.deferred.resolveWith(this, [$element, config])
                        }(animation)
                    })).fail((function() {
                        animation.deferred.rejectWith(this, [$element, config])
                    }))
                };
                var stopAnimationOnElement = function(jumpToEnd) {
                    var $element = this.element;
                    var config = this.config;
                    clearTimeout(this.startTimeout);
                    if (!this.isStarted) {
                        this.start()
                    }
                    this.strategy.stop($element, config, jumpToEnd)
                };
                var scopedRemoveEvent = (0, _index.addNamespace)(_remove.removeEvent, "dxFXStartAnimation");
                var createAnimation = function(element, initialConfig) {
                    var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig;
                    var config = (0, _extend.extend)(true, {}, defaultConfig, initialConfig);
                    var configurator = function(config) {
                        var result = animationConfigurators[config.type];
                        if (!result) {
                            throw _errors.default.Error("E0011", config.type)
                        }
                        return result
                    }(config);
                    var strategy = function(config) {
                        config = config || {};
                        var animationStrategies = {
                            transition: (0, _support.transition)() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                            frame: FrameAnimationStrategy,
                            noAnimation: FallbackToNoAnimationStrategy
                        };
                        var strategy = config.strategy || "transition";
                        if ("css" === config.type && !(0, _support.transition)()) {
                            strategy = "noAnimation"
                        }
                        return animationStrategies[strategy]
                    }(config);
                    var animation = {
                        element: (0, _renderer.default)(element),
                        config: config,
                        configurator: configurator,
                        strategy: strategy,
                        isSynchronous: strategy.isSynchronous,
                        setup: setupAnimationOnElement,
                        start: startAnimationOnElement,
                        stop: stopAnimationOnElement,
                        deferred: new _deferred.Deferred
                    };
                    if ((0, _type.isFunction)(configurator.validateConfig)) {
                        configurator.validateConfig(config)
                    }! function(animation) {
                        _events_engine.default.off(animation.element, scopedRemoveEvent);
                        _events_engine.default.on(animation.element, scopedRemoveEvent, (function() {
                            fx.stop(animation.element)
                        }));
                        animation.deferred.always((function() {
                            _events_engine.default.off(animation.element, scopedRemoveEvent)
                        }))
                    }(animation);
                    return animation
                };

                function getAnimQueueData($element) {
                    return $element.data("dxAnimQueue") || []
                }
                var destroyAnimQueueData = function($element) {
                    $element.removeData("dxAnimQueue")
                };

                function isAnimating($element) {
                    return !!$element.data("dxAnimData")
                }

                function shiftFromAnimationQueue($element, queueData) {
                    queueData = getAnimQueueData($element);
                    if (!queueData.length) {
                        return
                    }
                    var animation = queueData.shift();
                    if (0 === queueData.length) {
                        destroyAnimQueueData($element)
                    }(function(animation) {
                        animation.setup();
                        if (fx.off || animation.isSynchronous) {
                            animation.start()
                        } else {
                            animation.startTimeout = setTimeout((function() {
                                animation.start()
                            }))
                        }
                        return animation.deferred.promise()
                    })(animation).done((function() {
                        if (!isAnimating($element)) {
                            shiftFromAnimationQueue($element)
                        }
                    }))
                }

                function setupPosition($element, config) {
                    if (!config || !config.position) {
                        return
                    }
                    var win = (0, _renderer.default)(window);
                    var left = 0;
                    var top = 0;
                    var position = _position.default.calculate($element, config.position);
                    var offset = $element.offset();
                    var currentPosition = $element.position();
                    if (currentPosition.top > offset.top) {
                        top = win.scrollTop()
                    }
                    if (currentPosition.left > offset.left) {
                        left = win.scrollLeft()
                    }(0, _extend.extend)(config, {
                        left: position.h.location - offset.left + currentPosition.left - left,
                        top: position.v.location - offset.top + currentPosition.top - top
                    });
                    delete config.position
                }

                function setProps($element, props) {
                    (0, _iterator.each)(props, (function(key, value) {
                        try {
                            $element.css(key, (0, _type.isFunction)(value) ? value() : value)
                        } catch (e) {}
                    }))
                }
                var fx = {
                    off: false,
                    animationTypes: animationConfigurators,
                    animate: function(element, config) {
                        var $element = (0, _renderer.default)(element);
                        if (!$element.length) {
                            return (new _deferred.Deferred).resolve().promise()
                        }
                        var animation = createAnimation($element, config);
                        ! function($element, animation) {
                            var queueData = getAnimQueueData($element);
                            ! function($element, queueData) {
                                $element.data("dxAnimQueue", queueData)
                            }($element, queueData);
                            queueData.push(animation);
                            if (!isAnimating($element)) {
                                shiftFromAnimationQueue($element, queueData)
                            }
                        }($element, animation);
                        return animation.deferred.promise()
                    },
                    createAnimation: createAnimation,
                    isAnimating: isAnimating,
                    stop: function(element, jumpToEnd) {
                        var $element = (0, _renderer.default)(element);
                        var queueData = getAnimQueueData($element);
                        (0, _iterator.each)(queueData, (function(_, animation) {
                            animation.config.delay = 0;
                            animation.config.duration = 0;
                            animation.isSynchronous = true
                        }));
                        if (!isAnimating($element)) {
                            shiftFromAnimationQueue($element, queueData)
                        }
                        var animation = $element.data("dxAnimData");
                        if (animation) {
                            animation.stop(jumpToEnd)
                        }
                        $element.removeData("dxAnimData");
                        destroyAnimQueueData($element)
                    },
                    _simulatedTransitionEndDelay: 100
                };
                var _default = fx;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        49387:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/position.js ***!
              \*******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _size = __webpack_require__( /*! ../core/utils/size */ 58664);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _position = __webpack_require__( /*! ../core/utils/position */ 37518);
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../core/utils/browser */ 47810));
                var _translator = __webpack_require__( /*! ./translator */ 31648);
                var _support = __webpack_require__( /*! ../core/utils/support */ 60137);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 20530));
                var _style = __webpack_require__( /*! ../core/utils/style */ 80968);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var window = (0, _window.getWindow)();
                var horzRe = /left|right/;
                var vertRe = /top|bottom/;
                var collisionRe = /fit|flip|none/;
                var scaleRe = /scale\(.+?\)/;
                var IS_SAFARI = _browser.default.safari;
                var normalizeAlign = function(raw) {
                    var result = {
                        h: "center",
                        v: "center"
                    };
                    var pair = (0, _common.splitPair)(raw);
                    if (pair) {
                        (0, _iterator.each)(pair, (function() {
                            var w = String(this).toLowerCase();
                            if (horzRe.test(w)) {
                                result.h = w
                            } else if (vertRe.test(w)) {
                                result.v = w
                            }
                        }))
                    }
                    return result
                };
                var normalizeOffset = function(raw, preventRound) {
                    return (0, _common.pairToObject)(raw, preventRound)
                };
                var getAlignFactor = function(align) {
                    switch (align) {
                        case "center":
                            return .5;
                        case "right":
                        case "bottom":
                            return 1;
                        default:
                            return 0
                    }
                };
                var inverseAlign = function(align) {
                    switch (align) {
                        case "left":
                            return "right";
                        case "right":
                            return "left";
                        case "top":
                            return "bottom";
                        case "bottom":
                            return "top";
                        default:
                            return align
                    }
                };
                var calculateOversize = function(data, bounds) {
                    var oversize = 0;
                    if (data.myLocation < bounds.min) {
                        oversize += bounds.min - data.myLocation
                    }
                    if (data.myLocation > bounds.max) {
                        oversize += data.myLocation - bounds.max
                    }
                    return oversize
                };
                var collisionSide = function(direction, data, bounds) {
                    if (data.myLocation < bounds.min) {
                        return "h" === direction ? "left" : "top"
                    }
                    if (data.myLocation > bounds.max) {
                        return "h" === direction ? "right" : "bottom"
                    }
                    return "none"
                };
                var initMyLocation = function(data) {
                    data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
                };
                var collisionResolvers = {
                    fit: function(data, bounds) {
                        var result = false;
                        if (data.myLocation > bounds.max) {
                            data.myLocation = bounds.max;
                            result = true
                        }
                        if (data.myLocation < bounds.min) {
                            data.myLocation = bounds.min;
                            result = true
                        }
                        data.fit = result
                    },
                    flip: function(data, bounds) {
                        data.flip = false;
                        if ("center" === data.myAlign && "center" === data.atAlign) {
                            return
                        }
                        if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                            var inverseData = (0, _extend.extend)({}, data, {
                                myAlign: inverseAlign(data.myAlign),
                                atAlign: inverseAlign(data.atAlign),
                                offset: -data.offset
                            });
                            initMyLocation(inverseData);
                            inverseData.oversize = calculateOversize(inverseData, bounds);
                            if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                                data.myLocation = inverseData.myLocation;
                                data.oversize = inverseData.oversize;
                                data.flip = true
                            }
                        }
                    },
                    flipfit: function(data, bounds) {
                        this.flip(data, bounds);
                        this.fit(data, bounds)
                    },
                    none: function(data) {
                        data.oversize = 0
                    }
                };
                var scrollbarWidth;
                var calculateScrollbarWidth = function() {
                    var $scrollDiv = (0, _renderer.default)("<div>").css({
                        width: 100,
                        height: 100,
                        overflow: "scroll",
                        position: "absolute",
                        top: -9999
                    }).appendTo((0, _renderer.default)("body"));
                    var result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
                    $scrollDiv.remove();
                    scrollbarWidth = result
                };
                var defaultPositionResult = {
                    h: {
                        location: 0,
                        flip: false,
                        fit: false,
                        oversize: 0
                    },
                    v: {
                        location: 0,
                        flip: false,
                        fit: false,
                        oversize: 0
                    }
                };
                var calculatePosition = function(what, options) {
                    var $what = (0, _renderer.default)(what);
                    var currentOffset = $what.offset();
                    var result = (0, _extend.extend)(true, {}, defaultPositionResult, {
                        h: {
                            location: currentOffset.left
                        },
                        v: {
                            location: currentOffset.top
                        }
                    });
                    if (!options) {
                        return result
                    }
                    var my = normalizeAlign(options.my);
                    var at = normalizeAlign(options.at);
                    var of = (0, _renderer.default)(options.of).length && options.of || window;
                    var offset = normalizeOffset(options.offset, options.precise);
                    var collision = function(raw) {
                        var pair = (0, _common.splitPair)(raw);
                        var h = String(pair && pair[0]).toLowerCase();
                        var v = String(pair && pair[1]).toLowerCase();
                        if (!collisionRe.test(h)) {
                            h = "none"
                        }
                        if (!collisionRe.test(v)) {
                            v = h
                        }
                        return {
                            h: h,
                            v: v
                        }
                    }(options.collision);
                    var boundary = options.boundary;
                    var boundaryOffset = normalizeOffset(options.boundaryOffset, options.precise);
                    var h = {
                        mySize: (0, _size.getOuterWidth)($what),
                        myAlign: my.h,
                        atAlign: at.h,
                        offset: offset.h,
                        collision: collision.h,
                        boundaryOffset: boundaryOffset.h
                    };
                    var v = {
                        mySize: (0, _size.getOuterHeight)($what),
                        myAlign: my.v,
                        atAlign: at.v,
                        offset: offset.v,
                        collision: collision.v,
                        boundaryOffset: boundaryOffset.v
                    };
                    if (of.preventDefault) {
                        h.atLocation = of.pageX;
                        v.atLocation = of.pageY;
                        h.atSize = 0;
                        v.atSize = 0
                    } else {
                        of = (0, _renderer.default)(of);
                        if ((0, _type.isWindow)(of [0])) {
                            h.atLocation = of.scrollLeft();
                            v.atLocation = of.scrollTop();
                            if ("phone" === _devices.default.real().deviceType && of [0].visualViewport) {
                                h.atLocation = Math.max(h.atLocation, of [0].visualViewport.offsetLeft);
                                v.atLocation = Math.max(v.atLocation, of [0].visualViewport.offsetTop);
                                h.atSize = of [0].visualViewport.width;
                                v.atSize = of [0].visualViewport.height
                            } else {
                                h.atSize = of [0].innerWidth > of [0].outerWidth ? of [0].innerWidth : (0, _size.getWidth)(of);
                                v.atSize = of [0].innerHeight > of [0].outerHeight || IS_SAFARI ? of [0].innerHeight : (0, _size.getHeight)(of)
                            }
                        } else if (9 === of [0].nodeType) {
                            h.atLocation = 0;
                            v.atLocation = 0;
                            h.atSize = (0, _size.getWidth)(of);
                            v.atSize = (0, _size.getHeight)(of)
                        } else {
                            var ofRect = (0, _position.getBoundingRect)(of.get(0));
                            var o = getOffsetWithoutScale(of);
                            h.atLocation = o.left;
                            v.atLocation = o.top;
                            h.atSize = Math.max(ofRect.width, (0, _size.getOuterWidth)(of));
                            v.atSize = Math.max(ofRect.height, (0, _size.getOuterHeight)(of))
                        }
                    }
                    initMyLocation(h);
                    initMyLocation(v);
                    var bounds = function() {
                        var win = (0, _renderer.default)(window);
                        var windowWidth = (0, _size.getWidth)(win);
                        var windowHeight = (0, _size.getHeight)(win);
                        var left = win.scrollLeft();
                        var top = win.scrollTop();
                        var documentElement = _dom_adapter.default.getDocumentElement();
                        var hZoomLevel = _support.touch ? documentElement.clientWidth / windowWidth : 1;
                        var vZoomLevel = _support.touch ? documentElement.clientHeight / windowHeight : 1;
                        if (void 0 === scrollbarWidth) {
                            calculateScrollbarWidth()
                        }
                        var boundaryWidth = windowWidth;
                        var boundaryHeight = windowHeight;
                        if (boundary && !(0, _type.isWindow)(boundary)) {
                            var $boundary = (0, _renderer.default)(boundary);
                            var boundaryPosition = $boundary.offset();
                            left = boundaryPosition.left;
                            top = boundaryPosition.top;
                            boundaryWidth = (0, _size.getWidth)($boundary);
                            boundaryHeight = (0, _size.getHeight)($boundary)
                        }
                        return {
                            h: {
                                min: left + h.boundaryOffset,
                                max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                            },
                            v: {
                                min: top + v.boundaryOffset,
                                max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                            }
                        }
                    }();
                    h.oversize = calculateOversize(h, bounds.h);
                    v.oversize = calculateOversize(v, bounds.v);
                    h.collisionSide = collisionSide("h", h, bounds.h);
                    v.collisionSide = collisionSide("v", v, bounds.v);
                    if (collisionResolvers[h.collision]) {
                        collisionResolvers[h.collision](h, bounds.h)
                    }
                    if (collisionResolvers[v.collision]) {
                        collisionResolvers[v.collision](v, bounds.v)
                    }
                    var preciser = function(number) {
                        return options.precise ? number : Math.round(number)
                    };
                    (0, _extend.extend)(true, result, {
                        h: {
                            location: preciser(h.myLocation),
                            oversize: preciser(h.oversize),
                            fit: h.fit,
                            flip: h.flip,
                            collisionSide: h.collisionSide
                        },
                        v: {
                            location: preciser(v.myLocation),
                            oversize: preciser(v.oversize),
                            fit: v.fit,
                            flip: v.flip,
                            collisionSide: v.collisionSide
                        },
                        precise: options.precise
                    });
                    return result
                };
                var setScaleProperty = function(element, scale, styleAttr, isEmpty) {
                    var stylePropIsValid = (0, _type.isDefined)(element.style) && !_dom_adapter.default.isNode(element.style);
                    var newStyleValue = isEmpty ? styleAttr.replace(scale, "") : styleAttr;
                    if (stylePropIsValid) {
                        (0, _style.setStyle)(element, newStyleValue, false)
                    } else {
                        var styleAttributeNode = _dom_adapter.default.createAttribute("style");
                        styleAttributeNode.value = newStyleValue;
                        element.setAttributeNode(styleAttributeNode)
                    }
                };
                var getOffsetWithoutScale = function getOffsetWithoutScale($startElement) {
                    var _currentElement$getAt, _style$match;
                    var $currentElement = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : $startElement;
                    var currentElement = $currentElement.get(0);
                    if (!currentElement) {
                        return $startElement.offset()
                    }
                    var style = (null === (_currentElement$getAt = currentElement.getAttribute) || void 0 === _currentElement$getAt ? void 0 : _currentElement$getAt.call(currentElement, "style")) || "";
                    var scale = null === (_style$match = style.match(scaleRe)) || void 0 === _style$match ? void 0 : _style$match[0];
                    var offset;
                    if (scale) {
                        setScaleProperty(currentElement, scale, style, true);
                        offset = getOffsetWithoutScale($startElement, $currentElement.parent());
                        setScaleProperty(currentElement, scale, style, false)
                    } else {
                        offset = getOffsetWithoutScale($startElement, $currentElement.parent())
                    }
                    return offset
                };
                var position = function(what, options) {
                    var $what = (0, _renderer.default)(what);
                    if (!options) {
                        return $what.offset()
                    }(0, _translator.resetPosition)($what, true);
                    var offset = getOffsetWithoutScale($what);
                    var targetPosition = options.h && options.v ? options : calculatePosition($what, options);
                    var preciser = function(number) {
                        return options.precise ? number : Math.round(number)
                    };
                    (0, _translator.move)($what, {
                        left: targetPosition.h.location - preciser(offset.left),
                        top: targetPosition.v.location - preciser(offset.top)
                    });
                    return targetPosition
                };
                if (!position.inverseAlign) {
                    position.inverseAlign = inverseAlign
                }
                if (!position.normalizeAlign) {
                    position.normalizeAlign = normalizeAlign
                }
                var _default = {
                    calculateScrollbarWidth: calculateScrollbarWidth,
                    calculate: calculatePosition,
                    setup: position,
                    offset: function(element) {
                        element = (0, _renderer.default)(element).get(0);
                        if ((0, _type.isWindow)(element)) {
                            return null
                        } else if (element && "pageY" in element && "pageX" in element) {
                            return {
                                top: element.pageY,
                                left: element.pageX
                            }
                        }
                        return (0, _renderer.default)(element).offset()
                    }
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        42814:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/presets/presets.js ***!
              \**************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.presets = exports.PresetCollection = void 0;
                var _size = __webpack_require__( /*! ../../core/utils/size */ 58664);
                var _component = __webpack_require__( /*! ../../core/component */ 44297);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 20530));
                var _fx = _interopRequireDefault(__webpack_require__( /*! ../fx */ 87209));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var directionPostfixes = {
                    forward: " dx-forward",
                    backward: " dx-backward",
                    none: " dx-no-direction",
                    undefined: " dx-no-direction"
                };
                var AnimationPresetCollection = _component.Component.inherit({
                    ctor: function() {
                        this.callBase.apply(this, arguments);
                        this._registeredPresets = [];
                        this.resetToDefaults()
                    },
                    _getDefaultOptions: function() {
                        return (0, _extend.extend)(this.callBase(), {
                            defaultAnimationDuration: 400,
                            defaultAnimationDelay: 0,
                            defaultStaggerAnimationDuration: 300,
                            defaultStaggerAnimationDelay: 40,
                            defaultStaggerAnimationStartDelay: 500
                        })
                    },
                    _defaultOptionsRules: function() {
                        return this.callBase().concat([{
                            device: function(_device) {
                                return _device.phone
                            },
                            options: {
                                defaultStaggerAnimationDuration: 350,
                                defaultStaggerAnimationDelay: 50,
                                defaultStaggerAnimationStartDelay: 0
                            }
                        }, {
                            device: function() {
                                return _devices.default.current().android || _devices.default.real.android
                            },
                            options: {
                                defaultAnimationDelay: 100
                            }
                        }])
                    },
                    _getPresetOptionName: function(animationName) {
                        return "preset_" + animationName
                    },
                    _createAndroidSlideAnimationConfig: function(throughOpacity, widthMultiplier) {
                        var that = this;
                        var createBaseConfig = function(configModifier) {
                            return {
                                type: "slide",
                                delay: void 0 === configModifier.delay ? that.option("defaultAnimationDelay") : configModifier.delay,
                                duration: void 0 === configModifier.duration ? that.option("defaultAnimationDuration") : configModifier.duration
                            }
                        };
                        return {
                            enter: function($element, configModifier) {
                                var width = (0, _size.getWidth)($element.parent()) * widthMultiplier;
                                var direction = configModifier.direction;
                                var config = createBaseConfig(configModifier);
                                config.to = {
                                    left: 0,
                                    opacity: 1
                                };
                                if ("forward" === direction) {
                                    config.from = {
                                        left: width,
                                        opacity: throughOpacity
                                    }
                                } else if ("backward" === direction) {
                                    config.from = {
                                        left: -width,
                                        opacity: throughOpacity
                                    }
                                } else {
                                    config.from = {
                                        left: 0,
                                        opacity: 0
                                    }
                                }
                                return _fx.default.createAnimation($element, config)
                            },
                            leave: function($element, configModifier) {
                                var width = (0, _size.getWidth)($element.parent()) * widthMultiplier;
                                var direction = configModifier.direction;
                                var config = createBaseConfig(configModifier);
                                config.from = {
                                    left: 0,
                                    opacity: 1
                                };
                                if ("forward" === direction) {
                                    config.to = {
                                        left: -width,
                                        opacity: throughOpacity
                                    }
                                } else if ("backward" === direction) {
                                    config.to = {
                                        left: width,
                                        opacity: throughOpacity
                                    }
                                } else {
                                    config.to = {
                                        left: 0,
                                        opacity: 0
                                    }
                                }
                                return _fx.default.createAnimation($element, config)
                            }
                        }
                    },
                    _createOpenDoorConfig: function() {
                        var that = this;
                        var createBaseConfig = function(configModifier) {
                            return {
                                type: "css",
                                extraCssClasses: "dx-opendoor-animation",
                                delay: void 0 === configModifier.delay ? that.option("defaultAnimationDelay") : configModifier.delay,
                                duration: void 0 === configModifier.duration ? that.option("defaultAnimationDuration") : configModifier.duration
                            }
                        };
                        return {
                            enter: function($element, configModifier) {
                                var direction = configModifier.direction;
                                var config = createBaseConfig(configModifier);
                                config.delay = "none" === direction ? config.delay : config.duration;
                                config.from = "dx-enter dx-opendoor-animation" + directionPostfixes[direction];
                                config.to = "dx-enter-active";
                                return _fx.default.createAnimation($element, config)
                            },
                            leave: function($element, configModifier) {
                                var direction = configModifier.direction;
                                var config = createBaseConfig(configModifier);
                                config.from = "dx-leave dx-opendoor-animation" + directionPostfixes[direction];
                                config.to = "dx-leave-active";
                                return _fx.default.createAnimation($element, config)
                            }
                        }
                    },
                    _createWinPopConfig: function() {
                        var that = this;
                        var baseConfig = {
                            type: "css",
                            extraCssClasses: "dx-win-pop-animation",
                            duration: that.option("defaultAnimationDuration")
                        };
                        return {
                            enter: function($element, configModifier) {
                                var config = baseConfig;
                                var direction = configModifier.direction;
                                config.delay = "none" === direction ? that.option("defaultAnimationDelay") : that.option("defaultAnimationDuration") / 2;
                                config.from = "dx-enter dx-win-pop-animation" + directionPostfixes[direction];
                                config.to = "dx-enter-active";
                                return _fx.default.createAnimation($element, config)
                            },
                            leave: function($element, configModifier) {
                                var config = baseConfig;
                                var direction = configModifier.direction;
                                config.delay = that.option("defaultAnimationDelay");
                                config.from = "dx-leave dx-win-pop-animation" + directionPostfixes[direction];
                                config.to = "dx-leave-active";
                                return _fx.default.createAnimation($element, config)
                            }
                        }
                    },
                    resetToDefaults: function() {
                        this.clear();
                        this.registerDefaultPresets();
                        this.applyChanges()
                    },
                    clear: function(name) {
                        var that = this;
                        var newRegisteredPresets = [];
                        (0, _iterator.each)(this._registeredPresets, (function(index, preset) {
                            if (!name || name === preset.name) {
                                that.option(that._getPresetOptionName(preset.name), void 0)
                            } else {
                                newRegisteredPresets.push(preset)
                            }
                        }));
                        this._registeredPresets = newRegisteredPresets;
                        this.applyChanges()
                    },
                    registerPreset: function(name, config) {
                        this._registeredPresets.push({
                            name: name,
                            config: config
                        })
                    },
                    applyChanges: function() {
                        var that = this;
                        var customRules = [];
                        (0, _iterator.each)(this._registeredPresets, (function(index, preset) {
                            var rule = {
                                device: preset.config.device,
                                options: {}
                            };
                            rule.options[that._getPresetOptionName(preset.name)] = preset.config.animation;
                            customRules.push(rule)
                        }));
                        this._setOptionsByDevice(customRules)
                    },
                    getPreset: function(name) {
                        var result = name;
                        while ("string" === typeof result) {
                            result = this.option(this._getPresetOptionName(result))
                        }
                        return result
                    },
                    registerDefaultPresets: function() {
                        this.registerPreset("pop", {
                            animation: {
                                extraCssClasses: "dx-android-pop-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("openDoor", {
                            animation: this._createOpenDoorConfig()
                        });
                        this.registerPreset("win-pop", {
                            animation: this._createWinPopConfig()
                        });
                        this.registerPreset("fade", {
                            animation: {
                                extraCssClasses: "dx-fade-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("slide", {
                            device: function() {
                                return _devices.default.current().android || _devices.default.real.android
                            },
                            animation: this._createAndroidSlideAnimationConfig(1, 1)
                        });
                        this.registerPreset("slide", {
                            device: function() {
                                return !_devices.default.current().android && !_devices.default.real.android
                            },
                            animation: {
                                extraCssClasses: "dx-slide-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("ios7-slide", {
                            animation: {
                                extraCssClasses: "dx-ios7-slide-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("overflow", {
                            animation: {
                                extraCssClasses: "dx-overflow-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("ios7-toolbar", {
                            device: function() {
                                return !_devices.default.current().android && !_devices.default.real.android
                            },
                            animation: {
                                extraCssClasses: "dx-ios7-toolbar-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("ios7-toolbar", {
                            device: function() {
                                return _devices.default.current().android || _devices.default.real.android
                            },
                            animation: this._createAndroidSlideAnimationConfig(0, .4)
                        });
                        this.registerPreset("stagger-fade", {
                            animation: {
                                extraCssClasses: "dx-fade-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-slide", {
                            animation: {
                                extraCssClasses: "dx-slide-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-fade-slide", {
                            animation: {
                                extraCssClasses: "dx-fade-slide-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-drop", {
                            animation: {
                                extraCssClasses: "dx-drop-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-fade-drop", {
                            animation: {
                                extraCssClasses: "dx-fade-drop-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-fade-rise", {
                            animation: {
                                extraCssClasses: "dx-fade-rise-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-3d-drop", {
                            animation: {
                                extraCssClasses: "dx-3d-drop-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-fade-zoom", {
                            animation: {
                                extraCssClasses: "dx-fade-zoom-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        })
                    }
                });
                exports.PresetCollection = AnimationPresetCollection;
                var animationPresets = new AnimationPresetCollection;
                exports.presets = animationPresets
            },
        52431:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/transition_executor/transition_executor.js ***!
              \**************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.TransitionExecutor = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _fx = _interopRequireDefault(__webpack_require__( /*! ../fx */ 87209));
                var _presets = __webpack_require__( /*! ../presets/presets */ 42814);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var directionPostfixes = {
                    forward: " dx-forward",
                    backward: " dx-backward",
                    none: " dx-no-direction",
                    undefined: " dx-no-direction"
                };
                var TransitionExecutor = _class.default.inherit({
                    ctor: function() {
                        this._accumulatedDelays = {
                            enter: 0,
                            leave: 0
                        };
                        this._animations = [];
                        this.reset()
                    },
                    _createAnimations: function($elements, initialConfig, configModifier, type) {
                        $elements = (0, _renderer.default)($elements);
                        var that = this;
                        var result = [];
                        configModifier = configModifier || {};
                        var animationConfig = this._prepareElementAnimationConfig(initialConfig, configModifier, type);
                        if (animationConfig) {
                            $elements.each((function() {
                                var animation = that._createAnimation((0, _renderer.default)(this), animationConfig, configModifier);
                                if (animation) {
                                    animation.element.addClass("dx-animating");
                                    animation.setup();
                                    result.push(animation)
                                }
                            }))
                        }
                        return result
                    },
                    _prepareElementAnimationConfig: function(config, configModifier, type) {
                        var result;
                        if ("string" === typeof config) {
                            var presetName = config;
                            config = _presets.presets.getPreset(presetName)
                        }
                        if (!config) {
                            result = void 0
                        } else if ((0, _type.isFunction)(config[type])) {
                            result = config[type]
                        } else {
                            result = (0, _extend.extend)({
                                skipElementInitialStyles: true,
                                cleanupWhen: this._completePromise
                            }, config, configModifier);
                            if (!result.type || "css" === result.type) {
                                var cssClass = "dx-" + type;
                                var extraCssClasses = (result.extraCssClasses ? " " + result.extraCssClasses : "") + directionPostfixes[result.direction];
                                result.type = "css";
                                result.from = (result.from || cssClass) + extraCssClasses;
                                result.to = result.to || cssClass + "-active"
                            }
                            result.staggerDelay = result.staggerDelay || 0;
                            result.delay = result.delay || 0;
                            if (result.staggerDelay) {
                                result.delay += this._accumulatedDelays[type];
                                this._accumulatedDelays[type] += result.staggerDelay
                            }
                        }
                        return result
                    },
                    _createAnimation: function($element, animationConfig, configModifier) {
                        var result;
                        if ((0, _type.isPlainObject)(animationConfig)) {
                            result = _fx.default.createAnimation($element, animationConfig)
                        } else if ((0, _type.isFunction)(animationConfig)) {
                            result = animationConfig($element, configModifier)
                        }
                        return result
                    },
                    _startAnimations: function() {
                        var animations = this._animations;
                        for (var i = 0; i < animations.length; i++) {
                            animations[i].start()
                        }
                    },
                    _stopAnimations: function(jumpToEnd) {
                        var animations = this._animations;
                        for (var i = 0; i < animations.length; i++) {
                            animations[i].stop(jumpToEnd)
                        }
                    },
                    _clearAnimations: function() {
                        var animations = this._animations;
                        for (var i = 0; i < animations.length; i++) {
                            animations[i].element.removeClass("dx-animating")
                        }
                        this._animations.length = 0
                    },
                    reset: function() {
                        this._accumulatedDelays.enter = 0;
                        this._accumulatedDelays.leave = 0;
                        this._clearAnimations();
                        this._completeDeferred = new _deferred.Deferred;
                        this._completePromise = this._completeDeferred.promise()
                    },
                    enter: function($elements, animationConfig, configModifier) {
                        var animations = this._createAnimations($elements, animationConfig, configModifier, "enter");
                        this._animations.push.apply(this._animations, animations)
                    },
                    leave: function($elements, animationConfig, configModifier) {
                        var animations = this._createAnimations($elements, animationConfig, configModifier, "leave");
                        this._animations.push.apply(this._animations, animations)
                    },
                    start: function() {
                        var that = this;
                        var result;
                        if (!this._animations.length) {
                            that.reset();
                            result = (new _deferred.Deferred).resolve().promise()
                        } else {
                            var animationDeferreds = (0, _iterator.map)(this._animations, (function(animation) {
                                var result = new _deferred.Deferred;
                                animation.deferred.always((function() {
                                    result.resolve()
                                }));
                                return result.promise()
                            }));
                            result = _deferred.when.apply(_renderer.default, animationDeferreds).always((function() {
                                that._completeDeferred.resolve();
                                that.reset()
                            }));
                            (0, _common.executeAsync)((function() {
                                that._startAnimations()
                            }))
                        }
                        return result
                    },
                    stop: function(jumpToEnd) {
                        this._stopAnimations(jumpToEnd)
                    }
                });
                exports.TransitionExecutor = TransitionExecutor
            },
        31648:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/translator.js ***!
              \*********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.resetPosition = exports.parseTranslate = exports.move = exports.locate = exports.getTranslateCss = exports.getTranslate = exports.clearCache = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../core/renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _element_data = __webpack_require__( /*! ../core/element_data */ 97906);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/;
                var TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
                exports.locate = function($element) {
                    $element = (0, _renderer.default)($element);
                    var translate = getTranslate($element);
                    return {
                        left: translate.x,
                        top: translate.y
                    }
                };

                function isPercentValue(value) {
                    return "string" === (0, _type.type)(value) && "%" === value[value.length - 1]
                }

                function cacheTranslate($element, translate) {
                    if ($element.length) {
                        (0, _element_data.data)($element.get(0), "dxTranslator", translate)
                    }
                }
                var clearCache = function($element) {
                    if ($element.length) {
                        (0, _element_data.removeData)($element.get(0), "dxTranslator")
                    }
                };
                exports.clearCache = clearCache;
                var getTranslateCss = function(translate) {
                    translate.x = translate.x || 0;
                    translate.y = translate.y || 0;
                    var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
                    var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
                    return "translate(" + xValueString + ", " + yValueString + ")"
                };
                exports.getTranslateCss = getTranslateCss;
                var getTranslate = function($element) {
                    var result = $element.length ? (0, _element_data.data)($element.get(0), "dxTranslator") : null;
                    if (!result) {
                        var transformValue = $element.css("transform") || getTranslateCss({
                            x: 0,
                            y: 0
                        });
                        var matrix = transformValue.match(TRANSFORM_MATRIX_REGEX);
                        var is3D = matrix && matrix[1];
                        if (matrix) {
                            matrix = matrix[2].split(",");
                            if ("3d" === is3D) {
                                matrix = matrix.slice(12, 15)
                            } else {
                                matrix.push(0);
                                matrix = matrix.slice(4, 7)
                            }
                        } else {
                            matrix = [0, 0, 0]
                        }
                        result = {
                            x: parseFloat(matrix[0]),
                            y: parseFloat(matrix[1]),
                            z: parseFloat(matrix[2])
                        };
                        cacheTranslate($element, result)
                    }
                    return result
                };
                exports.getTranslate = getTranslate;
                exports.move = function($element, position) {
                    $element = (0, _renderer.default)($element);
                    var left = position.left;
                    var top = position.top;
                    var translate;
                    if (void 0 === left) {
                        translate = getTranslate($element);
                        translate.y = top || 0
                    } else if (void 0 === top) {
                        translate = getTranslate($element);
                        translate.x = left || 0
                    } else {
                        translate = {
                            x: left || 0,
                            y: top || 0,
                            z: 0
                        };
                        cacheTranslate($element, translate)
                    }
                    $element.css({
                        transform: getTranslateCss(translate)
                    });
                    if (isPercentValue(left) || isPercentValue(top)) {
                        clearCache($element)
                    }
                };
                exports.resetPosition = function($element, finishTransition) {
                    $element = (0, _renderer.default)($element);
                    var originalTransition;
                    var stylesConfig = {
                        left: 0,
                        top: 0,
                        transform: "none"
                    };
                    if (finishTransition) {
                        originalTransition = $element.css("transition");
                        stylesConfig.transition = "none"
                    }
                    $element.css(stylesConfig);
                    clearCache($element);
                    if (finishTransition) {
                        $element.get(0).offsetHeight;
                        $element.css("transition", originalTransition)
                    }
                };
                exports.parseTranslate = function(translateString) {
                    var result = translateString.match(TRANSLATE_REGEX);
                    if (!result || !result[1]) {
                        return
                    }
                    result = result[1].split(",");
                    result = {
                        x: parseFloat(result[0]),
                        y: parseFloat(result[1]),
                        z: parseFloat(result[2])
                    };
                    return result
                }
            },
        72505:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/common.charts.js ***!
              \******************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ./core */ 36991);
                DevExpress.common = DevExpress.common || {};
                DevExpress.common.charts = __webpack_require__( /*! ../../common/charts */ 29932);
                module.exports = DevExpress.common.charts
            },
        36991:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/core.js ***!
              \*********************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 58201);
                var window = windowUtils.getWindow();
                var DevExpress = window.DevExpress = window.DevExpress || {};
                var errors = DevExpress.errors = __webpack_require__( /*! ../../core/errors */ 17381);
                if (DevExpress._DEVEXTREME_BUNDLE_INITIALIZED) {
                    throw errors.Error("E0024")
                }
                DevExpress._DEVEXTREME_BUNDLE_INITIALIZED = true;
                DevExpress.clientExporter = __webpack_require__( /*! ../../exporter */ 78292);
                DevExpress.excelExporter = __webpack_require__( /*! ../../excel_exporter */ 2994);
                DevExpress.pdfExporter = __webpack_require__( /*! ../../pdf_exporter */ 44194);
                DevExpress.VERSION = __webpack_require__( /*! ../../core/version */ 36739).version;
                DevExpress.Class = __webpack_require__( /*! ../../core/class */ 38377);
                DevExpress.DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 13046);
                DevExpress.Component = __webpack_require__( /*! ../../core/component */ 44297).Component;
                DevExpress.registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 99393);
                DevExpress.devices = __webpack_require__( /*! ../../core/devices */ 20530);
                DevExpress.Color = __webpack_require__( /*! ../../color */ 52752);
                var animationFrame = __webpack_require__( /*! ../../animation/frame */ 90057);
                DevExpress.utils = {};
                DevExpress.utils.requestAnimationFrame = animationFrame.requestAnimationFrame;
                DevExpress.utils.cancelAnimationFrame = animationFrame.cancelAnimationFrame;
                DevExpress.utils.initMobileViewport = __webpack_require__( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 88185).p;
                DevExpress.utils.getTimeZones = __webpack_require__( /*! ../../time_zone_utils */ 88673).Z;
                DevExpress.utils.extendFromObject = __webpack_require__( /*! ../../core/utils/extend */ 13306).extendFromObject;
                DevExpress.utils.triggerShownEvent = __webpack_require__( /*! ../../events/visibility_change */ 80506).triggerShownEvent;
                DevExpress.utils.triggerHidingEvent = __webpack_require__( /*! ../../events/visibility_change */ 80506).triggerHidingEvent;
                DevExpress.utils.resetActiveElement = __webpack_require__( /*! ../../core/utils/dom */ 3532).resetActiveElement;
                DevExpress.utils.findBestMatches = __webpack_require__( /*! ../../core/utils/common */ 20576).findBestMatches;
                DevExpress.createQueue = __webpack_require__( /*! ../../core/utils/queue */ 59504).create;
                DevExpress.utils.dom = __webpack_require__( /*! ../../core/utils/dom */ 3532);
                DevExpress.utils.common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                DevExpress.utils.date = __webpack_require__( /*! ../../core/utils/date */ 91198);
                DevExpress.utils.browser = __webpack_require__( /*! ../../core/utils/browser */ 47810);
                DevExpress.utils.inflector = __webpack_require__( /*! ../../core/utils/inflector */ 78008);
                DevExpress.utils.iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                DevExpress.utils.readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 24311);
                DevExpress.utils.resizeCallbacks = __webpack_require__( /*! ../../core/utils/resize_callbacks */ 55814);
                DevExpress.utils.console = __webpack_require__( /*! ../../core/utils/console */ 30869);
                DevExpress.utils.string = __webpack_require__( /*! ../../core/utils/string */ 68752);
                DevExpress.utils.support = __webpack_require__( /*! ../../core/utils/support */ 60137);
                DevExpress.utils.ajax = __webpack_require__( /*! ../../core/utils/ajax */ 37208);
                DevExpress.viewPort = __webpack_require__( /*! ../../core/utils/view_port */ 77695).value;
                DevExpress.hideTopOverlay = __webpack_require__( /*! ../../mobile/hide_top_overlay */ 60628);
                DevExpress.formatHelper = __webpack_require__( /*! ../../format_helper */ 30343);
                DevExpress.config = __webpack_require__( /*! ../../core/config */ 80209);
                DevExpress.animationPresets = __webpack_require__( /*! ../../animation/presets/presets */ 42814).presets;
                DevExpress.fx = __webpack_require__( /*! ../../animation/fx */ 87209);
                DevExpress.TransitionExecutor = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 52431).TransitionExecutor;
                DevExpress.AnimationPresetCollection = __webpack_require__( /*! ../../animation/presets/presets */ 42814).PresetCollection;
                DevExpress.events = __webpack_require__( /*! ../../events */ 66365);
                DevExpress.events.click = __webpack_require__( /*! ../../events/click */ 95429);
                DevExpress.events.utils = __webpack_require__( /*! ../../events/utils */ 39611);
                DevExpress.events.GestureEmitter = __webpack_require__( /*! ../../events/gesture/emitter.gesture */ 98621);
                DevExpress.localization = __webpack_require__( /*! ../../localization */ 94484);
                DevExpress.templateRendered = __webpack_require__( /*! ../../core/templates/template_base */ 81033).renderedCallbacks;
                DevExpress.setTemplateEngine = __webpack_require__( /*! ../../core/templates/template_engine_registry */ 72987).setTemplateEngine;
                module.exports = DevExpress
            },
        86635:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/data.js ***!
              \*********************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ./core */ 36991);
                var errors = __webpack_require__( /*! ../../core/errors */ 17381);
                module.exports = DevExpress.data = DevExpress.data || {};
                Object.defineProperty(DevExpress.data, "errorHandler", {
                    get: function() {
                        return __webpack_require__( /*! ../../data/errors */ 18438).errorHandler
                    },
                    set: function(value) {
                        errors.log("W0003", "DevExpress.data", "errorHandler", "21.1", "Use the 'setErrorHandler' method instead");
                        __webpack_require__( /*! ../../data/errors */ 18438).setErrorHandler(value)
                    }
                });
                Object.defineProperty(DevExpress.data, "_errorHandler", {
                    get: function() {
                        return __webpack_require__( /*! ../../data/errors */ 18438).handleError
                    },
                    set: function(value) {
                        errors.log("W0003", "DevExpress.data", "_errorHandler", "21.1", "Use the 'setErrorHandler' method instead");
                        __webpack_require__( /*! ../../data/errors */ 18438).setErrorHandler(value)
                    }
                });
                DevExpress.data.setErrorHandler = __webpack_require__( /*! ../../data/errors */ 18438).setErrorHandler;
                DevExpress.data.DataSource = __webpack_require__( /*! ../../data/data_source */ 33546);
                DevExpress.data.query = __webpack_require__( /*! ../../data/query */ 96687);
                DevExpress.data.Store = __webpack_require__( /*! ../../data/abstract_store */ 67403);
                DevExpress.data.ArrayStore = __webpack_require__( /*! ../../data/array_store */ 26562);
                DevExpress.data.CustomStore = __webpack_require__( /*! ../../data/custom_store */ 88036);
                DevExpress.data.LocalStore = __webpack_require__( /*! ../../data/local_store */ 82837);
                DevExpress.data.base64_encode = __webpack_require__( /*! ../../data/utils */ 16454).base64_encode;
                DevExpress.data.applyChanges = __webpack_require__( /*! ../../data/apply_changes */ 36893);
                DevExpress.data.Guid = __webpack_require__( /*! ../../core/guid */ 73176);
                DevExpress.data.utils = {};
                DevExpress.data.utils.compileGetter = __webpack_require__( /*! ../../core/utils/data */ 47617).compileGetter;
                DevExpress.data.utils.compileSetter = __webpack_require__( /*! ../../core/utils/data */ 47617).compileSetter;
                DevExpress.EndpointSelector = __webpack_require__( /*! ../../data/endpoint_selector */ 8162);
                DevExpress.data.queryImpl = __webpack_require__( /*! ../../data/query_implementation */ 77549).queryImpl;
                DevExpress.data.queryAdapters = __webpack_require__( /*! ../../data/query_adapters */ 16135);
                var dataUtils = __webpack_require__( /*! ../../data/utils */ 16454);
                DevExpress.data.utils.normalizeBinaryCriterion = dataUtils.normalizeBinaryCriterion;
                DevExpress.data.utils.normalizeSortingInfo = dataUtils.normalizeSortingInfo;
                DevExpress.data.utils.errorMessageFromXhr = dataUtils.errorMessageFromXhr;
                DevExpress.data.utils.aggregators = dataUtils.aggregators;
                DevExpress.data.utils.keysEqual = dataUtils.keysEqual;
                DevExpress.data.utils.isDisjunctiveOperator = dataUtils.isDisjunctiveOperator;
                DevExpress.data.utils.isConjunctiveOperator = dataUtils.isConjunctiveOperator;
                DevExpress.data.utils.processRequestResultLock = dataUtils.processRequestResultLock;
                DevExpress.data.utils.toComparable = __webpack_require__( /*! ../../core/utils/data */ 47617).toComparable;
                DevExpress.data.utils.multiLevelGroup = __webpack_require__( /*! ../../data/store_helper */ 99236).multiLevelGroup;
                DevExpress.data.utils.arrangeSortingInfo = __webpack_require__( /*! ../../data/store_helper */ 99236).arrangeSortingInfo;
                DevExpress.data.utils.normalizeDataSourceOptions = __webpack_require__( /*! ../../data/data_source/utils */ 9234).normalizeDataSourceOptions
            },
        72343:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/data.odata.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                __webpack_require__( /*! ./data */ 86635);
                DevExpress.data.ODataStore = __webpack_require__( /*! ../../data/odata/store */ 341);
                DevExpress.data.ODataContext = __webpack_require__( /*! ../../data/odata/context */ 47256);
                DevExpress.data.utils = DevExpress.data.utils || {};
                DevExpress.data.utils.odata = {};
                DevExpress.data.utils.odata.keyConverters = __webpack_require__( /*! ../../data/odata/utils */ 77869).keyConverters;
                DevExpress.data.EdmLiteral = __webpack_require__( /*! ../../data/odata/utils */ 77869).EdmLiteral;
                var ODataUtilsModule = __webpack_require__( /*! ../../data/odata/utils */ 77869);
                DevExpress.data.utils.odata.serializePropName = ODataUtilsModule.serializePropName;
                DevExpress.data.utils.odata.serializeValue = ODataUtilsModule.serializeValue;
                DevExpress.data.utils.odata.serializeKey = ODataUtilsModule.serializeKey;
                DevExpress.data.utils.odata.sendRequest = ODataUtilsModule.sendRequest;
                DevExpress.data.queryAdapters = DevExpress.data.queryAdapters || {};
                DevExpress.data.queryAdapters.odata = __webpack_require__( /*! ../../data/odata/query_adapter */ 54263).odata
            },
        85357:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/core.js ***!
              \***************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ../../../bundles/modules/core */ 36991);
                __webpack_require__( /*! ../../../integration/jquery */ 78475);
                __webpack_require__( /*! ../../../integration/angular */ 71582);
                __webpack_require__( /*! ../../../integration/knockout */ 49281);
                __webpack_require__( /*! ../../../localization/globalize/core */ 74872);
                __webpack_require__( /*! ../../../localization/globalize/message */ 46949);
                __webpack_require__( /*! ../../../localization/globalize/number */ 908);
                __webpack_require__( /*! ../../../localization/globalize/date */ 60316);
                __webpack_require__( /*! ../../../localization/globalize/currency */ 7239);
                __webpack_require__( /*! ../../../events/click */ 95429);
                __webpack_require__( /*! ../../../events/contextmenu */ 49166);
                __webpack_require__( /*! ../../../events/double_click */ 85272);
                __webpack_require__( /*! ../../../events/drag */ 23174);
                __webpack_require__( /*! ../../../events/hold */ 11699);
                __webpack_require__( /*! ../../../events/hover */ 24028);
                __webpack_require__( /*! ../../../events/pointer */ 93786);
                __webpack_require__( /*! ../../../events/swipe */ 34309);
                __webpack_require__( /*! ../../../events/transform */ 91093);
                module.exports = DevExpress
            },
        94620:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/data.js ***!
              \***************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ./core */ 85357);
                var data = DevExpress.data = __webpack_require__( /*! ../../../bundles/modules/data */ 86635);
                data.odata = __webpack_require__( /*! ../../../bundles/modules/data.odata */ 72343);
                module.exports = data
            },
        66312:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/viz.js ***!
              \**************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ./core */ 85357);
                __webpack_require__( /*! ./data */ 94620);
                __webpack_require__( /*! ../common.charts */ 72505);
                var viz = DevExpress.viz = __webpack_require__( /*! ../../../bundles/modules/viz */ 20802);
                viz.currentTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).currentTheme;
                viz.registerTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).registerTheme;
                viz.exportFromMarkup = __webpack_require__( /*! ../../../viz/export */ 5259).exportFromMarkup;
                viz.getMarkup = __webpack_require__( /*! ../../../viz/export */ 5259).getMarkup;
                viz.exportWidgets = __webpack_require__( /*! ../../../viz/export */ 5259).exportWidgets;
                viz.currentPalette = __webpack_require__( /*! ../../../viz/palette */ 23696).currentPalette;
                viz.getPalette = __webpack_require__( /*! ../../../viz/palette */ 23696).getPalette;
                viz.generateColors = __webpack_require__( /*! ../../../viz/palette */ 23696).generateColors;
                viz.registerPalette = __webpack_require__( /*! ../../../viz/palette */ 23696).registerPalette;
                viz.refreshTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).refreshTheme;
                viz.dxChart = __webpack_require__( /*! ../../../viz/chart */ 99511);
                viz.dxPieChart = __webpack_require__( /*! ../../../viz/pie_chart */ 72111);
                viz.dxPolarChart = __webpack_require__( /*! ../../../viz/polar_chart */ 80919);
                viz.dxLinearGauge = __webpack_require__( /*! ../../../viz/linear_gauge */ 99630);
                viz.dxCircularGauge = __webpack_require__( /*! ../../../viz/circular_gauge */ 39847);
                viz.dxBarGauge = __webpack_require__( /*! ../../../viz/bar_gauge */ 45888);
                viz.dxRangeSelector = __webpack_require__( /*! ../../../viz/range_selector */ 82879);
                viz.dxVectorMap = __webpack_require__( /*! ../../../viz/vector_map */ 81849);
                viz.map = {};
                viz.map.sources = {};
                viz.map.projection = __webpack_require__( /*! ../../../viz/vector_map/projection */ 102).projection;
                viz.dxSparkline = __webpack_require__( /*! ../../../viz/sparkline */ 43759);
                viz.dxBullet = __webpack_require__( /*! ../../../viz/bullet */ 88950);
                viz.dxTreeMap = __webpack_require__( /*! ../../../viz/tree_map */ 15584);
                viz.dxFunnel = __webpack_require__( /*! ../../../viz/funnel */ 30187);
                viz.dxSankey = __webpack_require__( /*! ../../../viz/sankey */ 34377);
                viz.getTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).getTheme;
                viz.findTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).getTheme;
                viz.refreshAll = __webpack_require__( /*! ../../../viz/themes */ 86231).refreshTheme;
                viz.refreshPaths = __webpack_require__( /*! ../../../viz/utils */ 34434).refreshPaths;
                viz.gauges = {
                    __internals: {}
                };
                viz._dashboard = {};
                viz._dashboard.Renderer = __webpack_require__( /*! ../../../viz/core/renderers/renderer */ 56453).Renderer;
                viz._dashboard.SvgElement = __webpack_require__( /*! ../../../viz/core/renderers/renderer */ 56453).SvgElement;
                viz._dashboard.patchFontOptions = __webpack_require__( /*! ../../../viz/core/utils */ 19157).patchFontOptions;
                module.exports = viz
            },
        20802:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/viz.js ***!
              \********************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                __webpack_require__( /*! ./core */ 36991);
                module.exports = DevExpress.viz = DevExpress.viz || {}
            },
        52752:
            /*!******************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/color.js ***!
              \******************************************************/
            function(module, exports) {
                exports.default = void 0;
                var standardColorNames = {
                    aliceblue: "f0f8ff",
                    antiquewhite: "faebd7",
                    aqua: "00ffff",
                    aquamarine: "7fffd4",
                    azure: "f0ffff",
                    beige: "f5f5dc",
                    bisque: "ffe4c4",
                    black: "000000",
                    blanchedalmond: "ffebcd",
                    blue: "0000ff",
                    blueviolet: "8a2be2",
                    brown: "a52a2a",
                    burlywood: "deb887",
                    cadetblue: "5f9ea0",
                    chartreuse: "7fff00",
                    chocolate: "d2691e",
                    coral: "ff7f50",
                    cornflowerblue: "6495ed",
                    cornsilk: "fff8dc",
                    crimson: "dc143c",
                    cyan: "00ffff",
                    darkblue: "00008b",
                    darkcyan: "008b8b",
                    darkgoldenrod: "b8860b",
                    darkgray: "a9a9a9",
                    darkgreen: "006400",
                    darkgrey: "a9a9a9",
                    darkkhaki: "bdb76b",
                    darkmagenta: "8b008b",
                    darkolivegreen: "556b2f",
                    darkorange: "ff8c00",
                    darkorchid: "9932cc",
                    darkred: "8b0000",
                    darksalmon: "e9967a",
                    darkseagreen: "8fbc8f",
                    darkslateblue: "483d8b",
                    darkslategray: "2f4f4f",
                    darkslategrey: "2f4f4f",
                    darkturquoise: "00ced1",
                    darkviolet: "9400d3",
                    deeppink: "ff1493",
                    deepskyblue: "00bfff",
                    dimgray: "696969",
                    dimgrey: "696969",
                    dodgerblue: "1e90ff",
                    feldspar: "d19275",
                    firebrick: "b22222",
                    floralwhite: "fffaf0",
                    forestgreen: "228b22",
                    fuchsia: "ff00ff",
                    gainsboro: "dcdcdc",
                    ghostwhite: "f8f8ff",
                    gold: "ffd700",
                    goldenrod: "daa520",
                    gray: "808080",
                    green: "008000",
                    greenyellow: "adff2f",
                    grey: "808080",
                    honeydew: "f0fff0",
                    hotpink: "ff69b4",
                    indianred: "cd5c5c",
                    indigo: "4b0082",
                    ivory: "fffff0",
                    khaki: "f0e68c",
                    lavender: "e6e6fa",
                    lavenderblush: "fff0f5",
                    lawngreen: "7cfc00",
                    lemonchiffon: "fffacd",
                    lightblue: "add8e6",
                    lightcoral: "f08080",
                    lightcyan: "e0ffff",
                    lightgoldenrodyellow: "fafad2",
                    lightgray: "d3d3d3",
                    lightgreen: "90ee90",
                    lightgrey: "d3d3d3",
                    lightpink: "ffb6c1",
                    lightsalmon: "ffa07a",
                    lightseagreen: "20b2aa",
                    lightskyblue: "87cefa",
                    lightslateblue: "8470ff",
                    lightslategray: "778899",
                    lightslategrey: "778899",
                    lightsteelblue: "b0c4de",
                    lightyellow: "ffffe0",
                    lime: "00ff00",
                    limegreen: "32cd32",
                    linen: "faf0e6",
                    magenta: "ff00ff",
                    maroon: "800000",
                    mediumaquamarine: "66cdaa",
                    mediumblue: "0000cd",
                    mediumorchid: "ba55d3",
                    mediumpurple: "9370d8",
                    mediumseagreen: "3cb371",
                    mediumslateblue: "7b68ee",
                    mediumspringgreen: "00fa9a",
                    mediumturquoise: "48d1cc",
                    mediumvioletred: "c71585",
                    midnightblue: "191970",
                    mintcream: "f5fffa",
                    mistyrose: "ffe4e1",
                    moccasin: "ffe4b5",
                    navajowhite: "ffdead",
                    navy: "000080",
                    oldlace: "fdf5e6",
                    olive: "808000",
                    olivedrab: "6b8e23",
                    orange: "ffa500",
                    orangered: "ff4500",
                    orchid: "da70d6",
                    palegoldenrod: "eee8aa",
                    palegreen: "98fb98",
                    paleturquoise: "afeeee",
                    palevioletred: "d87093",
                    papayawhip: "ffefd5",
                    peachpuff: "ffdab9",
                    peru: "cd853f",
                    pink: "ffc0cb",
                    plum: "dda0dd",
                    powderblue: "b0e0e6",
                    purple: "800080",
                    rebeccapurple: "663399",
                    red: "ff0000",
                    rosybrown: "bc8f8f",
                    royalblue: "4169e1",
                    saddlebrown: "8b4513",
                    salmon: "fa8072",
                    sandybrown: "f4a460",
                    seagreen: "2e8b57",
                    seashell: "fff5ee",
                    sienna: "a0522d",
                    silver: "c0c0c0",
                    skyblue: "87ceeb",
                    slateblue: "6a5acd",
                    slategray: "708090",
                    slategrey: "708090",
                    snow: "fffafa",
                    springgreen: "00ff7f",
                    steelblue: "4682b4",
                    tan: "d2b48c",
                    teal: "008080",
                    thistle: "d8bfd8",
                    tomato: "ff6347",
                    turquoise: "40e0d0",
                    violet: "ee82ee",
                    violetred: "d02090",
                    wheat: "f5deb3",
                    white: "ffffff",
                    whitesmoke: "f5f5f5",
                    yellow: "ffff00",
                    yellowgreen: "9acd32"
                };
                var standardColorTypes = [{
                    re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
                    }
                }, {
                    re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
                    }
                }, {
                    re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
                    }
                }, {
                    re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16), Number((parseInt(colorString[4], 16) / 255).toFixed(2))]
                    }
                }, {
                    re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16), Number((parseInt(colorString[4] + colorString[4], 16) / 255).toFixed(2))]
                    }
                }, {
                    re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
                    }
                }, {
                    re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                    process: function(colorString) {
                        var h = parseInt(colorString[1], 10);
                        var s = parseInt(colorString[2], 10);
                        var v = parseInt(colorString[3], 10);
                        var rgb = hsvToRgb(h, s, v);
                        return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
                    }
                }, {
                    re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                    process: function(colorString) {
                        var h = parseInt(colorString[1], 10);
                        var s = parseInt(colorString[2], 10);
                        var l = parseInt(colorString[3], 10);
                        var rgb = hslToRgb(h, s, l);
                        return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
                    }
                }];
                var _round = Math.round;

                function Color(value) {
                    this.baseColor = value;
                    var color;
                    if (value) {
                        color = String(value).toLowerCase().replace(/ /g, "");
                        color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                        color = function(color) {
                            if ("transparent" === color) {
                                return [0, 0, 0, 0]
                            }
                            var i = 0;
                            var ii = standardColorTypes.length;
                            var str;
                            for (; i < ii; ++i) {
                                str = standardColorTypes[i].re.exec(color);
                                if (str) {
                                    return standardColorTypes[i].process(str)
                                }
                            }
                            return null
                        }(color)
                    }
                    if (!color) {
                        this.colorIsInvalid = true
                    }
                    color = color || {};
                    this.r = normalize(color[0]);
                    this.g = normalize(color[1]);
                    this.b = normalize(color[2]);
                    this.a = normalize(color[3], 1, 1);
                    if (color[4]) {
                        this.hsv = {
                            h: color[4][0],
                            s: color[4][1],
                            v: color[4][2]
                        }
                    } else {
                        this.hsv = function(r, g, b) {
                            var max = Math.max(r, g, b);
                            var min = Math.min(r, g, b);
                            var delta = max - min;
                            var H;
                            var S;
                            var V = max;
                            S = 0 === max ? 0 : 1 - min / max;
                            if (max === min) {
                                H = 0
                            } else {
                                switch (max) {
                                    case r:
                                        H = (g - b) / delta * 60;
                                        if (g < b) {
                                            H += 360
                                        }
                                        break;
                                    case g:
                                        H = (b - r) / delta * 60 + 120;
                                        break;
                                    case b:
                                        H = (r - g) / delta * 60 + 240
                                }
                            }
                            S *= 100;
                            V *= 100 / 255;
                            return {
                                h: Math.round(H),
                                s: Math.round(S),
                                v: Math.round(V)
                            }
                        }(this.r, this.g, this.b)
                    }
                    if (color[5]) {
                        this.hsl = {
                            h: color[5][0],
                            s: color[5][1],
                            l: color[5][2]
                        }
                    } else {
                        this.hsl = function(r, g, b) {
                            r = convertTo01Bounds(r, 255);
                            g = convertTo01Bounds(g, 255);
                            b = convertTo01Bounds(b, 255);
                            var max = Math.max(r, g, b);
                            var min = Math.min(r, g, b);
                            var maxMinSum = max + min;
                            var h;
                            var s;
                            var l = maxMinSum / 2;
                            if (max === min) {
                                h = s = 0
                            } else {
                                var delta = max - min;
                                if (l > .5) {
                                    s = delta / (2 - maxMinSum)
                                } else {
                                    s = delta / maxMinSum
                                }
                                h = function(r, g, b, delta) {
                                    var max = Math.max(r, g, b);
                                    switch (max) {
                                        case r:
                                            return (g - b) / delta + (g < b ? 6 : 0);
                                        case g:
                                            return (b - r) / delta + 2;
                                        case b:
                                            return (r - g) / delta + 4
                                    }
                                }(r, g, b, delta);
                                h /= 6
                            }
                            return {
                                h: _round(360 * h),
                                s: _round(100 * s),
                                l: _round(100 * l)
                            }
                        }(this.r, this.g, this.b)
                    }
                }

                function normalize(colorComponent, def, max) {
                    def = def || 0;
                    max = max || 255;
                    return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
                }

                function hsvToRgb(h, s, v) {
                    var index = Math.floor(h % 360 / 60);
                    var vMin = (100 - s) * v / 100;
                    var a = h % 60 / 60 * (v - vMin);
                    var vInc = vMin + a;
                    var vDec = v - a;
                    var r;
                    var g;
                    var b;
                    switch (index) {
                        case 0:
                            r = v;
                            g = vInc;
                            b = vMin;
                            break;
                        case 1:
                            r = vDec;
                            g = v;
                            b = vMin;
                            break;
                        case 2:
                            r = vMin;
                            g = v;
                            b = vInc;
                            break;
                        case 3:
                            r = vMin;
                            g = vDec;
                            b = v;
                            break;
                        case 4:
                            r = vInc;
                            g = vMin;
                            b = v;
                            break;
                        case 5:
                            r = v;
                            g = vMin;
                            b = vDec
                    }
                    return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
                }

                function makeColorTint(colorPart, h) {
                    var colorTint = h;
                    if ("r" === colorPart) {
                        colorTint = h + 1 / 3
                    }
                    if ("b" === colorPart) {
                        colorTint = h - 1 / 3
                    }
                    return colorTint
                }

                function hueToRgb(p, q, colorTint) {
                    colorTint = function(colorTint) {
                        if (colorTint < 0) {
                            colorTint += 1
                        }
                        if (colorTint > 1) {
                            colorTint -= 1
                        }
                        return colorTint
                    }(colorTint);
                    if (colorTint < 1 / 6) {
                        return p + 6 * (q - p) * colorTint
                    }
                    if (colorTint < .5) {
                        return q
                    }
                    if (colorTint < 2 / 3) {
                        return p + (q - p) * (2 / 3 - colorTint) * 6
                    }
                    return p
                }

                function hslToRgb(h, s, l) {
                    var r;
                    var g;
                    var b;
                    h = convertTo01Bounds(h, 360);
                    s = convertTo01Bounds(s, 100);
                    l = convertTo01Bounds(l, 100);
                    if (0 === s) {
                        r = g = b = l
                    } else {
                        var q = l < .5 ? l * (1 + s) : l + s - l * s;
                        var p = 2 * l - q;
                        r = hueToRgb(p, q, makeColorTint("r", h));
                        g = hueToRgb(p, q, makeColorTint("g", h));
                        b = hueToRgb(p, q, makeColorTint("b", h))
                    }
                    return [_round(255 * r), _round(255 * g), _round(255 * b)]
                }

                function convertTo01Bounds(n, max) {
                    n = Math.min(max, Math.max(0, parseFloat(n)));
                    if (Math.abs(n - max) < 1e-6) {
                        return 1
                    }
                    return n % max / parseFloat(max)
                }

                function isIntegerBetweenMinAndMax(number, min, max) {
                    min = min || 0;
                    max = max || 255;
                    if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                        return false
                    }
                    return true
                }
                Color.prototype = {
                    constructor: Color,
                    highlight: function(step) {
                        step = step || 10;
                        return this.alter(step).toHex()
                    },
                    darken: function(step) {
                        step = step || 10;
                        return this.alter(-step).toHex()
                    },
                    alter: function(step) {
                        var result = new Color;
                        result.r = normalize(this.r + step);
                        result.g = normalize(this.g + step);
                        result.b = normalize(this.b + step);
                        return result
                    },
                    blend: function(blendColor, opacity) {
                        var other = blendColor instanceof Color ? blendColor : new Color(blendColor);
                        var result = new Color;
                        result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                        result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                        result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                        return result
                    },
                    toHex: function() {
                        return r = this.r, g = this.g, b = this.b, "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1);
                        var r, g, b
                    },
                    getPureColor: function() {
                        var rgb = hsvToRgb(this.hsv.h, 100, 100);
                        return new Color("rgb(" + rgb.join(",") + ")")
                    },
                    isValidHex: function(hex) {
                        return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
                    },
                    isValidRGB: function(r, g, b) {
                        if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                            return false
                        }
                        return true
                    },
                    isValidAlpha: function(a) {
                        if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                            return false
                        }
                        return true
                    },
                    colorIsInvalid: false,
                    fromHSL: function(hsl) {
                        var color = new Color;
                        var rgb = hslToRgb(hsl.h, hsl.s, hsl.l);
                        color.r = rgb[0];
                        color.g = rgb[1];
                        color.b = rgb[2];
                        return color
                    }
                };
                var _default = Color;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        29932:
            /*!**************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/charts.js ***!
              \**************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "registerGradient", {
                    enumerable: true,
                    get: function() {
                        return _m_charts.registerGradient
                    }
                });
                Object.defineProperty(exports, "registerPattern", {
                    enumerable: true,
                    get: function() {
                        return _m_charts.registerPattern
                    }
                });
                var _m_charts = __webpack_require__( /*! ../__internal/common/m_charts */ 66798)
            },
        62414:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/action.js ***!
              \************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = (obj = __webpack_require__( /*! ./renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _window = __webpack_require__( /*! ./utils/window */ 58201);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ./utils/iterator */ 95479);
                var Action = function() {
                    function Action(action, config) {
                        config = config || {};
                        this._action = action;
                        this._context = config.context || (0, _window.getWindow)();
                        this._beforeExecute = config.beforeExecute;
                        this._afterExecute = config.afterExecute;
                        this._component = config.component;
                        this._validatingTargetName = config.validatingTargetName;
                        var excludeValidators = this._excludeValidators = {};
                        if (config.excludeValidators) {
                            for (var i = 0; i < config.excludeValidators.length; i++) {
                                excludeValidators[config.excludeValidators[i]] = true
                            }
                        }
                    }
                    var _proto = Action.prototype;
                    _proto.execute = function() {
                        var e = {
                            action: this._action,
                            args: Array.prototype.slice.call(arguments),
                            context: this._context,
                            component: this._component,
                            validatingTargetName: this._validatingTargetName,
                            cancel: false,
                            handled: false
                        };
                        var beforeExecute = this._beforeExecute;
                        var afterExecute = this._afterExecute;
                        var argsBag = e.args[0] || {};
                        if (!this._validateAction(e)) {
                            return
                        }
                        null === beforeExecute || void 0 === beforeExecute ? void 0 : beforeExecute.call(this._context, e);
                        if (e.cancel) {
                            return
                        }
                        var result = this._executeAction(e);
                        if (argsBag.cancel) {
                            return
                        }
                        null === afterExecute || void 0 === afterExecute ? void 0 : afterExecute.call(this._context, e);
                        return result
                    };
                    _proto._validateAction = function(e) {
                        var excludeValidators = this._excludeValidators;
                        var executors = Action.executors;
                        for (var name in executors) {
                            if (!excludeValidators[name]) {
                                var _executor$validate;
                                var executor = executors[name];
                                null === (_executor$validate = executor.validate) || void 0 === _executor$validate ? void 0 : _executor$validate.call(executor, e);
                                if (e.cancel) {
                                    return false
                                }
                            }
                        }
                        return true
                    };
                    _proto._executeAction = function(e) {
                        var result;
                        var executors = Action.executors;
                        for (var name in executors) {
                            var _executor$execute;
                            var executor = executors[name];
                            null === (_executor$execute = executor.execute) || void 0 === _executor$execute ? void 0 : _executor$execute.call(executor, e);
                            if (e.handled) {
                                result = e.result;
                                break
                            }
                        }
                        return result
                    };
                    Action.registerExecutor = function(name, executor) {
                        if ((0, _type.isPlainObject)(name)) {
                            (0, _iterator.each)(name, Action.registerExecutor);
                            return
                        }
                        Action.executors[name] = executor
                    };
                    Action.unregisterExecutor = function() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }(0, _iterator.each)(args, (function() {
                            delete Action.executors[this]
                        }))
                    };
                    return Action
                }();
                exports.default = Action;
                Action.executors = {};
                var createValidatorByTargetElement = function(condition) {
                    return function(e) {
                        if (!e.args.length) {
                            return
                        }
                        var args = e.args[0];
                        var element = args[e.validatingTargetName] || args.element;
                        if (element && condition((0, _renderer.default)(element))) {
                            e.cancel = true
                        }
                    }
                };
                Action.registerExecutor({
                    disabled: {
                        validate: createValidatorByTargetElement((function($target) {
                            return $target.is(".dx-state-disabled, .dx-state-disabled *")
                        }))
                    },
                    readOnly: {
                        validate: createValidatorByTargetElement((function($target) {
                            return $target.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")
                        }))
                    },
                    undefined: {
                        execute: function(e) {
                            if (!e.action) {
                                e.result = void 0;
                                e.handled = true
                            }
                        }
                    },
                    func: {
                        execute: function(e) {
                            if ((0, _type.isFunction)(e.action)) {
                                e.result = e.action.call(e.context, e.args[0]);
                                e.handled = true
                            }
                        }
                    }
                });
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        38377:
            /*!***********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/class.js ***!
              \***********************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _errors = (obj = __webpack_require__( /*! ./errors */ 17381), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var wrapOverridden = function(baseProto, methodName, method) {
                    return function() {
                        var prevCallBase = this.callBase;
                        this.callBase = baseProto[methodName];
                        try {
                            return method.apply(this, arguments)
                        } finally {
                            this.callBase = prevCallBase
                        }
                    }
                };
                var redefine = function(members) {
                    var overridden;
                    var memberName;
                    var member;
                    if (!members) {
                        return this
                    }
                    for (memberName in members) {
                        member = members[memberName];
                        overridden = "function" === typeof this.prototype[memberName] && "function" === typeof member;
                        this.prototype[memberName] = overridden ? wrapOverridden(this.parent.prototype, memberName, member) : member
                    }
                    return this
                };
                var include = function() {
                    var classObj = this;
                    var argument;
                    var name;
                    var i;
                    var hasClassObjOwnProperty = Object.prototype.hasOwnProperty.bind(classObj);
                    var isES6Class = !hasClassObjOwnProperty("_includedCtors") && !hasClassObjOwnProperty("_includedPostCtors");
                    if (isES6Class) {
                        classObj._includedCtors = classObj._includedCtors.slice(0);
                        classObj._includedPostCtors = classObj._includedPostCtors.slice(0)
                    }
                    for (i = 0; i < arguments.length; i++) {
                        argument = arguments[i];
                        if (argument.ctor) {
                            classObj._includedCtors.push(argument.ctor)
                        }
                        if (argument.postCtor) {
                            classObj._includedPostCtors.push(argument.postCtor)
                        }
                        for (name in argument) {
                            if ("ctor" === name || "postCtor" === name || "default" === name) {
                                continue
                            }
                            classObj.prototype[name] = argument[name]
                        }
                    }
                    return classObj
                };
                var subclassOf = function(parentClass) {
                    var hasParentProperty = Object.prototype.hasOwnProperty.bind(this)("parent");
                    var isES6Class = !hasParentProperty && this.parent;
                    if (isES6Class) {
                        var baseClass = Object.getPrototypeOf(this);
                        return baseClass === parentClass || baseClass.subclassOf(parentClass)
                    } else {
                        if (this.parent === parentClass) {
                            return true
                        }
                        if (!this.parent || !this.parent.subclassOf) {
                            return false
                        }
                        return this.parent.subclassOf(parentClass)
                    }
                };
                var abstract = function() {
                    throw _errors.default.Error("E0001")
                };
                var copyStatic = (hasOwn = Object.prototype.hasOwnProperty, function(source, destination) {
                    for (var key in source) {
                        if (!hasOwn.call(source, key)) {
                            return
                        }
                        destination[key] = source[key]
                    }
                });
                var hasOwn;
                var classImpl = function() {};
                classImpl.inherit = function(members) {
                    var inheritor = function() {
                        if (!this || (0, _type.isWindow)(this) || "function" !== typeof this.constructor) {
                            throw _errors.default.Error("E0003")
                        }
                        var instance = this;
                        var ctor = instance.ctor;
                        var includedCtors = instance.constructor._includedCtors;
                        var includedPostCtors = instance.constructor._includedPostCtors;
                        var i;
                        for (i = 0; i < includedCtors.length; i++) {
                            includedCtors[i].call(instance)
                        }
                        if (ctor) {
                            ctor.apply(instance, arguments)
                        }
                        for (i = 0; i < includedPostCtors.length; i++) {
                            includedPostCtors[i].call(instance)
                        }
                    };
                    inheritor.prototype = function(obj) {
                        var func = function() {};
                        func.prototype = obj.prototype;
                        return new func
                    }(this);
                    copyStatic(this, inheritor);
                    inheritor.inherit = this.inherit;
                    inheritor.abstract = abstract;
                    inheritor.redefine = redefine;
                    inheritor.include = include;
                    inheritor.subclassOf = subclassOf;
                    inheritor.parent = this;
                    inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
                    inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
                    inheritor.prototype.constructor = inheritor;
                    inheritor.redefine(members);
                    return inheritor
                };
                classImpl.abstract = abstract;
                var _default = classImpl;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        44297:
            /*!***************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/component.js ***!
              \***************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.Component = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 80209));
                var _extend = __webpack_require__( /*! ./utils/extend */ 13306);
                var _index = __webpack_require__( /*! ./options/index */ 95683);
                var _utils = __webpack_require__( /*! ./options/utils */ 45434);
                var _class = _interopRequireDefault(__webpack_require__( /*! ./class */ 38377));
                var _action = _interopRequireDefault(__webpack_require__( /*! ./action */ 62414));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 17381));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 44504));
                var _events_strategy = __webpack_require__( /*! ./events_strategy */ 80566);
                var _public_component = __webpack_require__( /*! ./utils/public_component */ 9321);
                var _postponed_operations = __webpack_require__( /*! ./postponed_operations */ 90889);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var _common = __webpack_require__( /*! ./utils/common */ 20576);
                var _data = __webpack_require__( /*! ./utils/data */ 47617);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var getEventName = function(actionName) {
                    return actionName.charAt(2).toLowerCase() + actionName.substr(3)
                };
                var Component = _class.default.inherit({
                    _setDeprecatedOptions: function() {
                        this._deprecatedOptions = {}
                    },
                    _getDeprecatedOptions: function() {
                        return this._deprecatedOptions
                    },
                    _getDefaultOptions: function() {
                        return {
                            onInitialized: null,
                            onOptionChanged: null,
                            onDisposing: null,
                            defaultOptionsRules: null
                        }
                    },
                    _defaultOptionsRules: function() {
                        return []
                    },
                    _setOptionsByDevice: function(rules) {
                        this._options.applyRules(rules)
                    },
                    _convertRulesToOptions: function(rules) {
                        return (0, _utils.convertRulesToOptions)(rules)
                    },
                    _isInitialOptionValue: function(name) {
                        return this._options.isInitial(name)
                    },
                    _setOptionsByReference: function() {
                        this._optionsByReference = {}
                    },
                    _getOptionsByReference: function() {
                        return this._optionsByReference
                    },
                    ctor: function() {
                        var options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
                        var _optionChangedCallbacks = options._optionChangedCallbacks,
                            _disposingCallbacks = options._disposingCallbacks;
                        this.NAME = (0, _public_component.name)(this.constructor);
                        this._eventsStrategy = _events_strategy.EventsStrategy.create(this, options.eventsStrategy);
                        this._updateLockCount = 0;
                        this._optionChangedCallbacks = _optionChangedCallbacks || (0, _callbacks.default)();
                        this._disposingCallbacks = _disposingCallbacks || (0, _callbacks.default)();
                        this.postponedOperations = new _postponed_operations.PostponedOperations;
                        this._createOptions(options)
                    },
                    _createOptions: function(options) {
                        var _this = this;
                        this.beginUpdate();
                        try {
                            this._setOptionsByReference();
                            this._setDeprecatedOptions();
                            this._options = new _index.Options(this._getDefaultOptions(), this._getDefaultOptions(), this._getOptionsByReference(), this._getDeprecatedOptions());
                            this._options.onChanging((function(name, previousValue, value) {
                                return _this._initialized && _this._optionChanging(name, previousValue, value)
                            }));
                            this._options.onDeprecated((function(option, info) {
                                return _this._logDeprecatedOptionWarning(option, info)
                            }));
                            this._options.onChanged((function(name, value, previousValue) {
                                return _this._notifyOptionChanged(name, value, previousValue)
                            }));
                            this._options.onStartChange((function() {
                                return _this.beginUpdate()
                            }));
                            this._options.onEndChange((function() {
                                return _this.endUpdate()
                            }));
                            this._options.addRules(this._defaultOptionsRules());
                            if (options && options.onInitializing) {
                                options.onInitializing.apply(this, [options])
                            }
                            this._setOptionsByDevice(options.defaultOptionsRules);
                            this._initOptions(options)
                        } finally {
                            this.endUpdate()
                        }
                    },
                    _initOptions: function(options) {
                        this.option(options)
                    },
                    _init: function() {
                        var _this2 = this;
                        this._createOptionChangedAction();
                        this.on("disposing", (function(args) {
                            _this2._disposingCallbacks.fireWith(_this2, [args])
                        }))
                    },
                    _logDeprecatedOptionWarning: function(option, info) {
                        var message = info.message || "Use the '".concat(info.alias, "' option instead");
                        _errors.default.log("W0001", this.NAME, option, info.since, message)
                    },
                    _logDeprecatedComponentWarning: function(since, alias) {
                        _errors.default.log("W0000", this.NAME, since, "Use the '".concat(alias, "' widget instead"))
                    },
                    _createOptionChangedAction: function() {
                        this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    },
                    _createDisposingAction: function() {
                        this._disposingAction = this._createActionByOption("onDisposing", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    },
                    _optionChanged: function(args) {
                        switch (args.name) {
                            case "onDisposing":
                            case "onInitialized":
                                break;
                            case "onOptionChanged":
                                this._createOptionChangedAction()
                        }
                    },
                    _dispose: function() {
                        this._optionChangedCallbacks.empty();
                        this._createDisposingAction();
                        this._disposingAction();
                        this._eventsStrategy.dispose();
                        this._options.dispose();
                        this._disposed = true
                    },
                    _lockUpdate: function() {
                        this._updateLockCount++
                    },
                    _unlockUpdate: function() {
                        this._updateLockCount = Math.max(this._updateLockCount - 1, 0)
                    },
                    _isUpdateAllowed: function() {
                        return 0 === this._updateLockCount
                    },
                    _isInitializingRequired: function() {
                        return !this._initializing && !this._initialized
                    },
                    isInitialized: function() {
                        return this._initialized
                    },
                    _commitUpdate: function() {
                        this.postponedOperations.callPostponedOperations();
                        this._isInitializingRequired() && this._initializeComponent()
                    },
                    _initializeComponent: function() {
                        this._initializing = true;
                        try {
                            this._init()
                        } finally {
                            this._initializing = false;
                            this._lockUpdate();
                            this._createActionByOption("onInitialized", {
                                excludeValidators: ["disabled", "readOnly"]
                            })();
                            this._unlockUpdate();
                            this._initialized = true
                        }
                    },
                    instance: function() {
                        return this
                    },
                    beginUpdate: function() {
                        this._lockUpdate()
                    },
                    endUpdate: function() {
                        this._unlockUpdate();
                        this._isUpdateAllowed() && this._commitUpdate()
                    },
                    _optionChanging: _common.noop,
                    _notifyOptionChanged: function(option, value, previousValue) {
                        if (this._initialized) {
                            var optionNames = [option].concat(this._options.getAliasesByName(option));
                            for (var i = 0; i < optionNames.length; i++) {
                                var name = optionNames[i];
                                var args = {
                                    name: (0, _data.getPathParts)(name)[0],
                                    fullName: name,
                                    value: value,
                                    previousValue: previousValue
                                };
                                if (!(optionName = name, 0 === optionName.indexOf("_", 0))) {
                                    this._optionChangedCallbacks.fireWith(this, [(0, _extend.extend)(this._defaultActionArgs(), args)]);
                                    this._optionChangedAction((0, _extend.extend)({}, args))
                                }
                                if (!this._disposed && this._cancelOptionChange !== name) {
                                    this._optionChanged(args)
                                }
                            }
                        }
                        var optionName
                    },
                    initialOption: function(name) {
                        return this._options.initial(name)
                    },
                    _defaultActionConfig: function() {
                        return {
                            context: this,
                            component: this
                        }
                    },
                    _defaultActionArgs: function() {
                        return {
                            component: this
                        }
                    },
                    _createAction: function(actionSource, config) {
                        var _this3 = this;
                        var action;
                        return function(e) {
                            if (!(0, _type.isDefined)(e)) {
                                e = {}
                            }
                            if (!(0, _type.isPlainObject)(e)) {
                                e = {
                                    actionValue: e
                                }
                            }
                            action = action || new _action.default(actionSource, (0, _extend.extend)({}, config, _this3._defaultActionConfig()));
                            return action.execute.call(action, (0, _extend.extend)(e, _this3._defaultActionArgs()))
                        }
                    },
                    _createActionByOption: function(optionName, config) {
                        var _this4 = this;
                        var action;
                        var eventName;
                        var actionFunc;
                        config = (0, _extend.extend)({}, config);
                        var result = function() {
                            if (!eventName) {
                                config = config || {};
                                if ("string" !== typeof optionName) {
                                    throw _errors.default.Error("E0008")
                                }
                                if (0 === optionName.indexOf("on")) {
                                    eventName = getEventName(optionName)
                                }
                                actionFunc = _this4.option(optionName)
                            }
                            if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !_this4._eventsStrategy.hasEvent(eventName)) {
                                return
                            }
                            if (!action) {
                                var beforeExecute = config.beforeExecute;
                                config.beforeExecute = function() {
                                    for (var _len2 = arguments.length, props = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                                        props[_key2] = arguments[_key2]
                                    }
                                    beforeExecute && beforeExecute.apply(_this4, props);
                                    _this4._eventsStrategy.fireEvent(eventName, props[0].args)
                                };
                                action = _this4._createAction(actionFunc, config)
                            }
                            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                                args[_key] = arguments[_key]
                            }
                            if ((0, _config.default)().wrapActionsBeforeExecute) {
                                var beforeActionExecute = _this4.option("beforeActionExecute") || _common.noop;
                                var wrappedAction = beforeActionExecute(_this4, action, config) || action;
                                return wrappedAction.apply(_this4, args)
                            }
                            return action.apply(_this4, args)
                        };
                        if ((0, _config.default)().wrapActionsBeforeExecute) {
                            return result
                        }
                        var onActionCreated = this.option("onActionCreated") || _common.noop;
                        return onActionCreated(this, result, config) || result
                    },
                    on: function(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    },
                    off: function(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    },
                    hasActionSubscription: function(actionName) {
                        return !!this._options.silent(actionName) || this._eventsStrategy.hasEvent(getEventName(actionName))
                    },
                    isOptionDeprecated: function(name) {
                        return this._options.isDeprecated(name)
                    },
                    _setOptionWithoutOptionChange: function(name, value) {
                        this._cancelOptionChange = name;
                        this.option(name, value);
                        this._cancelOptionChange = false
                    },
                    _getOptionValue: function(name, context) {
                        var value = this.option(name);
                        if ((0, _type.isFunction)(value)) {
                            return value.bind(context)()
                        }
                        return value
                    },
                    option: function() {
                        var _this$_options;
                        return (_this$_options = this._options).option.apply(_this$_options, arguments)
                    },
                    resetOption: function(name) {
                        this.beginUpdate();
                        this._options.reset(name);
                        this.endUpdate()
                    }
                });
                exports.Component = Component
            },
        99393:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/component_registrator.js ***!
              \***************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ./renderer */ 68374));
                var _component_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./component_registrator_callbacks */ 5554));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 17381));
                var _public_component = __webpack_require__( /*! ./utils/public_component */ 9321);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                _component_registrator_callbacks.default.add((function(name, componentClass) {
                    _renderer.default.fn[name] = function(options) {
                        var isMemberInvoke = "string" === typeof options;
                        var result;
                        if (isMemberInvoke) {
                            var memberName = options;
                            var memberArgs = [].slice.call(arguments).slice(1);
                            this.each((function() {
                                var instance = componentClass.getInstance(this);
                                if (!instance) {
                                    throw _errors.default.Error("E0009", name)
                                }
                                var member = instance[memberName];
                                var memberValue = member.apply(instance, memberArgs);
                                if (void 0 === result) {
                                    result = memberValue
                                }
                            }))
                        } else {
                            this.each((function() {
                                var instance = componentClass.getInstance(this);
                                if (instance) {
                                    instance.option(options)
                                } else {
                                    new componentClass(this, options)
                                }
                            }));
                            result = this
                        }
                        return result
                    }
                }));
                var _default = function(name, namespace, componentClass) {
                    if (!componentClass) {
                        componentClass = namespace
                    } else {
                        namespace[name] = componentClass
                    }(0, _public_component.name)(componentClass, name);
                    _component_registrator_callbacks.default.fire(name, componentClass)
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        5554:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/component_registrator_callbacks.js ***!
              \*************************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _memorized_callbacks = (obj = __webpack_require__( /*! ./memorized_callbacks */ 83358), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _default = new _memorized_callbacks.default;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        80209:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/config.js ***!
              \************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _extend = __webpack_require__( /*! ./utils/extend */ 13306);
                var _errors = (obj = __webpack_require__( /*! ./errors */ 17381), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var config = {
                    rtlEnabled: false,
                    defaultCurrency: "USD",
                    defaultUseCurrencyAccountingStyle: true,
                    oDataFilterToLower: true,
                    serverDecimalSeparator: ".",
                    decimalSeparator: ".",
                    thousandsSeparator: ",",
                    forceIsoDateParsing: true,
                    wrapActionsBeforeExecute: true,
                    useLegacyStoreResult: false,
                    useJQuery: void 0,
                    editorStylingMode: void 0,
                    useLegacyVisibleIndex: false,
                    floatingActionButtonConfig: {
                        icon: "add",
                        closeIcon: "close",
                        label: "",
                        position: {
                            at: "right bottom",
                            my: "right bottom",
                            offset: {
                                x: -16,
                                y: -16
                            }
                        },
                        maxSpeedDialActionCount: 5,
                        shading: false,
                        direction: "auto"
                    },
                    optionsParser: function(optionsString) {
                        if ("{" !== optionsString.trim().charAt(0)) {
                            optionsString = "{" + optionsString + "}"
                        }
                        try {
                            return JSON.parse(optionsString)
                        } catch (ex) {
                            try {
                                return JSON.parse(normalizeToJSONString(optionsString))
                            } catch (exNormalize) {
                                throw _errors.default.Error("E3018", ex, optionsString)
                            }
                        }
                    }
                };
                var normalizeToJSONString = function(optionsString) {
                    return optionsString.replace(/'/g, '"').replace(/,\s*([\]}])/g, "$1").replace(/([{,])\s*([^":\s]+)\s*:/g, '$1"$2":')
                };
                var deprecatedFields = ["decimalSeparator", "thousandsSeparator"];
                var configMethod = function() {
                    if (!arguments.length) {
                        return config
                    }
                    var newConfig = arguments.length <= 0 ? void 0 : arguments[0];
                    deprecatedFields.forEach((function(deprecatedField) {
                        if (newConfig[deprecatedField]) {
                            var message = "Now, the ".concat(deprecatedField, " is selected based on the specified locale.");
                            _errors.default.log("W0003", "config", deprecatedField, "19.2", message)
                        }
                    }));
                    (0, _extend.extend)(config, newConfig)
                };
                if ("undefined" !== typeof DevExpress && DevExpress.config) {
                    configMethod(DevExpress.config)
                }
                var _default = configMethod;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        20530:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/devices.js ***!
              \*************************************************************/
            func