/*!
* DevExtreme (dx.messages.ar.js)
* Version: 23.2.5
* Build date: Mon Mar 11 2024
*
* Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        ar: {
            Yes: "\u0646\u0639\u0645",
            No: "\u0644\u0627",
            Cancel: "\u0627\u0644\u063a\u0627\u0621",
            Close: "\u0625\u063a\u0644\u0627\u0642",
            Clear: "\u062a\u0646\u0636\u064a\u0641",
            Done: "\u062a\u0645",
            Loading: "\u062c\u0627\u0631 \u0627\u0644\u062a\u062d\u0645\u064a\u0644 ...",
            Select: "\u062a\u062d\u062f\u064a\u062f ",
            Search: "\u0628\u062d\u062b",
            Back: "\u0631\u062c\u0648\u0639",
            OK: "\u062d\u0633\u0646\u0627",
            "dxCollectionWidget-noDataText": "\u0644\u0627 \u062a\u0648\u062c\u062f \u0628\u064a\u0627\u0646\u0627\u062a \u0644\u0644\u0639\u0631\u0636",
            "dxDropDownEditor-selectLabel": "\u062a\u062d\u062f\u064a\u062f",
            "validation-required": "\u0645\u0637\u0644\u0648\u0628",
            "validation-required-formatted": "{0} \u0645\u0637\u0644\u0648\u0628",
            "validation-numeric": "\u0627\u0644\u0642\u064a\u0645\u0647 \u064a\u062c\u0628 \u0627\u0646 \u062a\u0643\u0648\u0646 \u0631\u0642\u0645",
            "validation-numeric-formatted": "{0} \u064a\u062c\u0628 \u0627\u0646 \u062a\u0643\u0648\u0646 \u0631\u0642\u0645",
            "validation-range": "\u0627\u0644\u0641\u064a\u0645\u0647 \u062e\u0627\u0631\u062c \u0627\u0644\u0645\u062f\u0649",
            "validation-range-formatted": "{0} \u062e\u0627\u0631\u062c \u0627\u0644\u0645\u062f\u0649",
            "validation-stringLength": "\u0637\u0648\u0644 \u0627\u0644\u0646\u0635 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d",
            "validation-stringLength-formatted": "\u0637\u0648\u0644 {0} \u063a\u064a\u0631 \u0635\u062d\u064a\u062d",
            "validation-custom": "\u0627\u0644\u0642\u064a\u0645\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629",
            "validation-custom-formatted": "{0} \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629",
            "validation-async": "\u0627\u0644\u0642\u064a\u0645\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629",
            "validation-async-formatted": "{0} \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629",
            "validation-compare": "\u0627\u0644\u0642\u064a\u0645 \u0644\u0627 \u062a\u062a\u0637\u0627\u0628\u0642",
            "validation-compare-formatted": "{0}  \u0644\u0627 \u062a\u062a\u0637\u0627\u0628\u0642",
            "validation-pattern": "\u0627\u0644\u0642\u064a\u0645\u0629 \u0644\u0627 \u062a\u062a\u0637\u0627\u0628\u0642 \u0645\u0639 \u0627\u0644\u0646\u0645\u0637",
            "validation-pattern-formatted": "{0} \u0644\u0627 \u062a\u062a\u0637\u0627\u0628\u0642 \u0645\u0639 \u0627\u0644\u0646\u0645\u0637",
            "validation-email": "\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u063a\u064a\u0631 \u0635\u0627\u0644\u062d",
            "validation-email-formatted": "{0}  \u063a\u064a\u0631 \u0635\u0627\u0644\u062d",
            "validation-mask": "\u0627\u0644\u0642\u064a\u0645\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629",
            "dxLookup-searchPlaceholder": "\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u062f\u0646\u0649 \u0644\u0639\u062f\u062f \u0627\u0644\u0623\u062d\u0631\u0641: {0}",
            "dxList-pullingDownText": "\u0644\u0644\u062a\u062d\u062f\u064a\u062b \u0627\u0633\u062d\u0628 \u0644\u0644\u0623\u0633\u0641\u0644...",
            "dxList-pulledDownText": "\u062d\u0631\u0631 \u0644\u0644\u062a\u062d\u062f\u064a\u062b ...",
            "dxList-refreshingText": "\u062c\u0627\u0631 \u0627\u0644\u062a\u062d\u062f\u064a\u062b ...",
            "dxList-pageLoadingText": "\u062c\u0627\u0631 \u0627\u0644\u062a\u062d\u0645\u064a\u0644...",
            "dxList-nextButtonText": "\u0627\u0644\u0645\u0632\u064a\u062f",
            "dxList-selectAll": "\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644",
            "dxListEditDecorator-delete": "\u062d\u0630\u0641",
            "dxListEditDecorator-more": "\u0627\u0644\u0645\u0632\u064a\u062f",
            "dxScrollView-pullingDownText": "\u0644\u0644\u062a\u062d\u062f\u064a\u062b \u0627\u0633\u062d\u0628 \u0644\u0644\u0623\u0633\u0641\u0644...",
            "dxScrollView-pulledDownText": "\u062d\u0631\u0631 \u0644\u0644\u062a\u062d\u062f\u064a\u062b ...",
            "dxScrollView-refreshingText": "\u062c\u0627\u0631 \u0627\u0644\u062a\u062d\u062f\u064a\u062b ...",
            "dxScrollView-reachBottomText": "\u062c\u0627\u0631 \u0627\u0644\u062a\u062d\u0645\u064a\u0644...",
            "dxDateBox-simulatedDataPickerTitleTime": "\u0627\u062e\u062a\u0631 \u0627\u0644\u0648\u0642\u062a",
            "dxDateBox-simulatedDataPickerTitleDate": "\u0627\u062e\u062a\u0631 \u0627\u0644\u062a\u0627\u0631\u064a\u062e",
            "dxDateBox-simulatedDataPickerTitleDateTime": "\u062d\u062f\u062f \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0648\u0627\u0644\u0648\u0642\u062a",
            "dxDateBox-validation-datetime": "\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0642\u064a\u0645\u0629 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0623\u0648 \u0648\u0642\u062a\u064b\u0627",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0628\u062f\u0621",
            "dxDateRangeBox-endDateLabel": "\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621",
            "dxFileUploader-selectFile": "\u062d\u062f\u062f \u0627\u0644\u0645\u0644\u0641",
            "dxFileUploader-dropFile": "\u0623\u0648 \u0625\u0641\u0644\u0627\u062a \u0627\u0644\u0645\u0644\u0641 \u0647\u0646\u0627",
            "dxFileUploader-bytes": "\u0628\u0627\u064a\u062a",
            "dxFileUploader-kb": "\u0643\u064a\u0644\u0648 \u0628\u0627\u064a\u062a",
            "dxFileUploader-Mb": "\u0645\u064a\u063a\u0627 \u0628\u0627\u064a\u062a",
            "dxFileUploader-Gb": "\u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a",
            "dxFileUploader-upload": "\u0631\u0641\u0639",
            "dxFileUploader-uploaded": "\u062a\u0645 \u0627\u0644\u0631\u0641\u0639",
            "dxFileUploader-readyToUpload": "\u062c\u0627\u0647\u0632 \u0644\u0644\u062a\u062d\u0645\u064a\u0644",
            "dxFileUploader-uploadAbortedMessage": "\u062a\u0645 \u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u062a\u062d\u0645\u064a\u0644",
            "dxFileUploader-uploadFailedMessage": "\u0627\u0644\u062a\u062d\u0645\u064a\u0644 \u0641\u0634\u0644",
            "dxFileUploader-invalidFileExtension": "\u0646\u0648\u0639 \u0627\u0644\u0645\u0644\u0641 \u063a\u064a\u0631 \u0645\u0633\u0645\u0648\u062d \u0628\u0647",
            "dxFileUploader-invalidMaxFileSize": "\u0627\u0644\u0645\u0644\u0641 \u0643\u0628\u064a\u0631 \u062c\u062f\u0627",
            "dxFileUploader-invalidMinFileSize": "\u0627\u0644\u0645\u0644\u0641 \u0635\u063a\u064a\u0631 \u062c\u062f\u064b\u0627",
            "dxRangeSlider-ariaFrom": "\u0645\u0646 \u0639\u0646\u062f",
            "dxRangeSlider-ariaTill": "\u062d\u062a\u0649",
            "dxSwitch-switchedOnText": "\u062a\u0634\u063a\u064a\u0644",
            "dxSwitch-switchedOffText": "\u0627\u064a\u0642\u0627\u0641",
            "dxForm-optionalMark": "\u0627\u062e\u062a\u064a\u0627\u0631\u064a",
            "dxForm-requiredMessage": "{0} \u0645\u0637\u0644\u0648\u0628",
            "dxNumberBox-invalidValueMessage": "\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0642\u064a\u0645\u0629 \u0631\u0642\u0645\u064b\u0627",
            "dxNumberBox-noDataText": "\u0644\u0627\u064a\u0648\u062c\u062f \u0628\u064a\u0627\u0646\u0627\u062a",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "\u0645\u0646\u062a\u0642\u064a \u0627\u0644\u0639\u0645\u0648\u062f",
            "dxDataGrid-columnChooserEmptyText": "\u0627\u0633\u062d\u0628 \u0627\u0644\u0639\u0645\u0648\u062f \u0647\u0646\u0627 \u0644\u0625\u062e\u0641\u0627\u0626\u0647",
            "dxDataGrid-groupContinuesMessage": "\u064a\u0633\u062a\u0645\u0631 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u062a\u0627\u0644\u064a\u0629",
            "dxDataGrid-groupContinuedMessage": "\u0627\u0633\u062a\u0645\u0631 \u0645\u0646 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0633\u0627\u0628\u0642\u0629",
            "dxDataGrid-groupHeaderText": "\u062a\u062c\u0645\u064a\u0639 \u062d\u0633\u0628 \u0647\u0630\u0627 \u0627\u0644\u0639\u0645\u0648\u062f",
            "dxDataGrid-ungroupHeaderText": "\u0641\u0643 \u0627\u0644\u062a\u062c\u0645\u064a\u0639",
            "dxDataGrid-ungroupAllText": "\u0641\u0643 \u062a\u062c\u0645\u064a\u0639 \u0627\u0644\u0643\u0644",
            "dxDataGrid-editingEditRow": "\u062a\u0639\u062f\u064a\u0644",
            "dxDataGrid-editingSaveRowChanges": "\u062d\u0641\u0638",
            "dxDataGrid-editingCancelRowChanges": "\u0627\u0644\u063a\u0627\u0621",
            "dxDataGrid-editingDeleteRow": "\u062d\u0630\u0641",
            "dxDataGrid-editingUndeleteRow": "\u0627\u0644\u063a\u0627\u0621 \u0627\u0644\u062d\u0630\u0641",
            "dxDataGrid-editingConfirmDeleteMessage": "\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627 \u0627\u0644\u0633\u062c\u0644\u061f",
            "dxDataGrid-validationCancelChanges": "\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a",
            "dxDataGrid-groupPanelEmptyText": "\u0627\u0633\u062d\u0628 \u0631\u0623\u0633 \u0627\u0644\u0639\u0645\u0648\u062f \u0647\u0646\u0627 \u0644\u0644\u062a\u062c\u0645\u064a\u0639 \u062d\u0633\u0628 \u0630\u0644\u0643 \u0627\u0644\u0639\u0645\u0648\u062f",
            "dxDataGrid-noDataText": "\u0644\u0627\u064a\u0648\u062c\u062f \u0628\u064a\u0627\u0646\u0627\u062a",
            "dxDataGrid-searchPanelPlaceholder": "\u0628\u062d\u062b...",
            "dxDataGrid-filterRowShowAllText": "(\u0627\u0644\u0643\u0644)",
            "dxDataGrid-filterRowResetOperationText": "\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646",
            "dxDataGrid-filterRowOperationEquals": "\u064a\u0633\u0627\u0648\u064a",
            "dxDataGrid-filterRowOperationNotEquals": "\u0644\u0627 \u064a\u0633\u0627\u0648\u064a",
            "dxDataGrid-filterRowOperationLess": "\u0623\u0642\u0644 \u0645\u0646",
            "dxDataGrid-filterRowOperationLessOrEquals": "\u0627\u0642\u0644 \u0627\u0648 \u064a\u0633\u0627\u0648\u064a",
            "dxDataGrid-filterRowOperationGreater": "\u0623\u0643\u062b\u0631 \u0645\u0646",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "\u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a",
            "dxDataGrid-filterRowOperationStartsWith": "\u0627\u0628\u062f\u0627 \u0628",
            "dxDataGrid-filterRowOperationContains": "\u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649",
            "dxDataGrid-filterRowOperationNotContains": "\u0644\u0627 \u064a\u062d\u062a\u0648\u064a",
            "dxDataGrid-filterRowOperationEndsWith": "\u064a\u0646\u062a\u0647\u064a \u0628\u0640",
            "dxDataGrid-filterRowOperationBetween": "\u0645\u0627 \u0628\u064a\u0646",
            "dxDataGrid-filterRowOperationBetweenStartText": "\u0628\u062f\u0627",
            "dxDataGrid-filterRowOperationBetweenEndText": "\u0627\u0646\u062a\u0647\u0649",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "\u062a\u0637\u0628\u064a\u0642 \u0645\u0631\u0634\u062d",
            "dxDataGrid-trueText": "\u0635\u062d\u064a\u062d",
            "dxDataGrid-falseText": "\u062e\u0627\u0637\u0626\u0629",
            "dxDataGrid-sortingAscendingText": "\u0641\u0631\u0632 \u062a\u0635\u0627\u0639\u062f\u064a",
            "dxDataGrid-sortingDescendingText": "\u062a\u0631\u062a\u064a\u0628 \u062a\u0646\u0627\u0632\u0644\u064a",
            "dxDataGrid-sortingClearText": "\u0645\u0633\u062d \u0627\u0644\u0641\u0631\u0632",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "\u0627\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a",
            "dxDataGrid-editingCancelAllChanges": "\u062a\u062c\u0627\u0647\u0644 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a",
            "dxDataGrid-editingAddRow": "\u0623\u0636\u0641 \u0635\u0641\u064b\u0627",
            "dxDataGrid-summaryMin": "\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u062f\u0646\u0649: {0}",
            "dxDataGrid-summaryMinOtherColumn": "\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u062f\u0646\u0649 \u0644\u0640 {1} \u0647\u0648 {0}",
            "dxDataGrid-summaryMax": "\u0627\u0644\u062d\u062f \u0627\u0644\u0627\u0639\u0644\u0649: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u0640 {1} \u0647\u0648 {0}",
            "dxDataGrid-summaryAvg": "\u0627\u0644\u0645\u062a\u0648\u0633\u0637: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "\u0645\u062a\u0648\u0633\u0637 {1} \u0647\u0648 {0}",
            "dxDataGrid-summarySum": "\u0627\u0644\u0645\u062c\u0645\u0648\u0639: {0}",
            "dxDataGrid-summarySumOtherColumn": "\u0645\u062c\u0645\u0648\u0639 {1} \u0647\u0648 {0}",
            "dxDataGrid-summaryCount": "\u0627\u0644\u0639\u062f\u062f: {0}",
            "dxDataGrid-columnFixingFix": "\u0627\u0644\u0625\u0635\u0644\u0627\u062d",
            "dxDataGrid-columnFixingUnfix": "\u0627\u0644\u063a\u0627\u0621 \u0627\u0644\u062a\u0635\u0644\u064a\u062d",
            "dxDataGrid-columnFixingLeftPosition": "\u0625\u0644\u0649 \u0627\u0644\u064a\u0633\u0627\u0631",
            "dxDataGrid-columnFixingRightPosition": "\u0625\u0644\u0649 \u0627\u0644\u064a\u0645\u064a\u0646",
            "dxDataGrid-exportTo": "\u062a\u0635\u062f\u064a\u0631",
            "dxDataGrid-exportToExcel": "\u062a\u0635\u062f\u064a\u0631 \u0625\u0644\u0649 \u0645\u0644\u0641 Excel",
            "dxDataGrid-exporting": "\u062a\u0635\u062f\u064a\u0631 ...",
            "dxDataGrid-excelFormat": "\u0645\u0644\u0641 \u0627\u0643\u0633\u0644",
            "dxDataGrid-selectedRows": "\u0627\u0644\u0635\u0641\u0648\u0641 \u0627\u0644\u0645\u062e\u062a\u0627\u0631\u0629",
            "dxDataGrid-exportSelectedRows": "\u062a\u0635\u062f\u064a\u0631 \u0627\u0644\u0635\u0641\u0648\u0641 \u0627\u0644\u0645\u062d\u062f\u062f\u0629",
            "dxDataGrid-exportAll": "\u062a\u0635\u062f\u064a\u0631 \u0643\u0627\u0641\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(\u0641\u0631\u0627\u063a\u0627\u062a)",
            "dxDataGrid-headerFilterOK": "\u062d\u0633\u0646\u0627",
            "dxDataGrid-headerFilterCancel": "\u0625\u0644\u063a\u0627\u0621",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "\u0639\u0645\u0648\u062f",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "\u0627\u0644\u0642\u064a\u0645\u0629",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "\u062a\u0635\u0641\u064a\u0629 \u0627\u0644\u062e\u0644\u064a\u0629",
            "dxDataGrid-ariaCollapse": "\u0637\u064a",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "\u062a\u0648\u0633\u064a\u0639",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "\u0634\u0628\u0643\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a",
            "dxDataGrid-ariaSearchInGrid": "\u0627\u0644\u0628\u062d\u062b \u0641\u064a \u0634\u0628\u0643\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a",
            "dxDataGrid-ariaSelectAll": "\u062d\u062f\u062f \u0627\u0644\u0643\u0644",
            "dxDataGrid-ariaSelectRow": "\u062a\u062d\u062f\u064a\u062f \u0635\u0641",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "\u0639\u0627\u0645\u0644 \u0627\u0644\u062a\u0635\u0641\u064a\u0629",
            "dxDataGrid-filterPanelCreateFilter": "\u0625\u0646\u0634\u0627\u0621 \u0639\u0627\u0645\u0644 \u062a\u0635\u0641\u064a\u0629",
            "dxDataGrid-filterPanelClearFilter": "\u0645\u0633\u062d",
            "dxDataGrid-filterPanelFilterEnabledHint": "\u062a\u0645\u0643\u064a\u0646 \u0639\u0627\u0645\u0644 \u0627\u0644\u062a\u0635\u0641\u064a\u0629",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "\u0627\u0636\u0627\u0641\u0629",
            "dxPager-infoText": "\u0627\u0644\u0635\u0641\u062d\u0629 {0} \u0645\u0646 {1} ({2} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631)",
            "dxPager-pagesCountText": "\u0645\u0646",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "\u0627\u0644\u0643\u0644",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous Page",
            "dxPager-nextPage": "Next Page",
            "dxPager-ariaLabel": "Page Navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "\u0627\u0644\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0643\u0644\u064a",
            "dxPivotGrid-total": "{0} \u0627\u0644\u0645\u062c\u0645\u0648\u0639",
            "dxPivotGrid-fieldChooserTitle": "\u0645\u0646\u062a\u0642\u064a \u0627\u0644\u062d\u0642\u0648\u0644",
            "dxPivotGrid-showFieldChooser": "\u0625\u0638\u0647\u0627\u0631 \u0645\u0646\u062a\u0642\u064a \u0627\u0644\u062d\u0642\u0648\u0644",
            "dxPivotGrid-expandAll": "\u062a\u0648\u0633\u064a\u0639 \u0627\u0644\u0643\u0644",
            "dxPivotGrid-collapseAll": "\u0637\u064a \u0627\u0644\u0643\u0644",
            "dxPivotGrid-sortColumnBySummary": "\u0641\u0631\u0632 {0} \u062d\u0633\u0628 \u0647\u0630\u0627 \u0627\u0644\u0639\u0645\u0648\u062f",
            "dxPivotGrid-sortRowBySummary": "\u0641\u0631\u0632 {0} \u062d\u0633\u0628 \u0647\u0630\u0627 \u0627\u0644\u0635\u0641",
            "dxPivotGrid-removeAllSorting": "\u0625\u0632\u0627\u0644\u0629 \u0643\u0627\u0641\u0629 \u0627\u0644\u0641\u0631\u0632",
            "dxPivotGrid-dataNotAvailable": "N / A",
            "dxPivotGrid-rowFields": "\u062d\u0642\u0648\u0644 \u0627\u0644\u0635\u0641",
            "dxPivotGrid-columnFields": "\u062d\u0642\u0648\u0644 \u0627\u0644\u0639\u0645\u0648\u062f",
            "dxPivotGrid-dataFields": "\u062d\u0642\u0648\u0644 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a",
            "dxPivotGrid-filterFields": "\u062a\u0635\u0641\u064a\u0629 \u0627\u0644\u062d\u0642\u0648\u0644",
            "dxPivotGrid-allFields": "\u0643\u0627\u0641\u0629 \u0627\u0644\u062d\u0642\u0648\u0644",
            "dxPivotGrid-columnFieldArea": "\u0625\u0641\u0644\u0627\u062a \u062d\u0642\u0648\u0644 \u0627\u0644\u0639\u0645\u0648\u062f \u0647\u0646\u0627",
            "dxPivotGrid-dataFieldArea": "\u0625\u0641\u0644\u0627\u062a \u062d\u0642\u0648\u0644 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0647\u0646\u0627",
            "dxPivotGrid-rowFieldArea": "\u0625\u0641\u0644\u0627\u062a \u062d\u0642\u0648\u0644 \u0627\u0644\u0635\u0641 \u0647\u0646\u0627",
            "dxPivotGrid-filterFieldArea": "\u0625\u0641\u0644\u0627\u062a \u062d\u0642\u0648\u0644 \u0627\u0644\u062a\u0635\u0641\u064a\u0629 \u0647\u0646\u0627",
            "dxScheduler-editorLabelTitle": "\u0627\u0644\u0645\u0648\u0636\u0648\u0639",
            "dxScheduler-editorLabelStartDate": "\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0628\u062f\u0621",
            "dxScheduler-editorLabelEndDate": "\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621",
            "dxScheduler-editorLabelDescription": "\u0627\u0644\u0648\u0635\u0641",
            "dxScheduler-editorLabelRecurrence": "\u062a\u0643\u0631\u0627\u0631",
            "dxScheduler-openAppointment": "\u0641\u062a\u062d \u0645\u0648\u0639\u062f",
            "dxScheduler-recurrenceNever": "\u0645\u0637\u0644\u0642\u064b\u0627",
            "dxScheduler-recurrenceMinutely": "\u0643\u0644 \u062f\u0642\u064a\u0642\u0629",
            "dxScheduler-recurrenceHourly": "\u0643\u0644 \u0633\u0627\u0639\u0629",
            "dxScheduler-recurrenceDaily": "\u064a\u0648\u0645\u064a\u064b\u0627",
            "dxScheduler-recurrenceWeekly": "\u0627\u0633\u0628\u0648\u0639\u064a\u0627",
            "dxScheduler-recurrenceMonthly": "\u0634\u0647\u0631\u064a\u064b\u0627",
            "dxScheduler-recurrenceYearly": "\u0633\u0646\u0648\u064a\u064b\u0627",
            "dxScheduler-recurrenceRepeatEvery": "\u0643\u0631\u0631 \u0643\u0644",
            "dxScheduler-recurrenceRepeatOn": "\u0643\u0631\u0631 \u0641\u064a",
            "dxScheduler-recurrenceEnd": "\u0625\u0646\u0647\u0627\u0621 \u0627\u0644\u062a\u0643\u0631\u0627\u0631",
            "dxScheduler-recurrenceAfter": "\u0628\u0639\u062f",
            "dxScheduler-recurrenceOn": "\u062a\u0634\u063a\u064a\u0644",
            "dxScheduler-recurrenceRepeatMinutely": "\u062f\u0642\u0627\u0626\u0642 (s)",
            "dxScheduler-recurrenceRepeatHourly": "\u0633\u0627\u0639\u0629 (h)",
            "dxScheduler-recurrenceRepeatDaily": "\u064a\u0648\u0645 (d)",
            "dxScheduler-recurrenceRepeatWeekly": "\u0623\u0633\u0628\u0648\u0639 (w)",
            "dxScheduler-recurrenceRepeatMonthly": "\u0634\u0647\u0631 (m)",
            "dxScheduler-recurrenceRepeatYearly": "\u0633\u0646\u0648\u064a (y)",
            "dxScheduler-switcherDay": "\u0627\u0644\u064a\u0648\u0645",
            "dxScheduler-switcherWeek": "\u0627\u0644\u0623\u0633\u0628\u0648\u0639",
            "dxScheduler-switcherWorkWeek": "\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0639\u0645\u0644",
            "dxScheduler-switcherMonth": "\u0634\u0647\u0631",
            "dxScheduler-switcherAgenda": "\u062c\u062f\u0648\u0644 \u0627\u0644\u0623\u0639\u0645\u0627\u0644",
            "dxScheduler-switcherTimelineDay": "\u064a\u0648\u0645 \u0627\u0644\u0645\u062e\u0637\u0637 \u0627\u0644\u0632\u0645\u0646\u064a",
            "dxScheduler-switcherTimelineWeek": "\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u062e\u0637\u0637 \u0627\u0644\u0632\u0645\u0646\u064a",
            "dxScheduler-switcherTimelineWorkWeek": "\u0623\u0633\u0628\u0648\u0639 \u0639\u0645\u0644 \u0627\u0644\u0645\u062e\u0637\u0637",
            "dxScheduler-switcherTimelineMonth": "\u0634\u0647\u0631 \u0627\u0644\u0645\u062e\u0637\u0637 \u0627\u0644\u0632\u0645\u0646\u064a",
            "dxScheduler-recurrenceRepeatOnDate": "\u0641\u064a \u0627\u0644\u062a\u0627\u0631\u064a\u062e",
            "dxScheduler-recurrenceRepeatCount": "\u0645\u0631\u0629 (\u0645\u0631\u0627\u062a)",
            "dxScheduler-allDay": "\u0637\u0648\u0627\u0644 \u0627\u0644\u064a\u0648\u0645",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "\u0647\u0644 \u062a\u0631\u064a\u062f \u062a\u062d\u0631\u064a\u0631 \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u0639\u062f \u0641\u0642\u0637 \u0623\u0645 \u0627\u0644\u0633\u0644\u0633\u0644\u0629 \u0628\u0623\u0643\u0645\u0644\u0647\u0627\u061f",
            "dxScheduler-confirmRecurrenceDeleteMessage": "\u0647\u0644 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u0639\u062f \u0641\u0642\u0637 \u0623\u0645 \u0627\u0644\u0645\u062c\u0645\u0648\u0639\u0629 \u0628\u0623\u0643\u0645\u0644\u0647\u0627\u061f",
            "dxScheduler-confirmRecurrenceEditSeries": "\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0633\u0644\u0633\u0644\u0629",
            "dxScheduler-confirmRecurrenceDeleteSeries": "\u062d\u0630\u0641 \u0627\u0644\u0633\u0644\u0633\u0644\u0629",
            "dxScheduler-confirmRecurrenceEditOccurrence": "\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0648\u0639\u062f",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "\u062d\u0630\u0641 \u0627\u0644\u0645\u0648\u0639\u062f",
            "dxScheduler-noTimezoneTitle": "\u0628\u0644\u0627 \u0645\u0646\u0637\u0642\u0629 \u0632\u0645\u0646\u064a\u0629",
            "dxScheduler-moreAppointments": "{0} \u0627\u0644\u0645\u0632\u064a\u062f",
            "dxCalendar-todayButtonText": "\u0627\u0644\u064a\u0648\u0645",
            "dxCalendar-ariaWidgetName": "\u0627\u0644\u062a\u0642\u0648\u064a\u0645",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxColorView-ariaRed": "\u0623\u062d\u0645\u0631",
            "dxColorView-ariaGreen": "\u0623\u062e\u0636\u0631",
            "dxColorView-ariaBlue": "\u0623\u0632\u0631\u0642",
            "dxColorView-ariaAlpha": "\u0627\u0644\u0634\u0641\u0627\u0641\u064a\u0629",
            "dxColorView-ariaHex": "\u0643\u0648\u062f \u0627\u0644\u0644\u0648\u0646",
            "dxTagBox-selected": "\u062a\u0645 \u062a\u062d\u062f\u064a\u062f {0}",
            "dxTagBox-allSelected": "\u0643\u0644 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0627\u0644\u0645\u062d\u062f\u062f\u0629 ({0})",
            "dxTagBox-moreSelected": "{0} \u0627\u0644\u0645\u0632\u064a\u062f",
            "vizExport-printingButtonText": "Print",
            "vizExport-titleMenuText": "\u062a\u0635\u062f\u064a\u0631 / \u0637\u0628\u0627\u0639\u0629",
            "vizExport-exportButtonText": "{0} file",
            "dxFilterBuilder-and": "\u0648",
            "dxFilterBuilder-or": "\u0627\u0648",
            "dxFilterBuilder-notAnd": "\u0644\u0627 \u0648",
            "dxFilterBuilder-notOr": "\u0644\u0627 \u0623\u0648",
            "dxFilterBuilder-addCondition": "\u0625\u0636\u0627\u0641\u0629 \u0634\u0631\u0637",
            "dxFilterBuilder-addGroup": "\u0625\u0636\u0627\u0641\u0629 \u0645\u062c\u0645\u0648\u0639\u0629",
            "dxFilterBuilder-enterValueText": "<\u0623\u062f\u062e\u0644 \u0642\u064a\u0645\u0629>",
            "dxFilterBuilder-filterOperationEquals": "\u064a\u0633\u0627\u0648\u064a",
            "dxFilterBuilder-filterOperationNotEquals": "\u0644\u0627 \u064a\u0633\u0627\u0648\u064a",
            "dxFilterBuilder-filterOperationLess": "\u0623\u0642\u0644 \u0645\u0646",
            "dxFilterBuilder-filterOperationLessOrEquals": "\u0623\u0642\u0644 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a",
            "dxFilterBuilder-filterOperationGreater": "\u0623\u0643\u0628\u0631 \u0645\u0646",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "\u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a",
            "dxFilterBuilder-filterOperationStartsWith": "\u064a\u0628\u062f\u0623 \u0628\u0640",
            "dxFilterBuilder-filterOperationContains": "\u064a\u062d\u062a\u0648\u064a",
            "dxFilterBuilder-filterOperationNotContains": "\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649",
            "dxFilterBuilder-filterOperationEndsWith": "\u064a\u0646\u062a\u0647\u064a \u0628\u0640",
            "dxFilterBuilder-filterOperationIsBlank": "\u0641\u0627\u0631\u063a",
            "dxFilterBuilder-filterOperationIsNotBlank": "\u0644\u064a\u0633 \u0641\u0627\u0631\u063a\u064b\u0627",
            "dxFilterBuilder-filterOperationBetween": "\u0628\u064a\u0646",
            "dxFilterBuilder-filterOperationAnyOf": "\u0623\u064a \u0645\u0646",
            "dxFilterBuilder-filterOperationNoneOf": "\u0644\u064a\u0633 \u0645\u0646",
            "dxHtmlEditor-dialogColorCaption": "\u062a\u063a\u064a\u064a\u0631 \u0644\u0648\u0646 \u0627\u0644\u062e\u0637",
            "dxHtmlEditor-dialogBackgroundCaption": "\u062a\u063a\u064a\u064a\u0631 \u0644\u0648\u0646 \u0627\u0644\u062e\u0644\u0641\u064a\u0629",
            "dxHtmlEditor-dialogLinkCaption": "\u0625\u0636\u0627\u0641\u0629 \u0627\u0631\u062a\u0628\u0627\u0637",
            "dxHtmlEditor-dialogLinkUrlField": "\u0627\u0644\u0631\u0627\u0628\u0637",
            "dxHtmlEditor-dialogLinkTextField": "\u0646\u0635",
            "dxHtmlEditor-dialogLinkTargetField": "\u0641\u062a\u062d \u0627\u0644\u0627\u0631\u062a\u0628\u0627\u0637 \u0641\u064a \u0646\u0627\u0641\u0630\u0629 \u062c\u062f\u064a\u062f\u0629",
            "dxHtmlEditor-dialogImageCaption": "\u0625\u0636\u0627\u0641\u0629 \u0635\u0648\u0631\u0629",
            "dxHtmlEditor-dialogImageUrlField": "\u0627\u0644\u0631\u0627\u0628\u0637",
            "dxHtmlEditor-dialogImageAltField": "\u0646\u0635 \u0628\u062f\u064a\u0644",
            "dxHtmlEditor-dialogImageWidthField": "\u0627\u0644\u0639\u0631\u0636 (\u0628\u0643\u0633\u0644)",
            "dxHtmlEditor-dialogImageHeightField": "\u0627\u0644\u0627\u0631\u062a\u0641\u0627\u0639 (\u0628\u0643\u0633\u0644)",
            "dxHtmlEditor-dialogInsertTableRowsField": "\u0635\u0641\u0648\u0641",
            "dxHtmlEditor-dialogInsertTableColumnsField": "\u0627\u0644\u0623\u0639\u0645\u062f\u0629",
            "dxHtmlEditor-dialogInsertTableCaption": "\u0625\u062f\u0631\u0627\u062c \u062c\u062f\u0648\u0644",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "\u0627\u0644\u0639\u0646\u0648\u0627\u0646",
            "dxHtmlEditor-normalText": "\u0646\u0635 \u0639\u0627\u062f\u064a",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxFileManager-newDirectoryName": "\u062f\u0644\u064a\u0644 \u0628\u062f\u0648\u0646 \u0639\u0646\u0648\u0627\u0646",
            "dxFileManager-rootDirectoryName": "\u0627\u0644\u0645\u0644\u0641\u0627\u062a",
            "dxFileManager-errorNoAccess": "\u062a\u0645 \u0631\u0641\u0636 \u0627\u0644\u0648\u0635\u0648\u0644. \u062a\u0639\u0630\u0631 \u0625\u0643\u0645\u0627\u0644 \u0627\u0644\u0639\u0645\u0644\u064a\u0629.",
            "dxFileManager-errorDirectoryExistsFormat": "\u0627\u0644\u062f\u0644\u064a\u0644 '{0}' \u0645\u0648\u062c\u0648\u062f \u0628\u0627\u0644\u0641\u0639\u0644.",
            "dxFileManager-errorFileExistsFormat": "\u0627\u0644\u0645\u0644\u0641 '{0}' \u0645\u0648\u062c\u0648\u062f \u0628\u0627\u0644\u0641\u0639\u0644.",
            "dxFileManager-errorFileNotFoundFormat": "\u0627\u0644\u0645\u0644\u0641 '{0}' \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f.",
            "dxFileManager-errorDirectoryNotFoundFormat": "\u0627\u0644\u062f\u0644\u064a\u0644 '{0}' \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f.",
            "dxFileManager-errorWrongFileExtension": "\u0645\u0644\u062d\u0642 \u0627\u0644\u0645\u0644\u0641 \u063a\u064a\u0631 \u0645\u0633\u0645\u0648\u062d \u0628\u0647.",
            "dxFileManager-errorMaxFileSizeExceeded": "\u062d\u062c\u0645 \u0627\u0644\u0645\u0644\u0641 \u064a\u062a\u062c\u0627\u0648\u0632 \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u0644\u062d\u062c\u0645 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647.",
            "dxFileManager-errorInvalidSymbols": "\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0645 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.",
            "dxFileManager-errorDefault": "\u062e\u0637\u0623 \u063a\u064a\u0631 \u0645\u062d\u062f\u062f.",
            "dxFileManager-errorDirectoryOpenFailed": "\u0644\u0627 \u064a\u0645\u0643\u0646 \u0641\u062a\u062d \u0627\u0644\u062f\u0644\u064a\u0644",
            "dxFileManager-commandCreate": "\u062f\u0644\u064a\u0644 \u062c\u062f\u064a\u062f",
            "dxFileManager-commandRename": "\u0625\u0639\u0627\u062f\u0629 \u062a\u0633\u0645\u064a\u0629",
            "dxFileManager-commandMove": "\u0646\u0642\u0644 \u0625\u0644\u0649",
            "dxFileManager-commandCopy": "\u0646\u0633\u062e \u0625\u0644\u0649",
            "dxFileManager-commandDelete": "Delete",
            "dxFileManager-commandDownload": "\u062a\u0646\u0632\u064a\u0644",
            "dxFileManager-commandUpload": "\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0644\u0641\u0627\u062a",
            "dxFileManager-commandRefresh": "\u062a\u062d\u062f\u064a\u062b",
            "dxFileManager-commandThumbnails": "\u0639\u0631\u0636 \u0627\u0644\u0635\u0648\u0631 \u0627\u0644\u0645\u0635\u063a\u0631\u0629",
            "dxFileManager-commandDetails": "\u0639\u0631\u0636 \u0627\u0644\u062a\u0641\u0627\u0635\u064a\u0644",
            "dxFileManager-commandClearSelection": "\u0645\u0633\u062d \u0627\u0644\u062a\u062d\u062f\u064a\u062f",
            "dxFileManager-commandShowNavPane": "\u062a\u0628\u062f\u064a\u0644 \u062c\u0632\u0621 \u0627\u0644\u062a\u0646\u0642\u0644",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "\u0646\u0642\u0644 \u0625\u0644\u0649",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "\u0646\u0642\u0644",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "\u0646\u0633\u062e \u0625\u0644\u0649",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "\u0646\u0633\u062e",
            "dxFileManager-dialogRenameItemTitle": "\u0625\u0639\u0627\u062f\u0629 \u062a\u0633\u0645\u064a\u0629",
            "dxFileManager-dialogRenameItemButtonText": "\u062d\u0641\u0638",
            "dxFileManager-dialogCreateDirectoryTitle": "\u062f\u0644\u064a\u0644 \u062c\u062f\u064a\u062f",
            "dxFileManager-dialogCreateDirectoryButtonText": "\u0625\u0646\u0634\u0627\u0621",
            "dxFileManager-dialogDeleteItemTitle": "\u062d\u0630\u0641",
            "dxFileManager-dialogDeleteItemButtonText": "\u062d\u0630\u0641",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 {0}\u061f",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 {0} \u0639\u0646\u0635\u0631\u061f",
            "dxFileManager-dialogButtonCancel": "\u0625\u0644\u063a\u0627\u0621",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "\u0625\u0646\u0634\u0627\u0621 \u062f\u0644\u064a\u0644 \u062f\u0627\u062e\u0644 {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u062f\u0644\u064a\u0644 \u062f\u0627\u062e\u0644 {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062f\u0644\u064a\u0644",
            "dxFileManager-editingCreateCommonErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062f\u0644\u064a\u0644",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "\u0625\u0639\u0627\u062f\u0629 \u062a\u0633\u0645\u064a\u0629 \u0639\u0646\u0635\u0631 \u062f\u0627\u062e\u0644 {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "\u062a\u0645\u062a \u0625\u0639\u0627\u062f\u0629 \u062a\u0633\u0645\u064a\u0629 \u0639\u0646\u0635\u0631 \u062f\u0627\u062e\u0644 {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "\u0644\u0645 \u062a\u062a\u0645 \u0625\u0639\u0627\u062f\u0629 \u062a\u0633\u0645\u064a\u0629 \u0627\u0644\u0639\u0646\u0635\u0631",
            "dxFileManager-editingRenameCommonErrorMessage": "\u0644\u0645 \u062a\u062a\u0645 \u0625\u0639\u0627\u062f\u0629 \u062a\u0633\u0645\u064a\u0629 \u0627\u0644\u0639\u0646\u0635\u0631",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "\u062d\u0630\u0641 \u0639\u0646\u0635\u0631 \u0645\u0646 {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "\u062d\u0630\u0641 {0} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0645\u0646 {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "\u062a\u0645 \u062d\u0630\u0641 \u0639\u0646\u0635\u0631 \u0645\u0646 {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "\u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0627\u0644\u0645\u062d\u0630\u0648\u0641\u0629 {0} \u0645\u0646 {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0639\u0646\u0635\u0631",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} \u0644\u0645 \u064a\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0639\u0646\u0627\u0635\u0631",
            "dxFileManager-editingDeleteCommonErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u062d\u0630\u0641 \u0628\u0639\u0636 \u0627\u0644\u0639\u0646\u0627\u0635\u0631",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "\u0646\u0642\u0644 \u0639\u0646\u0635\u0631 \u0625\u0644\u0649 {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "\u0646\u0642\u0644 {0} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0625\u0644\u0649 {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "\u062a\u0645 \u0646\u0642\u0644 \u0639\u0646\u0635\u0631 \u0625\u0644\u0649 {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "\u062a\u0645 \u0646\u0642\u0644 {0} \u0639\u0646\u0635\u0631\u064b\u0627 \u0625\u0644\u0649 {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u0646\u0642\u0644 \u0627\u0644\u0639\u0646\u0635\u0631",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0644\u0645 \u064a\u062a\u0645 \u0646\u0642\u0644\u0647\u0627",
            "dxFileManager-editingMoveCommonErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u0646\u0642\u0644 \u0628\u0639\u0636 \u0627\u0644\u0639\u0646\u0627\u0635\u0631",
            "dxFileManager-editingCopySingleItemProcessingMessage": "\u0646\u0633\u062e \u0639\u0646\u0635\u0631 \u0625\u0644\u0649 {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "\u0646\u0633\u062e {0} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0625\u0644\u0649 {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "\u0646\u0633\u062e \u0639\u0646\u0635\u0631 \u0625\u0644\u0649 {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "\u062a\u0645 \u0646\u0633\u062e {0} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0625\u0644\u0649 {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u0646\u0633\u062e \u0627\u0644\u0639\u0646\u0635\u0631",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0644\u0645 \u064a\u062a\u0645 \u0646\u0633\u062e\u0647\u0627",
            "dxFileManager-editingCopyCommonErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u0646\u0633\u062e \u0628\u0639\u0636 \u0627\u0644\u0639\u0646\u0627\u0635\u0631",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "\u062a\u062d\u0645\u064a\u0644 \u0639\u0646\u0635\u0631 \u0625\u0644\u0649 {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "\u062a\u062d\u0645\u064a\u0644 {0} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0625\u0644\u0649 {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "\u062a\u0645 \u062a\u062d\u0645\u064a\u0644 \u0639\u0646\u0635\u0631 \u0625\u0644\u0649 {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "\u062a\u0645 \u062a\u062d\u0645\u064a\u0644 {0} \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0625\u0644\u0649 {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "\u0644\u0645 \u064a\u062a\u0645 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0639\u0646\u0635\u0631",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} \u0644\u0645 \u064a\u062a\u0645 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0639\u0646\u0627\u0635\u0631",
            "dxFileManager-editingUploadCanceledMessage": "\u0645\u0644\u063a\u0649",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "\u0627\u0644\u0627\u0633\u0645",
            "dxFileManager-listDetailsColumnCaptionDateModified": "\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u062a\u0639\u062f\u064a\u0644",
            "dxFileManager-listDetailsColumnCaptionFileSize": "\u062d\u062c\u0645 \u0627\u0644\u0645\u0644\u0641",
            "dxFileManager-listThumbnailsTooltipTextSize": "\u0627\u0644\u062d\u062c\u0645",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u062a\u0639\u062f\u064a\u0644",
            "dxFileManager-notificationProgressPanelTitle": "\u0627\u0644\u062a\u0642\u062f\u0645",
            "dxFileManager-notificationProgressPanelEmptyListText": "\u0644\u0627 \u062a\u0648\u062c\u062f \u0639\u0645\u0644\u064a\u0627\u062a",
            "dxFileManager-notificationProgressPanelOperationCanceled": "\u0645\u0644\u063a\u0649",
            "dxDiagram-categoryGeneral": "\u0639\u0627\u0645",
            "dxDiagram-categoryFlowchart": "Flowchart",
            "dxDiagram-categoryOrgChart": "\u0645\u062e\u0637\u0637 \u0627\u0644\u0645\u0624\u0633\u0633\u0629",
            "dxDiagram-categoryContainers": "Container",
            "dxDiagram-categoryCustom": "Custom",
            "dxDiagram-commandExportToSvg": "\u062a\u0635\u062f\u064a\u0631 \u0625\u0644\u0649 SVG",
            "dxDiagram-commandExportToPng": "\u062a\u0635\u062f\u064a\u0631 \u0625\u0644\u0649 PNG",
            "dxDiagram-commandExportToJpg": "\u062a\u0635\u062f\u064a\u0631 \u0625\u0644\u0649 JPEG",
            "dxDiagram-commandUndo": "\u062a\u0631\u0627\u062c\u0639",
            "dxDiagram-commandRedo": "\u0625\u0639\u0627\u062f\u0629",
            "dxDiagram-commandFontName": "\u0627\u0633\u0645 \u0627\u0644\u062e\u0637",
            "dxDiagram-commandFontSize": "\u062d\u062c\u0645 \u0627\u0644\u062e\u0637",
            "dxDiagram-commandBold": "\u0628\u0627\u0644\u062e\u0637 \u0627\u0644\u0639\u0631\u064a\u0636",
            "dxDiagram-commandItalic": "\u0645\u0627\u0626\u0644",
            "dxDiagram-commandUnderline": "\u062a\u0633\u0637\u064a\u0631",
            "dxDiagram-commandTextColor": "\u0644\u0648\u0646 \u0627\u0644\u062e\u0637",
            "dxDiagram-commandLineColor": "\u0644\u0648\u0646 \u0627\u0644\u062e\u0637",
            "dxDiagram-commandLineWidth": "\u0639\u0631\u0636 \u0627\u0644\u062e\u0637",
            "dxDiagram-commandLineStyle": "\u0646\u0648\u0639 \u0627\u0644\u062e\u0637",
            "dxDiagram-commandLineStyleSolid": "\u0635\u0644\u0628",
            "dxDiagram-commandLineStyleDotted": "\u0645\u0646\u0642\u0637",
            "dxDiagram-commandLineStyleDashed": "\u0645\u062a\u0642\u0637\u0639",
            "dxDiagram-commandFillColor": "\u0644\u0648\u0646 \u0627\u0644\u062a\u0639\u0628\u0626\u0629",
            "dxDiagram-commandAlignLeft": "\u0645\u062d\u0627\u0630\u0627\u0629 \u0644\u0644\u064a\u0633\u0627\u0631",
            "dxDiagram-commandAlignCenter": "\u0645\u062d\u0627\u0630\u0627\u0629 \u0644\u0644\u0648\u0633\u0637",
            "dxDiagram-commandAlignRight": "\u0645\u062d\u0627\u0630\u0627\u0629 \u0644\u0644\u064a\u0645\u064a\u0646",
            "dxDiagram-commandConnectorLineType": "\u0646\u0648\u0639 \u062e\u0637 \u0627\u0644\u0645\u0648\u0635\u0644",
            "dxDiagram-commandConnectorLineStraight": "\u0645\u0633\u062a\u0642\u064a\u0645",
            "dxDiagram-commandConnectorLineOrthogonal": "\u0645\u062a\u0639\u0627\u0645\u062f",
            "dxDiagram-commandConnectorLineStart": "\u0628\u062f\u0621 \u062e\u0637 \u0627\u0644\u0645\u0648\u0635\u0644",
            "dxDiagram-commandConnectorLineEnd": "\u0631\u0627\u0628\u0637 \u062e\u0637 \u0627\u0644\u0646\u0647\u0627\u064a\u0629",
            "dxDiagram-commandConnectorLineNone": "\u0628\u0644\u0627",
            "dxDiagram-commandConnectorLineArrow": "\u0633\u0647\u0645",
            "dxDiagram-commandFullscreen": "\u0645\u0644\u0621 \u0627\u0644\u0634\u0627\u0634\u0629",
            "dxDiagram-commandUnits": "\u0627\u0644\u0648\u062d\u062f\u0627\u062a",
            "dxDiagram-commandPageSize": "\u062d\u062c\u0645 \u0627\u0644\u0635\u0641\u062d\u0629",
            "dxDiagram-commandPageOrientation": "\u0627\u062a\u062c\u0627\u0647 \u0627\u0644\u0635\u0641\u062d\u0629",
            "dxDiagram-commandPageOrientationLandscape": "\u0623\u0641\u0642\u064a",
            "dxDiagram-commandPageOrientationPortrait": "\u0635\u0648\u0631\u0629",
            "dxDiagram-commandPageColor": "\u0644\u0648\u0646 \u0627\u0644\u0635\u0641\u062d\u0629",
            "dxDiagram-commandShowGrid": "\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0634\u0628\u0643\u0629",
            "dxDiagram-commandSnapToGrid": "\u0627\u0646\u0637\u0628\u0627\u0642 \u0639\u0644\u0649 \u0627\u0644\u0634\u0628\u0643\u0629",
            "dxDiagram-commandGridSize": "\u062d\u062c\u0645 \u0627\u0644\u0634\u0628\u0643\u0629",
            "dxDiagram-commandZoomLevel": "\u0645\u0633\u062a\u0648\u0649 \u0627\u0644\u062a\u0643\u0628\u064a\u0631",
            "dxDiagram-commandAutoZoom": "\u062a\u0643\u0628\u064a\u0631 \u062a\u0644\u0642\u0627\u0626\u064a",
            "dxDiagram-commandFitToContent": "\u0645\u0644\u0627\u0626\u0645\u0629 \u0644\u0644\u0645\u062d\u062a\u0648\u0649",
            "dxDiagram-commandFitToWidth": "\u0645\u0644\u0627\u0621\u0645\u0629 \u0644\u0644\u0639\u0631\u0636",
            "dxDiagram-commandAutoZoomByContent": "\u062a\u0643\u0628\u064a\u0631 \u062a\u0644\u0642\u0627\u0626\u064a \u062d\u0633\u0628 \u0627\u0644\u0645\u062d\u062a\u0648\u0649",
            "dxDiagram-commandAutoZoomByWidth": "\u062a\u0643\u0628\u064a\u0631 \u062a\u0644\u0642\u0627\u0626\u064a \u062d\u0633\u0628 \u0627\u0644\u0639\u0631\u0636",
            "dxDiagram-commandSimpleView": "\u0639\u0631\u0636 \u0628\u0633\u064a\u0637",
            "dxDiagram-commandCut": "\u0642\u0635",
            "dxDiagram-commandCopy": "\u0646\u0633\u062e",
            "dxDiagram-commandPaste": "\u0644\u0635\u0642",
            "dxDiagram-commandSelectAll": "\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644",
            "dxDiagram-commandDelete": "\u062d\u0630\u0641",
            "dxDiagram-commandBringToFront": "\u0627\u062c\u0644\u0628 \u0644\u0644\u0645\u0642\u062f\u0645\u0629",
            "dxDiagram-commandSendToBack": "\u0625\u0631\u0633\u0627\u0644 \u0625\u0644\u0649 \u0627\u0644\u062e\u0644\u0641",
            "dxDiagram-commandLock": "\u0642\u0641\u0644",
            "dxDiagram-commandUnlock": "\u0627\u0644\u063a\u0627\u0621 \u0627\u0644\u0642\u0641\u0644",
            "dxDiagram-commandInsertShapeImage": "\u0625\u062f\u0631\u0627\u062c \u0635\u0648\u0631\u0629 ...",
            "dxDiagram-commandEditShapeImage": "\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0635\u0648\u0631\u0629 ...",
            "dxDiagram-commandDeleteShapeImage": "\u062d\u0630\u0641 \u0627\u0644\u0635\u0648\u0631\u0629",
            "dxDiagram-commandLayoutLeftToRight": "\u0645\u0646 \u0627\u0644\u064a\u0633\u0627\u0631 \u0625\u0644\u0649 \u0627\u0644\u064a\u0645\u064a\u0646",
            "dxDiagram-commandLayoutRightToLeft": "\u0645\u0646 \u0627\u0644\u064a\u0645\u064a\u0646 \u0627\u0644\u0649 \u0627\u0644\u064a\u0633\u0627\u0631",
            "dxDiagram-commandLayoutTopToBottom": "\u0645\u0646 \u0627\u0639\u0644\u0649 \u0644\u0627\u0633\u0641\u0644",
            "dxDiagram-commandLayoutBottomToTop": "\u0645\u0646 \u0627\u0644\u0623\u0633\u0641\u0644 \u0644\u0644\u0623\u0639\u0644\u0649",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "\u0645\u0648\u0627\u0641\u0642",
            "dxDiagram-dialogButtonCancel": "\u0625\u0644\u063a\u0627\u0621",
            "dxDiagram-dialogInsertShapeImageTitle": "\u0625\u062f\u0631\u0627\u062c \u0635\u0648\u0631\u0629",
            "dxDiagram-dialogEditShapeImageTitle": "\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0635\u0648\u0631\u0629",
            "dxDiagram-dialogEditShapeImageSelectButton": "\u062d\u062f\u062f \u0635\u0648\u0631\u0629",
            "dxDiagram-dialogEditShapeImageLabelText": "\u0623\u0648 \u0625\u0641\u0644\u0627\u062a \u0627\u0644\u0645\u0644\u0641 \u0647\u0646\u0627",
            "dxDiagram-uiExport": "\u062a\u0635\u062f\u064a\u0631",
            "dxDiagram-uiProperties": "\u062e\u0635\u0627\u0626\u0635",
            "dxDiagram-uiSettings": "\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a",
            "dxDiagram-uiShowToolbox": "\u0625\u0638\u0647\u0627\u0631 \u0645\u0631\u0628\u0639 \u0627\u0644\u0623\u062f\u0648\u0627\u062a",
            "dxDiagram-uiSearch": "\u0628\u062d\u062b",
            "dxDiagram-uiStyle": "\u0627\u0644\u0646\u0645\u0637",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "\u0634\u062c\u0631\u0629",
            "dxDiagram-uiLayoutLayered": "\u0637\u0628\u0642\u0627\u062a",
            "dxDiagram-uiDiagram": "\u0645\u062e\u0637\u0637",
            "dxDiagram-uiText": "\u0646\u0635",
            "dxDiagram-uiObject": "\u0643\u0627\u0626\u0646",
            "dxDiagram-uiConnector": "\u0645\u0648\u0635\u0644",
            "dxDiagram-uiPage": "\u0627\u0644\u0635\u0641\u062d\u0629",
            "dxDiagram-shapeText": "\u0646\u0635",
            "dxDiagram-shapeRectangle": "\u0645\u0633\u062a\u0637\u064a\u0644",
            "dxDiagram-shapeEllipse": "\u0627\u0644\u0634\u0643\u0644 \u0627\u0644\u0628\u064a\u0636\u0627\u0648\u064a",
            "dxDiagram-shapeCross": "\u062a\u0639\u0628\u0631",
            "dxDiagram-shapeTriangle": "\u0645\u062b\u0644\u062b",
            "dxDiagram-shapeDiamond": "\u0627\u0644\u0645\u0627\u0633",
            "dxDiagram-shapeHeart": "\u0627\u0644\u0642\u0644\u0628",
            "dxDiagram-shapePentagon": "\u062e\u0645\u0627\u0633\u064a \u0627\u0644\u0627\u0636\u0644\u0627\u0639",
            "dxDiagram-shapeHexagon": "\u0633\u062f\u0627\u0633\u064a \u0627\u0644\u0632\u0648\u0627\u064a\u0627",
            "dxDiagram-shapeOctagon": "\u0645\u062b\u0645\u0646",
            "dxDiagram-shapeStar": "\u0646\u062c\u0645\u0629",
            "dxDiagram-shapeArrowLeft": "\u0627\u0644\u0633\u0647\u0645 \u0627\u0644\u0627\u064a\u0633\u0631",
            "dxDiagram-shapeArrowUp": "\u0633\u0647\u0645 \u0644\u0644\u0627\u0639\u0644\u0649",
            "dxDiagram-shapeArrowRight": "\u0627\u0644\u0633\u0647\u0645 \u0627\u0644\u0623\u064a\u0645\u0646",
            "dxDiagram-shapeArrowDown": "\u0627\u0644\u0633\u0647\u0645 \u0644\u0623\u0633\u0641\u0644",
            "dxDiagram-shapeArrowUpDown": "\u0644\u0627\u0639\u0644\u0649 \u0633\u0647\u0645 \u0644\u0623\u0633\u0641\u0644",
            "dxDiagram-shapeArrowLeftRight": "\u0627\u0644\u0633\u0647\u0645 \u0627\u0644\u0623\u064a\u0645\u0646 \u0627\u0644\u0623\u064a\u0633\u0631",
            "dxDiagram-shapeProcess": "\u0645\u0639\u0627\u0644\u062c\u0629",
            "dxDiagram-shapeDecision": "\u0627\u0644\u0642\u0631\u0627\u0631",
            "dxDiagram-shapeTerminator": "\u0627\u0644\u0645\u0646\u0647\u064a",
            "dxDiagram-shapePredefinedProcess": "\u0639\u0645\u0644\u064a\u0629 \u0645\u062d\u062f\u062f\u0629 \u0645\u0633\u0628\u0642\u064b\u0627",
            "dxDiagram-shapeDocument": "\u0648\u062b\u064a\u0642\u0629",
            "dxDiagram-shapeMultipleDocuments": "\u0645\u0633\u062a\u0646\u062f\u0627\u062a \u0645\u062a\u0639\u062f\u062f\u0629",
            "dxDiagram-shapeManualInput": "\u0625\u062f\u062e\u0627\u0644 \u064a\u062f\u0648\u064a",
            "dxDiagram-shapePreparation": "\u062a\u062c\u0647\u064a\u0632",
            "dxDiagram-shapeData": "\u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a",
            "dxDiagram-shapeDatabase": "\u0642\u0627\u0639\u062f\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a",
            "dxDiagram-shapeHardDisk": "\u0627\u0644\u0642\u0631\u0635 \u0627\u0644\u0635\u0644\u0628",
            "dxDiagram-shapeInternalStorage": "\u0627\u0644\u062a\u062e\u0632\u064a\u0646 \u0627\u0644\u062f\u0627\u062e\u0644\u064a",
            "dxDiagram-shapePaperTape": "\u0634\u0631\u064a\u0637 \u0648\u0631\u0642\u064a",
            "dxDiagram-shapeManualOperation": "\u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u064a\u062f\u0648\u064a",
            "dxDiagram-shapeDelay": "\u062a\u0623\u062e\u064a\u0631",
            "dxDiagram-shapeStoredData": "\u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0645\u062e\u0632\u0646\u0629",
            "dxDiagram-shapeDisplay": "\u0639\u0631\u0636",
            "dxDiagram-shapeMerge": "\u062f\u0645\u062c",
            "dxDiagram-shapeConnector": "\u0645\u0648\u0635\u0644",
            "dxDiagram-shapeOr": "\u0627\u0648",
            "dxDiagram-shapeSummingJunction": "\u062a\u0644\u062e\u064a\u0635 \u0645\u0641\u0631\u0642",
            "dxDiagram-shapeContainerDefaultText": "\u062d\u0627\u0648\u064a\u0629",
            "dxDiagram-shapeVerticalContainer": "\u062d\u0627\u0648\u064a\u0629 \u0639\u0645\u0648\u062f\u064a\u0629",
            "dxDiagram-shapeHorizontalContainer": "\u062d\u0627\u0648\u064a\u0629 \u0623\u0641\u0642\u064a\u0629",
            "dxDiagram-shapeCardDefaultText": "\u0627\u0633\u0645 \u0627\u0644\u0634\u062e\u0635",
            "dxDiagram-shapeCardWithImageOnLeft": "\u0628\u0637\u0627\u0642\u0629 \u0628\u0647\u0627 \u0635\u0648\u0631\u0629 \u0639\u0644\u0649 \u0627\u0644\u064a\u0633\u0627\u0631",
            "dxDiagram-shapeCardWithImageOnTop": "\u0628\u0637\u0627\u0642\u0629 \u0645\u0639 \u0635\u0648\u0631\u0629 \u0641\u064a \u0627\u0644\u0623\u0639\u0644\u0649",
            "dxDiagram-shapeCardWithImageOnRight": "\u0628\u0637\u0627\u0642\u0629 \u0628\u0647\u0627 \u0635\u0648\u0631\u0629 \u0639\u0644\u0649 \u0627\u0644\u064a\u0645\u064a\u0646",
            "dxGantt-dialogTitle": "\u0639\u0646\u0648\u0627\u0646",
            "dxGantt-dialogStartTitle": "\u0628\u062f\u0627\u064a\u0629",
            "dxGantt-dialogEndTitle": "\u0627\u0644\u0646\u0647\u0627\u064a\u0629",
            "dxGantt-dialogProgressTitle": "\u0627\u0644\u062a\u0642\u062f\u0645",
            "dxGantt-dialogResourcesTitle": "\u0627\u0644\u0645\u0648\u0627\u0631\u062f",
            "dxGantt-dialogResourceManagerTitle": "\u0625\u062f\u0627\u0631\u0629 \u0627\u0644\u0645\u0648\u0627\u0631\u062f",
            "dxGantt-dialogTaskDetailsTitle": "\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0647\u0645\u0629",
            "dxGantt-dialogEditResourceListHint": "\u062a\u062d\u0631\u064a\u0631 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0645\u0648\u0627\u0631\u062f",
            "dxGantt-dialogEditNoResources": "\u0644\u0627 \u062a\u0648\u062c\u062f \u0645\u0648\u0627\u0631\u062f",
            "dxGantt-dialogButtonAdd": "\u0623\u0636\u0641",
            "dxGantt-contextMenuNewTask": "\u0645\u0647\u0645\u0629 \u062c\u062f\u064a\u062f\u0629",
            "dxGantt-contextMenuNewSubtask": "\u0645\u0647\u0645\u0629 \u0641\u0631\u0639\u064a\u0629 \u062c\u062f\u064a\u062f\u0629",
            "dxGantt-contextMenuDeleteTask": "\u062d\u0630\u0641 \u0627\u0644\u0645\u0647\u0645\u0629",
            "dxGantt-contextMenuDeleteDependency": "\u062d\u0630\u0641 \u0627\u0644\u062a\u0628\u0639\u064a\u0629",
            "dxGantt-dialogTaskDeleteConfirmation": "\u064a\u0624\u062f\u064a \u062d\u0630\u0641 \u0645\u0647\u0645\u0629 \u0623\u064a\u0636\u064b\u0627 \u0625\u0644\u0649 \u062d\u0630\u0641 \u0643\u0627\u0641\u0629 \u062a\u0628\u0639\u064a\u0627\u062a\u0647\u0627 \u0648\u0645\u0647\u0627\u0645\u0647\u0627 \u0627\u0644\u0641\u0631\u0639\u064a\u0629. \u0647\u0644 \u062a\u0631\u064a\u062f \u0628\u0627\u0644\u062a\u0623\u0643\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0647 \u0627\u0644\u0645\u0647\u0645\u0629\u061f",
            "dxGantt-dialogDependencyDeleteConfirmation": "\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0627\u0644\u062a\u0628\u0639\u064a\u0629 \u0645\u0646 \u0627\u0644\u0645\u0647\u0645\u0629\u061f",
            "dxGantt-dialogResourcesDeleteConfirmation": "\u064a\u0624\u062f\u064a \u062d\u0630\u0641 \u0627\u0644\u0645\u0648\u0631\u062f \u0623\u064a\u0636\u064b\u0627 \u0625\u0644\u0649 \u062d\u0630\u0641\u0647 \u0645\u0646 \u0627\u0644\u0645\u0647\u0627\u0645 \u0627\u0644\u062a\u064a \u062a\u0645 \u062a\u0639\u064a\u064a\u0646 \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u0631\u062f \u0644\u0647\u0627. \u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0647 \u0627\u0644\u0645\u0648\u0627\u0631\u062f\u061f \u0627\u0644\u0645\u0648\u0631\u062f: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "\u0627\u0644\u0645\u0647\u0645\u0629 \u0627\u0644\u062a\u064a \u062a\u062d\u0627\u0648\u0644 \u0646\u0642\u0644\u0647\u0627 \u0645\u0631\u062a\u0628\u0637\u0629 \u0628\u0645\u0647\u0645\u0629 \u062b\u0627\u0646\u064a\u0629 \u0628\u0639\u0644\u0627\u0642\u0629 \u062a\u0628\u0639\u064a\u0629. \u0642\u062f \u064a\u062a\u0639\u0627\u0631\u0636 \u0647\u0630\u0627 \u0627\u0644\u062a\u063a\u064a\u064a\u0631 \u0645\u0639 \u0642\u0648\u0627\u0639\u062f \u0627\u0644\u062a\u0628\u0639\u064a\u0629. \u0643\u064a\u0641 \u062a\u0631\u064a\u062f \u0627\u0644\u0645\u062a\u0627\u0628\u0639\u0629\u061f",
            "dxGantt-dialogConstraintViolationMessage": "\u0627\u0644\u0645\u0647\u0645\u0629 \u0627\u0644\u062a\u064a \u062a\u062d\u0627\u0648\u0644 \u0646\u0642\u0644\u0647\u0627 \u0645\u0631\u062a\u0628\u0637\u0629 \u0628\u0645\u0647\u0645\u0629 \u062b\u0627\u0646\u064a\u0629 \u0628\u0639\u0644\u0627\u0642\u0629 \u062a\u0628\u0639\u064a\u0629. \u0643\u064a\u0641 \u062a\u0631\u064a\u062f \u0627\u0644\u0645\u062a\u0627\u0628\u0639\u0629\u061f",
            "dxGantt-dialogCancelOperationMessage": "\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0639\u0645\u0644\u064a\u0629",
            "dxGantt-dialogDeleteDependencyMessage": "\u062d\u0630\u0641 \u0627\u0644\u062a\u0628\u0639\u064a\u0629",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "\u0627\u0646\u0642\u0644 \u0627\u0644\u0645\u0647\u0645\u0629 \u0648\u0627\u062d\u062a\u0641\u0638 \u0628\u0627\u0644\u062a\u0628\u0639\u064a\u0629",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "\u062a\u0631\u0627\u062c\u0639",
            "dxGantt-redo": "\u0625\u0639\u0627\u062f\u0629",
            "dxGantt-expandAll": "\u062a\u0648\u0633\u064a\u0639 \u0627\u0644\u0643\u0644",
            "dxGantt-collapseAll": "\u0627\u0646\u0647\u064a\u0627\u0631 \u062c\u0645\u064a\u0639",
            "dxGantt-addNewTask": "\u0625\u0636\u0627\u0641\u0629 \u0645\u0647\u0645\u0629 \u062c\u062f\u064a\u062f\u0629",
            "dxGantt-deleteSelectedTask": "\u062d\u0630\u0641 \u0627\u0644\u0645\u0647\u0645\u0629 \u0627\u0644\u0645\u062d\u062f\u062f\u0629",
            "dxGantt-zoomIn": "\u062a\u0643\u0628\u064a\u0631",
            "dxGantt-zoomOut": "\u062a\u0635\u063a\u064a\u0631",
            "dxGantt-fullScreen": "\u0645\u0644\u0621 \u0627\u0644\u0634\u0627\u0634\u0629",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sort Ascending",
            "dxGantt-sortingDescendingText": "Sort Descending",
            "dxGantt-sortingClearText": "Clear Sorting",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}"
        }
    })
}));
