create table QSU_TEMPLATES
(
  SURVEYTEMPID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SURVEYTETYPE         int             not null,
  SURVEYTTITLE         varchar(100)    not null,
  SURVEYWELCOM         varchar(500)    not null,
  SURVEYACTIVE         int             constraint DFD1D3C470D98744C384C06A53D666635B default -1 not null,
  SURVEYTHANKS         varchar(500)    not null,
  SURVEYANONYM         int             constraint DFBC096F8373CA415C889F6287158863BA default 0 not null,
  SURCREDATTIM         datetime        constraint DFD44AACF9B42C4E2ABE32AA8D271CF680 default '19991231 15:00:30' not null,
  SURVECREATBY         char(20)       ,
  SURLASMODATI         datetime       ,
  SURVLASMODBY         char(20)       ,
  SURVAUTHLEVE         int             constraint DF7F5B76FA9774485281C1EF5FBD28E2BA default 0 not null,
  SURVEVALNOTE         varchar(5000)  ,
  SUALEVFOEASU         int             constraint DF3596D7F3309E40DB8392997F89E09F48 default 0 not null,
  SURVINTENAME         varchar(100)   ,
  SURVEYTEMPLA         int             constraint DFBB9AFBB76F1C418BAF4071CDC2D4330C default 0 not null,
  SURVREVINUMB         int            ,
  SURVRELEDATE         datetime       ,
  SURVREVINOTE         varchar(1000)  ,
  SURKIORESINT         int             not null,
  SURKIOIDLINT         int             not null,
  SURKIOENARES         int             constraint DF803762ADBC9E44DFBCC71782D44B1CFF default -1 not null,
  SURKIOENIDDE         int             constraint DFB3DF697723DB46558234681DF1FAF545 default -1 not null,
  SURVEMAIBODY         varchar(max)   
) 
alter table QSU_TEMPLATES add constraint QSU_TEMPLATES_PK primary key (SURVEYTEMPID)
GO

create table QSU_QUESTIONS
(
  QUESTIONID           char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  QUESTSURVEID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  QUESTIQUEST1         int             not null,
  QUESTISEQUEN         int             not null,
  QUESTIACTIVE         int             constraint DF219A90D4A23E4E779CF49F3CEC43F2D2 default -1 not null,
  QUESTIQUESTI         varchar(200)    not null,
  QUESTIWEIGHT         int             not null,
  QUESTIOOWNER         int             constraint DF322C9B3CC75B44D58E9B208186E56B1B default 1 not null,
  QUESTIMANDAT         int             constraint DF4B786615EBC44BEEA1C6EF1A3E1A72B6 default -1 not null,
  QUESTITEMPLA         int             constraint DFB7738A77AF0C4E0DB29A21A725BA1967 default 0 not null
) 
alter table QSU_QUESTIONS add constraint QSU_QUESTIONS_PK primary key (QUESTIONID)
GO

create table QSU_POSSIBLE_ANSWERS
(
  POSSIBLEANID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  POSSIBLETEXT         varchar(200)    not null,
  POSSIBLVALUE         int             not null,
  POSSIBSEQUEN         int             not null,
  POSSIBACTIVE         int             constraint DF704A3B96E57E4A0A9700F6B2A5873558 default -1 not null,
  POSSIQUESTID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  POSSIBTEMPLA         int             constraint DF171E802D8FC748178AC8C5448C3E5D86 default 0 not null
)
alter table QSU_POSSIBLE_ANSWERS add constraint QSU_POSSIBLE_ANSWERS_PK primary key (POSSIBLEANID)
GO

create table QSU_SURVEYS
(
  SURVEYID             char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SURVESURVEID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SURVEYDATETI         datetime        not null,
  SURVERECIOLD         int            ,
  SURVEYSUBMIT         datetime       ,
  SURVEYRESULT         int            ,
  SURVEYNOTES          varchar(5000)  ,
  SURVEEDITIID         char(20)        collate SQL_Latin1_General_CP850_BIN,
  SURVERECIPID         char(20)        collate SQL_Latin1_General_CP850_BIN,
  SURVLASTREMA         datetime       
)
alter table QSU_SURVEYS add constraint QSU_SURVEYS_PK primary key (SURVEYID)
GO

create table QSU_ANSWERS
(
  ANSWERID             char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  ANSWESURVEID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  ANSWERTEXTAN         varchar(1000)  ,
  ANSWEPOSSIID         char(20)        collate SQL_Latin1_General_CP850_BIN,
  ANSWEQUESTID         char(20)        collate SQL_Latin1_General_CP850_BIN not null
)
alter table QSU_ANSWERS add constraint QSU_ANSWERS_PK primary key (ANSWERID) 
GO

create table QSU_DATE_ANSWERS
(
  DATEANSWERID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  DATEANSWER           datetime        not null
)
alter table QSU_DATE_ANSWERS add constraint QSU_DATE_ANSWERS_PK primary key (DATEANSWERID) 
GO

create table QSU_INTEGER_ANSWERS
(
  INTEGANSWEID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  INTEGEANSWER         int             not null
)
alter table QSU_INTEGER_ANSWERS add constraint QSU_INTEGER_ANSWERS_PK primary key (INTEGANSWEID)
GO

create table QSU_TEXT_ANSWERS
(
  TEXTANSWERID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  TEXTANSWTEXT         varchar(1000)  
)
alter table QSU_TEXT_ANSWERS add constraint QSU_TEXT_ANSWERS_PK primary key (TEXTANSWERID)
GO

create table QSU_MULTIPLE_CHOICE_ANSWERS
(
  MULTCHOANSID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  MULCHOANPOID         char(20)        collate SQL_Latin1_General_CP850_BIN
)
alter table QSU_MULTIPLE_CHOICE_ANSWERS add constraint QSU_MULTIPLE_CHOICE_ANSWERS_PK primary key (MULTCHOANSID)
GO
create table QSU_RESULT_CRITERIA
(
  RESULTCRITID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  RESULSURVEID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  RESULTCRIMIN         int             not null,
  RESULTCRIMAX         int             not null,
  RESULTDESCRI         varchar(100)    not null,
  RESULTCNOTES         varchar(250)   ,
  RESULTCCOLOR         int             constraint DF2798BD9E507D4184A5D55885C50BFE6A default 0 not null,
  RESULDECISID         char(20)        collate SQL_Latin1_General_CP850_BIN,
  RESULTTEMPLA         int             constraint DF0EDE8CB76F7745BEB9EFEF056E74AF6F default 0 not null
)
alter table QSU_RESULT_CRITERIA add constraint QSU_RESULT_CRITERIA_PK primary key (RESULTCRITID)
GO



create table QSU_DECISIONS
(
  DECISIONID           char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  DECISIDESCRI         varchar(100)    not null,
  DECISISEQUEN         int             not null,
  DECISIACTIVE         int             constraint DFF0802D1C1A1940F28C565CF26BF25DC5 default -1 not null,
  DECISITEMPLA         int             constraint DF94A0E05588AA4EFE8B7868938AA947FF default 0 not null
)
alter table QSU_DECISIONS add constraint QSU_DECISIONS_PK primary key (DECISIONID)
GO

create table QSU_DECISION_LINKS
(
  SURVDECLINID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SURDECLISUID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SURDECLIDEID         char(20)        collate SQL_Latin1_General_CP850_BIN not null
)
alter table QSU_DECISION_LINKS add constraint QSU_DECISION_LINKS_PK primary key (SURVDECLINID)
GO

create table QSU_TEMPLATE_DECISION_LINKS
(
  SURTEMDELIID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SUTEDELISUID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SUTEDELIDEID         char(20)        collate SQL_Latin1_General_CP850_BIN not null
)
alter table QSU_TEMPLATE_DECISION_LINKS add constraint QSU_TEMPLATE_DECISION_LINKS_PK primary key (SURTEMDELIID) 
GO

create table QSU_EDITIONS
(
  SURVEEDITIID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SURVEDISURID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  SURVEDITACTI         int             constraint DF50BEA2EE1A704B73AB3DC861C886C826 default -1 not null,
  SURVEDITTITL         varchar(150)    not null,
  SURVEDITDATE         datetime        not null,
  SURVEDITNOTE         varchar(5000)  
)
alter table QSU_EDITIONS add constraint QSU_EDITIONS_PK primary key (SURVEEDITIID)
GO

create table QSU_RECIPIENTS
(
  RECIPIENTID          char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  RECIPIENTYPE         varchar(50)     not null,
  RECIPQUALIID         int             not null
)
alter table QSU_RECIPIENTS add constraint QSU_RECIPIENTS_PK primary key (RECIPIENTID)
GO

create table QSU_PLANS
(
  PLANID               char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  PLANACTIVE           int             constraint DF252D104118434FCFB49B9E7FEF9DC3A5 default -1 not null,
  PLANSURVEYID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  PLANDISTRIBU         int             not null,
  PLANNOTES            varchar(5000)  ,
  PLANLASTSUBM         datetime       ,
  PLANNEXTSUBM         datetime       ,
  PLANTEMPEXPR         varchar(1000)  ,
  PLANTITLE            varchar(50)    ,
  PLACREDATTIM         datetime        constraint DF55C61261863B492BB655DF9A96DED847 default '19991231 15:00:30' not null,
  PLANCREATEBY         char(20)       ,
  PLALASMODATI         datetime       ,
  PLANLASMODBY         char(20)       ,
  PLANAUTHLEVE         int             constraint DFEC36A0BFB7CB43D385AB4883C7625677 default 0 not null
)
alter table QSU_PLANS add constraint QSU_PLANS_PK primary key (PLANID)
GO

create table QSU_SYNC_SETTINGS
(
  SYNCSETTINGID        varchar(20)     not null constraint QSUSYNCSETTINGSSYNCSETTINGID check (SYNCSETTINGID = 'UNIQUE'),
  SYNCSETTINSERVERMODE int             not null,
  SYNCSETTISYNCSERVURL varchar(150)   ,
  SYNCSETTILASTSYNCEON datetime       
)
alter table QSU_SYNC_SETTINGS add constraint QSU_SYNC_SETTINGS_PK primary key (SYNCSETTINGID)
GO

create table QSU_REVISIONS
(
  REVISIONID           char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  REVISSURVEID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  REVISINUMBER         int             not null,
  REVISIONDATE         datetime        not null,
  REVISIONOTES         varchar(1000)  
)
alter table QSU_REVISIONS add constraint QSU_REVISIONS_PK primary key (REVISIONID)
GO

create table QSU_TRANSLATION
(
  TRANSLATIOID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  TRANSLLANGUA         varchar(3)      not null,
  TRANORISTRID         char(20)        collate SQL_Latin1_General_CP850_BIN not null,
  TRANSLATION1         varchar(max)   ,
  TRANSPECPROP         varchar(50)    
)
alter table QSU_TRANSLATION add constraint QSU_TRANSLATION_PK primary key (TRANSLATIOID)
GO
alter table QSU_POSSIBLE_ANSWERS add constraint POSSIBQUESTI foreign key (POSSIQUESTID) references QSU_QUESTIONS on delete cascade
GO
alter table QSU_SURVEYS add constraint SURVEYSURVEY foreign key (SURVESURVEID) references QSU_TEMPLATES 
GO
alter table QSU_SURVEYS add constraint SURVEYEDITI1 foreign key (SURVEEDITIID) references QSU_EDITIONS
GO
alter table QSU_SURVEYS add constraint SURVEYRECIPI foreign key (SURVERECIPID) references QSU_RECIPIENTS on delete cascade 
GO
alter table QSU_ANSWERS add constraint ANSWERSURVEY foreign key (ANSWESURVEID) references QSU_SURVEYS on delete cascade 
GO
alter table QSU_ANSWERS add constraint ANSWERPOSSIB foreign key (ANSWEPOSSIID) references QSU_POSSIBLE_ANSWERS 
GO
alter table QSU_ANSWERS add constraint ANSWERQUESTI foreign key (ANSWEQUESTID) references QSU_QUESTIONS  
GO
alter table QSU_DATE_ANSWERS add constraint DATEANSWER foreign key (DATEANSWERID) references QSU_ANSWERS 
GO
alter table QSU_INTEGER_ANSWERS add constraint INTEGEANSWE1 foreign key (INTEGANSWEID) references QSU_ANSWERS  
GO
alter table QSU_TEXT_ANSWERS add constraint TEXTANSWER foreign key (TEXTANSWERID) references QSU_ANSWERS  
GO
alter table QSU_MULTIPLE_CHOICE_ANSWERS add constraint MULTCHOIANS1 foreign key (MULTCHOANSID) references QSU_ANSWERS 
GO
alter table QSU_MULTIPLE_CHOICE_ANSWERS add constraint MULCHOANSPOS foreign key (MULCHOANPOID) references QSU_POSSIBLE_ANSWERS 
GO
alter table QSU_RESULT_CRITERIA add constraint RESULTSURVEY foreign key (RESULSURVEID) references QSU_TEMPLATES on delete cascade
GO
alter table QSU_RESULT_CRITERIA add constraint RESULTDECISI foreign key (RESULDECISID) references QSU_DECISIONS  
GO
alter table QSU_DECISION_LINKS add constraint SURDECLINSUR foreign key (SURDECLISUID) references QSU_SURVEYS on delete cascade 
GO
alter table QSU_DECISION_LINKS add constraint SURDECLINDEC foreign key (SURDECLIDEID) references QSU_DECISIONS 
GO
alter table QSU_TEMPLATE_DECISION_LINKS add constraint SURTEMDELIDE foreign key (SUTEDELIDEID) references QSU_DECISIONS  
GO
alter table QSU_EDITIONS add constraint SURVEDITSURV foreign key (SURVEDISURID) references QSU_TEMPLATES on delete cascade
GO
alter table QSU_PLANS add constraint PLANSURVEYTE foreign key (PLANSURVEYID) references QSU_TEMPLATES 
GO
alter table QSU_REVISIONS add constraint REVISISURVEY foreign key (REVISSURVEID) references QSU_TEMPLATES  
GO