/*

  -------------------.-.--------------------
  Diagram Wrapper for INDE 23 for Fluid
                  02/05/2024
  ------------------------------------------
  
*/
let indeID = ""
Client.Diagram = function (element, parent, view)
{
  Client.Element.call(this, element, parent, view);
  if(Client.Diagram.inited && element.configuration && element.id){
    /*
      If the diagram was previously drawn we destroy the instance to create a new one
    */
    if (this.diagram_instance) {
      this.diagram_instance.destroy();
    }
      
    // read the Configuration shared by INDE
    let configuration = element.configuration
    let diagram_name = configuration.diagram_name;
    let custom_shapes = configuration.custom_shapes;
    let diagram_content = configuration.diagram_content;
    let main_toolbar = configuration.main_toolbar;
    let toolbox = configuration.toolbox;
    let context_toolbox = configuration.context_toolbox;
    let view_toolbar = configuration.view_toolbar;

    this.id = element.id;
    this.indeFormIndex = configuration.indeFormIndex;
    indeID = this.indeFormIndex
    
    DevExpress.localization.locale(navigator.language);

    let diagramDiv = document.createElement("div");
    diagramDiv.id = `diagram_${indeID}`;
    parent.appendChildObject(this, diagramDiv);
    let selector = `#${diagramDiv.id}`;
    this.diagram_instance_div = diagramDiv;

    // Inde framework FE needs it
    this.domObj = diagramDiv;

    $(selector).dxDiagram({
      export: {fileName: diagram_name},
      contextMenu: {
        enabled: true,
        commands: ['bringToFront', 'sendToBack', 'lock', 'unlock'],
      },
      customShapes: custom_shapes,
      contextToolbox: context_toolbox,

      historyToolbar: {
        visible: true,
      },

      viewToolbar: view_toolbar,
      
      mainToolbar: main_toolbar,
      
      toolbox: toolbox,
      
      /*
        events handling
      */
      onRequestEditOperation: function(event) {
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"RequestEditOperation",content: "${event}"}`);
      },

      onItemClick: function(data) {
        // handle the click on a wkf node
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"ItemClick",content: "${[data.item]}"}`);
      },
    });
                      
    /*
      Store the dxDiagram instance into this.diagram_instance
    */
    this.diagram_instance = $(selector).dxDiagram("instance");
    this.diagram_instance_div = diagramDiv
    this.attachEvents(element.events);

    if(diagram_content){
      this.diagram_instance.import(diagram_content, false);
    }
  }
  else {
    Client.Diagram.Realize = parent;
    this.diagram_instance_rendered = false
    return;
  }
  
  
};

 


// Inheriting properties from Client.Element
Client.Diagram.prototype = new Client.Element();
Client.Diagram.eventProperties = ["id"] 

/*
  Manage the Requirements of this Class Scheduler (so the requirements for dxScheduler to be instantiated)
  In this case I put the required files directly in the DesktopFluid.html template
*/
Client.Diagram.getRequirements = function ()
{
  Client.Diagram.inited = true;
  return {};
};


/*
  Destroy the diagram instance and remove the Div that has contained the diagram
*/
Client.Diagram.prototype.close = function (firstLevel, triggerAnimation)
{
  if (this.diagram_instance){this.diagram_instance.dispose();}
  delete this.diagram_instance;
  if(this.diagram_instance_div && this.diagram_instance_div.parentNode){this.diagram_instance_div.parentNode.removeChild(this.diagram_instance_div);}
  if(this.diagram_instance_div){delete this.diagram_instance_div;}
}



// this procedure delete an Appointment from the dxDiagram
Client.Diagram.prototype.checkdatasource = function() {
  console.log(this.diagram._dataSource._items);
}
 
Client.Diagram.prototype.exportJson = function (){
  var jsonString = this.diagram.export();
  this.SendEvent("export", [jsonString]);
}
 
Client.Diagram.prototype.importJson = function (json){
    var jsonToImport = json;
    this.diagram.import(jsonToImport, false);
}
 
Client.Diagram.prototype.printwkf = function (){
  var imageString = "";
  const ff = function() {
    this.SendEvent("print", [imageString]);
  };
    this.diagram.exportTo('svg', ff);
}


// this procedure changes language of this scheduler
Client.Diagram.prototype.setLocale = function(localeString) {
  if(localeString) {
    DevExpress.localization.locale(localeString);
  }
}
