const data = [];

function IDdxScheduler(pform)
{
  CustomElement.call(this, pform);
}

IDdxScheduler.prototype = new CustomElement();

IDdxScheduler.Init = function() {
  if(IDdxScheduler.inited){
    return
  }
  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/css/customIDDxScheduler.css", "CSS")
  IDdxScheduler.inited = true;
}

IDdxScheduler.Init();

Object.defineProperty(IDdxScheduler.prototype, "options", {
  get: function () {
    return this.options;
  },
  set: function (value) {
    if (this.calendar) {
      var opt = (typeof value === String ? JSON.parse(value) : value);
      var keys = Object.keys(opt);
        for (var i = 0; i < keys.length; i++)
          this.calendar.setOption(prop, opt[prop]);
    }
    else
      this._options = value;
  }
});


IDdxScheduler.prototype.Realize = function (parent, cls) {
  //
  if(!IDdxScheduler.inited) {
    IDdxScheduler.Realize = parent;
    return;
  }
  //
  CustomElement.prototype.Realize.call(this, parent, cls);
  var pthis = this;
  
  this.calendarDiv = document.createElement("div");
  this.calendarDiv.setAttribute("id","myScheduler");
  parent.appendChild(this.calendarDiv);

  if (this.calendar) {
    this.calendar.destroy();
  }
  
  window.setTimeout( function () {
    var pthis = this;
    DevExpress.localization.locale(navigator.language);
    $('#myScheduler').dxScheduler({
        dataSource: data,
        groups: ['employeeID', 'type'],
        cellDuration: 15,
        resources: [
          {
            fieldExpr: 'employeeID',
            allowMultiple: true,
            dataSource: [{}],
            label: 'Employee',
          },
        ],
        

        timeCellTemplate(itemData, itemIndex, itemElement) {
          const element = $(`<div>${itemData.text}</div>`);
          const { date } = itemData;
          element.append('<div class="cafe" />');
          return itemElement.append(element);
        },
        
        onAppointmentAdded: function(event) {
          if(event)
            pthis.SendEvent("AppointmentAdded", [event.appointmentData]);
        }, 

        onAppointmentAdding: function(event) {
          if(event)
            pthis.SendEvent("AppointmentAdding", [event.appointmentData]);
        }, 

        onAppointmentClick: function(event) {
          if(event){
            event.cancel = true;
            pthis.SendEvent("AppointmentClick", [event.appointmentData]);
          }
        }, 

        onAppointmentContextMenu: function(event) {
          if(event)
            pthis.SendEvent("AppointmentContextMenu", [event.appointmentData]);
        }, 

        // double click on event
        onAppointmentDblClick: function(event) {
          if(event){
            event.cancel = true;
            pthis.SendEvent("AppointmentDblClick", [event.appointmentData]);
          }           
        }, 

        onAppointmentDeleted: function(event) {
          if(event)
            pthis.SendEvent("AppointmentDeleted", [event.appointmentData]);
        }, 

        onAppointmentDeleting: function(event) {
          if(event)
            pthis.SendEvent("AppointmentDeleting", [event.appointmentData]);
        }, 

        onAppointmentFormOpening: function(event) {
          if(event)
            pthis.SendEvent("AppointmentFormOpening", [event.appointmentData]);
        }, 

        onAppointmentRendered: function(event) {
          if(event){
            // color is a custom property we defined in INDE: it is a String like #FFFFFF
            if(event.appointmentData.color){
              event.appointmentElement[0].style.backgroundColor = event.appointmentData.color;
            }
            pthis.SendEvent("AppointmentRendered", [event.appointmentData]);
          }
        },

        onAppointmentUpdated: function(event) {
          if(event)
            pthis.SendEvent("AppointmentUpdated", [event.appointmentData]);
        }, 
        onAppointmentUpdating: function(event) {
          if(event){
            if(event.oldData.editable){
              pthis.SendEvent("AppointmentUpdating", [event.oldData, event.newData]);
            }
            else{
              event.cancel = true;
            }
          }
        }, 
        onCellClick: function(event) {
          if(event)
            pthis.SendEvent("CellClick", [event.cellData]);
        }, 
        onCellContextMenu : function(event) {
          if(event)
            pthis.SendEvent("CellContextMenu", [event.cellData]);
        }, 
        onContentReady  : function(event) {
          if(event)
            pthis.SendEvent("ContentReady", [event.element]);
        },
        onDisposing: function(info) {
          if(info)
            pthis.SendEvent("Disposing ", [info.value]);
        },
        onInitialized: function(info) {
          if(info)
            pthis.SendEvent("Initialized", [info.element]);
        },
        onOptionChanged: function(data) {
          if(data.name == "currentDate") {
            pthis.SendEvent("CurrentDateChanged", [data.name, data.value]);
          }
        },

        appointmentTooltipTemplate(data) {
          eventData = data.targetedAppointmentData;
          return $(`${"<div class='event-tooltip' style='font-size: 10px !important;'>"
                          + "<img width='20' height='20' src='"}${eventData.image}' />`
                          + '<div class=\'event-info\'>'
                              + `<div class='event-title'>${eventData.text}` + '</div>'
                              + '<div>' + `Type: ${eventData.type}</div>`
                              + '<div>' + `Descrizione: ${eventData.description}` + '</div>'
                              + `<button class="btn info" onclick="test('1','${eventData.ID}')">FAI QUALCOSA</button>`
                          + '</div>'
                      + '</div>');
        },


        appointmentTemplate(data) {
          const eventData = data.targetedAppointmentData;
          return $(`${"<div class='showtime-preview' style='font-size: 10px !important;'>" 
                            + "<img width='20' height='20' src='"}${eventData.image}'/>`
                            + `<span style="white-space: break-spaces; height: auto;"><strong>${eventData.text}</strong></span>`
                            + `<div style="white-space: break-spaces; height: auto;">Type: ${eventData.type}`
                            + '</div>'
                            + `<div style="white-space: break-spaces; height: auto;">${eventData.description}</div>`
                            + '</div>' + `<button style="color: blue !important;" class="btn info" onclick="customButtonCommand('1','${eventData.ID}')">CLICCAMI</button>`
                        + '</div>');
        },

        dataCellTemplate(cellData, index, container) {
          const hours = cellData.startDate.getHours();
          if(hours > 12 && hours  <= 13){
            container.css('background-color', '#f5f5c9');
          }
          const day = cellData.startDate.getDay();
          if(day == 0 || day == 6){
            container.css('background-color', '#ededed');
          }
        return container;
        },
       
      
        resourceCellTemplate(cellData) {
          const avatarAndName = $('<div>')
          .addClass('resources')
          .css({ backgroundColor: cellData.color })
          // uncomment the code below to show the avatar of the resources 
          //.append($('<span>')
          // .html(`<img src=${cellData.data.avatar}>`))
          .append($('<span>')
            .text(cellData.text));
          
          return $('<div>').append([avatarAndName]);
        },

        dateCellTemplate(itemData, itemIndex, itemElement) {
          const dateHeaderContent = $(`<div>${itemData.text}</div>`);
          const actualDay = itemData.date.getDay();
          const isWekeendCheck = actualDay == 0 || actualDay == 6;
          if (isWekeendCheck) {
            itemElement.css('backgroundColor', '#ededed');
          }
          itemElement.css('font-weight', 600);
          itemElement.append(dateHeaderContent);
          return itemElement;
        },

        timeCellTemplate(itemData, itemIndex, itemElement) {
          const element = $(`<div>${itemData.text}</div>`);
          const { date } = itemData;
          const hours = date.getHours();
          if (hours >= 12 && hours < 13) {
            itemElement.css('font-color', 'rgb(242, 245, 188 / 40%');
          }
          const minutes = date.getMinutes();
          return itemElement.append(element);
        },
        
      });
       
      function isWeekEnd(date) {
        const day = date.getDay();
        return day === 0 || day === 6;
      }
    
      function getCurrentTraining(date, employeeID) {
        const result = (date + employeeID) % 3;
        const currentTraining = `training-background-${result}`;
    
        return currentTraining;
      }
        
    this.calendar = $('#myScheduler').dxScheduler("instance");
  }.bind(this), 350);

  this.calendar = $('#myScheduler').dxScheduler("dispose");
}

// custom procedure to udpate the dxScheduler Configuration
// from inde: USE an IDMAP that will be decoded in "data"
IDdxScheduler.prototype.updateConfiguration = function(data) {
  this.calendar = $('#myScheduler').dxScheduler(data);
}

// this procedure adds an Appointment in the dxScheduler
// from inde: USE an IDMAP in which store  text, employeeID, startDate and endDate
// to avoid inserting 2 times the same event, before inserting the event in the calendar we check if already exists 
IDdxScheduler.prototype.addEvent = function(data) {
  searchEvent = IDdxScheduler.prototype.findEvent(this.calendar._dataSource._items, data);
  if(!searchEvent){
    this.calendar.addAppointment (data);
  }
}

IDdxScheduler.prototype.findEvent = function(datasource, data) {
  if(data){
    if(data.ID){
      searchedID = data.ID
      dataSourceLenght = datasource.length;
      for(i = 0; i < dataSourceLenght; i++){
        if(datasource[i]){
          currentID = datasource[i].ID;
          if(currentID == searchedID){
            return datasource[i];
          }
        }
      }
    }
  }
}


// this procedure delete an Appointment from the dxScheduler
IDdxScheduler.prototype.deleteEvent = function(data) {
  if(data){
    if(data.ID){
      var foundEvent = IDdxScheduler.prototype.findEvent(this.calendar._dataSource._items, data);
      if(foundEvent){
        this.calendar.deleteAppointment(this.calendar._dataSource._items[i]);
      }
    }
  }
}

// this procedure changes the Options in the configuration IDdxScheduler 
IDdxScheduler.prototype.setOptions = function(options) {
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      oName = currentOption.name;
      oValue = currentOption.value;
      if(oName && oValue){
        this.calendar.option(oName, oValue);
      }
    }
  }
}

// this procedure changes language of this scheduler
IDdxScheduler.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

// this procedure delete an Appointment from the dxScheduler
IDdxScheduler.prototype.checkdatasource = function() {
 console.log(this.calendar._dataSource._items);
}

IDdxScheduler.prototype.Unrealize = function ()
{
  if (this.calendar)
    this.calendar.dispose();
  delete this.calendar;
  //
  if (this.calendarDiv.parentNode)
    this.calendarDiv.parentNode.removeChild(this.calendarDiv);
  delete this.calendarDiv;
}

/*
  Buttons js
*/
function customButtonCommand(buttonID,eventID){
  console.log("CLICCAMI has been pressed: "+ eventID);
  RD3_SendCommand("@button@button=" + buttonID + ";Event="+ eventID);
}