/*

  -------------------.-.--------------------
  dxGantt Wrapper for INDE 23 with Fluid
  ------------------------------------------
  
*/

Client.Gantt = function (element, parent, view)
{
  Client.Element.call(this, element, parent, view);

  if(!Client.Gantt.inited || !element.configuration.tasks || !element.id) {
    Client.Gantt.Realize = parent;
    this.gantt_rendered = false
    return;
  }
  
  /*
    If the Gantt was previously drawn we destroy the instance to create a new one
  */
  if (this.gantt) {
    this.gantt.destroy();
  }
    

  if(element.configuration.currentDate != null)
  {
    this.currentDate = element.configuration.focusOnDate;
  }
  else
  {
    this.currentDate = new Date();
  }

  this.configuration = element.configuration.configuration;
  this._tasks = element.configuration.tasks;
  this.indeFormIndex = element.configuration.indeFormIndex;
  this.indeID = element.configuration.indeFormIndex;
  let indeID = this.indeID
  this.id = element.id;
  
  /*
    Create the Div to put inside the dxGantt
  */
  this.domObj = document.createElement("div");
  this.domObj.id = `gantt_${this.indeID}`;
  parent.appendChildObject(this, this.domObj);
  this.ganttDiv = this.domObj;

  /*
    Draw the dxGantt inside the Div
  */
  this.ganttSelector = `#${this.domObj.id}`;
  DevExpress.localization.locale(navigator.language);
  $(this.ganttSelector).dxGantt({ 
    height: this.configuration.height,
    width: this.configuration.width,
    scaleType: this.configuration.scaleType,
    tasks: {
      dataSource: this._tasks,
      colorExpr: "taskColor",
    },
    showRowLines: true,
    firstDayOfWeek: 1,
    toolbar: this.configuration.toolbar,
    columns: [{
      allowFiltering: true,
      dataField: 'title',
      caption: 'Task',
      width: 300,
    }, {
      dataField: 'description',
      caption: 'Descrizione',
      width: 150,
    },],
    editing: this.configuration.editing,
    stripLines: this.configuration.stripLines,
    validation: {
      autoUpdateParentTasks: true,
    },
    taskListWidth: 500,
    taskTitlePosition: 'inside',
    onInitialized: function(info) {
      if(info){
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"initialized",content: ""}`);
      }
    },
    onTaskEditDialogShowing: function (e) {
      e.cancel = true;
    },
  });

  
  /*
    Store the dxGantt instance into this.gantt
  */
  this.gantt = $(this.ganttSelector).dxGantt("instance");
  this.sc_rendered = true;
  //this.attachEvents(element.events);

  setTimeout(function() {
    var ganttInstance = $(this.ganttSelector).dxGantt("instance");
    if(ganttInstance){
      var today = new Date();
      ganttInstance.scrollToDate(today);
    }
  }, 300);
};

// Define extension of class
Client.Gantt.prototype = new Client.Element();
Client.Gantt.eventProperties = ["id"] 

/*
  Manage the Requirements of this Class Gantt (so the requirements for dxGantt to be instantiated)
  In this case I put the required files directly in the DesktopFluid.html template
*/
Client.Gantt.getRequirements = function ()
{
  let prefix = Client.mainFrame.isIDF ? "fluid/" : "";
  let req = {};
  Client.Gantt.inited = true;
  return req;
};


/*
  Destroy the dxGantt instance and remove the Div that has contained the dxGantt
*/
Client.Gantt.prototype.close = function (firstLevel, triggerAnimation)
{
  if (this.gantt){this.gantt.dispose();}
  delete this.gantt;
  if(this.ganttDiv && this.ganttDiv.parentNode){this.ganttDiv.parentNode.removeChild(this.ganttDiv);}
  if(this.ganttDiv){delete this.ganttDiv;}
}

// custom procedure to udpate the dxGantt Configuration
// from inde: USE an IDMAP that will be decoded in "data"
Client.Gantt.prototype.updateConfiguration = function(data) {
  this.gantt = $(this.ganttSelector).dxGantt(data);
}

Client.Gantt.prototype.addTasks = function(taskInfo) {
  this.gantt.insertTask(taskInfo);
}


Client.Gantt.prototype.deleteTask = function(data) {
  if(data!=""){
    this.gantt.deleteTask(data);
  }
}

Client.Gantt.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}


// this procedure changes the Options in the configuration Gantt 
Client.Gantt.prototype.setOptions = function(options) {
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      if(currentOption != null){
        oName = currentOption.name;
        oValue = currentOption.value;
        if(oName && oValue){
         this.gantt.option(oName, oValue);
        }
      }
      
    }
  }
}

// this procedure delete an Appointment from the dxGantt
Client.Gantt.prototype.checkdatasource = function() {
  console.log(this.gantt._dataSource._items);
 }
 
// this procedure moves the focus of Gantt on the destinationDate passed as arg
Client.Gantt.prototype.focusOnToday = function() {
  var today = new Date();
  this.gantt.scrollToDate(today);
}