/*!
 * DevExtreme (dx.all.debug.js)
 * Version: 23.2.5
 * Build date: Mon Mar 11 2024
 *
 * Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function() {
    var __webpack_modules__ = {
        81589:
            /*!****************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/base_component.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __extends = this && this.__extends || (extendStatics = function(d, b) {
                    extendStatics = Object.setPrototypeOf || {
                        __proto__: []
                    }
                    instanceof Array && function(d, b) {
                        d.__proto__ = b
                    } || function(d, b) {
                        for (var p in b) {
                            if (Object.prototype.hasOwnProperty.call(b, p)) {
                                d[p] = b[p]
                            }
                        }
                    };
                    return extendStatics(d, b)
                }, function(d, b) {
                    if ("function" !== typeof b && null !== b) {
                        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null")
                    }
                    extendStatics(d, b);

                    function __() {
                        this.constructor = d
                    }
                    d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
                });
                var extendStatics;
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoWrapperComponent = exports.InfernoComponent = exports.BaseInfernoComponent = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var effect_host_1 = __webpack_require__( /*! ./effect_host */ 53213);
                var areObjectsEqual = function(firstObject, secondObject) {
                    var bothAreObjects = firstObject instanceof Object && secondObject instanceof Object;
                    if (!bothAreObjects) {
                        return firstObject === secondObject
                    }
                    var firstObjectKeys = Object.keys(firstObject);
                    var secondObjectKeys = Object.keys(secondObject);
                    if (firstObjectKeys.length !== secondObjectKeys.length) {
                        return false
                    }
                    var hasDifferentElement = firstObjectKeys.some((function(key) {
                        return firstObject[key] !== secondObject[key]
                    }));
                    return !hasDifferentElement
                };
                var BaseInfernoComponent = function(_super) {
                    __extends(BaseInfernoComponent, _super);

                    function BaseInfernoComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this._pendingContext = _this.context;
                        return _this
                    }
                    BaseInfernoComponent.prototype.componentWillReceiveProps = function(_, context) {
                        this._pendingContext = null !== context && void 0 !== context ? context : {}
                    };
                    BaseInfernoComponent.prototype.shouldComponentUpdate = function(nextProps, nextState) {
                        return !areObjectsEqual(this.props, nextProps) || !areObjectsEqual(this.state, nextState) || !areObjectsEqual(this.context, this._pendingContext)
                    };
                    return BaseInfernoComponent
                }(inferno_1.Component);
                exports.BaseInfernoComponent = BaseInfernoComponent;
                var InfernoComponent = function(_super) {
                    __extends(InfernoComponent, _super);

                    function InfernoComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this._effects = [];
                        return _this
                    }
                    InfernoComponent.prototype.createEffects = function() {
                        return []
                    };
                    InfernoComponent.prototype.updateEffects = function() {};
                    InfernoComponent.prototype.componentWillMount = function() {
                        effect_host_1.InfernoEffectHost.lock()
                    };
                    InfernoComponent.prototype.componentWillUpdate = function(_nextProps, _nextState, _context) {
                        effect_host_1.InfernoEffectHost.lock()
                    };
                    InfernoComponent.prototype.componentDidMount = function() {
                        var _this = this;
                        effect_host_1.InfernoEffectHost.callbacks.push((function() {
                            _this._effects = _this.createEffects()
                        }));
                        effect_host_1.InfernoEffectHost.callEffects()
                    };
                    InfernoComponent.prototype.componentDidUpdate = function() {
                        var _this = this;
                        effect_host_1.InfernoEffectHost.callbacks.push((function() {
                            return _this.updateEffects()
                        }));
                        effect_host_1.InfernoEffectHost.callEffects()
                    };
                    InfernoComponent.prototype.destroyEffects = function() {
                        this._effects.forEach((function(e) {
                            return e.dispose()
                        }))
                    };
                    InfernoComponent.prototype.componentWillUnmount = function() {
                        this.destroyEffects()
                    };
                    return InfernoComponent
                }(BaseInfernoComponent);
                exports.InfernoComponent = InfernoComponent;
                var InfernoWrapperComponent = function(_super) {
                    __extends(InfernoWrapperComponent, _super);

                    function InfernoWrapperComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this.vDomElement = null;
                        return _this
                    }
                    InfernoWrapperComponent.prototype.vDomUpdateClasses = function() {
                        var el = this.vDomElement;
                        var currentClasses = el.className.length ? el.className.split(" ") : [];
                        var addedClasses = currentClasses.filter((function(className) {
                            return el.dxClasses.previous.indexOf(className) < 0
                        }));
                        var removedClasses = el.dxClasses.previous.filter((function(className) {
                            return currentClasses.indexOf(className) < 0
                        }));
                        addedClasses.forEach((function(value) {
                            var indexInRemoved = el.dxClasses.removed.indexOf(value);
                            if (indexInRemoved > -1) {
                                el.dxClasses.removed.splice(indexInRemoved, 1)
                            } else {
                                el.dxClasses.added.push(value)
                            }
                        }));
                        removedClasses.forEach((function(value) {
                            var indexInAdded = el.dxClasses.added.indexOf(value);
                            if (indexInAdded > -1) {
                                el.dxClasses.added.splice(indexInAdded, 1)
                            } else {
                                el.dxClasses.removed.push(value)
                            }
                        }))
                    };
                    InfernoWrapperComponent.prototype.componentDidMount = function() {
                        var el = inferno_1.findDOMfromVNode(this.$LI, true);
                        this.vDomElement = el;
                        _super.prototype.componentDidMount.call(this);
                        el.dxClasses = el.dxClasses || {
                            removed: [],
                            added: [],
                            previous: []
                        };
                        el.dxClasses.previous = (null === el || void 0 === el ? void 0 : el.className.length) ? el.className.split(" ") : []
                    };
                    InfernoWrapperComponent.prototype.componentDidUpdate = function() {
                        _super.prototype.componentDidUpdate.call(this);
                        var el = this.vDomElement;
                        if (null !== el) {
                            el.dxClasses.added.forEach((function(className) {
                                return el.classList.add(className)
                            }));
                            el.dxClasses.removed.forEach((function(className) {
                                return el.classList.remove(className)
                            }));
                            el.dxClasses.previous = el.className.length ? el.className.split(" ") : []
                        }
                    };
                    InfernoWrapperComponent.prototype.shouldComponentUpdate = function(nextProps, nextState) {
                        var shouldUpdate = _super.prototype.shouldComponentUpdate.call(this, nextProps, nextState);
                        if (shouldUpdate) {
                            this.vDomUpdateClasses()
                        }
                        return shouldUpdate
                    };
                    return InfernoWrapperComponent
                }(InfernoComponent);
                exports.InfernoWrapperComponent = InfernoWrapperComponent
            },
        61080:
            /*!****************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/create_context.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __extends = this && this.__extends || (extendStatics = function(d, b) {
                    extendStatics = Object.setPrototypeOf || {
                        __proto__: []
                    }
                    instanceof Array && function(d, b) {
                        d.__proto__ = b
                    } || function(d, b) {
                        for (var p in b) {
                            if (Object.prototype.hasOwnProperty.call(b, p)) {
                                d[p] = b[p]
                            }
                        }
                    };
                    return extendStatics(d, b)
                }, function(d, b) {
                    if ("function" !== typeof b && null !== b) {
                        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null")
                    }
                    extendStatics(d, b);

                    function __() {
                        this.constructor = d
                    }
                    d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
                });
                var extendStatics;
                var __assign = this && this.__assign || function() {
                    __assign = Object.assign || function(t) {
                        for (var s, i = 1, n = arguments.length; i < n; i++) {
                            s = arguments[i];
                            for (var p in s) {
                                if (Object.prototype.hasOwnProperty.call(s, p)) {
                                    t[p] = s[p]
                                }
                            }
                        }
                        return t
                    };
                    return __assign.apply(this, arguments)
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createContext = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var contextId = 0;
                exports.createContext = function(defaultValue) {
                    var id = contextId++;
                    return {
                        id: id,
                        defaultValue: defaultValue,
                        Provider: function(_super) {
                            __extends(class_1, _super);

                            function class_1() {
                                return null !== _super && _super.apply(this, arguments) || this
                            }
                            class_1.prototype.getChildContext = function() {
                                var _a;
                                return __assign(__assign({}, this.context), (_a = {}, _a[id] = this.props.value || defaultValue, _a))
                            };
                            class_1.prototype.render = function() {
                                return this.props.children
                            };
                            return class_1
                        }(inferno_1.Component)
                    }
                }
            },
        43956:
            /*!********************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/effect.js ***!
              \********************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoEffect = void 0;
                var InfernoEffect = function() {
                    function InfernoEffect(effect, dependency) {
                        this.dependency = dependency;
                        this.effect = effect;
                        this.destroy = effect()
                    }
                    InfernoEffect.prototype.update = function(dependency) {
                        var currentDependency = this.dependency;
                        if (dependency) {
                            this.dependency = dependency
                        }
                        if (!dependency || dependency.some((function(d, i) {
                                return currentDependency[i] !== d
                            }))) {
                            this.dispose();
                            this.destroy = this.effect()
                        }
                    };
                    InfernoEffect.prototype.dispose = function() {
                        if (this.destroy) {
                            this.destroy()
                        }
                    };
                    return InfernoEffect
                }();
                exports.InfernoEffect = InfernoEffect
            },
        53213:
            /*!*************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/effect_host.js ***!
              \*************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoEffectHost = void 0;
                exports.InfernoEffectHost = {
                    lockCount: 0,
                    lock: function() {
                        this.lockCount++
                    },
                    callbacks: [],
                    callEffects: function() {
                        this.lockCount--;
                        if (this.lockCount < 0) {
                            throw new Error("Unexpected Effect Call")
                        }
                        if (0 === this.lockCount) {
                            var effects = this.callbacks;
                            this.callbacks = [];
                            effects.forEach((function(callback) {
                                return callback()
                            }))
                        }
                    }
                }
            },
        74219:
            /*!*******************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/index.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __createBinding = this && this.__createBinding || (Object.create ? function(o, m, k, k2) {
                    if (void 0 === k2) {
                        k2 = k
                    }
                    Object.defineProperty(o, k2, {
                        enumerable: true,
                        get: function() {
                            return m[k]
                        }
                    })
                } : function(o, m, k, k2) {
                    if (void 0 === k2) {
                        k2 = k
                    }
                    o[k2] = m[k]
                });
                var __exportStar = this && this.__exportStar || function(m, exports) {
                    for (var p in m) {
                        if ("default" !== p && !Object.prototype.hasOwnProperty.call(exports, p)) {
                            __createBinding(exports, m, p)
                        }
                    }
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                __exportStar(__webpack_require__( /*! ./base_component */ 81589), exports);
                __exportStar(__webpack_require__( /*! ./create_context */ 61080), exports);
                __exportStar(__webpack_require__( /*! ./effect */ 43956), exports);
                __exportStar(__webpack_require__( /*! ./effect_host */ 53213), exports);
                __exportStar(__webpack_require__( /*! ./portal */ 53159), exports);
                __exportStar(__webpack_require__( /*! ./ref_object */ 86687), exports);
                __exportStar(__webpack_require__( /*! ./re_render_effect */ 31620), exports);
                __exportStar(__webpack_require__( /*! ./mocked/hydrate */ 67604), exports);
                __exportStar(__webpack_require__( /*! ./render_template */ 32423), exports);
                __exportStar(__webpack_require__( /*! ./normalize_styles */ 73084), exports)
            },
        67604:
            /*!****************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/mocked/hydrate.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.hydrate = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var shared_1 = __webpack_require__( /*! ./shared */ 45786);

                function isSamePropsInnerHTML(dom, props) {
                    return Boolean(props && props.dangerouslySetInnerHTML && props.dangerouslySetInnerHTML.__html && function(dom, innerHTML) {
                        var tempdom = document.createElement("i");
                        tempdom.innerHTML = innerHTML;
                        return tempdom.innerHTML === dom.innerHTML
                    }(dom, props.dangerouslySetInnerHTML.__html))
                }

                function hydrateChildren(parentVNode, parentNode, currentNode, context, isSVG, lifecycle) {
                    var childFlags = parentVNode.childFlags;
                    var children = parentVNode.children;
                    var props = parentVNode.props;
                    var flags = parentVNode.flags;
                    if (1 !== childFlags) {
                        if (2 === childFlags) {
                            if (shared_1.isNull(currentNode)) {
                                inferno_1._M(children, parentNode, context, isSVG, null, lifecycle)
                            } else {
                                currentNode = hydrateVNode(children, parentNode, currentNode, context, isSVG, lifecycle);
                                currentNode = currentNode ? currentNode.nextSibling : null
                            }
                        } else if (16 === childFlags) {
                            if (shared_1.isNull(currentNode)) {
                                parentNode.appendChild(document.createTextNode(children))
                            } else if (1 !== parentNode.childNodes.length || 3 !== currentNode.nodeType) {
                                parentNode.textContent = children
                            } else if (currentNode.nodeValue !== children) {
                                currentNode.nodeValue = children
                            }
                            currentNode = null
                        } else if (12 & childFlags) {
                            var prevVNodeIsTextNode = false;
                            for (var i = 0, len = children.length; i < len; ++i) {
                                var child = children[i];
                                if (shared_1.isNull(currentNode) || prevVNodeIsTextNode && (16 & child.flags) > 0) {
                                    inferno_1._M(child, parentNode, context, isSVG, currentNode, lifecycle)
                                } else {
                                    currentNode = hydrateVNode(child, parentNode, currentNode, context, isSVG, lifecycle);
                                    currentNode = currentNode ? currentNode.nextSibling : null
                                }
                                prevVNodeIsTextNode = (16 & child.flags) > 0
                            }
                        }
                        if (0 === (8192 & flags)) {
                            var nextSibling = null;
                            while (currentNode) {
                                nextSibling = currentNode.nextSibling;
                                parentNode.removeChild(currentNode);
                                currentNode = nextSibling
                            }
                        }
                    } else if (!shared_1.isNull(parentNode.firstChild) && !isSamePropsInnerHTML(parentNode, props)) {
                        parentNode.textContent = "";
                        if (448 & flags) {
                            parentNode.defaultValue = ""
                        }
                    }
                }

                function hydrateText(vNode, parentDOM, dom) {
                    if (3 !== dom.nodeType) {
                        parentDOM.replaceChild(vNode.dom = document.createTextNode(vNode.children), dom)
                    } else {
                        var text = vNode.children;
                        if (dom.nodeValue !== text) {
                            dom.nodeValue = text
                        }
                        vNode.dom = dom
                    }
                    return vNode.dom
                }

                function hydrateVNode(vNode, parentDOM, currentDom, context, isSVG, lifecycle) {
                    var flags = vNode.flags |= 16384;
                    if (14 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, isClass, lifecycle) {
                            var type = vNode.type;
                            var ref = vNode.ref;
                            var props = vNode.props || inferno_1.EMPTY_OBJ;
                            var currentNode;
                            if (isClass) {
                                var instance = inferno_1._CI(vNode, type, props, context, isSVG, lifecycle);
                                var input = instance.$LI;
                                currentNode = hydrateVNode(input, parentDOM, dom, instance.$CX, isSVG, lifecycle);
                                inferno_1._MCCC(ref, instance, lifecycle)
                            } else {
                                input = inferno_1._HI(inferno_1._RFC(vNode, context));
                                currentNode = hydrateVNode(input, parentDOM, dom, context, isSVG, lifecycle);
                                vNode.children = input;
                                inferno_1._MFCC(vNode, lifecycle)
                            }
                            return currentNode
                        }(vNode, parentDOM, currentDom, context, isSVG, (4 & flags) > 0, lifecycle)
                    }
                    if (481 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, lifecycle) {
                            var props = vNode.props;
                            var className = vNode.className;
                            var flags = vNode.flags;
                            var ref = vNode.ref;
                            isSVG = isSVG || (32 & flags) > 0;
                            if (1 !== dom.nodeType) {
                                inferno_1._ME(vNode, null, context, isSVG, null, lifecycle);
                                parentDOM.replaceChild(vNode.dom, dom)
                            } else {
                                vNode.dom = dom;
                                hydrateChildren(vNode, dom, dom.firstChild, context, isSVG, lifecycle);
                                if (!shared_1.isNull(props)) {
                                    inferno_1._MP(vNode, flags, props, dom, isSVG)
                                }
                                if (shared_1.isNullOrUndef(className)) {
                                    if ("" !== dom.className) {
                                        dom.removeAttribute("class")
                                    }
                                } else if (isSVG) {
                                    dom.setAttribute("class", className)
                                } else {
                                    dom.className = className
                                }
                                inferno_1._MR(ref, dom, lifecycle)
                            }
                            return vNode.dom
                        }(vNode, parentDOM, currentDom, context, isSVG, lifecycle)
                    }
                    if (16 & flags) {
                        return hydrateText(vNode, parentDOM, currentDom)
                    }
                    if (512 & flags) {
                        return vNode.dom = currentDom
                    }
                    if (8192 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, lifecycle) {
                            var children = vNode.children;
                            if (2 === vNode.childFlags) {
                                hydrateText(children, parentDOM, dom);
                                return children.dom
                            }
                            hydrateChildren(vNode, parentDOM, dom, context, isSVG, lifecycle);
                            return function(vNode) {
                                var flags;
                                var children;
                                while (vNode) {
                                    flags = vNode.flags;
                                    if (2033 & flags) {
                                        return vNode.dom
                                    }
                                    children = vNode.children;
                                    if (8192 & flags) {
                                        vNode = 2 === vNode.childFlags ? children : children[children.length - 1]
                                    } else if (4 & flags) {
                                        vNode = children.$LI
                                    } else {
                                        vNode = children
                                    }
                                }
                                return null
                            }(children[children.length - 1])
                        }(vNode, parentDOM, currentDom, context, isSVG, lifecycle)
                    }
                    shared_1.throwError();
                    return null
                }
                exports.hydrate = function(input, parentDOM, callback) {
                    var dom = parentDOM.firstChild;
                    if (shared_1.isNull(dom)) {
                        inferno_1.render(input, parentDOM, callback)
                    } else {
                        var lifecycle = [];
                        if (!shared_1.isInvalid(input)) {
                            dom = hydrateVNode(input, parentDOM, dom, {}, false, lifecycle)
                        }
                        while (dom && (dom = dom.nextSibling)) {
                            parentDOM.removeChild(dom)
                        }
                        if (lifecycle.length > 0) {
                            var listener = void 0;
                            while (void 0 !== (listener = lifecycle.shift())) {
                                listener()
                            }
                        }
                    }
                    parentDOM.$V = input;
                    if (shared_1.isFunction(callback)) {
                        callback()
                    }
                }
            },
        45786:
            /*!***************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/mocked/shared.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.throwError = exports.isNull = exports.isFunction = exports.isInvalid = exports.isNullOrUndef = exports.ERROR_MSG = void 0;
                exports.ERROR_MSG = "a runtime error occured! Use Inferno in development environment to find the error.";
                exports.isNullOrUndef = function(o) {
                    return void 0 === o || null === o
                };
                exports.isInvalid = function(o) {
                    return null === o || false === o || true === o || void 0 === o
                };
                exports.isFunction = function(o) {
                    return "function" === typeof o
                };
                exports.isNull = function(o) {
                    return null === o
                };
                exports.throwError = function(message) {
                    if (!message) {
                        message = exports.ERROR_MSG
                    }
                    throw new Error("Inferno Error: " + message)
                }
            },
        73084:
            /*!******************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/normalize_styles.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports) {
                var __read = this && this.__read || function(o, n) {
                    var m = "function" === typeof Symbol && o[Symbol.iterator];
                    if (!m) {
                        return o
                    }
                    var r, e, i = m.call(o),
                        ar = [];
                    try {
                        while ((void 0 === n || n-- > 0) && !(r = i.next()).done) {
                            ar.push(r.value)
                        }
                    } catch (error) {
                        e = {
                            error: error
                        }
                    } finally {
                        try {
                            if (r && !r.done && (m = i.return)) {
                                m.call(i)
                            }
                        } finally {
                            if (e) {
                                throw e.error
                            }
                        }
                    }
                    return ar
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.normalizeStyles = void 0;
                var NUMBER_STYLES = new Set(["animationIterationCount", "borderImageOutset", "borderImageSlice", "border-imageWidth", "boxFlex", "boxFlexGroup", "boxOrdinalGroup", "columnCount", "fillOpacity", "flex", "flexGrow", "flexNegative", "flexOrder", "flexPositive", "flexShrink", "floodOpacity", "fontWeight", "gridColumn", "gridRow", "lineClamp", "lineHeight", "opacity", "order", "orphans", "stopOpacity", "strokeDasharray", "strokeDashoffset", "strokeMiterlimit", "strokeOpacity", "strokeWidth", "tabSize", "widows", "zIndex", "zoom"]);
                var uppercasePattern = /[A-Z]/g;
                exports.normalizeStyles = function(styles) {
                    if (!(styles instanceof Object)) {
                        return
                    }
                    return Object.entries(styles).reduce((function(acc, _a) {
                        var _b = __read(_a, 2),
                            key = _b[0],
                            value = _b[1];
                        acc[(str = key, str.replace(uppercasePattern, "-$&").toLowerCase())] = function(value) {
                            if ("number" === typeof value) {
                                return true
                            }
                            return !Number.isNaN(Number(value))
                        }(value) ? function(style, value) {
                            return NUMBER_STYLES.has(style) ? value : value + "px"
                        }(key, value) : value;
                        var str;
                        return acc
                    }), {})
                }
            },
        53159:
            /*!********************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/portal.js ***!
              \********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Portal = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                exports.Portal = function(_a) {
                    var container = _a.container,
                        children = _a.children;
                    if (container) {
                        return inferno_1.createPortal(children, container)
                    }
                    return null
                }
            },
        31620:
            /*!******************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/re_render_effect.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createReRenderEffect = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var effect_1 = __webpack_require__( /*! ./effect */ 43956);
                exports.createReRenderEffect = function() {
                    return new effect_1.InfernoEffect((function() {
                        inferno_1.rerender()
                    }), [])
                }
            },
        86687:
            /*!************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/ref_object.js ***!
              \************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                })
            },
        32423:
            /*!*****************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/render_template.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.hasTemplate = exports.renderTemplate = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var inferno_create_element_1 = __webpack_require__( /*! inferno-create-element */ 99038);
                exports.renderTemplate = function(template, props, _component) {
                    setTimeout((function() {
                        inferno_1.render(inferno_create_element_1.createElement(template, props), function(props) {
                            var _a, _b;
                            return (null === (_a = props.container) || void 0 === _a ? void 0 : _a.get(0)) || (null === (_b = props.item) || void 0 === _b ? void 0 : _b.get(0))
                        }(props))
                    }), 0)
                };
                exports.hasTemplate = function(name, properties, _component) {
                    var value = properties[name];
                    return !!value && "string" !== typeof value
                }
            },
        99038:
            /*!*******************************************************************!*\
              !*** ../../node_modules/inferno-create-element/dist/index.esm.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
                __webpack_require__.r(__webpack_exports__);
                __webpack_require__.d(__webpack_exports__, {
                    createElement: function() {
                        return createElement
                    }
                });
                var inferno__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__( /*! inferno */ 65414);

                function isNullOrUndef(o) {
                    return void 0 === o || null === o
                }

                function isString(o) {
                    return "string" === typeof o
                }

                function isUndefined(o) {
                    return void 0 === o
                }
                var componentHooks = {
                    onComponentDidMount: 1,
                    onComponentDidUpdate: 1,
                    onComponentShouldUpdate: 1,
                    onComponentWillMount: 1,
                    onComponentWillUnmount: 1,
                    onComponentWillUpdate: 1
                };

                function createElement(type, props, _children) {
                    var arguments$1 = arguments;
                    var children;
                    var ref = null;
                    var key = null;
                    var className = null;
                    var flags = 0;
                    var newProps;
                    var childLen = arguments.length - 2;
                    if (1 === childLen) {
                        children = _children
                    } else if (childLen > 1) {
                        children = [];
                        while (childLen-- > 0) {
                            children[childLen] = arguments$1[childLen + 2]
                        }
                    }
                    if (isString(type)) {
                        flags = (0, inferno__WEBPACK_IMPORTED_MODULE_0__.getFlagsForElementVnode)(type);
                        if (!isNullOrUndef(props)) {
                            newProps = {};
                            for (var prop in props) {
                                if ("className" === prop || "class" === prop) {
                                    className = props[prop]
                                } else if ("key" === prop) {
                                    key = props.key
                                } else if ("children" === prop && isUndefined(children)) {
                                    children = props.children
                                } else if ("ref" === prop) {
                                    ref = props.ref
                                } else {
                                    if ("contenteditable" === prop) {
                                        flags |= 4096
                                    }
                                    newProps[prop] = props[prop]
                                }
                            }
                        }
                    } else {
                        flags = 2;
                        if (!isUndefined(children)) {
                            if (!props) {
                                props = {}
                            }
                            props.children = children
                        }
                        if (!isNullOrUndef(props)) {
                            newProps = {};
                            for (var prop$1 in props) {
                                if ("key" === prop$1) {
                                    key = props.key
                                } else if ("ref" === prop$1) {
                                    ref = props.ref
                                } else if (1 === componentHooks[prop$1]) {
                                    if (!ref) {
                                        ref = {}
                                    }
                                    ref[prop$1] = props[prop$1]
                                } else {
                                    newProps[prop$1] = props[prop$1]
                                }
                            }
                        }
                        return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createComponentVNode)(flags, type, newProps, key, ref)
                    }
                    if (8192 & flags) {
                        return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createFragment)(1 === childLen ? [children] : children, 0, key)
                    }
                    return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createVNode)(flags, type, className, children, 0, newProps, key, ref)
                }
            },
        65414:
            /*!***********************************************************!*\
              !*** ../../node_modules/inferno/index.esm.js + 1 modules ***!
              \***********************************************************/
            function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
                __webpack_require__.r(__webpack_exports__);
                __webpack_require__.d(__webpack_exports__, {
                    Component: function() {
                        return Component
                    },
                    EMPTY_OBJ: function() {
                        return EMPTY_OBJ
                    },
                    Fragment: function() {
                        return Fragment
                    },
                    _CI: function() {
                        return createClassComponentInstance
                    },
                    _HI: function() {
                        return normalizeRoot
                    },
                    _M: function() {
                        return mount
                    },
                    _MCCC: function() {
                        return mountClassComponentCallbacks
                    },
                    _ME: function() {
                        return mountElement
                    },
                    _MFCC: function() {
                        return mountFunctionalComponentCallbacks
                    },
                    _MP: function() {
                        return mountProps
                    },
                    _MR: function() {
                        return mountRef
                    },
                    _RFC: function() {
                        return renderFunctionalComponent
                    },
                    __render: function() {
                        return __render
                    },
                    createComponentVNode: function() {
                        return createComponentVNode
                    },
                    createFragment: function() {
                        return createFragment
                    },
                    createPortal: function() {
                        return createPortal
                    },
                    createRef: function() {
                        return createRef
                    },
                    createRenderer: function() {
                        return createRenderer
                    },
                    createTextVNode: function() {
                        return createTextVNode
                    },
                    createVNode: function() {
                        return createVNode
                    },
                    directClone: function() {
                        return directClone
                    },
                    findDOMfromVNode: function() {
                        return findDOMfromVNode
                    },
                    forwardRef: function() {
                        return forwardRef
                    },
                    getFlagsForElementVnode: function() {
                        return getFlagsForElementVnode
                    },
                    linkEvent: function() {
                        return linkEvent
                    },
                    normalizeProps: function() {
                        return normalizeProps
                    },
                    options: function() {
                        return options
                    },
                    render: function() {
                        return render
                    },
                    rerender: function() {
                        return rerender
                    },
                    version: function() {
                        return version
                    }
                });
                var isArray = Array.isArray;

                function isStringOrNumber(o) {
                    var type = typeof o;
                    return "string" === type || "number" === type
                }

                function isNullOrUndef(o) {
                    return void 0 === o || null === o
                }

                function isInvalid(o) {
                    return null === o || false === o || true === o || void 0 === o
                }

                function isFunction(o) {
                    return "function" === typeof o
                }

                function isString(o) {
                    return "string" === typeof o
                }

                function isNull(o) {
                    return null === o
                }

                function combineFrom(first, second) {
                    var out = {};
                    if (first) {
                        for (var key in first) {
                            out[key] = first[key]
                        }
                    }
                    if (second) {
                        for (var key$1 in second) {
                            out[key$1] = second[key$1]
                        }
                    }
                    return out
                }

                function linkEvent(data, event) {
                    if (isFunction(event)) {
                        return {
                            data: data,
                            event: event
                        }
                    }
                    return null
                }

                function isLinkEventObject(o) {
                    return !isNull(o) && "object" === typeof o
                }
                var EMPTY_OBJ = {};
                var Fragment = "$F";

                function normalizeEventName(name) {
                    return name.substr(2).toLowerCase()
                }

                function appendChild(parentDOM, dom) {
                    parentDOM.appendChild(dom)
                }

                function insertOrAppend(parentDOM, newNode, nextNode) {
                    if (isNull(nextNode)) {
                        appendChild(parentDOM, newNode)
                    } else {
                        parentDOM.insertBefore(newNode, nextNode)
                    }
                }

                function removeChild(parentDOM, childNode) {
                    parentDOM.removeChild(childNode)
                }

                function callAll(arrayFn) {
                    for (var i = 0; i < arrayFn.length; i++) {
                        arrayFn[i]()
                    }
                }

                function findChildVNode(vNode, startEdge, flags) {
                    var children = vNode.children;
                    if (4 & flags) {
                        return children.$LI
                    }
                    if (8192 & flags) {
                        return 2 === vNode.childFlags ? children : children[startEdge ? 0 : children.length - 1]
                    }
                    return children
                }

                function findDOMfromVNode(vNode, startEdge) {
                    var flags;
                    while (vNode) {
                        flags = vNode.flags;
                        if (2033 & flags) {
                            return vNode.dom
                        }
                        vNode = findChildVNode(vNode, startEdge, flags)
                    }
                    return null
                }

                function removeVNodeDOM(vNode, parentDOM) {
                    do {
                        var flags = vNode.flags;
                        if (2033 & flags) {
                            removeChild(parentDOM, vNode.dom);
                            return
                        }
                        var children = vNode.children;
                        if (4 & flags) {
                            vNode = children.$LI
                        }
                        if (8 & flags) {
                            vNode = children
                        }
                        if (8192 & flags) {
                            if (2 === vNode.childFlags) {
                                vNode = children
                            } else {
                                for (var i = 0, len = children.length; i < len; ++i) {
                                    removeVNodeDOM(children[i], parentDOM)
                                }
                                return
                            }
                        }
                    } while (vNode)
                }

                function moveVNodeDOM(vNode, parentDOM, nextNode) {
                    do {
                        var flags = vNode.flags;
                        if (2033 & flags) {
                            insertOrAppend(parentDOM, vNode.dom, nextNode);
                            return
                        }
                        var children = vNode.children;
                        if (4 & flags) {
                            vNode = children.$LI
                        }
                        if (8 & flags) {
                            vNode = children
                        }
                        if (8192 & flags) {
                            if (2 === vNode.childFlags) {
                                vNode = children
                            } else {
                                for (var i = 0, len = children.length; i < len; ++i) {
                                    moveVNodeDOM(children[i], parentDOM, nextNode)
                                }
                                return
                            }
                        }
                    } while (vNode)
                }

                function createDerivedState(instance, nextProps, state) {
                    if (instance.constructor.getDerivedStateFromProps) {
                        return combineFrom(state, instance.constructor.getDerivedStateFromProps(nextProps, state))
                    }
                    return state
                }
                var renderCheck = {
                    v: false
                };
                var options = {
                    componentComparator: null,
                    createVNode: null,
                    renderComplete: null
                };

                function setTextContent(dom, children) {
                    dom.textContent = children
                }

                function isLastValueSameLinkEvent(lastValue, nextValue) {
                    return isLinkEventObject(lastValue) && lastValue.event === nextValue.event && lastValue.data === nextValue.data
                }

                function mergeUnsetProperties(to, from) {
                    for (var propName in from) {
                        if (o = to[propName], void 0 === o) {
                            to[propName] = from[propName]
                        }
                    }
                    var o;
                    return to
                }

                function safeCall1(method, arg1) {
                    return !!isFunction(method) && (method(arg1), true)
                }

                function V(childFlags, children, className, flags, key, props, ref, type) {
                    this.childFlags = childFlags;
                    this.children = children;
                    this.className = className;
                    this.dom = null;
                    this.flags = flags;
                    this.key = void 0 === key ? null : key;
                    this.props = void 0 === props ? null : props;
                    this.ref = void 0 === ref ? null : ref;
                    this.type = type
                }

                function createVNode(flags, type, className, children, childFlags, props, key, ref) {
                    var childFlag = void 0 === childFlags ? 1 : childFlags;
                    var vNode = new V(childFlag, children, className, flags, key, props, ref, type);
                    if (options.createVNode) {
                        options.createVNode(vNode)
                    }
                    if (0 === childFlag) {
                        normalizeChildren(vNode, vNode.children)
                    }
                    return vNode
                }

                function createComponentVNode(flags, type, props, key, ref) {
                    flags = function(flags, type) {
                        if (12 & flags) {
                            return flags
                        }
                        if (type.prototype && type.prototype.render) {
                            return 4
                        }
                        if (type.render) {
                            return 32776
                        }
                        return 8
                    }(flags, type);
                    var vNode = new V(1, null, null, flags, key, function(flags, type, props) {
                        var defaultProps = (32768 & flags ? type.render : type).defaultProps;
                        if (isNullOrUndef(defaultProps)) {
                            return props
                        }
                        if (isNullOrUndef(props)) {
                            return combineFrom(defaultProps, null)
                        }
                        return mergeUnsetProperties(props, defaultProps)
                    }(flags, type, props), function(flags, type, ref) {
                        if (4 & flags) {
                            return ref
                        }
                        var defaultHooks = (32768 & flags ? type.render : type).defaultHooks;
                        if (isNullOrUndef(defaultHooks)) {
                            return ref
                        }
                        if (isNullOrUndef(ref)) {
                            return defaultHooks
                        }
                        return mergeUnsetProperties(ref, defaultHooks)
                    }(flags, type, ref), type);
                    if (options.createVNode) {
                        options.createVNode(vNode)
                    }
                    return vNode
                }

                function createTextVNode(text, key) {
                    return new V(1, isNullOrUndef(text) || true === text || false === text ? "" : text, null, 16, key, null, null, null)
                }

                function createFragment(children, childFlags, key) {
                    var fragment = createVNode(8192, 8192, null, children, childFlags, null, key, null);
                    switch (fragment.childFlags) {
                        case 1:
                            fragment.children = createVoidVNode();
                            fragment.childFlags = 2;
                            break;
                        case 16:
                            fragment.children = [createTextVNode(children)];
                            fragment.childFlags = 4
                    }
                    return fragment
                }

                function normalizeProps(vNode) {
                    var props = vNode.props;
                    if (props) {
                        var flags = vNode.flags;
                        if (481 & flags) {
                            if (void 0 !== props.children && isNullOrUndef(vNode.children)) {
                                normalizeChildren(vNode, props.children)
                            }
                            if (void 0 !== props.className) {
                                if (isNullOrUndef(vNode.className)) {
                                    vNode.className = props.className || null
                                }
                                props.className = void 0
                            }
                        }
                        if (void 0 !== props.key) {
                            vNode.key = props.key;
                            props.key = void 0
                        }
                        if (void 0 !== props.ref) {
                            if (8 & flags) {
                                vNode.ref = combineFrom(vNode.ref, props.ref)
                            } else {
                                vNode.ref = props.ref
                            }
                            props.ref = void 0
                        }
                    }
                    return vNode
                }

                function directClone(vNodeToClone) {
                    var flags = -16385 & vNodeToClone.flags;
                    var props = vNodeToClone.props;
                    if (14 & flags) {
                        if (!isNull(props)) {
                            var propsToClone = props;
                            props = {};
                            for (var key in propsToClone) {
                                props[key] = propsToClone[key]
                            }
                        }
                    }
                    if (0 === (8192 & flags)) {
                        return new V(vNodeToClone.childFlags, vNodeToClone.children, vNodeToClone.className, flags, vNodeToClone.key, props, vNodeToClone.ref, vNodeToClone.type)
                    }
                    return function(vNodeToClone) {
                        var oldChildren = vNodeToClone.children;
                        var childFlags = vNodeToClone.childFlags;
                        return createFragment(2 === childFlags ? directClone(oldChildren) : oldChildren.map(directClone), childFlags, vNodeToClone.key)
                    }(vNodeToClone)
                }

                function createVoidVNode() {
                    return createTextVNode("", null)
                }

                function createPortal(children, container) {
                    var normalizedRoot = normalizeRoot(children);
                    return createVNode(1024, 1024, null, normalizedRoot, 0, null, normalizedRoot.key, container)
                }

                function _normalizeVNodes(nodes, result, index, currentKey) {
                    for (var len = nodes.length; index < len; index++) {
                        var n = nodes[index];
                        if (!isInvalid(n)) {
                            var newKey = currentKey + "$" + index;
                            if (isArray(n)) {
                                _normalizeVNodes(n, result, 0, newKey)
                            } else {
                                if (isStringOrNumber(n)) {
                                    n = createTextVNode(n, newKey)
                                } else {
                                    var oldKey = n.key;
                                    var isPrefixedKey = isString(oldKey) && "$" === oldKey[0];
                                    if (81920 & n.flags || isPrefixedKey) {
                                        n = directClone(n)
                                    }
                                    n.flags |= 65536;
                                    if (!isPrefixedKey) {
                                        if (isNull(oldKey)) {
                                            n.key = newKey
                                        } else {
                                            n.key = currentKey + oldKey
                                        }
                                    } else if (oldKey.substring(0, currentKey.length) !== currentKey) {
                                        n.key = currentKey + oldKey
                                    }
                                }
                                result.push(n)
                            }
                        }
                    }
                }

                function getFlagsForElementVnode(type) {
                    switch (type) {
                        case "svg":
                            return 32;
                        case "input":
                            return 64;
                        case "select":
                            return 256;
                        case "textarea":
                            return 128;
                        case Fragment:
                            return 8192;
                        default:
                            return 1
                    }
                }

                function normalizeChildren(vNode, children) {
                    var newChildren;
                    var newChildFlags = 1;
                    if (isInvalid(children)) {
                        newChildren = children
                    } else if (isStringOrNumber(children)) {
                        newChildFlags = 16;
                        newChildren = children
                    } else if (isArray(children)) {
                        var len = children.length;
                        for (var i = 0; i < len; ++i) {
                            var n = children[i];
                            if (isInvalid(n) || isArray(n)) {
                                newChildren = newChildren || children.slice(0, i);
                                _normalizeVNodes(children, newChildren, i, "");
                                break
                            } else if (isStringOrNumber(n)) {
                                newChildren = newChildren || children.slice(0, i);
                                newChildren.push(createTextVNode(n, "$" + i))
                            } else {
                                var key = n.key;
                                var needsCloning = (81920 & n.flags) > 0;
                                var isNullKey = isNull(key);
                                var isPrefixed = isString(key) && "$" === key[0];
                                if (needsCloning || isNullKey || isPrefixed) {
                                    newChildren = newChildren || children.slice(0, i);
                                    if (needsCloning || isPrefixed) {
                                        n = directClone(n)
                                    }
                                    if (isNullKey || isPrefixed) {
                                        n.key = "$" + i
                                    }
                                    newChildren.push(n)
                                } else if (newChildren) {
                                    newChildren.push(n)
                                }
                                n.flags |= 65536
                            }
                        }
                        newChildren = newChildren || children;
                        if (0 === newChildren.length) {
                            newChildFlags = 1
                        } else {
                            newChildFlags = 8
                        }
                    } else {
                        newChildren = children;
                        newChildren.flags |= 65536;
                        if (81920 & children.flags) {
                            newChildren = directClone(children)
                        }
                        newChildFlags = 2
                    }
                    vNode.children = newChildren;
                    vNode.childFlags = newChildFlags;
                    return vNode
                }

                function normalizeRoot(input) {
                    if (isInvalid(input) || isStringOrNumber(input)) {
                        return createTextVNode(input, null)
                    }
                    if (isArray(input)) {
                        return createFragment(input, 0, null)
                    }
                    return 16384 & input.flags ? directClone(input) : input
                }
                var xlinkNS = "http://www.w3.org/1999/xlink";
                var xmlNS = "http://www.w3.org/XML/1998/namespace";
                var namespaces = {
                    "xlink:actuate": xlinkNS,
                    "xlink:arcrole": xlinkNS,
                    "xlink:href": xlinkNS,
                    "xlink:role": xlinkNS,
                    "xlink:show": xlinkNS,
                    "xlink:title": xlinkNS,
                    "xlink:type": xlinkNS,
                    "xml:base": xmlNS,
                    "xml:lang": xmlNS,
                    "xml:space": xmlNS
                };

                function getDelegatedEventObject(v) {
                    return {
                        onClick: v,
                        onDblClick: v,
                        onFocusIn: v,
                        onFocusOut: v,
                        onKeyDown: v,
                        onKeyPress: v,
                        onKeyUp: v,
                        onMouseDown: v,
                        onMouseMove: v,
                        onMouseUp: v,
                        onTouchEnd: v,
                        onTouchMove: v,
                        onTouchStart: v
                    }
                }
                var attachedEventCounts = getDelegatedEventObject(0);
                var attachedEvents = getDelegatedEventObject(null);
                var syntheticEvents = getDelegatedEventObject(true);

                function updateOrAddSyntheticEvent(name, dom) {
                    var eventsObject = dom.$EV;
                    if (!eventsObject) {
                        eventsObject = dom.$EV = getDelegatedEventObject(null)
                    }
                    if (!eventsObject[name]) {
                        if (1 === ++attachedEventCounts[name]) {
                            attachedEvents[name] = function(name) {
                                var attachedEvent = "onClick" === name || "onDblClick" === name ? function(name) {
                                    return function(event) {
                                        if (0 !== event.button) {
                                            event.stopPropagation();
                                            return
                                        }
                                        dispatchEvents(event, true, name, extendEventProperties(event))
                                    }
                                }(name) : function(name) {
                                    return function(event) {
                                        dispatchEvents(event, false, name, extendEventProperties(event))
                                    }
                                }(name);
                                document.addEventListener(normalizeEventName(name), attachedEvent);
                                return attachedEvent
                            }(name)
                        }
                    }
                    return eventsObject
                }

                function unmountSyntheticEvent(name, dom) {
                    var eventsObject = dom.$EV;
                    if (eventsObject && eventsObject[name]) {
                        if (0 === --attachedEventCounts[name]) {
                            document.removeEventListener(normalizeEventName(name), attachedEvents[name]);
                            attachedEvents[name] = null
                        }
                        eventsObject[name] = null
                    }
                }

                function dispatchEvents(event, isClick, name, eventData) {
                    var dom = function(event) {
                        return isFunction(event.composedPath) ? event.composedPath()[0] : event.target
                    }(event);
                    do {
                        if (isClick && dom.disabled) {
                            return
                        }
                        var eventsObject = dom.$EV;
                        if (eventsObject) {
                            var currentEvent = eventsObject[name];
                            if (currentEvent) {
                                eventData.dom = dom;
                                currentEvent.event ? currentEvent.event(currentEvent.data, event) : currentEvent(event);
                                if (event.cancelBubble) {
                                    return
                                }
                            }
                        }
                        dom = dom.parentNode
                    } while (!isNull(dom))
                }

                function stopPropagation() {
                    this.cancelBubble = true;
                    if (!this.immediatePropagationStopped) {
                        this.stopImmediatePropagation()
                    }
                }

                function isDefaultPrevented() {
                    return this.defaultPrevented
                }

                function isPropagationStopped() {
                    return this.cancelBubble
                }

                function extendEventProperties(event) {
                    var eventData = {
                        dom: document
                    };
                    event.isDefaultPrevented = isDefaultPrevented;
                    event.isPropagationStopped = isPropagationStopped;
                    event.stopPropagation = stopPropagation;
                    Object.defineProperty(event, "currentTarget", {
                        configurable: true,
                        get: function() {
                            return eventData.dom
                        }
                    });
                    return eventData
                }

                function triggerEventListener(props, methodName, e) {
                    if (props[methodName]) {
                        var listener = props[methodName];
                        if (listener.event) {
                            listener.event(listener.data, e)
                        } else {
                            listener(e)
                        }
                    } else {
                        var nativeListenerName = methodName.toLowerCase();
                        if (props[nativeListenerName]) {
                            props[nativeListenerName](e)
                        }
                    }
                }

                function createWrappedFunction(methodName, applyValue) {
                    var fnMethod = function(e) {
                        var vNode = this.$V;
                        if (!vNode) {
                            return
                        }
                        var props = vNode.props || EMPTY_OBJ;
                        var dom = vNode.dom;
                        if (isString(methodName)) {
                            triggerEventListener(props, methodName, e)
                        } else {
                            for (var i = 0; i < methodName.length; ++i) {
                                triggerEventListener(props, methodName[i], e)
                            }
                        }
                        if (isFunction(applyValue)) {
                            var newVNode = this.$V;
                            var newProps = newVNode.props || EMPTY_OBJ;
                            applyValue(newProps, dom, false, newVNode)
                        }
                    };
                    Object.defineProperty(fnMethod, "wrapped", {
                        configurable: false,
                        enumerable: false,
                        value: true,
                        writable: false
                    });
                    return fnMethod
                }

                function attachEvent(dom, eventName, handler) {
                    var previousKey = "$" + eventName;
                    var previousArgs = dom[previousKey];
                    if (previousArgs) {
                        if (previousArgs[1].wrapped) {
                            return
                        }
                        dom.removeEventListener(previousArgs[0], previousArgs[1]);
                        dom[previousKey] = null
                    }
                    if (isFunction(handler)) {
                        dom.addEventListener(eventName, handler);
                        dom[previousKey] = [eventName, handler]
                    }
                }

                function isCheckedType(type) {
                    return "checkbox" === type || "radio" === type
                }
                var onTextInputChange = createWrappedFunction("onInput", applyValueInput);
                var wrappedOnChange = createWrappedFunction(["onClick", "onChange"], applyValueInput);

                function emptywrapper(event) {
                    event.stopPropagation()
                }
                emptywrapper.wrapped = true;

                function applyValueInput(nextPropsOrEmpty, dom) {
                    var type = nextPropsOrEmpty.type;
                    var value = nextPropsOrEmpty.value;
                    var checked = nextPropsOrEmpty.checked;
                    var multiple = nextPropsOrEmpty.multiple;
                    var defaultValue = nextPropsOrEmpty.defaultValue;
                    var hasValue = !isNullOrUndef(value);
                    if (type && type !== dom.type) {
                        dom.setAttribute("type", type)
                    }
                    if (!isNullOrUndef(multiple) && multiple !== dom.multiple) {
                        dom.multiple = multiple
                    }
                    if (!isNullOrUndef(defaultValue) && !hasValue) {
                        dom.defaultValue = defaultValue + ""
                    }
                    if (isCheckedType(type)) {
                        if (hasValue) {
                            dom.value = value
                        }
                        if (!isNullOrUndef(checked)) {
                            dom.checked = checked
                        }
                    } else if (hasValue && dom.value !== value) {
                        dom.defaultValue = value;
                        dom.value = value
                    } else if (!isNullOrUndef(checked)) {
                        dom.checked = checked
                    }
                }

                function updateChildOptions(vNode, value) {
                    if ("option" === vNode.type) {
                        ! function(vNode, value) {
                            var props = vNode.props || EMPTY_OBJ;
                            var dom = vNode.dom;
                            dom.value = props.value;
                            if (props.value === value || isArray(value) && -1 !== value.indexOf(props.value)) {
                                dom.selected = true
                            } else if (!isNullOrUndef(value) || !isNullOrUndef(props.selected)) {
                                dom.selected = props.selected || false
                            }
                        }(vNode, value)
                    } else {
                        var children = vNode.children;
                        var flags = vNode.flags;
                        if (4 & flags) {
                            updateChildOptions(children.$LI, value)
                        } else if (8 & flags) {
                            updateChildOptions(children, value)
                        } else if (2 === vNode.childFlags) {
                            updateChildOptions(children, value)
                        } else if (12 & vNode.childFlags) {
                            for (var i = 0, len = children.length; i < len; ++i) {
                                updateChildOptions(children[i], value)
                            }
                        }
                    }
                }
                var onSelectChange = createWrappedFunction("onChange", applyValueSelect);

                function applyValueSelect(nextPropsOrEmpty, dom, mounting, vNode) {
                    var multiplePropInBoolean = Boolean(nextPropsOrEmpty.multiple);
                    if (!isNullOrUndef(nextPropsOrEmpty.multiple) && multiplePropInBoolean !== dom.multiple) {
                        dom.multiple = multiplePropInBoolean
                    }
                    var index = nextPropsOrEmpty.selectedIndex;
                    if (-1 === index) {
                        dom.selectedIndex = -1
                    }
                    var childFlags = vNode.childFlags;
                    if (1 !== childFlags) {
                        var value = nextPropsOrEmpty.value;
                        if ((o = index, "number" === typeof o) && index > -1 && dom.options[index]) {
                            value = dom.options[index].value
                        }
                        if (mounting && isNullOrUndef(value)) {
                            value = nextPropsOrEmpty.defaultValue
                        }
                        updateChildOptions(vNode, value)
                    }
                    var o
                }
                var onTextareaInputChange = createWrappedFunction("onInput", applyValueTextArea);
                var wrappedOnChange$1 = createWrappedFunction("onChange");

                function applyValueTextArea(nextPropsOrEmpty, dom, mounting) {
                    var value = nextPropsOrEmpty.value;
                    var domValue = dom.value;
                    if (isNullOrUndef(value)) {
                        if (mounting) {
                            var defaultValue = nextPropsOrEmpty.defaultValue;
                            if (!isNullOrUndef(defaultValue) && defaultValue !== domValue) {
                                dom.defaultValue = defaultValue;
                                dom.value = defaultValue
                            }
                        }
                    } else if (domValue !== value) {
                        dom.defaultValue = value;
                        dom.value = value
                    }
                }

                function processElement(flags, vNode, dom, nextPropsOrEmpty, mounting, isControlled) {
                    if (64 & flags) {
                        applyValueInput(nextPropsOrEmpty, dom)
                    } else if (256 & flags) {
                        applyValueSelect(nextPropsOrEmpty, dom, mounting, vNode)
                    } else if (128 & flags) {
                        applyValueTextArea(nextPropsOrEmpty, dom, mounting)
                    }
                    if (isControlled) {
                        dom.$V = vNode
                    }
                }

                function addFormElementEventHandlers(flags, dom, nextPropsOrEmpty) {
                    if (64 & flags) {
                        ! function(dom, nextPropsOrEmpty) {
                            if (isCheckedType(nextPropsOrEmpty.type)) {
                                attachEvent(dom, "change", wrappedOnChange);
                                attachEvent(dom, "click", emptywrapper)
                            } else {
                                attachEvent(dom, "input", onTextInputChange)
                            }
                        }(dom, nextPropsOrEmpty)
                    } else if (256 & flags) {
                        ! function(dom) {
                            attachEvent(dom, "change", onSelectChange)
                        }(dom)
                    } else if (128 & flags) {
                        ! function(dom, nextPropsOrEmpty) {
                            attachEvent(dom, "input", onTextareaInputChange);
                            if (nextPropsOrEmpty.onChange) {
                                attachEvent(dom, "change", wrappedOnChange$1)
                            }
                        }(dom, nextPropsOrEmpty)
                    }
                }

                function isControlledFormElement(nextPropsOrEmpty) {
                    return nextPropsOrEmpty.type && isCheckedType(nextPropsOrEmpty.type) ? !isNullOrUndef(nextPropsOrEmpty.checked) : !isNullOrUndef(nextPropsOrEmpty.value)
                }

                function createRef() {
                    return {
                        current: null
                    }
                }

                function forwardRef(render) {
                    return {
                        render: render
                    }
                }

                function unmountRef(ref) {
                    if (ref) {
                        if (!safeCall1(ref, null) && ref.current) {
                            ref.current = null
                        }
                    }
                }

                function mountRef(ref, value, lifecycle) {
                    if (ref && (isFunction(ref) || void 0 !== ref.current)) {
                        lifecycle.push((function() {
                            if (!safeCall1(ref, value) && void 0 !== ref.current) {
                                ref.current = value
                            }
                        }))
                    }
                }

                function remove(vNode, parentDOM) {
                    unmount(vNode);
                    removeVNodeDOM(vNode, parentDOM)
                }

                function unmount(vNode) {
                    var flags = vNode.flags;
                    var children = vNode.children;
                    var ref;
                    if (481 & flags) {
                        ref = vNode.ref;
                        var props = vNode.props;
                        unmountRef(ref);
                        var childFlags = vNode.childFlags;
                        if (!isNull(props)) {
                            var keys = Object.keys(props);
                            for (var i = 0, len = keys.length; i < len; i++) {
                                var key = keys[i];
                                if (syntheticEvents[key]) {
                                    unmountSyntheticEvent(key, vNode.dom)
                                }
                            }
                        }
                        if (12 & childFlags) {
                            unmountAllChildren(children)
                        } else if (2 === childFlags) {
                            unmount(children)
                        }
                    } else if (children) {
                        if (4 & flags) {
                            if (isFunction(children.componentWillUnmount)) {
                                children.componentWillUnmount()
                            }
                            unmountRef(vNode.ref);
                            children.$UN = true;
                            unmount(children.$LI)
                        } else if (8 & flags) {
                            ref = vNode.ref;
                            if (!isNullOrUndef(ref) && isFunction(ref.onComponentWillUnmount)) {
                                ref.onComponentWillUnmount(findDOMfromVNode(vNode, true), vNode.props || EMPTY_OBJ)
                            }
                            unmount(children)
                        } else if (1024 & flags) {
                            remove(children, vNode.ref)
                        } else if (8192 & flags) {
                            if (12 & vNode.childFlags) {
                                unmountAllChildren(children)
                            }
                        }
                    }
                }

                function unmountAllChildren(children) {
                    for (var i = 0, len = children.length; i < len; ++i) {
                        unmount(children[i])
                    }
                }

                function clearDOM(dom) {
                    dom.textContent = ""
                }

                function removeAllChildren(dom, vNode, children) {
                    unmountAllChildren(children);
                    if (8192 & vNode.flags) {
                        removeVNodeDOM(vNode, dom)
                    } else {
                        clearDOM(dom)
                    }
                }

                function patchDangerInnerHTML(lastValue, nextValue, lastVNode, dom) {
                    var lastHtml = lastValue && lastValue.__html || "";
                    var nextHtml = nextValue && nextValue.__html || "";
                    if (lastHtml !== nextHtml) {
                        if (!isNullOrUndef(nextHtml) && ! function(dom, innerHTML) {
                                var tempdom = document.createElement("i");
                                tempdom.innerHTML = innerHTML;
                                return tempdom.innerHTML === dom.innerHTML
                            }(dom, nextHtml)) {
                            if (!isNull(lastVNode)) {
                                if (12 & lastVNode.childFlags) {
                                    unmountAllChildren(lastVNode.children)
                                } else if (2 === lastVNode.childFlags) {
                                    unmount(lastVNode.children)
                                }
                                lastVNode.children = null;
                                lastVNode.childFlags = 1
                            }
                            dom.innerHTML = nextHtml
                        }
                    }
                }

                function patchProp(prop, lastValue, nextValue, dom, isSVG, hasControlledValue, lastVNode) {
                    switch (prop) {
                        case "children":
                        case "childrenType":
                        case "className":
                        case "defaultValue":
                        case "key":
                        case "multiple":
                        case "ref":
                        case "selectedIndex":
                            break;
                        case "autoFocus":
                            dom.autofocus = !!nextValue;
                            break;
                        case "allowfullscreen":
                        case "autoplay":
                        case "capture":
                        case "checked":
                        case "controls":
                        case "default":
                        case "disabled":
                        case "hidden":
                        case "indeterminate":
                        case "loop":
                        case "muted":
                        case "novalidate":
                        case "open":
                        case "readOnly":
                        case "required":
                        case "reversed":
                        case "scoped":
                        case "seamless":
                        case "selected":
                            dom[prop] = !!nextValue;
                            break;
                        case "defaultChecked":
                        case "value":
                        case "volume":
                            if (hasControlledValue && "value" === prop) {
                                break
                            }
                            var value = isNullOrUndef(nextValue) ? "" : nextValue;
                            if (dom[prop] !== value) {
                                dom[prop] = value
                            }
                            break;
                        case "style":
                            ! function(lastAttrValue, nextAttrValue, dom) {
                                if (isNullOrUndef(nextAttrValue)) {
                                    dom.removeAttribute("style");
                                    return
                                }
                                var domStyle = dom.style;
                                var style;
                                var value;
                                if (isString(nextAttrValue)) {
                                    domStyle.cssText = nextAttrValue;
                                    return
                                }
                                if (!isNullOrUndef(lastAttrValue) && !isString(lastAttrValue)) {
                                    for (style in nextAttrValue) {
                                        value = nextAttrValue[style];
                                        if (value !== lastAttrValue[style]) {
                                            domStyle.setProperty(style, value)
                                        }
                                    }
                                    for (style in lastAttrValue) {
                                        if (isNullOrUndef(nextAttrValue[style])) {
                                            domStyle.removeProperty(style)
                                        }
                                    }
                                } else {
                                    for (style in nextAttrValue) {
                                        value = nextAttrValue[style];
                                        domStyle.setProperty(style, value)
                                    }
                                }
                            }(lastValue, nextValue, dom);
                            break;
                        case "dangerouslySetInnerHTML":
                            patchDangerInnerHTML(lastValue, nextValue, lastVNode, dom);
                            break;
                        default:
                            if (syntheticEvents[prop]) {
                                ! function(name, lastEvent, nextEvent, dom) {
                                    if (isFunction(nextEvent)) {
                                        updateOrAddSyntheticEvent(name, dom)[name] = nextEvent
                                    } else if (isLinkEventObject(nextEvent)) {
                                        if (isLastValueSameLinkEvent(lastEvent, nextEvent)) {
                                            return
                                        }
                                        updateOrAddSyntheticEvent(name, dom)[name] = nextEvent
                                    } else {
                                        unmountSyntheticEvent(name, dom)
                                    }
                                }(prop, lastValue, nextValue, dom)
                            } else if (111 === prop.charCodeAt(0) && 110 === prop.charCodeAt(1)) {
                                ! function(name, lastValue, nextValue, dom) {
                                    if (isLinkEventObject(nextValue)) {
                                        if (isLastValueSameLinkEvent(lastValue, nextValue)) {
                                            return
                                        }
                                        nextValue = function(nextValue) {
                                            var ev = nextValue.event;
                                            return function(e) {
                                                ev(nextValue.data, e)
                                            }
                                        }(nextValue)
                                    }
                                    attachEvent(dom, normalizeEventName(name), nextValue)
                                }(prop, lastValue, nextValue, dom)
                            } else if (isNullOrUndef(nextValue)) {
                                dom.removeAttribute(prop)
                            } else if (isSVG && namespaces[prop]) {
                                dom.setAttributeNS(namespaces[prop], prop, nextValue)
                            } else {
                                dom.setAttribute(prop, nextValue)
                            }
                    }
                }

                function mountProps(vNode, flags, props, dom, isSVG) {
                    var hasControlledValue = false;
                    var isFormElement = (448 & flags) > 0;
                    if (isFormElement) {
                        hasControlledValue = isControlledFormElement(props);
                        if (hasControlledValue) {
                            addFormElementEventHandlers(flags, dom, props)
                        }
                    }
                    for (var prop in props) {
                        patchProp(prop, null, props[prop], dom, isSVG, hasControlledValue, null)
                    }
                    if (isFormElement) {
                        processElement(flags, vNode, dom, props, true, hasControlledValue)
                    }
                }

                function renderNewInput(instance, props, context) {
                    var nextInput = normalizeRoot(instance.render(props, instance.state, context));
                    var childContext = context;
                    if (isFunction(instance.getChildContext)) {
                        childContext = combineFrom(context, instance.getChildContext())
                    }
                    instance.$CX = childContext;
                    return nextInput
                }

                function createClassComponentInstance(vNode, Component, props, context, isSVG, lifecycle) {
                    var instance = new Component(props, context);
                    var usesNewAPI = instance.$N = Boolean(Component.getDerivedStateFromProps || instance.getSnapshotBeforeUpdate);
                    instance.$SVG = isSVG;
                    instance.$L = lifecycle;
                    vNode.children = instance;
                    instance.$BS = false;
                    instance.context = context;
                    if (instance.props === EMPTY_OBJ) {
                        instance.props = props
                    }
                    if (!usesNewAPI) {
                        if (isFunction(instance.componentWillMount)) {
                            instance.$BR = true;
                            instance.componentWillMount();
                            var pending = instance.$PS;
                            if (!isNull(pending)) {
                                var state = instance.state;
                                if (isNull(state)) {
                                    instance.state = pending
                                } else {
                                    for (var key in pending) {
                                        state[key] = pending[key]
                                    }
                                }
                                instance.$PS = null
                            }
                            instance.$BR = false
                        }
                    } else {
                        instance.state = createDerivedState(instance, props, instance.state)
                    }
                    instance.$LI = renderNewInput(instance, props, context);
                    return instance
                }

                function renderFunctionalComponent(vNode, context) {
                    var props = vNode.props || EMPTY_OBJ;
                    return 32768 & vNode.flags ? vNode.type.render(props, vNode.ref, context) : vNode.type(props, context)
                }

                function mount(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var flags = vNode.flags |= 16384;
                    if (481 & flags) {
                        mountElement(vNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (4 & flags) {
                        ! function(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var instance = createClassComponentInstance(vNode, vNode.type, vNode.props || EMPTY_OBJ, context, isSVG, lifecycle);
                            mount(instance.$LI, parentDOM, instance.$CX, isSVG, nextNode, lifecycle);
                            mountClassComponentCallbacks(vNode.ref, instance, lifecycle)
                        }(vNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (8 & flags) {
                        ! function(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            mount(vNode.children = normalizeRoot(renderFunctionalComponent(vNode, context)), parentDOM, context, isSVG, nextNode, lifecycle)
                        }(vNode, parentDOM, context, isSVG, nextNode, lifecycle);
                        mountFunctionalComponentCallbacks(vNode, lifecycle)
                    } else if (512 & flags || 16 & flags) {
                        mountText(vNode, parentDOM, nextNode)
                    } else if (8192 & flags) {
                        ! function(vNode, context, parentDOM, isSVG, nextNode, lifecycle) {
                            var children = vNode.children;
                            var childFlags = vNode.childFlags;
                            if (12 & childFlags && 0 === children.length) {
                                childFlags = vNode.childFlags = 2;
                                children = vNode.children = createVoidVNode()
                            }
                            if (2 === childFlags) {
                                mount(children, parentDOM, context, isSVG, nextNode, lifecycle)
                            } else {
                                mountArrayChildren(children, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                        }(vNode, context, parentDOM, isSVG, nextNode, lifecycle)
                    } else if (1024 & flags) {
                        ! function(vNode, context, parentDOM, nextNode, lifecycle) {
                            mount(vNode.children, vNode.ref, context, false, null, lifecycle);
                            var placeHolderVNode = createVoidVNode();
                            mountText(placeHolderVNode, parentDOM, nextNode);
                            vNode.dom = placeHolderVNode.dom
                        }(vNode, context, parentDOM, nextNode, lifecycle)
                    }
                }

                function mountText(vNode, parentDOM, nextNode) {
                    var dom = vNode.dom = document.createTextNode(vNode.children);
                    if (!isNull(parentDOM)) {
                        insertOrAppend(parentDOM, dom, nextNode)
                    }
                }

                function mountElement(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var flags = vNode.flags;
                    var props = vNode.props;
                    var className = vNode.className;
                    var childFlags = vNode.childFlags;
                    var dom = vNode.dom = function(tag, isSVG) {
                        if (isSVG) {
                            return document.createElementNS("http://www.w3.org/2000/svg", tag)
                        }
                        return document.createElement(tag)
                    }(vNode.type, isSVG = isSVG || (32 & flags) > 0);
                    var children = vNode.children;
                    if (!isNullOrUndef(className) && "" !== className) {
                        if (isSVG) {
                            dom.setAttribute("class", className)
                        } else {
                            dom.className = className
                        }
                    }
                    if (16 === childFlags) {
                        setTextContent(dom, children)
                    } else if (1 !== childFlags) {
                        var childrenIsSVG = isSVG && "foreignObject" !== vNode.type;
                        if (2 === childFlags) {
                            if (16384 & children.flags) {
                                vNode.children = children = directClone(children)
                            }
                            mount(children, dom, context, childrenIsSVG, null, lifecycle)
                        } else if (8 === childFlags || 4 === childFlags) {
                            mountArrayChildren(children, dom, context, childrenIsSVG, null, lifecycle)
                        }
                    }
                    if (!isNull(parentDOM)) {
                        insertOrAppend(parentDOM, dom, nextNode)
                    }
                    if (!isNull(props)) {
                        mountProps(vNode, flags, props, dom, isSVG)
                    }
                    mountRef(vNode.ref, dom, lifecycle)
                }

                function mountArrayChildren(children, dom, context, isSVG, nextNode, lifecycle) {
                    for (var i = 0; i < children.length; ++i) {
                        var child = children[i];
                        if (16384 & child.flags) {
                            children[i] = child = directClone(child)
                        }
                        mount(child, dom, context, isSVG, nextNode, lifecycle)
                    }
                }

                function mountClassComponentCallbacks(ref, instance, lifecycle) {
                    mountRef(ref, instance, lifecycle);
                    if (isFunction(instance.componentDidMount)) {
                        lifecycle.push(function(instance) {
                            return function() {
                                instance.componentDidMount()
                            }
                        }(instance))
                    }
                }

                function mountFunctionalComponentCallbacks(vNode, lifecycle) {
                    var ref = vNode.ref;
                    if (!isNullOrUndef(ref)) {
                        safeCall1(ref.onComponentWillMount, vNode.props || EMPTY_OBJ);
                        if (isFunction(ref.onComponentDidMount)) {
                            lifecycle.push(function(ref, vNode) {
                                return function() {
                                    ref.onComponentDidMount(findDOMfromVNode(vNode, true), vNode.props || EMPTY_OBJ)
                                }
                            }(ref, vNode))
                        }
                    }
                }

                function patch(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var nextFlags = nextVNode.flags |= 16384;
                    if (lastVNode.flags !== nextFlags || lastVNode.type !== nextVNode.type || lastVNode.key !== nextVNode.key || 2048 & nextFlags) {
                        if (16384 & lastVNode.flags) {
                            ! function(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle) {
                                unmount(lastVNode);
                                if (0 !== (nextVNode.flags & lastVNode.flags & 2033)) {
                                    mount(nextVNode, null, context, isSVG, null, lifecycle);
                                    ! function(parentDOM, newDom, lastDom) {
                                        parentDOM.replaceChild(newDom, lastDom)
                                    }(parentDOM, nextVNode.dom, lastVNode.dom)
                                } else {
                                    mount(nextVNode, parentDOM, context, isSVG, findDOMfromVNode(lastVNode, true), lifecycle);
                                    removeVNodeDOM(lastVNode, parentDOM)
                                }
                            }(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle)
                        } else {
                            mount(nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                        }
                    } else if (481 & nextFlags) {
                        ! function(lastVNode, nextVNode, context, isSVG, nextFlags, lifecycle) {
                            var dom = nextVNode.dom = lastVNode.dom;
                            var lastProps = lastVNode.props;
                            var nextProps = nextVNode.props;
                            var isFormElement = false;
                            var hasControlledValue = false;
                            var nextPropsOrEmpty;
                            isSVG = isSVG || (32 & nextFlags) > 0;
                            if (lastProps !== nextProps) {
                                var lastPropsOrEmpty = lastProps || EMPTY_OBJ;
                                nextPropsOrEmpty = nextProps || EMPTY_OBJ;
                                if (nextPropsOrEmpty !== EMPTY_OBJ) {
                                    isFormElement = (448 & nextFlags) > 0;
                                    if (isFormElement) {
                                        hasControlledValue = isControlledFormElement(nextPropsOrEmpty)
                                    }
                                    for (var prop in nextPropsOrEmpty) {
                                        var lastValue = lastPropsOrEmpty[prop];
                                        var nextValue = nextPropsOrEmpty[prop];
                                        if (lastValue !== nextValue) {
                                            patchProp(prop, lastValue, nextValue, dom, isSVG, hasControlledValue, lastVNode)
                                        }
                                    }
                                }
                                if (lastPropsOrEmpty !== EMPTY_OBJ) {
                                    for (var prop$1 in lastPropsOrEmpty) {
                                        if (isNullOrUndef(nextPropsOrEmpty[prop$1]) && !isNullOrUndef(lastPropsOrEmpty[prop$1])) {
                                            patchProp(prop$1, lastPropsOrEmpty[prop$1], null, dom, isSVG, hasControlledValue, lastVNode)
                                        }
                                    }
                                }
                            }
                            var nextChildren = nextVNode.children;
                            var nextClassName = nextVNode.className;
                            if (lastVNode.className !== nextClassName) {
                                if (isNullOrUndef(nextClassName)) {
                                    dom.removeAttribute("class")
                                } else if (isSVG) {
                                    dom.setAttribute("class", nextClassName)
                                } else {
                                    dom.className = nextClassName
                                }
                            }
                            if (4096 & nextFlags) {
                                ! function(dom, nextChildren) {
                                    if (dom.textContent !== nextChildren) {
                                        dom.textContent = nextChildren
                                    }
                                }(dom, nextChildren)
                            } else {
                                patchChildren(lastVNode.childFlags, nextVNode.childFlags, lastVNode.children, nextChildren, dom, context, isSVG && "foreignObject" !== nextVNode.type, null, lastVNode, lifecycle)
                            }
                            if (isFormElement) {
                                processElement(nextFlags, nextVNode, dom, nextPropsOrEmpty, false, hasControlledValue)
                            }
                            var nextRef = nextVNode.ref;
                            var lastRef = lastVNode.ref;
                            if (lastRef !== nextRef) {
                                unmountRef(lastRef);
                                mountRef(nextRef, dom, lifecycle)
                            }
                        }(lastVNode, nextVNode, context, isSVG, nextFlags, lifecycle)
                    } else if (4 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var instance = nextVNode.children = lastVNode.children;
                            if (isNull(instance)) {
                                return
                            }
                            instance.$L = lifecycle;
                            var nextProps = nextVNode.props || EMPTY_OBJ;
                            var nextRef = nextVNode.ref;
                            var lastRef = lastVNode.ref;
                            var nextState = instance.state;
                            if (!instance.$N) {
                                if (isFunction(instance.componentWillReceiveProps)) {
                                    instance.$BR = true;
                                    instance.componentWillReceiveProps(nextProps, context);
                                    if (instance.$UN) {
                                        return
                                    }
                                    instance.$BR = false
                                }
                                if (!isNull(instance.$PS)) {
                                    nextState = combineFrom(nextState, instance.$PS);
                                    instance.$PS = null
                                }
                            }
                            updateClassComponent(instance, nextState, nextProps, parentDOM, context, isSVG, false, nextNode, lifecycle);
                            if (lastRef !== nextRef) {
                                unmountRef(lastRef);
                                mountRef(nextRef, instance, lifecycle)
                            }
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (8 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var shouldUpdate = true;
                            var nextProps = nextVNode.props || EMPTY_OBJ;
                            var nextRef = nextVNode.ref;
                            var lastProps = lastVNode.props;
                            var nextHooksDefined = !isNullOrUndef(nextRef);
                            var lastInput = lastVNode.children;
                            if (nextHooksDefined && isFunction(nextRef.onComponentShouldUpdate)) {
                                shouldUpdate = nextRef.onComponentShouldUpdate(lastProps, nextProps)
                            }
                            if (false !== shouldUpdate) {
                                if (nextHooksDefined && isFunction(nextRef.onComponentWillUpdate)) {
                                    nextRef.onComponentWillUpdate(lastProps, nextProps)
                                }
                                var nextInput = normalizeRoot(renderFunctionalComponent(nextVNode, context));
                                patch(lastInput, nextInput, parentDOM, context, isSVG, nextNode, lifecycle);
                                nextVNode.children = nextInput;
                                if (nextHooksDefined && isFunction(nextRef.onComponentDidUpdate)) {
                                    nextRef.onComponentDidUpdate(lastProps, nextProps)
                                }
                            } else {
                                nextVNode.children = lastInput
                            }
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (16 & nextFlags) {
                        ! function(lastVNode, nextVNode) {
                            var nextText = nextVNode.children;
                            var dom = nextVNode.dom = lastVNode.dom;
                            if (nextText !== lastVNode.children) {
                                dom.nodeValue = nextText
                            }
                        }(lastVNode, nextVNode)
                    } else if (512 & nextFlags) {
                        nextVNode.dom = lastVNode.dom
                    } else if (8192 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle) {
                            var lastChildren = lastVNode.children;
                            var nextChildren = nextVNode.children;
                            var lastChildFlags = lastVNode.childFlags;
                            var nextChildFlags = nextVNode.childFlags;
                            var nextNode = null;
                            if (12 & nextChildFlags && 0 === nextChildren.length) {
                                nextChildFlags = nextVNode.childFlags = 2;
                                nextChildren = nextVNode.children = createVoidVNode()
                            }
                            var nextIsSingle = 0 !== (2 & nextChildFlags);
                            if (12 & lastChildFlags) {
                                var lastLen = lastChildren.length;
                                if (8 & lastChildFlags && 8 & nextChildFlags || nextIsSingle || !nextIsSingle && nextChildren.length > lastLen) {
                                    nextNode = findDOMfromVNode(lastChildren[lastLen - 1], false).nextSibling
                                }
                            }
                            patchChildren(lastChildFlags, nextChildFlags, lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, lastVNode, lifecycle)
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle)
                    } else {
                        ! function(lastVNode, nextVNode, context, lifecycle) {
                            var lastContainer = lastVNode.ref;
                            var nextContainer = nextVNode.ref;
                            var nextChildren = nextVNode.children;
                            patchChildren(lastVNode.childFlags, nextVNode.childFlags, lastVNode.children, nextChildren, lastContainer, context, false, null, lastVNode, lifecycle);
                            nextVNode.dom = lastVNode.dom;
                            if (lastContainer !== nextContainer && !isInvalid(nextChildren)) {
                                var node = nextChildren.dom;
                                removeChild(lastContainer, node);
                                appendChild(nextContainer, node)
                            }
                        }(lastVNode, nextVNode, context, lifecycle)
                    }
                }

                function patchChildren(lastChildFlags, nextChildFlags, lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, parentVNode, lifecycle) {
                    switch (lastChildFlags) {
                        case 2:
                            switch (nextChildFlags) {
                                case 2:
                                    patch(lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    remove(lastChildren, parentDOM);
                                    break;
                                case 16:
                                    unmount(lastChildren);
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                default:
                                    ! function(lastChildren, nextChildren, parentDOM, context, isSVG, lifecycle) {
                                        unmount(lastChildren);
                                        mountArrayChildren(nextChildren, parentDOM, context, isSVG, findDOMfromVNode(lastChildren, true), lifecycle);
                                        removeVNodeDOM(lastChildren, parentDOM)
                                    }(lastChildren, nextChildren, parentDOM, context, isSVG, lifecycle)
                            }
                            break;
                        case 1:
                            switch (nextChildFlags) {
                                case 2:
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    break;
                                case 16:
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                default:
                                    mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                            break;
                        case 16:
                            switch (nextChildFlags) {
                                case 16:
                                    ! function(lastChildren, nextChildren, parentDOM) {
                                        if (lastChildren !== nextChildren) {
                                            if ("" !== lastChildren) {
                                                parentDOM.firstChild.nodeValue = nextChildren
                                            } else {
                                                setTextContent(parentDOM, nextChildren)
                                            }
                                        }
                                    }(lastChildren, nextChildren, parentDOM);
                                    break;
                                case 2:
                                    clearDOM(parentDOM);
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    clearDOM(parentDOM);
                                    break;
                                default:
                                    clearDOM(parentDOM);
                                    mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                            break;
                        default:
                            switch (nextChildFlags) {
                                case 16:
                                    unmountAllChildren(lastChildren);
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                case 2:
                                    removeAllChildren(parentDOM, parentVNode, lastChildren);
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    removeAllChildren(parentDOM, parentVNode, lastChildren);
                                    break;
                                default:
                                    var lastLength = 0 | lastChildren.length;
                                    var nextLength = 0 | nextChildren.length;
                                    if (0 === lastLength) {
                                        if (nextLength > 0) {
                                            mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                                        }
                                    } else if (0 === nextLength) {
                                        removeAllChildren(parentDOM, parentVNode, lastChildren)
                                    } else if (8 === nextChildFlags && 8 === lastChildFlags) {
                                        ! function(a, b, dom, context, isSVG, aLength, bLength, outerEdge, parentVNode, lifecycle) {
                                            var aEnd = aLength - 1;
                                            var bEnd = bLength - 1;
                                            var j = 0;
                                            var aNode = a[j];
                                            var bNode = b[j];
                                            var nextPos;
                                            var nextNode;
                                            outer: {
                                                while (aNode.key === bNode.key) {
                                                    if (16384 & bNode.flags) {
                                                        b[j] = bNode = directClone(bNode)
                                                    }
                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                    a[j] = bNode;
                                                    ++j;
                                                    if (j > aEnd || j > bEnd) {
                                                        break outer
                                                    }
                                                    aNode = a[j];
                                                    bNode = b[j]
                                                }
                                                aNode = a[aEnd];bNode = b[bEnd];
                                                while (aNode.key === bNode.key) {
                                                    if (16384 & bNode.flags) {
                                                        b[bEnd] = bNode = directClone(bNode)
                                                    }
                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                    a[aEnd] = bNode;
                                                    aEnd--;
                                                    bEnd--;
                                                    if (j > aEnd || j > bEnd) {
                                                        break outer
                                                    }
                                                    aNode = a[aEnd];
                                                    bNode = b[bEnd]
                                                }
                                            }
                                            if (j > aEnd) {
                                                if (j <= bEnd) {
                                                    nextPos = bEnd + 1;
                                                    nextNode = nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge;
                                                    while (j <= bEnd) {
                                                        bNode = b[j];
                                                        if (16384 & bNode.flags) {
                                                            b[j] = bNode = directClone(bNode)
                                                        }++j;
                                                        mount(bNode, dom, context, isSVG, nextNode, lifecycle)
                                                    }
                                                }
                                            } else if (j > bEnd) {
                                                while (j <= aEnd) {
                                                    remove(a[j++], dom)
                                                }
                                            } else {
                                                ! function(a, b, context, aLength, bLength, aEnd, bEnd, j, dom, isSVG, outerEdge, parentVNode, lifecycle) {
                                                    var aNode;
                                                    var bNode;
                                                    var nextPos;
                                                    var i = 0;
                                                    var aStart = j;
                                                    var bStart = j;
                                                    var aLeft = aEnd - j + 1;
                                                    var bLeft = bEnd - j + 1;
                                                    var sources = new Int32Array(bLeft + 1);
                                                    var canRemoveWholeContent = aLeft === aLength;
                                                    var moved = false;
                                                    var pos = 0;
                                                    var patched = 0;
                                                    if (bLength < 4 || (aLeft | bLeft) < 32) {
                                                        for (i = aStart; i <= aEnd; ++i) {
                                                            aNode = a[i];
                                                            if (patched < bLeft) {
                                                                for (j = bStart; j <= bEnd; j++) {
                                                                    bNode = b[j];
                                                                    if (aNode.key === bNode.key) {
                                                                        sources[j - bStart] = i + 1;
                                                                        if (canRemoveWholeContent) {
                                                                            canRemoveWholeContent = false;
                                                                            while (aStart < i) {
                                                                                remove(a[aStart++], dom)
                                                                            }
                                                                        }
                                                                        if (pos > j) {
                                                                            moved = true
                                                                        } else {
                                                                            pos = j
                                                                        }
                                                                        if (16384 & bNode.flags) {
                                                                            b[j] = bNode = directClone(bNode)
                                                                        }
                                                                        patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                                        ++patched;
                                                                        break
                                                                    }
                                                                }
                                                                if (!canRemoveWholeContent && j > bEnd) {
                                                                    remove(aNode, dom)
                                                                }
                                                            } else if (!canRemoveWholeContent) {
                                                                remove(aNode, dom)
                                                            }
                                                        }
                                                    } else {
                                                        var keyIndex = {};
                                                        for (i = bStart; i <= bEnd; ++i) {
                                                            keyIndex[b[i].key] = i
                                                        }
                                                        for (i = aStart; i <= aEnd; ++i) {
                                                            aNode = a[i];
                                                            if (patched < bLeft) {
                                                                j = keyIndex[aNode.key];
                                                                if (void 0 !== j) {
                                                                    if (canRemoveWholeContent) {
                                                                        canRemoveWholeContent = false;
                                                                        while (i > aStart) {
                                                                            remove(a[aStart++], dom)
                                                                        }
                                                                    }
                                                                    sources[j - bStart] = i + 1;
                                                                    if (pos > j) {
                                                                        moved = true
                                                                    } else {
                                                                        pos = j
                                                                    }
                                                                    bNode = b[j];
                                                                    if (16384 & bNode.flags) {
                                                                        b[j] = bNode = directClone(bNode)
                                                                    }
                                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                                    ++patched
                                                                } else if (!canRemoveWholeContent) {
                                                                    remove(aNode, dom)
                                                                }
                                                            } else if (!canRemoveWholeContent) {
                                                                remove(aNode, dom)
                                                            }
                                                        }
                                                    }
                                                    if (canRemoveWholeContent) {
                                                        removeAllChildren(dom, parentVNode, a);
                                                        mountArrayChildren(b, dom, context, isSVG, outerEdge, lifecycle)
                                                    } else if (moved) {
                                                        var seq = function(arr) {
                                                            var arrI = 0;
                                                            var i = 0;
                                                            var j = 0;
                                                            var k = 0;
                                                            var u = 0;
                                                            var v = 0;
                                                            var c = 0;
                                                            var len = arr.length;
                                                            if (len > maxLen) {
                                                                maxLen = len;
                                                                result = new Int32Array(len);
                                                                p = new Int32Array(len)
                                                            }
                                                            for (; i < len; ++i) {
                                                                arrI = arr[i];
                                                                if (0 !== arrI) {
                                                                    j = result[k];
                                                                    if (arr[j] < arrI) {
                                                                        p[i] = j;
                                                                        result[++k] = i;
                                                                        continue
                                                                    }
                                                                    u = 0;
                                                                    v = k;
                                                                    while (u < v) {
                                                                        c = u + v >> 1;
                                                                        if (arr[result[c]] < arrI) {
                                                                            u = c + 1
                                                                        } else {
                                                                            v = c
                                                                        }
                                                                    }
                                                                    if (arrI < arr[result[u]]) {
                                                                        if (u > 0) {
                                                                            p[i] = result[u - 1]
                                                                        }
                                                                        result[u] = i
                                                                    }
                                                                }
                                                            }
                                                            u = k + 1;
                                                            var seq = new Int32Array(u);
                                                            v = result[u - 1];
                                                            while (u-- > 0) {
                                                                seq[u] = v;
                                                                v = p[v];
                                                                result[u] = 0
                                                            }
                                                            return seq
                                                        }(sources);
                                                        j = seq.length - 1;
                                                        for (i = bLeft - 1; i >= 0; i--) {
                                                            if (0 === sources[i]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                if (16384 & bNode.flags) {
                                                                    b[pos] = bNode = directClone(bNode)
                                                                }
                                                                nextPos = pos + 1;
                                                                mount(bNode, dom, context, isSVG, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge, lifecycle)
                                                            } else if (j < 0 || i !== seq[j]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                nextPos = pos + 1;
                                                                moveVNodeDOM(bNode, dom, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge)
                                                            } else {
                                                                j--
                                                            }
                                                        }
                                                    } else if (patched !== bLeft) {
                                                        for (i = bLeft - 1; i >= 0; i--) {
                                                            if (0 === sources[i]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                if (16384 & bNode.flags) {
                                                                    b[pos] = bNode = directClone(bNode)
                                                                }
                                                                nextPos = pos + 1;
                                                                mount(bNode, dom, context, isSVG, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge, lifecycle)
                                                            }
                                                        }
                                                    }
                                                }(a, b, context, aLength, bLength, aEnd, bEnd, j, dom, isSVG, outerEdge, parentVNode, lifecycle)
                                            }
                                        }(lastChildren, nextChildren, parentDOM, context, isSVG, lastLength, nextLength, nextNode, parentVNode, lifecycle)
                                    } else {
                                        ! function(lastChildren, nextChildren, dom, context, isSVG, lastChildrenLength, nextChildrenLength, nextNode, lifecycle) {
                                            var commonLength = lastChildrenLength > nextChildrenLength ? nextChildrenLength : lastChildrenLength;
                                            var i = 0;
                                            var nextChild;
                                            var lastChild;
                                            for (; i < commonLength; ++i) {
                                                nextChild = nextChildren[i];
                                                lastChild = lastChildren[i];
                                                if (16384 & nextChild.flags) {
                                                    nextChild = nextChildren[i] = directClone(nextChild)
                                                }
                                                patch(lastChild, nextChild, dom, context, isSVG, nextNode, lifecycle);
                                                lastChildren[i] = nextChild
                                            }
                                            if (lastChildrenLength < nextChildrenLength) {
                                                for (i = commonLength; i < nextChildrenLength; ++i) {
                                                    nextChild = nextChildren[i];
                                                    if (16384 & nextChild.flags) {
                                                        nextChild = nextChildren[i] = directClone(nextChild)
                                                    }
                                                    mount(nextChild, dom, context, isSVG, nextNode, lifecycle)
                                                }
                                            } else if (lastChildrenLength > nextChildrenLength) {
                                                for (i = commonLength; i < lastChildrenLength; ++i) {
                                                    remove(lastChildren[i], dom)
                                                }
                                            }
                                        }(lastChildren, nextChildren, parentDOM, context, isSVG, lastLength, nextLength, nextNode, lifecycle)
                                    }
                            }
                    }
                }

                function updateClassComponent(instance, nextState, nextProps, parentDOM, context, isSVG, force, nextNode, lifecycle) {
                    var lastState = instance.state;
                    var lastProps = instance.props;
                    var usesNewAPI = Boolean(instance.$N);
                    var hasSCU = isFunction(instance.shouldComponentUpdate);
                    if (usesNewAPI) {
                        nextState = createDerivedState(instance, nextProps, nextState !== lastState ? combineFrom(lastState, nextState) : nextState)
                    }
                    if (force || !hasSCU || hasSCU && instance.shouldComponentUpdate(nextProps, nextState, context)) {
                        if (!usesNewAPI && isFunction(instance.componentWillUpdate)) {
                            instance.componentWillUpdate(nextProps, nextState, context)
                        }
                        instance.props = nextProps;
                        instance.state = nextState;
                        instance.context = context;
                        var snapshot = null;
                        var nextInput = renderNewInput(instance, nextProps, context);
                        if (usesNewAPI && isFunction(instance.getSnapshotBeforeUpdate)) {
                            snapshot = instance.getSnapshotBeforeUpdate(lastProps, lastState)
                        }
                        patch(instance.$LI, nextInput, parentDOM, instance.$CX, isSVG, nextNode, lifecycle);
                        instance.$LI = nextInput;
                        if (isFunction(instance.componentDidUpdate)) {
                            ! function(instance, lastProps, lastState, snapshot, lifecycle) {
                                lifecycle.push((function() {
                                    instance.componentDidUpdate(lastProps, lastState, snapshot)
                                }))
                            }(instance, lastProps, lastState, snapshot, lifecycle)
                        }
                    } else {
                        instance.props = nextProps;
                        instance.state = nextState;
                        instance.context = context
                    }
                }
                var result;
                var p;
                var maxLen = 0;
                var hasDocumentAvailable = "undefined" !== typeof document;
                if (hasDocumentAvailable) {
                    if (window.Node) {
                        Node.prototype.$EV = null;
                        Node.prototype.$V = null
                    }
                }

                function __render(input, parentDOM, callback, context) {
                    var lifecycle = [];
                    var rootInput = parentDOM.$V;
                    renderCheck.v = true;
                    if (isNullOrUndef(rootInput)) {
                        if (!isNullOrUndef(input)) {
                            if (16384 & input.flags) {
                                input = directClone(input)
                            }
                            mount(input, parentDOM, context, false, null, lifecycle);
                            parentDOM.$V = input;
                            rootInput = input
                        }
                    } else if (isNullOrUndef(input)) {
                        remove(rootInput, parentDOM);
                        parentDOM.$V = null
                    } else {
                        if (16384 & input.flags) {
                            input = directClone(input)
                        }
                        patch(rootInput, input, parentDOM, context, false, null, lifecycle);
                        rootInput = parentDOM.$V = input
                    }
                    callAll(lifecycle);
                    renderCheck.v = false;
                    if (isFunction(callback)) {
                        callback()
                    }
                    if (isFunction(options.renderComplete)) {
                        options.renderComplete(rootInput, parentDOM)
                    }
                }

                function render(input, parentDOM, callback, context) {
                    if (void 0 === callback) {
                        callback = null
                    }
                    if (void 0 === context) {
                        context = EMPTY_OBJ
                    }
                    __render(input, parentDOM, callback, context)
                }

                function createRenderer(parentDOM) {
                    return function(lastInput, nextInput, callback, context) {
                        if (!parentDOM) {
                            parentDOM = lastInput
                        }
                        render(nextInput, parentDOM, callback, context)
                    }
                }
                var QUEUE = [];
                var nextTick = "undefined" !== typeof Promise ? Promise.resolve().then.bind(Promise.resolve()) : function(a) {
                    window.setTimeout(a, 0)
                };
                var microTaskPending = false;

                function queueStateChanges(component, newState, callback, force) {
                    var pending = component.$PS;
                    if (isFunction(newState)) {
                        newState = newState(pending ? combineFrom(component.state, pending) : component.state, component.props, component.context)
                    }
                    if (isNullOrUndef(pending)) {
                        component.$PS = newState
                    } else {
                        for (var stateKey in newState) {
                            pending[stateKey] = newState[stateKey]
                        }
                    }
                    if (!component.$BR) {
                        if (!renderCheck.v) {
                            if (0 === QUEUE.length) {
                                applyState(component, force);
                                if (isFunction(callback)) {
                                    callback.call(component)
                                }
                                return
                            }
                        }
                        if (-1 === QUEUE.indexOf(component)) {
                            QUEUE.push(component)
                        }
                        if (force) {
                            component.$F = true
                        }
                        if (!microTaskPending) {
                            microTaskPending = true;
                            nextTick(rerender)
                        }
                        if (isFunction(callback)) {
                            var QU = component.$QU;
                            if (!QU) {
                                QU = component.$QU = []
                            }
                            QU.push(callback)
                        }
                    } else if (isFunction(callback)) {
                        component.$L.push(callback.bind(component))
                    }
                }

                function callSetStateCallbacks(component) {
                    var queue = component.$QU;
                    for (var i = 0; i < queue.length; ++i) {
                        queue[i].call(component)
                    }
                    component.$QU = null
                }

                function rerender() {
                    var component;
                    microTaskPending = false;
                    while (component = QUEUE.shift()) {
                        if (!component.$UN) {
                            var force = component.$F;
                            component.$F = false;
                            applyState(component, force);
                            if (component.$QU) {
                                callSetStateCallbacks(component)
                            }
                        }
                    }
                }

                function applyState(component, force) {
                    if (force || !component.$BR) {
                        var pendingState = component.$PS;
                        component.$PS = null;
                        var lifecycle = [];
                        renderCheck.v = true;
                        updateClassComponent(component, combineFrom(component.state, pendingState), component.props, findDOMfromVNode(component.$LI, true).parentNode, component.context, component.$SVG, force, null, lifecycle);
                        callAll(lifecycle);
                        renderCheck.v = false
                    } else {
                        component.state = component.$PS;
                        component.$PS = null
                    }
                }
                var Component = function(props, context) {
                    this.state = null;
                    this.$BR = false;
                    this.$BS = true;
                    this.$PS = null;
                    this.$LI = null;
                    this.$UN = false;
                    this.$CX = null;
                    this.$QU = null;
                    this.$N = false;
                    this.$L = null;
                    this.$SVG = false;
                    this.$F = false;
                    this.props = props || EMPTY_OBJ;
                    this.context = context || EMPTY_OBJ
                };
                Component.prototype.forceUpdate = function(callback) {
                    if (this.$UN) {
                        return
                    }
                    queueStateChanges(this, {}, callback, true)
                };
                Component.prototype.setState = function(newState, callback) {
                    if (this.$UN) {
                        return
                    }
                    if (!this.$BS) {
                        queueStateChanges(this, newState, callback, false)
                    }
                };
                Component.prototype.render = function(_nextProps, _nextState, _nextContext) {
                    return null
                };
                var version = "7.4.11";
                if (false) {}
            },
        98919:
            /*!***************************************************************!*\
              !*** ../../node_modules/rrule/dist/esm/index.js + 28 modules ***!
              \***************************************************************/
            function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
                __webpack_require__.r(__webpack_exports__);
                __webpack_require__.d(__webpack_exports__, {
                    Frequency: function() {
                        return Frequency
                    },
                    RRule: function() {
                        return RRule
                    },
                    RRuleSet: function() {
                        return RRuleSet
                    },
                    Weekday: function() {
                        return Weekday
                    },
                    datetime: function() {
                        return datetime
                    },
                    rrulestr: function() {
                        return rrulestr
                    }
                });
                var ALL_WEEKDAYS = ["MO", "TU", "WE", "TH", "FR", "SA", "SU"];
                var Weekday = function() {
                    function Weekday(weekday, n) {
                        if (0 === n) {
                            throw new Error("Can't create weekday with n == 0")
                        }
                        this.weekday = weekday;
                        this.n = n
                    }
                    Weekday.fromStr = function(str) {
                        return new Weekday(ALL_WEEKDAYS.indexOf(str))
                    };
                    Weekday.prototype.nth = function(n) {
                        return this.n === n ? this : new Weekday(this.weekday, n)
                    };
                    Weekday.prototype.equals = function(other) {
                        return this.weekday === other.weekday && this.n === other.n
                    };
                    Weekday.prototype.toString = function() {
                        var s = ALL_WEEKDAYS[this.weekday];
                        if (this.n) {
                            s = (this.n > 0 ? "+" : "") + String(this.n) + s
                        }
                        return s
                    };
                    Weekday.prototype.getJsWeekday = function() {
                        return 6 === this.weekday ? 0 : this.weekday + 1
                    };
                    return Weekday
                }();
                var isPresent = function(value) {
                    return null !== value && void 0 !== value
                };
                var isNumber = function(value) {
                    return "number" === typeof value
                };
                var isWeekdayStr = function(value) {
                    return "string" === typeof value && ALL_WEEKDAYS.includes(value)
                };
                var isArray = Array.isArray;
                var range = function(start, end) {
                    if (void 0 === end) {
                        end = start
                    }
                    if (1 === arguments.length) {
                        end = start;
                        start = 0
                    }
                    var rang = [];
                    for (var i = start; i < end; i++) {
                        rang.push(i)
                    }
                    return rang
                };
                var repeat = function(value, times) {
                    var i = 0;
                    var array = [];
                    if (isArray(value)) {
                        for (; i < times; i++) {
                            array[i] = [].concat(value)
                        }
                    } else {
                        for (; i < times; i++) {
                            array[i] = value
                        }
                    }
                    return array
                };
                var toArray = function(item) {
                    if (isArray(item)) {
                        return item
                    }
                    return [item]
                };

                function padStart(item, targetLength, padString) {
                    if (void 0 === padString) {
                        padString = " "
                    }
                    var str = String(item);
                    targetLength >>= 0;
                    if (str.length > targetLength) {
                        return String(str)
                    }
                    targetLength -= str.length;
                    if (targetLength > padString.length) {
                        padString += repeat(padString, targetLength / padString.length)
                    }
                    return padString.slice(0, targetLength) + String(str)
                }
                var pymod = function(a, b) {
                    var r = a % b;
                    return r * b < 0 ? r + b : r
                };
                var divmod = function(a, b) {
                    return {
                        div: Math.floor(a / b),
                        mod: pymod(a, b)
                    }
                };
                var empty = function(obj) {
                    return !isPresent(obj) || 0 === obj.length
                };
                var notEmpty = function(obj) {
                    return !empty(obj)
                };
                var includes = function(arr, val) {
                    return notEmpty(arr) && -1 !== arr.indexOf(val)
                };
                var datetime = function(y, m, d, h, i, s) {
                    if (void 0 === h) {
                        h = 0
                    }
                    if (void 0 === i) {
                        i = 0
                    }
                    if (void 0 === s) {
                        s = 0
                    }
                    return new Date(Date.UTC(y, m - 1, d, h, i, s))
                };
                var MONTH_DAYS = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
                var ORDINAL_BASE = datetime(1970, 1, 1);
                var PY_WEEKDAYS = [6, 0, 1, 2, 3, 4, 5];
                var isLeapYear = function(year) {
                    return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0
                };
                var isDate = function(value) {
                    return value instanceof Date
                };
                var isValidDate = function(value) {
                    return isDate(value) && !isNaN(value.getTime())
                };
                var tzOffset = function(date) {
                    return 60 * date.getTimezoneOffset() * 1e3
                };
                var toOrdinal = function(date) {
                    return date1 = date, date2 = ORDINAL_BASE, date1ms = date1.getTime() - tzOffset(date1), date2ms = date2.getTime() - tzOffset(date2), differencems = date1ms - date2ms, Math.round(differencems / 864e5);
                    var date1, date2, date1ms, date2ms, differencems
                };
                var fromOrdinal = function(ordinal) {
                    return new Date(ORDINAL_BASE.getTime() + 864e5 * ordinal)
                };
                var getMonthDays = function(date) {
                    var month = date.getUTCMonth();
                    return 1 === month && isLeapYear(date.getUTCFullYear()) ? 29 : MONTH_DAYS[month]
                };
                var getWeekday = function(date) {
                    return PY_WEEKDAYS[date.getUTCDay()]
                };
                var monthRange = function(year, month) {
                    var date = datetime(year, month + 1, 1);
                    return [getWeekday(date), getMonthDays(date)]
                };
                var combine = function(date, time) {
                    time = time || date;
                    return new Date(Date.UTC(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds()))
                };
                var dateutil_clone = function(date) {
                    var dolly = new Date(date.getTime());
                    return dolly
                };
                var cloneDates = function(dates) {
                    var clones = [];
                    for (var i = 0; i < dates.length; i++) {
                        clones.push(dateutil_clone(dates[i]))
                    }
                    return clones
                };
                var sort = function(dates) {
                    dates.sort((function(a, b) {
                        return a.getTime() - b.getTime()
                    }))
                };
                var timeToUntilString = function(time, utc) {
                    if (void 0 === utc) {
                        utc = true
                    }
                    var date = new Date(time);
                    return [padStart(date.getUTCFullYear().toString(), 4, "0"), padStart(date.getUTCMonth() + 1, 2, "0"), padStart(date.getUTCDate(), 2, "0"), "T", padStart(date.getUTCHours(), 2, "0"), padStart(date.getUTCMinutes(), 2, "0"), padStart(date.getUTCSeconds(), 2, "0"), utc ? "Z" : ""].join("")
                };
                var untilStringToDate = function(until) {
                    var bits = /^(\d{4})(\d{2})(\d{2})(T(\d{2})(\d{2})(\d{2})Z?)?$/.exec(until);
                    if (!bits) {
                        throw new Error("Invalid UNTIL value: ".concat(until))
                    }
                    return new Date(Date.UTC(parseInt(bits[1], 10), parseInt(bits[2], 10) - 1, parseInt(bits[3], 10), parseInt(bits[5], 10) || 0, parseInt(bits[6], 10) || 0, parseInt(bits[7], 10) || 0))
                };
                var dateTZtoISO8601 = function(date, timeZone) {
                    var dateStr = date.toLocaleString("sv-SE", {
                        timeZone: timeZone
                    });
                    return dateStr.replace(" ", "T") + "Z"
                };
                var IterResult = function() {
                    function IterResult(method, args) {
                        this.minDate = null;
                        this.maxDate = null;
                        this._result = [];
                        this.total = 0;
                        this.method = method;
                        this.args = args;
                        if ("between" === method) {
                            this.maxDate = args.inc ? args.before : new Date(args.before.getTime() - 1);
                            this.minDate = args.inc ? args.after : new Date(args.after.getTime() + 1)
                        } else if ("before" === method) {
                            this.maxDate = args.inc ? args.dt : new Date(args.dt.getTime() - 1)
                        } else if ("after" === method) {
                            this.minDate = args.inc ? args.dt : new Date(args.dt.getTime() + 1)
                        }
                    }
                    IterResult.prototype.accept = function(date) {
                        ++this.total;
                        var tooEarly = this.minDate && date < this.minDate;
                        var tooLate = this.maxDate && date > this.maxDate;
                        if ("between" === this.method) {
                            if (tooEarly) {
                                return true
                            }
                            if (tooLate) {
                                return false
                            }
                        } else if ("before" === this.method) {
                            if (tooLate) {
                                return false
                            }
                        } else if ("after" === this.method) {
                            if (tooEarly) {
                                return true
                            }
                            this.add(date);
                            return false
                        }
                        return this.add(date)
                    };
                    IterResult.prototype.add = function(date) {
                        this._result.push(date);
                        return true
                    };
                    IterResult.prototype.getValue = function() {
                        var res = this._result;
                        switch (this.method) {
                            case "all":
                            case "between":
                                return res;
                            case "before":
                            case "after":
                            default:
                                return res.length ? res[res.length - 1] : null
                        }
                    };
                    IterResult.prototype.clone = function() {
                        return new IterResult(this.method, this.args)
                    };
                    return IterResult
                }();
                var iterresult = IterResult;
                var extendStatics = function(d, b) {
                    extendStatics = Object.setPrototypeOf || {
                        __proto__: []
                    }
                    instanceof Array && function(d, b) {
                        d.__proto__ = b
                    } || function(d, b) {
                        for (var p in b) {
                            if (Object.prototype.hasOwnProperty.call(b, p)) {
                                d[p] = b[p]
                            }
                        }
                    };
                    return extendStatics(d, b)
                };

                function __extends(d, b) {
                    if ("function" !== typeof b && null !== b) {
                        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null")
                    }
                    extendStatics(d, b);

                    function __() {
                        this.constructor = d
                    }
                    d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
                }
                var __assign = function() {
                    __assign = Object.assign || function(t) {
                        for (var s, i = 1, n = arguments.length; i < n; i++) {
                            s = arguments[i];
                            for (var p in s) {
                                if (Object.prototype.hasOwnProperty.call(s, p)) {
                                    t[p] = s[p]
                                }
                            }
                        }
                        return t
                    };
                    return __assign.apply(this, arguments)
                };
                Object.create;

                function __spreadArray(to, from, pack) {
                    if (pack || 2 === arguments.length) {
                        for (var ar, i = 0, l = from.length; i < l; i++) {
                            if (ar || !(i in from)) {
                                if (!ar) {
                                    ar = Array.prototype.slice.call(from, 0, i)
                                }
                                ar[i] = from[i]
                            }
                        }
                    }
                    return to.concat(ar || Array.prototype.slice.call(from))
                }
                Object.create;
                "function" === typeof SuppressedError && SuppressedError;
                var CallbackIterResult = function(_super) {
                    __extends(CallbackIterResult, _super);

                    function CallbackIterResult(method, args, iterator) {
                        var _this = _super.call(this, method, args) || this;
                        _this.iterator = iterator;
                        return _this
                    }
                    CallbackIterResult.prototype.add = function(date) {
                        if (this.iterator(date, this._result.length)) {
                            this._result.push(date);
                            return true
                        }
                        return false
                    };
                    return CallbackIterResult
                }(iterresult);
                var callbackiterresult = CallbackIterResult;
                var i18n = {
                    dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                    monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
                    tokens: {
                        SKIP: /^[ \r\n\t]+|^\.$/,
                        number: /^[1-9][0-9]*/,
                        numberAsText: /^(one|two|three)/i,
                        every: /^every/i,
                        "day(s)": /^days?/i,
                        "weekday(s)": /^weekdays?/i,
                        "week(s)": /^weeks?/i,
                        "hour(s)": /^hours?/i,
                        "minute(s)": /^minutes?/i,
                        "month(s)": /^months?/i,
                        "year(s)": /^years?/i,
                        on: /^(on|in)/i,
                        at: /^(at)/i,
                        the: /^the/i,
                        first: /^first/i,
                        second: /^second/i,
                        third: /^third/i,
                        nth: /^([1-9][0-9]*)(\.|th|nd|rd|st)/i,
                        last: /^last/i,
                        for: /^for/i,
                        "time(s)": /^times?/i,
                        until: /^(un)?til/i,
                        monday: /^mo(n(day)?)?/i,
                        tuesday: /^tu(e(s(day)?)?)?/i,
                        wednesday: /^we(d(n(esday)?)?)?/i,
                        thursday: /^th(u(r(sday)?)?)?/i,
                        friday: /^fr(i(day)?)?/i,
                        saturday: /^sa(t(urday)?)?/i,
                        sunday: /^su(n(day)?)?/i,
                        january: /^jan(uary)?/i,
                        february: /^feb(ruary)?/i,
                        march: /^mar(ch)?/i,
                        april: /^apr(il)?/i,
                        may: /^may/i,
                        june: /^june?/i,
                        july: /^july?/i,
                        august: /^aug(ust)?/i,
                        september: /^sep(t(ember)?)?/i,
                        october: /^oct(ober)?/i,
                        november: /^nov(ember)?/i,
                        december: /^dec(ember)?/i,
                        comma: /^(,\s*|(and|or)\s*)+/i
                    }
                };
                var contains = function(arr, val) {
                    return -1 !== arr.indexOf(val)
                };
                var defaultGetText = function(id) {
                    return id.toString()
                };
                var defaultDateFormatter = function(year, month, day) {
                    return "".concat(month, " ").concat(day, ", ").concat(year)
                };
                var ToText = function() {
                    function ToText(rrule, gettext, language, dateFormatter) {
                        if (void 0 === gettext) {
                            gettext = defaultGetText
                        }
                        if (void 0 === language) {
                            language = i18n
                        }
                        if (void 0 === dateFormatter) {
                            dateFormatter = defaultDateFormatter
                        }
                        this.text = [];
                        this.language = language || i18n;
                        this.gettext = gettext;
                        this.dateFormatter = dateFormatter;
                        this.rrule = rrule;
                        this.options = rrule.options;
                        this.origOptions = rrule.origOptions;
                        if (this.origOptions.bymonthday) {
                            var bymonthday = [].concat(this.options.bymonthday);
                            var bynmonthday = [].concat(this.options.bynmonthday);
                            bymonthday.sort((function(a, b) {
                                return a - b
                            }));
                            bynmonthday.sort((function(a, b) {
                                return b - a
                            }));
                            this.bymonthday = bymonthday.concat(bynmonthday);
                            if (!this.bymonthday.length) {
                                this.bymonthday = null
                            }
                        }
                        if (isPresent(this.origOptions.byweekday)) {
                            var byweekday = !isArray(this.origOptions.byweekday) ? [this.origOptions.byweekday] : this.origOptions.byweekday;
                            var days = String(byweekday);
                            this.byweekday = {
                                allWeeks: byweekday.filter((function(weekday) {
                                    return !weekday.n
                                })),
                                someWeeks: byweekday.filter((function(weekday) {
                                    return Boolean(weekday.n)
                                })),
                                isWeekdays: -1 !== days.indexOf("MO") && -1 !== days.indexOf("TU") && -1 !== days.indexOf("WE") && -1 !== days.indexOf("TH") && -1 !== days.indexOf("FR") && -1 === days.indexOf("SA") && -1 === days.indexOf("SU"),
                                isEveryDay: -1 !== days.indexOf("MO") && -1 !== days.indexOf("TU") && -1 !== days.indexOf("WE") && -1 !== days.indexOf("TH") && -1 !== days.indexOf("FR") && -1 !== days.indexOf("SA") && -1 !== days.indexOf("SU")
                            };
                            var sortWeekDays = function(a, b) {
                                return a.weekday - b.weekday
                            };
                            this.byweekday.allWeeks.sort(sortWeekDays);
                            this.byweekday.someWeeks.sort(sortWeekDays);
                            if (!this.byweekday.allWeeks.length) {
                                this.byweekday.allWeeks = null
                            }
                            if (!this.byweekday.someWeeks.length) {
                                this.byweekday.someWeeks = null
                            }
                        } else {
                            this.byweekday = null
                        }
                    }
                    ToText.isFullyConvertible = function(rrule) {
                        if (!(rrule.options.freq in ToText.IMPLEMENTED)) {
                            return false
                        }
                        if (rrule.origOptions.until && rrule.origOptions.count) {
                            return false
                        }
                        for (var key in rrule.origOptions) {
                            if (contains(["dtstart", "wkst", "freq"], key)) {
                                return true
                            }
                            if (!contains(ToText.IMPLEMENTED[rrule.options.freq], key)) {
                                return false
                            }
                        }
                        return true
                    };
                    ToText.prototype.isFullyConvertible = function() {
                        return ToText.isFullyConvertible(this.rrule)
                    };
                    ToText.prototype.toString = function() {
                        var gettext = this.gettext;
                        if (!(this.options.freq in ToText.IMPLEMENTED)) {
                            return gettext("RRule error: Unable to fully convert this rrule to text")
                        }
                        this.text = [gettext("every")];
                        this[RRule.FREQUENCIES[this.options.freq]]();
                        if (this.options.until) {
                            this.add(gettext("until"));
                            var until = this.options.until;
                            this.add(this.dateFormatter(until.getUTCFullYear(), this.language.monthNames[until.getUTCMonth()], until.getUTCDate()))
                        } else if (this.options.count) {
                            this.add(gettext("for")).add(this.options.count.toString()).add(this.plural(this.options.count) ? gettext("times") : gettext("time"))
                        }
                        if (!this.isFullyConvertible()) {
                            this.add(gettext("(~ approximate)"))
                        }
                        return this.text.join("")
                    };
                    ToText.prototype.HOURLY = function() {
                        var gettext = this.gettext;
                        if (1 !== this.options.interval) {
                            this.add(this.options.interval.toString())
                        }
                        this.add(this.plural(this.options.interval) ? gettext("hours") : gettext("hour"))
                    };
                    ToText.prototype.MINUTELY = function() {
                        var gettext = this.gettext;
                        if (1 !== this.options.interval) {
                            this.add(this.options.interval.toString())
                        }
                        this.add(this.plural(this.options.interval) ? gettext("minutes") : gettext("minute"))
                    };
                    ToText.prototype.DAILY = function() {
                        var gettext = this.gettext;
                        if (1 !== this.options.interval) {
                            this.add(this.options.interval.toString())
                        }
                        if (this.byweekday && this.byweekday.isWeekdays) {
                            this.add(this.plural(this.options.interval) ? gettext("weekdays") : gettext("weekday"))
                        } else {
                            this.add(this.plural(this.options.interval) ? gettext("days") : gettext("day"))
                        }
                        if (this.origOptions.bymonth) {
                            this.add(gettext("in"));
                            this._bymonth()
                        }
                        if (this.bymonthday) {
                            this._bymonthday()
                        } else if (this.byweekday) {
                            this._byweekday()
                        } else if (this.origOptions.byhour) {
                            this._byhour()
                        }
                    };
                    ToText.prototype.WEEKLY = function() {
                        var gettext = this.gettext;
                        if (1 !== this.options.interval) {
                            this.add(this.options.interval.toString()).add(this.plural(this.options.interval) ? gettext("weeks") : gettext("week"))
                        }
                        if (this.byweekday && this.byweekday.isWeekdays) {
                            if (1 === this.options.interval) {
                                this.add(this.plural(this.options.interval) ? gettext("weekdays") : gettext("weekday"))
                            } else {
                                this.add(gettext("on")).add(gettext("weekdays"))
                            }
                        } else if (this.byweekday && this.byweekday.isEveryDay) {
                            this.add(this.plural(this.options.interval) ? gettext("days") : gettext("day"))
                        } else {
                            if (1 === this.options.interval) {
                                this.add(gettext("week"))
                            }
                            if (this.origOptions.bymonth) {
                                this.add(gettext("in"));
                                this._bymonth()
                            }
                            if (this.bymonthday) {
                                this._bymonthday()
                            } else if (this.byweekday) {
                                this._byweekday()
                            }
                        }
                    };
                    ToText.prototype.MONTHLY = function() {
                        var gettext = this.gettext;
                        if (this.origOptions.bymonth) {
                            if (1 !== this.options.interval) {
                                this.add(this.options.interval.toString()).add(gettext("months"));
                                if (this.plural(this.options.interval)) {
                                    this.add(gettext("in"))
                                }
                            }
                            this._bymonth()
                        } else {
                            if (1 !== this.options.interval) {
                                this.add(this.options.interval.toString())
                            }
                            this.add(this.plural(this.options.interval) ? gettext("months") : gettext("month"))
                        }
                        if (this.bymonthday) {
                            this._bymonthday()
                        } else if (this.byweekday && this.byweekday.isWeekdays) {
                            this.add(gettext("on")).add(gettext("weekdays"))
                        } else if (this.byweekday) {
                            this._byweekday()
                        }
                    };
                    ToText.prototype.YEARLY = function() {
                        var gettext = this.gettext;
                        if (this.origOptions.bymonth) {
                            if (1 !== this.options.interval) {
                                this.add(this.options.interval.toString());
                                this.add(gettext("years"))
                            }
                            this._bymonth()
                        } else {
                            if (1 !== this.options.interval) {
                                this.add(this.options.interval.toString())
                            }
                            this.add(this.plural(this.options.interval) ? gettext("years") : gettext("year"))
                        }
                        if (this.bymonthday) {
                            this._bymonthday()
                        } else if (this.byweekday) {
                            this._byweekday()
                        }
                        if (this.options.byyearday) {
                            this.add(gettext("on the")).add(this.list(this.options.byyearday, this.nth, gettext("and"))).add(gettext("day"))
                        }
                        if (this.options.byweekno) {
                            this.add(gettext("in")).add(this.plural(this.options.byweekno.length) ? gettext("weeks") : gettext("week")).add(this.list(this.options.byweekno, void 0, gettext("and")))
                        }
                    };
                    ToText.prototype._bymonthday = function() {
                        var gettext = this.gettext;
                        if (this.byweekday && this.byweekday.allWeeks) {
                            this.add(gettext("on")).add(this.list(this.byweekday.allWeeks, this.weekdaytext, gettext("or"))).add(gettext("the")).add(this.list(this.bymonthday, this.nth, gettext("or")))
                        } else {
                            this.add(gettext("on the")).add(this.list(this.bymonthday, this.nth, gettext("and")))
                        }
                    };
                    ToText.prototype._byweekday = function() {
                        var gettext = this.gettext;
                        if (this.byweekday.allWeeks && !this.byweekday.isWeekdays) {
                            this.add(gettext("on")).add(this.list(this.byweekday.allWeeks, this.weekdaytext))
                        }
                        if (this.byweekday.someWeeks) {
                            if (this.byweekday.allWeeks) {
                                this.add(gettext("and"))
                            }
                            this.add(gettext("on the")).add(this.list(this.byweekday.someWeeks, this.weekdaytext, gettext("and")))
                        }
                    };
                    ToText.prototype._byhour = function() {
                        var gettext = this.gettext;
                        this.add(gettext("at")).add(this.list(this.origOptions.byhour, void 0, gettext("and")))
                    };
                    ToText.prototype._bymonth = function() {
                        this.add(this.list(this.options.bymonth, this.monthtext, this.gettext("and")))
                    };
                    ToText.prototype.nth = function(n) {
                        n = parseInt(n.toString(), 10);
                        var nth;
                        var gettext = this.gettext;
                        if (-1 === n) {
                            return gettext("last")
                        }
                        var npos = Math.abs(n);
                        switch (npos) {
                            case 1:
                            case 21:
                            case 31:
                                nth = npos + gettext("st");
                                break;
                            case 2:
                            case 22:
                                nth = npos + gettext("nd");
                                break;
                            case 3:
                            case 23:
                                nth = npos + gettext("rd");
                                break;
                            default:
                                nth = npos + gettext("th")
                        }
                        return n < 0 ? nth + " " + gettext("last") : nth
                    };
                    ToText.prototype.monthtext = function(m) {
                        return this.language.monthNames[m - 1]
                    };
                    ToText.prototype.weekdaytext = function(wday) {
                        var weekday = isNumber(wday) ? (wday + 1) % 7 : wday.getJsWeekday();
                        return (wday.n ? this.nth(wday.n) + " " : "") + this.language.dayNames[weekday]
                    };
                    ToText.prototype.plural = function(n) {
                        return n % 100 !== 1
                    };
                    ToText.prototype.add = function(s) {
                        this.text.push(" ");
                        this.text.push(s);
                        return this
                    };
                    ToText.prototype.list = function(arr, callback, finalDelim, delim) {
                        var _this = this;
                        if (void 0 === delim) {
                            delim = ","
                        }
                        if (!isArray(arr)) {
                            arr = [arr]
                        }
                        callback = callback || function(o) {
                            return o.toString()
                        };
                        var realCallback = function(arg) {
                            return callback && callback.call(_this, arg)
                        };
                        if (finalDelim) {
                            return function(array, delimiter, finalDelimiter) {
                                var list = "";
                                for (var i = 0; i < array.length; i++) {
                                    if (0 !== i) {
                                        if (i === array.length - 1) {
                                            list += " " + finalDelimiter + " "
                                        } else {
                                            list += delimiter + " "
                                        }
                                    }
                                    list += array[i]
                                }
                                return list
                            }(arr.map(realCallback), delim, finalDelim)
                        } else {
                            return arr.map(realCallback).join(delim + " ")
                        }
                    };
                    return ToText
                }();
                var totext = ToText;
                var Parser = function() {
                    function Parser(rules) {
                        this.done = true;
                        this.rules = rules
                    }
                    Parser.prototype.start = function(text) {
                        this.text = text;
                        this.done = false;
                        return this.nextSymbol()
                    };
                    Parser.prototype.isDone = function() {
                        return this.done && null === this.symbol
                    };
                    Parser.prototype.nextSymbol = function() {
                        var best;
                        var bestSymbol;
                        this.symbol = null;
                        this.value = null;
                        do {
                            if (this.done) {
                                return false
                            }
                            var rule = void 0;
                            best = null;
                            for (var name_1 in this.rules) {
                                rule = this.rules[name_1];
                                var match = rule.exec(this.text);
                                if (match) {
                                    if (null === best || match[0].length > best[0].length) {
                                        best = match;
                                        bestSymbol = name_1
                                    }
                                }
                            }
                            if (null != best) {
                                this.text = this.text.substr(best[0].length);
                                if ("" === this.text) {
                                    this.done = true
                                }
                            }
                            if (null == best) {
                                this.done = true;
                                this.symbol = null;
                                this.value = null;
                                return
                            }
                        } while ("SKIP" === bestSymbol);
                        this.symbol = bestSymbol;
                        this.value = best;
                        return true
                    };
                    Parser.prototype.accept = function(name) {
                        if (this.symbol === name) {
                            if (this.value) {
                                var v = this.value;
                                this.nextSymbol();
                                return v
                            }
                            this.nextSymbol();
                            return true
                        }
                        return false
                    };
                    Parser.prototype.acceptNumber = function() {
                        return this.accept("number")
                    };
                    Parser.prototype.expect = function(name) {
                        if (this.accept(name)) {
                            return true
                        }
                        throw new Error("expected " + name + " but found " + this.symbol)
                    };
                    return Parser
                }();

                function parseText(text, language) {
                    if (void 0 === language) {
                        language = i18n
                    }
                    var options = {};
                    var ttr = new Parser(language.tokens);
                    if (!ttr.start(text)) {
                        return null
                    }! function() {
                        ttr.expect("every");
                        var n = ttr.acceptNumber();
                        if (n) {
                            options.interval = parseInt(n[0], 10)
                        }
                        if (ttr.isDone()) {
                            throw new Error("Unexpected end")
                        }
                        switch (ttr.symbol) {
                            case "day(s)":
                                options.freq = RRule.DAILY;
                                if (ttr.nextSymbol()) {
                                    ! function() {
                                        var at = ttr.accept("at");
                                        if (!at) {
                                            return
                                        }
                                        do {
                                            var n = ttr.acceptNumber();
                                            if (!n) {
                                                throw new Error("Unexpected symbol " + ttr.symbol + ", expected hour")
                                            }
                                            options.byhour = [parseInt(n[0], 10)];
                                            while (ttr.accept("comma")) {
                                                n = ttr.acceptNumber();
                                                if (!n) {
                                                    throw new Error("Unexpected symbol " + ttr.symbol + "; expected hour")
                                                }
                                                options.byhour.push(parseInt(n[0], 10))
                                            }
                                        } while (ttr.accept("comma") || ttr.accept("at"))
                                    }();
                                    F()
                                }
                                break;
                            case "weekday(s)":
                                options.freq = RRule.WEEKLY;
                                options.byweekday = [RRule.MO, RRule.TU, RRule.WE, RRule.TH, RRule.FR];
                                ttr.nextSymbol();
                                F();
                                break;
                            case "week(s)":
                                options.freq = RRule.WEEKLY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "hour(s)":
                                options.freq = RRule.HOURLY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "minute(s)":
                                options.freq = RRule.MINUTELY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "month(s)":
                                options.freq = RRule.MONTHLY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "year(s)":
                                options.freq = RRule.YEARLY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "monday":
                            case "tuesday":
                            case "wednesday":
                            case "thursday":
                            case "friday":
                            case "saturday":
                            case "sunday":
                                options.freq = RRule.WEEKLY;
                                var key = ttr.symbol.substr(0, 2).toUpperCase();
                                options.byweekday = [RRule[key]];
                                if (!ttr.nextSymbol()) {
                                    return
                                }
                                while (ttr.accept("comma")) {
                                    if (ttr.isDone()) {
                                        throw new Error("Unexpected end")
                                    }
                                    var wkd = decodeWKD();
                                    if (!wkd) {
                                        throw new Error("Unexpected symbol " + ttr.symbol + ", expected weekday")
                                    }
                                    options.byweekday.push(RRule[wkd]);
                                    ttr.nextSymbol()
                                }! function() {
                                    ttr.accept("on");
                                    ttr.accept("the");
                                    var nth = decodeNTH();
                                    if (!nth) {
                                        return
                                    }
                                    options.bymonthday = [nth];
                                    ttr.nextSymbol();
                                    while (ttr.accept("comma")) {
                                        nth = decodeNTH();
                                        if (!nth) {
                                            throw new Error("Unexpected symbol " + ttr.symbol + "; expected monthday")
                                        }
                                        options.bymonthday.push(nth);
                                        ttr.nextSymbol()
                                    }
                                }();
                                F();
                                break;
                            case "january":
                            case "february":
                            case "march":
                            case "april":
                            case "may":
                            case "june":
                            case "july":
                            case "august":
                            case "september":
                            case "october":
                            case "november":
                            case "december":
                                options.freq = RRule.YEARLY;
                                options.bymonth = [decodeM()];
                                if (!ttr.nextSymbol()) {
                                    return
                                }
                                while (ttr.accept("comma")) {
                                    if (ttr.isDone()) {
                                        throw new Error("Unexpected end")
                                    }
                                    var m = decodeM();
                                    if (!m) {
                                        throw new Error("Unexpected symbol " + ttr.symbol + ", expected month")
                                    }
                                    options.bymonth.push(m);
                                    ttr.nextSymbol()
                                }
                                ON();
                                F();
                                break;
                            default:
                                throw new Error("Unknown symbol")
                        }
                    }();
                    return options;

                    function ON() {
                        var on = ttr.accept("on");
                        var the = ttr.accept("the");
                        if (!(on || the)) {
                            return
                        }
                        do {
                            var nth = decodeNTH();
                            var wkd = decodeWKD();
                            var m = decodeM();
                            if (nth) {
                                if (wkd) {
                                    ttr.nextSymbol();
                                    if (!options.byweekday) {
                                        options.byweekday = []
                                    }
                                    options.byweekday.push(RRule[wkd].nth(nth))
                                } else {
                                    if (!options.bymonthday) {
                                        options.bymonthday = []
                                    }
                                    options.bymonthday.push(nth);
                                    ttr.accept("day(s)")
                                }
                            } else if (wkd) {
                                ttr.nextSymbol();
                                if (!options.byweekday) {
                                    options.byweekday = []
                                }
                                options.byweekday.push(RRule[wkd])
                            } else if ("weekday(s)" === ttr.symbol) {
                                ttr.nextSymbol();
                                if (!options.byweekday) {
                                    options.byweekday = [RRule.MO, RRule.TU, RRule.WE, RRule.TH, RRule.FR]
                                }
                            } else if ("week(s)" === ttr.symbol) {
                                ttr.nextSymbol();
                                var n = ttr.acceptNumber();
                                if (!n) {
                                    throw new Error("Unexpected symbol " + ttr.symbol + ", expected week number")
                                }
                                options.byweekno = [parseInt(n[0], 10)];
                                while (ttr.accept("comma")) {
                                    n = ttr.acceptNumber();
                                    if (!n) {
                                        throw new Error("Unexpected symbol " + ttr.symbol + "; expected monthday")
                                    }
                                    options.byweekno.push(parseInt(n[0], 10))
                                }
                            } else if (m) {
                                ttr.nextSymbol();
                                if (!options.bymonth) {
                                    options.bymonth = []
                                }
                                options.bymonth.push(m)
                            } else {
                                return
                            }
                        } while (ttr.accept("comma") || ttr.accept("the") || ttr.accept("on"))
                    }

                    function decodeM() {
                        switch (ttr.symbol) {
                            case "january":
                                return 1;
                            case "february":
                                return 2;
                            case "march":
                                return 3;
                            case "april":
                                return 4;
                            case "may":
                                return 5;
                            case "june":
                                return 6;
                            case "july":
                                return 7;
                            case "august":
                                return 8;
                            case "september":
                                return 9;
                            case "october":
                                return 10;
                            case "november":
                                return 11;
                            case "december":
                                return 12;
                            default:
                                return false
                        }
                    }

                    function decodeWKD() {
                        switch (ttr.symbol) {
                            case "monday":
                            case "tuesday":
                            case "wednesday":
                            case "thursday":
                            case "friday":
                            case "saturday":
                            case "sunday":
                                return ttr.symbol.substr(0, 2).toUpperCase();
                            default:
                                return false
                        }
                    }

                    function decodeNTH() {
                        switch (ttr.symbol) {
                            case "last":
                                ttr.nextSymbol();
                                return -1;
                            case "first":
                                ttr.nextSymbol();
                                return 1;
                            case "second":
                                ttr.nextSymbol();
                                return ttr.accept("last") ? -2 : 2;
                            case "third":
                                ttr.nextSymbol();
                                return ttr.accept("last") ? -3 : 3;
                            case "nth":
                                var v = parseInt(ttr.value[1], 10);
                                if (v < -366 || v > 366) {
                                    throw new Error("Nth out of range: " + v)
                                }
                                ttr.nextSymbol();
                                return ttr.accept("last") ? -v : v;
                            default:
                                return false
                        }
                    }

                    function F() {
                        if ("until" === ttr.symbol) {
                            var date = Date.parse(ttr.text);
                            if (!date) {
                                throw new Error("Cannot parse until date:" + ttr.text)
                            }
                            options.until = new Date(date)
                        } else if (ttr.accept("for")) {
                            options.count = parseInt(ttr.value[0], 10);
                            ttr.expect("number")
                        }
                    }
                }
                var Frequency;
                ! function(Frequency) {
                    Frequency[Frequency.YEARLY = 0] = "YEARLY";
                    Frequency[Frequency.MONTHLY = 1] = "MONTHLY";
                    Frequency[Frequency.WEEKLY = 2] = "WEEKLY";
                    Frequency[Frequency.DAILY = 3] = "DAILY";
                    Frequency[Frequency.HOURLY = 4] = "HOURLY";
                    Frequency[Frequency.MINUTELY = 5] = "MINUTELY";
                    Frequency[Frequency.SECONDLY = 6] = "SECONDLY"
                }(Frequency || (Frequency = {}));

                function freqIsDailyOrGreater(freq) {
                    return freq < Frequency.HOURLY
                }
                /* !
                 * rrule.js - Library for working with recurrence rules for calendar dates.
                 * https://github.com/jakubroztocil/rrule
                 *
                 * Copyright 2010, Jakub Roztocil and Lars Schoning
                 * Licenced under the BSD licence.
                 * https://github.com/jakubroztocil/rrule/blob/master/LICENCE
                 *
                 */
                var fromText = function(text, language) {
                    if (void 0 === language) {
                        language = i18n
                    }
                    return new RRule(parseText(text, language) || void 0)
                };
                var common = ["count", "until", "interval", "byweekday", "bymonthday", "bymonth"];
                totext.IMPLEMENTED = [];
                totext.IMPLEMENTED[Frequency.HOURLY] = common;
                totext.IMPLEMENTED[Frequency.MINUTELY] = common;
                totext.IMPLEMENTED[Frequency.DAILY] = ["byhour"].concat(common);
                totext.IMPLEMENTED[Frequency.WEEKLY] = common;
                totext.IMPLEMENTED[Frequency.MONTHLY] = common;
                totext.IMPLEMENTED[Frequency.YEARLY] = ["byweekno", "byyearday"].concat(common);
                var isFullyConvertible = totext.isFullyConvertible;
                var Time = function() {
                    function Time(hour, minute, second, millisecond) {
                        this.hour = hour;
                        this.minute = minute;
                        this.second = second;
                        this.millisecond = millisecond || 0
                    }
                    Time.prototype.getHours = function() {
                        return this.hour
                    };
                    Time.prototype.getMinutes = function() {
                        return this.minute
                    };
                    Time.prototype.getSeconds = function() {
                        return this.second
                    };
                    Time.prototype.getMilliseconds = function() {
                        return this.millisecond
                    };
                    Time.prototype.getTime = function() {
                        return 1e3 * (60 * this.hour * 60 + 60 * this.minute + this.second) + this.millisecond
                    };
                    return Time
                }();
                var DateTime = function(_super) {
                    __extends(DateTime, _super);

                    function DateTime(year, month, day, hour, minute, second, millisecond) {
                        var _this = _super.call(this, hour, minute, second, millisecond) || this;
                        _this.year = year;
                        _this.month = month;
                        _this.day = day;
                        return _this
                    }
                    DateTime.fromDate = function(date) {
                        return new this(date.getUTCFullYear(), date.getUTCMonth() + 1, date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.valueOf() % 1e3)
                    };
                    DateTime.prototype.getWeekday = function() {
                        return getWeekday(new Date(this.getTime()))
                    };
                    DateTime.prototype.getTime = function() {
                        return new Date(Date.UTC(this.year, this.month - 1, this.day, this.hour, this.minute, this.second, this.millisecond)).getTime()
                    };
                    DateTime.prototype.getDay = function() {
                        return this.day
                    };
                    DateTime.prototype.getMonth = function() {
                        return this.month
                    };
                    DateTime.prototype.getYear = function() {
                        return this.year
                    };
                    DateTime.prototype.addYears = function(years) {
                        this.year += years
                    };
                    DateTime.prototype.addMonths = function(months) {
                        this.month += months;
                        if (this.month > 12) {
                            var yearDiv = Math.floor(this.month / 12);
                            var monthMod = pymod(this.month, 12);
                            this.month = monthMod;
                            this.year += yearDiv;
                            if (0 === this.month) {
                                this.month = 12;
                                --this.year
                            }
                        }
                    };
                    DateTime.prototype.addWeekly = function(days, wkst) {
                        if (wkst > this.getWeekday()) {
                            this.day += -(this.getWeekday() + 1 + (6 - wkst)) + 7 * days
                        } else {
                            this.day += -(this.getWeekday() - wkst) + 7 * days
                        }
                        this.fixDay()
                    };
                    DateTime.prototype.addDaily = function(days) {
                        this.day += days;
                        this.fixDay()
                    };
                    DateTime.prototype.addHours = function(hours, filtered, byhour) {
                        if (filtered) {
                            this.hour += Math.floor((23 - this.hour) / hours) * hours
                        }
                        for (;;) {
                            this.hour += hours;
                            var _a = divmod(this.hour, 24),
                                dayDiv = _a.div,
                                hourMod = _a.mod;
                            if (dayDiv) {
                                this.hour = hourMod;
                                this.addDaily(dayDiv)
                            }
                            if (empty(byhour) || includes(byhour, this.hour)) {
                                break
                            }
                        }
                    };
                    DateTime.prototype.addMinutes = function(minutes, filtered, byhour, byminute) {
                        if (filtered) {
                            this.minute += Math.floor((1439 - (60 * this.hour + this.minute)) / minutes) * minutes
                        }
                        for (;;) {
                            this.minute += minutes;
                            var _a = divmod(this.minute, 60),
                                hourDiv = _a.div,
                                minuteMod = _a.mod;
                            if (hourDiv) {
                                this.minute = minuteMod;
                                this.addHours(hourDiv, false, byhour)
                            }
                            if ((empty(byhour) || includes(byhour, this.hour)) && (empty(byminute) || includes(byminute, this.minute))) {
                                break
                            }
                        }
                    };
                    DateTime.prototype.addSeconds = function(seconds, filtered, byhour, byminute, bysecond) {
                        if (filtered) {
                            this.second += Math.floor((86399 - (3600 * this.hour + 60 * this.minute + this.second)) / seconds) * seconds
                        }
                        for (;;) {
                            this.second += seconds;
                            var _a = divmod(this.second, 60),
                                minuteDiv = _a.div,
                                secondMod = _a.mod;
                            if (minuteDiv) {
                                this.second = secondMod;
                                this.addMinutes(minuteDiv, false, byhour, byminute)
                            }
                            if ((empty(byhour) || includes(byhour, this.hour)) && (empty(byminute) || includes(byminute, this.minute)) && (empty(bysecond) || includes(bysecond, this.second))) {
                                break
                            }
                        }
                    };
                    DateTime.prototype.fixDay = function() {
                        if (this.day <= 28) {
                            return
                        }
                        var daysinmonth = monthRange(this.year, this.month - 1)[1];
                        if (this.day <= daysinmonth) {
                            return
                        }
                        while (this.day > daysinmonth) {
                            this.day -= daysinmonth;
                            ++this.month;
                            if (13 === this.month) {
                                this.month = 1;
                                ++this.year;
                                if (this.year > 9999) {
                                    return
                                }
                            }
                            daysinmonth = monthRange(this.year, this.month - 1)[1]
                        }
                    };
                    DateTime.prototype.add = function(options, filtered) {
                        var freq = options.freq,
                            interval = options.interval,
                            wkst = options.wkst,
                            byhour = options.byhour,
                            byminute = options.byminute,
                            bysecond = options.bysecond;
                        switch (freq) {
                            case Frequency.YEARLY:
                                return this.addYears(interval);
                            case Frequency.MONTHLY:
                                return this.addMonths(interval);
                            case Frequency.WEEKLY:
                                return this.addWeekly(interval, wkst);
                            case Frequency.DAILY:
                                return this.addDaily(interval);
                            case Frequency.HOURLY:
                                return this.addHours(interval, filtered, byhour);
                            case Frequency.MINUTELY:
                                return this.addMinutes(interval, filtered, byhour, byminute);
                            case Frequency.SECONDLY:
                                return this.addSeconds(interval, filtered, byhour, byminute, bysecond)
                        }
                    };
                    return DateTime
                }(Time);

                function initializeOptions(options) {
                    var invalid = [];
                    var keys = Object.keys(options);
                    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
                        var key = keys_1[_i];
                        if (!includes(defaultKeys, key)) {
                            invalid.push(key)
                        }
                        if (isDate(options[key]) && !isValidDate(options[key])) {
                            invalid.push(key)
                        }
                    }
                    if (invalid.length) {
                        throw new Error("Invalid options: " + invalid.join(", "))
                    }
                    return __assign({}, options)
                }

                function parseOptions(options) {
                    var opts = __assign(__assign({}, DEFAULT_OPTIONS), initializeOptions(options));
                    if (isPresent(opts.byeaster)) {
                        opts.freq = RRule.YEARLY
                    }
                    if (!(isPresent(opts.freq) && RRule.FREQUENCIES[opts.freq])) {
                        throw new Error("Invalid frequency: ".concat(opts.freq, " ").concat(options.freq))
                    }
                    if (!opts.dtstart) {
                        opts.dtstart = new Date((new Date).setMilliseconds(0))
                    }
                    if (!isPresent(opts.wkst)) {
                        opts.wkst = RRule.MO.weekday
                    } else if (isNumber(opts.wkst)) {} else {
                        opts.wkst = opts.wkst.weekday
                    }
                    if (isPresent(opts.bysetpos)) {
                        if (isNumber(opts.bysetpos)) {
                            opts.bysetpos = [opts.bysetpos]
                        }
                        for (var i = 0; i < opts.bysetpos.length; i++) {
                            var v = opts.bysetpos[i];
                            if (0 === v || !(v >= -366 && v <= 366)) {
                                throw new Error("bysetpos must be between 1 and 366, or between -366 and -1")
                            }
                        }
                    }
                    if (!(Boolean(opts.byweekno) || notEmpty(opts.byweekno) || notEmpty(opts.byyearday) || Boolean(opts.bymonthday) || notEmpty(opts.bymonthday) || isPresent(opts.byweekday) || isPresent(opts.byeaster))) {
                        switch (opts.freq) {
                            case RRule.YEARLY:
                                if (!opts.bymonth) {
                                    opts.bymonth = opts.dtstart.getUTCMonth() + 1
                                }
                                opts.bymonthday = opts.dtstart.getUTCDate();
                                break;
                            case RRule.MONTHLY:
                                opts.bymonthday = opts.dtstart.getUTCDate();
                                break;
                            case RRule.WEEKLY:
                                opts.byweekday = [getWeekday(opts.dtstart)]
                        }
                    }
                    if (isPresent(opts.bymonth) && !isArray(opts.bymonth)) {
                        opts.bymonth = [opts.bymonth]
                    }
                    if (isPresent(opts.byyearday) && !isArray(opts.byyearday) && isNumber(opts.byyearday)) {
                        opts.byyearday = [opts.byyearday]
                    }
                    if (!isPresent(opts.bymonthday)) {
                        opts.bymonthday = [];
                        opts.bynmonthday = []
                    } else if (isArray(opts.bymonthday)) {
                        var bymonthday = [];
                        var bynmonthday = [];
                        for (i = 0; i < opts.bymonthday.length; i++) {
                            v = opts.bymonthday[i];
                            if (v > 0) {
                                bymonthday.push(v)
                            } else if (v < 0) {
                                bynmonthday.push(v)
                            }
                        }
                        opts.bymonthday = bymonthday;
                        opts.bynmonthday = bynmonthday
                    } else if (opts.bymonthday < 0) {
                        opts.bynmonthday = [opts.bymonthday];
                        opts.bymonthday = []
                    } else {
                        opts.bynmonthday = [];
                        opts.bymonthday = [opts.bymonthday]
                    }
                    if (isPresent(opts.byweekno) && !isArray(opts.byweekno)) {
                        opts.byweekno = [opts.byweekno]
                    }
                    if (!isPresent(opts.byweekday)) {
                        opts.bynweekday = null
                    } else if (isNumber(opts.byweekday)) {
                        opts.byweekday = [opts.byweekday];
                        opts.bynweekday = null
                    } else if (isWeekdayStr(opts.byweekday)) {
                        opts.byweekday = [Weekday.fromStr(opts.byweekday).weekday];
                        opts.bynweekday = null
                    } else if (opts.byweekday instanceof Weekday) {
                        if (!opts.byweekday.n || opts.freq > RRule.MONTHLY) {
                            opts.byweekday = [opts.byweekday.weekday];
                            opts.bynweekday = null
                        } else {
                            opts.bynweekday = [
                                [opts.byweekday.weekday, opts.byweekday.n]
                            ];
                            opts.byweekday = null
                        }
                    } else {
                        var byweekday = [];
                        var bynweekday = [];
                        for (i = 0; i < opts.byweekday.length; i++) {
                            var wday = opts.byweekday[i];
                            if (isNumber(wday)) {
                                byweekday.push(wday);
                                continue
                            } else if (isWeekdayStr(wday)) {
                                byweekday.push(Weekday.fromStr(wday).weekday);
                                continue
                            }
                            if (!wday.n || opts.freq > RRule.MONTHLY) {
                                byweekday.push(wday.weekday)
                            } else {
                                bynweekday.push([wday.weekday, wday.n])
                            }
                        }
                        opts.byweekday = notEmpty(byweekday) ? byweekday : null;
                        opts.bynweekday = notEmpty(bynweekday) ? bynweekday : null
                    }
                    if (!isPresent(opts.byhour)) {
                        opts.byhour = opts.freq < RRule.HOURLY ? [opts.dtstart.getUTCHours()] : null
                    } else if (isNumber(opts.byhour)) {
                        opts.byhour = [opts.byhour]
                    }
                    if (!isPresent(opts.byminute)) {
                        opts.byminute = opts.freq < RRule.MINUTELY ? [opts.dtstart.getUTCMinutes()] : null
                    } else if (isNumber(opts.byminute)) {
                        opts.byminute = [opts.byminute]
                    }
                    if (!isPresent(opts.bysecond)) {
                        opts.bysecond = opts.freq < RRule.SECONDLY ? [opts.dtstart.getUTCSeconds()] : null
                    } else if (isNumber(opts.bysecond)) {
                        opts.bysecond = [opts.bysecond]
                    }
                    return {
                        parsedOptions: opts
                    }
                }

                function parseString(rfcString) {
                    var options = rfcString.split("\n").map(parseLine).filter((function(x) {
                        return null !== x
                    }));
                    return __assign(__assign({}, options[0]), options[1])
                }

                function parseDtstart(line) {
                    var options = {};
                    var dtstartWithZone = /DTSTART(?:;TZID=([^:=]+?))?(?::|=)([^;\s]+)/i.exec(line);
                    if (!dtstartWithZone) {
                        return options
                    }
                    var tzid = dtstartWithZone[1],
                        dtstart = dtstartWithZone[2];
                    if (tzid) {
                        options.tzid = tzid
                    }
                    options.dtstart = untilStringToDate(dtstart);
                    return options
                }

                function parseLine(rfcString) {
                    rfcString = rfcString.replace(/^\s+|\s+$/, "");
                    if (!rfcString.length) {
                        return null
                    }
                    var header = /^([A-Z]+?)[:;]/.exec(rfcString.toUpperCase());
                    if (!header) {
                        return parseRrule(rfcString)
                    }
                    var key = header[1];
                    switch (key.toUpperCase()) {
                        case "RRULE":
                        case "EXRULE":
                            return parseRrule(rfcString);
                        case "DTSTART":
                            return parseDtstart(rfcString);
                        default:
                            throw new Error("Unsupported RFC prop ".concat(key, " in ").concat(rfcString))
                    }
                }

                function parseRrule(line) {
                    var strippedLine = line.replace(/^RRULE:/i, "");
                    var options = parseDtstart(strippedLine);
                    var attrs = line.replace(/^(?:RRULE|EXRULE):/i, "").split(";");
                    attrs.forEach((function(attr) {
                        var _a = attr.split("="),
                            key = _a[0],
                            value = _a[1];
                        switch (key.toUpperCase()) {
                            case "FREQ":
                                options.freq = Frequency[value.toUpperCase()];
                                break;
                            case "WKST":
                                options.wkst = Days[value.toUpperCase()];
                                break;
                            case "COUNT":
                            case "INTERVAL":
                            case "BYSETPOS":
                            case "BYMONTH":
                            case "BYMONTHDAY":
                            case "BYYEARDAY":
                            case "BYWEEKNO":
                            case "BYHOUR":
                            case "BYMINUTE":
                            case "BYSECOND":
                                var num = function(value) {
                                    if (-1 !== value.indexOf(",")) {
                                        var values = value.split(",");
                                        return values.map(parseIndividualNumber)
                                    }
                                    return parseIndividualNumber(value)
                                }(value);
                                var optionKey = key.toLowerCase();
                                options[optionKey] = num;
                                break;
                            case "BYWEEKDAY":
                            case "BYDAY":
                                options.byweekday = function(value) {
                                    var days = value.split(",");
                                    return days.map((function(day) {
                                        if (2 === day.length) {
                                            return Days[day]
                                        }
                                        var parts = day.match(/^([+-]?\d{1,2})([A-Z]{2})$/);
                                        if (!parts || parts.length < 3) {
                                            throw new SyntaxError("Invalid weekday string: ".concat(day))
                                        }
                                        var n = Number(parts[1]);
                                        var wdaypart = parts[2];
                                        var wday = Days[wdaypart].weekday;
                                        return new Weekday(wday, n)
                                    }))
                                }(value);
                                break;
                            case "DTSTART":
                            case "TZID":
                                var dtstart = parseDtstart(line);
                                options.tzid = dtstart.tzid;
                                options.dtstart = dtstart.dtstart;
                                break;
                            case "UNTIL":
                                options.until = untilStringToDate(value);
                                break;
                            case "BYEASTER":
                                options.byeaster = Number(value);
                                break;
                            default:
                                throw new Error("Unknown RRULE property '" + key + "'")
                        }
                    }));
                    return options
                }

                function parseIndividualNumber(value) {
                    if (/^[+-]?\d+$/.test(value)) {
                        return Number(value)
                    }
                    return value
                }
                var DateWithZone = function() {
                    function DateWithZone(date, tzid) {
                        if (isNaN(date.getTime())) {
                            throw new RangeError("Invalid date passed to DateWithZone")
                        }
                        this.date = date;
                        this.tzid = tzid
                    }
                    Object.defineProperty(DateWithZone.prototype, "isUTC", {
                        get: function() {
                            return !this.tzid || "UTC" === this.tzid.toUpperCase()
                        },
                        enumerable: false,
                        configurable: true
                    });
                    DateWithZone.prototype.toString = function() {
                        var datestr = timeToUntilString(this.date.getTime(), this.isUTC);
                        if (!this.isUTC) {
                            return ";TZID=".concat(this.tzid, ":").concat(datestr)
                        }
                        return ":".concat(datestr)
                    };
                    DateWithZone.prototype.getTime = function() {
                        return this.date.getTime()
                    };
                    DateWithZone.prototype.rezonedDate = function() {
                        if (this.isUTC) {
                            return this.date
                        }
                        return function(date, timeZone) {
                            var localTimeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
                            var dateInLocalTZ = new Date(dateTZtoISO8601(date, localTimeZone));
                            var dateInTargetTZ = new Date(dateTZtoISO8601(date, null !== timeZone && void 0 !== timeZone ? timeZone : "UTC"));
                            var tzOffset = dateInTargetTZ.getTime() - dateInLocalTZ.getTime();
                            return new Date(date.getTime() - tzOffset)
                        }(this.date, this.tzid)
                    };
                    return DateWithZone
                }();

                function optionsToString(options) {
                    var rrule = [];
                    var dtstart = "";
                    var keys = Object.keys(options);
                    var defaultKeys = Object.keys(DEFAULT_OPTIONS);
                    for (var i = 0; i < keys.length; i++) {
                        if ("tzid" === keys[i]) {
                            continue
                        }
                        if (!includes(defaultKeys, keys[i])) {
                            continue
                        }
                        var key = keys[i].toUpperCase();
                        var value = options[keys[i]];
                        var outValue = "";
                        if (!isPresent(value) || isArray(value) && !value.length) {
                            continue
                        }
                        switch (key) {
                            case "FREQ":
                                outValue = RRule.FREQUENCIES[options.freq];
                                break;
                            case "WKST":
                                if (isNumber(value)) {
                                    outValue = new Weekday(value).toString()
                                } else {
                                    outValue = value.toString()
                                }
                                break;
                            case "BYWEEKDAY":
                                key = "BYDAY";
                                outValue = toArray(value).map((function(wday) {
                                    if (wday instanceof Weekday) {
                                        return wday
                                    }
                                    if (isArray(wday)) {
                                        return new Weekday(wday[0], wday[1])
                                    }
                                    return new Weekday(wday)
                                })).toString();
                                break;
                            case "DTSTART":
                                dtstart = buildDtstart(value, options.tzid);
                                break;
                            case "UNTIL":
                                outValue = timeToUntilString(value, !options.tzid);
                                break;
                            default:
                                if (isArray(value)) {
                                    var strValues = [];
                                    for (var j = 0; j < value.length; j++) {
                                        strValues[j] = String(value[j])
                                    }
                                    outValue = strValues.toString()
                                } else {
                                    outValue = String(value)
                                }
                        }
                        if (outValue) {
                            rrule.push([key, outValue])
                        }
                    }
                    var rules = rrule.map((function(_a) {
                        var key = _a[0],
                            value = _a[1];
                        return "".concat(key, "=").concat(value.toString())
                    })).join(";");
                    var ruleString = "";
                    if ("" !== rules) {
                        ruleString = "RRULE:".concat(rules)
                    }
                    return [dtstart, ruleString].filter((function(x) {
                        return !!x
                    })).join("\n")
                }

                function buildDtstart(dtstart, tzid) {
                    if (!dtstart) {
                        return ""
                    }
                    return "DTSTART" + new DateWithZone(new Date(dtstart), tzid).toString()
                }

                function argsMatch(left, right) {
                    if (Array.isArray(left)) {
                        if (!Array.isArray(right)) {
                            return false
                        }
                        if (left.length !== right.length) {
                            return false
                        }
                        return left.every((function(date, i) {
                            return date.getTime() === right[i].getTime()
                        }))
                    }
                    if (left instanceof Date) {
                        return right instanceof Date && left.getTime() === right.getTime()
                    }
                    return left === right
                }
                var Cache = function() {
                    function Cache() {
                        this.all = false;
                        this.before = [];
                        this.after = [];
                        this.between = []
                    }
                    Cache.prototype._cacheAdd = function(what, value, args) {
                        if (value) {
                            value = value instanceof Date ? dateutil_clone(value) : cloneDates(value)
                        }
                        if ("all" === what) {
                            this.all = value
                        } else {
                            args._value = value;
                            this[what].push(args)
                        }
                    };
                    Cache.prototype._cacheGet = function(what, args) {
                        var cached = false;
                        var argsKeys = args ? Object.keys(args) : [];
                        var findCacheDiff = function(item) {
                            for (var i = 0; i < argsKeys.length; i++) {
                                var key = argsKeys[i];
                                if (!argsMatch(args[key], item[key])) {
                                    return true
                                }
                            }
                            return false
                        };
                        var cachedObject = this[what];
                        if ("all" === what) {
                            cached = this.all
                        } else if (isArray(cachedObject)) {
                            for (var i = 0; i < cachedObject.length; i++) {
                                var item = cachedObject[i];
                                if (argsKeys.length && findCacheDiff(item)) {
                                    continue
                                }
                                cached = item._value;
                                break
                            }
                        }
                        if (!cached && this.all) {
                            var iterResult = new iterresult(what, args);
                            for (i = 0; i < this.all.length; i++) {
                                if (!iterResult.accept(this.all[i])) {
                                    break
                                }
                            }
                            cached = iterResult.getValue();
                            this._cacheAdd(what, cached, args)
                        }
                        return isArray(cached) ? cloneDates(cached) : cached instanceof Date ? dateutil_clone(cached) : cached
                    };
                    return Cache
                }();
                var M365MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], repeat(1, 31), true), repeat(2, 28), true), repeat(3, 31), true), repeat(4, 30), true), repeat(5, 31), true), repeat(6, 30), true), repeat(7, 31), true), repeat(8, 31), true), repeat(9, 30), true), repeat(10, 31), true), repeat(11, 30), true), repeat(12, 31), true), repeat(1, 7), true);
                var M366MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], repeat(1, 31), true), repeat(2, 29), true), repeat(3, 31), true), repeat(4, 30), true), repeat(5, 31), true), repeat(6, 30), true), repeat(7, 31), true), repeat(8, 31), true), repeat(9, 30), true), repeat(10, 31), true), repeat(11, 30), true), repeat(12, 31), true), repeat(1, 7), true);
                var M28 = range(1, 29);
                var M29 = range(1, 30);
                var M30 = range(1, 31);
                var M31 = range(1, 32);
                var MDAY366MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], M31, true), M29, true), M31, true), M30, true), M31, true), M30, true), M31, true), M31, true), M30, true), M31, true), M30, true), M31, true), M31.slice(0, 7), true);
                var MDAY365MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], M31, true), M28, true), M31, true), M30, true), M31, true), M30, true), M31, true), M31, true), M30, true), M31, true), M30, true), M31, true), M31.slice(0, 7), true);
                var NM28 = range(-28, 0);
                var NM29 = range(-29, 0);
                var NM30 = range(-30, 0);
                var NM31 = range(-31, 0);
                var NMDAY366MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], NM31, true), NM29, true), NM31, true), NM30, true), NM31, true), NM30, true), NM31, true), NM31, true), NM30, true), NM31, true), NM30, true), NM31, true), NM31.slice(0, 7), true);
                var NMDAY365MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], NM31, true), NM28, true), NM31, true), NM30, true), NM31, true), NM30, true), NM31, true), NM31, true), NM30, true), NM31, true), NM30, true), NM31, true), NM31.slice(0, 7), true);
                var M366RANGE = [0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366];
                var M365RANGE = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365];
                var WDAYMASK = function() {
                    var wdaymask = [];
                    for (var i = 0; i < 55; i++) {
                        wdaymask = wdaymask.concat(range(7))
                    }
                    return wdaymask
                }();

                function rebuildYear(year, options) {
                    var firstyday = datetime(year, 1, 1);
                    var yearlen = isLeapYear(year) ? 366 : 365;
                    var nextyearlen = isLeapYear(year + 1) ? 366 : 365;
                    var yearordinal = toOrdinal(firstyday);
                    var yearweekday = getWeekday(firstyday);
                    var result = __assign(__assign({
                        yearlen: yearlen,
                        nextyearlen: nextyearlen,
                        yearordinal: yearordinal,
                        yearweekday: yearweekday
                    }, function(year) {
                        var yearlen = isLeapYear(year) ? 366 : 365;
                        var firstyday = datetime(year, 1, 1);
                        var wday = getWeekday(firstyday);
                        if (365 === yearlen) {
                            return {
                                mmask: M365MASK,
                                mdaymask: MDAY365MASK,
                                nmdaymask: NMDAY365MASK,
                                wdaymask: WDAYMASK.slice(wday),
                                mrange: M365RANGE
                            }
                        }
                        return {
                            mmask: M366MASK,
                            mdaymask: MDAY366MASK,
                            nmdaymask: NMDAY366MASK,
                            wdaymask: WDAYMASK.slice(wday),
                            mrange: M366RANGE
                        }
                    }(year)), {
                        wnomask: null
                    });
                    if (empty(options.byweekno)) {
                        return result
                    }
                    result.wnomask = repeat(0, yearlen + 7);
                    var firstwkst;
                    var wyearlen;
                    var no1wkst = firstwkst = pymod(7 - yearweekday + options.wkst, 7);
                    if (no1wkst >= 4) {
                        no1wkst = 0;
                        wyearlen = result.yearlen + pymod(yearweekday - options.wkst, 7)
                    } else {
                        wyearlen = yearlen - no1wkst
                    }
                    var div = Math.floor(wyearlen / 7);
                    var mod = pymod(wyearlen, 7);
                    var numweeks = Math.floor(div + mod / 4);
                    for (var j = 0; j < options.byweekno.length; j++) {
                        var n = options.byweekno[j];
                        if (n < 0) {
                            n += numweeks + 1
                        }
                        if (!(n > 0 && n <= numweeks)) {
                            continue
                        }
                        var i = void 0;
                        if (n > 1) {
                            i = no1wkst + 7 * (n - 1);
                            if (no1wkst !== firstwkst) {
                                i -= 7 - firstwkst
                            }
                        } else {
                            i = no1wkst
                        }
                        for (var k = 0; k < 7; k++) {
                            result.wnomask[i] = 1;
                            i++;
                            if (result.wdaymask[i] === options.wkst) {
                                break
                            }
                        }
                    }
                    if (includes(options.byweekno, 1)) {
                        i = no1wkst + 7 * numweeks;
                        if (no1wkst !== firstwkst) {
                            i -= 7 - firstwkst
                        }
                        if (i < yearlen) {
                            for (j = 0; j < 7; j++) {
                                result.wnomask[i] = 1;
                                i += 1;
                                if (result.wdaymask[i] === options.wkst) {
                                    break
                                }
                            }
                        }
                    }
                    if (no1wkst) {
                        var lnumweeks = void 0;
                        if (!includes(options.byweekno, -1)) {
                            var lyearweekday = getWeekday(datetime(year - 1, 1, 1));
                            var lno1wkst = pymod(7 - lyearweekday.valueOf() + options.wkst, 7);
                            var lyearlen = isLeapYear(year - 1) ? 366 : 365;
                            var weekst = void 0;
                            if (lno1wkst >= 4) {
                                lno1wkst = 0;
                                weekst = lyearlen + pymod(lyearweekday - options.wkst, 7)
                            } else {
                                weekst = yearlen - no1wkst
                            }
                            lnumweeks = Math.floor(52 + pymod(weekst, 7) / 4)
                        } else {
                            lnumweeks = -1
                        }
                        if (includes(options.byweekno, lnumweeks)) {
                            for (i = 0; i < no1wkst; i++) {
                                result.wnomask[i] = 1
                            }
                        }
                    }
                    return result
                }
                var Iterinfo = function() {
                    function Iterinfo(options) {
                        this.options = options
                    }
                    Iterinfo.prototype.rebuild = function(year, month) {
                        var options = this.options;
                        if (year !== this.lastyear) {
                            this.yearinfo = rebuildYear(year, options)
                        }
                        if (notEmpty(options.bynweekday) && (month !== this.lastmonth || year !== this.lastyear)) {
                            var _a = this.yearinfo,
                                yearlen = _a.yearlen,
                                mrange = _a.mrange,
                                wdaymask = _a.wdaymask;
                            this.monthinfo = function(year, month, yearlen, mrange, wdaymask, options) {
                                var result = {
                                    lastyear: year,
                                    lastmonth: month,
                                    nwdaymask: []
                                };
                                var ranges = [];
                                if (options.freq === RRule.YEARLY) {
                                    if (empty(options.bymonth)) {
                                        ranges = [
                                            [0, yearlen]
                                        ]
                                    } else {
                                        for (var j = 0; j < options.bymonth.length; j++) {
                                            month = options.bymonth[j];
                                            ranges.push(mrange.slice(month - 1, month + 1))
                                        }
                                    }
                                } else if (options.freq === RRule.MONTHLY) {
                                    ranges = [mrange.slice(month - 1, month + 1)]
                                }
                                if (empty(ranges)) {
                                    return result
                                }
                                result.nwdaymask = repeat(0, yearlen);
                                for (j = 0; j < ranges.length; j++) {
                                    var rang = ranges[j];
                                    var first = rang[0];
                                    var last = rang[1] - 1;
                                    for (var k = 0; k < options.bynweekday.length; k++) {
                                        var i = void 0;
                                        var _a = options.bynweekday[k],
                                            wday = _a[0],
                                            n = _a[1];
                                        if (n < 0) {
                                            i = last + 7 * (n + 1);
                                            i -= pymod(wdaymask[i] - wday, 7)
                                        } else {
                                            i = first + 7 * (n - 1);
                                            i += pymod(7 - wdaymask[i] + wday, 7)
                                        }
                                        if (first <= i && i <= last) {
                                            result.nwdaymask[i] = 1
                                        }
                                    }
                                }
                                return result
                            }(year, month, yearlen, mrange, wdaymask, options)
                        }
                        if (isPresent(options.byeaster)) {
                            this.eastermask = function(y, offset) {
                                if (void 0 === offset) {
                                    offset = 0
                                }
                                var a = y % 19;
                                var b = Math.floor(y / 100);
                                var c = y % 100;
                                var d = Math.floor(b / 4);
                                var e = b % 4;
                                var f = Math.floor((b + 8) / 25);
                                var g = Math.floor((b - f + 1) / 3);
                                var h = Math.floor(19 * a + b - d - g + 15) % 30;
                                var i = Math.floor(c / 4);
                                var k = c % 4;
                                var l = Math.floor(32 + 2 * e + 2 * i - h - k) % 7;
                                var m = Math.floor((a + 11 * h + 22 * l) / 451);
                                var month = Math.floor((h + l - 7 * m + 114) / 31);
                                var day = (h + l - 7 * m + 114) % 31 + 1;
                                var date = Date.UTC(y, month - 1, day + offset);
                                var yearStart = Date.UTC(y, 0, 1);
                                return [Math.ceil((date - yearStart) / 864e5)]
                            }(year, options.byeaster)
                        }
                    };
                    Object.defineProperty(Iterinfo.prototype, "lastyear", {
                        get: function() {
                            return this.monthinfo ? this.monthinfo.lastyear : null
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "lastmonth", {
                        get: function() {
                            return this.monthinfo ? this.monthinfo.lastmonth : null
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "yearlen", {
                        get: function() {
                            return this.yearinfo.yearlen
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "yearordinal", {
                        get: function() {
                            return this.yearinfo.yearordinal
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "mrange", {
                        get: function() {
                            return this.yearinfo.mrange
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "wdaymask", {
                        get: function() {
                            return this.yearinfo.wdaymask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "mmask", {
                        get: function() {
                            return this.yearinfo.mmask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "wnomask", {
                        get: function() {
                            return this.yearinfo.wnomask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "nwdaymask", {
                        get: function() {
                            return this.monthinfo ? this.monthinfo.nwdaymask : []
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "nextyearlen", {
                        get: function() {
                            return this.yearinfo.nextyearlen
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "mdaymask", {
                        get: function() {
                            return this.yearinfo.mdaymask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "nmdaymask", {
                        get: function() {
                            return this.yearinfo.nmdaymask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Iterinfo.prototype.ydayset = function() {
                        return [range(this.yearlen), 0, this.yearlen]
                    };
                    Iterinfo.prototype.mdayset = function(_, month) {
                        var start = this.mrange[month - 1];
                        var end = this.mrange[month];
                        var set = repeat(null, this.yearlen);
                        for (var i = start; i < end; i++) {
                            set[i] = i
                        }
                        return [set, start, end]
                    };
                    Iterinfo.prototype.wdayset = function(year, month, day) {
                        var set = repeat(null, this.yearlen + 7);
                        var i = toOrdinal(datetime(year, month, day)) - this.yearordinal;
                        var start = i;
                        for (var j = 0; j < 7; j++) {
                            set[i] = i;
                            ++i;
                            if (this.wdaymask[i] === this.options.wkst) {
                                break
                            }
                        }
                        return [set, start, i]
                    };
                    Iterinfo.prototype.ddayset = function(year, month, day) {
                        var set = repeat(null, this.yearlen);
                        var i = toOrdinal(datetime(year, month, day)) - this.yearordinal;
                        set[i] = i;
                        return [set, i, i + 1]
                    };
                    Iterinfo.prototype.htimeset = function(hour, _, second, millisecond) {
                        var _this = this;
                        var set = [];
                        this.options.byminute.forEach((function(minute) {
                            set = set.concat(_this.mtimeset(hour, minute, second, millisecond))
                        }));
                        sort(set);
                        return set
                    };
                    Iterinfo.prototype.mtimeset = function(hour, minute, _, millisecond) {
                        var set = this.options.bysecond.map((function(second) {
                            return new Time(hour, minute, second, millisecond)
                        }));
                        sort(set);
                        return set
                    };
                    Iterinfo.prototype.stimeset = function(hour, minute, second, millisecond) {
                        return [new Time(hour, minute, second, millisecond)]
                    };
                    Iterinfo.prototype.getdayset = function(freq) {
                        switch (freq) {
                            case Frequency.YEARLY:
                                return this.ydayset.bind(this);
                            case Frequency.MONTHLY:
                                return this.mdayset.bind(this);
                            case Frequency.WEEKLY:
                                return this.wdayset.bind(this);
                            case Frequency.DAILY:
                            default:
                                return this.ddayset.bind(this)
                        }
                    };
                    Iterinfo.prototype.gettimeset = function(freq) {
                        switch (freq) {
                            case Frequency.HOURLY:
                                return this.htimeset.bind(this);
                            case Frequency.MINUTELY:
                                return this.mtimeset.bind(this);
                            case Frequency.SECONDLY:
                                return this.stimeset.bind(this)
                        }
                    };
                    return Iterinfo
                }();
                var iterinfo = Iterinfo;

                function buildPoslist(bysetpos, timeset, start, end, ii, dayset) {
                    var poslist = [];
                    for (var j = 0; j < bysetpos.length; j++) {
                        var daypos = void 0;
                        var timepos = void 0;
                        var pos = bysetpos[j];
                        if (pos < 0) {
                            daypos = Math.floor(pos / timeset.length);
                            timepos = pymod(pos, timeset.length)
                        } else {
                            daypos = Math.floor((pos - 1) / timeset.length);
                            timepos = pymod(pos - 1, timeset.length)
                        }
                        var tmp = [];
                        for (var k = start; k < end; k++) {
                            var val = dayset[k];
                            if (!isPresent(val)) {
                                continue
                            }
                            tmp.push(val)
                        }
                        var i = void 0;
                        if (daypos < 0) {
                            i = tmp.slice(daypos)[0]
                        } else {
                            i = tmp[daypos]
                        }
                        var time = timeset[timepos];
                        var date = fromOrdinal(ii.yearordinal + i);
                        var res = combine(date, time);
                        if (!includes(poslist, res)) {
                            poslist.push(res)
                        }
                    }
                    sort(poslist);
                    return poslist
                }

                function iter(iterResult, options) {
                    var dtstart = options.dtstart,
                        freq = options.freq,
                        interval = options.interval,
                        until = options.until,
                        bysetpos = options.bysetpos;
                    var count = options.count;
                    if (0 === count || 0 === interval) {
                        return emitResult(iterResult)
                    }
                    var counterDate = DateTime.fromDate(dtstart);
                    var ii = new iterinfo(options);
                    ii.rebuild(counterDate.year, counterDate.month);
                    var timeset = function(ii, counterDate, options) {
                        var freq = options.freq,
                            byhour = options.byhour,
                            byminute = options.byminute,
                            bysecond = options.bysecond;
                        if (freqIsDailyOrGreater(freq)) {
                            return function(opts) {
                                var millisecondModulo = opts.dtstart.getTime() % 1e3;
                                if (!freqIsDailyOrGreater(opts.freq)) {
                                    return []
                                }
                                var timeset = [];
                                opts.byhour.forEach((function(hour) {
                                    opts.byminute.forEach((function(minute) {
                                        opts.bysecond.forEach((function(second) {
                                            timeset.push(new Time(hour, minute, second, millisecondModulo))
                                        }))
                                    }))
                                }));
                                return timeset
                            }(options)
                        }
                        if (freq >= RRule.HOURLY && notEmpty(byhour) && !includes(byhour, counterDate.hour) || freq >= RRule.MINUTELY && notEmpty(byminute) && !includes(byminute, counterDate.minute) || freq >= RRule.SECONDLY && notEmpty(bysecond) && !includes(bysecond, counterDate.second)) {
                            return []
                        }
                        return ii.gettimeset(freq)(counterDate.hour, counterDate.minute, counterDate.second, counterDate.millisecond)
                    }(ii, counterDate, options);
                    for (;;) {
                        var _a = ii.getdayset(freq)(counterDate.year, counterDate.month, counterDate.day),
                            dayset = _a[0],
                            start = _a[1],
                            end = _a[2];
                        var filtered = removeFilteredDays(dayset, start, end, ii, options);
                        if (notEmpty(bysetpos)) {
                            var poslist = buildPoslist(bysetpos, timeset, start, end, ii, dayset);
                            for (var j = 0; j < poslist.length; j++) {
                                var res = poslist[j];
                                if (until && res > until) {
                                    return emitResult(iterResult)
                                }
                                if (res >= dtstart) {
                                    var rezonedDate = rezoneIfNeeded(res, options);
                                    if (!iterResult.accept(rezonedDate)) {
                                        return emitResult(iterResult)
                                    }
                                    if (count) {
                                        --count;
                                        if (!count) {
                                            return emitResult(iterResult)
                                        }
                                    }
                                }
                            }
                        } else {
                            for (j = start; j < end; j++) {
                                var currentDay = dayset[j];
                                if (!isPresent(currentDay)) {
                                    continue
                                }
                                var date = fromOrdinal(ii.yearordinal + currentDay);
                                for (var k = 0; k < timeset.length; k++) {
                                    var time = timeset[k];
                                    res = combine(date, time);
                                    if (until && res > until) {
                                        return emitResult(iterResult)
                                    }
                                    if (res >= dtstart) {
                                        rezonedDate = rezoneIfNeeded(res, options);
                                        if (!iterResult.accept(rezonedDate)) {
                                            return emitResult(iterResult)
                                        }
                                        if (count) {
                                            --count;
                                            if (!count) {
                                                return emitResult(iterResult)
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if (0 === options.interval) {
                            return emitResult(iterResult)
                        }
                        counterDate.add(options, filtered);
                        if (counterDate.year > 9999) {
                            return emitResult(iterResult)
                        }
                        if (!freqIsDailyOrGreater(freq)) {
                            timeset = ii.gettimeset(freq)(counterDate.hour, counterDate.minute, counterDate.second, 0)
                        }
                        ii.rebuild(counterDate.year, counterDate.month)
                    }
                }

                function isFiltered(ii, currentDay, options) {
                    var bymonth = options.bymonth,
                        byweekno = options.byweekno,
                        byweekday = options.byweekday,
                        byeaster = options.byeaster,
                        bymonthday = options.bymonthday,
                        bynmonthday = options.bynmonthday,
                        byyearday = options.byyearday;
                    return notEmpty(bymonth) && !includes(bymonth, ii.mmask[currentDay]) || notEmpty(byweekno) && !ii.wnomask[currentDay] || notEmpty(byweekday) && !includes(byweekday, ii.wdaymask[currentDay]) || notEmpty(ii.nwdaymask) && !ii.nwdaymask[currentDay] || null !== byeaster && !includes(ii.eastermask, currentDay) || (notEmpty(bymonthday) || notEmpty(bynmonthday)) && !includes(bymonthday, ii.mdaymask[currentDay]) && !includes(bynmonthday, ii.nmdaymask[currentDay]) || notEmpty(byyearday) && (currentDay < ii.yearlen && !includes(byyearday, currentDay + 1) && !includes(byyearday, -ii.yearlen + currentDay) || currentDay >= ii.yearlen && !includes(byyearday, currentDay + 1 - ii.yearlen) && !includes(byyearday, -ii.nextyearlen + currentDay - ii.yearlen))
                }

                function rezoneIfNeeded(date, options) {
                    return new DateWithZone(date, options.tzid).rezonedDate()
                }

                function emitResult(iterResult) {
                    return iterResult.getValue()
                }

                function removeFilteredDays(dayset, start, end, ii, options) {
                    var filtered = false;
                    for (var dayCounter = start; dayCounter < end; dayCounter++) {
                        var currentDay = dayset[dayCounter];
                        filtered = isFiltered(ii, currentDay, options);
                        if (filtered) {
                            dayset[currentDay] = null
                        }
                    }
                    return filtered
                }
                var Days = {
                    MO: new Weekday(0),
                    TU: new Weekday(1),
                    WE: new Weekday(2),
                    TH: new Weekday(3),
                    FR: new Weekday(4),
                    SA: new Weekday(5),
                    SU: new Weekday(6)
                };
                var DEFAULT_OPTIONS = {
                    freq: Frequency.YEARLY,
                    dtstart: null,
                    interval: 1,
                    wkst: Days.MO,
                    count: null,
                    until: null,
                    tzid: null,
                    bysetpos: null,
                    bymonth: null,
                    bymonthday: null,
                    bynmonthday: null,
                    byyearday: null,
                    byweekno: null,
                    byweekday: null,
                    bynweekday: null,
                    byhour: null,
                    byminute: null,
                    bysecond: null,
                    byeaster: null
                };
                var defaultKeys = Object.keys(DEFAULT_OPTIONS);
                var RRule = function() {
                    function RRule(options, noCache) {
                        if (void 0 === options) {
                            options = {}
                        }
                        if (void 0 === noCache) {
                            noCache = false
                        }
                        this._cache = noCache ? null : new Cache;
                        this.origOptions = initializeOptions(options);
                        var parsedOptions = parseOptions(options).parsedOptions;
                        this.options = parsedOptions
                    }
                    RRule.parseText = function(text, language) {
                        return parseText(text, language)
                    };
                    RRule.fromText = function(text, language) {
                        return fromText(text, language)
                    };
                    RRule.fromString = function(str) {
                        return new RRule(RRule.parseString(str) || void 0)
                    };
                    RRule.prototype._iter = function(iterResult) {
                        return iter(iterResult, this.options)
                    };
                    RRule.prototype._cacheGet = function(what, args) {
                        if (!this._cache) {
                            return false
                        }
                        return this._cache._cacheGet(what, args)
                    };
                    RRule.prototype._cacheAdd = function(what, value, args) {
                        if (!this._cache) {
                            return
                        }
                        return this._cache._cacheAdd(what, value, args)
                    };
                    RRule.prototype.all = function(iterator) {
                        if (iterator) {
                            return this._iter(new callbackiterresult("all", {}, iterator))
                        }
                        var result = this._cacheGet("all");
                        if (false === result) {
                            result = this._iter(new iterresult("all", {}));
                            this._cacheAdd("all", result)
                        }
                        return result
                    };
                    RRule.prototype.between = function(after, before, inc, iterator) {
                        if (void 0 === inc) {
                            inc = false
                        }
                        if (!isValidDate(after) || !isValidDate(before)) {
                            throw new Error("Invalid date passed in to RRule.between")
                        }
                        var args = {
                            before: before,
                            after: after,
                            inc: inc
                        };
                        if (iterator) {
                            return this._iter(new callbackiterresult("between", args, iterator))
                        }
                        var result = this._cacheGet("between", args);
                        if (false === result) {
                            result = this._iter(new iterresult("between", args));
                            this._cacheAdd("between", result, args)
                        }
                        return result
                    };
                    RRule.prototype.before = function(dt, inc) {
                        if (void 0 === inc) {
                            inc = false
                        }
                        if (!isValidDate(dt)) {
                            throw new Error("Invalid date passed in to RRule.before")
                        }
                        var args = {
                            dt: dt,
                            inc: inc
                        };
                        var result = this._cacheGet("before", args);
                        if (false === result) {
                            result = this._iter(new iterresult("before", args));
                            this._cacheAdd("before", result, args)
                        }
                        return result
                    };
                    RRule.prototype.after = function(dt, inc) {
                        if (void 0 === inc) {
                            inc = false
                        }
                        if (!isValidDate(dt)) {
                            throw new Error("Invalid date passed in to RRule.after")
                        }
                        var args = {
                            dt: dt,
                            inc: inc
                        };
                        var result = this._cacheGet("after", args);
                        if (false === result) {
                            result = this._iter(new iterresult("after", args));
                            this._cacheAdd("after", result, args)
                        }
                        return result
                    };
                    RRule.prototype.count = function() {
                        return this.all().length
                    };
                    RRule.prototype.toString = function() {
                        return optionsToString(this.origOptions)
                    };
                    RRule.prototype.toText = function(gettext, language, dateFormatter) {
                        return function(rrule, gettext, language, dateFormatter) {
                            return new totext(rrule, gettext, language, dateFormatter).toString()
                        }(this, gettext, language, dateFormatter)
                    };
                    RRule.prototype.isFullyConvertibleToText = function() {
                        return isFullyConvertible(this)
                    };
                    RRule.prototype.clone = function() {
                        return new RRule(this.origOptions)
                    };
                    RRule.FREQUENCIES = ["YEARLY", "MONTHLY", "WEEKLY", "DAILY", "HOURLY", "MINUTELY", "SECONDLY"];
                    RRule.YEARLY = Frequency.YEARLY;
                    RRule.MONTHLY = Frequency.MONTHLY;
                    RRule.WEEKLY = Frequency.WEEKLY;
                    RRule.DAILY = Frequency.DAILY;
                    RRule.HOURLY = Frequency.HOURLY;
                    RRule.MINUTELY = Frequency.MINUTELY;
                    RRule.SECONDLY = Frequency.SECONDLY;
                    RRule.MO = Days.MO;
                    RRule.TU = Days.TU;
                    RRule.WE = Days.WE;
                    RRule.TH = Days.TH;
                    RRule.FR = Days.FR;
                    RRule.SA = Days.SA;
                    RRule.SU = Days.SU;
                    RRule.parseString = parseString;
                    RRule.optionsToString = optionsToString;
                    return RRule
                }();
                var rrulestr_DEFAULT_OPTIONS = {
                    dtstart: null,
                    cache: false,
                    unfold: false,
                    forceset: false,
                    compatible: false,
                    tzid: null
                };

                function parseInput(s, options) {
                    var rrulevals = [];
                    var rdatevals = [];
                    var exrulevals = [];
                    var exdatevals = [];
                    var parsedDtstart = parseDtstart(s);
                    var dtstart = parsedDtstart.dtstart;
                    var tzid = parsedDtstart.tzid;
                    var lines = function(s, unfold) {
                        if (void 0 === unfold) {
                            unfold = false
                        }
                        s = s && s.trim();
                        if (!s) {
                            throw new Error("Invalid empty string")
                        }
                        if (!unfold) {
                            return s.split(/\s/)
                        }
                        var lines = s.split("\n");
                        var i = 0;
                        while (i < lines.length) {
                            var line = lines[i] = lines[i].replace(/\s+$/g, "");
                            if (!line) {
                                lines.splice(i, 1)
                            } else if (i > 0 && " " === line[0]) {
                                lines[i - 1] += line.slice(1);
                                lines.splice(i, 1)
                            } else {
                                i += 1
                            }
                        }
                        return lines
                    }(s, options.unfold);
                    lines.forEach((function(line) {
                        var _a;
                        if (!line) {
                            return
                        }
                        var _b = function(line) {
                                var _a = function(line) {
                                        if (-1 === line.indexOf(":")) {
                                            return {
                                                name: "RRULE",
                                                value: line
                                            }
                                        }
                                        var _a = (str = line, sep = ":", num = 1, splits = str.split(sep), num ? splits.slice(0, num).concat([splits.slice(num).join(sep)]) : splits),
                                            name = _a[0],
                                            value = _a[1];
                                        var str, sep, num, splits;
                                        return {
                                            name: name,
                                            value: value
                                        }
                                    }(line),
                                    name = _a.name,
                                    value = _a.value;
                                var parms = name.split(";");
                                if (!parms) {
                                    throw new Error("empty property name")
                                }
                                return {
                                    name: parms[0].toUpperCase(),
                                    parms: parms.slice(1),
                                    value: value
                                }
                            }(line),
                            name = _b.name,
                            parms = _b.parms,
                            value = _b.value;
                        switch (name.toUpperCase()) {
                            case "RRULE":
                                if (parms.length) {
                                    throw new Error("unsupported RRULE parm: ".concat(parms.join(",")))
                                }
                                rrulevals.push(parseString(line));
                                break;
                            case "RDATE":
                                var _c = null !== (_a = /RDATE(?:;TZID=([^:=]+))?/i.exec(line)) && void 0 !== _a ? _a : [],
                                    rdateTzid = _c[1];
                                if (rdateTzid && !tzid) {
                                    tzid = rdateTzid
                                }
                                rdatevals = rdatevals.concat(parseRDate(value, parms));
                                break;
                            case "EXRULE":
                                if (parms.length) {
                                    throw new Error("unsupported EXRULE parm: ".concat(parms.join(",")))
                                }
                                exrulevals.push(parseString(value));
                                break;
                            case "EXDATE":
                                exdatevals = exdatevals.concat(parseRDate(value, parms));
                                break;
                            case "DTSTART":
                                break;
                            default:
                                throw new Error("unsupported property: " + name)
                        }
                    }));
                    return {
                        dtstart: dtstart,
                        tzid: tzid,
                        rrulevals: rrulevals,
                        rdatevals: rdatevals,
                        exrulevals: exrulevals,
                        exdatevals: exdatevals
                    }
                }

                function rrulestr(s, options) {
                    if (void 0 === options) {
                        options = {}
                    }
                    return function(s, options) {
                        var _a = parseInput(s, options),
                            rrulevals = _a.rrulevals,
                            rdatevals = _a.rdatevals,
                            exrulevals = _a.exrulevals,
                            exdatevals = _a.exdatevals,
                            dtstart = _a.dtstart,
                            tzid = _a.tzid;
                        var noCache = false === options.cache;
                        if (options.compatible) {
                            options.forceset = true;
                            options.unfold = true
                        }
                        if (options.forceset || rrulevals.length > 1 || rdatevals.length || exrulevals.length || exdatevals.length) {
                            var rset_1 = new RRuleSet(noCache);
                            rset_1.dtstart(dtstart);
                            rset_1.tzid(tzid || void 0);
                            rrulevals.forEach((function(val) {
                                rset_1.rrule(new RRule(groomRruleOptions(val, dtstart, tzid), noCache))
                            }));
                            rdatevals.forEach((function(date) {
                                rset_1.rdate(date)
                            }));
                            exrulevals.forEach((function(val) {
                                rset_1.exrule(new RRule(groomRruleOptions(val, dtstart, tzid), noCache))
                            }));
                            exdatevals.forEach((function(date) {
                                rset_1.exdate(date)
                            }));
                            if (options.compatible && options.dtstart) {
                                rset_1.rdate(dtstart)
                            }
                            return rset_1
                        }
                        var val = rrulevals[0] || {};
                        return new RRule(groomRruleOptions(val, val.dtstart || options.dtstart || dtstart, val.tzid || options.tzid || tzid), noCache)
                    }(s, function(options) {
                        var invalid = [];
                        var keys = Object.keys(options);
                        var defaultKeys = Object.keys(rrulestr_DEFAULT_OPTIONS);
                        keys.forEach((function(key) {
                            if (!includes(defaultKeys, key)) {
                                invalid.push(key)
                            }
                        }));
                        if (invalid.length) {
                            throw new Error("Invalid options: " + invalid.join(", "))
                        }
                        return __assign(__assign({}, rrulestr_DEFAULT_OPTIONS), options)
                    }(options))
                }

                function groomRruleOptions(val, dtstart, tzid) {
                    return __assign(__assign({}, val), {
                        dtstart: dtstart,
                        tzid: tzid
                    })
                }

                function parseRDate(rdateval, parms) {
                    ! function(parms) {
                        parms.forEach((function(parm) {
                            if (!/(VALUE=DATE(-TIME)?)|(TZID=)/.test(parm)) {
                                throw new Error("unsupported RDATE/EXDATE parm: " + parm)
                            }
                        }))
                    }(parms);
                    return rdateval.split(",").map((function(datestr) {
                        return untilStringToDate(datestr)
                    }))
                }

                function createGetterSetter(fieldName) {
                    var _this = this;
                    return function(field) {
                        if (void 0 !== field) {
                            _this["_".concat(fieldName)] = field
                        }
                        if (void 0 !== _this["_".concat(fieldName)]) {
                            return _this["_".concat(fieldName)]
                        }
                        for (var i = 0; i < _this._rrule.length; i++) {
                            var field_1 = _this._rrule[i].origOptions[fieldName];
                            if (field_1) {
                                return field_1
                            }
                        }
                    }
                }
                var RRuleSet = function(_super) {
                    __extends(RRuleSet, _super);

                    function RRuleSet(noCache) {
                        if (void 0 === noCache) {
                            noCache = false
                        }
                        var _this = _super.call(this, {}, noCache) || this;
                        _this.dtstart = createGetterSetter.apply(_this, ["dtstart"]);
                        _this.tzid = createGetterSetter.apply(_this, ["tzid"]);
                        _this._rrule = [];
                        _this._rdate = [];
                        _this._exrule = [];
                        _this._exdate = [];
                        return _this
                    }
                    RRuleSet.prototype._iter = function(iterResult) {
                        return function(iterResult, _rrule, _exrule, _rdate, _exdate, tzid) {
                            var _exdateHash = {};
                            var _accept = iterResult.accept;

                            function evalExdate(after, before) {
                                _exrule.forEach((function(rrule) {
                                    rrule.between(after, before, true).forEach((function(date) {
                                        _exdateHash[Number(date)] = true
                                    }))
                                }))
                            }
                            _exdate.forEach((function(date) {
                                var zonedDate = new DateWithZone(date, tzid).rezonedDate();
                                _exdateHash[Number(zonedDate)] = true
                            }));
                            iterResult.accept = function(date) {
                                var dt = Number(date);
                                if (isNaN(dt)) {
                                    return _accept.call(this, date)
                                }
                                if (!_exdateHash[dt]) {
                                    evalExdate(new Date(dt - 1), new Date(dt + 1));
                                    if (!_exdateHash[dt]) {
                                        _exdateHash[dt] = true;
                                        return _accept.call(this, date)
                                    }
                                }
                                return true
                            };
                            if ("between" === iterResult.method) {
                                evalExdate(iterResult.args.after, iterResult.args.before);
                                iterResult.accept = function(date) {
                                    var dt = Number(date);
                                    if (!_exdateHash[dt]) {
                                        _exdateHash[dt] = true;
                                        return _accept.call(this, date)
                                    }
                                    return true
                                }
                            }
                            for (var i = 0; i < _rdate.length; i++) {
                                var zonedDate = new DateWithZone(_rdate[i], tzid).rezonedDate();
                                if (!iterResult.accept(new Date(zonedDate.getTime()))) {
                                    break
                                }
                            }
                            _rrule.forEach((function(rrule) {
                                iter(iterResult, rrule.options)
                            }));
                            var res = iterResult._result;
                            sort(res);
                            switch (iterResult.method) {
                                case "all":
                                case "between":
                                    return res;
                                case "before":
                                    return res.length && res[res.length - 1] || null;
                                case "after":
                                default:
                                    return res.length && res[0] || null
                            }
                        }(iterResult, this._rrule, this._exrule, this._rdate, this._exdate, this.tzid())
                    };
                    RRuleSet.prototype.rrule = function(rrule) {
                        _addRule(rrule, this._rrule)
                    };
                    RRuleSet.prototype.exrule = function(rrule) {
                        _addRule(rrule, this._exrule)
                    };
                    RRuleSet.prototype.rdate = function(date) {
                        _addDate(date, this._rdate)
                    };
                    RRuleSet.prototype.exdate = function(date) {
                        _addDate(date, this._exdate)
                    };
                    RRuleSet.prototype.rrules = function() {
                        return this._rrule.map((function(e) {
                            return rrulestr(e.toString())
                        }))
                    };
                    RRuleSet.prototype.exrules = function() {
                        return this._exrule.map((function(e) {
                            return rrulestr(e.toString())
                        }))
                    };
                    RRuleSet.prototype.rdates = function() {
                        return this._rdate.map((function(e) {
                            return new Date(e.getTime())
                        }))
                    };
                    RRuleSet.prototype.exdates = function() {
                        return this._exdate.map((function(e) {
                            return new Date(e.getTime())
                        }))
                    };
                    RRuleSet.prototype.valueOf = function() {
                        var result = [];
                        if (!this._rrule.length && this._dtstart) {
                            result = result.concat(optionsToString({
                                dtstart: this._dtstart
                            }))
                        }
                        this._rrule.forEach((function(rrule) {
                            result = result.concat(rrule.toString().split("\n"))
                        }));
                        this._exrule.forEach((function(exrule) {
                            result = result.concat(exrule.toString().split("\n").map((function(line) {
                                return line.replace(/^RRULE:/, "EXRULE:")
                            })).filter((function(line) {
                                return !/^DTSTART/.test(line)
                            })))
                        }));
                        if (this._rdate.length) {
                            result.push(rdatesToString("RDATE", this._rdate, this.tzid()))
                        }
                        if (this._exdate.length) {
                            result.push(rdatesToString("EXDATE", this._exdate, this.tzid()))
                        }
                        return result
                    };
                    RRuleSet.prototype.toString = function() {
                        return this.valueOf().join("\n")
                    };
                    RRuleSet.prototype.clone = function() {
                        var rrs = new RRuleSet(!!this._cache);
                        this._rrule.forEach((function(rule) {
                            return rrs.rrule(rule.clone())
                        }));
                        this._exrule.forEach((function(rule) {
                            return rrs.exrule(rule.clone())
                        }));
                        this._rdate.forEach((function(date) {
                            return rrs.rdate(new Date(date.getTime()))
                        }));
                        this._exdate.forEach((function(date) {
                            return rrs.exdate(new Date(date.getTime()))
                        }));
                        return rrs
                    };
                    return RRuleSet
                }(RRule);

                function _addRule(rrule, collection) {
                    if (!(rrule instanceof RRule)) {
                        throw new TypeError(String(rrule) + " is not RRule instance")
                    }
                    if (!includes(collection.map(String), String(rrule))) {
                        collection.push(rrule)
                    }
                }

                function _addDate(date, collection) {
                    if (!(date instanceof Date)) {
                        throw new TypeError(String(date) + " is not Date instance")
                    }
                    if (!includes(collection.map(Number), Number(date))) {
                        collection.push(date);
                        sort(collection)
                    }
                }

                function rdatesToString(param, rdates, tzid) {
                    var isUTC = !tzid || "UTC" === tzid.toUpperCase();
                    var header = isUTC ? "".concat(param, ":") : "".concat(param, ";TZID=").concat(tzid, ":");
                    var dateString = rdates.map((function(rdate) {
                        return timeToUntilString(rdate.valueOf(), isUTC)
                    })).join(",");
                    return "".concat(header).concat(dateString)
                }
            },
        66798:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/common/m_charts.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.registerPattern = exports.registerGradient = exports.default = void 0;
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const graphicObjects = {};
                exports.registerPattern = options => {
                    const id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: "pattern"
                    }, options);
                    return id
                };
                exports.registerGradient = (type, options) => {
                    const id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: type
                    }, options);
                    return id
                };
                var _default = {
                    getGraphicObjects: () => graphicObjects
                };
                exports.default = _default
            },
        70100:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/license_validation_internal.js ***!
              \****************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                exports.parseLicenseKey = function(encodedKey) {};
                exports.peekValidationPerformed = function() {};
                exports.setLicenseCheckSkipCondition = function() {};
                exports.validateLicense = validateLicense;

                function validateLicense(licenseKey, version) {}
                var _default = {
                    validateLicense: validateLicense
                };
                exports.default = _default
            },
        24321:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/date.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.dateUtilsTs = void 0;
                const dateUtilsTs = {
                    addOffsets: (date, offsets) => {
                        const newDateMs = offsets.reduce((result, offset) => result + offset, date.getTime());
                        return new Date(newDateMs)
                    }
                };
                exports.dateUtilsTs = dateUtilsTs
            },
        11390:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/math.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.shiftIntegerByModule = void 0;
                exports.shiftIntegerByModule = (integerValue, moduleValue) => {
                    if (!Number.isInteger(integerValue)) {
                        throw Error("Passed integer value ".concat(integerValue, " is not an integer."))
                    }
                    if (!Number.isInteger(moduleValue)) {
                        throw Error("Passed module value ".concat(moduleValue, " is not an integer."))
                    }
                    if (moduleValue <= 0) {
                        throw Error("Passed module value ".concat(moduleValue, " must be > 0."))
                    }
                    const normalizedInteger = integerValue % moduleValue;
                    switch (true) {
                        case 0 === normalizedInteger:
                            return 0;
                        case normalizedInteger > 0:
                            return normalizedInteger;
                        case normalizedInteger < 0:
                            return moduleValue + normalizedInteger;
                        default:
                            throw Error("Unexpected division (".concat(integerValue, " % ").concat(moduleValue, ") occurred."))
                    }
                }
            },
        17301:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/promise.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createPromise = function() {
                    let resolve;
                    let reject;
                    const promise = new Promise((res, rej) => {
                        resolve = res;
                        reject = rej
                    });
                    return {
                        promise: promise,
                        resolve: resolve,
                        reject: reject
                    }
                }
            },
        18605:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/events/dblclick.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.name = exports.dblClick = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _dom = __webpack_require__( /*! ../../core/utils/dom */ 3532);
                var _click = __webpack_require__( /*! ../../events/click */ 95429);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _index = __webpack_require__( /*! ../../events/utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.name = "dxdblclick";
                const NAMESPACED_CLICK_EVENT = (0, _index.addNamespace)(_click.name, "dxDblClick");
                const DblClick = _class.default.inherit({
                    ctor() {
                        this._handlerCount = 0;
                        this._forgetLastClick()
                    },
                    _forgetLastClick() {
                        this._firstClickTarget = null;
                        this._lastClickTimeStamp = -300
                    },
                    add() {
                        if (this._handlerCount <= 0) {
                            _events_engine.default.on(_dom_adapter.default.getDocument(), NAMESPACED_CLICK_EVENT, this._clickHandler.bind(this))
                        }
                        this._handlerCount += 1
                    },
                    _clickHandler(e) {
                        const timeStamp = e.timeStamp || Date.now();
                        const timeBetweenClicks = timeStamp - this._lastClickTimeStamp;
                        const isSimulated = timeBetweenClicks < 0;
                        const isDouble = !isSimulated && timeBetweenClicks < 300;
                        if (isDouble) {
                            (0, _index.fireEvent)({
                                type: "dxdblclick",
                                target: (0, _dom.closestCommonParent)(this._firstClickTarget, e.target),
                                originalEvent: e
                            });
                            this._forgetLastClick()
                        } else {
                            this._firstClickTarget = e.target;
                            this._lastClickTimeStamp = timeStamp
                        }
                    },
                    remove() {
                        this._handlerCount -= 1;
                        if (this._handlerCount <= 0) {
                            this._forgetLastClick();
                            _events_engine.default.off(_dom_adapter.default.getDocument(), NAMESPACED_CLICK_EVENT, void 0);
                            this._handlerCount = 0
                        }
                    }
                });
                const dblClick = new DblClick;
                exports.dblClick = dblClick
            },
        90102:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/filter_builder/m_between.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getConfig = function(caption, context) {
                    return {
                        name: "between",
                        caption: caption,
                        icon: "range",
                        valueSeparator: "\u2013",
                        dataTypes: ["number", "date", "datetime"],
                        editorTemplate: editorTemplate.bind(context),
                        notForLookup: true
                    }
                };
                var _renderer = (obj = __webpack_require__( /*! ../../core/renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                const FILTER_BUILDER_RANGE_START_CLASS = "".concat("dx-filterbuilder-range", "-start");
                const FILTER_BUILDER_RANGE_END_CLASS = "".concat("dx-filterbuilder-range", "-end");
                const FILTER_BUILDER_RANGE_SEPARATOR_CLASS = "".concat("dx-filterbuilder-range", "-separator");

                function editorTemplate(conditionInfo, container) {
                    const $editorStart = (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_RANGE_START_CLASS);
                    const $editorEnd = (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_RANGE_END_CLASS);
                    let values = conditionInfo.value || [];
                    const getStartValue = function(values) {
                        return values && values.length > 0 ? values[0] : null
                    };
                    const getEndValue = function(values) {
                        return values && 2 === values.length ? values[1] : null
                    };
                    container.append($editorStart);
                    container.append((0, _renderer.default)("<span>").addClass(FILTER_BUILDER_RANGE_SEPARATOR_CLASS).text("\u2013"));
                    container.append($editorEnd);
                    container.addClass("dx-filterbuilder-range");
                    this._editorFactory.createEditor.call(this, $editorStart, (0, _extend.extend)({}, conditionInfo.field, conditionInfo, {
                        value: getStartValue(values),
                        parentType: "filterBuilder",
                        setValue(value) {
                            values = [value, getEndValue(values)];
                            conditionInfo.setValue(values)
                        }
                    }));
                    this._editorFactory.createEditor.call(this, $editorEnd, (0, _extend.extend)({}, conditionInfo.field, conditionInfo, {
                        value: getEndValue(values),
                        parentType: "filterBuilder",
                        setValue(value) {
                            values = [getStartValue(values), value];
                            conditionInfo.setValue(values)
                        }
                    }))
                }
            },
        88283:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/filter_builder/m_filter_builder.js ***!
              \*******************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 99393));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _index = __webpack_require__( /*! ../../events/utils/index */ 39611);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../localization/message */ 28109));
                var _utils = __webpack_require__( /*! ../../ui/overlay/utils */ 13660);
                var _popup = _interopRequireDefault(__webpack_require__( /*! ../../ui/popup */ 39114));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../ui/shared/ui.editor_factory_mixin */ 15653));
                var _tree_view = _interopRequireDefault(__webpack_require__( /*! ../../ui/tree_view */ 30254));
                var _ui2 = _interopRequireDefault(__webpack_require__( /*! ../../ui/widget/ui.widget */ 14390));
                var _m_utils = __webpack_require__( /*! ./m_utils */ 70474);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const FILTER_BUILDER_GROUP_CLASS = "".concat("dx-filterbuilder", "-group");
                const FILTER_BUILDER_GROUP_ITEM_CLASS = "".concat(FILTER_BUILDER_GROUP_CLASS, "-item");
                const FILTER_BUILDER_GROUP_CONTENT_CLASS = "".concat(FILTER_BUILDER_GROUP_CLASS, "-content");
                const FILTER_BUILDER_GROUP_OPERATIONS_CLASS = "".concat(FILTER_BUILDER_GROUP_CLASS, "-operations");
                const FILTER_BUILDER_GROUP_OPERATION_CLASS = "".concat(FILTER_BUILDER_GROUP_CLASS, "-operation");
                const FILTER_BUILDER_ACTION_CLASS = "".concat("dx-filterbuilder", "-action");
                const FILTER_BUILDER_IMAGE_CLASS = "".concat(FILTER_BUILDER_ACTION_CLASS, "-icon");
                const FILTER_BUILDER_ITEM_TEXT_CLASS = "".concat("dx-filterbuilder", "-text");
                const FILTER_BUILDER_ITEM_FIELD_CLASS = "".concat("dx-filterbuilder", "-item-field");
                const FILTER_BUILDER_ITEM_OPERATION_CLASS = "".concat("dx-filterbuilder", "-item-operation");
                const FILTER_BUILDER_ITEM_VALUE_CLASS = "".concat("dx-filterbuilder", "-item-value");
                const FILTER_BUILDER_ITEM_VALUE_TEXT_CLASS = "".concat("dx-filterbuilder", "-item-value-text");
                const FILTER_BUILDER_OVERLAY_CLASS = "".concat("dx-filterbuilder", "-overlay");
                const FILTER_BUILDER_FILTER_OPERATIONS_CLASS = "".concat("dx-filterbuilder", "-operations");
                const FILTER_BUILDER_FIELDS_CLASS = "".concat("dx-filterbuilder", "-fields");
                const FILTER_BUILDER_ADD_CONDITION_CLASS = "".concat("dx-filterbuilder", "-add-condition");
                const FILTER_BUILDER_MENU_CUSTOM_OPERATION_CLASS = "".concat("dx-filterbuilder", "-menu-custom-operation");
                const ACTIONS = [{
                    name: "onEditorPreparing",
                    config: {
                        excludeValidators: ["disabled", "readOnly"],
                        category: "rendering"
                    }
                }, {
                    name: "onEditorPrepared",
                    config: {
                        excludeValidators: ["disabled", "readOnly"],
                        category: "rendering"
                    }
                }, {
                    name: "onValueChanged",
                    config: {
                        excludeValidators: ["disabled", "readOnly"]
                    }
                }];
                const OPERATORS = {
                    and: "and",
                    or: "or",
                    notAnd: "!and",
                    notOr: "!or"
                };
                const EditorFactory = (0, _ui.default)(function() {
                    return function() {}
                }());
                let FilterBuilder = function(_Widget) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(FilterBuilder, _Widget);

                    function FilterBuilder() {
                        return _Widget.apply(this, arguments) || this
                    }
                    var _proto = FilterBuilder.prototype;
                    _proto._getDefaultOptions = function() {
                        return (0, _extend.extend)(_Widget.prototype._getDefaultOptions.call(this), {
                            onEditorPreparing: null,
                            onEditorPrepared: null,
                            onValueChanged: null,
                            fields: [],
                            groupOperations: ["and", "or", "notAnd", "notOr"],
                            maxGroupLevel: void 0,
                            value: null,
                            allowHierarchicalFields: false,
                            groupOperationDescriptions: {
                                and: _message.default.format("dxFilterBuilder-and"),
                                or: _message.default.format("dxFilterBuilder-or"),
                                notAnd: _message.default.format("dxFilterBuilder-notAnd"),
                                notOr: _message.default.format("dxFilterBuilder-notOr")
                            },
                            customOperations: [],
                            closePopupOnTargetScroll: true,
                            filterOperationDescriptions: {
                                between: _message.default.format("dxFilterBuilder-filterOperationBetween"),
                                equal: _message.default.format("dxFilterBuilder-filterOperationEquals"),
                                notEqual: _message.default.format("dxFilterBuilder-filterOperationNotEquals"),
                                lessThan: _message.default.format("dxFilterBuilder-filterOperationLess"),
                                lessThanOrEqual: _message.default.format("dxFilterBuilder-filterOperationLessOrEquals"),
                                greaterThan: _message.default.format("dxFilterBuilder-filterOperationGreater"),
                                greaterThanOrEqual: _message.default.format("dxFilterBuilder-filterOperationGreaterOrEquals"),
                                startsWith: _message.default.format("dxFilterBuilder-filterOperationStartsWith"),
                                contains: _message.default.format("dxFilterBuilder-filterOperationContains"),
                                notContains: _message.default.format("dxFilterBuilder-filterOperationNotContains"),
                                endsWith: _message.default.format("dxFilterBuilder-filterOperationEndsWith"),
                                isBlank: _message.default.format("dxFilterBuilder-filterOperationIsBlank"),
                                isNotBlank: _message.default.format("dxFilterBuilder-filterOperationIsNotBlank")
                            }
                        })
                    };
                    _proto._optionChanged = function(args) {
                        switch (args.name) {
                            case "closePopupOnTargetScroll":
                                break;
                            case "onEditorPreparing":
                            case "onEditorPrepared":
                            case "onValueChanged":
                                this._initActions();
                                break;
                            case "customOperations":
                                this._initCustomOperations();
                                this._invalidate();
                                break;
                            case "fields":
                            case "maxGroupLevel":
                            case "groupOperations":
                            case "allowHierarchicalFields":
                            case "groupOperationDescriptions":
                            case "filterOperationDescriptions":
                                this._invalidate();
                                break;
                            case "value":
                                if (args.value !== args.previousValue) {
                                    const disableInvalidateForValue = this._disableInvalidateForValue;
                                    if (!disableInvalidateForValue) {
                                        this._initModel();
                                        this._invalidate()
                                    }
                                    this._disableInvalidateForValue = false;
                                    this.executeAction("onValueChanged", {
                                        value: args.value,
                                        previousValue: args.previousValue
                                    });
                                    this._disableInvalidateForValue = disableInvalidateForValue
                                }
                                break;
                            default:
                                _Widget.prototype._optionChanged.call(this, args)
                        }
                    };
                    _proto.getFilterExpression = function() {
                        const fields = this._getNormalizedFields();
                        const value = (0, _extend.extend)(true, [], this._model);
                        return (0, _m_utils.getFilterExpression)((0, _m_utils.getNormalizedFilter)(value), fields, this._customOperations, "filterBuilder")
                    };
                    _proto._getNormalizedFields = function() {
                        return (0, _m_utils.getNormalizedFields)(this.option("fields"))
                    };
                    _proto._updateFilter = function() {
                        this._disableInvalidateForValue = true;
                        const value = (0, _extend.extend)(true, [], this._model);
                        const normalizedValue = (0, _m_utils.getNormalizedFilter)(value);
                        const oldValue = (0, _m_utils.getNormalizedFilter)(this._getModel(this.option("value")));
                        if (JSON.stringify(oldValue) !== JSON.stringify(normalizedValue)) {
                            this.option("value", normalizedValue)
                        }
                        this._disableInvalidateForValue = false;
                        this._fireContentReadyAction()
                    };
                    _proto._init = function() {
                        this._initCustomOperations();
                        this._initModel();
                        this._initEditorFactory();
                        this._initActions();
                        _Widget.prototype._init.call(this)
                    };
                    _proto._initEditorFactory = function() {
                        this._editorFactory = new EditorFactory
                    };
                    _proto._initCustomOperations = function() {
                        this._customOperations = (0, _m_utils.getMergedOperations)(this.option("customOperations"), this.option("filterOperationDescriptions.between"), this)
                    };
                    _proto._getDefaultGroupOperation = function() {
                        var _a, _b;
                        return null !== (_b = null === (_a = this.option("groupOperations")) || void 0 === _a ? void 0 : _a[0]) && void 0 !== _b ? _b : OPERATORS.and
                    };
                    _proto._getModel = function(value) {
                        return (0, _m_utils.convertToInnerStructure)(value, this._customOperations, this._getDefaultGroupOperation())
                    };
                    _proto._initModel = function() {
                        this._model = this._getModel(this.option("value"))
                    };
                    _proto._initActions = function() {
                        const that = this;
                        that._actions = {};
                        ACTIONS.forEach(action => {
                            const actionConfig = (0, _extend.extend)({}, action.config);
                            that._actions[action.name] = that._createActionByOption(action.name, actionConfig)
                        })
                    };
                    _proto.executeAction = function(actionName, options) {
                        const action = this._actions[actionName];
                        return action && action(options)
                    };
                    _proto._initMarkup = function() {
                        this.$element().addClass("dx-filterbuilder");
                        _Widget.prototype._initMarkup.call(this);
                        this._createGroupElementByCriteria(this._model).appendTo(this.$element())
                    };
                    _proto._createConditionElement = function(condition, parent) {
                        return (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_GROUP_CLASS).append(this._createConditionItem(condition, parent))
                    };
                    _proto._createGroupElementByCriteria = function(criteria, parent) {
                        let groupLevel = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 0;
                        const $group = this._createGroupElement(criteria, parent, groupLevel);
                        const $groupContent = $group.find(".".concat(FILTER_BUILDER_GROUP_CONTENT_CLASS));
                        const groupCriteria = (0, _m_utils.getGroupCriteria)(criteria);
                        for (let i = 0; i < groupCriteria.length; i++) {
                            const innerCriteria = groupCriteria[i];
                            if ((0, _m_utils.isGroup)(innerCriteria)) {
                                this._createGroupElementByCriteria(innerCriteria, criteria, groupLevel + 1).appendTo($groupContent)
                            } else if ((0, _m_utils.isCondition)(innerCriteria)) {
                                this._createConditionElement(innerCriteria, criteria).appendTo($groupContent)
                            }
                        }
                        return $group
                    };
                    _proto._createGroupElement = function(criteria, parent, groupLevel) {
                        const $groupItem = (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_GROUP_ITEM_CLASS);
                        const $groupContent = (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_GROUP_CONTENT_CLASS);
                        const $group = (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_GROUP_CLASS).append($groupItem).append($groupContent);
                        if (null != parent) {
                            this._createRemoveButton(() => {
                                (0, _m_utils.removeItem)(parent, criteria);
                                $group.remove();
                                this._updateFilter()
                            }).appendTo($groupItem)
                        }
                        this._createGroupOperationButton(criteria).appendTo($groupItem);
                        this._createAddButton(() => {
                            const newGroup = (0, _m_utils.createEmptyGroup)(this._getDefaultGroupOperation());
                            (0, _m_utils.addItem)(newGroup, criteria);
                            this._createGroupElement(newGroup, criteria, groupLevel + 1).appendTo($groupContent);
                            this._updateFilter()
                        }, () => {
                            const field = this.option("fields")[0];
                            const newCondition = (0, _m_utils.createCondition)(field, this._customOperations);
                            (0, _m_utils.addItem)(newCondition, criteria);
                            this._createConditionElement(newCondition, criteria).appendTo($groupContent);
                            this._updateFilter()
                        }, groupLevel).appendTo($groupItem);
                        return $group
                    };
                    _proto._createButton = function(caption) {
                        return (0, _renderer.default)("<div>").text(caption)
                    };
                    _proto._createGroupOperationButton = function(criteria) {
                        const groupOperations = this._getGroupOperations(criteria);
                        let groupMenuItem = (0, _m_utils.getGroupMenuItem)(criteria, groupOperations);
                        const caption = groupMenuItem.text;
                        const $operationButton = groupOperations && groupOperations.length < 2 ? this._createButton(caption).addClass("dx-state-disabled") : this._createButtonWithMenu({
                            caption: caption,
                            menu: {
                                items: groupOperations,
                                displayExpr: "text",
                                keyExpr: "value",
                                onItemClick: e => {
                                    if (groupMenuItem !== e.itemData) {
                                        (0, _m_utils.setGroupValue)(criteria, e.itemData.value);
                                        $operationButton.text(e.itemData.text);
                                        groupMenuItem = e.itemData;
                                        this._updateFilter()
                                    }
                                },
                                onContentReady(e) {
                                    e.component.selectItem(groupMenuItem)
                                },
                                cssClass: FILTER_BUILDER_GROUP_OPERATIONS_CLASS
                            }
                        });
                        return $operationButton.addClass(FILTER_BUILDER_ITEM_TEXT_CLASS).addClass(FILTER_BUILDER_GROUP_OPERATION_CLASS).attr("tabindex", 0)
                    };
                    _proto._createButtonWithMenu = function(options) {
                        const that = this;
                        const removeMenu = function() {
                            that.$element().find(".".concat("dx-state-active")).removeClass("dx-state-active");
                            that.$element().find(".dx-overlay .dx-treeview").remove();
                            that.$element().find(".dx-overlay").remove()
                        };
                        const rtlEnabled = this.option("rtlEnabled");
                        const position = rtlEnabled ? "right" : "left";
                        const $button = this._createButton(options.caption);
                        (0, _extend.extend)(options.menu, {
                            focusStateEnabled: true,
                            selectionMode: "single",
                            onItemClick: (handler = options.menu.onItemClick, function(e) {
                                handler(e);
                                if ("dxclick" === e.event.type) {
                                    removeMenu()
                                }
                            }),
                            onHiding() {
                                $button.removeClass("dx-state-active")
                            },
                            position: {
                                my: "".concat(position, " top"),
                                at: "".concat(position, " bottom"),
                                offset: "0 1",
                                of: $button,
                                collision: "flip"
                            },
                            animation: null,
                            onHidden() {
                                removeMenu()
                            },
                            cssClass: "".concat(FILTER_BUILDER_OVERLAY_CLASS, " ").concat(options.menu.cssClass),
                            rtlEnabled: rtlEnabled
                        });
                        var handler;
                        options.popup = {
                            onShown(info) {
                                const treeViewElement = (0, _renderer.default)(info.component.content()).find(".dx-treeview");
                                const treeView = treeViewElement.dxTreeView("instance");
                                _events_engine.default.on(treeViewElement, "keyup keydown", e => {
                                    const keyName = (0, _index.normalizeKeyName)(e);
                                    if ("keydown" === e.type && "tab" === keyName || "keyup" === e.type && ("escape" === keyName || "enter" === keyName)) {
                                        info.component.hide();
                                        _events_engine.default.trigger(options.menu.position.of, "focus")
                                    }
                                });
                                treeView.focus();
                                treeView.option("focusedElement", null)
                            }
                        };
                        this._subscribeOnClickAndEnterKey($button, () => {
                            removeMenu();
                            that._createPopupWithTreeView(options, that.$element());
                            $button.addClass("dx-state-active")
                        });
                        return $button
                    };
                    _proto._hasValueButton = function(condition) {
                        const customOperation = (0, _m_utils.getCustomOperation)(this._customOperations, condition[1]);
                        return customOperation ? false !== customOperation.hasValue : null !== condition[2]
                    };
                    _proto._createOperationButtonWithMenu = function(condition, field) {
                        const that = this;
                        const availableOperations = (0, _m_utils.getAvailableOperations)(field, this.option("filterOperationDescriptions"), this._customOperations);
                        let currentOperation = (0, _m_utils.getOperationFromAvailable)((0, _m_utils.getOperationValue)(condition), availableOperations);
                        const $operationButton = this._createButtonWithMenu({
                            caption: currentOperation.text,
                            menu: {
                                items: availableOperations,
                                displayExpr: "text",
                                onItemRendered(e) {
                                    e.itemData.isCustom && (0, _renderer.default)(e.itemElement).addClass(FILTER_BUILDER_MENU_CUSTOM_OPERATION_CLASS)
                                },
                                onContentReady(e) {
                                    e.component.selectItem(currentOperation)
                                },
                                onItemClick: e => {
                                    if (currentOperation !== e.itemData) {
                                        currentOperation = e.itemData;
                                        (0, _m_utils.updateConditionByOperation)(condition, currentOperation.value, that._customOperations);
                                        const $valueButton = $operationButton.siblings().filter(".".concat(FILTER_BUILDER_ITEM_VALUE_CLASS));
                                        if (that._hasValueButton(condition)) {
                                            if (0 !== $valueButton.length) {
                                                $valueButton.remove()
                                            }
                                            that._createValueButton(condition, field).appendTo($operationButton.parent())
                                        } else {
                                            $valueButton.remove()
                                        }
                                        $operationButton.text(currentOperation.text);
                                        this._updateFilter()
                                    }
                                },
                                cssClass: FILTER_BUILDER_FILTER_OPERATIONS_CLASS
                            }
                        }).addClass(FILTER_BUILDER_ITEM_TEXT_CLASS).addClass(FILTER_BUILDER_ITEM_OPERATION_CLASS).attr("tabindex", 0);
                        return $operationButton
                    };
                    _proto._createOperationAndValueButtons = function(condition, field, $item) {
                        this._createOperationButtonWithMenu(condition, field).appendTo($item);
                        if (this._hasValueButton(condition)) {
                            this._createValueButton(condition, field).appendTo($item)
                        }
                    };
                    _proto._createFieldButtonWithMenu = function(fields, condition, field) {
                        const that = this;
                        const allowHierarchicalFields = this.option("allowHierarchicalFields");
                        const items = (0, _m_utils.getItems)(fields, allowHierarchicalFields);
                        let item = (0, _m_utils.getField)(field.name || field.dataField, items);
                        const getFullCaption = function(item, items) {
                            return allowHierarchicalFields ? (0, _m_utils.getCaptionWithParents)(item, items) : item.caption
                        };
                        const $fieldButton = this._createButtonWithMenu({
                            caption: getFullCaption(item, items),
                            menu: {
                                items: items,
                                dataStructure: "plain",
                                keyExpr: "id",
                                parentId: "parentId",
                                displayExpr: "caption",
                                onItemClick: e => {
                                    if (item !== e.itemData) {
                                        item = e.itemData;
                                        condition[0] = item.name || item.dataField;
                                        condition[2] = "object" === item.dataType ? null : "";
                                        (0, _m_utils.updateConditionByOperation)(condition, (0, _m_utils.getDefaultOperation)(item), that._customOperations);
                                        $fieldButton.siblings().filter(".".concat(FILTER_BUILDER_ITEM_TEXT_CLASS)).remove();
                                        that._createOperationAndValueButtons(condition, item, $fieldButton.parent());
                                        const caption = getFullCaption(item, e.component.option("items"));
                                        $fieldButton.text(caption);
                                        this._updateFilter()
                                    }
                                },
                                onContentReady(e) {
                                    e.component.selectItem(item)
                                },
                                cssClass: FILTER_BUILDER_FIELDS_CLASS
                            }
                        }).addClass(FILTER_BUILDER_ITEM_TEXT_CLASS).addClass(FILTER_BUILDER_ITEM_FIELD_CLASS).attr("tabindex", 0);
                        return $fieldButton
                    };
                    _proto._createConditionItem = function(condition, parent) {
                        const $item = (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_GROUP_ITEM_CLASS);
                        const fields = this._getNormalizedFields();
                        const field = (0, _m_utils.getField)(condition[0], fields);
                        this._createRemoveButton(() => {
                            (0, _m_utils.removeItem)(parent, condition);
                            const isSingleChild = 1 === $item.parent().children().length;
                            if (isSingleChild) {
                                $item.parent().remove()
                            } else {
                                $item.remove()
                            }
                            this._updateFilter()
                        }).appendTo($item);
                        this._createFieldButtonWithMenu(fields, condition, field).appendTo($item);
                        this._createOperationAndValueButtons(condition, field, $item);
                        return $item
                    };
                    _proto._getGroupOperations = function(criteria) {
                        let groupOperations = this.option("groupOperations");
                        const groupOperationDescriptions = this.option("groupOperationDescriptions");
                        if (!groupOperations || !groupOperations.length) {
                            groupOperations = [(0, _m_utils.getGroupValue)(criteria).replace("!", "not")]
                        }
                        return groupOperations.map(operation => ({
                            text: groupOperationDescriptions[operation],
                            value: OPERATORS[operation]
                        }))
                    };
                    _proto._createRemoveButton = function(handler) {
                        const $removeButton = (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_IMAGE_CLASS).addClass("dx-icon-remove").addClass(FILTER_BUILDER_ACTION_CLASS).attr("tabindex", 0);
                        this._subscribeOnClickAndEnterKey($removeButton, handler);
                        return $removeButton
                    };
                    _proto._createAddButton = function(addGroupHandler, addConditionHandler, groupLevel) {
                        let $button;
                        const maxGroupLevel = this.option("maxGroupLevel");
                        if ((0, _type.isDefined)(maxGroupLevel) && groupLevel >= maxGroupLevel) {
                            $button = this._createButton();
                            this._subscribeOnClickAndEnterKey($button, addConditionHandler)
                        } else {
                            $button = this._createButtonWithMenu({
                                menu: {
                                    items: [{
                                        caption: _message.default.format("dxFilterBuilder-addCondition"),
                                        click: addConditionHandler
                                    }, {
                                        caption: _message.default.format("dxFilterBuilder-addGroup"),
                                        click: addGroupHandler
                                    }],
                                    displayExpr: "caption",
                                    onItemClick(e) {
                                        e.itemData.click()
                                    },
                                    cssClass: FILTER_BUILDER_ADD_CONDITION_CLASS
                                }
                            })
                        }
                        return $button.addClass(FILTER_BUILDER_IMAGE_CLASS).addClass("dx-icon-plus").addClass(FILTER_BUILDER_ACTION_CLASS).attr("tabindex", 0)
                    };
                    _proto._createValueText = function(item, field, $container) {
                        const that = this;
                        const $text = (0, _renderer.default)("<div>").html("&nbsp;").addClass(FILTER_BUILDER_ITEM_VALUE_TEXT_CLASS).attr("tabindex", 0).appendTo($container);
                        const value = item[2];
                        const customOperation = (0, _m_utils.getCustomOperation)(that._customOperations, item[1]);
                        if (!customOperation && field.lookup) {
                            (0, _m_utils.getCurrentLookupValueText)(field, value, result => {
                                (0, _m_utils.renderValueText)($text, result)
                            })
                        } else {
                            (0, _deferred.when)((0, _m_utils.getCurrentValueText)(field, value, customOperation)).done(result => {
                                (0, _m_utils.renderValueText)($text, result, customOperation)
                            })
                        }
                        that._subscribeOnClickAndEnterKey($text, e => {
                            if ("keyup" === e.type) {
                                e.stopPropagation()
                            }
                            that._createValueEditorWithEvents(item, field, $container)
                        });
                        return $text
                    };
                    _proto._updateConditionValue = function(item, value, callback) {
                        const areValuesDifferent = item[2] !== value;
                        if (areValuesDifferent) {
                            item[2] = value
                        }
                        callback();
                        this._updateFilter()
                    };
                    _proto._addDocumentKeyUp = function($editor, handler) {
                        let isComposing = false;
                        let hasCompositionJustEnded = false;
                        const document = _dom_adapter.default.getDocument();
                        const documentKeyUpHandler = e => {
                            if (isComposing || hasCompositionJustEnded) {
                                hasCompositionJustEnded = false;
                                return
                            }
                            handler(e)
                        };
                        _events_engine.default.on(document, "keyup", documentKeyUpHandler);
                        const input = $editor.find("input");
                        _events_engine.default.on(input, "compositionstart", () => {
                            isComposing = true
                        });
                        _events_engine.default.on(input, "compositionend", () => {
                            isComposing = false;
                            hasCompositionJustEnded = true
                        });
                        _events_engine.default.on(input, "keydown", event => {
                            if (229 !== event.which) {
                                hasCompositionJustEnded = false
                            }
                        });
                        this._documentKeyUpHandler = documentKeyUpHandler
                    };
                    _proto._addDocumentClick = function($editor, closeEditorFunc) {
                        const document = _dom_adapter.default.getDocument();
                        const documentClickHandler = e => {
                            if (!this._isFocusOnEditorParts($editor, e.target)) {
                                _events_engine.default.trigger($editor.find("input"), "change");
                                closeEditorFunc()
                            }
                        };
                        _events_engine.default.on(document, "dxpointerdown", documentClickHandler);
                        this._documentClickHandler = documentClickHandler
                    };
                    _proto._isFocusOnEditorParts = function($editor, target) {
                        const activeElement = target || _dom_adapter.default.getActiveElement();
                        return (0, _renderer.default)(activeElement).closest($editor.children()).length || (0, _renderer.default)(activeElement).closest(".dx-dropdowneditor-overlay").length
                    };
                    _proto._removeEvents = function() {
                        const document = _dom_adapter.default.getDocument();
                        (0, _type.isDefined)(this._documentKeyUpHandler) && _events_engine.default.off(document, "keyup", this._documentKeyUpHandler);
                        (0, _type.isDefined)(this._documentClickHandler) && _events_engine.default.off(document, "dxpointerdown", this._documentClickHandler)
                    };
                    _proto._dispose = function() {
                        this._removeEvents();
                        _Widget.prototype._dispose.call(this)
                    };
                    _proto._createValueEditorWithEvents = function(item, field, $container) {
                        let value = item[2];
                        const createValueText = () => {
                            $container.empty();
                            this._removeEvents();
                            return this._createValueText(item, field, $container)
                        };
                        const closeEditor = () => {
                            this._updateConditionValue(item, value, () => {
                                createValueText()
                            })
                        };
                        const options = {
                            value: "" === value ? null : value,
                            filterOperation: (0, _m_utils.getOperationValue)(item),
                            setValue(data) {
                                value = null === data ? "" : data
                            },
                            closeEditor: closeEditor,
                            text: $container.text()
                        };
                        $container.empty();
                        const $editor = this._createValueEditor($container, field, options);
                        _events_engine.default.trigger($editor.find("input").not(":hidden").eq(0), "focus");
                        this._removeEvents();
                        this._addDocumentClick($editor, closeEditor);
                        this._addDocumentKeyUp($editor, e => {
                            const keyName = (0, _index.normalizeKeyName)(e);
                            if ("tab" === keyName) {
                                if (this._isFocusOnEditorParts($editor)) {
                                    return
                                }
                                this._updateConditionValue(item, value, () => {
                                    createValueText();
                                    if (e.shiftKey) {
                                        _events_engine.default.trigger($container.prev(), "focus")
                                    }
                                })
                            }
                            if ("escape" === keyName) {
                                _events_engine.default.trigger(createValueText(), "focus")
                            }
                            if ("enter" === keyName) {
                                this._updateConditionValue(item, value, () => {
                                    _events_engine.default.trigger(createValueText(), "focus")
                                })
                            }
                        });
                        this._fireContentReadyAction()
                    };
                    _proto._createValueButton = function(item, field) {
                        const $valueButton = (0, _renderer.default)("<div>").addClass(FILTER_BUILDER_ITEM_TEXT_CLASS).addClass(FILTER_BUILDER_ITEM_VALUE_CLASS);
                        this._createValueText(item, field, $valueButton);
                        return $valueButton
                    };
                    _proto._createValueEditor = function($container, field, options) {
                        const $editor = (0, _renderer.default)("<div>").attr("tabindex", 0).appendTo($container);
                        const customOperation = (0, _m_utils.getCustomOperation)(this._customOperations, options.filterOperation);
                        const editorTemplate = customOperation && customOperation.editorTemplate ? customOperation.editorTemplate : field.editorTemplate;
                        if (editorTemplate) {
                            const template = this._getTemplate(editorTemplate);
                            template.render({
                                model: (0, _extend.extend)({
                                    field: field
                                }, options),
                                container: $editor
                            })
                        } else {
                            this._editorFactory.createEditor.call(this, $editor, (0, _extend.extend)({}, field, options, {
                                parentType: "filterBuilder"
                            }))
                        }
                        return $editor
                    };
                    _proto._createPopupWithTreeView = function(options, $container) {
                        const that = this;
                        const $popup = (0, _renderer.default)("<div>").addClass(options.menu.cssClass).appendTo($container);
                        this._createComponent($popup, _popup.default, {
                            onHiding: options.menu.onHiding,
                            onHidden: options.menu.onHidden,
                            rtlEnabled: options.menu.rtlEnabled,
                            position: options.menu.position,
                            animation: options.menu.animation,
                            contentTemplate(contentElement) {
                                const $menuContainer = (0, _renderer.default)("<div>").appendTo(contentElement);
                                that._createComponent($menuContainer, _tree_view.default, options.menu);
                                this.repaint()
                            },
                            _ignoreFunctionValueDeprecation: true,
                            maxHeight: () => (0, _utils.getElementMaxHeightByWindow)(options.menu.position.of),
                            visible: true,
                            focusStateEnabled: false,
                            hideOnParentScroll: this.option("closePopupOnTargetScroll"),
                            hideOnOutsideClick: true,
                            onShown: options.popup.onShown,
                            shading: false,
                            width: "auto",
                            height: "auto",
                            showTitle: false,
                            _wrapperClassExternal: options.menu.cssClass
                        })
                    };
                    _proto._subscribeOnClickAndEnterKey = function($button, handler) {
                        _events_engine.default.on($button, "dxclick", handler);
                        _events_engine.default.on($button, "keyup", e => {
                            if ("enter" === (0, _index.normalizeKeyName)(e)) {
                                handler(e)
                            }
                        })
                    };
                    return FilterBuilder
                }(_ui2.default);
                (0, _component_registrator.default)("dxFilterBuilder", FilterBuilder);
                var _default = FilterBuilder;
                exports.default = _default
            },
        90067:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/filter_builder/m_filter_operations_dictionary.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                const OPERATION_ICONS = {
                    "=": "equal",
                    "<>": "notequal",
                    "<": "less",
                    "<=": "lessorequal",
                    ">": "greater",
                    ">=": "greaterorequal",
                    notcontains: "doesnotcontain",
                    contains: "contains",
                    startswith: "startswith",
                    endswith: "endswith",
                    isblank: "isblank",
                    isnotblank: "isnotblank"
                };
                const OPERATION_NAME = {
                    "=": "equal",
                    "<>": "notEqual",
                    "<": "lessThan",
                    "<=": "lessThanOrEqual",
                    ">": "greaterThan",
                    ">=": "greaterThanOrEqual",
                    startswith: "startsWith",
                    contains: "contains",
                    notcontains: "notContains",
                    endswith: "endsWith",
                    isblank: "isBlank",
                    isnotblank: "isNotBlank",
                    between: "between"
                };
                var _default = {
                    getIconByFilterOperation: filterOperation => OPERATION_ICONS[filterOperation],
                    getNameByFilterOperation: filterOperation => OPERATION_NAME[filterOperation]
                };
                exports.default = _default
            },
        70474:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/filter_builder/m_utils.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.addItem = function(item, group) {
                    const criteria = getGroupCriteria(group);
                    const groupValue = getGroupValue(criteria);
                    1 === criteria.length ? criteria.unshift(item) : criteria.push(item, groupValue);
                    return group
                };
                exports.convertToInnerStructure = convertToInnerStructure;
                exports.createCondition = function(field, customOperations) {
                    const condition = [field.dataField, "", ""];
                    const filterOperation = getDefaultOperation(field);
                    updateConditionByOperation(condition, filterOperation, customOperations);
                    return condition
                };
                exports.createEmptyGroup = createEmptyGroup;
                exports.filterHasField = function filterHasField(filter, dataField) {
                    if (null === filter || 0 === filter.length) {
                        return false
                    }
                    if (isCondition(filter)) {
                        return filter[0] === dataField
                    }
                    return filter.some(item => (isCondition(item) || isGroup(item)) && filterHasField(item, dataField))
                };
                exports.getAvailableOperations = function(field, filterOperationDescriptions, customOperations) {
                    const filterOperations = getFilterOperations(field);
                    const isLookupField = !!field.lookup;
                    customOperations.forEach(customOperation => {
                        if (!field.filterOperations && -1 === filterOperations.indexOf(customOperation.name)) {
                            const dataTypes = customOperation && customOperation.dataTypes;
                            const isOperationForbidden = isLookupField ? !!customOperation.notForLookup : false;
                            if (!isOperationForbidden && dataTypes && dataTypes.indexOf(field.dataType || "string") >= 0) {
                                filterOperations.push(customOperation.name)
                            }
                        }
                    });
                    return filterOperations.map(operation => {
                        const customOperation = getCustomOperation(customOperations, operation);
                        if (customOperation) {
                            return {
                                icon: customOperation.icon || "icon-none",
                                text: customOperation.caption || (0, _inflector.captionize)(customOperation.name),
                                value: customOperation.name,
                                isCustom: true
                            }
                        }
                        return {
                            icon: _m_filter_operations_dictionary.default.getIconByFilterOperation(operation) || "icon-none",
                            text: getCaptionByOperation(operation, filterOperationDescriptions),
                            value: operation
                        }
                    })
                };
                exports.getCaptionByOperation = getCaptionByOperation;
                exports.getCaptionWithParents = function getCaptionWithParents(item, plainItems) {
                    if (hasParent(item.dataField)) {
                        const parentId = getParentIdFromItemDataField(item.dataField);
                        for (let i = 0; i < plainItems.length; i++) {
                            if (plainItems[i].dataField === parentId) {
                                return "".concat(getCaptionWithParents(plainItems[i], plainItems), ".").concat(item.caption)
                            }
                        }
                    }
                    return item.caption
                };
                exports.getCurrentLookupValueText = function(field, value, handler) {
                    if ("" === value) {
                        handler("");
                        return
                    }
                    const {
                        lookup: lookup
                    } = field;
                    if (lookup.items) {
                        handler(lookup.calculateCellValue(value) || "")
                    } else {
                        const lookupDataSource = (0, _type.isFunction)(lookup.dataSource) ? lookup.dataSource({}) : lookup.dataSource;
                        const dataSource = new _data_source.DataSource(lookupDataSource);
                        dataSource.loadSingle(lookup.valueExpr, value).done(result => {
                            let valueText = "";
                            if (result) {
                                valueText = lookup.displayExpr ? (0, _data.compileGetter)(lookup.displayExpr)(result) : result
                            }
                            if (field.customizeText) {
                                valueText = field.customizeText({
                                    value: value,
                                    valueText: valueText
                                })
                            }
                            handler(valueText)
                        }).fail(() => {
                            handler("")
                        })
                    }
                };
                exports.getCurrentValueText = function(field, value, customOperation) {
                    let target = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : "filterBuilder";
                    if (checkDefaultValue(value)) {
                        return ""
                    }
                    if (Array.isArray(value)) {
                        const result = new _deferred.Deferred;
                        _deferred.when.apply(this, getArrayValueText(field, value, customOperation, target)).done((function() {
                            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                                args[_key] = arguments[_key]
                            }
                            const text = args.some(item => !checkDefaultValue(item)) ? args.map(item => !checkDefaultValue(item) ? item : "?") : "";
                            result.resolve(text)
                        }));
                        return result
                    }
                    return getPrimitiveValueText(field, value, customOperation, target)
                };
                exports.getCustomOperation = getCustomOperation;
                exports.getDefaultOperation = getDefaultOperation;
                exports.getField = getField;
                exports.getFilterExpression = function getFilterExpression(value, fields, customOperations, target) {
                    if (!(0, _type.isDefined)(value)) {
                        return null
                    }
                    if (isNegationGroup(value)) {
                        const filterExpression = getFilterExpression(value[1], fields, customOperations, target);
                        return ["!", filterExpression]
                    }
                    const criteria = getGroupCriteria(value);
                    if (isCondition(criteria)) {
                        return getConditionFilterExpression(criteria, fields, customOperations, target) || null
                    }
                    let result = [];
                    let filterExpression;
                    const groupValue = getGroupValue(criteria);
                    for (let i = 0; i < criteria.length; i++) {
                        if (isGroup(criteria[i])) {
                            filterExpression = getFilterExpression(criteria[i], fields, customOperations, target);
                            if (filterExpression) {
                                i && result.push(groupValue);
                                result.push(filterExpression)
                            }
                        } else if (isCondition(criteria[i])) {
                            filterExpression = getConditionFilterExpression(criteria[i], fields, customOperations, target);
                            if (filterExpression) {
                                result.length && result.push(groupValue);
                                result.push(filterExpression)
                            }
                        }
                    }
                    if (1 === result.length) {
                        result = result[0]
                    }
                    return result.length ? result : null
                };
                exports.getFilterOperations = getFilterOperations;
                exports.getGroupCriteria = getGroupCriteria;
                exports.getGroupMenuItem = function(group, availableGroups) {
                    const groupValue = getGroupValue(group);
                    return availableGroups.filter(item => item.value === groupValue)[0]
                };
                exports.getGroupValue = getGroupValue;
                exports.getItems = getItems;
                exports.getMatchedConditions = function(filter, dataField) {
                    if (null === filter || 0 === filter.length) {
                        return []
                    }
                    if (isCondition(filter)) {
                        if (isMatchedCondition(filter, dataField)) {
                            return [filter]
                        }
                        return []
                    }
                    const groupValue = getGroupValue(filter);
                    if ("and" !== groupValue) {
                        return []
                    }
                    const result = filter.filter(item => isCondition(item) && isMatchedCondition(item, dataField));
                    return result
                };
                exports.getMergedOperations = function(customOperations, betweenCaption, context) {
                    const result = (0, _extend.extend)(true, [], customOperations);
                    let betweenIndex = -1;
                    result.some((customOperation, index) => {
                        if ("between" === customOperation.name) {
                            betweenIndex = index;
                            return true
                        }
                        return
                    });
                    if (-1 !== betweenIndex) {
                        result[betweenIndex] = (0, _extend.extend)((0, _m_between.getConfig)(betweenCaption, context), result[betweenIndex])
                    } else {
                        result.unshift((0, _m_between.getConfig)(betweenCaption, context))
                    }
                    return result
                };
                exports.getNormalizedFields = function(fields) {
                    return fields.reduce((result, field) => {
                        if ((0, _type.isDefined)(field.dataField)) {
                            const normalizedField = {};
                            for (const key in field) {
                                if (field[key] && AVAILABLE_FIELD_PROPERTIES.includes(key)) {
                                    normalizedField[key] = field[key]
                                }
                            }
                            normalizedField.defaultCalculateFilterExpression = _filtering.default.defaultCalculateFilterExpression;
                            if (!(0, _type.isDefined)(normalizedField.dataType)) {
                                normalizedField.dataType = "string"
                            }
                            if (!(0, _type.isDefined)(normalizedField.trueText)) {
                                normalizedField.trueText = _message.default.format("dxDataGrid-trueText")
                            }
                            if (!(0, _type.isDefined)(normalizedField.falseText)) {
                                normalizedField.falseText = _message.default.format("dxDataGrid-falseText")
                            }
                            result.push(normalizedField)
                        }
                        return result
                    }, [])
                };
                exports.getNormalizedFilter = function getNormalizedFilter(group) {
                    const criteria = getGroupCriteria(group);
                    let i;
                    if (0 === criteria.length) {
                        return null
                    }
                    const itemsForRemove = [];
                    for (i = 0; i < criteria.length; i++) {
                        if (isGroup(criteria[i])) {
                            const normalizedGroupValue = getNormalizedFilter(criteria[i]);
                            if (normalizedGroupValue) {
                                criteria[i] = normalizedGroupValue
                            } else {
                                itemsForRemove.push(criteria[i])
                            }
                        } else if (isCondition(criteria[i])) {
                            if (!isValidCondition(criteria[i])) {
                                itemsForRemove.push(criteria[i])
                            }
                        }
                    }
                    for (i = 0; i < itemsForRemove.length; i++) {
                        removeItem(criteria, itemsForRemove[i])
                    }
                    if (1 === criteria.length) {
                        return null
                    }
                    criteria.splice(criteria.length - 1, 1);
                    if (1 === criteria.length) {
                        group = function(group, criteria) {
                            if (isNegationGroup(group)) {
                                group[1] = criteria
                            } else {
                                group = criteria
                            }
                            return group
                        }(group, criteria[0])
                    }
                    if (0 === group.length) {
                        return null
                    }
                    return group
                };
                exports.getOperationFromAvailable = function(operation, availableOperations) {
                    for (let i = 0; i < availableOperations.length; i++) {
                        if (availableOperations[i].value === operation) {
                            return availableOperations[i]
                        }
                    }
                    throw new _ui.default.Error("E1048", operation)
                };
                exports.getOperationValue = function(condition) {
                    let caption;
                    if (null === condition[2]) {
                        if ("=" === condition[1]) {
                            caption = "isblank"
                        } else {
                            caption = "isnotblank"
                        }
                    } else {
                        caption = condition[1]
                    }
                    return caption
                };
                exports.isCondition = isCondition;
                exports.isEmptyGroup = function(group) {
                    const criteria = getGroupCriteria(group);
                    if (isCondition(criteria)) {
                        return false
                    }
                    const hasConditions = criteria.some(item => isCondition(item));
                    return !hasConditions
                };
                exports.isGroup = isGroup;
                exports.isValidCondition = isValidCondition;
                exports.removeFieldConditionsFromFilter = function(filter, dataField) {
                    if (!filter || 0 === filter.length) {
                        return null
                    }
                    if (isCondition(filter)) {
                        const hasMatchedCondition = isMatchedCondition(filter, dataField);
                        return !hasMatchedCondition ? filter : null
                    }
                    return syncConditionIntoGroup(filter, [dataField], false)
                };
                exports.removeItem = removeItem;
                exports.renderValueText = void 0;
                exports.setGroupValue = function(group, value) {
                    ! function(group, value) {
                        if (function(value) {
                                return -1 !== value.indexOf("!")
                            }(value)) {
                            if (!isNegationGroup(group)) {
                                ! function(group) {
                                    const criteria = group.slice(0);
                                    group.length = 0;
                                    group.push("!", criteria)
                                }(group)
                            }
                        } else if (isNegationGroup(group)) {
                            ! function(group) {
                                const criteria = getGroupCriteria(group);
                                group.length = 0;
                                [].push.apply(group, criteria)
                            }(group)
                        }
                    }(group, value);
                    const criteria = getGroupCriteria(group);
                    let i;
                    value = function(value) {
                        return -1 === value.indexOf("!") ? value : value.substring(1)
                    }(value);
                    ! function(criteria, value) {
                        for (i = 0; i < criteria.length; i++) {
                            if (!Array.isArray(criteria[i])) {
                                criteria[i] = value
                            }
                        }
                    }(criteria, value);
                    return group
                };
                exports.syncFilters = function(filter, addedFilter) {
                    if (null === filter || 0 === filter.length) {
                        return addedFilter
                    }
                    if (isCondition(filter)) {
                        if (isMatchedCondition(filter, addedFilter[0])) {
                            return addedFilter
                        }
                        return [filter, "and", addedFilter]
                    }
                    const groupValue = getGroupValue(filter);
                    if ("and" !== groupValue) {
                        return [addedFilter, "and", filter]
                    }
                    return syncConditionIntoGroup(filter, addedFilter, true)
                };
                exports.updateConditionByOperation = updateConditionByOperation;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _data = __webpack_require__( /*! ../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _inflector = __webpack_require__( /*! ../../core/utils/inflector */ 78008);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 85273);
                var _errors = __webpack_require__( /*! ../../data/errors */ 18438);
                var _format_helper = _interopRequireDefault(__webpack_require__( /*! ../../format_helper */ 30343));
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../localization/message */ 28109));
                var _filtering = _interopRequireDefault(__webpack_require__( /*! ../../ui/shared/filtering */ 18740));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../ui/widget/ui.errors */ 96688));
                var _m_between = __webpack_require__( /*! ./m_between */ 90102);
                var _m_filter_operations_dictionary = _interopRequireDefault(__webpack_require__( /*! ./m_filter_operations_dictionary */ 90067));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const DATATYPE_OPERATIONS = {
                    number: ["=", "<>", "<", ">", "<=", ">=", "isblank", "isnotblank"],
                    string: ["contains", "notcontains", "startswith", "endswith", "=", "<>", "isblank", "isnotblank"],
                    date: ["=", "<>", "<", ">", "<=", ">=", "isblank", "isnotblank"],
                    datetime: ["=", "<>", "<", ">", "<=", ">=", "isblank", "isnotblank"],
                    boolean: ["=", "<>", "isblank", "isnotblank"],
                    object: ["isblank", "isnotblank"]
                };
                const DEFAULT_FORMAT = {
                    date: "shortDate",
                    datetime: "shortDateShortTime"
                };
                const LOOKUP_OPERATIONS = ["=", "<>", "isblank", "isnotblank"];
                const AVAILABLE_FIELD_PROPERTIES = ["caption", "customizeText", "dataField", "dataType", "editorTemplate", "falseText", "editorOptions", "filterOperations", "format", "lookup", "trueText", "calculateFilterExpression", "name"];
                const FILTER_BUILDER_ITEM_TEXT_CLASS = "".concat("dx-filterbuilder", "-text");
                const FILTER_BUILDER_ITEM_TEXT_PART_CLASS = "".concat(FILTER_BUILDER_ITEM_TEXT_CLASS, "-part");
                const FILTER_BUILDER_ITEM_TEXT_SEPARATOR_CLASS = "".concat(FILTER_BUILDER_ITEM_TEXT_CLASS, "-separator");
                const FILTER_BUILDER_ITEM_TEXT_SEPARATOR_EMPTY_CLASS = "".concat(FILTER_BUILDER_ITEM_TEXT_SEPARATOR_CLASS, "-empty");

                function isNegationGroup(group) {
                    return group && group.length > 1 && "!" === group[0] && !isCondition(group)
                }

                function getGroupCriteria(group) {
                    return isNegationGroup(group) ? group[1] : group
                }

                function getCriteriaOperation(criteria) {
                    if (isCondition(criteria)) {
                        return "and"
                    }
                    let value = "";
                    for (let i = 0; i < criteria.length; i++) {
                        const item = criteria[i];
                        if (!Array.isArray(item)) {
                            if (value && value !== item) {
                                throw new _errors.errors.Error("E4019")
                            }
                            if ("!" !== item) {
                                value = item
                            }
                        }
                    }
                    return value
                }

                function getGroupValue(group) {
                    const criteria = getGroupCriteria(group);
                    let value = getCriteriaOperation(criteria);
                    if (!value) {
                        value = "and"
                    }
                    if (criteria !== group) {
                        value = "!".concat(value)
                    }
                    return value
                }

                function getFilterOperations(field) {
                    const result = (entity = field.filterOperations, Array.isArray(entity) && entity.length) ? field.filterOperations : function(field) {
                        return field.lookup && LOOKUP_OPERATIONS || DATATYPE_OPERATIONS[field.dataType || "string"]
                    }(field);
                    var entity;
                    return (0, _extend.extend)([], result)
                }

                function getCaptionByOperation(operation, filterOperationDescriptions) {
                    const operationName = _m_filter_operations_dictionary.default.getNameByFilterOperation(operation);
                    return filterOperationDescriptions && filterOperationDescriptions[operationName] ? filterOperationDescriptions[operationName] : operationName
                }

                function getCustomOperation(customOperations, name) {
                    const filteredOperations = customOperations.filter(item => item.name === name);
                    return filteredOperations.length ? filteredOperations[0] : null
                }

                function getDefaultOperation(field) {
                    return field.defaultFilterOperation || getFilterOperations(field)[0]
                }

                function removeItem(group, item) {
                    const criteria = getGroupCriteria(group);
                    const index = criteria.indexOf(item);
                    criteria.splice(index, 1);
                    if (1 !== criteria.length) {
                        criteria.splice(index, 1)
                    }
                    return group
                }

                function createEmptyGroup(value) {
                    const isNegation = isNegationGroupOperation(value);
                    const groupOperation = isNegation ? getGroupOperationFromNegationOperation(value) : value;
                    return isNegation ? ["!", [groupOperation]] : [groupOperation]
                }

                function getField(dataField, fields) {
                    for (let i = 0; i < fields.length; i++) {
                        if (fields[i].name === dataField) {
                            return fields[i]
                        }
                        if (fields[i].dataField.toLowerCase() === dataField.toLowerCase()) {
                            return fields[i]
                        }
                    }
                    const extendedFields = getItems(fields, true).filter(item => item.dataField.toLowerCase() === dataField.toLowerCase());
                    if (extendedFields.length > 0) {
                        return extendedFields[0]
                    }
                    throw new _ui.default.Error("E1047", dataField)
                }

                function isGroup(criteria) {
                    if (!Array.isArray(criteria)) {
                        return false
                    }
                    return criteria.length < 2 || Array.isArray(criteria[0]) || Array.isArray(criteria[1])
                }

                function isCondition(criteria) {
                    if (!Array.isArray(criteria)) {
                        return false
                    }
                    return criteria.length > 1 && !Array.isArray(criteria[0]) && !Array.isArray(criteria[1])
                }

                function convertToInnerGroup(group, customOperations, defaultGroupOperation) {
                    defaultGroupOperation = defaultGroupOperation || "and";
                    const groupOperation = getCriteriaOperation(group).toLowerCase() || defaultGroupOperation;
                    let innerGroup = [];
                    for (let i = 0; i < group.length; i++) {
                        if (isGroup(group[i])) {
                            innerGroup.push(convertToInnerStructure(group[i], customOperations, defaultGroupOperation));
                            innerGroup = appendGroupOperationToGroup(innerGroup, groupOperation)
                        } else if (isCondition(group[i])) {
                            innerGroup.push(convertToInnerCondition(group[i], customOperations));
                            innerGroup = appendGroupOperationToGroup(innerGroup, groupOperation)
                        }
                    }
                    if (0 === innerGroup.length) {
                        innerGroup = appendGroupOperationToGroup(innerGroup, groupOperation)
                    }
                    return innerGroup
                }

                function convertToInnerCondition(condition, customOperations) {
                    if (function(condition, customOperations) {
                            const customOperation = getCustomOperation(customOperations, condition[1]);
                            return customOperation && customOperation.name === condition[1]
                        }(condition, customOperations)) {
                        return condition
                    }
                    if (condition.length < 3) {
                        condition[2] = condition[1];
                        condition[1] = "="
                    }
                    return condition
                }

                function isNegationGroupOperation(operation) {
                    return -1 !== operation.indexOf("not")
                }

                function getGroupOperationFromNegationOperation(operation) {
                    return operation.substring(3).toLowerCase()
                }

                function appendGroupOperationToCriteria(criteria, groupOperation) {
                    const isNegation = isNegationGroupOperation(groupOperation);
                    groupOperation = isNegation ? getGroupOperationFromNegationOperation(groupOperation) : groupOperation;
                    return isNegation ? ["!", criteria, groupOperation] : [criteria, groupOperation]
                }

                function appendGroupOperationToGroup(group, groupOperation) {
                    const isNegation = isNegationGroupOperation(groupOperation);
                    groupOperation = isNegation ? getGroupOperationFromNegationOperation(groupOperation) : groupOperation;
                    group.push(groupOperation);
                    let result = group;
                    if (isNegation) {
                        result = ["!", result]
                    }
                    return result
                }

                function convertToInnerStructure(value, customOperations, defaultGroupOperation) {
                    defaultGroupOperation = defaultGroupOperation || "and";
                    if (!value) {
                        return createEmptyGroup(defaultGroupOperation)
                    }
                    value = (0, _extend.extend)(true, [], value);
                    if (isCondition(value)) {
                        return appendGroupOperationToCriteria(convertToInnerCondition(value, customOperations), defaultGroupOperation)
                    }
                    if (isNegationGroup(value)) {
                        return ["!", isCondition(value[1]) ? appendGroupOperationToCriteria(convertToInnerCondition(value[1], customOperations), defaultGroupOperation) : isNegationGroup(value[1]) ? appendGroupOperationToCriteria(convertToInnerStructure(value[1], customOperations), defaultGroupOperation) : convertToInnerGroup(value[1], customOperations, defaultGroupOperation)]
                    }
                    return convertToInnerGroup(value, customOperations, defaultGroupOperation)
                }

                function getConditionFilterExpression(condition, fields, customOperations, target) {
                    const field = getField(condition[0], fields);
                    const filterExpression = convertToInnerCondition(condition, customOperations);
                    const customOperation = customOperations.length && getCustomOperation(customOperations, filterExpression[1]);
                    if (customOperation && customOperation.calculateFilterExpression) {
                        return customOperation.calculateFilterExpression.apply(customOperation, [filterExpression[2], field, fields])
                    }
                    if (field.createFilterExpression) {
                        return field.createFilterExpression.apply(field, [filterExpression[2], filterExpression[1], target])
                    }
                    if (field.calculateFilterExpression) {
                        return field.calculateFilterExpression.apply(field, [filterExpression[2], filterExpression[1], target])
                    }
                    return field.defaultCalculateFilterExpression.apply(field, [filterExpression[2], filterExpression[1], target])
                }

                function getPrimitiveValueText(field, value, customOperation, target, options) {
                    let valueText;
                    if (true === value) {
                        valueText = field.trueText || _message.default.format("dxDataGrid-trueText")
                    } else if (false === value) {
                        valueText = field.falseText || _message.default.format("dxDataGrid-falseText")
                    } else {
                        valueText = function(field, value) {
                            const fieldFormat = field.format || DEFAULT_FORMAT[field.dataType];
                            return _format_helper.default.format(value, fieldFormat)
                        }(field, value)
                    }
                    if (field.customizeText) {
                        valueText = field.customizeText.call(field, {
                            value: value,
                            valueText: valueText,
                            target: target
                        })
                    }
                    if (customOperation && customOperation.customizeText) {
                        valueText = customOperation.customizeText.call(customOperation, {
                            value: value,
                            valueText: valueText,
                            field: field,
                            target: target
                        }, options)
                    }
                    return valueText
                }

                function getArrayValueText(field, value, customOperation, target) {
                    const options = {
                        values: value
                    };
                    return value.map(v => getPrimitiveValueText(field, v, customOperation, target, options))
                }

                function checkDefaultValue(value) {
                    return "" === value || null === value
                }

                function itemExists(plainItems, parentId) {
                    return plainItems.some(item => item.dataField === parentId)
                }

                function pushItemAndCheckParent(originalItems, plainItems, item) {
                    const {
                        dataField: dataField
                    } = item;
                    if (hasParent(dataField)) {
                        item.parentId = getParentIdFromItemDataField(dataField);
                        if (!itemExists(plainItems, item.parentId) && !itemExists(originalItems, item.parentId)) {
                            pushItemAndCheckParent(originalItems, plainItems, {
                                id: item.parentId,
                                dataType: "object",
                                dataField: item.parentId,
                                caption: generateCaptionByDataField(item.parentId, true),
                                filterOperations: ["isblank", "isnotblank"],
                                defaultCalculateFilterExpression: _filtering.default.defaultCalculateFilterExpression
                            })
                        }
                    }
                    plainItems.push(item)
                }

                function generateCaptionByDataField(dataField, allowHierarchicalFields) {
                    let caption = "";
                    if (allowHierarchicalFields) {
                        dataField = dataField.substring(dataField.lastIndexOf(".") + 1)
                    } else if (hasParent(dataField)) {
                        dataField.split(".").forEach((field, index, arr) => {
                            caption += (0, _inflector.captionize)(field);
                            if (index !== arr.length - 1) {
                                caption += "."
                            }
                        });
                        return caption
                    }
                    return (0, _inflector.captionize)(dataField)
                }

                function getItems(fields, allowHierarchicalFields) {
                    const items = [];
                    for (let i = 0; i < fields.length; i++) {
                        const item = (0, _extend.extend)(true, {
                            caption: generateCaptionByDataField(fields[i].dataField, allowHierarchicalFields)
                        }, fields[i]);
                        item.id = item.name || item.dataField;
                        if (allowHierarchicalFields) {
                            pushItemAndCheckParent(fields, items, item)
                        } else {
                            items.push(item)
                        }
                    }
                    return items
                }

                function hasParent(dataField) {
                    return -1 !== dataField.lastIndexOf(".")
                }

                function getParentIdFromItemDataField(dataField) {
                    return dataField.substring(0, dataField.lastIndexOf("."))
                }

                function updateConditionByOperation(condition, operation, customOperations) {
                    let customOperation = getCustomOperation(customOperations, operation);
                    if (customOperation) {
                        if (false === customOperation.hasValue) {
                            condition[1] = operation;
                            condition.length = 2
                        } else {
                            condition[1] = operation;
                            condition[2] = ""
                        }
                        return condition
                    }
                    if ("isblank" === operation) {
                        condition[1] = "=";
                        condition[2] = null
                    } else if ("isnotblank" === operation) {
                        condition[1] = "<>";
                        condition[2] = null
                    } else {
                        customOperation = getCustomOperation(customOperations, condition[1]);
                        if (customOperation || 2 === condition.length || null === condition[2]) {
                            condition[2] = ""
                        }
                        condition[1] = operation
                    }
                    return condition
                }

                function isValidCondition(condition) {
                    return "" !== condition[2]
                }

                function isMatchedCondition(filter, addedFilterDataField) {
                    return filter[0] === addedFilterDataField
                }

                function syncConditionIntoGroup(filter, addedFilter, canPush) {
                    const result = [];
                    filter.forEach(item => {
                        if (isCondition(item)) {
                            if (isMatchedCondition(item, addedFilter[0])) {
                                if (canPush) {
                                    result.push(addedFilter);
                                    canPush = false
                                } else {
                                    result.splice(result.length - 1, 1)
                                }
                            } else {
                                result.push(item)
                            }
                        } else {
                            (result.length || isGroup(item)) && result.push(item)
                        }
                    });
                    if (0 === result.length) {
                        return null
                    }
                    if (canPush) {
                        result.push("and");
                        result.push(addedFilter)
                    }
                    return 1 === result.length ? result[0] : result
                }
                exports.renderValueText = function($container, value, customOperation) {
                    if (Array.isArray(value)) {
                        const lastItemIndex = value.length - 1;
                        $container.empty();
                        value.forEach((t, i) => {
                            (0, _renderer.default)("<span>").addClass(FILTER_BUILDER_ITEM_TEXT_PART_CLASS).text(t).appendTo($container);
                            if (i !== lastItemIndex) {
                                (0, _renderer.default)("<span>").addClass(FILTER_BUILDER_ITEM_TEXT_SEPARATOR_CLASS).text(customOperation && customOperation.valueSeparator ? customOperation.valueSeparator : "|").addClass(FILTER_BUILDER_ITEM_TEXT_SEPARATOR_EMPTY_CLASS).appendTo($container)
                            }
                        })
                    } else if (value) {
                        $container.text(value)
                    } else {
                        $container.text(_message.default.format("dxFilterBuilder-enterValueText"))
                    }
                }
            },
        48252:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/export/m_export.js ***!
              \*******************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ExportController = exports.DataProvider = void 0;
                __webpack_require__( /*! ../../../../ui/button */ 63008);
                __webpack_require__( /*! ../../../../ui/drop_down_button */ 45231);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _position = __webpack_require__( /*! ../../../../core/utils/position */ 37518);
                var _string = __webpack_require__( /*! ../../../../core/utils/string */ 68752);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _list_light = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/list_light */ 56757));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_export = __webpack_require__( /*! ../../../grids/grid_core/m_export */ 1229);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _inheritsLoose(subClass, superClass) {
                    subClass.prototype = Object.create(superClass.prototype);
                    subClass.prototype.constructor = subClass;
                    _setPrototypeOf(subClass, superClass)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                let DataProvider = function() {
                    function DataProvider(exportController, initialColumnWidthsByColumnIndex, selectedRowsOnly) {
                        this._exportController = exportController;
                        this._initialColumnWidthsByColumnIndex = initialColumnWidthsByColumnIndex;
                        this._selectedRowsOnly = selectedRowsOnly
                    }
                    var _proto = DataProvider.prototype;
                    _proto._getGroupValue = function(item) {
                        const {
                            key: key,
                            data: data,
                            rowType: rowType,
                            groupIndex: groupIndex,
                            summaryCells: summaryCells
                        } = item;
                        const groupColumn = this._options.groupColumns[groupIndex];
                        const value = _m_core.default.getDisplayValue(groupColumn, groupColumn.deserializeValue ? groupColumn.deserializeValue(key[groupIndex]) : key[groupIndex], data, rowType);
                        let result = "".concat(groupColumn.caption, ": ").concat(_m_core.default.formatValue(value, groupColumn));
                        if (summaryCells && summaryCells[0] && summaryCells[0].length) {
                            result += " ".concat(_m_core.default.getGroupRowSummaryText(summaryCells[0], this._options.summaryTexts))
                        }
                        return result
                    };
                    _proto._correctCellIndex = function(cellIndex) {
                        return cellIndex
                    };
                    _proto._initOptions = function() {
                        const exportController = this._exportController;
                        const groupColumns = exportController._columnsController.getGroupColumns();
                        this._options = {
                            columns: exportController._getColumns(this._initialColumnWidthsByColumnIndex),
                            groupColumns: groupColumns,
                            items: this._selectedRowsOnly || exportController._selectionOnly ? exportController._getSelectedItems() : exportController._getAllItems(),
                            isHeadersVisible: exportController.option("showColumnHeaders"),
                            summaryTexts: exportController.option("summary.texts"),
                            rtlEnabled: exportController.option("rtlEnabled")
                        }
                    };
                    _proto.getHeaderStyles = function() {
                        return [{
                            bold: true,
                            alignment: "center"
                        }, {
                            bold: true,
                            alignment: "left"
                        }, {
                            bold: true,
                            alignment: "right"
                        }]
                    };
                    _proto.getGroupRowStyle = function() {
                        return {
                            bold: true,
                            alignment: (0, _position.getDefaultAlignment)(this._options.rtlEnabled)
                        }
                    };
                    _proto.getColumnStyles = function() {
                        const columnStyles = [];
                        this.getColumns().forEach(column => {
                            columnStyles.push({
                                alignment: column.alignment || "left",
                                format: column.format,
                                dataType: column.dataType
                            })
                        });
                        return columnStyles
                    };
                    _proto.getStyles = function() {
                        return [...this.getHeaderStyles(), ...this.getColumnStyles(), this.getGroupRowStyle()]
                    };
                    _proto._getTotalCellStyleId = function(cellIndex) {
                        var _a;
                        const alignment = (null === (_a = this.getColumns()[cellIndex]) || void 0 === _a ? void 0 : _a.alignment) || "right";
                        return this.getHeaderStyles().map(style => style.alignment).indexOf(alignment)
                    };
                    _proto.getStyleId = function(rowIndex, cellIndex) {
                        if (rowIndex < this.getHeaderRowCount()) {
                            return 0
                        }
                        if (this.isTotalCell(rowIndex - this.getHeaderRowCount(), cellIndex)) {
                            return this._getTotalCellStyleId(cellIndex)
                        }
                        if (this.isGroupRow(rowIndex - this.getHeaderRowCount())) {
                            return this.getHeaderStyles().length + this.getColumns().length
                        }
                        return cellIndex + this.getHeaderStyles().length
                    };
                    _proto.getColumns = function(getColumnsByAllRows) {
                        const {
                            columns: columns
                        } = this._options;
                        return getColumnsByAllRows ? columns : columns[columns.length - 1]
                    };
                    _proto.getColumnsWidths = function() {
                        const columns = this.getColumns();
                        return (0, _type.isDefined)(columns) ? columns.map(c => c.width) : void 0
                    };
                    _proto.getRowsCount = function() {
                        return this._options.items.length + this.getHeaderRowCount()
                    };
                    _proto.getHeaderRowCount = function() {
                        if (this.isHeadersVisible()) {
                            return this._options.columns.length - 1
                        }
                        return 0
                    };
                    _proto.isGroupRow = function(rowIndex) {
                        return rowIndex < this._options.items.length && "group" === this._options.items[rowIndex].rowType
                    };
                    _proto.getGroupLevel = function(rowIndex) {
                        const item = this._options.items[rowIndex - this.getHeaderRowCount()];
                        const groupIndex = item && item.groupIndex;
                        if (item && "totalFooter" === item.rowType) {
                            return 0
                        }
                        return (0, _type.isDefined)(groupIndex) ? groupIndex : this._options.groupColumns.length
                    };
                    _proto.getCellType = function(rowIndex, cellIndex) {
                        const columns = this.getColumns();
                        if (rowIndex < this.getHeaderRowCount()) {
                            return "string"
                        }
                        rowIndex -= this.getHeaderRowCount();
                        if (cellIndex < columns.length) {
                            const item = this._options.items.length && this._options.items[rowIndex];
                            const column = columns[cellIndex];
                            if (item && "data" === item.rowType) {
                                if (isFinite(item.values[this._correctCellIndex(cellIndex)]) && !(0, _type.isDefined)(column.customizeText)) {
                                    return (0, _type.isDefined)(column.lookup) ? column.lookup.dataType : column.dataType
                                }
                            }
                            return "string"
                        }
                    };
                    _proto.ready = function() {
                        this._initOptions();
                        const options = this._options;
                        return (0, _deferred.when)(options.items).done(items => {
                            options.items = items
                        }).fail(() => {
                            options.items = []
                        })
                    };
                    _proto._convertFromGridGroupSummaryItems = function(gridGroupSummaryItems) {
                        if ((0, _type.isDefined)(gridGroupSummaryItems) && gridGroupSummaryItems.length > 0) {
                            return gridGroupSummaryItems.map(item => ({
                                value: item.value,
                                name: item.name
                            }))
                        }
                    };
                    _proto.getCellData = function(rowIndex, cellIndex, isExcelJS) {
                        let value;
                        let column;
                        const result = {
                            cellSourceData: {},
                            value: value
                        };
                        const columns = this.getColumns();
                        const correctedCellIndex = this._correctCellIndex(cellIndex);
                        if (rowIndex < this.getHeaderRowCount()) {
                            const columnsRow = this.getColumns(true)[rowIndex];
                            column = columnsRow[cellIndex];
                            result.cellSourceData.rowType = "header";
                            result.cellSourceData.column = column && column.gridColumn;
                            result.value = column && column.caption
                        } else {
                            rowIndex -= this.getHeaderRowCount();
                            const item = this._options.items.length && this._options.items[rowIndex];
                            if (item) {
                                const itemValues = item.values;
                                result.cellSourceData.rowType = item.rowType;
                                result.cellSourceData.column = columns[cellIndex] && columns[cellIndex].gridColumn;
                                switch (item.rowType) {
                                    case "groupFooter":
                                    case "totalFooter":
                                        if (correctedCellIndex < itemValues.length) {
                                            value = itemValues[correctedCellIndex];
                                            if ((0, _type.isDefined)(value)) {
                                                result.cellSourceData.value = value.value;
                                                result.cellSourceData.totalSummaryItemName = value.name;
                                                result.value = _m_core.default.getSummaryText(value, this._options.summaryTexts)
                                            } else {
                                                result.cellSourceData.value = void 0
                                            }
                                        }
                                        break;
                                    case "group":
                                        result.cellSourceData.groupIndex = item.groupIndex;
                                        if (cellIndex < 1) {
                                            result.cellSourceData.column = this._options.groupColumns[item.groupIndex];
                                            result.cellSourceData.value = item.key[item.groupIndex];
                                            result.cellSourceData.groupSummaryItems = this._convertFromGridGroupSummaryItems(item.summaryCells[0]);
                                            result.value = this._getGroupValue(item)
                                        } else {
                                            const summaryItems = item.values[correctedCellIndex];
                                            if (Array.isArray(summaryItems)) {
                                                result.cellSourceData.groupSummaryItems = this._convertFromGridGroupSummaryItems(summaryItems);
                                                value = "";
                                                for (let i = 0; i < summaryItems.length; i++) {
                                                    value += (i > 0 ? isExcelJS ? "\n" : " \n " : "") + _m_core.default.getSummaryText(summaryItems[i], this._options.summaryTexts)
                                                }
                                                result.value = value
                                            } else {
                                                result.cellSourceData.value = void 0
                                            }
                                        }
                                        break;
                                    default:
                                        column = columns[cellIndex];
                                        if (column) {
                                            const value = itemValues[correctedCellIndex];
                                            const displayValue = _m_core.default.getDisplayValue(column, value, item.data, item.rowType);
                                            if (!isFinite(displayValue) || (0, _type.isDefined)(column.customizeText)) {
                                                if (isExcelJS && (0, _type.isDefined)(column.customizeText) && column.customizeText === this._exportController._columnsController.getCustomizeTextByDataType("boolean")) {
                                                    result.value = displayValue
                                                } else {
                                                    result.value = _m_core.default.formatValue(displayValue, column)
                                                }
                                            } else {
                                                result.value = displayValue
                                            }
                                            result.cellSourceData.value = value
                                        }
                                        result.cellSourceData.data = item.data
                                }
                            }
                        }
                        return result
                    };
                    _proto.isHeadersVisible = function() {
                        return this._options.isHeadersVisible
                    };
                    _proto.isTotalCell = function(rowIndex, cellIndex) {
                        const {
                            items: items
                        } = this._options;
                        const item = items[rowIndex];
                        const correctCellIndex = this._correctCellIndex(cellIndex);
                        const isSummaryAlignByColumn = item.summaryCells && item.summaryCells[correctCellIndex] && item.summaryCells[correctCellIndex].length > 0 && item.summaryCells[correctCellIndex][0].alignByColumn;
                        return item && "groupFooter" === item.rowType || "totalFooter" === item.rowType || isSummaryAlignByColumn
                    };
                    _proto.getCellMerging = function(rowIndex, cellIndex) {
                        const {
                            columns: columns
                        } = this._options;
                        const column = columns[rowIndex] && columns[rowIndex][cellIndex];
                        return column ? {
                            colspan: (column.exportColspan || 1) - 1,
                            rowspan: (column.rowspan || 1) - 1
                        } : {
                            colspan: 0,
                            rowspan: 0
                        }
                    };
                    _proto.getFrozenArea = function() {
                        return {
                            x: 0,
                            y: this.getHeaderRowCount()
                        }
                    };
                    return DataProvider
                }();
                exports.DataProvider = DataProvider;
                let ExportController = function(_dataGridCore$ViewCon) {
                    _inheritsLoose(ExportController, _dataGridCore$ViewCon);

                    function ExportController() {
                        return _dataGridCore$ViewCon.apply(this, arguments) || this
                    }
                    var _proto2 = ExportController.prototype;
                    _proto2._getEmptyCell = function() {
                        return {
                            caption: "",
                            colspan: 1,
                            rowspan: 1
                        }
                    };
                    _proto2._updateColumnWidth = function(column, width) {
                        column.width = width
                    };
                    _proto2._getColumns = function(initialColumnWidthsByColumnIndex) {
                        let result = [];
                        let i;
                        let columns;
                        const columnsController = this._columnsController;
                        const rowCount = columnsController.getRowCount();
                        for (i = 0; i <= rowCount; i++) {
                            const currentHeaderRow = [];
                            columns = columnsController.getVisibleColumns(i, true);
                            let columnWidthsByColumnIndex;
                            if (i === rowCount) {
                                if (this._updateLockCount) {
                                    columnWidthsByColumnIndex = initialColumnWidthsByColumnIndex
                                } else {
                                    const columnWidths = this._getColumnWidths(this._headersView, this._rowsView);
                                    if (columnWidths && columnWidths.length) {
                                        columnWidthsByColumnIndex = {};
                                        for (let i = 0; i < columns.length; i++) {
                                            columnWidthsByColumnIndex[columns[i].index] = columnWidths[i]
                                        }
                                    }
                                }
                            }
                            for (let j = 0; j < columns.length; j++) {
                                const column = (0, _extend.extend)({}, columns[j], {
                                    dataType: "datetime" === columns[j].dataType ? "date" : columns[j].dataType,
                                    gridColumn: columns[j]
                                });
                                if (this._needColumnExporting(column)) {
                                    const currentColspan = this._calculateExportColspan(column);
                                    if ((0, _type.isDefined)(currentColspan)) {
                                        column.exportColspan = currentColspan
                                    }
                                    if (columnWidthsByColumnIndex) {
                                        this._updateColumnWidth(column, columnWidthsByColumnIndex[column.index])
                                    }
                                    currentHeaderRow.push(column)
                                }
                            }
                            result.push(currentHeaderRow)
                        }
                        columns = result[rowCount];
                        result = (0, _m_export.prepareItems)(result.slice(0, -1), this._getEmptyCell());
                        result.push(columns);
                        return result
                    };
                    _proto2._calculateExportColspan = function(column) {
                        if (!column.isBand) {
                            return
                        }
                        const childColumns = this._columnsController.getChildrenByBandColumn(column.index, true);
                        if (!(0, _type.isDefined)(childColumns)) {
                            return
                        }
                        return childColumns.reduce((result, childColumn) => {
                            if (this._needColumnExporting(childColumn)) {
                                return result + (this._calculateExportColspan(childColumn) || 1)
                            }
                            return result
                        }, 0)
                    };
                    _proto2._needColumnExporting = function(column) {
                        return !column.command && (column.allowExporting || void 0 === column.allowExporting)
                    };
                    _proto2._getFooterSummaryItems = function(summaryCells, isTotal) {
                        const result = [];
                        let estimatedItemsCount = 1;
                        let i = 0;
                        do {
                            const values = [];
                            for (let j = 0; j < summaryCells.length; j++) {
                                const summaryCell = summaryCells[j];
                                const itemsLength = summaryCell.length;
                                if (estimatedItemsCount < itemsLength) {
                                    estimatedItemsCount = itemsLength
                                }
                                values.push(summaryCell[i])
                            }
                            result.push({
                                values: values,
                                rowType: isTotal ? "totalFooter" : "groupFooter"
                            })
                        } while (i++ < estimatedItemsCount - 1);
                        return result
                    };
                    _proto2._hasSummaryGroupFooters = function() {
                        const groupItems = this.option("summary.groupItems");
                        if ((0, _type.isDefined)(groupItems)) {
                            for (let i = 0; i < groupItems.length; i++) {
                                if (groupItems[i].showInGroupFooter) {
                                    return true
                                }
                            }
                        }
                        return false
                    };
                    _proto2._getItemsWithSummaryGroupFooters = function(sourceItems) {
                        let result = [];
                        let beforeGroupFooterItems = [];
                        let groupFooterItems = [];
                        for (let i = 0; i < sourceItems.length; i++) {
                            const item = sourceItems[i];
                            if ("groupFooter" === item.rowType) {
                                groupFooterItems = this._getFooterSummaryItems(item.summaryCells);
                                result = result.concat(beforeGroupFooterItems, groupFooterItems);
                                beforeGroupFooterItems = []
                            } else {
                                beforeGroupFooterItems.push(item)
                            }
                        }
                        return result.length ? result : beforeGroupFooterItems
                    };
                    _proto2._updateGroupValuesWithSummaryByColumn = function(sourceItems) {
                        let summaryValues = [];
                        for (let i = 0; i < sourceItems.length; i++) {
                            const item = sourceItems[i];
                            const {
                                summaryCells: summaryCells
                            } = item;
                            if ("group" === item.rowType && summaryCells && summaryCells.length > 1) {
                                const groupColumnCount = item.values.length;
                                for (let j = 1; j < summaryCells.length; j++) {
                                    for (let k = 0; k < summaryCells[j].length; k++) {
                                        const summaryItem = summaryCells[j][k];
                                        if (summaryItem && summaryItem.alignByColumn) {
                                            if (!Array.isArray(summaryValues[j - groupColumnCount])) {
                                                summaryValues[j - groupColumnCount] = []
                                            }
                                            summaryValues[j - groupColumnCount].push(summaryItem)
                                        }
                                    }
                                }
                                if (summaryValues.length > 0) {
                                    item.values.push(...summaryValues);
                                    summaryValues = []
                                }
                            }
                        }
                    };
                    _proto2._processUnExportedItems = function(items) {
                        const columns = this._columnsController.getVisibleColumns(null, true);
                        const groupColumns = this._columnsController.getGroupColumns();
                        let values;
                        let summaryCells;
                        for (let i = 0; i < items.length; i++) {
                            const item = items[i];
                            let isCommand = false;
                            values = [];
                            summaryCells = [];
                            for (let j = 0; j < columns.length; j++) {
                                const column = columns[j];
                                isCommand || (isCommand = ["detailExpand", "buttons"].includes(column.type));
                                if (this._needColumnExporting(column)) {
                                    if (item.values) {
                                        if ("group" === item.rowType && !values.length) {
                                            values.push(item.key[item.groupIndex])
                                        } else {
                                            values.push(item.values[j])
                                        }
                                    }
                                    if (item.summaryCells) {
                                        if ("group" === item.rowType && !summaryCells.length) {
                                            const index = j - groupColumns.length + item.groupIndex;
                                            summaryCells.push(item.summaryCells[isCommand ? index : index + 1])
                                        } else {
                                            summaryCells.push(item.summaryCells[j])
                                        }
                                    }
                                }
                            }
                            if (values.length) {
                                item.values = values
                            }
                            if (summaryCells.length) {
                                item.summaryCells = summaryCells
                            }
                        }
                    };
                    _proto2._getAllItems = function(data) {
                        let skipFilter = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : false;
                        const that = this;
                        const d = new _deferred.Deferred;
                        const dataController = this.getController("data");
                        const footerItems = dataController.footerItems();
                        const totalItem = footerItems.length && footerItems[0];
                        const summaryTotalItems = that.option("summary.totalItems");
                        let summaryCells;
                        (0, _deferred.when)(data).done(data => {
                            dataController.loadAll(data, skipFilter).done((sourceItems, totalAggregates) => {
                                that._updateGroupValuesWithSummaryByColumn(sourceItems);
                                if (that._hasSummaryGroupFooters()) {
                                    sourceItems = that._getItemsWithSummaryGroupFooters(sourceItems)
                                }
                                summaryCells = totalItem && totalItem.summaryCells;
                                if ((0, _type.isDefined)(totalAggregates) && summaryTotalItems) {
                                    summaryCells = that._getSummaryCells(summaryTotalItems, totalAggregates)
                                }
                                const summaryItems = totalItem && that._getFooterSummaryItems(summaryCells, true);
                                if (summaryItems) {
                                    sourceItems = sourceItems.concat(summaryItems)
                                }
                                that._processUnExportedItems(sourceItems);
                                d.resolve(sourceItems)
                            }).fail(d.reject)
                        }).fail(d.reject);
                        return d
                    };
                    _proto2._getSummaryCells = function(summaryTotalItems, totalAggregates) {
                        const dataController = this.getController("data");
                        const columnsController = dataController._columnsController;
                        return dataController._calculateSummaryCells(summaryTotalItems, totalAggregates, columnsController.getVisibleColumns(null, true), (summaryItem, column) => dataController._isDataColumn(column) ? column.index : -1)
                    };
                    _proto2._getSelectedItems = function() {
                        const selectionController = this.getController("selection");
                        if (this.needLoadItemsOnExportingSelectedItems()) {
                            return this._getAllItems(selectionController.loadSelectedItemsWithFilter(), true)
                        }
                        return this._getAllItems(selectionController.getSelectedRowsData())
                    };
                    _proto2._getColumnWidths = function(headersView, rowsView) {
                        return headersView && headersView.isVisible() ? headersView.getColumnWidths() : rowsView.getColumnWidths()
                    };
                    _proto2.throwWarningIfNoOnExportingEvent = function() {
                        var _a, _b;
                        const hasOnExporting = null === (_b = (_a = this.component).hasActionSubscription) || void 0 === _b ? void 0 : _b.call(_a, "onExporting");
                        if (this.option("export.enabled") && !hasOnExporting) {
                            _ui.default.log("W1024")
                        }
                    };
                    _proto2.init = function() {
                        this.throwWarningIfNoOnExportingEvent();
                        this._columnsController = this.getController("columns");
                        this._rowsView = this.getView("rowsView");
                        this._headersView = this.getView("columnHeadersView");
                        this.createAction("onExporting", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    };
                    _proto2.callbackNames = function() {
                        return ["selectionOnlyChanged"]
                    };
                    _proto2.getDataProvider = function(selectedRowsOnly) {
                        const columnWidths = this._getColumnWidths(this._headersView, this._rowsView);
                        let initialColumnWidthsByColumnIndex;
                        if (columnWidths && columnWidths.length) {
                            initialColumnWidthsByColumnIndex = {};
                            const columnsLastRowVisibleColumns = this._columnsController.getVisibleColumns(this._columnsController.getRowCount(), true);
                            for (let i = 0; i < columnsLastRowVisibleColumns.length; i++) {
                                initialColumnWidthsByColumnIndex[columnsLastRowVisibleColumns[i].index] = columnWidths[i]
                            }
                        }
                        return new DataProvider(this, initialColumnWidthsByColumnIndex, selectedRowsOnly)
                    };
                    _proto2.exportTo = function(selectedRowsOnly, format) {
                        this._selectionOnly = selectedRowsOnly;
                        const onExporting = this.getAction("onExporting");
                        const eventArgs = {
                            rtlEnabled: this.option("rtlEnabled"),
                            selectedRowsOnly: !!selectedRowsOnly,
                            format: format,
                            fileName: "DataGrid",
                            cancel: false
                        };
                        (0, _type.isFunction)(onExporting) && onExporting(eventArgs)
                    };
                    _proto2.publicMethods = function() {
                        return ["getDataProvider"]
                    };
                    _proto2.selectionOnly = function(value) {
                        if ((0, _type.isDefined)(value)) {
                            this._isSelectedRows = value;
                            this.selectionOnlyChanged.fire()
                        } else {
                            return this._isSelectedRows
                        }
                    };
                    _proto2.optionChanged = function(args) {
                        _dataGridCore$ViewCon.prototype.optionChanged.call(this, args);
                        if ("export" === args.name) {
                            this.throwWarningIfNoOnExportingEvent()
                        }
                    };
                    _proto2.needLoadItemsOnExportingSelectedItems = function() {
                        var _a;
                        return null !== (_a = this.option("loadItemsOnExportingSelectedItems")) && void 0 !== _a ? _a : this.getController("data")._dataSource.remoteOperations().filtering
                    };
                    return ExportController
                }(_m_core.default.ViewController);
                exports.ExportController = ExportController;
                _m_core.default.registerModule("export", {
                    defaultOptions: () => ({
                        export: {
                            enabled: false,
                            fileName: "DataGrid",
                            formats: ["xlsx"],
                            allowExportSelectedData: false,
                            texts: {
                                exportTo: _message.default.format("dxDataGrid-exportTo"),
                                exportAll: _message.default.format("dxDataGrid-exportAll"),
                                exportSelectedRows: _message.default.format("dxDataGrid-exportSelectedRows")
                            }
                        }
                    }),
                    controllers: {
                        export: ExportController
                    },
                    extenders: {
                        controllers: {
                            editing: Base => function(_Base) {
                                _inheritsLoose(ExportEditingControllerExtender, _Base);

                                function ExportEditingControllerExtender() {
                                    return _Base.apply(this, arguments) || this
                                }
                                var _proto3 = ExportEditingControllerExtender.prototype;
                                _proto3.callbackNames = function() {
                                    const callbackList = _Base.prototype.callbackNames.call(this);
                                    return (0, _type.isDefined)(callbackList) ? callbackList.push("editingButtonsUpdated") : ["editingButtonsUpdated"]
                                };
                                _proto3._updateEditButtons = function() {
                                    _Base.prototype._updateEditButtons.call(this);
                                    this.editingButtonsUpdated.fire()
                                };
                                return ExportEditingControllerExtender
                            }(Base)
                        },
                        views: {
                            headerPanel: Base => function(_Base2) {
                                _inheritsLoose(ExportHeaderPanelExtender, _Base2);

                                function ExportHeaderPanelExtender() {
                                    return _Base2.apply(this, arguments) || this
                                }
                                var _proto4 = ExportHeaderPanelExtender.prototype;
                                _proto4._getToolbarItems = function() {
                                    const items = _Base2.prototype._getToolbarItems.call(this);
                                    const exportButton = this._getExportToolbarButton();
                                    if (exportButton) {
                                        items.push(exportButton);
                                        this._correctItemsPosition(items)
                                    }
                                    return items
                                };
                                _proto4._getExportToolbarButton = function() {
                                    const items = this._getExportToolbarItems();
                                    if (0 === items.length) {
                                        return null
                                    }
                                    const disabled = this._needDisableExportButton();
                                    const toolbarButtonOptions = {
                                        name: "exportButton",
                                        location: "after",
                                        locateInMenu: "auto",
                                        sortIndex: 30,
                                        options: {
                                            items: items
                                        },
                                        disabled: disabled
                                    };
                                    if (1 === items.length) {
                                        const widgetOptions = _extends(_extends({}, items[0]), {
                                            hint: items[0].text,
                                            elementAttr: {
                                                class: "dx-datagrid-export-button"
                                            }
                                        });
                                        toolbarButtonOptions.widget = "dxButton";
                                        toolbarButtonOptions.showText = "inMenu";
                                        toolbarButtonOptions.options = widgetOptions
                                    } else {
                                        const widgetOptions = {
                                            icon: "export",
                                            displayExpr: "text",
                                            items: items,
                                            hint: this.option("export.texts.exportTo"),
                                            elementAttr: {
                                                class: "dx-datagrid-export-button"
                                            },
                                            dropDownOptions: {
                                                width: "auto",
                                                _wrapperClassExternal: "dx-datagrid-export-menu"
                                            }
                                        };
                                        toolbarButtonOptions.options = widgetOptions;
                                        toolbarButtonOptions.widget = "dxDropDownButton";
                                        toolbarButtonOptions.menuItemTemplate = (_data, _index, container) => {
                                            this._createComponent((0, _renderer.default)(container), _list_light.default, {
                                                items: items
                                            })
                                        }
                                    }
                                    return toolbarButtonOptions
                                };
                                _proto4._getExportToolbarItems = function() {
                                    var _a;
                                    const exportOptions = this.option("export");
                                    const texts = this.option("export.texts");
                                    const formats = null !== (_a = this.option("export.formats")) && void 0 !== _a ? _a : [];
                                    if (!exportOptions.enabled) {
                                        return []
                                    }
                                    const items = [];
                                    formats.forEach(formatType => {
                                        let formatName = formatType.toUpperCase();
                                        let exportAllIcon = "export";
                                        if ("xlsx" === formatType) {
                                            formatName = "Excel";
                                            exportAllIcon = "xlsxfile"
                                        }
                                        if ("pdf" === formatType) {
                                            exportAllIcon = "pdffile"
                                        }
                                        items.push({
                                            text: (0, _string.format)(texts.exportAll, formatName),
                                            icon: exportAllIcon,
                                            onClick: () => {
                                                this._exportController.exportTo(false, formatType)
                                            }
                                        });
                                        if (exportOptions.allowExportSelectedData) {
                                            items.push({
                                                text: (0, _string.format)(texts.exportSelectedRows, formatName),
                                                icon: "exportselected",
                                                onClick: () => {
                                                    this._exportController.exportTo(true, formatType)
                                                }
                                            })
                                        }
                                    });
                                    return items
                                };
                                _proto4._correctItemsPosition = function(items) {
                                    items.sort((itemA, itemB) => itemA.sortIndex - itemB.sortIndex)
                                };
                                _proto4._isExportButtonVisible = function() {
                                    return this.option("export.enabled")
                                };
                                _proto4.optionChanged = function(args) {
                                    _Base2.prototype.optionChanged.call(this, args);
                                    if ("export" === args.name) {
                                        args.handled = true;
                                        this._invalidate()
                                    }
                                };
                                _proto4._needDisableExportButton = function() {
                                    const isDataColumnsInvisible = !this._columnsController.hasVisibleDataColumns();
                                    const hasUnsavedChanges = this._editingController.hasChanges();
                                    return isDataColumnsInvisible || hasUnsavedChanges
                                };
                                _proto4._columnOptionChanged = function(e) {
                                    _Base2.prototype._columnOptionChanged.call(this, e);
                                    const isColumnLocationChanged = _m_core.default.checkChanges(e.optionNames, ["groupIndex", "visible", "all"]);
                                    if (isColumnLocationChanged) {
                                        const disabled = this._needDisableExportButton();
                                        this.setToolbarItemDisabled("exportButton", disabled)
                                    }
                                };
                                _proto4.init = function() {
                                    _Base2.prototype.init.call(this);
                                    this._exportController = this.getController("export");
                                    this._editingController = this.getController("editing");
                                    this._editingController.editingButtonsUpdated.add(() => {
                                        const disabled = this._needDisableExportButton();
                                        this.setToolbarItemDisabled("exportButton", disabled)
                                    })
                                };
                                _proto4.isVisible = function() {
                                    return _Base2.prototype.isVisible.call(this) || this._isExportButtonVisible()
                                };
                                return ExportHeaderPanelExtender
                            }(Base)
                        }
                    }
                })
            },
        56445:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/focus/m_focus.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _m_focus = __webpack_require__( /*! ../../../grids/grid_core/focus/m_focus */ 5325);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _m_utils = __webpack_require__( /*! ../m_utils */ 10087);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
                _m_core.default.registerModule("focus", _extends(_extends({}, _m_focus.focusModule), {
                    extenders: _extends(_extends({}, _m_focus.focusModule.extenders), {
                        controllers: _extends(_extends({}, _m_focus.focusModule.extenders.controllers), {
                            data: Base => function(_focusModule$extender) {
                                ! function(subClass, superClass) {
                                    subClass.prototype = Object.create(superClass.prototype);
                                    subClass.prototype.constructor = subClass;
                                    _setPrototypeOf(subClass, superClass)
                                }(FocusDataControllerExtender, _focusModule$extender);

                                function FocusDataControllerExtender() {
                                    return _focusModule$extender.apply(this, arguments) || this
                                }
                                var _proto = FocusDataControllerExtender.prototype;
                                _proto.changeRowExpand = function(path, isRowClick) {
                                    if (this.option("focusedRowEnabled") && Array.isArray(path) && this.isRowExpanded(path)) {
                                        const keyboardNavigation = this.getController("keyboardNavigation");
                                        if ((!isRowClick || !keyboardNavigation.isKeyboardEnabled()) && this._isFocusedRowInsideGroup(path)) {
                                            this.option("focusedRowKey", path)
                                        }
                                    }
                                    return _focusModule$extender.prototype.changeRowExpand.call(this, path, isRowClick)
                                };
                                _proto._isFocusedRowInsideGroup = function(path) {
                                    const columnsController = this.getController("columns");
                                    const focusedRowKey = this.option("focusedRowKey");
                                    const rowIndex = this.getRowIndexByKey(focusedRowKey);
                                    const focusedRow = rowIndex >= 0 && this.getVisibleRows()[rowIndex];
                                    const groups = columnsController.getGroupDataSourceParameters(true);
                                    if (focusedRow) {
                                        for (let i = 0; i < path.length; ++i) {
                                            const getter = (0, _data.compileGetter)(groups[i] && groups[i].selector);
                                            if (getter(focusedRow.data) !== path[i]) {
                                                return false
                                            }
                                        }
                                    }
                                    return true
                                };
                                _proto._getGroupPath = function(groupItem, groupCount) {
                                    const groupPath = [];
                                    let items = [groupItem];
                                    while (items && items[0] && groupCount) {
                                        const item = items[0];
                                        if (void 0 !== item.key) {
                                            groupPath.push(item.key)
                                        }
                                        items = item.items;
                                        groupCount--
                                    }
                                    return groupPath
                                };
                                _proto._expandGroupByPath = function(that, groupPath, level) {
                                    const d = new _deferred.Deferred;
                                    level++;
                                    that.expandRow(groupPath.slice(0, level)).done(() => {
                                        if (level === groupPath.length) {
                                            d.resolve()
                                        } else {
                                            that._expandGroupByPath(that, groupPath, level).done(d.resolve).fail(d.reject)
                                        }
                                    }).fail(d.reject);
                                    return d.promise()
                                };
                                _proto._calculateGlobalRowIndexByGroupedData = function(key) {
                                    const that = this;
                                    const dataSource = that._dataSource;
                                    const filter = that._generateFilterByKey(key);
                                    const deferred = new _deferred.Deferred;
                                    const isGroupKey = Array.isArray(key);
                                    const group = dataSource.group();
                                    if (isGroupKey) {
                                        return deferred.resolve(-1).promise()
                                    }
                                    if (!dataSource._grouping._updatePagingOptions) {
                                        that._calculateGlobalRowIndexByFlatData(key, null, true).done(deferred.resolve).fail(deferred.reject);
                                        return deferred
                                    }
                                    dataSource.load({
                                        filter: that._concatWithCombinedFilter(filter),
                                        group: group
                                    }).done(data => {
                                        if (!data || 0 === data.length || !(0, _type.isDefined)(data[0].key) || -1 === data[0].key) {
                                            return deferred.resolve(-1).promise()
                                        }
                                        const groupPath = that._getGroupPath(data[0], group.length);
                                        that._expandGroupByPath(that, groupPath, 0).done(() => {
                                            that._calculateExpandedRowGlobalIndex(deferred, key, groupPath, group)
                                        }).fail(deferred.reject)
                                    }).fail(deferred.reject);
                                    return deferred.promise()
                                };
                                _proto._calculateExpandedRowGlobalIndex = function(deferred, key, groupPath, group) {
                                    const groupFilter = (0, _m_utils.createGroupFilter)(groupPath, {
                                        group: group
                                    });
                                    const dataSource = this._dataSource;
                                    const scrollingMode = this.option("scrolling.mode");
                                    const isVirtualScrolling = "virtual" === scrollingMode || "infinite" === scrollingMode;
                                    const pageSize = dataSource.pageSize();
                                    let groupOffset;
                                    dataSource._grouping._updatePagingOptions({
                                        skip: 0,
                                        take: MAX_SAFE_INTEGER
                                    }, (groupInfo, totalOffset) => {
                                        if ((0, _common.equalByValue)(groupInfo.path, groupPath)) {
                                            groupOffset = totalOffset
                                        }
                                    });
                                    this._calculateGlobalRowIndexByFlatData(key, groupFilter).done(dataOffset => {
                                        let count;
                                        let groupContinuationCount;
                                        if (dataOffset < 0) {
                                            deferred.resolve(-1);
                                            return
                                        }
                                        const currentPageOffset = groupOffset % pageSize || pageSize;
                                        count = currentPageOffset + dataOffset - groupPath.length;
                                        if (isVirtualScrolling) {
                                            groupContinuationCount = 0
                                        } else {
                                            groupContinuationCount = Math.floor(count / (pageSize - groupPath.length)) * groupPath.length
                                        }
                                        count = groupOffset + dataOffset + groupContinuationCount;
                                        deferred.resolve(count)
                                    }).fail(deferred.reject)
                                };
                                return FocusDataControllerExtender
                            }(_m_focus.focusModule.extenders.controllers.data(Base))
                        })
                    })
                }))
            },
        72487:
            /*!***********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/grouping/m_grouping.js ***!
              \***********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupingHeaderPanelExtender = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../../core/devices */ 20530));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _accessibility = __webpack_require__( /*! ../../../../ui/shared/accessibility */ 56756);
                var _m_accessibility = __webpack_require__( /*! ../../../grids/grid_core/m_accessibility */ 9130);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ../m_data_source_adapter */ 49975));
                var _m_grouping_collapsed = __webpack_require__( /*! ./m_grouping_collapsed */ 2772);
                var _m_grouping_expanded = __webpack_require__( /*! ./m_grouping_expanded */ 4789);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _inheritsLoose(subClass, superClass) {
                    subClass.prototype = Object.create(superClass.prototype);
                    subClass.prototype.constructor = subClass;
                    _setPrototypeOf(subClass, superClass)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                _m_data_source_adapter.default.extend(Base => function(_Base) {
                    _inheritsLoose(GroupingDataSourceAdapterExtender, _Base);

                    function GroupingDataSourceAdapterExtender() {
                        return _Base.apply(this, arguments) || this
                    }
                    var _proto = GroupingDataSourceAdapterExtender.prototype;
                    _proto.init = function() {
                        _Base.prototype.init.apply(this, arguments);
                        this._initGroupingHelper()
                    };
                    _proto._initGroupingHelper = function(options) {
                        const grouping = this._grouping;
                        const isAutoExpandAll = this.option("grouping.autoExpandAll");
                        const isFocusedRowEnabled = this.option("focusedRowEnabled");
                        const remoteOperations = options ? options.remoteOperations : this.remoteOperations();
                        const isODataRemoteOperations = remoteOperations.filtering && remoteOperations.sorting && remoteOperations.paging;
                        if (isODataRemoteOperations && !remoteOperations.grouping && (isAutoExpandAll || !isFocusedRowEnabled)) {
                            if (!grouping || grouping instanceof _m_grouping_collapsed.GroupingHelper) {
                                this._grouping = new _m_grouping_expanded.GroupingHelper(this)
                            }
                        } else if (!grouping || grouping instanceof _m_grouping_expanded.GroupingHelper) {
                            this._grouping = new _m_grouping_collapsed.GroupingHelper(this)
                        }
                    };
                    _proto.totalItemsCount = function() {
                        const totalCount = _Base.prototype.totalItemsCount.call(this);
                        return totalCount > 0 && this._dataSource.group() && this._dataSource.requireTotalCount() ? totalCount + this._grouping.totalCountCorrection() : totalCount
                    };
                    _proto.itemsCount = function() {
                        return this._dataSource.group() ? this._grouping.itemsCount() || 0 : _Base.prototype.itemsCount.apply(this, arguments)
                    };
                    _proto.allowCollapseAll = function() {
                        return this._grouping.allowCollapseAll()
                    };
                    _proto.isGroupItemCountable = function(item) {
                        return this._grouping.isGroupItemCountable(item)
                    };
                    _proto.isRowExpanded = function(key) {
                        const groupInfo = this._grouping.findGroupInfo(key);
                        return groupInfo ? groupInfo.isExpanded : !this._grouping.allowCollapseAll()
                    };
                    _proto.collapseAll = function(groupIndex) {
                        return this._collapseExpandAll(groupIndex, false)
                    };
                    _proto.expandAll = function(groupIndex) {
                        return this._collapseExpandAll(groupIndex, true)
                    };
                    _proto._collapseExpandAll = function(groupIndex, isExpand) {
                        const that = this;
                        const dataSource = that._dataSource;
                        const group = dataSource.group();
                        const groups = _m_core.default.normalizeSortingInfo(group || []);
                        if (groups.length) {
                            for (let i = 0; i < groups.length; i++) {
                                if (void 0 === groupIndex || groupIndex === i) {
                                    groups[i].isExpanded = isExpand
                                } else if (group && group[i]) {
                                    groups[i].isExpanded = group[i].isExpanded
                                }
                            }
                            dataSource.group(groups);
                            that._grouping.foreachGroups((groupInfo, parents) => {
                                if (void 0 === groupIndex || groupIndex === parents.length - 1) {
                                    groupInfo.isExpanded = isExpand
                                }
                            }, false, true);
                            that.resetPagesCache()
                        }
                        return true
                    };
                    _proto.refresh = function() {
                        _Base.prototype.refresh.apply(this, arguments);
                        return this._grouping.refresh.apply(this._grouping, arguments)
                    };
                    _proto.changeRowExpand = function(path) {
                        const that = this;
                        const dataSource = that._dataSource;
                        if (dataSource.group()) {
                            dataSource.beginLoading();
                            if (that._lastLoadOptions) {
                                that._lastLoadOptions.groupExpand = true
                            }
                            return that._changeRowExpandCore(path).always(() => {
                                dataSource.endLoading()
                            })
                        }
                    };
                    _proto._changeRowExpandCore = function(path) {
                        return this._grouping.changeRowExpand(path)
                    };
                    _proto._hasGroupLevelsExpandState = function(group, isExpanded) {
                        if (group && Array.isArray(group)) {
                            for (let i = 0; i < group.length; i++) {
                                if (group[i].isExpanded === isExpanded) {
                                    return true
                                }
                            }
                        }
                    };
                    _proto._customizeRemoteOperations = function(options, operationTypes) {
                        const {
                            remoteOperations: remoteOperations
                        } = options;
                        if (options.storeLoadOptions.group) {
                            if (remoteOperations.grouping && !options.isCustomLoading) {
                                if (!remoteOperations.groupPaging || this._hasGroupLevelsExpandState(options.storeLoadOptions.group, true)) {
                                    remoteOperations.paging = false
                                }
                            }
                            if (!remoteOperations.grouping && (!remoteOperations.sorting || !remoteOperations.filtering || options.isCustomLoading || this._hasGroupLevelsExpandState(options.storeLoadOptions.group, false))) {
                                remoteOperations.paging = false
                            }
                        } else if (!options.isCustomLoading && remoteOperations.paging && operationTypes.grouping) {
                            this.resetCache()
                        }
                        _Base.prototype._customizeRemoteOperations.apply(this, arguments)
                    };
                    _proto._handleDataLoading = function(options) {
                        _Base.prototype._handleDataLoading.call(this, options);
                        this._initGroupingHelper(options);
                        return this._grouping.handleDataLoading(options)
                    };
                    _proto._handleDataLoaded = function(options) {
                        return this._grouping.handleDataLoaded(options, _Base.prototype._handleDataLoaded.bind(this))
                    };
                    _proto._handleDataLoadedCore = function(options) {
                        return this._grouping.handleDataLoadedCore(options, _Base.prototype._handleDataLoadedCore.bind(this))
                    };
                    return GroupingDataSourceAdapterExtender
                }(Base));
                const onGroupingMenuItemClick = function(column, params) {
                    const columnsController = this._columnsController;
                    switch (params.itemData.value) {
                        case "group": {
                            const groups = columnsController._dataSource.group() || [];
                            columnsController.columnOption(column.dataField, "groupIndex", groups.length);
                            break
                        }
                        case "ungroup":
                            columnsController.columnOption(column.dataField, "groupIndex", -1);
                            break;
                        case "ungroupAll":
                            this.component.clearGrouping()
                    }
                };
                const isGroupPanelVisible = groupPanelOptions => {
                    const visible = null === groupPanelOptions || void 0 === groupPanelOptions ? void 0 : groupPanelOptions.visible;
                    return "auto" === visible ? "desktop" === _devices.default.current().deviceType : !!visible
                };
                const _allowDragging = (groupPanelOptions, column) => {
                    const isVisible = isGroupPanelVisible(groupPanelOptions);
                    const canDrag = (null === groupPanelOptions || void 0 === groupPanelOptions ? void 0 : groupPanelOptions.allowColumnDragging) && column.allowGrouping;
                    return isVisible && !!canDrag
                };
                const GroupingHeaderPanelExtender = Base => function(_Base3) {
                    _inheritsLoose(GroupingHeaderPanelExtender, _Base3);

                    function GroupingHeaderPanelExtender() {
                        return _Base3.apply(this, arguments) || this
                    }
                    var _proto3 = GroupingHeaderPanelExtender.prototype;
                    _proto3._getToolbarItems = function() {
                        const items = _Base3.prototype._getToolbarItems.call(this);
                        return this._appendGroupingItem(items)
                    };
                    _proto3._appendGroupingItem = function(items) {
                        if (this._isGroupPanelVisible()) {
                            let isRendered = false;
                            const toolbarItem = {
                                template: () => {
                                    const $groupPanel = (0, _renderer.default)("<div>").addClass("dx-datagrid-group-panel");
                                    this._updateGroupPanelContent($groupPanel);
                                    (0, _m_accessibility.registerKeyboardAction)("groupPanel", this, $groupPanel, void 0, this._handleActionKeyDown.bind(this));
                                    return $groupPanel
                                },
                                name: "groupPanel",
                                onItemRendered: () => {
                                    isRendered && this.renderCompleted.fire();
                                    isRendered = true
                                },
                                location: "before",
                                locateInMenu: "never",
                                sortIndex: 1
                            };
                            items.push(toolbarItem);
                            this.updateToolbarDimensions()
                        }
                        return items
                    };
                    _proto3._handleActionKeyDown = function(args) {
                        const {
                            event: event
                        } = args;
                        const $target = (0, _renderer.default)(event.target);
                        const groupColumnIndex = $target.closest(".".concat("dx-group-panel-item")).index();
                        const column = this._columnsController.getGroupColumns()[groupColumnIndex];
                        const columnIndex = column && column.index;
                        if ($target.is(".dx-header-filter")) {
                            this.getController("headerFilter").showHeaderFilterMenu(columnIndex, true)
                        } else {
                            this._processGroupItemAction(columnIndex)
                        }
                        event.preventDefault()
                    };
                    _proto3._isGroupPanelVisible = function() {
                        return isGroupPanelVisible(this.option("groupPanel"))
                    };
                    _proto3._renderGroupPanelItems = function($groupPanel, groupColumns) {
                        const that = this;
                        $groupPanel.empty();
                        (0, _iterator.each)(groupColumns, (index, groupColumn) => {
                            that._createGroupPanelItem($groupPanel, groupColumn)
                        });
                        (0, _accessibility.restoreFocus)(this)
                    };
                    _proto3._createGroupPanelItem = function($rootElement, groupColumn) {
                        const $groupPanelItem = (0, _renderer.default)("<div>").addClass(groupColumn.cssClass).addClass("dx-group-panel-item").data("columnData", groupColumn).appendTo($rootElement).text(groupColumn.caption);
                        (0, _accessibility.setTabIndex)(this, $groupPanelItem);
                        return $groupPanelItem
                    };
                    _proto3._columnOptionChanged = function(e) {
                        if (!this._requireReady && !_m_core.default.checkChanges(e.optionNames, ["width", "visibleWidth"])) {
                            const $toolbarElement = this.element();
                            const $groupPanel = $toolbarElement && $toolbarElement.find(".".concat("dx-datagrid-group-panel"));
                            if ($groupPanel && $groupPanel.length) {
                                this._updateGroupPanelContent($groupPanel);
                                this.updateToolbarDimensions();
                                this.renderCompleted.fire()
                            }
                        }
                        _Base3.prototype._columnOptionChanged.call(this)
                    };
                    _proto3._updateGroupPanelContent = function($groupPanel) {
                        const groupColumns = this.getController("columns").getGroupColumns();
                        const groupPanelOptions = this.option("groupPanel");
                        this._renderGroupPanelItems($groupPanel, groupColumns);
                        if (groupPanelOptions.allowColumnDragging && !groupColumns.length) {
                            (0, _renderer.default)("<div>").addClass("dx-group-panel-message").text(groupPanelOptions.emptyPanelText).appendTo($groupPanel);
                            $groupPanel.closest(".".concat("dx-toolbar-item")).addClass("dx-toolbar-label");
                            $groupPanel.closest(".".concat("dx-toolbar-label")).css("maxWidth", "none")
                        }
                    };
                    _proto3.allowDragging = function(column) {
                        const groupPanelOptions = this.option("groupPanel");
                        return _allowDragging(groupPanelOptions, column)
                    };
                    _proto3.getColumnElements = function() {
                        const $element = this.element();
                        return $element && $element.find(".".concat("dx-group-panel-item"))
                    };
                    _proto3.getColumns = function() {
                        return this.getController("columns").getGroupColumns()
                    };
                    _proto3.getBoundingRect = function() {
                        const $element = this.element();
                        if ($element && $element.find(".".concat("dx-datagrid-group-panel")).length) {
                            const offset = $element.offset();
                            return {
                                top: offset.top,
                                bottom: offset.top + (0, _size.getHeight)($element)
                            }
                        }
                        return null
                    };
                    _proto3.getName = function() {
                        return "group"
                    };
                    _proto3.getContextMenuItems = function(options) {
                        const that = this;
                        const contextMenuEnabled = that.option("grouping.contextMenuEnabled");
                        const $groupedColumnElement = (0, _renderer.default)(options.targetElement).closest(".".concat("dx-group-panel-item"));
                        let items;
                        if ($groupedColumnElement.length) {
                            options.column = $groupedColumnElement.data("columnData")
                        }
                        if (contextMenuEnabled && options.column) {
                            const {
                                column: column
                            } = options;
                            const isGroupingAllowed = (0, _type.isDefined)(column.allowGrouping) ? column.allowGrouping : true;
                            if (isGroupingAllowed) {
                                const isColumnGrouped = (0, _type.isDefined)(column.groupIndex) && column.groupIndex > -1;
                                const groupingTexts = that.option("grouping.texts");
                                const onItemClick = onGroupingMenuItemClick.bind(that, column);
                                items = [{
                                    text: groupingTexts.ungroup,
                                    value: "ungroup",
                                    disabled: !isColumnGrouped,
                                    onItemClick: onItemClick
                                }, {
                                    text: groupingTexts.ungroupAll,
                                    value: "ungroupAll",
                                    onItemClick: onItemClick
                                }]
                            }
                        }
                        return items
                    };
                    _proto3.isVisible = function() {
                        return _Base3.prototype.isVisible.call(this) || this._isGroupPanelVisible()
                    };
                    _proto3.hasGroupedColumns = function() {
                        return this._isGroupPanelVisible() && !!this.getColumns().length
                    };
                    _proto3.optionChanged = function(args) {
                        if ("groupPanel" === args.name) {
                            this._invalidate();
                            args.handled = true
                        } else {
                            _Base3.prototype.optionChanged.call(this, args)
                        }
                    };
                    return GroupingHeaderPanelExtender
                }(Base);
                exports.GroupingHeaderPanelExtender = GroupingHeaderPanelExtender;
                _m_core.default.registerModule("grouping", {
                    defaultOptions: () => ({
                        grouping: {
                            autoExpandAll: true,
                            allowCollapsing: true,
                            contextMenuEnabled: false,
                            expandMode: "buttonClick",
                            texts: {
                                groupContinuesMessage: _message.default.format("dxDataGrid-groupContinuesMessage"),
                                groupContinuedMessage: _message.default.format("dxDataGrid-groupContinuedMessage"),
                                groupByThisColumn: _message.default.format("dxDataGrid-groupHeaderText"),
                                ungroup: _message.default.format("dxDataGrid-ungroupHeaderText"),
                                ungroupAll: _message.default.format("dxDataGrid-ungroupAllText")
                            }
                        },
                        groupPanel: {
                            visible: false,
                            emptyPanelText: _message.default.format("dxDataGrid-groupPanelEmptyText"),
                            allowColumnDragging: true
                        }
                    }),
                    extenders: {
                        controllers: {
                            data: Base => function(_Base2) {
                                _inheritsLoose(GroupingDataControllerExtender, _Base2);

                                function GroupingDataControllerExtender() {
                                    return _Base2.apply(this, arguments) || this
                                }
                                var _proto2 = GroupingDataControllerExtender.prototype;
                                _proto2.init = function() {
                                    _Base2.prototype.init.call(this);
                                    this.createAction("onRowExpanding");
                                    this.createAction("onRowExpanded");
                                    this.createAction("onRowCollapsing");
                                    this.createAction("onRowCollapsed")
                                };
                                _proto2._beforeProcessItems = function(items) {
                                    const groupColumns = this._columnsController.getGroupColumns();
                                    items = _Base2.prototype._beforeProcessItems.call(this, items);
                                    if (items.length && groupColumns.length) {
                                        items = this._processGroupItems(items, groupColumns.length)
                                    }
                                    return items
                                };
                                _proto2._processItem = function(item, options) {
                                    if ((0, _type.isDefined)(item.groupIndex) && (0, _type.isString)(item.rowType) && 0 === item.rowType.indexOf("group")) {
                                        item = this._processGroupItem(item, options);
                                        options.dataIndex = 0
                                    } else {
                                        item = _Base2.prototype._processItem.apply(this, arguments)
                                    }
                                    return item
                                };
                                _proto2._processGroupItem = function(item, options) {
                                    return item
                                };
                                _proto2._processGroupItems = function(items, groupsCount, options) {
                                    const that = this;
                                    const groupedColumns = that._columnsController.getGroupColumns();
                                    const column = groupedColumns[groupedColumns.length - groupsCount];
                                    if (!options) {
                                        const scrollingMode = that.option("scrolling.mode");
                                        options = {
                                            collectContinuationItems: "virtual" !== scrollingMode && "infinite" !== scrollingMode,
                                            resultItems: [],
                                            path: [],
                                            values: []
                                        }
                                    }
                                    const {
                                        resultItems: resultItems
                                    } = options;
                                    if (options.data) {
                                        if (options.collectContinuationItems || !options.data.isContinuation) {
                                            resultItems.push({
                                                rowType: "group",
                                                data: options.data,
                                                groupIndex: options.path.length - 1,
                                                isExpanded: !!options.data.items,
                                                key: options.path.slice(0),
                                                values: options.values.slice(0)
                                            })
                                        }
                                    }
                                    if (items) {
                                        if (0 === groupsCount) {
                                            resultItems.push.apply(resultItems, items)
                                        } else {
                                            for (let i = 0; i < items.length; i++) {
                                                const item = items[i];
                                                if (item && "items" in item) {
                                                    options.data = item;
                                                    options.path.push(item.key);
                                                    options.values.push(column && column.deserializeValue && !column.calculateDisplayValue ? column.deserializeValue(item.key) : item.key);
                                                    that._processGroupItems(item.items, groupsCount - 1, options);
                                                    options.data = void 0;
                                                    options.path.pop();
                                                    options.values.pop()
                                                } else {
                                                    resultItems.push(item)
                                                }
                                            }
                                        }
                                    }
                                    return resultItems
                                };
                                _proto2.publicMethods = function() {
                                    return _Base2.prototype.publicMethods.call(this).concat(["collapseAll", "expandAll", "isRowExpanded", "expandRow", "collapseRow"])
                                };
                                _proto2.collapseAll = function(groupIndex) {
                                    const dataSource = this._dataSource;
                                    if (dataSource && dataSource.collapseAll(groupIndex)) {
                                        dataSource.pageIndex(0);
                                        dataSource.reload()
                                    }
                                };
                                _proto2.expandAll = function(groupIndex) {
                                    const dataSource = this._dataSource;
                                    if (dataSource && dataSource.expandAll(groupIndex)) {
                                        dataSource.pageIndex(0);
                                        dataSource.reload()
                                    }
                                };
                                _proto2.changeRowExpand = function(key) {
                                    const that = this;
                                    const expanded = that.isRowExpanded(key);
                                    const args = {
                                        key: key,
                                        expanded: expanded
                                    };
                                    that.executeAction(expanded ? "onRowCollapsing" : "onRowExpanding", args);
                                    if (!args.cancel) {
                                        return (0, _deferred.when)(that._changeRowExpandCore(key)).done(() => {
                                            args.expanded = !expanded;
                                            that.executeAction(expanded ? "onRowCollapsed" : "onRowExpanded", args)
                                        })
                                    }
                                    return (new _deferred.Deferred).resolve()
                                };
                                _proto2._changeRowExpandCore = function(key) {
                                    const that = this;
                                    const dataSource = this._dataSource;
                                    const d = new _deferred.Deferred;
                                    if (!dataSource) {
                                        d.resolve()
                                    } else {
                                        (0, _deferred.when)(dataSource.changeRowExpand(key)).done(() => {
                                            that.load().done(d.resolve).fail(d.reject)
                                        }).fail(d.reject)
                                    }
                                    return d
                                };
                                _proto2.isRowExpanded = function(key) {
                                    const dataSource = this._dataSource;
                                    return dataSource && dataSource.isRowExpanded(key)
                                };
                                _proto2.expandRow = function(key) {
                                    if (!this.isRowExpanded(key)) {
                                        return this.changeRowExpand(key)
                                    }
                                    return (new _deferred.Deferred).resolve()
                                };
                                _proto2.collapseRow = function(key) {
                                    if (this.isRowExpanded(key)) {
                                        return this.changeRowExpand(key)
                                    }
                                    return (new _deferred.Deferred).resolve()
                                };
                                _proto2.optionChanged = function(args) {
                                    if ("grouping" === args.name) {
                                        args.name = "dataSource"
                                    }
                                    _Base2.prototype.optionChanged.call(this, args)
                                };
                                return GroupingDataControllerExtender
                            }(Base),
                            columns: Base => function(_Base6) {
                                _inheritsLoose(GroupingColumnsExtender, _Base6);

                                function GroupingColumnsExtender() {
                                    return _Base6.apply(this, arguments) || this
                                }
                                var _proto6 = GroupingColumnsExtender.prototype;
                                _proto6._getExpandColumnOptions = function() {
                                    const options = _Base6.prototype._getExpandColumnOptions.apply(this, arguments);
                                    options.cellTemplate = _m_core.default.getExpandCellTemplate();
                                    return options
                                };
                                return GroupingColumnsExtender
                            }(Base),
                            editing: Base => function(_Base7) {
                                _inheritsLoose(GroupingEditingExtender, _Base7);

                                function GroupingEditingExtender() {
                                    return _Base7.apply(this, arguments) || this
                                }
                                var _proto7 = GroupingEditingExtender.prototype;
                                _proto7._isProcessedItem = function(item) {
                                    return (0, _type.isDefined)(item.groupIndex) && (0, _type.isString)(item.rowType) && 0 === item.rowType.indexOf("group")
                                };
                                return GroupingEditingExtender
                            }(Base)
                        },
                        views: {
                            headerPanel: GroupingHeaderPanelExtender,
                            rowsView: Base => function(_Base4) {
                                _inheritsLoose(GroupingRowsViewExtender, _Base4);

                                function GroupingRowsViewExtender() {
                                    return _Base4.apply(this, arguments) || this
                                }
                                var _proto4 = GroupingRowsViewExtender.prototype;
                                _proto4.getContextMenuItems = function(options) {
                                    const that = this;
                                    const contextMenuEnabled = that.option("grouping.contextMenuEnabled");
                                    let items;
                                    if (contextMenuEnabled && options.row && "group" === options.row.rowType) {
                                        const columnsController = that._columnsController;
                                        const column = columnsController.columnOption("groupIndex:".concat(options.row.groupIndex));
                                        if (column && column.allowGrouping) {
                                            const groupingTexts = that.option("grouping.texts");
                                            const onItemClick = onGroupingMenuItemClick.bind(that, column);
                                            items = [];
                                            items.push({
                                                text: groupingTexts.ungroup,
                                                value: "ungroup",
                                                onItemClick: onItemClick
                                            }, {
                                                text: groupingTexts.ungroupAll,
                                                value: "ungroupAll",
                                                onItemClick: onItemClick
                                            })
                                        }
                                    }
                                    return items
                                };
                                _proto4._rowClick = function(e) {
                                    const that = this;
                                    const expandMode = that.option("grouping.expandMode");
                                    const scrollingMode = that.option("scrolling.mode");
                                    const isGroupRowStateChanged = "infinite" !== scrollingMode && "rowClick" === expandMode && (0, _renderer.default)(e.event.target).closest(".".concat("dx-group-row")).length;
                                    const isExpandButtonClicked = (0, _renderer.default)(e.event.target).closest(".".concat("dx-datagrid-expand")).length;
                                    if (isGroupRowStateChanged || isExpandButtonClicked) {
                                        that._changeGroupRowState(e)
                                    }
                                    _Base4.prototype._rowClick.call(this, e)
                                };
                                _proto4._changeGroupRowState = function(e) {
                                    const dataController = this.getController("data");
                                    const row = dataController.items()[e.rowIndex];
                                    const allowCollapsing = this._columnsController.columnOption("groupIndex:".concat(row.groupIndex), "allowCollapsing");
                                    if ("data" === row.rowType || "group" === row.rowType && false !== allowCollapsing) {
                                        dataController.changeRowExpand(row.key, true);
                                        e.event.preventDefault();
                                        e.handled = true
                                    }
                                };
                                return GroupingRowsViewExtender
                            }(Base),
                            columnHeadersView: Base => function(_Base5) {
                                _inheritsLoose(GroupingHeadersViewExtender, _Base5);

                                function GroupingHeadersViewExtender() {
                                    return _Base5.apply(this, arguments) || this
                                }
                                var _proto5 = GroupingHeadersViewExtender.prototype;
                                _proto5.getContextMenuItems = function(options) {
                                    const that = this;
                                    const contextMenuEnabled = that.option("grouping.contextMenuEnabled");
                                    let items = _Base5.prototype.getContextMenuItems.call(this, options);
                                    if (contextMenuEnabled && options.row && ("header" === options.row.rowType || "detailAdaptive" === options.row.rowType)) {
                                        const {
                                            column: column
                                        } = options;
                                        if (!column.command && (!(0, _type.isDefined)(column.allowGrouping) || column.allowGrouping)) {
                                            const groupingTexts = that.option("grouping.texts");
                                            const isColumnGrouped = (0, _type.isDefined)(column.groupIndex) && column.groupIndex > -1;
                                            const onItemClick = onGroupingMenuItemClick.bind(that, column);
                                            items = items || [];
                                            items.push({
                                                text: groupingTexts.groupByThisColumn,
                                                value: "group",
                                                beginGroup: true,
                                                disabled: isColumnGrouped,
                                                onItemClick: onItemClick
                                            });
                                            if (column.showWhenGrouped) {
                                                items.push({
                                                    text: groupingTexts.ungroup,
                                                    value: "ungroup",
                                                    disabled: !isColumnGrouped,
                                                    onItemClick: onItemClick
                                                })
                                            }
                                            items.push({
                                                text: groupingTexts.ungroupAll,
                                                value: "ungroupAll",
                                                onItemClick: onItemClick
                                            })
                                        }
                                    }
                                    return items
                                };
                                _proto5.allowDragging = function(column) {
                                    const groupPanelOptions = this.option("groupPanel");
                                    return _allowDragging(groupPanelOptions, column) || _Base5.prototype.allowDragging.call(this, column)
                                };
                                return GroupingHeadersViewExtender
                            }(Base)
                        }
                    }
                })
            },
        2772:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/grouping/m_grouping_collapsed.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupingHelper = void 0;
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _errors = __webpack_require__( /*! ../../../../data/errors */ 18438);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_utils = __webpack_require__( /*! ../m_utils */ 10087);
                var _m_grouping_core = __webpack_require__( /*! ./m_grouping_core */ 8748);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }

                function getContinuationGroupCount(groupOffset, pageSize, groupSize, groupIndex) {
                    groupIndex = groupIndex || 0;
                    if (pageSize > 1 && groupSize > 0) {
                        let pageOffset = groupOffset - Math.floor(groupOffset / pageSize) * pageSize || pageSize;
                        pageOffset += groupSize - groupIndex - 2;
                        if (pageOffset < 0) {
                            pageOffset += pageSize
                        }
                        return Math.floor(pageOffset / (pageSize - groupIndex - 1))
                    }
                    return 0
                }
                const foreachExpandedGroups = function(that, callback, updateGroups) {
                    return that.foreachGroups((groupInfo, parents) => {
                        if (groupInfo.isExpanded) {
                            return callback(groupInfo, parents)
                        }
                    }, true, false, updateGroups, updateGroups)
                };
                const processGroupItems = function(that, items, groupsCount, expandedInfo, path, isCustomLoading, isLastGroupExpanded) {
                    let isExpanded;
                    expandedInfo.items = expandedInfo.items || [];
                    expandedInfo.paths = expandedInfo.paths || [];
                    expandedInfo.count = expandedInfo.count || 0;
                    expandedInfo.lastCount = expandedInfo.lastCount || 0;
                    if (!groupsCount) {
                        return
                    }
                    for (let i = 0; i < items.length; i++) {
                        const item = items[i];
                        if (void 0 !== item.items) {
                            path.push(item.key);
                            if (isCustomLoading) {
                                isExpanded = true
                            } else {
                                const groupInfo = that.findGroupInfo(path);
                                isExpanded = groupInfo && groupInfo.isExpanded
                            }
                            if (!isExpanded) {
                                item.collapsedItems = item.items;
                                item.items = null
                            } else if (item.items) {
                                processGroupItems(that, item.items, groupsCount - 1, expandedInfo, path, isCustomLoading, isLastGroupExpanded)
                            } else if (1 === groupsCount && item.count && (!isCustomLoading || isLastGroupExpanded)) {
                                expandedInfo.items.push(item);
                                expandedInfo.paths.push(path.slice(0));
                                expandedInfo.count += expandedInfo.lastCount;
                                expandedInfo.lastCount = item.count
                            }
                            path.pop()
                        }
                    }
                };
                const updateGroupInfoItem = function(that, item, isLastGroupLevel, path, offset) {
                    const groupInfo = that.findGroupInfo(path);
                    let count;
                    if (!groupInfo) {
                        if (isLastGroupLevel) {
                            count = item.count > 0 ? item.count : item.items.length
                        }
                        that.addGroupInfo({
                            isExpanded: that._isGroupExpanded(path.length - 1),
                            path: path.slice(0),
                            offset: offset,
                            count: count || 0
                        })
                    } else {
                        if (isLastGroupLevel) {
                            groupInfo.count = item.count > 0 ? item.count : item.items && item.items.length || 0
                        } else {
                            item.count = groupInfo.count || item.count
                        }
                        groupInfo.offset = offset
                    }
                };
                const updateGroupInfos = function(that, options, items, loadedGroupCount, groupIndex, path, parentIndex) {
                    const groupCount = options.group ? options.group.length : 0;
                    const isLastGroupLevel = groupCount === loadedGroupCount;
                    const remotePaging = options.remoteOperations.paging;
                    let offset = 0;
                    let totalCount = 0;
                    let count;
                    groupIndex = groupIndex || 0;
                    path = path || [];
                    if (remotePaging && !parentIndex) {
                        offset = 0 === groupIndex ? options.skip || 0 : options.skips[groupIndex - 1] || 0
                    }
                    if (groupIndex >= loadedGroupCount) {
                        return items.length
                    }
                    for (let i = 0; i < items.length; i++) {
                        const item = items[i];
                        if (item) {
                            path.push(item.key);
                            if (!item.count && !item.items || void 0 === item.items) {
                                return -1
                            }
                            updateGroupInfoItem(that, item, isLastGroupLevel, path, offset + i);
                            count = item.items ? updateGroupInfos(that, options, item.items, loadedGroupCount, groupIndex + 1, path, i) : item.count || -1;
                            if (count < 0) {
                                return -1
                            }
                            totalCount += count;
                            path.pop()
                        }
                    }
                    return totalCount
                };
                const isGroupExpanded = function(groups, groupIndex) {
                    return groups && groups.length && groups[groupIndex] && !!groups[groupIndex].isExpanded
                };
                const getTotalOffset = function(groupInfos, pageSize, offset) {
                    let groupSize;
                    let totalOffset = offset;
                    for (let groupIndex = 0; groupIndex < groupInfos.length; groupIndex++) {
                        groupSize = groupInfos[groupIndex].offset + 1;
                        if (groupIndex > 0) {
                            groupSize += groupInfos[groupIndex - 1].childrenTotalCount;
                            if (pageSize) {
                                groupSize += getContinuationGroupCount(totalOffset, pageSize, groupSize, groupIndex - 1) * groupIndex
                            }
                        }
                        totalOffset += groupSize
                    }
                    return totalOffset
                };

                function applyContinuationToGroupItem(options, expandedInfo, groupLevel, expandedItemIndex) {
                    const item = expandedInfo.items[expandedItemIndex];
                    const skip = options.skips && options.skips[groupLevel];
                    const take = options.takes && options.takes[groupLevel];
                    const isLastExpandedItem = expandedItemIndex === expandedInfo.items.length - 1;
                    const isFirstExpandedItem = 0 === expandedItemIndex;
                    const lastExpandedItemSkip = isFirstExpandedItem && skip || 0;
                    const isItemsTruncatedByTake = item.count > take + lastExpandedItemSkip;
                    if (isFirstExpandedItem && void 0 !== skip) {
                        item.isContinuation = true
                    }
                    if (isLastExpandedItem && void 0 !== take && isItemsTruncatedByTake) {
                        item.isContinuationOnNextPage = true
                    }
                }

                function isDataDeferred(data) {
                    return !Array.isArray(data)
                }

                function makeDataDeferred(options) {
                    if (!isDataDeferred(options.data)) {
                        options.data = new _deferred.Deferred
                    }
                }

                function loadGroupItems(that, options, loadedGroupCount, expandedInfo, groupLevel, data) {
                    if (!options.isCustomLoading) {
                        expandedInfo = {};
                        processGroupItems(that, data, loadedGroupCount, expandedInfo, []);
                        ! function(options, expandedInfo, currentGroupCount) {
                            const currentGroupIndex = currentGroupCount - 1;
                            const groupCount = options.group ? options.group.length : 0;
                            expandedInfo.skip = options.skips && options.skips[currentGroupIndex];
                            if (options.takes && void 0 !== options.takes[currentGroupIndex]) {
                                if (groupCount === currentGroupCount) {
                                    expandedInfo.take = expandedInfo.count ? expandedInfo.count - (expandedInfo.skip || 0) : 0
                                } else {
                                    expandedInfo.take = 0
                                }
                                expandedInfo.take += options.takes[currentGroupIndex]
                            }
                        }(options, expandedInfo, loadedGroupCount)
                    }
                    const groupCount = options.group ? options.group.length : 0;
                    if (expandedInfo.paths.length && groupCount - loadedGroupCount > 0) {
                        makeDataDeferred(options);
                        ! function(that, options, expandedInfo, loadedGroupCount, groupLevel, data) {
                            const groups = options.group || [];
                            const currentGroup = groups[groupLevel + 1];
                            const deferreds = [];
                            (0, _iterator.each)(expandedInfo.paths, expandedItemIndex => {
                                var _a;
                                const loadOptions = {
                                    requireTotalCount: false,
                                    requireGroupCount: true,
                                    group: [currentGroup],
                                    groupSummary: options.storeLoadOptions.groupSummary,
                                    filter: (0, _m_utils.createGroupFilter)(expandedInfo.paths[expandedItemIndex], {
                                        filter: options.storeLoadOptions.filter,
                                        group: groups
                                    }),
                                    select: options.storeLoadOptions.select,
                                    langParams: null === (_a = options.storeLoadOptions) || void 0 === _a ? void 0 : _a.langParams
                                };
                                if (0 === expandedItemIndex) {
                                    loadOptions.skip = expandedInfo.skip || 0
                                }
                                if (expandedItemIndex === expandedInfo.paths.length - 1) {
                                    loadOptions.take = expandedInfo.take
                                }
                                const loadResult = 0 === loadOptions.take ? [] : that._dataSource.loadFromStore(loadOptions);
                                (0, _deferred.when)(loadResult).done(data => {
                                    const item = expandedInfo.items[expandedItemIndex];
                                    applyContinuationToGroupItem(options, expandedInfo, groupLevel, expandedItemIndex);
                                    item.items = data
                                });
                                deferreds.push(loadResult)
                            });
                            _deferred.when.apply(null, deferreds).done(() => {
                                updateGroupInfos(that, options, data, loadedGroupCount + 1);
                                loadGroupItems(that, options, loadedGroupCount + 1, expandedInfo, groupLevel + 1, data)
                            })
                        }(that, options, expandedInfo, loadedGroupCount, groupLevel, data)
                    } else if (expandedInfo.paths.length && options.storeLoadOptions.group) {
                        makeDataDeferred(options);
                        ! function(that, options, expandedInfo, data) {
                            const expandedFilters = [];
                            const groups = options.group || [];
                            (0, _iterator.each)(expandedInfo.paths, (_, expandedPath) => {
                                expandedFilters.push((0, _m_utils.createGroupFilter)(expandedPath, {
                                    group: options.isCustomLoading ? options.storeLoadOptions.group : groups
                                }))
                            });
                            let {
                                filter: filter
                            } = options.storeLoadOptions;
                            if (!options.storeLoadOptions.isLoadingAll) {
                                filter = _m_core.default.combineFilters([filter, _m_core.default.combineFilters(expandedFilters, "or")])
                            }
                            const loadOptions = (0, _extend.extend)({}, options.storeLoadOptions, {
                                requireTotalCount: false,
                                requireGroupCount: false,
                                group: null,
                                sort: groups.concat(_m_core.default.normalizeSortingInfo(options.storeLoadOptions.sort || [])),
                                filter: filter
                            });
                            const isPagingLocal = that._dataSource.isLastLevelGroupItemsPagingLocal();
                            if (!isPagingLocal) {
                                loadOptions.skip = expandedInfo.skip;
                                loadOptions.take = expandedInfo.take
                            }(0, _deferred.when)(0 === expandedInfo.take ? [] : that._dataSource.loadFromStore(loadOptions)).done(items => {
                                if (isPagingLocal) {
                                    items = that._dataSource.sortLastLevelGroupItems(items, groups, expandedInfo.paths);
                                    items = expandedInfo.skip ? items.slice(expandedInfo.skip) : items;
                                    items = expandedInfo.take ? items.slice(0, expandedInfo.take) : items
                                }(0, _iterator.each)(expandedInfo.items, (index, item) => {
                                    const itemCount = item.count - (0 === index && expandedInfo.skip || 0);
                                    const expandedItems = items.splice(0, itemCount);
                                    applyContinuationToGroupItem(options, expandedInfo, groups.length - 1, index);
                                    item.items = expandedItems
                                });
                                options.data.resolve(data)
                            }).fail(options.data.reject)
                        }(that, options, expandedInfo, data)
                    } else if (isDataDeferred(options.data)) {
                        options.data.resolve(data)
                    }
                }
                const loadGroupTotalCount = function(dataSource, options) {
                    const d = new _deferred.Deferred;
                    const isGrouping = !!(options.group && options.group.length);
                    const loadOptions = (0, _extend.extend)({
                        skip: 0,
                        take: 1,
                        requireGroupCount: isGrouping,
                        requireTotalCount: !isGrouping
                    }, options, {
                        group: isGrouping ? options.group : null
                    });
                    dataSource.load(loadOptions).done((data, extra) => {
                        const count = extra && (isGrouping ? extra.groupCount : extra.totalCount);
                        if (!isFinite(count)) {
                            d.reject(_errors.errors.Error(isGrouping ? "E4022" : "E4021"));
                            return
                        }
                        d.resolve(count)
                    }).fail(d.reject.bind(d));
                    return d
                };
                let GroupingHelper = function(_GroupingHelperCore) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(GroupingHelper, _GroupingHelperCore);

                    function GroupingHelper() {
                        return _GroupingHelperCore.apply(this, arguments) || this
                    }
                    var _proto = GroupingHelper.prototype;
                    _proto.updateTotalItemsCount = function(options) {
                        let totalItemsCount = 0;
                        const totalCount = options.extra && options.extra.totalCount || 0;
                        const groupCount = options.extra && options.extra.groupCount || 0;
                        const pageSize = this._dataSource.pageSize();
                        const isVirtualPaging = this._isVirtualPaging();
                        foreachExpandedGroups(this, groupInfo => {
                            groupInfo.childrenTotalCount = 0
                        });
                        foreachExpandedGroups(this, (groupInfo, parents) => {
                            const totalOffset = getTotalOffset(parents, isVirtualPaging ? 0 : pageSize, totalItemsCount);
                            let count = groupInfo.count + groupInfo.childrenTotalCount;
                            if (!isVirtualPaging) {
                                count += getContinuationGroupCount(totalOffset, pageSize, count, parents.length - 1)
                            }
                            if (parents[parents.length - 2]) {
                                parents[parents.length - 2].childrenTotalCount += count
                            } else {
                                totalItemsCount += count
                            }
                        });
                        _GroupingHelperCore.prototype.updateTotalItemsCount.call(this, totalItemsCount - totalCount + groupCount)
                    };
                    _proto._isGroupExpanded = function(groupIndex) {
                        const groups = this._dataSource.group();
                        return isGroupExpanded(groups, groupIndex)
                    };
                    _proto._updatePagingOptions = function(options, callback) {
                        const that = this;
                        const isVirtualPaging = that._isVirtualPaging();
                        const pageSize = that._dataSource.pageSize();
                        const skips = [];
                        const takes = [];
                        let skipChildrenTotalCount = 0;
                        let childrenTotalCount = 0;
                        if (options.take) {
                            foreachExpandedGroups(this, groupInfo => {
                                groupInfo.childrenTotalCount = 0;
                                groupInfo.skipChildrenTotalCount = 0
                            });
                            foreachExpandedGroups(that, (groupInfo, parents) => {
                                let take;
                                let takeCorrection = 0;
                                let parentTakeCorrection = 0;
                                const totalOffset = getTotalOffset(parents, isVirtualPaging ? 0 : pageSize, childrenTotalCount);
                                let continuationGroupCount = 0;
                                let skipContinuationGroupCount = 0;
                                let groupInfoCount = groupInfo.count + groupInfo.childrenTotalCount;
                                let childrenGroupInfoCount = groupInfoCount;
                                callback && callback(groupInfo, totalOffset);
                                const skip = options.skip - totalOffset;
                                if (totalOffset <= options.skip + options.take && groupInfoCount) {
                                    take = options.take;
                                    if (!isVirtualPaging) {
                                        continuationGroupCount = getContinuationGroupCount(totalOffset, pageSize, groupInfoCount, parents.length - 1);
                                        groupInfoCount += continuationGroupCount * parents.length;
                                        childrenGroupInfoCount += continuationGroupCount;
                                        if (pageSize && skip >= 0) {
                                            takeCorrection = parents.length;
                                            parentTakeCorrection = parents.length - 1;
                                            skipContinuationGroupCount = Math.floor(skip / pageSize)
                                        }
                                    }
                                    if (skip >= 0) {
                                        if (totalOffset + groupInfoCount > options.skip) {
                                            skips.unshift(skip - skipContinuationGroupCount * takeCorrection - groupInfo.skipChildrenTotalCount)
                                        }
                                        if (totalOffset + groupInfoCount >= options.skip + take) {
                                            takes.unshift(take - takeCorrection - groupInfo.childrenTotalCount + groupInfo.skipChildrenTotalCount)
                                        }
                                    } else if (totalOffset + groupInfoCount >= options.skip + take) {
                                        takes.unshift(take + skip - groupInfo.childrenTotalCount)
                                    }
                                }
                                if (totalOffset <= options.skip) {
                                    if (parents[parents.length - 2]) {
                                        parents[parents.length - 2].skipChildrenTotalCount += Math.min(childrenGroupInfoCount, skip + 1 - skipContinuationGroupCount * parentTakeCorrection)
                                    } else {
                                        skipChildrenTotalCount += Math.min(childrenGroupInfoCount, skip + 1)
                                    }
                                }
                                if (totalOffset <= options.skip + take) {
                                    groupInfoCount = Math.min(childrenGroupInfoCount, skip + take - (skipContinuationGroupCount + 1) * parentTakeCorrection);
                                    if (parents[parents.length - 2]) {
                                        parents[parents.length - 2].childrenTotalCount += groupInfoCount
                                    } else {
                                        childrenTotalCount += groupInfoCount
                                    }
                                }
                            });
                            options.skip -= skipChildrenTotalCount;
                            options.take -= childrenTotalCount - skipChildrenTotalCount
                        }
                        options.skips = skips;
                        options.takes = takes
                    };
                    _proto.changeRowExpand = function(path) {
                        const groupInfo = this.findGroupInfo(path);
                        const dataSource = this._dataSource;
                        const remoteGroupPaging = dataSource.remoteOperations().groupPaging;
                        const groups = _m_core.default.normalizeSortingInfo(dataSource.group());
                        if (groupInfo) {
                            groupInfo.isExpanded = !groupInfo.isExpanded;
                            if (remoteGroupPaging && groupInfo.isExpanded && path.length < groups.length) {
                                return loadGroupTotalCount(dataSource, {
                                    filter: (0, _m_utils.createGroupFilter)(path, {
                                        filter: dataSource.lastLoadOptions().filter,
                                        group: dataSource.group()
                                    }),
                                    group: [groups[path.length]],
                                    select: dataSource.select()
                                }).done(groupCount => {
                                    groupInfo.count = groupCount
                                })
                            }
                            return (new _deferred.Deferred).resolve()
                        }
                        return (new _deferred.Deferred).reject()
                    };
                    _proto.handleDataLoading = function(options) {
                        const that = this;
                        const {
                            storeLoadOptions: storeLoadOptions
                        } = options;
                        const groups = _m_core.default.normalizeSortingInfo(storeLoadOptions.group || options.loadOptions.group);
                        if (options.isCustomLoading || !groups.length) {
                            return
                        }
                        if (options.remoteOperations.grouping) {
                            const remotePaging = that._dataSource.remoteOperations().paging;
                            storeLoadOptions.group = _m_core.default.normalizeSortingInfo(storeLoadOptions.group);
                            storeLoadOptions.group.forEach((group, index) => {
                                const isLastGroup = index === storeLoadOptions.group.length - 1;
                                group.isExpanded = !remotePaging || !isLastGroup
                            })
                        }
                        options.group = options.group || groups;
                        if (options.remoteOperations.paging) {
                            options.skip = storeLoadOptions.skip;
                            options.take = storeLoadOptions.take;
                            storeLoadOptions.requireGroupCount = true;
                            storeLoadOptions.group = groups.slice(0, 1);
                            that._updatePagingOptions(options);
                            storeLoadOptions.skip = options.skip;
                            storeLoadOptions.take = options.take
                        } else {
                            options.skip = options.loadOptions.skip;
                            options.take = options.loadOptions.take;
                            that._updatePagingOptions(options)
                        }
                    };
                    _proto.handleDataLoadedCore = function(options, callBase) {
                        const that = this;
                        const loadedGroupCount = _m_core.default.normalizeSortingInfo(options.storeLoadOptions.group || options.loadOptions.group).length;
                        const groupCount = options.group ? options.group.length : 0;
                        let totalCount;
                        const expandedInfo = {};
                        if (options.isCustomLoading) {
                            callBase(options);
                            processGroupItems(that, options.data, loadedGroupCount, expandedInfo, [], options.isCustomLoading, options.storeLoadOptions.isLoadingAll)
                        } else {
                            if (!options.remoteOperations.paging) {
                                that.foreachGroups(groupInfo => {
                                    groupInfo.count = 0
                                })
                            }
                            totalCount = updateGroupInfos(that, options, options.data, loadedGroupCount);
                            if (totalCount < 0) {
                                options.data = (new _deferred.Deferred).reject(_ui.default.Error("E1037"));
                                return
                            }
                            if (!options.remoteOperations.paging) {
                                if (loadedGroupCount && options.extra && options.loadOptions.requireTotalCount) {
                                    options.extra.totalCount = totalCount;
                                    options.extra.groupCount = options.data.length
                                }
                            }
                            if (groupCount && options.storeLoadOptions.requireGroupCount && !isFinite(options.extra.groupCount)) {
                                options.data = (new _deferred.Deferred).reject(_errors.errors.Error("E4022"));
                                return
                            }
                            that.updateTotalItemsCount(options);
                            if (!options.remoteOperations.paging) {
                                that._updatePagingOptions(options);
                                options.lastLoadOptions.skips = options.skips;
                                options.lastLoadOptions.takes = options.takes
                            }
                            callBase(options);
                            if (!options.remoteOperations.paging) {
                                that._processPaging(options, loadedGroupCount)
                            }
                        }
                        loadGroupItems(that, options, loadedGroupCount, expandedInfo, 0, options.data)
                    };
                    _proto._processSkips = function(items, skips, groupCount) {
                        if (!groupCount) {
                            return
                        }
                        const firstItem = items[0];
                        const skip = skips[0];
                        const children = firstItem && firstItem.items;
                        if (void 0 !== skip) {
                            firstItem.isContinuation = true;
                            if (children) {
                                firstItem.items = children.slice(skip);
                                this._processSkips(firstItem.items, skips.slice(1), groupCount - 1)
                            }
                        }
                    };
                    _proto._processTakes = function(items, skips, takes, groupCount, parents) {
                        if (!groupCount || !items) {
                            return
                        }
                        parents = parents || [];
                        const lastItem = items[items.length - 1];
                        let children = lastItem && lastItem.items;
                        const take = takes[0];
                        const skip = skips[0];
                        if (lastItem) {
                            const maxTakeCount = lastItem.count - (lastItem.isContinuation && skip || 0) || children.length;
                            if (void 0 !== take && maxTakeCount > take) {
                                lastItem.isContinuationOnNextPage = true;
                                parents.forEach(parent => {
                                    parent.isContinuationOnNextPage = true
                                });
                                if (children) {
                                    children = children.slice(0, take);
                                    lastItem.items = children
                                }
                            }
                            parents.push(lastItem);
                            this._processTakes(children, skips.slice(1), takes.slice(1), groupCount - 1, parents)
                        }
                    };
                    _proto._processPaging = function(options, groupCount) {
                        this._processSkips(options.data, options.skips, groupCount);
                        this._processTakes(options.data, options.skips, options.takes, groupCount)
                    };
                    _proto.isLastLevelGroupItemsPagingLocal = function() {
                        return false
                    };
                    _proto.sortLastLevelGroupItems = function(items) {
                        return items
                    };
                    _proto.refresh = function(options, operationTypes) {
                        const that = this;
                        const dataSource = that._dataSource;
                        const {
                            storeLoadOptions: storeLoadOptions
                        } = options;
                        const group = options.group || options.storeLoadOptions.group;
                        const oldGroups = _m_core.default.normalizeSortingInfo(that._group);
                        let isExpanded;
                        let groupIndex;

                        function handleGroup(groupInfo, parents) {
                            if (parents.length === groupIndex + 1) {
                                groupInfo.isExpanded = isExpanded
                            }
                        }
                        for (groupIndex = 0; groupIndex < oldGroups.length; groupIndex++) {
                            isExpanded = isGroupExpanded(group, groupIndex);
                            if (isGroupExpanded(that._group, groupIndex) !== isExpanded) {
                                that.foreachGroups(handleGroup)
                            }
                        }
                        _GroupingHelperCore.prototype.refresh.apply(this, arguments);
                        if (group && options.remoteOperations.paging && operationTypes.reload) {
                            return foreachExpandedGroups(that, groupInfo => {
                                const groupCountQuery = loadGroupTotalCount(dataSource, {
                                    filter: (0, _m_utils.createGroupFilter)(groupInfo.path, {
                                        filter: storeLoadOptions.filter,
                                        group: group
                                    }),
                                    group: group.slice(groupInfo.path.length),
                                    select: storeLoadOptions.select
                                });
                                const groupOffsetQuery = loadGroupTotalCount(dataSource, {
                                    filter: (0, _m_grouping_core.createOffsetFilter)(groupInfo.path, {
                                        filter: storeLoadOptions.filter,
                                        group: group
                                    }, true),
                                    group: group.slice(groupInfo.path.length - 1, groupInfo.path.length),
                                    select: storeLoadOptions.select
                                });
                                return (0, _deferred.when)(groupOffsetQuery, groupCountQuery).done((offset, count) => {
                                    offset = parseInt(offset.length ? offset[0] : offset);
                                    count = parseInt(count.length ? count[0] : count);
                                    groupInfo.offset = offset;
                                    if (groupInfo.count !== count) {
                                        groupInfo.count = count;
                                        that.updateTotalItemsCount(options)
                                    }
                                })
                            }, true)
                        }
                    };
                    return GroupingHelper
                }(_m_grouping_core.GroupingHelper);
                exports.GroupingHelper = GroupingHelper
            },
        8748:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/grouping/m_grouping_core.js ***!
              \****************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupingHelper = void 0;
                exports.createOffsetFilter = function(path, storeLoadOptions, lastLevelOnly) {
                    const groups = (0, _utils.normalizeSortingInfo)(storeLoadOptions.group);
                    let filter = [];
                    for (let i = lastLevelOnly ? path.length - 1 : 0; i < path.length; i++) {
                        const filterElement = [];
                        for (let j = 0; j <= i; j++) {
                            const {
                                selector: selector
                            } = groups[j];
                            if (i === j && (null === path[j] || false === path[j] || true === path[j])) {
                                if (false === path[j]) {
                                    filterElement.push([selector, "=", groups[j].desc ? true : null])
                                } else if (path[j] ? !groups[j].desc : groups[j].desc) {
                                    filterElement.push([selector, "<>", path[j]])
                                } else {
                                    filterElement.push([selector, "<>", null]);
                                    filterElement.push([selector, "=", null])
                                }
                            } else {
                                const currentFilter = [selector, i === j ? groups[j].desc ? ">" : "<" : "=", path[j]];
                                if ("<" === currentFilter[1]) {
                                    filterElement.push([currentFilter, "or", [selector, "=", null]])
                                } else {
                                    filterElement.push(currentFilter)
                                }
                            }
                        }
                        filter.push(_m_core.default.combineFilters(filterElement))
                    }
                    filter = _m_core.default.combineFilters(filter, "or");
                    return _m_core.default.combineFilters([filter, storeLoadOptions.filter])
                };
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _utils = __webpack_require__( /*! ../../../../data/utils */ 16454);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const findGroupInfoByKey = function(groupsInfo, key) {
                    const {
                        hash: hash
                    } = groupsInfo;
                    return hash && hash[JSON.stringify(key)]
                };
                const getGroupInfoIndexByOffset = function(groupsInfo, offset) {
                    let leftIndex = 0;
                    let rightIndex = groupsInfo.length - 1;
                    if (!groupsInfo.length) {
                        return 0
                    }
                    do {
                        const middleIndex = rightIndex + leftIndex >> 1;
                        if (groupsInfo[middleIndex].offset > offset) {
                            rightIndex = middleIndex
                        } else {
                            leftIndex = middleIndex
                        }
                    } while (rightIndex - leftIndex > 1);
                    let index;
                    for (index = leftIndex; index <= rightIndex; index++) {
                        if (groupsInfo[index].offset > offset) {
                            break
                        }
                    }
                    return index
                };
                const cleanGroupsInfo = function(groupsInfo, groupIndex, groupsCount) {
                    for (let i = 0; i < groupsInfo.length; i++) {
                        if (groupIndex + 1 >= groupsCount) {
                            groupsInfo[i].children = []
                        } else {
                            cleanGroupsInfo(groupsInfo[i].children, groupIndex + 1, groupsCount)
                        }
                    }
                };
                const calculateItemsCount = function(that, items, groupsCount) {
                    let result = 0;
                    if (items) {
                        if (!groupsCount) {
                            result = items.length
                        } else {
                            for (let i = 0; i < items.length; i++) {
                                if (that.isGroupItemCountable(items[i])) {
                                    result++
                                }
                                result += calculateItemsCount(that, items[i].items, groupsCount - 1)
                            }
                        }
                    }
                    return result
                };
                let GroupingHelper = function() {
                    function GroupingHelper(dataSourceAdapter) {
                        this._dataSource = dataSourceAdapter;
                        this.reset()
                    }
                    var _proto = GroupingHelper.prototype;
                    _proto.reset = function() {
                        this._groupsInfo = [];
                        this._totalCountCorrection = 0
                    };
                    _proto.totalCountCorrection = function() {
                        return this._totalCountCorrection
                    };
                    _proto.updateTotalItemsCount = function(totalCountCorrection) {
                        this._totalCountCorrection = totalCountCorrection || 0
                    };
                    _proto.isGroupItemCountable = function(item) {
                        return !this._isVirtualPaging() || !item.isContinuation
                    };
                    _proto._isVirtualPaging = function() {
                        const scrollingMode = this._dataSource.option("scrolling.mode");
                        return "virtual" === scrollingMode || "infinite" === scrollingMode
                    };
                    _proto.itemsCount = function() {
                        const dataSourceAdapter = this._dataSource;
                        const dataSource = dataSourceAdapter._dataSource;
                        const groupCount = _m_core.default.normalizeSortingInfo(dataSource.group() || []).length;
                        const itemsCount = calculateItemsCount(this, dataSource.items(), groupCount);
                        return itemsCount
                    };
                    _proto.foreachGroups = function(callback, childrenAtFirst, foreachCollapsedGroups, updateOffsets, updateParentOffsets) {
                        const that = this;
                        return function foreachGroupsCore(groupsInfo, callback, childrenAtFirst, parents) {
                            const callbackResults = [];

                            function executeCallback(callback, data, parents, callbackResults) {
                                const callbackResult = data && callback(data, parents);
                                callbackResult && callbackResults.push(callbackResult);
                                return callbackResult
                            }
                            for (let i = 0; i < groupsInfo.length; i++) {
                                parents.push(groupsInfo[i].data);
                                if (!childrenAtFirst && false === executeCallback(callback, groupsInfo[i].data, parents, callbackResults)) {
                                    return false
                                }
                                if (!groupsInfo[i].data || groupsInfo[i].data.isExpanded || foreachCollapsedGroups) {
                                    const {
                                        children: children
                                    } = groupsInfo[i];
                                    const callbackResult = children.length && foreachGroupsCore(children, callback, childrenAtFirst, parents);
                                    callbackResult && callbackResults.push(callbackResult);
                                    if (false === callbackResult) {
                                        return false
                                    }
                                }
                                if (childrenAtFirst && false === executeCallback(callback, groupsInfo[i].data, parents, callbackResults)) {
                                    return false
                                }
                                if (!groupsInfo[i].data || groupsInfo[i].data.offset !== groupsInfo[i].offset) {
                                    updateOffsets = true
                                }
                                parents.pop()
                            }
                            const currentParents = updateParentOffsets && parents.slice(0);
                            return updateOffsets && _deferred.when.apply(_renderer.default, callbackResults).always(() => {
                                that._updateGroupInfoOffsets(groupsInfo, currentParents)
                            })
                        }(that._groupsInfo, callback, childrenAtFirst, [])
                    };
                    _proto._updateGroupInfoOffsets = function(groupsInfo, parents) {
                        parents = parents || [];
                        for (let index = 0; index < groupsInfo.length; index++) {
                            const groupInfo = groupsInfo[index];
                            if (groupInfo.data && groupInfo.data.offset !== groupInfo.offset) {
                                groupInfo.offset = groupInfo.data.offset;
                                for (let parentIndex = 0; parentIndex < parents.length; parentIndex++) {
                                    parents[parentIndex].offset = groupInfo.offset
                                }
                            }
                        }
                        groupsInfo.sort((a, b) => a.offset - b.offset)
                    };
                    _proto.findGroupInfo = function(path) {
                        let groupInfo;
                        let groupsInfo = this._groupsInfo;
                        for (let pathIndex = 0; groupsInfo && pathIndex < path.length; pathIndex++) {
                            groupInfo = findGroupInfoByKey(groupsInfo, path[pathIndex]);
                            groupsInfo = groupInfo && groupInfo.children
                        }
                        return groupInfo && groupInfo.data
                    };
                    _proto.addGroupInfo = function(groupInfoData) {
                        const that = this;
                        let groupInfo;
                        const {
                            path: path
                        } = groupInfoData;
                        let groupsInfo = that._groupsInfo;
                        for (let pathIndex = 0; pathIndex < path.length; pathIndex++) {
                            groupInfo = findGroupInfoByKey(groupsInfo, path[pathIndex]);
                            if (!groupInfo) {
                                groupInfo = {
                                    key: path[pathIndex],
                                    offset: groupInfoData.offset,
                                    data: {
                                        offset: groupInfoData.offset,
                                        isExpanded: true,
                                        path: path.slice(0, pathIndex + 1)
                                    },
                                    children: []
                                };
                                const index = getGroupInfoIndexByOffset(groupsInfo, groupInfoData.offset);
                                groupsInfo.splice(index, 0, groupInfo);
                                groupsInfo.hash = groupsInfo.hash || {};
                                groupsInfo.hash[JSON.stringify(groupInfo.key)] = groupInfo
                            }
                            if (pathIndex === path.length - 1) {
                                groupInfo.data = groupInfoData;
                                if (groupInfo.offset !== groupInfoData.offset) {
                                    that._updateGroupInfoOffsets(groupsInfo)
                                }
                            }
                            groupsInfo = groupInfo.children
                        }
                    };
                    _proto.allowCollapseAll = function() {
                        return true
                    };
                    _proto.refresh = function(options) {
                        const that = this;
                        const {
                            storeLoadOptions: storeLoadOptions
                        } = options;
                        const groups = (0, _utils.normalizeSortingInfo)(storeLoadOptions.group || []);
                        const oldGroups = "_group" in that ? (0, _utils.normalizeSortingInfo)(that._group || []) : groups;
                        let groupsCount = Math.min(oldGroups.length, groups.length);
                        that._group = storeLoadOptions.group;
                        for (let groupIndex = 0; groupIndex < groupsCount; groupIndex++) {
                            if (oldGroups[groupIndex].selector !== groups[groupIndex].selector) {
                                groupsCount = groupIndex;
                                break
                            }
                        }
                        if (!groupsCount) {
                            that.reset()
                        } else {
                            cleanGroupsInfo(that._groupsInfo, 0, groupsCount)
                        }
                    };
                    _proto.handleDataLoading = function() {};
                    _proto.handleDataLoaded = function(options, callBase) {
                        callBase(options)
                    };
                    _proto.handleDataLoadedCore = function(options, callBase) {
                        callBase(options)
                    };
                    return GroupingHelper
                }();
                exports.GroupingHelper = GroupingHelper
            },
        4789:
            /*!********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/grouping/m_grouping_expanded.js ***!
              \********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupingHelper = void 0;
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _query = _interopRequireDefault(__webpack_require__( /*! ../../../../data/query */ 96687));
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ../../../../data/store_helper */ 99236));
                var _utils = __webpack_require__( /*! ../../../../data/utils */ 16454);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_utils = __webpack_require__( /*! ../m_utils */ 10087);
                var _m_grouping_core = __webpack_require__( /*! ./m_grouping_core */ 8748);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const loadTotalCount = function(dataSource, options) {
                    const d = new _deferred.Deferred;
                    const loadOptions = (0, _extend.extend)({
                        skip: 0,
                        take: 1,
                        requireTotalCount: true
                    }, options);
                    dataSource.load(loadOptions).done((data, extra) => {
                        d.resolve(extra && extra.totalCount)
                    }).fail(d.reject.bind(d));
                    return d
                };
                const foreachCollapsedGroups = function(that, callback, updateOffsets) {
                    return that.foreachGroups(groupInfo => {
                        if (!groupInfo.isExpanded) {
                            return callback(groupInfo)
                        }
                    }, false, false, updateOffsets, true)
                };
                const correctSkipLoadOption = function(that, skip) {
                    let skipCorrection = 0;
                    let resultSkip = skip || 0;
                    if (skip) {
                        foreachCollapsedGroups(that, groupInfo => {
                            if (groupInfo.offset - skipCorrection >= skip) {
                                return false
                            }
                            skipCorrection += groupInfo.count - 1
                        });
                        resultSkip += skipCorrection
                    }
                    return resultSkip
                };
                const processGroupItems = function(that, items, path, offset, skipFirstItem, take) {
                    let removeLastItemsCount = 0;
                    let needRemoveFirstItem = false;
                    for (let i = 0; i < items.length; i++) {
                        const item = items[i];
                        if (void 0 !== item.items) {
                            path.push(item.key);
                            const groupInfo = that.findGroupInfo(path);
                            if (groupInfo && !groupInfo.isExpanded) {
                                item.collapsedItems = item.items;
                                item.items = null;
                                offset += groupInfo.count;
                                take--;
                                if (take < 0) {
                                    removeLastItemsCount++
                                }
                                if (skipFirstItem) {
                                    needRemoveFirstItem = true
                                }
                            } else if (item.items) {
                                const offsetInfo = processGroupItems(that, item.items, path, offset, skipFirstItem, take);
                                if (skipFirstItem) {
                                    if (offsetInfo.offset - offset > 1) {
                                        item.isContinuation = true
                                    } else {
                                        needRemoveFirstItem = true
                                    }
                                }
                                offset = offsetInfo.offset;
                                take = offsetInfo.take;
                                if (take < 0) {
                                    if (item.items.length) {
                                        item.isContinuationOnNextPage = true
                                    } else {
                                        removeLastItemsCount++
                                    }
                                }
                            }
                            path.pop()
                        } else {
                            if (skipFirstItem) {
                                needRemoveFirstItem = true
                            }
                            offset++;
                            take--;
                            if (take < 0) {
                                removeLastItemsCount++
                            }
                        }
                        skipFirstItem = false
                    }
                    if (needRemoveFirstItem) {
                        items.splice(0, 1)
                    }
                    if (removeLastItemsCount) {
                        items.splice(-removeLastItemsCount, removeLastItemsCount)
                    }
                    return {
                        offset: offset,
                        take: take
                    }
                };
                const pathEquals = function(path1, path2) {
                    if (path1.length !== path2.length) {
                        return false
                    }
                    for (let i = 0; i < path1.length; i++) {
                        if (!(0, _utils.keysEqual)(null, path1[i], path2[i])) {
                            return false
                        }
                    }
                    return true
                };
                const updateGroupOffsets = function(that, items, path, offset, additionalGroupInfo) {
                    if (!items) {
                        return
                    }
                    for (let i = 0; i < items.length; i++) {
                        const item = items[i];
                        if ("key" in item && void 0 !== item.items) {
                            path.push(item.key);
                            if (additionalGroupInfo && pathEquals(additionalGroupInfo.path, path) && !item.isContinuation) {
                                additionalGroupInfo.offset = offset
                            }
                            const groupInfo = that.findGroupInfo(path);
                            if (groupInfo && !item.isContinuation) {
                                groupInfo.offset = offset
                            }
                            if (groupInfo && !groupInfo.isExpanded) {
                                offset += groupInfo.count
                            } else {
                                offset = updateGroupOffsets(that, item.items, path, offset, additionalGroupInfo)
                            }
                            path.pop()
                        } else {
                            offset++
                        }
                    }
                    return offset
                };
                const getGroupCount = function(item, groupCount) {
                    let count = item.count || item.items.length;
                    if (!item.count && groupCount > 1) {
                        count = 0;
                        for (let i = 0; i < item.items.length; i++) {
                            count += getGroupCount(item.items[i], groupCount - 1)
                        }
                    }
                    return count
                };
                let GroupingHelper = function(_GroupingHelperCore) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(GroupingHelper, _GroupingHelperCore);

                    function GroupingHelper() {
                        return _GroupingHelperCore.apply(this, arguments) || this
                    }
                    var _proto = GroupingHelper.prototype;
                    _proto.handleDataLoading = function(options) {
                        const {
                            storeLoadOptions: storeLoadOptions
                        } = options;
                        const collapsedGroups = [];
                        let collapsedItemsCount = 0;
                        let skipFirstItem = false;
                        let take;
                        const {
                            group: group
                        } = options.loadOptions;
                        let skipCorrection = 0;
                        ! function(storeLoadOptions, loadOptions) {
                            if (loadOptions.group) {
                                const groups = _m_core.default.normalizeSortingInfo(loadOptions.group);
                                const sorts = _m_core.default.normalizeSortingInfo(storeLoadOptions.sort);
                                storeLoadOptions.sort = _store_helper.default.arrangeSortingInfo(groups, sorts);
                                delete loadOptions.group
                            }
                        }(storeLoadOptions, options.loadOptions);
                        options.group = options.group || group;
                        if (options.isCustomLoading) {
                            return
                        }
                        const loadOptions = (0, _extend.extend)({}, storeLoadOptions);
                        loadOptions.skip = correctSkipLoadOption(this, storeLoadOptions.skip);
                        if (loadOptions.skip && loadOptions.take && group) {
                            loadOptions.skip--;
                            loadOptions.take++;
                            skipFirstItem = true
                        }
                        if (loadOptions.take && group) {
                            take = loadOptions.take;
                            loadOptions.take++
                        }
                        foreachCollapsedGroups(this, groupInfo => {
                            if (groupInfo.offset >= loadOptions.skip + loadOptions.take + skipCorrection) {
                                return false
                            }
                            if (groupInfo.offset >= loadOptions.skip + skipCorrection && groupInfo.count) {
                                skipCorrection += groupInfo.count - 1;
                                collapsedGroups.push(groupInfo);
                                collapsedItemsCount += groupInfo.count
                            }
                        });
                        (0, _iterator.each)(collapsedGroups, (function() {
                            loadOptions.filter = function(path, storeLoadOptions, group) {
                                const groups = _m_core.default.normalizeSortingInfo(group || storeLoadOptions.group);
                                let filter = [];
                                for (let i = 0; i < path.length; i++) {
                                    const filterElement = [];
                                    for (let j = 0; j <= i; j++) {
                                        filterElement.push([groups[j].selector, i === j ? "<>" : "=", path[j]])
                                    }
                                    filter.push(_m_core.default.combineFilters(filterElement))
                                }
                                filter = _m_core.default.combineFilters(filter, "or");
                                return _m_core.default.combineFilters([filter, storeLoadOptions.filter])
                            }(this.path, loadOptions, group)
                        }));
                        options.storeLoadOptions = loadOptions;
                        options.collapsedGroups = collapsedGroups;
                        options.collapsedItemsCount = collapsedItemsCount;
                        options.skip = loadOptions.skip || 0;
                        options.skipFirstItem = skipFirstItem;
                        options.take = take
                    };
                    _proto.handleDataLoaded = function(options, callBase) {
                        const that = this;
                        const {
                            collapsedGroups: collapsedGroups
                        } = options;
                        const groups = _m_core.default.normalizeSortingInfo(options.group);
                        const groupCount = groups.length;

                        function appendCollapsedPath(data, path, groups, collapsedGroup, offset) {
                            if (!data || !path.length || !groups.length) {
                                return
                            }
                            let keyValue;
                            let i;
                            const pathValue = (0, _data.toComparable)(path[0], true);
                            for (i = 0; i < data.length; i++) {
                                keyValue = (0, _data.toComparable)(data[i].key, true);
                                if (offset >= collapsedGroup.offset || pathValue === keyValue) {
                                    break
                                } else {
                                    offset += getGroupCount(data[i], groups.length)
                                }
                            }
                            if (!data.length || pathValue !== keyValue) {
                                data.splice(i, 0, {
                                    key: path[0],
                                    items: [],
                                    count: 1 === path.length ? collapsedGroup.count : void 0
                                })
                            }
                            appendCollapsedPath(data[i].items, path.slice(1), groups.slice(1), collapsedGroup, offset)
                        }
                        if (options.collapsedItemsCount && options.extra && options.extra.totalCount >= 0) {
                            if (!options.extra._totalCountWasIncreasedByCollapsedItems) {
                                options.extra.totalCount += options.collapsedItemsCount;
                                options.extra._totalCountWasIncreasedByCollapsedItems = true
                            }
                        }
                        callBase(options);
                        if (groupCount) {
                            let {
                                data: data
                            } = options;
                            const query = (0, _query.default)(data);
                            _store_helper.default.multiLevelGroup(query, groups).enumerate().done(groupedData => {
                                data = groupedData
                            });
                            if (collapsedGroups) {
                                for (let pathIndex = 0; pathIndex < collapsedGroups.length; pathIndex++) {
                                    appendCollapsedPath(data, collapsedGroups[pathIndex].path, groups, collapsedGroups[pathIndex], options.skip)
                                }
                            }
                            if (!options.isCustomLoading) {
                                processGroupItems(that, data, [], options.skip, options.skipFirstItem, options.take)
                            }
                            options.data = data
                        }
                    };
                    _proto.isGroupItemCountable = function(item) {
                        return null === item.items
                    };
                    _proto.updateTotalItemsCount = function() {
                        let itemsCountCorrection = 0;
                        foreachCollapsedGroups(this, groupInfo => {
                            if (groupInfo.count) {
                                itemsCountCorrection -= groupInfo.count - 1
                            }
                        });
                        _GroupingHelperCore.prototype.updateTotalItemsCount.call(this, itemsCountCorrection)
                    };
                    _proto.changeRowExpand = function(path) {
                        const that = this;
                        const dataSource = that._dataSource;
                        const beginPageIndex = dataSource.beginPageIndex ? dataSource.beginPageIndex() : dataSource.pageIndex();
                        const dataSourceItems = dataSource.items();
                        const offset = correctSkipLoadOption(that, beginPageIndex * dataSource.pageSize());
                        let groupInfo = that.findGroupInfo(path);
                        let groupCountQuery;
                        if (groupInfo && !groupInfo.isExpanded) {
                            groupCountQuery = (new _deferred.Deferred).resolve(groupInfo.count)
                        } else {
                            groupCountQuery = loadTotalCount(dataSource, {
                                filter: (0, _m_utils.createGroupFilter)(path, {
                                    filter: dataSource.filter(),
                                    group: dataSource.group()
                                })
                            })
                        }
                        return (0, _deferred.when)(groupCountQuery).done(count => {
                            count = parseInt(count.length ? count[0] : count);
                            if (groupInfo) {
                                updateGroupOffsets(that, dataSourceItems, [], offset);
                                groupInfo.isExpanded = !groupInfo.isExpanded;
                                groupInfo.count = count
                            } else {
                                groupInfo = {
                                    offset: -1,
                                    count: count,
                                    path: path,
                                    isExpanded: false
                                };
                                updateGroupOffsets(that, dataSourceItems, [], offset, groupInfo);
                                if (groupInfo.offset >= 0) {
                                    that.addGroupInfo(groupInfo)
                                }
                            }
                            that.updateTotalItemsCount()
                        }).fail((function() {
                            dataSource._eventsStrategy.fireEvent("loadError", arguments)
                        }))
                    };
                    _proto.allowCollapseAll = function() {
                        return false
                    };
                    _proto.refresh = function(options, operationTypes) {
                        const that = this;
                        const {
                            storeLoadOptions: storeLoadOptions
                        } = options;
                        const dataSource = that._dataSource;
                        _GroupingHelperCore.prototype.refresh.apply(this, arguments);
                        if (operationTypes.reload) {
                            return foreachCollapsedGroups(that, groupInfo => {
                                const groupCountQuery = loadTotalCount(dataSource, {
                                    filter: (0, _m_utils.createGroupFilter)(groupInfo.path, storeLoadOptions)
                                });
                                const groupOffsetQuery = loadTotalCount(dataSource, {
                                    filter: (0, _m_grouping_core.createOffsetFilter)(groupInfo.path, storeLoadOptions)
                                });
                                return (0, _deferred.when)(groupOffsetQuery, groupCountQuery).done((offset, count) => {
                                    offset = parseInt(offset.length ? offset[0] : offset);
                                    count = parseInt(count.length ? count[0] : count);
                                    groupInfo.offset = offset;
                                    if (groupInfo.count !== count) {
                                        groupInfo.count = count;
                                        that.updateTotalItemsCount()
                                    }
                                })
                            }, true)
                        }
                    };
                    return GroupingHelper
                }(_m_grouping_core.GroupingHelper);
                exports.GroupingHelper = GroupingHelper
            },
        29593:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_aggregate_calculator.js ***!
              \**************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 47617);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _errors = __webpack_require__( /*! ../../../data/errors */ 18438);
                var _utils = __webpack_require__( /*! ../../../data/utils */ 16454);

                function depthFirstSearch(i, depth, root, callback) {
                    let j = 0;
                    if (i < depth) {
                        for (; j < root.items.length; j++) {
                            depthFirstSearch(i + 1, depth, root.items[j], callback)
                        }
                    }
                    if (i === depth) {
                        callback(root)
                    }
                }

                function map(array, callback) {
                    let i;
                    if ("map" in array) {
                        return array.map(callback)
                    }
                    const result = new Array(array.length);
                    for (i in array) {
                        result[i] = callback(array[i], i)
                    }
                    return result
                }

                function normalizeAggregate(aggregate) {
                    const selector = (0, _data.compileGetter)(aggregate.selector);
                    const skipEmptyValues = "skipEmptyValues" in aggregate ? aggregate.skipEmptyValues : true;
                    let {
                        aggregator: aggregator
                    } = aggregate;
                    if ("string" === typeof aggregator) {
                        aggregator = _utils.aggregators[aggregator];
                        if (!aggregator) {
                            throw _errors.errors.Error("E4001", aggregate.aggregator)
                        }
                    }
                    return {
                        selector: selector,
                        aggregator: aggregator,
                        skipEmptyValues: skipEmptyValues
                    }
                }
                let AggregateCalculator = function() {
                    function AggregateCalculator(options) {
                        this._data = options.data;
                        this._groupLevel = options.groupLevel || 0;
                        this._totalAggregates = map(options.totalAggregates || [], normalizeAggregate);
                        this._groupAggregates = map(options.groupAggregates || [], normalizeAggregate);
                        this._totals = []
                    }
                    var _proto = AggregateCalculator.prototype;
                    _proto.calculate = function() {
                        if (this._totalAggregates.length) {
                            this._calculateTotals(0, {
                                items: this._data
                            })
                        }
                        if (this._groupAggregates.length && this._groupLevel > 0) {
                            this._calculateGroups({
                                items: this._data
                            })
                        }
                    };
                    _proto.totalAggregates = function() {
                        return this._totals
                    };
                    _proto._aggregate = function(aggregates, data, container) {
                        const length = data.items ? data.items.length : 0;
                        for (let i = 0; i < aggregates.length; i++) {
                            if (aggregator = aggregates[i].aggregator, aggregator === _utils.aggregators.count) {
                                container[i] = (container[i] || 0) + length;
                                continue
                            }
                            for (let j = 0; j < length; j++) {
                                this._accumulate(i, aggregates[i], container, data.items[j])
                            }
                        }
                        var aggregator
                    };
                    _proto._calculateTotals = function(level, data) {
                        if (0 === level) {
                            this._totals = this._seed(this._totalAggregates)
                        }
                        if (level === this._groupLevel) {
                            this._aggregate(this._totalAggregates, data, this._totals)
                        } else {
                            for (let i = 0; i < data.items.length; i++) {
                                this._calculateTotals(level + 1, data.items[i])
                            }
                        }
                        if (0 === level) {
                            this._totals = this._finalize(this._totalAggregates, this._totals)
                        }
                    };
                    _proto._calculateGroups = function(root) {
                        const maxLevel = this._groupLevel;
                        let currentLevel = maxLevel + 1;
                        const seedFn = this._seed.bind(this, this._groupAggregates);
                        const stepFn = this._aggregate.bind(this, this._groupAggregates);
                        const finalizeFn = this._finalize.bind(this, this._groupAggregates);

                        function aggregator(node) {
                            node.aggregates = seedFn(currentLevel - 1);
                            if (currentLevel === maxLevel) {
                                stepFn(node, node.aggregates)
                            } else {
                                depthFirstSearch(currentLevel, maxLevel, node, innerNode => {
                                    stepFn(innerNode, node.aggregates)
                                })
                            }
                            node.aggregates = finalizeFn(node.aggregates)
                        }
                        while (--currentLevel > 0) {
                            depthFirstSearch(0, currentLevel, root, aggregator)
                        }
                    };
                    _proto._seed = function(aggregates, groupIndex) {
                        return map(aggregates, aggregate => {
                            const {
                                aggregator: aggregator
                            } = aggregate;
                            const seed = "seed" in aggregator ? (0, _type.isFunction)(aggregator.seed) ? aggregator.seed(groupIndex) : aggregator.seed : NaN;
                            return seed
                        })
                    };
                    _proto._accumulate = function(aggregateIndex, aggregate, results, item) {
                        const value = aggregate.selector(item);
                        const {
                            aggregator: aggregator
                        } = aggregate;
                        const {
                            skipEmptyValues: skipEmptyValues
                        } = aggregate;
                        if (skipEmptyValues && (x = value, x !== x || "" === x || null === x || void 0 === x)) {
                            return
                        }
                        var x;
                        if (results[aggregateIndex] !== results[aggregateIndex]) {
                            results[aggregateIndex] = value
                        } else {
                            results[aggregateIndex] = aggregator.step(results[aggregateIndex], value)
                        }
                    };
                    _proto._finalize = function(aggregates, results) {
                        return map(aggregates, (aggregate, index) => {
                            const fin = aggregate.aggregator.finalize;
                            return fin ? fin(results[index]) : results[index]
                        })
                    };
                    return AggregateCalculator
                }();
                exports.default = AggregateCalculator
            },
        96291:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_columns_controller.js ***!
              \************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _m_columns_controller = __webpack_require__( /*! ../../grids/grid_core/columns_controller/m_columns_controller */ 10279);
                var _m_core = (obj = __webpack_require__( /*! ./m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("columns", {
                    defaultOptions: () => (0, _extend.extend)(true, {}, _m_columns_controller.columnsControllerModule.defaultOptions(), {
                        commonColumnSettings: {
                            allowExporting: true
                        }
                    }),
                    controllers: _m_columns_controller.columnsControllerModule.controllers
                })
            },
        74938:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_core.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../../grids/grid_core/m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../../grids/grid_core/m_utils */ 60082));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                var _default = _extends(_extends(_extends({}, _m_modules.default), _m_utils.default), {
                    modules: []
                });
                exports.default = _default
            },
        3263:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_data_controller.js ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.DataController = void 0;
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../ui/widget/ui.errors */ 96688));
                var _m_data_controller = __webpack_require__( /*! ../../grids/grid_core/data_controller/m_data_controller */ 72119);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ./m_core */ 74938));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ./m_data_source_adapter */ 49975));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                let DataGridDataController = function(_DataController) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(DataGridDataController, _DataController);

                    function DataGridDataController() {
                        return _DataController.apply(this, arguments) || this
                    }
                    var _proto = DataGridDataController.prototype;
                    _proto._getDataSourceAdapter = function() {
                        return _m_data_source_adapter.default
                    };
                    _proto._getSpecificDataSourceOption = function() {
                        const dataSource = this.option("dataSource");
                        if (dataSource && !Array.isArray(dataSource) && this.option("keyExpr")) {
                            _ui.default.log("W1011")
                        }
                        return _DataController.prototype._getSpecificDataSourceOption.call(this)
                    };
                    return DataGridDataController
                }(_m_data_controller.DataController);
                exports.DataController = DataGridDataController;
                _m_core.default.registerModule("data", {
                    defaultOptions: _m_data_controller.dataControllerModule.defaultOptions,
                    controllers: {
                        data: DataGridDataController
                    }
                })
            },
        49975:
            /*!*************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_data_source_adapter.js ***!
              \*************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_data_source_adapter = (obj = __webpack_require__( /*! ../../grids/grid_core/data_source_adapter/m_data_source_adapter */ 30945), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                let DataSourceAdapterType = _m_data_source_adapter.default;
                var _default = {
                    extend(extender) {
                        DataSourceAdapterType = extender(DataSourceAdapterType)
                    },
                    create: component => new DataSourceAdapterType(component)
                };
                exports.default = _default
            },
        26949:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_editing.js ***!
              \*************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                __webpack_require__( /*! ./module_not_extended/editor_factory */ 98125);
                var _m_editing = __webpack_require__( /*! ../../grids/grid_core/editing/m_editing */ 22324);
                var _m_core = (obj = __webpack_require__( /*! ./m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                _m_core.default.registerModule("editing", _extends(_extends({}, _m_editing.editingModule), {
                    extenders: _extends(_extends({}, _m_editing.editingModule.extenders), {
                        controllers: _extends(_extends({}, _m_editing.editingModule.extenders.controllers), {
                            data: Base => function(_dataControllerEditin) {
                                ! function(subClass, superClass) {
                                    subClass.prototype = Object.create(superClass.prototype);
                                    subClass.prototype.constructor = subClass;
                                    _setPrototypeOf(subClass, superClass)
                                }(DataEditingDataGridExtender, _dataControllerEditin);

                                function DataEditingDataGridExtender() {
                                    return _dataControllerEditin.apply(this, arguments) || this
                                }
                                var _proto = DataEditingDataGridExtender.prototype;
                                _proto._changeRowExpandCore = function(key) {
                                    const editingController = this._editingController;
                                    if (Array.isArray(key)) {
                                        editingController && editingController.refresh()
                                    }
                                    return _dataControllerEditin.prototype._changeRowExpandCore.apply(this, arguments)
                                };
                                return DataEditingDataGridExtender
                            }((0, _m_editing.dataControllerEditingExtenderMixin)(Base))
                        })
                    })
                }))
            },
        10087:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_utils.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createGroupFilter = function(path, storeLoadOptions) {
                    const groups = (0, _utils.normalizeSortingInfo)(storeLoadOptions.group);
                    const filter = [];
                    for (let i = 0; i < path.length; i++) {
                        filter.push([groups[i].selector, "=", path[i]])
                    }
                    if (storeLoadOptions.filter) {
                        filter.push(storeLoadOptions.filter)
                    }
                    return _m_utils.default.combineFilters(filter)
                };
                var _utils = __webpack_require__( /*! ../../../data/utils */ 16454);
                var _m_utils = (obj = __webpack_require__( /*! ../../grids/grid_core/m_utils */ 60082), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj
            },
        10590:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_widget.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_widget_base = (obj = __webpack_require__( /*! ./m_widget_base */ 26196), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                __webpack_require__( /*! ./module_not_extended/state_storing */ 97847);
                __webpack_require__( /*! ./module_not_extended/selection */ 86006);
                __webpack_require__( /*! ./module_not_extended/column_chooser */ 17663);
                __webpack_require__( /*! ./grouping/m_grouping */ 72487);
                __webpack_require__( /*! ./module_not_extended/master_detail */ 48190);
                __webpack_require__( /*! ./m_editing */ 26949);
                __webpack_require__( /*! ./module_not_extended/editing_row_based */ 42267);
                __webpack_require__( /*! ./module_not_extended/editing_form_based */ 94585);
                __webpack_require__( /*! ./module_not_extended/editing_cell_based */ 82831);
                __webpack_require__( /*! ./module_not_extended/validating */ 41430);
                __webpack_require__( /*! ./module_not_extended/virtual_scrolling */ 98726);
                __webpack_require__( /*! ./module_not_extended/filter_row */ 34622);
                __webpack_require__( /*! ./module_not_extended/header_filter */ 42595);
                __webpack_require__( /*! ./module_not_extended/filter_sync */ 66551);
                __webpack_require__( /*! ./module_not_extended/filter_builder */ 69566);
                __webpack_require__( /*! ./module_not_extended/filter_panel */ 76568);
                __webpack_require__( /*! ./module_not_extended/search */ 20015);
                __webpack_require__( /*! ./module_not_extended/pager */ 70608);
                __webpack_require__( /*! ./module_not_extended/columns_resizing_reordering */ 53489);
                __webpack_require__( /*! ./module_not_extended/keyboard_navigation */ 28294);
                __webpack_require__( /*! ./summary/m_summary */ 15180);
                __webpack_require__( /*! ./module_not_extended/column_fixing */ 68339);
                __webpack_require__( /*! ./module_not_extended/adaptivity */ 26098);
                __webpack_require__( /*! ./module_not_extended/virtual_columns */ 12470);
                __webpack_require__( /*! ./export/m_export */ 48252);
                __webpack_require__( /*! ./focus/m_focus */ 56445);
                __webpack_require__( /*! ./module_not_extended/row_dragging */ 445);
                var _default = _m_widget_base.default;
                exports.default = _default
            },
        26196:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_widget_base.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                __webpack_require__( /*! ./module_not_extended/column_headers */ 90130);
                __webpack_require__( /*! ./m_columns_controller */ 96291);
                __webpack_require__( /*! ./m_data_controller */ 3263);
                __webpack_require__( /*! ./module_not_extended/sorting */ 10792);
                __webpack_require__( /*! ./module_not_extended/rows */ 86226);
                __webpack_require__( /*! ./module_not_extended/context_menu */ 74043);
                __webpack_require__( /*! ./module_not_extended/error_handling */ 46950);
                __webpack_require__( /*! ./module_not_extended/grid_view */ 24734);
                __webpack_require__( /*! ./module_not_extended/header_panel */ 63350);
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../../core/component_registrator */ 99393));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 68374));
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/browser */ 47810));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _console = __webpack_require__( /*! ../../../core/utils/console */ 30869);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _themes = __webpack_require__( /*! ../../../ui/themes */ 75811);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../ui/widget/ui.widget */ 14390));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../../grids/grid_core/m_utils */ 60082));
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ./m_core */ 74938));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                _m_core.default.registerModulesOrder(["stateStoring", "columns", "selection", "editorFactory", "columnChooser", "grouping", "editing", "editingRowBased", "editingFormBased", "editingCellBased", "masterDetail", "validating", "adaptivity", "data", "virtualScrolling", "columnHeaders", "filterRow", "headerPanel", "headerFilter", "sorting", "search", "rows", "pager", "columnsResizingReordering", "contextMenu", "keyboardNavigation", "errorHandling", "summary", "columnFixing", "export", "gridView"]);
                const DataGrid = _ui.default.inherit({
                    _activeStateUnit: ".dx-row",
                    _getDefaultOptions() {
                        const result = this.callBase();
                        (0, _iterator.each)(_m_core.default.modules, (function() {
                            if ((0, _type.isFunction)(this.defaultOptions)) {
                                (0, _extend.extend)(true, result, this.defaultOptions())
                            }
                        }));
                        return result
                    },
                    _setDeprecatedOptions() {
                        this.callBase();
                        (0, _extend.extend)(this._deprecatedOptions, {
                            useKeyboard: {
                                since: "19.2",
                                alias: "keyboardNavigation.enabled"
                            },
                            rowTemplate: {
                                since: "21.2",
                                message: 'Use the "dataRowTemplate" option instead'
                            },
                            "columnChooser.allowSearch": {
                                since: "23.1",
                                message: 'Use the "columnChooser.search.enabled" option instead'
                            },
                            "columnChooser.searchTimeout": {
                                since: "23.1",
                                message: 'Use the "columnChooser.search.timeout" option instead'
                            }
                        })
                    },
                    _defaultOptionsRules() {
                        return this.callBase().concat([{
                            device: {
                                platform: "ios"
                            },
                            options: {
                                showRowLines: true
                            }
                        }, {
                            device: () => (0, _themes.isMaterialBased)(),
                            options: {
                                showRowLines: true,
                                showColumnLines: false,
                                headerFilter: {
                                    height: 315
                                },
                                editing: {
                                    useIcons: true
                                },
                                selection: {
                                    showCheckBoxesMode: "always"
                                }
                            }
                        }, {
                            device: () => _browser.default.webkit,
                            options: {
                                loadingTimeout: 30,
                                loadPanel: {
                                    animation: {
                                        show: {
                                            easing: "cubic-bezier(1, 0, 1, 0)",
                                            duration: 500,
                                            from: {
                                                opacity: 0
                                            },
                                            to: {
                                                opacity: 1
                                            }
                                        }
                                    }
                                }
                            }
                        }, {
                            device: device => "desktop" !== device.deviceType,
                            options: {
                                grouping: {
                                    expandMode: "rowClick"
                                }
                            }
                        }])
                    },
                    _init() {
                        this.callBase();
                        _m_utils.default.logHeaderFilterDeprecatedWarningIfNeed(this);
                        _m_core.default.processModules(this, _m_core.default);
                        _m_core.default.callModuleItemsMethod(this, "init")
                    },
                    _clean: _common.noop,
                    _optionChanged(args) {
                        const that = this;
                        _m_core.default.callModuleItemsMethod(that, "optionChanged", [args]);
                        if (!args.handled) {
                            that.callBase(args)
                        }
                    },
                    _dimensionChanged() {
                        this.updateDimensions(true)
                    },
                    _visibilityChanged(visible) {
                        if (visible) {
                            this.updateDimensions()
                        }
                    },
                    _initMarkup() {
                        this.callBase.apply(this, arguments);
                        this.getView("gridView").render(this.$element())
                    },
                    _renderContentImpl() {
                        this.getView("gridView").update()
                    },
                    _renderContent() {
                        const that = this;
                        (0, _common.deferRender)(() => {
                            that._renderContentImpl()
                        })
                    },
                    _getTemplate(templateName) {
                        let template = templateName;
                        if ((0, _type.isString)(template) && template.startsWith("#")) {
                            template = (0, _renderer.default)(templateName);
                            _console.logger.warn("Specifying grid templates with the jQuery selector name is now deprecated. Use the DOM Node or the jQuery object that references this selector instead.")
                        }
                        return this.callBase(template)
                    },
                    _dispose() {
                        this.callBase();
                        _m_core.default.callModuleItemsMethod(this, "dispose")
                    },
                    isReady() {
                        return this.getController("data").isReady()
                    },
                    beginUpdate() {
                        this.callBase();
                        _m_core.default.callModuleItemsMethod(this, "beginUpdate")
                    },
                    endUpdate() {
                        _m_core.default.callModuleItemsMethod(this, "endUpdate");
                        this.callBase()
                    },
                    getController(name) {
                        return this._controllers[name]
                    },
                    getView(name) {
                        return this._views[name]
                    },
                    focus(element) {
                        this.getController("keyboardNavigation").focus(element)
                    }
                });
                DataGrid.registerModule = _m_core.default.registerModule.bind(_m_core.default);
                (0, _component_registrator.default)("dxDataGrid", DataGrid);
                var _default = DataGrid;
                exports.default = _default
            },
        26098:
            /*!**********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/adaptivity.js ***!
              \**********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_adaptivity = __webpack_require__( /*! ../../../grids/grid_core/adaptivity/m_adaptivity */ 18107);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("adaptivity", _m_adaptivity.adaptivityModule)
            },
        17663:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/column_chooser.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ColumnChooserView = exports.ColumnChooserController = void 0;
                var _m_column_chooser = __webpack_require__( /*! ../../../grids/grid_core/column_chooser/m_column_chooser */ 71184);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const ColumnChooserController = _m_column_chooser.columnChooserModule.controllers.columnChooser;
                exports.ColumnChooserController = ColumnChooserController;
                const ColumnChooserView = _m_column_chooser.columnChooserModule.views.columnChooserView;
                exports.ColumnChooserView = ColumnChooserView;
                _m_core.default.registerModule("columnChooser", _m_column_chooser.columnChooserModule)
            },
        68339:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/column_fixing.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_column_fixing = __webpack_require__( /*! ../../../grids/grid_core/column_fixing/m_column_fixing */ 53424);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("columnFixing", _m_column_fixing.columnFixingModule)
            },
        90130:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/column_headers.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ColumnHeadersView = void 0;
                var _m_column_headers = __webpack_require__( /*! ../../../grids/grid_core/column_headers/m_column_headers */ 14509);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const ColumnHeadersView = _m_column_headers.columnHeadersModule.views.columnHeadersView;
                exports.ColumnHeadersView = ColumnHeadersView;
                _m_core.default.registerModule("columnHeaders", _m_column_headers.columnHeadersModule)
            },
        53489:
            /*!***************************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/columns_resizing_reordering.js ***!
              \***************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.TrackerView = exports.TablePositionViewController = exports.DraggingHeaderViewController = exports.DraggingHeaderView = exports.ColumnsSeparatorView = exports.ColumnsResizerViewController = void 0;
                var _m_columns_resizing_reordering = __webpack_require__( /*! ../../../grids/grid_core/columns_resizing_reordering/m_columns_resizing_reordering */ 49505);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const DraggingHeaderView = _m_columns_resizing_reordering.columnsResizingReorderingModule.views.draggingHeaderView;
                exports.DraggingHeaderView = DraggingHeaderView;
                const DraggingHeaderViewController = _m_columns_resizing_reordering.columnsResizingReorderingModule.controllers.draggingHeader;
                exports.DraggingHeaderViewController = DraggingHeaderViewController;
                const ColumnsSeparatorView = _m_columns_resizing_reordering.columnsResizingReorderingModule.views.columnsSeparatorView;
                exports.ColumnsSeparatorView = ColumnsSeparatorView;
                const TablePositionViewController = _m_columns_resizing_reordering.columnsResizingReorderingModule.controllers.tablePosition;
                exports.TablePositionViewController = TablePositionViewController;
                const ColumnsResizerViewController = _m_columns_resizing_reordering.columnsResizingReorderingModule.controllers.columnsResizer;
                exports.ColumnsResizerViewController = ColumnsResizerViewController;
                const TrackerView = _m_columns_resizing_reordering.columnsResizingReorderingModule.views.trackerView;
                exports.TrackerView = TrackerView;
                _m_core.default.registerModule("columnsResizingReordering", _m_columns_resizing_reordering.columnsResizingReorderingModule)
            },
        74043:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/context_menu.js ***!
              \************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_context_menu = __webpack_require__( /*! ../../../grids/grid_core/context_menu/m_context_menu */ 69823);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("contextMenu", _m_context_menu.contextMenuModule)
            },
        82831:
            /*!******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/editing_cell_based.js ***!
              \******************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_editing_cell_based = __webpack_require__( /*! ../../../grids/grid_core/editing/m_editing_cell_based */ 68802);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editingCellBased", _m_editing_cell_based.editingCellBasedModule)
            },
        94585:
            /*!******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/editing_form_based.js ***!
              \******************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_editing_form_based = __webpack_require__( /*! ../../../grids/grid_core/editing/m_editing_form_based */ 99211);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editingFormBased", _m_editing_form_based.editingFormBasedModule)
            },
        42267:
            /*!*****************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/editing_row_based.js ***!
              \*****************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_editing_row_based = __webpack_require__( /*! ../../../grids/grid_core/editing/m_editing_row_based */ 55597);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editingRowBased", _m_editing_row_based.editingRowBasedModule)
            },
        98125:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/editor_factory.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_editor_factory = __webpack_require__( /*! ../../../grids/grid_core/editor_factory/m_editor_factory */ 80070);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editorFactory", _m_editor_factory.editorFactoryModule)
            },
        46950:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/error_handling.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_error_handling = __webpack_require__( /*! ../../../grids/grid_core/error_handling/m_error_handling */ 31152);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("errorHandling", _m_error_handling.errorHandlingModule)
            },
        69566:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/filter_builder.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_filter_builder = __webpack_require__( /*! ../../../grids/grid_core/filter/m_filter_builder */ 62690);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("filterBuilder", _m_filter_builder.filterBuilderModule)
            },
        76568:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/filter_panel.js ***!
              \************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_filter_panel = __webpack_require__( /*! ../../../grids/grid_core/filter/m_filter_panel */ 4062);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("filterPanel", _m_filter_panel.filterPanelModule)
            },
        34622:
            /*!**********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/filter_row.js ***!
              \**********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_filter_row = __webpack_require__( /*! ../../../grids/grid_core/filter/m_filter_row */ 12302);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("filterRow", _m_filter_row.filterRowModule)
            },
        66551:
            /*!***********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/filter_sync.js ***!
              \***********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_filter_sync = __webpack_require__( /*! ../../../grids/grid_core/filter/m_filter_sync */ 14407);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("filterSync", _m_filter_sync.filterSyncModule)
            },
        24734:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/grid_view.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_grid_view = __webpack_require__( /*! ../../../grids/grid_core/views/m_grid_view */ 28016);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("gridView", _m_grid_view.gridViewModule)
            },
        42595:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/header_filter.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_header_filter = __webpack_require__( /*! ../../../grids/grid_core/header_filter/m_header_filter */ 68796);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("headerFilter", _m_header_filter.headerFilterModule)
            },
        63350:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/header_panel.js ***!
              \************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.HeaderPanel = void 0;
                var _m_header_panel = __webpack_require__( /*! ../../../grids/grid_core/header_panel/m_header_panel */ 92468);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const HeaderPanel = _m_header_panel.headerPanelModule.views.headerPanel;
                exports.HeaderPanel = HeaderPanel;
                _m_core.default.registerModule("headerPanel", _m_header_panel.headerPanelModule)
            },
        28294:
            /*!*******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/keyboard_navigation.js ***!
              \*******************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_keyboard_navigation = __webpack_require__( /*! ../../../grids/grid_core/keyboard_navigation/m_keyboard_navigation */ 31822);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("keyboardNavigation", _m_keyboard_navigation.keyboardNavigationModule)
            },
        48190:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/master_detail.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_master_detail = __webpack_require__( /*! ../../../grids/grid_core/master_detail/m_master_detail */ 82802);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("masterDetail", _m_master_detail.masterDetailModule)
            },
        70608:
            /*!*****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/pager.js ***!
              \*****************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_pager = __webpack_require__( /*! ../../../grids/grid_core/pager/m_pager */ 3990);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("pager", _m_pager.pagerModule)
            },
        445:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/row_dragging.js ***!
              \************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_row_dragging = __webpack_require__( /*! ../../../grids/grid_core/row_dragging/m_row_dragging */ 88351);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("rowDragging", _m_row_dragging.rowDraggingModule)
            },
        86226:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/rows.js ***!
              \****************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.RowsView = void 0;
                var _m_rows_view = __webpack_require__( /*! ../../../grids/grid_core/views/m_rows_view */ 35095);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const RowsView = _m_rows_view.rowsModule.views.rowsView;
                exports.RowsView = RowsView;
                _m_core.default.registerModule("rows", _m_rows_view.rowsModule)
            },
        20015:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/search.js ***!
              \******************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_search = __webpack_require__( /*! ../../../grids/grid_core/search/m_search */ 92021);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("search", _m_search.searchModule)
            },
        86006:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/selection.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_selection = __webpack_require__( /*! ../../../grids/grid_core/selection/m_selection */ 17969);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("selection", _m_selection.selectionModule)
            },
        10792:
            /*!*******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/sorting.js ***!
              \*******************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_sorting = __webpack_require__( /*! ../../../grids/grid_core/sorting/m_sorting */ 11590);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("sorting", _m_sorting.sortingModule)
            },
        97847:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/state_storing.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_state_storing = __webpack_require__( /*! ../../../grids/grid_core/state_storing/m_state_storing */ 12440);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("stateStoring", _m_state_storing.stateStoringModule)
            },
        41430:
            /*!**********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/validating.js ***!
              \**********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_validating = __webpack_require__( /*! ../../../grids/grid_core/validating/m_validating */ 39830);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("validating", _m_validating.validatingModule)
            },
        12470:
            /*!***************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/virtual_columns.js ***!
              \***************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_virtual_columns = __webpack_require__( /*! ../../../grids/grid_core/virtual_columns/m_virtual_columns */ 87482);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("virtualColumns", _m_virtual_columns.virtualColumnsModule)
            },
        98726:
            /*!*****************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/virtual_scrolling.js ***!
              \*****************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_virtual_scrolling = __webpack_require__( /*! ../../../grids/grid_core/virtual_scrolling/m_virtual_scrolling */ 92018);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ../m_data_source_adapter */ 49975));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                _m_core.default.registerModule("virtualScrolling", _m_virtual_scrolling.virtualScrollingModule);
                _m_data_source_adapter.default.extend(_m_virtual_scrolling.dataSourceAdapterExtender)
            },
        15180:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/summary/m_summary.js ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.renderSummaryCell = exports.FooterView = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _query = _interopRequireDefault(__webpack_require__( /*! ../../../../data/query */ 96687));
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ../../../../data/store_helper */ 99236));
                var _utils = __webpack_require__( /*! ../../../../data/utils */ 16454);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_columns_view = __webpack_require__( /*! ../../../grids/grid_core/views/m_columns_view */ 57318);
                var _m_aggregate_calculator = _interopRequireDefault(__webpack_require__( /*! ../m_aggregate_calculator */ 29593));
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ../m_data_source_adapter */ 49975));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _inheritsLoose(subClass, superClass) {
                    subClass.prototype = Object.create(superClass.prototype);
                    subClass.prototype.constructor = subClass;
                    _setPrototypeOf(subClass, superClass)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const renderSummaryCell = function(cell, options) {
                    const $cell = (0, _renderer.default)(cell);
                    const {
                        column: column
                    } = options;
                    const {
                        summaryItems: summaryItems
                    } = options;
                    const $summaryItems = [];
                    if (!column.command && summaryItems) {
                        for (let i = 0; i < summaryItems.length; i++) {
                            const summaryItem = summaryItems[i];
                            const text = _m_core.default.getSummaryText(summaryItem, options.summaryTexts);
                            $summaryItems.push((0, _renderer.default)("<div>").css("textAlign", summaryItem.alignment || column.alignment).addClass("dx-datagrid-summary-item").addClass("dx-datagrid-text-content").addClass(summaryItem.cssClass).toggleClass("dx-datagrid-group-text-content", "group" === options.rowType).text(text).attr("aria-label", "".concat(column.caption, " ").concat(text)))
                        }
                        $cell.append($summaryItems)
                    }
                };
                exports.renderSummaryCell = renderSummaryCell;
                const getSummaryCellOptions = function(that, options) {
                    const summaryTexts = that.option("summary.texts") || {};
                    return {
                        totalItem: options.row,
                        summaryItems: options.row.summaryCells[options.columnIndex],
                        summaryTexts: summaryTexts
                    }
                };
                const getGroupAggregates = function(data) {
                    return data.summary || data.aggregates || []
                };
                const recalculateWhileEditing = function(that) {
                    return that.option("summary.recalculateWhileEditing")
                };
                const forEachGroup = function(groups, groupCount, callback, path) {
                    path = path || [];
                    for (let i = 0; i < groups.length; i++) {
                        path.push(groups[i].key);
                        if (1 === groupCount) {
                            callback(path, groups[i].items)
                        } else {
                            forEachGroup(groups[i].items, groupCount - 1, callback, path)
                        }
                        path.pop()
                    }
                };
                const applyAddedData = function(data, insertedData, groupLevel) {
                    if (groupLevel) {
                        return applyAddedData(data, insertedData.map(item => ({
                            items: [item]
                        }), groupLevel - 1))
                    }
                    return data.concat(insertedData)
                };
                const applyRemovedData = function(data, removedData, groupLevel) {
                    if (groupLevel) {
                        return data.map(data => {
                            const updatedData = {};
                            const updatedItems = applyRemovedData(data.items || [], removedData, groupLevel - 1);
                            Object.defineProperty(updatedData, "aggregates", {
                                get: () => data.aggregates,
                                set: value => {
                                    data.aggregates = value
                                }
                            });
                            return (0, _extend.extend)(updatedData, data, {
                                items: updatedItems
                            })
                        })
                    }
                    return data.filter(data => removedData.indexOf(data) < 0)
                };
                const sortGroupsBySummaryCore = function(items, groups, sortByGroups) {
                    if (!items || !groups.length) {
                        return items
                    }
                    const group = groups[0];
                    const sorts = sortByGroups[0];
                    let query;
                    if (group && sorts && sorts.length) {
                        query = (0, _query.default)(items);
                        (0, _iterator.each)(sorts, (function(index) {
                            if (0 === index) {
                                query = query.sortBy(this.selector, this.desc)
                            } else {
                                query = query.thenBy(this.selector, this.desc)
                            }
                        }));
                        query.enumerate().done(sortedItems => {
                            items = sortedItems
                        })
                    }
                    groups = groups.slice(1);
                    sortByGroups = sortByGroups.slice(1);
                    if (groups.length && sortByGroups.length) {
                        (0, _iterator.each)(items, (function() {
                            this.items = sortGroupsBySummaryCore(this.items, groups, sortByGroups)
                        }))
                    }
                    return items
                };
                const sortGroupsBySummary = function(data, group, summary) {
                    const sortByGroups = summary && summary.sortByGroups && summary.sortByGroups();
                    if (sortByGroups && sortByGroups.length) {
                        return sortGroupsBySummaryCore(data, group, sortByGroups)
                    }
                    return data
                };
                const calculateAggregates = function(that, summary, data, groupLevel) {
                    let calculator;
                    if (recalculateWhileEditing(that)) {
                        const editingController = that.getController("editing");
                        if (editingController) {
                            const insertedData = editingController.getInsertedData();
                            if (insertedData.length) {
                                data = applyAddedData(data, insertedData, groupLevel)
                            }
                            const removedData = editingController.getRemovedData();
                            if (removedData.length) {
                                data = applyRemovedData(data, removedData, groupLevel)
                            }
                        }
                    }
                    if (summary) {
                        calculator = new _m_aggregate_calculator.default({
                            totalAggregates: summary.totalAggregates,
                            groupAggregates: summary.groupAggregates,
                            data: data,
                            groupLevel: groupLevel
                        });
                        calculator.calculate()
                    }
                    return calculator ? calculator.totalAggregates() : []
                };
                let FooterView = function(_ColumnsView) {
                    _inheritsLoose(FooterView, _ColumnsView);

                    function FooterView() {
                        return _ColumnsView.apply(this, arguments) || this
                    }
                    var _proto = FooterView.prototype;
                    _proto._getRows = function() {
                        return this._dataController.footerItems()
                    };
                    _proto._getCellOptions = function(options) {
                        return (0, _extend.extend)(_ColumnsView.prototype._getCellOptions.call(this, options), getSummaryCellOptions(this, options))
                    };
                    _proto._renderCellContent = function($cell, options) {
                        renderSummaryCell($cell, options);
                        _ColumnsView.prototype._renderCellContent.apply(this, arguments)
                    };
                    _proto._renderCore = function(change) {
                        let needUpdateScrollLeft = false;
                        const totalItem = this._dataController.footerItems()[0];
                        if (!change || !change.columnIndices) {
                            this.element().empty().addClass("dx-datagrid-total-footer").toggleClass("dx-datagrid-nowrap", !this.option("wordWrapEnabled"));
                            needUpdateScrollLeft = true
                        }
                        if (totalItem && totalItem.summaryCells && totalItem.summaryCells.length) {
                            this._updateContent(this._renderTable({
                                change: change
                            }), change);
                            needUpdateScrollLeft && this._updateScrollLeftPosition()
                        }
                    };
                    _proto._updateContent = function($newTable, change) {
                        if (change && "update" === change.changeType && change.columnIndices) {
                            return this.waitAsyncTemplates().done(() => {
                                const $row = this.getTableElement().find(".dx-row");
                                const $newRow = $newTable.find(".dx-row");
                                this._updateCells($row, $newRow, change.columnIndices[0])
                            })
                        }
                        return _ColumnsView.prototype._updateContent.apply(this, arguments)
                    };
                    _proto._rowClick = function(e) {
                        const item = this._dataController.footerItems()[e.rowIndex] || {};
                        this.executeAction("onRowClick", (0, _extend.extend)({}, e, item))
                    };
                    _proto._columnOptionChanged = function(e) {
                        const {
                            optionNames: optionNames
                        } = e;
                        if (e.changeTypes.grouping) {
                            return
                        }
                        if (optionNames.width || optionNames.visibleWidth) {
                            _ColumnsView.prototype._columnOptionChanged.call(this, e)
                        }
                    };
                    _proto._handleDataChanged = function(e) {
                        const {
                            changeType: changeType
                        } = e;
                        if ("update" === e.changeType && e.repaintChangesOnly) {
                            if (!e.totalColumnIndices) {
                                this.render()
                            } else if (e.totalColumnIndices.length) {
                                this.render(null, {
                                    changeType: "update",
                                    columnIndices: [e.totalColumnIndices]
                                })
                            }
                        } else if ("refresh" === changeType || "append" === changeType || "prepend" === changeType) {
                            this.render()
                        }
                    };
                    _proto._createRow = function(row) {
                        const $row = _ColumnsView.prototype._createRow.apply(this, arguments);
                        if ("totalFooter" === row.rowType) {
                            $row.addClass("dx-footer-row");
                            $row.addClass("dx-cell-focus-disabled");
                            $row.attr("tabindex", 0)
                        }
                        return $row
                    };
                    _proto.getHeight = function() {
                        return this.getElementHeight()
                    };
                    _proto.isVisible = function() {
                        return !!this._dataController.footerItems().length
                    };
                    return FooterView
                }(_m_columns_view.ColumnsView);
                exports.FooterView = FooterView;
                _m_data_source_adapter.default.extend(Base => function(_Base) {
                    _inheritsLoose(SummaryDataSourceAdapterExtender, _Base);

                    function SummaryDataSourceAdapterExtender() {
                        return _Base.apply(this, arguments) || this
                    }
                    var _proto2 = SummaryDataSourceAdapterExtender.prototype;
                    _proto2.init = function() {
                        _Base.prototype.init.apply(this, arguments);
                        this._totalAggregates = [];
                        this._summaryGetter = _common.noop
                    };
                    _proto2.summaryGetter = function(_summaryGetter) {
                        if (!arguments.length) {
                            return this._summaryGetter
                        }
                        if ((0, _type.isFunction)(_summaryGetter)) {
                            this._summaryGetter = _summaryGetter
                        }
                    };
                    _proto2.summary = function(_summary) {
                        if (!arguments.length) {
                            return this._summaryGetter()
                        }
                        this._summaryGetter = function() {
                            return _summary
                        }
                    };
                    _proto2.totalAggregates = function() {
                        return this._totalAggregates
                    };
                    _proto2.isLastLevelGroupItemsPagingLocal = function() {
                        const summary = this.summary();
                        const sortByGroupsInfo = null === summary || void 0 === summary ? void 0 : summary.sortByGroups();
                        return null === sortByGroupsInfo || void 0 === sortByGroupsInfo ? void 0 : sortByGroupsInfo.length
                    };
                    _proto2.sortLastLevelGroupItems = function(items, groups, paths) {
                        const groupedItems = _store_helper.default.multiLevelGroup((0, _query.default)(items), groups).toArray();
                        let result = [];
                        paths.forEach(path => {
                            forEachGroup(groupedItems, groups.length, (itemsPath, items) => {
                                if (path.toString() === itemsPath.toString()) {
                                    result = result.concat(items)
                                }
                            })
                        });
                        return result
                    };
                    _proto2._customizeRemoteOperations = function(options) {
                        const summary = this.summary();
                        if (summary) {
                            if (options.remoteOperations.summary) {
                                if (!options.isCustomLoading || options.storeLoadOptions.isLoadingAll) {
                                    if (options.storeLoadOptions.group) {
                                        if (options.remoteOperations.grouping) {
                                            options.storeLoadOptions.groupSummary = summary.groupAggregates
                                        } else if (summary.groupAggregates.length) {
                                            options.remoteOperations.paging = false
                                        }
                                    }
                                    options.storeLoadOptions.totalSummary = summary.totalAggregates
                                }
                            } else if (summary.totalAggregates.length || summary.groupAggregates.length && options.storeLoadOptions.group) {
                                options.remoteOperations.paging = false
                            }
                        }
                        _Base.prototype._customizeRemoteOperations.apply(this, arguments);
                        const cachedExtra = options.cachedData.extra;
                        if ((null === cachedExtra || void 0 === cachedExtra ? void 0 : cachedExtra.summary) && !options.isCustomLoading) {
                            options.storeLoadOptions.totalSummary = void 0
                        }
                    };
                    _proto2._handleDataLoadedCore = function(options) {
                        var _a, _b;
                        const groups = (0, _utils.normalizeSortingInfo)(options.storeLoadOptions.group || options.loadOptions.group || []);
                        const remoteOperations = options.remoteOperations || {};
                        const summary = this.summaryGetter()(remoteOperations);
                        if (!options.isCustomLoading || options.storeLoadOptions.isLoadingAll) {
                            if (remoteOperations.summary) {
                                if (!remoteOperations.paging && groups.length && summary) {
                                    if (!remoteOperations.grouping) {
                                        calculateAggregates(this, {
                                            groupAggregates: summary.groupAggregates
                                        }, options.data, groups.length)
                                    }
                                    options.data = sortGroupsBySummary(options.data, groups, summary)
                                }
                            } else if (!remoteOperations.paging && summary) {
                                const operationTypes = options.operationTypes || {};
                                const hasOperations = Object.keys(operationTypes).some(type => operationTypes[type]);
                                if (!hasOperations || !(null === (_b = null === (_a = options.cachedData) || void 0 === _a ? void 0 : _a.extra) || void 0 === _b ? void 0 : _b.summary) || groups.length && summary.groupAggregates.length) {
                                    const totalAggregates = calculateAggregates(this, summary, options.data, groups.length);
                                    options.extra = (0, _type.isPlainObject)(options.extra) ? options.extra : {};
                                    options.extra.summary = totalAggregates;
                                    if (options.cachedData) {
                                        options.cachedData.extra = options.extra
                                    }
                                }
                                options.data = sortGroupsBySummary(options.data, groups, summary)
                            }
                        }
                        if (!options.isCustomLoading) {
                            this._totalAggregates = options.extra && options.extra.summary || this._totalAggregates
                        }
                        _Base.prototype._handleDataLoadedCore.call(this, options)
                    };
                    return SummaryDataSourceAdapterExtender
                }(Base));
                _m_core.default.registerModule("summary", {
                    defaultOptions: () => ({
                        summary: {
                            groupItems: void 0,
                            totalItems: void 0,
                            calculateCustomSummary: void 0,
                            skipEmptyValues: true,
                            recalculateWhileEditing: false,
                            texts: {
                                sum: _message.default.format("dxDataGrid-summarySum"),
                                sumOtherColumn: _message.default.format("dxDataGrid-summarySumOtherColumn"),
                                min: _message.default.format("dxDataGrid-summaryMin"),
                                minOtherColumn: _message.default.format("dxDataGrid-summaryMinOtherColumn"),
                                max: _message.default.format("dxDataGrid-summaryMax"),
                                maxOtherColumn: _message.default.format("dxDataGrid-summaryMaxOtherColumn"),
                                avg: _message.default.format("dxDataGrid-summaryAvg"),
                                avgOtherColumn: _message.default.format("dxDataGrid-summaryAvgOtherColumn"),
                                count: _message.default.format("dxDataGrid-summaryCount")
                            }
                        },
                        sortByGroupSummaryInfo: void 0
                    }),
                    views: {
                        footerView: FooterView
                    },
                    extenders: {
                        controllers: {
                            data: Base => function(_Base2) {
                                _inheritsLoose(SummaryDataControllerExtender, _Base2);

                                function SummaryDataControllerExtender() {
                                    return _Base2.apply(this, arguments) || this
                                }
                                var _proto3 = SummaryDataControllerExtender.prototype;
                                _proto3._isDataColumn = function(column) {
                                    return column && (!(0, _type.isDefined)(column.groupIndex) || column.showWhenGrouped)
                                };
                                _proto3._isGroupFooterVisible = function() {
                                    const groupItems = this.option("summary.groupItems") || [];
                                    for (let i = 0; i < groupItems.length; i++) {
                                        const groupItem = groupItems[i];
                                        const column = this._columnsController.columnOption(groupItem.showInColumn || groupItem.column);
                                        if (groupItem.showInGroupFooter && this._isDataColumn(column)) {
                                            return true
                                        }
                                    }
                                    return false
                                };
                                _proto3._processGroupItems = function(items, groupCount, options) {
                                    const data = options && options.data;
                                    const result = _Base2.prototype._processGroupItems.apply(this, arguments);
                                    if (options) {
                                        if (void 0 === options.isGroupFooterVisible) {
                                            options.isGroupFooterVisible = this._isGroupFooterVisible()
                                        }
                                        if (data && data.items && options.isGroupFooterVisible && (options.collectContinuationItems || !data.isContinuationOnNextPage)) {
                                            result.push({
                                                rowType: "groupFooter",
                                                key: options.path.slice(),
                                                data: data,
                                                groupIndex: options.path.length - 1,
                                                values: []
                                            })
                                        }
                                    }
                                    return result
                                };
                                _proto3._processGroupItem = function(groupItem, options) {
                                    const that = this;
                                    if (!options.summaryGroupItems) {
                                        options.summaryGroupItems = that.option("summary.groupItems") || []
                                    }
                                    if ("group" === groupItem.rowType) {
                                        let groupColumnIndex = -1;
                                        let afterGroupColumnIndex = -1;
                                        (0, _iterator.each)(options.visibleColumns, (function(visibleIndex) {
                                            const prevColumn = options.visibleColumns[visibleIndex - 1];
                                            if (groupItem.groupIndex === this.groupIndex) {
                                                groupColumnIndex = this.index
                                            }
                                            if (visibleIndex > 0 && "expand" === prevColumn.command && "expand" !== this.command) {
                                                afterGroupColumnIndex = this.index
                                            }
                                        }));
                                        groupItem.summaryCells = this._calculateSummaryCells(options.summaryGroupItems, getGroupAggregates(groupItem.data), options.visibleColumns, (summaryItem, column) => {
                                            if (summaryItem.showInGroupFooter) {
                                                return -1
                                            }
                                            if (summaryItem.alignByColumn && column && !(0, _type.isDefined)(column.groupIndex) && column.index !== afterGroupColumnIndex) {
                                                return column.index
                                            }
                                            return groupColumnIndex
                                        }, true)
                                    }
                                    if ("groupFooter" === groupItem.rowType) {
                                        groupItem.summaryCells = this._calculateSummaryCells(options.summaryGroupItems, getGroupAggregates(groupItem.data), options.visibleColumns, (summaryItem, column) => summaryItem.showInGroupFooter && that._isDataColumn(column) ? column.index : -1)
                                    }
                                    return groupItem
                                };
                                _proto3._calculateSummaryCells = function(summaryItems, aggregates, visibleColumns, calculateTargetColumnIndex, isGroupRow) {
                                    const that = this;
                                    const summaryCells = [];
                                    const summaryCellsByColumns = {};
                                    (0, _iterator.each)(summaryItems, (summaryIndex, summaryItem) => {
                                        const column = that._columnsController.columnOption(summaryItem.column);
                                        const showInColumn = summaryItem.showInColumn && that._columnsController.columnOption(summaryItem.showInColumn) || column;
                                        const columnIndex = calculateTargetColumnIndex(summaryItem, showInColumn);
                                        if (columnIndex >= 0) {
                                            if (!summaryCellsByColumns[columnIndex]) {
                                                summaryCellsByColumns[columnIndex] = []
                                            }
                                            const aggregate = aggregates[summaryIndex];
                                            if (aggregate === aggregate) {
                                                let valueFormat;
                                                if ((0, _type.isDefined)(summaryItem.valueFormat)) {
                                                    valueFormat = summaryItem.valueFormat
                                                } else if ("count" !== summaryItem.summaryType) {
                                                    valueFormat = _m_core.default.getFormatByDataType(column && column.dataType)
                                                }
                                                summaryCellsByColumns[columnIndex].push((0, _extend.extend)({}, summaryItem, {
                                                    value: (0, _type.isString)(aggregate) && column && column.deserializeValue ? column.deserializeValue(aggregate) : aggregate,
                                                    valueFormat: valueFormat,
                                                    columnCaption: column && column.index !== columnIndex ? column.caption : void 0
                                                }))
                                            }
                                        }
                                    });
                                    if (!(0, _type.isEmptyObject)(summaryCellsByColumns)) {
                                        visibleColumns.forEach((column, visibleIndex) => {
                                            const prevColumn = visibleColumns[visibleIndex - 1];
                                            const columnIndex = isGroupRow && ("expand" === (null === prevColumn || void 0 === prevColumn ? void 0 : prevColumn.command) || "expand" === column.command) ? null === prevColumn || void 0 === prevColumn ? void 0 : prevColumn.index : column.index;
                                            summaryCells.push(summaryCellsByColumns[columnIndex] || [])
                                        })
                                    }
                                    return summaryCells
                                };
                                _proto3._getSummaryCells = function(summaryTotalItems, totalAggregates) {
                                    const that = this;
                                    const columnsController = that._columnsController;
                                    return that._calculateSummaryCells(summaryTotalItems, totalAggregates, columnsController.getVisibleColumns(), (summaryItem, column) => that._isDataColumn(column) ? column.index : -1)
                                };
                                _proto3._updateItemsCore = function(change) {
                                    const that = this;
                                    let summaryCells;
                                    const dataSource = that._dataSource;
                                    const footerItems = that._footerItems;
                                    const oldSummaryCells = footerItems && footerItems[0] && footerItems[0].summaryCells;
                                    const summaryTotalItems = that.option("summary.totalItems");
                                    that._footerItems = [];
                                    if (dataSource && summaryTotalItems && summaryTotalItems.length) {
                                        const totalAggregates = dataSource.totalAggregates();
                                        summaryCells = that._getSummaryCells(summaryTotalItems, totalAggregates);
                                        if (change && change.repaintChangesOnly && oldSummaryCells) {
                                            change.totalColumnIndices = summaryCells.map((summaryCell, index) => {
                                                if (JSON.stringify(summaryCell) !== JSON.stringify(oldSummaryCells[index])) {
                                                    return index
                                                }
                                                return -1
                                            }).filter(index => index >= 0)
                                        }
                                        if (summaryCells.length) {
                                            that._footerItems.push({
                                                rowType: "totalFooter",
                                                summaryCells: summaryCells
                                            })
                                        }
                                    }
                                    _Base2.prototype._updateItemsCore.call(this, change)
                                };
                                _proto3._prepareUnsavedDataSelector = function(selector) {
                                    const that = this;
                                    if (recalculateWhileEditing(that)) {
                                        const editingController = that.getController("editing");
                                        if (editingController) {
                                            return function(data) {
                                                data = editingController.getUpdatedData(data);
                                                return selector(data)
                                            }
                                        }
                                    }
                                    return selector
                                };
                                _proto3._prepareAggregateSelector = function(selector, aggregator) {
                                    selector = this._prepareUnsavedDataSelector(selector);
                                    if ("avg" === aggregator || "sum" === aggregator) {
                                        return function(data) {
                                            const value = selector(data);
                                            return (0, _type.isDefined)(value) ? Number(value) : value
                                        }
                                    }
                                    return selector
                                };
                                _proto3._getAggregates = function(summaryItems, remoteOperations) {
                                    const that = this;
                                    const columnsController = that.getController("columns");
                                    let calculateCustomSummary = that.option("summary.calculateCustomSummary");
                                    const commonSkipEmptyValues = that.option("summary.skipEmptyValues");
                                    return (0, _iterator.map)(summaryItems || [], summaryItem => {
                                        const column = columnsController.columnOption(summaryItem.column);
                                        const calculateCellValue = column && column.calculateCellValue ? column.calculateCellValue.bind(column) : (0, _data.compileGetter)(column ? column.dataField : summaryItem.column);
                                        let aggregator = summaryItem.summaryType || "count";
                                        const skipEmptyValues = (0, _type.isDefined)(summaryItem.skipEmptyValues) ? summaryItem.skipEmptyValues : commonSkipEmptyValues;
                                        if (remoteOperations) {
                                            return {
                                                selector: summaryItem.column,
                                                summaryType: aggregator
                                            }
                                        }
                                        const selector = that._prepareAggregateSelector(calculateCellValue, aggregator);
                                        if ("custom" === aggregator) {
                                            if (!calculateCustomSummary) {
                                                _ui.default.log("E1026");
                                                calculateCustomSummary = function() {}
                                            }
                                            const options = {
                                                component: that.component,
                                                name: summaryItem.name
                                            };
                                            calculateCustomSummary(options);
                                            options.summaryProcess = "calculate";
                                            aggregator = {
                                                seed(groupIndex) {
                                                    options.summaryProcess = "start";
                                                    options.totalValue = void 0;
                                                    options.groupIndex = groupIndex;
                                                    delete options.value;
                                                    calculateCustomSummary(options);
                                                    return options.totalValue
                                                },
                                                step(totalValue, value) {
                                                    options.summaryProcess = "calculate";
                                                    options.totalValue = totalValue;
                                                    options.value = value;
                                                    calculateCustomSummary(options);
                                                    return options.totalValue
                                                },
                                                finalize(totalValue) {
                                                    options.summaryProcess = "finalize";
                                                    options.totalValue = totalValue;
                                                    delete options.value;
                                                    calculateCustomSummary(options);
                                                    return options.totalValue
                                                }
                                            }
                                        }
                                        return {
                                            selector: selector,
                                            aggregator: aggregator,
                                            skipEmptyValues: skipEmptyValues
                                        }
                                    })
                                };
                                _proto3._addSortInfo = function(sortByGroups, groupColumn, selector, sortOrder) {
                                    if (groupColumn) {
                                        const {
                                            groupIndex: groupIndex
                                        } = groupColumn;
                                        sortOrder = sortOrder || groupColumn.sortOrder;
                                        if ((0, _type.isDefined)(groupIndex)) {
                                            sortByGroups[groupIndex] = sortByGroups[groupIndex] || [];
                                            sortByGroups[groupIndex].push({
                                                selector: selector,
                                                desc: "desc" === sortOrder
                                            })
                                        }
                                    }
                                };
                                _proto3._findSummaryItem = function(summaryItems, name) {
                                    let summaryItemIndex = -1;
                                    if ((0, _type.isDefined)(name)) {
                                        (0, _iterator.each)(summaryItems || [], (function(index) {
                                            if (this.name === name || index === name || this.summaryType === name || this.column === name || function(summaryItem) {
                                                    const {
                                                        summaryType: summaryType
                                                    } = summaryItem;
                                                    const {
                                                        column: column
                                                    } = summaryItem;
                                                    return summaryType && column && "".concat(summaryType, "_").concat(column)
                                                }(this) === name) {
                                                summaryItemIndex = index;
                                                return false
                                            }
                                        }))
                                    }
                                    return summaryItemIndex
                                };
                                _proto3._getSummarySortByGroups = function(sortByGroupSummaryInfo, groupSummaryItems) {
                                    const that = this;
                                    const columnsController = that._columnsController;
                                    const groupColumns = columnsController.getGroupColumns();
                                    const sortByGroups = [];
                                    if (!groupSummaryItems || !groupSummaryItems.length) {
                                        return
                                    }(0, _iterator.each)(sortByGroupSummaryInfo || [], (function() {
                                        const {
                                            sortOrder: sortOrder
                                        } = this;
                                        let {
                                            groupColumn: groupColumn
                                        } = this;
                                        const summaryItemIndex = that._findSummaryItem(groupSummaryItems, this.summaryItem);
                                        if (summaryItemIndex < 0) {
                                            return
                                        }
                                        const selector = function(data) {
                                            return getGroupAggregates(data)[summaryItemIndex]
                                        };
                                        if ((0, _type.isDefined)(groupColumn)) {
                                            groupColumn = columnsController.columnOption(groupColumn);
                                            that._addSortInfo(sortByGroups, groupColumn, selector, sortOrder)
                                        } else {
                                            (0, _iterator.each)(groupColumns, (groupIndex, groupColumn) => {
                                                that._addSortInfo(sortByGroups, groupColumn, selector, sortOrder)
                                            })
                                        }
                                    }));
                                    return sortByGroups
                                };
                                _proto3._createDataSourceAdapterCore = function(dataSource, remoteOperations) {
                                    const that = this;
                                    const dataSourceAdapter = _Base2.prototype._createDataSourceAdapterCore.call(this, dataSource, remoteOperations);
                                    dataSourceAdapter.summaryGetter(currentRemoteOperations => that._getSummaryOptions(currentRemoteOperations || remoteOperations));
                                    return dataSourceAdapter
                                };
                                _proto3._getSummaryOptions = function(remoteOperations) {
                                    const that = this;
                                    const groupSummaryItems = that.option("summary.groupItems");
                                    const totalSummaryItems = that.option("summary.totalItems");
                                    const sortByGroupSummaryInfo = that.option("sortByGroupSummaryInfo");
                                    const groupAggregates = that._getAggregates(groupSummaryItems, remoteOperations && remoteOperations.grouping && remoteOperations.summary);
                                    const totalAggregates = that._getAggregates(totalSummaryItems, remoteOperations && remoteOperations.summary);
                                    const sortByGroups = function() {
                                        return that._getSummarySortByGroups(sortByGroupSummaryInfo, groupSummaryItems)
                                    };
                                    if (groupAggregates.length || totalAggregates.length) {
                                        return {
                                            groupAggregates: groupAggregates,
                                            totalAggregates: totalAggregates,
                                            sortByGroups: sortByGroups
                                        }
                                    }
                                    return
                                };
                                _proto3.publicMethods = function() {
                                    const methods = _Base2.prototype.publicMethods.call(this);
                                    methods.push("getTotalSummaryValue");
                                    return methods
                                };
                                _proto3.getTotalSummaryValue = function(summaryItemName) {
                                    const summaryItemIndex = this._findSummaryItem(this.option("summary.totalItems"), summaryItemName);
                                    const aggregates = this._dataSource.totalAggregates();
                                    if (aggregates.length && summaryItemIndex > -1) {
                                        return aggregates[summaryItemIndex]
                                    }
                                };
                                _proto3.optionChanged = function(args) {
                                    if ("summary" === args.name || "sortByGroupSummaryInfo" === args.name) {
                                        args.name = "dataSource"
                                    }
                                    _Base2.prototype.optionChanged.call(this, args)
                                };
                                _proto3.init = function() {
                                    this._footerItems = [];
                                    _Base2.prototype.init.call(this)
                                };
                                _proto3.footerItems = function() {
                                    return this._footerItems
                                };
                                return SummaryDataControllerExtender
                            }(Base),
                            editing: Base => function(_Base3) {
                                _inheritsLoose(SummaryEditingController, _Base3);

                                function SummaryEditingController() {
                                    return _Base3.apply(this, arguments) || this
                                }
                                var _proto4 = SummaryEditingController.prototype;
                                _proto4._refreshSummary = function() {
                                    if (recalculateWhileEditing(this) && !this.isSaving()) {
                                        this._dataController.refresh({
                                            load: true,
                                            changesOnly: true
                                        })
                                    }
                                };
                                _proto4._addChange = function(params) {
                                    const result = _Base3.prototype._addChange.apply(this, arguments);
                                    if (params.type) {
                                        this._refreshSummary()
                                    }
                                    return result
                                };
                                _proto4._removeChange = function() {
                                    const result = _Base3.prototype._removeChange.apply(this, arguments);
                                    this._refreshSummary();
                                    return result
                                };
                                _proto4.cancelEditData = function() {
                                    const result = _Base3.prototype.cancelEditData.apply(this, arguments);
                                    this._refreshSummary();
                                    return result
                                };
                                return SummaryEditingController
                            }(Base)
                        },
                        views: {
                            rowsView: Base => function(_Base4) {
                                _inheritsLoose(SummaryRowsViewExtender, _Base4);

                                function SummaryRowsViewExtender() {
                                    return _Base4.apply(this, arguments) || this
                                }
                                var _proto5 = SummaryRowsViewExtender.prototype;
                                _proto5._createRow = function(row) {
                                    const $row = _Base4.prototype._createRow.apply(this, arguments);
                                    row && $row.addClass("groupFooter" === row.rowType ? "dx-datagrid-group-footer" : "");
                                    return $row
                                };
                                _proto5._renderCells = function($row, options) {
                                    _Base4.prototype._renderCells.apply(this, arguments);
                                    if ("group" === options.row.rowType && options.row.summaryCells && options.row.summaryCells.length) {
                                        this._renderGroupSummaryCells($row, options)
                                    }
                                };
                                _proto5._hasAlignByColumnSummaryItems = function(columnIndex, options) {
                                    return !(0, _type.isDefined)(options.columns[columnIndex].groupIndex) && options.row.summaryCells[columnIndex].length
                                };
                                _proto5._getAlignByColumnCellCount = function(groupCellColSpan, options) {
                                    let alignByColumnCellCount = 0;
                                    for (let i = 1; i < groupCellColSpan; i++) {
                                        const columnIndex = options.row.summaryCells.length - i;
                                        alignByColumnCellCount = this._hasAlignByColumnSummaryItems(columnIndex, options) ? i : alignByColumnCellCount
                                    }
                                    return alignByColumnCellCount
                                };
                                _proto5._renderGroupSummaryCells = function($row, options) {
                                    const $groupCell = $row.children().last();
                                    const groupCellColSpan = Number($groupCell.attr("colSpan")) || 1;
                                    const alignByColumnCellCount = this._getAlignByColumnCellCount(groupCellColSpan, options);
                                    this._renderGroupSummaryCellsCore($groupCell, options, groupCellColSpan, alignByColumnCellCount)
                                };
                                _proto5._renderGroupSummaryCellsCore = function($groupCell, options, groupCellColSpan, alignByColumnCellCount) {
                                    if (alignByColumnCellCount > 0) {
                                        $groupCell.attr("colSpan", groupCellColSpan - alignByColumnCellCount);
                                        for (let i = 0; i < alignByColumnCellCount; i++) {
                                            const columnIndex = options.columns.length - alignByColumnCellCount + i;
                                            this._renderCell($groupCell.parent(), (0, _extend.extend)({
                                                column: options.columns[columnIndex],
                                                columnIndex: this._getSummaryCellIndex(columnIndex, options.columns)
                                            }, options))
                                        }
                                    }
                                };
                                _proto5._getSummaryCellIndex = function(columnIndex, columns) {
                                    return columnIndex
                                };
                                _proto5._getCellTemplate = function(options) {
                                    if (!options.column.command && !(0, _type.isDefined)(options.column.groupIndex) && options.summaryItems && options.summaryItems.length) {
                                        return renderSummaryCell
                                    }
                                    return _Base4.prototype._getCellTemplate.call(this, options)
                                };
                                _proto5._getCellOptions = function(options) {
                                    const that = this;
                                    const parameters = _Base4.prototype._getCellOptions.call(this, options);
                                    if (options.row.summaryCells) {
                                        return (0, _extend.extend)(parameters, getSummaryCellOptions(that, options))
                                    }
                                    return parameters
                                };
                                return SummaryRowsViewExtender
                            }(Base)
                        }
                    }
                })
            },
        18107:
            /*!***************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/adaptivity/m_adaptivity.js ***!
              \***************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.adaptivityModule = exports.AdaptiveColumnsController = void 0;
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../../../core/guid */ 73176));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _dom = __webpack_require__( /*! ../../../../core/utils/dom */ 3532);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _click = __webpack_require__( /*! ../../../../events/click */ 95429);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 55994));
                var _remove = __webpack_require__( /*! ../../../../events/remove */ 29007);
                var _index = __webpack_require__( /*! ../../../../events/utils/index */ 39611);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _form = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/form */ 17737));
                var _themes = __webpack_require__( /*! ../../../../ui/themes */ 75811);
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _inheritsLoose(subClass, superClass) {
                    subClass.prototype = Object.create(superClass.prototype);
                    subClass.prototype.constructor = subClass;
                    _setPrototypeOf(subClass, superClass)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const COLUMN_VIEWS = ["columnHeadersView", "rowsView", "footerView"];

                function getColumnId(that, column) {
                    return that._columnsController.getColumnId(column)
                }

                function adaptiveCellTemplate(container, options) {
                    let $adaptiveColumnButton;
                    const $container = (0, _renderer.default)(container);
                    const adaptiveColumnsController = options.component.getController("adaptiveColumns");
                    if ("data" === options.rowType) {
                        $adaptiveColumnButton = (0, _renderer.default)("<span>").addClass(adaptiveColumnsController.addWidgetPrefix("adaptive-more"));
                        _events_engine.default.on($adaptiveColumnButton, (0, _index.addNamespace)(_click.name, "dxDataGridAdaptivity"), adaptiveColumnsController.createAction(() => {
                            adaptiveColumnsController.toggleExpandAdaptiveDetailRow(options.key)
                        }));
                        $adaptiveColumnButton.appendTo($container)
                    } else {
                        _m_utils.default.setEmptyText($container)
                    }
                }

                function focusCellHandler(e) {
                    var _a;
                    const $nextCell = null === (_a = e.data) || void 0 === _a ? void 0 : _a.$nextCell;
                    _events_engine.default.off($nextCell, "focus", focusCellHandler);
                    _events_engine.default.trigger($nextCell, "dxclick")
                }
                let AdaptiveColumnsController = function(_modules$ViewControll) {
                    _inheritsLoose(AdaptiveColumnsController, _modules$ViewControll);

                    function AdaptiveColumnsController() {
                        return _modules$ViewControll.apply(this, arguments) || this
                    }
                    var _proto = AdaptiveColumnsController.prototype;
                    _proto.init = function() {
                        this._columnsController = this.getController("columns");
                        this._dataController = this.getController("data");
                        this._editingController = this.getController("editing");
                        this._keyboardNavigationController = this.getController("keyboardNavigation");
                        this._rowsView = this.getView("rowsView");
                        this._columnsController.addCommandColumn({
                            type: "adaptive",
                            command: "adaptive",
                            visible: true,
                            adaptiveHidden: true,
                            cssClass: "dx-command-adaptive",
                            alignment: "center",
                            width: "auto",
                            cellTemplate: adaptiveCellTemplate,
                            fixedPosition: "right"
                        });
                        this._columnsController.columnsChanged.add(() => {
                            const isAdaptiveVisible = !!this.updateHidingQueue(this._columnsController.getColumns()).length;
                            this._columnsController.columnOption("command:adaptive", "adaptiveHidden", !isAdaptiveVisible, true)
                        });
                        this._hidingColumnsQueue = [];
                        this._hiddenColumns = [];
                        this.createAction("onAdaptiveDetailRowPreparing");
                        _modules$ViewControll.prototype.init.call(this)
                    };
                    _proto.optionChanged = function(args) {
                        if ("columnHidingEnabled" === args.name) {
                            this._columnsController.columnOption("command:adaptive", "adaptiveHidden", !args.value)
                        }
                        _modules$ViewControll.prototype.optionChanged.call(this, args)
                    };
                    _proto.publicMethods = function() {
                        return ["isAdaptiveDetailRowExpanded", "expandAdaptiveDetailRow", "collapseAdaptiveDetailRow"]
                    };
                    _proto._isRowEditMode = function() {
                        const editMode = this._getEditMode();
                        return "row" === editMode
                    };
                    _proto._isItemModified = function(item, cellOptions) {
                        const columnIndex = this._columnsController.getVisibleIndex(item.column.index);
                        const rowIndex = this._dataController.getRowIndexByKey(cellOptions.key);
                        const row = this._dataController.items()[rowIndex + 1];
                        return row && row.modifiedValues && (0, _type.isDefined)(row.modifiedValues[columnIndex])
                    };
                    _proto._renderFormViewTemplate = function(item, cellOptions, $container) {
                        const that = this;
                        const {
                            column: column
                        } = item;
                        const focusAction = that.createAction(() => {
                            if (that._editingController.isEditing()) {
                                _events_engine.default.trigger($container, _click.name)
                            }
                        });
                        const rowData = cellOptions.row.data;
                        const value = column.calculateCellValue(rowData);
                        const displayValue = _m_utils.default.getDisplayValue(column, value, rowData, cellOptions.rowType);
                        const text = _m_utils.default.formatValue(displayValue, column);
                        const isCellOrBatchEditMode = this._editingController.isCellOrBatchEditMode();
                        const rowsView = that._rowsView;
                        if (column.allowEditing && this._keyboardNavigationController.isKeyboardEnabled()) {
                            $container.attr("tabIndex", that.option("tabIndex"));
                            if (isCellOrBatchEditMode) {
                                _events_engine.default.off($container, "focus", focusAction);
                                _events_engine.default.on($container, "focus", focusAction)
                            }
                        }
                        if (column.cellTemplate) {
                            const templateOptions = (0, _extend.extend)({}, cellOptions, {
                                value: value,
                                displayValue: displayValue,
                                text: text,
                                column: column
                            });
                            rowsView.renderTemplate($container, column.cellTemplate, templateOptions, (0, _dom.isElementInDom)($container)).done(() => {
                                rowsView._cellPrepared($container, cellOptions)
                            })
                        } else {
                            const container = $container.get(0);
                            if (column.encodeHtml) {
                                container.textContent = text
                            } else {
                                container.innerHTML = text
                            }
                            $container.addClass("dx-adaptive-item-text");
                            if (!(0, _type.isDefined)(text) || "" === text) {
                                $container.html("&nbsp;")
                            }
                            if (!that._isRowEditMode()) {
                                if (that._isItemModified(item, cellOptions)) {
                                    $container.addClass("dx-item-modified")
                                }
                            }
                            rowsView._cellPrepared($container, cellOptions)
                        }
                    };
                    _proto._getTemplate = function(item, cellOptions, updateForm) {
                        const that = this;
                        const {
                            column: column
                        } = item;
                        const editingController = this._editingController;
                        return function(options, container) {
                            const $container = (0, _renderer.default)(container);
                            const columnIndex = that._columnsController.getVisibleIndex(column.index);
                            const templateOptions = (0, _extend.extend)({}, cellOptions);
                            const renderFormTemplate = function() {
                                const isItemEdited = that._isItemEdited(item);
                                templateOptions.value = cellOptions.row.values[columnIndex];
                                if (isItemEdited || column.showEditorAlways) {
                                    editingController.renderFormEditorTemplate(templateOptions, item, options, $container, !isItemEdited)
                                } else {
                                    templateOptions.column = column;
                                    templateOptions.columnIndex = columnIndex;
                                    that._renderFormViewTemplate(item, templateOptions, $container)
                                }
                            };
                            renderFormTemplate();
                            if (templateOptions.watch) {
                                const dispose = templateOptions.watch(() => ({
                                    isItemEdited: that._isItemEdited(item),
                                    value: cellOptions.row.values[columnIndex]
                                }), () => {
                                    $container.contents().remove();
                                    $container.removeClass("dx-adaptive-item-text");
                                    renderFormTemplate()
                                });
                                _events_engine.default.on($container, _remove.removeEvent, dispose)
                            }
                        }
                    };
                    _proto._isVisibleColumnsValid = function(visibleColumns) {
                        if (visibleColumns < 2) {
                            return false
                        }
                        if (visibleColumns.length - function() {
                                let result = 0;
                                for (let j = 0; j < visibleColumns.length; j++) {
                                    const visibleColumn = visibleColumns[j];
                                    if (visibleColumn.command) {
                                        result++
                                    }
                                }
                                return result
                            }() <= 1) {
                            return false
                        }
                        return true
                    };
                    _proto._calculatePercentWidths = function(widths, visibleColumns) {
                        const that = this;
                        let percentWidths = 0;
                        visibleColumns.forEach((item, index) => {
                            if ("adaptiveHidden" !== widths[index]) {
                                percentWidths += that._getItemPercentWidth(item)
                            }
                        });
                        return percentWidths
                    };
                    _proto._isPercentWidth = function(width) {
                        return (0, _type.isString)(width) && width.endsWith("%")
                    };
                    _proto._isColumnHidden = function(column) {
                        return this._hiddenColumns.filter(hiddenColumn => hiddenColumn.index === column.index).length > 0
                    };
                    _proto._getAverageColumnsWidth = function(containerWidth, columns, columnsCanFit) {
                        const that = this;
                        let fixedColumnsWidth = 0;
                        let columnsWithoutFixedWidthCount = 0;
                        columns.forEach(column => {
                            if (!that._isColumnHidden(column)) {
                                const {
                                    width: width
                                } = column;
                                if ((0, _type.isDefined)(width) && !isNaN(parseFloat(width))) {
                                    fixedColumnsWidth += that._isPercentWidth(width) ? that._calculatePercentWidth({
                                        visibleIndex: column.visibleIndex,
                                        columnsCount: columns.length,
                                        columnsCanFit: columnsCanFit,
                                        bestFitWidth: column.bestFitWidth,
                                        columnWidth: width,
                                        containerWidth: containerWidth
                                    }) : parseFloat(width)
                                } else {
                                    columnsWithoutFixedWidthCount++
                                }
                            }
                        });
                        return (containerWidth - fixedColumnsWidth) / columnsWithoutFixedWidthCount
                    };
                    _proto._calculateColumnWidth = function(column, containerWidth, contentColumns, columnsCanFit) {
                        const columnId = getColumnId(this, column);
                        const widthOption = this._columnsController.columnOption(columnId, "width");
                        const bestFitWidth = this._columnsController.columnOption(columnId, "bestFitWidth");
                        const columnsCount = contentColumns.length;
                        let colWidth;
                        if (widthOption && "auto" !== widthOption) {
                            if (this._isPercentWidth(widthOption)) {
                                colWidth = this._calculatePercentWidth({
                                    visibleIndex: column.visibleIndex,
                                    columnsCount: columnsCount,
                                    columnsCanFit: columnsCanFit,
                                    bestFitWidth: bestFitWidth,
                                    columnWidth: widthOption,
                                    containerWidth: containerWidth
                                })
                            } else {
                                return parseFloat(widthOption)
                            }
                        } else {
                            const columnAutoWidth = this.option("columnAutoWidth");
                            colWidth = columnAutoWidth || !!column.command ? bestFitWidth : this._getAverageColumnsWidth(containerWidth, contentColumns, columnsCanFit)
                        }
                        return colWidth
                    };
                    _proto._calculatePercentWidth = function(options) {
                        const columnFitted = options.visibleIndex < options.columnsCount - 1 && options.columnsCanFit;
                        const partialWidth = options.containerWidth * parseFloat(options.columnWidth) / 100;
                        const resultWidth = options.columnsCanFit && partialWidth < options.bestFitWidth ? options.bestFitWidth : partialWidth;
                        return columnFitted ? options.containerWidth * parseFloat(options.columnWidth) / 100 : resultWidth
                    };
                    _proto._getNotTruncatedColumnWidth = function(column, containerWidth, contentColumns, columnsCanFit) {
                        const columnId = getColumnId(this, column);
                        const widthOption = this._columnsController.columnOption(columnId, "width");
                        const bestFitWidth = this._columnsController.columnOption(columnId, "bestFitWidth");
                        if (widthOption && "auto" !== widthOption && !this._isPercentWidth(widthOption)) {
                            return parseFloat(widthOption)
                        }
                        const colWidth = this._calculateColumnWidth(column, containerWidth, contentColumns, columnsCanFit);
                        return colWidth < bestFitWidth ? null : colWidth
                    };
                    _proto._getItemPercentWidth = function(item) {
                        let result = 0;
                        if (item.width && this._isPercentWidth(item.width)) {
                            result = parseFloat(item.width)
                        }
                        return result
                    };
                    _proto._getCommandColumnsWidth = function() {
                        const that = this;
                        const columns = that._columnsController.getVisibleColumns();
                        let colWidth = 0;
                        (0, _iterator.each)(columns, (index, column) => {
                            if (column.index < 0 || column.command) {
                                colWidth += that._columnsController.columnOption(getColumnId(that, column), "bestFitWidth") || 0
                            }
                        });
                        return colWidth
                    };
                    _proto._isItemEdited = function(item) {
                        if (this.isFormOrPopupEditMode()) {
                            return false
                        }
                        if (this._isRowEditMode()) {
                            const editRowKey = this.option("editing.editRowKey");
                            if ((0, _common.equalByValue)(editRowKey, this._dataController.adaptiveExpandedKey())) {
                                return true
                            }
                        } else {
                            const rowIndex = this._dataController.getRowIndexByKey(this._dataController.adaptiveExpandedKey()) + 1;
                            const columnIndex = this._columnsController.getVisibleIndex(item.column.index);
                            return this._editingController.isEditCell(rowIndex, columnIndex)
                        }
                        return
                    };
                    _proto._getFormItemsByHiddenColumns = function(hiddenColumns) {
                        const items = [];
                        (0, _iterator.each)(hiddenColumns, (_, column) => {
                            items.push({
                                column: column,
                                name: column.name,
                                dataField: column.dataField,
                                visibleIndex: column.visibleIndex
                            })
                        });
                        return items
                    };
                    _proto._getAdaptiveColumnVisibleIndex = function(visibleColumns) {
                        for (let i = 0; i < visibleColumns.length; i++) {
                            const column = visibleColumns[i];
                            if ("adaptive" === column.command) {
                                return i
                            }
                        }
                        return
                    };
                    _proto._hideAdaptiveColumn = function(resultWidths, visibleColumns) {
                        const visibleIndex = this._getAdaptiveColumnVisibleIndex(visibleColumns);
                        if ((0, _type.isDefined)(visibleIndex)) {
                            resultWidths[visibleIndex] = "adaptiveHidden";
                            this._hideVisibleColumn({
                                isCommandColumn: true,
                                visibleIndex: visibleIndex
                            })
                        }
                    };
                    _proto._showHiddenCellsInView = function(_ref) {
                        let {
                            $cells: $cells,
                            isCommandColumn: isCommandColumn
                        } = _ref;
                        let cssClassNameToRemove = this.addWidgetPrefix("hidden-column");
                        if (isCommandColumn) {
                            cssClassNameToRemove = "dx-command-adaptive-hidden";
                            $cells.attr({
                                tabIndex: 0,
                                "aria-hidden": null
                            }).removeClass(cssClassNameToRemove)
                        } else {
                            $cells.removeClass(cssClassNameToRemove)
                        }
                    };
                    _proto._showHiddenColumns = function() {
                        for (let i = 0; i < COLUMN_VIEWS.length; i++) {
                            const view = this.getView(COLUMN_VIEWS[i]);
                            if (view && view.isVisible() && view.element()) {
                                const viewName = view.name;
                                const $hiddenCommandCells = view.element().find(".".concat("dx-command-adaptive-hidden"));
                                this._showHiddenCellsInView({
                                    viewName: viewName,
                                    $cells: $hiddenCommandCells,
                                    isCommandColumn: true
                                });
                                const $hiddenCells = view.element().find(".".concat(this.addWidgetPrefix("hidden-column")));
                                this._showHiddenCellsInView({
                                    viewName: viewName,
                                    $cells: $hiddenCells
                                })
                            }
                        }
                    };
                    _proto._isCellValid = function($cell) {
                        return $cell && $cell.length && !$cell.hasClass("dx-master-detail-cell") && !$cell.hasClass("dx-group-cell")
                    };
                    _proto._hideVisibleColumn = function(_ref2) {
                        let {
                            isCommandColumn: isCommandColumn,
                            visibleIndex: visibleIndex
                        } = _ref2;
                        const that = this;
                        COLUMN_VIEWS.forEach(viewName => {
                            const view = that.getView(viewName);
                            view && that._hideVisibleColumnInView({
                                view: view,
                                isCommandColumn: isCommandColumn,
                                visibleIndex: visibleIndex
                            })
                        })
                    };
                    _proto._hideVisibleColumnInView = function(_ref3) {
                        let {
                            view: view,
                            isCommandColumn: isCommandColumn,
                            visibleIndex: visibleIndex
                        } = _ref3;
                        const viewName = view.name;
                        let $cellElement;
                        const column = this._columnsController.getVisibleColumns()[visibleIndex];
                        const editFormRowIndex = this._editingController && this._editingController.getEditFormRowIndex();
                        if (view && view.isVisible() && column) {
                            const rowsCount = view.getRowsCount();
                            const $rowElements = view._getRowElements();
                            for (let rowIndex = 0; rowIndex < rowsCount; rowIndex++) {
                                const cancelClassAdding = rowIndex === editFormRowIndex && "rowsView" === viewName && "popup" !== this.option("editing.mode");
                                if (!cancelClassAdding) {
                                    const currentVisibleIndex = "columnHeadersView" === viewName ? this._columnsController.getVisibleIndex(column.index, rowIndex) : visibleIndex;
                                    if (currentVisibleIndex >= 0) {
                                        const $rowElement = $rowElements.eq(rowIndex);
                                        $cellElement = this._findCellElementInRow($rowElement, currentVisibleIndex);
                                        this._isCellValid($cellElement) && this._hideVisibleCellInView({
                                            viewName: viewName,
                                            isCommandColumn: isCommandColumn,
                                            $cell: $cellElement
                                        })
                                    }
                                }
                            }
                        }
                    };
                    _proto._findCellElementInRow = function($rowElement, visibleColumnIndex) {
                        const $rowCells = $rowElement.children();
                        let visibleIndex = visibleColumnIndex;
                        let cellIsInsideGroup = false;
                        if ($rowElement.hasClass("dx-group-row")) {
                            const $groupCell = $rowElement.find(".".concat("dx-group-cell"));
                            const colSpan = $groupCell.attr("colspan");
                            if ($groupCell.length && (0, _type.isDefined)(colSpan)) {
                                const groupCellLength = parseInt(colSpan);
                                const endGroupIndex = $groupCell.index() + groupCellLength - 1;
                                if (visibleColumnIndex > endGroupIndex) {
                                    visibleIndex = visibleColumnIndex - groupCellLength + 1
                                } else {
                                    cellIsInsideGroup = true
                                }
                            }
                        }
                        const $cellElement = !cellIsInsideGroup ? $rowCells.eq(visibleIndex) : void 0;
                        return $cellElement
                    };
                    _proto._hideVisibleCellInView = function(_ref4) {
                        let {
                            $cell: $cell,
                            isCommandColumn: isCommandColumn
                        } = _ref4;
                        const cssClassNameToAdd = isCommandColumn ? "dx-command-adaptive-hidden" : this.addWidgetPrefix("hidden-column");
                        $cell.attr({
                            tabIndex: -1,
                            "aria-hidden": true
                        }).addClass(cssClassNameToAdd)
                    };
                    _proto._getEditMode = function() {
                        return this._editingController.getEditMode()
                    };
                    _proto.isFormOrPopupEditMode = function() {
                        const editMode = this._getEditMode();
                        return "form" === editMode || "popup" === editMode
                    };
                    _proto.hideRedundantColumns = function(resultWidths, visibleColumns, hiddenQueue) {
                        const that = this;
                        this._hiddenColumns = [];
                        if (that._isVisibleColumnsValid(visibleColumns) && hiddenQueue.length) {
                            let totalWidth = 0;
                            const $rootElement = that.component.$element();
                            let rootElementWidth = (0, _size.getWidth)($rootElement) - that._getCommandColumnsWidth();
                            const getVisibleContentColumns = function() {
                                return visibleColumns.filter(item => !item.command && 0 === this._hiddenColumns.filter(i => i.index === item.index).length)
                            }.bind(this);
                            let visibleContentColumns = getVisibleContentColumns();
                            const contentColumnsCount = visibleContentColumns.length;
                            let i;
                            let hasHiddenColumns;
                            let needHideColumn;
                            do {
                                needHideColumn = false;
                                totalWidth = 0;
                                const percentWidths = that._calculatePercentWidths(resultWidths, visibleColumns);
                                const columnsCanFit = percentWidths < 100 && 0 !== percentWidths;
                                for (i = 0; i < visibleColumns.length; i++) {
                                    const visibleColumn = visibleColumns[i];
                                    let columnWidth = that._getNotTruncatedColumnWidth(visibleColumn, rootElementWidth, visibleContentColumns, columnsCanFit);
                                    const columnId = getColumnId(that, visibleColumn);
                                    const widthOption = that._columnsController.columnOption(columnId, "width");
                                    const minWidth = that._columnsController.columnOption(columnId, "minWidth");
                                    const columnBestFitWidth = that._columnsController.columnOption(columnId, "bestFitWidth");
                                    if ("adaptiveHidden" === resultWidths[i]) {
                                        hasHiddenColumns = true;
                                        continue
                                    }
                                    if (!columnWidth && !visibleColumn.command && !visibleColumn.fixed) {
                                        needHideColumn = true;
                                        break
                                    }
                                    if (!widthOption || "auto" === widthOption) {
                                        columnWidth = Math.max(columnBestFitWidth || 0, minWidth || 0)
                                    }
                                    if ("adaptive" !== visibleColumn.command || hasHiddenColumns) {
                                        totalWidth += columnWidth
                                    }
                                }
                                needHideColumn = needHideColumn || totalWidth > (0, _size.getWidth)($rootElement);
                                if (needHideColumn) {
                                    const column = hiddenQueue.pop();
                                    const visibleIndex = that._columnsController.getVisibleIndex(column.index);
                                    rootElementWidth += that._calculateColumnWidth(column, rootElementWidth, visibleContentColumns, columnsCanFit);
                                    that._hideVisibleColumn({
                                        visibleIndex: visibleIndex
                                    });
                                    resultWidths[visibleIndex] = "adaptiveHidden";
                                    this._hiddenColumns.push(column);
                                    visibleContentColumns = getVisibleContentColumns()
                                }
                            } while (needHideColumn && visibleContentColumns.length > 1 && hiddenQueue.length);
                            if (contentColumnsCount === visibleContentColumns.length) {
                                that._hideAdaptiveColumn(resultWidths, visibleColumns)
                            }
                        } else {
                            that._hideAdaptiveColumn(resultWidths, visibleColumns)
                        }
                    };
                    _proto.getAdaptiveDetailItems = function() {
                        return this._$itemContents
                    };
                    _proto.getItemContentByColumnIndex = function(visibleColumnIndex) {
                        let $itemContent;
                        for (let i = 0; i < this._$itemContents.length; i++) {
                            $itemContent = this._$itemContents.eq(i);
                            const item = $itemContent.data("dx-form-item");
                            if (item && item.column && this._columnsController.getVisibleIndex(item.column.index) === visibleColumnIndex) {
                                return $itemContent
                            }
                        }
                    };
                    _proto.toggleExpandAdaptiveDetailRow = function(key, alwaysExpanded) {
                        if (!(this.isFormOrPopupEditMode() && this._editingController.isEditing())) {
                            this._dataController.toggleExpandAdaptiveDetailRow(key, alwaysExpanded)
                        }
                    };
                    _proto.createFormByHiddenColumns = function(container, options) {
                        const that = this;
                        const $container = (0, _renderer.default)(container);
                        const userFormOptions = {
                            items: that._getFormItemsByHiddenColumns(that._hiddenColumns),
                            formID: "dx-".concat(new _guid.default)
                        };
                        const defaultFormOptions = (0, _themes.isMaterial)() ? {
                            colCount: 2
                        } : {};
                        this.executeAction("onAdaptiveDetailRowPreparing", {
                            formOptions: userFormOptions
                        });
                        that._$itemContents = null;
                        that._form = that._createComponent((0, _renderer.default)("<div>").appendTo($container), _form.default, (0, _extend.extend)(defaultFormOptions, userFormOptions, {
                            customizeItem(item) {
                                const column = item.column || that._columnsController.columnOption(item.name || item.dataField);
                                if (column) {
                                    item.label = item.label || {};
                                    item.label.text = item.label.text || column.caption;
                                    item.column = column;
                                    item.template = that._getTemplate(item, options, that.updateForm.bind(that))
                                }
                                userFormOptions.customizeItem && userFormOptions.customizeItem.call(this, item)
                            },
                            onContentReady(e) {
                                userFormOptions.onContentReady && userFormOptions.onContentReady.call(this, e);
                                that._$itemContents = $container.find(".".concat("dx-field-item-content"))
                            }
                        }))
                    };
                    _proto.hasAdaptiveDetailRowExpanded = function() {
                        return (0, _type.isDefined)(this._dataController.adaptiveExpandedKey())
                    };
                    _proto.updateForm = function(hiddenColumns) {
                        if (this.hasAdaptiveDetailRowExpanded()) {
                            if (this._form && (0, _type.isDefined)(this._form._contentReadyAction)) {
                                if (hiddenColumns && hiddenColumns.length) {
                                    this._form.option("items", this._getFormItemsByHiddenColumns(hiddenColumns))
                                } else {
                                    this._form.repaint()
                                }
                            }
                        }
                    };
                    _proto.updateHidingQueue = function(columns) {
                        const that = this;
                        const hideableColumns = columns.filter(column => column.visible && !column.type && !column.fixed && !((0, _type.isDefined)(column.groupIndex) && column.groupIndex >= 0));
                        let columnsHasHidingPriority;
                        let i;
                        that._hidingColumnsQueue = [];
                        if (that.option("allowColumnResizing") && "widget" === that.option("columnResizingMode")) {
                            return that._hidingColumnsQueue
                        }
                        for (i = 0; i < hideableColumns.length; i++) {
                            if ((0, _type.isDefined)(hideableColumns[i].hidingPriority) && hideableColumns[i].hidingPriority >= 0) {
                                columnsHasHidingPriority = true;
                                that._hidingColumnsQueue[hideableColumns[i].hidingPriority] = hideableColumns[i]
                            }
                        }
                        if (columnsHasHidingPriority) {
                            that._hidingColumnsQueue.reverse()
                        } else if (that.option("columnHidingEnabled")) {
                            for (i = 0; i < hideableColumns.length; i++) {
                                const visibleIndex = that._columnsController.getVisibleIndex(hideableColumns[i].index);
                                that._hidingColumnsQueue[visibleIndex] = hideableColumns[i]
                            }
                        }
                        that._hidingColumnsQueue = that._hidingColumnsQueue.filter(Object);
                        return that._hidingColumnsQueue
                    };
                    _proto.getHiddenColumns = function() {
                        return this._hiddenColumns
                    };
                    _proto.hasHiddenColumns = function() {
                        return this._hiddenColumns.length > 0
                    };
                    _proto.getHidingColumnsQueue = function() {
                        return this._hidingColumnsQueue
                    };
                    _proto.isAdaptiveDetailRowExpanded = function(key) {
                        const dataController = this._dataController;
                        return dataController.adaptiveExpandedKey() && (0, _common.equalByValue)(dataController.adaptiveExpandedKey(), key)
                    };
                    _proto.expandAdaptiveDetailRow = function(key) {
                        if (!this.hasAdaptiveDetailRowExpanded()) {
                            this.toggleExpandAdaptiveDetailRow(key)
                        }
                    };
                    _proto.collapseAdaptiveDetailRow = function() {
                        if (this.hasAdaptiveDetailRowExpanded()) {
                            this.toggleExpandAdaptiveDetailRow()
                        }
                    };
                    _proto.updateCommandAdaptiveAriaLabel = function(key, label) {
                        const rowIndex = this._dataController.getRowIndexByKey(key);
                        if (-1 === rowIndex) {
                            return
                        }
                        const $row = (0, _renderer.default)(this.component.getRowElement(rowIndex));
                        this.setCommandAdaptiveAriaLabel($row, label)
                    };
                    _proto.setCommandAdaptiveAriaLabel = function($row, labelName) {
                        const $adaptiveCommand = $row.find(".dx-command-adaptive");
                        $adaptiveCommand.attr("aria-label", _message.default.format(labelName))
                    };
                    return AdaptiveColumnsController
                }(_m_modules.default.ViewController);
                exports.AdaptiveColumnsController = AdaptiveColumnsController;
                const adaptivityModule = {
                    defaultOptions: () => ({
                        columnHidingEnabled: false,
                        onAdaptiveDetailRowPreparing: null
                    }),
                    controllers: {
                        adaptiveColumns: AdaptiveColumnsController
                    },
                    extenders: {
                        views: {
                            rowsView: Base => function(_Base2) {
                                _inheritsLoose(AdaptivityRowsViewExtender, _Base2);

                                function AdaptivityRowsViewExtender() {
                                    return _Base2.apply(this, arguments) || this
                                }
                                var _proto3 = AdaptivityRowsViewExtender.prototype;
                                _proto3._getCellTemplate = function(options) {
                                    const that = this;
                                    const {
                                        column: column
                                    } = options;
                                    if ("detailAdaptive" === options.rowType && "detail" === column.command) {
                                        return function(container, options) {
                                            that._adaptiveColumnsController.createFormByHiddenColumns((0, _renderer.default)(container), options)
                                        }
                                    }
                                    return _Base2.prototype._getCellTemplate.call(this, options)
                                };
                                _proto3._createRow = function(row) {
                                    const $row = _Base2.prototype._createRow.apply(this, arguments);
                                    if (row && "detailAdaptive" === row.rowType && row.key === this._dataController.adaptiveExpandedKey()) {
                                        $row.addClass("dx-adaptive-detail-row")
                                    }
                                    return $row
                                };
                                _proto3._renderCells = function($row, options) {
                                    _Base2.prototype._renderCells.call(this, $row, options);
                                    const adaptiveColumnsController = this._adaptiveColumnsController;
                                    const hidingColumnsQueueLength = adaptiveColumnsController.getHidingColumnsQueue().length;
                                    const hiddenColumnsLength = adaptiveColumnsController.getHiddenColumns().length;
                                    if (hidingColumnsQueueLength && !hiddenColumnsLength) {
                                        (function($row) {
                                            return $row.find("td:not(.dx-datagrid-hidden-column):not([class*='dx-command-'])")
                                        })($row).last().addClass("dx-last-data-cell")
                                    }
                                    if ("data" === options.row.rowType) {
                                        adaptiveColumnsController.setCommandAdaptiveAriaLabel($row, "dxDataGrid-ariaAdaptiveExpand")
                                    }
                                };
                                _proto3._getColumnIndexByElementCore = function($element) {
                                    const $itemContent = $element.closest(".".concat("dx-field-item-content"));
                                    if ($itemContent.length && $itemContent.closest(this.component.$element()).length) {
                                        const formItem = $itemContent.length ? $itemContent.first().data("dx-form-item") : null;
                                        return formItem && formItem.column && this._columnsController.getVisibleIndex(formItem.column.index)
                                    }
                                    return _Base2.prototype._getColumnIndexByElementCore.call(this, $element)
                                };
                                _proto3._cellPrepared = function($cell, options) {
                                    _Base2.prototype._cellPrepared.apply(this, arguments);
                                    if ("detailAdaptive" !== options.row.rowType && "adaptiveHidden" === options.column.visibleWidth) {
                                        $cell.addClass(this.addWidgetPrefix("hidden-column"))
                                    }
                                };
                                _proto3.getCell = function(cellPosition, rows) {
                                    const item = this._dataController.items()[null === cellPosition || void 0 === cellPosition ? void 0 : cellPosition.rowIndex];
                                    if ("detailAdaptive" === (null === item || void 0 === item ? void 0 : item.rowType)) {
                                        const $adaptiveDetailItems = this._adaptiveColumnsController.getAdaptiveDetailItems();
                                        return _Base2.prototype.getCell.call(this, cellPosition, rows, $adaptiveDetailItems)
                                    }
                                    return _Base2.prototype.getCell.apply(this, arguments)
                                };
                                _proto3._getCellElement = function(rowIndex, columnIdentifier) {
                                    const item = this._dataController.items()[rowIndex];
                                    if (item && "detailAdaptive" === item.rowType) {
                                        return this._adaptiveColumnsController.getItemContentByColumnIndex(columnIdentifier)
                                    }
                                    return _Base2.prototype._getCellElement.apply(this, arguments)
                                };
                                _proto3.getContextMenuItems = function(options) {
                                    var _a;
                                    if (options.row && "detailAdaptive" === options.row.rowType) {
                                        const view = this._columnHeadersView;
                                        const formItem = (0, _renderer.default)(options.targetElement).closest(".dx-field-item-label").next().data("dx-form-item");
                                        options.column = formItem ? formItem.column : options.column;
                                        return view.getContextMenuItems && view.getContextMenuItems(options)
                                    }
                                    return null === (_a = _Base2.prototype.getContextMenuItems) || void 0 === _a ? void 0 : _a.call(this, options)
                                };
                                _proto3.isClickableElement = function($target) {
                                    var _a, _b;
                                    const isClickable = null !== (_b = null === (_a = _Base2.prototype.isClickableElement) || void 0 === _a ? void 0 : _a.call(this, $target)) && void 0 !== _b ? _b : false;
                                    return isClickable || !!$target.closest(".".concat("dx-command-adaptive")).length
                                };
                                return AdaptivityRowsViewExtender
                            }(Base)
                        },
                        controllers: {
                            export: Base => function(_Base3) {
                                _inheritsLoose(AdaptivityExportExtender, _Base3);

                                function AdaptivityExportExtender() {
                                    return _Base3.apply(this, arguments) || this
                                }
                                var _proto4 = AdaptivityExportExtender.prototype;
                                _proto4._updateColumnWidth = function(column, width) {
                                    _Base3.prototype._updateColumnWidth.call(this, column, "adaptiveHidden" === column.visibleWidth ? column.bestFitWidth : width)
                                };
                                return AdaptivityExportExtender
                            }(Base),
                            columnsResizer: Base => function(_Base4) {
                                _inheritsLoose(AdaptivityColumnsResizerExtender, _Base4);

                                function AdaptivityColumnsResizerExtender() {
                                    return _Base4.apply(this, arguments) || this
                                }
                                var _proto5 = AdaptivityColumnsResizerExtender.prototype;
                                _proto5._pointCreated = function(point, cellsLength, columns) {
                                    const result = _Base4.prototype._pointCreated.call(this, point, cellsLength, columns);
                                    const currentColumn = columns[point.columnIndex] || {};
                                    const nextColumnIndex = this._getNextColumnIndex(point.columnIndex);
                                    const nextColumn = columns[nextColumnIndex] || {};
                                    const hasHiddenColumnsOnly = nextColumnIndex !== point.columnIndex + 1 && nextColumn.command;
                                    const hasAdaptiveHiddenWidth = "adaptiveHidden" === currentColumn.visibleWidth || hasHiddenColumnsOnly;
                                    return result || hasAdaptiveHiddenWidth
                                };
                                _proto5._getNextColumnIndex = function(currentColumnIndex) {
                                    const visibleColumns = this._columnsController.getVisibleColumns();
                                    let index = _Base4.prototype._getNextColumnIndex.call(this, currentColumnIndex);
                                    while (visibleColumns[index] && "adaptiveHidden" === visibleColumns[index].visibleWidth) {
                                        index++
                                    }
                                    return index
                                };
                                return AdaptivityColumnsResizerExtender
                            }(Base),
                            draggingHeader: Base => function(_Base5) {
                                _inheritsLoose(AdaptivityDraggingHeaderExtender, _Base5);

                                function AdaptivityDraggingHeaderExtender() {
                                    return _Base5.apply(this, arguments) || this
                                }
                                var _proto6 = AdaptivityDraggingHeaderExtender.prototype;
                                _proto6._pointCreated = function(point, columns, location, sourceColumn) {
                                    const result = _Base5.prototype._pointCreated.call(this, point, columns, location, sourceColumn);
                                    const column = columns[point.columnIndex - 1] || {};
                                    const hasAdaptiveHiddenWidth = "adaptiveHidden" === column.visibleWidth;
                                    return result || hasAdaptiveHiddenWidth
                                };
                                return AdaptivityDraggingHeaderExtender
                            }(Base),
                            editing: Base => function(_Base6) {
                                _inheritsLoose(AdaptivityEditingExtender, _Base6);

                                function AdaptivityEditingExtender() {
                                    return _Base6.apply(this, arguments) || this
                                }
                                var _proto7 = AdaptivityEditingExtender.prototype;
                                _proto7._isRowEditMode = function() {
                                    return "row" === this.getEditMode()
                                };
                                _proto7._getFormEditItemTemplate = function(cellOptions, column) {
                                    if ("row" !== this.getEditMode() && "detailAdaptive" === cellOptions.rowType) {
                                        cellOptions.columnIndex = this._columnsController.getVisibleIndex(column.index);
                                        return this.getColumnTemplate(cellOptions)
                                    }
                                    return _Base6.prototype._getFormEditItemTemplate.call(this, cellOptions, column)
                                };
                                _proto7._closeEditItem = function($targetElement) {
                                    const $itemContents = $targetElement.closest(".".concat("dx-field-item-content"));
                                    const rowIndex = this._dataController.getRowIndexByKey(this._dataController.adaptiveExpandedKey()) + 1;
                                    const formItem = $itemContents.length ? $itemContents.first().data("dx-form-item") : null;
                                    const columnIndex = formItem && formItem.column && this._columnsController.getVisibleIndex(formItem.column.index);
                                    if (!this.isEditCell(rowIndex, columnIndex)) {
                                        _Base6.prototype._closeEditItem.call(this, $targetElement)
                                    }
                                };
                                _proto7._beforeUpdateItems = function(rowIndices, rowIndex) {
                                    if (!this._adaptiveColumnsController.isFormOrPopupEditMode() && this._adaptiveColumnsController.hasHiddenColumns()) {
                                        const items = this._dataController.items();
                                        const item = items[rowIndex];
                                        const oldExpandRowIndex = _m_utils.default.getIndexByKey(this._dataController.adaptiveExpandedKey(), items);
                                        this._isForceRowAdaptiveExpand = !this._adaptiveColumnsController.hasAdaptiveDetailRowExpanded();
                                        if (oldExpandRowIndex >= 0) {
                                            rowIndices.push(oldExpandRowIndex + 1)
                                        }
                                        rowIndices.push(rowIndex + 1);
                                        this._dataController.adaptiveExpandedKey(item.key)
                                    }
                                };
                                _proto7._afterInsertRow = function(key) {
                                    _Base6.prototype._afterInsertRow.apply(this, arguments);
                                    if (this._adaptiveColumnsController.hasHiddenColumns()) {
                                        this._adaptiveColumnsController.toggleExpandAdaptiveDetailRow(key, this.isRowEditMode());
                                        this._isForceRowAdaptiveExpand = true
                                    }
                                };
                                _proto7._collapseAdaptiveDetailRow = function() {
                                    if (this._isRowEditMode() && this._isForceRowAdaptiveExpand) {
                                        this._adaptiveColumnsController.collapseAdaptiveDetailRow();
                                        this._isForceRowAdaptiveExpand = false
                                    }
                                };
                                _proto7._cancelEditAdaptiveDetailRow = function() {
                                    if (this._adaptiveColumnsController.hasHiddenColumns()) {
                                        this._collapseAdaptiveDetailRow()
                                    }
                                };
                                _proto7._afterSaveEditData = function() {
                                    _Base6.prototype._afterSaveEditData.apply(this, arguments);
                                    const deferred = new _deferred.Deferred;
                                    if (this._isRowEditMode() && this._adaptiveColumnsController.hasHiddenColumns()) {
                                        (0, _deferred.when)(this._validatingController.validate(true)).done(isValid => {
                                            if (isValid) {
                                                this._cancelEditAdaptiveDetailRow()
                                            }
                                            deferred.resolve()
                                        })
                                    } else {
                                        deferred.resolve()
                                    }
                                    return deferred.promise()
                                };
                                _proto7._beforeCancelEditData = function() {
                                    _Base6.prototype._beforeCancelEditData.call(this);
                                    this._cancelEditAdaptiveDetailRow()
                                };
                                _proto7._getRowIndicesForCascadeUpdating = function(row) {
                                    const rowIndices = _Base6.prototype._getRowIndicesForCascadeUpdating.apply(this, arguments);
                                    if (this._adaptiveColumnsController.isAdaptiveDetailRowExpanded(row.key)) {
                                        rowIndices.push("detailAdaptive" === row.rowType ? row.rowIndex - 1 : row.rowIndex + 1)
                                    }
                                    return rowIndices
                                };
                                _proto7._beforeCloseEditCellInBatchMode = function(rowIndices) {
                                    const expandedKey = this._dataController._adaptiveExpandedKey;
                                    if (expandedKey) {
                                        const rowIndex = _m_utils.default.getIndexByKey(expandedKey, this._dataController.items());
                                        if (rowIndex > -1) {
                                            rowIndices.unshift(rowIndex)
                                        }
                                    }
                                };
                                _proto7.editRow = function(rowIndex) {
                                    if (this._adaptiveColumnsController.isFormOrPopupEditMode()) {
                                        this._adaptiveColumnsController.collapseAdaptiveDetailRow()
                                    }
                                    return _Base6.prototype.editRow.call(this, rowIndex)
                                };
                                _proto7.deleteRow = function(rowIndex) {
                                    const rowKey = this._dataController.getKeyByRowIndex(rowIndex);
                                    if ("batch" === this.getEditMode() && this._adaptiveColumnsController.isAdaptiveDetailRowExpanded(rowKey)) {
                                        this._adaptiveColumnsController.collapseAdaptiveDetailRow()
                                    }
                                    _Base6.prototype.deleteRow.call(this, rowIndex)
                                };
                                return AdaptivityEditingExtender
                            }(Base),
                            resizing: Base => function(_Base10) {
                                _inheritsLoose(AdaptivityResizingControllerExtender, _Base10);

                                function AdaptivityResizingControllerExtender() {
                                    return _Base10.apply(this, arguments) || this
                                }
                                var _proto11 = AdaptivityResizingControllerExtender.prototype;
                                _proto11.dispose = function() {
                                    _Base10.prototype.dispose.apply(this, arguments);
                                    clearTimeout(this._updateScrollableTimeoutID)
                                };
                                _proto11._needBestFit = function() {
                                    return _Base10.prototype._needBestFit.call(this) || !!this._adaptiveColumnsController.getHidingColumnsQueue().length
                                };
                                _proto11._correctColumnWidths = function(resultWidths, visibleColumns) {
                                    const adaptiveController = this._adaptiveColumnsController;
                                    const oldHiddenColumns = adaptiveController.getHiddenColumns();
                                    const hidingColumnsQueue = adaptiveController.updateHidingQueue(this._columnsController.getColumns());
                                    adaptiveController.hideRedundantColumns(resultWidths, visibleColumns, hidingColumnsQueue);
                                    const hiddenColumns = adaptiveController.getHiddenColumns();
                                    if (adaptiveController.hasAdaptiveDetailRowExpanded()) {
                                        if (oldHiddenColumns.length !== hiddenColumns.length) {
                                            adaptiveController.updateForm(hiddenColumns)
                                        }
                                    }!hiddenColumns.length && adaptiveController.collapseAdaptiveDetailRow();
                                    return _Base10.prototype._correctColumnWidths.apply(this, arguments)
                                };
                                _proto11._toggleBestFitMode = function(isBestFit) {
                                    isBestFit && this._adaptiveColumnsController._showHiddenColumns();
                                    _Base10.prototype._toggleBestFitMode.call(this, isBestFit)
                                };
                                _proto11._needStretch = function() {
                                    const adaptiveColumnsController = this._adaptiveColumnsController;
                                    return _Base10.prototype._needStretch.apply(this, arguments) || adaptiveColumnsController.getHidingColumnsQueue().length || adaptiveColumnsController.hasHiddenColumns()
                                };
                                return AdaptivityResizingControllerExtender
                            }(Base),
                            data: Base => function(_Base7) {
                                _inheritsLoose(AdaptivityDataControllerExtender, _Base7);

                                function AdaptivityDataControllerExtender() {
                                    return _Base7.apply(this, arguments) || this
                                }
                                var _proto8 = AdaptivityDataControllerExtender.prototype;
                                _proto8._processItems = function(items, change) {
                                    const {
                                        changeType: changeType
                                    } = change;
                                    items = _Base7.prototype._processItems.apply(this, arguments);
                                    if ("loadingAll" === changeType || !(0, _type.isDefined)(this._adaptiveExpandedKey)) {
                                        return items
                                    }
                                    const expandRowIndex = _m_utils.default.getIndexByKey(this._adaptiveExpandedKey, items);
                                    const newMode = false === this.option("scrolling.legacyMode");
                                    if (expandRowIndex >= 0) {
                                        const item = items[expandRowIndex];
                                        items.splice(expandRowIndex + 1, 0, {
                                            visible: true,
                                            rowType: "detailAdaptive",
                                            key: item.key,
                                            data: item.data,
                                            node: item.node,
                                            modifiedValues: item.modifiedValues,
                                            isNewRow: item.isNewRow,
                                            values: item.values
                                        })
                                    } else if ("refresh" === changeType && !(newMode && change.repaintChangesOnly)) {
                                        this._adaptiveExpandedKey = void 0
                                    }
                                    return items
                                };
                                _proto8._getRowIndicesForExpand = function(key) {
                                    const rowIndices = _Base7.prototype._getRowIndicesForExpand.apply(this, arguments);
                                    if (this._adaptiveColumnsController.isAdaptiveDetailRowExpanded(key)) {
                                        const lastRowIndex = rowIndices[rowIndices.length - 1];
                                        rowIndices.push(lastRowIndex + 1)
                                    }
                                    return rowIndices
                                };
                                _proto8.adaptiveExpandedKey = function(value) {
                                    if ((0, _type.isDefined)(value)) {
                                        this._adaptiveExpandedKey = value
                                    } else {
                                        return this._adaptiveExpandedKey
                                    }
                                };
                                _proto8.toggleExpandAdaptiveDetailRow = function(key, alwaysExpanded) {
                                    let oldExpandLoadedRowIndex = _m_utils.default.getIndexByKey(this._adaptiveExpandedKey, this._items);
                                    let newExpandLoadedRowIndex = _m_utils.default.getIndexByKey(key, this._items);
                                    if (oldExpandLoadedRowIndex >= 0 && oldExpandLoadedRowIndex === newExpandLoadedRowIndex && !alwaysExpanded) {
                                        key = void 0;
                                        newExpandLoadedRowIndex = -1
                                    }
                                    const oldKey = this._adaptiveExpandedKey;
                                    this._adaptiveExpandedKey = key;
                                    if (oldExpandLoadedRowIndex >= 0) {
                                        oldExpandLoadedRowIndex++
                                    }
                                    if (newExpandLoadedRowIndex >= 0) {
                                        newExpandLoadedRowIndex++
                                    }
                                    const rowIndexDelta = this.getRowIndexDelta();
                                    this.updateItems({
                                        allowInvisibleRowIndices: true,
                                        changeType: "update",
                                        rowIndices: [oldExpandLoadedRowIndex - rowIndexDelta, newExpandLoadedRowIndex - rowIndexDelta]
                                    });
                                    this._adaptiveColumnsController.updateCommandAdaptiveAriaLabel(key, "dxDataGrid-ariaAdaptiveCollapse");
                                    this._adaptiveColumnsController.updateCommandAdaptiveAriaLabel(oldKey, "dxDataGrid-ariaAdaptiveExpand")
                                };
                                return AdaptivityDataControllerExtender
                            }(Base),
                            editorFactory: Base => function(_Base8) {
                                _inheritsLoose(AdaptivityEditorFactoryExtender, _Base8);

                                function AdaptivityEditorFactoryExtender() {
                                    return _Base8.apply(this, arguments) || this
                                }
                                var _proto9 = AdaptivityEditorFactoryExtender.prototype;
                                _proto9._needHideBorder = function($element) {
                                    return _Base8.prototype._needHideBorder.call(this, $element) || (null === $element || void 0 === $element ? void 0 : $element.hasClass("dx-field-item-content")) && (null === $element || void 0 === $element ? void 0 : $element.find(".dx-checkbox").length)
                                };
                                _proto9._getFocusCellSelector = function() {
                                    return "".concat(_Base8.prototype._getFocusCellSelector.call(this), ", .dx-adaptive-detail-row .dx-field-item > .dx-field-item-content")
                                };
                                _proto9._getRevertTooltipsSelector = function() {
                                    return "".concat(_Base8.prototype._getRevertTooltipsSelector.call(this), ", .dx-field-item-content .").concat(this.addWidgetPrefix("revert-tooltip"))
                                };
                                return AdaptivityEditorFactoryExtender
                            }(Base),
                            columns: Base => function(_Base9) {
                                _inheritsLoose(AdaptivityColumnsExtender, _Base9);

                                function AdaptivityColumnsExtender() {
                                    return _Base9.apply(this, arguments) || this
                                }
                                var _proto10 = AdaptivityColumnsExtender.prototype;
                                _proto10._isColumnVisible = function(column) {
                                    return _Base9.prototype._isColumnVisible.call(this, column) && !column.adaptiveHidden
                                };
                                return AdaptivityColumnsExtender
                            }(Base),
                            keyboardNavigation: Base => function(_Base) {
                                _inheritsLoose(AdaptivityKeyboardNavigationExtender, _Base);

                                function AdaptivityKeyboardNavigationExtender() {
                                    return _Base.apply(this, arguments) || this
                                }
                                var _proto2 = AdaptivityKeyboardNavigationExtender.prototype;
                                _proto2._isCellValid = function($cell, isClick) {
                                    return _Base.prototype._isCellValid.call(this, $cell, isClick) && !$cell.hasClass(this.addWidgetPrefix("hidden-column")) && !$cell.hasClass("dx-command-adaptive-hidden")
                                };
                                _proto2._processNextCellInMasterDetail = function($nextCell, $cell) {
                                    _Base.prototype._processNextCellInMasterDetail.call(this, $nextCell, $cell);
                                    const isCellOrBatchMode = this._editingController.isCellOrBatchEditMode();
                                    const isEditing = this._editingController.isEditing();
                                    if (isEditing && $nextCell && isCellOrBatchMode && !this._isInsideEditForm($nextCell)) {
                                        _events_engine.default.off($nextCell, "focus", focusCellHandler);
                                        _events_engine.default.on($nextCell, "focus", {
                                            $nextCell: $nextCell
                                        }, focusCellHandler);
                                        _events_engine.default.trigger($cell, "focus")
                                    }
                                };
                                _proto2._isCellElement = function($cell) {
                                    return _Base.prototype._isCellElement.call(this, $cell) || $cell.hasClass("dx-adaptive-item-text")
                                };
                                return AdaptivityKeyboardNavigationExtender
                            }(Base)
                        }
                    }
                };
                exports.adaptivityModule = adaptivityModule
            },
        71184:
            /*!***********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/column_chooser/m_column_chooser.js ***!
              \***********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnChooserModule = exports.ColumnChooserView = exports.ColumnChooserController = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../../core/devices */ 20530));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _button = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/button */ 63008));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/popup/ui.popup */ 51495));
                var _themes = __webpack_require__( /*! ../../../../ui/themes */ 75811);
                var _tree_view = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/tree_view */ 30254));
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_columns_view = __webpack_require__( /*! ../views/m_columns_view */ 57318);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _inheritsLoose(subClass, superClass) {
                    subClass.prototype = Object.create(superClass.prototype);
                    subClass.prototype.constructor = subClass;
                    _setPrototypeOf(subClass, superClass)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const COLUMN_OPTIONS_USED_IN_ITEMS = ["showInColumnChooser", "caption", "allowHiding", "visible", "cssClass", "ownerBand"];
                let ColumnChooserController = function(_modules$ViewControll) {
                    _inheritsLoose(ColumnChooserController, _modules$ViewControll);

                    function ColumnChooserController() {
                        return _modules$ViewControll.apply(this, arguments) || this
                    }
                    var _proto = ColumnChooserController.prototype;
                    _proto.init = function() {
                        _modules$ViewControll.prototype.init.call(this);
                        this._rowsView = this.getView("rowsView")
                    };
                    _proto.renderShowColumnChooserButton = function($element) {
                        const that = this;
                        const columnChooserButtonClass = that.addWidgetPrefix("column-chooser-button");
                        const columnChooserEnabled = that.option("columnChooser.enabled");
                        const $showColumnChooserButton = $element.find(".".concat(columnChooserButtonClass));
                        let $columnChooserButton;
                        if (columnChooserEnabled) {
                            if (!$showColumnChooserButton.length) {
                                $columnChooserButton = (0, _renderer.default)("<div>").addClass(columnChooserButtonClass).appendTo($element);
                                that._createComponent($columnChooserButton, _button.default, {
                                    icon: "column-chooser",
                                    onClick() {
                                        that.getView("columnChooserView").showColumnChooser()
                                    },
                                    hint: that.option("columnChooser.title"),
                                    integrationOptions: {}
                                })
                            } else {
                                $showColumnChooserButton.show()
                            }
                        } else {
                            $showColumnChooserButton.hide()
                        }
                    };
                    _proto.getPosition = function() {
                        const position = this.option("columnChooser.position");
                        return (0, _type.isDefined)(position) ? position : {
                            my: "right bottom",
                            at: "right bottom",
                            of: this._rowsView && this._rowsView.element(),
                            collision: "fit",
                            offset: "-2 -2",
                            boundaryOffset: "2 2"
                        }
                    };
                    return ColumnChooserController
                }(_m_modules.default.ViewController);
                exports.ColumnChooserController = ColumnChooserController;
                let ColumnChooserView = function(_ColumnsView) {
                    _inheritsLoose(ColumnChooserView, _ColumnsView);

                    function ColumnChooserView() {
                        return _ColumnsView.apply(this, arguments) || this
                    }
                    var _proto2 = ColumnChooserView.prototype;
                    _proto2.optionChanged = function(args) {
                        switch (args.name) {
                            case "columnChooser":
                                this._initializePopupContainer();
                                this.render(null, "full");
                                break;
                            default:
                                _ColumnsView.prototype.optionChanged.call(this, args)
                        }
                    };
                    _proto2.publicMethods = function() {
                        return ["showColumnChooser", "hideColumnChooser"]
                    };
                    _proto2._resizeCore = function() {};
                    _proto2._isWinDevice = function() {
                        return !!_devices.default.real().win
                    };
                    _proto2._initializePopupContainer = function() {
                        const that = this;
                        const columnChooserClass = that.addWidgetPrefix("column-chooser");
                        const $element = that.element().addClass(columnChooserClass);
                        const columnChooserOptions = that.option("columnChooser");
                        const popupPosition = this._columnChooserController.getPosition();
                        const themeName = (0, _themes.current)();
                        const isGenericTheme = (0, _themes.isGeneric)(themeName);
                        const isMaterial = (0, _themes.isMaterial)(themeName);
                        const dxPopupOptions = {
                            visible: false,
                            shading: false,
                            showCloseButton: false,
                            dragEnabled: true,
                            resizeEnabled: true,
                            wrapperAttr: {
                                class: columnChooserClass
                            },
                            toolbarItems: [{
                                text: columnChooserOptions.title,
                                toolbar: "top",
                                location: isGenericTheme || isMaterial ? "before" : "center"
                            }],
                            position: popupPosition,
                            width: columnChooserOptions.width,
                            height: columnChooserOptions.height,
                            rtlEnabled: that.option("rtlEnabled"),
                            onHidden() {
                                if (that._isWinDevice()) {
                                    (0, _renderer.default)("body").removeClass(that.addWidgetPrefix("notouch-action"))
                                }
                            },
                            container: columnChooserOptions.container
                        };
                        if (isGenericTheme || isMaterial) {
                            (0, _extend.extend)(dxPopupOptions, {
                                showCloseButton: true
                            })
                        } else {
                            dxPopupOptions.toolbarItems[dxPopupOptions.toolbarItems.length] = {
                                shortcut: "cancel"
                            }
                        }
                        if (!(0, _type.isDefined)(this._popupContainer)) {
                            that._popupContainer = that._createComponent($element, _ui.default, dxPopupOptions);
                            that._popupContainer.on("optionChanged", args => {
                                if ("visible" === args.name) {
                                    that.renderCompleted.fire()
                                }
                            })
                        } else {
                            this._popupContainer.option(dxPopupOptions)
                        }
                        this.setPopupAttributes()
                    };
                    _proto2.setPopupAttributes = function() {
                        const isSelectMode = this.isSelectMode();
                        const isBandColumnsUsed = this._columnsController.isBandColumnsUsed();
                        this._popupContainer.setAria({
                            role: "dialog",
                            label: _message.default.format("dxDataGrid-columnChooserTitle")
                        });
                        this._popupContainer.$wrapper().toggleClass(this.addWidgetPrefix("column-chooser-mode-drag"), !isSelectMode).toggleClass(this.addWidgetPrefix("column-chooser-mode-select"), isSelectMode);
                        this._popupContainer.$content().addClass(this.addWidgetPrefix("column-chooser-list"));
                        if (isSelectMode && !isBandColumnsUsed) {
                            this._popupContainer.$content().addClass(this.addWidgetPrefix("column-chooser-plain"))
                        }
                    };
                    _proto2._renderCore = function(change) {
                        if (this._popupContainer) {
                            const isDragMode = !this.isSelectMode();
                            if (!this._columnChooserList || "full" === change) {
                                this._renderTreeView()
                            } else if (isDragMode) {
                                this._updateItems()
                            }
                        }
                    };
                    _proto2._renderTreeView = function() {
                        var _a, _b, _c;
                        const that = this;
                        const $container = this._popupContainer.$content();
                        const columnChooser = this.option("columnChooser");
                        const isSelectMode = this.isSelectMode();
                        const searchEnabled = (0, _type.isDefined)(columnChooser.allowSearch) ? columnChooser.allowSearch : null === (_a = columnChooser.search) || void 0 === _a ? void 0 : _a.enabled;
                        const searchTimeout = (0, _type.isDefined)(columnChooser.searchTimeout) ? columnChooser.searchTimeout : null === (_b = columnChooser.search) || void 0 === _b ? void 0 : _b.timeout;
                        const treeViewConfig = {
                            dataStructure: "plain",
                            activeStateEnabled: true,
                            focusStateEnabled: true,
                            hoverStateEnabled: true,
                            itemTemplate: "item",
                            showCheckBoxesMode: "none",
                            rootValue: null,
                            searchEnabled: searchEnabled,
                            searchTimeout: searchTimeout,
                            searchEditorOptions: null === (_c = columnChooser.search) || void 0 === _c ? void 0 : _c.editorOptions
                        };
                        if (this._isWinDevice()) {
                            treeViewConfig.useNativeScrolling = false
                        }(0, _extend.extend)(treeViewConfig, isSelectMode ? this._prepareSelectModeConfig() : this._prepareDragModeConfig());
                        if (this._columnChooserList) {
                            if (!treeViewConfig.searchEnabled) {
                                treeViewConfig.searchValue = ""
                            }
                            this._columnChooserList.option(treeViewConfig);
                            this._updateItems()
                        } else {
                            this._columnChooserList = this._createComponent($container, _tree_view.default, treeViewConfig);
                            this._updateItems();
                            let scrollTop = 0;
                            this._columnChooserList.on("optionChanged", e => {
                                const scrollable = e.component.getScrollable();
                                scrollTop = scrollable.scrollTop()
                            });
                            this._columnChooserList.on("contentReady", e => {
                                (0, _common.deferUpdate)(() => {
                                    const scrollable = e.component.getScrollable();
                                    scrollable.scrollTo({
                                        y: scrollTop
                                    });
                                    that.renderCompleted.fire()
                                })
                            })
                        }
                    };
                    _proto2._prepareDragModeConfig = function() {
                        const columnChooserOptions = this.option("columnChooser");
                        return {
                            noDataText: columnChooserOptions.emptyPanelText,
                            activeStateEnabled: false,
                            focusStateEnabled: false,
                            hoverStateEnabled: false,
                            itemTemplate(data, index, item) {
                                (0, _renderer.default)(item).text(data.text).parent().addClass(data.cssClass).addClass("dx-column-chooser-item")
                            }
                        }
                    };
                    _proto2._prepareSelectModeConfig = function() {
                        var _a;
                        const that = this;
                        const selectionOptions = null !== (_a = this.option("columnChooser.selection")) && void 0 !== _a ? _a : {};
                        let isUpdatingSelection = false;
                        return {
                            selectByClick: selectionOptions.selectByClick,
                            selectNodesRecursive: selectionOptions.recursive,
                            showCheckBoxesMode: selectionOptions.allowSelectAll ? "selectAll" : "normal",
                            onSelectionChanged: e => {
                                if (isUpdatingSelection) {
                                    return
                                }
                                const nodes = (nodes => {
                                    const addNodesToArray = (nodes, flatNodesArray) => nodes.reduce((result, node) => {
                                        result.push(node);
                                        if (node.children.length) {
                                            addNodesToArray(node.children, result)
                                        }
                                        return result
                                    }, flatNodesArray);
                                    return addNodesToArray(nodes, [])
                                })(e.component.getNodes());
                                e.component.beginUpdate();
                                isUpdatingSelection = true;
                                ((e, nodes) => {
                                    nodes.filter(node => false === node.itemData.allowHiding).forEach(node => e.component.selectItem(node.key))
                                })(e, nodes);
                                e.component.endUpdate();
                                isUpdatingSelection = false;
                                that.component.beginUpdate();
                                this._isUpdatingColumnVisibility = true;
                                (nodes => {
                                    nodes.forEach(node => {
                                        const columnIndex = node.itemData.id;
                                        const isVisible = false !== node.selected;
                                        that._columnsController.columnOption(columnIndex, "visible", isVisible)
                                    })
                                })(nodes);
                                that.component.endUpdate();
                                this._isUpdatingColumnVisibility = false
                            }
                        }
                    };
                    _proto2._updateItems = function() {
                        const isSelectMode = this.isSelectMode();
                        const chooserColumns = this._columnsController.getChooserColumns(isSelectMode);
                        const items = function(that, chooserColumns) {
                            const items = [];
                            const isSelectMode = that.isSelectMode();
                            const isRecursive = that.option("columnChooser.selection.recursive");
                            if (chooserColumns.length) {
                                (0, _iterator.each)(chooserColumns, (index, column) => {
                                    const item = {
                                        text: column.caption,
                                        cssClass: column.cssClass,
                                        allowHiding: column.allowHiding,
                                        expanded: true,
                                        id: column.index,
                                        disabled: false === column.allowHiding,
                                        parentId: (0, _type.isDefined)(column.ownerBand) ? column.ownerBand : null
                                    };
                                    const isRecursiveWithColumns = isRecursive && column.hasColumns;
                                    if (isSelectMode && !isRecursiveWithColumns) {
                                        item.selected = column.visible
                                    }
                                    items.push(item)
                                })
                            }
                            return items
                        }(this, chooserColumns);
                        this._columnChooserList.option("items", items)
                    };
                    _proto2._updateItemsSelection = function(columnIndices) {
                        const changedColumns = null === columnIndices || void 0 === columnIndices ? void 0 : columnIndices.map(columnIndex => this._columnsController.columnOption(columnIndex));
                        this._columnChooserList.beginUpdate();
                        null === changedColumns || void 0 === changedColumns ? void 0 : changedColumns.forEach(_ref => {
                            let {
                                visible: visible,
                                index: index
                            } = _ref;
                            if (visible) {
                                this._columnChooserList.selectItem(index)
                            } else {
                                this._columnChooserList.unselectItem(index)
                            }
                        });
                        this._columnChooserList.endUpdate()
                    };
                    _proto2._columnOptionChanged = function(e) {
                        _ColumnsView.prototype._columnOptionChanged.call(this, e);
                        const isSelectMode = this.isSelectMode();
                        if (isSelectMode && this._columnChooserList && !this._isUpdatingColumnVisibility) {
                            const {
                                optionNames: optionNames
                            } = e;
                            const onlyVisibleChanged = optionNames.visible && 1 === optionNames.length;
                            const columnIndices = (0, _type.isDefined)(e.columnIndex) ? [e.columnIndex] : e.columnIndices;
                            const needUpdate = COLUMN_OPTIONS_USED_IN_ITEMS.some(optionName => optionNames[optionName]) || e.changeTypes.columns && optionNames.all;
                            if (needUpdate) {
                                this._updateItemsSelection(columnIndices);
                                if (!onlyVisibleChanged) {
                                    this._updateItems()
                                }
                            }
                        }
                    };
                    _proto2.getColumnElements = function() {
                        const result = [];
                        const isSelectMode = this.isSelectMode();
                        const chooserColumns = this._columnsController.getChooserColumns(isSelectMode);
                        const $content = this._popupContainer && this._popupContainer.$content();
                        const $nodes = $content && $content.find(".dx-treeview-node");
                        if ($nodes) {
                            chooserColumns.forEach(column => {
                                const $node = $nodes.filter("[data-item-id = '".concat(column.index, "']"));
                                const item = $node.length ? $node.children(".".concat("dx-column-chooser-item")).get(0) : null;
                                result.push(item)
                            })
                        }
                        return (0, _renderer.default)(result)
                    };
                    _proto2.getName = function() {
                        return "columnChooser"
                    };
                    _proto2.getColumns = function() {
                        return this._columnsController.getChooserColumns()
                    };
                    _proto2.allowDragging = function(column) {
                        const isParentColumnVisible = this._columnsController.isParentColumnVisible(column.index);
                        const isColumnHidden = !column.visible && column.allowHiding;
                        return this.isColumnChooserVisible() && isParentColumnVisible && isColumnHidden
                    };
                    _proto2.allowColumnHeaderDragging = function(column) {
                        const isDragMode = !this.isSelectMode();
                        return isDragMode && this.isColumnChooserVisible() && column.allowHiding
                    };
                    _proto2.getBoundingRect = function() {
                        const container = this._popupContainer && this._popupContainer.$overlayContent();
                        if (container && container.is(":visible")) {
                            const offset = container.offset();
                            return {
                                left: offset.left,
                                top: offset.top,
                                right: offset.left + (0, _size.getOuterWidth)(container),
                                bottom: offset.top + (0, _size.getOuterHeight)(container)
                            }
                        }
                        return null
                    };
                    _proto2.showColumnChooser = function() {
                        if (!this._popupContainer) {
                            this._initializePopupContainer();
                            this.render()
                        }
                        this._popupContainer.show();
                        if (this._isWinDevice()) {
                            (0, _renderer.default)("body").addClass(this.addWidgetPrefix("notouch-action"))
                        }
                    };
                    _proto2.hideColumnChooser = function() {
                        if (this._popupContainer) {
                            this._popupContainer.hide()
                        }
                    };
                    _proto2.isColumnChooserVisible = function() {
                        const popupContainer = this._popupContainer;
                        return popupContainer && popupContainer.option("visible")
                    };
                    _proto2.isSelectMode = function() {
                        return "select" === this.option("columnChooser.mode")
                    };
                    _proto2.hasHiddenColumns = function() {
                        const isEnabled = this.option("columnChooser.enabled");
                        const hiddenColumns = this.getColumns().filter(column => !column.visible);
                        return isEnabled && hiddenColumns.length
                    };
                    return ColumnChooserView
                }(_m_columns_view.ColumnsView);
                exports.ColumnChooserView = ColumnChooserView;
                const columnChooserModule = {
                    defaultOptions: () => ({
                        columnChooser: {
                            enabled: false,
                            search: {
                                enabled: false,
                                timeout: 500,
                                editorOptions: {}
                            },
                            selection: {
                                allowSelectAll: false,
                                selectByClick: false,
                                recursive: false
                            },
                            position: void 0,
                            mode: "dragAndDrop",
                            width: 250,
                            height: 260,
                            title: _message.default.format("dxDataGrid-columnChooserTitle"),
                            emptyPanelText: _message.default.format("dxDataGrid-columnChooserEmptyText"),
                            container: void 0
                        }
                    }),
                    controllers: {
                        columnChooser: ColumnChooserController
                    },
                    views: {
                        columnChooserView: ColumnChooserView
                    },
                    extenders: {
                        views: {
                            headerPanel: Base => function(_Base) {
                                _inheritsLoose(ColumnChooserHeaderPanelExtender, _Base);

                                function ColumnChooserHeaderPanelExtender() {
                                    return _Base.apply(this, arguments) || this
                                }
                                var _proto3 = ColumnChooserHeaderPanelExtender.prototype;
                                _proto3._getToolbarItems = function() {
                                    const items = _Base.prototype._getToolbarItems.call(this);
                                    return this._appendColumnChooserItem(items)
                                };
                                _proto3._appendColumnChooserItem = function(items) {
                                    const that = this;
                                    const columnChooserEnabled = that.option("columnChooser.enabled");
                                    if (columnChooserEnabled) {
                                        const onClickHandler = function() {
                                            that.component.getView("columnChooserView").showColumnChooser()
                                        };
                                        const onInitialized = function(e) {
                                            (0, _renderer.default)(e.element).addClass(that._getToolbarButtonClass(that.addWidgetPrefix("column-chooser-button")))
                                        };
                                        const hintText = that.option("columnChooser.title");
                                        const toolbarItem = {
                                            widget: "dxButton",
                                            options: {
                                                icon: "column-chooser",
                                                onClick: onClickHandler,
                                                hint: hintText,
                                                text: hintText,
                                                onInitialized: onInitialized,
                                                elementAttr: {
                                                    "aria-haspopup": "dialog"
                                                }
                                            },
                                            showText: "inMenu",
                                            location: "after",
                                            name: "columnChooserButton",
                                            locateInMenu: "auto",
                                            sortIndex: 40
                                        };
                                        items.push(toolbarItem)
                                    }
                                    return items
                                };
                                _proto3.optionChanged = function(args) {
                                    switch (args.name) {
                                        case "columnChooser":
                                            this._invalidate();
                                            args.handled = true;
                                            break;
                                        default:
                                            _Base.prototype.optionChanged.call(this, args)
                                    }
                                };
                                _proto3.isVisible = function() {
                                    const columnChooserEnabled = this.option("columnChooser.enabled");
                                    return _Base.prototype.isVisible.call(this) || columnChooserEnabled
                                };
                                return ColumnChooserHeaderPanelExtender
                            }(Base),
                            columnHeadersView: Base => function(_Base3) {
                                _inheritsLoose(ColumnChooserColumnHeadersExtender, _Base3);

                                function ColumnChooserColumnHeadersExtender() {
                                    return _Base3.apply(this, arguments) || this
                                }
                                var _proto5 = ColumnChooserColumnHeadersExtender.prototype;
                                _proto5.allowDragging = function(column) {
                                    const isDragMode = !this._columnChooserView.isSelectMode();
                                    const isColumnChooserVisible = this._columnChooserView.isColumnChooserVisible();
                                    return isDragMode && isColumnChooserVisible && column.allowHiding || _Base3.prototype.allowDragging.call(this, column)
                                };
                                return ColumnChooserColumnHeadersExtender
                            }(Base)
                        },
                        controllers: {
                            columns: Base => function(_Base2) {
                                _inheritsLoose(ColumnsChooserColumnsControllerExtender, _Base2);

                                function ColumnsChooserColumnsControllerExtender() {
                                    return _Base2.apply(this, arguments) || this
                                }
                                var _proto4 = ColumnsChooserColumnsControllerExtender.prototype;
                                _proto4.allowMoveColumn = function(fromVisibleIndex, toVisibleIndex, sourceLocation, targetLocation) {
                                    const isSelectMode = "select" === this.option("columnChooser.mode");
                                    const isMoveColumnDisallowed = isSelectMode && "columnChooser" === targetLocation;
                                    return isMoveColumnDisallowed ? false : _Base2.prototype.allowMoveColumn.call(this, fromVisibleIndex, toVisibleIndex, sourceLocation, targetLocation)
                                };
                                return ColumnsChooserColumnsControllerExtender
                            }(Base)
                        }
                    }
                };
                exports.columnChooserModule = columnChooserModule
            },
        53424:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/column_fixing/m_column_fixing.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnFixingModule = void 0;
                var _translator = __webpack_require__( /*! ../../../../animation/translator */ 31648);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/browser */ 47810));
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _position = __webpack_require__( /*! ../../../../core/utils/position */ 37518);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _style = __webpack_require__( /*! ../../../../core/utils/style */ 80968);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 55994));
                var _wheel = __webpack_require__( /*! ../../../../events/core/wheel */ 765);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/scroll_view/ui.scrollable */ 41183));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));
                var _m_columns_view = __webpack_require__( /*! ../views/m_columns_view */ 57318);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _inheritsLoose(subClass, superClass) {
                    subClass.prototype = Object.create(superClass.prototype);
                    subClass.prototype.constructor = subClass;
                    _setPrototypeOf(subClass, superClass)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const getTransparentColumnIndex = function(fixedColumns) {
                    let transparentColumnIndex = -1;
                    (0, _iterator.each)(fixedColumns, (index, column) => {
                        if ("transparent" === column.command) {
                            transparentColumnIndex = index;
                            return false
                        }
                        return
                    });
                    return transparentColumnIndex
                };
                const normalizeColumnWidths = function(fixedColumns, widths, fixedWidths) {
                    let fixedColumnIndex = 0;
                    if (fixedColumns && widths && fixedWidths) {
                        for (let i = 0; i < fixedColumns.length; i++) {
                            if ("transparent" === fixedColumns[i].command) {
                                fixedColumnIndex += fixedColumns[i].colspan
                            } else {
                                if (widths[fixedColumnIndex] < fixedWidths[i]) {
                                    widths[fixedColumnIndex] = fixedWidths[i]
                                }
                                fixedColumnIndex++
                            }
                        }
                    }
                    return widths
                };
                const baseFixedColumns = Base => function(_Base) {
                    _inheritsLoose(BaseFixedColumnsExtender, _Base);

                    function BaseFixedColumnsExtender() {
                        return _Base.apply(this, arguments) || this
                    }
                    var _proto = BaseFixedColumnsExtender.prototype;
                    _proto.init = function() {
                        _Base.prototype.init.call(this);
                        this._isFixedTableRendering = false;
                        this._isFixedColumns = false
                    };
                    _proto._createCol = function(column) {
                        return _Base.prototype._createCol.call(this, column).toggleClass("dx-col-fixed", !!(this._isFixedTableRendering && (column.fixed || column.command && "transparent" !== column.command)))
                    };
                    _proto._correctColumnIndicesForFixedColumns = function(fixedColumns, change) {
                        const transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                        const transparentColspan = fixedColumns[transparentColumnIndex].colspan;
                        const columnIndices = change && change.columnIndices;
                        if (columnIndices) {
                            change.columnIndices = columnIndices.map(columnIndices => {
                                if (columnIndices) {
                                    return columnIndices.map(columnIndex => {
                                        if (columnIndex < transparentColumnIndex) {
                                            return columnIndex
                                        }
                                        if (columnIndex >= transparentColumnIndex + transparentColspan) {
                                            return columnIndex - transparentColspan + 1
                                        }
                                        return -1
                                    }).filter(columnIndex => columnIndex >= 0)
                                }
                            })
                        }
                    };
                    _proto._partialUpdateFixedTable = function(fixedColumns) {
                        const fixedTableElement = this._fixedTableElement;
                        const $rows = this._getRowElementsCore(fixedTableElement);
                        const $colgroup = fixedTableElement.children("colgroup");
                        $colgroup.replaceWith(this._createColGroup(fixedColumns));
                        for (let i = 0; i < $rows.length; i++) {
                            this._partialUpdateFixedRow((0, _renderer.default)($rows[i]), fixedColumns)
                        }
                    };
                    _proto._partialUpdateFixedRow = function($row, fixedColumns) {
                        var _a;
                        const cellElements = $row.get(0).childNodes;
                        const transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                        const transparentColumn = fixedColumns[transparentColumnIndex];
                        const columnIndexOffset = this._columnsController.getColumnIndexOffset();
                        let groupCellOptions;
                        let colIndex = columnIndexOffset + 1;
                        let {
                            colspan: colspan
                        } = transparentColumn;
                        if ($row.hasClass("dx-master-detail-row")) {
                            cellElements[0].setAttribute("colspan", null === (_a = this._columnsController.getVisibleColumns()) || void 0 === _a ? void 0 : _a.length);
                            return
                        }
                        if ($row.hasClass("dx-group-row")) {
                            groupCellOptions = this._getGroupCellOptions({
                                row: $row.data("options"),
                                columns: this._columnsController.getVisibleColumns()
                            });
                            colspan = groupCellOptions.colspan - Math.max(0, cellElements.length - (groupCellOptions.columnIndex + 2))
                        }
                        for (let j = 0; j < cellElements.length; j++) {
                            const needUpdateColspan = groupCellOptions ? j === groupCellOptions.columnIndex + 1 : j === transparentColumnIndex;
                            cellElements[j].setAttribute("aria-colindex", colIndex);
                            if (needUpdateColspan) {
                                cellElements[j].setAttribute("colspan", colspan);
                                colIndex += colspan
                            } else {
                                colIndex++
                            }
                        }
                    };
                    _proto._renderTable = function(options) {
                        var _a;
                        let $fixedTable;
                        const fixedColumns = this.getFixedColumns();
                        this._isFixedColumns = !!fixedColumns.length;
                        const $table = _Base.prototype._renderTable.call(this, options);
                        if (this._isFixedColumns) {
                            const change = null === options || void 0 === options ? void 0 : options.change;
                            const $fixedDataRows = this._getRowElements(this._fixedTableElement);
                            const needPartialUpdate = (null === change || void 0 === change ? void 0 : change.virtualColumnsScrolling) && $fixedDataRows.length === (null === (_a = null === change || void 0 === change ? void 0 : change.items) || void 0 === _a ? void 0 : _a.length);
                            this._isFixedTableRendering = true;
                            if (needPartialUpdate && true !== this.option("scrolling.legacyMode")) {
                                this._partialUpdateFixedTable(fixedColumns);
                                this._isFixedTableRendering = false
                            } else {
                                const columnIndices = null === change || void 0 === change ? void 0 : change.columnIndices;
                                this._correctColumnIndicesForFixedColumns(fixedColumns, change);
                                $fixedTable = this._createTable(fixedColumns);
                                this._renderRows($fixedTable, (0, _extend.extend)({}, options, {
                                    columns: fixedColumns
                                }));
                                this._updateContent($fixedTable, change, true);
                                if (columnIndices) {
                                    change.columnIndices = columnIndices
                                }
                                this._isFixedTableRendering = false
                            }
                        } else {
                            this._fixedTableElement && this._fixedTableElement.parent().remove();
                            this._fixedTableElement = null
                        }
                        return $table
                    };
                    _proto._renderRow = function($table, options) {
                        let fixedCorrection;
                        let {
                            cells: cells
                        } = options.row;
                        _Base.prototype._renderRow.apply(this, arguments);
                        if (this._isFixedTableRendering && cells && cells.length) {
                            fixedCorrection = 0;
                            const fixedCells = options.row.cells || [];
                            cells = cells.slice();
                            options.row.cells = cells;
                            for (let i = 0; i < fixedCells.length; i++) {
                                if (fixedCells[i].column && "transparent" === fixedCells[i].column.command) {
                                    fixedCorrection = (fixedCells[i].column.colspan || 1) - 1;
                                    continue
                                }
                                cells[i + fixedCorrection] = fixedCells[i]
                            }
                        }
                    };
                    _proto._createCell = function(options) {
                        const that = this;
                        const {
                            column: column
                        } = options;
                        const columnCommand = column && column.command;
                        const {
                            rowType: rowType
                        } = options;
                        const $cell = _Base.prototype._createCell.apply(that, arguments);
                        let fixedColumns;
                        let prevFixedColumn;
                        let transparentColumnIndex;
                        if (that._isFixedTableRendering || "filter" === rowType) {
                            fixedColumns = that.getFixedColumns();
                            transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                            prevFixedColumn = fixedColumns[transparentColumnIndex - 1]
                        }
                        if (that._isFixedTableRendering) {
                            if ("transparent" === columnCommand) {
                                $cell.addClass("dx-pointer-events-none").toggleClass("dx-first-cell", 0 === transparentColumnIndex || prevFixedColumn && "expand" === prevFixedColumn.command).toggleClass("dx-last-cell", fixedColumns.length && transparentColumnIndex === fixedColumns.length - 1);
                                if ("freeSpace" !== rowType) {
                                    _m_utils.default.setEmptyText($cell)
                                }
                            }
                        } else if ("filter" === rowType) {
                            $cell.toggleClass("dx-first-cell", options.columnIndex === transparentColumnIndex)
                        }
                        const isRowAltStyle = that.option("rowAlternationEnabled") && options.isAltRow;
                        const isSelectAllCell = "multiple" === that.option("selection.mode") && 0 === options.columnIndex && "header" === options.rowType;
                        if (_browser.default.mozilla && options.column.fixed && "group" !== options.rowType && !isRowAltStyle && !isSelectAllCell) {
                            $cell.addClass("dx-col-fixed")
                        }
                        return $cell
                    };
                    _proto._getContent = function(isFixedTableRendering) {
                        var _a;
                        return isFixedTableRendering ? null === (_a = this._fixedTableElement) || void 0 === _a ? void 0 : _a.parent() : _Base.prototype._getContent.apply(this, arguments)
                    };
                    _proto._wrapTableInScrollContainer = function($table, isFixedTableRendering) {
                        const $scrollContainer = _Base.prototype._wrapTableInScrollContainer.apply(this, arguments);
                        if (this._isFixedTableRendering || isFixedTableRendering) {
                            $scrollContainer.addClass(this.addWidgetPrefix("content-fixed"))
                        }
                        return $scrollContainer
                    };
                    _proto._renderCellContent = function($cell, options) {
                        let isEmptyCell;
                        const {
                            column: column
                        } = options;
                        const isFixedTableRendering = this._isFixedTableRendering;
                        const isGroupCell = "group" === options.rowType && (0, _type.isDefined)(column.groupIndex);
                        if (isFixedTableRendering && isGroupCell && !column.command && !column.groupCellTemplate) {
                            $cell.css("pointerEvents", "none")
                        }
                        if (!isFixedTableRendering && this._isFixedColumns) {
                            isEmptyCell = column.fixed || column.command && false !== column.fixed;
                            if (isGroupCell) {
                                isEmptyCell = false;
                                if (options.row.summaryCells && options.row.summaryCells.length) {
                                    const columns = this._columnsController.getVisibleColumns();
                                    const alignByFixedColumnCellCount = this._getAlignByColumnCellCount ? this._getAlignByColumnCellCount(column.colspan, {
                                        columns: columns,
                                        row: options.row,
                                        isFixed: true
                                    }) : 0;
                                    if (alignByFixedColumnCellCount > 0) {
                                        const transparentColumnIndex = getTransparentColumnIndex(this._columnsController.getFixedColumns());
                                        isEmptyCell = columns.length - alignByFixedColumnCellCount < transparentColumnIndex
                                    }
                                }
                            }
                            if (isEmptyCell) {
                                if (column.command && "buttons" !== column.type || "group" === options.rowType) {
                                    $cell.html("&nbsp;").addClass(column.cssClass);
                                    return
                                }
                                $cell.addClass("dx-hidden-cell")
                            }
                        }
                        if ("transparent" !== column.command) {
                            _Base.prototype._renderCellContent.apply(this, arguments)
                        }
                    };
                    _proto._getCellElementsCore = function(rowIndex) {
                        const cellElements = _Base.prototype._getCellElementsCore.apply(this, arguments);
                        const isGroupRow = null === cellElements || void 0 === cellElements ? void 0 : cellElements.parent().hasClass("dx-group-row");
                        const headerRowIndex = "columnHeadersView" === this.name ? rowIndex : void 0;
                        if (this._fixedTableElement && cellElements) {
                            const fixedColumns = this.getFixedColumns(headerRowIndex);
                            const fixedCellElements = this._getRowElements(this._fixedTableElement).eq(rowIndex).children("td");
                            (0, _iterator.each)(fixedCellElements, (columnIndex, cell) => {
                                if (isGroupRow) {
                                    if (cellElements[columnIndex] && "hidden" !== cell.style.visibility) {
                                        cellElements[columnIndex] = cell
                                    }
                                } else {
                                    const fixedColumn = fixedColumns[columnIndex];
                                    if (fixedColumn) {
                                        if ("transparent" === fixedColumn.command) {
                                            if (fixedCellElements.eq(columnIndex).hasClass("dx-master-detail-cell")) {
                                                cellElements[columnIndex] = cell || cellElements[columnIndex]
                                            }
                                        } else {
                                            const fixedColumnIndex = this._columnsController.getVisibleIndexByColumn(fixedColumn, headerRowIndex);
                                            cellElements[fixedColumnIndex] = cell || cellElements[fixedColumnIndex]
                                        }
                                    }
                                }
                            })
                        }
                        return cellElements
                    };
                    _proto.getColumnWidths = function(fixedTableElement) {
                        const result = _Base.prototype.getColumnWidths.call(this);
                        const fixedColumns = this.getFixedColumns();
                        const fixedWidths = this._fixedTableElement && result.length ? _Base.prototype.getColumnWidths.call(this, this._fixedTableElement) : void 0;
                        return normalizeColumnWidths(fixedColumns, result, fixedWidths)
                    };
                    _proto.getTableElement = function(isFixedTableRendering) {
                        isFixedTableRendering = this._isFixedTableRendering || isFixedTableRendering;
                        const tableElement = isFixedTableRendering ? this._fixedTableElement : _Base.prototype.getTableElement.call(this);
                        return tableElement
                    };
                    _proto.setTableElement = function(tableElement, isFixedTableRendering) {
                        if (this._isFixedTableRendering || isFixedTableRendering) {
                            this._fixedTableElement = tableElement.addClass("dx-pointer-events-none")
                        } else {
                            _Base.prototype.setTableElement.call(this, tableElement)
                        }
                    };
                    _proto.getColumns = function(rowIndex) {
                        const $tableElement = this.getTableElement();
                        if (this._isFixedTableRendering) {
                            return this.getFixedColumns(rowIndex)
                        }
                        return _Base.prototype.getColumns.call(this, rowIndex, $tableElement)
                    };
                    _proto.getRowIndex = function($row) {
                        const $fixedTable = this._fixedTableElement;
                        if ($fixedTable && $fixedTable.find($row).length) {
                            return this._getRowElements($fixedTable).index($row)
                        }
                        return _Base.prototype.getRowIndex.call(this, $row)
                    };
                    _proto.getTableElements = function() {
                        let result = _Base.prototype.getTableElements.apply(this, arguments);
                        if (this._fixedTableElement) {
                            result = (0, _renderer.default)([result.get(0), this._fixedTableElement.get(0)])
                        }
                        return result
                    };
                    _proto.getFixedColumns = function(rowIndex) {
                        return this._columnsController.getFixedColumns(rowIndex)
                    };
                    _proto.getFixedColumnsOffset = function() {
                        let offset = {
                            left: 0,
                            right: 0
                        };
                        let $transparentColumn;
                        if (this._fixedTableElement) {
                            $transparentColumn = this.getTransparentColumnElement();
                            const positionTransparentColumn = $transparentColumn.position();
                            offset = {
                                left: positionTransparentColumn.left,
                                right: (0, _size.getOuterWidth)(this.element(), true) - ((0, _size.getOuterWidth)($transparentColumn, true) + positionTransparentColumn.left)
                            }
                        }
                        return offset
                    };
                    _proto.getTransparentColumnElement = function() {
                        return this._fixedTableElement && this._fixedTableElement.find(".".concat("dx-pointer-events-none")).first()
                    };
                    _proto.getFixedTableElement = function() {
                        return this._fixedTableElement
                    };
                    _proto.isFixedColumns = function() {
                        return this._isFixedColumns
                    };
                    _proto._resizeCore = function() {
                        _Base.prototype._resizeCore.call(this);
                        this.synchronizeRows()
                    };
                    _proto.setColumnWidths = function(options) {
                        var _a;
                        const {
                            widths: widths
                        } = options;
                        const visibleColumns = this._columnsController.getVisibleColumns();
                        const isColumnWidthsSynced = (null === widths || void 0 === widths ? void 0 : widths.length) && visibleColumns.some(column => (0, _type.isDefined)(column.visibleWidth));
                        const isColumnWidthChanged = null === (_a = options.optionNames) || void 0 === _a ? void 0 : _a.width;
                        _Base.prototype.setColumnWidths.call(this, options);
                        if (this._fixedTableElement) {
                            const hasAutoWidth = null === widths || void 0 === widths ? void 0 : widths.some(width => "auto" === width || !(0, _type.isDefined)(width));
                            const needVisibleColumns = hasAutoWidth && (!isColumnWidthsSynced || !this.isScrollbarVisible(true));
                            const columns = needVisibleColumns ? visibleColumns : this.getFixedColumns();
                            this.setFixedTableColumnWidths(columns, widths)
                        }
                        const wordWrapEnabled = this.option("wordWrapEnabled");
                        const needSynchronizeRows = isColumnWidthsSynced || isColumnWidthChanged && wordWrapEnabled;
                        if (needSynchronizeRows) {
                            this.synchronizeRows()
                        }
                    };
                    _proto.setFixedTableColumnWidths = function(columns, widths) {
                        if (!this._fixedTableElement || !widths) {
                            return
                        }
                        const $cols = this._fixedTableElement.children("colgroup").children("col");
                        $cols.toArray().forEach(col => col.removeAttribute("style"));
                        let columnIndex = 0;
                        columns.forEach(column => {
                            if (column.colspan) {
                                columnIndex += column.colspan;
                                return
                            }
                            const colWidth = (0, _m_columns_view.normalizeWidth)(widths[columnIndex]);
                            if ((0, _type.isDefined)(colWidth)) {
                                (0, _style.setWidth)($cols.eq(columnIndex), colWidth)
                            }
                            columnIndex += 1
                        })
                    };
                    _proto._getClientHeight = function(element) {
                        const boundingClientRectElement = element.getBoundingClientRect && (0, _position.getBoundingRect)(element);
                        return boundingClientRectElement && boundingClientRectElement.height ? boundingClientRectElement.height : element.clientHeight
                    };
                    _proto.synchronizeRows = function() {
                        const rowHeights = [];
                        const fixedRowHeights = [];
                        let rowIndex;
                        let $rowElements;
                        let $fixedRowElements;
                        let $contentElement;
                        this.waitAsyncTemplates(true).done(() => {
                            if (this._isFixedColumns && this._tableElement && this._fixedTableElement) {
                                const heightTable = this._getClientHeight(this._tableElement.get(0));
                                const heightFixedTable = this._getClientHeight(this._fixedTableElement.get(0));
                                $rowElements = this._getRowElements(this._tableElement);
                                $fixedRowElements = this._getRowElements(this._fixedTableElement);
                                $contentElement = this._findContentElement();
                                if (heightTable !== heightFixedTable) {
                                    $contentElement && $contentElement.css("height", heightTable);
                                    $rowElements.css("height", "");
                                    $fixedRowElements.css("height", "");
                                    for (rowIndex = 0; rowIndex < $rowElements.length; rowIndex++) {
                                        rowHeights.push(this._getClientHeight($rowElements.get(rowIndex)));
                                        fixedRowHeights.push(this._getClientHeight($fixedRowElements.get(rowIndex)))
                                    }
                                    for (rowIndex = 0; rowIndex < $rowElements.length; rowIndex++) {
                                        const rowHeight = rowHeights[rowIndex];
                                        const fixedRowHeight = fixedRowHeights[rowIndex];
                                        if (rowHeight > fixedRowHeight) {
                                            $fixedRowElements.eq(rowIndex).css("height", rowHeight)
                                        } else if (rowHeight < fixedRowHeight) {
                                            $rowElements.eq(rowIndex).css("height", fixedRowHeight)
                                        }
                                    }
                                    $contentElement && $contentElement.css("height", "")
                                }
                            }
                        })
                    };
                    _proto.setScrollerSpacing = function(width, hWidth) {
                        const rtlEnabled = this.option("rtlEnabled");
                        _Base.prototype.setScrollerSpacing.call(this, width);
                        this.element().children(".".concat(this.addWidgetPrefix("content-fixed"))).css({
                            paddingLeft: rtlEnabled ? width : "",
                            paddingRight: !rtlEnabled ? width : ""
                        })
                    };
                    return BaseFixedColumnsExtender
                }(Base);
                const columnFixingModule = {
                    defaultOptions: () => ({
                        columnFixing: {
                            enabled: false,
                            texts: {
                                fix: _message.default.format("dxDataGrid-columnFixingFix"),
                                unfix: _message.default.format("dxDataGrid-columnFixingUnfix"),
                                leftPosition: _message.default.format("dxDataGrid-columnFixingLeftPosition"),
                                rightPosition: _message.default.format("dxDataGrid-columnFixingRightPosition")
                            }
                        }
                    }),
                    extenders: {
                        views: {
                            columnHeadersView: Base => function(_baseFixedColumns) {
                                _inheritsLoose(ColumnHeadersViewFixedColumnsExtender, _baseFixedColumns);

                                function ColumnHeadersViewFixedColumnsExtender() {
                                    return _baseFixedColumns.apply(this, arguments) || this
                                }
                                var _proto2 = ColumnHeadersViewFixedColumnsExtender.prototype;
                                _proto2._getRowVisibleColumns = function(rowIndex) {
                                    if (this._isFixedTableRendering) {
                                        return this.getFixedColumns(rowIndex)
                                    }
                                    return _baseFixedColumns.prototype._getRowVisibleColumns.call(this, rowIndex)
                                };
                                _proto2.getContextMenuItems = function(options) {
                                    const {
                                        column: column
                                    } = options;
                                    const columnFixingOptions = this.option("columnFixing");
                                    let items = _baseFixedColumns.prototype.getContextMenuItems.call(this, options);
                                    if (options.row && "header" === options.row.rowType) {
                                        if (true === columnFixingOptions.enabled && column && column.allowFixing) {
                                            const onItemClick = params => {
                                                switch (params.itemData.value) {
                                                    case "none":
                                                        this._columnsController.columnOption(column.index, "fixed", false);
                                                        break;
                                                    case "left":
                                                        this._columnsController.columnOption(column.index, {
                                                            fixed: true,
                                                            fixedPosition: "left"
                                                        });
                                                        break;
                                                    case "right":
                                                        this._columnsController.columnOption(column.index, {
                                                            fixed: true,
                                                            fixedPosition: "right"
                                                        })
                                                }
                                            };
                                            items = items || [];
                                            items.push({
                                                text: columnFixingOptions.texts.fix,
                                                beginGroup: true,
                                                items: [{
                                                    text: columnFixingOptions.texts.leftPosition,
                                                    value: "left",
                                                    disabled: column.fixed && (!column.fixedPosition || "left" === column.fixedPosition),
                                                    onItemClick: onItemClick
                                                }, {
                                                    text: columnFixingOptions.texts.rightPosition,
                                                    value: "right",
                                                    disabled: column.fixed && "right" === column.fixedPosition,
                                                    onItemClick: onItemClick
                                                }]
                                            }, {
                                                text: columnFixingOptions.texts.unfix,
                                                value: "none",
                                                disabled: !column.fixed,
                                                onItemClick: onItemClick
                                            })
                                        }
                                    }
                                    return items
                                };
                                _proto2.getFixedColumnElements = function(rowIndex) {
                                    const that = this;
                                    if ((0, _type.isDefined)(rowIndex)) {
                                        return this._fixedTableElement && this._getRowElements(this._fixedTableElement).eq(rowIndex).children()
                                    }
                                    const columnElements = that.getColumnElements();
                                    const $transparentColumnElement = that.getTransparentColumnElement();
                                    if (columnElements && $transparentColumnElement && $transparentColumnElement.length) {
                                        const transparentColumnIndex = getTransparentColumnIndex(that.getFixedColumns());
                                        columnElements.splice(transparentColumnIndex, $transparentColumnElement.get(0).colSpan, $transparentColumnElement.get(0))
                                    }
                                    return columnElements
                                };
                                _proto2.getColumnWidths = function() {
                                    const that = this;
                                    let fixedWidths;
                                    const result = _baseFixedColumns.prototype.getColumnWidths.call(this);
                                    const $fixedColumnElements = that.getFixedColumnElements();
                                    const fixedColumns = that.getFixedColumns();
                                    if (that._fixedTableElement) {
                                        if ($fixedColumnElements && $fixedColumnElements.length) {
                                            fixedWidths = that._getWidths($fixedColumnElements)
                                        } else {
                                            fixedWidths = _baseFixedColumns.prototype.getColumnWidths.call(this, that._fixedTableElement)
                                        }
                                    }
                                    return normalizeColumnWidths(fixedColumns, result, fixedWidths)
                                };
                                return ColumnHeadersViewFixedColumnsExtender
                            }(baseFixedColumns(Base)),
                            rowsView: Base => function(_baseFixedColumns2) {
                                _inheritsLoose(RowsViewFixedColumnsExtender, _baseFixedColumns2);

                                function RowsViewFixedColumnsExtender() {
                                    return _baseFixedColumns2.apply(this, arguments) || this
                                }
                                var _proto3 = RowsViewFixedColumnsExtender.prototype;
                                _proto3.dispose = function() {
                                    _baseFixedColumns2.prototype.dispose.apply(this, arguments);
                                    clearTimeout(this._fixedScrollTimeout)
                                };
                                _proto3.optionChanged = function(args) {
                                    _baseFixedColumns2.prototype.optionChanged.call(this, args);
                                    if ("hoverStateEnabled" === args.name && this._isFixedColumns) {
                                        args.value ? this._attachHoverEvents() : this._detachHoverEvents()
                                    }
                                };
                                _proto3._detachHoverEvents = function() {
                                    const element = this.element();
                                    if (this._fixedTableElement && this._tableElement) {
                                        _events_engine.default.off(element, "mouseover mouseout", ".dx-data-row")
                                    }
                                };
                                _proto3._attachHoverEvents = function() {
                                    if (this._fixedTableElement && this._tableElement) {
                                        _events_engine.default.on(this.element(), "mouseover mouseout", ".dx-data-row", this.createAction(args => {
                                            const {
                                                event: event
                                            } = args;
                                            const rowIndex = this.getRowIndex((0, _renderer.default)(event.target).closest(".dx-row"));
                                            const isHover = "mouseover" === event.type;
                                            if (rowIndex >= 0) {
                                                this._tableElement && this._getRowElements(this._tableElement).eq(rowIndex).toggleClass("dx-state-hover", isHover);
                                                this._fixedTableElement && this._getRowElements(this._fixedTableElement).eq(rowIndex).toggleClass("dx-state-hover", isHover)
                                            }
                                        }))
                                    }
                                };
                                _proto3._getScrollDelay = function() {
                                    var _a;
                                    const hasResizeTimeout = null === (_a = this._resizingController) || void 0 === _a ? void 0 : _a.hasResizeTimeout();
                                    if (hasResizeTimeout) {
                                        return this.option("scrolling.updateTimeout")
                                    }
                                    return _browser.default.mozilla ? 60 : 0
                                };
                                _proto3._findContentElement = function(isFixedTableRendering) {
                                    let $content;
                                    let scrollTop;
                                    const contentClass = this.addWidgetPrefix("content");
                                    const element = this.element();
                                    isFixedTableRendering = this._isFixedTableRendering || isFixedTableRendering;
                                    if (element && isFixedTableRendering) {
                                        $content = element.children(".".concat(contentClass));
                                        const scrollable = this.getScrollable();
                                        if (!$content.length && scrollable) {
                                            $content = (0, _renderer.default)("<div>").addClass(contentClass);
                                            _events_engine.default.on($content, "scroll", e => {
                                                const {
                                                    target: target
                                                } = e;
                                                const scrollDelay = this._getScrollDelay();
                                                clearTimeout(this._fixedScrollTimeout);
                                                this._fixedScrollTimeout = setTimeout(() => {
                                                    scrollTop = (0, _renderer.default)(target).scrollTop();
                                                    scrollable.scrollTo({
                                                        y: scrollTop
                                                    })
                                                }, scrollDelay)
                                            });
                                            _events_engine.default.on($content, _wheel.name, e => {
                                                const $nearestScrollable = (0, _renderer.default)(e.target).closest(".dx-scrollable");
                                                let shouldScroll = false;
                                                if (scrollable && scrollable.$element().is($nearestScrollable)) {
                                                    shouldScroll = true
                                                } else {
                                                    const nearestScrollableInstance = $nearestScrollable.length && _ui.default.getInstance($nearestScrollable.get(0));
                                                    const nearestScrollableHasVerticalScrollbar = nearestScrollableInstance && nearestScrollableInstance.scrollHeight() - nearestScrollableInstance.clientHeight() > 0;
                                                    shouldScroll = nearestScrollableInstance && !nearestScrollableHasVerticalScrollbar
                                                }
                                                if (shouldScroll) {
                                                    scrollTop = scrollable.scrollTop();
                                                    scrollable.scrollTo({
                                                        y: scrollTop - e.delta
                                                    });
                                                    const scrollableTop = scrollable.scrollTop() + scrollable.clientHeight();
                                                    const scrollableHeight = scrollable.scrollHeight() + this.getScrollbarWidth();
                                                    const isPreventDefault = scrollable.scrollTop() > 0 && scrollableTop < scrollableHeight;
                                                    if (isPreventDefault) {
                                                        return false
                                                    }
                                                }
                                                return
                                            });
                                            $content.appendTo(element)
                                        }
                                        return $content
                                    }
                                    return _baseFixedColumns2.prototype._findContentElement.call(this)
                                };
                                _proto3._updateScrollable = function() {
                                    _baseFixedColumns2.prototype._updateScrollable.call(this);
                                    const scrollable = this.getScrollable();
                                    if (null === scrollable || void 0 === scrollable ? void 0 : scrollable._disposed) {
                                        return
                                    }
                                    const scrollTop = scrollable && scrollable.scrollOffset().top;
                                    this._updateFixedTablePosition(scrollTop)
                                };
                                _proto3._renderContent = function(contentElement, tableElement, isFixedTableRendering) {
                                    if (this._isFixedTableRendering || isFixedTableRendering) {
                                        return contentElement.empty().addClass("".concat(this.addWidgetPrefix("content"), " ").concat(this.addWidgetPrefix("content-fixed"))).append(tableElement)
                                    }
                                    return _baseFixedColumns2.prototype._renderContent.call(this, contentElement, tableElement)
                                };
                                _proto3._getGroupCellOptions = function(options) {
                                    if (this._isFixedTableRendering) {
                                        return _baseFixedColumns2.prototype._getGroupCellOptions.call(this, (0, _extend.extend)({}, options, {
                                            columns: this._columnsController.getVisibleColumns()
                                        }))
                                    }
                                    return _baseFixedColumns2.prototype._getGroupCellOptions.call(this, options)
                                };
                                _proto3._renderGroupedCells = function($row, options) {
                                    return _baseFixedColumns2.prototype._renderGroupedCells.call(this, $row, (0, _extend.extend)({}, options, {
                                        columns: this._columnsController.getVisibleColumns()
                                    }))
                                };
                                _proto3._renderGroupSummaryCells = function($row, options) {
                                    if (this._isFixedTableRendering) {
                                        _baseFixedColumns2.prototype._renderGroupSummaryCells.call(this, $row, (0, _extend.extend)({}, options, {
                                            columns: this._columnsController.getVisibleColumns()
                                        }))
                                    } else {
                                        _baseFixedColumns2.prototype._renderGroupSummaryCells.call(this, $row, options)
                                    }
                                };
                                _proto3._hasAlignByColumnSummaryItems = function(columnIndex, options) {
                                    const result = _baseFixedColumns2.prototype._hasAlignByColumnSummaryItems.apply(this, arguments);
                                    const column = options.columns[columnIndex];
                                    if (options.isFixed) {
                                        return column.fixed && (result || "right" === column.fixedPosition)
                                    }
                                    return result && (!this._isFixedColumns || !column.fixed)
                                };
                                _proto3._renderGroupSummaryCellsCore = function($groupCell, options, groupCellColSpan, alignByColumnCellCount) {
                                    let alignByFixedColumnCellCount;
                                    if (this._isFixedTableRendering) {
                                        options.isFixed = true;
                                        alignByFixedColumnCellCount = this._getAlignByColumnCellCount(groupCellColSpan, options);
                                        options.isFixed = false;
                                        const startColumnIndex = options.columns.length - alignByFixedColumnCellCount;
                                        options = (0, _extend.extend)({}, options, {
                                            columns: this.getFixedColumns()
                                        });
                                        const transparentColumnIndex = getTransparentColumnIndex(options.columns);
                                        if (startColumnIndex < transparentColumnIndex) {
                                            alignByFixedColumnCellCount -= options.columns[transparentColumnIndex].colspan - 1 || 0;
                                            groupCellColSpan -= options.columns[transparentColumnIndex].colspan - 1 || 0
                                        } else if (alignByColumnCellCount > 0) {
                                            $groupCell.css("visibility", "hidden")
                                        }
                                        alignByColumnCellCount = alignByFixedColumnCellCount
                                    }
                                    _baseFixedColumns2.prototype._renderGroupSummaryCellsCore.call(this, $groupCell, options, groupCellColSpan, alignByColumnCellCount)
                                };
                                _proto3._getSummaryCellIndex = function(columnIndex, columns) {
                                    if (this._isFixedTableRendering) {
                                        const transparentColumnIndex = getTransparentColumnIndex(columns);
                                        if (columnIndex > transparentColumnIndex) {
                                            columnIndex += columns[transparentColumnIndex].colspan - 1
                                        }
                                        return columnIndex
                                    }
                                    return _baseFixedColumns2.prototype._getSummaryCellIndex.apply(this, arguments)
                                };
                                _proto3._renderCore = function(change) {
                                    this._detachHoverEvents();
                                    const deferred = _baseFixedColumns2.prototype._renderCore.call(this, change);
                                    const isFixedColumns = this._isFixedColumns;
                                    this.element().toggleClass("dx-fixed-columns", isFixedColumns);
                                    if (this.option("hoverStateEnabled") && isFixedColumns) {
                                        this._attachHoverEvents()
                                    }
                                    return deferred
                                };
                                _proto3.setAriaOwns = function(headerTableId, footerTableId, isFixed) {
                                    var _a, _b;
                                    if (isFixed) {
                                        const contentFixedClass = this.addWidgetPrefix("content-fixed");
                                        const $contentFixedElement = null === (_a = this.element()) || void 0 === _a ? void 0 : _a.children(".".concat(contentFixedClass));
                                        const $fixedTableElement = this.getFixedTableElement();
                                        if ($contentFixedElement.length && (null === $fixedTableElement || void 0 === $fixedTableElement ? void 0 : $fixedTableElement.length)) {
                                            this.setAria("owns", "".concat(null !== headerTableId && void 0 !== headerTableId ? headerTableId : "", " ").concat(null !== (_b = $fixedTableElement.attr("id")) && void 0 !== _b ? _b : "", " ").concat(null !== footerTableId && void 0 !== footerTableId ? footerTableId : "").trim(), $contentFixedElement)
                                        }
                                    } else {
                                        _baseFixedColumns2.prototype.setAriaOwns.apply(this, arguments)
                                    }
                                };
                                _proto3.setRowsOpacity = function(columnIndex, value) {
                                    _baseFixedColumns2.prototype.setRowsOpacity.call(this, columnIndex, value);
                                    const $rows = this._getRowElements(this._fixedTableElement);
                                    this._setRowsOpacityCore($rows, this.getFixedColumns(), columnIndex, value)
                                };
                                _proto3.getCellIndex = function($cell) {
                                    const $fixedTable = this._fixedTableElement;
                                    let cellIndex = 0;
                                    if ($fixedTable && $cell.is("td") && $cell.closest($fixedTable).length) {
                                        const columns = this.getFixedColumns();
                                        (0, _iterator.each)(columns, (index, column) => {
                                            if (index === $cell[0].cellIndex) {
                                                return false
                                            }
                                            if (column.colspan) {
                                                cellIndex += column.colspan;
                                                return
                                            }
                                            cellIndex++;
                                            return
                                        });
                                        return cellIndex
                                    }
                                    return _baseFixedColumns2.prototype.getCellIndex.apply(this, arguments)
                                };
                                _proto3._updateFixedTablePosition = function(scrollTop, needFocus) {
                                    if (this._fixedTableElement && this._tableElement) {
                                        let $focusedElement;
                                        this._fixedTableElement.parent().scrollTop(scrollTop);
                                        if (needFocus && this._editorFactoryController) {
                                            $focusedElement = this._editorFactoryController.focus();
                                            $focusedElement && this._editorFactoryController.focus($focusedElement)
                                        }
                                    }
                                };
                                _proto3.setScrollerSpacing = function(vWidth, hWidth) {
                                    const that = this;
                                    const styles = {
                                        marginBottom: 0
                                    };
                                    const $fixedContent = that.element().children(".".concat(this.addWidgetPrefix("content-fixed")));
                                    if ($fixedContent.length && that._fixedTableElement) {
                                        $fixedContent.css(styles);
                                        that._fixedTableElement.css(styles);
                                        styles[that.option("rtlEnabled") ? "marginLeft" : "marginRight"] = vWidth;
                                        styles.marginBottom = hWidth;
                                        const useNativeScrolling = that._scrollable && that._scrollable.option("useNative");
                                        (useNativeScrolling ? $fixedContent : that._fixedTableElement).css(styles)
                                    }
                                };
                                _proto3._getElasticScrollTop = function(e) {
                                    let elasticScrollTop = 0;
                                    if (e.scrollOffset.top < 0) {
                                        elasticScrollTop = -e.scrollOffset.top
                                    } else if (e.reachedBottom) {
                                        const $scrollableContent = (0, _renderer.default)(e.component.content());
                                        const $scrollableContainer = (0, _renderer.default)(e.component.container());
                                        const maxScrollTop = Math.max($scrollableContent.get(0).clientHeight - $scrollableContainer.get(0).clientHeight, 0);
                                        elasticScrollTop = Math.min(maxScrollTop - e.scrollOffset.top, 0)
                                    }
                                    return Math.floor(elasticScrollTop)
                                };
                                _proto3._applyElasticScrolling = function(e) {
                                    if (this._fixedTableElement) {
                                        const elasticScrollTop = this._getElasticScrollTop(e);
                                        if (0 !== Math.ceil(elasticScrollTop)) {
                                            (0, _translator.move)(this._fixedTableElement, {
                                                top: elasticScrollTop
                                            })
                                        } else {
                                            this._fixedTableElement.css("transform", "")
                                        }
                                    }
                                };
                                _proto3._handleScroll = function(e) {
                                    this._updateFixedTablePosition(e.scrollOffset.top, true);
                                    this._applyElasticScrolling(e);
                                    _baseFixedColumns2.prototype._handleScroll.call(this, e)
                                };
                                _proto3._updateContentPosition = function(isRender) {
                                    _baseFixedColumns2.prototype._updateContentPosition.apply(this, arguments);
                                    if (!isRender) {
                                        this._updateFixedTablePosition(this._scrollTop)
                                    }
                                };
                                _proto3._afterRowPrepared = function(e) {
                                    if (this._isFixedTableRendering) {
                                        return
                                    }
                                    _baseFixedColumns2.prototype._afterRowPrepared.call(this, e)
                                };
                                _proto3._scrollToElement = function($element) {
                                    _baseFixedColumns2.prototype._scrollToElement.call(this, $element, this.getFixedColumnsOffset())
                                };
                                return RowsViewFixedColumnsExtender
                            }(baseFixedColumns(Base)),
                            footerView: Base => function(_baseFixedColumns3) {
                                _inheritsLoose(FooterViewFixedColumnsExtender, _baseFixedColumns3);

                                function FooterViewFixedColumnsExtender() {
                                    return _baseFixedColumns3.apply(this, arguments) || this
                                }
                                return FooterViewFixedColumnsExtender
                            }(baseFixedColumns(Base))
                        },
                        controllers: {
                            draggingHeader: Base => function(_Base2) {
                                _inheritsLoose(DraggingHeaderColumnFixingExtender, _Base2);

                                function DraggingHeaderColumnFixingExtender() {
                                    return _Base2.apply(this, arguments) || this
                                }
                                var _proto4 = DraggingHeaderColumnFixingExtender.prototype;
                                _proto4._generatePointsByColumns = function(options) {
                                    const visibleColumns = options.columns;
                                    const {
                                        targetDraggingPanel: targetDraggingPanel
                                    } = options;
                                    if (targetDraggingPanel && "headers" === targetDraggingPanel.getName() && targetDraggingPanel.isFixedColumns()) {
                                        if (options.sourceColumn.fixed) {
                                            if (!options.rowIndex) {
                                                options.columnElements = targetDraggingPanel.getFixedColumnElements(0)
                                            }
                                            options.columns = targetDraggingPanel.getFixedColumns(options.rowIndex);
                                            const pointsByColumns = _Base2.prototype._generatePointsByColumns.call(this, options);
                                            ! function(columns, fixedColumns, pointsByColumns) {
                                                const transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                                                const correctIndex = columns.length - fixedColumns.length;
                                                (0, _iterator.each)(pointsByColumns, (_, point) => {
                                                    if (point.index > transparentColumnIndex) {
                                                        point.columnIndex += correctIndex;
                                                        point.index += correctIndex
                                                    }
                                                });
                                                return pointsByColumns
                                            }(visibleColumns, options.columns, pointsByColumns);
                                            return pointsByColumns
                                        }
                                    }
                                    return _Base2.prototype._generatePointsByColumns.call(this, options)
                                };
                                _proto4._pointCreated = function(point, columns, location, sourceColumn) {
                                    const result = _Base2.prototype._pointCreated.apply(this, arguments);
                                    const targetColumn = columns[point.columnIndex];
                                    const $transparentColumn = this._columnHeadersView.getTransparentColumnElement();
                                    if (!result && "headers" === location && $transparentColumn && $transparentColumn.length) {
                                        const boundingRect = (0, _position.getBoundingRect)($transparentColumn.get(0));
                                        if (sourceColumn && sourceColumn.fixed) {
                                            return "right" === sourceColumn.fixedPosition ? point.x < boundingRect.right : point.x > boundingRect.left
                                        }
                                        if (targetColumn && targetColumn.fixed && "right" !== targetColumn.fixedPosition) {
                                            return true
                                        }
                                        return point.x < boundingRect.left || point.x > boundingRect.right
                                    }
                                    return result
                                };
                                return DraggingHeaderColumnFixingExtender
                            }(Base),
                            columnsResizer: Base => function(_Base3) {
                                _inheritsLoose(ColumnResizerColumnFixingExtender, _Base3);

                                function ColumnResizerColumnFixingExtender() {
                                    return _Base3.apply(this, arguments) || this
                                }
                                var _proto5 = ColumnResizerColumnFixingExtender.prototype;
                                _proto5._generatePointsByColumns = function() {
                                    const that = this;
                                    const columnsController = that._columnsController;
                                    const columns = columnsController && that._columnsController.getVisibleColumns();
                                    const fixedColumns = columnsController && that._columnsController.getFixedColumns();
                                    const transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                                    const correctIndex = columns.length - fixedColumns.length;
                                    const cells = that._columnHeadersView.getFixedColumnElements();
                                    _Base3.prototype._generatePointsByColumns.call(this);
                                    if (cells && cells.length > 0) {
                                        that._pointsByFixedColumns = _m_utils.default.getPointsByColumns(cells, point => {
                                            if (point.index > transparentColumnIndex) {
                                                point.columnIndex += correctIndex;
                                                point.index += correctIndex
                                            }
                                            return that._pointCreated(point, columns.length, columns)
                                        })
                                    }
                                };
                                _proto5._getTargetPoint = function(pointsByColumns, currentX, deltaX) {
                                    const $transparentColumn = this._columnHeadersView.getTransparentColumnElement();
                                    if ($transparentColumn && $transparentColumn.length) {
                                        const boundingRect = (0, _position.getBoundingRect)($transparentColumn.get(0));
                                        if (currentX <= boundingRect.left || currentX >= boundingRect.right) {
                                            return _Base3.prototype._getTargetPoint.call(this, this._pointsByFixedColumns, currentX, deltaX)
                                        }
                                    }
                                    return _Base3.prototype._getTargetPoint.call(this, pointsByColumns, currentX, deltaX)
                                };
                                return ColumnResizerColumnFixingExtender
                            }(Base),
                            resizing: Base => function(_Base4) {
                                _inheritsLoose(ResizingColumnFixingExtender, _Base4);

                                function ResizingColumnFixingExtender() {
                                    return _Base4.apply(this, arguments) || this
                                }
                                var _proto6 = ResizingColumnFixingExtender.prototype;
                                _proto6._setAriaOwns = function() {
                                    var _a, _b, _c;
                                    _Base4.prototype._setAriaOwns.apply(this, arguments);
                                    const headerFixedTable = null === (_a = this._columnHeadersView) || void 0 === _a ? void 0 : _a.getFixedTableElement();
                                    const footerFixedTable = null === (_b = this._footerView) || void 0 === _b ? void 0 : _b.getFixedTableElement();
                                    null === (_c = this._rowsView) || void 0 === _c ? void 0 : _c.setAriaOwns(null === headerFixedTable || void 0 === headerFixedTable ? void 0 : headerFixedTable.attr("id"), null === footerFixedTable || void 0 === footerFixedTable ? void 0 : footerFixedTable.attr("id"), true)
                                };
                                return ResizingColumnFixingExtender
                            }(Base)
                        }
                    }
                };
                exports.columnFixingModule = columnFixingModule
            },
        14509:
            /*!***********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/column_headers/m_column_headers.js ***!
              \***********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnHeadersModule = exports.ColumnHeadersView = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../../core/dom_adapter */ 73349));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 55994));
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _m_accessibility = __webpack_require__( /*! ../m_accessibility */ 9130);
                var _m_columns_view = __webpack_require__( /*! ../views/m_columns_view */ 57318);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const createCellContent = function(that, $cell, options) {
                    const $cellContent = (0, _renderer.default)("<div>").addClass(that.addWidgetPrefix("text-content"));
                    that.setAria("role", "presentation", $cellContent);
                    addCssClassesToCellContent(that, $cell, options.column, $cellContent);
                    const showColumnLines = that.option("showColumnLines");
                    const contentAlignment = that.getController("columns").getHeaderContentAlignment(options.column.alignment);
                    return $cellContent[showColumnLines || "right" === contentAlignment ? "appendTo" : "prependTo"]($cell)
                };

                function addCssClassesToCellContent(that, $cell, column, $cellContent) {
                    const $indicatorElements = that._getIndicatorElements($cell, true);
                    const $visibleIndicatorElements = that._getIndicatorElements($cell);
                    const indicatorCount = $indicatorElements && $indicatorElements.length;
                    const columnAlignment = that._getColumnAlignment(column.alignment);
                    const sortIndicatorClassName = ".".concat(that._getIndicatorClassName("sort"));
                    const sortIndexIndicatorClassName = ".".concat(that._getIndicatorClassName("sortIndex"));
                    const $sortIndicator = $visibleIndicatorElements.filter(sortIndicatorClassName);
                    const $sortIndexIndicator = $visibleIndicatorElements.children().filter(sortIndexIndicatorClassName);
                    $cellContent = $cellContent || $cell.children(".".concat(that.addWidgetPrefix("text-content")));
                    $cellContent.toggleClass("dx-text-content-alignment-" + columnAlignment, indicatorCount > 0).toggleClass("dx-text-content-alignment-" + ("left" === columnAlignment ? "right" : "left"), indicatorCount > 0 && "center" === column.alignment).toggleClass("dx-sort-indicator", !!$sortIndicator.length).toggleClass("dx-sort-index-indicator", !!$sortIndexIndicator.length).toggleClass("dx-header-filter-indicator", !!$visibleIndicatorElements.filter(".".concat(that._getIndicatorClassName("headerFilter"))).length)
                }
                let ColumnHeadersView = function(_ColumnsView) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(ColumnHeadersView, _ColumnsView);

                    function ColumnHeadersView() {
                        return _ColumnsView.apply(this, arguments) || this
                    }
                    var _proto = ColumnHeadersView.prototype;
                    _proto.init = function() {
                        _ColumnsView.prototype.init.call(this);
                        this._headerPanelView = this.getView("headerPanel");
                        this._headerFilterController = this.getController("headerFilter");
                        this._dataController = this.getController("data")
                    };
                    _proto._createTable = function() {
                        const $table = _ColumnsView.prototype._createTable.apply(this, arguments);
                        _events_engine.default.on($table, "mousedown selectstart", this.createAction(e => {
                            const {
                                event: event
                            } = e;
                            if (event.shiftKey) {
                                event.preventDefault()
                            }
                        }));
                        return $table
                    };
                    _proto._isLegacyKeyboardNavigation = function() {
                        return this.option("useLegacyKeyboardNavigation")
                    };
                    _proto._getDefaultTemplate = function(column) {
                        const that = this;
                        return function($container, options) {
                            const {
                                caption: caption
                            } = column;
                            const needCellContent = !column.command || caption && "expand" !== column.command;
                            if ("empty" === column.command) {
                                that._renderEmptyMessage($container, options)
                            } else if (needCellContent) {
                                const $content = createCellContent(that, $container, options);
                                $content.text(caption)
                            } else if (column.command) {
                                $container.html("&nbsp;")
                            }
                        }
                    };
                    _proto._renderEmptyMessage = function($container, options) {
                        const textEmpty = this._getEmptyHeaderText();
                        if (!textEmpty) {
                            $container.html("&nbsp;");
                            return
                        }
                        const $cellContent = createCellContent(this, $container, options);
                        const needSplit = textEmpty.includes("{0}");
                        if (needSplit) {
                            const [leftPart, rightPart] = textEmpty.split("{0}");
                            const columnChooserTitle = _message.default.format("dxDataGrid-emptyHeaderColumnChooserText");
                            const columnChooserView = this._columnChooserView;
                            const $link = (0, _renderer.default)("<a>").text(columnChooserTitle).addClass("dx-link");
                            _events_engine.default.on($link, "click", this.createAction(() => columnChooserView.showColumnChooser()));
                            $cellContent.append(_dom_adapter.default.createTextNode(leftPart)).append($link).append(_dom_adapter.default.createTextNode(rightPart))
                        } else {
                            $cellContent.text(textEmpty)
                        }
                    };
                    _proto._getEmptyHeaderText = function() {
                        const hasHiddenColumns = !!this._columnChooserView.hasHiddenColumns();
                        const hasGroupedColumns = !!this._headerPanelView.hasGroupedColumns();
                        switch (true) {
                            case hasHiddenColumns && hasGroupedColumns:
                                return _message.default.format("dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText");
                            case hasGroupedColumns:
                                return _message.default.format("dxDataGrid-emptyHeaderWithGroupPanelText");
                            case hasHiddenColumns:
                                return _message.default.format("dxDataGrid-emptyHeaderWithColumnChooserText");
                            default:
                                return ""
                        }
                    };
                    _proto._getHeaderTemplate = function(column) {
                        return column.headerCellTemplate || {
                            allowRenderToDetachedContainer: true,
                            render: this._getDefaultTemplate(column)
                        }
                    };
                    _proto._processTemplate = function(template, options) {
                        const that = this;
                        let resultTemplate;
                        const {
                            column: column
                        } = options;
                        const renderingTemplate = _ColumnsView.prototype._processTemplate.call(this, template);
                        if ("header" === options.rowType && renderingTemplate && column.headerCellTemplate && !column.command) {
                            resultTemplate = {
                                render(options) {
                                    const $content = createCellContent(that, options.container, options.model);
                                    renderingTemplate.render((0, _extend.extend)({}, options, {
                                        container: $content
                                    }))
                                }
                            }
                        } else {
                            resultTemplate = renderingTemplate
                        }
                        return resultTemplate
                    };
                    _proto._handleDataChanged = function(e) {
                        if ("refresh" !== e.changeType) {
                            return
                        }
                        if (this._isGroupingChanged || this._requireReady) {
                            this._isGroupingChanged = false;
                            this.render()
                        }
                    };
                    _proto._renderCell = function($row, options) {
                        const $cell = _ColumnsView.prototype._renderCell.call(this, $row, options);
                        if ("header" === options.row.rowType) {
                            $cell.addClass("dx-cell-focus-disabled");
                            if (!this._isLegacyKeyboardNavigation()) {
                                if (options.column && !options.column.type) {
                                    $cell.attr("tabindex", this.option("tabindex") || 0)
                                }
                            }
                        }
                        return $cell
                    };
                    _proto._setCellAriaAttributes = function($cell, cellOptions) {
                        _ColumnsView.prototype._setCellAriaAttributes.call(this, $cell, cellOptions);
                        if ("header" === cellOptions.rowType) {
                            if (!cellOptions.column.type) {
                                this.setAria("role", "columnheader", $cell)
                            }
                            if (cellOptions.column && !cellOptions.column.command && !cellOptions.column.isBand) {
                                $cell.attr("id", cellOptions.column.headerId);
                                this.setAria("label", "".concat(_message.default.format("dxDataGrid-ariaColumn"), " ").concat(cellOptions.column.caption), $cell)
                            }
                        }
                    };
                    _proto._createRow = function(row) {
                        const $row = _ColumnsView.prototype._createRow.apply(this, arguments);
                        $row.toggleClass("dx-column-lines", this.option("showColumnLines"));
                        if ("header" === row.rowType) {
                            $row.addClass("dx-header-row");
                            if (!this._isLegacyKeyboardNavigation()) {
                                (0, _m_accessibility.registerKeyboardAction)("columnHeaders", this, $row, "td", this._handleActionKeyDown.bind(this))
                            }
                        }
                        return $row
                    };
                    _proto._processHeaderAction = function(event, $row) {};
                    _proto._handleActionKeyDown = function(args) {
                        const {
                            event: event
                        } = args;
                        const $target = (0, _renderer.default)(event.target);
                        this._lastActionElement = event.target;
                        if ($target.is(".dx-header-filter")) {
                            const headerFilterController = this._headerFilterController;
                            const $column = $target.closest("td");
                            const columnIndex = this.getColumnIndexByElement($column);
                            if (columnIndex >= 0) {
                                headerFilterController.showHeaderFilterMenu(columnIndex, false)
                            }
                        } else {
                            const $row = $target.closest(".dx-row");
                            this._processHeaderAction(event, $row)
                        }
                        event.preventDefault()
                    };
                    _proto._renderCore = function() {
                        const that = this;
                        const $container = that.element();
                        const change = {};
                        if (that._tableElement && !that._dataController.isLoaded() && !that._hasRowElements) {
                            return
                        }
                        $container.addClass(that.addWidgetPrefix("headers")).toggleClass(that.addWidgetPrefix("nowrap"), !that.option("wordWrapEnabled")).empty();
                        that.setAria("role", "presentation", $container);
                        const deferred = that._updateContent(that._renderTable({
                            change: change
                        }), change);
                        if (that.getRowCount() > 1) {
                            $container.addClass("dx-header-multi-row")
                        }
                        _ColumnsView.prototype._renderCore.apply(that, arguments);
                        return deferred
                    };
                    _proto._renderRows = function() {
                        const that = this;
                        if (that._dataController.isLoaded() || that._hasRowElements) {
                            _ColumnsView.prototype._renderRows.apply(that, arguments);
                            that._hasRowElements = true
                        }
                    };
                    _proto._renderRow = function($table, options) {
                        const rowIndex = 1 === this.getRowCount() ? null : options.row.rowIndex;
                        options.columns = this.getColumns(rowIndex);
                        _ColumnsView.prototype._renderRow.call(this, $table, options)
                    };
                    _proto._createCell = function(options) {
                        const {
                            column: column
                        } = options;
                        const $cellElement = _ColumnsView.prototype._createCell.apply(this, arguments);
                        column.rowspan > 1 && "header" === options.rowType && $cellElement.attr("rowSpan", column.rowspan);
                        return $cellElement
                    };
                    _proto._getRows = function() {
                        const result = [];
                        const rowCount = this.getRowCount();
                        if (this.option("showColumnHeaders")) {
                            for (let i = 0; i < rowCount; i++) {
                                result.push({
                                    rowType: "header",
                                    rowIndex: i
                                })
                            }
                        }
                        return result
                    };
                    _proto._getCellTemplate = function(options) {
                        if ("header" === options.rowType) {
                            return this._getHeaderTemplate(options.column)
                        }
                    };
                    _proto._columnOptionChanged = function(e) {
                        const {
                            changeTypes: changeTypes
                        } = e;
                        const {
                            optionNames: optionNames
                        } = e;
                        if (changeTypes.grouping || changeTypes.groupExpanding) {
                            if (changeTypes.grouping) {
                                this._isGroupingChanged = true
                            }
                            return
                        }
                        _ColumnsView.prototype._columnOptionChanged.call(this, e);
                        if (optionNames.width || optionNames.visible) {
                            this.resizeCompleted.fire()
                        }
                    };
                    _proto._isElementVisible = function(elementOptions) {
                        return elementOptions && elementOptions.visible
                    };
                    _proto._alignCaptionByCenter = function($cell) {
                        let $indicatorsContainer = this._getIndicatorContainer($cell, true);
                        if ($indicatorsContainer && $indicatorsContainer.length) {
                            $indicatorsContainer.filter(".".concat("dx-visibility-hidden")).remove();
                            $indicatorsContainer = this._getIndicatorContainer($cell);
                            $indicatorsContainer.clone().addClass("dx-visibility-hidden").css("float", "").insertBefore($cell.children(".".concat(this.addWidgetPrefix("text-content"))))
                        }
                    };
                    _proto._updateCell = function($cell, options) {
                        if ("header" === options.rowType && "center" === options.column.alignment) {
                            this._alignCaptionByCenter($cell)
                        }
                        _ColumnsView.prototype._updateCell.apply(this, arguments)
                    };
                    _proto._updateIndicator = function($cell, column, indicatorName) {
                        const $indicatorElement = _ColumnsView.prototype._updateIndicator.apply(this, arguments);
                        if ("center" === column.alignment) {
                            this._alignCaptionByCenter($cell)
                        }
                        addCssClassesToCellContent(this, $cell, column);
                        return $indicatorElement
                    };
                    _proto._getIndicatorContainer = function($cell, returnAll) {
                        const $indicatorsContainer = _ColumnsView.prototype._getIndicatorContainer.call(this, $cell);
                        return returnAll ? $indicatorsContainer : $indicatorsContainer.filter(":not(.".concat("dx-visibility-hidden", ")"))
                    };
                    _proto._isSortableElement = function($target) {
                        return true
                    };
                    _proto.getHeadersRowHeight = function() {
                        const $tableElement = this.getTableElement();
                        const $headerRows = $tableElement && $tableElement.find(".".concat("dx-header-row"));
                        return $headerRows && $headerRows.toArray().reduce((sum, headerRow) => sum + (0, _size.getHeight)(headerRow), 0) || 0
                    };
                    _proto.getHeaderElement = function(index) {
                        const columnElements = this.getColumnElements();
                        return columnElements && columnElements.eq(index)
                    };
                    _proto.getColumnElements = function(index, bandColumnIndex) {
                        const that = this;
                        let $cellElement;
                        const columnsController = that._columnsController;
                        const rowCount = that.getRowCount();
                        if (that.option("showColumnHeaders")) {
                            if (rowCount > 1 && (!(0, _type.isDefined)(index) || (0, _type.isDefined)(bandColumnIndex))) {
                                const result = [];
                                const visibleColumns = (0, _type.isDefined)(bandColumnIndex) ? columnsController.getChildrenByBandColumn(bandColumnIndex, true) : columnsController.getVisibleColumns();
                                (0, _iterator.each)(visibleColumns, (_, column) => {
                                    const rowIndex = (0, _type.isDefined)(index) ? index : columnsController.getRowIndex(column.index);
                                    $cellElement = that._getCellElement(rowIndex, columnsController.getVisibleIndex(column.index, rowIndex));
                                    $cellElement && result.push($cellElement.get(0))
                                });
                                return (0, _renderer.default)(result)
                            }
                            if (!index || index < rowCount) {
                                return that.getCellElements(index || 0)
                            }
                        }
                        return
                    };
                    _proto.getColumnIndexByElement = function($cell) {
                        const cellIndex = this.getCellIndex($cell);
                        const $row = $cell.closest(".dx-row");
                        const {
                            rowIndex: rowIndex
                        } = $row[0];
                        const column = this.getColumns(rowIndex)[cellIndex];
                        return column ? column.index : -1
                    };
                    _proto.getVisibleColumnIndex = function(columnIndex, rowIndex) {
                        const column = this.getColumns()[columnIndex];
                        return column ? this._columnsController.getVisibleIndex(column.index, rowIndex) : -1
                    };
                    _proto.getColumnWidths = function() {
                        const $columnElements = this.getColumnElements();
                        if ($columnElements && $columnElements.length) {
                            return this._getWidths($columnElements)
                        }
                        return _ColumnsView.prototype.getColumnWidths.apply(this, arguments)
                    };
                    _proto.allowDragging = function(column) {
                        var _a;
                        const rowIndex = column && this._columnsController.getRowIndex(column.index);
                        const columns = this.getColumns(rowIndex);
                        const isReorderingEnabled = null !== (_a = this.option("allowColumnReordering")) && void 0 !== _a ? _a : this._columnsController.isColumnOptionUsed("allowReordering");
                        return isReorderingEnabled && column.allowReordering && columns.length > 1
                    };
                    _proto.getBoundingRect = function() {
                        const that = this;
                        const $columnElements = that.getColumnElements();
                        if ($columnElements && $columnElements.length) {
                            const offset = that.getTableElement().offset();
                            return {
                                top: offset.top
                            }
                        }
                        return null
                    };
                    _proto.getName = function() {
                        return "headers"
                    };
                    _proto.getColumnCount = function() {
                        const $columnElements = this.getColumnElements();
                        return $columnElements ? $columnElements.length : 0
                    };
                    _proto.isVisible = function() {
                        return this.option("showColumnHeaders")
                    };
                    _proto.optionChanged = function(args) {
                        const that = this;
                        switch (args.name) {
                            case "showColumnHeaders":
                            case "wordWrapEnabled":
                            case "showColumnLines":
                                that._invalidate(true, true);
                                args.handled = true;
                                break;
                            default:
                                _ColumnsView.prototype.optionChanged.call(this, args)
                        }
                    };
                    _proto.getHeight = function() {
                        return this.getElementHeight()
                    };
                    _proto.getContextMenuItems = function(options) {
                        const that = this;
                        const {
                            column: column
                        } = options;
                        if (options.row && ("header" === options.row.rowType || "detailAdaptive" === options.row.rowType)) {
                            const sortingOptions = that.option("sorting");
                            if (sortingOptions && "none" !== sortingOptions.mode && column && column.allowSorting) {
                                const onItemClick = function(params) {
                                    setTimeout(() => {
                                        that._columnsController.changeSortOrder(column.index, params.itemData.value)
                                    })
                                };
                                return [{
                                    text: sortingOptions.ascendingText,
                                    value: "asc",
                                    disabled: "asc" === column.sortOrder,
                                    icon: "context-menu-sort-asc",
                                    onItemClick: onItemClick
                                }, {
                                    text: sortingOptions.descendingText,
                                    value: "desc",
                                    disabled: "desc" === column.sortOrder,
                                    icon: "context-menu-sort-desc",
                                    onItemClick: onItemClick
                                }, {
                                    text: sortingOptions.clearText,
                                    value: "none",
                                    disabled: !column.sortOrder,
                                    icon: "context-menu-sort-none",
                                    onItemClick: onItemClick
                                }]
                            }
                        }
                        return
                    };
                    _proto.getRowCount = function() {
                        return this._columnsController && this._columnsController.getRowCount()
                    };
                    _proto.setRowsOpacity = function(columnIndex, value, rowIndex) {
                        let i;
                        let columnElements;
                        const rowCount = this.getRowCount();
                        const columns = this._columnsController.getColumns();
                        const column = columns && columns[columnIndex];
                        const columnID = column && column.isBand && column.index;
                        const setColumnOpacity = (column, index) => {
                            if (column.ownerBand === columnID) {
                                columnElements.eq(index).css({
                                    opacity: value
                                });
                                if (column.isBand) {
                                    this.setRowsOpacity(column.index, value, i + 1)
                                }
                            }
                        };
                        if ((0, _type.isDefined)(columnID)) {
                            rowIndex = rowIndex || 0;
                            for (i = rowIndex; i < rowCount; i++) {
                                columnElements = this.getCellElements(i);
                                if (columnElements) {
                                    const rowColumns = this.getColumns(i);
                                    rowColumns.forEach(setColumnOpacity)
                                }
                            }
                        }
                    };
                    return ColumnHeadersView
                }(_m_columns_view.ColumnsView);
                exports.ColumnHeadersView = ColumnHeadersView;
                const columnHeadersModule = {
                    defaultOptions: () => ({
                        showColumnHeaders: true,
                        cellHintEnabled: true
                    }),
                    views: {
                        columnHeadersView: ColumnHeadersView
                    }
                };
                exports.columnHeadersModule = columnHeadersModule
            },
        51255:
            /*!*******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/column_state_mixin/m_column_state_mixin.js ***!
              \*******************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.ColumnStateMixin = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../../../../core/renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _position = __webpack_require__( /*! ../../../../core/utils/position */ 37518);

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                const ColumnStateMixin = Base => function(_Base) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(_class, _Base);

                    function _class() {
                        return _Base.apply(this, arguments) || this
                    }
                    var _proto = _class.prototype;
                    _proto._applyColumnState = function(options) {
                        var _a;
                        const rtlEnabled = this.option("rtlEnabled");
                        const columnAlignment = this._getColumnAlignment(options.column.alignment, rtlEnabled);
                        const parameters = (0, _extend.extend)(true, {
                            columnAlignment: columnAlignment
                        }, options);
                        const isGroupPanelItem = parameters.rootElement.hasClass("dx-group-panel-item");
                        const $indicatorsContainer = this._createIndicatorContainer(parameters, isGroupPanelItem);
                        const $span = (0, _renderer.default)("<span>").addClass(this._getIndicatorClassName(options.name));
                        const columnsController = null === (_a = this.component) || void 0 === _a ? void 0 : _a.getController("columns");
                        const indicatorAlignment = (null === columnsController || void 0 === columnsController ? void 0 : columnsController.getHeaderContentAlignment(columnAlignment)) || columnAlignment;
                        parameters.container = $indicatorsContainer;
                        parameters.indicator = $span;
                        this._renderIndicator(parameters);
                        $indicatorsContainer[(isGroupPanelItem || !options.showColumnLines) && "left" === indicatorAlignment ? "appendTo" : "prependTo"](options.rootElement);
                        return $span
                    };
                    _proto._getIndicatorClassName = function(name) {};
                    _proto._getColumnAlignment = function(alignment, rtlEnabled) {
                        rtlEnabled = rtlEnabled || this.option("rtlEnabled");
                        return alignment && "center" !== alignment ? alignment : (0, _position.getDefaultAlignment)(rtlEnabled)
                    };
                    _proto._createIndicatorContainer = function(options, ignoreIndicatorAlignment) {
                        let $indicatorsContainer = this._getIndicatorContainer(options.rootElement);
                        const indicatorAlignment = "left" === options.columnAlignment ? "right" : "left";
                        if (!$indicatorsContainer.length) {
                            $indicatorsContainer = (0, _renderer.default)("<div>").addClass("dx-column-indicators")
                        }
                        this.setAria("role", "presentation", $indicatorsContainer);
                        return $indicatorsContainer.css("float", options.showColumnLines && !ignoreIndicatorAlignment ? indicatorAlignment : null)
                    };
                    _proto._getIndicatorContainer = function($cell) {
                        return $cell && $cell.find(".".concat("dx-column-indicators"))
                    };
                    _proto._getIndicatorElements = function($cell) {
                        const $indicatorContainer = this._getIndicatorContainer($cell);
                        return $indicatorContainer && $indicatorContainer.children()
                    };
                    _proto._renderIndicator = function(options) {
                        const $container = options.container;
                        const $indicator = options.indicator;
                        $container && $indicator && $container.append($indicator)
                    };
                    _proto._updateIndicators = function(indicatorName) {
                        const that = this;
                        const columns = that.getColumns();
                        const $cells = that.getColumnElements();
                        let $cell;
                        if (!$cells || columns.length !== $cells.length) {
                            return
                        }
                        for (let i = 0; i < columns.length; i++) {
                            $cell = $cells.eq(i);
                            that._updateIndicator($cell, columns[i], indicatorName);
                            const rowOptions = $cell.parent().data("options");
                            if (rowOptions && rowOptions.cells) {
                                rowOptions.cells[$cell.index()].column = columns[i]
                            }
                        }
                    };
                    _proto._updateIndicator = function($cell, column, indicatorName) {
                        if (!column.command) {
                            return this._applyColumnState({
                                name: indicatorName,
                                rootElement: $cell,
                                column: column,
                                showColumnLines: this.option("showColumnLines")
                            })
                        }
                        return
                    };
                    return _class
                }(Base);
                exports.ColumnStateMixin = ColumnStateMixin;
                var _default = ColumnStateMixin;
                exports.default = _default
            },
        54057:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/columns_controller/const.js ***!
              \****************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.USER_STATE_FIELD_NAMES_15_1 = exports.USER_STATE_FIELD_NAMES = exports.MAX_SAFE_INTEGER = exports.IGNORE_COLUMN_OPTION_NAMES = exports.GROUP_LOCATION = exports.GROUP_COMMAND_COLUMN_NAME = exports.DETAIL_COMMAND_COLUMN_NAME = exports.DEFAULT_COLUMN_OPTIONS = exports.DATATYPE_OPERATIONS = exports.COMMAND_EXPAND_CLASS = exports.COLUMN_OPTION_REGEXP = exports.COLUMN_INDEX_OPTIONS = exports.COLUMN_CHOOSER_LOCATION = void 0;
                const USER_STATE_FIELD_NAMES_15_1 = ["filterValues", "filterType", "fixed", "fixedPosition"];
                exports.USER_STATE_FIELD_NAMES_15_1 = USER_STATE_FIELD_NAMES_15_1;
                const USER_STATE_FIELD_NAMES = ["visibleIndex", "dataField", "name", "dataType", "width", "visible", "sortOrder", "lastSortOrder", "sortIndex", "groupIndex", "filterValue", "bufferedFilterValue", "selectedFilterOperation", "bufferedSelectedFilterOperation", "added"].concat(USER_STATE_FIELD_NAMES_15_1);
                exports.USER_STATE_FIELD_NAMES = USER_STATE_FIELD_NAMES;
                exports.IGNORE_COLUMN_OPTION_NAMES = {
                    visibleWidth: true,
                    bestFitWidth: true,
                    bufferedFilterValue: true
                };
                exports.COMMAND_EXPAND_CLASS = "dx-command-expand";
                const MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
                exports.MAX_SAFE_INTEGER = MAX_SAFE_INTEGER;
                exports.GROUP_COMMAND_COLUMN_NAME = "groupExpand";
                exports.DETAIL_COMMAND_COLUMN_NAME = "detailExpand";
                exports.COLUMN_OPTION_REGEXP = /columns\[(\d+)\]\.?/gi;
                exports.DEFAULT_COLUMN_OPTIONS = {
                    visible: true,
                    showInColumnChooser: true
                };
                exports.DATATYPE_OPERATIONS = {
                    number: ["=", "<>", "<", ">", "<=", ">=", "between"],
                    string: ["contains", "notcontains", "startswith", "endswith", "=", "<>"],
                    date: ["=", "<>", "<", ">", "<=", ">=", "between"],
                    datetime: ["=", "<>", "<", ">", "<=", ">=", "between"]
                };
                exports.COLUMN_INDEX_OPTIONS = {
                    visibleIndex: true,
                    groupIndex: true,
                    grouped: true,
                    sortIndex: true,
                    sortOrder: true
                };
                exports.GROUP_LOCATION = "group";
                exports.COLUMN_CHOOSER_LOCATION = "columnChooser"
            },
        10279:
            /*!*******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/columns_controller/m_columns_controller.js ***!
              \*******************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnsControllerModule = exports.ColumnsController = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../../../core/config */ 80209));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/callbacks */ 44504));
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _inflector = __webpack_require__( /*! ../../../../core/utils/inflector */ 78008);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _object = __webpack_require__( /*! ../../../../core/utils/object */ 48013);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/variable_wrapper */ 26974));
                var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ../../../../data/abstract_store */ 67403));
                var _data_source = __webpack_require__( /*! ../../../../data/data_source/data_source */ 85273);
                var _utils = __webpack_require__( /*! ../../../../data/data_source/utils */ 9234);
                var _date = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/date */ 91500));
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _filtering = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/shared/filtering */ 18740));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));
                var _const = __webpack_require__( /*! ./const */ 54057);
                var _m_columns_controller_utils = __webpack_require__( /*! ./m_columns_controller_utils */ 22732);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                let ColumnsController = function(_modules$Controller) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(ColumnsController, _modules$Controller);

                    function ColumnsController() {
                        return _modules$Controller.apply(this, arguments) || this
                    }
                    var _proto = ColumnsController.prototype;
                    _proto.init = function(isApplyingUserState) {
                        this._dataController = this.getController("data");
                        this._focusController = this.getController("focus");
                        this._stateStoringController = this.getController("stateStoring");
                        const columns = this.option("columns");
                        this._commandColumns = this._commandColumns || [];
                        this._columns = this._columns || [];
                        this._isColumnsFromOptions = !!columns;
                        if (this._isColumnsFromOptions) {
                            (0, _m_columns_controller_utils.assignColumns)(this, columns ? (0, _m_columns_controller_utils.createColumnsFromOptions)(this, columns) : []);
                            (0, _m_columns_controller_utils.applyUserState)(this)
                        } else {
                            (0, _m_columns_controller_utils.assignColumns)(this, this._columnsUserState ? (0, _m_columns_controller_utils.createColumnsFromOptions)(this, this._columnsUserState) : this._columns)
                        }(0, _m_columns_controller_utils.addExpandColumn)(this);
                        if (this._dataSourceApplied) {
                            this.applyDataSource(this._dataSource, true, isApplyingUserState)
                        } else {
                            (0, _m_columns_controller_utils.updateIndexes)(this)
                        }
                        this._checkColumns()
                    };
                    _proto._getExpandColumnOptions = function() {
                        return {
                            type: "expand",
                            command: "expand",
                            width: "auto",
                            cssClass: _const.COMMAND_EXPAND_CLASS,
                            allowEditing: false,
                            allowGrouping: false,
                            allowSorting: false,
                            allowResizing: false,
                            allowReordering: false,
                            allowHiding: false
                        }
                    };
                    _proto._getFirstItems = function(dataSource) {
                        let groupsCount;
                        let items = [];
                        const getFirstItemsCore = function(items, groupsCount) {
                            if (!items || !groupsCount) {
                                return items
                            }
                            for (let i = 0; i < items.length; i++) {
                                const childItems = getFirstItemsCore(items[i].items || items[i].collapsedItems, groupsCount - 1);
                                if (childItems && childItems.length) {
                                    return childItems
                                }
                            }
                        };
                        if (dataSource && dataSource.items().length > 0) {
                            groupsCount = _m_utils.default.normalizeSortingInfo(dataSource.group()).length;
                            items = getFirstItemsCore(dataSource.items(), groupsCount) || []
                        }
                        return items
                    };
                    _proto._endUpdateCore = function() {
                        !this._skipProcessingColumnsChange && (0, _m_columns_controller_utils.fireColumnsChanged)(this)
                    };
                    _proto.callbackNames = function() {
                        return ["columnsChanged"]
                    };
                    _proto.getColumnByPath = function(path, columns) {
                        const that = this;
                        let column;
                        const columnIndexes = [];
                        path.replace(_const.COLUMN_OPTION_REGEXP, (_, columnIndex) => {
                            columnIndexes.push(parseInt(columnIndex));
                            return ""
                        });
                        if (columnIndexes.length) {
                            if (columns) {
                                column = columnIndexes.reduce((column, index) => column && column.columns && column.columns[index], {
                                    columns: columns
                                })
                            } else {
                                column = (0, _m_columns_controller_utils.getColumnByIndexes)(that, columnIndexes)
                            }
                        }
                        return column
                    };
                    _proto.optionChanged = function(args) {
                        let needUpdateRequireResize;
                        switch (args.name) {
                            case "adaptColumnWidthByRatio":
                                args.handled = true;
                                break;
                            case "dataSource":
                                if (args.value !== args.previousValue && !this.option("columns") && (!Array.isArray(args.value) || !Array.isArray(args.previousValue))) {
                                    this._columns = []
                                }
                                break;
                            case "columns":
                                needUpdateRequireResize = this._skipProcessingColumnsChange;
                                args.handled = true;
                                if (!this._skipProcessingColumnsChange) {
                                    if (args.name === args.fullName) {
                                        this._columnsUserState = null;
                                        this._ignoreColumnOptionNames = null;
                                        this.init()
                                    } else {
                                        this._columnOptionChanged(args);
                                        needUpdateRequireResize = true
                                    }
                                }
                                if (needUpdateRequireResize) {
                                    this._updateRequireResize(args)
                                }
                                break;
                            case "commonColumnSettings":
                            case "columnAutoWidth":
                            case "allowColumnResizing":
                            case "allowColumnReordering":
                            case "columnFixing":
                            case "grouping":
                            case "groupPanel":
                            case "regenerateColumnsByVisibleItems":
                            case "customizeColumns":
                            case "columnHidingEnabled":
                            case "dateSerializationFormat":
                            case "columnResizingMode":
                            case "columnMinWidth":
                            case "columnWidth": {
                                args.handled = true;
                                const ignoreColumnOptionNames = "columnWidth" === args.fullName && ["width"];
                                this.reinit(ignoreColumnOptionNames);
                                break
                            }
                            case "rtlEnabled":
                                this.reinit();
                                break;
                            default:
                                _modules$Controller.prototype.optionChanged.call(this, args)
                        }
                    };
                    _proto._columnOptionChanged = function(args) {
                        let columnOptionValue = {};
                        const column = this.getColumnByPath(args.fullName);
                        const columnOptionName = args.fullName.replace(_const.COLUMN_OPTION_REGEXP, "");
                        if (column) {
                            if (columnOptionName) {
                                columnOptionValue[columnOptionName] = args.value
                            } else {
                                columnOptionValue = args.value
                            }
                            this._skipProcessingColumnsChange = args.fullName;
                            this.columnOption(column.index, columnOptionValue);
                            this._skipProcessingColumnsChange = false
                        }
                    };
                    _proto._updateRequireResize = function(args) {
                        const {
                            component: component
                        } = this;
                        if ("width" === args.fullName.replace(_const.COLUMN_OPTION_REGEXP, "") && component._updateLockCount) {
                            component._requireResize = true
                        }
                    };
                    _proto.publicMethods = function() {
                        return ["addColumn", "deleteColumn", "columnOption", "columnCount", "clearSorting", "clearGrouping", "getVisibleColumns", "getVisibleColumnIndex"]
                    };
                    _proto.applyDataSource = function(dataSource, forceApplying, isApplyingUserState) {
                        const that = this;
                        const isDataSourceLoaded = dataSource && dataSource.isLoaded();
                        that._dataSource = dataSource;
                        if (!that._dataSourceApplied || 0 === that._dataSourceColumnsCount || forceApplying || that.option("regenerateColumnsByVisibleItems")) {
                            if (isDataSourceLoaded) {
                                if (!that._isColumnsFromOptions) {
                                    const columnsFromDataSource = (0, _m_columns_controller_utils.createColumnsFromDataSource)(that, dataSource);
                                    if (columnsFromDataSource.length) {
                                        (0, _m_columns_controller_utils.assignColumns)(that, columnsFromDataSource);
                                        that._dataSourceColumnsCount = that._columns.length;
                                        (0, _m_columns_controller_utils.applyUserState)(that)
                                    }
                                }
                                return that.updateColumns(dataSource, forceApplying, isApplyingUserState)
                            }
                            that._dataSourceApplied = false;
                            (0, _m_columns_controller_utils.updateIndexes)(that)
                        } else if (isDataSourceLoaded && !that.isAllDataTypesDefined(true) && that.updateColumnDataTypes(dataSource)) {
                            (0, _m_columns_controller_utils.updateColumnChanges)(that, "columns");
                            (0, _m_columns_controller_utils.fireColumnsChanged)(that);
                            return (new _deferred.Deferred).reject().promise()
                        }
                    };
                    _proto.reset = function() {
                        this._dataSource = null;
                        this._dataSourceApplied = false;
                        this._dataSourceColumnsCount = void 0;
                        this.reinit()
                    };
                    _proto.resetColumnsCache = function() {
                        this._visibleColumns = void 0;
                        this._fixedColumns = void 0;
                        this._rowCount = void 0;
                        (0, _m_columns_controller_utils.resetBandColumnsCache)(this)
                    };
                    _proto.reinit = function(ignoreColumnOptionNames) {
                        this._columnsUserState = this.getUserState();
                        this._ignoreColumnOptionNames = ignoreColumnOptionNames || null;
                        this.init();
                        if (ignoreColumnOptionNames) {
                            this._ignoreColumnOptionNames = null
                        }
                    };
                    _proto.isInitialized = function() {
                        return !!this._columns.length || !!this.option("columns")
                    };
                    _proto.isDataSourceApplied = function() {
                        return this._dataSourceApplied
                    };
                    _proto.getCommonSettings = function(column) {
                        var _a, _b;
                        const commonColumnSettings = (!column || !column.type) && this.option("commonColumnSettings") || {};
                        const groupingOptions = null !== (_a = this.option("grouping")) && void 0 !== _a ? _a : {};
                        const groupPanelOptions = null !== (_b = this.option("groupPanel")) && void 0 !== _b ? _b : {};
                        return (0, _extend.extend)({
                            allowFixing: this.option("columnFixing.enabled"),
                            allowResizing: this.option("allowColumnResizing") || void 0,
                            allowReordering: this.option("allowColumnReordering"),
                            minWidth: this.option("columnMinWidth"),
                            width: this.option("columnWidth"),
                            autoExpandGroup: groupingOptions.autoExpandAll,
                            allowCollapsing: groupingOptions.allowCollapsing,
                            allowGrouping: groupPanelOptions.allowColumnDragging && groupPanelOptions.visible || groupingOptions.contextMenuEnabled
                        }, commonColumnSettings)
                    };
                    _proto.isColumnOptionUsed = function(optionName) {
                        for (let i = 0; i < this._columns.length; i++) {
                            if (this._columns[i][optionName]) {
                                return true
                            }
                        }
                    };
                    _proto.isAllDataTypesDefined = function(checkSerializers) {
                        const columns = this._columns;
                        if (!columns.length) {
                            return false
                        }
                        for (let i = 0; i < columns.length; i++) {
                            if (!columns[i].dataField && columns[i].calculateCellValue === columns[i].defaultCalculateCellValue) {
                                continue
                            }
                            if (!columns[i].dataType || checkSerializers && columns[i].deserializeValue && void 0 === columns[i].serializationFormat) {
                                return false
                            }
                        }
                        return true
                    };
                    _proto.getColumns = function() {
                        return this._columns
                    };
                    _proto.isBandColumnsUsed = function() {
                        return this.getColumns().some(column => column.isBand)
                    };
                    _proto.getGroupColumns = function() {
                        const result = [];
                        (0, _iterator.each)(this._columns, (function() {
                            const column = this;
                            if ((0, _type.isDefined)(column.groupIndex)) {
                                result[column.groupIndex] = column
                            }
                        }));
                        return result
                    };
                    _proto._shouldReturnVisibleColumns = function() {
                        return true
                    };
                    _proto._compileVisibleColumns = function(rowIndex) {
                        this._visibleColumns = this._visibleColumns || this._compileVisibleColumnsCore();
                        rowIndex = (0, _type.isDefined)(rowIndex) ? rowIndex : this._visibleColumns.length - 1;
                        return this._visibleColumns[rowIndex] || []
                    };
                    _proto.getVisibleColumns = function(rowIndex, isBase) {
                        if (!this._shouldReturnVisibleColumns()) {
                            return []
                        }
                        return this._compileVisibleColumns.apply(this, arguments)
                    };
                    _proto.getFixedColumns = function(rowIndex) {
                        this._fixedColumns = this._fixedColumns || this._getFixedColumnsCore();
                        rowIndex = (0, _type.isDefined)(rowIndex) ? rowIndex : this._fixedColumns.length - 1;
                        return this._fixedColumns[rowIndex] || []
                    };
                    _proto.getFilteringColumns = function() {
                        return this.getColumns().filter(item => (item.dataField || item.name) && (item.allowFiltering || item.allowHeaderFiltering)).map(item => {
                            const field = (0, _extend.extend)(true, {}, item);
                            if (!(0, _type.isDefined)(field.dataField)) {
                                field.dataField = field.name
                            }
                            field.filterOperations = item.filterOperations !== item.defaultFilterOperations ? field.filterOperations : null;
                            return field
                        })
                    };
                    _proto.getColumnIndexOffset = function() {
                        return 0
                    };
                    _proto._getFixedColumnsCore = function() {
                        const that = this;
                        const result = [];
                        const rowCount = that.getRowCount();
                        const isColumnFixing = that._isColumnFixing();
                        const transparentColumn = {
                            command: "transparent"
                        };
                        let transparentColspan = 0;
                        let notFixedColumnCount;
                        let transparentColumnIndex;
                        let lastFixedPosition;
                        if (isColumnFixing) {
                            for (let i = 0; i <= rowCount; i++) {
                                notFixedColumnCount = 0;
                                lastFixedPosition = null;
                                transparentColumnIndex = null;
                                const visibleColumns = that.getVisibleColumns(i, true);
                                for (let j = 0; j < visibleColumns.length; j++) {
                                    const prevColumn = visibleColumns[j - 1];
                                    const column = visibleColumns[j];
                                    if (!column.fixed) {
                                        if (0 === i) {
                                            if (column.isBand && column.colspan) {
                                                transparentColspan += column.colspan
                                            } else {
                                                transparentColspan++
                                            }
                                        }
                                        notFixedColumnCount++;
                                        if (!(0, _type.isDefined)(transparentColumnIndex)) {
                                            transparentColumnIndex = j
                                        }
                                    } else if (prevColumn && prevColumn.fixed && (0, _m_columns_controller_utils.getFixedPosition)(that, prevColumn) !== (0, _m_columns_controller_utils.getFixedPosition)(that, column)) {
                                        if (!(0, _type.isDefined)(transparentColumnIndex)) {
                                            transparentColumnIndex = j
                                        }
                                    } else {
                                        lastFixedPosition = column.fixedPosition
                                    }
                                }
                                if (0 === i && (0 === notFixedColumnCount || notFixedColumnCount >= visibleColumns.length)) {
                                    return []
                                }
                                if (!(0, _type.isDefined)(transparentColumnIndex)) {
                                    transparentColumnIndex = "right" === lastFixedPosition ? 0 : visibleColumns.length
                                }
                                result[i] = visibleColumns.slice(0);
                                if (!transparentColumn.colspan) {
                                    transparentColumn.colspan = transparentColspan
                                }
                                result[i].splice(transparentColumnIndex, notFixedColumnCount, transparentColumn)
                            }
                        }
                        return result.map(columns => columns.map(column => {
                            const newColumn = _extends({}, column);
                            if (newColumn.headerId) {
                                newColumn.headerId += "-fixed"
                            }
                            return newColumn
                        }))
                    };
                    _proto._isColumnFixing = function() {
                        let isColumnFixing = this.option("columnFixing.enabled");
                        !isColumnFixing && (0, _iterator.each)(this._columns, (_, column) => {
                            if (column.fixed) {
                                isColumnFixing = true;
                                return false
                            }
                        });
                        return isColumnFixing
                    };
                    _proto._getExpandColumnsCore = function() {
                        return this.getGroupColumns()
                    };
                    _proto.getExpandColumns = function() {
                        let expandColumns = this._getExpandColumnsCore();
                        let expandColumn;
                        const firstGroupColumn = expandColumns.filter(column => 0 === column.groupIndex)[0];
                        const isFixedFirstGroupColumn = firstGroupColumn && firstGroupColumn.fixed;
                        const isColumnFixing = this._isColumnFixing();
                        const rtlEnabled = this.option("rtlEnabled");
                        if (expandColumns.length) {
                            expandColumn = this.columnOption("command:expand")
                        }
                        expandColumns = (0, _iterator.map)(expandColumns, column => (0, _extend.extend)({}, column, {
                            visibleWidth: null,
                            minWidth: null,
                            cellTemplate: !(0, _type.isDefined)(column.groupIndex) ? column.cellTemplate : null,
                            headerCellTemplate: null,
                            fixed: !(0, _type.isDefined)(column.groupIndex) || !isFixedFirstGroupColumn ? isColumnFixing : true,
                            fixedPosition: rtlEnabled ? "right" : "left"
                        }, expandColumn, {
                            index: column.index,
                            type: column.type || _const.GROUP_COMMAND_COLUMN_NAME
                        }));
                        return expandColumns
                    };
                    _proto.getBandColumnsCache = function() {
                        if (!this._bandColumnsCache) {
                            const columns = this._columns;
                            const columnChildrenByIndex = {};
                            const columnParentByIndex = {};
                            let isPlain = true;
                            columns.forEach(column => {
                                const {
                                    ownerBand: ownerBand
                                } = column;
                                let parentIndex = (0, _type.isObject)(ownerBand) ? ownerBand.index : ownerBand;
                                const parent = columns[parentIndex];
                                if (column.hasColumns) {
                                    isPlain = false
                                }
                                if (column.colspan) {
                                    column.colspan = void 0
                                }
                                if (column.rowspan) {
                                    column.rowspan = void 0
                                }
                                if (parent) {
                                    columnParentByIndex[column.index] = parent
                                } else {
                                    parentIndex = -1
                                }
                                columnChildrenByIndex[parentIndex] = columnChildrenByIndex[parentIndex] || [];
                                columnChildrenByIndex[parentIndex].push(column)
                            });
                            this._bandColumnsCache = {
                                isPlain: isPlain,
                                columnChildrenByIndex: columnChildrenByIndex,
                                columnParentByIndex: columnParentByIndex
                            }
                        }
                        return this._bandColumnsCache
                    };
                    _proto._isColumnVisible = function(column) {
                        return column.visible && this.isParentColumnVisible(column.index)
                    };
                    _proto._isColumnInGroupPanel = function(column) {
                        return (0, _type.isDefined)(column.groupIndex) && !column.showWhenGrouped
                    };
                    _proto.hasVisibleDataColumns = function() {
                        const columns = this._columns;
                        return columns.some(column => {
                            const isVisible = this._isColumnVisible(column);
                            const isInGroupPanel = this._isColumnInGroupPanel(column);
                            const isCommand = !!column.command;
                            return isVisible && !isInGroupPanel && !isCommand
                        })
                    };
                    _proto._compileVisibleColumnsCore = function() {
                        const bandColumnsCache = this.getBandColumnsCache();
                        const columns = (0, _m_columns_controller_utils.mergeColumns)(this, this._columns, this._commandColumns, true);
                        (0, _m_columns_controller_utils.processBandColumns)(this, columns, bandColumnsCache);
                        const indexedColumns = this._getIndexedColumns(columns);
                        const visibleColumns = this._getVisibleColumnsFromIndexed(indexedColumns);
                        const isDataColumnsInvisible = !this.hasVisibleDataColumns();
                        if (isDataColumnsInvisible && this._columns.length) {
                            visibleColumns[visibleColumns.length - 1].push({
                                command: "empty"
                            })
                        }
                        return visibleColumns
                    };
                    _proto._getIndexedColumns = function(columns) {
                        const rtlEnabled = this.option("rtlEnabled");
                        const rowCount = this.getRowCount();
                        const columnDigitsCount = (0, _m_columns_controller_utils.digitsCount)(columns.length);
                        const bandColumnsCache = this.getBandColumnsCache();
                        const positiveIndexedColumns = [];
                        const negativeIndexedColumns = [];
                        for (let i = 0; i < rowCount; i += 1) {
                            negativeIndexedColumns[i] = [{}];
                            positiveIndexedColumns[i] = [{}, {}, {}]
                        }
                        columns.forEach(column => {
                            var _a, _b, _c, _d;
                            let {
                                visibleIndex: visibleIndex
                            } = column;
                            let indexedColumns;
                            const parentBandColumns = (0, _m_columns_controller_utils.getParentBandColumns)(column.index, bandColumnsCache.columnParentByIndex);
                            const isVisible = this._isColumnVisible(column);
                            const isInGroupPanel = this._isColumnInGroupPanel(column);
                            if (isVisible && !isInGroupPanel) {
                                const rowIndex = parentBandColumns.length;
                                if (visibleIndex < 0) {
                                    visibleIndex = -visibleIndex;
                                    indexedColumns = negativeIndexedColumns[rowIndex]
                                } else {
                                    column.fixed = null !== (_b = null === (_a = parentBandColumns[0]) || void 0 === _a ? void 0 : _a.fixed) && void 0 !== _b ? _b : column.fixed;
                                    column.fixedPosition = null !== (_d = null === (_c = parentBandColumns[0]) || void 0 === _c ? void 0 : _c.fixedPosition) && void 0 !== _d ? _d : column.fixedPosition;
                                    if (column.fixed) {
                                        const isDefaultCommandColumn = !!column.command && !(0, _m_columns_controller_utils.isCustomCommandColumn)(this, column);
                                        let isFixedToEnd = "right" === column.fixedPosition;
                                        if (rtlEnabled && !isDefaultCommandColumn) {
                                            isFixedToEnd = !isFixedToEnd
                                        }
                                        indexedColumns = isFixedToEnd ? positiveIndexedColumns[rowIndex][2] : positiveIndexedColumns[rowIndex][0]
                                    } else {
                                        indexedColumns = positiveIndexedColumns[rowIndex][1]
                                    }
                                }
                                if (parentBandColumns.length) {
                                    visibleIndex = (0, _m_columns_controller_utils.numberToString)(visibleIndex, columnDigitsCount);
                                    for (let i = parentBandColumns.length - 1; i >= 0; i -= 1) {
                                        visibleIndex = (0, _m_columns_controller_utils.numberToString)(parentBandColumns[i].visibleIndex, columnDigitsCount) + visibleIndex
                                    }
                                }
                                indexedColumns[visibleIndex] = indexedColumns[visibleIndex] || [];
                                indexedColumns[visibleIndex].push(column)
                            }
                        });
                        return {
                            positiveIndexedColumns: positiveIndexedColumns,
                            negativeIndexedColumns: negativeIndexedColumns
                        }
                    };
                    _proto._getVisibleColumnsFromIndexed = function(_ref) {
                        let {
                            positiveIndexedColumns: positiveIndexedColumns,
                            negativeIndexedColumns: negativeIndexedColumns
                        } = _ref;
                        const result = [];
                        const rowCount = this.getRowCount();
                        const expandColumns = (0, _m_columns_controller_utils.mergeColumns)(this, this.getExpandColumns(), this._columns);
                        let rowspanGroupColumns = 0;
                        let rowspanExpandColumns = 0;
                        for (let rowIndex = 0; rowIndex < rowCount; rowIndex += 1) {
                            result.push([]);
                            (0, _object.orderEach)(negativeIndexedColumns[rowIndex], (_, columns) => {
                                result[rowIndex].unshift.apply(result[rowIndex], columns)
                            });
                            const firstPositiveIndexColumn = result[rowIndex].length;
                            const positiveIndexedRowColumns = positiveIndexedColumns[rowIndex];
                            positiveIndexedRowColumns.forEach(columnsByFixing => {
                                (0, _object.orderEach)(columnsByFixing, (_, columnsByVisibleIndex) => {
                                    result[rowIndex].push.apply(result[rowIndex], columnsByVisibleIndex)
                                })
                            });
                            if (rowspanExpandColumns <= rowIndex) {
                                rowspanExpandColumns += _m_columns_controller_utils.processExpandColumns.call(this, result[rowIndex], expandColumns, _const.DETAIL_COMMAND_COLUMN_NAME, firstPositiveIndexColumn)
                            }
                            if (rowspanGroupColumns <= rowIndex) {
                                rowspanGroupColumns += _m_columns_controller_utils.processExpandColumns.call(this, result[rowIndex], expandColumns, _const.GROUP_COMMAND_COLUMN_NAME, firstPositiveIndexColumn)
                            }
                        }
                        result.push((0, _m_columns_controller_utils.getDataColumns)(result));
                        return result
                    };
                    _proto.getInvisibleColumns = function(columns, bandColumnIndex) {
                        const that = this;
                        let result = [];
                        let hiddenColumnsByBand;
                        columns = columns || that._columns;
                        (0, _iterator.each)(columns, (_, column) => {
                            if (column.ownerBand !== bandColumnIndex) {
                                return
                            }
                            if (column.isBand) {
                                if (!column.visible) {
                                    hiddenColumnsByBand = that.getChildrenByBandColumn(column.index)
                                } else {
                                    hiddenColumnsByBand = that.getInvisibleColumns(that.getChildrenByBandColumn(column.index), column.index)
                                }
                                if (hiddenColumnsByBand.length) {
                                    result.push(column);
                                    result = result.concat(hiddenColumnsByBand)
                                }
                                return
                            }
                            if (!column.visible) {
                                result.push(column)
                            }
                        });
                        return result
                    };
                    _proto.getChooserColumns = function(getAllColumns) {
                        const columns = getAllColumns ? this.getColumns() : this.getInvisibleColumns();
                        const columnChooserColumns = columns.filter(column => column.showInColumnChooser);
                        const sortOrder = this.option("columnChooser.sortOrder");
                        return (0, _m_columns_controller_utils.sortColumns)(columnChooserColumns, sortOrder)
                    };
                    _proto.allowMoveColumn = function(fromVisibleIndex, toVisibleIndex, sourceLocation, targetLocation) {
                        const columnIndex = (0, _m_columns_controller_utils.getColumnIndexByVisibleIndex)(this, fromVisibleIndex, sourceLocation);
                        const sourceColumn = this._columns[columnIndex];
                        if (sourceColumn && (sourceColumn.allowReordering || sourceColumn.allowGrouping || sourceColumn.allowHiding)) {
                            if (sourceLocation === targetLocation) {
                                if (sourceLocation === _const.COLUMN_CHOOSER_LOCATION) {
                                    return false
                                }
                                fromVisibleIndex = (0, _type.isObject)(fromVisibleIndex) ? fromVisibleIndex.columnIndex : fromVisibleIndex;
                                toVisibleIndex = (0, _type.isObject)(toVisibleIndex) ? toVisibleIndex.columnIndex : toVisibleIndex;
                                return fromVisibleIndex !== toVisibleIndex && fromVisibleIndex + 1 !== toVisibleIndex
                            }
                            if (sourceLocation === _const.GROUP_LOCATION && targetLocation !== _const.COLUMN_CHOOSER_LOCATION || targetLocation === _const.GROUP_LOCATION) {
                                return sourceColumn && sourceColumn.allowGrouping
                            }
                            if (sourceLocation === _const.COLUMN_CHOOSER_LOCATION || targetLocation === _const.COLUMN_CHOOSER_LOCATION) {
                                return sourceColumn && sourceColumn.allowHiding
                            }
                            return true
                        }
                        return false
                    };
                    _proto.moveColumn = function(fromVisibleIndex, toVisibleIndex, sourceLocation, targetLocation) {
                        const that = this;
                        const options = {};
                        let prevGroupIndex;
                        const fromIndex = (0, _m_columns_controller_utils.getColumnIndexByVisibleIndex)(that, fromVisibleIndex, sourceLocation);
                        const toIndex = (0, _m_columns_controller_utils.getColumnIndexByVisibleIndex)(that, toVisibleIndex, targetLocation);
                        let targetGroupIndex;
                        if (fromIndex >= 0) {
                            const column = that._columns[fromIndex];
                            toVisibleIndex = (0, _type.isObject)(toVisibleIndex) ? toVisibleIndex.columnIndex : toVisibleIndex;
                            targetGroupIndex = toIndex >= 0 ? that._columns[toIndex].groupIndex : -1;
                            if ((0, _type.isDefined)(column.groupIndex) && sourceLocation === _const.GROUP_LOCATION) {
                                if (targetGroupIndex > column.groupIndex) {
                                    targetGroupIndex--
                                }
                                if (targetLocation !== _const.GROUP_LOCATION) {
                                    options.groupIndex = void 0
                                } else {
                                    prevGroupIndex = column.groupIndex;
                                    delete column.groupIndex;
                                    (0, _m_columns_controller_utils.updateColumnGroupIndexes)(that)
                                }
                            }
                            if (targetLocation === _const.GROUP_LOCATION) {
                                options.groupIndex = (0, _m_columns_controller_utils.moveColumnToGroup)(that, column, targetGroupIndex);
                                column.groupIndex = prevGroupIndex
                            } else if (toVisibleIndex >= 0) {
                                const targetColumn = that._columns[toIndex];
                                if (!targetColumn || column.ownerBand !== targetColumn.ownerBand) {
                                    options.visibleIndex = _const.MAX_SAFE_INTEGER
                                } else if ((0, _m_columns_controller_utils.isColumnFixed)(that, column) ^ (0, _m_columns_controller_utils.isColumnFixed)(that, targetColumn)) {
                                    options.visibleIndex = _const.MAX_SAFE_INTEGER
                                } else {
                                    options.visibleIndex = targetColumn.visibleIndex
                                }
                            }
                            const isVisible = targetLocation !== _const.COLUMN_CHOOSER_LOCATION;
                            if (column.visible !== isVisible) {
                                options.visible = isVisible
                            }
                            that.columnOption(column.index, options)
                        }
                    };
                    _proto.changeSortOrder = function(columnIndex, sortOrder) {
                        const that = this;
                        const options = {};
                        const sortingOptions = that.option("sorting");
                        const sortingMode = sortingOptions && sortingOptions.mode;
                        const needResetSorting = "single" === sortingMode || !sortOrder;
                        const allowSorting = "single" === sortingMode || "multiple" === sortingMode;
                        const column = that._columns[columnIndex];
                        if (allowSorting && column && column.allowSorting) {
                            if (needResetSorting && !(0, _type.isDefined)(column.groupIndex)) {
                                (0, _iterator.each)(that._columns, (function(index) {
                                    if (index !== columnIndex && this.sortOrder) {
                                        if (!(0, _type.isDefined)(this.groupIndex)) {
                                            delete this.sortOrder
                                        }
                                        delete this.sortIndex
                                    }
                                }))
                            }
                            if ((0, _m_columns_controller_utils.isSortOrderValid)(sortOrder)) {
                                if (column.sortOrder !== sortOrder) {
                                    options.sortOrder = sortOrder
                                }
                            } else if ("none" === sortOrder) {
                                if (column.sortOrder) {
                                    options.sortIndex = void 0;
                                    options.sortOrder = void 0
                                }
                            } else {
                                ! function(column) {
                                    if ("ctrl" === sortOrder) {
                                        if (!("sortOrder" in column && "sortIndex" in column)) {
                                            return false
                                        }
                                        options.sortOrder = void 0;
                                        options.sortIndex = void 0
                                    } else if ((0, _type.isDefined)(column.groupIndex) || (0, _type.isDefined)(column.sortIndex)) {
                                        options.sortOrder = "desc" === column.sortOrder ? "asc" : "desc"
                                    } else {
                                        options.sortOrder = "asc"
                                    }
                                    return true
                                }(column)
                            }
                        }
                        that.columnOption(column.index, options)
                    };
                    _proto.getSortDataSourceParameters = function(useLocalSelector) {
                        const sortColumns = [];
                        const sort = [];
                        (0, _iterator.each)(this._columns, (function() {
                            if ((this.dataField || this.selector || this.calculateCellValue) && (0, _type.isDefined)(this.sortIndex) && !(0, _type.isDefined)(this.groupIndex)) {
                                sortColumns[this.sortIndex] = this
                            }
                        }));
                        (0, _iterator.each)(sortColumns, (function() {
                            const sortOrder = this && this.sortOrder;
                            if ((0, _m_columns_controller_utils.isSortOrderValid)(sortOrder)) {
                                const sortItem = {
                                    selector: this.calculateSortValue || this.displayField || this.calculateDisplayValue || useLocalSelector && this.selector || this.dataField || this.calculateCellValue,
                                    desc: "desc" === this.sortOrder
                                };
                                if (this.sortingMethod) {
                                    sortItem.compare = this.sortingMethod.bind(this)
                                }
                                sort.push(sortItem)
                            }
                        }));
                        return sort.length > 0 ? sort : null
                    };
                    _proto.getGroupDataSourceParameters = function(useLocalSelector) {
                        const group = [];
                        (0, _iterator.each)(this.getGroupColumns(), (function() {
                            const selector = this.calculateGroupValue || this.displayField || this.calculateDisplayValue || useLocalSelector && this.selector || this.dataField || this.calculateCellValue;
                            if (selector) {
                                const groupItem = {
                                    selector: selector,
                                    desc: "desc" === this.sortOrder,
                                    isExpanded: !!this.autoExpandGroup
                                };
                                if (this.sortingMethod) {
                                    groupItem.compare = this.sortingMethod.bind(this)
                                }
                                group.push(groupItem)
                            }
                        }));
                        return group.length > 0 ? group : null
                    };
                    _proto.refresh = function(updateNewLookupsOnly) {
                        const deferreds = [];
                        (0, _iterator.each)(this._columns, (function() {
                            const {
                                lookup: lookup
                            } = this;
                            if (lookup && !this.calculateDisplayValue) {
                                if (updateNewLookupsOnly && lookup.valueMap) {
                                    return
                                }
                                if (lookup.update) {
                                    deferreds.push(lookup.update())
                                }
                            }
                        }));
                        return _deferred.when.apply(_renderer.default, deferreds).done(_m_columns_controller_utils.resetColumnsCache.bind(null, this))
                    };
                    _proto._updateColumnOptions = function(column, columnIndex) {
                        var _a, _b, _c, _d;
                        const shouldTakeOriginalCallbackFromPrevious = this._reinitAfterLookupChanges && (null === (_a = this._previousColumns) || void 0 === _a ? void 0 : _a[columnIndex]);
                        column.selector = null !== (_b = column.selector) && void 0 !== _b ? _b : data => column.calculateCellValue(data);
                        column.selector.columnIndex = columnIndex;
                        column.selector.originalCallback = shouldTakeOriginalCallbackFromPrevious ? null !== (_d = null === (_c = this._previousColumns[columnIndex].selector) || void 0 === _c ? void 0 : _c.originalCallback) && void 0 !== _d ? _d : column.selector : column.selector;
                        (0, _iterator.each)(["calculateSortValue", "calculateGroupValue", "calculateDisplayValue"], (_, calculateCallbackName) => {
                            const calculateCallback = column[calculateCallbackName];
                            if ((0, _type.isFunction)(calculateCallback)) {
                                if (!calculateCallback.originalCallback) {
                                    const context = {
                                        column: column
                                    };
                                    column[calculateCallbackName] = function(data) {
                                        return calculateCallback.call(context.column, data)
                                    };
                                    column[calculateCallbackName].originalCallback = calculateCallback;
                                    column[calculateCallbackName].columnIndex = columnIndex;
                                    column[calculateCallbackName].context = context
                                } else {
                                    column[calculateCallbackName].context.column = column
                                }
                            }
                        });
                        if ((0, _type.isString)(column.calculateDisplayValue)) {
                            column.displayField = column.calculateDisplayValue;
                            column.calculateDisplayValue = (0, _data.compileGetter)(column.displayField)
                        }
                        if (column.calculateDisplayValue) {
                            column.displayValueMap = column.displayValueMap || {}
                        }(0, _m_columns_controller_utils.updateSerializers)(column, column.dataType);
                        const {
                            lookup: lookup
                        } = column;
                        if (lookup) {
                            (0, _m_columns_controller_utils.updateSerializers)(lookup, lookup.dataType)
                        }
                        const dataType = lookup ? lookup.dataType : column.dataType;
                        if (dataType) {
                            column.alignment = column.alignment || (0, _m_columns_controller_utils.getAlignmentByDataType)(dataType, this.option("rtlEnabled"));
                            column.format = column.format || _m_utils.default.getFormatByDataType(dataType);
                            column.customizeText = column.customizeText || (0, _m_columns_controller_utils.getCustomizeTextByDataType)(dataType);
                            column.defaultFilterOperations = column.defaultFilterOperations || !lookup && _const.DATATYPE_OPERATIONS[dataType] || [];
                            if (!(0, _type.isDefined)(column.filterOperations)) {
                                (0, _m_columns_controller_utils.setFilterOperationsAsDefaultValues)(column)
                            }
                            column.defaultFilterOperation = column.filterOperations && column.filterOperations[0] || "=";
                            column.showEditorAlways = (0, _type.isDefined)(column.showEditorAlways) ? column.showEditorAlways : "boolean" === dataType && !column.cellTemplate && !column.lookup
                        }
                    };
                    _proto.updateColumnDataTypes = function(dataSource) {
                        const that = this;
                        const dateSerializationFormat = that.option("dateSerializationFormat");
                        const firstItems = that._getFirstItems(dataSource);
                        let isColumnDataTypesUpdated = false;
                        (0, _iterator.each)(that._columns, (index, column) => {
                            let i;
                            let value;
                            let dataType;
                            let lookupDataType;
                            let valueDataType;
                            const {
                                lookup: lookup
                            } = column;
                            if (_m_utils.default.isDateType(column.dataType) && void 0 === column.serializationFormat) {
                                column.serializationFormat = dateSerializationFormat
                            }
                            if (lookup && _m_utils.default.isDateType(lookup.dataType) && void 0 === column.serializationFormat) {
                                lookup.serializationFormat = dateSerializationFormat
                            }
                            if (column.calculateCellValue && firstItems.length) {
                                if (!column.dataType || lookup && !lookup.dataType) {
                                    for (i = 0; i < firstItems.length; i++) {
                                        value = column.calculateCellValue(firstItems[i]);
                                        if (!column.dataType) {
                                            valueDataType = (0, _m_columns_controller_utils.getValueDataType)(value);
                                            dataType = dataType || valueDataType;
                                            if (dataType && valueDataType && dataType !== valueDataType) {
                                                dataType = "string"
                                            }
                                        }
                                        if (lookup && !lookup.dataType) {
                                            valueDataType = (0, _m_columns_controller_utils.getValueDataType)(_m_utils.default.getDisplayValue(column, value, firstItems[i]));
                                            lookupDataType = lookupDataType || valueDataType;
                                            if (lookupDataType && valueDataType && lookupDataType !== valueDataType) {
                                                lookupDataType = "string"
                                            }
                                        }
                                    }
                                    if (dataType || lookupDataType) {
                                        if (dataType) {
                                            column.dataType = dataType
                                        }
                                        if (lookup && lookupDataType) {
                                            lookup.dataType = lookupDataType
                                        }
                                        isColumnDataTypesUpdated = true
                                    }
                                }
                                if (void 0 === column.serializationFormat || lookup && void 0 === lookup.serializationFormat) {
                                    for (i = 0; i < firstItems.length; i++) {
                                        value = column.calculateCellValue(firstItems[i], true);
                                        if (void 0 === column.serializationFormat) {
                                            column.serializationFormat = (0, _m_columns_controller_utils.getSerializationFormat)(column.dataType, value)
                                        }
                                        if (lookup && void 0 === lookup.serializationFormat) {
                                            lookup.serializationFormat = (0, _m_columns_controller_utils.getSerializationFormat)(lookup.dataType, lookup.calculateCellValue(value, true))
                                        }
                                    }
                                }
                            }
                            that._updateColumnOptions(column, index)
                        });
                        return isColumnDataTypesUpdated
                    };
                    _proto._customizeColumns = function(columns) {
                        const that = this;
                        const customizeColumns = that.option("customizeColumns");
                        if (customizeColumns) {
                            const hasOwnerBand = columns.some(column => (0, _type.isObject)(column.ownerBand));
                            if (hasOwnerBand) {
                                (0, _m_columns_controller_utils.updateIndexes)(that)
                            }
                            customizeColumns(columns);
                            (0, _m_columns_controller_utils.assignColumns)(that, (0, _m_columns_controller_utils.createColumnsFromOptions)(that, columns))
                        }
                    };
                    _proto.updateColumns = function(dataSource, forceApplying, isApplyingUserState) {
                        if (!forceApplying) {
                            this.updateSortingGrouping(dataSource)
                        }
                        if (!dataSource || dataSource.isLoaded()) {
                            const sortParameters = dataSource ? dataSource.sort() || [] : this.getSortDataSourceParameters();
                            const groupParameters = dataSource ? dataSource.group() || [] : this.getGroupDataSourceParameters();
                            const filterParameters = null === dataSource || void 0 === dataSource ? void 0 : dataSource.lastLoadOptions().filter;
                            if (!isApplyingUserState) {
                                this._customizeColumns(this._columns)
                            }(0, _m_columns_controller_utils.updateIndexes)(this);
                            const columns = this._columns;
                            return (0, _deferred.when)(this.refresh(true)).always(() => {
                                if (this._columns !== columns) {
                                    return
                                }
                                this._updateChanges(dataSource, {
                                    sorting: sortParameters,
                                    grouping: groupParameters,
                                    filtering: filterParameters
                                });
                                (0, _m_columns_controller_utils.fireColumnsChanged)(this)
                            })
                        }
                    };
                    _proto._updateChanges = function(dataSource, parameters) {
                        if (dataSource) {
                            this.updateColumnDataTypes(dataSource);
                            this._dataSourceApplied = true
                        }
                        if (!_m_utils.default.equalSortParameters(parameters.sorting, this.getSortDataSourceParameters())) {
                            (0, _m_columns_controller_utils.updateColumnChanges)(this, "sorting")
                        }
                        if (!_m_utils.default.equalSortParameters(parameters.grouping, this.getGroupDataSourceParameters())) {
                            (0, _m_columns_controller_utils.updateColumnChanges)(this, "grouping")
                        }
                        if (this._dataController && !_m_utils.default.equalFilterParameters(parameters.filtering, this._dataController.getCombinedFilter())) {
                            (0, _m_columns_controller_utils.updateColumnChanges)(this, "filtering")
                        }(0, _m_columns_controller_utils.updateColumnChanges)(this, "columns")
                    };
                    _proto.updateSortingGrouping = function(dataSource, fromDataSource) {
                        const that = this;
                        let sortParameters;
                        let isColumnsChanged;
                        const updateSortGroupParameterIndexes = function(columns, sortParameters, indexParameterName) {
                            (0, _iterator.each)(columns, (index, column) => {
                                delete column[indexParameterName];
                                if (sortParameters) {
                                    for (let i = 0; i < sortParameters.length; i++) {
                                        const {
                                            selector: selector
                                        } = sortParameters[i];
                                        const {
                                            isExpanded: isExpanded
                                        } = sortParameters[i];
                                        if (selector === column.dataField || selector === column.name || selector === column.selector || s