function IDdxPieChart(pform){
  CustomElement.call(this, pform);
}

IDdxPieChart.prototype = new CustomElement();
IDdxPieChart.Init = function() {
  if(IDdxPieChart.inited){
    return
  }
  IDdxPieChart.inited = true;
}

IDdxPieChart.Init();
Object.defineProperty(IDdxPieChart.prototype, "options", {
  get: function () {
    return this.options;
  },
  set: function (value) {
    if (this.pieChart) {
      var opt = (typeof value === String ? JSON.parse(value) : value);
      var keys = Object.keys(opt);
        for (var i = 0; i < keys.length; i++)
          this.pieChart.setOption(prop, opt[prop]);
    }
    else
      this._options = value;
  }
});

Object.defineProperty(IDdxPieChart.prototype, "data", {
  get: function () {
    return this._data;
  },
  set: function (configuration) {
    this._data = configuration.data;
    this._chartTitle = configuration.title;
    this._customDivChart = configuration.divToUse + 'PieChart';
    this._width = configuration.width;
    this._height = configuration.height;
    if(this.pieChart){
      this.Realize(IDdxPieChart.Realize, IDdxPieChart.cls);}
    else {
      if(IDdxPieChart.Realize){
        this.Realize(IDdxPieChart.Realize, IDdxPieChart.cls);
      }
    }
  }
});

IDdxPieChart.prototype.Realize = function (parent, cls) {

  if(!this._data){
    IDdxPieChart.Realize = parent;
    IDdxPieChart.cls = cls;
    return;
  }

  if(!IDdxPieChart.inited || this._data.length == 0) {
    IDdxPieChart.Realize = parent;
    IDdxPieChart.cls = cls;
    return;
  }
  CustomElement.prototype.Realize.call(this, parent, cls);

  var pthis = this;
  
  this.pieChartDiv = document.createElement("div");
  this.pieChartDiv.setAttribute("id", this._customDivChart);
  parent.appendChild(this.pieChartDiv);
 
  function toggleVisibility(item) {
    if (item.isVisible()) {
      item.hide();
    } else {
      item.show();
    }
  }


  this.storedParent = parent;

  // avoid 2 or more equal instances of the Chart
  if (this.pieChart) {
    this.pieChart.destroy();
  }
  
  var pieChartDiv = '#' + this._customDivChart;
  DevExpress.localization.locale('it');
  window.setTimeout( function () {
    DevExpress.localization.locale(navigator.language);
    var dataSource = this._data;
    $(pieChartDiv).dxPieChart({
        size: {
          width: this._width,
          height: this._height,
        },
        palette: 'bright',
        dataSource,
        series: [
          {
            argumentField: 'name',
            valueField: 'amount',
            label: {
              visible: true,
              connector: {
                visible: true,
                width: 1,
              },
            },
          },
        ],
        title: this._chartTitle,
        export: {
          enabled: true,
        },
        onPointClick(e) {
          const point = e.target;
          toggleVisibility(point);
        },
        onLegendClick(e) {
          const arg = e.target;
    
          toggleVisibility(this.getAllSeries()[0].getPointsByArg(arg)[0]);
        },
      }
    );
    
    this.pieChart = $(pieChartDiv).dxPieChart("instance");

  }.bind(this), 350);

  this.pieChart = $(pieChartDiv).dxPieChart("dispose");
 
}

IDdxPieChart.prototype.setLocale   = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

IDdxPieChart.prototype.Unrealize = function ()
{
  if (this.pieChart)
    this.pieChart.dispose();
  delete this.pieChart;
  if (this.pieChartDiv.parentNode)
    this.pieChartDiv.parentNode.removeChild(this.pieChartDiv);
  $(this.pieChartDiv).remove();
}

/*
  custom button
*/
function customButtonCommand(buttonID,eventID){
  console.log("CLICCAMI has been pressed: "+ eventID);
  RD3_SendCommand("@button@button=" + buttonID + ";Event="+ eventID);
}