/*!
 * DevExtreme (dx.web.debug.js)
 * Version: 23.1.6
 * Build date: Fri Oct 13 2023
 *
 * Copyright (c) 2012 - 2023 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function() {
    var __webpack_modules__ = {
        66798:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/common/m_charts.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.registerPattern = exports.registerGradient = exports.default = void 0;
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                var graphicObjects = {};
                exports.registerPattern = function(options) {
                    var id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: "pattern"
                    }, options);
                    return id
                };
                exports.registerGradient = function(type, options) {
                    var id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: type
                    }, options);
                    return id
                };
                var _default = {
                    getGraphicObjects: function() {
                        return graphicObjects
                    }
                };
                exports.default = _default
            },
        48252:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/export/m_export.js ***!
              \*******************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ExportController = exports.DataProvider = void 0;
                __webpack_require__( /*! ../../../../ui/button */ 63008);
                __webpack_require__( /*! ../../../../ui/drop_down_button */ 45231);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _position = __webpack_require__( /*! ../../../../core/utils/position */ 37518);
                var _string = __webpack_require__( /*! ../../../../core/utils/string */ 68752);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _list_light = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/list_light */ 56757));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_export = __webpack_require__( /*! ../../../grids/grid_core/m_export */ 1229);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var DataProvider = function() {
                    function DataProvider(exportController, initialColumnWidthsByColumnIndex, selectedRowsOnly) {
                        this._exportController = exportController;
                        this._initialColumnWidthsByColumnIndex = initialColumnWidthsByColumnIndex;
                        this._selectedRowsOnly = selectedRowsOnly
                    }
                    var _proto = DataProvider.prototype;
                    _proto._getGroupValue = function(item) {
                        var key = item.key,
                            data = item.data,
                            rowType = item.rowType,
                            groupIndex = item.groupIndex,
                            summaryCells = item.summaryCells;
                        var groupColumn = this._options.groupColumns[groupIndex];
                        var value = _m_core.default.getDisplayValue(groupColumn, groupColumn.deserializeValue ? groupColumn.deserializeValue(key[groupIndex]) : key[groupIndex], data, rowType);
                        var result = "".concat(groupColumn.caption, ": ").concat(_m_core.default.formatValue(value, groupColumn));
                        if (summaryCells && summaryCells[0] && summaryCells[0].length) {
                            result += " ".concat(_m_core.default.getGroupRowSummaryText(summaryCells[0], this._options.summaryTexts))
                        }
                        return result
                    };
                    _proto._correctCellIndex = function(cellIndex) {
                        return cellIndex
                    };
                    _proto._initOptions = function() {
                        var exportController = this._exportController;
                        var groupColumns = exportController._columnsController.getGroupColumns();
                        this._options = {
                            columns: exportController._getColumns(this._initialColumnWidthsByColumnIndex),
                            groupColumns: groupColumns,
                            items: this._selectedRowsOnly || exportController._selectionOnly ? exportController._getSelectedItems() : exportController._getAllItems(),
                            isHeadersVisible: exportController.option("showColumnHeaders"),
                            summaryTexts: exportController.option("summary.texts"),
                            rtlEnabled: exportController.option("rtlEnabled")
                        }
                    };
                    _proto.getHeaderStyles = function() {
                        return [{
                            bold: true,
                            alignment: "center"
                        }, {
                            bold: true,
                            alignment: "left"
                        }, {
                            bold: true,
                            alignment: "right"
                        }]
                    };
                    _proto.getGroupRowStyle = function() {
                        return {
                            bold: true,
                            alignment: (0, _position.getDefaultAlignment)(this._options.rtlEnabled)
                        }
                    };
                    _proto.getColumnStyles = function() {
                        var columnStyles = [];
                        this.getColumns().forEach((function(column) {
                            columnStyles.push({
                                alignment: column.alignment || "left",
                                format: column.format,
                                dataType: column.dataType
                            })
                        }));
                        return columnStyles
                    };
                    _proto.getStyles = function() {
                        return [].concat(_toConsumableArray(this.getHeaderStyles()), _toConsumableArray(this.getColumnStyles()), [this.getGroupRowStyle()])
                    };
                    _proto._getTotalCellStyleId = function(cellIndex) {
                        var _a;
                        var alignment = (null === (_a = this.getColumns()[cellIndex]) || void 0 === _a ? void 0 : _a.alignment) || "right";
                        return this.getHeaderStyles().map((function(style) {
                            return style.alignment
                        })).indexOf(alignment)
                    };
                    _proto.getStyleId = function(rowIndex, cellIndex) {
                        if (rowIndex < this.getHeaderRowCount()) {
                            return 0
                        }
                        if (this.isTotalCell(rowIndex - this.getHeaderRowCount(), cellIndex)) {
                            return this._getTotalCellStyleId(cellIndex)
                        }
                        if (this.isGroupRow(rowIndex - this.getHeaderRowCount())) {
                            return this.getHeaderStyles().length + this.getColumns().length
                        }
                        return cellIndex + this.getHeaderStyles().length
                    };
                    _proto.getColumns = function(getColumnsByAllRows) {
                        var columns = this._options.columns;
                        return getColumnsByAllRows ? columns : columns[columns.length - 1]
                    };
                    _proto.getColumnsWidths = function() {
                        var columns = this.getColumns();
                        return (0, _type.isDefined)(columns) ? columns.map((function(c) {
                            return c.width
                        })) : void 0
                    };
                    _proto.getRowsCount = function() {
                        return this._options.items.length + this.getHeaderRowCount()
                    };
                    _proto.getHeaderRowCount = function() {
                        if (this.isHeadersVisible()) {
                            return this._options.columns.length - 1
                        }
                        return 0
                    };
                    _proto.isGroupRow = function(rowIndex) {
                        return rowIndex < this._options.items.length && "group" === this._options.items[rowIndex].rowType
                    };
                    _proto.getGroupLevel = function(rowIndex) {
                        var item = this._options.items[rowIndex - this.getHeaderRowCount()];
                        var groupIndex = item && item.groupIndex;
                        if (item && "totalFooter" === item.rowType) {
                            return 0
                        }
                        return (0, _type.isDefined)(groupIndex) ? groupIndex : this._options.groupColumns.length
                    };
                    _proto.getCellType = function(rowIndex, cellIndex) {
                        var columns = this.getColumns();
                        if (rowIndex < this.getHeaderRowCount()) {
                            return "string"
                        }
                        rowIndex -= this.getHeaderRowCount();
                        if (cellIndex < columns.length) {
                            var item = this._options.items.length && this._options.items[rowIndex];
                            var column = columns[cellIndex];
                            if (item && "data" === item.rowType) {
                                if (isFinite(item.values[this._correctCellIndex(cellIndex)]) && !(0, _type.isDefined)(column.customizeText)) {
                                    return (0, _type.isDefined)(column.lookup) ? column.lookup.dataType : column.dataType
                                }
                            }
                            return "string"
                        }
                    };
                    _proto.ready = function() {
                        this._initOptions();
                        var options = this._options;
                        return (0, _deferred.when)(options.items).done((function(items) {
                            options.items = items
                        })).fail((function() {
                            options.items = []
                        }))
                    };
                    _proto._convertFromGridGroupSummaryItems = function(gridGroupSummaryItems) {
                        if ((0, _type.isDefined)(gridGroupSummaryItems) && gridGroupSummaryItems.length > 0) {
                            return gridGroupSummaryItems.map((function(item) {
                                return {
                                    value: item.value,
                                    name: item.name
                                }
                            }))
                        }
                    };
                    _proto.getCellData = function(rowIndex, cellIndex, isExcelJS) {
                        var value;
                        var column;
                        var result = {
                            cellSourceData: {},
                            value: value
                        };
                        var columns = this.getColumns();
                        var correctedCellIndex = this._correctCellIndex(cellIndex);
                        if (rowIndex < this.getHeaderRowCount()) {
                            var columnsRow = this.getColumns(true)[rowIndex];
                            column = columnsRow[cellIndex];
                            result.cellSourceData.rowType = "header";
                            result.cellSourceData.column = column && column.gridColumn;
                            result.value = column && column.caption
                        } else {
                            rowIndex -= this.getHeaderRowCount();
                            var item = this._options.items.length && this._options.items[rowIndex];
                            if (item) {
                                var itemValues = item.values;
                                result.cellSourceData.rowType = item.rowType;
                                result.cellSourceData.column = columns[cellIndex] && columns[cellIndex].gridColumn;
                                switch (item.rowType) {
                                    case "groupFooter":
                                    case "totalFooter":
                                        if (correctedCellIndex < itemValues.length) {
                                            value = itemValues[correctedCellIndex];
                                            if ((0, _type.isDefined)(value)) {
                                                result.cellSourceData.value = value.value;
                                                result.cellSourceData.totalSummaryItemName = value.name;
                                                result.value = _m_core.default.getSummaryText(value, this._options.summaryTexts)
                                            } else {
                                                result.cellSourceData.value = void 0
                                            }
                                        }
                                        break;
                                    case "group":
                                        result.cellSourceData.groupIndex = item.groupIndex;
                                        if (cellIndex < 1) {
                                            result.cellSourceData.column = this._options.groupColumns[item.groupIndex];
                                            result.cellSourceData.value = item.key[item.groupIndex];
                                            result.cellSourceData.groupSummaryItems = this._convertFromGridGroupSummaryItems(item.summaryCells[0]);
                                            result.value = this._getGroupValue(item)
                                        } else {
                                            var summaryItems = item.values[correctedCellIndex];
                                            if (Array.isArray(summaryItems)) {
                                                result.cellSourceData.groupSummaryItems = this._convertFromGridGroupSummaryItems(summaryItems);
                                                value = "";
                                                for (var i = 0; i < summaryItems.length; i++) {
                                                    value += (i > 0 ? isExcelJS ? "\n" : " \n " : "") + _m_core.default.getSummaryText(summaryItems[i], this._options.summaryTexts)
                                                }
                                                result.value = value
                                            } else {
                                                result.cellSourceData.value = void 0
                                            }
                                        }
                                        break;
                                    default:
                                        column = columns[cellIndex];
                                        if (column) {
                                            var _value = itemValues[correctedCellIndex];
                                            var displayValue = _m_core.default.getDisplayValue(column, _value, item.data, item.rowType);
                                            if (!isFinite(displayValue) || (0, _type.isDefined)(column.customizeText)) {
                                                if (isExcelJS && (0, _type.isDefined)(column.customizeText) && column.customizeText === this._exportController._columnsController.getCustomizeTextByDataType("boolean")) {
                                                    result.value = displayValue
                                                } else {
                                                    result.value = _m_core.default.formatValue(displayValue, column)
                                                }
                                            } else {
                                                result.value = displayValue
                                            }
                                            result.cellSourceData.value = _value
                                        }
                                        result.cellSourceData.data = item.data
                                }
                            }
                        }
                        return result
                    };
                    _proto.isHeadersVisible = function() {
                        return this._options.isHeadersVisible
                    };
                    _proto.isTotalCell = function(rowIndex, cellIndex) {
                        var items = this._options.items;
                        var item = items[rowIndex];
                        var correctCellIndex = this._correctCellIndex(cellIndex);
                        var isSummaryAlignByColumn = item.summaryCells && item.summaryCells[correctCellIndex] && item.summaryCells[correctCellIndex].length > 0 && item.summaryCells[correctCellIndex][0].alignByColumn;
                        return item && "groupFooter" === item.rowType || "totalFooter" === item.rowType || isSummaryAlignByColumn
                    };
                    _proto.getCellMerging = function(rowIndex, cellIndex) {
                        var columns = this._options.columns;
                        var column = columns[rowIndex] && columns[rowIndex][cellIndex];
                        return column ? {
                            colspan: (column.exportColspan || 1) - 1,
                            rowspan: (column.rowspan || 1) - 1
                        } : {
                            colspan: 0,
                            rowspan: 0
                        }
                    };
                    _proto.getFrozenArea = function() {
                        return {
                            x: 0,
                            y: this.getHeaderRowCount()
                        }
                    };
                    return DataProvider
                }();
                exports.DataProvider = DataProvider;
                var ExportController = function(_dataGridCore$ViewCon) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(ExportController, _dataGridCore$ViewCon);

                    function ExportController() {
                        return _dataGridCore$ViewCon.apply(this, arguments) || this
                    }
                    var _proto2 = ExportController.prototype;
                    _proto2._getEmptyCell = function() {
                        return {
                            caption: "",
                            colspan: 1,
                            rowspan: 1
                        }
                    };
                    _proto2._updateColumnWidth = function(column, width) {
                        column.width = width
                    };
                    _proto2._getColumns = function(initialColumnWidthsByColumnIndex) {
                        var result = [];
                        var i;
                        var columns;
                        var columnsController = this._columnsController;
                        var rowCount = columnsController.getRowCount();
                        for (i = 0; i <= rowCount; i++) {
                            var currentHeaderRow = [];
                            columns = columnsController.getVisibleColumns(i, true);
                            var columnWidthsByColumnIndex = void 0;
                            if (i === rowCount) {
                                if (this._updateLockCount) {
                                    columnWidthsByColumnIndex = initialColumnWidthsByColumnIndex
                                } else {
                                    var columnWidths = this._getColumnWidths(this._headersView, this._rowsView);
                                    if (columnWidths && columnWidths.length) {
                                        columnWidthsByColumnIndex = {};
                                        for (var _i = 0; _i < columns.length; _i++) {
                                            columnWidthsByColumnIndex[columns[_i].index] = columnWidths[_i]
                                        }
                                    }
                                }
                            }
                            for (var j = 0; j < columns.length; j++) {
                                var column = (0, _extend.extend)({}, columns[j], {
                                    dataType: "datetime" === columns[j].dataType ? "date" : columns[j].dataType,
                                    gridColumn: columns[j]
                                });
                                if (this._needColumnExporting(column)) {
                                    var currentColspan = this._calculateExportColspan(column);
                                    if ((0, _type.isDefined)(currentColspan)) {
                                        column.exportColspan = currentColspan
                                    }
                                    if (columnWidthsByColumnIndex) {
                                        this._updateColumnWidth(column, columnWidthsByColumnIndex[column.index])
                                    }
                                    currentHeaderRow.push(column)
                                }
                            }
                            result.push(currentHeaderRow)
                        }
                        columns = result[rowCount];
                        result = (0, _m_export.prepareItems)(result.slice(0, -1), this._getEmptyCell());
                        result.push(columns);
                        return result
                    };
                    _proto2._calculateExportColspan = function(column) {
                        var _this = this;
                        if (!column.isBand) {
                            return
                        }
                        var childColumns = this._columnsController.getChildrenByBandColumn(column.index, true);
                        if (!(0, _type.isDefined)(childColumns)) {
                            return
                        }
                        return childColumns.reduce((function(result, childColumn) {
                            if (_this._needColumnExporting(childColumn)) {
                                return result + (_this._calculateExportColspan(childColumn) || 1)
                            }
                            return result
                        }), 0)
                    };
                    _proto2._needColumnExporting = function(column) {
                        return !column.command && (column.allowExporting || void 0 === column.allowExporting)
                    };
                    _proto2._getFooterSummaryItems = function(summaryCells, isTotal) {
                        var result = [];
                        var estimatedItemsCount = 1;
                        var i = 0;
                        do {
                            var values = [];
                            for (var j = 0; j < summaryCells.length; j++) {
                                var summaryCell = summaryCells[j];
                                var itemsLength = summaryCell.length;
                                if (estimatedItemsCount < itemsLength) {
                                    estimatedItemsCount = itemsLength
                                }
                                values.push(summaryCell[i])
                            }
                            result.push({
                                values: values,
                                rowType: isTotal ? "totalFooter" : "groupFooter"
                            })
                        } while (i++ < estimatedItemsCount - 1);
                        return result
                    };
                    _proto2._hasSummaryGroupFooters = function() {
                        var groupItems = this.option("summary.groupItems");
                        if ((0, _type.isDefined)(groupItems)) {
                            for (var i = 0; i < groupItems.length; i++) {
                                if (groupItems[i].showInGroupFooter) {
                                    return true
                                }
                            }
                        }
                        return false
                    };
                    _proto2._getItemsWithSummaryGroupFooters = function(sourceItems) {
                        var result = [];
                        var beforeGroupFooterItems = [];
                        var groupFooterItems = [];
                        for (var i = 0; i < sourceItems.length; i++) {
                            var item = sourceItems[i];
                            if ("groupFooter" === item.rowType) {
                                groupFooterItems = this._getFooterSummaryItems(item.summaryCells);
                                result = result.concat(beforeGroupFooterItems, groupFooterItems);
                                beforeGroupFooterItems = []
                            } else {
                                beforeGroupFooterItems.push(item)
                            }
                        }
                        return result.length ? result : beforeGroupFooterItems
                    };
                    _proto2._updateGroupValuesWithSummaryByColumn = function(sourceItems) {
                        var summaryValues = [];
                        for (var i = 0; i < sourceItems.length; i++) {
                            var item = sourceItems[i];
                            var summaryCells = item.summaryCells;
                            if ("group" === item.rowType && summaryCells && summaryCells.length > 1) {
                                var groupColumnCount = item.values.length;
                                for (var j = 1; j < summaryCells.length; j++) {
                                    for (var k = 0; k < summaryCells[j].length; k++) {
                                        var summaryItem = summaryCells[j][k];
                                        if (summaryItem && summaryItem.alignByColumn) {
                                            if (!Array.isArray(summaryValues[j - groupColumnCount])) {
                                                summaryValues[j - groupColumnCount] = []
                                            }
                                            summaryValues[j - groupColumnCount].push(summaryItem)
                                        }
                                    }
                                }
                                if (summaryValues.length > 0) {
                                    var _item$values;
                                    (_item$values = item.values).push.apply(_item$values, _toConsumableArray(summaryValues));
                                    summaryValues = []
                                }
                            }
                        }
                    };
                    _proto2._processUnExportedItems = function(items) {
                        var columns = this._columnsController.getVisibleColumns(null, true);
                        var groupColumns = this._columnsController.getGroupColumns();
                        var values;
                        var summaryCells;
                        for (var i = 0; i < items.length; i++) {
                            var item = items[i];
                            var isCommand = false;
                            values = [];
                            summaryCells = [];
                            for (var j = 0; j < columns.length; j++) {
                                var column = columns[j];
                                isCommand || (isCommand = ["detailExpand", "buttons"].includes(column.type));
                                if (this._needColumnExporting(column)) {
                                    if (item.values) {
                                        if ("group" === item.rowType && !values.length) {
                                            values.push(item.key[item.groupIndex])
                                        } else {
                                            values.push(item.values[j])
                                        }
                                    }
                                    if (item.summaryCells) {
                                        if ("group" === item.rowType && !summaryCells.length) {
                                            var index = j - groupColumns.length + item.groupIndex;
                                            summaryCells.push(item.summaryCells[isCommand ? index : index + 1])
                                        } else {
                                            summaryCells.push(item.summaryCells[j])
                                        }
                                    }
                                }
                            }
                            if (values.length) {
                                item.values = values
                            }
                            if (summaryCells.length) {
                                item.summaryCells = summaryCells
                            }
                        }
                    };
                    _proto2._getAllItems = function(data) {
                        var skipFilter = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : false;
                        var that = this;
                        var d = new _deferred.Deferred;
                        var dataController = this.getController("data");
                        var footerItems = dataController.footerItems();
                        var totalItem = footerItems.length && footerItems[0];
                        var summaryTotalItems = that.option("summary.totalItems");
                        var summaryCells;
                        (0, _deferred.when)(data).done((function(data) {
                            dataController.loadAll(data, skipFilter).done((function(sourceItems, totalAggregates) {
                                that._updateGroupValuesWithSummaryByColumn(sourceItems);
                                if (that._hasSummaryGroupFooters()) {
                                    sourceItems = that._getItemsWithSummaryGroupFooters(sourceItems)
                                }
                                summaryCells = totalItem && totalItem.summaryCells;
                                if ((0, _type.isDefined)(totalAggregates) && summaryTotalItems) {
                                    summaryCells = that._getSummaryCells(summaryTotalItems, totalAggregates)
                                }
                                var summaryItems = totalItem && that._getFooterSummaryItems(summaryCells, true);
                                if (summaryItems) {
                                    sourceItems = sourceItems.concat(summaryItems)
                                }
                                that._processUnExportedItems(sourceItems);
                                d.resolve(sourceItems)
                            })).fail(d.reject)
                        })).fail(d.reject);
                        return d
                    };
                    _proto2._getSummaryCells = function(summaryTotalItems, totalAggregates) {
                        var dataController = this.getController("data");
                        var columnsController = dataController._columnsController;
                        return dataController._calculateSummaryCells(summaryTotalItems, totalAggregates, columnsController.getVisibleColumns(null, true), (function(summaryItem, column) {
                            return dataController._isDataColumn(column) ? column.index : -1
                        }))
                    };
                    _proto2._getSelectedItems = function() {
                        var selectionController = this.getController("selection");
                        if (this.needLoadItemsOnExportingSelectedItems()) {
                            return this._getAllItems(selectionController.loadSelectedItemsWithFilter(), true)
                        }
                        return this._getAllItems(selectionController.getSelectedRowsData())
                    };
                    _proto2._getColumnWidths = function(headersView, rowsView) {
                        return headersView && headersView.isVisible() ? headersView.getColumnWidths() : rowsView.getColumnWidths()
                    };
                    _proto2.throwWarningIfNoOnExportingEvent = function() {
                        var _a, _b;
                        var hasOnExporting = null === (_b = (_a = this.component).hasActionSubscription) || void 0 === _b ? void 0 : _b.call(_a, "onExporting");
                        if (this.option("export.enabled") && !hasOnExporting) {
                            _ui.default.log("W1024")
                        }
                    };
                    _proto2.init = function() {
                        this.throwWarningIfNoOnExportingEvent();
                        this._columnsController = this.getController("columns");
                        this._rowsView = this.getView("rowsView");
                        this._headersView = this.getView("columnHeadersView");
                        this.createAction("onExporting", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    };
                    _proto2.callbackNames = function() {
                        return ["selectionOnlyChanged"]
                    };
                    _proto2.getDataProvider = function(selectedRowsOnly) {
                        var columnWidths = this._getColumnWidths(this._headersView, this._rowsView);
                        var initialColumnWidthsByColumnIndex;
                        if (columnWidths && columnWidths.length) {
                            initialColumnWidthsByColumnIndex = {};
                            var columnsLastRowVisibleColumns = this._columnsController.getVisibleColumns(this._columnsController.getRowCount(), true);
                            for (var i = 0; i < columnsLastRowVisibleColumns.length; i++) {
                                initialColumnWidthsByColumnIndex[columnsLastRowVisibleColumns[i].index] = columnWidths[i]
                            }
                        }
                        return new DataProvider(this, initialColumnWidthsByColumnIndex, selectedRowsOnly)
                    };
                    _proto2.exportTo = function(selectedRowsOnly, format) {
                        this._selectionOnly = selectedRowsOnly;
                        var onExporting = this.getAction("onExporting");
                        var eventArgs = {
                            rtlEnabled: this.option("rtlEnabled"),
                            selectedRowsOnly: !!selectedRowsOnly,
                            format: format,
                            fileName: "DataGrid",
                            cancel: false
                        };
                        (0, _type.isFunction)(onExporting) && onExporting(eventArgs)
                    };
                    _proto2.publicMethods = function() {
                        return ["getDataProvider"]
                    };
                    _proto2.selectionOnly = function(value) {
                        if ((0, _type.isDefined)(value)) {
                            this._isSelectedRows = value;
                            this.selectionOnlyChanged.fire()
                        } else {
                            return this._isSelectedRows
                        }
                    };
                    _proto2.optionChanged = function(args) {
                        _dataGridCore$ViewCon.prototype.optionChanged.call(this, args);
                        if ("export" === args.name) {
                            this.throwWarningIfNoOnExportingEvent()
                        }
                    };
                    _proto2.needLoadItemsOnExportingSelectedItems = function() {
                        var _a;
                        return null !== (_a = this.option("loadItemsOnExportingSelectedItems")) && void 0 !== _a ? _a : this.getController("data")._dataSource.remoteOperations().filtering
                    };
                    return ExportController
                }(_m_core.default.ViewController);
                exports.ExportController = ExportController;
                _m_core.default.registerModule("export", {
                    defaultOptions: function() {
                        return {
                            export: {
                                enabled: false,
                                fileName: "DataGrid",
                                formats: ["xlsx"],
                                allowExportSelectedData: false,
                                texts: {
                                    exportTo: _message.default.format("dxDataGrid-exportTo"),
                                    exportAll: _message.default.format("dxDataGrid-exportAll"),
                                    exportSelectedRows: _message.default.format("dxDataGrid-exportSelectedRows")
                                }
                            }
                        }
                    },
                    controllers: {
                        export: ExportController
                    },
                    extenders: {
                        controllers: {
                            editing: {
                                callbackNames: function() {
                                    var callbackList = this.callBase();
                                    return (0, _type.isDefined)(callbackList) ? callbackList.push("editingButtonsUpdated") : ["editingButtonsUpdated"]
                                },
                                _updateEditButtons: function() {
                                    this.callBase();
                                    this.editingButtonsUpdated.fire()
                                }
                            }
                        },
                        views: {
                            headerPanel: {
                                _getToolbarItems: function() {
                                    var items = this.callBase();
                                    var exportButton = this._getExportToolbarButton();
                                    if (exportButton) {
                                        items.push(exportButton);
                                        this._correctItemsPosition(items)
                                    }
                                    return items
                                },
                                _getExportToolbarButton: function() {
                                    var _this2 = this;
                                    var items = this._getExportToolbarItems();
                                    if (0 === items.length) {
                                        return null
                                    }
                                    var disabled = this._needDisableExportButton();
                                    var toolbarButtonOptions = {
                                        name: "exportButton",
                                        location: "after",
                                        locateInMenu: "auto",
                                        sortIndex: 30,
                                        options: {
                                            items: items
                                        },
                                        disabled: disabled
                                    };
                                    if (1 === items.length) {
                                        var widgetOptions = _extends(_extends({}, items[0]), {
                                            hint: items[0].text,
                                            elementAttr: {
                                                class: "dx-datagrid-export-button"
                                            }
                                        });
                                        toolbarButtonOptions.widget = "dxButton";
                                        toolbarButtonOptions.showText = "inMenu";
                                        toolbarButtonOptions.options = widgetOptions
                                    } else {
                                        var _widgetOptions = {
                                            icon: "export",
                                            displayExpr: "text",
                                            items: items,
                                            hint: this.option("export.texts.exportTo"),
                                            elementAttr: {
                                                class: "dx-datagrid-export-button"
                                            },
                                            dropDownOptions: {
                                                width: "auto",
                                                _wrapperClassExternal: "dx-datagrid-export-menu"
                                            }
                                        };
                                        toolbarButtonOptions.options = _widgetOptions;
                                        toolbarButtonOptions.widget = "dxDropDownButton";
                                        toolbarButtonOptions.menuItemTemplate = function(_data, _index, container) {
                                            _this2._createComponent((0, _renderer.default)(container), _list_light.default, {
                                                items: items
                                            })
                                        }
                                    }
                                    return toolbarButtonOptions
                                },
                                _getExportToolbarItems: function() {
                                    var _this3 = this;
                                    var _a;
                                    var exportOptions = this.option("export");
                                    var texts = this.option("export.texts");
                                    var formats = null !== (_a = this.option("export.formats")) && void 0 !== _a ? _a : [];
                                    if (!exportOptions.enabled) {
                                        return []
                                    }
                                    var items = [];
                                    formats.forEach((function(formatType) {
                                        var formatName = formatType.toUpperCase();
                                        var exportAllIcon = "export";
                                        if ("xlsx" === formatType) {
                                            formatName = "Excel";
                                            exportAllIcon = "xlsxfile"
                                        }
                                        if ("pdf" === formatType) {
                                            exportAllIcon = "pdffile"
                                        }
                                        items.push({
                                            text: (0, _string.format)(texts.exportAll, formatName),
                                            icon: exportAllIcon,
                                            onClick: function() {
                                                _this3._exportController.exportTo(false, formatType)
                                            }
                                        });
                                        if (exportOptions.allowExportSelectedData) {
                                            items.push({
                                                text: (0, _string.format)(texts.exportSelectedRows, formatName),
                                                icon: "exportselected",
                                                onClick: function() {
                                                    _this3._exportController.exportTo(true, formatType)
                                                }
                                            })
                                        }
                                    }));
                                    return items
                                },
                                _correctItemsPosition: function(items) {
                                    items.sort((function(itemA, itemB) {
                                        return itemA.sortIndex - itemB.sortIndex
                                    }))
                                },
                                _isExportButtonVisible: function() {
                                    return this.option("export.enabled")
                                },
                                optionChanged: function(args) {
                                    this.callBase(args);
                                    if ("export" === args.name) {
                                        args.handled = true;
                                        this._invalidate()
                                    }
                                },
                                _needDisableExportButton: function() {
                                    var isDataColumnsInvisible = !this._columnsController.hasVisibleDataColumns();
                                    var hasUnsavedChanges = this._editingController.hasChanges();
                                    return isDataColumnsInvisible || hasUnsavedChanges
                                },
                                _columnOptionChanged: function(e) {
                                    this.callBase(e);
                                    var isColumnLocationChanged = _m_core.default.checkChanges(e.optionNames, ["groupIndex", "visible", "all"]);
                                    if (isColumnLocationChanged) {
                                        var disabled = this._needDisableExportButton();
                                        this.setToolbarItemDisabled("exportButton", disabled)
                                    }
                                },
                                init: function() {
                                    var _this4 = this;
                                    this.callBase();
                                    this._exportController = this.getController("export");
                                    this._editingController = this.getController("editing");
                                    this._editingController.editingButtonsUpdated.add((function() {
                                        var disabled = _this4._needDisableExportButton();
                                        _this4.setToolbarItemDisabled("exportButton", disabled)
                                    }))
                                },
                                isVisible: function() {
                                    return this.callBase() || this._isExportButtonVisible()
                                }
                            }
                        }
                    }
                })
            },
        56445:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/focus/m_focus.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _m_focus = __webpack_require__( /*! ../../../grids/grid_core/focus/m_focus */ 5325);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _m_utils = __webpack_require__( /*! ../m_utils */ 10087);

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
                _m_core.default.registerModule("focus", (0, _extend.extend)(true, {}, _m_focus.focusModule, {
                    extenders: {
                        controllers: {
                            data: function(Base) {
                                return function(_Base$inherit) {
                                    ! function(subClass, superClass) {
                                        subClass.prototype = Object.create(superClass.prototype);
                                        subClass.prototype.constructor = subClass;
                                        _setPrototypeOf(subClass, superClass)
                                    }(FocusDataControllerExtender, _Base$inherit);

                                    function FocusDataControllerExtender() {
                                        return _Base$inherit.apply(this, arguments) || this
                                    }
                                    var _proto = FocusDataControllerExtender.prototype;
                                    _proto.changeRowExpand = function(path, isRowClick) {
                                        if (this.option("focusedRowEnabled") && Array.isArray(path) && this.isRowExpanded(path)) {
                                            var keyboardNavigation = this.getController("keyboardNavigation");
                                            if ((!isRowClick || !keyboardNavigation.isKeyboardEnabled()) && this._isFocusedRowInsideGroup(path)) {
                                                this.option("focusedRowKey", path)
                                            }
                                        }
                                        return _Base$inherit.prototype.changeRowExpand.call(this, path, isRowClick)
                                    };
                                    _proto._isFocusedRowInsideGroup = function(path) {
                                        var columnsController = this.getController("columns");
                                        var focusedRowKey = this.option("focusedRowKey");
                                        var rowIndex = this.getRowIndexByKey(focusedRowKey);
                                        var focusedRow = rowIndex >= 0 && this.getVisibleRows()[rowIndex];
                                        var groups = columnsController.getGroupDataSourceParameters(true);
                                        if (focusedRow) {
                                            for (var i = 0; i < path.length; ++i) {
                                                var getter = (0, _data.compileGetter)(groups[i] && groups[i].selector);
                                                if (getter(focusedRow.data) !== path[i]) {
                                                    return false
                                                }
                                            }
                                        }
                                        return true
                                    };
                                    _proto._getGroupPath = function(groupItem, groupCount) {
                                        var groupPath = [];
                                        var items = [groupItem];
                                        while (items && items[0] && groupCount) {
                                            var item = items[0];
                                            if (void 0 !== item.key) {
                                                groupPath.push(item.key)
                                            }
                                            items = item.items;
                                            groupCount--
                                        }
                                        return groupPath
                                    };
                                    _proto._expandGroupByPath = function(that, groupPath, level) {
                                        var d = new _deferred.Deferred;
                                        level++;
                                        that.expandRow(groupPath.slice(0, level)).done((function() {
                                            if (level === groupPath.length) {
                                                d.resolve()
                                            } else {
                                                that._expandGroupByPath(that, groupPath, level).done(d.resolve).fail(d.reject)
                                            }
                                        })).fail(d.reject);
                                        return d.promise()
                                    };
                                    _proto._calculateGlobalRowIndexByGroupedData = function(key) {
                                        var that = this;
                                        var dataSource = that._dataSource;
                                        var filter = that._generateFilterByKey(key);
                                        var deferred = new _deferred.Deferred;
                                        var isGroupKey = Array.isArray(key);
                                        var group = dataSource.group();
                                        if (isGroupKey) {
                                            return deferred.resolve(-1).promise()
                                        }
                                        if (!dataSource._grouping._updatePagingOptions) {
                                            that._calculateGlobalRowIndexByFlatData(key, null, true).done(deferred.resolve).fail(deferred.reject);
                                            return deferred
                                        }
                                        dataSource.load({
                                            filter: that._concatWithCombinedFilter(filter),
                                            group: group
                                        }).done((function(data) {
                                            if (!data || 0 === data.length || !(0, _type.isDefined)(data[0].key) || -1 === data[0].key) {
                                                return deferred.resolve(-1).promise()
                                            }
                                            var groupPath = that._getGroupPath(data[0], group.length);
                                            that._expandGroupByPath(that, groupPath, 0).done((function() {
                                                that._calculateExpandedRowGlobalIndex(deferred, key, groupPath, group)
                                            })).fail(deferred.reject)
                                        })).fail(deferred.reject);
                                        return deferred.promise()
                                    };
                                    _proto._calculateExpandedRowGlobalIndex = function(deferred, key, groupPath, group) {
                                        var groupFilter = (0, _m_utils.createGroupFilter)(groupPath, {
                                            group: group
                                        });
                                        var dataSource = this._dataSource;
                                        var scrollingMode = this.option("scrolling.mode");
                                        var isVirtualScrolling = "virtual" === scrollingMode || "infinite" === scrollingMode;
                                        var pageSize = dataSource.pageSize();
                                        var groupOffset;
                                        dataSource._grouping._updatePagingOptions({
                                            skip: 0,
                                            take: MAX_SAFE_INTEGER
                                        }, (function(groupInfo, totalOffset) {
                                            if ((0, _common.equalByValue)(groupInfo.path, groupPath)) {
                                                groupOffset = totalOffset
                                            }
                                        }));
                                        this._calculateGlobalRowIndexByFlatData(key, groupFilter).done((function(dataOffset) {
                                            var count;
                                            var groupContinuationCount;
                                            if (dataOffset < 0) {
                                                deferred.resolve(-1);
                                                return
                                            }
                                            var currentPageOffset = groupOffset % pageSize || pageSize;
                                            count = currentPageOffset + dataOffset - groupPath.length;
                                            if (isVirtualScrolling) {
                                                groupContinuationCount = 0
                                            } else {
                                                groupContinuationCount = Math.floor(count / (pageSize - groupPath.length)) * groupPath.length
                                            }
                                            count = groupOffset + dataOffset + groupContinuationCount;
                                            deferred.resolve(count)
                                        })).fail(deferred.reject)
                                    };
                                    return FocusDataControllerExtender
                                }(Base.inherit(_m_focus.focusModule.extenders.controllers.data))
                            }
                        }
                    }
                }))
            },
        72487:
            /*!***********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/grouping/m_grouping.js ***!
              \***********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupingHeaderPanelExtender = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../../core/devices */ 20530));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _accessibility = __webpack_require__( /*! ../../../../ui/shared/accessibility */ 56756);
                var _m_accessibility = __webpack_require__( /*! ../../../grids/grid_core/m_accessibility */ 9130);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ../m_data_source_adapter */ 49975));
                var _m_grouping_collapsed = __webpack_require__( /*! ./m_grouping_collapsed */ 2772);
                var _m_grouping_expanded = __webpack_require__( /*! ./m_grouping_expanded */ 4789);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var GroupingDataSourceAdapterExtender = {
                    init: function() {
                        this.callBase.apply(this, arguments);
                        this._initGroupingHelper()
                    },
                    _initGroupingHelper: function(options) {
                        var grouping = this._grouping;
                        var isAutoExpandAll = this.option("grouping.autoExpandAll");
                        var isFocusedRowEnabled = this.option("focusedRowEnabled");
                        var remoteOperations = options ? options.remoteOperations : this.remoteOperations();
                        var isODataRemoteOperations = remoteOperations.filtering && remoteOperations.sorting && remoteOperations.paging;
                        if (isODataRemoteOperations && !remoteOperations.grouping && (isAutoExpandAll || !isFocusedRowEnabled)) {
                            if (!grouping || grouping instanceof _m_grouping_collapsed.GroupingHelper) {
                                this._grouping = new _m_grouping_expanded.GroupingHelper(this)
                            }
                        } else if (!grouping || grouping instanceof _m_grouping_expanded.GroupingHelper) {
                            this._grouping = new _m_grouping_collapsed.GroupingHelper(this)
                        }
                    },
                    totalItemsCount: function() {
                        var totalCount = this.callBase();
                        return totalCount > 0 && this._dataSource.group() && this._dataSource.requireTotalCount() ? totalCount + this._grouping.totalCountCorrection() : totalCount
                    },
                    itemsCount: function() {
                        return this._dataSource.group() ? this._grouping.itemsCount() || 0 : this.callBase.apply(this, arguments)
                    },
                    allowCollapseAll: function() {
                        return this._grouping.allowCollapseAll()
                    },
                    isGroupItemCountable: function(item) {
                        return this._grouping.isGroupItemCountable(item)
                    },
                    isRowExpanded: function(key) {
                        var groupInfo = this._grouping.findGroupInfo(key);
                        return groupInfo ? groupInfo.isExpanded : !this._grouping.allowCollapseAll()
                    },
                    collapseAll: function(groupIndex) {
                        return this._collapseExpandAll(groupIndex, false)
                    },
                    expandAll: function(groupIndex) {
                        return this._collapseExpandAll(groupIndex, true)
                    },
                    _collapseExpandAll: function(groupIndex, isExpand) {
                        var dataSource = this._dataSource;
                        var group = dataSource.group();
                        var groups = _m_core.default.normalizeSortingInfo(group || []);
                        if (groups.length) {
                            for (var i = 0; i < groups.length; i++) {
                                if (void 0 === groupIndex || groupIndex === i) {
                                    groups[i].isExpanded = isExpand
                                } else if (group && group[i]) {
                                    groups[i].isExpanded = group[i].isExpanded
                                }
                            }
                            dataSource.group(groups);
                            this._grouping.foreachGroups((function(groupInfo, parents) {
                                if (void 0 === groupIndex || groupIndex === parents.length - 1) {
                                    groupInfo.isExpanded = isExpand
                                }
                            }), false, true);
                            this.resetPagesCache()
                        }
                        return true
                    },
                    refresh: function() {
                        this.callBase.apply(this, arguments);
                        return this._grouping.refresh.apply(this._grouping, arguments)
                    },
                    changeRowExpand: function(path) {
                        var dataSource = this._dataSource;
                        if (dataSource.group()) {
                            dataSource.beginLoading();
                            if (this._lastLoadOptions) {
                                this._lastLoadOptions.groupExpand = true
                            }
                            return this._changeRowExpandCore(path).always((function() {
                                dataSource.endLoading()
                            }))
                        }
                    },
                    _changeRowExpandCore: function(path) {
                        return this._grouping.changeRowExpand(path)
                    },
                    _hasGroupLevelsExpandState: function(group, isExpanded) {
                        if (group && Array.isArray(group)) {
                            for (var i = 0; i < group.length; i++) {
                                if (group[i].isExpanded === isExpanded) {
                                    return true
                                }
                            }
                        }
                    },
                    _customizeRemoteOperations: function(options, operationTypes) {
                        var remoteOperations = options.remoteOperations;
                        if (options.storeLoadOptions.group) {
                            if (remoteOperations.grouping && !options.isCustomLoading) {
                                if (!remoteOperations.groupPaging || this._hasGroupLevelsExpandState(options.storeLoadOptions.group, true)) {
                                    remoteOperations.paging = false
                                }
                            }
                            if (!remoteOperations.grouping && (!remoteOperations.sorting || !remoteOperations.filtering || options.isCustomLoading || this._hasGroupLevelsExpandState(options.storeLoadOptions.group, false))) {
                                remoteOperations.paging = false
                            }
                        } else if (!options.isCustomLoading && remoteOperations.paging && operationTypes.grouping) {
                            this.resetCache()
                        }
                        this.callBase.apply(this, arguments)
                    },
                    _handleDataLoading: function(options) {
                        this.callBase(options);
                        this._initGroupingHelper(options);
                        return this._grouping.handleDataLoading(options)
                    },
                    _handleDataLoaded: function(options) {
                        return this._grouping.handleDataLoaded(options, this.callBase.bind(this))
                    },
                    _handleDataLoadedCore: function(options) {
                        return this._grouping.handleDataLoadedCore(options, this.callBase.bind(this))
                    }
                };
                _m_data_source_adapter.default.extend(GroupingDataSourceAdapterExtender);
                var GroupingDataControllerExtender = {
                    init: function() {
                        this.callBase();
                        this.createAction("onRowExpanding");
                        this.createAction("onRowExpanded");
                        this.createAction("onRowCollapsing");
                        this.createAction("onRowCollapsed")
                    },
                    _beforeProcessItems: function(items) {
                        var groupColumns = this._columnsController.getGroupColumns();
                        items = this.callBase(items);
                        if (items.length && groupColumns.length) {
                            items = this._processGroupItems(items, groupColumns.length)
                        }
                        return items
                    },
                    _processItem: function(item, options) {
                        if ((0, _type.isDefined)(item.groupIndex) && (0, _type.isString)(item.rowType) && 0 === item.rowType.indexOf("group")) {
                            item = this._processGroupItem(item, options);
                            options.dataIndex = 0
                        } else {
                            item = this.callBase.apply(this, arguments)
                        }
                        return item
                    },
                    _processGroupItem: function(item) {
                        return item
                    },
                    _processGroupItems: function(items, groupsCount, options) {
                        var groupedColumns = this._columnsController.getGroupColumns();
                        var column = groupedColumns[groupedColumns.length - groupsCount];
                        if (!options) {
                            var scrollingMode = this.option("scrolling.mode");
                            options = {
                                collectContinuationItems: "virtual" !== scrollingMode && "infinite" !== scrollingMode,
                                resultItems: [],
                                path: [],
                                values: []
                            }
                        }
                        var _options = options,
                            resultItems = _options.resultItems;
                        if (options.data) {
                            if (options.collectContinuationItems || !options.data.isContinuation) {
                                resultItems.push({
                                    rowType: "group",
                                    data: options.data,
                                    groupIndex: options.path.length - 1,
                                    isExpanded: !!options.data.items,
                                    key: options.path.slice(0),
                                    values: options.values.slice(0)
                                })
                            }
                        }
                        if (items) {
                            if (0 === groupsCount) {
                                resultItems.push.apply(resultItems, items)
                            } else {
                                for (var i = 0; i < items.length; i++) {
                                    var item = items[i];
                                    if (item && "items" in item) {
                                        options.data = item;
                                        options.path.push(item.key);
                                        options.values.push(column && column.deserializeValue && !column.calculateDisplayValue ? column.deserializeValue(item.key) : item.key);
                                        this._processGroupItems(item.items, groupsCount - 1, options);
                                        options.data = void 0;
                                        options.path.pop();
                                        options.values.pop()
                                    } else {
                                        resultItems.push(item)
                                    }
                                }
                            }
                        }
                        return resultItems
                    },
                    publicMethods: function() {
                        return this.callBase().concat(["collapseAll", "expandAll", "isRowExpanded", "expandRow", "collapseRow"])
                    },
                    collapseAll: function(groupIndex) {
                        var dataSource = this._dataSource;
                        if (dataSource && dataSource.collapseAll(groupIndex)) {
                            dataSource.pageIndex(0);
                            dataSource.reload()
                        }
                    },
                    expandAll: function(groupIndex) {
                        var dataSource = this._dataSource;
                        if (dataSource && dataSource.expandAll(groupIndex)) {
                            dataSource.pageIndex(0);
                            dataSource.reload()
                        }
                    },
                    changeRowExpand: function(key) {
                        var that = this;
                        var expanded = that.isRowExpanded(key);
                        var args = {
                            key: key,
                            expanded: expanded
                        };
                        that.executeAction(expanded ? "onRowCollapsing" : "onRowExpanding", args);
                        if (!args.cancel) {
                            return (0, _deferred.when)(that._changeRowExpandCore(key)).done((function() {
                                args.expanded = !expanded;
                                that.executeAction(expanded ? "onRowCollapsed" : "onRowExpanded", args)
                            }))
                        }
                        return (new _deferred.Deferred).resolve()
                    },
                    _changeRowExpandCore: function(key) {
                        var that = this;
                        var dataSource = this._dataSource;
                        var d = new _deferred.Deferred;
                        if (!dataSource) {
                            d.resolve()
                        } else {
                            (0, _deferred.when)(dataSource.changeRowExpand(key)).done((function() {
                                that.load().done(d.resolve).fail(d.reject)
                            })).fail(d.reject)
                        }
                        return d
                    },
                    isRowExpanded: function(key) {
                        var dataSource = this._dataSource;
                        return dataSource && dataSource.isRowExpanded(key)
                    },
                    expandRow: function(key) {
                        if (!this.isRowExpanded(key)) {
                            return this.changeRowExpand(key)
                        }
                        return (new _deferred.Deferred).resolve()
                    },
                    collapseRow: function(key) {
                        if (this.isRowExpanded(key)) {
                            return this.changeRowExpand(key)
                        }
                        return (new _deferred.Deferred).resolve()
                    },
                    optionChanged: function(args) {
                        if ("grouping" === args.name) {
                            args.name = "dataSource"
                        }
                        this.callBase(args)
                    }
                };
                var onGroupingMenuItemClick = function(column, params) {
                    var columnsController = this._columnsController;
                    switch (params.itemData.value) {
                        case "group":
                            var groups = columnsController._dataSource.group() || [];
                            columnsController.columnOption(column.dataField, "groupIndex", groups.length);
                            break;
                        case "ungroup":
                            columnsController.columnOption(column.dataField, "groupIndex", -1);
                            break;
                        case "ungroupAll":
                            this.component.clearGrouping()
                    }
                };
                var isGroupPanelVisible = function(groupPanelOptions) {
                    var visible = null === groupPanelOptions || void 0 === groupPanelOptions ? void 0 : groupPanelOptions.visible;
                    return "auto" === visible ? "desktop" === _devices.default.current().deviceType : !!visible
                };
                var _allowDragging = function(groupPanelOptions, column) {
                    var isVisible = isGroupPanelVisible(groupPanelOptions);
                    var canDrag = (null === groupPanelOptions || void 0 === groupPanelOptions ? void 0 : groupPanelOptions.allowColumnDragging) && column.allowGrouping;
                    return isVisible && !!canDrag
                };
                var GroupingHeaderPanelExtender = {
                    _getToolbarItems: function() {
                        var items = this.callBase();
                        return this._appendGroupingItem(items)
                    },
                    _appendGroupingItem: function(items) {
                        var _this = this;
                        if (this._isGroupPanelVisible()) {
                            var isRendered = false;
                            var toolbarItem = {
                                template: function() {
                                    var $groupPanel = (0, _renderer.default)("<div>").addClass("dx-datagrid-group-panel");
                                    _this._updateGroupPanelContent($groupPanel);
                                    (0, _m_accessibility.registerKeyboardAction)("groupPanel", _this, $groupPanel, void 0, _this._handleActionKeyDown.bind(_this));
                                    return $groupPanel
                                },
                                name: "groupPanel",
                                onItemRendered: function() {
                                    isRendered && _this.renderCompleted.fire();
                                    isRendered = true
                                },
                                location: "before",
                                locateInMenu: "never",
                                sortIndex: 1
                            };
                            items.push(toolbarItem);
                            this.updateToolbarDimensions()
                        }
                        return items
                    },
                    _handleActionKeyDown: function(args) {
                        var event = args.event;
                        var $target = (0, _renderer.default)(event.target);
                        var groupColumnIndex = $target.closest(".".concat("dx-group-panel-item")).index();
                        var column = this._columnsController.getGroupColumns()[groupColumnIndex];
                        var columnIndex = column && column.index;
                        if ($target.is(".dx-header-filter")) {
                            this.getController("headerFilter").showHeaderFilterMenu(columnIndex, true)
                        } else {
                            this._processGroupItemAction(columnIndex)
                        }
                        event.preventDefault()
                    },
                    _isGroupPanelVisible: function() {
                        return isGroupPanelVisible(this.option("groupPanel"))
                    },
                    _renderGroupPanelItems: function($groupPanel, groupColumns) {
                        var that = this;
                        $groupPanel.empty();
                        (0, _iterator.each)(groupColumns, (function(index, groupColumn) {
                            that._createGroupPanelItem($groupPanel, groupColumn)
                        }));
                        (0, _accessibility.restoreFocus)(this)
                    },
                    _createGroupPanelItem: function($rootElement, groupColumn) {
                        var $groupPanelItem = (0, _renderer.default)("<div>").addClass(groupColumn.cssClass).addClass("dx-group-panel-item").data("columnData", groupColumn).appendTo($rootElement).text(groupColumn.caption);
                        (0, _accessibility.setTabIndex)(this, $groupPanelItem);
                        return $groupPanelItem
                    },
                    _columnOptionChanged: function(e) {
                        if (!this._requireReady && !_m_core.default.checkChanges(e.optionNames, ["width", "visibleWidth"])) {
                            var $toolbarElement = this.element();
                            var $groupPanel = $toolbarElement && $toolbarElement.find(".".concat("dx-datagrid-group-panel"));
                            if ($groupPanel && $groupPanel.length) {
                                this._updateGroupPanelContent($groupPanel);
                                this.updateToolbarDimensions();
                                this.renderCompleted.fire()
                            }
                        }
                        this.callBase()
                    },
                    _updateGroupPanelContent: function($groupPanel) {
                        var groupColumns = this.getController("columns").getGroupColumns();
                        var groupPanelOptions = this.option("groupPanel");
                        this._renderGroupPanelItems($groupPanel, groupColumns);
                        if (groupPanelOptions.allowColumnDragging && !groupColumns.length) {
                            (0, _renderer.default)("<div>").addClass("dx-group-panel-message").text(groupPanelOptions.emptyPanelText).appendTo($groupPanel);
                            $groupPanel.closest(".".concat("dx-toolbar-item")).addClass("dx-toolbar-label");
                            $groupPanel.closest(".".concat("dx-toolbar-label")).css("maxWidth", "none")
                        }
                    },
                    allowDragging: function(column) {
                        var groupPanelOptions = this.option("groupPanel");
                        return _allowDragging(groupPanelOptions, column)
                    },
                    getColumnElements: function() {
                        var $element = this.element();
                        return $element && $element.find(".".concat("dx-group-panel-item"))
                    },
                    getColumns: function() {
                        return this.getController("columns").getGroupColumns()
                    },
                    getBoundingRect: function() {
                        var $element = this.element();
                        if ($element && $element.find(".".concat("dx-datagrid-group-panel")).length) {
                            var offset = $element.offset();
                            return {
                                top: offset.top,
                                bottom: offset.top + (0, _size.getHeight)($element)
                            }
                        }
                        return null
                    },
                    getName: function() {
                        return "group"
                    },
                    getContextMenuItems: function(options) {
                        var contextMenuEnabled = this.option("grouping.contextMenuEnabled");
                        var $groupedColumnElement = (0, _renderer.default)(options.targetElement).closest(".".concat("dx-group-panel-item"));
                        var items;
                        if ($groupedColumnElement.length) {
                            options.column = $groupedColumnElement.data("columnData")
                        }
                        if (contextMenuEnabled && options.column) {
                            var column = options.column;
                            var isGroupingAllowed = (0, _type.isDefined)(column.allowGrouping) ? column.allowGrouping : true;
                            if (isGroupingAllowed) {
                                var isColumnGrouped = (0, _type.isDefined)(column.groupIndex) && column.groupIndex > -1;
                                var groupingTexts = this.option("grouping.texts");
                                var onItemClick = onGroupingMenuItemClick.bind(this, column);
                                items = [{
                                    text: groupingTexts.ungroup,
                                    value: "ungroup",
                                    disabled: !isColumnGrouped,
                                    onItemClick: onItemClick
                                }, {
                                    text: groupingTexts.ungroupAll,
                                    value: "ungroupAll",
                                    onItemClick: onItemClick
                                }]
                            }
                        }
                        return items
                    },
                    isVisible: function() {
                        return this.callBase() || this._isGroupPanelVisible()
                    },
                    hasGroupedColumns: function() {
                        return this._isGroupPanelVisible() && !!this.getColumns().length
                    },
                    optionChanged: function(args) {
                        if ("groupPanel" === args.name) {
                            this._invalidate();
                            args.handled = true
                        } else {
                            this.callBase(args)
                        }
                    }
                };
                exports.GroupingHeaderPanelExtender = GroupingHeaderPanelExtender;
                var GroupingRowsViewExtender = {
                    getContextMenuItems: function(options) {
                        var contextMenuEnabled = this.option("grouping.contextMenuEnabled");
                        var items;
                        if (contextMenuEnabled && options.row && "group" === options.row.rowType) {
                            var columnsController = this._columnsController;
                            var column = columnsController.columnOption("groupIndex:".concat(options.row.groupIndex));
                            if (column && column.allowGrouping) {
                                var groupingTexts = this.option("grouping.texts");
                                var onItemClick = onGroupingMenuItemClick.bind(this, column);
                                items = [];
                                items.push({
                                    text: groupingTexts.ungroup,
                                    value: "ungroup",
                                    onItemClick: onItemClick
                                }, {
                                    text: groupingTexts.ungroupAll,
                                    value: "ungroupAll",
                                    onItemClick: onItemClick
                                })
                            }
                        }
                        return items
                    },
                    _rowClick: function(e) {
                        var expandMode = this.option("grouping.expandMode");
                        var scrollingMode = this.option("scrolling.mode");
                        var isGroupRowStateChanged = "infinite" !== scrollingMode && "rowClick" === expandMode && (0, _renderer.default)(e.event.target).closest(".".concat("dx-group-row")).length;
                        var isExpandButtonClicked = (0, _renderer.default)(e.event.target).closest(".".concat("dx-datagrid-expand")).length;
                        if (isGroupRowStateChanged || isExpandButtonClicked) {
                            this._changeGroupRowState(e)
                        }
                        this.callBase(e)
                    },
                    _changeGroupRowState: function(e) {
                        var dataController = this.getController("data");
                        var row = dataController.items()[e.rowIndex];
                        var allowCollapsing = this._columnsController.columnOption("groupIndex:".concat(row.groupIndex), "allowCollapsing");
                        if ("data" === row.rowType || "group" === row.rowType && false !== allowCollapsing) {
                            dataController.changeRowExpand(row.key, true);
                            e.event.preventDefault();
                            e.handled = true
                        }
                    }
                };
                var columnHeadersViewExtender = {
                    getContextMenuItems: function(options) {
                        var contextMenuEnabled = this.option("grouping.contextMenuEnabled");
                        var items = this.callBase(options);
                        if (contextMenuEnabled && options.row && ("header" === options.row.rowType || "detailAdaptive" === options.row.rowType)) {
                            var column = options.column;
                            if (!column.command && (!(0, _type.isDefined)(column.allowGrouping) || column.allowGrouping)) {
                                var groupingTexts = this.option("grouping.texts");
                                var isColumnGrouped = (0, _type.isDefined)(column.groupIndex) && column.groupIndex > -1;
                                var onItemClick = onGroupingMenuItemClick.bind(this, column);
                                items = items || [];
                                items.push({
                                    text: groupingTexts.groupByThisColumn,
                                    value: "group",
                                    beginGroup: true,
                                    disabled: isColumnGrouped,
                                    onItemClick: onItemClick
                                });
                                if (column.showWhenGrouped) {
                                    items.push({
                                        text: groupingTexts.ungroup,
                                        value: "ungroup",
                                        disabled: !isColumnGrouped,
                                        onItemClick: onItemClick
                                    })
                                }
                                items.push({
                                    text: groupingTexts.ungroupAll,
                                    value: "ungroupAll",
                                    onItemClick: onItemClick
                                })
                            }
                        }
                        return items
                    },
                    allowDragging: function(column) {
                        var groupPanelOptions = this.option("groupPanel");
                        return _allowDragging(groupPanelOptions, column) || this.callBase(column)
                    }
                };
                _m_core.default.registerModule("grouping", {
                    defaultOptions: function() {
                        return {
                            grouping: {
                                autoExpandAll: true,
                                allowCollapsing: true,
                                contextMenuEnabled: false,
                                expandMode: "buttonClick",
                                texts: {
                                    groupContinuesMessage: _message.default.format("dxDataGrid-groupContinuesMessage"),
                                    groupContinuedMessage: _message.default.format("dxDataGrid-groupContinuedMessage"),
                                    groupByThisColumn: _message.default.format("dxDataGrid-groupHeaderText"),
                                    ungroup: _message.default.format("dxDataGrid-ungroupHeaderText"),
                                    ungroupAll: _message.default.format("dxDataGrid-ungroupAllText")
                                }
                            },
                            groupPanel: {
                                visible: false,
                                emptyPanelText: _message.default.format("dxDataGrid-groupPanelEmptyText"),
                                allowColumnDragging: true
                            }
                        }
                    },
                    extenders: {
                        controllers: {
                            data: GroupingDataControllerExtender,
                            columns: {
                                _getExpandColumnOptions: function() {
                                    var options = this.callBase.apply(this, arguments);
                                    options.cellTemplate = _m_core.default.getExpandCellTemplate();
                                    return options
                                }
                            },
                            editing: {
                                _isProcessedItem: function(item) {
                                    return (0, _type.isDefined)(item.groupIndex) && (0, _type.isString)(item.rowType) && 0 === item.rowType.indexOf("group")
                                }
                            }
                        },
                        views: {
                            headerPanel: GroupingHeaderPanelExtender,
                            rowsView: GroupingRowsViewExtender,
                            columnHeadersView: columnHeadersViewExtender
                        }
                    }
                })
            },
        2772:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/grouping/m_grouping_collapsed.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupingHelper = void 0;
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _errors = __webpack_require__( /*! ../../../../data/errors */ 18438);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_utils = __webpack_require__( /*! ../m_utils */ 10087);
                var _m_grouping_core = __webpack_require__( /*! ./m_grouping_core */ 8748);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function getContinuationGroupCount(groupOffset, pageSize, groupSize, groupIndex) {
                    groupIndex = groupIndex || 0;
                    if (pageSize > 1 && groupSize > 0) {
                        var pageOffset = groupOffset - Math.floor(groupOffset / pageSize) * pageSize || pageSize;
                        pageOffset += groupSize - groupIndex - 2;
                        if (pageOffset < 0) {
                            pageOffset += pageSize
                        }
                        return Math.floor(pageOffset / (pageSize - groupIndex - 1))
                    }
                    return 0
                }
                var GroupingHelper = _m_grouping_core.GroupingHelper.inherit(function() {
                    var foreachExpandedGroups = function(that, callback, updateGroups) {
                        return that.foreachGroups((function(groupInfo, parents) {
                            if (groupInfo.isExpanded) {
                                return callback(groupInfo, parents)
                            }
                        }), true, false, updateGroups, updateGroups)
                    };
                    var processGroupItems = function processGroupItems(that, items, groupsCount, expandedInfo, path, isCustomLoading, isLastGroupExpanded) {
                        var isExpanded;
                        expandedInfo.items = expandedInfo.items || [];
                        expandedInfo.paths = expandedInfo.paths || [];
                        expandedInfo.count = expandedInfo.count || 0;
                        expandedInfo.lastCount = expandedInfo.lastCount || 0;
                        if (!groupsCount) {
                            return
                        }
                        for (var i = 0; i < items.length; i++) {
                            var item = items[i];
                            if (void 0 !== item.items) {
                                path.push(item.key);
                                if (isCustomLoading) {
                                    isExpanded = true
                                } else {
                                    var groupInfo = that.findGroupInfo(path);
                                    isExpanded = groupInfo && groupInfo.isExpanded
                                }
                                if (!isExpanded) {
                                    item.collapsedItems = item.items;
                                    item.items = null
                                } else if (item.items) {
                                    processGroupItems(that, item.items, groupsCount - 1, expandedInfo, path, isCustomLoading, isLastGroupExpanded)
                                } else if (1 === groupsCount && item.count && (!isCustomLoading || isLastGroupExpanded)) {
                                    expandedInfo.items.push(item);
                                    expandedInfo.paths.push(path.slice(0));
                                    expandedInfo.count += expandedInfo.lastCount;
                                    expandedInfo.lastCount = item.count
                                }
                                path.pop()
                            }
                        }
                    };
                    var updateGroupInfoItem = function(that, item, isLastGroupLevel, path, offset) {
                        var groupInfo = that.findGroupInfo(path);
                        var count;
                        if (!groupInfo) {
                            if (isLastGroupLevel) {
                                count = item.count > 0 ? item.count : item.items.length
                            }
                            that.addGroupInfo({
                                isExpanded: that._isGroupExpanded(path.length - 1),
                                path: path.slice(0),
                                offset: offset,
                                count: count || 0
                            })
                        } else {
                            if (isLastGroupLevel) {
                                groupInfo.count = item.count > 0 ? item.count : item.items && item.items.length || 0
                            } else {
                                item.count = groupInfo.count || item.count
                            }
                            groupInfo.offset = offset
                        }
                    };
                    var updateGroupInfos = function updateGroupInfos(that, options, items, loadedGroupCount, groupIndex, path, parentIndex) {
                        var groupCount = options.group ? options.group.length : 0;
                        var isLastGroupLevel = groupCount === loadedGroupCount;
                        var remotePaging = options.remoteOperations.paging;
                        var offset = 0;
                        var totalCount = 0;
                        var count;
                        groupIndex = groupIndex || 0;
                        path = path || [];
                        if (remotePaging && !parentIndex) {
                            offset = 0 === groupIndex ? options.skip || 0 : options.skips[groupIndex - 1] || 0
                        }
                        if (groupIndex >= loadedGroupCount) {
                            return items.length
                        }
                        for (var i = 0; i < items.length; i++) {
                            var item = items[i];
                            if (item) {
                                path.push(item.key);
                                if (!item.count && !item.items || void 0 === item.items) {
                                    return -1
                                }
                                updateGroupInfoItem(that, item, isLastGroupLevel, path, offset + i);
                                count = item.items ? updateGroupInfos(that, options, item.items, loadedGroupCount, groupIndex + 1, path, i) : item.count || -1;
                                if (count < 0) {
                                    return -1
                                }
                                totalCount += count;
                                path.pop()
                            }
                        }
                        return totalCount
                    };
                    var isGroupExpanded = function(groups, groupIndex) {
                        return groups && groups.length && groups[groupIndex] && !!groups[groupIndex].isExpanded
                    };
                    var getTotalOffset = function(groupInfos, pageSize, offset) {
                        var groupSize;
                        var totalOffset = offset;
                        for (var groupIndex = 0; groupIndex < groupInfos.length; groupIndex++) {
                            groupSize = groupInfos[groupIndex].offset + 1;
                            if (groupIndex > 0) {
                                groupSize += groupInfos[groupIndex - 1].childrenTotalCount;
                                if (pageSize) {
                                    groupSize += getContinuationGroupCount(totalOffset, pageSize, groupSize, groupIndex - 1) * groupIndex
                                }
                            }
                            totalOffset += groupSize
                        }
                        return totalOffset
                    };

                    function applyContinuationToGroupItem(options, expandedInfo, groupLevel, expandedItemIndex) {
                        var item = expandedInfo.items[expandedItemIndex];
                        var skip = options.skips && options.skips[groupLevel];
                        var take = options.takes && options.takes[groupLevel];
                        var isLastExpandedItem = expandedItemIndex === expandedInfo.items.length - 1;
                        var isFirstExpandedItem = 0 === expandedItemIndex;
                        var lastExpandedItemSkip = isFirstExpandedItem && skip || 0;
                        var isItemsTruncatedByTake = item.count > take + lastExpandedItemSkip;
                        if (isFirstExpandedItem && void 0 !== skip) {
                            item.isContinuation = true
                        }
                        if (isLastExpandedItem && void 0 !== take && isItemsTruncatedByTake) {
                            item.isContinuationOnNextPage = true
                        }
                    }

                    function isDataDeferred(data) {
                        return !Array.isArray(data)
                    }

                    function makeDataDeferred(options) {
                        if (!isDataDeferred(options.data)) {
                            options.data = new _deferred.Deferred
                        }
                    }

                    function loadGroupItems(that, options, loadedGroupCount, expandedInfo, groupLevel, data) {
                        if (!options.isCustomLoading) {
                            expandedInfo = {};
                            processGroupItems(that, data, loadedGroupCount, expandedInfo, []);
                            ! function(options, expandedInfo, currentGroupCount) {
                                var currentGroupIndex = currentGroupCount - 1;
                                var groupCount = options.group ? options.group.length : 0;
                                expandedInfo.skip = options.skips && options.skips[currentGroupIndex];
                                if (options.takes && void 0 !== options.takes[currentGroupIndex]) {
                                    if (groupCount === currentGroupCount) {
                                        expandedInfo.take = expandedInfo.count ? expandedInfo.count - (expandedInfo.skip || 0) : 0
                                    } else {
                                        expandedInfo.take = 0
                                    }
                                    expandedInfo.take += options.takes[currentGroupIndex]
                                }
                            }(options, expandedInfo, loadedGroupCount)
                        }
                        var groupCount = options.group ? options.group.length : 0;
                        if (expandedInfo.paths.length && groupCount - loadedGroupCount > 0) {
                            makeDataDeferred(options);
                            ! function(that, options, expandedInfo, loadedGroupCount, groupLevel, data) {
                                var groups = options.group || [];
                                var currentGroup = groups[groupLevel + 1];
                                var deferreds = [];
                                (0, _iterator.each)(expandedInfo.paths, (function(expandedItemIndex) {
                                    var _a;
                                    var loadOptions = {
                                        requireTotalCount: false,
                                        requireGroupCount: true,
                                        group: [currentGroup],
                                        groupSummary: options.storeLoadOptions.groupSummary,
                                        filter: (0, _m_utils.createGroupFilter)(expandedInfo.paths[expandedItemIndex], {
                                            filter: options.storeLoadOptions.filter,
                                            group: groups
                                        }),
                                        select: options.storeLoadOptions.select,
                                        langParams: null === (_a = options.storeLoadOptions) || void 0 === _a ? void 0 : _a.langParams
                                    };
                                    if (0 === expandedItemIndex) {
                                        loadOptions.skip = expandedInfo.skip || 0
                                    }
                                    if (expandedItemIndex === expandedInfo.paths.length - 1) {
                                        loadOptions.take = expandedInfo.take
                                    }
                                    var loadResult = 0 === loadOptions.take ? [] : that._dataSource.loadFromStore(loadOptions);
                                    (0, _deferred.when)(loadResult).done((function(data) {
                                        var item = expandedInfo.items[expandedItemIndex];
                                        applyContinuationToGroupItem(options, expandedInfo, groupLevel, expandedItemIndex);
                                        item.items = data
                                    }));
                                    deferreds.push(loadResult)
                                }));
                                _deferred.when.apply(null, deferreds).done((function() {
                                    updateGroupInfos(that, options, data, loadedGroupCount + 1);
                                    loadGroupItems(that, options, loadedGroupCount + 1, expandedInfo, groupLevel + 1, data)
                                }))
                            }(that, options, expandedInfo, loadedGroupCount, groupLevel, data)
                        } else if (expandedInfo.paths.length && options.storeLoadOptions.group) {
                            makeDataDeferred(options);
                            ! function(that, options, expandedInfo, data) {
                                var expandedFilters = [];
                                var groups = options.group || [];
                                (0, _iterator.each)(expandedInfo.paths, (function(_, expandedPath) {
                                    expandedFilters.push((0, _m_utils.createGroupFilter)(expandedPath, {
                                        group: options.isCustomLoading ? options.storeLoadOptions.group : groups
                                    }))
                                }));
                                var filter = options.storeLoadOptions.filter;
                                if (!options.storeLoadOptions.isLoadingAll) {
                                    filter = _m_core.default.combineFilters([filter, _m_core.default.combineFilters(expandedFilters, "or")])
                                }
                                var loadOptions = (0, _extend.extend)({}, options.storeLoadOptions, {
                                    requireTotalCount: false,
                                    requireGroupCount: false,
                                    group: null,
                                    sort: groups.concat(_m_core.default.normalizeSortingInfo(options.storeLoadOptions.sort || [])),
                                    filter: filter
                                });
                                var isPagingLocal = that._dataSource.isLastLevelGroupItemsPagingLocal();
                                if (!isPagingLocal) {
                                    loadOptions.skip = expandedInfo.skip;
                                    loadOptions.take = expandedInfo.take
                                }(0, _deferred.when)(0 === expandedInfo.take ? [] : that._dataSource.loadFromStore(loadOptions)).done((function(items) {
                                    if (isPagingLocal) {
                                        items = that._dataSource.sortLastLevelGroupItems(items, groups, expandedInfo.paths);
                                        items = expandedInfo.skip ? items.slice(expandedInfo.skip) : items;
                                        items = expandedInfo.take ? items.slice(0, expandedInfo.take) : items
                                    }(0, _iterator.each)(expandedInfo.items, (function(index, item) {
                                        var itemCount = item.count - (0 === index && expandedInfo.skip || 0);
                                        var expandedItems = items.splice(0, itemCount);
                                        applyContinuationToGroupItem(options, expandedInfo, groups.length - 1, index);
                                        item.items = expandedItems
                                    }));
                                    options.data.resolve(data)
                                })).fail(options.data.reject)
                            }(that, options, expandedInfo, data)
                        } else if (isDataDeferred(options.data)) {
                            options.data.resolve(data)
                        }
                    }
                    var loadGroupTotalCount = function(dataSource, options) {
                        var d = new _deferred.Deferred;
                        var isGrouping = !!(options.group && options.group.length);
                        var loadOptions = (0, _extend.extend)({
                            skip: 0,
                            take: 1,
                            requireGroupCount: isGrouping,
                            requireTotalCount: !isGrouping
                        }, options, {
                            group: isGrouping ? options.group : null
                        });
                        dataSource.load(loadOptions).done((function(data, extra) {
                            var count = extra && (isGrouping ? extra.groupCount : extra.totalCount);
                            if (!isFinite(count)) {
                                d.reject(_errors.errors.Error(isGrouping ? "E4022" : "E4021"));
                                return
                            }
                            d.resolve(count)
                        })).fail(d.reject.bind(d));
                        return d
                    };
                    return {
                        updateTotalItemsCount: function(options) {
                            var totalItemsCount = 0;
                            var totalCount = options.extra && options.extra.totalCount || 0;
                            var groupCount = options.extra && options.extra.groupCount || 0;
                            var pageSize = this._dataSource.pageSize();
                            var isVirtualPaging = this._isVirtualPaging();
                            foreachExpandedGroups(this, (function(groupInfo) {
                                groupInfo.childrenTotalCount = 0
                            }));
                            foreachExpandedGroups(this, (function(groupInfo, parents) {
                                var totalOffset = getTotalOffset(parents, isVirtualPaging ? 0 : pageSize, totalItemsCount);
                                var count = groupInfo.count + groupInfo.childrenTotalCount;
                                if (!isVirtualPaging) {
                                    count += getContinuationGroupCount(totalOffset, pageSize, count, parents.length - 1)
                                }
                                if (parents[parents.length - 2]) {
                                    parents[parents.length - 2].childrenTotalCount += count
                                } else {
                                    totalItemsCount += count
                                }
                            }));
                            this.callBase(totalItemsCount - totalCount + groupCount)
                        },
                        _isGroupExpanded: function(groupIndex) {
                            var groups = this._dataSource.group();
                            return isGroupExpanded(groups, groupIndex)
                        },
                        _updatePagingOptions: function(options, callback) {
                            var isVirtualPaging = this._isVirtualPaging();
                            var pageSize = this._dataSource.pageSize();
                            var skips = [];
                            var takes = [];
                            var skipChildrenTotalCount = 0;
                            var childrenTotalCount = 0;
                            if (options.take) {
                                foreachExpandedGroups(this, (function(groupInfo) {
                                    groupInfo.childrenTotalCount = 0;
                                    groupInfo.skipChildrenTotalCount = 0
                                }));
                                foreachExpandedGroups(this, (function(groupInfo, parents) {
                                    var take;
                                    var takeCorrection = 0;
                                    var parentTakeCorrection = 0;
                                    var totalOffset = getTotalOffset(parents, isVirtualPaging ? 0 : pageSize, childrenTotalCount);
                                    var continuationGroupCount = 0;
                                    var skipContinuationGroupCount = 0;
                                    var groupInfoCount = groupInfo.count + groupInfo.childrenTotalCount;
                                    var childrenGroupInfoCount = groupInfoCount;
                                    callback && callback(groupInfo, totalOffset);
                                    var skip = options.skip - totalOffset;
                                    if (totalOffset <= options.skip + options.take && groupInfoCount) {
                                        take = options.take;
                                        if (!isVirtualPaging) {
                                            continuationGroupCount = getContinuationGroupCount(totalOffset, pageSize, groupInfoCount, parents.length - 1);
                                            groupInfoCount += continuationGroupCount * parents.length;
                                            childrenGroupInfoCount += continuationGroupCount;
                                            if (pageSize && skip >= 0) {
                                                takeCorrection = parents.length;
                                                parentTakeCorrection = parents.length - 1;
                                                skipContinuationGroupCount = Math.floor(skip / pageSize)
                                            }
                                        }
                                        if (skip >= 0) {
                                            if (totalOffset + groupInfoCount > options.skip) {
                                                skips.unshift(skip - skipContinuationGroupCount * takeCorrection - groupInfo.skipChildrenTotalCount)
                                            }
                                            if (totalOffset + groupInfoCount >= options.skip + take) {
                                                takes.unshift(take - takeCorrection - groupInfo.childrenTotalCount + groupInfo.skipChildrenTotalCount)
                                            }
                                        } else if (totalOffset + groupInfoCount >= options.skip + take) {
                                            takes.unshift(take + skip - groupInfo.childrenTotalCount)
                                        }
                                    }
                                    if (totalOffset <= options.skip) {
                                        if (parents[parents.length - 2]) {
                                            parents[parents.length - 2].skipChildrenTotalCount += Math.min(childrenGroupInfoCount, skip + 1 - skipContinuationGroupCount * parentTakeCorrection)
                                        } else {
                                            skipChildrenTotalCount += Math.min(childrenGroupInfoCount, skip + 1)
                                        }
                                    }
                                    if (totalOffset <= options.skip + take) {
                                        groupInfoCount = Math.min(childrenGroupInfoCount, skip + take - (skipContinuationGroupCount + 1) * parentTakeCorrection);
                                        if (parents[parents.length - 2]) {
                                            parents[parents.length - 2].childrenTotalCount += groupInfoCount
                                        } else {
                                            childrenTotalCount += groupInfoCount
                                        }
                                    }
                                }));
                                options.skip -= skipChildrenTotalCount;
                                options.take -= childrenTotalCount - skipChildrenTotalCount
                            }
                            options.skips = skips;
                            options.takes = takes
                        },
                        changeRowExpand: function(path) {
                            var groupInfo = this.findGroupInfo(path);
                            var dataSource = this._dataSource;
                            var remoteGroupPaging = dataSource.remoteOperations().groupPaging;
                            var groups = _m_core.default.normalizeSortingInfo(dataSource.group());
                            if (groupInfo) {
                                groupInfo.isExpanded = !groupInfo.isExpanded;
                                if (remoteGroupPaging && groupInfo.isExpanded && path.length < groups.length) {
                                    return loadGroupTotalCount(dataSource, {
                                        filter: (0, _m_utils.createGroupFilter)(path, {
                                            filter: dataSource.lastLoadOptions().filter,
                                            group: dataSource.group()
                                        }),
                                        group: [groups[path.length]],
                                        select: dataSource.select()
                                    }).done((function(groupCount) {
                                        groupInfo.count = groupCount
                                    }))
                                }
                                return (new _deferred.Deferred).resolve()
                            }
                            return (new _deferred.Deferred).reject()
                        },
                        handleDataLoading: function(options) {
                            var storeLoadOptions = options.storeLoadOptions;
                            var groups = _m_core.default.normalizeSortingInfo(storeLoadOptions.group || options.loadOptions.group);
                            if (options.isCustomLoading || !groups.length) {
                                return
                            }
                            if (options.remoteOperations.grouping) {
                                var remotePaging = this._dataSource.remoteOperations().paging;
                                storeLoadOptions.group = _m_core.default.normalizeSortingInfo(storeLoadOptions.group);
                                storeLoadOptions.group.forEach((function(group, index) {
                                    var isLastGroup = index === storeLoadOptions.group.length - 1;
                                    group.isExpanded = !remotePaging || !isLastGroup
                                }))
                            }
                            options.group = options.group || groups;
                            if (options.remoteOperations.paging) {
                                options.skip = storeLoadOptions.skip;
                                options.take = storeLoadOptions.take;
                                storeLoadOptions.requireGroupCount = true;
                                storeLoadOptions.group = groups.slice(0, 1);
                                this._updatePagingOptions(options);
                                storeLoadOptions.skip = options.skip;
                                storeLoadOptions.take = options.take
                            } else {
                                options.skip = options.loadOptions.skip;
                                options.take = options.loadOptions.take;
                                this._updatePagingOptions(options)
                            }
                        },
                        handleDataLoadedCore: function(options, callBase) {
                            var loadedGroupCount = _m_core.default.normalizeSortingInfo(options.storeLoadOptions.group || options.loadOptions.group).length;
                            var groupCount = options.group ? options.group.length : 0;
                            var totalCount;
                            var expandedInfo = {};
                            if (options.isCustomLoading) {
                                callBase(options);
                                processGroupItems(this, options.data, loadedGroupCount, expandedInfo, [], options.isCustomLoading, options.storeLoadOptions.isLoadingAll)
                            } else {
                                if (!options.remoteOperations.paging) {
                                    this.foreachGroups((function(groupInfo) {
                                        groupInfo.count = 0
                                    }))
                                }
                                totalCount = updateGroupInfos(this, options, options.data, loadedGroupCount);
                                if (totalCount < 0) {
                                    options.data = (new _deferred.Deferred).reject(_ui.default.Error("E1037"));
                                    return
                                }
                                if (!options.remoteOperations.paging) {
                                    if (loadedGroupCount && options.extra && options.loadOptions.requireTotalCount) {
                                        options.extra.totalCount = totalCount;
                                        options.extra.groupCount = options.data.length
                                    }
                                }
                                if (groupCount && options.storeLoadOptions.requireGroupCount && !isFinite(options.extra.groupCount)) {
                                    options.data = (new _deferred.Deferred).reject(_errors.errors.Error("E4022"));
                                    return
                                }
                                this.updateTotalItemsCount(options);
                                if (!options.remoteOperations.paging) {
                                    this._updatePagingOptions(options)
                                }
                                callBase(options);
                                if (!options.remoteOperations.paging) {
                                    this._processPaging(options, loadedGroupCount)
                                }
                            }
                            loadGroupItems(this, options, loadedGroupCount, expandedInfo, 0, options.data)
                        },
                        _processSkips: function(items, skips, groupCount) {
                            if (!groupCount) {
                                return
                            }
                            var firstItem = items[0];
                            var skip = skips[0];
                            var children = firstItem && firstItem.items;
                            if (void 0 !== skip) {
                                firstItem.isContinuation = true;
                                if (children) {
                                    firstItem.items = children.slice(skip);
                                    this._processSkips(firstItem.items, skips.slice(1), groupCount - 1)
                                }
                            }
                        },
                        _processTakes: function(items, skips, takes, groupCount, parents) {
                            if (!groupCount || !items) {
                                return
                            }
                            parents = parents || [];
                            var lastItem = items[items.length - 1];
                            var children = lastItem && lastItem.items;
                            var take = takes[0];
                            var skip = skips[0];
                            if (lastItem) {
                                var maxTakeCount = lastItem.count - (lastItem.isContinuation && skip || 0) || children.length;
                                if (void 0 !== take && maxTakeCount > take) {
                                    lastItem.isContinuationOnNextPage = true;
                                    parents.forEach((function(parent) {
                                        parent.isContinuationOnNextPage = true
                                    }));
                                    if (children) {
                                        children = children.slice(0, take);
                                        lastItem.items = children
                                    }
                                }
                                parents.push(lastItem);
                                this._processTakes(children, skips.slice(1), takes.slice(1), groupCount - 1, parents)
                            }
                        },
                        _processPaging: function(options, groupCount) {
                            this._processSkips(options.data, options.skips, groupCount);
                            this._processTakes(options.data, options.skips, options.takes, groupCount)
                        },
                        isLastLevelGroupItemsPagingLocal: function() {
                            return false
                        },
                        sortLastLevelGroupItems: function(items) {
                            return items
                        },
                        refresh: function(options, operationTypes) {
                            var that = this;
                            var dataSource = that._dataSource;
                            var storeLoadOptions = options.storeLoadOptions;
                            var group = options.group || options.storeLoadOptions.group;
                            var oldGroups = _m_core.default.normalizeSortingInfo(that._group);
                            var isExpanded;
                            var groupIndex;

                            function handleGroup(groupInfo, parents) {
                                if (parents.length === groupIndex + 1) {
                                    groupInfo.isExpanded = isExpanded
                                }
                            }
                            for (groupIndex = 0; groupIndex < oldGroups.length; groupIndex++) {
                                isExpanded = isGroupExpanded(group, groupIndex);
                                if (isGroupExpanded(that._group, groupIndex) !== isExpanded) {
                                    that.foreachGroups(handleGroup)
                                }
                            }
                            that.callBase.apply(this, arguments);
                            if (group && options.remoteOperations.paging && operationTypes.reload) {
                                return foreachExpandedGroups(that, (function(groupInfo) {
                                    var groupCountQuery = loadGroupTotalCount(dataSource, {
                                        filter: (0, _m_utils.createGroupFilter)(groupInfo.path, {
                                            filter: storeLoadOptions.filter,
                                            group: group
                                        }),
                                        group: group.slice(groupInfo.path.length),
                                        select: storeLoadOptions.select
                                    });
                                    var groupOffsetQuery = loadGroupTotalCount(dataSource, {
                                        filter: (0, _m_grouping_core.createOffsetFilter)(groupInfo.path, {
                                            filter: storeLoadOptions.filter,
                                            group: group
                                        }, true),
                                        group: group.slice(groupInfo.path.length - 1, groupInfo.path.length),
                                        select: storeLoadOptions.select
                                    });
                                    return (0, _deferred.when)(groupOffsetQuery, groupCountQuery).done((function(offset, count) {
                                        offset = parseInt(offset.length ? offset[0] : offset);
                                        count = parseInt(count.length ? count[0] : count);
                                        groupInfo.offset = offset;
                                        if (groupInfo.count !== count) {
                                            groupInfo.count = count;
                                            that.updateTotalItemsCount(options)
                                        }
                                    }))
                                }), true)
                            }
                        }
                    }
                }());
                exports.GroupingHelper = GroupingHelper
            },
        8748:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/grouping/m_grouping_core.js ***!
              \****************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupingHelper = void 0;
                exports.createOffsetFilter = function(path, storeLoadOptions, lastLevelOnly) {
                    var groups = (0, _utils.normalizeSortingInfo)(storeLoadOptions.group);
                    var filter = [];
                    for (var i = lastLevelOnly ? path.length - 1 : 0; i < path.length; i++) {
                        var filterElement = [];
                        for (var j = 0; j <= i; j++) {
                            var selector = groups[j].selector;
                            if (i === j && (null === path[j] || false === path[j] || true === path[j])) {
                                if (false === path[j]) {
                                    filterElement.push([selector, "=", groups[j].desc ? true : null])
                                } else if (path[j] ? !groups[j].desc : groups[j].desc) {
                                    filterElement.push([selector, "<>", path[j]])
                                } else {
                                    filterElement.push([selector, "<>", null]);
                                    filterElement.push([selector, "=", null])
                                }
                            } else {
                                var currentFilter = [selector, i === j ? groups[j].desc ? ">" : "<" : "=", path[j]];
                                if ("<" === currentFilter[1]) {
                                    filterElement.push([currentFilter, "or", [selector, "=", null]])
                                } else {
                                    filterElement.push(currentFilter)
                                }
                            }
                        }
                        filter.push(_m_core.default.combineFilters(filterElement))
                    }
                    filter = _m_core.default.combineFilters(filter, "or");
                    return _m_core.default.combineFilters([filter, storeLoadOptions.filter])
                };
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../../../core/class */ 38377));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _utils = __webpack_require__( /*! ../../../../data/utils */ 16454);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var GroupingHelper = _class.default.inherit((findGroupInfoByKey = function(groupsInfo, key) {
                    var hash = groupsInfo.hash;
                    return hash && hash[JSON.stringify(key)]
                }, getGroupInfoIndexByOffset = function(groupsInfo, offset) {
                    var leftIndex = 0;
                    var rightIndex = groupsInfo.length - 1;
                    if (!groupsInfo.length) {
                        return 0
                    }
                    do {
                        var middleIndex = rightIndex + leftIndex >> 1;
                        if (groupsInfo[middleIndex].offset > offset) {
                            rightIndex = middleIndex
                        } else {
                            leftIndex = middleIndex
                        }
                    } while (rightIndex - leftIndex > 1);
                    var index;
                    for (index = leftIndex; index <= rightIndex; index++) {
                        if (groupsInfo[index].offset > offset) {
                            break
                        }
                    }
                    return index
                }, {
                    ctor: function(dataSourceAdapter) {
                        this._dataSource = dataSourceAdapter;
                        this.reset()
                    },
                    reset: function() {
                        this._groupsInfo = [];
                        this._totalCountCorrection = 0
                    },
                    totalCountCorrection: function() {
                        return this._totalCountCorrection
                    },
                    updateTotalItemsCount: function(totalCountCorrection) {
                        this._totalCountCorrection = totalCountCorrection || 0
                    },
                    isGroupItemCountable: function(item) {
                        return !this._isVirtualPaging() || !item.isContinuation
                    },
                    _isVirtualPaging: function() {
                        var scrollingMode = this._dataSource.option("scrolling.mode");
                        return "virtual" === scrollingMode || "infinite" === scrollingMode
                    },
                    itemsCount: function() {
                        var dataSourceAdapter = this._dataSource;
                        var dataSource = dataSourceAdapter._dataSource;
                        var groupCount = _m_core.default.normalizeSortingInfo(dataSource.group() || []).length;
                        var itemsCount = function calculateItemsCount(that, items, groupsCount) {
                            var result = 0;
                            if (items) {
                                if (!groupsCount) {
                                    result = items.length
                                } else {
                                    for (var i = 0; i < items.length; i++) {
                                        if (that.isGroupItemCountable(items[i])) {
                                            result++
                                        }
                                        result += calculateItemsCount(that, items[i].items, groupsCount - 1)
                                    }
                                }
                            }
                            return result
                        }(this, dataSource.items(), groupCount);
                        return itemsCount
                    },
                    foreachGroups: function(callback, childrenAtFirst, foreachCollapsedGroups, updateOffsets, updateParentOffsets) {
                        var that = this;
                        return function foreachGroupsCore(groupsInfo, callback, childrenAtFirst, parents) {
                            var callbackResults = [];

                            function executeCallback(callback, data, parents, callbackResults) {
                                var callbackResult = data && callback(data, parents);
                                callbackResult && callbackResults.push(callbackResult);
                                return callbackResult
                            }
                            for (var i = 0; i < groupsInfo.length; i++) {
                                parents.push(groupsInfo[i].data);
                                if (!childrenAtFirst && false === executeCallback(callback, groupsInfo[i].data, parents, callbackResults)) {
                                    return false
                                }
                                if (!groupsInfo[i].data || groupsInfo[i].data.isExpanded || foreachCollapsedGroups) {
                                    var children = groupsInfo[i].children;
                                    var callbackResult = children.length && foreachGroupsCore(children, callback, childrenAtFirst, parents);
                                    callbackResult && callbackResults.push(callbackResult);
                                    if (false === callbackResult) {
                                        return false
                                    }
                                }
                                if (childrenAtFirst && false === executeCallback(callback, groupsInfo[i].data, parents, callbackResults)) {
                                    return false
                                }
                                if (!groupsInfo[i].data || groupsInfo[i].data.offset !== groupsInfo[i].offset) {
                                    updateOffsets = true
                                }
                                parents.pop()
                            }
                            var currentParents = updateParentOffsets && parents.slice(0);
                            return updateOffsets && _deferred.when.apply(_renderer.default, callbackResults).always((function() {
                                that._updateGroupInfoOffsets(groupsInfo, currentParents)
                            }))
                        }(that._groupsInfo, callback, childrenAtFirst, [])
                    },
                    _updateGroupInfoOffsets: function(groupsInfo, parents) {
                        parents = parents || [];
                        for (var index = 0; index < groupsInfo.length; index++) {
                            var groupInfo = groupsInfo[index];
                            if (groupInfo.data && groupInfo.data.offset !== groupInfo.offset) {
                                groupInfo.offset = groupInfo.data.offset;
                                for (var parentIndex = 0; parentIndex < parents.length; parentIndex++) {
                                    parents[parentIndex].offset = groupInfo.offset
                                }
                            }
                        }
                        groupsInfo.sort((function(a, b) {
                            return a.offset - b.offset
                        }))
                    },
                    findGroupInfo: function(path) {
                        var groupInfo;
                        var groupsInfo = this._groupsInfo;
                        for (var pathIndex = 0; groupsInfo && pathIndex < path.length; pathIndex++) {
                            groupInfo = findGroupInfoByKey(groupsInfo, path[pathIndex]);
                            groupsInfo = groupInfo && groupInfo.children
                        }
                        return groupInfo && groupInfo.data
                    },
                    addGroupInfo: function(groupInfoData) {
                        var groupInfo;
                        var path = groupInfoData.path;
                        var groupsInfo = this._groupsInfo;
                        for (var pathIndex = 0; pathIndex < path.length; pathIndex++) {
                            groupInfo = findGroupInfoByKey(groupsInfo, path[pathIndex]);
                            if (!groupInfo) {
                                groupInfo = {
                                    key: path[pathIndex],
                                    offset: groupInfoData.offset,
                                    data: {
                                        offset: groupInfoData.offset,
                                        isExpanded: true,
                                        path: path.slice(0, pathIndex + 1)
                                    },
                                    children: []
                                };
                                var index = getGroupInfoIndexByOffset(groupsInfo, groupInfoData.offset);
                                groupsInfo.splice(index, 0, groupInfo);
                                groupsInfo.hash = groupsInfo.hash || {};
                                groupsInfo.hash[JSON.stringify(groupInfo.key)] = groupInfo
                            }
                            if (pathIndex === path.length - 1) {
                                groupInfo.data = groupInfoData;
                                if (groupInfo.offset !== groupInfoData.offset) {
                                    this._updateGroupInfoOffsets(groupsInfo)
                                }
                            }
                            groupsInfo = groupInfo.children
                        }
                    },
                    allowCollapseAll: function() {
                        return true
                    },
                    refresh: function(options) {
                        var storeLoadOptions = options.storeLoadOptions;
                        var groups = (0, _utils.normalizeSortingInfo)(storeLoadOptions.group || []);
                        var oldGroups = "_group" in this ? (0, _utils.normalizeSortingInfo)(this._group || []) : groups;
                        var groupsCount = Math.min(oldGroups.length, groups.length);
                        this._group = storeLoadOptions.group;
                        for (var groupIndex = 0; groupIndex < groupsCount; groupIndex++) {
                            if (oldGroups[groupIndex].selector !== groups[groupIndex].selector) {
                                groupsCount = groupIndex;
                                break
                            }
                        }
                        if (!groupsCount) {
                            this.reset()
                        } else {
                            ! function cleanGroupsInfo(groupsInfo, groupIndex, groupsCount) {
                                for (var i = 0; i < groupsInfo.length; i++) {
                                    if (groupIndex + 1 >= groupsCount) {
                                        groupsInfo[i].children = []
                                    } else {
                                        cleanGroupsInfo(groupsInfo[i].children, groupIndex + 1, groupsCount)
                                    }
                                }
                            }(this._groupsInfo, 0, groupsCount)
                        }
                    },
                    handleDataLoading: function() {},
                    handleDataLoaded: function(options, callBase) {
                        callBase(options)
                    },
                    handleDataLoadedCore: function(options, callBase) {
                        callBase(options)
                    }
                }));
                var findGroupInfoByKey, getGroupInfoIndexByOffset;
                exports.GroupingHelper = GroupingHelper
            },
        4789:
            /*!********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/grouping/m_grouping_expanded.js ***!
              \********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupingHelper = void 0;
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _query = _interopRequireDefault(__webpack_require__( /*! ../../../../data/query */ 96687));
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ../../../../data/store_helper */ 99236));
                var _utils = __webpack_require__( /*! ../../../../data/utils */ 16454);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_utils = __webpack_require__( /*! ../m_utils */ 10087);
                var _m_grouping_core = __webpack_require__( /*! ./m_grouping_core */ 8748);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var loadTotalCount = function(dataSource, options) {
                    var d = new _deferred.Deferred;
                    var loadOptions = (0, _extend.extend)({
                        skip: 0,
                        take: 1,
                        requireTotalCount: true
                    }, options);
                    dataSource.load(loadOptions).done((function(data, extra) {
                        d.resolve(extra && extra.totalCount)
                    })).fail(d.reject.bind(d));
                    return d
                };
                var GroupingHelper = _m_grouping_core.GroupingHelper.inherit((foreachCollapsedGroups = function(that, callback, updateOffsets) {
                    return that.foreachGroups((function(groupInfo) {
                        if (!groupInfo.isExpanded) {
                            return callback(groupInfo)
                        }
                    }), false, false, updateOffsets, true)
                }, correctSkipLoadOption = function(that, skip) {
                    var skipCorrection = 0;
                    var resultSkip = skip || 0;
                    if (skip) {
                        foreachCollapsedGroups(that, (function(groupInfo) {
                            if (groupInfo.offset - skipCorrection >= skip) {
                                return false
                            }
                            skipCorrection += groupInfo.count - 1
                        }));
                        resultSkip += skipCorrection
                    }
                    return resultSkip
                }, pathEquals = function(path1, path2) {
                    if (path1.length !== path2.length) {
                        return false
                    }
                    for (var i = 0; i < path1.length; i++) {
                        if (!(0, _utils.keysEqual)(null, path1[i], path2[i])) {
                            return false
                        }
                    }
                    return true
                }, updateGroupOffsets = function updateGroupOffsets(that, items, path, offset, additionalGroupInfo) {
                    if (!items) {
                        return
                    }
                    for (var i = 0; i < items.length; i++) {
                        var item = items[i];
                        if ("key" in item && void 0 !== item.items) {
                            path.push(item.key);
                            if (additionalGroupInfo && pathEquals(additionalGroupInfo.path, path) && !item.isContinuation) {
                                additionalGroupInfo.offset = offset
                            }
                            var groupInfo = that.findGroupInfo(path);
                            if (groupInfo && !item.isContinuation) {
                                groupInfo.offset = offset
                            }
                            if (groupInfo && !groupInfo.isExpanded) {
                                offset += groupInfo.count
                            } else {
                                offset = updateGroupOffsets(that, item.items, path, offset, additionalGroupInfo)
                            }
                            path.pop()
                        } else {
                            offset++
                        }
                    }
                    return offset
                }, getGroupCount = function getGroupCount(item, groupCount) {
                    var count = item.count || item.items.length;
                    if (!item.count && groupCount > 1) {
                        count = 0;
                        for (var i = 0; i < item.items.length; i++) {
                            count += getGroupCount(item.items[i], groupCount - 1)
                        }
                    }
                    return count
                }, {
                    handleDataLoading: function(options) {
                        var storeLoadOptions = options.storeLoadOptions;
                        var collapsedGroups = [];
                        var collapsedItemsCount = 0;
                        var skipFirstItem = false;
                        var take;
                        var group = options.loadOptions.group;
                        var skipCorrection = 0;
                        ! function(storeLoadOptions, loadOptions) {
                            if (loadOptions.group) {
                                var groups = _m_core.default.normalizeSortingInfo(loadOptions.group);
                                var sorts = _m_core.default.normalizeSortingInfo(storeLoadOptions.sort);
                                storeLoadOptions.sort = _store_helper.default.arrangeSortingInfo(groups, sorts);
                                delete loadOptions.group
                            }
                        }(storeLoadOptions, options.loadOptions);
                        options.group = options.group || group;
                        if (options.isCustomLoading) {
                            return
                        }
                        var loadOptions = (0, _extend.extend)({}, storeLoadOptions);
                        loadOptions.skip = correctSkipLoadOption(this, storeLoadOptions.skip);
                        if (loadOptions.skip && loadOptions.take && group) {
                            loadOptions.skip--;
                            loadOptions.take++;
                            skipFirstItem = true
                        }
                        if (loadOptions.take && group) {
                            take = loadOptions.take;
                            loadOptions.take++
                        }
                        foreachCollapsedGroups(this, (function(groupInfo) {
                            if (groupInfo.offset >= loadOptions.skip + loadOptions.take + skipCorrection) {
                                return false
                            }
                            if (groupInfo.offset >= loadOptions.skip + skipCorrection && groupInfo.count) {
                                skipCorrection += groupInfo.count - 1;
                                collapsedGroups.push(groupInfo);
                                collapsedItemsCount += groupInfo.count
                            }
                        }));
                        (0, _iterator.each)(collapsedGroups, (function() {
                            loadOptions.filter = function(path, storeLoadOptions, group) {
                                var groups = _m_core.default.normalizeSortingInfo(group || storeLoadOptions.group);
                                var filter = [];
                                for (var i = 0; i < path.length; i++) {
                                    var filterElement = [];
                                    for (var j = 0; j <= i; j++) {
                                        filterElement.push([groups[j].selector, i === j ? "<>" : "=", path[j]])
                                    }
                                    filter.push(_m_core.default.combineFilters(filterElement))
                                }
                                filter = _m_core.default.combineFilters(filter, "or");
                                return _m_core.default.combineFilters([filter, storeLoadOptions.filter])
                            }(this.path, loadOptions, group)
                        }));
                        options.storeLoadOptions = loadOptions;
                        options.collapsedGroups = collapsedGroups;
                        options.collapsedItemsCount = collapsedItemsCount;
                        options.skip = loadOptions.skip || 0;
                        options.skipFirstItem = skipFirstItem;
                        options.take = take
                    },
                    handleDataLoaded: function(options, callBase) {
                        var collapsedGroups = options.collapsedGroups;
                        var groups = _m_core.default.normalizeSortingInfo(options.group);
                        var groupCount = groups.length;

                        function appendCollapsedPath(data, path, groups, collapsedGroup, offset) {
                            if (!data || !path.length || !groups.length) {
                                return
                            }
                            var keyValue;
                            var i;
                            var pathValue = (0, _data.toComparable)(path[0], true);
                            for (i = 0; i < data.length; i++) {
                                keyValue = (0, _data.toComparable)(data[i].key, true);
                                if (offset >= collapsedGroup.offset || pathValue === keyValue) {
                                    break
                                } else {
                                    offset += getGroupCount(data[i], groups.length)
                                }
                            }
                            if (!data.length || pathValue !== keyValue) {
                                data.splice(i, 0, {
                                    key: path[0],
                                    items: [],
                                    count: 1 === path.length ? collapsedGroup.count : void 0
                                })
                            }
                            appendCollapsedPath(data[i].items, path.slice(1), groups.slice(1), collapsedGroup, offset)
                        }
                        if (options.collapsedItemsCount && options.extra && options.extra.totalCount >= 0) {
                            if (!options.extra._totalCountWasIncreasedByCollapsedItems) {
                                options.extra.totalCount += options.collapsedItemsCount;
                                options.extra._totalCountWasIncreasedByCollapsedItems = true
                            }
                        }
                        callBase(options);
                        if (groupCount) {
                            var data = options.data;
                            var query = (0, _query.default)(data);
                            _store_helper.default.multiLevelGroup(query, groups).enumerate().done((function(groupedData) {
                                data = groupedData
                            }));
                            if (collapsedGroups) {
                                for (var pathIndex = 0; pathIndex < collapsedGroups.length; pathIndex++) {
                                    appendCollapsedPath(data, collapsedGroups[pathIndex].path, groups, collapsedGroups[pathIndex], options.skip)
                                }
                            }
                            if (!options.isCustomLoading) {
                                ! function processGroupItems(that, items, path, offset, skipFirstItem, take) {
                                    var removeLastItemsCount = 0;
                                    var needRemoveFirstItem = false;
                                    for (var i = 0; i < items.length; i++) {
                                        var item = items[i];
                                        if (void 0 !== item.items) {
                                            path.push(item.key);
                                            var groupInfo = that.findGroupInfo(path);
                                            if (groupInfo && !groupInfo.isExpanded) {
                                                item.collapsedItems = item.items;
                                                item.items = null;
                                                offset += groupInfo.count;
                                                take--;
                                                if (take < 0) {
                                                    removeLastItemsCount++
                                                }
                                                if (skipFirstItem) {
                                                    needRemoveFirstItem = true
                                                }
                                            } else if (item.items) {
                                                var offsetInfo = processGroupItems(that, item.items, path, offset, skipFirstItem, take);
                                                if (skipFirstItem) {
                                                    if (offsetInfo.offset - offset > 1) {
                                                        item.isContinuation = true
                                                    } else {
                                                        needRemoveFirstItem = true
                                                    }
                                                }
                                                offset = offsetInfo.offset;
                                                take = offsetInfo.take;
                                                if (take < 0) {
                                                    if (item.items.length) {
                                                        item.isContinuationOnNextPage = true
                                                    } else {
                                                        removeLastItemsCount++
                                                    }
                                                }
                                            }
                                            path.pop()
                                        } else {
                                            if (skipFirstItem) {
                                                needRemoveFirstItem = true
                                            }
                                            offset++;
                                            take--;
                                            if (take < 0) {
                                                removeLastItemsCount++
                                            }
                                        }
                                        skipFirstItem = false
                                    }
                                    if (needRemoveFirstItem) {
                                        items.splice(0, 1)
                                    }
                                    if (removeLastItemsCount) {
                                        items.splice(-removeLastItemsCount, removeLastItemsCount)
                                    }
                                    return {
                                        offset: offset,
                                        take: take
                                    }
                                }(this, data, [], options.skip, options.skipFirstItem, options.take)
                            }
                            options.data = data
                        }
                    },
                    isGroupItemCountable: function(item) {
                        return null === item.items
                    },
                    updateTotalItemsCount: function() {
                        var itemsCountCorrection = 0;
                        foreachCollapsedGroups(this, (function(groupInfo) {
                            if (groupInfo.count) {
                                itemsCountCorrection -= groupInfo.count - 1
                            }
                        }));
                        this.callBase(itemsCountCorrection)
                    },
                    changeRowExpand: function(path) {
                        var that = this;
                        var dataSource = that._dataSource;
                        var beginPageIndex = dataSource.beginPageIndex ? dataSource.beginPageIndex() : dataSource.pageIndex();
                        var dataSourceItems = dataSource.items();
                        var offset = correctSkipLoadOption(that, beginPageIndex * dataSource.pageSize());
                        var groupInfo = that.findGroupInfo(path);
                        var groupCountQuery;
                        if (groupInfo && !groupInfo.isExpanded) {
                            groupCountQuery = (new _deferred.Deferred).resolve(groupInfo.count)
                        } else {
                            groupCountQuery = loadTotalCount(dataSource, {
                                filter: (0, _m_utils.createGroupFilter)(path, {
                                    filter: dataSource.filter(),
                                    group: dataSource.group()
                                })
                            })
                        }
                        return (0, _deferred.when)(groupCountQuery).done((function(count) {
                            count = parseInt(count.length ? count[0] : count);
                            if (groupInfo) {
                                updateGroupOffsets(that, dataSourceItems, [], offset);
                                groupInfo.isExpanded = !groupInfo.isExpanded;
                                groupInfo.count = count
                            } else {
                                groupInfo = {
                                    offset: -1,
                                    count: count,
                                    path: path,
                                    isExpanded: false
                                };
                                updateGroupOffsets(that, dataSourceItems, [], offset, groupInfo);
                                if (groupInfo.offset >= 0) {
                                    that.addGroupInfo(groupInfo)
                                }
                            }
                            that.updateTotalItemsCount()
                        })).fail((function() {
                            dataSource._eventsStrategy.fireEvent("loadError", arguments)
                        }))
                    },
                    allowCollapseAll: function() {
                        return false
                    },
                    refresh: function(options, operationTypes) {
                        var that = this;
                        var storeLoadOptions = options.storeLoadOptions;
                        var dataSource = that._dataSource;
                        this.callBase.apply(this, arguments);
                        if (operationTypes.reload) {
                            return foreachCollapsedGroups(that, (function(groupInfo) {
                                var groupCountQuery = loadTotalCount(dataSource, {
                                    filter: (0, _m_utils.createGroupFilter)(groupInfo.path, storeLoadOptions)
                                });
                                var groupOffsetQuery = loadTotalCount(dataSource, {
                                    filter: (0, _m_grouping_core.createOffsetFilter)(groupInfo.path, storeLoadOptions)
                                });
                                return (0, _deferred.when)(groupOffsetQuery, groupCountQuery).done((function(offset, count) {
                                    offset = parseInt(offset.length ? offset[0] : offset);
                                    count = parseInt(count.length ? count[0] : count);
                                    groupInfo.offset = offset;
                                    if (groupInfo.count !== count) {
                                        groupInfo.count = count;
                                        that.updateTotalItemsCount()
                                    }
                                }))
                            }), true)
                        }
                    }
                }));
                var foreachCollapsedGroups, correctSkipLoadOption, pathEquals, updateGroupOffsets, getGroupCount;
                exports.GroupingHelper = GroupingHelper
            },
        29593:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_aggregate_calculator.js ***!
              \**************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _class = (obj = __webpack_require__( /*! ../../../core/class */ 38377), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 47617);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _errors = __webpack_require__( /*! ../../../data/errors */ 18438);
                var _utils = __webpack_require__( /*! ../../../data/utils */ 16454);

                function depthFirstSearch(i, depth, root, callback) {
                    var j = 0;
                    if (i < depth) {
                        for (; j < root.items.length; j++) {
                            depthFirstSearch(i + 1, depth, root.items[j], callback)
                        }
                    }
                    if (i === depth) {
                        callback(root)
                    }
                }

                function map(array, callback) {
                    var i;
                    if ("map" in array) {
                        return array.map(callback)
                    }
                    var result = new Array(array.length);
                    for (i in array) {
                        result[i] = callback(array[i], i)
                    }
                    return result
                }

                function normalizeAggregate(aggregate) {
                    var selector = (0, _data.compileGetter)(aggregate.selector);
                    var skipEmptyValues = "skipEmptyValues" in aggregate ? aggregate.skipEmptyValues : true;
                    var aggregator = aggregate.aggregator;
                    if ("string" === typeof aggregator) {
                        aggregator = _utils.aggregators[aggregator];
                        if (!aggregator) {
                            throw _errors.errors.Error("E4001", aggregate.aggregator)
                        }
                    }
                    return {
                        selector: selector,
                        aggregator: aggregator,
                        skipEmptyValues: skipEmptyValues
                    }
                }
                var _default = _class.default.inherit({
                    ctor: function(options) {
                        this._data = options.data;
                        this._groupLevel = options.groupLevel || 0;
                        this._totalAggregates = map(options.totalAggregates || [], normalizeAggregate);
                        this._groupAggregates = map(options.groupAggregates || [], normalizeAggregate);
                        this._totals = []
                    },
                    calculate: function() {
                        if (this._totalAggregates.length) {
                            this._calculateTotals(0, {
                                items: this._data
                            })
                        }
                        if (this._groupAggregates.length && this._groupLevel > 0) {
                            this._calculateGroups({
                                items: this._data
                            })
                        }
                    },
                    totalAggregates: function() {
                        return this._totals
                    },
                    _aggregate: function(aggregates, data, container) {
                        var length = data.items ? data.items.length : 0;
                        for (var i = 0; i < aggregates.length; i++) {
                            if (aggregator = aggregates[i].aggregator, aggregator === _utils.aggregators.count) {
                                container[i] = (container[i] || 0) + length;
                                continue
                            }
                            for (var j = 0; j < length; j++) {
                                this._accumulate(i, aggregates[i], container, data.items[j])
                            }
                        }
                        var aggregator
                    },
                    _calculateTotals: function(level, data) {
                        if (0 === level) {
                            this._totals = this._seed(this._totalAggregates)
                        }
                        if (level === this._groupLevel) {
                            this._aggregate(this._totalAggregates, data, this._totals)
                        } else {
                            for (var i = 0; i < data.items.length; i++) {
                                this._calculateTotals(level + 1, data.items[i])
                            }
                        }
                        if (0 === level) {
                            this._totals = this._finalize(this._totalAggregates, this._totals)
                        }
                    },
                    _calculateGroups: function(root) {
                        var maxLevel = this._groupLevel;
                        var currentLevel = maxLevel + 1;
                        var seedFn = this._seed.bind(this, this._groupAggregates);
                        var stepFn = this._aggregate.bind(this, this._groupAggregates);
                        var finalizeFn = this._finalize.bind(this, this._groupAggregates);

                        function aggregator(node) {
                            node.aggregates = seedFn(currentLevel - 1);
                            if (currentLevel === maxLevel) {
                                stepFn(node, node.aggregates)
                            } else {
                                depthFirstSearch(currentLevel, maxLevel, node, (function(innerNode) {
                                    stepFn(innerNode, node.aggregates)
                                }))
                            }
                            node.aggregates = finalizeFn(node.aggregates)
                        }
                        while (--currentLevel > 0) {
                            depthFirstSearch(0, currentLevel, root, aggregator)
                        }
                    },
                    _seed: function(aggregates, groupIndex) {
                        return map(aggregates, (function(aggregate) {
                            var aggregator = aggregate.aggregator;
                            var seed = "seed" in aggregator ? (0, _type.isFunction)(aggregator.seed) ? aggregator.seed(groupIndex) : aggregator.seed : NaN;
                            return seed
                        }))
                    },
                    _accumulate: function(aggregateIndex, aggregate, results, item) {
                        var value = aggregate.selector(item);
                        var aggregator = aggregate.aggregator;
                        var skipEmptyValues = aggregate.skipEmptyValues;
                        if (skipEmptyValues && (x = value, x !== x || "" === x || null === x || void 0 === x)) {
                            return
                        }
                        var x;
                        if (results[aggregateIndex] !== results[aggregateIndex]) {
                            results[aggregateIndex] = value
                        } else {
                            results[aggregateIndex] = aggregator.step(results[aggregateIndex], value)
                        }
                    },
                    _finalize: function(aggregates, results) {
                        return map(aggregates, (function(aggregate, index) {
                            var fin = aggregate.aggregator.finalize;
                            return fin ? fin(results[index]) : results[index]
                        }))
                    }
                });
                exports.default = _default
            },
        96291:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_columns_controller.js ***!
              \************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _m_columns_controller = __webpack_require__( /*! ../../grids/grid_core/columns_controller/m_columns_controller */ 10279);
                var _m_core = (obj = __webpack_require__( /*! ./m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("columns", {
                    defaultOptions: function() {
                        return (0, _extend.extend)(true, {}, _m_columns_controller.columnsControllerModule.defaultOptions(), {
                            commonColumnSettings: {
                                allowExporting: true
                            }
                        })
                    },
                    controllers: _m_columns_controller.columnsControllerModule.controllers
                })
            },
        74938:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_core.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../../grids/grid_core/m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../../grids/grid_core/m_utils */ 60082));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                var _default = _extends(_extends(_extends({}, _m_modules.default), _m_utils.default), {
                    modules: []
                });
                exports.default = _default
            },
        3263:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_data_controller.js ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.DataController = void 0;
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../ui/widget/ui.errors */ 96688));
                var _m_data_controller = __webpack_require__( /*! ../../grids/grid_core/data_controller/m_data_controller */ 72119);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ./m_core */ 74938));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ./m_data_source_adapter */ 49975));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var _a, _b;
                var DataController = null === (_b = null === (_a = _m_data_controller.dataControllerModule.controllers) || void 0 === _a ? void 0 : _a.data) || void 0 === _b ? void 0 : _b.inherit({
                    _getDataSourceAdapter: function() {
                        return _m_data_source_adapter.default
                    },
                    _getSpecificDataSourceOption: function() {
                        var dataSource = this.option("dataSource");
                        if (dataSource && !Array.isArray(dataSource) && this.option("keyExpr")) {
                            _ui.default.log("W1011")
                        }
                        return this.callBase()
                    }
                });
                exports.DataController = DataController;
                _m_core.default.registerModule("data", {
                    defaultOptions: _m_data_controller.dataControllerModule.defaultOptions,
                    controllers: {
                        data: DataController
                    }
                })
            },
        49975:
            /*!*************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_data_source_adapter.js ***!
              \*************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_data_source_adapter = (obj = __webpack_require__( /*! ../../grids/grid_core/data_source_adapter/m_data_source_adapter */ 30945), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var dataSourceAdapterType = _m_data_source_adapter.default;
                var _default = {
                    extend: function(extender) {
                        dataSourceAdapterType = dataSourceAdapterType.inherit(extender)
                    },
                    create: function(component) {
                        return new dataSourceAdapterType(component)
                    }
                };
                exports.default = _default
            },
        26949:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_editing.js ***!
              \*************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                __webpack_require__( /*! ./module_not_extended/editor_factory */ 98125);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _m_editing = __webpack_require__( /*! ../../grids/grid_core/editing/m_editing */ 22324);
                var _m_core = (obj = __webpack_require__( /*! ./m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editing", (0, _extend.extend)(true, {}, _m_editing.editingModule, {
                    extenders: {
                        controllers: {
                            data: {
                                _changeRowExpandCore: function(key) {
                                    var editingController = this._editingController;
                                    if (Array.isArray(key)) {
                                        editingController && editingController.refresh()
                                    }
                                    return this.callBase.apply(this, arguments)
                                }
                            }
                        }
                    }
                }))
            },
        10087:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_utils.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createGroupFilter = function(path, storeLoadOptions) {
                    var groups = (0, _utils.normalizeSortingInfo)(storeLoadOptions.group);
                    var filter = [];
                    for (var i = 0; i < path.length; i++) {
                        filter.push([groups[i].selector, "=", path[i]])
                    }
                    if (storeLoadOptions.filter) {
                        filter.push(storeLoadOptions.filter)
                    }
                    return _m_utils.default.combineFilters(filter)
                };
                var _utils = __webpack_require__( /*! ../../../data/utils */ 16454);
                var _m_utils = (obj = __webpack_require__( /*! ../../grids/grid_core/m_utils */ 60082), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj
            },
        10590:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_widget.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_widget_base = (obj = __webpack_require__( /*! ./m_widget_base */ 26196), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                __webpack_require__( /*! ./module_not_extended/state_storing */ 97847);
                __webpack_require__( /*! ./module_not_extended/selection */ 86006);
                __webpack_require__( /*! ./module_not_extended/column_chooser */ 17663);
                __webpack_require__( /*! ./grouping/m_grouping */ 72487);
                __webpack_require__( /*! ./module_not_extended/master_detail */ 48190);
                __webpack_require__( /*! ./m_editing */ 26949);
                __webpack_require__( /*! ./module_not_extended/editing_row_based */ 42267);
                __webpack_require__( /*! ./module_not_extended/editing_form_based */ 94585);
                __webpack_require__( /*! ./module_not_extended/editing_cell_based */ 82831);
                __webpack_require__( /*! ./module_not_extended/validating */ 41430);
                __webpack_require__( /*! ./module_not_extended/virtual_scrolling */ 98726);
                __webpack_require__( /*! ./module_not_extended/filter_row */ 34622);
                __webpack_require__( /*! ./module_not_extended/header_filter */ 42595);
                __webpack_require__( /*! ./module_not_extended/filter_sync */ 66551);
                __webpack_require__( /*! ./module_not_extended/filter_builder */ 69566);
                __webpack_require__( /*! ./module_not_extended/filter_panel */ 76568);
                __webpack_require__( /*! ./module_not_extended/search */ 20015);
                __webpack_require__( /*! ./module_not_extended/pager */ 70608);
                __webpack_require__( /*! ./module_not_extended/columns_resizing_reordering */ 53489);
                __webpack_require__( /*! ./module_not_extended/keyboard_navigation */ 28294);
                __webpack_require__( /*! ./summary/m_summary */ 15180);
                __webpack_require__( /*! ./module_not_extended/column_fixing */ 68339);
                __webpack_require__( /*! ./module_not_extended/adaptivity */ 26098);
                __webpack_require__( /*! ./module_not_extended/virtual_columns */ 12470);
                __webpack_require__( /*! ./export/m_export */ 48252);
                __webpack_require__( /*! ./focus/m_focus */ 56445);
                __webpack_require__( /*! ./module_not_extended/row_dragging */ 445);
                var _default = _m_widget_base.default;
                exports.default = _default
            },
        26196:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/m_widget_base.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                __webpack_require__( /*! ./module_not_extended/column_headers */ 90130);
                __webpack_require__( /*! ./m_columns_controller */ 96291);
                __webpack_require__( /*! ./m_data_controller */ 3263);
                __webpack_require__( /*! ./module_not_extended/sorting */ 10792);
                __webpack_require__( /*! ./module_not_extended/rows */ 86226);
                __webpack_require__( /*! ./module_not_extended/context_menu */ 74043);
                __webpack_require__( /*! ./module_not_extended/error_handling */ 46950);
                __webpack_require__( /*! ./module_not_extended/grid_view */ 24734);
                __webpack_require__( /*! ./module_not_extended/header_panel */ 63350);
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../../core/component_registrator */ 99393));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 68374));
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/browser */ 47810));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _console = __webpack_require__( /*! ../../../core/utils/console */ 30869);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _themes = __webpack_require__( /*! ../../../ui/themes */ 75811);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../ui/widget/ui.widget */ 14390));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../../grids/grid_core/m_utils */ 60082));
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ./m_core */ 74938));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                _m_core.default.registerModulesOrder(["stateStoring", "columns", "selection", "editorFactory", "columnChooser", "grouping", "editing", "editingRowBased", "editingFormBased", "editingCellBased", "masterDetail", "validating", "adaptivity", "data", "virtualScrolling", "columnHeaders", "filterRow", "headerPanel", "headerFilter", "sorting", "search", "rows", "pager", "columnsResizingReordering", "contextMenu", "keyboardNavigation", "errorHandling", "summary", "columnFixing", "export", "gridView"]);
                var DataGrid = _ui.default.inherit({
                    _activeStateUnit: ".dx-row",
                    _getDefaultOptions: function() {
                        var result = this.callBase();
                        (0, _iterator.each)(_m_core.default.modules, (function() {
                            if ((0, _type.isFunction)(this.defaultOptions)) {
                                (0, _extend.extend)(true, result, this.defaultOptions())
                            }
                        }));
                        return result
                    },
                    _setDeprecatedOptions: function() {
                        this.callBase();
                        (0, _extend.extend)(this._deprecatedOptions, {
                            useKeyboard: {
                                since: "19.2",
                                alias: "keyboardNavigation.enabled"
                            },
                            rowTemplate: {
                                since: "21.2",
                                message: 'Use the "dataRowTemplate" option instead'
                            },
                            "columnChooser.allowSearch": {
                                since: "23.1",
                                message: 'Use the "columnChooser.search.enabled" option instead'
                            },
                            "columnChooser.searchTimeout": {
                                since: "23.1",
                                message: 'Use the "columnChooser.search.timeout" option instead'
                            }
                        })
                    },
                    _defaultOptionsRules: function() {
                        return this.callBase().concat([{
                            device: {
                                platform: "ios"
                            },
                            options: {
                                showRowLines: true
                            }
                        }, {
                            device: function() {
                                return (0, _themes.isMaterial)()
                            },
                            options: {
                                showRowLines: true,
                                showColumnLines: false,
                                headerFilter: {
                                    height: 315
                                },
                                editing: {
                                    useIcons: true
                                },
                                selection: {
                                    showCheckBoxesMode: "always"
                                }
                            }
                        }, {
                            device: function() {
                                return _browser.default.webkit
                            },
                            options: {
                                loadingTimeout: 30,
                                loadPanel: {
                                    animation: {
                                        show: {
                                            easing: "cubic-bezier(1, 0, 1, 0)",
                                            duration: 500,
                                            from: {
                                                opacity: 0
                                            },
                                            to: {
                                                opacity: 1
                                            }
                                        }
                                    }
                                }
                            }
                        }, {
                            device: function(_device) {
                                return "desktop" !== _device.deviceType
                            },
                            options: {
                                grouping: {
                                    expandMode: "rowClick"
                                }
                            }
                        }])
                    },
                    _init: function() {
                        this.callBase();
                        _m_utils.default.logHeaderFilterDeprecatedWarningIfNeed(this);
                        _m_core.default.processModules(this, _m_core.default);
                        _m_core.default.callModuleItemsMethod(this, "init")
                    },
                    _clean: _common.noop,
                    _optionChanged: function(args) {
                        _m_core.default.callModuleItemsMethod(this, "optionChanged", [args]);
                        if (!args.handled) {
                            this.callBase(args)
                        }
                    },
                    _dimensionChanged: function() {
                        this.updateDimensions(true)
                    },
                    _visibilityChanged: function(visible) {
                        if (visible) {
                            this.updateDimensions()
                        }
                    },
                    _initMarkup: function() {
                        this.callBase.apply(this, arguments);
                        this.getView("gridView").render(this.$element())
                    },
                    _renderContentImpl: function() {
                        this.getView("gridView").update()
                    },
                    _renderContent: function() {
                        var that = this;
                        (0, _common.deferRender)((function() {
                            that._renderContentImpl()
                        }))
                    },
                    _getTemplate: function(templateName) {
                        var template = templateName;
                        if ((0, _type.isString)(template) && template.startsWith("#")) {
                            template = (0, _renderer.default)(templateName);
                            _console.logger.warn("Specifying grid templates with the jQuery selector name is now deprecated. Use the DOM Node or the jQuery object that references this selector instead.")
                        }
                        return this.callBase(template)
                    },
                    _dispose: function() {
                        this.callBase();
                        _m_core.default.callModuleItemsMethod(this, "dispose")
                    },
                    isReady: function() {
                        return this.getController("data").isReady()
                    },
                    beginUpdate: function() {
                        this.callBase();
                        _m_core.default.callModuleItemsMethod(this, "beginUpdate")
                    },
                    endUpdate: function() {
                        _m_core.default.callModuleItemsMethod(this, "endUpdate");
                        this.callBase()
                    },
                    getController: function(name) {
                        return this._controllers[name]
                    },
                    getView: function(name) {
                        return this._views[name]
                    },
                    focus: function(element) {
                        this.getController("keyboardNavigation").focus(element)
                    }
                });
                DataGrid.registerModule = _m_core.default.registerModule.bind(_m_core.default);
                (0, _component_registrator.default)("dxDataGrid", DataGrid);
                var _default = DataGrid;
                exports.default = _default
            },
        26098:
            /*!**********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/adaptivity.js ***!
              \**********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_adaptivity = __webpack_require__( /*! ../../../grids/grid_core/adaptivity/m_adaptivity */ 18107);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("adaptivity", _m_adaptivity.adaptivityModule)
            },
        17663:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/column_chooser.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ColumnChooserView = exports.ColumnChooserController = void 0;
                var _m_column_chooser = __webpack_require__( /*! ../../../grids/grid_core/column_chooser/m_column_chooser */ 71184);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var ColumnChooserController = _m_column_chooser.columnChooserModule.controllers.columnChooser;
                exports.ColumnChooserController = ColumnChooserController;
                var ColumnChooserView = _m_column_chooser.columnChooserModule.views.columnChooserView;
                exports.ColumnChooserView = ColumnChooserView;
                _m_core.default.registerModule("columnChooser", _m_column_chooser.columnChooserModule)
            },
        68339:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/column_fixing.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_column_fixing = __webpack_require__( /*! ../../../grids/grid_core/column_fixing/m_column_fixing */ 53424);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("columnFixing", _m_column_fixing.columnFixingModule)
            },
        90130:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/column_headers.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ColumnHeadersView = void 0;
                var _m_column_headers = __webpack_require__( /*! ../../../grids/grid_core/column_headers/m_column_headers */ 14509);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var ColumnHeadersView = _m_column_headers.columnHeadersModule.views.columnHeadersView;
                exports.ColumnHeadersView = ColumnHeadersView;
                _m_core.default.registerModule("columnHeaders", _m_column_headers.columnHeadersModule)
            },
        53489:
            /*!***************************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/columns_resizing_reordering.js ***!
              \***************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.TrackerView = exports.TablePositionViewController = exports.DraggingHeaderViewController = exports.DraggingHeaderView = exports.ColumnsSeparatorView = exports.ColumnsResizerViewController = void 0;
                var _m_columns_resizing_reordering = __webpack_require__( /*! ../../../grids/grid_core/columns_resizing_reordering/m_columns_resizing_reordering */ 49505);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var DraggingHeaderView = _m_columns_resizing_reordering.columnsResizingReorderingModule.views.draggingHeaderView;
                exports.DraggingHeaderView = DraggingHeaderView;
                var DraggingHeaderViewController = _m_columns_resizing_reordering.columnsResizingReorderingModule.controllers.draggingHeader;
                exports.DraggingHeaderViewController = DraggingHeaderViewController;
                var ColumnsSeparatorView = _m_columns_resizing_reordering.columnsResizingReorderingModule.views.columnsSeparatorView;
                exports.ColumnsSeparatorView = ColumnsSeparatorView;
                var TablePositionViewController = _m_columns_resizing_reordering.columnsResizingReorderingModule.controllers.tablePosition;
                exports.TablePositionViewController = TablePositionViewController;
                var ColumnsResizerViewController = _m_columns_resizing_reordering.columnsResizingReorderingModule.controllers.columnsResizer;
                exports.ColumnsResizerViewController = ColumnsResizerViewController;
                var TrackerView = _m_columns_resizing_reordering.columnsResizingReorderingModule.views.trackerView;
                exports.TrackerView = TrackerView;
                _m_core.default.registerModule("columnsResizingReordering", _m_columns_resizing_reordering.columnsResizingReorderingModule)
            },
        74043:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/context_menu.js ***!
              \************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_context_menu = __webpack_require__( /*! ../../../grids/grid_core/context_menu/m_context_menu */ 69823);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("contextMenu", _m_context_menu.contextMenuModule)
            },
        82831:
            /*!******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/editing_cell_based.js ***!
              \******************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_editing_cell_based = __webpack_require__( /*! ../../../grids/grid_core/editing/m_editing_cell_based */ 68802);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editingCellBased", _m_editing_cell_based.editingCellBasedModule)
            },
        94585:
            /*!******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/editing_form_based.js ***!
              \******************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_editing_form_based = __webpack_require__( /*! ../../../grids/grid_core/editing/m_editing_form_based */ 99211);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editingFormBased", _m_editing_form_based.editingFormBasedModule)
            },
        42267:
            /*!*****************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/editing_row_based.js ***!
              \*****************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_editing_row_based = __webpack_require__( /*! ../../../grids/grid_core/editing/m_editing_row_based */ 55597);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editingRowBased", _m_editing_row_based.editingRowBasedModule)
            },
        98125:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/editor_factory.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_editor_factory = __webpack_require__( /*! ../../../grids/grid_core/editor_factory/m_editor_factory */ 80070);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("editorFactory", _m_editor_factory.editorFactoryModule)
            },
        46950:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/error_handling.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_error_handling = __webpack_require__( /*! ../../../grids/grid_core/error_handling/m_error_handling */ 31152);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("errorHandling", _m_error_handling.errorHandlingModule)
            },
        69566:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/filter_builder.js ***!
              \**************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_filter_builder = __webpack_require__( /*! ../../../grids/grid_core/filter/m_filter_builder */ 62690);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("filterBuilder", _m_filter_builder.filterBuilderModule)
            },
        76568:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/filter_panel.js ***!
              \************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_filter_panel = __webpack_require__( /*! ../../../grids/grid_core/filter/m_filter_panel */ 4062);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("filterPanel", _m_filter_panel.filterPanelModule)
            },
        34622:
            /*!**********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/filter_row.js ***!
              \**********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_filter_row = __webpack_require__( /*! ../../../grids/grid_core/filter/m_filter_row */ 12302);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("filterRow", _m_filter_row.filterRowModule)
            },
        66551:
            /*!***********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/filter_sync.js ***!
              \***********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_filter_sync = __webpack_require__( /*! ../../../grids/grid_core/filter/m_filter_sync */ 14407);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("filterSync", _m_filter_sync.filterSyncModule)
            },
        24734:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/grid_view.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_grid_view = __webpack_require__( /*! ../../../grids/grid_core/views/m_grid_view */ 28016);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("gridView", _m_grid_view.gridViewModule)
            },
        42595:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/header_filter.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_header_filter = __webpack_require__( /*! ../../../grids/grid_core/header_filter/m_header_filter */ 68796);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("headerFilter", _m_header_filter.headerFilterModule)
            },
        63350:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/header_panel.js ***!
              \************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.HeaderPanel = void 0;
                var _m_header_panel = __webpack_require__( /*! ../../../grids/grid_core/header_panel/m_header_panel */ 92468);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var HeaderPanel = _m_header_panel.headerPanelModule.views.headerPanel;
                exports.HeaderPanel = HeaderPanel;
                _m_core.default.registerModule("headerPanel", _m_header_panel.headerPanelModule)
            },
        28294:
            /*!*******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/keyboard_navigation.js ***!
              \*******************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_keyboard_navigation = __webpack_require__( /*! ../../../grids/grid_core/keyboard_navigation/m_keyboard_navigation */ 31822);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("keyboardNavigation", _m_keyboard_navigation.keyboardNavigationModule)
            },
        48190:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/master_detail.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_master_detail = __webpack_require__( /*! ../../../grids/grid_core/master_detail/m_master_detail */ 82802);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("masterDetail", _m_master_detail.masterDetailModule)
            },
        70608:
            /*!*****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/pager.js ***!
              \*****************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_pager = __webpack_require__( /*! ../../../grids/grid_core/pager/m_pager */ 3990);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("pager", _m_pager.pagerModule)
            },
        445:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/row_dragging.js ***!
              \************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_row_dragging = __webpack_require__( /*! ../../../grids/grid_core/row_dragging/m_row_dragging */ 88351);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("rowDragging", _m_row_dragging.rowDraggingModule)
            },
        86226:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/rows.js ***!
              \****************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.RowsView = void 0;
                var _m_rows_view = __webpack_require__( /*! ../../../grids/grid_core/views/m_rows_view */ 35095);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var RowsView = _m_rows_view.rowsModule.views.rowsView;
                exports.RowsView = RowsView;
                _m_core.default.registerModule("rows", _m_rows_view.rowsModule)
            },
        20015:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/search.js ***!
              \******************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_search = __webpack_require__( /*! ../../../grids/grid_core/search/m_search */ 92021);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("search", _m_search.searchModule)
            },
        86006:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/selection.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_selection = __webpack_require__( /*! ../../../grids/grid_core/selection/m_selection */ 17969);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("selection", _m_selection.selectionModule)
            },
        10792:
            /*!*******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/sorting.js ***!
              \*******************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_sorting = __webpack_require__( /*! ../../../grids/grid_core/sorting/m_sorting */ 11590);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("sorting", _m_sorting.sortingModule)
            },
        97847:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/state_storing.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_state_storing = __webpack_require__( /*! ../../../grids/grid_core/state_storing/m_state_storing */ 12440);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("stateStoring", _m_state_storing.stateStoringModule)
            },
        41430:
            /*!**********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/validating.js ***!
              \**********************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_validating = __webpack_require__( /*! ../../../grids/grid_core/validating/m_validating */ 39830);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("validating", _m_validating.validatingModule)
            },
        12470:
            /*!***************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/virtual_columns.js ***!
              \***************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_virtual_columns = __webpack_require__( /*! ../../../grids/grid_core/virtual_columns/m_virtual_columns */ 87482);
                var _m_core = (obj = __webpack_require__( /*! ../m_core */ 74938), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                _m_core.default.registerModule("virtualColumns", _m_virtual_columns.virtualColumnsModule)
            },
        98726:
            /*!*****************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/virtual_scrolling.js ***!
              \*****************************************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _m_virtual_scrolling = __webpack_require__( /*! ../../../grids/grid_core/virtual_scrolling/m_virtual_scrolling */ 92018);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ../m_data_source_adapter */ 49975));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                _m_core.default.registerModule("virtualScrolling", _m_virtual_scrolling.virtualScrollingModule);
                _m_data_source_adapter.default.extend(_m_virtual_scrolling.virtualScrollingModule.extenders.dataSourceAdapter)
            },
        15180:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/summary/m_summary.js ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.renderSummaryCell = exports.FooterView = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _query = _interopRequireDefault(__webpack_require__( /*! ../../../../data/query */ 96687));
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ../../../../data/store_helper */ 99236));
                var _utils = __webpack_require__( /*! ../../../../data/utils */ 16454);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_columns_view = __webpack_require__( /*! ../../../grids/grid_core/views/m_columns_view */ 57318);
                var _m_aggregate_calculator = _interopRequireDefault(__webpack_require__( /*! ../m_aggregate_calculator */ 29593));
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 74938));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ../m_data_source_adapter */ 49975));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var renderSummaryCell = function(cell, options) {
                    var $cell = (0, _renderer.default)(cell);
                    var column = options.column;
                    var summaryItems = options.summaryItems;
                    var $summaryItems = [];
                    if (!column.command && summaryItems) {
                        for (var i = 0; i < summaryItems.length; i++) {
                            var summaryItem = summaryItems[i];
                            $summaryItems.push((0, _renderer.default)("<div>").css("textAlign", summaryItem.alignment || column.alignment).addClass("dx-datagrid-summary-item").addClass("dx-datagrid-text-content").addClass(summaryItem.cssClass).toggleClass("dx-datagrid-group-text-content", "group" === options.rowType).text(_m_core.default.getSummaryText(summaryItem, options.summaryTexts)))
                        }
                        $cell.append($summaryItems)
                    }
                };
                exports.renderSummaryCell = renderSummaryCell;
                var getSummaryCellOptions = function(that, options) {
                    var summaryTexts = that.option("summary.texts") || {};
                    return {
                        totalItem: options.row,
                        summaryItems: options.row.summaryCells[options.columnIndex],
                        summaryTexts: summaryTexts
                    }
                };
                var getGroupAggregates = function(data) {
                    return data.summary || data.aggregates || []
                };
                var recalculateWhileEditing = function(that) {
                    return that.option("summary.recalculateWhileEditing")
                };
                var FooterView = _m_columns_view.ColumnsView.inherit({
                    _getRows: function() {
                        return this._dataController.footerItems()
                    },
                    _getCellOptions: function(options) {
                        return (0, _extend.extend)(this.callBase(options), getSummaryCellOptions(this, options))
                    },
                    _renderCellContent: function($cell, options) {
                        renderSummaryCell($cell, options);
                        this.callBase.apply(this, arguments)
                    },
                    _renderCore: function(change) {
                        var needUpdateScrollLeft = false;
                        var totalItem = this._dataController.footerItems()[0];
                        if (!change || !change.columnIndices) {
                            this.element().empty().addClass("dx-datagrid-total-footer").toggleClass("dx-datagrid-nowrap", !this.option("wordWrapEnabled"));
                            needUpdateScrollLeft = true
                        }
                        if (totalItem && totalItem.summaryCells && totalItem.summaryCells.length) {
                            this._updateContent(this._renderTable({
                                change: change
                            }), change);
                            needUpdateScrollLeft && this._updateScrollLeftPosition()
                        }
                    },
                    _updateContent: function($newTable, change) {
                        var _this = this;
                        if (change && "update" === change.changeType && change.columnIndices) {
                            return this.waitAsyncTemplates().done((function() {
                                var $row = _this.getTableElement().find(".dx-row");
                                var $newRow = $newTable.find(".dx-row");
                                _this._updateCells($row, $newRow, change.columnIndices[0])
                            }))
                        }
                        return this.callBase.apply(this, arguments)
                    },
                    _rowClick: function(e) {
                        var item = this._dataController.footerItems()[e.rowIndex] || {};
                        this.executeAction("onRowClick", (0, _extend.extend)({}, e, item))
                    },
                    _columnOptionChanged: function(e) {
                        var optionNames = e.optionNames;
                        if (e.changeTypes.grouping) {
                            return
                        }
                        if (optionNames.width || optionNames.visibleWidth) {
                            this.callBase(e)
                        }
                    },
                    _handleDataChanged: function(e) {
                        var changeType = e.changeType;
                        if ("update" === e.changeType && e.repaintChangesOnly) {
                            if (!e.totalColumnIndices) {
                                this.render()
                            } else if (e.totalColumnIndices.length) {
                                this.render(null, {
                                    changeType: "update",
                                    columnIndices: [e.totalColumnIndices]
                                })
                            }
                        } else if ("refresh" === changeType || "append" === changeType || "prepend" === changeType) {
                            this.render()
                        }
                    },
                    _createRow: function(row) {
                        var $row = this.callBase.apply(this, arguments);
                        if ("totalFooter" === row.rowType) {
                            $row.addClass("dx-footer-row")
                        }
                        return $row
                    },
                    getHeight: function() {
                        return this.getElementHeight()
                    },
                    isVisible: function() {
                        return !!this._dataController.footerItems().length
                    }
                });
                exports.FooterView = FooterView;
                var SummaryDataSourceAdapterExtender = {
                    init: function() {
                        this.callBase.apply(this, arguments);
                        this._totalAggregates = [];
                        this._summaryGetter = _common.noop
                    },
                    summaryGetter: function(_summaryGetter) {
                        if (!arguments.length) {
                            return this._summaryGetter
                        }
                        if ((0, _type.isFunction)(_summaryGetter)) {
                            this._summaryGetter = _summaryGetter
                        }
                    },
                    summary: function(_summary) {
                        if (!arguments.length) {
                            return this._summaryGetter()
                        }
                        this._summaryGetter = function() {
                            return _summary
                        }
                    },
                    totalAggregates: function() {
                        return this._totalAggregates
                    },
                    isLastLevelGroupItemsPagingLocal: function() {
                        var summary = this.summary();
                        var sortByGroupsInfo = summary && summary.sortByGroups();
                        return sortByGroupsInfo && sortByGroupsInfo.length
                    },
                    sortLastLevelGroupItems: function(items, groups, paths) {
                        var groupedItems = _store_helper.default.multiLevelGroup((0, _query.default)(items), groups).toArray();
                        var result = [];
                        paths.forEach((function(path) {
                            ! function forEachGroup(groups, groupCount, callback, path) {
                                path = path || [];
                                for (var i = 0; i < groups.length; i++) {
                                    path.push(groups[i].key);
                                    if (1 === groupCount) {
                                        callback(path, groups[i].items)
                                    } else {
                                        forEachGroup(groups[i].items, groupCount - 1, callback, path)
                                    }
                                    path.pop()
                                }
                            }(groupedItems, groups.length, (function(itemsPath, items) {
                                if (path.toString() === itemsPath.toString()) {
                                    result = result.concat(items)
                                }
                            }))
                        }));
                        return result
                    }
                };
                var SummaryDataSourceAdapterClientExtender = (calculateAggregates = function(that, summary, data, groupLevel) {
                    var calculator;
                    if (recalculateWhileEditing(that)) {
                        var editingController = that.getController("editing");
                        if (editingController) {
                            var insertedData = editingController.getInsertedData();
                            if (insertedData.length) {
                                data = function applyAddedData(data, insertedData, groupLevel) {
                                    if (groupLevel) {
                                        return applyAddedData(data, insertedData.map((function(item) {
                                            return {
                                                items: [item]
                                            }
                                        }), groupLevel - 1))
                                    }
                                    return data.concat(insertedData)
                                }(data, insertedData, groupLevel)
                            }
                            var removedData = editingController.getRemovedData();
                            if (removedData.length) {
                                data = function applyRemovedData(data, removedData, groupLevel) {
                                    if (groupLevel) {
                                        return data.map((function(data) {
                                            var updatedData = {};
                                            var updatedItems = applyRemovedData(data.items || [], removedData, groupLevel - 1);
                                            Object.defineProperty(updatedData, "aggregates", {
                                                get: function() {
                                                    return data.aggregates
                                                },
                                                set: function(value) {
                                                    data.aggregates = value
                                                }
                                            });
                                            return (0, _extend.extend)(updatedData, data, {
                                                items: updatedItems
                                            })
                                        }))
                                    }
                                    return data.filter((function(data) {
                                        return removedData.indexOf(data) < 0
                                    }))
                                }(data, removedData, groupLevel)
                            }
                        }
                    }
                    if (summary) {
                        calculator = new _m_aggregate_calculator.default({
                            totalAggregates: summary.totalAggregates,
                            groupAggregates: summary.groupAggregates,
                            data: data,
                            groupLevel: groupLevel
                        });
                        calculator.calculate()
                    }
                    return calculator ? calculator.totalAggregates() : []
                }, sortGroupsBySummary = function(data, group, summary) {
                    var sortByGroups = summary && summary.sortByGroups && summary.sortByGroups();
                    if (sortByGroups && sortByGroups.length) {
                        return function sortGroupsBySummaryCore(items, groups, sortByGroups) {
                            if (!items || !groups.length) {
                                return items
                            }
                            var group = groups[0];
                            var sorts = sortByGroups[0];
                            var query;
                            if (group && sorts && sorts.length) {
                                query = (0, _query.default)(items);
                                (0, _iterator.each)(sorts, (function(index) {
                                    if (0 === index) {
                                        query = query.sortBy(this.selector, this.desc)
                                    } else {
                                        query = query.thenBy(this.selector, this.desc)
                                    }
                                }));
                                query.enumerate().done((function(sortedItems) {
                                    items = sortedItems
                                }))
                            }
                            groups = groups.slice(1);
                            sortByGroups = sortByGroups.slice(1);
                            if (groups.length && sortByGroups.length) {
                                (0, _iterator.each)(items, (function() {
                                    this.items = sortGroupsBySummaryCore(this.items, groups, sortByGroups)
                                }))
                            }
                            return items
                        }(data, group, sortByGroups)
                    }
                    return data
                }, {
                    _customizeRemoteOperations: function(options) {
                        var summary = this.summary();
                        if (summary) {
                            if (options.remoteOperations.summary) {
                                if (!options.isCustomLoading || options.storeLoadOptions.isLoadingAll) {
                                    if (options.storeLoadOptions.group) {
                                        if (options.remoteOperations.grouping) {
                                            options.storeLoadOptions.groupSummary = summary.groupAggregates
                                        } else if (summary.groupAggregates.length) {
                                            options.remoteOperations.paging = false
                                        }
                                    }
                                    options.storeLoadOptions.totalSummary = summary.totalAggregates
                                }
                            } else if (summary.totalAggregates.length || summary.groupAggregates.length && options.storeLoadOptions.group) {
                                options.remoteOperations.paging = false
                            }
                        }
                        this.callBase.apply(this, arguments);
                        var cachedExtra = options.cachedData.extra;
                        if (cachedExtra && cachedExtra.summary && !options.isCustomLoading) {
                            options.storeLoadOptions.totalSummary = void 0
                        }
                    },
                    _handleDataLoadedCore: function(options) {
                        var _a, _b;
                        var groups = (0, _utils.normalizeSortingInfo)(options.storeLoadOptions.group || options.loadOptions.group || []);
                        var remoteOperations = options.remoteOperations || {};
                        var summary = this.summaryGetter()(remoteOperations);
                        if (!options.isCustomLoading || options.storeLoadOptions.isLoadingAll) {
                            if (remoteOperations.summary) {
                                if (!remoteOperations.paging && groups.length && summary) {
                                    if (!remoteOperations.grouping) {
                                        calculateAggregates(this, {
                                            groupAggregates: summary.groupAggregates
                                        }, options.data, groups.length)
                                    }
                                    options.data = sortGroupsBySummary(options.data, groups, summary)
                                }
                            } else if (!remoteOperations.paging && summary) {
                                var operationTypes = options.operationTypes || {};
                                var hasOperations = Object.keys(operationTypes).some((function(type) {
                                    return operationTypes[type]
                                }));
                                if (!hasOperations || !(null === (_b = null === (_a = options.cachedData) || void 0 === _a ? void 0 : _a.extra) || void 0 === _b ? void 0 : _b.summary) || groups.length && summary.groupAggregates.length) {
                                    var totalAggregates = calculateAggregates(this, summary, options.data, groups.length);
                                    options.extra = (0, _type.isPlainObject)(options.extra) ? options.extra : {};
                                    options.extra.summary = totalAggregates;
                                    if (options.cachedData) {
                                        options.cachedData.extra = options.extra
                                    }
                                }
                                options.data = sortGroupsBySummary(options.data, groups, summary)
                            }
                        }
                        if (!options.isCustomLoading) {
                            this._totalAggregates = options.extra && options.extra.summary || this._totalAggregates
                        }
                        this.callBase(options)
                    }
                });
                var calculateAggregates, sortGroupsBySummary;
                _m_data_source_adapter.default.extend(SummaryDataSourceAdapterExtender);
                _m_data_source_adapter.default.extend(SummaryDataSourceAdapterClientExtender);
                _m_core.default.registerModule("summary", {
                    defaultOptions: function() {
                        return {
                            summary: {
                                groupItems: void 0,
                                totalItems: void 0,
                                calculateCustomSummary: void 0,
                                skipEmptyValues: true,
                                recalculateWhileEditing: false,
                                texts: {
                                    sum: _message.default.format("dxDataGrid-summarySum"),
                                    sumOtherColumn: _message.default.format("dxDataGrid-summarySumOtherColumn"),
                                    min: _message.default.format("dxDataGrid-summaryMin"),
                                    minOtherColumn: _message.default.format("dxDataGrid-summaryMinOtherColumn"),
                                    max: _message.default.format("dxDataGrid-summaryMax"),
                                    maxOtherColumn: _message.default.format("dxDataGrid-summaryMaxOtherColumn"),
                                    avg: _message.default.format("dxDataGrid-summaryAvg"),
                                    avgOtherColumn: _message.default.format("dxDataGrid-summaryAvgOtherColumn"),
                                    count: _message.default.format("dxDataGrid-summaryCount")
                                }
                            },
                            sortByGroupSummaryInfo: void 0
                        }
                    },
                    views: {
                        footerView: FooterView
                    },
                    extenders: {
                        controllers: {
                            data: {
                                _isDataColumn: function(column) {
                                    return column && (!(0, _type.isDefined)(column.groupIndex) || column.showWhenGrouped)
                                },
                                _isGroupFooterVisible: function() {
                                    var groupItems = this.option("summary.groupItems") || [];
                                    for (var i = 0; i < groupItems.length; i++) {
                                        var groupItem = groupItems[i];
                                        var column = this._columnsController.columnOption(groupItem.showInColumn || groupItem.column);
                                        if (groupItem.showInGroupFooter && this._isDataColumn(column)) {
                                            return true
                                        }
                                    }
                                    return false
                                },
                                _processGroupItems: function(items, groupCount, options) {
                                    var data = options && options.data;
                                    var result = this.callBase.apply(this, arguments);
                                    if (options) {
                                        if (void 0 === options.isGroupFooterVisible) {
                                            options.isGroupFooterVisible = this._isGroupFooterVisible()
                                        }
                                        if (data && data.items && options.isGroupFooterVisible && (options.collectContinuationItems || !data.isContinuationOnNextPage)) {
                                            result.push({
                                                rowType: "groupFooter",
                                                key: options.path.slice(),
                                                data: data,
                                                groupIndex: options.path.length - 1,
                                                values: []
                                            })
                                        }
                                    }
                                    return result
                                },
                                _processGroupItem: function(groupItem, options) {
                                    var that = this;
                                    if (!options.summaryGroupItems) {
                                        options.summaryGroupItems = that.option("summary.groupItems") || []
                                    }
                                    if ("group" === groupItem.rowType) {
                                        var groupColumnIndex = -1;
                                        var afterGroupColumnIndex = -1;
                                        (0, _iterator.each)(options.visibleColumns, (function(visibleIndex) {
                                            var prevColumn = options.visibleColumns[visibleIndex - 1];
                                            if (groupItem.groupIndex === this.groupIndex) {
                                                groupColumnIndex = this.index
                                            }
                                            if (visibleIndex > 0 && "expand" === prevColumn.command && "expand" !== this.command) {
                                                afterGroupColumnIndex = this.index
                                            }
                                        }));
                                        groupItem.summaryCells = this._calculateSummaryCells(options.summaryGroupItems, getGroupAggregates(groupItem.data), options.visibleColumns, (function(summaryItem, column) {
                                            if (summaryItem.showInGroupFooter) {
                                                return -1
                                            }
                                            if (summaryItem.alignByColumn && column && !(0, _type.isDefined)(column.groupIndex) && column.index !== afterGroupColumnIndex) {
                                                return column.index
                                            }
                                            return groupColumnIndex
                                        }), true)
                                    }
                                    if ("groupFooter" === groupItem.rowType) {
                                        groupItem.summaryCells = this._calculateSummaryCells(options.summaryGroupItems, getGroupAggregates(groupItem.data), options.visibleColumns, (function(summaryItem, column) {
                                            return summaryItem.showInGroupFooter && that._isDataColumn(column) ? column.index : -1
                                        }))
                                    }
                                    return groupItem
                                },
                                _calculateSummaryCells: function(summaryItems, aggregates, visibleColumns, calculateTargetColumnIndex, isGroupRow) {
                                    var that = this;
                                    var summaryCells = [];
                                    var summaryCellsByColumns = {};
                                    (0, _iterator.each)(summaryItems, (function(summaryIndex, summaryItem) {
                                        var column = that._columnsController.columnOption(summaryItem.column);
                                        var showInColumn = summaryItem.showInColumn && that._columnsController.columnOption(summaryItem.showInColumn) || column;
                                        var columnIndex = calculateTargetColumnIndex(summaryItem, showInColumn);
                                        if (columnIndex >= 0) {
                                            if (!summaryCellsByColumns[columnIndex]) {
                                                summaryCellsByColumns[columnIndex] = []
                                            }
                                            var aggregate = aggregates[summaryIndex];
                                            if (aggregate === aggregate) {
                                                var valueFormat;
                                                if ((0, _type.isDefined)(summaryItem.valueFormat)) {
                                                    valueFormat = summaryItem.valueFormat
                                                } else if ("count" !== summaryItem.summaryType) {
                                                    valueFormat = _m_core.default.getFormatByDataType(column && column.dataType)
                                                }
                                                summaryCellsByColumns[columnIndex].push((0, _extend.extend)({}, summaryItem, {
                                                    value: (0, _type.isString)(aggregate) && column && column.deserializeValue ? column.deserializeValue(aggregate) : aggregate,
                                                    valueFormat: valueFormat,
                                                    columnCaption: column && column.index !== columnIndex ? column.caption : void 0
                                                }))
                                            }
                                        }
                                    }));
                                    if (!(0, _type.isEmptyObject)(summaryCellsByColumns)) {
                                        visibleColumns.forEach((function(column, visibleIndex) {
                                            var prevColumn = visibleColumns[visibleIndex - 1];
                                            var columnIndex = isGroupRow && ("expand" === (null === prevColumn || void 0 === prevColumn ? void 0 : prevColumn.command) || "expand" === column.command) ? null === prevColumn || void 0 === prevColumn ? void 0 : prevColumn.index : column.index;
                                            summaryCells.push(summaryCellsByColumns[columnIndex] || [])
                                        }))
                                    }
                                    return summaryCells
                                },
                                _getSummaryCells: function(summaryTotalItems, totalAggregates) {
                                    var that = this;
                                    var columnsController = that._columnsController;
                                    return that._calculateSummaryCells(summaryTotalItems, totalAggregates, columnsController.getVisibleColumns(), (function(summaryItem, column) {
                                        return that._isDataColumn(column) ? column.index : -1
                                    }))
                                },
                                _updateItemsCore: function(change) {
                                    var summaryCells;
                                    var dataSource = this._dataSource;
                                    var footerItems = this._footerItems;
                                    var oldSummaryCells = footerItems && footerItems[0] && footerItems[0].summaryCells;
                                    var summaryTotalItems = this.option("summary.totalItems");
                                    this._footerItems = [];
                                    if (dataSource && summaryTotalItems && summaryTotalItems.length) {
                                        var totalAggregates = dataSource.totalAggregates();
                                        summaryCells = this._getSummaryCells(summaryTotalItems, totalAggregates);
                                        if (change && change.repaintChangesOnly && oldSummaryCells) {
                                            change.totalColumnIndices = summaryCells.map((function(summaryCell, index) {
                                                if (JSON.stringify(summaryCell) !== JSON.stringify(oldSummaryCells[index])) {
                                                    return index
                                                }
                                                return -1
                                            })).filter((function(index) {
                                                return index >= 0
                                            }))
                                        }
                                        if (summaryCells.length) {
                                            this._footerItems.push({
                                                rowType: "totalFooter",
                                                summaryCells: summaryCells
                                            })
                                        }
                                    }
                                    this.callBase(change)
                                },
                                _prepareUnsavedDataSelector: function(selector) {
                                    if (recalculateWhileEditing(this)) {
                                        var editingController = this.getController("editing");
                                        if (editingController) {
                                            return function(data) {
                                                data = editingController.getUpdatedData(data);
                                                return selector(data)
                                            }
                                        }
                                    }
                                    return selector
                                },
                                _prepareAggregateSelector: function(selector, aggregator) {
                                    selector = this._prepareUnsavedDataSelector(selector);
                                    if ("avg" === aggregator || "sum" === aggregator) {
                                        return function(data) {
                                            var value = selector(data);
                                            return (0, _type.isDefined)(value) ? Number(value) : value
                                        }
                                    }
                                    return selector
                                },
                                _getAggregates: function(summaryItems, remoteOperations) {
                                    var that = this;
                                    var columnsController = that.getController("columns");
                                    var calculateCustomSummary = that.option("summary.calculateCustomSummary");
                                    var commonSkipEmptyValues = that.option("summary.skipEmptyValues");
                                    return (0, _iterator.map)(summaryItems || [], (function(summaryItem) {
                                        var column = columnsController.columnOption(summaryItem.column);
                                        var calculateCellValue = column && column.calculateCellValue ? column.calculateCellValue.bind(column) : (0, _data.compileGetter)(column ? column.dataField : summaryItem.column);
                                        var aggregator = summaryItem.summaryType || "count";
                                        var skipEmptyValues = (0, _type.isDefined)(summaryItem.skipEmptyValues) ? summaryItem.skipEmptyValues : commonSkipEmptyValues;
                                        if (remoteOperations) {
                                            return {
                                                selector: summaryItem.column,
                                                summaryType: aggregator
                                            }
                                        }
                                        var selector = that._prepareAggregateSelector(calculateCellValue, aggregator);
                                        if ("custom" === aggregator) {
                                            if (!calculateCustomSummary) {
                                                _ui.default.log("E1026");
                                                calculateCustomSummary = function() {}
                                            }
                                            var options = {
                                                component: that.component,
                                                name: summaryItem.name
                                            };
                                            calculateCustomSummary(options);
                                            options.summaryProcess = "calculate";
                                            aggregator = {
                                                seed: function(groupIndex) {
                                                    options.summaryProcess = "start";
                                                    options.totalValue = void 0;
                                                    options.groupIndex = groupIndex;
                                                    delete options.value;
                                                    calculateCustomSummary(options);
                                                    return options.totalValue
                                                },
                                                step: function(totalValue, value) {
                                                    options.summaryProcess = "calculate";
                                                    options.totalValue = totalValue;
                                                    options.value = value;
                                                    calculateCustomSummary(options);
                                                    return options.totalValue
                                                },
                                                finalize: function(totalValue) {
                                                    options.summaryProcess = "finalize";
                                                    options.totalValue = totalValue;
                                                    delete options.value;
                                                    calculateCustomSummary(options);
                                                    return options.totalValue
                                                }
                                            }
                                        }
                                        return {
                                            selector: selector,
                                            aggregator: aggregator,
                                            skipEmptyValues: skipEmptyValues
                                        }
                                    }))
                                },
                                _addSortInfo: function(sortByGroups, groupColumn, selector, sortOrder) {
                                    if (groupColumn) {
                                        var groupIndex = groupColumn.groupIndex;
                                        sortOrder = sortOrder || groupColumn.sortOrder;
                                        if ((0, _type.isDefined)(groupIndex)) {
                                            sortByGroups[groupIndex] = sortByGroups[groupIndex] || [];
                                            sortByGroups[groupIndex].push({
                                                selector: selector,
                                                desc: "desc" === sortOrder
                                            })
                                        }
                                    }
                                },
                                _findSummaryItem: function(summaryItems, name) {
                                    var summaryItemIndex = -1;
                                    if ((0, _type.isDefined)(name)) {
                                        (0, _iterator.each)(summaryItems || [], (function(index) {
                                            if (this.name === name || index === name || this.summaryType === name || this.column === name || (summaryItem = this, summaryType = summaryItem.summaryType, column = summaryItem.column, summaryType && column && "".concat(summaryType, "_").concat(column)) === name) {
                                                summaryItemIndex = index;
                                                return false
                                            }
                                            var summaryItem, summaryType, column
                                        }))
                                    }
                                    return summaryItemIndex
                                },
                                _getSummarySortByGroups: function(sortByGroupSummaryInfo, groupSummaryItems) {
                                    var that = this;
                                    var columnsController = that._columnsController;
                                    var groupColumns = columnsController.getGroupColumns();
                                    var sortByGroups = [];
                                    if (!groupSummaryItems || !groupSummaryItems.length) {
                                        return
                                    }(0, _iterator.each)(sortByGroupSummaryInfo || [], (function() {
                                        var sortOrder = this.sortOrder;
                                        var groupColumn = this.groupColumn;
                                        var summaryItemIndex = that._findSummaryItem(groupSummaryItems, this.summaryItem);
                                        if (summaryItemIndex < 0) {
                                            return
                                        }
                                        var selector = function(data) {
                                            return getGroupAggregates(data)[summaryItemIndex]
                                        };
                                        if ((0, _type.isDefined)(groupColumn)) {
                                            groupColumn = columnsController.columnOption(groupColumn);
                                            that._addSortInfo(sortByGroups, groupColumn, selector, sortOrder)
                                        } else {
                                            (0, _iterator.each)(groupColumns, (function(groupIndex, groupColumn) {
                                                that._addSortInfo(sortByGroups, groupColumn, selector, sortOrder)
                                            }))
                                        }
                                    }));
                                    return sortByGroups
                                },
                                _createDataSourceAdapterCore: function(dataSource, remoteOperations) {
                                    var that = this;
                                    var dataSourceAdapter = this.callBase(dataSource, remoteOperations);
                                    dataSourceAdapter.summaryGetter((function(currentRemoteOperations) {
                                        return that._getSummaryOptions(currentRemoteOperations || remoteOperations)
                                    }));
                                    return dataSourceAdapter
                                },
                                _getSummaryOptions: function(remoteOperations) {
                                    var that = this;
                                    var groupSummaryItems = that.option("summary.groupItems");
                                    var totalSummaryItems = that.option("summary.totalItems");
                                    var sortByGroupSummaryInfo = that.option("sortByGroupSummaryInfo");
                                    var groupAggregates = that._getAggregates(groupSummaryItems, remoteOperations && remoteOperations.grouping && remoteOperations.summary);
                                    var totalAggregates = that._getAggregates(totalSummaryItems, remoteOperations && remoteOperations.summary);
                                    if (groupAggregates.length || totalAggregates.length) {
                                        return {
                                            groupAggregates: groupAggregates,
                                            totalAggregates: totalAggregates,
                                            sortByGroups: function() {
                                                return that._getSummarySortByGroups(sortByGroupSummaryInfo, groupSummaryItems)
                                            }
                                        }
                                    }
                                    return
                                },
                                publicMethods: function() {
                                    var methods = this.callBase();
                                    methods.push("getTotalSummaryValue");
                                    return methods
                                },
                                getTotalSummaryValue: function(summaryItemName) {
                                    var summaryItemIndex = this._findSummaryItem(this.option("summary.totalItems"), summaryItemName);
                                    var aggregates = this._dataSource.totalAggregates();
                                    if (aggregates.length && summaryItemIndex > -1) {
                                        return aggregates[summaryItemIndex]
                                    }
                                },
                                optionChanged: function(args) {
                                    if ("summary" === args.name || "sortByGroupSummaryInfo" === args.name) {
                                        args.name = "dataSource"
                                    }
                                    this.callBase(args)
                                },
                                init: function() {
                                    this._footerItems = [];
                                    this.callBase()
                                },
                                footerItems: function() {
                                    return this._footerItems
                                }
                            },
                            editing: {
                                _refreshSummary: function() {
                                    if (recalculateWhileEditing(this) && !this.isSaving()) {
                                        this._dataController.refresh({
                                            load: true,
                                            changesOnly: true
                                        })
                                    }
                                },
                                _addChange: function(params) {
                                    var result = this.callBase.apply(this, arguments);
                                    if (params.type) {
                                        this._refreshSummary()
                                    }
                                    return result
                                },
                                _removeChange: function() {
                                    var result = this.callBase.apply(this, arguments);
                                    this._refreshSummary();
                                    return result
                                },
                                cancelEditData: function() {
                                    var result = this.callBase.apply(this, arguments);
                                    this._refreshSummary();
                                    return result
                                }
                            }
                        },
                        views: {
                            rowsView: {
                                _createRow: function(row) {
                                    var $row = this.callBase.apply(this, arguments);
                                    row && $row.addClass("groupFooter" === row.rowType ? "dx-datagrid-group-footer" : "");
                                    return $row
                                },
                                _renderCells: function($row, options) {
                                    this.callBase.apply(this, arguments);
                                    if ("group" === options.row.rowType && options.row.summaryCells && options.row.summaryCells.length) {
                                        this._renderGroupSummaryCells($row, options)
                                    }
                                },
                                _hasAlignByColumnSummaryItems: function(columnIndex, options) {
                                    return !(0, _type.isDefined)(options.columns[columnIndex].groupIndex) && options.row.summaryCells[columnIndex].length
                                },
                                _getAlignByColumnCellCount: function(groupCellColSpan, options) {
                                    var alignByColumnCellCount = 0;
                                    for (var i = 1; i < groupCellColSpan; i++) {
                                        var columnIndex = options.row.summaryCells.length - i;
                                        alignByColumnCellCount = this._hasAlignByColumnSummaryItems(columnIndex, options) ? i : alignByColumnCellCount
                                    }
                                    return alignByColumnCellCount
                                },
                                _renderGroupSummaryCells: function($row, options) {
                                    var $groupCell = $row.children().last();
                                    var groupCellColSpan = Number($groupCell.attr("colSpan")) || 1;
                                    var alignByColumnCellCount = this._getAlignByColumnCellCount(groupCellColSpan, options);
                                    this._renderGroupSummaryCellsCore($groupCell, options, groupCellColSpan, alignByColumnCellCount)
                                },
                                _renderGroupSummaryCellsCore: function($groupCell, options, groupCellColSpan, alignByColumnCellCount) {
                                    if (alignByColumnCellCount > 0) {
                                        $groupCell.attr("colSpan", groupCellColSpan - alignByColumnCellCount);
                                        for (var i = 0; i < alignByColumnCellCount; i++) {
                                            var columnIndex = options.columns.length - alignByColumnCellCount + i;
                                            this._renderCell($groupCell.parent(), (0, _extend.extend)({
                                                column: options.columns[columnIndex],
                                                columnIndex: this._getSummaryCellIndex(columnIndex, options.columns)
                                            }, options))
                                        }
                                    }
                                },
                                _getSummaryCellIndex: function(columnIndex) {
                                    return columnIndex
                                },
                                _getCellTemplate: function(options) {
                                    if (!options.column.command && !(0, _type.isDefined)(options.column.groupIndex) && options.summaryItems && options.summaryItems.length) {
                                        return renderSummaryCell
                                    }
                                    return this.callBase(options)
                                },
                                _getCellOptions: function(options) {
                                    var parameters = this.callBase(options);
                                    if (options.row.summaryCells) {
                                        return (0, _extend.extend)(parameters, getSummaryCellOptions(this, options))
                                    }
                                    return parameters
                                }
                            }
                        }
                    }
                })
            },
        18107:
            /*!***************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/adaptivity/m_adaptivity.js ***!
              \***************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.adaptivityModule = void 0;
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../../../core/guid */ 73176));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _dom = __webpack_require__( /*! ../../../../core/utils/dom */ 3532);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _click = __webpack_require__( /*! ../../../../events/click */ 95429);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 55994));
                var _index = __webpack_require__( /*! ../../../../events/utils/index */ 39611);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _form = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/form */ 17737));
                var _themes = __webpack_require__( /*! ../../../../ui/themes */ 75811);
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var COLUMN_VIEWS = ["columnHeadersView", "rowsView", "footerView"];

                function getColumnId(that, column) {
                    return that._columnsController.getColumnId(column)
                }

                function adaptiveCellTemplate(container, options) {
                    var $adaptiveColumnButton;
                    var $container = (0, _renderer.default)(container);
                    var adaptiveColumnsController = options.component.getController("adaptiveColumns");
                    if ("data" === options.rowType) {
                        $adaptiveColumnButton = (0, _renderer.default)("<span>").addClass(adaptiveColumnsController.addWidgetPrefix("adaptive-more"));
                        _events_engine.default.on($adaptiveColumnButton, (0, _index.addNamespace)(_click.name, "dxDataGridAdaptivity"), adaptiveColumnsController.createAction((function() {
                            adaptiveColumnsController.toggleExpandAdaptiveDetailRow(options.key)
                        })));
                        $adaptiveColumnButton.appendTo($container)
                    } else {
                        _m_utils.default.setEmptyText($container)
                    }
                }

                function focusCellHandler(e) {
                    var _a;
                    var $nextCell = null === (_a = e.data) || void 0 === _a ? void 0 : _a.$nextCell;
                    _events_engine.default.off($nextCell, "focus", focusCellHandler);
                    _events_engine.default.trigger($nextCell, "dxclick")
                }
                var adaptiveColumnsControllerMembers = {
                    _isRowEditMode: function() {
                        var editMode = this._getEditMode();
                        return "row" === editMode
                    },
                    _isItemModified: function(item, cellOptions) {
                        var columnIndex = this._columnsController.getVisibleIndex(item.column.index);
                        var rowIndex = this._dataController.getRowIndexByKey(cellOptions.key);
                        var row = this._dataController.items()[rowIndex + 1];
                        return row && row.modifiedValues && (0, _type.isDefined)(row.modifiedValues[columnIndex])
                    },
                    _renderFormViewTemplate: function(item, cellOptions, $container) {
                        var that = this;
                        var column = item.column;
                        var focusAction = that.createAction((function() {
                            if (that._editingController.isEditing()) {
                                _events_engine.default.trigger($container, _click.name)
                            }
                        }));
                        var rowData = cellOptions.row.data;
                        var value = column.calculateCellValue(rowData);
                        var displayValue = _m_utils.default.getDisplayValue(column, value, rowData, cellOptions.rowType);
                        var text = _m_utils.default.formatValue(displayValue, column);
                        var isCellOrBatchEditMode = this._editingController.isCellOrBatchEditMode();
                        var rowsView = that._rowsView;
                        if (column.allowEditing && that.getController("keyboardNavigation").isKeyboardEnabled()) {
                            $container.attr("tabIndex", that.option("tabIndex"));
                            if (isCellOrBatchEditMode) {
                                _events_engine.default.off($container, "focus", focusAction);
                                _events_engine.default.on($container, "focus", focusAction)
                            }
                        }
                        if (column.cellTemplate) {
                            var templateOptions = (0, _extend.extend)({}, cellOptions, {
                                value: value,
                                displayValue: displayValue,
                                text: text,
                                column: column
                            });
                            rowsView.renderTemplate($container, column.cellTemplate, templateOptions, (0, _dom.isElementInDom)($container)).done((function() {
                                rowsView._cellPrepared($container, cellOptions)
                            }))
                        } else {
                            var container = $container.get(0);
                            if (column.encodeHtml) {
                                container.textContent = text
                            } else {
                                container.innerHTML = text
                            }
                            $container.addClass("dx-adaptive-item-text");
                            if (!(0, _type.isDefined)(text) || "" === text) {
                                $container.html("&nbsp;")
                            }
                            if (!that._isRowEditMode()) {
                                if (that._isItemModified(item, cellOptions)) {
                                    $container.addClass("dx-item-modified")
                                }
                            }
                            rowsView._cellPrepared($container, cellOptions)
                        }
                    },
                    _getTemplate: function(item, cellOptions) {
                        var that = this;
                        var column = item.column;
                        var editingController = this.getController("editing");
                        return function(options, container) {
                            var $container = (0, _renderer.default)(container);
                            var columnIndex = that._columnsController.getVisibleIndex(column.index);
                            var templateOptions = (0, _extend.extend)({}, cellOptions);
                            var renderFormTemplate = function() {
                                var isItemEdited = that._isItemEdited(item);
                                templateOptions.value = cellOptions.row.values[columnIndex];
                                if (isItemEdited || column.showEditorAlways) {
                                    editingController.renderFormEditorTemplate(templateOptions, item, options, $container, !isItemEdited)
                                } else {
                                    templateOptions.column = column;
                                    templateOptions.columnIndex = columnIndex;
                                    that._renderFormViewTemplate(item, templateOptions, $container)
                                }
                            };
                            renderFormTemplate();
                            templateOptions.watch && templateOptions.watch((function() {
                                return {
                                    isItemEdited: that._isItemEdited(item),
                                    value: cellOptions.row.values[columnIndex]
                                }
                            }), (function() {
                                $container.contents().remove();
                                $container.removeClass("dx-adaptive-item-text");
                                renderFormTemplate()
                            }))
                        }
                    },
                    _isVisibleColumnsValid: function(visibleColumns) {
                        if (visibleColumns < 2) {
                            return false
                        }
                        if (visibleColumns.length - function() {
                                var result = 0;
                                for (var j = 0; j < visibleColumns.length; j++) {
                                    var visibleColumn = visibleColumns[j];
                                    if (visibleColumn.command) {
                                        result++
                                    }
                                }
                                return result
                            }() <= 1) {
                            return false
                        }
                        return true
                    },
                    _calculatePercentWidths: function(widths, visibleColumns) {
                        var that = this;
                        var percentWidths = 0;
                        visibleColumns.forEach((function(item, index) {
                            if ("adaptiveHidden" !== widths[index]) {
                                percentWidths += that._getItemPercentWidth(item)
                            }
                        }));
                        return percentWidths
                    },
                    _isPercentWidth: function(width) {
                        return (0, _type.isString)(width) && width.endsWith("%")
                    },
                    _isColumnHidden: function(column) {
                        return this._hiddenColumns.filter((function(hiddenColumn) {
                            return hiddenColumn.index === column.index
                        })).length > 0
                    },
                    _getAverageColumnsWidth: function(containerWidth, columns, columnsCanFit) {
                        var that = this;
                        var fixedColumnsWidth = 0;
                        var columnsWithoutFixedWidthCount = 0;
                        columns.forEach((function(column) {
                            if (!that._isColumnHidden(column)) {
                                var width = column.width;
                                if ((0, _type.isDefined)(width) && !isNaN(parseFloat(width))) {
                                    fixedColumnsWidth += that._isPercentWidth(width) ? that._calculatePercentWidth({
                                        visibleIndex: column.visibleIndex,
                                        columnsCount: columns.length,
                                        columnsCanFit: columnsCanFit,
                                        bestFitWidth: column.bestFitWidth,
                                        columnWidth: width,
                                        containerWidth: containerWidth
                                    }) : parseFloat(width)
                                } else {
                                    columnsWithoutFixedWidthCount++
                                }
                            }
                        }));
                        return (containerWidth - fixedColumnsWidth) / columnsWithoutFixedWidthCount
                    },
                    _calculateColumnWidth: function(column, containerWidth, contentColumns, columnsCanFit) {
                        var columnId = getColumnId(this, column);
                        var widthOption = this._columnsController.columnOption(columnId, "width");
                        var bestFitWidth = this._columnsController.columnOption(columnId, "bestFitWidth");
                        var columnsCount = contentColumns.length;
                        var colWidth;
                        if (widthOption && "auto" !== widthOption) {
                            if (this._isPercentWidth(widthOption)) {
                                colWidth = this._calculatePercentWidth({
                                    visibleIndex: column.visibleIndex,
                                    columnsCount: columnsCount,
                                    columnsCanFit: columnsCanFit,
                                    bestFitWidth: bestFitWidth,
                                    columnWidth: widthOption,
                                    containerWidth: containerWidth
                                })
                            } else {
                                return parseFloat(widthOption)
                            }
                        } else {
                            var columnAutoWidth = this.option("columnAutoWidth");
                            colWidth = columnAutoWidth || !!column.command ? bestFitWidth : this._getAverageColumnsWidth(containerWidth, contentColumns, columnsCanFit)
                        }
                        return colWidth
                    },
                    _calculatePercentWidth: function(options) {
                        var columnFitted = options.visibleIndex < options.columnsCount - 1 && options.columnsCanFit;
                        var partialWidth = options.containerWidth * parseFloat(options.columnWidth) / 100;
                        var resultWidth = options.columnsCanFit && partialWidth < options.bestFitWidth ? options.bestFitWidth : partialWidth;
                        return columnFitted ? options.containerWidth * parseFloat(options.columnWidth) / 100 : resultWidth
                    },
                    _getNotTruncatedColumnWidth: function(column, containerWidth, contentColumns, columnsCanFit) {
                        var columnId = getColumnId(this, column);
                        var widthOption = this._columnsController.columnOption(columnId, "width");
                        var bestFitWidth = this._columnsController.columnOption(columnId, "bestFitWidth");
                        if (widthOption && "auto" !== widthOption && !this._isPercentWidth(widthOption)) {
                            return parseFloat(widthOption)
                        }
                        var colWidth = this._calculateColumnWidth(column, containerWidth, contentColumns, columnsCanFit);
                        return colWidth < bestFitWidth ? null : colWidth
                    },
                    _getItemPercentWidth: function(item) {
                        var result = 0;
                        if (item.width && this._isPercentWidth(item.width)) {
                            result = parseFloat(item.width)
                        }
                        return result
                    },
                    _getCommandColumnsWidth: function() {
                        var that = this;
                        var columns = that._columnsController.getVisibleColumns();
                        var colWidth = 0;
                        (0, _iterator.each)(columns, (function(index, column) {
                            if (column.index < 0 || column.command) {
                                colWidth += that._columnsController.columnOption(getColumnId(that, column), "bestFitWidth") || 0
                            }
                        }));
                        return colWidth
                    },
                    _isItemEdited: function(item) {
                        if (this.isFormOrPopupEditMode()) {
                            return false
                        }
                        if (this._isRowEditMode()) {
                            var editRowKey = this.option("editing.editRowKey");
                            if ((0, _common.equalByValue)(editRowKey, this._dataController.adaptiveExpandedKey())) {
                                return true
                            }
                        } else {
                            var rowIndex = this._dataController.getRowIndexByKey(this._dataController.adaptiveExpandedKey()) + 1;
                            var columnIndex = this._columnsController.getVisibleIndex(item.column.index);
                            return this._editingController.isEditCell(rowIndex, columnIndex)
                        }
                    },
                    _getFormItemsByHiddenColumns: function(hiddenColumns) {
                        var items = [];
                        (0, _iterator.each)(hiddenColumns, (function(_, column) {
                            items.push({
                                column: column,
                                name: column.name,
                                dataField: column.dataField,
                                visibleIndex: column.visibleIndex
                            })
                        }));
                        return items
                    },
                    _getAdaptiveColumnVisibleIndex: function(visibleColumns) {
                        for (var i = 0; i < visibleColumns.length; i++) {
                            var column = visibleColumns[i];
                            if ("adaptive" === column.command) {
                                return i
                            }
                        }
                        return
                    },
                    _hideAdaptiveColumn: function(resultWidths, visibleColumns) {
                        var visibleIndex = this._getAdaptiveColumnVisibleIndex(visibleColumns);
                        if ((0, _type.isDefined)(visibleIndex)) {
                            resultWidths[visibleIndex] = "adaptiveHidden";
                            this._hideVisibleColumn({
                                isCommandColumn: true,
                                visibleIndex: visibleIndex
                            })
                        }
                    },
                    _showHiddenCellsInView: function(_ref) {
                        var $cells = _ref.$cells,
                            isCommandColumn = _ref.isCommandColumn;
                        var cssClassNameToRemove = this.addWidgetPrefix("hidden-column");
                        if (isCommandColumn) {
                            cssClassNameToRemove = "dx-command-adaptive-hidden";
                            $cells.attr({
                                tabIndex: 0,
                                "aria-hidden": null
                            }).removeClass(cssClassNameToRemove)
                        } else {
                            $cells.removeClass(cssClassNameToRemove)
                        }
                    },
                    _showHiddenColumns: function() {
                        for (var i = 0; i < COLUMN_VIEWS.length; i++) {
                            var view = this.getView(COLUMN_VIEWS[i]);
                            if (view && view.isVisible() && view.element()) {
                                var viewName = view.name;
                                var $hiddenCommandCells = view.element().find(".".concat("dx-command-adaptive-hidden"));
                                this._showHiddenCellsInView({
                                    viewName: viewName,
                                    $cells: $hiddenCommandCells,
                                    isCommandColumn: true
                                });
                                var $hiddenCells = view.element().find(".".concat(this.addWidgetPrefix("hidden-column")));
                                this._showHiddenCellsInView({
                                    viewName: viewName,
                                    $cells: $hiddenCells
                                })
                            }
                        }
                    },
                    _isCellValid: function($cell) {
                        return $cell && $cell.length && !$cell.hasClass("dx-master-detail-cell") && !$cell.hasClass("dx-group-cell")
                    },
                    _hideVisibleColumn: function(_ref2) {
                        var isCommandColumn = _ref2.isCommandColumn,
                            visibleIndex = _ref2.visibleIndex;
                        var that = this;
                        COLUMN_VIEWS.forEach((function(viewName) {
                            var view = that.getView(viewName);
                            view && that._hideVisibleColumnInView({
                                view: view,
                                isCommandColumn: isCommandColumn,
                                visibleIndex: visibleIndex
                            })
                        }))
                    },
                    _hideVisibleColumnInView: function(_ref3) {
                        var view = _ref3.view,
                            isCommandColumn = _ref3.isCommandColumn,
                            visibleIndex = _ref3.visibleIndex;
                        var viewName = view.name;
                        var $cellElement;
                        var column = this._columnsController.getVisibleColumns()[visibleIndex];
                        var editFormRowIndex = this._editingController && this._editingController.getEditFormRowIndex();
                        if (view && view.isVisible() && column) {
                            var rowsCount = view.getRowsCount();
                            var $rowElements = view._getRowElements();
                            for (var rowIndex = 0; rowIndex < rowsCount; rowIndex++) {
                                var cancelClassAdding = rowIndex === editFormRowIndex && "rowsView" === viewName && "popup" !== this.option("editing.mode");
                                if (!cancelClassAdding) {
                                    var currentVisibleIndex = "columnHeadersView" === viewName ? this._columnsController.getVisibleIndex(column.index, rowIndex) : visibleIndex;
                                    if (currentVisibleIndex >= 0) {
                                        var $rowElement = $rowElements.eq(rowIndex);
                                        $cellElement = this._findCellElementInRow($rowElement, currentVisibleIndex);
                                        this._isCellValid($cellElement) && this._hideVisibleCellInView({
                                            viewName: viewName,
                                            isCommandColumn: isCommandColumn,
                                            $cell: $cellElement
                                        })
                                    }
                                }
                            }
                        }
                    },
                    _findCellElementInRow: function($rowElement, visibleColumnIndex) {
                        var $rowCells = $rowElement.children();
                        var visibleIndex = visibleColumnIndex;
                        var cellIsInsideGroup = false;
                        if ($rowElement.hasClass("dx-group-row")) {
                            var $groupCell = $rowElement.find(".".concat("dx-group-cell"));
                            var colSpan = $groupCell.attr("colspan");
                            if ($groupCell.length && (0, _type.isDefined)(colSpan)) {
                                var groupCellLength = parseInt(colSpan);
                                var endGroupIndex = $groupCell.index() + groupCellLength - 1;
                                if (visibleColumnIndex > endGroupIndex) {
                                    visibleIndex = visibleColumnIndex - groupCellLength + 1
                                } else {
                                    cellIsInsideGroup = true
                                }
                            }
                        }
                        var $cellElement = !cellIsInsideGroup ? $rowCells.eq(visibleIndex) : void 0;
                        return $cellElement
                    },
                    _hideVisibleCellInView: function(_ref4) {
                        var $cell = _ref4.$cell,
                            isCommandColumn = _ref4.isCommandColumn;
                        var cssClassNameToAdd = isCommandColumn ? "dx-command-adaptive-hidden" : this.addWidgetPrefix("hidden-column");
                        $cell.attr({
                            tabIndex: -1,
                            "aria-hidden": true
                        }).addClass(cssClassNameToAdd)
                    },
                    _getEditMode: function() {
                        return this._editingController.getEditMode()
                    },
                    isFormOrPopupEditMode: function() {
                        var editMode = this._getEditMode();
                        return "form" === editMode || "popup" === editMode
                    },
                    hideRedundantColumns: function(resultWidths, visibleColumns, hiddenQueue) {
                        this._hiddenColumns = [];
                        if (this._isVisibleColumnsValid(visibleColumns) && hiddenQueue.length) {
                            var totalWidth = 0;
                            var $rootElement = this.component.$element();
                            var rootElementWidth = (0, _size.getWidth)($rootElement) - this._getCommandColumnsWidth();
                            var getVisibleContentColumns = function() {
                                var _this = this;
                                return visibleColumns.filter((function(item) {
                                    return !item.command && 0 === _this._hiddenColumns.filter((function(i) {
                                        return i.index === item.index
                                    })).length
                                }))
                            }.bind(this);
                            var visibleContentColumns = getVisibleContentColumns();
                            var contentColumnsCount = visibleContentColumns.length;
                            var i;
                            var hasHiddenColumns;
                            var needHideColumn;
                            do {
                                needHideColumn = false;
                                totalWidth = 0;
                                var percentWidths = this._calculatePercentWidths(resultWidths, visibleColumns);
                                var columnsCanFit = percentWidths < 100 && 0 !== percentWidths;
                                for (i = 0; i < visibleColumns.length; i++) {
                                    var visibleColumn = visibleColumns[i];
                                    var columnWidth = this._getNotTruncatedColumnWidth(visibleColumn, rootElementWidth, visibleContentColumns, columnsCanFit);
                                    var columnId = getColumnId(this, visibleColumn);
                                    var widthOption = this._columnsController.columnOption(columnId, "width");
                                    var minWidth = this._columnsController.columnOption(columnId, "minWidth");
                                    var columnBestFitWidth = this._columnsController.columnOption(columnId, "bestFitWidth");
                                    if ("adaptiveHidden" === resultWidths[i]) {
                                        hasHiddenColumns = true;
                                        continue
                                    }
                                    if (!columnWidth && !visibleColumn.command && !visibleColumn.fixed) {
                                        needHideColumn = true;
                                        break
                                    }
                                    if (!widthOption || "auto" === widthOption) {
                                        columnWidth = Math.max(columnBestFitWidth || 0, minWidth || 0)
                                    }
                                    if ("adaptive" !== visibleColumn.command || hasHiddenColumns) {
                                        totalWidth += columnWidth
                                    }
                                }
                                needHideColumn = needHideColumn || totalWidth > (0, _size.getWidth)($rootElement);
                                if (needHideColumn) {
                                    var column = hiddenQueue.pop();
                                    var visibleIndex = this._columnsController.getVisibleIndex(column.index);
                                    rootElementWidth += this._calculateColumnWidth(column, rootElementWidth, visibleContentColumns, columnsCanFit);
                                    this._hideVisibleColumn({
                                        visibleIndex: visibleIndex
                                    });
                                    resultWidths[visibleIndex] = "adaptiveHidden";
                                    this._hiddenColumns.push(column);
                                    visibleContentColumns = getVisibleContentColumns()
                                }
                            } while (needHideColumn && visibleContentColumns.length > 1 && hiddenQueue.length);
                            if (contentColumnsCount === visibleContentColumns.length) {
                                this._hideAdaptiveColumn(resultWidths, visibleColumns)
                            }
                        } else {
                            this._hideAdaptiveColumn(resultWidths, visibleColumns)
                        }
                    },
                    getAdaptiveDetailItems: function() {
                        return this._$itemContents
                    },
                    getItemContentByColumnIndex: function(visibleColumnIndex) {
                        var $itemContent;
                        for (var i = 0; i < this._$itemContents.length; i++) {
                            $itemContent = this._$itemContents.eq(i);
                            var item = $itemContent.data("dx-form-item");
                            if (item && item.column && this._columnsController.getVisibleIndex(item.column.index) === visibleColumnIndex) {
                                return $itemContent
                            }
                        }
                    },
                    toggleExpandAdaptiveDetailRow: function(key, alwaysExpanded) {
                        if (!(this.isFormOrPopupEditMode() && this._editingController.isEditing())) {
                            this.getController("data").toggleExpandAdaptiveDetailRow(key, alwaysExpanded)
                        }
                    },
                    createFormByHiddenColumns: function(container, options) {
                        var that = this;
                        var $container = (0, _renderer.default)(container);
                        var userFormOptions = {
                            items: that._getFormItemsByHiddenColumns(that._hiddenColumns),
                            formID: "dx-".concat(new _guid.default)
                        };
                        var defaultFormOptions = (0, _themes.isMaterial)() ? {
                            colCount: 2
                        } : {};
                        this.executeAction("onAdaptiveDetailRowPreparing", {
                            formOptions: userFormOptions
                        });
                        that._$itemContents = null;
                        that._form = that._createComponent((0, _renderer.default)("<div>").appendTo($container), _form.default, (0, _extend.extend)(defaultFormOptions, userFormOptions, {
                            customizeItem: function(item) {
                                var column = item.column || that._columnsController.columnOption(item.name || item.dataField);
                                if (column) {
                                    item.label = item.label || {};
                                    item.label.text = item.label.text || column.caption;
                                    item.column = column;
                                    item.template = that._getTemplate(item, options, that.updateForm.bind(that))
                                }
                                userFormOptions.customizeItem && userFormOptions.customizeItem.call(this, item)
                            },
                            onContentReady: function(e) {
                                userFormOptions.onContentReady && userFormOptions.onContentReady.call(this, e);
                                that._$itemContents = $container.find(".".concat("dx-field-item-content"))
                            }
                        }))
                    },
                    hasAdaptiveDetailRowExpanded: function() {
                        return (0, _type.isDefined)(this._dataController.adaptiveExpandedKey())
                    },
                    updateForm: function(hiddenColumns) {
                        if (this.hasAdaptiveDetailRowExpanded()) {
                            if (this._form && (0, _type.isDefined)(this._form._contentReadyAction)) {
                                if (hiddenColumns && hiddenColumns.length) {
                                    this._form.option("items", this._getFormItemsByHiddenColumns(hiddenColumns))
                                } else {
                                    this._form.repaint()
                                }
                            }
                        }
                    },
                    updateHidingQueue: function(columns) {
                        var hideableColumns = columns.filter((function(column) {
                            return column.visible && !column.type && !column.fixed && !((0, _type.isDefined)(column.groupIndex) && column.groupIndex >= 0)
                        }));
                        var columnsHasHidingPriority;
                        var i;
                        this._hidingColumnsQueue = [];
                        if (this.option("allowColumnResizing") && "widget" === this.option("columnResizingMode")) {
                            return this._hidingColumnsQueue
                        }
                        for (i = 0; i < hideableColumns.length; i++) {
                            if ((0, _type.isDefined)(hideableColumns[i].hidingPriority) && hideableColumns[i].hidingPriority >= 0) {
                                columnsHasHidingPriority = true;
                                this._hidingColumnsQueue[hideableColumns[i].hidingPriority] = hideableColumns[i]
                            }
                        }
                        if (columnsHasHidingPriority) {
                            this._hidingColumnsQueue.reverse()
                        } else if (this.option("columnHidingEnabled")) {
                            for (i = 0; i < hideableColumns.length; i++) {
                                var visibleIndex = this._columnsController.getVisibleIndex(hideableColumns[i].index);
                                this._hidingColumnsQueue[visibleIndex] = hideableColumns[i]
                            }
                        }
                        this._hidingColumnsQueue = this._hidingColumnsQueue.filter(Object);
                        return this._hidingColumnsQueue
                    },
                    getHiddenColumns: function() {
                        return this._hiddenColumns
                    },
                    hasHiddenColumns: function() {
                        return this._hiddenColumns.length > 0
                    },
                    getHidingColumnsQueue: function() {
                        return this._hidingColumnsQueue
                    },
                    init: function() {
                        var that = this;
                        that._columnsController = that.getController("columns");
                        that._dataController = that.getController("data");
                        that._rowsView = that.getView("rowsView");
                        that._columnsController.addCommandColumn({
                            type: "adaptive",
                            command: "adaptive",
                            visible: true,
                            adaptiveHidden: true,
                            cssClass: "dx-command-adaptive",
                            alignment: "center",
                            width: "auto",
                            cellTemplate: adaptiveCellTemplate,
                            fixedPosition: "right"
                        });
                        that._columnsController.columnsChanged.add((function() {
                            var isAdaptiveVisible = !!that.updateHidingQueue(that._columnsController.getColumns()).length;
                            that._columnsController.columnOption("command:adaptive", "adaptiveHidden", !isAdaptiveVisible, true)
                        }));
                        that._editingController = that.getController("editing");
                        that._hidingColumnsQueue = [];
                        that._hiddenColumns = [];
                        that.createAction("onAdaptiveDetailRowPreparing");
                        that.callBase()
                    },
                    optionChanged: function(args) {
                        if ("columnHidingEnabled" === args.name) {
                            this._columnsController.columnOption("command:adaptive", "adaptiveHidden", !args.value)
                        }
                        this.callBase(args)
                    },
                    publicMethods: function() {
                        return ["isAdaptiveDetailRowExpanded", "expandAdaptiveDetailRow", "collapseAdaptiveDetailRow"]
                    },
                    isAdaptiveDetailRowExpanded: function(key) {
                        var dataController = this._dataController;
                        return dataController.adaptiveExpandedKey() && (0, _common.equalByValue)(dataController.adaptiveExpandedKey(), key)
                    },
                    expandAdaptiveDetailRow: function(key) {
                        if (!this.hasAdaptiveDetailRowExpanded()) {
                            this.toggleExpandAdaptiveDetailRow(key)
                        }
                    },
                    collapseAdaptiveDetailRow: function() {
                        if (this.hasAdaptiveDetailRowExpanded()) {
                            this.toggleExpandAdaptiveDetailRow()
                        }
                    },
                    updateCommandAdaptiveAriaLabel: function(key, label) {
                        var rowIndex = this._dataController.getRowIndexByKey(key);
                        if (-1 === rowIndex) {
                            return
                        }
                        var $row = (0, _renderer.default)(this.component.getRowElement(rowIndex));
                        this.setCommandAdaptiveAriaLabel($row, label)
                    },
                    setCommandAdaptiveAriaLabel: function($row, labelName) {
                        var $adaptiveCommand = $row.find(".dx-command-adaptive");
                        $adaptiveCommand.attr("aria-label", _message.default.format(labelName))
                    }
                };
                var AdaptiveColumnsController = _m_modules.default.ViewController.inherit(adaptiveColumnsControllerMembers);
                var adaptivityModule = {
                    defaultOptions: function() {
                        return {
                            columnHidingEnabled: false,
                            onAdaptiveDetailRowPreparing: null
                        }
                    },
                    controllers: {
                        adaptiveColumns: AdaptiveColumnsController
                    },
                    extenders: {
                        views: {
                            rowsView: {
                                _getCellTemplate: function(options) {
                                    var that = this;
                                    var column = options.column;
                                    if ("detailAdaptive" === options.rowType && "detail" === column.command) {
                                        return function(container, options) {
                                            that._adaptiveColumnsController.createFormByHiddenColumns((0, _renderer.default)(container), options)
                                        }
                                    }
                                    return that.callBase(options)
                                },
                                _createRow: function(row) {
                                    var $row = this.callBase.apply(this, arguments);
                                    if (row && "detailAdaptive" === row.rowType && row.key === this._dataController.adaptiveExpandedKey()) {
                                        $row.addClass("dx-adaptive-detail-row")
                                    }
                                    return $row
                                },
                                _renderCells: function($row, options) {
                                    this.callBase($row, options);
                                    var adaptiveColumnsController = this._adaptiveColumnsController;
                                    var hidingColumnsQueueLength = adaptiveColumnsController.getHidingColumnsQueue().length;
                                    var hiddenColumnsLength = adaptiveColumnsController.getHiddenColumns().length;
                                    if (hidingColumnsQueueLength && !hiddenColumnsLength) {
                                        (function($row) {
                                            return $row.find("td:not(.dx-datagrid-hidden-column):not([class*='dx-command-'])")
                                        })($row).last().addClass("dx-last-data-cell")
                                    }
                                    if ("data" === options.row.rowType) {
                                        adaptiveColumnsController.setCommandAdaptiveAriaLabel($row, "dxDataGrid-ariaAdaptiveExpand")
                                    }
                                },
                                _getColumnIndexByElementCore: function($element) {
                                    var $itemContent = $element.closest(".".concat("dx-field-item-content"));
                                    if ($itemContent.length && $itemContent.closest(this.component.$element()).length) {
                                        var formItem = $itemContent.length ? $itemContent.first().data("dx-form-item") : null;
                                        return formItem && formItem.column && this._columnsController.getVisibleIndex(formItem.column.index)
                                    }
                                    return this.callBase($element)
                                },
                                _cellPrepared: function($cell, options) {
                                    this.callBase.apply(this, arguments);
                                    if ("detailAdaptive" !== options.row.rowType && "adaptiveHidden" === options.column.visibleWidth) {
                                        $cell.addClass(this.addWidgetPrefix("hidden-column"))
                                    }
                                },
                                getCell: function(cellPosition, rows) {
                                    var item = this._dataController.items()[null === cellPosition || void 0 === cellPosition ? void 0 : cellPosition.rowIndex];
                                    if ("detailAdaptive" === (null === item || void 0 === item ? void 0 : item.rowType)) {
                                        var $adaptiveDetailItems = this._adaptiveColumnsController.getAdaptiveDetailItems();
                                        return this.callBase(cellPosition, rows, $adaptiveDetailItems)
                                    }
                                    return this.callBase.apply(this, arguments)
                                },
                                _getCellElement: function(rowIndex, columnIdentifier) {
                                    var item = this._dataController.items()[rowIndex];
                                    if (item && "detailAdaptive" === item.rowType) {
                                        return this._adaptiveColumnsController.getItemContentByColumnIndex(columnIdentifier)
                                    }
                                    return this.callBase.apply(this, arguments)
                                },
                                getContextMenuItems: function(options) {
                                    if (options.row && "detailAdaptive" === options.row.rowType) {
                                        var view = this.component.getView("columnHeadersView");
                                        var formItem = (0, _renderer.default)(options.targetElement).closest(".dx-field-item-label").next().data("dx-form-item");
                                        options.column = formItem ? formItem.column : options.column;
                                        return view.getContextMenuItems && view.getContextMenuItems(options)
                                    }
                                    return this.callBase && this.callBase(options)
                                },
                                isClickableElement: function($target) {
                                    var isClickable = this.callBase ? this.callBase($target) : false;
                                    return isClickable || !!$target.closest(".".concat("dx-command-adaptive")).length
                                },
                                init: function() {
                                    this.callBase();
                                    this._adaptiveColumnsController = this.getController("adaptiveColumns")
                                }
                            }
                        },
                        controllers: {
                            export: {
                                _updateColumnWidth: function(column, width) {
                                    this.callBase(column, "adaptiveHidden" === column.visibleWidth ? column.bestFitWidth : width)
                                }
                            },
                            columnsResizer: {
                                _pointCreated: function(point, cellsLength, columns) {
                                    var result = this.callBase(point, cellsLength, columns);
                                    var currentColumn = columns[point.columnIndex] || {};
                                    var nextColumnIndex = this._getNextColumnIndex(point.columnIndex);
                                    var nextColumn = columns[nextColumnIndex] || {};
                                    var hasHiddenColumnsOnly = nextColumnIndex !== point.columnIndex + 1 && nextColumn.command;
                                    var hasAdaptiveHiddenWidth = "adaptiveHidden" === currentColumn.visibleWidth || hasHiddenColumnsOnly;
                                    return result || hasAdaptiveHiddenWidth
                                },
                                _getNextColumnIndex: function(currentColumnIndex) {
                                    var visibleColumns = this._columnsController.getVisibleColumns();
                                    var index = this.callBase(currentColumnIndex);
                                    while (visibleColumns[index] && "adaptiveHidden" === visibleColumns[index].visibleWidth) {
                                        index++
                                    }
                                    return index
                                }
                            },
                            draggingHeader: {
                                _pointCreated: function(point, columns, location, sourceColumn) {
                                    var result = this.callBase(point, columns, location, sourceColumn);
                                    var column = columns[point.columnIndex - 1] || {};
                                    var hasAdaptiveHiddenWidth = "adaptiveHidden" === column.visibleWidth;
                                    return result || hasAdaptiveHiddenWidth
                                }
                            },
                            editing: {
                                _isRowEditMode: function() {
                                    return "row" === this.getEditMode()
                                },
                                _getFormEditItemTemplate: function(cellOptions, column) {
                                    if ("row" !== this.getEditMode() && "detailAdaptive" === cellOptions.rowType) {
                                        cellOptions.columnIndex = this._columnsController.getVisibleIndex(column.index);
                                        return this.getColumnTemplate(cellOptions)
                                    }
                                    return this.callBase(cellOptions, column)
                                },
                                _closeEditItem: function($targetElement) {
                                    var $itemContents = $targetElement.closest(".".concat("dx-field-item-content"));
                                    var rowIndex = this._dataController.getRowIndexByKey(this._dataController.adaptiveExpandedKey()) + 1;
                                    var formItem = $itemContents.length ? $itemContents.first().data("dx-form-item") : null;
                                    var columnIndex = formItem && formItem.column && this._columnsController.getVisibleIndex(formItem.column.index);
                                    if (!this.isEditCell(rowIndex, columnIndex)) {
                                        this.callBase($targetElement)
                                    }
                                },
                                _beforeUpdateItems: function(rowIndices, rowIndex) {
                                    if (!this._adaptiveController.isFormOrPopupEditMode() && this._adaptiveController.hasHiddenColumns()) {
                                        var items = this._dataController.items();
                                        var item = items[rowIndex];
                                        var oldExpandRowIndex = _m_utils.default.getIndexByKey(this._dataController.adaptiveExpandedKey(), items);
                                        this._isForceRowAdaptiveExpand = !this._adaptiveController.hasAdaptiveDetailRowExpanded();
                                        if (oldExpandRowIndex >= 0) {
                                            rowIndices.push(oldExpandRowIndex + 1)
                                        }
                                        rowIndices.push(rowIndex + 1);
                                        this._dataController.adaptiveExpandedKey(item.key)
                                    }
                                },
                                _afterInsertRow: function(key) {
                                    this.callBase.apply(this, arguments);
                                    if (this._adaptiveController.hasHiddenColumns()) {
                                        this._adaptiveController.toggleExpandAdaptiveDetailRow(key, this.isRowEditMode());
                                        this._isForceRowAdaptiveExpand = true
                                    }
                                },
                                _collapseAdaptiveDetailRow: function() {
                                    if (this._isRowEditMode() && this._isForceRowAdaptiveExpand) {
                                        this._adaptiveController.collapseAdaptiveDetailRow();
                                        this._isForceRowAdaptiveExpand = false
                                    }
                                },
                                _cancelEditAdaptiveDetailRow: function() {
                                    if (this._adaptiveController.hasHiddenColumns()) {
                                        this._collapseAdaptiveDetailRow()
                                    }
                                },
                                _afterSaveEditData: function() {
                                    var _this2 = this;
                                    this.callBase.apply(this, arguments);
                                    var deferred = new _deferred.Deferred;
                                    if (this._isRowEditMode() && this._adaptiveController.hasHiddenColumns()) {
                                        (0, _deferred.when)(this.getController("validating").validate(true)).done((function(isValid) {
                                            if (isValid) {
                                                _this2._cancelEditAdaptiveDetailRow()
                                            }
                                            deferred.resolve()
                                        }))
                                    } else {
                                        deferred.resolve()
                                    }
                                    return deferred.promise()
                                },
                                _beforeCancelEditData: function() {
                                    this.callBase();
                                    this._cancelEditAdaptiveDetailRow()
                                },
                                _getRowIndicesForCascadeUpdating: function(row) {
                                    var rowIndices = this.callBase.apply(this, arguments);
                                    if (this._adaptiveController.isAdaptiveDetailRowExpanded(row.key)) {
                                        rowIndices.push("detailAdaptive" === row.rowType ? row.rowIndex - 1 : row.rowIndex + 1)
                                    }
                                    return rowIndices
                                },
                                _beforeCloseEditCellInBatchMode: function(rowIndices) {
                                    var expandedKey = this._dataController._adaptiveExpandedKey;
                                    if (expandedKey) {
                                        var rowIndex = _m_utils.default.getIndexByKey(expandedKey, this._dataController.items());
                                        if (rowIndex > -1) {
                                            rowIndices.unshift(rowIndex)
                                        }
                                    }
                                },
                                editRow: function(rowIndex) {
                                    if (this._adaptiveController.isFormOrPopupEditMode()) {
                                        this._adaptiveController.collapseAdaptiveDetailRow()
                                    }
                                    this.callBase(rowIndex)
                                },
                                deleteRow: function(rowIndex) {
                                    var rowKey = this._dataController.getKeyByRowIndex(rowIndex);
                                    if ("batch" === this.getEditMode() && this._adaptiveController.isAdaptiveDetailRowExpanded(rowKey)) {
                                        this._adaptiveController.collapseAdaptiveDetailRow()
                                    }
                                    this.callBase(rowIndex)
                                },
                                init: function() {
                                    this.callBase();
                                    this._adaptiveController = this.getController("adaptiveColumns")
                                }
                            },
                            resizing: {
                                _needBestFit: function() {
                                    return this.callBase() || !!this._adaptiveColumnsController.getHidingColumnsQueue().length
                                },
                                _correctColumnWidths: function(resultWidths, visibleColumns) {
                                    var adaptiveController = this._adaptiveColumnsController;
                                    var oldHiddenColumns = adaptiveController.getHiddenColumns();
                                    var hidingColumnsQueue = adaptiveController.updateHidingQueue(this._columnsController.getColumns());
                                    adaptiveController.hideRedundantColumns(resultWidths, visibleColumns, hidingColumnsQueue);
                                    var hiddenColumns = adaptiveController.getHiddenColumns();
                                    if (adaptiveController.hasAdaptiveDetailRowExpanded()) {
                                        if (oldHiddenColumns.length !== hiddenColumns.length) {
                                            adaptiveController.updateForm(hiddenColumns)
                                        }
                                    }!hiddenColumns.length && adaptiveController.collapseAdaptiveDetailRow();
                                    return this.callBase.apply(this, arguments)
                                },
                                _toggleBestFitMode: function(isBestFit) {
                                    isBestFit && this._adaptiveColumnsController._showHiddenColumns();
                                    this.callBase(isBestFit)
                                },
                                _needStretch: function() {
                                    var adaptiveColumnsController = this._adaptiveColumnsController;
                                    return this.callBase.apply(this, arguments) || adaptiveColumnsController.getHidingColumnsQueue().length || adaptiveColumnsController.hasHiddenColumns()
                                },
                                init: function() {
                                    this._adaptiveColumnsController = this.getController("adaptiveColumns");
                                    this.callBase()
                                },
                                dispose: function() {
                                    this.callBase.apply(this, arguments);
                                    clearTimeout(this._updateScrollableTimeoutID)
                                }
                            },
                            data: {
                                _processItems: function(items, change) {
                                    var changeType = change.changeType;
                                    items = this.callBase.apply(this, arguments);
                                    if ("loadingAll" === changeType || !(0, _type.isDefined)(this._adaptiveExpandedKey)) {
                                        return items
                                    }
                                    var expandRowIndex = _m_utils.default.getIndexByKey(this._adaptiveExpandedKey, items);
                                    var newMode = false === this.option("scrolling.legacyMode");
                                    if (expandRowIndex >= 0) {
                                        var item = items[expandRowIndex];
                                        items.splice(expandRowIndex + 1, 0, {
                                            visible: true,
                                            rowType: "detailAdaptive",
                                            key: item.key,
                                            data: item.data,
                                            node: item.node,
                                            modifiedValues: item.modifiedValues,
                                            isNewRow: item.isNewRow,
                                            values: item.values
                                        })
                                    } else if ("refresh" === changeType && !(newMode && change.repaintChangesOnly)) {
                                        this._adaptiveExpandedKey = void 0
                                    }
                                    return items
                                },
                                _getRowIndicesForExpand: function(key) {
                                    var rowIndices = this.callBase.apply(this, arguments);
                                    if (this.getController("adaptiveColumns").isAdaptiveDetailRowExpanded(key)) {
                                        var lastRowIndex = rowIndices[rowIndices.length - 1];
                                        rowIndices.push(lastRowIndex + 1)
                                    }
                                    return rowIndices
                                },
                                adaptiveExpandedKey: function(value) {
                                    if ((0, _type.isDefined)(value)) {
                                        this._adaptiveExpandedKey = value
                                    } else {
                                        return this._adaptiveExpandedKey
                                    }
                                },
                                toggleExpandAdaptiveDetailRow: function(key, alwaysExpanded) {
                                    var oldExpandLoadedRowIndex = _m_utils.default.getIndexByKey(this._adaptiveExpandedKey, this._items);
                                    var newExpandLoadedRowIndex = _m_utils.default.getIndexByKey(key, this._items);
                                    if (oldExpandLoadedRowIndex >= 0 && oldExpandLoadedRowIndex === newExpandLoadedRowIndex && !alwaysExpanded) {
                                        key = void 0;
                                        newExpandLoadedRowIndex = -1
                                    }
                                    var oldKey = this._adaptiveExpandedKey;
                                    this._adaptiveExpandedKey = key;
                                    if (oldExpandLoadedRowIndex >= 0) {
                                        oldExpandLoadedRowIndex++
                                    }
                                    if (newExpandLoadedRowIndex >= 0) {
                                        newExpandLoadedRowIndex++
                                    }
                                    var rowIndexDelta = this.getRowIndexDelta();
                                    this.updateItems({
                                        allowInvisibleRowIndices: true,
                                        changeType: "update",
                                        rowIndices: [oldExpandLoadedRowIndex - rowIndexDelta, newExpandLoadedRowIndex - rowIndexDelta]
                                    });
                                    var adaptiveColumnsController = this.getController("adaptiveColumns");
                                    adaptiveColumnsController.updateCommandAdaptiveAriaLabel(key, "dxDataGrid-ariaAdaptiveCollapse");
                                    adaptiveColumnsController.updateCommandAdaptiveAriaLabel(oldKey, "dxDataGrid-ariaAdaptiveExpand")
                                },
                                init: function() {
                                    this.callBase();
                                    this._adaptiveExpandedKey = void 0
                                }
                            },
                            editorFactory: {
                                _needHideBorder: function($element) {
                                    return this.callBase($element) || (null === $element || void 0 === $element ? void 0 : $element.hasClass("dx-field-item-content")) && (null === $element || void 0 === $element ? void 0 : $element.find(".dx-checkbox").length)
                                },
                                _getFocusCellSelector: function() {
                                    return "".concat(this.callBase(), ", .dx-adaptive-detail-row .dx-field-item > .dx-field-item-content")
                                },
                                _getRevertTooltipsSelector: function() {
                                    return "".concat(this.callBase(), ", .dx-field-item-content .").concat(this.addWidgetPrefix("revert-tooltip"))
                                }
                            },
                            columns: {
                                _isColumnVisible: function(column) {
                                    return this.callBase(column) && !column.adaptiveHidden
                                }
                            },
                            keyboardNavigation: function(Base) {
                                return function(_Base) {
                                    ! function(subClass, superClass) {
                                        subClass.prototype = Object.create(superClass.prototype);
                                        subClass.prototype.constructor = subClass;
                                        _setPrototypeOf(subClass, superClass)
                                    }(AdaptivityKeyboardNavigationExtender, _Base);

                                    function AdaptivityKeyboardNavigationExtender() {
                                        return _Base.apply(this, arguments) || this
                                    }
                                    var _proto = AdaptivityKeyboardNavigationExtender.prototype;
                                    _proto._isCellValid = function($cell, isClick) {
                                        return _Base.prototype._isCellValid.call(this, $cell, isClick) && !$cell.hasClass(this.addWidgetPrefix("hidden-column")) && !$cell.hasClass("dx-command-adaptive-hidden")
                                    };
                                    _proto._processNextCellInMasterDetail = function($nextCell, $cell) {
                                        _Base.prototype._processNextCellInMasterDetail.call(this, $nextCell, $cell);
                                        var isCellOrBatchMode = this._editingController.isCellOrBatchEditMode();
                                        var isEditing = this._editingController.isEditing();
                                        if (isEditing && $nextCell && isCellOrBatchMode && !this._isInsideEditForm($nextCell)) {
                                            _events_engine.default.off($nextCell, "focus", focusCellHandler);
                                            _events_engine.default.on($nextCell, "focus", {
                                                $nextCell: $nextCell
                                            }, focusCellHandler);
                                            _events_engine.default.trigger($cell, "focus")
                                        }
                                    };
                                    _proto._isCellElement = function($cell) {
                                        return _Base.prototype._isCellElement.call(this, $cell) || $cell.hasClass("dx-adaptive-item-text")
                                    };
                                    _proto.init = function() {
                                        _Base.prototype.init.call(this);
                                        this._adaptiveController = this.getController("adaptiveColumns")
                                    };
                                    return AdaptivityKeyboardNavigationExtender
                                }(Base)
                            }
                        }
                    }
                };
                exports.adaptivityModule = adaptivityModule
            },
        71184:
            /*!***********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/column_chooser/m_column_chooser.js ***!
              \***********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnChooserModule = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../../core/devices */ 20530));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _button = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/button */ 63008));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/popup/ui.popup */ 51495));
                var _themes = __webpack_require__( /*! ../../../../ui/themes */ 75811);
                var _tree_view = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/tree_view */ 30254));
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_columns_view = __webpack_require__( /*! ../views/m_columns_view */ 57318);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var COLUMN_OPTIONS_USED_IN_ITEMS = ["showInColumnChooser", "caption", "allowHiding", "visible", "cssClass", "ownerBand"];
                var columnChooserControllerMembers = {
                    renderShowColumnChooserButton: function($element) {
                        var that = this;
                        var columnChooserButtonClass = that.addWidgetPrefix("column-chooser-button");
                        var columnChooserEnabled = that.option("columnChooser.enabled");
                        var $showColumnChooserButton = $element.find(".".concat(columnChooserButtonClass));
                        var $columnChooserButton;
                        if (columnChooserEnabled) {
                            if (!$showColumnChooserButton.length) {
                                $columnChooserButton = (0, _renderer.default)("<div>").addClass(columnChooserButtonClass).appendTo($element);
                                that._createComponent($columnChooserButton, _button.default, {
                                    icon: "column-chooser",
                                    onClick: function() {
                                        that.getView("columnChooserView").showColumnChooser()
                                    },
                                    hint: that.option("columnChooser.title"),
                                    integrationOptions: {}
                                })
                            } else {
                                $showColumnChooserButton.show()
                            }
                        } else {
                            $showColumnChooserButton.hide()
                        }
                    },
                    getPosition: function() {
                        var rowsView = this.getView("rowsView");
                        var position = this.option("columnChooser.position");
                        return (0, _type.isDefined)(position) ? position : {
                            my: "right bottom",
                            at: "right bottom",
                            of: rowsView && rowsView.element(),
                            collision: "fit",
                            offset: "-2 -2",
                            boundaryOffset: "2 2"
                        }
                    }
                };
                var ColumnChooserController = _m_modules.default.ViewController.inherit(columnChooserControllerMembers);
                var columnChooserMembers = {
                    _resizeCore: _common.noop,
                    _isWinDevice: function() {
                        return !!_devices.default.real().win
                    },
                    _initializePopupContainer: function() {
                        var that = this;
                        var columnChooserClass = that.addWidgetPrefix("column-chooser");
                        var $element = that.element().addClass(columnChooserClass);
                        var columnChooserOptions = that.option("columnChooser");
                        var themeName = (0, _themes.current)();
                        var isGenericTheme = (0, _themes.isGeneric)(themeName);
                        var isMaterial = (0, _themes.isMaterial)(themeName);
                        var dxPopupOptions = {
                            visible: false,
                            shading: false,
                            showCloseButton: false,
                            dragEnabled: true,
                            resizeEnabled: true,
                            wrapperAttr: {
                                class: columnChooserClass
                            },
                            toolbarItems: [{
                                text: columnChooserOptions.title,
                                toolbar: "top",
                                location: isGenericTheme || isMaterial ? "before" : "center"
                            }],
                            position: that.getController("columnChooser").getPosition(),
                            width: columnChooserOptions.width,
                            height: columnChooserOptions.height,
                            rtlEnabled: that.option("rtlEnabled"),
                            onHidden: function() {
                                if (that._isWinDevice()) {
                                    (0, _renderer.default)("body").removeClass(that.addWidgetPrefix("notouch-action"))
                                }
                            },
                            container: columnChooserOptions.container
                        };
                        if (isGenericTheme || isMaterial) {
                            (0, _extend.extend)(dxPopupOptions, {
                                showCloseButton: true
                            })
                        } else {
                            dxPopupOptions.toolbarItems[dxPopupOptions.toolbarItems.length] = {
                                shortcut: "cancel"
                            }
                        }
                        if (!(0, _type.isDefined)(this._popupContainer)) {
                            that._popupContainer = that._createComponent($element, _ui.default, dxPopupOptions);
                            that._popupContainer.on("optionChanged", (function(args) {
                                if ("visible" === args.name) {
                                    that.renderCompleted.fire()
                                }
                            }))
                        } else {
                            this._popupContainer.option(dxPopupOptions)
                        }
                        this.setPopupAttributes()
                    },
                    setPopupAttributes: function() {
                        var isSelectMode = this.isSelectMode();
                        var isBandColumnsUsed = this._columnsController.isBandColumnsUsed();
                        this._popupContainer.setAria({
                            role: "dialog",
                            label: _message.default.format("dxDataGrid-columnChooserTitle")
                        });
                        this._popupContainer.$wrapper().toggleClass(this.addWidgetPrefix("column-chooser-mode-drag"), !isSelectMode).toggleClass(this.addWidgetPrefix("column-chooser-mode-select"), isSelectMode);
                        this._popupContainer.$content().addClass(this.addWidgetPrefix("column-chooser-list"));
                        if (isSelectMode && !isBandColumnsUsed) {
                            this._popupContainer.$content().addClass(this.addWidgetPrefix("column-chooser-plain"))
                        }
                    },
                    _renderCore: function(change) {
                        if (this._popupContainer) {
                            var isDragMode = !this.isSelectMode();
                            if (!this._columnChooserList || "full" === change) {
                                this._renderTreeView()
                            } else if (isDragMode) {
                                this._updateItems()
                            }
                        }
                    },
                    _renderTreeView: function() {
                        var _a, _b, _c;
                        var that = this;
                        var $container = this._popupContainer.$content();
                        var columnChooser = this.option("columnChooser");
                        var isSelectMode = this.isSelectMode();
                        var searchEnabled = (0, _type.isDefined)(columnChooser.allowSearch) ? columnChooser.allowSearch : null === (_a = columnChooser.search) || void 0 === _a ? void 0 : _a.enabled;
                        var searchTimeout = (0, _type.isDefined)(columnChooser.searchTimeout) ? columnChooser.searchTimeout : null === (_b = columnChooser.search) || void 0 === _b ? void 0 : _b.timeout;
                        var treeViewConfig = {
                            dataStructure: "plain",
                            activeStateEnabled: true,
                            focusStateEnabled: true,
                            hoverStateEnabled: true,
                            itemTemplate: "item",
                            showCheckBoxesMode: "none",
                            rootValue: null,
                            searchEnabled: searchEnabled,
                            searchTimeout: searchTimeout,
                            searchEditorOptions: null === (_c = columnChooser.search) || void 0 === _c ? void 0 : _c.editorOptions
                        };
                        if (this._isWinDevice()) {
                            treeViewConfig.useNativeScrolling = false
                        }(0, _extend.extend)(treeViewConfig, isSelectMode ? this._prepareSelectModeConfig() : this._prepareDragModeConfig());
                        if (this._columnChooserList) {
                            if (!treeViewConfig.searchEnabled) {
                                treeViewConfig.searchValue = ""
                            }
                            this._columnChooserList.option(treeViewConfig);
                            this._updateItems()
                        } else {
                            this._columnChooserList = this._createComponent($container, _tree_view.default, treeViewConfig);
                            this._updateItems();
                            var scrollTop = 0;
                            this._columnChooserList.on("optionChanged", (function(e) {
                                var scrollable = e.component.getScrollable();
                                scrollTop = scrollable.scrollTop()
                            }));
                            this._columnChooserList.on("contentReady", (function(e) {
                                (0, _common.deferUpdate)((function() {
                                    var scrollable = e.component.getScrollable();
                                    scrollable.scrollTo({
                                        y: scrollTop
                                    });
                                    that.renderCompleted.fire()
                                }))
                            }))
                        }
                    },
                    _prepareDragModeConfig: function() {
                        var columnChooserOptions = this.option("columnChooser");
                        return {
                            noDataText: columnChooserOptions.emptyPanelText,
                            activeStateEnabled: false,
                            focusStateEnabled: false,
                            hoverStateEnabled: false,
                            itemTemplate: function(data, index, item) {
                                (0, _renderer.default)(item).text(data.text).parent().addClass(data.cssClass).addClass("dx-column-chooser-item")
                            }
                        }
                    },
                    _prepareSelectModeConfig: function() {
                        var _this = this;
                        var that = this;
                        var selectionOptions = this.option("columnChooser.selection") || {};
                        var isUpdatingSelection = false;
                        return {
                            selectByClick: selectionOptions.selectByClick,
                            selectNodesRecursive: selectionOptions.recursive,
                            showCheckBoxesMode: selectionOptions.allowSelectAll ? "selectAll" : "normal",
                            onSelectionChanged: function(e) {
                                if (isUpdatingSelection) {
                                    return
                                }
                                var nodes = function(nodes) {
                                    return function addNodesToArray(nodes, flatNodesArray) {
                                        return nodes.reduce((function(result, node) {
                                            result.push(node);
                                            if (node.children.length) {
                                                addNodesToArray(node.children, result)
                                            }
                                            return result
                                        }), flatNodesArray)
                                    }(nodes, [])
                                }(e.component.getNodes());
                                e.component.beginUpdate();
                                isUpdatingSelection = true;
                                ! function(e, nodes) {
                                    nodes.filter((function(node) {
                                        return false === node.itemData.allowHiding
                                    })).forEach((function(node) {
                                        return e.component.selectItem(node.key)
                                    }))
                                }(e, nodes);
                                e.component.endUpdate();
                                isUpdatingSelection = false;
                                that.component.beginUpdate();
                                _this._isUpdatingColumnVisibility = true;
                                ! function(nodes) {
                                    nodes.forEach((function(node) {
                                        var columnIndex = node.itemData.id;
                                        var isVisible = false !== node.selected;
                                        that._columnsController.columnOption(columnIndex, "visible", isVisible)
                                    }))
                                }(nodes);
                                that.component.endUpdate();
                                _this._isUpdatingColumnVisibility = false
                            }
                        }
                    },
                    _updateItems: function() {
                        var isSelectMode = this.isSelectMode();
                        var chooserColumns = this._columnsController.getChooserColumns(isSelectMode);
                        var items = function(that, chooserColumns) {
                            var items = [];
                            var isSelectMode = that.isSelectMode();
                            var isRecursive = that.option("columnChooser.selection.recursive");
                            if (chooserColumns.length) {
                                (0, _iterator.each)(chooserColumns, (function(index, column) {
                                    var item = {
                                        text: column.caption,
                                        cssClass: column.cssClass,
                                        allowHiding: column.allowHiding,
                                        expanded: true,
                                        id: column.index,
                                        disabled: false === column.allowHiding,
                                        parentId: (0, _type.isDefined)(column.ownerBand) ? column.ownerBand : null
                                    };
                                    var isRecursiveWithColumns = isRecursive && column.hasColumns;
                                    if (isSelectMode && !isRecursiveWithColumns) {
                                        item.selected = column.visible
                                    }
                                    items.push(item)
                                }))
                            }
                            return items
                        }(this, chooserColumns);
                        this._columnChooserList.option("items", items)
                    },
                    _updateItemsSelection: function(columnIndices) {
                        var _this2 = this;
                        var changedColumns = null === columnIndices || void 0 === columnIndices ? void 0 : columnIndices.map((function(columnIndex) {
                            return _this2._columnsController.columnOption(columnIndex)
                        }));
                        this._columnChooserList.beginUpdate();
                        null === changedColumns || void 0 === changedColumns ? void 0 : changedColumns.forEach((function(_ref) {
                            var visible = _ref.visible,
                                index = _ref.index;
                            if (visible) {
                                _this2._columnChooserList.selectItem(index)
                            } else {
                                _this2._columnChooserList.unselectItem(index)
                            }
                        }));
                        this._columnChooserList.endUpdate()
                    },
                    _columnOptionChanged: function(e) {
                        this.callBase(e);
                        var isSelectMode = this.isSelectMode();
                        if (isSelectMode && this._columnChooserList && true !== this._isUpdatingColumnVisibility) {
                            var optionNames = e.optionNames;
                            var onlyVisibleChanged = optionNames.visible && 1 === optionNames.length;
                            var columnIndices = (0, _type.isDefined)(e.columnIndex) ? [e.columnIndex] : e.columnIndices;
                            var needUpdate = COLUMN_OPTIONS_USED_IN_ITEMS.some((function(optionName) {
                                return optionNames[optionName]
                            })) || e.changeTypes.columns && optionNames.all;
                            if (needUpdate) {
                                this._updateItemsSelection(columnIndices);
                                if (!onlyVisibleChanged) {
                                    this._updateItems()
                                }
                            }
                        }
                    },
                    optionChanged: function(args) {
                        switch (args.name) {
                            case "columnChooser":
                                this._initializePopupContainer();
                                this.render(null, "full");
                                break;
                            default:
                                this.callBase(args)
                        }
                    },
                    getColumnElements: function() {
                        var result = [];
                        var isSelectMode = this.isSelectMode();
                        var chooserColumns = this._columnsController.getChooserColumns(isSelectMode);
                        var $content = this._popupContainer && this._popupContainer.$content();
                        var $nodes = $content && $content.find(".dx-treeview-node");
                        if ($nodes) {
                            chooserColumns.forEach((function(column) {
                                var $node = $nodes.filter("[data-item-id = '".concat(column.index, "']"));
                                var item = $node.length ? $node.children(".".concat("dx-column-chooser-item")).get(0) : null;
                                result.push(item)
                            }))
                        }
                        return (0, _renderer.default)(result)
                    },
                    getName: function() {
                        return "columnChooser"
                    },
                    getColumns: function() {
                        return this._columnsController.getChooserColumns()
                    },
                    allowDragging: function(column) {
                        var isParentColumnVisible = this._columnsController.isParentColumnVisible(column.index);
                        var isColumnHidden = !column.visible && column.allowHiding;
                        return this.isColumnChooserVisible() && isParentColumnVisible && isColumnHidden
                    },
                    allowColumnHeaderDragging: function(column) {
                        var isDragMode = !this.isSelectMode();
                        return isDragMode && this.isColumnChooserVisible() && column.allowHiding
                    },
                    getBoundingRect: function() {
                        var container = this._popupContainer && this._popupContainer.$overlayContent();
                        if (container && container.is(":visible")) {
                            var offset = container.offset();
                            return {
                                left: offset.left,
                                top: offset.top,
                                right: offset.left + (0, _size.getOuterWidth)(container),
                                bottom: offset.top + (0, _size.getOuterHeight)(container)
                            }
                        }
                        return null
                    },
                    showColumnChooser: function() {
                        if (!this._popupContainer) {
                            this._initializePopupContainer();
                            this.render()
                        }
                        this._popupContainer.show();
                        if (this._isWinDevice()) {
                            (0, _renderer.default)("body").addClass(this.addWidgetPrefix("notouch-action"))
                        }
                    },
                    hideColumnChooser: function() {
                        if (this._popupContainer) {
                            this._popupContainer.hide()
                        }
                    },
                    isColumnChooserVisible: function() {
                        var popupContainer = this._popupContainer;
                        return popupContainer && popupContainer.option("visible")
                    },
                    isSelectMode: function() {
                        return "select" === this.option("columnChooser.mode")
                    },
                    hasHiddenColumns: function() {
                        var isEnabled = this.option("columnChooser.enabled");
                        var hiddenColumns = this.getColumns().filter((function(column) {
                            return !column.visible
                        }));
                        return isEnabled && hiddenColumns.length
                    },
                    publicMethods: function() {
                        return ["showColumnChooser", "hideColumnChooser"]
                    }
                };
                var ColumnChooserView = _m_columns_view.ColumnsView.inherit(columnChooserMembers);
                var columnChooserModule = {
                    defaultOptions: function() {
                        return {
                            columnChooser: {
                                enabled: false,
                                search: {
                                    enabled: false,
                                    timeout: 500,
                                    editorOptions: {}
                                },
                                selection: {
                                    allowSelectAll: false,
                                    selectByClick: false,
                                    recursive: false
                                },
                                position: void 0,
                                mode: "dragAndDrop",
                                width: 250,
                                height: 260,
                                title: _message.default.format("dxDataGrid-columnChooserTitle"),
                                emptyPanelText: _message.default.format("dxDataGrid-columnChooserEmptyText"),
                                container: void 0
                            }
                        }
                    },
                    controllers: {
                        columnChooser: ColumnChooserController
                    },
                    views: {
                        columnChooserView: ColumnChooserView
                    },
                    extenders: {
                        views: {
                            headerPanel: {
                                _getToolbarItems: function() {
                                    var items = this.callBase();
                                    return this._appendColumnChooserItem(items)
                                },
                                _appendColumnChooserItem: function(items) {
                                    var that = this;
                                    var columnChooserEnabled = that.option("columnChooser.enabled");
                                    if (columnChooserEnabled) {
                                        var hintText = that.option("columnChooser.title");
                                        var toolbarItem = {
                                            widget: "dxButton",
                                            options: {
                                                icon: "column-chooser",
                                                onClick: function() {
                                                    that.component.getView("columnChooserView").showColumnChooser()
                                                },
                                                hint: hintText,
                                                text: hintText,
                                                onInitialized: function(e) {
                                                    (0, _renderer.default)(e.element).addClass(that._getToolbarButtonClass(that.addWidgetPrefix("column-chooser-button")))
                                                },
                                                elementAttr: {
                                                    "aria-haspopup": "dialog"
                                                }
                                            },
                                            showText: "inMenu",
                                            location: "after",
                                            name: "columnChooserButton",
                                            locateInMenu: "auto",
                                            sortIndex: 40
                                        };
                                        items.push(toolbarItem)
                                    }
                                    return items
                                },
                                optionChanged: function(args) {
                                    switch (args.name) {
                                        case "columnChooser":
                                            this._invalidate();
                                            args.handled = true;
                                            break;
                                        default:
                                            this.callBase(args)
                                    }
                                },
                                isVisible: function() {
                                    var columnChooserEnabled = this.option("columnChooser.enabled");
                                    return this.callBase() || columnChooserEnabled
                                }
                            },
                            columnHeadersView: {
                                allowDragging: function(column) {
                                    var columnChooserView = this.component.getView("columnChooserView");
                                    var isDragMode = !columnChooserView.isSelectMode();
                                    var isColumnChooserVisible = columnChooserView.isColumnChooserVisible();
                                    return isDragMode && isColumnChooserVisible && column.allowHiding || this.callBase(column)
                                }
                            }
                        },
                        controllers: {
                            columns: {
                                allowMoveColumn: function(fromVisibleIndex, toVisibleIndex, sourceLocation, targetLocation) {
                                    var isSelectMode = "select" === this.option("columnChooser.mode");
                                    var isMoveColumnDisallowed = isSelectMode && "columnChooser" === targetLocation;
                                    return isMoveColumnDisallowed ? false : this.callBase(fromVisibleIndex, toVisibleIndex, sourceLocation, targetLocation)
                                }
                            }
                        }
                    }
                };
                exports.columnChooserModule = columnChooserModule
            },
        53424:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/column_fixing/m_column_fixing.js ***!
              \*********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnFixingModule = void 0;
                var _translator = __webpack_require__( /*! ../../../../animation/translator */ 31648);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/browser */ 47810));
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _position = __webpack_require__( /*! ../../../../core/utils/position */ 37518);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _style = __webpack_require__( /*! ../../../../core/utils/style */ 80968);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 55994));
                var _wheel = __webpack_require__( /*! ../../../../events/core/wheel */ 765);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/scroll_view/ui.scrollable */ 41183));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));
                var _m_columns_view = __webpack_require__( /*! ../views/m_columns_view */ 57318);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var getTransparentColumnIndex = function(fixedColumns) {
                    var transparentColumnIndex = -1;
                    (0, _iterator.each)(fixedColumns, (function(index, column) {
                        if ("transparent" === column.command) {
                            transparentColumnIndex = index;
                            return false
                        }
                        return
                    }));
                    return transparentColumnIndex
                };
                var normalizeColumnWidths = function(fixedColumns, widths, fixedWidths) {
                    var fixedColumnIndex = 0;
                    if (fixedColumns && widths && fixedWidths) {
                        for (var i = 0; i < fixedColumns.length; i++) {
                            if ("transparent" === fixedColumns[i].command) {
                                fixedColumnIndex += fixedColumns[i].colspan
                            } else {
                                if (widths[fixedColumnIndex] < fixedWidths[i]) {
                                    widths[fixedColumnIndex] = fixedWidths[i]
                                }
                                fixedColumnIndex++
                            }
                        }
                    }
                    return widths
                };
                var baseFixedColumns = {
                    init: function() {
                        this.callBase();
                        this._isFixedTableRendering = false;
                        this._isFixedColumns = false
                    },
                    _createCol: function(column) {
                        return this.callBase(column).toggleClass("dx-col-fixed", !!(this._isFixedTableRendering && (column.fixed || column.command && "transparent" !== column.command)))
                    },
                    _correctColumnIndicesForFixedColumns: function(fixedColumns, change) {
                        var transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                        var transparentColspan = fixedColumns[transparentColumnIndex].colspan;
                        var columnIndices = change && change.columnIndices;
                        if (columnIndices) {
                            change.columnIndices = columnIndices.map((function(columnIndices) {
                                if (columnIndices) {
                                    return columnIndices.map((function(columnIndex) {
                                        if (columnIndex < transparentColumnIndex) {
                                            return columnIndex
                                        }
                                        if (columnIndex >= transparentColumnIndex + transparentColspan) {
                                            return columnIndex - transparentColspan + 1
                                        }
                                        return -1
                                    })).filter((function(columnIndex) {
                                        return columnIndex >= 0
                                    }))
                                }
                            }))
                        }
                    },
                    _partialUpdateFixedTable: function(fixedColumns) {
                        var fixedTableElement = this._fixedTableElement;
                        var $rows = this._getRowElementsCore(fixedTableElement);
                        var $colgroup = fixedTableElement.children("colgroup");
                        $colgroup.replaceWith(this._createColGroup(fixedColumns));
                        for (var i = 0; i < $rows.length; i++) {
                            this._partialUpdateFixedRow((0, _renderer.default)($rows[i]), fixedColumns)
                        }
                    },
                    _partialUpdateFixedRow: function($row, fixedColumns) {
                        var _a;
                        var cellElements = $row.get(0).childNodes;
                        var transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                        var transparentColumn = fixedColumns[transparentColumnIndex];
                        var columnIndexOffset = this._columnsController.getColumnIndexOffset();
                        var groupCellOptions;
                        var colIndex = columnIndexOffset + 1;
                        var colspan = transparentColumn.colspan;
                        if ($row.hasClass("dx-master-detail-row")) {
                            cellElements[0].setAttribute("colspan", null === (_a = this._columnsController.getVisibleColumns()) || void 0 === _a ? void 0 : _a.length);
                            return
                        }
                        if ($row.hasClass("dx-group-row")) {
                            groupCellOptions = this._getGroupCellOptions({
                                row: $row.data("options"),
                                columns: this._columnsController.getVisibleColumns()
                            });
                            colspan = groupCellOptions.colspan - Math.max(0, cellElements.length - (groupCellOptions.columnIndex + 2))
                        }
                        for (var j = 0; j < cellElements.length; j++) {
                            var needUpdateColspan = groupCellOptions ? j === groupCellOptions.columnIndex + 1 : j === transparentColumnIndex;
                            cellElements[j].setAttribute("aria-colindex", colIndex);
                            if (needUpdateColspan) {
                                cellElements[j].setAttribute("colspan", colspan);
                                colIndex += colspan
                            } else {
                                colIndex++
                            }
                        }
                    },
                    _renderTable: function(options) {
                        var _a;
                        var $fixedTable;
                        var fixedColumns = this.getFixedColumns();
                        this._isFixedColumns = !!fixedColumns.length;
                        var $table = this.callBase(options);
                        if (this._isFixedColumns) {
                            var change = null === options || void 0 === options ? void 0 : options.change;
                            var $fixedDataRows = this._getRowElements(this._fixedTableElement);
                            var needPartialUpdate = (null === change || void 0 === change ? void 0 : change.virtualColumnsScrolling) && $fixedDataRows.length === (null === (_a = null === change || void 0 === change ? void 0 : change.items) || void 0 === _a ? void 0 : _a.length);
                            this._isFixedTableRendering = true;
                            if (needPartialUpdate && true !== this.option("scrolling.legacyMode")) {
                                this._partialUpdateFixedTable(fixedColumns);
                                this._isFixedTableRendering = false
                            } else {
                                var columnIndices = null === change || void 0 === change ? void 0 : change.columnIndices;
                                this._correctColumnIndicesForFixedColumns(fixedColumns, change);
                                $fixedTable = this._createTable(fixedColumns);
                                this._renderRows($fixedTable, (0, _extend.extend)({}, options, {
                                    columns: fixedColumns
                                }));
                                this._updateContent($fixedTable, change, true);
                                if (columnIndices) {
                                    change.columnIndices = columnIndices
                                }
                                this._isFixedTableRendering = false
                            }
                        } else {
                            this._fixedTableElement && this._fixedTableElement.parent().remove();
                            this._fixedTableElement = null
                        }
                        return $table
                    },
                    _renderRow: function($table, options) {
                        var fixedCorrection;
                        var cells = options.row.cells;
                        this.callBase.apply(this, arguments);
                        if (this._isFixedTableRendering && cells && cells.length) {
                            fixedCorrection = 0;
                            var fixedCells = options.row.cells || [];
                            cells = cells.slice();
                            options.row.cells = cells;
                            for (var i = 0; i < fixedCells.length; i++) {
                                if (fixedCells[i].column && "transparent" === fixedCells[i].column.command) {
                                    fixedCorrection = (fixedCells[i].column.colspan || 1) - 1;
                                    continue
                                }
                                cells[i + fixedCorrection] = fixedCells[i]
                            }
                        }
                    },
                    _createCell: function(options) {
                        var that = this;
                        var column = options.column;
                        var columnCommand = column && column.command;
                        var rowType = options.rowType;
                        var $cell = that.callBase.apply(that, arguments);
                        var fixedColumns;
                        var prevFixedColumn;
                        var transparentColumnIndex;
                        if (that._isFixedTableRendering || "filter" === rowType) {
                            fixedColumns = that.getFixedColumns();
                            transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                            prevFixedColumn = fixedColumns[transparentColumnIndex - 1]
                        }
                        if (that._isFixedTableRendering) {
                            if ("transparent" === columnCommand) {
                                $cell.addClass("dx-pointer-events-none").toggleClass("dx-first-cell", 0 === transparentColumnIndex || prevFixedColumn && "expand" === prevFixedColumn.command).toggleClass("dx-last-cell", fixedColumns.length && transparentColumnIndex === fixedColumns.length - 1);
                                if ("freeSpace" !== rowType) {
                                    _m_utils.default.setEmptyText($cell)
                                }
                            }
                        } else if ("filter" === rowType) {
                            $cell.toggleClass("dx-first-cell", options.columnIndex === transparentColumnIndex)
                        }
                        var isRowAltStyle = that.option("rowAlternationEnabled") && options.isAltRow;
                        var isSelectAllCell = "multiple" === that.option("selection.mode") && 0 === options.columnIndex && "header" === options.rowType;
                        if (_browser.default.mozilla && options.column.fixed && "group" !== options.rowType && !isRowAltStyle && !isSelectAllCell) {
                            $cell.addClass("dx-col-fixed")
                        }
                        return $cell
                    },
                    _getContent: function(isFixedTableRendering) {
                        var _a;
                        return isFixedTableRendering ? null === (_a = this._fixedTableElement) || void 0 === _a ? void 0 : _a.parent() : this.callBase.apply(this, arguments)
                    },
                    _wrapTableInScrollContainer: function($table, isFixedTableRendering) {
                        var $scrollContainer = this.callBase.apply(this, arguments);
                        if (this._isFixedTableRendering || isFixedTableRendering) {
                            $scrollContainer.addClass(this.addWidgetPrefix("content-fixed"))
                        }
                        return $scrollContainer
                    },
                    _renderCellContent: function($cell, options) {
                        var isEmptyCell;
                        var column = options.column;
                        var isFixedTableRendering = this._isFixedTableRendering;
                        var isGroupCell = "group" === options.rowType && (0, _type.isDefined)(column.groupIndex);
                        if (isFixedTableRendering && isGroupCell && !column.command && !column.groupCellTemplate) {
                            $cell.css("pointerEvents", "none")
                        }
                        if (!isFixedTableRendering && this._isFixedColumns) {
                            isEmptyCell = column.fixed || column.command && false !== column.fixed;
                            if (isGroupCell) {
                                isEmptyCell = false;
                                if (options.row.summaryCells && options.row.summaryCells.length) {
                                    var columns = this._columnsController.getVisibleColumns();
                                    var alignByFixedColumnCellCount = this._getAlignByColumnCellCount ? this._getAlignByColumnCellCount(column.colspan, {
                                        columns: columns,
                                        row: options.row,
                                        isFixed: true
                                    }) : 0;
                                    if (alignByFixedColumnCellCount > 0) {
                                        var transparentColumnIndex = getTransparentColumnIndex(this._columnsController.getFixedColumns());
                                        isEmptyCell = columns.length - alignByFixedColumnCellCount < transparentColumnIndex
                                    }
                                }
                            }
                            if (isEmptyCell) {
                                if (column.command && "buttons" !== column.type || "group" === options.rowType) {
                                    $cell.html("&nbsp;").addClass(column.cssClass);
                                    return
                                }
                                $cell.addClass("dx-hidden-cell")
                            }
                        }
                        if ("transparent" !== column.command) {
                            this.callBase.apply(this, arguments)
                        }
                    },
                    _getCellElementsCore: function(rowIndex) {
                        var _this = this;
                        var cellElements = this.callBase.apply(this, arguments);
                        var isGroupRow = null === cellElements || void 0 === cellElements ? void 0 : cellElements.parent().hasClass("dx-group-row");
                        var headerRowIndex = "columnHeadersView" === this.name ? rowIndex : void 0;
                        if (this._fixedTableElement && cellElements) {
                            var fixedColumns = this.getFixedColumns(headerRowIndex);
                            var fixedCellElements = this._getRowElements(this._fixedTableElement).eq(rowIndex).children("td");
                            (0, _iterator.each)(fixedCellElements, (function(columnIndex, cell) {
                                if (isGroupRow) {
                                    if (cellElements[columnIndex] && "hidden" !== cell.style.visibility) {
                                        cellElements[columnIndex] = cell
                                    }
                                } else {
                                    var fixedColumn = fixedColumns[columnIndex];
                                    if (fixedColumn) {
                                        if ("transparent" === fixedColumn.command) {
                                            if (fixedCellElements.eq(columnIndex).hasClass("dx-master-detail-cell")) {
                                                cellElements[columnIndex] = cell || cellElements[columnIndex]
                                            }
                                        } else {
                                            var fixedColumnIndex = _this._columnsController.getVisibleIndexByColumn(fixedColumn, headerRowIndex);
                                            cellElements[fixedColumnIndex] = cell || cellElements[fixedColumnIndex]
                                        }
                                    }
                                }
                            }))
                        }
                        return cellElements
                    },
                    getColumnWidths: function() {
                        var result = this.callBase();
                        var fixedColumns = this.getFixedColumns();
                        var fixedWidths = this._fixedTableElement && result.length ? this.callBase(this._fixedTableElement) : void 0;
                        return normalizeColumnWidths(fixedColumns, result, fixedWidths)
                    },
                    getTableElement: function(isFixedTableRendering) {
                        isFixedTableRendering = this._isFixedTableRendering || isFixedTableRendering;
                        var tableElement = isFixedTableRendering ? this._fixedTableElement : this.callBase();
                        return tableElement
                    },
                    setTableElement: function(tableElement, isFixedTableRendering) {
                        if (this._isFixedTableRendering || isFixedTableRendering) {
                            this._fixedTableElement = tableElement.addClass("dx-pointer-events-none")
                        } else {
                            this.callBase(tableElement)
                        }
                    },
                    getColumns: function(rowIndex) {
                        var $tableElement = this.getTableElement();
                        if (this._isFixedTableRendering) {
                            return this.getFixedColumns(rowIndex)
                        }
                        return this.callBase(rowIndex, $tableElement)
                    },
                    getRowIndex: function($row) {
                        var $fixedTable = this._fixedTableElement;
                        if ($fixedTable && $fixedTable.find($row).length) {
                            return this._getRowElements($fixedTable).index($row)
                        }
                        return this.callBase($row)
                    },
                    getTableElements: function() {
                        var result = this.callBase.apply(this, arguments);
                        if (this._fixedTableElement) {
                            result = (0, _renderer.default)([result.get(0), this._fixedTableElement.get(0)])
                        }
                        return result
                    },
                    getFixedColumns: function(rowIndex) {
                        return this._columnsController.getFixedColumns(rowIndex)
                    },
                    getFixedColumnsOffset: function() {
                        var offset = {
                            left: 0,
                            right: 0
                        };
                        var $transparentColumn;
                        if (this._fixedTableElement) {
                            $transparentColumn = this.getTransparentColumnElement();
                            var positionTransparentColumn = $transparentColumn.position();
                            offset = {
                                left: positionTransparentColumn.left,
                                right: (0, _size.getOuterWidth)(this.element(), true) - ((0, _size.getOuterWidth)($transparentColumn, true) + positionTransparentColumn.left)
                            }
                        }
                        return offset
                    },
                    getTransparentColumnElement: function() {
                        return this._fixedTableElement && this._fixedTableElement.find(".".concat("dx-pointer-events-none")).first()
                    },
                    getFixedTableElement: function() {
                        return this._fixedTableElement
                    },
                    isFixedColumns: function() {
                        return this._isFixedColumns
                    },
                    _resizeCore: function() {
                        this.callBase();
                        this.synchronizeRows()
                    },
                    setColumnWidths: function(options) {
                        var _a;
                        var widths = options.widths;
                        var visibleColumns = this._columnsController.getVisibleColumns();
                        var isColumnWidthsSynced = (null === widths || void 0 === widths ? void 0 : widths.length) && visibleColumns.some((function(column) {
                            return (0, _type.isDefined)(column.visibleWidth)
                        }));
                        var isColumnWidthChanged = null === (_a = options.optionNames) || void 0 === _a ? void 0 : _a.width;
                        this.callBase(options);
                        if (this._fixedTableElement) {
                            var hasAutoWidth = null === widths || void 0 === widths ? void 0 : widths.some((function(width) {
                                return "auto" === width || !(0, _type.isDefined)(width)
                            }));
                            var needVisibleColumns = hasAutoWidth && (!isColumnWidthsSynced || !this.isScrollbarVisible(true));
                            var columns = needVisibleColumns ? visibleColumns : this.getFixedColumns();
                            this.setFixedTableColumnWidths(columns, widths)
                        }
                        var wordWrapEnabled = this.option("wordWrapEnabled");
                        var needSynchronizeRows = isColumnWidthsSynced || isColumnWidthChanged && wordWrapEnabled;
                        if (needSynchronizeRows) {
                            this.synchronizeRows()
                        }
                    },
                    setFixedTableColumnWidths: function(columns, widths) {
                        if (!this._fixedTableElement || !widths) {
                            return
                        }
                        var $cols = this._fixedTableElement.children("colgroup").children("col");
                        $cols.toArray().forEach((function(col) {
                            return col.removeAttribute("style")
                        }));
                        var columnIndex = 0;
                        columns.forEach((function(column) {
                            if (column.colspan) {
                                columnIndex += column.colspan;
                                return
                            }
                            var colWidth = (0, _m_columns_view.normalizeWidth)(widths[columnIndex]);
                            if ((0, _type.isDefined)(colWidth)) {
                                (0, _style.setWidth)($cols.eq(columnIndex), colWidth)
                            }
                            columnIndex += 1
                        }))
                    },
                    _getClientHeight: function(element) {
                        var boundingClientRectElement = element.getBoundingClientRect && (0, _position.getBoundingRect)(element);
                        return boundingClientRectElement && boundingClientRectElement.height ? boundingClientRectElement.height : element.clientHeight
                    },
                    synchronizeRows: function() {
                        var _this2 = this;
                        var rowHeights = [];
                        var fixedRowHeights = [];
                        var rowIndex;
                        var $rowElements;
                        var $fixedRowElements;
                        var $contentElement;
                        this.waitAsyncTemplates(true).done((function() {
                            if (_this2._isFixedColumns && _this2._tableElement && _this2._fixedTableElement) {
                                var heightTable = _this2._getClientHeight(_this2._tableElement.get(0));
                                var heightFixedTable = _this2._getClientHeight(_this2._fixedTableElement.get(0));
                                $rowElements = _this2._getRowElements(_this2._tableElement);
                                $fixedRowElements = _this2._getRowElements(_this2._fixedTableElement);
                                $contentElement = _this2._findContentElement();
                                if (heightTable !== heightFixedTable) {
                                    $contentElement && $contentElement.css("height", heightTable);
                                    $rowElements.css("height", "");
                                    $fixedRowElements.css("height", "");
                                    for (rowIndex = 0; rowIndex < $rowElements.length; rowIndex++) {
                                        rowHeights.push(_this2._getClientHeight($rowElements.get(rowIndex)));
                                        fixedRowHeights.push(_this2._getClientHeight($fixedRowElements.get(rowIndex)))
                                    }
                                    for (rowIndex = 0; rowIndex < $rowElements.length; rowIndex++) {
                                        var rowHeight = rowHeights[rowIndex];
                                        var fixedRowHeight = fixedRowHeights[rowIndex];
                                        if (rowHeight > fixedRowHeight) {
                                            $fixedRowElements.eq(rowIndex).css("height", rowHeight)
                                        } else if (rowHeight < fixedRowHeight) {
                                            $rowElements.eq(rowIndex).css("height", fixedRowHeight)
                                        }
                                    }
                                    $contentElement && $contentElement.css("height", "")
                                }
                            }
                        }))
                    },
                    setScrollerSpacing: function(width) {
                        var rtlEnabled = this.option("rtlEnabled");
                        this.callBase(width);
                        this.element().children(".".concat(this.addWidgetPrefix("content-fixed"))).css({
                            paddingLeft: rtlEnabled ? width : "",
                            paddingRight: !rtlEnabled ? width : ""
                        })
                    }
                };
                var ColumnHeadersViewFixedColumnsExtender = (0, _extend.extend)({}, baseFixedColumns, {
                    _getRowVisibleColumns: function(rowIndex) {
                        if (this._isFixedTableRendering) {
                            return this.getFixedColumns(rowIndex)
                        }
                        return this.callBase(rowIndex)
                    },
                    getContextMenuItems: function(options) {
                        var _this3 = this;
                        var column = options.column;
                        var columnFixingOptions = this.option("columnFixing");
                        var items = this.callBase(options);
                        if (options.row && "header" === options.row.rowType) {
                            if (true === columnFixingOptions.enabled && column && column.allowFixing) {
                                var onItemClick = function(params) {
                                    switch (params.itemData.value) {
                                        case "none":
                                            _this3._columnsController.columnOption(column.index, "fixed", false);
                                            break;
                                        case "left":
                                            _this3._columnsController.columnOption(column.index, {
                                                fixed: true,
                                                fixedPosition: "left"
                                            });
                                            break;
                                        case "right":
                                            _this3._columnsController.columnOption(column.index, {
                                                fixed: true,
                                                fixedPosition: "right"
                                            })
                                    }
                                };
                                items = items || [];
                                items.push({
                                    text: columnFixingOptions.texts.fix,
                                    beginGroup: true,
                                    items: [{
                                        text: columnFixingOptions.texts.leftPosition,
                                        value: "left",
                                        disabled: column.fixed && (!column.fixedPosition || "left" === column.fixedPosition),
                                        onItemClick: onItemClick
                                    }, {
                                        text: columnFixingOptions.texts.rightPosition,
                                        value: "right",
                                        disabled: column.fixed && "right" === column.fixedPosition,
                                        onItemClick: onItemClick
                                    }]
                                }, {
                                    text: columnFixingOptions.texts.unfix,
                                    value: "none",
                                    disabled: !column.fixed,
                                    onItemClick: onItemClick
                                })
                            }
                        }
                        return items
                    },
                    getFixedColumnElements: function(rowIndex) {
                        if ((0, _type.isDefined)(rowIndex)) {
                            return this._fixedTableElement && this._getRowElements(this._fixedTableElement).eq(rowIndex).children()
                        }
                        var columnElements = this.getColumnElements();
                        var $transparentColumnElement = this.getTransparentColumnElement();
                        if (columnElements && $transparentColumnElement && $transparentColumnElement.length) {
                            var transparentColumnIndex = getTransparentColumnIndex(this.getFixedColumns());
                            columnElements.splice(transparentColumnIndex, $transparentColumnElement.get(0).colSpan, $transparentColumnElement.get(0))
                        }
                        return columnElements
                    },
                    getColumnWidths: function() {
                        var fixedWidths;
                        var result = this.callBase();
                        var $fixedColumnElements = this.getFixedColumnElements();
                        var fixedColumns = this.getFixedColumns();
                        if (this._fixedTableElement) {
                            if ($fixedColumnElements && $fixedColumnElements.length) {
                                fixedWidths = this._getWidths($fixedColumnElements)
                            } else {
                                fixedWidths = this.callBase(this._fixedTableElement)
                            }
                        }
                        return normalizeColumnWidths(fixedColumns, result, fixedWidths)
                    }
                });
                var RowsViewFixedColumnsExtender = (0, _extend.extend)({}, baseFixedColumns, {
                    _detachHoverEvents: function() {
                        var element = this.element();
                        if (this._fixedTableElement && this._tableElement) {
                            _events_engine.default.off(element, "mouseover mouseout", ".dx-data-row")
                        }
                    },
                    _attachHoverEvents: function() {
                        var _this4 = this;
                        if (this._fixedTableElement && this._tableElement) {
                            _events_engine.default.on(this.element(), "mouseover mouseout", ".dx-data-row", this.createAction((function(args) {
                                var event = args.event;
                                var rowIndex = _this4.getRowIndex((0, _renderer.default)(event.target).closest(".dx-row"));
                                var isHover = "mouseover" === event.type;
                                if (rowIndex >= 0) {
                                    _this4._tableElement && _this4._getRowElements(_this4._tableElement).eq(rowIndex).toggleClass("dx-state-hover", isHover);
                                    _this4._fixedTableElement && _this4._getRowElements(_this4._fixedTableElement).eq(rowIndex).toggleClass("dx-state-hover", isHover)
                                }
                            })))
                        }
                    },
                    _getScrollDelay: function() {
                        var _a;
                        var hasResizeTimeout = null === (_a = this.getController("resizing")) || void 0 === _a ? void 0 : _a.hasResizeTimeout();
                        if (hasResizeTimeout) {
                            return this.option("scrolling.updateTimeout")
                        }
                        return _browser.default.mozilla ? 60 : 0
                    },
                    _findContentElement: function(isFixedTableRendering) {
                        var _this5 = this;
                        var $content;
                        var scrollTop;
                        var contentClass = this.addWidgetPrefix("content");
                        var element = this.element();
                        isFixedTableRendering = this._isFixedTableRendering || isFixedTableRendering;
                        if (element && isFixedTableRendering) {
                            $content = element.children(".".concat(contentClass));
                            var scrollable = this.getScrollable();
                            if (!$content.length && scrollable) {
                                $content = (0, _renderer.default)("<div>").addClass(contentClass);
                                _events_engine.default.on($content, "scroll", (function(e) {
                                    var target = e.target;
                                    var scrollDelay = _this5._getScrollDelay();
                                    clearTimeout(_this5._fixedScrollTimeout);
                                    _this5._fixedScrollTimeout = setTimeout((function() {
                                        scrollTop = (0, _renderer.default)(target).scrollTop();
                                        scrollable.scrollTo({
                                            y: scrollTop
                                        })
                                    }), scrollDelay)
                                }));
                                _events_engine.default.on($content, _wheel.name, (function(e) {
                                    var $nearestScrollable = (0, _renderer.default)(e.target).closest(".dx-scrollable");
                                    var shouldScroll = false;
                                    if (scrollable && scrollable.$element().is($nearestScrollable)) {
                                        shouldScroll = true
                                    } else {
                                        var nearestScrollableInstance = $nearestScrollable.length && _ui.default.getInstance($nearestScrollable.get(0));
                                        var nearestScrollableHasVerticalScrollbar = nearestScrollableInstance && nearestScrollableInstance.scrollHeight() - nearestScrollableInstance.clientHeight() > 0;
                                        shouldScroll = nearestScrollableInstance && !nearestScrollableHasVerticalScrollbar
                                    }
                                    if (shouldScroll) {
                                        scrollTop = scrollable.scrollTop();
                                        scrollable.scrollTo({
                                            y: scrollTop - e.delta
                                        });
                                        var scrollableTop = scrollable.scrollTop() + scrollable.clientHeight();
                                        var scrollableHeight = scrollable.scrollHeight() + _this5.getScrollbarWidth();
                                        var isPreventDefault = scrollable.scrollTop() > 0 && scrollableTop < scrollableHeight;
                                        if (isPreventDefault) {
                                            return false
                                        }
                                    }
                                    return
                                }));
                                $content.appendTo(element)
                            }
                            return $content
                        }
                        return this.callBase()
                    },
                    _updateScrollable: function() {
                        this.callBase();
                        var scrollable = this.getScrollable();
                        if (null === scrollable || void 0 === scrollable ? void 0 : scrollable._disposed) {
                            return
                        }
                        var scrollTop = scrollable && scrollable.scrollOffset().top;
                        this._updateFixedTablePosition(scrollTop)
                    },
                    _renderContent: function(contentElement, tableElement, isFixedTableRendering) {
                        if (this._isFixedTableRendering || isFixedTableRendering) {
                            return contentElement.empty().addClass("".concat(this.addWidgetPrefix("content"), " ").concat(this.addWidgetPrefix("content-fixed"))).append(tableElement)
                        }
                        return this.callBase(contentElement, tableElement)
                    },
                    _getGroupCellOptions: function(options) {
                        if (this._isFixedTableRendering) {
                            return this.callBase((0, _extend.extend)({}, options, {
                                columns: this._columnsController.getVisibleColumns()
                            }))
                        }
                        return this.callBase(options)
                    },
                    _renderGroupedCells: function($row, options) {
                        return this.callBase($row, (0, _extend.extend)({}, options, {
                            columns: this._columnsController.getVisibleColumns()
                        }))
                    },
                    _renderGroupSummaryCells: function($row, options) {
                        if (this._isFixedTableRendering) {
                            this.callBase($row, (0, _extend.extend)({}, options, {
                                columns: this._columnsController.getVisibleColumns()
                            }))
                        } else {
                            this.callBase($row, options)
                        }
                    },
                    _hasAlignByColumnSummaryItems: function(columnIndex, options) {
                        var result = this.callBase.apply(this, arguments);
                        var column = options.columns[columnIndex];
                        if (options.isFixed) {
                            return column.fixed && (result || "right" === column.fixedPosition)
                        }
                        return result && (!this._isFixedColumns || !column.fixed)
                    },
                    _renderGroupSummaryCellsCore: function($groupCell, options, groupCellColSpan, alignByColumnCellCount) {
                        var alignByFixedColumnCellCount;
                        if (this._isFixedTableRendering) {
                            options.isFixed = true;
                            alignByFixedColumnCellCount = this._getAlignByColumnCellCount(groupCellColSpan, options);
                            options.isFixed = false;
                            var startColumnIndex = options.columns.length - alignByFixedColumnCellCount;
                            options = (0, _extend.extend)({}, options, {
                                columns: this.getFixedColumns()
                            });
                            var transparentColumnIndex = getTransparentColumnIndex(options.columns);
                            if (startColumnIndex < transparentColumnIndex) {
                                alignByFixedColumnCellCount -= options.columns[transparentColumnIndex].colspan - 1 || 0;
                                groupCellColSpan -= options.columns[transparentColumnIndex].colspan - 1 || 0
                            } else if (alignByColumnCellCount > 0) {
                                $groupCell.css("visibility", "hidden")
                            }
                            alignByColumnCellCount = alignByFixedColumnCellCount
                        }
                        this.callBase($groupCell, options, groupCellColSpan, alignByColumnCellCount)
                    },
                    _getSummaryCellIndex: function(columnIndex, columns) {
                        if (this._isFixedTableRendering) {
                            var transparentColumnIndex = getTransparentColumnIndex(columns);
                            if (columnIndex > transparentColumnIndex) {
                                columnIndex += columns[transparentColumnIndex].colspan - 1
                            }
                            return columnIndex
                        }
                        return this.callBase.apply(this, arguments)
                    },
                    _renderCore: function(change) {
                        this._detachHoverEvents();
                        var deferred = this.callBase(change);
                        var isFixedColumns = this._isFixedColumns;
                        this.element().toggleClass("dx-fixed-columns", isFixedColumns);
                        if (this.option("hoverStateEnabled") && isFixedColumns) {
                            this._attachHoverEvents()
                        }
                        return deferred
                    },
                    setRowsOpacity: function(columnIndex, value) {
                        this.callBase(columnIndex, value);
                        var $rows = this._getRowElements(this._fixedTableElement);
                        this._setRowsOpacityCore($rows, this.getFixedColumns(), columnIndex, value)
                    },
                    optionChanged: function(args) {
                        this.callBase(args);
                        if ("hoverStateEnabled" === args.name && this._isFixedColumns) {
                            args.value ? this._attachHoverEvents() : this._detachHoverEvents()
                        }
                    },
                    getCellIndex: function($cell) {
                        var $fixedTable = this._fixedTableElement;
                        var cellIndex = 0;
                        if ($fixedTable && $cell.is("td") && $cell.closest($fixedTable).length) {
                            var columns = this.getFixedColumns();
                            (0, _iterator.each)(columns, (function(index, column) {
                                if (index === $cell[0].cellIndex) {
                                    return false
                                }
                                if (column.colspan) {
                                    cellIndex += column.colspan;
                                    return
                                }
                                cellIndex++;
                                return
                            }));
                            return cellIndex
                        }
                        return this.callBase.apply(this, arguments)
                    },
                    _updateFixedTablePosition: function(scrollTop, needFocus) {
                        if (this._fixedTableElement && this._tableElement) {
                            var $focusedElement;
                            var editorFactory = this.getController("editorFactory");
                            this._fixedTableElement.parent().scrollTop(scrollTop);
                            if (needFocus && editorFactory) {
                                $focusedElement = editorFactory.focus();
                                $focusedElement && editorFactory.focus($focusedElement)
                            }
                        }
                    },
                    setScrollerSpacing: function(vWidth, hWidth) {
                        var styles = {
                            marginBottom: 0
                        };
                        var $fixedContent = this.element().children(".".concat(this.addWidgetPrefix("content-fixed")));
                        if ($fixedContent.length && this._fixedTableElement) {
                            $fixedContent.css(styles);
                            this._fixedTableElement.css(styles);
                            styles[this.option("rtlEnabled") ? "marginLeft" : "marginRight"] = vWidth;
                            styles.marginBottom = hWidth;
                            var useNativeScrolling = this._scrollable && this._scrollable.option("useNative");
                            (useNativeScrolling ? $fixedContent : this._fixedTableElement).css(styles)
                        }
                    },
                    _getElasticScrollTop: function(e) {
                        var elasticScrollTop = 0;
                        if (e.scrollOffset.top < 0) {
                            elasticScrollTop = -e.scrollOffset.top
                        } else if (e.reachedBottom) {
                            var $scrollableContent = (0, _renderer.default)(e.component.content());
                            var $scrollableContainer = (0, _renderer.default)(e.component.container());
                            var maxScrollTop = Math.max($scrollableContent.get(0).clientHeight - $scrollableContainer.get(0).clientHeight, 0);
                            elasticScrollTop = Math.min(maxScrollTop - e.scrollOffset.top, 0)
                        }
                        return Math.floor(elasticScrollTop)
                    },
                    _applyElasticScrolling: function(e) {
                        if (this._fixedTableElement) {
                            var elasticScrollTop = this._getElasticScrollTop(e);
                            if (0 !== Math.ceil(elasticScrollTop)) {
                                (0, _translator.move)(this._fixedTableElement, {
                                    top: elasticScrollTop
                                })
                            } else {
                                this._fixedTableElement.css("transform", "")
                            }
                        }
                    },
                    _handleScroll: function(e) {
                        this._updateFixedTablePosition(e.scrollOffset.top, true);
                        this._applyElasticScrolling(e);
                        this.callBase(e)
                    },
                    _updateContentPosition: function(isRender) {
                        this.callBase.apply(this, arguments);
                        if (!isRender) {
                            this._updateFixedTablePosition(this._scrollTop)
                        }
                    },
                    _afterRowPrepared: function(e) {
                        if (this._isFixedTableRendering) {
                            return
                        }
                        this.callBase(e)
                    },
                    _scrollToElement: function($element) {
                        this.callBase($element, this.getFixedColumnsOffset())
                    },
                    dispose: function() {
                        this.callBase.apply(this, arguments);
                        clearTimeout(this._fixedScrollTimeout)
                    }
                });
                var FooterViewFixedColumnsExtender = baseFixedColumns;
                var columnFixingModule = {
                    defaultOptions: function() {
                        return {
                            columnFixing: {
                                enabled: false,
                                texts: {
                                    fix: _message.default.format("dxDataGrid-columnFixingFix"),
                                    unfix: _message.default.format("dxDataGrid-columnFixingUnfix"),
                                    leftPosition: _message.default.format("dxDataGrid-columnFixingLeftPosition"),
                                    rightPosition: _message.default.format("dxDataGrid-columnFixingRightPosition")
                                }
                            }
                        }
                    },
                    extenders: {
                        views: {
                            columnHeadersView: ColumnHeadersViewFixedColumnsExtender,
                            rowsView: RowsViewFixedColumnsExtender,
                            footerView: FooterViewFixedColumnsExtender
                        },
                        controllers: {
                            draggingHeader: {
                                _generatePointsByColumns: function(options) {
                                    var visibleColumns = options.columns;
                                    var targetDraggingPanel = options.targetDraggingPanel;
                                    if (targetDraggingPanel && "headers" === targetDraggingPanel.getName() && targetDraggingPanel.isFixedColumns()) {
                                        if (options.sourceColumn.fixed) {
                                            if (!options.rowIndex) {
                                                options.columnElements = targetDraggingPanel.getFixedColumnElements(0)
                                            }
                                            options.columns = targetDraggingPanel.getFixedColumns(options.rowIndex);
                                            var pointsByColumns = this.callBase(options);
                                            ! function(columns, fixedColumns, pointsByColumns) {
                                                var transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                                                var correctIndex = columns.length - fixedColumns.length;
                                                (0, _iterator.each)(pointsByColumns, (function(_, point) {
                                                    if (point.index > transparentColumnIndex) {
                                                        point.columnIndex += correctIndex;
                                                        point.index += correctIndex
                                                    }
                                                }));
                                                return pointsByColumns
                                            }(visibleColumns, options.columns, pointsByColumns);
                                            return pointsByColumns
                                        }
                                    }
                                    return this.callBase(options)
                                },
                                _pointCreated: function(point, columns, location, sourceColumn) {
                                    var result = this.callBase.apply(this, arguments);
                                    var targetColumn = columns[point.columnIndex];
                                    var $transparentColumn = this._columnHeadersView.getTransparentColumnElement();
                                    if (!result && "headers" === location && $transparentColumn && $transparentColumn.length) {
                                        var boundingRect = (0, _position.getBoundingRect)($transparentColumn.get(0));
                                        if (sourceColumn && sourceColumn.fixed) {
                                            return "right" === sourceColumn.fixedPosition ? point.x < boundingRect.right : point.x > boundingRect.left
                                        }
                                        if (targetColumn && targetColumn.fixed && "right" !== targetColumn.fixedPosition) {
                                            return true
                                        }
                                        return point.x < boundingRect.left || point.x > boundingRect.right
                                    }
                                    return result
                                }
                            },
                            columnsResizer: {
                                _generatePointsByColumns: function() {
                                    var that = this;
                                    var columnsController = that._columnsController;
                                    var columns = columnsController && that._columnsController.getVisibleColumns();
                                    var fixedColumns = columnsController && that._columnsController.getFixedColumns();
                                    var transparentColumnIndex = getTransparentColumnIndex(fixedColumns);
                                    var correctIndex = columns.length - fixedColumns.length;
                                    var cells = that._columnHeadersView.getFixedColumnElements();
                                    that.callBase();
                                    if (cells && cells.length > 0) {
                                        that._pointsByFixedColumns = _m_utils.default.getPointsByColumns(cells, (function(point) {
                                            if (point.index > transparentColumnIndex) {
                                                point.columnIndex += correctIndex;
                                                point.index += correctIndex
                                            }
                                            return that._pointCreated(point, columns.length, columns)
                                        }))
                                    }
                                },
                                _getTargetPoint: function(pointsByColumns, currentX, deltaX) {
                                    var $transparentColumn = this._columnHeadersView.getTransparentColumnElement();
                                    if ($transparentColumn && $transparentColumn.length) {
                                        var boundingRect = (0, _position.getBoundingRect)($transparentColumn.get(0));
                                        if (currentX <= boundingRect.left || currentX >= boundingRect.right) {
                                            return this.callBase(this._pointsByFixedColumns, currentX, deltaX)
                                        }
                                    }
                                    return this.callBase(pointsByColumns, currentX, deltaX)
                                }
                            }
                        }
                    }
                };
                exports.columnFixingModule = columnFixingModule
            },
        14509:
            /*!***********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/column_headers/m_column_headers.js ***!
              \***********************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnHeadersModule = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../../core/dom_adapter */ 73349));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 55994));
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _m_accessibility = __webpack_require__( /*! ../m_accessibility */ 9130);
                var _m_columns_view = __webpack_require__( /*! ../views/m_columns_view */ 57318);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _slicedToArray(arr, i) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return arr
                        }
                    }(arr) || function(arr, i) {
                        var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
                        if (null != _i) {
                            var _s, _e, _x, _r, _arr = [],
                                _n = !0,
                                _d = !1;
                            try {
                                if (_x = (_i = _i.call(arr)).next, 0 === i) {
                                    if (Object(_i) !== _i) {
                                        return
                                    }
                                    _n = !1
                                } else {
                                    for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0) {}
                                }
                            } catch (err) {
                                _d = !0, _e = err
                            } finally {
                                try {
                                    if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) {
                                        return
                                    }
                                } finally {
                                    if (_d) {
                                        throw _e
                                    }
                                }
                            }
                            return _arr
                        }
                    }(arr, i) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr, i) || function() {
                        throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var columnHeadersModule = {
                    defaultOptions: function() {
                        return {
                            showColumnHeaders: true,
                            cellHintEnabled: true
                        }
                    },
                    views: {
                        columnHeadersView: _m_columns_view.ColumnsView.inherit(function() {
                            var createCellContent = function(that, $cell, options) {
                                var $cellContent = (0, _renderer.default)("<div>").addClass(that.addWidgetPrefix("text-content"));
                                that.setAria("role", "presentation", $cellContent);
                                addCssClassesToCellContent(that, $cell, options.column, $cellContent);
                                var showColumnLines = that.option("showColumnLines");
                                var contentAlignment = that.getController("columns").getHeaderContentAlignment(options.column.alignment);
                                return $cellContent[showColumnLines || "right" === contentAlignment ? "appendTo" : "prependTo"]($cell)
                            };

                            function addCssClassesToCellContent(that, $cell, column, $cellContent) {
                                var $indicatorElements = that._getIndicatorElements($cell, true);
                                var $visibleIndicatorElements = that._getIndicatorElements($cell);
                                var indicatorCount = $indicatorElements && $indicatorElements.length;
                                var columnAlignment = that._getColumnAlignment(column.alignment);
                                var sortIndicatorClassName = ".".concat(that._getIndicatorClassName("sort"));
                                var sortIndexIndicatorClassName = ".".concat(that._getIndicatorClassName("sortIndex"));
                                var $sortIndicator = $visibleIndicatorElements.filter(sortIndicatorClassName);
                                var $sortIndexIndicator = $visibleIndicatorElements.children().filter(sortIndexIndicatorClassName);
                                $cellContent = $cellContent || $cell.children(".".concat(that.addWidgetPrefix("text-content")));
                                $cellContent.toggleClass("dx-text-content-alignment-" + columnAlignment, indicatorCount > 0).toggleClass("dx-text-content-alignment-" + ("left" === columnAlignment ? "right" : "left"), indicatorCount > 0 && "center" === column.alignment).toggleClass("dx-sort-indicator", !!$sortIndicator.length).toggleClass("dx-sort-index-indicator", !!$sortIndexIndicator.length).toggleClass("dx-header-filter-indicator", !!$visibleIndicatorElements.filter(".".concat(that._getIndicatorClassName("headerFilter"))).length)
                            }
                            var members = {
                                _createTable: function() {
                                    var $table = this.callBase.apply(this, arguments);
                                    _events_engine.default.on($table, "mousedown selectstart", this.createAction((function(e) {
                                        var event = e.event;
                                        if (event.shiftKey) {
                                            event.preventDefault()
                                        }
                                    })));
                                    return $table
                                },
                                _isLegacyKeyboardNavigation: function() {
                                    return this.option("useLegacyKeyboardNavigation")
                                },
                                _getDefaultTemplate: function(column) {
                                    var that = this;
                                    return function($container, options) {
                                        var caption = column.caption;
                                        var needCellContent = !column.command || caption && "expand" !== column.command;
                                        if ("empty" === column.command) {
                                            that._renderEmptyMessage($container, options)
                                        } else if (needCellContent) {
                                            var $content = createCellContent(that, $container, options);
                                            $content.text(caption)
                                        } else if (column.command) {
                                            $container.html("&nbsp;")
                                        }
                                    }
                                },
                                _renderEmptyMessage: function($container, options) {
                                    var textEmpty = this._getEmptyHeaderText();
                                    if (!textEmpty) {
                                        $container.html("&nbsp;");
                                        return
                                    }
                                    var $cellContent = createCellContent(this, $container, options);
                                    var needSplit = textEmpty.includes("{0}");
                                    if (needSplit) {
                                        var _textEmpty$split = textEmpty.split("{0}"),
                                            _textEmpty$split2 = _slicedToArray(_textEmpty$split, 2),
                                            leftPart = _textEmpty$split2[0],
                                            rightPart = _textEmpty$split2[1];
                                        var columnChooserTitle = _message.default.format("dxDataGrid-emptyHeaderColumnChooserText");
                                        var columnChooserView = this.component.getView("columnChooserView");
                                        var $link = (0, _renderer.default)("<a>").text(columnChooserTitle).addClass("dx-link");
                                        _events_engine.default.on($link, "click", this.createAction((function() {
                                            return columnChooserView.showColumnChooser()
                                        })));
                                        $cellContent.append(_dom_adapter.default.createTextNode(leftPart)).append($link).append(_dom_adapter.default.createTextNode(rightPart))
                                    } else {
                                        $cellContent.text(textEmpty)
                                    }
                                },
                                _getEmptyHeaderText: function() {
                                    var hasHiddenColumns = !!this.component.getView("columnChooserView").hasHiddenColumns();
                                    var hasGroupedColumns = !!this.component.getView("headerPanel").hasGroupedColumns();
                                    switch (true) {
                                        case hasHiddenColumns && hasGroupedColumns:
                                            return _message.default.format("dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText");
                                        case hasGroupedColumns:
                                            return _message.default.format("dxDataGrid-emptyHeaderWithGroupPanelText");
                                        case hasHiddenColumns:
                                            return _message.default.format("dxDataGrid-emptyHeaderWithColumnChooserText");
                                        default:
                                            return ""
                                    }
                                },
                                _getHeaderTemplate: function(column) {
                                    return column.headerCellTemplate || {
                                        allowRenderToDetachedContainer: true,
                                        render: this._getDefaultTemplate(column)
                                    }
                                },
                                _processTemplate: function(template, options) {
                                    var that = this;
                                    var resultTemplate;
                                    var column = options.column;
                                    var renderingTemplate = that.callBase(template);
                                    if ("header" === options.rowType && renderingTemplate && column.headerCellTemplate && !column.command) {
                                        resultTemplate = {
                                            render: function(options) {
                                                var $content = createCellContent(that, options.container, options.model);
                                                renderingTemplate.render((0, _extend.extend)({}, options, {
                                                    container: $content
                                                }))
                                            }
                                        }
                                    } else {
                                        resultTemplate = renderingTemplate
                                    }
                                    return resultTemplate
                                },
                                _handleDataChanged: function(e) {
                                    if ("refresh" !== e.changeType) {
                                        return
                                    }
                                    if (this._isGroupingChanged || this._requireReady) {
                                        this._isGroupingChanged = false;
                                        this.render()
                                    }
                                },
                                _renderCell: function($row, options) {
                                    var $cell = this.callBase($row, options);
                                    if ("header" === options.row.rowType) {
                                        $cell.addClass("dx-cell-focus-disabled");
                                        if (!this._isLegacyKeyboardNavigation()) {
                                            if (options.column && !options.column.type) {
                                                $cell.attr("tabindex", this.option("tabindex") || 0)
                                            }
                                        }
                                    }
                                    return $cell
                                },
                                _setCellAriaAttributes: function($cell, cellOptions) {
                                    this.callBase($cell, cellOptions);
                                    if ("header" === cellOptions.rowType) {
                                        if (!cellOptions.column.type) {
                                            this.setAria("role", "columnheader", $cell)
                                        }
                                        if (cellOptions.column && !cellOptions.column.command && !cellOptions.column.isBand) {
                                            $cell.attr("id", cellOptions.column.headerId);
                                            this.setAria("label", "".concat(_message.default.format("dxDataGrid-ariaColumn"), " ").concat(cellOptions.column.caption), $cell)
                                        }
                                    }
                                },
                                _createRow: function(row) {
                                    var $row = this.callBase.apply(this, arguments);
                                    $row.toggleClass("dx-column-lines", this.option("showColumnLines"));
                                    if ("header" === row.rowType) {
                                        $row.addClass("dx-header-row");
                                        if (!this._isLegacyKeyboardNavigation()) {
                                            (0, _m_accessibility.registerKeyboardAction)("columnHeaders", this, $row, "td", this._handleActionKeyDown.bind(this))
                                        }
                                    }
                                    return $row
                                },
                                _handleActionKeyDown: function(args) {
                                    var event = args.event;
                                    var $target = (0, _renderer.default)(event.target);
                                    this._lastActionElement = event.target;
                                    if ($target.is(".dx-header-filter")) {
                                        var headerFilterController = this.getController("headerFilter");
                                        var $column = $target.closest("td");
                                        var columnIndex = this.getColumnIndexByElement($column);
                                        if (columnIndex >= 0) {
                                            headerFilterController.showHeaderFilterMenu(columnIndex, false)
                                        }
                                    } else {
                                        var $row = $target.closest(".dx-row");
                                        this._processHeaderAction(event, $row)
                                    }
                                    event.preventDefault()
                                },
                                _renderCore: function() {
                                    var that = this;
                                    var $container = that.element();
                                    var change = {};
                                    if (that._tableElement && !that._dataController.isLoaded() && !that._hasRowElements) {
                                        return
                                    }
                                    $container.addClass(that.addWidgetPrefix("headers")).toggleClass(that.addWidgetPrefix("nowrap"), !that.option("wordWrapEnabled")).empty();
                                    that.setAria("role", "presentation", $container);
                                    var deferred = that._updateContent(that._renderTable({
                                        change: change
                                    }), change);
                                    if (that.getRowCount() > 1) {
                                        $container.addClass("dx-header-multi-row")
                                    }
                                    that.callBase.apply(that, arguments);
                                    return deferred
                                },
                                _renderRows: function() {
                                    var that = this;
                                    if (that._dataController.isLoaded() || that._hasRowElements) {
                                        that.callBase.apply(that, arguments);
                                        that._hasRowElements = true
                                    }
                                },
                                _renderRow: function($table, options) {
                                    var rowIndex = 1 === this.getRowCount() ? null : options.row.rowIndex;
                                    options.columns = this.getColumns(rowIndex);
                                    this.callBase($table, options)
                                },
                                _createCell: function(options) {
                                    var column = options.column;
                                    var $cellElement = this.callBase.apply(this, arguments);
                                    column.rowspan > 1 && "header" === options.rowType && $cellElement.attr("rowSpan", column.rowspan);
                                    return $cellElement
                                },
                                _getRows: function() {
                                    var result = [];
                                    var rowCount = this.getRowCount();
                                    if (this.option("showColumnHeaders")) {
                                        for (var i = 0; i < rowCount; i++) {
                                            result.push({
                                                rowType: "header",
                                                rowIndex: i
                                            })
                                        }
                                    }
                                    return result
                                },
                                _getCellTemplate: function(options) {
                                    if ("header" === options.rowType) {
                                        return this._getHeaderTemplate(options.column)
                                    }
                                },
                                _columnOptionChanged: function(e) {
                                    var changeTypes = e.changeTypes;
                                    var optionNames = e.optionNames;
                                    if (changeTypes.grouping || changeTypes.groupExpanding) {
                                        if (changeTypes.grouping) {
                                            this._isGroupingChanged = true
                                        }
                                        return
                                    }
                                    this.callBase(e);
                                    if (optionNames.width || optionNames.visible) {
                                        this.resizeCompleted.fire()
                                    }
                                },
                                _isElementVisible: function(elementOptions) {
                                    return elementOptions && elementOptions.visible
                                },
                                _alignCaptionByCenter: function($cell) {
                                    var $indicatorsContainer = this._getIndicatorContainer($cell, true);
                                    if ($indicatorsContainer && $indicatorsContainer.length) {
                                        $indicatorsContainer.filter(".".concat("dx-visibility-hidden")).remove();
                                        $indicatorsContainer = this._getIndicatorContainer($cell);
                                        $indicatorsContainer.clone().addClass("dx-visibility-hidden").css("float", "").insertBefore($cell.children(".".concat(this.addWidgetPrefix("text-content"))))
                                    }
                                },
                                _updateCell: function($cell, options) {
                                    if ("header" === options.rowType && "center" === options.column.alignment) {
                                        this._alignCaptionByCenter($cell)
                                    }
                                    this.callBase.apply(this, arguments)
                                },
                                _updateIndicator: function($cell, column, indicatorName) {
                                    var $indicatorElement = this.callBase.apply(this, arguments);
                                    if ("center" === column.alignment) {
                                        this._alignCaptionByCenter($cell)
                                    }
                                    addCssClassesToCellContent(this, $cell, column);
                                    return $indicatorElement
                                },
                                _getIndicatorContainer: function($cell, returnAll) {
                                    var $indicatorsContainer = this.callBase($cell);
                                    return returnAll ? $indicatorsContainer : $indicatorsContainer.filter(":not(.".concat("dx-visibility-hidden", ")"))
                                },
                                _isSortableElement: function() {
                                    return true
                                },
                                getHeadersRowHeight: function() {
                                    var $tableElement = this.getTableElement();
                                    var $headerRows = $tableElement && $tableElement.find(".".concat("dx-header-row"));
                                    return $headerRows && $headerRows.toArray().reduce((function(sum, headerRow) {
                                        return sum + (0, _size.getHeight)(headerRow)
                                    }), 0) || 0
                                },
                                getHeaderElement: function(index) {
                                    var columnElements = this.getColumnElements();
                                    return columnElements && columnElements.eq(index)
                                },
                                getColumnElements: function(index, bandColumnIndex) {
                                    var that = this;
                                    var $cellElement;
                                    var columnsController = that._columnsController;
                                    var rowCount = that.getRowCount();
                                    if (that.option("showColumnHeaders")) {
                                        if (rowCount > 1 && (!(0, _type.isDefined)(index) || (0, _type.isDefined)(bandColumnIndex))) {
                                            var result = [];
                                            var visibleColumns = (0, _type.isDefined)(bandColumnIndex) ? columnsController.getChildrenByBandColumn(bandColumnIndex, true) : columnsController.getVisibleColumns();
                                            (0, _iterator.each)(visibleColumns, (function(_, column) {
                                                var rowIndex = (0, _type.isDefined)(index) ? index : columnsController.getRowIndex(column.index);
                                                $cellElement = that._getCellElement(rowIndex, columnsController.getVisibleIndex(column.index, rowIndex));
                                                $cellElement && result.push($cellElement.get(0))
                                            }));
                                            return (0, _renderer.default)(result)
                                        }
                                        if (!index || index < rowCount) {
                                            return that.getCellElements(index || 0)
                                        }
                                    }
                                },
                                getColumnIndexByElement: function($cell) {
                                    var cellIndex = this.getCellIndex($cell);
                                    var $row = $cell.closest(".dx-row");
                                    var rowIndex = $row[0].rowIndex;
                                    var column = this.getColumns(rowIndex)[cellIndex];
                                    return column ? column.index : -1
                                },
                                getVisibleColumnIndex: function(columnIndex, rowIndex) {
                                    var column = this.getColumns()[columnIndex];
                                    return column ? this._columnsController.getVisibleIndex(column.index, rowIndex) : -1
                                },
                                getColumnWidths: function() {
                                    var $columnElements = this.getColumnElements();
                                    if ($columnElements && $columnElements.length) {
                                        return this._getWidths($columnElements)
                                    }
                                    return this.callBase.apply(this, arguments)
                                },
                                allowDragging: function(column) {
                                    var rowIndex = column && this._columnsController.getRowIndex(column.index);
                                    var columns = this.getColumns(rowIndex);
                                    var isReorderingEnabled = this.option("allowColumnReordering") || this._columnsController.isColumnOptionUsed("allowReordering");
                                    return isReorderingEnabled && column.allowReordering && columns.length > 1
                                },
                                getBoundingRect: function() {
                                    var $columnElements = this.getColumnElements();
                                    if ($columnElements && $columnElements.length) {
                                        var offset = this.getTableElement().offset();
                                        return {
                                            top: offset.top
                                        }
                                    }
                                    return null
                                },
                                getName: function() {
                                    return "headers"
                                },
                                getColumnCount: function() {
                                    var $columnElements = this.getColumnElements();
                                    return $columnElements ? $columnElements.length : 0
                                },
                                isVisible: function() {
                                    return this.option("showColumnHeaders")
                                },
                                optionChanged: function(args) {
                                    switch (args.name) {
                                        case "showColumnHeaders":
                                        case "wordWrapEnabled":
                                        case "showColumnLines":
                                            this._invalidate(true, true);
                                            args.handled = true;
                                            break;
                                        default:
                                            this.callBase(args)
                                    }
                                },
                                getHeight: function() {
                                    return this.getElementHeight()
                                },
                                getContextMenuItems: function(options) {
                                    var that = this;
                                    var column = options.column;
                                    if (options.row && ("header" === options.row.rowType || "detailAdaptive" === options.row.rowType)) {
                                        var sortingOptions = that.option("sorting");
                                        if (sortingOptions && "none" !== sortingOptions.mode && column && column.allowSorting) {
                                            var onItemClick = function(params) {
                                                setTimeout((function() {
                                                    that._columnsController.changeSortOrder(column.index, params.itemData.value)
                                                }))
                                            };
                                            return [{
                                                text: sortingOptions.ascendingText,
                                                value: "asc",
                                                disabled: "asc" === column.sortOrder,
                                                icon: "context-menu-sort-asc",
                                                onItemClick: onItemClick
                                            }, {
                                                text: sortingOptions.descendingText,
                                                value: "desc",
                                                disabled: "desc" === column.sortOrder,
                                                icon: "context-menu-sort-desc",
                                                onItemClick: onItemClick
                                            }, {
                                                text: sortingOptions.clearText,
                                                value: "none",
                                                disabled: !column.sortOrder,
                                                icon: "context-menu-sort-none",
                                                onItemClick: onItemClick
                                            }]
                                        }
                                    }
                                    return
                                },
                                getRowCount: function() {
                                    return this._columnsController && this._columnsController.getRowCount()
                                },
                                setRowsOpacity: function(columnIndex, value, rowIndex) {
                                    var _this = this;
                                    var i;
                                    var columnElements;
                                    var rowCount = this.getRowCount();
                                    var columns = this._columnsController.getColumns();
                                    var column = columns && columns[columnIndex];
                                    var columnID = column && column.isBand && column.index;
                                    var setColumnOpacity = function(column, index) {
                                        if (column.ownerBand === columnID) {
                                            columnElements.eq(index).css({
                                                opacity: value
                                            });
                                            if (column.isBand) {
                                                _this.setRowsOpacity(column.index, value, i + 1)
                                            }
                                        }
                                    };
                                    if ((0, _type.isDefined)(columnID)) {
                                        rowIndex = rowIndex || 0;
                                        for (i = rowIndex; i < rowCount; i++) {
                                            columnElements = this.getCellElements(i);
                                            if (columnElements) {
                                                var rowColumns = this.getColumns(i);
                                                rowColumns.forEach(setColumnOpacity)
                                            }
                                        }
                                    }
                                }
                            };
                            return members
                        }())
                    }
                };
                exports.columnHeadersModule = columnHeadersModule
            },
        51255:
            /*!*******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/column_state_mixin/m_column_state_mixin.js ***!
              \*******************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../../../../core/renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _position = __webpack_require__( /*! ../../../../core/utils/position */ 37518);
                var _default = {
                    _applyColumnState: function(options) {
                        var _a;
                        var rtlEnabled = this.option("rtlEnabled");
                        var columnAlignment = this._getColumnAlignment(options.column.alignment, rtlEnabled);
                        var parameters = (0, _extend.extend)(true, {
                            columnAlignment: columnAlignment
                        }, options);
                        var isGroupPanelItem = parameters.rootElement.hasClass("dx-group-panel-item");
                        var $indicatorsContainer = this._createIndicatorContainer(parameters, isGroupPanelItem);
                        var $span = (0, _renderer.default)("<span>").addClass(this._getIndicatorClassName(options.name));
                        var columnsController = null === (_a = this.component) || void 0 === _a ? void 0 : _a.getController("columns");
                        var indicatorAlignment = (null === columnsController || void 0 === columnsController ? void 0 : columnsController.getHeaderContentAlignment(columnAlignment)) || columnAlignment;
                        parameters.container = $indicatorsContainer;
                        parameters.indicator = $span;
                        this._renderIndicator(parameters);
                        $indicatorsContainer[(isGroupPanelItem || !options.showColumnLines) && "left" === indicatorAlignment ? "appendTo" : "prependTo"](options.rootElement);
                        return $span
                    },
                    _getIndicatorClassName: _common.noop,
                    _getColumnAlignment: function(alignment, rtlEnabled) {
                        rtlEnabled = rtlEnabled || this.option("rtlEnabled");
                        return alignment && "center" !== alignment ? alignment : (0, _position.getDefaultAlignment)(rtlEnabled)
                    },
                    _createIndicatorContainer: function(options, ignoreIndicatorAlignment) {
                        var $indicatorsContainer = this._getIndicatorContainer(options.rootElement);
                        var indicatorAlignment = "left" === options.columnAlignment ? "right" : "left";
                        if (!$indicatorsContainer.length) {
                            $indicatorsContainer = (0, _renderer.default)("<div>").addClass("dx-column-indicators")
                        }
                        this.setAria("role", "presentation", $indicatorsContainer);
                        return $indicatorsContainer.css("float", options.showColumnLines && !ignoreIndicatorAlignment ? indicatorAlignment : null)
                    },
                    _getIndicatorContainer: function($cell) {
                        return $cell && $cell.find(".".concat("dx-column-indicators"))
                    },
                    _getIndicatorElements: function($cell) {
                        var $indicatorContainer = this._getIndicatorContainer($cell);
                        return $indicatorContainer && $indicatorContainer.children()
                    },
                    _renderIndicator: function(options) {
                        var $container = options.container;
                        var $indicator = options.indicator;
                        $container && $indicator && $container.append($indicator)
                    },
                    _updateIndicators: function(indicatorName) {
                        var columns = this.getColumns();
                        var $cells = this.getColumnElements();
                        var $cell;
                        if (!$cells || columns.length !== $cells.length) {
                            return
                        }
                        for (var i = 0; i < columns.length; i++) {
                            $cell = $cells.eq(i);
                            this._updateIndicator($cell, columns[i], indicatorName);
                            var rowOptions = $cell.parent().data("options");
                            if (rowOptions && rowOptions.cells) {
                                rowOptions.cells[$cell.index()].column = columns[i]
                            }
                        }
                    },
                    _updateIndicator: function($cell, column, indicatorName) {
                        if (!column.command) {
                            return this._applyColumnState({
                                name: indicatorName,
                                rootElement: $cell,
                                column: column,
                                showColumnLines: this.option("showColumnLines")
                            })
                        }
                    }
                };
                exports.default = _default
            },
        54057:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/columns_controller/const.js ***!
              \****************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.USER_STATE_FIELD_NAMES_15_1 = exports.USER_STATE_FIELD_NAMES = exports.MAX_SAFE_INTEGER = exports.IGNORE_COLUMN_OPTION_NAMES = exports.GROUP_LOCATION = exports.GROUP_COMMAND_COLUMN_NAME = exports.DETAIL_COMMAND_COLUMN_NAME = exports.DEFAULT_COLUMN_OPTIONS = exports.DATATYPE_OPERATIONS = exports.COMMAND_EXPAND_CLASS = exports.COLUMN_OPTION_REGEXP = exports.COLUMN_INDEX_OPTIONS = exports.COLUMN_CHOOSER_LOCATION = void 0;
                var USER_STATE_FIELD_NAMES_15_1 = ["filterValues", "filterType", "fixed", "fixedPosition"];
                exports.USER_STATE_FIELD_NAMES_15_1 = USER_STATE_FIELD_NAMES_15_1;
                var USER_STATE_FIELD_NAMES = ["visibleIndex", "dataField", "name", "dataType", "width", "visible", "sortOrder", "lastSortOrder", "sortIndex", "groupIndex", "filterValue", "bufferedFilterValue", "selectedFilterOperation", "bufferedSelectedFilterOperation", "added"].concat(USER_STATE_FIELD_NAMES_15_1);
                exports.USER_STATE_FIELD_NAMES = USER_STATE_FIELD_NAMES;
                exports.IGNORE_COLUMN_OPTION_NAMES = {
                    visibleWidth: true,
                    bestFitWidth: true,
                    bufferedFilterValue: true
                };
                exports.COMMAND_EXPAND_CLASS = "dx-command-expand";
                var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
                exports.MAX_SAFE_INTEGER = MAX_SAFE_INTEGER;
                exports.GROUP_COMMAND_COLUMN_NAME = "groupExpand";
                exports.DETAIL_COMMAND_COLUMN_NAME = "detailExpand";
                exports.COLUMN_OPTION_REGEXP = /columns\[(\d+)\]\.?/gi;
                exports.DEFAULT_COLUMN_OPTIONS = {
                    visible: true,
                    showInColumnChooser: true
                };
                exports.DATATYPE_OPERATIONS = {
                    number: ["=", "<>", "<", ">", "<=", ">=", "between"],
                    string: ["contains", "notcontains", "startswith", "endswith", "=", "<>"],
                    date: ["=", "<>", "<", ">", "<=", ">=", "between"],
                    datetime: ["=", "<>", "<", ">", "<=", ">=", "between"]
                };
                exports.COLUMN_INDEX_OPTIONS = {
                    visibleIndex: true,
                    groupIndex: true,
                    grouped: true,
                    sortIndex: true,
                    sortOrder: true
                };
                exports.GROUP_LOCATION = "group";
                exports.COLUMN_CHOOSER_LOCATION = "columnChooser"
            },
        10279:
            /*!*******************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/columns_controller/m_columns_controller.js ***!
              \*******************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnsControllerModule = exports.ColumnsController = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../../../core/config */ 80209));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/callbacks */ 44504));
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _inflector = __webpack_require__( /*! ../../../../core/utils/inflector */ 78008);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _object = __webpack_require__( /*! ../../../../core/utils/object */ 48013);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/variable_wrapper */ 26974));
                var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ../../../../data/abstract_store */ 67403));
                var _data_source = __webpack_require__( /*! ../../../../data/data_source/data_source */ 85273);
                var _utils = __webpack_require__( /*! ../../../../data/data_source/utils */ 9234);
                var _date = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/date */ 91500));
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _filtering = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/shared/filtering */ 18740));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));
                var _const = __webpack_require__( /*! ./const */ 54057);
                var _m_columns_controller_utils = __webpack_require__( /*! ./m_columns_controller_utils */ 22732);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var ColumnsController = function(_modules$Controller) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(ColumnsController, _modules$Controller);

                    function ColumnsController() {
                        return _modules$Controller.apply(this, arguments) || this
                    }
                    var _proto = ColumnsController.prototype;
                    _proto._getExpandColumnOptions = function() {
                        return {
                            type: "expand",
                            command: "expand",
                            width: "auto",
                            cssClass: _const.COMMAND_EXPAND_CLASS,
                            allowEditing: false,
                            allowGrouping: false,
                            allowSorting: false,
                            allowResizing: false,
                            allowReordering: false,
                            allowHiding: false
                        }
                    };
                    _proto._getFirstItems = function(dataSource) {
                        var groupsCount;
                        var items = [];
                        if (dataSource && dataSource.items().length > 0) {
                            groupsCount = _m_utils.default.normalizeSortingInfo(dataSource.group()).length;
                            items = function getFirstItemsCore(items, groupsCount) {
                                if (!items || !groupsCount) {
                                    return items
                                }
                                for (var i = 0; i < items.length; i++) {
                                    var childItems = getFirstItemsCore(items[i].items || items[i].collapsedItems, groupsCount - 1);
                                    if (childItems && childItems.length) {
                                        return childItems
                                    }
                                }
                            }(dataSource.items(), groupsCount) || []
                        }
                        return items
                    };
                    _proto._endUpdateCore = function() {
                        !this._skipProcessingColumnsChange && (0, _m_columns_controller_utils.fireColumnsChanged)(this)
                    };
                    _proto.init = function(isApplyingUserState) {
                        var columns = this.option("columns");
                        this._commandColumns = this._commandColumns || [];
                        this._columns = this._columns || [];
                        this._isColumnsFromOptions = !!columns;
                        if (this._isColumnsFromOptions) {
                            (0, _m_columns_controller_utils.assignColumns)(this, columns ? (0, _m_columns_controller_utils.createColumnsFromOptions)(this, columns) : []);
                            (0, _m_columns_controller_utils.applyUserState)(this)
                        } else {
                            (0, _m_columns_controller_utils.assignColumns)(this, this._columnsUserState ? (0, _m_columns_controller_utils.createColumnsFromOptions)(this, this._columnsUserState) : this._columns)
                        }(0, _m_columns_controller_utils.addExpandColumn)(this);
                        if (this._dataSourceApplied) {
                            this.applyDataSource(this._dataSource, true, isApplyingUserState)
                        } else {
                            (0, _m_columns_controller_utils.updateIndexes)(this)
                        }
                        this._checkColumns()
                    };
                    _proto.callbackNames = function() {
                        return ["columnsChanged"]
                    };
                    _proto.getColumnByPath = function(path, columns) {
                        var column;
                        var columnIndexes = [];
                        path.replace(_const.COLUMN_OPTION_REGEXP, (function(_, columnIndex) {
                            columnIndexes.push(parseInt(columnIndex));
                            return ""
                        }));
                        if (columnIndexes.length) {
                            if (columns) {
                                column = columnIndexes.reduce((function(column, index) {
                                    return column && column.columns && column.columns[index]
                                }), {
                                    columns: columns
                                })
                            } else {
                                column = (0, _m_columns_controller_utils.getColumnByIndexes)(this, columnIndexes)
                            }
                        }
                        return column
                    };
                    _proto.optionChanged = function(args) {
                        var needUpdateRequireResize;
                        switch (args.name) {
                            case "adaptColumnWidthByRatio":
                                args.handled = true;
                                break;
                            case "dataSource":
                                if (args.value !== args.previousValue && !this.option("columns") && (!Array.isArray(args.value) || !Array.isArray(args.previousValue))) {
                                    this._columns = []
                                }
                                break;
                            case "columns":
                                needUpdateRequireResize = this._skipProcessingColumnsChange;
                                args.handled = true;
                                if (!this._skipProcessingColumnsChange) {
                                    if (args.name === args.fullName) {
                                        this._columnsUserState = null;
                                        this._ignoreColumnOptionNames = null;
                                        this.init()
                                    } else {
                                        this._columnOptionChanged(args);
                                        needUpdateRequireResize = true
                                    }
                                }
                                if (needUpdateRequireResize) {
                                    this._updateRequireResize(args)
                                }
                                break;
                            case "commonColumnSettings":
                            case "columnAutoWidth":
                            case "allowColumnResizing":
                            case "allowColumnReordering":
                            case "columnFixing":
                            case "grouping":
                            case "groupPanel":
                            case "regenerateColumnsByVisibleItems":
                            case "customizeColumns":
                            case "columnHidingEnabled":
                            case "dateSerializationFormat":
                            case "columnResizingMode":
                            case "columnMinWidth":
                            case "columnWidth":
                                args.handled = true;
                                var ignoreColumnOptionNames = "columnWidth" === args.fullName && ["width"];
                                this.reinit(ignoreColumnOptionNames);
                                break;
                            case "rtlEnabled":
                                this.reinit();
                                break;
                            default:
                                _modules$Controller.prototype.optionChanged.call(this, args)
                        }
                    };
                    _proto._columnOptionChanged = function(args) {
                        var columnOptionValue = {};
                        var column = this.getColumnByPath(args.fullName);
                        var columnOptionName = args.fullName.replace(_const.COLUMN_OPTION_REGEXP, "");
                        if (column) {
                            if (columnOptionName) {
                                columnOptionValue[columnOptionName] = args.value
                            } else {
                                columnOptionValue = args.value
                            }
                            this._skipProcessingColumnsChange = args.fullName;
                            this.columnOption(column.index, columnOptionValue);
                            this._skipProcessingColumnsChange = false
                        }
                    };
                    _proto._updateRequireResize = function(args) {
                        var component = this.component;
                        if ("width" === args.fullName.replace(_const.COLUMN_OPTION_REGEXP, "") && component._updateLockCount) {
                            component._requireResize = true
                        }
                    };
                    _proto.publicMethods = function() {
                        return ["addColumn", "deleteColumn", "columnOption", "columnCount", "clearSorting", "clearGrouping", "getVisibleColumns", "getVisibleColumnIndex"]
                    };
                    _proto.applyDataSource = function(dataSource, forceApplying, isApplyingUserState) {
                        var isDataSourceLoaded = dataSource && dataSource.isLoaded();
                        this._dataSource = dataSource;
                        if (!this._dataSourceApplied || 0 === this._dataSourceColumnsCount || forceApplying || this.option("regenerateColumnsByVisibleItems")) {
                            if (isDataSourceLoaded) {
                                if (!this._isColumnsFromOptions) {
                                    var columnsFromDataSource = (0, _m_columns_controller_utils.createColumnsFromDataSource)(this, dataSource);
                                    if (columnsFromDataSource.length) {
                                        (0, _m_columns_controller_utils.assignColumns)(this, columnsFromDataSource);
                                        this._dataSourceColumnsCount = this._columns.length;
                                        (0, _m_columns_controller_utils.applyUserState)(this)
                                    }
                                }
                                return this.updateColumns(dataSource, forceApplying, isApplyingUserState)
                            }
                            this._dataSourceApplied = false;
                            (0, _m_columns_controller_utils.updateIndexes)(this)
                        } else if (isDataSourceLoaded && !this.isAllDataTypesDefined(true) && this.updateColumnDataTypes(dataSource)) {
                            (0, _m_columns_controller_utils.updateColumnChanges)(this, "columns");
                            (0, _m_columns_controller_utils.fireColumnsChanged)(this);
                            return (new _deferred.Deferred).reject().promise()
                        }
                    };
                    _proto.reset = function() {
                        this._dataSource = null;
                        this._dataSourceApplied = false;
                        this._dataSourceColumnsCount = void 0;
                        this.reinit()
                    };
                    _proto.resetColumnsCache = function() {
                        this._visibleColumns = void 0;
                        this._fixedColumns = void 0;
                        this._rowCount = void 0;
                        (0, _m_columns_controller_utils.resetBandColumnsCache)(this)
                    };
                    _proto.reinit = function(ignoreColumnOptionNames) {
                        this._columnsUserState = this.getUserState();
                        this._ignoreColumnOptionNames = ignoreColumnOptionNames || null;
                        this.init();
                        if (ignoreColumnOptionNames) {
                            this._ignoreColumnOptionNames = null
                        }
                    };
                    _proto.isInitialized = function() {
                        return !!this._columns.length || !!this.option("columns")
                    };
                    _proto.isDataSourceApplied = function() {
                        return this._dataSourceApplied
                    };
                    _proto.getCommonSettings = function(column) {
                        var _a, _b;
                        var commonColumnSettings = (!column || !column.type) && this.option("commonColumnSettings") || {};
                        var groupingOptions = null !== (_a = this.option("grouping")) && void 0 !== _a ? _a : {};
                        var groupPanelOptions = null !== (_b = this.option("groupPanel")) && void 0 !== _b ? _b : {};
                        return (0, _extend.extend)({
                            allowFixing: this.option("columnFixing.enabled"),
                            allowResizing: this.option("allowColumnResizing") || void 0,
                            allowReordering: this.option("allowColumnReordering"),
                            minWidth: this.option("columnMinWidth"),
                            width: this.option("columnWidth"),
                            autoExpandGroup: groupingOptions.autoExpandAll,
                            allowCollapsing: groupingOptions.allowCollapsing,
                            allowGrouping: groupPanelOptions.allowColumnDragging && groupPanelOptions.visible || groupingOptions.contextMenuEnabled
                        }, commonColumnSettings)
                    };
                    _proto.isColumnOptionUsed = function(optionName) {
                        for (var i = 0; i < this._columns.length; i++) {
                            if (this._columns[i][optionName]) {
                                return true
                            }
                        }
                    };
                    _proto.isAllDataTypesDefined = function(checkSerializers) {
                        var columns = this._columns;
                        if (!columns.length) {
                            return false
                        }
                        for (var i = 0; i < columns.length; i++) {
                            if (!columns[i].dataField && columns[i].calculateCellValue === columns[i].defaultCalculateCellValue) {
                                continue
                            }
                            if (!columns[i].dataType || checkSerializers && columns[i].deserializeValue && void 0 === columns[i].serializationFormat) {
                                return false
                            }
                        }
                        return true
                    };
                    _proto.getColumns = function() {
                        return this._columns
                    };
                    _proto.isBandColumnsUsed = function() {
                        return this.getColumns().some((function(column) {
                            return column.isBand
                        }))
                    };
                    _proto.getGroupColumns = function() {
                        var result = [];
                        (0, _iterator.each)(this._columns, (function() {
                            if ((0, _type.isDefined)(this.groupIndex)) {
                                result[this.groupIndex] = this
                            }
                        }));
                        return result
                    };
                    _proto._shouldReturnVisibleColumns = function() {
                        return true
                    };
                    _proto._compileVisibleColumns = function(rowIndex) {
                        this._visibleColumns = this._visibleColumns || this._compileVisibleColumnsCore();
                        rowIndex = (0, _type.isDefined)(rowIndex) ? rowIndex : this._visibleColumns.length - 1;
                        return this._visibleColumns[rowIndex] || []
                    };
                    _proto.getVisibleColumns = function(rowIndex, isBase) {
                        if (!this._shouldReturnVisibleColumns()) {
                            return []
                        }
                        return this._compileVisibleColumns.apply(this, arguments)
                    };
                    _proto.getFixedColumns = function(rowIndex) {
                        this._fixedColumns = this._fixedColumns || this._getFixedColumnsCore();
                        rowIndex = (0, _type.isDefined)(rowIndex) ? rowIndex : this._fixedColumns.length - 1;
                        return this._fixedColumns[rowIndex] || []
                    };
                    _proto.getFilteringColumns = function() {
                        return this.getColumns().filter((function(item) {
                            return (item.dataField || item.name) && (item.allowFiltering || item.allowHeaderFiltering)
                        })).map((function(item) {
                            var field = (0, _extend.extend)(true, {}, item);
                            if (!(0, _type.isDefined)(field.dataField)) {
                                field.dataField = field.name
                            }
                            field.filterOperations = item.filterOperations !== item.defaultFilterOperations ? field.filterOperations : null;
                            return field
                        }))
                    };
                    _proto.getColumnIndexOffset = function() {
                        return 0
                    };
                    _proto._getFixedColumnsCore = function() {
                        var result = [];
                        var rowCount = this.getRowCount();
                        var isColumnFixing = this._isColumnFixing();
                        var transparentColumn = {
                            command: "transparent"
                        };
                        var transparentColspan = 0;
                        var notFixedColumnCount;
                        var transparentColumnIndex;
                        var lastFixedPosition;
                        if (isColumnFixing) {
                            for (var i = 0; i <= rowCount; i++) {
                                notFixedColumnCount = 0;
                                lastFixedPosition = null;
                                transparentColumnIndex = null;
                                var visibleColumns = this.getVisibleColumns(i, true);
                                for (var j = 0; j < visibleColumns.length; j++) {
                                    var prevColumn = visibleColumns[j - 1];
                                    var column = visibleColumns[j];
                                    if (!column.fixed) {
                                        if (0 === i) {
                                            if (column.isBand && column.colspan) {
                                                transparentColspan += column.colspan
                                            } else {
                                                transparentColspan++
                                            }
                                        }
                                        notFixedColumnCount++;
                                        if (!(0, _type.isDefined)(transparentColumnIndex)) {
                                            transparentColumnIndex = j
                                        }
                                    } else if (prevColumn && prevColumn.fixed && (0, _m_columns_controller_utils.getFixedPosition)(this, prevColumn) !== (0, _m_columns_controller_utils.getFixedPosition)(this, column)) {
                                        if (!(0, _type.isDefined)(transparentColumnIndex)) {
                                            transparentColumnIndex = j
                                        }
                                    } else {
                                        lastFixedPosition = column.fixedPosition
                                    }
                                }
                                if (0 === i && (0 === notFixedColumnCount || notFixedColumnCount >= visibleColumns.length)) {
                                    return []
                                }
                                if (!(0, _type.isDefined)(transparentColumnIndex)) {
                                    transparentColumnIndex = "right" === lastFixedPosition ? 0 : visibleColumns.length
                                }
                                result[i] = visibleColumns.slice(0);
                                if (!transparentColumn.colspan) {
                                    transparentColumn.colspan = transparentColspan
                                }
                                result[i].splice(transparentColumnIndex, notFixedColumnCount, transparentColumn)
                            }
                        }
                        return result.map((function(columns) {
                            return columns.map((function(column) {
                                var newColumn = _extends({}, column);
                                if (newColumn.headerId) {
                                    newColumn.headerId += "-fixed"
                                }
                                return newColumn
                            }))
                        }))
                    };
                    _proto._isColumnFixing = function() {
                        var isColumnFixing = this.option("columnFixing.enabled");
                        !isColumnFixing && (0, _iterator.each)(this._columns, (function(_, column) {
                            if (column.fixed) {
                                isColumnFixing = true;
                                return false
                            }
                        }));
                        return isColumnFixing
                    };
                    _proto._getExpandColumnsCore = function() {
                        return this.getGroupColumns()
                    };
                    _proto.getExpandColumns = function() {
                        var expandColumns = this._getExpandColumnsCore();
                        var expandColumn;
                        var firstGroupColumn = expandColumns.filter((function(column) {
                            return 0 === column.groupIndex
                        }))[0];
                        var isFixedFirstGroupColumn = firstGroupColumn && firstGroupColumn.fixed;
                        var isColumnFixing = this._isColumnFixing();
                        var rtlEnabled = this.option("rtlEnabled");
                        if (expandColumns.length) {
                            expandColumn = this.columnOption("command:expand")
                        }
                        expandColumns = (0, _iterator.map)(expandColumns, (function(column) {
                            return (0, _extend.extend)({}, column, {
                                visibleWidth: null,
                                minWidth: null,
                                cellTemplate: !(0, _type.isDefined)(column.groupIndex) ? column.cellTemplate : null,
                                headerCellTemplate: null,
                                fixed: !(0, _type.isDefined)(column.groupIndex) || !isFixedFirstGroupColumn ? isColumnFixing : true,
                                fixedPosition: rtlEnabled ? "right" : "left"
                            }, expandColumn, {
                                index: column.index,
                                type: column.type || _const.GROUP_COMMAND_COLUMN_NAME
                            })
                        }));
                        return expandColumns
                    };
                    _proto.getBandColumnsCache = function() {
                        if (!this._bandColumnsCache) {
                            var columns = this._columns;
                            var columnChildrenByIndex = {};
                            var columnParentByIndex = {};
                            var isPlain = true;
                            columns.forEach((function(column) {
                                var ownerBand = column.ownerBand;
                                var parentIndex = (0, _type.isObject)(ownerBand) ? ownerBand.index : ownerBand;
                                var parent = columns[parentIndex];
                                if (column.hasColumns) {
                                    isPlain = false
                                }
                                if (column.colspan) {
                                    column.colspan = void 0
                                }
                                if (column.rowspan) {
                                    column.rowspan = void 0
                                }
                                if (parent) {
                                    columnParentByIndex[column.index] = parent
                                } else {
                                    parentIndex = -1
                                }
                                columnChildrenByIndex[parentIndex] = columnChildrenByIndex[parentIndex] || [];
                                columnChildrenByIndex[parentIndex].push(column)
                            }));
                            this._bandColumnsCache = {
                                isPlain: isPlain,
                                columnChildrenByIndex: columnChildrenByIndex,
                                columnParentByIndex: columnParentByIndex
                            }
                        }
                        return this._bandColumnsCache
                    };
                    _proto._isColumnVisible = function(column) {
                        return column.visible && this.isParentColumnVisible(column.index)
                    };
                    _proto._isColumnInGroupPanel = function(column) {
                        return (0, _type.isDefined)(column.groupIndex) && !column.showWhenGrouped
                    };
                    _proto.hasVisibleDataColumns = function() {
                        var _this = this;
                        var columns = this._columns;
                        return columns.some((function(column) {
                            var isVisible = _this._isColumnVisible(column);
                            var isInGroupPanel = _this._isColumnInGroupPanel(column);
                            var isCommand = !!column.command;
                            return isVisible && !isInGroupPanel && !isCommand
                        }))
                    };
                    _proto._compileVisibleColumnsCore = function() {
                        var bandColumnsCache = this.getBandColumnsCache();
                        var columns = (0, _m_columns_controller_utils.mergeColumns)(this, this._columns, this._commandColumns, true);
                        (0, _m_columns_controller_utils.processBandColumns)(this, columns, bandColumnsCache);
                        var indexedColumns = this._getIndexedColumns(columns);
                        var visibleColumns = this._getVisibleColumnsFromIndexed(indexedColumns);
                        var isDataColumnsInvisible = !this.hasVisibleDataColumns();
                        if (isDataColumnsInvisible && this._columns.length) {
                            visibleColumns[visibleColumns.length - 1].push({
                                command: "empty"
                            })
                        }
                        return visibleColumns
                    };
                    _proto._getIndexedColumns = function(columns) {
                        var _this2 = this;
                        var rtlEnabled = this.option("rtlEnabled");
                        var rowCount = this.getRowCount();
                        var columnDigitsCount = (0, _m_columns_controller_utils.digitsCount)(columns.length);
                        var bandColumnsCache = this.getBandColumnsCache();
                        var positiveIndexedColumns = [];
                        var negativeIndexedColumns = [];
                        for (var i = 0; i < rowCount; i += 1) {
                            negativeIndexedColumns[i] = [{}];
                            positiveIndexedColumns[i] = [{}, {}, {}]
                        }
                        columns.forEach((function(column) {
                            var _a, _b, _c, _d;
                            var visibleIndex = column.visibleIndex;
                            var indexedColumns;
                            var parentBandColumns = (0, _m_columns_controller_utils.getParentBandColumns)(column.index, bandColumnsCache.columnParentByIndex);
                            var isVisible = _this2._isColumnVisible(column);
                            var isInGroupPanel = _this2._isColumnInGroupPanel(column);
                            if (isVisible && !isInGroupPanel) {
                                var rowIndex = parentBandColumns.length;
                                if (visibleIndex < 0) {
                                    visibleIndex = -visibleIndex;
                                    indexedColumns = negativeIndexedColumns[rowIndex]
                                } else {
                                    column.fixed = null !== (_b = null === (_a = parentBandColumns[0]) || void 0 === _a ? void 0 : _a.fixed) && void 0 !== _b ? _b : column.fixed;
                                    column.fixedPosition = null !== (_d = null === (_c = parentBandColumns[0]) || void 0 === _c ? void 0 : _c.fixedPosition) && void 0 !== _d ? _d : column.fixedPosition;
                                    if (column.fixed) {
                                        var isDefaultCommandColumn = !!column.command && !(0, _m_columns_controller_utils.isCustomCommandColumn)(_this2, column);
                                        var isFixedToEnd = "right" === column.fixedPosition;
                                        if (rtlEnabled && !isDefaultCommandColumn) {
                                            isFixedToEnd = !isFixedToEnd
                                        }
                                        indexedColumns = isFixedToEnd ? positiveIndexedColumns[rowIndex][2] : positiveIndexedColumns[rowIndex][0]
                                    } else {
                                        indexedColumns = positiveIndexedColumns[rowIndex][1]
                                    }
                                }
                                if (parentBandColumns.length) {
                                    visibleIndex = (0, _m_columns_controller_utils.numberToString)(visibleIndex, columnDigitsCount);
                                    for (var _i = parentBandColumns.length - 1; _i >= 0; _i -= 1) {
                                        visibleIndex = (0, _m_columns_controller_utils.numberToString)(parentBandColumns[_i].visibleIndex, columnDigitsCount) + visibleIndex
                                    }
                                }
                                indexedColumns[visibleIndex] = indexedColumns[visibleIndex] || [];
                                indexedColumns[visibleIndex].push(column)
                            }
                        }));
                        return {
                            positiveIndexedColumns: positiveIndexedColumns,
                            negativeIndexedColumns: negativeIndexedColumns
                        }
                    };
                    _proto._getVisibleColumnsFromIndexed = function(_ref) {
                        var _this3 = this;
                        var positiveIndexedColumns = _ref.positiveIndexedColumns,
                            negativeIndexedColumns = _ref.negativeIndexedColumns;
                        var result = [];
                        var rowCount = this.getRowCount();
                        var expandColumns = (0, _m_columns_controller_utils.mergeColumns)(this, this.getExpandColumns(), this._columns);
                        var rowspanGroupColumns = 0;
                        var rowspanExpandColumns = 0;
                        var _loop = function(rowIndex) {
                            result.push([]);
                            (0, _object.orderEach)(negativeIndexedColumns[rowIndex], (function(_, columns) {
                                result[rowIndex].unshift.apply(result[rowIndex], columns)
                            }));
                            var firstPositiveIndexColumn = result[rowIndex].length;
                            var positiveIndexedRowColumns = positiveIndexedColumns[rowIndex];
                            positiveIndexedRowColumns.forEach((function(columnsByFixing) {
                                (0, _object.orderEach)(columnsByFixing, (function(_, columnsByVisibleIndex) {
                                    result[rowIndex].push.apply(result[rowIndex], columnsByVisibleIndex)
                                }))
                            }));
                            if (rowspanExpandColumns <= rowIndex) {
                                rowspanExpandColumns += _m_columns_controller_utils.processExpandColumns.call(_this3, result[rowIndex], expandColumns, _const.DETAIL_COMMAND_COLUMN_NAME, firstPositiveIndexColumn)
                            }
                            if (rowspanGroupColumns <= rowIndex) {
                                rowspanGroupColumns += _m_columns_controller_utils.processExpandColumns.call(_this3, result[rowIndex], expandColumns, _const.GROUP_COMMAND_COLUMN_NAME, firstPositiveIndexColumn)
                            }
                        };
                        for (var rowIndex = 0; rowIndex < rowCount; rowIndex += 1) {
                            _loop(rowIndex)
                        }
                        result.push((0, _m_columns_controller_utils.getDataColumns)(result));
                        return result
                    };
                    _proto.getInvisibleColumns = function(columns, bandColumnIndex) {
                        var that = this;
                        var result = [];
                        var hiddenColumnsByBand;
                        columns = columns || that._columns;
                        (0, _iterator.each)(columns, (function(_, column) {
                            if (column.ownerBand !== bandColumnIndex) {
                                return
                            }
                            if (column.isBand) {
                                if (!column.visible) {
                                    hiddenColumnsByBand = that.getChildrenByBandColumn(column.index)
                                } else {
                                    hiddenColumnsByBand = that.getInvisibleColumns(that.getChildrenByBandColumn(column.index), column.index)
                                }
                                if (hiddenColumnsByBand.length) {
                                    result.push(column);
                                    result = result.concat(hiddenColumnsByBand)
                                }
                                return
                            }
                            if (!column.visible) {
                                result.push(column)
                            }
                        }));
                        return result
                    };
                    _proto.getChooserColumns = function(getAllColumns) {
                        var columns = getAllColumns ? this.getColumns() : this.getInvisibleColumns();
                        var columnChooserColumns = columns.filter((function(column) {
                            return column.showInColumnChooser
                        }));
                        var sortOrder = this.option("columnChooser.sortOrder");
                        return (0, _m_columns_controller_utils.sortColumns)(columnChooserColumns, sortOrder)
                    };
                    _proto.allowMoveColumn = function(fromVisibleIndex, toVisibleIndex, sourceLocation, targetLocation) {
                        var columnIndex = (0, _m_columns_controller_utils.getColumnIndexByVisibleIndex)(this, fromVisibleIndex, sourceLocation);
                        var sourceColumn = this._columns[columnIndex];
                        if (sourceColumn && (sourceColumn.allowReordering || sourceColumn.allowGrouping || sourceColumn.allowHiding)) {
                            if (sourceLocation === targetLocation) {
                                if (sourceLocation === _const.COLUMN_CHOOSER_LOCATION) {
                                    return false
                                }
                                fromVisibleIndex = (0, _type.isObject)(fromVisibleIndex) ? fromVisibleIndex.columnIndex : fromVisibleIndex;
                                toVisibleIndex = (0, _type.isObject)(toVisibleIndex) ? toVisibleIndex.columnIndex : toVisibleIndex;
                                return fromVisibleIndex !== toVisibleIndex && fromVisibleIndex + 1 !== toVisibleIndex
                            }
                            if (sourceLocation === _const.GROUP_LOCATION && targetLocation !== _const.COLUMN_CHOOSER_LOCATION || targetLocation === _const.GROUP_LOCATION) {
                                return sourceColumn && sourceColumn.allowGrouping
                            }
                            if (sourceLocation === _const.COLUMN_CHOOSER_LOCATION || targetLocation === _const.COLUMN_CHOOSER_LOCATION) {
                                return sourceColumn && sourceColumn.allowHiding
                            }
                            return true
                        }
                        return false
                    };
                    _proto.moveColumn = function(fromVisibleIndex, toVisibleIndex, sourceLocation, targetLocation) {
                        var options = {};
                        var prevGroupIndex;
                        var fromIndex = (0, _m_columns_controller_utils.getColumnIndexByVisibleIndex)(this, fromVisibleIndex, sourceLocation);
                        var toIndex = (0, _m_columns_controller_utils.getColumnIndexByVisibleIndex)(this, toVisibleIndex, targetLocation);
                        var targetGroupIndex;
                        if (fromIndex >= 0) {
                            var column = this._columns[fromIndex];
                            toVisibleIndex = (0, _type.isObject)(toVisibleIndex) ? toVisibleIndex.columnIndex : toVisibleIndex;
                            targetGroupIndex = toIndex >= 0 ? this._columns[toIndex].groupIndex : -1;
                            if ((0, _type.isDefined)(column.groupIndex) && sourceLocation === _const.GROUP_LOCATION) {
                                if (targetGroupIndex > column.groupIndex) {
                                    targetGroupIndex--
                                }
                                if (targetLocation !== _const.GROUP_LOCATION) {
                                    options.groupIndex = void 0
                                } else {
                                    prevGroupIndex = column.groupIndex;
                                    delete column.groupIndex;
                                    (0, _m_columns_controller_utils.updateColumnGroupIndexes)(this)
                                }
                            }
                            if (targetLocation === _const.GROUP_LOCATION) {
                                options.groupIndex = (0, _m_columns_controller_utils.moveColumnToGroup)(this, column, targetGroupIndex);
                                column.groupIndex = prevGroupIndex
                            } else if (toVisibleIndex >= 0) {
                                var targetColumn = this._columns[toIndex];
                                if (!targetColumn || column.ownerBand !== targetColumn.ownerBand) {
                                    options.visibleIndex = _const.MAX_SAFE_INTEGER
                                } else if ((0, _m_columns_controller_utils.isColumnFixed)(this, column) ^ (0, _m_columns_controller_utils.isColumnFixed)(this, targetColumn)) {
                                    options.visibleIndex = _const.MAX_SAFE_INTEGER
                                } else {
                                    options.visibleIndex = targetColumn.visibleIndex
                                }
                            }
                            var isVisible = targetLocation !== _const.COLUMN_CHOOSER_LOCATION;
                            if (column.visible !== isVisible) {
                                options.visible = isVisible
                            }
                            this.columnOption(column.index, options)
                        }
                    };
                    _proto.changeSortOrder = function(columnIndex, sortOrder) {
                        var options = {};
                        var sortingOptions = this.option("sorting");
                        var sortingMode = sortingOptions && sortingOptions.mode;
                        var needResetSorting = "single" === sortingMode || !sortOrder;
                        var allowSorting = "single" === sortingMode || "multiple" === sortingMode;
                        var column = this._columns[columnIndex];
                        if (allowSorting && column && column.allowSorting) {
                            if (needResetSorting && !(0, _type.isDefined)(column.groupIndex)) {
                                (0, _iterator.each)(this._columns, (function(index) {
                                    if (index !== columnIndex && this.sortOrder) {
                                        if (!(0, _type.isDefined)(this.groupIndex)) {
                                            delete this.sortOrder
                                        }
                                        delete this.sortIndex
                                    }
                                }))
                            }
                            if ((0, _m_columns_controller_utils.isSortOrderValid)(sortOrder)) {
                                if (column.sortOrder !== sortOrder) {
                                    options.sortOrder = sortOrder
                                }
                            } else if ("none" === sortOrder) {
                                if (column.sortOrder) {
                                    options.sortIndex = void 0;
                                    options.sortOrder = void 0
                                }
                            } else {
                                ! function(column) {
                                    if ("ctrl" === sortOrder) {
                                        if (!("sortOrder" in column && "sortIndex" in column)) {
                                            return false
                                        }
                                        options.sortOrder = void 0;
                                        options.sortIndex = void 0
                                    } else if ((0, _type.isDefined)(column.groupIndex) || (0, _type.isDefined)(column.sortIndex)) {
                                        options.sortOrder = "desc" === column.sortOrder ? "asc" : "desc"
                                    } else {
                                        options.sortOrder = "asc"
                                    }
                                    return true
                                }(column)
                            }
                        }
                        this.columnOption(column.index, options)
                    };
                    _proto.getSortDataSourceParameters = function(useLocalSelector) {
                        var sortColumns = [];
                        var sort = [];
                        (0, _iterator.each)(this._columns, (function() {
                            if ((this.dataField || this.selector || this.calculateCellValue) && (0, _type.isDefined)(this.sortIndex) && !(0, _type.isDefined)(this.groupIndex)) {
                                sortColumns[this.sortIndex] = this
                            }
                        }));
                        (0, _iterator.each)(sortColumns, (function() {
                            var sortOrder = this && this.sortOrder;
                            if ((0, _m_columns_controller_utils.isSortOrderValid)(sortOrder)) {
                                var sortItem = {
                                    selector: this.calculateSortValue || this.displayField || this.calculateDisplayValue || useLocalSelector && this.selector || this.dataField || this.calculateCellValue,
                                    desc: "desc" === this.sortOrder
                                };
                                if (this.sortingMethod) {
                                    sortItem.compare = this.sortingMethod.bind(this)
                                }
                                sort.push(sortItem)
                            }
                        }));
                        return sort.length > 0 ? sort : null
                    };
                    _proto.getGroupDataSourceParameters = function(useLocalSelector) {
                        var group = [];
                        (0, _iterator.each)(this.getGroupColumns(), (function() {
                            var selector = this.calculateGroupValue || this.displayField || this.calculateDisplayValue || useLocalSelector && this.selector || this.dataField || this.calculateCellValue;
                            if (selector) {
                                var groupItem = {
                                    selector: selector,
                                    desc: "desc" === this.sortOrder,
                                    isExpanded: !!this.autoExpandGroup
                                };
                                if (this.sortingMethod) {
                                    groupItem.compare = this.sortingMethod.bind(this)
                                }
                                group.push(groupItem)
                            }
                        }));
                        return group.length > 0 ? group : null
                    };
                    _proto.refresh = function(updateNewLookupsOnly) {
                        var deferreds = [];
                        (0, _iterator.each)(this._columns, (function() {
                            var lookup = this.lookup;
                            if (lookup && !this.calculateDisplayValue) {
                                if (updateNewLookupsOnly && lookup.valueMap) {
                                    return
                                }
                                if (lookup.update) {
                                    deferreds.push(lookup.update())
                                }
                            }
                        }));
                        return _deferred.when.apply(_renderer.default, deferreds).done(_m_columns_controller_utils.resetColumnsCache.bind(null, this))
                    };
                    _proto._updateColumnOptions = function(column, columnIndex) {
                        column.selector = column.selector || function(data) {
                            return column.calculateCellValue(data)
                        };
                        if (this._reinitAfterLookupChanges && this._previousColumns) {
                            column.selector.columnIndex = columnIndex;
                            column.selector.originalCallback = this._previousColumns[columnIndex].selector.originalCallback
                        } else {
                            column.selector.columnIndex = columnIndex;
                            column.selector.originalCallback = column.selector
                        }(0, _iterator.each)(["calculateSortValue", "calculateGroupValue", "calculateDisplayValue"], (function(_, calculateCallbackName) {
                            var calculateCallback = column[calculateCallbackName];
                            if ((0, _type.isFunction)(calculateCallback)) {
                                if (!calculateCallback.originalCallback) {
                                    var context = {
                                        column: column
                                    };
                                    column[calculateCallbackName] = function(data) {
                                        return calculateCallback.call(context.column, data)
                                    };
                                    column[calculateCallbackName].originalCallback = calculateCallback;
                                    column[calculateCallbackName].columnIndex = columnIndex;
                                    column[calculateCallbackName].context = context
                                } else {
                                    column[calculateCallbackName].context.column = column
                                }
                            }
                        }));
                        if ((0, _type.isString)(column.calculateDisplayValue)) {
                            column.displayField = column.calculateDisplayValue;
                            column.calculateDisplayValue = (0, _data.compileGetter)(column.displayField)
                        }
                        if (column.calculateDisplayValue) {
                            column.displayValueMap = column.displayValueMap || {}
                        }(0, _m_columns_controller_utils.updateSerializers)(column, column.dataType);
                        var lookup = column.lookup;
                        if (lookup) {
                            (0, _m_columns_controller_utils.updateSerializers)(lookup, lookup.dataType)
                        }
                        var dataType = lookup ? lookup.dataType : column.dataType;
                        if (dataType) {
                            column.alignment = column.alignment || (0, _m_columns_controller_utils.getAlignmentByDataType)(dataType, this.option("rtlEnabled"));
                            column.format = column.format || _m_utils.default.getFormatByDataType(dataType);
                            column.customizeText = column.customizeText || (0, _m_columns_controller_utils.getCustomizeTextByDataType)(dataType);
                            column.defaultFilterOperations = column.defaultFilterOperations || !lookup && _const.DATATYPE_OPERATIONS[dataType] || [];
                            if (!(0, _type.isDefined)(column.filterOperations)) {
                                (0, _m_columns_controller_utils.setFilterOperationsAsDefaultValues)(column)
                            }
                            column.defaultFilterOperation = column.filterOperations && column.filterOperations[0] || "=";
                            column.showEditorAlways = (0, _type.isDefined)(column.showEditorAlways) ? column.showEditorAlways : "boolean" === dataType && !column.cellTemplate && !column.lookup
                        }
                    };
                    _proto.updateColumnDataTypes = function(dataSource) {
                        var that = this;
                        var dateSerializationFormat = that.option("dateSerializationFormat");
                        var firstItems = that._getFirstItems(dataSource);
                        var isColumnDataTypesUpdated = false;
                        (0, _iterator.each)(that._columns, (function(index, column) {
                            var i;
                            var value;
                            var dataType;
                            var lookupDataType;
                            var valueDataType;
                            var lookup = column.lookup;
                            if (_m_utils.default.isDateType(column.dataType) && void 0 === column.serializationFormat) {
                                column.serializationFormat = dateSerializationFormat
                            }
                            if (lookup && _m_utils.default.isDateType(lookup.dataType) && void 0 === column.serializationFormat) {
                                lookup.serializationFormat = dateSerializationFormat
                            }
                            if (column.calculateCellValue && firstItems.length) {
                                if (!column.dataType || lookup && !lookup.dataType) {
                                    for (i = 0; i < firstItems.length; i++) {
                                        value = column.calculateCellValue(firstItems[i]);
                                        if (!column.dataType) {
                                            valueDataType = (0, _m_columns_controller_utils.getValueDataType)(value);
                                            dataType = dataType || valueDataType;
                                            if (dataType && valueDataType && dataType !== valueDataType) {
                                                dataType = "string"
                                            }
                                        }
                                        if (lookup && !lookup.dataType) {
                                            valueDataType = (0, _m_columns_controller_utils.getValueDataType)(_m_utils.default.getDisplayValue(column, value, firstItems[i]));
                                            lookupDataType = lookupDataType || valueDataType;
                                            if (lookupDataType && valueDataType && lookupDataType !== valueDataType) {
                                                lookupDataType = "string"
                                            }
                                        }
                                    }
                                    if (dataType || lookupDataType) {
                                        if (dataType) {
                                            column.dataType = dataType
                                        }
                                        if (lookup && lookupDataType) {
                                            lookup.dataType = lookupDataType
                                        }
                                        isColumnDataTypesUpdated = true
                                    }
                                }
                                if (void 0 === column.serializationFormat || lookup && void 0 === lookup.serializationFormat) {
                                    for (i = 0; i < firstItems.length; i++) {
                                        value = column.calculateCellValue(firstItems[i], true);
                                        if (void 0 === column.serializationFormat) {
                                            column.serializationFormat = (0, _m_columns_controller_utils.getSerializationFormat)(column.dataType, value)
                                        }
                                        if (lookup && void 0 === lookup.serializationFormat) {
                                            lookup.serializationFormat = (0, _m_columns_controller_utils.getSerializationFormat)(lookup.dataType, lookup.calculateCellValue(value, true))
                                        }
                                    }
                                }
                            }
                            that._updateColumnOptions(column, index)
                        }));
                        return isColumnDataTypesUpdated
                    };
                    _proto._customizeColumns = function(columns) {
                        var customizeColumns = this.option("customizeColumns");
                        if (customizeColumns) {
                            var hasOwnerBand = columns.some((function(column) {
                                return (0, _type.isObject)(column.ownerBand)
                            }));
                            if (hasOwnerBand) {
                                (0, _m_columns_controller_utils.updateIndexes)(this)
                            }
                            customizeColumns(columns);
                            (0, _m_columns_controller_utils.assignColumns)(this, (0, _m_columns_controller_utils.createColumnsFromOptions)(this, columns))
                        }
                    };
                    _proto.updateColumns = function(dataSource, forceApplying, isApplyingUserState) {
                        var _this4 = this;
                        if (!forceApplying) {
                            this.updateSortingGrouping(dataSource)
                        }
                        if (!dataSource || dataSource.isLoaded()) {
                            var sortParameters = dataSource ? dataSource.sort() || [] : this.getSortDataSourceParameters();
                            var groupParameters = dataSource ? dataSource.group() || [] : this.getGroupDataSourceParameters();
                            var filterParameters = null === dataSource || void 0 === dataSource ? void 0 : dataSource.lastLoadOptions().filter;
                            if (!isApplyingUserState) {
                                this._customizeColumns(this._columns)
                            }(0, _m_columns_controller_utils.updateIndexes)(this);
                            var columns = this._columns;
                            return (0, _deferred.when)(this.refresh(true)).always((function() {
                                if (_this4._columns !== columns) {
                                    return
                                }
                                _this4._updateChanges(dataSource, {
                                    sorting: sortParameters,
                                    grouping: groupParameters,
                                    filtering: filterParameters
                                });
                                (0, _m_columns_controller_utils.fireColumnsChanged)(_this4)
                            }))
                        }
                    };
                    _proto._updateChanges = function(dataSource, parameters) {
                        if (dataSource) {
                            this.updateColumnDataTypes(dataSource);
                            this._dataSourceApplied = true
                        }
                        if (!_m_utils.default.equalSortParameters(parameters.sorting, this.getSortDataSourceParameters())) {
                            (0, _m_columns_controller_utils.updateColumnChanges)(this, "sorting")
                        }
                        if (!_m_utils.default.equalSortParameters(parameters.grouping, this.getGroupDataSourceParameters())) {
                            (0, _m_columns_controller_utils.updateColumnChanges)(this, "grouping")
                        }
                        var dataController = this.getController("data");
                        if (dataController && !_m_utils.default.equalFilterParameters(parameters.filtering, dataController.getCombinedFilter())) {
                            (0, _m_columns_controller_utils.updateColumnChanges)(this, "filtering")
                        }(0, _m_columns_controller_utils.updateColumnChanges)(this, "columns")
                    };
                    _proto.updateSortingGrouping = function(dataSource, fromDataSource) {
                        var that = this;
                        var sortParameters;
                        var isColumnsChanged;
                        var updateSortGroupParameterIndexes = function(columns, sortParameters, indexParameterName) {
                            (0, _iterator.each)(columns, (function(index, column) {
                                delete column[indexParameterName];
                                if (sortParameters) {
                                    for (var i = 0; i < sortParameters.length; i++) {
                                        var selector = sortParameters[i].selector;
                                        var isExpanded = sortParameters[i].isExpanded;
                                        if (selector === column.dataField || selector === column.name || selector === column.selector || selector === column.calculateCellValue || selector === column.calculateGroupValue || selector === column.calculateDisplayValue) {
                                            if (fromDataSource) {
                                                column.sortOrder = "sortOrder" in column ? column.sortOrder : sortParameters[i].desc ? "desc" : "asc"
                                            } else {
                                                column.sortOrder = column.sortOrder || (sortParameters[i].desc ? "desc" : "asc")
                                            }
                                            if (void 0 !== isExpanded) {
                                                column.autoExpandGroup = isExpanded
                                            }
                                            column[indexParameterName] = i;
                                            break
                                        }
                                    }
                                }
                            }))
                        };
                        if (dataSource) {
                            sortParameters = _m_utils.default.normalizeSortingInfo(dataSource.sort());
                            var groupParameters = _m_utils.default.normalizeSortingInfo(dataSource.group());
                            var columnsGroupParameters = that.getGroupDataSourceParameters();
                            var columnsSortParameters = that.getSortDataSourceParameters();
                            var groupingChanged = !_m_utils.default.equalSortParameters(groupParameters, columnsGroupParameters, true);
                            var groupExpandingChanged = !groupingChanged && !_m_utils.default.equalSortParameters(groupParameters, columnsGroupParameters);
                            if (!that._columns.length) {
                                (0, _iterator.each)(groupParameters, (function(index, group) {
                                    that._columns.push(group.selector)
                                }));
                                (0, _iterator.each)(sortParameters, (function(index, sort) {
                                    if (!(0, _type.isFunction)(sort.selector)) {
                                        that._columns.push(sort.selector)
                                    }
                                }));
                                (0, _m_columns_controller_utils.assignColumns)(that, (0, _m_columns_controller_utils.createColumnsFromOptions)(that, that._columns))
                            }
                            if ((fromDataSource || !columnsGroupParameters && !that._hasUserState) && (groupingChanged || groupExpandingChanged)) {
                                updateSortGroupParameterIndexes(that._columns, groupParameters, "groupIndex");
                                if (fromDataSource) {
                                    groupingChanged && (0, _m_columns_controller_utils.updateColumnChanges)(that, "grouping");
                                    groupExpandingChanged && (0, _m_columns_controller_utils.updateColumnChanges)(that, "groupExpanding");
                                    isColumnsChanged = true
                                }
                            }
                            if ((fromDataSource || !columnsSortParameters && !that._hasUserState) && !_m_utils.default.equalSortParameters(sortParameters, columnsSortParameters)) {
                                updateSortGroupParameterIndexes(that._columns, sortParameters, "sortIndex");
                                if (fromDataSource) {
                                    (0, _m_columns_controller_utils.updateColumnChanges)(that, "sorting");
                                    isColumnsChanged = true
                                }
                            }
                            if (isColumnsChanged) {
                                (0, _m_columns_controller_utils.fireColumnsChanged)(that)
                            }
                        }
                    };
                    _proto.updateFilter = function(filter, remoteFiltering, columnIndex, filterValue) {
                        if (!Array.isArray(filter)) {
                            return filter
                        }
                        filter = (0, _extend.extend)([], filter);
                        columnIndex = void 0 !== filter.columnIndex ? filter.columnIndex : columnIndex;
                        filterValue = void 0 !== filter.filterValue ? filter.filterValue : filterValue;
                        if ((0, _type.isString)(filter[0]) && "!" !== filter[0]) {
                            var column = this.columnOption(filter[0]);
                            if (remoteFiltering) {
                                if ((0, _config.default)().forceIsoDateParsing && column && column.serializeValue && filter.length > 1) {
                                    filter[filter.length - 1] = column.serializeValue(filter[filter.length - 1], "filter")
                                }
                            } else if (column && column.selector) {
                                filter[0] = column.selector;
                                filter[0].columnIndex = column.index
                            }
                        } else if ((0, _type.isFunction)(filter[0])) {
                            filter[0].columnIndex = columnIndex;
                            filter[0].filterValue = filterValue;
                            filter[0].selectedFilterOperation = filter.selectedFilterOperation
                        }
                        for (var i = 0; i < filter.length; i++) {
                            filter[i] = this.updateFilter(filter[i], remoteFiltering, columnIndex, filterValue)
                        }
                        return filter
                    };
                    _proto.columnCount = function() {
                        return this._columns ? this._columns.length : 0
                    };
                    _proto.columnOption = function(identifier, option, value, notFireEvent) {
                        var that = this;
                        var columns = that._columns.concat(that._commandColumns);
                        var column = (0, _m_columns_controller_utils.findColumn)(columns, identifier);
                        if (column) {
                            if (1 === arguments.length) {
                                return (0, _extend.extend)({}, column)
                            }
                            if ((0, _type.isString)(option)) {
                                if (2 === arguments.length) {
                                    return (0, _m_columns_controller_utils.columnOptionCore)(that, column, option)
                                }(0, _m_columns_controller_utils.columnOptionCore)(that, column, option, value, notFireEvent)
                            } else if ((0, _type.isObject)(option)) {
                                (0, _iterator.each)(option, (function(optionName, value) {
                                    (0, _m_columns_controller_utils.columnOptionCore)(that, column, optionName, value, notFireEvent)
                                }))
                            }(0, _m_columns_controller_utils.fireColumnsChanged)(that)
                        }
                    };
                    _proto.clearSorting = function() {
                        var columnCount = this.columnCount();
                        this.beginUpdate();
                        for (var i = 0; i < columnCount; i++) {
                            this.columnOption(i, "sortOrder", void 0);
                            delete(0, _m_columns_controller_utils.findColumn)(this._columns, i).sortOrder
                        }
                        this.endUpdate()
                    };
                    _proto.clearGrouping = function() {
                        var columnCount = this.columnCount();
                        this.beginUpdate();
                        for (var i = 0; i < columnCount; i++) {
                            this.columnOption(i, "groupIndex", void 0)
                        }
                        this.endUpdate()
                    };
                    _proto.getVisibleIndex = function(index, rowIndex) {
                        var columns = this.getVisibleColumns(rowIndex);
                        for (var i = columns.length - 1; i >= 0; i--) {
                            if (columns[i].index === index) {
                                return i
                            }
                        }
                        return -1
                    };
                    _proto.getVisibleIndexByColumn = function(column, rowIndex) {
                        var visibleColumns = this.getVisibleColumns(rowIndex);
                        var visibleColumn = visibleColumns.filter((function(col) {
                            return col.index === column.index && col.command === column.command
                        }))[0];
                        return visibleColumns.indexOf(visibleColumn)
                    };
                    _proto.getVisibleColumnIndex = function(id, rowIndex) {
                        var index = this.columnOption(id, "index");
                        return this.getVisibleIndex(index, rowIndex)
                    };
                    _proto.addColumn = function(options) {
                        var column = (0, _m_columns_controller_utils.createColumn)(this, options);
                        var index = this._columns.length;
                        this._columns.push(column);
                        if (column.isBand) {
                            this._columns = (0, _m_columns_controller_utils.createColumnsFromOptions)(this, this._columns);
                            column = this._columns[index]
                        }
                        column.added = options;
                        (0, _m_columns_controller_utils.updateIndexes)(this, column);
                        this.updateColumns(this._dataSource);
                        this._checkColumns()
                    };
                    _proto.deleteColumn = function(id) {
                        var column = this.columnOption(id);
                        if (column && column.index >= 0) {
                            (0, _m_columns_controller_utils.convertOwnerBandToColumnReference)(this._columns);
                            this._columns.splice(column.index, 1);
                            if (column.isBand) {
                                var childIndexes = this.getChildrenByBandColumn(column.index).map((function(column) {
                                    return column.index
                                }));
                                this._columns = this._columns.filter((function(column) {
                                    return childIndexes.indexOf(column.index) < 0
                                }))
                            }(0, _m_columns_controller_utils.updateIndexes)(this);
                            this.updateColumns(this._dataSource)
                        }
                    };
                    _proto.addCommandColumn = function(options) {
                        var commandColumn = this._commandColumns.filter((function(column) {
                            return column.command === options.command
                        }))[0];
                        if (!commandColumn) {
                            commandColumn = options;
                            this._commandColumns.push(commandColumn)
                        }
                    };
                    _proto.getUserState = function() {
                        var columns = this._columns;
                        var result = [];
                        var i;

                        function handleStateField(index, value) {
                            if (void 0 !== columns[i][value]) {
                                result[i][value] = columns[i][value]
                            }
                        }
                        for (i = 0; i < columns.length; i++) {
                            result[i] = {};
                            (0, _iterator.each)(_const.USER_STATE_FIELD_NAMES, handleStateField)
                        }
                        return result
                    };
                    _proto.setName = function(column) {
                        column.name = column.name || column.dataField || column.type
                    };
                    _proto.setUserState = function(state) {
                        var dataSource = this._dataSource;
                        var ignoreColumnOptionNames = this.option("stateStoring.ignoreColumnOptionNames");
                        null === state || void 0 === state ? void 0 : state.forEach(this.setName);
                        if (!ignoreColumnOptionNames) {
                            ignoreColumnOptionNames = [];
                            var commonColumnSettings = this.getCommonSettings();
                            if (!this.option("columnChooser.enabled")) {
                                ignoreColumnOptionNames.push("visible")
                            }
                            if ("none" === this.option("sorting.mode")) {
                                ignoreColumnOptionNames.push("sortIndex", "sortOrder")
                            }
                            if (!commonColumnSettings.allowGrouping) {
                                ignoreColumnOptionNames.push("groupIndex")
                            }
                            if (!commonColumnSettings.allowFixing) {
                                ignoreColumnOptionNames.push("fixed", "fixedPosition")
                            }
                            if (!commonColumnSettings.allowResizing) {
                                ignoreColumnOptionNames.push("width", "visibleWidth")
                            }
                            var isFilterPanelHidden = !this.option("filterPanel.visible");
                            if (!this.option("filterRow.visible") && isFilterPanelHidden) {
                                ignoreColumnOptionNames.push("filterValue", "selectedFilterOperation")
                            }
                            if (!this.option("headerFilter.visible") && isFilterPanelHidden) {
                                ignoreColumnOptionNames.push("filterValues", "filterType")
                            }
                        }
                        this._columnsUserState = state;
                        this._ignoreColumnOptionNames = ignoreColumnOptionNames;
                        this._hasUserState = !!state;
                        (0, _m_columns_controller_utils.updateColumnChanges)(this, "filtering");
                        this.init(true);
                        if (dataSource) {
                            dataSource.sort(this.getSortDataSourceParameters());
                            dataSource.group(this.getGroupDataSourceParameters())
                        }
                    };
                    _proto._checkColumns = function() {
                        var usedNames = {};
                        var hasEditableColumnWithoutName = false;
                        var duplicatedNames = [];
                        this._columns.forEach((function(column) {
                            var _a;
                            var name = column.name;
                            var isBand = null === (_a = column.columns) || void 0 === _a ? void 0 : _a.length;
                            var isEditable = column.allowEditing && (column.dataField || column.setCellValue) && !isBand;
                            if (name) {
                                if (usedNames[name]) {
                                    duplicatedNames.push('"'.concat(name, '"'))
                                }
                                usedNames[name] = true
                            } else if (isEditable) {
                                hasEditableColumnWithoutName = true
                            }
                        }));
                        if (duplicatedNames.length) {
                            _ui.default.log("E1059", duplicatedNames.join(", "))
                        }
                        if (hasEditableColumnWithoutName) {
                            _ui.default.log("E1060")
                        }
                    };
                    _proto._createCalculatedColumnOptions = function(columnOptions, bandColumn) {
                        var calculatedColumnOptions = {};
                        var dataField = columnOptions.dataField;
                        if (Array.isArray(columnOptions.columns) && columnOptions.columns.length || columnOptions.isBand) {
                            calculatedColumnOptions.isBand = true;
                            dataField = null
                        }
                        if (dataField) {
                            if ((0, _type.isString)(dataField)) {
                                var getter = (0, _data.compileGetter)(dataField);
                                calculatedColumnOptions = {
                                    caption: (0, _inflector.captionize)(dataField),
                                    calculateCellValue: function(data, skipDeserialization) {
                                        var value = getter(data);
                                        return this.deserializeValue && !skipDeserialization ? this.deserializeValue(value) : value
                                    },
                                    setCellValue: _m_columns_controller_utils.defaultSetCellValue,
                                    parseValue: function(text) {
                                        var result;
                                        var parsedValue;
                                        if ("number" === this.dataType) {
                                            if ((0, _type.isString)(text) && this.format) {
                                                result = (0, _m_columns_controller_utils.strictParseNumber)(text.trim(), this.format)
                                            } else if ((0, _type.isDefined)(text) && (0, _type.isNumeric)(text)) {
                                                result = Number(text)
                                            }
                                        } else if ("boolean" === this.dataType) {
                                            if (text === this.trueText) {
                                                result = true
                                            } else if (text === this.falseText) {
                                                result = false
                                            }
                                        } else if (_m_utils.default.isDateType(this.dataType)) {
                                            parsedValue = _date.default.parse(text, this.format);
                                            if (parsedValue) {
                                                result = parsedValue
                                            }
                                        } else {
                                            result = text
                                        }
                                        return result
                                    }
                                }
                            }
                            calculatedColumnOptions.allowFiltering = true
                        } else {
                            calculatedColumnOptions.allowFiltering = !!columnOptions.calculateFilterExpression
                        }
                        calculatedColumnOptions.calculateFilterExpression = function() {
                            return _filtering.default.defaultCalculateFilterExpression.apply(this, arguments)
                        };
                        calculatedColumnOptions.defaultFilterOperation = "=";
                        calculatedColumnOptions.createFilterExpression = function(filterValue, selectedFilterOperation) {
                            var result;
                            if (this.calculateFilterExpression) {
                                result = this.calculateFilterExpression.apply(this, arguments)
                            }
                            if ((0, _type.isFunction)(result)) {
                                result = [result, "=", true]
                            }
                            if (result) {
                                result.columnIndex = this.index;
                                result.filterValue = filterValue;
                                result.selectedFilterOperation = selectedFilterOperation
                            }
                            return result
                        };
                        if (!dataField || !(0, _type.isString)(dataField)) {
                            (0, _extend.extend)(true, calculatedColumnOptions, {
                                allowSorting: false,
                                allowGrouping: false,
                                calculateCellValue: function() {
                                    return null
                                }
                            })
                        }
                        if (bandColumn) {
                            calculatedColumnOptions.allowFixing = false
                        }
                        if (columnOptions.dataType) {
                            calculatedColumnOptions.userDataType = columnOptions.dataType
                        }
                        if (columnOptions.selectedFilterOperation && !("defaultSelectedFilterOperation" in calculatedColumnOptions)) {
                            calculatedColumnOptions.defaultSelectedFilterOperation = columnOptions.selectedFilterOperation
                        }
                        if (columnOptions.lookup) {
                            calculatedColumnOptions.lookup = {
                                calculateCellValue: function(value, skipDeserialization) {
                                    if (this.valueExpr) {
                                        value = this.valueMap && this.valueMap[value]
                                    }
                                    return this.deserializeValue && !skipDeserialization ? this.deserializeValue(value) : value
                                },
                                updateValueMap: function() {
                                    this.valueMap = {};
                                    if (this.items) {
                                        var calculateValue = (0, _data.compileGetter)(this.valueExpr);
                                        var calculateDisplayValue = (0, _data.compileGetter)(this.displayExpr);
                                        for (var i = 0; i < this.items.length; i++) {
                                            var item = this.items[i];
                                            var displayValue = calculateDisplayValue(item);
                                            this.valueMap[calculateValue(item)] = displayValue;
                                            this.dataType = this.dataType || (0, _m_columns_controller_utils.getValueDataType)(displayValue)
                                        }
                                    }
                                },
                                update: function() {
                                    var that = this;
                                    var dataSource = that.dataSource;
                                    if (dataSource) {
                                        if ((0, _type.isFunction)(dataSource) && !_variable_wrapper.default.isWrapped(dataSource)) {
                                            dataSource = dataSource({})
                                        }
                                        if ((0, _type.isPlainObject)(dataSource) || dataSource instanceof _abstract_store.default || Array.isArray(dataSource)) {
                                            if (that.valueExpr) {
                                                var dataSourceOptions = (0, _utils.normalizeDataSourceOptions)(dataSource);
                                                dataSourceOptions.paginate = false;
                                                dataSource = new _data_source.DataSource(dataSourceOptions);
                                                return dataSource.load().done((function(data) {
                                                    that.items = data;
                                                    that.updateValueMap && that.updateValueMap()
                                                }))
                                            }
                                        } else {
                                            _ui.default.log("E1016")
                                        }
                                    } else {
                                        that.updateValueMap && that.updateValueMap()
                                    }
                                }
                            }
                        }
                        calculatedColumnOptions.resizedCallbacks = (0, _callbacks.default)();
                        if (columnOptions.resized) {
                            calculatedColumnOptions.resizedCallbacks.add(columnOptions.resized.bind(columnOptions))
                        }(0, _iterator.each)(calculatedColumnOptions, (function(optionName) {
                            if ((0, _type.isFunction)(calculatedColumnOptions[optionName]) && 0 !== optionName.indexOf("default")) {
                                var defaultOptionName = "default".concat(optionName.charAt(0).toUpperCase()).concat(optionName.substr(1));
                                calculatedColumnOptions[defaultOptionName] = calculatedColumnOptions[optionName]
                            }
                        }));
                        return calculatedColumnOptions
                    };
                    _proto.getRowCount = function() {
                        this._rowCount = this._rowCount || (0, _m_columns_controller_utils.getRowCount)(this);
                        return this._rowCount
                    };
                    _proto.getRowIndex = function(columnIndex, alwaysGetRowIndex) {
                        var column = this._columns[columnIndex];
                        var bandColumnsCache = this.getBandColumnsCache();
                        return column && (alwaysGetRowIndex || column.visible && !(column.command || (0, _type.isDefined)(column.groupIndex))) ? (0, _m_columns_controller_utils.getParentBandColumns)(columnIndex, bandColumnsCache.columnParentByIndex).length : 0
                    };
                    _proto.getChildrenByBandColumn = function(bandColumnIndex, onlyVisibleDirectChildren) {
                        var bandColumnsCache = this.getBandColumnsCache();
                        var result = (0, _m_columns_controller_utils.getChildrenByBandColumn)(bandColumnIndex, bandColumnsCache.columnChildrenByIndex, !onlyVisibleDirectChildren);
                        if (onlyVisibleDirectChildren) {
                            return result.filter((function(column) {
                                return column.visible && !column.command
                            })).sort((function(column1, column2) {
                                return column1.visibleIndex - column2.visibleIndex
                            }))
                        }
                        return result
                    };
                    _proto.isParentBandColumn = function(columnIndex, bandColumnIndex) {
                        var result = false;
                        var column = this._columns[columnIndex];
                        var bandColumnsCache = this.getBandColumnsCache();
                        var parentBandColumns = column && (0, _m_columns_controller_utils.getParentBandColumns)(columnIndex, bandColumnsCache.columnParentByIndex);
                        if (parentBandColumns) {
                            (0, _iterator.each)(parentBandColumns, (function(_, bandColumn) {
                                if (bandColumn.index === bandColumnIndex) {
                                    result = true;
                                    return false
                                }
                            }))
                        }
                        return result
                    };
                    _proto.isParentColumnVisible = function(columnIndex) {
                        var result = true;
                        var bandColumnsCache = this.getBandColumnsCache();
                        var bandColumns = columnIndex >= 0 && (0, _m_columns_controller_utils.getParentBandColumns)(columnIndex, bandColumnsCache.columnParentByIndex);
                        bandColumns && (0, _iterator.each)(bandColumns, (function(_, bandColumn) {
                            result = result && bandColumn.visible;
                            return result
                        }));
                        return result
                    };
                    _proto.getColumnId = function(column) {
                        if (column.command && column.type === _const.GROUP_COMMAND_COLUMN_NAME) {
                            if ((0, _m_columns_controller_utils.isCustomCommandColumn)(this, column)) {
                                return "type:".concat(column.type)
                            }
                            return "command:".concat(column.command)
                        }
                        return column.index
                    };
                    _proto.getCustomizeTextByDataType = function(dataType) {
                        return (0, _m_columns_controller_utils.getCustomizeTextByDataType)(dataType)
                    };
                    _proto.getHeaderContentAlignment = function(columnAlignment) {
                        var rtlEnabled = this.option("rtlEnabled");
                        if (rtlEnabled) {
                            return "left" === columnAlignment ? "right" : "left"
                        }
                        return columnAlignment
                    };
                    return ColumnsController
                }(_m_modules.default.Controller);
                exports.ColumnsController = ColumnsController;
                var columnsControllerModule = {
                    defaultOptions: function() {
                        return {
                            commonColumnSettings: {
                                allowFiltering: true,
                                allowHiding: true,
                                allowSorting: true,
                                allowEditing: true,
                                encodeHtml: true,
                                trueText: _message.default.format("dxDataGrid-trueText"),
                                falseText: _message.default.format("dxDataGrid-falseText")
                            },
                            allowColumnReordering: false,
                            allowColumnResizing: false,
                            columnResizingMode: "nextColumn",
                            columnMinWidth: void 0,
                            columnWidth: void 0,
                            adaptColumnWidthByRatio: true,
                            columns: void 0,
                            regenerateColumnsByVisibleItems: false,
                            customizeColumns: null,
                            dateSerializationFormat: void 0
                        }
                    },
                    controllers: {
                        columns: ColumnsController
                    }
                };
                exports.columnsControllerModule = columnsControllerModule
            },
        22732:
            /*!*************************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/columns_controller/m_columns_controller_utils.js ***!
              \*************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.applyUserState = exports.addExpandColumn = void 0;
                exports.assignColumns = assignColumns;
                exports.isCustomCommandColumn = exports.isColumnFixed = exports.getValueDataType = exports.getSerializationFormat = exports.getRowCount = exports.getParentBandColumns = exports.getFixedPosition = exports.getDataColumns = exports.getCustomizeTextByDataType = exports.getColumnIndexByVisibleIndex = exports.getColumnFullPath = exports.getColumnByIndexes = exports.getChildrenByBandColumn = exports.getAlignmentByDataType = exports.fireOptionChanged = exports.fireColumnsChanged = exports.findColumn = exports.digitsCount = exports.defaultSetCellValue = exports.customizeTextForBooleanDataType = exports.createColumnsFromOptions = exports.createColumnsFromDataSource = exports.createColumn = exports.convertOwnerBandToColumnReference = exports.columnOptionCore = exports.calculateColspan = void 0;
                exports.isSortOrderValid = isSortOrderValid;
                exports.updateSortOrderWhenGrouping = exports.updateSerializers = exports.updateIndexes = exports.updateColumnVisibleIndexes = exports.updateColumnSortIndexes = exports.updateColumnIndexes = exports.updateColumnGroupIndexes = exports.updateColumnChanges = exports.strictParseNumber = exports.sortColumns = exports.setFilterOperationsAsDefaultValues = exports.resetColumnsCache = exports.resetBandColumnsCache = exports.processExpandColumns = exports.processBandColumns = exports.numberToString = exports.moveColumnToGroup = exports.mergeColumns = void 0;
                var _array = __webpack_require__( /*! ../../../../core/utils/array */ 89386);
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 47617);
                var _date_serialization = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/date_serialization */ 69434));
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _object = __webpack_require__( /*! ../../../../core/utils/object */ 48013);
                var _position = __webpack_require__( /*! ../../../../core/utils/position */ 37518);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/variable_wrapper */ 26974));
                var _number = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/number */ 18016));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));
                var _const = __webpack_require__( /*! ./const */ 54057);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var setFilterOperationsAsDefaultValues = function(column) {
                    column.filterOperations = column.defaultFilterOperations
                };
                exports.setFilterOperationsAsDefaultValues = setFilterOperationsAsDefaultValues;
                var globalColumnId = 1;
                var createColumn = function(that, columnOptions, userStateColumnOptions, bandColumn) {
                    var commonColumnOptions = {};
                    if (columnOptions) {
                        if ((0, _type.isString)(columnOptions)) {
                            columnOptions = {
                                dataField: columnOptions
                            }
                        }
                        that.setName(columnOptions);
                        var result = {};
                        if (columnOptions.command) {
                            result = (0, _object.deepExtendArraySafe)(commonColumnOptions, columnOptions)
                        } else {
                            commonColumnOptions = that.getCommonSettings(columnOptions);
                            if (userStateColumnOptions && userStateColumnOptions.name && userStateColumnOptions.dataField) {
                                columnOptions = (0, _extend.extend)({}, columnOptions, {
                                    dataField: userStateColumnOptions.dataField
                                })
                            }
                            var calculatedColumnOptions = that._createCalculatedColumnOptions(columnOptions, bandColumn);
                            if (!columnOptions.type) {
                                result = {
                                    headerId: "dx-col-".concat(globalColumnId++)
                                }
                            }
                            result = (0, _object.deepExtendArraySafe)(result, _const.DEFAULT_COLUMN_OPTIONS);
                            (0, _object.deepExtendArraySafe)(result, commonColumnOptions);
                            (0, _object.deepExtendArraySafe)(result, calculatedColumnOptions);
                            (0, _object.deepExtendArraySafe)(result, columnOptions);
                            (0, _object.deepExtendArraySafe)(result, {
                                selector: null
                            })
                        }
                        if (columnOptions.filterOperations === columnOptions.defaultFilterOperations) {
                            setFilterOperationsAsDefaultValues(result)
                        }
                        return result
                    }
                };
                exports.createColumn = createColumn;
                var createColumnsFromOptions = function createColumnsFromOptions(that, columnsOptions, bandColumn) {
                    var result = [];
                    if (columnsOptions) {
                        (0, _iterator.each)(columnsOptions, (function(index, columnOptions) {
                            var userStateColumnOptions = that._columnsUserState && checkUserStateColumn(columnOptions, that._columnsUserState[index]) && that._columnsUserState[index];
                            var column = createColumn(that, columnOptions, userStateColumnOptions, bandColumn);
                            if (column) {
                                if (bandColumn) {
                                    column.ownerBand = bandColumn
                                }
                                result.push(column);
                                if (column.columns) {
                                    result = result.concat(createColumnsFromOptions(that, column.columns, column));
                                    delete column.columns;
                                    column.hasColumns = true
                                }
                            }
                        }))
                    }
                    return result
                };
                exports.createColumnsFromOptions = createColumnsFromOptions;
                var getParentBandColumns = function(columnIndex, columnParentByIndex) {
                    var result = [];
                    var parent = columnParentByIndex[columnIndex];
                    while (parent) {
                        result.unshift(parent);
                        columnIndex = parent.index;
                        parent = columnParentByIndex[columnIndex]
                    }
                    return result
                };
                exports.getParentBandColumns = getParentBandColumns;
                exports.getChildrenByBandColumn = function getChildrenByBandColumn(columnIndex, columnChildrenByIndex, recursive) {
                    var result = [];
                    var children = columnChildrenByIndex[columnIndex];
                    if (children) {
                        for (var i = 0; i < children.length; i++) {
                            var column = children[i];
                            if (!(0, _type.isDefined)(column.groupIndex) || column.showWhenGrouped) {
                                result.push(column);
                                if (recursive && column.isBand) {
                                    result = result.concat(getChildrenByBandColumn(column.index, columnChildrenByIndex, recursive))
                                }
                            }
                        }
                    }
                    return result
                };
                exports.getColumnByIndexes = function(that, columnIndexes) {
                    var result;
                    var columns;
                    var bandColumnsCache = that.getBandColumnsCache();
                    var callbackFilter = function(column) {
                        var ownerBand = result ? result.index : void 0;
                        return column.ownerBand === ownerBand
                    };
                    if (bandColumnsCache.isPlain) {
                        result = that._columns[columnIndexes[0]]
                    } else {
                        columns = that._columns.filter(callbackFilter);
                        for (var i = 0; i < columnIndexes.length; i++) {
                            result = columns[columnIndexes[i]];
                            if (result) {
                                columns = that._columns.filter(callbackFilter)
                            }
                        }
                    }
                    return result
                };
                var getColumnFullPath = function(that, column) {
                    var result = [];
                    var columns;
                    var bandColumnsCache = that.getBandColumnsCache();
                    var callbackFilter = function(item) {
                        return item.ownerBand === column.ownerBand
                    };
                    if (bandColumnsCache.isPlain) {
                        var columnIndex = that._columns.indexOf(column);
                        if (columnIndex >= 0) {
                            result = ["columns[".concat(columnIndex, "]")]
                        }
                    } else {
                        columns = that._columns.filter(callbackFilter);
                        while (columns.length && -1 !== columns.indexOf(column)) {
                            result.unshift("columns[".concat(columns.indexOf(column), "]"));
                            column = bandColumnsCache.columnParentByIndex[column.index];
                            columns = column ? that._columns.filter(callbackFilter) : []
                        }
                    }
                    return result.join(".")
                };
                exports.getColumnFullPath = getColumnFullPath;
                var calculateColspan = function calculateColspan(that, columnID) {
                    var colspan = 0;
                    var columns = that.getChildrenByBandColumn(columnID, true);
                    (0, _iterator.each)(columns, (function(_, column) {
                        if (column.isBand) {
                            column.colspan = column.colspan || calculateColspan(that, column.index);
                            colspan += column.colspan || 1
                        } else {
                            colspan += 1
                        }
                    }));
                    return colspan
                };
                exports.calculateColspan = calculateColspan;
                exports.processBandColumns = function(that, columns, bandColumnsCache) {
                    var rowspan;
                    for (var i = 0; i < columns.length; i++) {
                        var column = columns[i];
                        if (column.visible || column.command) {
                            if (column.isBand) {
                                column.colspan = column.colspan || calculateColspan(that, column.index)
                            }
                            if (!column.isBand || !column.colspan) {
                                rowspan = that.getRowCount();
                                if (!column.command && (!(0, _type.isDefined)(column.groupIndex) || column.showWhenGrouped)) {
                                    rowspan -= getParentBandColumns(column.index, bandColumnsCache.columnParentByIndex).length
                                }
                                if (rowspan > 1) {
                                    column.rowspan = rowspan
                                }
                            }
                        }
                    }
                };
                exports.getValueDataType = function(value) {
                    var dataType = (0, _type.type)(value);
                    if ("string" !== dataType && "boolean" !== dataType && "number" !== dataType && "date" !== dataType && "object" !== dataType) {
                        dataType = void 0
                    }
                    return dataType
                };
                exports.getSerializationFormat = function(dataType, value) {
                    switch (dataType) {
                        case "date":
                        case "datetime":
                            return _date_serialization.default.getDateSerializationFormat(value);
                        case "number":
                            if ((0, _type.isString)(value)) {
                                return "string"
                            }
                            if ((0, _type.isNumeric)(value)) {
                                return null
                            }
                    }
                };
                exports.updateSerializers = function(options, dataType) {
                    if (!options.deserializeValue) {
                        if (_m_utils.default.isDateType(dataType)) {
                            options.deserializeValue = function(value) {
                                return _date_serialization.default.deserializeDate(value)
                            };
                            options.serializeValue = function(value) {
                                return (0, _type.isString)(value) ? value : _date_serialization.default.serializeDate(value, this.serializationFormat)
                            }
                        }
                        if ("number" === dataType) {
                            options.deserializeValue = function(value) {
                                var parsedValue = parseFloat(value);
                                return isNaN(parsedValue) ? value : parsedValue
                            };
                            options.serializeValue = function(value, target) {
                                if ("filter" === target) {
                                    return value
                                }
                                return (0, _type.isDefined)(value) && "string" === this.serializationFormat ? value.toString() : value
                            }
                        }
                    }
                };
                exports.getAlignmentByDataType = function(dataType, isRTL) {
                    switch (dataType) {
                        case "number":
                            return "right";
                        case "boolean":
                            return "center";
                        default:
                            return (0, _position.getDefaultAlignment)(isRTL)
                    }
                };
                var customizeTextForBooleanDataType = function(e) {
                    if (true === e.value) {
                        return this.trueText || "true"
                    }
                    if (false === e.value) {
                        return this.falseText || "false"
                    }
                    return e.valueText || ""
                };
                exports.customizeTextForBooleanDataType = customizeTextForBooleanDataType;
                exports.getCustomizeTextByDataType = function(dataType) {
                    if ("boolean" === dataType) {
                        return customizeTextForBooleanDataType
                    }
                };
                exports.createColumnsFromDataSource = function(that, dataSource) {
                    var firstItems = that._getFirstItems(dataSource);
                    var fieldName;
                    var processedFields = {};
                    var result = [];
                    for (var i = 0; i < firstItems.length; i++) {
                        if (firstItems[i]) {
                            for (fieldName in firstItems[i]) {
                                if (!(0, _type.isFunction)(firstItems[i][fieldName]) || _variable_wrapper.default.isWrapped(firstItems[i][fieldName])) {
                                    processedFields[fieldName] = true
                                }
                            }
                        }
                    }
                    for (fieldName in processedFields) {
                        if (0 !== fieldName.indexOf("__")) {
                            var column = createColumn(that, fieldName);
                            result.push(column)
                        }
                    }
                    return result
                };
                var updateColumnIndexes = function(that) {
                    (0, _iterator.each)(that._columns, (function(index, column) {
                        column.index = index
                    }));
                    (0, _iterator.each)(that._columns, (function(index, column) {
                        if ((0, _type.isObject)(column.ownerBand)) {
                            column.ownerBand = column.ownerBand.index
                        }
                    }));
                    (0, _iterator.each)(that._commandColumns, (function(index, column) {
                        column.index = -(index + 1)
                    }))
                };
                exports.updateColumnIndexes = updateColumnIndexes;
                var updateColumnGroupIndexes = function(that, currentColumn) {
                    (0, _array.normalizeIndexes)(that._columns, "groupIndex", currentColumn, (function(column) {
                        var grouped = column.grouped;
                        delete column.grouped;
                        return grouped
                    }))
                };
                exports.updateColumnGroupIndexes = updateColumnGroupIndexes;
                var updateColumnSortIndexes = function(that, currentColumn) {
                    (0, _iterator.each)(that._columns, (function(index, column) {
                        if ((0, _type.isDefined)(column.sortIndex) && !isSortOrderValid(column.sortOrder)) {
                            delete column.sortIndex
                        }
                    }));
                    (0, _array.normalizeIndexes)(that._columns, "sortIndex", currentColumn, (function(column) {
                        return !(0, _type.isDefined)(column.groupIndex) && isSortOrderValid(column.sortOrder)
                    }))
                };
                exports.updateColumnSortIndexes = updateColumnSortIndexes;
                var updateColumnVisibleIndexes = function(that, currentColumn) {
                    var column;
                    var result = [];
                    var bandColumnsCache = that.getBandColumnsCache();
                    var bandedColumns = [];
                    var columns = that._columns.filter((function(column) {
                        return !column.command
                    }));
                    for (var i = 0; i < columns.length; i++) {
                        column = columns[i];
                        var parentBandColumns = getParentBandColumns(i, bandColumnsCache.columnParentByIndex);
                        if (parentBandColumns.length) {
                            bandedColumns.push(column)
                        } else {
                            result.push(column)
                        }
                    }(0, _array.normalizeIndexes)(bandedColumns, "visibleIndex", currentColumn);
                    (0, _array.normalizeIndexes)(result, "visibleIndex", currentColumn)
                };
                exports.updateColumnVisibleIndexes = updateColumnVisibleIndexes;
                exports.getColumnIndexByVisibleIndex = function(that, visibleIndex, location) {
                    var rowIndex = (0, _type.isObject)(visibleIndex) ? visibleIndex.rowIndex : null;
                    var columns = location === _const.GROUP_LOCATION ? that.getGroupColumns() : location === _const.COLUMN_CHOOSER_LOCATION ? that.getChooserColumns() : that.getVisibleColumns(rowIndex);
                    var column;
                    visibleIndex = (0, _type.isObject)(visibleIndex) ? visibleIndex.columnIndex : visibleIndex;
                    column = columns[visibleIndex];
                    if (column && column.type === _const.GROUP_COMMAND_COLUMN_NAME) {
                        column = that._columns.filter((function(col) {
                            return column.type === col.type
                        }))[0] || column
                    }
                    return column && (0, _type.isDefined)(column.index) ? column.index : -1
                };
                exports.moveColumnToGroup = function(that, column, groupIndex) {
                    var groupColumns = that.getGroupColumns();
                    var i;
                    if (groupIndex >= 0) {
                        for (i = 0; i < groupColumns.length; i++) {
                            if (groupColumns[i].groupIndex >= groupIndex) {
                                groupColumns[i].groupIndex++
                            }
                        }
                    } else {
                        groupIndex = 0;
                        for (i = 0; i < groupColumns.length; i++) {
                            groupIndex = Math.max(groupIndex, groupColumns[i].groupIndex + 1)
                        }
                    }
                    return groupIndex
                };

                function checkUserStateColumn(column, userStateColumn) {
                    return column && userStateColumn && userStateColumn.name === (column.name || column.dataField) && (userStateColumn.dataField === column.dataField || column.name)
                }
                exports.applyUserState = function(that) {
                    var columnsUserState = that._columnsUserState;
                    var ignoreColumnOptionNames = that._ignoreColumnOptionNames || [];
                    var columns = that._columns;
                    var columnCountById = {};
                    var resultColumns = [];
                    var allColumnsHaveState = true;
                    var userStateColumnIndexes = [];
                    var column;
                    var userStateColumnIndex;
                    var i;

                    function applyFieldsState(column, userStateColumn) {
                        if (!userStateColumn) {
                            return
                        }
                        for (var index = 0; index < _const.USER_STATE_FIELD_NAMES.length; index++) {
                            var fieldName = _const.USER_STATE_FIELD_NAMES[index];
                            if (ignoreColumnOptionNames.includes(fieldName)) {
                                continue
                            }
                            if ("dataType" === fieldName) {
                                column[fieldName] = column[fieldName] || userStateColumn[fieldName]
                            } else if (_const.USER_STATE_FIELD_NAMES_15_1.includes(fieldName)) {
                                if (fieldName in userStateColumn) {
                                    column[fieldName] = userStateColumn[fieldName]
                                }
                            } else {
                                if ("selectedFilterOperation" === fieldName && userStateColumn[fieldName]) {
                                    column.defaultSelectedFilterOperation = column[fieldName] || null
                                }
                                column[fieldName] = userStateColumn[fieldName]
                            }
                        }
                    }

                    function findUserStateColumn(columnsUserState, column) {
                        var id = column.name || column.dataField;
                        var count = columnCountById[id] || 0;
                        for (var j = 0; j < columnsUserState.length; j++) {
                            if (checkUserStateColumn(column, columnsUserState[j])) {
                                if (count) {
                                    count--
                                } else {
                                    columnCountById[id] = columnCountById[id] || 0;
                                    columnCountById[id]++;
                                    return j
                                }
                            }
                        }
                        return -1
                    }
                    if (columnsUserState) {
                        for (i = 0; i < columns.length; i++) {
                            userStateColumnIndex = findUserStateColumn(columnsUserState, columns[i]);
                            allColumnsHaveState = allColumnsHaveState && userStateColumnIndex >= 0;
                            userStateColumnIndexes.push(userStateColumnIndex)
                        }
                        for (i = 0; i < columns.length; i++) {
                            column = columns[i];
                            userStateColumnIndex = userStateColumnIndexes[i];
                            if (that._hasUserState || allColumnsHaveState) {
                                applyFieldsState(column, columnsUserState[userStateColumnIndex])
                            }
                            if (userStateColumnIndex >= 0 && (0, _type.isDefined)(columnsUserState[userStateColumnIndex].initialIndex)) {
                                resultColumns[userStateColumnIndex] = column
                            } else {
                                resultColumns.push(column)
                            }
                        }
                        var hasAddedBands = false;
                        for (i = 0; i < columnsUserState.length; i++) {
                            var columnUserState = columnsUserState[i];
                            if (columnUserState.added && findUserStateColumn(columns, columnUserState) < 0) {
                                column = createColumn(that, columnUserState.added);
                                applyFieldsState(column, columnUserState);
                                resultColumns.push(column);
                                if (columnUserState.added.columns) {
                                    hasAddedBands = true
                                }
                            }
                        }
                        if (hasAddedBands) {
                            updateColumnIndexes(that);
                            resultColumns = createColumnsFromOptions(that, resultColumns)
                        }
                        assignColumns(that, resultColumns)
                    }
                };
                var updateIndexes = function(that, column) {
                    updateColumnIndexes(that);
                    updateColumnGroupIndexes(that, column);
                    updateColumnSortIndexes(that, column);
                    resetBandColumnsCache(that);
                    updateColumnVisibleIndexes(that, column)
                };
                exports.updateIndexes = updateIndexes;
                var resetColumnsCache = function(that) {
                    that.resetColumnsCache()
                };
                exports.resetColumnsCache = resetColumnsCache;

                function assignColumns(that, columns) {
                    that._previousColumns = that._columns;
                    that._columns = columns;
                    resetColumnsCache(that);
                    that.updateColumnDataTypes()
                }
                var updateColumnChanges = function(that, changeType, optionName, columnIndex) {
                    var _a;
                    var columnChanges = that._columnChanges || {
                        optionNames: {
                            length: 0
                        },
                        changeTypes: {
                            length: 0
                        },
                        columnIndex: columnIndex
                    };
                    optionName = optionName || "all";
                    optionName = optionName.split(".")[0];
                    var changeTypes = columnChanges.changeTypes;
                    if (changeType && !changeTypes[changeType]) {
                        changeTypes[changeType] = true;
                        changeTypes.length++
                    }
                    var optionNames = columnChanges.optionNames;
                    if (optionName && !optionNames[optionName]) {
                        optionNames[optionName] = true;
                        optionNames.length++
                    }
                    if (void 0 === columnIndex || columnIndex !== columnChanges.columnIndex) {
                        if ((0, _type.isDefined)(columnIndex)) {
                            null !== (_a = columnChanges.columnIndices) && void 0 !== _a ? _a : columnChanges.columnIndices = [];
                            if ((0, _type.isDefined)(columnChanges.columnIndex)) {
                                columnChanges.columnIndices.push(columnChanges.columnIndex)
                            }
                            columnChanges.columnIndices.push(columnIndex)
                        }
                        delete columnChanges.columnIndex
                    }
                    that._columnChanges = columnChanges;
                    resetColumnsCache(that)
                };
                exports.updateColumnChanges = updateColumnChanges;
                exports.fireColumnsChanged = function(that) {
                    var onColumnsChanging = that.option("onColumnsChanging");
                    var columnChanges = that._columnChanges;
                    var reinitOptionNames = ["dataField", "lookup", "dataType", "columns"];
                    if (that.isInitialized() && !that._updateLockCount && columnChanges) {
                        if (onColumnsChanging) {
                            that._updateLockCount++;
                            onColumnsChanging((0, _extend.extend)({
                                component: that.component
                            }, columnChanges));
                            that._updateLockCount--
                        }
                        that._columnChanges = void 0;
                        if (options = columnChanges.optionNames, options && reinitOptionNames.some((function(name) {
                                return options[name]
                            }))) {
                            that._reinitAfterLookupChanges = null === columnChanges || void 0 === columnChanges ? void 0 : columnChanges.optionNames.lookup;
                            that.reinit();
                            that._reinitAfterLookupChanges = void 0
                        } else {
                            that.columnsChanged.fire(columnChanges)
                        }
                    }
                    var options
                };
                var updateSortOrderWhenGrouping = function(that, column, groupIndex, prevGroupIndex) {
                    var columnWasGrouped = prevGroupIndex >= 0;
                    if (groupIndex >= 0) {
                        if (!columnWasGrouped) {
                            column.lastSortOrder = column.sortOrder
                        }
                    } else {
                        var sortMode = that.option("sorting.mode");
                        var sortOrder = column.lastSortOrder;
                        if ("single" === sortMode) {
                            var sortedByAnotherColumn = that._columns.some((function(col) {
                                return col !== column && (0, _type.isDefined)(col.sortIndex)
                            }));
                            if (sortedByAnotherColumn) {
                                sortOrder = void 0
                            }
                        }
                        column.sortOrder = sortOrder
                    }
                };
                exports.updateSortOrderWhenGrouping = updateSortOrderWhenGrouping;
                var fireOptionChanged = function(that, options) {
                    var value = options.value;
                    var optionName = options.optionName;
                    var prevValue = options.prevValue;
                    var fullOptionName = options.fullOptionName;
                    var fullOptionPath = "".concat(fullOptionName, ".").concat(optionName);
                    if (!_const.IGNORE_COLUMN_OPTION_NAMES[optionName] && that._skipProcessingColumnsChange !== fullOptionPath) {
                        that._skipProcessingColumnsChange = fullOptionPath;
                        that.component._notifyOptionChanged(fullOptionPath, value, prevValue);
                        that._skipProcessingColumnsChange = false
                    }
                };
                exports.fireOptionChanged = fireOptionChanged;
                exports.columnOptionCore = function(that, column, optionName, value, notFireEvent) {
                    var optionGetter = (0, _data.compileGetter)(optionName);
                    var columnIndex = column.index;
                    var columns;
                    var changeType;
                    var initialColumn;
                    if (3 === arguments.length) {
                        return optionGetter(column, {
                            functionsAsIs: true
                        })
                    }
                    var prevValue = optionGetter(column, {
                        functionsAsIs: true
                    });
                    if (!(0, _common.equalByValue)(prevValue, value, {
                            maxDepth: 5
                        })) {
                        if ("groupIndex" === optionName || "calculateGroupValue" === optionName) {
                            changeType = "grouping";
                            updateSortOrderWhenGrouping(that, column, value, prevValue)
                        } else if ("sortIndex" === optionName || "sortOrder" === optionName || "calculateSortValue" === optionName) {
                            changeType = "sorting"
                        } else {
                            changeType = "columns"
                        }
                        var optionSetter = (0, _data.compileSetter)(optionName);
                        optionSetter(column, value, {
                            functionsAsIs: true
                        });
                        var fullOptionName = getColumnFullPath(that, column);
                        if (_const.COLUMN_INDEX_OPTIONS[optionName]) {
                            updateIndexes(that, column);
                            value = optionGetter(column)
                        }
                        if ("name" === optionName || "allowEditing" === optionName) {
                            that._checkColumns()
                        }
                        if (!(0, _type.isDefined)(prevValue) && !(0, _type.isDefined)(value) && 0 !== optionName.indexOf("buffer")) {
                            notFireEvent = true
                        }
                        if (!notFireEvent) {
                            if (!_const.USER_STATE_FIELD_NAMES.includes(optionName) && "visibleWidth" !== optionName) {
                                columns = that.option("columns");
                                initialColumn = that.getColumnByPath(fullOptionName, columns);
                                if ((0, _type.isString)(initialColumn)) {
                                    initialColumn = columns[columnIndex] = {
                                        dataField: initialColumn
                                    }
                                }
                                if (initialColumn && checkUserStateColumn(initialColumn, column)) {
                                    optionSetter(initialColumn, value, {
                                        functionsAsIs: true
                                    })
                                }
                            }
                            updateColumnChanges(that, changeType, optionName, columnIndex)
                        } else {
                            resetColumnsCache(that)
                        }
                        fullOptionName && fireOptionChanged(that, {
                            fullOptionName: fullOptionName,
                            optionName: optionName,
                            value: value,
                            prevValue: prevValue
                        })
                    }
                };

                function isSortOrderValid(sortOrder) {
                    return "asc" === sortOrder || "desc" === sortOrder
                }
                exports.addExpandColumn = function(that) {
                    var options = that._getExpandColumnOptions();
                    that.addCommandColumn(options)
                };
                exports.defaultSetCellValue = function(data, value) {
                    if (!this.dataField) {
                        return
                    }
                    var path = this.dataField.split(".");
                    var dotCount = path.length - 1;
                    if (this.serializeValue) {
                        value = this.serializeValue(value)
                    }
                    for (var i = 0; i < dotCount; i++) {
                        var name = path[i];
                        data = data[name] = data[name] || {}
                    }
                    data[path[dotCount]] = value
                };
                exports.getDataColumns = function getDataColumns(columns, rowIndex, bandColumnID) {
                    var result = [];
                    rowIndex = rowIndex || 0;
                    columns[rowIndex] && (0, _iterator.each)(columns[rowIndex], (function(_, column) {
                        if (column.ownerBand === bandColumnID || column.type === _const.GROUP_COMMAND_COLUMN_NAME) {
                            if (!column.isBand || !column.colspan) {
                                if (!column.command || rowIndex < 1) {
                                    result.push(column)
                                }
                            } else {
                                result.push.apply(result, getDataColumns(columns, rowIndex + 1, column.index))
                            }
                        }
                    }));
                    return result
                };
                exports.getRowCount = function(that) {
                    var rowCount = 1;
                    var bandColumnsCache = that.getBandColumnsCache();
                    var columnParentByIndex = bandColumnsCache.columnParentByIndex;
                    that._columns.forEach((function(column) {
                        var parents = getParentBandColumns(column.index, columnParentByIndex);
                        var invisibleParents = parents.filter((function(column) {
                            return !column.visible
                        }));
                        if (column.visible && !invisibleParents.length) {
                            rowCount = Math.max(rowCount, parents.length + 1)
                        }
                    }));
                    return rowCount
                };
                var isCustomCommandColumn = function(that, commandColumn) {
                    var customCommandColumns = that._columns.filter((function(column) {
                        return column.type === commandColumn.type
                    }));
                    return !!customCommandColumns.length
                };
                exports.isCustomCommandColumn = isCustomCommandColumn;
                exports.getFixedPosition = function(that, column) {
                    var rtlEnabled = that.option("rtlEnabled");
                    if (column.command && !isCustomCommandColumn(that, column) || !column.fixedPosition) {
                        return rtlEnabled ? "right" : "left"
                    }
                    return column.fixedPosition
                };
                exports.processExpandColumns = function(columns, expandColumns, type, columnIndex) {
                    var customColumnIndex;
                    var rowCount = this.getRowCount();
                    var rowspan = columns[columnIndex] && columns[columnIndex].rowspan;
                    var expandColumnsByType = expandColumns.filter((function(column) {
                        return column.type === type
                    }));
                    columns.forEach((function(column, index) {
                        if (column.type === type) {
                            customColumnIndex = index;
                            rowspan = columns[index + 1] ? columns[index + 1].rowspan : rowCount
                        }
                    }));
                    if (rowspan > 1) {
                        expandColumnsByType = (0, _iterator.map)(expandColumnsByType, (function(expandColumn) {
                            return (0, _extend.extend)({}, expandColumn, {
                                rowspan: rowspan
                            })
                        }))
                    }
                    expandColumnsByType.unshift.apply(expandColumnsByType, (0, _type.isDefined)(customColumnIndex) ? [customColumnIndex, 1] : [columnIndex, 0]);
                    columns.splice.apply(columns, expandColumnsByType);
                    return rowspan || 1
                };
                exports.digitsCount = function(number) {
                    var i;
                    for (i = 0; number > 1; i++) {
                        number /= 10
                    }
                    return i
                };
                exports.numberToString = function(number, digitsCount) {
                    var str = number ? number.toString() : "0";
                    while (str.length < digitsCount) {
                        str = "0".concat(str)
                    }
                    return str
                };
                exports.mergeColumns = function(that, columns, commandColumns, needToExtend) {
                    var column;
                    var commandColumnIndex;
                    var result = columns.slice().map((function(column) {
                        return (0, _extend.extend)({}, column)
                    }));
                    var isColumnFixing = that._isColumnFixing();
                    var defaultCommandColumns = commandColumns.slice().map((function(column) {
                        return (0, _extend.extend)({
                            fixed: isColumnFixing
                        }, column)
                    }));
                    var getCommandColumnIndex = function(column) {
                        return commandColumns.reduce((function(result, commandColumn, index) {
                            var columnType = needToExtend && column.type === _const.GROUP_COMMAND_COLUMN_NAME ? "expand" : column.type;
                            return commandColumn.type === columnType || commandColumn.command === column.command ? index : result
                        }), -1)
                    };
                    var callbackFilter = function(commandColumn) {
                        return commandColumn.command !== commandColumns[commandColumnIndex].command
                    };
                    for (var i = 0; i < columns.length; i++) {
                        column = columns[i];
                        commandColumnIndex = column && (column.type || column.command) ? getCommandColumnIndex(column) : -1;
                        if (commandColumnIndex >= 0) {
                            if (needToExtend) {
                                result[i] = (0, _extend.extend)({
                                    fixed: isColumnFixing
                                }, commandColumns[commandColumnIndex], column);
                                if (column.type !== _const.GROUP_COMMAND_COLUMN_NAME) {
                                    defaultCommandColumns = defaultCommandColumns.filter(callbackFilter)
                                }
                            } else {
                                var columnOptions = {
                                    visibleIndex: column.visibleIndex,
                                    index: column.index,
                                    headerId: column.headerId,
                                    allowFixing: 0 === column.groupIndex,
                                    allowReordering: 0 === column.groupIndex,
                                    groupIndex: column.groupIndex
                                };
                                result[i] = (0, _extend.extend)({}, column, commandColumns[commandColumnIndex], column.type === _const.GROUP_COMMAND_COLUMN_NAME && columnOptions)
                            }
                        }
                    }
                    if (columns.length && needToExtend && defaultCommandColumns.length) {
                        result = result.concat(defaultCommandColumns)
                    }
                    return result
                };
                exports.isColumnFixed = function(that, column) {
                    return (0, _type.isDefined)(column.fixed) || !column.type ? column.fixed : that._isColumnFixing()
                };
                exports.convertOwnerBandToColumnReference = function(columns) {
                    columns.forEach((function(column) {
                        if ((0, _type.isDefined)(column.ownerBand)) {
                            column.ownerBand = columns[column.ownerBand]
                        }
                    }))
                };
                var resetBandColumnsCache = function(that) {
                    that._bandColumnsCache = void 0
                };
                exports.resetBandColumnsCache = resetBandColumnsCache;
                exports.findColumn = function(columns, identifier) {
                    var identifierOptionName = (0, _type.isString)(identifier) && identifier.substr(0, identifier.indexOf(":"));
                    var column;
                    if (void 0 === identifier) {
                        return
                    }
                    if (identifierOptionName) {
                        identifier = identifier.substr(identifierOptionName.length + 1)
                    }
                    if (identifierOptionName) {
                        column = columns.filter((function(column) {
                            return "".concat(column[identifierOptionName]) === identifier
                        }))[0]
                    } else {
                        ["index", "name", "dataField", "caption"].some((function(optionName) {
                            column = columns.filter((function(column) {
                                return column[optionName] === identifier
                            }))[0];
                            return !!column
                        }))
                    }
                    return column
                };
                exports.sortColumns = function(columns, sortOrder) {
                    if ("asc" !== sortOrder && "desc" !== sortOrder) {
                        return columns
                    }
                    var sign = "asc" === sortOrder ? 1 : -1;
                    columns.sort((function(column1, column2) {
                        var caption1 = column1.caption || "";
                        var caption2 = column2.caption || "";
                        return sign * caption1.localeCompare(caption2)
                    }));
                    return columns
                };
                exports.strictParseNumber = function(text, format) {
                    var parsedValue = _number.default.parse(text);
                    if ((0, _type.isNumeric)(parsedValue)) {
                        var formattedValue = _number.default.format(parsedValue, format);
                        var formattedValueWithDefaultFormat = _number.default.format(parsedValue, "decimal");
                        if (formattedValue === text || formattedValueWithDefaultFormat === text) {
                            return parsedValue
                        }
                    }
                }
            },
        49505:
            /*!*************************************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/columns_resizing_reordering/m_columns_resizing_reordering.js ***!
              \*************************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.columnsResizingReorderingModule = void 0;
                var _fx = _interopRequireDefault(__webpack_require__( /*! ../../../../animation/fx */ 87209));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../../core/dom_adapter */ 73349));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/callbacks */ 44504));
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _position = __webpack_require__( /*! ../../../../core/utils/position */ 37518);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 55994));
                var _drag = __webpack_require__( /*! ../../../../events/drag */ 23174);
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../../../../events/pointer */ 93786));
                var _index = __webpack_require__( /*! ../../../../events/utils/index */ 39611);
                var _swatch_container = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/swatch_container */ 92591));
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _inheritsLoose(subClass, superClass) {
                    subClass.prototype = Object.create(superClass.prototype);
                    subClass.prototype.constructor = subClass;
                    _setPrototypeOf(subClass, superClass)
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var MODULE_NAMESPACE = "dxDataGridResizingReordering";
                var allowResizing = function(that) {
                    return that.option("allowColumnResizing") || that.getController("columns").isColumnOptionUsed("allowResizing")
                };
                var allowReordering = function(that) {
                    return that.option("allowColumnReordering") || that.getController("columns").isColumnOptionUsed("allowReordering")
                };
                var TrackerView = function(_modules$View) {
                    _inheritsLoose(TrackerView, _modules$View);

                    function TrackerView() {
                        return _modules$View.apply(this, arguments) || this
                    }
                    var _proto = TrackerView.prototype;
                    _proto._renderCore = function() {
                        var deferred = _modules$View.prototype._renderCore.call(this);
                        this.element().addClass(this.addWidgetPrefix("tracker"));
                        this.hide();
                        return deferred
                    };
                    _proto._unsubscribeFromCallback = function() {
                        if (this._positionChanged) {
                            this._tablePositionController.positionChanged.remove(this._positionChanged)
                        }
                    };
                    _proto._subscribeToCallback = function() {
                        var that = this;
                        that._positionChanged = function(position) {
                            var $element = that.element();
                            if ($element && $element.hasClass(that.addWidgetPrefix("tracker"))) {
                                $element.css({
                                    top: position.top
                                });
                                (0, _size.setHeight)($element, position.height)
                            }
                        };
                        this._tablePositionController.positionChanged.add(that._positionChanged)
                    };
                    _proto.optionChanged = function(args) {
                        if ("allowColumnResizing" === args.name) {
                            this._unsubscribeFromCallback();
                            if (args.value) {
                                this._subscribeToCallback();
                                this._invalidate()
                            }
                        }
                        _modules$View.prototype.optionChanged.call(this, args)
                    };
                    _proto.init = function() {
                        _modules$View.prototype.init.call(this);
                        this._tablePositionController = this.getController("tablePosition");
                        this._subscribeToCallback()
                    };
                    _proto.isVisible = function() {
                        return allowResizing(this)
                    };
                    _proto.show = function() {
                        this.element().show()
                    };
                    _proto.hide = function() {
                        this.element() && this.element().hide()
                    };
                    _proto.setHeight = function(value) {
                        (0, _size.setHeight)(this.element(), value)
                    };
                    _proto.dispose = function() {
                        this._unsubscribeFromCallback();
                        _modules$View.prototype.dispose.call(this)
                    };
                    return TrackerView
                }(_m_modules.default.View);
                var SeparatorView = function(_modules$View2) {
                    _inheritsLoose(SeparatorView, _modules$View2);

                    function SeparatorView() {
                        return _modules$View2.apply(this, arguments) || this
                    }
                    var _proto2 = SeparatorView.prototype;
                    _proto2._renderSeparator = function() {};
                    _proto2._renderCore = function(options) {
                        var deferred = _modules$View2.prototype._renderCore.call(this, options);
                        this._isShown = true;
                        this._renderSeparator();
                        this.hide();
                        return deferred
                    };
                    _proto2.show = function() {
                        this._isShown = true
                    };
                    _proto2.hide = function() {
                        this._isShown = false
                    };
                    _proto2.height = function(value) {
                        var $element = this.element();
                        if ($element) {
                            if ((0, _type.isDefined)(value)) {
                                (0, _size.setHeight)($element, value)
                            } else {
                                return (0, _size.getHeight)($element)
                            }
                        }
                    };
                    _proto2.width = function(value) {
                        var $element = this.element();
                        if ($element) {
                            if ((0, _type.isDefined)(value)) {
                                (0, _size.setWidth)($element, value)
                            } else {
                                return (0, _size.getWidth)($element)
                            }
                        }
                    };
                    return SeparatorView
                }(_m_modules.default.View);
                var ColumnsSeparatorView = function(_SeparatorView) {
                    _inheritsLoose(ColumnsSeparatorView, _SeparatorView);

                    function ColumnsSeparatorView() {
                        return _SeparatorView.apply(this, arguments) || this
                    }
                    var _proto3 = ColumnsSeparatorView.prototype;
                    _proto3._renderSeparator = function() {
                        _SeparatorView.prototype._renderSeparator.call(this);
                        var $element = this.element();
                        $element.addClass(this.addWidgetPrefix("columns-separator"))
                    };
                    _proto3._subscribeToCallback = function() {
                        var that = this;
                        var $element;
                        that._positionChanged = function(position) {
                            $element = that.element();
                            if ($element) {
                                $element.css({
                                    top: position.top
                                });
                                (0, _size.setHeight)($element, position.height)
                            }
                        };
                        that._tablePositionController.positionChanged.add(that._positionChanged)
                    };
                    _proto3._unsubscribeFromCallback = function() {
                        this._positionChanged && this._tablePositionController.positionChanged.remove(this._positionChanged)
                    };
                    _proto3._init = function() {
                        this._isTransparent = allowResizing(this);
                        if (this.isVisible()) {
                            this._subscribeToCallback()
                        }
                    };
                    _proto3.isVisible = function() {
                        return this.option("showColumnHeaders") && (allowReordering(this) || allowResizing(this))
                    };
                    _proto3.optionChanged = function(args) {
                        if ("allowColumnResizing" === args.name) {
                            if (args.value) {
                                this._init();
                                this._invalidate();
                                this.hide(true)
                            } else {
                                this._unsubscribeFromCallback();
                                this._isTransparent = allowResizing(this);
                                this.hide(true)
                            }
                        }
                        _SeparatorView.prototype.optionChanged.call(this, args)
                    };
                    _proto3.init = function() {
                        _SeparatorView.prototype.init.call(this);
                        this._tablePositionController = this.getController("tablePosition");
                        this._init()
                    };
                    _proto3.show = function() {
                        var $element = this.element();
                        if ($element && !this._isShown) {
                            if (this._isTransparent) {
                                $element.removeClass(this.addWidgetPrefix("columns-separator-transparent"))
                            } else {
                                $element.show()
                            }
                        }
                        _SeparatorView.prototype.show.call(this)
                    };
                    _proto3.hide = function(force) {
                        var $element = this.element();
                        var columnsSeparatorTransparent = this.addWidgetPrefix("columns-separator-transparent");
                        if ($element && (this._isShown || force)) {
                            if (this._isTransparent) {
                                $element.addClass(columnsSeparatorTransparent);
                                $element.css("left", "");
                                $element.show()
                            } else {
                                if ($element.hasClass(columnsSeparatorTransparent)) {
                                    $element.removeClass(columnsSeparatorTransparent)
                                }
                                $element.hide()
                            }
                        }
                        _SeparatorView.prototype.hide.call(this)
                    };
                    _proto3.moveByX = function(outerX) {
                        var $element = this.element();
                        if ($element) {
                            $element.css("left", null === outerX ? 0 : outerX - this._parentElement().offset().left)
                        }
                    };
                    _proto3.changeCursor = function(cursorName) {
                        cursorName = (0, _type.isDefined)(cursorName) ? cursorName : "";
                        var $element = this.element();
                        if ($element) {
                            $element.css("cursor", cursorName)
                        }
                    };
                    _proto3.dispose = function() {
                        this._unsubscribeFromCallback();
                        _SeparatorView.prototype.dispose.call(this)
                    };
                    return ColumnsSeparatorView
                }(SeparatorView);
                var BlockSeparatorView = function(_SeparatorView2) {
                    _inheritsLoose(BlockSeparatorView, _SeparatorView2);

                    function BlockSeparatorView() {
                        return _SeparatorView2.apply(this, arguments) || this
                    }
                    var _proto4 = BlockSeparatorView.prototype;
                    _proto4.init = function() {
                        var that = this;
                        _SeparatorView2.prototype.init.call(this);
                        this.getController("data").loadingChanged.add((function(isLoading) {
                            if (!isLoading) {
                                that.hide()
                            }
                        }))
                    };
                    _proto4._renderSeparator = function() {
                        _SeparatorView2.prototype._renderSeparator.call(this);
                        this.element().addClass("dx-block-separator").html("&nbsp;")
                    };
                    _proto4.hide = function() {
                        var $parent = this._parentElement();
                        var $element = this.element();
                        if ($element && this._isShown) {
                            $element.css("display", "none")
                        }
                        if ($parent && !$parent.children(".".concat("dx-block-separator")).length) {
                            $parent.prepend(this.element())
                        }
                        _SeparatorView2.prototype.hide.call(this)
                    };
                    _proto4.isVisible = function() {
                        var groupPanelOptions = this.option("groupPanel");
                        var columnChooserOptions = this.option("columnChooser");
                        return groupPanelOptions && groupPanelOptions.visible || columnChooserOptions && columnChooserOptions.enabled
                    };
                    _proto4.show = function(targetLocation) {
                        var $element = this.element();
                        var startAnimate = function(toOptions) {
                            _fx.default.stop($element, true);
                            _fx.default.animate($element, {
                                type: "slide",
                                from: {
                                    width: 0,
                                    display: toOptions.display
                                },
                                to: toOptions,
                                duration: 300,
                                easing: "swing"
                            })
                        };
                        if ($element && !this._isShown) {
                            switch (targetLocation) {
                                case "group":
                                    startAnimate({
                                        width: "50px",
                                        display: "inline-block"
                                    });
                                    break;
                                case "columnChooser":
                                    startAnimate({
                                        width: "100%",
                                        display: "block"
                                    });
                                    break;
                                default:
                                    $element.css("display", "")
                            }
                        }
                        _SeparatorView2.prototype.show.call(this)
                    };
                    return BlockSeparatorView
                }(SeparatorView);
                var DraggingHeaderView = function(_modules$View3) {
                    _inheritsLoose(DraggingHeaderView, _modules$View3);

                    function DraggingHeaderView() {
                        return _modules$View3.apply(this, arguments) || this
                    }
                    var _proto5 = DraggingHeaderView.prototype;
                    _proto5.isDragging = function() {
                        return this._isDragging
                    };
                    _proto5._getDraggingPanelByPos = function(pos) {
                        var result;
                        (0, _iterator.each)(this._dragOptions.draggingPanels, (function(index, draggingPanel) {
                            if (draggingPanel) {
                                var boundingRect = draggingPanel.getBoundingRect();
                                if (boundingRect && (void 0 === boundingRect.bottom || pos.y < boundingRect.bottom) && (void 0 === boundingRect.top || pos.y > boundingRect.top) && (void 0 === boundingRect.left || pos.x > boundingRect.left) && (void 0 === boundingRect.right || pos.x < boundingRect.right)) {
                                    result = draggingPanel;
                                    return false
                                }
                            }
                            return
                        }));
                        return result
                    };
                    _proto5._renderCore = function() {
                        this.element().addClass("".concat(this.addWidgetPrefix("drag-header"), " ").concat(this.addWidgetPrefix("text-content"), " ").concat("dx-widget")).hide()
                    };
                    _proto5._resetTargetColumnOptions = function() {
                        var params = this._dropOptions;
                        params.targetColumnIndex = -1;
                        delete params.targetColumnElement;
                        delete params.isLast;
                        delete params.posX;
                        delete params.posY
                    };
                    _proto5._getVisibleIndexObject = function(rowIndex, visibleIndex) {
                        if ((0, _type.isDefined)(rowIndex)) {
                            return {
                                columnIndex: visibleIndex,
                                rowIndex: rowIndex
                            }
                        }
                        return visibleIndex
                    };
                    _proto5.dispose = function() {
                        var element = this.element();
                        this._dragOptions = null;
                        element && element.parent().find(".".concat(this.addWidgetPrefix("drag-header"))).remove()
                    };
                    _proto5.isVisible = function() {
                        var columnsController = this.getController("columns");
                        var commonColumnSettings = columnsController.getCommonSettings();
                        return this.option("showColumnHeaders") && (allowReordering(this) || commonColumnSettings.allowGrouping || commonColumnSettings.allowHiding)
                    };
                    _proto5.init = function() {
                        var that = this;
                        _modules$View3.prototype.init.call(this);
                        this._controller = this.getController("draggingHeader");
                        this._columnsResizerViewController = this.getController("columnsResizer");
                        this._isDragging = false;
                        this.getController("data").loadingChanged.add((function(isLoading) {
                            var element = that.element();
                            if (!isLoading && element) {
                                element.hide()
                            }
                        }))
                    };
                    _proto5.dragHeader = function(options) {
                        var columnElement = options.columnElement;
                        var isCommandColumn = !!options.sourceColumn.type;
                        this._isDragging = true;
                        this._dragOptions = options;
                        this._dropOptions = {
                            sourceIndex: options.index,
                            sourceColumnIndex: this._getVisibleIndexObject(options.rowIndex, options.columnIndex),
                            sourceColumnElement: options.columnElement,
                            sourceLocation: options.sourceLocation
                        };
                        var document = _dom_adapter.default.getDocument();
                        this._onSelectStart = document.onselectstart;
                        document.onselectstart = function() {
                            return false
                        };
                        this._controller.drag(this._dropOptions);
                        this.element().css({
                            textAlign: columnElement && columnElement.css("textAlign"),
                            height: columnElement && (isCommandColumn && columnElement.get(0).clientHeight || (0, _size.getHeight)(columnElement)),
                            width: columnElement && (isCommandColumn && columnElement.get(0).clientWidth || (0, _size.getWidth)(columnElement)),
                            whiteSpace: columnElement && columnElement.css("whiteSpace")
                        }).addClass(this.addWidgetPrefix("drag-action")).toggleClass("dx-drag-command-cell", isCommandColumn).text(isCommandColumn ? "" : options.sourceColumn.caption);
                        this.element().appendTo(_swatch_container.default.getSwatchContainer(columnElement))
                    };
                    _proto5.moveHeader = function(args) {
                        var e = args.event;
                        var that = e.data.that;
                        var eventData = (0, _index.eventData)(e);
                        var isResizing = that._columnsResizerViewController ? that._columnsResizerViewController.isResizing() : false;
                        var dragOptions = that._dragOptions;
                        if (that._isDragging && !isResizing) {
                            var $element = that.element();
                            var moveDeltaX = Math.abs(eventData.x - dragOptions.columnElement.offset().left - dragOptions.deltaX);
                            var moveDeltaY = Math.abs(eventData.y - dragOptions.columnElement.offset().top - dragOptions.deltaY);
                            if ($element.is(":visible") || moveDeltaX > 5 || moveDeltaY > 5) {
                                $element.show();
                                var newLeft = eventData.x - dragOptions.deltaX;
                                var newTop = eventData.y - dragOptions.deltaY;
                                $element.css({
                                    left: newLeft,
                                    top: newTop
                                });
                                that.dockHeader(eventData)
                            }
                            e.preventDefault()
                        }
                    };
                    _proto5.dockHeader = function(eventData) {
                        var targetDraggingPanel = this._getDraggingPanelByPos(eventData);
                        var controller = this._controller;
                        var params = this._dropOptions;
                        var dragOptions = this._dragOptions;
                        if (targetDraggingPanel) {
                            var rtlEnabled = this.option("rtlEnabled");
                            var isVerticalOrientation = "columnChooser" === targetDraggingPanel.getName();
                            var axisName = isVerticalOrientation ? "y" : "x";
                            var targetLocation = targetDraggingPanel.getName();
                            var rowIndex = "headers" === targetLocation ? dragOptions.rowIndex : void 0;
                            var sourceColumn = dragOptions.sourceColumn;
                            var columnElements = targetDraggingPanel.getColumnElements(rowIndex, null === sourceColumn || void 0 === sourceColumn ? void 0 : sourceColumn.ownerBand) || [];
                            var pointsByTarget = dragOptions.pointsByTarget = dragOptions.pointsByTarget || {};
                            var pointsByColumns = "columnChooser" === targetLocation ? [] : pointsByTarget[targetLocation] || controller._generatePointsByColumns((0, _extend.extend)({}, dragOptions, {
                                targetDraggingPanel: targetDraggingPanel,
                                columns: targetDraggingPanel.getColumns(rowIndex),
                                columnElements: columnElements,
                                isVerticalOrientation: isVerticalOrientation,
                                startColumnIndex: "headers" === targetLocation && (0, _renderer.default)(columnElements[0]).index()
                            }));
                            pointsByTarget[targetLocation] = pointsByColumns;
                            params.targetLocation = targetLocation;
                            if (pointsByColumns.length > 0) {
                                for (var i = 0; i < pointsByColumns.length; i++) {
                                    var centerPosition = pointsByColumns[i + 1] && (pointsByColumns[i][axisName] + pointsByColumns[i + 1][axisName]) / 2;
                                    if (void 0 === centerPosition || (rtlEnabled && "x" === axisName ? eventData[axisName] > centerPosition : eventData[axisName] < centerPosition)) {
                                        params.targetColumnIndex = this._getVisibleIndexObject(rowIndex, pointsByColumns[i].columnIndex);
                                        if (columnElements[i]) {
                                            params.targetColumnElement = columnElements.eq(i);
                                            params.isLast = false
                                        } else {
                                            params.targetColumnElement = columnElements.last();
                                            params.isLast = true
                                        }
                                        params.posX = pointsByColumns[i].x;
                                        params.posY = pointsByColumns[i].y;
                                        controller.dock(params);
                                        break
                                    }
                                }
                            } else {
                                this._resetTargetColumnOptions();
                                controller.dock(params)
                            }
                        }
                    };
                    _proto5.dropHeader = function(args) {
                        var e = args.event;
                        var that = e.data.that;
                        var controller = that._controller;
                        that.element().hide();
                        if (controller && that._isDragging) {
                            controller.drop(that._dropOptions)
                        }
                        that.element().appendTo(that._parentElement());
                        that._dragOptions = null;
                        that._dropOptions = null;
                        that._isDragging = false;
                        _dom_adapter.default.getDocument().onselectstart = that._onSelectStart || null
                    };
                    return DraggingHeaderView
                }(_m_modules.default.View);
                var isNextColumnResizingMode = function(that) {
                    return "widget" !== that.option("columnResizingMode")
                };
                var ColumnsResizerViewController = function(_modules$ViewControll) {
                    _inheritsLoose(ColumnsResizerViewController, _modules$ViewControll);

                    function ColumnsResizerViewController() {
                        return _modules$ViewControll.apply(this, arguments) || this
                    }
                    var _proto6 = ColumnsResizerViewController.prototype;
                    _proto6._isHeadersRowArea = function(posY) {
                        if (this._columnHeadersView) {
                            var element = this._columnHeadersView.element();
                            if (element) {
                                var offsetTop = element.offset().top;
                                var headersRowHeight = this._columnHeadersView.getHeadersRowHeight();
                                return posY >= offsetTop && posY <= offsetTop + headersRowHeight
                            }
                        }
                        return false
                    };
                    _proto6._isRtlParentStyle = function() {
                        var _a;
                        return this.option("rtlEnabled") && "rtl" === (null === (_a = this._$parentContainer) || void 0 === _a ? void 0 : _a.parent().css("direction"))
                    };
                    _proto6._pointCreated = function(point, cellsLength, columns) {
                        var isNextColumnMode = isNextColumnResizingMode(this);
                        var rtlEnabled = this.option("rtlEnabled");
                        var isRtlParentStyle = this._isRtlParentStyle();
                        var firstPointColumnIndex = !isNextColumnMode && rtlEnabled && !isRtlParentStyle ? 0 : 1;
                        if (point.index >= firstPointColumnIndex && point.index < cellsLength + (!isNextColumnMode && (!rtlEnabled || isRtlParentStyle) ? 1 : 0)) {
                            point.columnIndex -= firstPointColumnIndex;
                            var currentColumn = columns[point.columnIndex] || {};
                            var nextColumn = columns[point.columnIndex + 1] || {};
                            return !(isNextColumnMode ? currentColumn.allowResizing && nextColumn.allowResizing : currentColumn.allowResizing)
                        }
                        return true
                    };
                    _proto6._getTargetPoint = function(pointsByColumns, currentX, deltaX) {
                        if (pointsByColumns) {
                            for (var i = 0; i < pointsByColumns.length; i++) {
                                if (pointsByColumns[i].x === pointsByColumns[0].x && pointsByColumns[i + 1] && pointsByColumns[i].x === pointsByColumns[i + 1].x) {
                                    continue
                                }
                                if (pointsByColumns[i].x - deltaX <= currentX && currentX <= pointsByColumns[i].x + deltaX) {
                                    return pointsByColumns[i]
                                }
                            }
                        }
                        return null
                    };
                    _proto6._moveSeparator = function(args) {
                        var _a;
                        var e = args.event;
                        var that = e.data;
                        var columnsSeparatorWidth = that._columnsSeparatorView.width();
                        var isNextColumnMode = isNextColumnResizingMode(that);
                        var deltaX = columnsSeparatorWidth / 2;
                        var parentOffset = that._$parentContainer.offset();
                        var parentOffsetLeft = parentOffset.left;
                        var eventData = (0, _index.eventData)(e);
                        var rtlEnabled = that.option("rtlEnabled");
                        var isRtlParentStyle = this._isRtlParentStyle();
                        var isDragging = null === (_a = that._draggingHeaderView) || void 0 === _a ? void 0 : _a.isDragging();
                        if (that._isResizing && that._resizingInfo) {
                            if ((parentOffsetLeft <= eventData.x || !isNextColumnMode && isRtlParentStyle) && (!isNextColumnMode || eventData.x <= parentOffsetLeft + (0, _size.getWidth)(that._$parentContainer))) {
                                if (that._updateColumnsWidthIfNeeded(eventData.x)) {
                                    var $cell = that._columnHeadersView.getColumnElements().eq(that._resizingInfo.currentColumnIndex);
                                    var cell = $cell[0];
                                    if (cell) {
                                        var outerWidth = cell.getBoundingClientRect().width;
                                        that._columnsSeparatorView.moveByX($cell.offset().left + ((isNextColumnMode || isRtlParentStyle) && rtlEnabled ? 0 : outerWidth));
                                        that._tablePositionController.update(that._targetPoint.y);
                                        e.preventDefault()
                                    }
                                }
                            }
                        } else if (!isDragging) {
                            if (that._isHeadersRowArea(eventData.y)) {
                                if (that._previousParentOffset) {
                                    if (that._previousParentOffset.left !== parentOffset.left || that._previousParentOffset.top !== parentOffset.top) {
                                        that.pointsByColumns(null)
                                    }
                                }
                                that._targetPoint = that._getTargetPoint(that.pointsByColumns(), eventData.x, columnsSeparatorWidth);
                                that._previousParentOffset = parentOffset;
                                that._isReadyResizing = false;
                                if (that._targetPoint) {
                                    that._columnsSeparatorView.changeCursor("col-resize");
                                    that._columnsSeparatorView.moveByX(that._targetPoint.x - deltaX);
                                    that._tablePositionController.update(that._targetPoint.y);
                                    that._isReadyResizing = true;
                                    e.preventDefault()
                                } else {
                                    that._columnsSeparatorView.changeCursor();
                                    that._columnsSeparatorView.moveByX(null)
                                }
                            } else {
                                that.pointsByColumns(null);
                                that._isReadyResizing = false;
                                that._columnsSeparatorView.changeCursor();
                                that._columnsSeparatorView.moveByX(null)
                            }
                        }
                    };
                    _proto6._endResizing = function(args) {
                        var e = args.event;
                        var that = e.data;
                        if (that._isResizing) {
                            that.pointsByColumns(null);
                            that._resizingInfo = null;
                            that._columnsSeparatorView.hide();
                            that._columnsSeparatorView.changeCursor();
                            that._trackerView.hide();
                            that._isReadyResizing = false;
                            that._isResizing = false
                        }
                    };
                    _proto6._getNextColumnIndex = function(currentColumnIndex) {
                        return currentColumnIndex + 1
                    };
                    _proto6._setupResizingInfo = function(posX) {
                        var currentColumnIndex = this._targetPoint.columnIndex;
                        var nextColumnIndex = this._getNextColumnIndex(currentColumnIndex);
                        var currentHeader = this._columnHeadersView.getHeaderElement(currentColumnIndex);
                        var nextHeader = this._columnHeadersView.getHeaderElement(nextColumnIndex);
                        this._resizingInfo = {
                            startPosX: posX,
                            currentColumnIndex: currentColumnIndex,
                            currentColumnWidth: currentHeader && currentHeader.length > 0 ? (0, _position.getBoundingRect)(currentHeader[0]).width : 0,
                            nextColumnIndex: nextColumnIndex,
                            nextColumnWidth: nextHeader && nextHeader.length > 0 ? (0, _position.getBoundingRect)(nextHeader[0]).width : 0
                        }
                    };
                    _proto6._startResizing = function(args) {
                        var e = args.event;
                        var that = e.data;
                        var eventData = (0, _index.eventData)(e);
                        if ((0, _index.isTouchEvent)(e)) {
                            if (that._isHeadersRowArea(eventData.y)) {
                                that._targetPoint = that._getTargetPoint(that.pointsByColumns(), eventData.x, 10);
                                if (that._targetPoint) {
                                    that._columnsSeparatorView.moveByX(that._targetPoint.x - that._columnsSeparatorView.width() / 2);
                                    that._isReadyResizing = true
                                }
                            } else {
                                that._isReadyResizing = false
                            }
                        }
                        if (that._isReadyResizing) {
                            that._setupResizingInfo(eventData.x);
                            that._isResizing = true;
                            that._tablePositionController.update(that._targetPoint.y);
                            that._columnsSeparatorView.show();
                            that._trackerView.show();
                            var scrollable = that.component.getScrollable();
                            if (scrollable && that._isRtlParentStyle()) {
                                that._scrollRight = (0, _size.getWidth)(scrollable.$content()) - (0, _size.getWidth)(scrollable.container()) - scrollable.scrollLeft()
                            }
                            e.preventDefault();
                            e.stopPropagation()
                        }
                        if (this.isResizing()) {
                            this.getController("editorFactory").loseFocus()
                        }
                    };
                    _proto6._generatePointsByColumns = function() {
                        var that = this;
                        var columns = that._columnsController ? that._columnsController.getVisibleColumns() : [];
                        var cells = that._columnHeadersView.getColumnElements();
                        var pointsByColumns = [];
                        if (cells && cells.length > 0) {
                            pointsByColumns = _m_utils.default.getPointsByColumns(cells, (function(point) {
                                return that._pointCreated(point, cells.length, columns)
                            }))
                        }
                        that._pointsByColumns = pointsByColumns
                    };
                    _proto6._unsubscribeFromEvents = function() {
                        this._moveSeparatorHandler && _events_engine.default.off(_dom_adapter.default.getDocument(), (0, _index.addNamespace)(_pointer.default.move, MODULE_NAMESPACE), this._moveSeparatorHandler);
                        this._startResizingHandler && _events_engine.default.off(this._$parentContainer, (0, _index.addNamespace)(_pointer.default.down, MODULE_NAMESPACE), this._startResizingHandler);
                        if (this._endResizingHandler) {
                            _events_engine.default.off(this._columnsSeparatorView.element(), (0, _index.addNamespace)(_pointer.default.up, MODULE_NAMESPACE), this._endResizingHandler);
                            _events_engine.default.off(_dom_adapter.default.getDocument(), (0, _index.addNamespace)(_pointer.default.up, MODULE_NAMESPACE), this._endResizingHandler)
                        }
                    };
                    _proto6._subscribeToEvents = function() {
                        this._moveSeparatorHandler = this.createAction(this._moveSeparator);
                        this._startResizingHandler = this.createAction(this._startResizing);
                        this._endResizingHandler = this.createAction(this._endResizing);
                        _events_engine.default.on(_dom_adapter.default.getDocument(), (0, _index.addNamespace)(_pointer.default.move, MODULE_NAMESPACE), this, this._moveSeparatorHandler);
                        _events_engine.default.on(this._$parentContainer, (0, _index.addNamespace)(_pointer.default.down, MODULE_NAMESPACE), this, this._startResizingHandler);
                        _events_engine.default.on(this._columnsSeparatorView.element(), (0, _index.addNamespace)(_pointer.default.up, MODULE_NAMESPACE), this, this._endResizingHandler);
                        _events_engine.default.on(_dom_adapter.default.getDocument(), (0, _index.addNamespace)(_pointer.default.up, MODULE_NAMESPACE), this, this._endResizingHandler)
                    };
                    _proto6._updateColumnsWidthIfNeeded = function(posX) {
                        var deltaX;
                        var needUpdate;
                        var contentWidth = this._rowsView.contentWidth();
                        var resizingInfo = this._resizingInfo;
                        var columnsController = this._columnsController;
                        var visibleColumns = columnsController.getVisibleColumns();
                        var columnsSeparatorWidth = this._columnsSeparatorView.width();
                        var isNextColumnMode = isNextColumnResizingMode(this);
                        var adaptColumnWidthByRatio = isNextColumnMode && this.option("adaptColumnWidthByRatio") && !this.option("columnAutoWidth");
                        var rtlEnabled = this.option("rtlEnabled");
                        var isRtlParentStyle = this._isRtlParentStyle();
                        var column = visibleColumns[resizingInfo.currentColumnIndex];
                        var nextColumn = visibleColumns[resizingInfo.nextColumnIndex];

                        function isPercentWidth(width) {
                            return (0, _type.isString)(width) && width.endsWith("%")
                        }

                        function setColumnWidth(column, columnWidth, contentWidth, adaptColumnWidthByRatio) {
                            if (column) {
                                var oldColumnWidth = column.width;
                                if (oldColumnWidth) {
                                    adaptColumnWidthByRatio = isPercentWidth(oldColumnWidth)
                                }
                                if (adaptColumnWidthByRatio) {
                                    columnsController.columnOption(column.index, "visibleWidth", columnWidth);
                                    columnsController.columnOption(column.index, "width", "".concat((columnWidth / contentWidth * 100).toFixed(3), "%"))
                                } else {
                                    columnsController.columnOption(column.index, "visibleWidth", null);
                                    columnsController.columnOption(column.index, "width", columnWidth)
                                }
                            }
                        }
                        deltaX = posX - resizingInfo.startPosX;
                        if ((isNextColumnMode || isRtlParentStyle) && rtlEnabled) {
                            deltaX = -deltaX
                        }
                        var _calculateCellWidths = function(delta) {
                                var nextMinWidth;
                                var nextCellWidth;
                                var needCorrectionNextCellWidth;
                                var cellWidth = resizingInfo.currentColumnWidth + delta;
                                var minWidth = column && column.minWidth || columnsSeparatorWidth;
                                var result = {};
                                if (cellWidth >= minWidth) {
                                    result.cellWidth = cellWidth
                                } else {
                                    result.cellWidth = minWidth;
                                    needCorrectionNextCellWidth = true
                                }
                                if (isNextColumnMode) {
                                    nextCellWidth = resizingInfo.nextColumnWidth - delta;
                                    nextMinWidth = nextColumn && nextColumn.minWidth || columnsSeparatorWidth;
                                    if (nextCellWidth >= nextMinWidth) {
                                        if (needCorrectionNextCellWidth) {
                                            result.nextCellWidth = resizingInfo.nextColumnWidth - (delta + minWidth - cellWidth)
                                        } else {
                                            result.nextCellWidth = nextCellWidth
                                        }
                                    } else {
                                        result.nextCellWidth = nextMinWidth;
                                        result.cellWidth = resizingInfo.currentColumnWidth + (delta - nextMinWidth + nextCellWidth)
                                    }
                                }
                                return result
                            }(deltaX),
                            cellWidth = _calculateCellWidths.cellWidth,
                            nextCellWidth = _calculateCellWidths.nextCellWidth;
                        needUpdate = column.width !== cellWidth;
                        if (needUpdate) {
                            columnsController.beginUpdate();
                            cellWidth = Math.floor(cellWidth);
                            contentWidth = function(contentWidth, visibleColumns) {
                                var allColumnsHaveWidth = visibleColumns.every((function(column) {
                                    return column.width
                                }));
                                if (allColumnsHaveWidth) {
                                    var totalPercent = visibleColumns.reduce((function(sum, column) {
                                        if (isPercentWidth(column.width)) {
                                            sum += parseFloat(column.width)
                                        }
                                        return sum
                                    }), 0);
                                    if (totalPercent > 100) {
                                        contentWidth = contentWidth / totalPercent * 100
                                    }
                                }
                                return contentWidth
                            }(contentWidth, visibleColumns);
                            setColumnWidth(column, cellWidth, contentWidth, adaptColumnWidthByRatio);
                            if (isNextColumnMode) {
                                nextCellWidth = Math.floor(nextCellWidth);
                                setColumnWidth(nextColumn, nextCellWidth, contentWidth, adaptColumnWidthByRatio)
                            } else {
                                var columnWidths = this._columnHeadersView.getColumnWidths();
                                columnWidths[resizingInfo.currentColumnIndex] = cellWidth;
                                var hasScroll = columnWidths.reduce((function(totalWidth, width) {
                                    return totalWidth + width
                                }), 0) > this._rowsView.contentWidth();
                                if (!hasScroll) {
                                    var lastColumnIndex = _m_utils.default.getLastResizableColumnIndex(visibleColumns);
                                    if (lastColumnIndex >= 0) {
                                        columnsController.columnOption(visibleColumns[lastColumnIndex].index, "visibleWidth", "auto")
                                    }
                                }
                                for (var i = 0; i < columnWidths.length; i++) {
                                    if (visibleColumns[i] && visibleColumns[i] !== column && void 0 === visibleColumns[i].width) {
                                        columnsController.columnOption(visibleColumns[i].index, "width", columnWidths[i])
                                    }
                                }
                            }
                            columnsController.endUpdate();
                            if (!isNextColumnMode) {
                                this.component.updateDimensions();
                                var scrollable = this.component.getScrollable();
                                if (scrollable && isRtlParentStyle) {
                                    var left = (0, _size.getWidth)(scrollable.$content()) - (0, _size.getWidth)(scrollable.container()) - this._scrollRight;
                                    scrollable.scrollTo({
                                        left: left
                                    })
                                }
                            }
                        }
                        return needUpdate
                    };
                    _proto6._subscribeToCallback = function(callback, handler) {
                        callback.add(handler);
                        this._subscribesToCallbacks.push({
                            callback: callback,
                            handler: handler
                        })
                    };
                    _proto6._unsubscribeFromCallbacks = function() {
                        for (var i = 0; i < this._subscribesToCallbacks.length; i++) {
                            var subscribe = this._subscribesToCallbacks[i];
                            subscribe.callback.remove(subscribe.handler)
                        }
                        this._subscribesToCallbacks = []
                    };
                    _proto6._unsubscribes = function() {
                        this._unsubscribeFromEvents();
                        this._unsubscribeFromCallbacks()
                    };
                    _proto6._init = function() {
                        var that = this;
                        var generatePointsByColumnsHandler = function() {
                            if (!that._isResizing) {
                                that.pointsByColumns(null)
                            }
                        };
                        var generatePointsByColumnsScrollHandler = function(offset) {
                            if (that._scrollLeft !== offset.left) {
                                that._scrollLeft = offset.left;
                                that.pointsByColumns(null)
                            }
                        };
                        that._columnsSeparatorView = that.getView("columnsSeparatorView");
                        that._columnHeadersView = that.getView("columnHeadersView");
                        that._trackerView = that.getView("trackerView");
                        that._rowsView = that.getView("rowsView");
                        that._columnsController = that.getController("columns");
                        that._tablePositionController = that.getController("tablePosition");
                        that._$parentContainer = that.component.$element();
                        that._draggingHeaderView = that.component.getView("draggingHeaderView");
                        that._subscribeToCallback(that._columnHeadersView.renderCompleted, generatePointsByColumnsHandler);
                        that._subscribeToCallback(that._columnHeadersView.resizeCompleted, generatePointsByColumnsHandler);
                        that._subscribeToCallback(that._columnsSeparatorView.renderCompleted, (function() {
                            that._unsubscribeFromEvents();
                            that._subscribeToEvents()
                        }));
                        that._subscribeToCallback(that._rowsView.renderCompleted, (function() {
                            that._rowsView.scrollChanged.remove(generatePointsByColumnsScrollHandler);
                            that._rowsView.scrollChanged.add(generatePointsByColumnsScrollHandler)
                        }));
                        var previousScrollbarVisibility = 0 !== that._rowsView.getScrollbarWidth();
                        var previousTableHeight = 0;
                        that._subscribeToCallback(that.getController("tablePosition").positionChanged, (function(e) {
                            if (that._isResizing && !that._rowsView.isResizing) {
                                var scrollbarVisibility = 0 !== that._rowsView.getScrollbarWidth();
                                if (previousScrollbarVisibility !== scrollbarVisibility || previousTableHeight && previousTableHeight !== e.height) {
                                    previousScrollbarVisibility = scrollbarVisibility;
                                    previousTableHeight = e.height;
                                    that.component.updateDimensions()
                                } else {
                                    that._rowsView.updateFreeSpaceRowHeight()
                                }
                            }
                            previousTableHeight = e.height
                        }))
                    };
                    _proto6.optionChanged = function(args) {
                        _modules$ViewControll.prototype.optionChanged.call(this, args);
                        if ("allowColumnResizing" === args.name) {
                            if (args.value) {
                                this._init();
                                this._subscribeToEvents()
                            } else {
                                this._unsubscribes()
                            }
                        }
                    };
                    _proto6.isResizing = function() {
                        return this._isResizing
                    };
                    _proto6.init = function() {
                        this._subscribesToCallbacks = [];
                        if (allowResizing(this)) {
                            this._init()
                        }
                    };
                    _proto6.pointsByColumns = function(value) {
                        if (void 0 !== value) {
                            this._pointsByColumns = value
                        } else {
                            if (!this._pointsByColumns) {
                                this._generatePointsByColumns()
                            }
                            return this._pointsByColumns
                        }
                    };
                    _proto6.dispose = function() {
                        this._unsubscribes();
                        _modules$ViewControll.prototype.dispose.call(this)
                    };
                    return ColumnsResizerViewController
                }(_m_modules.default.ViewController);
                var TablePositionViewController = function(_modules$ViewControll2) {
                    _inheritsLoose(TablePositionViewController, _modules$ViewControll2);

                    function TablePositionViewController(component) {
                        var _this;
                        _this = _modules$ViewControll2.call(this, component) || this;
                        _this.positionChanged = (0, _callbacks.default)();
                        return _this
                    }
                    var _proto7 = TablePositionViewController.prototype;
                    _proto7.update = function(top) {
                        var params = {};
                        var $element = this._columnHeadersView.element();
                        var offset = $element && $element.offset();
                        var offsetTop = offset && offset.top || 0;
                        var diffOffsetTop = (0, _type.isDefined)(top) ? Math.abs(top - offsetTop) : 0;
                        var columnsHeadersHeight = this._columnHeadersView ? this._columnHeadersView.getHeight() : 0;
                        var scrollBarWidth = this._rowsView.getScrollbarWidth(true);
                        var rowsHeight = this._rowsView ? this._rowsView.height() - scrollBarWidth : 0;
                        var columnsResizerController = this.component.getController("columnsResizer");
                        var draggingHeaderView = this.component.getView("draggingHeaderView");
                        params.height = columnsHeadersHeight;
                        var isDraggingOrResizing = columnsResizerController.isResizing() || draggingHeaderView.isDragging();
                        if (isDraggingOrResizing) {
                            params.height += rowsHeight - diffOffsetTop
                        }
                        if (null !== top && $element && $element.length) {
                            params.top = $element[0].offsetTop + diffOffsetTop
                        }
                        this.positionChanged.fire(params)
                    };
                    _proto7.init = function() {
                        var that = this;
                        _modules$ViewControll2.prototype.init.call(this);
                        that._columnHeadersView = this.getView("columnHeadersView");
                        that._rowsView = this.getView("rowsView");
                        that._pagerView = this.getView("pagerView");
                        that._rowsView.resizeCompleted.add((function() {
                            if (that.option("allowColumnResizing")) {
                                var targetPoint = that.getController("columnsResizer")._targetPoint;
                                that.update(targetPoint ? targetPoint.y : null)
                            }
                        }))
                    };
                    return TablePositionViewController
                }(_m_modules.default.ViewController);
                var DraggingHeaderViewController = function(_modules$ViewControll3) {
                    _inheritsLoose(DraggingHeaderViewController, _modules$ViewControll3);

                    function DraggingHeaderViewController() {
                        return _modules$ViewControll3.apply(this, arguments) || this
                    }
                    var _proto8 = DraggingHeaderViewController.prototype;
                    _proto8._generatePointsByColumns = function(options) {
                        var that = this;
                        this.isCustomGroupColumnPosition = this.checkIsCustomGroupColumnPosition(options);
                        return _m_utils.default.getPointsByColumns(options.columnElements, (function(point) {
                            return that._pointCreated(point, options.columns, options.targetDraggingPanel.getName(), options.sourceColumn)
                        }), options.isVerticalOrientation, options.startColumnIndex)
                    };
                    _proto8.checkIsCustomGroupColumnPosition = function(options) {
                        var wasOnlyCommandColumns = true;
                        for (var i = 0; i < options.columns.length; i += 1) {
                            var col = options.columns[i];
                            if ("expand" === col.command && !wasOnlyCommandColumns) {
                                return true
                            }
                            if (!col.command) {
                                wasOnlyCommandColumns = false
                            }
                        }
                        return false
                    };
                    _proto8._pointCreated = function(point, columns, location, sourceColumn) {
                        var _a;
                        var targetColumn = columns[point.columnIndex];
                        var prevColumn = columns[point.columnIndex - 1];
                        var isColumnAfterExpandColumn = "expand" === (null === prevColumn || void 0 === prevColumn ? void 0 : prevColumn.command);
                        var isFirstExpandColumn = "expand" === (null === targetColumn || void 0 === targetColumn ? void 0 : targetColumn.command) && "expand" !== (null === prevColumn || void 0 === prevColumn ? void 0 : prevColumn.command);
                        var sourceColumnReorderingDisabled = sourceColumn && !sourceColumn.allowReordering;
                        var otherColumnReorderingDisabled = !(null === targetColumn || void 0 === targetColumn ? void 0 : targetColumn.allowReordering) && !(null === prevColumn || void 0 === prevColumn ? void 0 : prevColumn.allowReordering);
                        switch (location) {
                            case "columnChooser":
                                return true;
                            case "headers":
                                if (!isFirstExpandColumn) {
                                    return isColumnAfterExpandColumn || sourceColumnReorderingDisabled || otherColumnReorderingDisabled
                                }
                                if (this.isCustomGroupColumnPosition) {
                                    return false
                                }
                                while ("expand" === (null === (_a = columns[point.columnIndex]) || void 0 === _a ? void 0 : _a.command)) {
                                    point.columnIndex += 1
                                }
                                return false;
                            default:
                                return 0 === columns.length
                        }
                    };
                    _proto8._subscribeToEvents = function(draggingHeader, draggingPanels) {
                        var that = this;
                        (0, _iterator.each)(draggingPanels, (function(_, draggingPanel) {
                            if (draggingPanel) {
                                var columns;
                                var rowCount = draggingPanel.getRowCount ? draggingPanel.getRowCount() : 1;
                                var nameDraggingPanel = draggingPanel.getName();
                                var subscribeToEvents = function(index, columnElement) {
                                    if (!columnElement) {
                                        return
                                    }
                                    var $columnElement = (0, _renderer.default)(columnElement);
                                    var column = columns[index];
                                    if (column && draggingPanel.allowDragging(column)) {
                                        $columnElement.addClass(that.addWidgetPrefix("drag-action"));
                                        _events_engine.default.on($columnElement, (0, _index.addNamespace)(_drag.start, MODULE_NAMESPACE), that.createAction((function(args) {
                                            var e = args.event;
                                            var eventData = (0, _index.eventData)(e);
                                            draggingHeader.dragHeader({
                                                deltaX: eventData.x - (0, _renderer.default)(e.currentTarget).offset().left,
                                                deltaY: eventData.y - (0, _renderer.default)(e.currentTarget).offset().top,
                                                sourceColumn: column,
                                                index: column.index,
                                                columnIndex: index,
                                                columnElement: $columnElement,
                                                sourceLocation: nameDraggingPanel,
                                                draggingPanels: draggingPanels,
                                                rowIndex: that._columnsController.getRowIndex(column.index, true)
                                            })
                                        })));
                                        _events_engine.default.on($columnElement, (0, _index.addNamespace)(_drag.move, MODULE_NAMESPACE), {
                                            that: draggingHeader
                                        }, that.createAction(draggingHeader.moveHeader));
                                        _events_engine.default.on($columnElement, (0, _index.addNamespace)(_drag.end, MODULE_NAMESPACE), {
                                            that: draggingHeader
                                        }, that.createAction(draggingHeader.dropHeader))
                                    }
                                };
                                for (var i = 0; i < rowCount; i++) {
                                    var columnElements = draggingPanel.getColumnElements(i) || [];
                                    if (columnElements.length) {
                                        columns = draggingPanel.getColumns(i) || [];
                                        (0, _iterator.each)(columnElements, subscribeToEvents)
                                    }
                                }
                            }
                        }))
                    };
                    _proto8._unsubscribeFromEvents = function(draggingHeader, draggingPanels) {
                        var that = this;
                        (0, _iterator.each)(draggingPanels, (function(_, draggingPanel) {
                            if (draggingPanel) {
                                var columnElements = draggingPanel.getColumnElements() || [];
                                (0, _iterator.each)(columnElements, (function(index, columnElement) {
                                    var $columnElement = (0, _renderer.default)(columnElement);
                                    _events_engine.default.off($columnElement, (0, _index.addNamespace)(_drag.start, MODULE_NAMESPACE));
                                    _events_engine.default.off($columnElement, (0, _index.addNamespace)(_drag.move, MODULE_NAMESPACE));
                                    _events_engine.default.off($columnElement, (0, _index.addNamespace)(_drag.end, MODULE_NAMESPACE));
                                    $columnElement.removeClass(that.addWidgetPrefix("drag-action"))
                                }))
                            }
                        }))
                    };
                    _proto8._getSeparator = function(targetLocation) {
                        return "headers" === targetLocation ? this._columnsSeparatorView : this._blockSeparatorView
                    };
                    _proto8.hideSeparators = function(type) {
                        var blockSeparator = this._blockSeparatorView;
                        var columnsSeparator = this._columnsSeparatorView;
                        this._animationColumnIndex = void 0;
                        blockSeparator && blockSeparator.hide();
                        "block" !== type && columnsSeparator && columnsSeparator.hide()
                    };
                    _proto8.init = function() {
                        var that = this;
                        _modules$ViewControll3.prototype.init.call(this);
                        that._columnsController = that.getController("columns");
                        that._columnHeadersView = that.getView("columnHeadersView");
                        that._columnsSeparatorView = that.getView("columnsSeparatorView");
                        that._draggingHeaderView = that.getView("draggingHeaderView");
                        that._rowsView = that.getView("rowsView");
                        that._blockSeparatorView = that.getView("blockSeparatorView");
                        that._headerPanelView = that.getView("headerPanel");
                        that._columnChooserView = that.getView("columnChooserView");
                        var subscribeToEvents = function() {
                            if (that._draggingHeaderView) {
                                var draggingPanels = [that._columnChooserView, that._columnHeadersView, that._headerPanelView];
                                that._unsubscribeFromEvents(that._draggingHeaderView, draggingPanels);
                                that._subscribeToEvents(that._draggingHeaderView, draggingPanels)
                            }
                        };
                        that._columnHeadersView.renderCompleted.add(subscribeToEvents);
                        that._headerPanelView && that._headerPanelView.renderCompleted.add(subscribeToEvents);
                        that._columnChooserView && that._columnChooserView.renderCompleted.add(subscribeToEvents)
                    };
                    _proto8.allowDrop = function(parameters) {
                        return this._columnsController.allowMoveColumn(parameters.sourceColumnIndex, parameters.targetColumnIndex, parameters.sourceLocation, parameters.targetLocation)
                    };
                    _proto8.drag = function(parameters) {
                        var sourceIndex = parameters.sourceIndex;
                        var sourceLocation = parameters.sourceLocation;
                        var sourceColumnElement = parameters.sourceColumnElement;
                        var headersView = this._columnHeadersView;
                        var rowsView = this._rowsView;
                        if (sourceColumnElement) {
                            sourceColumnElement.css({
                                opacity: .5
                            });
                            if ("headers" === sourceLocation) {
                                headersView && headersView.setRowsOpacity(sourceIndex, .5);
                                rowsView && rowsView.setRowsOpacity(sourceIndex, .5)
                            }
                        }
                    };
                    _proto8.dock = function(parameters) {
                        var that = this;
                        var targetColumnIndex = (0, _type.isObject)(parameters.targetColumnIndex) ? parameters.targetColumnIndex.columnIndex : parameters.targetColumnIndex;
                        var sourceLocation = parameters.sourceLocation;
                        var targetLocation = parameters.targetLocation;
                        var separator = that._getSeparator(targetLocation);
                        var hasTargetVisibleIndex = targetColumnIndex >= 0;
                        that._columnHeadersView.element().find(".".concat("dx-header-row")).toggleClass(that.addWidgetPrefix("drop-highlight"), "headers" !== sourceLocation && "headers" === targetLocation && !hasTargetVisibleIndex);
                        if (separator) {
                            if (that.allowDrop(parameters) && hasTargetVisibleIndex) {
                                if ("group" === targetLocation || "columnChooser" === targetLocation) {
                                    ! function() {
                                        if (that._animationColumnIndex !== targetColumnIndex) {
                                            that.hideSeparators();
                                            separator.element()[parameters.isLast ? "insertAfter" : "insertBefore"](parameters.targetColumnElement);
                                            that._animationColumnIndex = targetColumnIndex;
                                            separator.show(targetLocation)
                                        }
                                    }()
                                } else {
                                    that.hideSeparators("block");
                                    that.getController("tablePosition").update(parameters.posY);
                                    separator.moveByX(parameters.posX - separator.width());
                                    separator.show()
                                }
                            } else {
                                that.hideSeparators()
                            }
                        }
                    };
                    _proto8.drop = function(parameters) {
                        var sourceColumnElement = parameters.sourceColumnElement;
                        if (sourceColumnElement) {
                            sourceColumnElement.css({
                                opacity: ""
                            });
                            this._columnHeadersView.setRowsOpacity(parameters.sourceIndex, "");
                            this._rowsView.setRowsOpacity(parameters.sourceIndex, "");
                            this._columnHeadersView.element().find(".".concat("dx-header-row")).removeClass(this.addWidgetPrefix("drop-highlight"))
                        }
                        if (this.allowDrop(parameters)) {
                            var separator = this._getSeparator(parameters.targetLocation);
                            if (separator) {
                                separator.hide()
                            }
                            this._columnsController.moveColumn(parameters.sourceColumnIndex, parameters.targetColumnIndex, parameters.sourceLocation, parameters.targetLocation)
                        }
                    };
                    _proto8.dispose = function() {
                        if (this._draggingHeaderView) {
                            this._unsubscribeFromEvents(this._draggingHeaderView, [this._columnChooserView, this._columnHeadersView, this._headerPanelView])
                        }
                    };
                    return DraggingHeaderViewController
                }(_m_modules.default.ViewController);
                var columnsResizingReorderingModule = {
                    views: {
                        columnsSeparatorView: ColumnsSeparatorView,
                        blockSeparatorView: BlockSeparatorView,
                        draggingHeaderView: DraggingHeaderView,
                        trackerView: TrackerView
                    },
                    controllers: {
                        draggingHeader: DraggingHeaderViewController,
                        tablePosition: TablePositionViewController,
                        columnsResizer: ColumnsResizerViewController
                    },
                    extenders: {
                        views: {
                            rowsView: {
                                _needUpdateRowHeight: function(itemCount) {
                                    var wordWrapEnabled = this.option("wordWrapEnabled");
                                    var columnsResizerController = this.getController("columnsResizer");
                                    var isResizing = columnsResizerController.isResizing();
                                    return this.callBase.apply(this, arguments) || itemCount > 0 && wordWrapEnabled && isResizing
                                }
                            }
                        },
                        controllers: {
                            editorFactory: {
                                renderFocusOverlay: function() {
                                    if (this.getController("columnsResizer").isResizing()) {
                                        return
                                    }
                                    return this.callBase.apply(this, arguments)
                                }
                            }
                        }
                    }
                };
                exports.columnsResizingReorderingModule = columnsResizingReorderingModule
            },
        69823:
            /*!*******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/context_menu/m_context_menu.js ***!
              \*******************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.contextMenuModule = void 0;
                var _element = __webpack_require__( /*! ../../../../core/element */ 6415);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _context_menu = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/context_menu */ 10042));
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var viewName = {
                    columnHeadersView: "header",
                    rowsView: "content",
                    footerView: "footer",
                    headerPanel: "headerPanel"
                };
                var VIEW_NAMES = ["columnHeadersView", "rowsView", "footerView", "headerPanel"];
                var ContextMenuController = _m_modules.default.ViewController.inherit({
                    init: function() {
                        this.createAction("onContextMenuPreparing")
                    },
                    getContextMenuItems: function(dxEvent) {
                        if (!dxEvent) {
                            return false
                        }
                        var that = this;
                        var $targetElement = (0, _renderer.default)(dxEvent.target);
                        var $element;
                        var $targetRowElement;
                        var $targetCellElement;
                        var menuItems;
                        (0, _iterator.each)(VIEW_NAMES, (function() {
                            var _a, _b;
                            var view = that.getView(this);
                            $element = view && view.element();
                            if ($element && ($element.is($targetElement) || $element.find($targetElement).length)) {
                                $targetCellElement = $targetElement.closest(".dx-row > td, .dx-row > tr");
                                $targetRowElement = $targetCellElement.parent();
                                var rowIndex = view.getRowIndex($targetRowElement);
                                var columnIndex = $targetCellElement[0] && $targetCellElement[0].cellIndex;
                                var rowOptions = $targetRowElement.data("options");
                                var options = {
                                    event: dxEvent,
                                    targetElement: (0, _element.getPublicElement)($targetElement),
                                    target: viewName[this],
                                    rowIndex: rowIndex,
                                    row: view._getRows()[rowIndex],
                                    columnIndex: columnIndex,
                                    column: null === (_b = null === (_a = null === rowOptions || void 0 === rowOptions ? void 0 : rowOptions.cells) || void 0 === _a ? void 0 : _a[columnIndex]) || void 0 === _b ? void 0 : _b.column
                                };
                                options.items = view.getContextMenuItems && view.getContextMenuItems(options);
                                that.executeAction("onContextMenuPreparing", options);
                                that._contextMenuPrepared(options);
                                menuItems = options.items;
                                if (menuItems) {
                                    return false
                                }
                            }
                            return
                        }));
                        return menuItems
                    },
                    _contextMenuPrepared: _common.noop
                });
                var ContextMenuView = _m_modules.default.View.inherit({
                    _renderCore: function() {
                        var that = this;
                        var $element = that.element().addClass("dx-context-menu");
                        this.setAria("role", "presentation", $element);
                        this._createComponent($element, _context_menu.default, {
                            onPositioning: function(actionArgs) {
                                var event = actionArgs.event;
                                var contextMenuInstance = actionArgs.component;
                                var items = that.getController("contextMenu").getContextMenuItems(event);
                                if (items) {
                                    contextMenuInstance.option("items", items);
                                    event.stopPropagation()
                                } else {
                                    actionArgs.cancel = true
                                }
                            },
                            onItemClick: function(params) {
                                params.itemData.onItemClick && params.itemData.onItemClick(params)
                            },
                            cssClass: that.getWidgetContainerClass(),
                            target: that.component.$element()
                        })
                    }
                });
                var contextMenuModule = {
                    defaultOptions: function() {
                        return {
                            onContextMenuPreparing: null
                        }
                    },
                    controllers: {
                        contextMenu: ContextMenuController
                    },
                    views: {
                        contextMenuView: ContextMenuView
                    }
                };
                exports.contextMenuModule = contextMenuModule
            },
        72119:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/data_controller/m_data_controller.js ***!
              \*************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.dataControllerModule = exports.DataController = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _array_compare = __webpack_require__( /*! ../../../../core/utils/array_compare */ 34671);
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _array_store = _interopRequireDefault(__webpack_require__( /*! ../../../../data/array_store */ 26562));
                var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../../../../data/custom_store */ 88036));
                var _data_helper = _interopRequireDefault(__webpack_require__( /*! ../../../../data_helper */ 53305));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 96688));
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var changePaging = function(that, optionName, value) {
                    var dataSource = that._dataSource;
                    if (dataSource) {
                        if (void 0 !== value) {
                            var oldValue = that._getPagingOptionValue(optionName);
                            if (oldValue !== value) {
                                if ("pageSize" === optionName) {
                                    dataSource.pageIndex(0)
                                }
                                dataSource[optionName](value);
                                that._skipProcessingPagingChange = true;
                                that.option("paging.".concat(optionName), value);
                                that._skipProcessingPagingChange = false;
                                var pageIndex = dataSource.pageIndex();
                                that._isPaging = "pageIndex" === optionName;
                                return dataSource["pageIndex" === optionName ? "load" : "reload"]().done((function() {
                                    that._isPaging = false;
                                    that.pageChanged.fire(pageIndex)
                                }))
                            }
                            return (0, _deferred.Deferred)().resolve().promise()
                        }
                        return dataSource[optionName]()
                    }
                    return 0
                };
                var ControllerWithDataMixin = _m_modules.default.Controller.inherit(_data_helper.default);
                var DataController = function(_ControllerWithDataMi) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(DataController, _ControllerWithDataMi);

                    function DataController() {
                        return _ControllerWithDataMi.apply(this, arguments) || this
                    }
                    var _proto = DataController.prototype;
                    _proto.init = function() {
                        var _this = this;
                        var that = this;
                        that._items = [];
                        that._cachedProcessedItems = null;
                        that._columnsController = this.getController("columns");
                        that._isPaging = false;
                        that._currentOperationTypes = null;
                        that._dataChangedHandler = function(e) {
                            that._currentOperationTypes = _this._dataSource.operationTypes();
                            that._handleDataChanged(e);
                            that._currentOperationTypes = null
                        };
                        that._columnsChangedHandler = that._handleColumnsChanged.bind(that);
                        that._loadingChangedHandler = that._handleLoadingChanged.bind(that);
                        that._loadErrorHandler = that._handleLoadError.bind(that);
                        that._customizeStoreLoadOptionsHandler = that._handleCustomizeStoreLoadOptions.bind(that);
                        that._changingHandler = that._handleChanging.bind(that);
                        that._dataPushedHandler = that._handleDataPushed.bind(that);
                        that._columnsController.columnsChanged.add(that._columnsChangedHandler);
                        that._isLoading = false;
                        that._isCustomLoading = false;
                        that._repaintChangesOnly = void 0;
                        that._changes = [];
                        that.createAction("onDataErrorOccurred");
                        that.dataErrorOccurred.add((function(error) {
                            return that.executeAction("onDataErrorOccurred", {
                                error: error
                            })
                        }));
                        that._refreshDataSource()
                    };
                    _proto._getPagingOptionValue = function(optionName) {
                        return this._dataSource[optionName]()
                    };
                    _proto.callbackNames = function() {
                        return ["changed", "loadingChanged", "dataErrorOccurred", "pageChanged", "dataSourceChanged", "pushed"]
                    };
                    _proto.callbackFlags = function(name) {
                        if ("dataErrorOccurred" === name) {
                            return {
                                stopOnFalse: true
                            }
                        }
                        return
                    };
                    _proto.publicMethods = function() {
                        return ["beginCustomLoading", "endCustomLoading", "refresh", "filter", "clearFilter", "getCombinedFilter", "keyOf", "byKey", "getDataByKeys", "pageIndex", "pageSize", "pageCount", "totalCount", "_disposeDataSource", "getKeyByRowIndex", "getRowIndexByKey", "getDataSource", "getVisibleRows", "repaintRows"]
                    };
                    _proto.reset = function() {
                        this._columnsController.reset();
                        this._items = [];
                        this._refreshDataSource()
                    };
                    _proto._handleDataSourceChange = function(args) {
                        if (args.value === args.previousValue || this.option("columns") && Array.isArray(args.value) && Array.isArray(args.previousValue)) {
                            var isValueChanged = args.value !== args.previousValue;
                            if (isValueChanged) {
                                var store = this.store();
                                if (store) {
                                    store._array = args.value
                                }
                            }
                            if (this.needToRefreshOnDataSourceChange(args)) {
                                this.refresh(this.option("repaintChangesOnly"))
                            }
                            return true
                        }
                        return false
                    };
                    _proto.needToRefreshOnDataSourceChange = function(args) {
                        return true
                    };
                    _proto.optionChanged = function(args) {
                        var _this2 = this;
                        var that = this;
                        var dataSource;
                        var changedPagingOptions;

                        function handled() {
                            args.handled = true
                        }
                        if ("dataSource" === args.name && args.name === args.fullName && this._handleDataSourceChange(args)) {
                            handled();
                            return
                        }
                        switch (args.name) {
                            case "cacheEnabled":
                            case "repaintChangesOnly":
                            case "highlightChanges":
                            case "loadingTimeout":
                                handled();
                                break;
                            case "remoteOperations":
                            case "keyExpr":
                            case "dataSource":
                            case "scrolling":
                                handled();
                                that.reset();
                                break;
                            case "paging":
                                dataSource = that.dataSource();
                                if (dataSource) {
                                    changedPagingOptions = that._setPagingOptions(dataSource);
                                    if (changedPagingOptions) {
                                        var pageIndex = dataSource.pageIndex();
                                        this._isPaging = changedPagingOptions.isPageIndexChanged;
                                        dataSource.load().done((function() {
                                            _this2._isPaging = false;
                                            that.pageChanged.fire(pageIndex)
                                        }))
                                    }
                                }
                                handled();
                                break;
                            case "rtlEnabled":
                                that.reset();
                                break;
                            case "columns":
                                dataSource = that.dataSource();
                                if (dataSource && dataSource.isLoading() && args.name === args.fullName) {
                                    this._useSortingGroupingFromColumns = true;
                                    dataSource.load()
                                }
                                break;
                            default:
                                _ControllerWithDataMi.prototype.optionChanged.call(this, args)
                        }
                    };
                    _proto.isReady = function() {
                        return !this._isLoading
                    };
                    _proto.getDataSource = function() {
                        return this._dataSource && this._dataSource._dataSource
                    };
                    _proto.getCombinedFilter = function(returnDataField) {
                        return this.combinedFilter(void 0, returnDataField)
                    };
                    _proto.combinedFilter = function(filter, returnDataField) {
                        if (!this._dataSource) {
                            return filter
                        }
                        var combinedFilter = null !== filter && void 0 !== filter ? filter : this._dataSource.filter();
                        var isColumnsTypesDefined = this._columnsController.isDataSourceApplied() || this._columnsController.isAllDataTypesDefined();
                        if (isColumnsTypesDefined) {
                            var additionalFilter = this._calculateAdditionalFilter();
                            combinedFilter = additionalFilter ? _m_utils.default.combineFilters([additionalFilter, combinedFilter]) : combinedFilter
                        }
                        var isRemoteFiltering = this._dataSource.remoteOperations().filtering || returnDataField;
                        combinedFilter = this._columnsController.updateFilter(combinedFilter, isRemoteFiltering);
                        return combinedFilter
                    };
                    _proto.waitReady = function() {
                        if (this._updateLockCount) {
                            this._readyDeferred = new _deferred.Deferred;
                            return this._readyDeferred
                        }
                        return (0, _deferred.when)()
                    };
                    _proto._endUpdateCore = function() {
                        var changes = this._changes;
                        if (changes.length) {
                            this._changes = [];
                            var repaintChangesOnly = changes.every((function(change) {
                                return change.repaintChangesOnly
                            }));
                            this.updateItems(1 === changes.length ? changes[0] : {
                                repaintChangesOnly: repaintChangesOnly
                            })
                        }
                        if (this._readyDeferred) {
                            this._readyDeferred.resolve();
                            this._readyDeferred = null
                        }
                    };
                    _proto._handleCustomizeStoreLoadOptions = function(e) {
                        var _a;
                        var columnsController = this._columnsController;
                        var dataSource = this._dataSource;
                        var storeLoadOptions = e.storeLoadOptions;
                        if (e.isCustomLoading && !storeLoadOptions.isLoadingAll) {
                            return
                        }
                        storeLoadOptions.filter = this.combinedFilter(storeLoadOptions.filter);
                        if (1 === (null === (_a = storeLoadOptions.filter) || void 0 === _a ? void 0 : _a.length) && "!" === storeLoadOptions.filter[0]) {
                            e.data = [];
                            e.extra = e.extra || {};
                            e.extra.totalCount = 0
                        }
                        if (!columnsController.isDataSourceApplied()) {
                            columnsController.updateColumnDataTypes(dataSource)
                        }
                        this._columnsUpdating = true;
                        columnsController.updateSortingGrouping(dataSource, !this._useSortingGroupingFromColumns);
                        this._columnsUpdating = false;
                        storeLoadOptions.sort = columnsController.getSortDataSourceParameters();
                        storeLoadOptions.group = columnsController.getGroupDataSourceParameters();
                        dataSource.sort(storeLoadOptions.sort);
                        dataSource.group(storeLoadOptions.group);
                        storeLoadOptions.sort = columnsController.getSortDataSourceParameters(!dataSource.remoteOperations().sorting);
                        e.group = columnsController.getGroupDataSourceParameters(!dataSource.remoteOperations().grouping)
                    };
                    _proto._handleColumnsChanged = function(e) {
                        var that = this;
                        var changeTypes = e.changeTypes;
                        var optionNames = e.optionNames;
                        var filterValue;
                        var filterValues;
                        var filterApplied;
                        if (changeTypes.sorting || changeTypes.grouping) {
                            if (that._dataSource && !that._columnsUpdating) {
                                that._dataSource.group(that._columnsController.getGroupDataSourceParameters());
                                that._dataSource.sort(that._columnsController.getSortDataSourceParameters());
                                that.reload()
                            }
                        } else if (changeTypes.columns) {
                            filterValues = that._columnsController.columnOption(e.columnIndex, "filterValues");
                            if (optionNames.filterValues || optionNames.filterType && Array.isArray(filterValues) || optionNames.filterValue || optionNames.selectedFilterOperation || optionNames.allowFiltering) {
                                filterValue = that._columnsController.columnOption(e.columnIndex, "filterValue");
                                if (Array.isArray(filterValues) || void 0 === e.columnIndex || (0, _type.isDefined)(filterValue) || !optionNames.selectedFilterOperation || optionNames.filterValue) {
                                    that._applyFilter();
                                    filterApplied = true
                                }
                            }
                            if (!that._needApplyFilter && !_m_utils.default.checkChanges(optionNames, ["width", "visibleWidth", "filterValue", "bufferedFilterValue", "selectedFilterOperation", "filterValues", "filterType"])) {
                                that._columnsController.columnsChanged.add((function updateItemsHandler(change) {
                                    var _a;
                                    that._columnsController.columnsChanged.remove(updateItemsHandler);
                                    that.updateItems({
                                        repaintChangesOnly: false,
                                        virtualColumnsScrolling: null === (_a = null === change || void 0 === change ? void 0 : change.changeTypes) || void 0 === _a ? void 0 : _a.virtualColumnsScrolling
                                    })
                                }))
                            }
                            if ((0, _type.isDefined)(optionNames.visible)) {
                                var column = that._columnsController.columnOption(e.columnIndex);
                                if (column && ((0, _type.isDefined)(column.filterValue) || (0, _type.isDefined)(column.filterValues))) {
                                    that._applyFilter();
                                    filterApplied = true
                                }
                            }
                        }
                        if (!filterApplied && changeTypes.filtering) {
                            that.reload()
                        }
                    };
                    _proto._handleDataChanged = function(e) {
                        var that = this;
                        var dataSource = that._dataSource;
                        var columnsController = that._columnsController;
                        var isAsyncDataSourceApplying = false;
                        this._useSortingGroupingFromColumns = false;
                        if (dataSource && !that._isDataSourceApplying) {
                            that._isDataSourceApplying = true;
                            (0, _deferred.when)(that._columnsController.applyDataSource(dataSource)).done((function() {
                                if (that._isLoading) {
                                    that._handleLoadingChanged(false)
                                }
                                if (isAsyncDataSourceApplying && e && e.isDelayed) {
                                    e.isDelayed = false
                                }
                                that._isDataSourceApplying = false;
                                var needApplyFilter = that._needApplyFilter;
                                that._needApplyFilter = false;
                                if (needApplyFilter && !that._isAllDataTypesDefined && (additionalFilter = that._calculateAdditionalFilter(), additionalFilter && additionalFilter.length)) {
                                    _ui.default.log("W1005", that.component.NAME);
                                    that._applyFilter()
                                } else {
                                    that.updateItems(e, true)
                                }
                                var additionalFilter
                            })).fail((function() {
                                that._isDataSourceApplying = false
                            }));
                            if (that._isDataSourceApplying) {
                                isAsyncDataSourceApplying = true;
                                that._handleLoadingChanged(true)
                            }
                            that._needApplyFilter = !that._columnsController.isDataSourceApplied();
                            that._isAllDataTypesDefined = columnsController.isAllDataTypesDefined()
                        }
                    };
                    _proto._handleLoadingChanged = function(isLoading) {
                        this._isLoading = isLoading;
                        this._fireLoadingChanged()
                    };
                    _proto._handleLoadError = function(e) {
                        this.dataErrorOccurred.fire(e)
                    };
                    _proto._handleDataPushed = function(changes) {
                        this.pushed.fire(changes)
                    };
                    _proto.fireError = function() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        this.dataErrorOccurred.fire(_ui.default.Error.apply(_ui.default, args))
                    };
                    _proto._setPagingOptions = function(dataSource) {
                        var pageIndex = this.option("paging.pageIndex");
                        var pageSize = this.option("paging.pageSize");
                        var pagingEnabled = this.option("paging.enabled");
                        var scrollingMode = this.option("scrolling.mode");
                        var appendMode = "infinite" === scrollingMode;
                        var virtualMode = "virtual" === scrollingMode;
                        var paginate = pagingEnabled || virtualMode || appendMode;
                        var isPaginateChanged = false;
                        var isPageSizeChanged = false;
                        var isPageIndexChanged = false;
                        dataSource.requireTotalCount(!appendMode);
                        if (void 0 !== pagingEnabled && dataSource.paginate() !== paginate) {
                            dataSource.paginate(paginate);
                            isPaginateChanged = true
                        }
                        if (void 0 !== pageSize && dataSource.pageSize() !== pageSize) {
                            dataSource.pageSize(pageSize);
                            isPageSizeChanged = true
                        }
                        if (void 0 !== pageIndex && dataSource.pageIndex() !== pageIndex) {
                            dataSource.pageIndex(pageIndex);
                            isPageIndexChanged = true
                        }
                        if (isPaginateChanged || isPageSizeChanged || isPageIndexChanged) {
                            return {
                                isPaginateChanged: isPaginateChanged,
                                isPageSizeChanged: isPageSizeChanged,
                                isPageIndexChanged: isPageIndexChanged
                            }
                        }
                        return false
                    };
                    _proto._getSpecificDataSourceOption = function() {
                        var dataSource = this.option("dataSource");
                        if (Array.isArray(dataSource)) {
                            return {
                                store: {
                                    type: "array",
                                    data: dataSource,
                                    key: this.option("keyExpr")
                                }
                            }
                        }
                        return dataSource
                    };
                    _proto._initDataSource = function() {
                        var oldDataSource = this._dataSource;
                        _ControllerWithDataMi.prototype._initDataSource.call(this);
                        var dataSource = this._dataSource;
                        this._useSortingGroupingFromColumns = true;
                        this._cachedProcessedItems = null;
                        if (dataSource) {
                            var changedPagingOptions = this._setPagingOptions(dataSource);
                            this._isPaging = null === changedPagingOptions || void 0 === changedPagingOptions ? void 0 : changedPagingOptions.isPageIndexChanged;
                            this.setDataSource(dataSource)
                        } else if (oldDataSource) {
                            this.updateItems()
                        }
                    };
                    _proto._loadDataSource = function() {
                        var that = this;
                        var dataSource = that._dataSource;
                        var result = new _deferred.Deferred;
                        (0, _deferred.when)(this._columnsController.refresh(true)).always((function() {
                            if (dataSource) {
                                dataSource.load().done((function() {
                                    that._isPaging = false;
                                    result.resolve.apply(result, arguments)
                                })).fail(result.reject)
                            } else {
                                result.resolve()
                            }
                        }));
                        return result.promise()
                    };
                    _proto._beforeProcessItems = function(items) {
                        return items.slice(0)
                    };
                    _proto.getRowIndexDelta = function() {
                        return 0
                    };
                    _proto.getDataIndex = function(change) {
                        var visibleItems = this._items;
                        var lastVisibleItem = "append" === change.changeType && visibleItems.length > 0 ? visibleItems[visibleItems.length - 1] : null;
                        return (0, _type.isDefined)(null === lastVisibleItem || void 0 === lastVisibleItem ? void 0 : lastVisibleItem.dataIndex) ? lastVisibleItem.dataIndex + 1 : 0
                    };
                    _proto._processItems = function(items, change) {
                        var that = this;
                        var rowIndexDelta = that.getRowIndexDelta();
                        var changeType = change.changeType;
                        var visibleColumns = that._columnsController.getVisibleColumns(null, "loadingAll" === changeType);
                        var dataIndex = this.getDataIndex(change);
                        var options = {
                            visibleColumns: visibleColumns,
                            dataIndex: dataIndex
                        };
                        var result = [];
                        (0, _iterator.each)(items, (function(index, item) {
                            if ((0, _type.isDefined)(item)) {
                                options.rowIndex = index - rowIndexDelta;
                                item = that._processItem(item, options);
                                result.push(item)
                            }
                        }));
                        return result
                    };
                    _proto._processItem = function(item, options) {
                        item = this._generateDataItem(item, options);
                        item = this._processDataItem(item, options);
                        item.dataIndex = options.dataIndex++;
                        return item
                    };
                    _proto._generateDataItem = function(data, options) {
                        return {
                            rowType: "data",
                            data: data,
                            key: this.keyOf(data)
                        }
                    };
                    _proto._processDataItem = function(dataItem, options) {
                        dataItem.values = this.generateDataValues(dataItem.data, options.visibleColumns);
                        return dataItem
                    };
                    _proto.generateDataValues = function(data, columns, isModified) {
                        var values = [];
                        var value;
                        for (var i = 0; i < columns.length; i++) {
                            var column = columns[i];
                            value = isModified ? void 0 : null;
                            if (!column.command) {
                                if (column.calculateCellValue) {
                                    value = column.calculateCellValue(data)
                                } else if (column.dataField) {
                                    value = data[column.dataField]
                                }
                            }
                            values.push(value)
                        }
                        return values
                    };
                    _proto._applyChange = function(change) {
                        if ("update" === change.changeType) {
                            this._applyChangeUpdate(change)
                        } else if (this.items().length && change.repaintChangesOnly && "refresh" === change.changeType) {
                            this._applyChangesOnly(change)
                        } else if ("refresh" === change.changeType) {
                            this._applyChangeFull(change)
                        }
                    };
                    _proto._applyChangeFull = function(change) {
                        this._items = change.items.slice(0)
                    };
                    _proto._getRowIndices = function(change) {
                        var rowIndices = change.rowIndices.slice(0);
                        var rowIndexDelta = this.getRowIndexDelta();
                        rowIndices.sort((function(a, b) {
                            return a - b
                        }));
                        for (var i = 0; i < rowIndices.length; i++) {
                            var correctedRowIndex = rowIndices[i];
                            if (change.allowInvisibleRowIndices) {
                                correctedRowIndex += rowIndexDelta
                            }
                            if (correctedRowIndex < 0) {
                                rowIndices.splice(i, 1);
                                i--
                            }
                        }
                        return rowIndices
                    };
                    _proto._applyChangeUpdate = function(change) {
                        var that = this;
                        var items = change.items;
                        var rowIndices = that._getRowIndices(change);
                        var rowIndexDelta = that.getRowIndexDelta();
                        var repaintChangesOnly = that.option("repaintChangesOnly");
                        var prevIndex = -1;
                        var rowIndexCorrection = 0;
                        var changeType;
                        change.items = [];
                        change.rowIndices = [];
                        change.columnIndices = [];
                        change.changeTypes = [];
                        var equalItems = function(item1, item2, strict) {
                            var result = item1 && item2 && (0, _common.equalByValue)(item1.key, item2.key);
                            if (result && strict) {
                                result = item1.rowType === item2.rowType && ("detail" !== item2.rowType || item1.isEditing === item2.isEditing)
                            }
                            return result
                        };
                        (0, _iterator.each)(rowIndices, (function(index, rowIndex) {
                            var columnIndices;
                            rowIndex += rowIndexCorrection + rowIndexDelta;
                            if (prevIndex === rowIndex) {
                                return
                            }
                            prevIndex = rowIndex;
                            var oldItem = that._items[rowIndex];
                            var oldNextItem = that._items[rowIndex + 1];
                            var newItem = items[rowIndex];
                            var newNextItem = items[rowIndex + 1];
                            var strict = equalItems(oldItem, oldNextItem) || equalItems(newItem, newNextItem);
                            if (newItem) {
                                newItem.rowIndex = rowIndex;
                                change.items.push(newItem)
                            }
                            if (oldItem && newItem && equalItems(oldItem, newItem, strict)) {
                                changeType = "update";
                                that._items[rowIndex] = newItem;
                                if (oldItem.visible !== newItem.visible) {
                                    change.items.splice(-1, 1, {
                                        visible: newItem.visible
                                    })
                                } else if (repaintChangesOnly && !change.isFullUpdate) {
                                    columnIndices = that._partialUpdateRow(oldItem, newItem, rowIndex - rowIndexDelta)
                                }
                            } else if (newItem && !oldItem || newNextItem && equalItems(oldItem, newNextItem, strict)) {
                                changeType = "insert";
                                that._items.splice(rowIndex, 0, newItem);
                                rowIndexCorrection++
                            } else if (oldItem && !newItem || oldNextItem && equalItems(newItem, oldNextItem, strict)) {
                                changeType = "remove";
                                that._items.splice(rowIndex, 1);
                                rowIndexCorrection--;
                                prevIndex = -1
                            } else if (newItem) {
                                changeType = "update";
                                that._items[rowIndex] = newItem
                            } else {
                                return
                            }
                            change.rowIndices.push(rowIndex - rowIndexDelta);
                            change.changeTypes.push(changeType);
                            change.columnIndices.push(columnIndices)
                        }))
                    };
                    _proto._isCellChanged = function(oldRow, newRow, visibleRowIndex, columnIndex, isLiveUpdate) {
                        if (JSON.stringify(oldRow.values[columnIndex]) !== JSON.stringify(newRow.values[columnIndex])) {
                            return true
                        }

                        function isCellModified(row, columnIndex) {
                            return row.modifiedValues ? void 0 !== row.modifiedValues[columnIndex] : false
                        }
                        if (isCellModified(oldRow, columnIndex) !== isCellModified(newRow, columnIndex)) {
                            return true
                        }
                        return false
                    };
                    _proto._getChangedColumnIndices = function(oldItem, newItem, visibleRowIndex, isLiveUpdate) {
                        var columnIndices;
                        if (oldItem.rowType === newItem.rowType) {
                            if ("group" !== newItem.rowType && "groupFooter" !== newItem.rowType) {
                                columnIndices = [];
                                if ("detail" !== newItem.rowType) {
                                    for (var columnIndex = 0; columnIndex < oldItem.values.length; columnIndex++) {
                                        if (this._isCellChanged(oldItem, newItem, visibleRowIndex, columnIndex, isLiveUpdate)) {
                                            columnIndices.push(columnIndex)
                                        }
                                    }
                                }
                            }
                            if ("group" === newItem.rowType && newItem.isExpanded === oldItem.isExpanded && oldItem.cells) {
                                columnIndices = oldItem.cells.map((function(cell, index) {
                                    var _a;
                                    return "groupExpand" !== (null === (_a = cell.column) || void 0 === _a ? void 0 : _a.type) ? index : -1
                                })).filter((function(index) {
                                    return index >= 0
                                }))
                            }
                        }
                        return columnIndices
                    };
                    _proto._partialUpdateRow = function(oldItem, newItem, visibleRowIndex, isLiveUpdate) {
                        var changedColumnIndices = this._getChangedColumnIndices(oldItem, newItem, visibleRowIndex, isLiveUpdate);
                        if ((null === changedColumnIndices || void 0 === changedColumnIndices ? void 0 : changedColumnIndices.length) && this.option("dataRowTemplate")) {
                            changedColumnIndices = void 0
                        }
                        if (changedColumnIndices) {
                            oldItem.cells && oldItem.cells.forEach((function(cell, columnIndex) {
                                var isCellChanged = changedColumnIndices.indexOf(columnIndex) >= 0;
                                if (!isCellChanged && cell && cell.update) {
                                    cell.update(newItem)
                                }
                            }));
                            newItem.update = oldItem.update;
                            newItem.watch = oldItem.watch;
                            newItem.cells = oldItem.cells;
                            if (isLiveUpdate) {
                                newItem.oldValues = oldItem.values
                            }
                            oldItem.update && oldItem.update(newItem)
                        }
                        return changedColumnIndices
                    };
                    _proto._isItemEquals = function(item1, item2) {
                        var _a, _b, _c, _d;
                        if (JSON.stringify(item1.values) !== JSON.stringify(item2.values)) {
                            return false
                        }
                        if (["modified", "isNewRow", "removed", "isEditing"].some((function(field) {
                                return item1[field] !== item2[field]
                            }))) {
                            return false
                        }
                        if ("group" === item1.rowType || "groupFooter" === item1.rowType) {
                            var expandedMatch = item1.isExpanded === item2.isExpanded;
                            var summaryCellsMatch = JSON.stringify(item1.summaryCells) === JSON.stringify(item2.summaryCells);
                            var continuationMatch = (null === (_a = item1.data) || void 0 === _a ? void 0 : _a.isContinuation) === (null === (_b = item2.data) || void 0 === _b ? void 0 : _b.isContinuation) && (null === (_c = item1.data) || void 0 === _c ? void 0 : _c.isContinuationOnNextPage) === (null === (_d = item2.data) || void 0 === _d ? void 0 : _d.isContinuationOnNextPage);
                            if (!expandedMatch || !summaryCellsMatch || !continuationMatch) {
                                return false
                            }
                        }
                        return true
                    };
                    _proto._applyChangesOnly = function(change) {
                        var _this3 = this;
                        var _a;
                        var rowIndices = [];
                        var columnIndices = [];
                        var changeTypes = [];
                        var items = [];
                        var newIndexByKey = {};
                        var isLiveUpdate = null !== (_a = null === change || void 0 === change ? void 0 : change.isLiveUpdate) && void 0 !== _a ? _a : true;

                        function getRowKey(row) {
                            if (row) {
                                return "".concat(row.rowType, ",").concat(JSON.stringify(row.key))
                            }
                            return
                        }
                        var currentItems = this._items;
                        var oldItems = currentItems.slice();
                        change.items.forEach((function(item, index) {
                            var key = getRowKey(item);
                            newIndexByKey[key] = index;
                            item.rowIndex = index
                        }));
                        var result = (0, _array_compare.findChanges)(oldItems, change.items, getRowKey, (function(item1, item2) {
                            if (!_this3._isItemEquals(item1, item2)) {
                                return false
                            }
                            if (item1.cells) {
                                item1.update && item1.update(item2);
                                item1.cells.forEach((function(cell) {
                                    if (cell && cell.update) {
                                        cell.update(item2, true)
                                    }
                                }))
                            }
                            return true
                        }));
                        if (!result) {
                            this._applyChangeFull(change);
                            return
                        }
                        result.forEach((function(change) {
                            switch (change.type) {
                                case "update":
                                    var index = change.index;
                                    var newItem = change.data;
                                    var oldItem = change.oldItem;
                                    var changedColumnIndices = _this3._partialUpdateRow(oldItem, newItem, index, isLiveUpdate);
                                    rowIndices.push(index);
                                    changeTypes.push("update");
                                    items.push(newItem);
                                    currentItems[index] = newItem;
                                    columnIndices.push(changedColumnIndices);
                                    break;
                                case "insert":
                                    rowIndices.push(change.index);
                                    changeTypes.push("insert");
                                    items.push(change.data);
                                    columnIndices.push(void 0);
                                    currentItems.splice(change.index, 0, change.data);
                                    break;
                                case "remove":
                                    rowIndices.push(change.index);
                                    changeTypes.push("remove");
                                    currentItems.splice(change.index, 1);
                                    items.push(change.oldItem);
                                    columnIndices.push(void 0)
                            }
                        }));
                        change.repaintChangesOnly = true;
                        change.changeType = "update";
                        change.rowIndices = rowIndices;
                        change.columnIndices = columnIndices;
                        change.changeTypes = changeTypes;
                        change.items = items;
                        if (oldItems.length) {
                            change.isLiveUpdate = true
                        }
                        this._correctRowIndices((function(rowIndex) {
                            var oldRowIndexOffset = _this3._rowIndexOffset || 0;
                            var rowIndexOffset = _this3.getRowIndexOffset();
                            var oldItem = oldItems[rowIndex - oldRowIndexOffset];
                            var key = getRowKey(oldItem);
                            var newVisibleRowIndex = newIndexByKey[key];
                            return newVisibleRowIndex >= 0 ? newVisibleRowIndex + rowIndexOffset - rowIndex : 0
                        }))
                    };
                    _proto._correctRowIndices = function(rowIndex) {};
                    _proto._afterProcessItems = function(items, change) {
                        return items
                    };
                    _proto._updateItemsCore = function(change) {
                        var items;
                        var dataSource = this._dataSource;
                        var changeType = change.changeType || "refresh";
                        change.changeType = changeType;
                        if (dataSource) {
                            var cachedProcessedItems = this._cachedProcessedItems;
                            if (change.useProcessedItemsCache && cachedProcessedItems) {
                                items = cachedProcessedItems
                            } else {
                                items = change.items || dataSource.items();
                                items = this._beforeProcessItems(items);
                                items = this._processItems(items, change);
                                this._cachedProcessedItems = items
                            }
                            items = this._afterProcessItems(items, change);
                            change.items = items;
                            var oldItems = this._items.length === items.length && this._items;
                            this._applyChange(change);
                            var rowIndexDelta = this.getRowIndexDelta();
                            (0, _iterator.each)(this._items, (function(index, item) {
                                var _a;
                                item.rowIndex = index - rowIndexDelta;
                                if (oldItems) {
                                    item.cells = null !== (_a = oldItems[index].cells) && void 0 !== _a ? _a : []
                                }
                                var newItem = items[index];
                                if (newItem) {
                                    item.loadIndex = newItem.loadIndex
                                }
                            }));
                            this._rowIndexOffset = this.getRowIndexOffset()
                        } else {
                            this._items = []
                        }
                    };
                    _proto._handleChanging = function(e) {
                        var rows = this.getVisibleRows();
                        var dataSource = this.dataSource();
                        if (dataSource) {
                            e.changes.forEach((function(change) {
                                if ("insert" === change.type && change.index >= 0) {
                                    var dataIndex = 0;
                                    for (var i = 0; i < change.index; i++) {
                                        var row = rows[i];
                                        if (row && ("data" === row.rowType || "group" === row.rowType)) {
                                            dataIndex++
                                        }
                                    }
                                    change.index = dataIndex
                                }
                            }))
                        }
                    };
                    _proto.updateItems = function(change, isDataChanged) {
                        var _a;
                        change = change || {};
                        if (void 0 !== this._repaintChangesOnly) {
                            change.repaintChangesOnly = null !== (_a = change.repaintChangesOnly) && void 0 !== _a ? _a : this._repaintChangesOnly;
                            change.needUpdateDimensions = change.needUpdateDimensions || this._needUpdateDimensions
                        } else if (change.changes) {
                            change.repaintChangesOnly = this.option("repaintChangesOnly")
                        } else if (isDataChanged) {
                            var operationTypes = this.dataSource().operationTypes();
                            change.repaintChangesOnly = operationTypes && !operationTypes.grouping && !operationTypes.filtering && this.option("repaintChangesOnly");
                            change.isDataChanged = true;
                            if (operationTypes && (operationTypes.reload || operationTypes.paging || operationTypes.groupExpanding)) {
                                change.needUpdateDimensions = true
                            }
                        }
                        if (this._updateLockCount && !change.cancel) {
                            this._changes.push(change);
                            return
                        }
                        this._updateItemsCore(change);
                        if (change.cancel) {
                            return
                        }
                        this._fireChanged(change)
                    };
                    _proto.loadingOperationTypes = function() {
                        var dataSource = this.dataSource();
                        return dataSource && dataSource.loadingOperationTypes() || {}
                    };
                    _proto._fireChanged = function(change) {
                        var _this4 = this;
                        if (this._currentOperationTypes) {
                            change.operationTypes = this._currentOperationTypes;
                            this._currentOperationTypes = null
                        }(0, _common.deferRender)((function() {
                            _this4.changed.fire(change)
                        }))
                    };
                    _proto.isLoading = function() {
                        return this._isLoading || this._isCustomLoading
                    };
                    _proto._fireLoadingChanged = function() {
                        this.loadingChanged.fire(this.isLoading(), this._loadingText)
                    };
                    _proto._calculateAdditionalFilter = function() {
                        return null
                    };
                    _proto._applyFilter = function() {
                        var _this5 = this;
                        var dataSource = this._dataSource;
                        if (dataSource) {
                            dataSource.pageIndex(0);
                            this._isFilterApplying = true;
                            return this.reload().done((function() {
                                if (_this5._isFilterApplying) {
                                    _this5.pageChanged.fire()
                                }
                            }))
                        }
                    };
                    _proto.resetFilterApplying = function() {
                        this._isFilterApplying = false
                    };
                    _proto.filter = function(filterExpr) {
                        var dataSource = this._dataSource;
                        var filter = dataSource && dataSource.filter();
                        if (0 === arguments.length) {
                            return filter
                        }
                        filterExpr = arguments.length > 1 ? Array.prototype.slice.call(arguments, 0) : filterExpr;
                        if (_m_utils.default.equalFilterParameters(filter, filterExpr)) {
                            return
                        }
                        if (dataSource) {
                            dataSource.filter(filterExpr)
                        }
                        this._applyFilter()
                    };
                    _proto.clearFilter = function(filterName) {
                        var that = this;
                        var columnsController = that._columnsController;
                        var clearColumnOption = function(optionName) {
                            var columnCount = columnsController.columnCount();
                            for (var index = 0; index < columnCount; index++) {
                                columnsController.columnOption(index, optionName, void 0)
                            }
                        };
                        that.component.beginUpdate();
                        if (arguments.length > 0) {
                            switch (filterName) {
                                case "dataSource":
                                    that.filter(null);
                                    break;
                                case "search":
                                    that.searchByText("");
                                    break;
                                case "header":
                                    clearColumnOption("filterValues");
                                    break;
                                case "row":
                                    clearColumnOption("filterValue")
                            }
                        } else {
                            that.filter(null);
                            that.searchByText("");
                            clearColumnOption("filterValue");
                            clearColumnOption("bufferedFilterValue");
                            clearColumnOption("filterValues")
                        }
                        that.component.endUpdate()
                    };
                    _proto._fireDataSourceChanged = function() {
                        var that = this;
                        that.changed.add((function changedHandler() {
                            that.changed.remove(changedHandler);
                            that.dataSourceChanged.fire()
                        }))
                    };
                    _proto._getDataSourceAdapter = function() {};
                    _proto._createDataSourceAdapterCore = function(dataSource, remoteOperations) {
                        var dataSourceAdapterProvider = this._getDataSourceAdapter();
                        var dataSourceAdapter = dataSourceAdapterProvider.create(this.component);
                        dataSourceAdapter.init(dataSource, remoteOperations);
                        return dataSourceAdapter
                    };
                    _proto.isLocalStore = function() {
                        var store = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : this.store();
                        return store instanceof _array_store.default
                    };
                    _proto.isCustomStore = function(store) {
                        store = store || this.store();
                        return store instanceof _custom_store.default
                    };
                    _proto._createDataSourceAdapter = function(dataSource) {
                        var remoteOperations = this.option("remoteOperations");
                        var store = dataSource.store();
                        var enabledRemoteOperations = {
                            filtering: true,
                            sorting: true,
                            paging: true,
                            grouping: true,
                            summary: true
                        };
                        if ((0, _type.isObject)(remoteOperations) && remoteOperations.groupPaging) {
                            remoteOperations = (0, _extend.extend)({}, enabledRemoteOperations, remoteOperations)
                        }
                        if ("auto" === remoteOperations) {
                            remoteOperations = this.isLocalStore(store) || this.isCustomStore(store) ? {} : {
                                filtering: true,
                                sorting: true,
                                paging: true
                            }
                        }
                        if (true === remoteOperations) {
                            remoteOperations = enabledRemoteOperations
                        }
                        return this._createDataSourceAdapterCore(dataSource, remoteOperations)
                    };
                    _proto.setDataSource = function(dataSource) {
                        var oldDataSource = this._dataSource;
                        if (!dataSource && oldDataSource) {
                            oldDataSource.cancelAll();
                            oldDataSource.changed.remove(this._dataChangedHandler);
                            oldDataSource.loadingChanged.remove(this._loadingChangedHandler);
                            oldDataSource.loadError.remove(this._loadErrorHandler);
                            oldDataSource.customizeStoreLoadOptions.remove(this._customizeStoreLoadOptionsHandler);
                            oldDataSource.changing.remove(this._changingHandler);
                            oldDataSource.pushed.remove(this._dataPushedHandler);
                            oldDataSource.dispose(this._isSharedDataSource)
                        }
                        if (dataSource) {
                            dataSource = this._createDataSourceAdapter(dataSource)
                        }
                        this._dataSource = dataSource;
                        if (dataSource) {
                            this._fireDataSourceChanged();
                            this._isLoading = !dataSource.isLoaded();
                            this._needApplyFilter = true;
                            this._isAllDataTypesDefined = this._columnsController.isAllDataTypesDefined();
                            dataSource.changed.add(this._dataChangedHandler);
                            dataSource.loadingChanged.add(this._loadingChangedHandler);
                            dataSource.loadError.add(this._loadErrorHandler);
                            dataSource.customizeStoreLoadOptions.add(this._customizeStoreLoadOptionsHandler);
                            dataSource.changing.add(this._changingHandler);
                            dataSource.pushed.add(this._dataPushedHandler)
                        }
                    };
                    _proto.items = function(byLoaded) {
                        return this._items
                    };
                    _proto.isEmpty = function() {
                        return !this.items().length
                    };
                    _proto.pageCount = function() {
                        return this._dataSource ? this._dataSource.pageCount() : 1
                    };
                    _proto.dataSource = function() {
                        return this._dataSource
                    };
                    _proto.store = function() {
                        var dataSource = this._dataSource;
                        return dataSource && dataSource.store()
                    };
                    _proto.loadAll = function(data) {
                        var skipFilter = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : false;
                        var that = this;
                        var d = new _deferred.Deferred;
                        var dataSource = that._dataSource;
                        if (dataSource) {
                            if (data) {
                                var options = {
                                    data: data,
                                    isCustomLoading: true,
                                    storeLoadOptions: {
                                        isLoadingAll: true
                                    },
                                    loadOptions: {
                                        filter: skipFilter ? null : that.getCombinedFilter(),
                                        group: dataSource.group(),
                                        sort: dataSource.sort()
                                    }
                                };
                                dataSource._handleDataLoaded(options);
                                (0, _deferred.when)(options.data).done((function(data) {
                                    var _a;
                                    data = that._beforeProcessItems(data);
                                    d.resolve(that._processItems(data, {
                                        changeType: "loadingAll"
                                    }), null === (_a = options.extra) || void 0 === _a ? void 0 : _a.summary)
                                })).fail(d.reject)
                            } else if (!dataSource.isLoading()) {
                                var loadOptions = (0, _extend.extend)({}, dataSource.loadOptions(), {
                                    isLoadingAll: true,
                                    requireTotalCount: false
                                });
                                dataSource.load(loadOptions).done((function(items, extra) {
                                    items = that._beforeProcessItems(items);
                                    items = that._processItems(items, {
                                        changeType: "loadingAll"
                                    });
                                    d.resolve(items, extra && extra.summary)
                                })).fail(d.reject)
                            } else {
                                d.reject()
                            }
                        } else {
                            d.resolve([])
                        }
                        return d
                    };
                    _proto.getKeyByRowIndex = function(rowIndex, byLoaded) {
                        var item = this.items(byLoaded)[rowIndex];
                        if (item) {
                            return item.key
                        }
                    };
                    _proto.getRowIndexByKey = function(key, byLoaded) {
                        return _m_utils.default.getIndexByKey(key, this.items(byLoaded))
                    };
                    _proto.keyOf = function(data) {
                        var store = this.store();
                        if (store) {
                            return store.keyOf(data)
                        }
                    };
                    _proto.byKey = function(key) {
                        var store = this.store();
                        var rowIndex = this.getRowIndexByKey(key);
                        var result;
                        if (!store) {
                            return
                        }
                        if (rowIndex >= 0) {
                            result = (new _deferred.Deferred).resolve(this.items()[rowIndex].data)
                        }
                        return result || store.byKey(key)
                    };
                    _proto.key = function() {
                        var store = this.store();
                        if (store) {
                            return store.key()
                        }
                    };
                    _proto.getRowIndexOffset = function(byLoadedRows) {
                        return 0
                    };
                    _proto.getDataByKeys = function(rowKeys) {
                        var that = this;
                        var result = new _deferred.Deferred;
                        var deferreds = [];
                        var data = [];
                        (0, _iterator.each)(rowKeys, (function(index, key) {
                            deferreds.push(that.byKey(key).done((function(keyData) {
                                data[index] = keyData
                            })))
                        }));
                        _deferred.when.apply(_renderer.default, deferreds).always((function() {
                            result.resolve(data)
                        }));
                        return result
                    };
                    _proto.pageIndex = function(value) {
                        return changePaging(this, "pageIndex", value)
                    };
                    _proto.pageSize = function(value) {
                        return changePaging(this, "pageSize", value)
                    };
                    _proto.beginCustomLoading = function(messageText) {
                        this._isCustomLoading = true;
                        this._loadingText = messageText || "";
                        this._fireLoadingChanged()
                    };
                    _proto.endCustomLoading = function() {
                        this._isCustomLoading = false;
                        this._loadingText = void 0;
                        this._fireLoadingChanged()
                    };
                    _proto.refresh = function(options) {
                        if (true === options) {
                            options = {
                                reload: true,
                                changesOnly: true
                            }
                        } else if (!options) {
                            options = {
                                lookup: true,
                                selection: true,
                                reload: true
                            }
                        }
                        var that = this;
                        var dataSource = that.getDataSource();
                        var _options = options,
                            changesOnly = _options.changesOnly;
                        var d = new _deferred.Deferred;
                        var customizeLoadResult = function() {
                            that._repaintChangesOnly = !!changesOnly
                        };
                        (0, _deferred.when)(!options.lookup || that._columnsController.refresh()).always((function() {
                            if (options.load || options.reload) {
                                dataSource && dataSource.on("customizeLoadResult", customizeLoadResult);
                                (0, _deferred.when)(that.reload(options.reload, changesOnly)).always((function() {
                                    dataSource && dataSource.off("customizeLoadResult", customizeLoadResult);
                                    that._repaintChangesOnly = void 0
                                })).done(d.resolve).fail(d.reject)
                            } else {
                                that.updateItems({
                                    repaintChangesOnly: options.changesOnly
                                });
                                d.resolve()
                            }
                        }));
                        return d.promise()
                    };
                    _proto.getVisibleRows = function() {
                        return this.items()
                    };
                    _proto._disposeDataSource = function() {
                        this.setDataSource(null)
                    };
                    _proto.dispose = function() {
                        this._disposeDataSource();
                        _ControllerWithDataMi.prototype.dispose.call(this)
                    };
                    _proto.repaintRows = function(rowIndexes, changesOnly) {
                        rowIndexes = Array.isArray(rowIndexes) ? rowIndexes : [rowIndexes];
                        if (rowIndexes.length > 1 || (0, _type.isDefined)(rowIndexes[0])) {
                            this.updateItems({
                                changeType: "update",
                                rowIndices: rowIndexes,
                                isFullUpdate: !changesOnly
                            })
                        }
                    };
                    _proto.skipProcessingPagingChange = function(fullName) {
                        return this._skipProcessingPagingChange && ("paging.pageIndex" === fullName || "paging.pageSize" === fullName)
                    };
                    _proto.getUserState = function() {
                        return {
                            searchText: this.option("searchPanel.text"),
                            pageIndex: this.pageIndex(),
                            pageSize: this.pageSize()
                        }
                    };
                    _proto.getCachedStoreData = function() {
                        return this._dataSource && this._dataSource.getCachedStoreData()
                    };
                    _proto.isLastPageLoaded = function() {
                        var pageIndex = this.pageIndex();
                        var pageCount = this.pageCount();
                        return pageIndex === pageCount - 1
                    };
                    _proto.load = function() {
                        var _a;
                        return null === (_a = this._dataSource) || void 0 === _a ? void 0 : _a.load()
                    };
                    _proto.reload = function(_reload, changesOnly) {
                        var _a;
                        return null === (_a = this._dataSource) || void 0 === _a ? void 0 : _a.reload(_reload, changesOnly)
                    };
                    _proto.push = function() {
                        var _a2;
                        var _a;
                        return null === (_a = this._dataSource) || void 0 === _a ? void 0 : (_a2 = _a).push.apply(_a2, arguments)
                    };
                    _proto.itemsCount = function() {
                        var _a;
                        return this._dataSource ? null === (_a = this._dataSource) || void 0 === _a ? void 0 : _a.itemsCount() : 0
                    };
                    _proto.totalItemsCount = function() {
                        var _a;
                        return this._dataSource ? null === (_a = this._dataSource) || void 0 === _a ? void 0 : _a.totalItemsCount() : 0
                    };
                    _proto.hasKnownLastPage = function() {
                        var _a;
                        return this._dataSource ? null === (_a = this._dataSource) || void 0 === _a ? void 0 : _a.hasKnownLastPage() : true
                    };
                    _proto.isLoaded = function() {
                        var _a;
                        return this._dataSource ? null === (_a = this._dataSource) || void 0 === _a ? void 0 : _a.isLoaded() : true
                    };
                    _proto.totalCount = function() {
                        var _a;
                        return this._dataSource ? null === (_a = this._dataSource) || void 0 === _a ? void 0 : _a.totalCount() : 0
                    };
                    return DataController
                }(ControllerWithDataMixin);
                exports.DataController = DataController;
                var dataControllerModule = {
                    defaultOptions: function() {
                        return {
                            loadingTimeout: 0,
                            dataSource: null,
                            cacheEnabled: true,
                            repaintChangesOnly: false,
                            highlightChanges: false,
                            onDataErrorOccurred: null,
                            remoteOperations: "auto",
                            paging: {
                                enabled: true,
                                pageSize: void 0,
                                pageIndex: void 0
                            }
                        }
                    },
                    controllers: {
                        data: DataController
                    }
                };
                exports.dataControllerModule = dataControllerModule
            },
        30945:
            /*!*********************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/data_source_adapter/m_data_source_adapter.js ***!
              \*********************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/callbacks */ 44504));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _array_store = _interopRequireDefault(__webpack_require__( /*! ../../../../data/array_store */ 26562));
                var _array_utils = __webpack_require__( /*! ../../../../data/array_utils */ 60637);
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                var _default = _m_modules.default.Controller.inherit(function() {
                    function cloneItems(items, groupCount) {
                        if (items) {
                            items = items.slice(0);
                            if (groupCount) {
                                for (var i = 0; i < items.length; i++) {
                                    items[i] = (0, _extend.extend)({
                                        key: items[i].key
                                    }, items[i]);
                                    items[i].items = cloneItems(items[i].items, groupCount - 1)
                                }
                            }
                        }
                        return items
                    }

                    function calculateOperationTypes(loadOptions, lastLoadOptions, isFullReload) {
                        var operationTypes = {
                            reload: true,
                            fullReload: true
                        };
                        if (lastLoadOptions) {
                            operationTypes = {
                                sorting: !_m_utils.default.equalSortParameters(loadOptions.sort, lastLoadOptions.sort),
                                grouping: !_m_utils.default.equalSortParameters(loadOptions.group, lastLoadOptions.group, true),
                                groupExpanding: !_m_utils.default.equalSortParameters(loadOptions.group, lastLoadOptions.group) || lastLoadOptions.groupExpand,
                                filtering: !_m_utils.default.equalFilterParameters(loadOptions.filter, lastLoadOptions.filter),
                                pageIndex: loadOptions.pageIndex !== lastLoadOptions.pageIndex,
                                skip: loadOptions.skip !== lastLoadOptions.skip,
                                take: loadOptions.take !== lastLoadOptions.take,
                                pageSize: loadOptions.pageSize !== lastLoadOptions.pageSize,
                                fullReload: isFullReload,
                                reload: false,
                                paging: false
                            };
                            operationTypes.reload = isFullReload || operationTypes.sorting || operationTypes.grouping || operationTypes.filtering;
                            operationTypes.paging = operationTypes.pageIndex || operationTypes.pageSize || operationTypes.take
                        }
                        return operationTypes
                    }

                    function getPageDataFromCache(options, updatePaging) {
                        var groupCount = _m_utils.default.normalizeSortingInfo(options.group || options.storeLoadOptions.group || options.loadOptions.group).length;
                        var items = [];
                        if (fillItemsFromCache(items, options, groupCount)) {
                            return items
                        }
                        if (updatePaging) {
                            ! function(cacheItemsFromBegin, options, groupCount) {
                                var _a, _b;
                                var cacheItemBeginCount = cacheItemsFromBegin.length;
                                var storeLoadOptions = options.storeLoadOptions;
                                if (void 0 !== storeLoadOptions.skip && storeLoadOptions.take && !groupCount) {
                                    var cacheItemsFromEnd = [];
                                    fillItemsFromCache(cacheItemsFromEnd, options, groupCount, true);
                                    var cacheItemEndCount = cacheItemsFromEnd.length;
                                    if (cacheItemBeginCount || cacheItemEndCount) {
                                        options.skip = null !== (_a = options.skip) && void 0 !== _a ? _a : storeLoadOptions.skip;
                                        options.take = null !== (_b = options.take) && void 0 !== _b ? _b : storeLoadOptions.take
                                    }
                                    if (cacheItemBeginCount) {
                                        storeLoadOptions.skip += cacheItemBeginCount;
                                        storeLoadOptions.take -= cacheItemBeginCount;
                                        options.cachedDataPartBegin = cacheItemsFromBegin
                                    }
                                    if (cacheItemEndCount) {
                                        storeLoadOptions.take -= cacheItemEndCount;
                                        options.cachedDataPartEnd = cacheItemsFromEnd.reverse()
                                    }
                                }
                            }(items, options, groupCount)
                        }
                    }

                    function fillItemsFromCache(items, options, groupCount, fromEnd) {
                        var _a, _b, _c, _d, _e;
                        var storeLoadOptions = options.storeLoadOptions;
                        var take = null !== (_b = null !== (_a = options.take) && void 0 !== _a ? _a : storeLoadOptions.take) && void 0 !== _b ? _b : 0;
                        var cachedItems = null === (_c = options.cachedData) || void 0 === _c ? void 0 : _c.items;
                        if (take && cachedItems) {
                            var skip = null !== (_e = null !== (_d = options.skip) && void 0 !== _d ? _d : storeLoadOptions.skip) && void 0 !== _e ? _e : 0;
                            for (var i = 0; i < take; i++) {
                                var localIndex = fromEnd ? take - 1 - i : i;
                                var cacheItemIndex = localIndex + skip;
                                var cacheItem = cachedItems[cacheItemIndex];
                                if (void 0 === cacheItem && cacheItemIndex in cachedItems) {
                                    return true
                                }
                                var item = getItemFromCache(options, cacheItem, groupCount, localIndex, take);
                                if (item) {
                                    items.push(item)
                                } else {
                                    return false
                                }
                            }
                            return true
                        }
                        return false
                    }

                    function getItemFromCache(options, cacheItem, groupCount, index, take) {
                        if (groupCount && cacheItem) {
                            var skips = 0 === index && options.skips || [];
                            var takes = index === take - 1 && options.takes || [];
                            return function getGroupItemFromCache(cacheItem, groupCount, skips, takes) {
                                if (groupCount && cacheItem) {
                                    var result = _extends({}, cacheItem);
                                    var skip = skips[0] || 0;
                                    var take = takes[0];
                                    var items = cacheItem.items;
                                    if (items) {
                                        if (void 0 === take && !items[skip]) {
                                            return
                                        }
                                        result.items = [];
                                        if (skips.length) {
                                            result.isContinuation = true
                                        }
                                        if (take) {
                                            result.isContinuationOnNextPage = cacheItem.count > take
                                        }
                                        for (var i = 0; void 0 === take ? items[i + skip] : i < take; i++) {
                                            var childCacheItem = items[i + skip];
                                            var isLast = i + 1 === take;
                                            var item = getGroupItemFromCache(childCacheItem, groupCount - 1, 0 === i ? skips.slice(1) : [], isLast ? takes.slice(1) : []);
                                            if (void 0 !== item) {
                                                result.items.push(item)
                                            } else {
                                                return
                                            }
                                        }
                                    }
                                    return result
                                }
                                return cacheItem
                            }(cacheItem, groupCount, skips, takes)
                        }
                        return cacheItem
                    }

                    function getCacheItem(cacheItem, loadedItem, groupCount, skips) {
                        if (groupCount && loadedItem) {
                            var result = _extends({}, loadedItem);
                            delete result.isContinuation;
                            delete result.isContinuationOnNextPage;
                            var skip = skips[0] || 0;
                            if (loadedItem.items) {
                                result.items = (null === cacheItem || void 0 === cacheItem ? void 0 : cacheItem.items) || {};
                                loadedItem.items.forEach((function(item, index) {
                                    var globalIndex = index + skip;
                                    var childSkips = 0 === index ? skips.slice(1) : [];
                                    result.items[globalIndex] = getCacheItem(result.items[globalIndex], item, groupCount - 1, childSkips)
                                }))
                            }
                            return result
                        }
                        return loadedItem
                    }
                    var members = {
                        init: function(dataSource, remoteOperations) {
                            var that = this;
                            that._dataSource = dataSource;
                            that._remoteOperations = remoteOperations || {};
                            that._isLastPage = !dataSource.isLastPage();
                            that._hasLastPage = false;
                            that._currentTotalCount = 0;
                            that._cachedData = {
                                items: {}
                            };
                            that._lastOperationTypes = {};
                            that._eventsStrategy = dataSource._eventsStrategy;
                            that._totalCountCorrection = 0;
                            that._isLoadingAll = false;
                            that.changed = (0, _callbacks.default)();
                            that.loadingChanged = (0, _callbacks.default)();
                            that.loadError = (0, _callbacks.default)();
                            that.customizeStoreLoadOptions = (0, _callbacks.default)();
                            that.changing = (0, _callbacks.default)();
                            that.pushed = (0, _callbacks.default)();
                            that._dataChangedHandler = that._handleDataChanged.bind(that);
                            that._customizeStoreLoadOptionsHandler = that._handleCustomizeStoreLoadOptions.bind(that);
                            that._dataLoadedHandler = that._handleDataLoaded.bind(that);
                            that._loadingChangedHandler = that._handleLoadingChanged.bind(that);
                            that._loadErrorHandler = that._handleLoadError.bind(that);
                            that._pushHandler = that._handlePush.bind(that);
                            that._changingHandler = that._handleChanging.bind(that);
                            dataSource.on("changed", that._dataChangedHandler);
                            dataSource.on("customizeStoreLoadOptions", that._customizeStoreLoadOptionsHandler);
                            dataSource.on("customizeLoadResult", that._dataLoadedHandler);
                            dataSource.on("loadingChanged", that._loadingChangedHandler);
                            dataSource.on("loadError", that._loadErrorHandler);
                            dataSource.on("changing", that._changingHandler);
                            dataSource.store().on("beforePush", that._pushHandler);
                            (0, _iterator.each)(dataSource, (function(memberName, member) {
                                if (!that[memberName] && (0, _type.isFunction)(member)) {
                                    that[memberName] = function() {
                                        return this._dataSource[memberName].apply(this._dataSource, arguments)
                                    }
                                }
                            }))
                        },
                        remoteOperations: function() {
                            return this._remoteOperations
                        },
                        dispose: function(isSharedDataSource) {
                            var dataSource = this._dataSource;
                            var store = dataSource.store();
                            dataSource.off("changed", this._dataChangedHandler);
                            dataSource.off("customizeStoreLoadOptions", this._customizeStoreLoadOptionsHandler);
                            dataSource.off("customizeLoadResult", this._dataLoadedHandler);
                            dataSource.off("loadingChanged", this._loadingChangedHandler);
                            dataSource.off("loadError", this._loadErrorHandler);
                            dataSource.off("changing", this._changingHandler);
                            store && store.off("beforePush", this._pushHandler);
                            if (!isSharedDataSource) {
                                dataSource.dispose()
                            }
                        },
                        refresh: function(options, operationTypes) {
                            var dataSource = this._dataSource;
                            if (operationTypes.reload) {
                                this.resetCurrentTotalCount();
                                this._isLastPage = !dataSource.paginate();
                                this._hasLastPage = this._isLastPage
                            }
                        },
                        resetCurrentTotalCount: function() {
                            this._currentTotalCount = 0;
                            this._totalCountCorrection = 0
                        },
                        resetCache: function() {
                            this._cachedStoreData = void 0;
                            this._cachedPagingData = void 0
                        },
                        resetPagesCache: function() {
                            this._cachedData = {
                                items: {}
                            }
                        },
                        _needClearStoreDataCache: function() {
                            var remoteOperations = this.remoteOperations();
                            var operationTypes = calculateOperationTypes(this._lastLoadOptions || {}, {});
                            var isLocalOperations = Object.keys(remoteOperations).every((function(operationName) {
                                return !operationTypes[operationName] || !remoteOperations[operationName]
                            }));
                            return !isLocalOperations
                        },
                        push: function(changes, fromStore) {
                            var store = this.store();
                            if (this._needClearStoreDataCache()) {
                                this._cachedStoreData = void 0
                            }
                            this._cachedPagingData = void 0;
                            this.resetPagesCache(true);
                            if (this._cachedStoreData) {
                                (0, _array_utils.applyBatch)({
                                    keyInfo: store,
                                    data: this._cachedStoreData,
                                    changes: changes
                                })
                            }
                            if (!fromStore) {
                                this._applyBatch(changes)
                            }
                            this.pushed.fire(changes)
                        },
                        getDataIndexGetter: function() {
                            var _this = this;
                            if (!this._dataIndexGetter) {
                                var indexByKey;
                                var storeData;
                                var store = this.store();
                                this._dataIndexGetter = function(data) {
                                    var isCacheUpdated = storeData && storeData !== _this._cachedStoreData;
                                    if (!indexByKey || isCacheUpdated) {
                                        storeData = _this._cachedStoreData || [];
                                        indexByKey = {};
                                        for (var i = 0; i < storeData.length; i++) {
                                            indexByKey[(0, _common.getKeyHash)(store.keyOf(storeData[i]))] = i
                                        }
                                    }
                                    return indexByKey[(0, _common.getKeyHash)(store.keyOf(data))]
                                }
                            }
                            return this._dataIndexGetter
                        },
                        _getKeyInfo: function() {
                            return this.store()
                        },
                        _needToCopyDataObject: function() {
                            return true
                        },
                        _applyBatch: function(changes, fromStore) {
                            var _this2 = this;
                            var keyInfo = this._getKeyInfo();
                            var dataSource = this._dataSource;
                            var groupCount = _m_utils.default.normalizeSortingInfo(this.group()).length;
                            var isReshapeMode = "reshape" === this.option("editing.refreshMode");
                            var isVirtualMode = "virtual" === this.option("scrolling.mode");
                            changes = changes.filter((function(change) {
                                return !dataSource.paginate() || "insert" !== change.type || void 0 !== change.index
                            }));
                            var getItemCount = function() {
                                return groupCount ? _this2.itemsCount() : _this2.items().length
                            };
                            var oldItemCount = getItemCount();
                            (0, _array_utils.applyBatch)({
                                keyInfo: keyInfo,
                                data: this._items,
                                changes: changes,
                                groupCount: groupCount,
                                useInsertIndex: true,
                                skipCopying: !this._needToCopyDataObject()
                            });
                            (0, _array_utils.applyBatch)({
                                keyInfo: keyInfo,
                                data: dataSource.items(),
                                changes: changes,
                                groupCount: groupCount,
                                useInsertIndex: true,
                                skipCopying: !this._needToCopyDataObject()
                            });
                            var needUpdateTotalCountCorrection = this._currentTotalCount > 0 || (fromStore || !isReshapeMode) && isVirtualMode;
                            if (needUpdateTotalCountCorrection) {
                                this._totalCountCorrection += getItemCount() - oldItemCount
                            }
                            changes.splice(0, changes.length)
                        },
                        _handlePush: function(_ref) {
                            var changes = _ref.changes;
                            this.push(changes, true)
                        },
                        _handleChanging: function(e) {
                            this.changing.fire(e);
                            this._applyBatch(e.changes, true)
                        },
                        _needCleanCacheByOperation: function(operationType, remoteOperations) {
                            var operationTypesByOrder = ["filtering", "sorting", "paging"];
                            var operationTypeIndex = operationTypesByOrder.indexOf(operationType);
                            var currentOperationTypes = operationTypeIndex >= 0 ? operationTypesByOrder.slice(operationTypeIndex) : [operationType];
                            return currentOperationTypes.some((function(operationType) {
                                return remoteOperations[operationType]
                            }))
                        },
                        _customizeRemoteOperations: function(options, operationTypes) {
                            var _this3 = this;
                            var cachedStoreData = this._cachedStoreData;
                            var cachedPagingData = this._cachedPagingData;
                            var cachedData = this._cachedData;
                            if (options.storeLoadOptions.filter && !options.remoteOperations.filtering || options.storeLoadOptions.sort && !options.remoteOperations.sorting) {
                                options.remoteOperations = {
                                    filtering: options.remoteOperations.filtering,
                                    summary: options.remoteOperations.summary
                                }
                            }
                            if (operationTypes.fullReload) {
                                cachedStoreData = void 0;
                                cachedPagingData = void 0;
                                cachedData = {
                                    items: {}
                                }
                            } else {
                                if (operationTypes.reload) {
                                    cachedPagingData = void 0;
                                    cachedData = {
                                        items: {}
                                    }
                                } else if (operationTypes.groupExpanding) {
                                    cachedData = {
                                        items: {}
                                    }
                                }(0, _iterator.each)(operationTypes, (function(operationType, value) {
                                    if (value && _this3._needCleanCacheByOperation(operationType, options.remoteOperations)) {
                                        cachedStoreData = void 0;
                                        cachedPagingData = void 0
                                    }
                                }))
                            }
                            if (cachedPagingData) {
                                options.remoteOperations.paging = false
                            }
                            options.cachedStoreData = cachedStoreData;
                            options.cachedPagingData = cachedPagingData;
                            options.cachedData = cachedData;
                            if (!options.isCustomLoading) {
                                this._cachedStoreData = cachedStoreData;
                                this._cachedPagingData = cachedPagingData;
                                this._cachedData = cachedData
                            }
                        },
                        _handleCustomizeStoreLoadOptions: function(options) {
                            var _a;
                            this._handleDataLoading(options);
                            if (!(0 === (null === (_a = options.data) || void 0 === _a ? void 0 : _a.length))) {
                                options.data = getPageDataFromCache(options, true) || options.cachedStoreData
                            }
                        },
                        _handleDataLoading: function(options) {
                            var _this4 = this;
                            var dataSource = this._dataSource;
                            var lastLoadOptions = this._lastLoadOptions;
                            this.customizeStoreLoadOptions.fire(options);
                            options.delay = this.option("loadingTimeout");
                            options.originalStoreLoadOptions = options.storeLoadOptions;
                            options.remoteOperations = (0, _extend.extend)({}, this.remoteOperations());
                            var isFullReload = !this.isLoaded() && !this._isRefreshing;
                            if (this.option("integrationOptions.renderedOnServer") && !this.isLoaded()) {
                                options.delay = void 0
                            }
                            var loadOptions = (0, _extend.extend)({
                                pageIndex: this.pageIndex(),
                                pageSize: this.pageSize()
                            }, options.storeLoadOptions);
                            var operationTypes = calculateOperationTypes(loadOptions, lastLoadOptions, isFullReload);
                            this._customizeRemoteOperations(options, operationTypes);
                            if (!options.isCustomLoading) {
                                var isRefreshing = this._isRefreshing;
                                options.pageIndex = dataSource.pageIndex();
                                options.lastLoadOptions = loadOptions;
                                options.operationTypes = operationTypes;
                                this._loadingOperationTypes = operationTypes;
                                this._isRefreshing = true;
                                (0, _deferred.when)(isRefreshing || this._isRefreshed || this.refresh(options, operationTypes)).done((function() {
                                    if (_this4._lastOperationId === options.operationId) {
                                        _this4._isRefreshed = true;
                                        _this4.load().always((function() {
                                            _this4._isRefreshed = false
                                        }))
                                    }
                                })).fail((function() {
                                    dataSource.cancel(options.operationId)
                                })).always((function() {
                                    _this4._isRefreshing = false
                                }));
                                dataSource.cancel(this._lastOperationId);
                                this._lastOperationId = options.operationId;
                                if (this._isRefreshing) {
                                    dataSource.cancel(this._lastOperationId)
                                }
                            }
                            this._handleDataLoadingCore(options)
                        },
                        _handleDataLoadingCore: function(options) {
                            var remoteOperations = options.remoteOperations;
                            options.loadOptions = {};
                            var cachedExtra = options.cachedData.extra;
                            var localLoadOptionNames = {
                                filter: !remoteOperations.filtering,
                                sort: !remoteOperations.sorting,
                                group: !remoteOperations.grouping,
                                summary: !remoteOperations.summary,
                                skip: !remoteOperations.paging,
                                take: !remoteOperations.paging,
                                requireTotalCount: cachedExtra && "totalCount" in cachedExtra || !remoteOperations.paging,
                                langParams: !remoteOperations.filtering || !remoteOperations.sorting
                            };
                            (0, _iterator.each)(options.storeLoadOptions, (function(optionName, optionValue) {
                                if (localLoadOptionNames[optionName]) {
                                    options.loadOptions[optionName] = optionValue;
                                    delete options.storeLoadOptions[optionName]
                                }
                            }));
                            if (cachedExtra) {
                                options.extra = cachedExtra
                            }
                        },
                        _handleDataLoaded: function(options) {
                            var _this5 = this;
                            var _a, _b;
                            var loadOptions = options.loadOptions;
                            var localPaging = options.remoteOperations && !options.remoteOperations.paging;
                            var cachedData = options.cachedData;
                            var storeLoadOptions = options.storeLoadOptions;
                            var needCache = false !== this.option("cacheEnabled") && storeLoadOptions;
                            var needPageCache = needCache && !options.isCustomLoading && cachedData && (!localPaging || storeLoadOptions.group);
                            var needPagingCache = needCache && localPaging;
                            var needStoreCache = needPagingCache && !options.isCustomLoading;
                            if (!loadOptions) {
                                this._dataSource.cancel(options.operationId);
                                return
                            }
                            if (localPaging) {
                                options.skip = loadOptions.skip;
                                options.take = loadOptions.take;
                                delete loadOptions.skip;
                                delete loadOptions.take
                            }
                            if (loadOptions.group) {
                                loadOptions.group = options.group || loadOptions.group
                            }
                            var groupCount = _m_utils.default.normalizeSortingInfo(options.group || storeLoadOptions.group || loadOptions.group).length;
                            if (options.cachedDataPartBegin) {
                                options.data = options.cachedDataPartBegin.concat(options.data)
                            }
                            if (options.cachedDataPartEnd) {
                                options.data = options.data.concat(options.cachedDataPartEnd)
                            }
                            if (!needPageCache || !getPageDataFromCache(options)) {
                                if (needPagingCache && options.cachedPagingData) {
                                    options.data = cloneItems(options.cachedPagingData, groupCount)
                                } else {
                                    if (needStoreCache) {
                                        if (!this._cachedStoreData) {
                                            this._cachedStoreData = cloneItems(options.data, _m_utils.default.normalizeSortingInfo(storeLoadOptions.group).length)
                                        } else if (options.mergeStoreLoadData) {
                                            options.data = this._cachedStoreData = this._cachedStoreData.concat(options.data)
                                        }
                                    }
                                    new _array_store.default(options.data).load(loadOptions).done((function(data) {
                                        options.data = data;
                                        if (needStoreCache) {
                                            _this5._cachedPagingData = cloneItems(options.data, groupCount)
                                        }
                                    })).fail((function(error) {
                                        options.data = (new _deferred.Deferred).reject(error)
                                    }))
                                }
                                if (loadOptions.requireTotalCount && localPaging) {
                                    options.extra = (0, _type.isPlainObject)(options.extra) ? options.extra : {};
                                    options.extra.totalCount = options.data.length
                                }
                                if (options.extra && options.extra.totalCount >= 0 && (false === storeLoadOptions.requireTotalCount || false === loadOptions.requireTotalCount)) {
                                    options.extra.totalCount = -1
                                }
                                if (!loadOptions.data && (storeLoadOptions.requireTotalCount || (null !== (_b = null === (_a = options.extra) || void 0 === _a ? void 0 : _a.totalCount) && void 0 !== _b ? _b : -1) >= 0)) {
                                    this._totalCountCorrection = 0
                                }
                                this._handleDataLoadedCore(options);
                                if (needPageCache) {
                                    cachedData.extra = cachedData.extra || (0, _extend.extend)({}, options.extra);
                                    (0, _deferred.when)(options.data).done((function(data) {
                                        ! function(options, data, groupCount) {
                                            var _a, _b, _c, _d;
                                            var storeLoadOptions = options.storeLoadOptions;
                                            var skip = null !== (_b = null !== (_a = options.skip) && void 0 !== _a ? _a : storeLoadOptions.skip) && void 0 !== _b ? _b : 0;
                                            var take = null !== (_d = null !== (_c = options.take) && void 0 !== _c ? _c : storeLoadOptions.take) && void 0 !== _d ? _d : 0;
                                            for (var i = 0; i < take; i++) {
                                                var globalIndex = i + skip;
                                                var cacheItems = options.cachedData.items;
                                                var skips = 0 === i && options.skips || [];
                                                cacheItems[globalIndex] = getCacheItem(cacheItems[globalIndex], data[i], groupCount, skips)
                                            }
                                        }(options, data, groupCount)
                                    }))
                                }
                            }(0, _deferred.when)(options.data).done((function() {
                                if (options.lastLoadOptions) {
                                    _this5._lastLoadOptions = options.lastLoadOptions;
                                    Object.keys(options.operationTypes).forEach((function(operationType) {
                                        _this5._lastOperationTypes[operationType] = _this5._lastOperationTypes[operationType] || options.operationTypes[operationType]
                                    }))
                                }
                            }));
                            options.storeLoadOptions = options.originalStoreLoadOptions
                        },
                        _handleDataLoadedCore: function(options) {
                            if (options.remoteOperations && !options.remoteOperations.paging && Array.isArray(options.data)) {
                                if (void 0 !== options.skip) {
                                    options.data = options.data.slice(options.skip)
                                }
                                if (void 0 !== options.take) {
                                    options.data = options.data.slice(0, options.take)
                                }
                            }
                        },
                        _handleLoadingChanged: function(isLoading) {
                            this.loadingChanged.fire(isLoading)
                        },
                        _handleLoadError: function(error) {
                            this.loadError.fire(error);
                            this.changed.fire({
                                changeType: "loadError",
                                error: error
                            })
                        },
                        _loadPageSize: function() {
                            return this.pageSize()
                        },
                        _handleDataChanged: function(args) {
                            var currentTotalCount;
                            var dataSource = this._dataSource;
                            var isLoading = false;
                            var isDataLoading = !args || (0, _type.isDefined)(args.changeType);
                            var itemsCount = this.itemsCount();
                            if (isDataLoading) {
                                this._isLastPage = !itemsCount || !this._loadPageSize() || itemsCount < this._loadPageSize();
                                if (this._isLastPage) {
                                    this._hasLastPage = true
                                }
                            }
                            if (dataSource.totalCount() >= 0) {
                                if (dataSource.pageIndex() >= this.pageCount()) {
                                    dataSource.pageIndex(this.pageCount() - 1);
                                    this.pageIndex(dataSource.pageIndex());
                                    this.resetPagesCache();
                                    dataSource.load();
                                    isLoading = true
                                }
                            } else if (isDataLoading) {
                                currentTotalCount = dataSource.pageIndex() * this.pageSize() + itemsCount;
                                if (currentTotalCount > this._currentTotalCount) {
                                    this._currentTotalCount = currentTotalCount;
                                    if (0 === dataSource.pageIndex() || !this.option("scrolling.legacyMode")) {
                                        this._totalCountCorrection = 0
                                    }
                                }
                                if (0 === itemsCount && dataSource.pageIndex() >= this.pageCount()) {
                                    dataSource.pageIndex(this.pageCount() - 1);
                                    if ("infinite" !== this.option("scrolling.mode")) {
                                        dataSource.load();
                                        isLoading = true
                                    }
                                }
                            }
                            if (!isLoading) {
                                this._operationTypes = this._lastOperationTypes;
                                this._lastOperationTypes = {};
                                this.component._optionCache = {};
                                this.changed.fire(args);
                                this.component._optionCache = void 0
                            }
                        },
                        _scheduleCustomLoadCallbacks: function(deferred) {
                            var that = this;
                            that._isCustomLoading = true;
                            deferred.always((function() {
                                that._isCustomLoading = false
                            }))
                        },
                        loadingOperationTypes: function() {
                            return this._loadingOperationTypes
                        },
                        operationTypes: function() {
                            return this._operationTypes
                        },
                        lastLoadOptions: function() {
                            return this._lastLoadOptions || {}
                        },
                        isLastPage: function() {
                            return this._isLastPage
                        },
                        _dataSourceTotalCount: function() {
                            return this._dataSource.totalCount()
                        },
                        totalCount: function() {
                            return parseInt((this._currentTotalCount || this._dataSourceTotalCount()) + this._totalCountCorrection)
                        },
                        totalCountCorrection: function() {
                            return this._totalCountCorrection
                        },
                        itemsCount: function() {
                            return this._dataSource.items().length
                        },
                        totalItemsCount: function() {
                            return this.totalCount()
                        },
                        pageSize: function() {
                            var dataSource = this._dataSource;
                            if (!arguments.length && !dataSource.paginate()) {
                                return 0
                            }
                            return dataSource.pageSize.apply(dataSource, arguments)
                        },
                        pageCount: function() {
                            var count = this.totalItemsCount() - this._totalCountCorrection;
                            var pageSize = this.pageSize();
                            if (pageSize && count > 0) {
                                return Math.max(1, Math.ceil(count / pageSize))
                            }
                            return 1
                        },
                        hasKnownLastPage: function() {
                            return this._hasLastPage || this._dataSource.totalCount() >= 0
                        },
                        loadFromStore: function(loadOptions, store) {
                            var dataSource = this._dataSource;
                            var d = new _deferred.Deferred;
                            if (!dataSource) {
                                return
                            }
                            store = store || dataSource.store();
                            store.load(loadOptions).done((function(data, extra) {
                                if (data && !Array.isArray(data) && Array.isArray(data.data)) {
                                    extra = data;
                                    data = data.data
                                }
                                d.resolve(data, extra)
                            })).fail(d.reject);
                            return d
                        },
                        isCustomLoading: function() {
                            return !!this._isCustomLoading
                        },
                        load: function(options) {
                            var _this6 = this;
                            var that = this;
                            var dataSource = that._dataSource;
                            var d = new _deferred.Deferred;
                            if (options) {
                                var store = dataSource.store();
                                var dataSourceLoadOptions = dataSource.loadOptions();
                                var loadResult = {
                                    storeLoadOptions: (0, _extend.extend)({}, options, {
                                        langParams: null === dataSourceLoadOptions || void 0 === dataSourceLoadOptions ? void 0 : dataSourceLoadOptions.langParams
                                    }),
                                    isCustomLoading: true
                                };
                                (0, _iterator.each)(store._customLoadOptions() || [], (function(_, optionName) {
                                    if (!(optionName in loadResult.storeLoadOptions)) {
                                        loadResult.storeLoadOptions[optionName] = dataSourceLoadOptions[optionName]
                                    }
                                }));
                                this._isLoadingAll = options.isLoadingAll;
                                that._scheduleCustomLoadCallbacks(d);
                                dataSource._scheduleLoadCallbacks(d);
                                that._handleCustomizeStoreLoadOptions(loadResult);
                                ! function(action, timeout) {
                                    if ((0, _type.isDefined)(timeout)) {
                                        (0, _common.executeAsync)(action, timeout)
                                    } else {
                                        action()
                                    }
                                }((function() {
                                    if (!dataSource.store()) {
                                        return d.reject("canceled")
                                    }(0, _deferred.when)(loadResult.data || that.loadFromStore(loadResult.storeLoadOptions)).done((function(data, extra) {
                                        loadResult.data = data;
                                        loadResult.extra = extra || {};
                                        that._handleDataLoaded(loadResult);
                                        if (options.requireTotalCount && void 0 === loadResult.extra.totalCount) {
                                            loadResult.extra.totalCount = store.totalCount(loadResult.storeLoadOptions)
                                        }(0, _deferred.when)(loadResult.data, loadResult.extra.totalCount).done((function(data, totalCount) {
                                            loadResult.extra.totalCount = totalCount;
                                            d.resolve(data, loadResult.extra)
                                        })).fail(d.reject)
                                    })).fail(d.reject)
                                }), that.option("loadingTimeout"));
                                return d.fail((function() {
                                    that._eventsStrategy.fireEvent("loadError", arguments)
                                })).always((function() {
                                    _this6._isLoadingAll = false
                                })).promise()
                            }
                            return dataSource.load()
                        },
                        reload: function(full) {
                            return full ? this._dataSource.reload() : this._dataSource.load()
                        },
                        getCachedStoreData: function() {
                            return this._cachedStoreData
                        }
                    };
                    return members
                }());
                exports.default = _default
            },
        72313:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/editing/const.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.VIEWPORT_TOP_NEW_ROW_POSITION = exports.VIEWPORT_BOTTOM_NEW_ROW_POSITION = exports.TARGET_COMPONENT_NAME = exports.ROW_SELECTED_CLASS = exports.ROW_SELECTED = exports.ROW_REMOVED = exports.ROW_MODIFIED = exports.ROW_INSERTED = exports.ROW_CLASS = exports.ROW_BASED_MODES = exports.REQUIRED_EDITOR_LABELLEDBY_MODES = exports.READONLY_CLASS = exports.PAGE_TOP_NEW_ROW_POSITION = exports.PAGE_BOTTOM_NEW_ROW_POSITION = exports.MODES_WITH_DELAYED_FOCUS = exports.METHOD_NAMES = exports.LINK_ICON_CLASS = exports.LINK_CLASS = exports.LAST_NEW_ROW_POSITION = exports.INSERT_INDEX = exports.FORM_BUTTONS_CONTAINER_CLASS = exports.FOCUS_OVERLAY_CLASS = exports.FOCUSABLE_ELEMENT_SELECTOR = exports.FOCUSABLE_ELEMENT_CLASS = exports.FIRST_NEW_ROW_POSITION = exports.EDIT_ROW = exports.EDIT_POPUP_FORM_CLASS = exports.EDIT_POPUP_CLASS = exports.EDIT_MODE_ROW = exports.EDIT_MODE_POPUP = exports.EDIT_MODE_FORM = exports.EDIT_MODE_CELL = exports.EDIT_MODE_BATCH = exports.EDIT_MODES = exports.EDIT_LINK_CLASS = exports.EDIT_ICON_CLASS = exports.EDIT_FORM_ITEM_CLASS = exports.EDIT_FORM_CLASS = exports.EDIT_BUTTON_CLASS = exports.EDITOR_CELL_CLASS = exports.EDITORS_INPUT_SELECTOR = exports.EDITING_POPUP_OPTION_NAME = exports.EDITING_NAMESPACE = exports.EDITING_FORM_OPTION_NAME = exports.EDITING_EDITROWKEY_OPTION_NAME = exports.EDITING_EDITCOLUMNNAME_OPTION_NAME = exports.EDITING_CHANGES_OPTION_NAME = exports.DROPDOWN_EDITOR_OVERLAY_CLASS = exports.DEFAULT_START_EDIT_ACTION = exports.DATA_ROW_CLASS = exports.DATA_EDIT_DATA_UPDATE_TYPE = exports.DATA_EDIT_DATA_REMOVE_TYPE = exports.DATA_EDIT_DATA_INSERT_TYPE = exports.COMMAND_EDIT_WITH_ICONS_CLASS = exports.COMMAND_EDIT_CLASS = exports.CELL_MODIFIED_CLASS = exports.CELL_MODIFIED = exports.CELL_FOCUS_DISABLED_CLASS = exports.BUTTON_NAMES = exports.BUTTON_CLASS = exports.ADD_ROW_BUTTON_CLASS = exports.ACTION_OPTION_NAMES = void 0;
                var _ui = (obj = __webpack_require__( /*! ../../../../ui/scroll_view/ui.scrollable */ 41183), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                exports.EDITOR_CELL_CLASS = "dx-editor-cell";
                exports.ROW_CLASS = "dx-row";
                exports.CELL_MODIFIED_CLASS = "dx-cell-modified";
                exports.ROW_SELECTED_CLASS = "dx-selection";
                exports.EDIT_FORM_CLASS = "edit-form";
                exports.DATA_EDIT_DATA_INSERT_TYPE = "insert";
                exports.DATA_EDIT_DATA_REMOVE_TYPE = "remove";
                exports.EDITING_POPUP_OPTION_NAME = "editing.popup";
                exports.EDITING_FORM_OPTION_NAME = "editing.form";
                exports.EDITING_EDITROWKEY_OPTION_NAME = "editing.editRowKey";
                exports.EDITING_EDITCOLUMNNAME_OPTION_NAME = "editing.editColumnName";
                exports.TARGET_COMPONENT_NAME = "targetComponent";
                exports.EDITORS_INPUT_SELECTOR = "input:not([type='hidden'])";
                var FOCUSABLE_ELEMENT_SELECTOR = "[tabindex]:not([disabled]), ".concat("input:not([type='hidden'])", ":not([disabled])");
                exports.FOCUSABLE_ELEMENT_SELECTOR = FOCUSABLE_ELEMENT_SELECTOR;
                exports.EDIT_MODE_BATCH = "batch";
                exports.EDIT_MODE_ROW = "row";
                exports.EDIT_MODE_CELL = "cell";
                exports.EDIT_MODE_FORM = "form";
                exports.EDIT_MODE_POPUP = "popup";
                exports.FIRST_NEW_ROW_POSITION = "first";
                exports.LAST_NEW_ROW_POSITION = "last";
                exports.PAGE_BOTTOM_NEW_ROW_POSITION = "pageBottom";
                exports.PAGE_TOP_NEW_ROW_POSITION = "pageTop";
                exports.VIEWPORT_BOTTOM_NEW_ROW_POSITION = "viewportBottom";
                exports.VIEWPORT_TOP_NEW_ROW_POSITION = "viewportTop";
                var EDIT_MODES = ["batch", "row", "cell", "form", "popup"];
                exports.EDIT_MODES = EDIT_MODES;
                var ROW_BASED_MODES = ["row", "form", "popup"];
                exports.ROW_BASED_MODES = ROW_BASED_MODES;
                var REQUIRED_EDITOR_LABELLEDBY_MODES = ["batch", "row", "cell"];
                exports.REQUIRED_EDITOR_LABELLEDBY_MODES = REQUIRED_EDITOR_LABELLEDBY_MODES;
                var MODES_WITH_DELAYED_FOCUS = ["row", "form"];
                exports.MODES_WITH_DELAYED_FOCUS = MODES_WITH_DELAYED_FOCUS;
                exports.READONLY_CLASS = "readonly";
                exports.LINK_CLASS = "dx-link";
                exports.LINK_ICON_CLASS = "dx-link-icon";
                exports.ROW_SELECTED = "dx-selection";
                exports.EDIT_BUTTON_CLASS = "dx-edit-button";
                exports.COMMAND_EDIT_CLASS = "dx-command-edit";
                var COMMAND_EDIT_WITH_ICONS_CLASS = "".concat("dx-command-edit", "-with-icons");
                exports.COMMAND_EDIT_WITH_ICONS_CLASS = COMMAND_EDIT_WITH_ICONS_CLASS;
                exports.INSERT_INDEX = "__DX_INSERT_INDEX__";
                exports.ROW_INSERTED = "dx-row-inserted";
                exports.ROW_MODIFIED = "dx-row-modified";
                exports.CELL_MODIFIED = "dx-cell-modified";
                exports.EDITING_NAMESPACE = "dxDataGridEditing";
                exports.CELL_FOCUS_DISABLED_CLASS = "dx-cell-focus-disabled";
                exports.DATA_EDIT_DATA_UPDATE_TYPE = "update";
                exports.DEFAULT_START_EDIT_ACTION = "click";
                exports.EDIT_LINK_CLASS = {
                    save: "dx-link-save",
                    cancel: "dx-link-cancel",
                    edit: "dx-link-edit",
                    undelete: "dx-link-undelete",
                    delete: "dx-link-delete",
                    add: "dx-link-add"
                };
                exports.EDIT_ICON_CLASS = {
                    save: "save",
                    cancel: "revert",
                    edit: "edit",
                    undelete: "revert",
                    delete: "trash",
                    add: "add"
                };
                exports.METHOD_NAMES = {
                    edit: "editRow",
                    delete: "deleteRow",
                    undelete: "undeleteRow",
                    save: "saveEditData",
                    cancel: "cancelEditData",
                    add: "addRowByRowIndex"
                };
                exports.ACTION_OPTION_NAMES = {
                    add: "allowAdding",
                    edit: "allowUpdating",
                    delete: "allowDeleting"
                };
                exports.BUTTON_NAMES = ["edit", "save", "cancel", "delete", "undelete"];
                exports.EDITING_CHANGES_OPTION_NAME = "editing.changes";
                exports.FOCUS_OVERLAY_CLASS = "focus-overlay";
                exports.ADD_ROW_BUTTON_CLASS = "addrow-button";
                exports.DROPDOWN_EDITOR_OVERLAY_CLASS = "dx-dropdowneditor-overlay";
                exports.DATA_ROW_CLASS = "dx-data-row";
                exports.ROW_REMOVED = "dx-row-removed";
                var isRenovatedScrollable = !!_ui.default.IS_RENOVATED_WIDGET;
                exports.EDIT_FORM_ITEM_CLASS = "edit-form-item";
                exports.EDIT_POPUP_CLASS = "edit-popup";
                exports.EDIT_POPUP_FORM_CLASS = "edit-popup-form";
                var FOCUSABLE_ELEMENT_CLASS = isRenovatedScrollable ? "dx-scrollable" : "dx-scrollable-container";
                exports.FOCUSABLE_ELEMENT_CLASS = FOCUSABLE_ELEMENT_CLASS;
                exports.BUTTON_CLASS = "dx-button";
                exports.FORM_BUTTONS_CONTAINER_CLASS = "form-buttons-container";
                exports.EDIT_ROW = "dx-edit-row"
            },
        22324:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/editing/m_editing.js ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.editingModule = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../../core/devices */ 20530));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../../core/dom_adapter */ 73349));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../../../core/guid */ 73176));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 62754);
                var _dom = __webpack_require__( /*! ../../../../core/utils/dom */ 3532);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 13306);
                var iconUtils = function(obj, nodeInterop) {
                    if (!nodeInterop && obj && obj.__esModule) {
                        return obj
                    }
                    if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                        return {
                            default: obj
                        }
                    }
                    var cache = _getRequireWildcardCache(nodeInterop);
                    if (cache && cache.has(obj)) {
                        return cache.get(obj)
                    }
                    var newObj = {};
                    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var key in obj) {
                        if ("default" !== key && Object.prototype.hasOwnProperty.call(obj, key)) {
                            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                            if (desc && (desc.get || desc.set)) {
                                Object.defineProperty(newObj, key, desc)
                            } else {
                                newObj[key] = obj[key]
                            }
                        }
                    }
                    newObj.default = obj;
                    if (cache) {
                        cache.set(obj, newObj)
                    }
                    return newObj
                }(__webpack_require__( /*! ../../../../core/utils/icon */ 44899));
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 95479);
                var _object = __webpack_require__( /*! ../../../../core/utils/object */ 48013);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 35922);
                var _array_utils = __webpack_require__( /*! ../../../../data/array_utils */ 60637);
                var _click = __webpack_require__( /*! ../../../../events/click */ 95429);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 55994));
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../../../../events/pointer */ 93786));
                var _index = __webpack_require__( /*! ../../../../events/utils/index */ 39611);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../localization/message */ 28109));
                var _dialog = __webpack_require__( /*! ../../../../ui/dialog */ 15029);
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 15943));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 60082));
                var _const = __webpack_require__( /*! ./const */ 72313);
                var _m_editing_utils = __webpack_require__( /*! ./m_editing_utils */ 89237);

                function _getRequireWildcardCache(nodeInterop) {
                    if ("function" !== typeof WeakMap) {
                        return null
                    }
                    var cacheBabelInterop = new WeakMap;
                    var cacheNodeInterop = new WeakMap;
                    return (_getRequireWildcardCache = function(nodeInterop) {
                        return nodeInterop ? cacheNodeInterop : cacheBabelInterop
                    })(nodeInterop)
                }

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var EditingControllerImpl = function(_modules$ViewControll) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(EditingControllerImpl, _modules$ViewControll);

                    function EditingControllerImpl() {
                        return _modules$ViewControll.apply(this, arguments) || this
                    }
                    var _proto = EditingControllerImpl.prototype;
                    _proto.init = function() {
                        this._columnsController = this.getController("columns");
                        this._dataController = this.getController("data");
                        this._rowsView = this.getView("rowsView");
                        this._lastOperation = null;
                        this._changes = [];
                        if (this._deferreds) {
                            this._deferreds.forEach((function(d) {
                                d.reject("cancel")
                            }))
                        }
                        this._deferreds = [];
                        if (!this._dataChangedHandler) {
                            this._dataChangedHandler = this._handleDataChanged.bind(this);
                            this._dataController.changed.add(this._dataChangedHandler)
                        }
                        if (!this._saveEditorHandler) {
                            this.createAction("onInitNewRow", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onRowInserting", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onRowInserted", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onEditingStart", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onRowUpdating", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onRowUpdated", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onRowRemoving", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onRowRemoved", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onSaved", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onSaving", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onEditCanceling", {
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            this.createAction("onEditCanceled", {
                                excludeValidators: ["disabled", "readOnly"]
                            })
                        }
                        this._updateEditColumn();
                        this._updateEditButtons();
                        if (!this._internalState) {
                            this._internalState = []
                        }
                        this.component._optionsByReference[_const.EDITING_EDITROWKEY_OPTION_NAME] = true;
                        this.component._optionsByReference[_const.EDITING_CHANGES_OPTION_NAME] = true
                    };
                    _proto.getEditMode = function() {
                        var editMode = this.option("editing.mode");
                        if (_const.EDIT_MODES.includes(editMode)) {
                            return editMode
                        }
                        return _const.EDIT_MODE_ROW
                    };
                    _proto._getDefaultEditorTemplate = function() {
                        var _this = this;
                        return function(container, options) {
                            var $editor = (0, _renderer.default)("<div>").appendTo(container);
                            var editorOptions = (0, _extend.extend)({}, options.column, {
                                value: options.value,
                                setValue: options.setValue,
                                row: options.row,
                                parentType: "dataRow",
                                width: null,
                                readOnly: !options.setValue,
                                isOnForm: options.isOnForm,
                                id: options.id
                            });
                            var needLabel = _const.REQUIRED_EDITOR_LABELLEDBY_MODES.includes(_this.getEditMode());
                            if (needLabel) {
                                editorOptions["aria-labelledby"] = options.column.headerId
                            }
                            _this.getController("editorFactory").createEditor($editor, editorOptions)
                        }
                    };
                    _proto._getNewRowPosition = function() {
                        var newRowPosition = this.option("editing.newRowPosition");
                        var scrollingMode = this.option("scrolling.mode");
                        if ("virtual" === scrollingMode) {
                            switch (newRowPosition) {
                                case _const.PAGE_TOP_NEW_ROW_POSITION:
                                    return _const.VIEWPORT_TOP_NEW_ROW_POSITION;
                                case _const.PAGE_BOTTOM_NEW_ROW_POSITION:
                                    return _const.VIEWPORT_BOTTOM_NEW_ROW_POSITION;
                                default:
                                    return newRowPosition
                            }
                        }
                        return newRowPosition
                    };
                    _proto.getChanges = function() {
                        return this.option(_const.EDITING_CHANGES_OPTION_NAME)
                    };
                    _proto.getInsertRowCount = function() {
                        var changes = this.option(_const.EDITING_CHANGES_OPTION_NAME);
                        return changes.filter((function(change) {
                            return "insert" === change.type
                        })).length
                    };
                    _proto.resetChanges = function() {
                        var changes = this.getChanges();
                        var needReset = null === changes || void 0 === changes ? void 0 : changes.length;
                        if (needReset) {
                            this._silentOption(_const.EDITING_CHANGES_OPTION_NAME, [])
                        }
                    };
                    _proto._getInternalData = function(key) {
                        return this._internalState.filter((function(item) {
                            return (0, _common.equalByValue)(item.key, key)
                        }))[0]
                    };
                    _proto._addInternalData = function(params) {
                        var internalData = this._getInternalData(params.key);
                        if (internalData) {
                            return (0, _extend.extend)(internalData, params)
                        }
                        this._internalState.push(params);
                        return params
                    };
                    _proto._getOldData = function(key) {
                        var _a;
                        return null === (_a = this._getInternalData(key)) || void 0 === _a ? void 0 : _a.oldData
                    };
                    _proto.getUpdatedData = function(data) {
                        var key = this._dataController.keyOf(data);
                        var changes = this.getChanges();
                        var editIndex = _m_utils.default.getIndexByKey(key, changes);
                        if (changes[editIndex]) {
                            return (0, _array_utils.createObjectWithChanges)(data, changes[editIndex].data)
                        }
                        return data
                    };
                    _proto.getInsertedData = function() {
                        return this.getChanges().filter((function(change) {
                            return change.data && change.type === _const.DATA_EDIT_DATA_INSERT_TYPE
                        })).map((function(change) {
                            return change.data
                        }))
                    };
                    _proto.getRemovedData = function() {
                        var _this2 = this;
                        return this.getChanges().filter((function(change) {
                            return _this2._getOldData(change.key) && change.type === _const.DATA_EDIT_DATA_REMOVE_TYPE
                        })).map((function(change) {
                            return _this2._getOldData(change.key)
                        }))
                    };
                    _proto._fireDataErrorOccurred = function(arg) {
                        if ("cancel" === arg) {
                            return
                        }
                        var $popupContent = this.getPopupContent();
                        this._dataController.dataErrorOccurred.fire(arg, $popupContent)
                    };
                    _proto._needToCloseEditableCell = function($targetElement) {};
                    _proto._closeEditItem = function($targetElement) {};
                    _proto._handleDataChanged = function(args) {};
                    _proto._isDefaultButtonVisible = function(button, options) {
                        var result = true;
                        switch (button.name) {
                            case "delete":
                                result = this.allowDeleting(options);
                                break;
                            case "undelete":
                                result = false
                        }
                        return result
                    };
                    _proto._isButtonVisible = function(button, options) {
                        var visible = button.visible;
                        if (!(0, _type.isDefined)(visible)) {
                            return this._isDefaultButtonVisible(button, options)
                        }
                        return (0, _type.isFunction)(visible) ? visible.call(button, {
                            component: options.component,
                            row: options.row,
                            column: options.column
                        }) : visible
                    };
                    _proto._isButtonDisabled = function(button, options) {
                        var disabled = button.disabled;
                        return (0, _type.isFunction)(disabled) ? disabled.call(button, {
                            component: options.component,
                            row: options.row,
                            column: options.column
                        }) : !!disabled
                    };
                    _proto._getButtonConfig = function(button, options) {
                        var _this3 = this;
                        var config = (0, _type.isObject)(button) ? button : {};
                        var buttonName = (0, _m_editing_utils.getButtonName)(button);
                        var editingTexts = (0, _m_editing_utils.getEditingTexts)(options);
                        var methodName = _const.METHOD_NAMES[buttonName];
                        var editingOptions = this.option("editing");
                        var actionName = _const.ACTION_OPTION_NAMES[buttonName];
                        var allowAction = actionName ? editingOptions[actionName] : true;
                        return (0, _extend.extend)({
                            name: buttonName,
                            text: editingTexts[buttonName],
                            cssClass: _const.EDIT_LINK_CLASS[buttonName]
                        }, {
                            onClick: methodName && function(e) {
                                var event = e.event;
                                event.stopPropagation();
                                event.preventDefault();
                                setTimeout((function() {
                                    options.row && allowAction && _this3[methodName] && _this3[methodName](options.row.rowIndex)
                                }))
                            }
                        }, config)
                    };
                    _proto._getEditingButtons = function(options) {
                        var _this4 = this;
                        var buttonIndex;
                        var haveCustomButtons = !!options.column.buttons;
                        var buttons = (options.column.buttons || []).slice();
                        if (haveCustomButtons) {
                            buttonIndex = (0, _m_editing_utils.getButtonIndex)(buttons, "edit");
                            if (buttonIndex >= 0) {
                                if ((0, _m_editing_utils.getButtonIndex)(buttons, "save") < 0) {
                                    buttons.splice(buttonIndex + 1, 0, "save")
                                }
                                if ((0, _m_editing_utils.getButtonIndex)(buttons, "cancel") < 0) {
                                    buttons.splice((0, _m_editing_utils.getButtonIndex)(buttons, "save") + 1, 0, "cancel")
                                }
                            }
                            buttonIndex = (0, _m_editing_utils.getButtonIndex)(buttons, "delete");
                            if (buttonIndex >= 0 && (0, _m_editing_utils.getButtonIndex)(buttons, "undelete") < 0) {
                                buttons.splice(buttonIndex + 1, 0, "undelete")
                            }
                        } else {
                            buttons = _const.BUTTON_NAMES.slice()
                        }
                        return buttons.map((function(button) {
                            return _this4._getButtonConfig(button, options)
                        }))
                    };
                    _proto._renderEditingButtons = function($container, buttons, options, change) {
                        var _this5 = this;
                        buttons.forEach((function(button) {
                            if (_this5._isButtonVisible(button, options)) {
                                _this5._createButton($container, button, options, change)
                            }
                        }))
                    };
                    _proto._getEditCommandCellTemplate = function() {
                        var _this6 = this;
                        return function(container, options, change) {
                            var $container = (0, _renderer.default)(container);
                            if ("data" === options.rowType) {
                                var buttons = _this6._getEditingButtons(options);
                                _this6._renderEditingButtons($container, buttons, options, change);
                                options.watch && options.watch((function() {
                                    return buttons.map((function(button) {
                                        return {
                                            visible: _this6._isButtonVisible(button, options),
                                            disabled: _this6._isButtonDisabled(button, options)
                                        }
                                    }))
                                }), (function() {
                                    $container.empty();
                                    _this6._renderEditingButtons($container, buttons, options)
                                }))
                            } else {
                                _m_utils.default.setEmptyText($container)
                            }
                        }
                    };
                    _proto.isRowBasedEditMode = function() {
                        var editMode = this.getEditMode();
                        return _const.ROW_BASED_MODES.includes(editMode)
                    };
                    _proto.getFirstEditableColumnIndex = function() {
                        var columnsController = this.getController("columns");
                        var columnIndex;
                        var visibleColumns = columnsController.getVisibleColumns();
                        (0, _iterator.each)(visibleColumns, (function(index, column) {
                            if (column.allowEditing) {
                                columnIndex = index;
                                return false
                            }
                        }));
                        return columnIndex
                    };
                    _proto.getFirstEditableCellInRow = function(rowIndex) {
                        var rowsView = this.getView("rowsView");
                        var columnIndex = this.getFirstEditableColumnIndex();
                        return null === rowsView || void 0 === rowsView ? void 0 : rowsView._getCellElement(rowIndex || 0, columnIndex)
                    };
                    _proto.getFocusedCellInRow = function(rowIndex) {
                        return this.getFirstEditableCellInRow(rowIndex)
                    };
                    _proto.getIndexByKey = function(key, items) {
                        return _m_utils.default.getIndexByKey(key, items)
                    };
                    _proto.hasChanges = function(rowIndex) {
                        var changes = this.getChanges();
                        var result = false;
                        for (var i = 0; i < (null === changes || void 0 === changes ? void 0 : changes.length); i++) {
                            if (changes[i].type && (!(0, _type.isDefined)(rowIndex) || this._dataController.getRowIndexByKey(changes[i].key) === rowIndex)) {
                                result = true;
                                break
                            }
                        }
                        return result
                    };
                    _proto.dispose = function() {
                        _modules$ViewControll.prototype.dispose.call(this);
                        clearTimeout(this._inputFocusTimeoutID);
                        _events_engine.default.off(_dom_adapter.default.getDocument(), _pointer.default.up, this._pointerUpEditorHandler);
                        _events_engine.default.off(_dom_adapter.default.getDocument(), _pointer.default.down, this._pointerDownEditorHandler);
                        _events_engine.default.off(_dom_adapter.default.getDocument(), _click.name, this._saveEditorHandler)
                    };
                    _proto._silentOption = function(name, value) {
                        if ("editing.changes" === name) {
                            this._changes = (0, _object.deepExtendArraySafe)([], value)
                        }
                        _modules$ViewControll.prototype._silentOption.call(this, name, value)
                    };
                    _proto.optionChanged = function(args) {
                        if ("editing" === args.name) {
                            var fullName = args.fullName;
                            if (fullName === _const.EDITING_EDITROWKEY_OPTION_NAME) {
                                this._handleEditRowKeyChange(args)
                            } else if (fullName === _const.EDITING_CHANGES_OPTION_NAME) {
                                var isEqual = (0, _common.equalByValue)(args.value, this._changes, {
                                    maxDepth: 4
                                });
                                if (!isEqual) {
                                    this._changes = (0, _object.deepExtendArraySafe)([], args.value);
                                    this._handleChangesChange(args)
                                }
                            } else if (!args.handled) {
                                this._columnsController.reinit();
                                this.init();
                                this.resetChanges();
                                this._resetEditColumnName();
                                this._resetEditRowKey()
                            }
                            args.handled = true
                        } else {
                            _modules$ViewControll.prototype.optionChanged.call(this, args)
                        }
                    };
                    _proto._handleEditRowKeyChange = function(args) {
                        var rowIndex = this._dataController.getRowIndexByKey(args.value);
                        var oldRowIndexCorrection = this._getEditRowIndexCorrection();
                        var oldRowIndex = this._dataController.getRowIndexByKey(args.previousValue) + oldRowIndexCorrection;
                        if ((0, _type.isDefined)(args.value)) {
                            if (args.value !== args.previousValue) {
                                this._editRowFromOptionChanged(rowIndex, oldRowIndex)
                            }
                        } else {
                            this.cancelEditData()
                        }
                    };
                    _proto._handleChangesChange = function(args) {
                        var _this7 = this;
                        var dataController = this._dataController;
                        var changes = args.value;
                        if (!args.value.length && !args.previousValue.length) {
                            return
                        }
                        changes.forEach((function(change) {
                            var _a;
                            if ("insert" === change.type) {
                                _this7._addInsertInfo(change)
                            } else {
                                var items = dataController.getCachedStoreData() || (null === (_a = dataController.items()) || void 0 === _a ? void 0 : _a.map((function(item) {
                                    return item.data
                                })));
                                var rowIndex = _m_utils.default.getIndexByKey(change.key, items, dataController.key());
                                _this7._addInternalData({
                                    key: change.key,
                                    oldData: items[rowIndex]
                                })
                            }
                        }));
                        dataController.updateItems({
                            repaintChangesOnly: true,
                            isLiveUpdate: false,
                            isOptionChanged: true
                        })
                    };
                    _proto.publicMethods = function() {
                        return ["addRow", "deleteRow", "undeleteRow", "editRow", "saveEditData", "cancelEditData", "hasEditData"]
                    };
                    _proto.refresh = function() {
                        if (!(0, _type.isDefined)(this._pageIndex)) {
                            return
                        }
                        this._refreshCore.apply(this, arguments)
                    };
                    _proto._refreshCore = function(params) {};
                    _proto.isEditing = function() {
                        var isEditRowKeyDefined = (0, _type.isDefined)(this.option(_const.EDITING_EDITROWKEY_OPTION_NAME));
                        return isEditRowKeyDefined
                    };
                    _proto.isEditRow = function(rowIndex) {
                        return false
                    };
                    _proto._setEditRowKey = function(value, silent) {
                        if (silent) {
                            this._silentOption(_const.EDITING_EDITROWKEY_OPTION_NAME, value)
                        } else {
                            this.option(_const.EDITING_EDITROWKEY_OPTION_NAME, value)
                        }
                        if (this._refocusEditCell) {
                            this._refocusEditCell = false;
                            this._focusEditingCell()
                        }
                    };
                    _proto._setEditRowKeyByIndex = function(rowIndex, silent) {
                        var key = this._dataController.getKeyByRowIndex(rowIndex);
                        if (void 0 === key) {
                            this._dataController.fireError("E1043");
                            return
                        }
                        this._setEditRowKey(key, silent)
                    };
                    _proto.getEditRowIndex = function() {
                        return this._getVisibleEditRowIndex()
                    };
                    _proto.getEditFormRowIndex = function() {
                        return -1
                    };
                    _proto.isEditRowByIndex = function(rowIndex) {
                        var key = this._dataController.getKeyByRowIndex(rowIndex);
                        var isKeyEqual = (0, _type.isDefined)(key) && (0, _common.equalByValue)(this.option(_const.EDITING_EDITROWKEY_OPTION_NAME), key);
                        if (isKeyEqual) {
                            return this._getVisibleEditRowIndex() === rowIndex
                        }
                        return isKeyEqual
                    };
                    _proto.isEditCell = function(visibleRowIndex, columnIndex) {
                        return this.isEditRowByIndex(visibleRowIndex) && this._getVisibleEditColumnIndex() === columnIndex
                    };
                    _proto.getPopupContent = function() {};
                    _proto._isProcessedItem = function(item) {
                        return false
                    };
                    _proto._getInsertRowIndex = function(items, change, isProcessedItems) {
                        var _this8 = this;
                        var result = -1;
                        var dataController = this._dataController;
                        var key = this._getInsertAfterOrBeforeKey(change);
                        if (!(0, _type.isDefined)(key) && 0 === items.length) {
                            result = 0
                        } else if ((0, _type.isDefined)(key)) {
                            items.some((function(item, index) {
                                var isProcessedItem = isProcessedItems || _this8._isProcessedItem(item);
                                if ((0, _type.isObject)(item)) {
                                    if (isProcessedItem || (0, _type.isDefined)(item[_const.INSERT_INDEX])) {
                                        if ((0, _common.equalByValue)(item.key, key)) {
                                            result = index
                                        }
                                    } else if ((0, _common.equalByValue)(dataController.keyOf(item), key)) {
                                        result = index
                                    }
                                }
                                if (result >= 0) {
                                    var nextItem = items[result + 1];
                                    if (nextItem && ("detail" === nextItem.rowType || "detailAdaptive" === nextItem.rowType) && (0, _type.isDefined)(change.insertAfterKey)) {
                                        return
                                    }
                                    if ((0, _type.isDefined)(change.insertAfterKey)) {
                                        result += 1
                                    }
                                    return true
                                }
                            }))
                        }
                        return result
                    };
                    _proto._generateNewItem = function(key) {
                        var _a;
                        var item = {
                            key: key
                        };
                        var insertInfo = null === (_a = this._getInternalData(key)) || void 0 === _a ? void 0 : _a.insertInfo;
                        if (null === insertInfo || void 0 === insertInfo ? void 0 : insertInfo[_const.INSERT_INDEX]) {
                            item[_const.INSERT_INDEX] = insertInfo[_const.INSERT_INDEX]
                        }
                        return item
                    };
                    _proto._getLoadedRowIndex = function(items, change, isProcessedItems) {
                        var loadedRowIndex = this._getInsertRowIndex(items, change, isProcessedItems);
                        var dataController = this._dataController;
                        if (loadedRowIndex < 0) {
                            var newRowPosition = this._getNewRowPosition();
                            var pageIndex = dataController.pageIndex();
                            var insertAfterOrBeforeKey = this._getInsertAfterOrBeforeKey(change);
                            if (newRowPosition !== _const.LAST_NEW_ROW_POSITION && 0 === pageIndex && !(0, _type.isDefined)(insertAfterOrBeforeKey)) {
                                loadedRowIndex = 0
                            } else if (newRowPosition === _const.LAST_NEW_ROW_POSITION && dataController.isLastPageLoaded()) {
                                loadedRowIndex = items.length
                            }
                        }
                        return loadedRowIndex
                    };
                    _proto.processItems = function(items, e) {
                        var _this9 = this;
                        var changeType = e.changeType;
                        this.update(changeType);
                        var changes = this.getChanges();
                        changes.forEach((function(change) {
                            var _a;
                            var isInsert = change.type === _const.DATA_EDIT_DATA_INSERT_TYPE;
                            if (!isInsert) {
                                return
                            }
                            var key = change.key;
                            var insertInfo = null === (_a = _this9._getInternalData(key)) || void 0 === _a ? void 0 : _a.insertInfo;
                            if (!(0, _type.isDefined)(key) || !(0, _type.isDefined)(insertInfo)) {
                                insertInfo = _this9._addInsertInfo(change);
                                key = insertInfo.key
                            }
                            var loadedRowIndex = _this9._getLoadedRowIndex(items, change);
                            var item = _this9._generateNewItem(key);
                            if (loadedRowIndex >= 0) {
                                items.splice(loadedRowIndex, 0, item)
                            }
                        }));
                        return items
                    };
                    _proto.processDataItem = function(item, options, generateDataValues) {
                        var columns = options.visibleColumns;
                        var key = item.data[_const.INSERT_INDEX] ? item.data.key : item.key;
                        var changes = this.getChanges();
                        var editIndex = _m_utils.default.getIndexByKey(key, changes);
                        item.isEditing = false;
                        if (editIndex >= 0) {
                            this._processDataItemCore(item, changes[editIndex], key, columns, generateDataValues)
                        }
                    };
                    _proto._processDataItemCore = function(item, change, key, columns, generateDataValues) {
                        var data = change.data,
                            type = change.type;
                        switch (type) {
                            case _const.DATA_EDIT_DATA_INSERT_TYPE:
                                item.isNewRow = true;
                                item.key = key;
                                item.data = data;
                                break;
                            case _const.DATA_EDIT_DATA_UPDATE_TYPE:
                                item.modified = true;
                                item.oldData = item.data;
                                item.data = (0, _array_utils.createObjectWithChanges)(item.data, data);
                                item.modifiedValues = generateDataValues(data, columns, true);
                                break;
                            case _const.DATA_EDIT_DATA_REMOVE_TYPE:
                                item.removed = true
                        }
                    };
                    _proto._initNewRow = function(options) {
                        var _this10 = this;
                        this.executeAction("onInitNewRow", options);
                        if (options.promise) {
                            var deferred = new _deferred.Deferred;
                            (0, _deferred.when)((0, _deferred.fromPromise)(options.promise)).done(deferred.resolve).fail((0, _m_editing_utils.createFailureHandler)(deferred)).fail((function(arg) {
                                return _this10._fireDataErrorOccurred(arg)
                            }));
                            return deferred
                        }
                    };
                    _proto._createInsertInfo = function() {
                        var insertInfo = {};
                        insertInfo[_const.INSERT_INDEX] = this._getInsertIndex();
                        return insertInfo
                    };
                    _proto._addInsertInfo = function(change, parentKey) {
                        var _a;
                        var insertInfo;
                        change.key = this.getChangeKeyValue(change);
                        var key = change.key;
                        insertInfo = null === (_a = this._getInternalData(key)) || void 0 === _a ? void 0 : _a.insertInfo;
                        if (!(0, _type.isDefined)(insertInfo)) {
                            var insertAfterOrBeforeKey = this._getInsertAfterOrBeforeKey(change);
                            insertInfo = this._createInsertInfo();
                            if (!(0, _type.isDefined)(insertAfterOrBeforeKey)) {
                                this._setInsertAfterOrBeforeKey(change, parentKey)
                            }
                        }
                        this._addInternalData({
                            insertInfo: insertInfo,
                            key: key
                        });
                        return {
                            insertInfo: insertInfo,
                            key: key
                        }
                    };
                    _proto.getChangeKeyValue = function(change) {
                        if ((0, _type.isDefined)(change.key)) {
                            return change.key
                        }
                        var keyExpr = this._dataController.key();
                        var keyValue;
                        if (change.data && keyExpr && !Array.isArray(keyExpr)) {
                            keyValue = change.data[keyExpr]
                        }
                        if (!(0, _type.isDefined)(keyValue)) {
                            keyValue = (0, _m_editing_utils.generateNewRowTempKey)()
                        }
                        return keyValue
                    };
                    _proto._setInsertAfterOrBeforeKey = function(change, parentKey) {
                        var dataController = this._dataController;
                        var allItems = dataController.items(true);
                        var rowsView = this.getView("rowsView");
                        var newRowPosition = this._getNewRowPosition();
                        switch (newRowPosition) {
                            case _const.FIRST_NEW_ROW_POSITION:
                            case _const.LAST_NEW_ROW_POSITION:
                                break;
                            case _const.PAGE_TOP_NEW_ROW_POSITION:
                            case _const.PAGE_BOTTOM_NEW_ROW_POSITION:
                                if (allItems.length) {
                                    var itemIndex = newRowPosition === _const.PAGE_TOP_NEW_ROW_POSITION ? 0 : allItems.length - 1;
                                    change[0 === itemIndex ? "insertBeforeKey" : "insertAfterKey"] = allItems[itemIndex].key
                                }
                                break;
                            default:
                                var isViewportBottom = newRowPosition === _const.VIEWPORT_BOTTOM_NEW_ROW_POSITION;
                                var visibleItemIndex = isViewportBottom ? null === rowsView || void 0 === rowsView ? void 0 : rowsView.getBottomVisibleItemIndex() : null === rowsView || void 0 === rowsView ? void 0 : rowsView.getTopVisibleItemIndex();
                                var row = dataController.getVisibleRows()[visibleItemIndex];
                                if (row && (!row.isEditing && "detail" === row.rowType || "detailAdaptive" === row.rowType)) {
                                    visibleItemIndex++
                                }
                                var insertKey = dataController.getKeyByRowIndex(visibleItemIndex);
                                if ((0, _type.isDefined)(insertKey)) {
                                    change.insertBeforeKey = insertKey
                                }
                        }
                    };
                    _proto._getInsertIndex = function() {
                        var _this11 = this;
                        var maxInsertIndex = 0;
                        this.getChanges().forEach((function(editItem) {
                            var _a;
                            var insertInfo = null === (_a = _this11._getInternalData(editItem.key)) || void 0 === _a ? void 0 : _a.insertInfo;
                            if ((0, _type.isDefined)(insertInfo) && editItem.type === _const.DATA_EDIT_DATA_INSERT_TYPE && insertInfo[_const.INSERT_INDEX] > maxInsertIndex) {
                                maxInsertIndex = insertInfo[_const.INSERT_INDEX]
                            }
                        }));
                        return maxInsertIndex + 1
                    };
                    _proto._getInsertAfterOrBeforeKey = function(insertChange) {
                        var _a;
                        return null !== (_a = insertChange.insertAfterKey) && void 0 !== _a ? _a : insertChange.insertBeforeKey
                    };
                    _proto._getPageIndexToInsertRow = function() {
                        var newRowPosition = this._getNewRowPosition();
                        var dataController = this._dataController;
                        var pageIndex = dataController.pageIndex();
                        var lastPageIndex = dataController.pageCount() - 1;
                        if (newRowPosition === _const.FIRST_NEW_ROW_POSITION && 0 !== pageIndex) {
                            return 0
                        }
                        if (newRowPosition === _const.LAST_NEW_ROW_POSITION && pageIndex !== lastPageIndex) {
                            return lastPageIndex
                        }
                        return -1
                    };
                    _proto.addRow = function(parentKey) {
                        var dataController = this._dataController;
                        var store = dataController.store();
                        if (!store) {
                            dataController.fireError("E1052", this.component.NAME);
                            return (new _deferred.Deferred).reject()
                        }
                        return this._addRow(parentKey)
                    };
                    _proto._addRow = function(parentKey) {
                        var _this12 = this;
                        var dataController = this._dataController;
                        var store = dataController.store();
                        var key = store && store.key();
                        var param = {
                            data: {}
                        };
                        var oldEditRowIndex = this._getVisibleEditRowIndex();
                        var deferred = new _deferred.Deferred;
                        this.refresh({
                            allowCancelEditing: true
                        });
                        if (!this._allowRowAdding()) {
                            (0, _deferred.when)(this._navigateToNewRow(oldEditRowIndex)).done(deferred.resolve).fail(deferred.reject);
                            return deferred.promise()
                        }
                        if (!key) {
                            param.data.__KEY__ = String(new _guid.default)
                        }(0, _deferred.when)(this._initNewRow(param, parentKey)).done((function() {
                            if (_this12._allowRowAdding()) {
                                (0, _deferred.when)(_this12._addRowCore(param.data, parentKey, oldEditRowIndex)).done(deferred.resolve).fail(deferred.reject)
                            } else {
                                deferred.reject("cancel")
                            }
                        })).fail(deferred.reject);
                        return deferred.promise()
                    };
                    _proto._allowRowAdding = function(params) {
                        var insertIndex = this._getInsertIndex();
                        if (insertIndex > 1) {
                            return false
                        }
                        return true
                    };
                    _proto._addRowCore = function(data, parentKey, initialOldEditRowIndex) {
                        var change = {
                            data: data,
                            type: _const.DATA_EDIT_DATA_INSERT_TYPE
                        };
                        var editRowIndex = this._getVisibleEditRowIndex();
                        var insertInfo = this._addInsertInfo(change, parentKey);
                        var key = insertInfo.key;
                        this._setEditRowKey(key, true);
                        this._addChange(change);
                        return this._navigateToNewRow(initialOldEditRowIndex, change, editRowIndex)
                    };
                    _proto._navigateToNewRow = function(oldEditRowIndex, change, editRowIndex) {
                        var _this13 = this;
                        var d = new _deferred.Deferred;
                        var dataController = this._dataController;
                        var focusController = this.getController("focus");
                        editRowIndex = null !== editRowIndex && void 0 !== editRowIndex ? editRowIndex : -1;
                        change = null !== change && void 0 !== change ? change : this.getChanges().filter((function(c) {
                            return c.type === _const.DATA_EDIT_DATA_INSERT_TYPE
                        }))[0];
                        if (!change) {
                            return d.reject("cancel").promise()
                        }
                        var pageIndexToInsertRow = this._getPageIndexToInsertRow();
                        var rowIndex = this._getLoadedRowIndex(dataController.items(), change, true);
                        var navigateToRowByKey = function(key) {
                            (0, _deferred.when)(null === focusController || void 0 === focusController ? void 0 : focusController.navigateToRow(key)).done((function() {
                                rowIndex = dataController.getRowIndexByKey(change.key);
                                d.resolve()
                            }))
                        };
                        var insertAfterOrBeforeKey = this._getInsertAfterOrBeforeKey(change);
                        if (pageIndexToInsertRow >= 0) {
                            dataController.pageIndex(pageIndexToInsertRow).done((function() {
                                navigateToRowByKey(change.key)
                            })).fail(d.reject)
                        } else if (rowIndex < 0 && (0, _type.isDefined)(insertAfterOrBeforeKey)) {
                            navigateToRowByKey(insertAfterOrBeforeKey)
                        } else {
                            dataController.updateItems({
                                changeType: "update",
                                rowIndices: [oldEditRowIndex, editRowIndex, rowIndex]
                            });
                            rowIndex = dataController.getRowIndexByKey(change.key);
                            if (rowIndex < 0) {
                                navigateToRowByKey(change.key)
                            } else {
                                d.resolve()
                            }
                        }
                        d.done((function() {
                            var _a;
                            null === (_a = _this13._rowsView) || void 0 === _a ? void 0 : _a.waitAsyncTemplates(true).done((function() {
                                _this13._showAddedRow(rowIndex);
                                _this13._afterInsertRow(change.key)
                            }))
                        }));
                        return d.promise()
                    };
                    _proto._showAddedRow = function(rowIndex) {
                        this._focusFirstEditableCellInRow(rowIndex)
                    };
                    _proto._beforeFocusElementInRow = function(rowIndex) {};
                    _proto._focusFirstEditableCellInRow = function(rowIndex) {
                        var _this14 = this;
                        var dataController = this._dataController;
                        var keyboardController = this.getController("keyboardNavigation");
                        var key = dataController.getKeyByRowIndex(rowIndex);
                        var $firstCell = this.getFirstEditableCellInRow(rowIndex);
                        null === keyboardController || void 0 === keyboardController ? void 0 : keyboardController.focus($firstCell);
                        this.option("focusedRowKey", key);
                        this._editCellInProgress = true;
                        this._delayedInputFocus($firstCell, (function() {
                            rowIndex = dataController.getRowIndexByKey(key);
                            _this14._editCellInProgress = false;
                            _this14._beforeFocusElementInRow(rowIndex)
                        }))
                    };
                    _proto._isEditingStart = function(options) {
                        this.executeAction("onEditingStart", options);
                        return options.cancel
                    };
                    _proto._beforeUpdateItems = function() {};
                    _proto._getVisibleEditColumnIndex = function() {
                        var editColumnName = this.option(_const.EDITING_EDITCOLUMNNAME_OPTION_NAME);
                        if (!(0, _type.isDefined)(editColumnName)) {
                            return -1
                        }
                        return this._columnsController.getVisibleColumnIndex(editColumnName)
                    };
                    _proto._setEditColumnNameByIndex = function(index, silent) {
                        var _a;
                        var visibleColumns = this._columnsController.getVisibleColumns();
                        this._setEditColumnName(null === (_a = visibleColumns[index]) || void 0 === _a ? void 0 : _a.name, silent)
                    };
                    _proto._setEditColumnName = function(name, silent) {
                        if (silent) {
                            this._silentOption(_const.EDITING_EDITCOLUMNNAME_OPTION_NAME, name)
                        } else {
                            this.option(_const.EDITING_EDITCOLUMNNAME_OPTION_NAME, name)
                        }
                    };
                    _proto._resetEditColumnName = function() {
                        this._setEditColumnName(null, true)
                    };
                    _proto._getEditColumn = function() {
                        var editColumnName = this.option(_const.EDITING_EDITCOLUMNNAME_OPTION_NAME);
                        return this._getColumnByName(editColumnName)
                    };
                    _proto._getColumnByName = function(name) {
                        var visibleColumns = this._columnsController.getVisibleColumns();
                        var editColumn;
                        (0, _type.isDefined)(name) && visibleColumns.some((function(column) {
                            if (column.name === name) {
                                editColumn = column;
                                return true
                            }
                        }));
                        return editColumn
                    };
                    _proto._getVisibleEditRowIndex = function(columnName) {
                        var dataController = this._dataController;
                        var editRowKey = this.option(_const.EDITING_EDITROWKEY_OPTION_NAME);
                        var rowIndex = dataController.getRowIndexByKey(editRowKey);
                        if (-1 === rowIndex) {
                            return rowIndex
                        }
                        return rowIndex + this._getEditRowIndexCorrection(columnName)
                    };
                    _proto._getEditRowIndexCorrection = function(columnName) {
                        var editColumn = columnName ? this._getColumnByName(columnName) : this._getEditColumn();
                        var isColumnHidden = "adaptiveHidden" === (null === editColumn || void 0 === editColumn ? void 0 : editColumn.visibleWidth);
                        return isColumnHidden ? 1 : 0
                    };
                    _proto._resetEditRowKey = function() {
                        this._refocusEditCell = false;
                        this._setEditRowKey(null, true)
                    };
                    _proto._resetEditIndices = function() {
                        this._resetEditColumnName();
                        this._resetEditRowKey()
                    };
                    _proto.editRow = function(rowIndex) {
                        var _a;
                        var dataController = this._dataController;
                        var items = dataController.items();
                        var item = items[rowIndex];
                        var params = {
                            data: item && item.data,
                            cancel: false
                        };
                        var oldRowIndex = this._getVisibleEditRowIndex();
                        if (!item) {
                            return
                        }
                        if (rowIndex === oldRowIndex) {
                            return true
                        }
                        if (void 0 === item.key) {
                            this._dataController.fireError("E1043");
                            return
                        }
                        if (!item.isNewRow) {
                            params.key = item.key
                        }
                        if (this._isEditingStart(params)) {
                            return
                        }
                        this.resetChanges();
                        this.init();
                        this._resetEditColumnName();
                        this._pageIndex = dataController.pageIndex();
                        this._addInternalData({
                            key: item.key,
                            oldData: null !== (_a = item.oldData) && void 0 !== _a ? _a : item.data
                        });
                        this._setEditRowKey(item.key)
                    };
                    _proto._editRowFromOptionChanged = function(rowIndex, oldRowIndex) {
                        var rowIndices = [oldRowIndex, rowIndex];
                        this._beforeUpdateItems(rowIndices, rowIndex, oldRowIndex);
                        this._editRowFromOptionChangedCore(rowIndices, rowIndex)
                    };
                    _proto._editRowFromOptionChangedCore = function(rowIndices, rowIndex, preventRendering) {
                        this._needFocusEditor = true;
                        this._dataController.updateItems({
                            changeType: "update",
                            rowIndices: rowIndices,
                            cancel: preventRendering
                        })
                    };
                    _proto._focusEditorIfNeed = function() {};
                    _proto._showEditPopup = function(rowIndex, repaintForm) {};
                    _proto._repaintEditPopup = function() {};
                    _proto._getEditPopupHiddenHandler = function() {
                        var _this15 = this;
                        return function(e) {
                            if (_this15.isEditing()) {
                                _this15.cancelEditData()
                            }
                        }
                    };
                    _proto._getPopupEditFormTemplate = function(rowIndex) {};
                    _proto._getSaveButtonConfig = function() {
                        return {
                            text: this.option("editing.texts.saveRowChanges"),
                            onClick: this.saveEditData.bind(this)
                        }
                    };
                    _proto._getCancelButtonConfig = function() {
                        return {
                            text: this.option("editing.texts.cancelRowChanges"),
                            onClick: this.cancelEditData.bind(this)
                        }
                    };
                    _proto._removeInternalData = function(key) {
                        var internalData = this._getInternalData(key);
                        var index = this._internalState.indexOf(internalData);
                        if (index > -1) {
                            this._internalState.splice(index, 1)
                        }
                    };
                    _proto._updateInsertAfterOrBeforeKeys = function(changes, index) {
                        var _this16 = this;
                        var removeChange = changes[index];
                        changes.forEach((function(change) {
                            var insertAfterOrBeforeKey = _this16._getInsertAfterOrBeforeKey(change);
                            if ((0, _common.equalByValue)(insertAfterOrBeforeKey, removeChange.key)) {
                                change[(0, _type.isDefined)(change.insertAfterKey) ? "insertAfterKey" : "insertBeforeKey"] = _this16._getInsertAfterOrBeforeKey(removeChange)
                            }
                        }))
                    };
                    _proto._removeChange = function(index) {
                        if (index >= 0) {
                            var changes = _toConsumableArray(this.getChanges());
                            var key = changes[index].key;
                            this._removeInternalData(key);
                            this._updateInsertAfterOrBeforeKeys(changes, index);
                            changes.splice(index, 1);
                            this._silentOption(_const.EDITING_CHANGES_OPTION_NAME, changes);
                            if ((0, _common.equalByValue)(this.option(_const.EDITING_EDITROWKEY_OPTION_NAME), key)) {
                                this._resetEditIndices()
                            }
                        }
                    };
                    _proto.executeOperation = function(deferred, func) {
                        var _this17 = this;
                        this._lastOperation && this._lastOperation.reject();
                        this._lastOperation = deferred;
                        this.waitForDeferredOperations().done((function() {
                            if ("rejected" === deferred.state()) {
                                return
                            }
                            func();
                            _this17._lastOperation = null
                        })).fail((function() {
                            deferred.reject();
                            _this17._lastOperation = null
                        }))
                    };
                    _proto.waitForDeferredOperations = function() {
                        return _deferred.when.apply(void 0, _toConsumableArray(this._deferreds))
                    };
                    _proto._processCanceledEditingCell = function() {};
                    _proto._repaintEditCell = function(column, oldColumn, oldEditRowIndex) {
                        this._needFocusEditor = true;
                        if (!column || !column.showEditorAlways || oldColumn && !oldColumn.showEditorAlways) {
                            this._editCellInProgress = true;
                            this.getController("editorFactory").loseFocus();
                            this._dataController.updateItems({
                                changeType: "update",
                                rowIndices: [oldEditRowIndex, this._getVisibleEditRowIndex()]
                            })
                        } else if (column !== oldColumn) {
                            this._dataController.updateItems({
                                changeType: "update",
                                rowIndices: []
                            })
                        }
                    };
                    _proto._delayedInputFocus = function($cell, beforeFocusCallback, callBeforeFocusCallbackAlways) {
                        var _this18 = this;
                        var inputFocus = function() {
                            if (beforeFocusCallback) {
                                beforeFocusCallback()
                            }
                            if ($cell) {
                                var $focusableElement = $cell.find(_const.FOCUSABLE_ELEMENT_SELECTOR).first();
                                _m_utils.default.focusAndSelectElement(_this18, $focusableElement)
                            }
                            _this18._beforeFocusCallback = null
                        };
                        if (_devices.default.real().ios || _devices.default.real().android) {
                            inputFocus()
                        } else {
                            if (this._beforeFocusCallback) {
                                this._beforeFocusCallback()
                            }
                            clearTimeout(this._inputFocusTimeoutID);
                            if (callBeforeFocusCallbackAlways) {
                                this._beforeFocusCallback = beforeFocusCallback
                            }
                            this._inputFocusTimeoutID = setTimeout(inputFocus)
                        }
                    };
                    _proto._focusEditingCell = function(beforeFocusCallback, $editCell, callBeforeFocusCallbackAlways) {
                        var rowsView = this.getView("rowsView");
                        var editColumnIndex = this._getVisibleEditColumnIndex();
                        $editCell = $editCell || rowsView && rowsView._getCellElement(this._getVisibleEditRowIndex(), editColumnIndex);
                        if ($editCell) {
                            this._delayedInputFocus($editCell, beforeFocusCallback, callBeforeFocusCallbackAlways)
                        }
                    };
                    _proto.deleteRow = function(rowIndex) {
                        this._checkAndDeleteRow(rowIndex)
                    };
                    _proto._checkAndDeleteRow = function(rowIndex) {
                        var _this19 = this;
                        var editingOptions = this.option("editing");
                        var editingTexts = null === editingOptions || void 0 === editingOptions ? void 0 : editingOptions.texts;
                        var confirmDelete = null === editingOptions || void 0 === editingOptions ? void 0 : editingOptions.confirmDelete;
                        var confirmDeleteMessage = null === editingTexts || void 0 === editingTexts ? void 0 : editingTexts.confirmDeleteMessage;
                        var item = this._dataController.items()[rowIndex];
                        var allowDeleting = !this.isEditing() || item.isNewRow;
                        if (item && allowDeleting) {
                            if (!confirmDelete || !confirmDeleteMessage) {
                                this._deleteRowCore(rowIndex)
                            } else {
                                var confirmDeleteTitle = editingTexts && editingTexts.confirmDeleteTitle;
                                var showDialogTitle = (0, _type.isDefined)(confirmDeleteTitle) && confirmDeleteTitle.length > 0;
                                (0, _dialog.confirm)(confirmDeleteMessage, confirmDeleteTitle, showDialogTitle).done((function(confirmResult) {
                                    if (confirmResult) {
                                        _this19._deleteRowCore(rowIndex)
                                    }
                                }))
                            }
                        }
                    };
                    _proto._deleteRowCore = function(rowIndex) {
                        var dataController = this._dataController;
                        var item = dataController.items()[rowIndex];
                        var key = item && item.key;
                        var oldEditRowIndex = this._getVisibleEditRowIndex();
                        this.refresh();
                        var changes = this.getChanges();
                        var editIndex = _m_utils.default.getIndexByKey(key, changes);
                        if (editIndex >= 0) {
                            if (changes[editIndex].type === _const.DATA_EDIT_DATA_INSERT_TYPE) {
                                this._removeChange(editIndex)
                            } else {
                                this._addChange({
                                    key: key,
                                    type: _const.DATA_EDIT_DATA_REMOVE_TYPE
                                })
                            }
                        } else {
                            this._addChange({
                                key: key,
                                oldData: item.data,
                                type: _const.DATA_EDIT_DATA_REMOVE_TYPE
                            })
                        }
                        return this._afterDeleteRow(rowIndex, oldEditRowIndex)
                    };
                    _proto._afterDeleteRow = function(rowIndex, oldEditRowIndex) {
                        return this.saveEditData()
                    };
                    _proto.undeleteRow = function(rowIndex) {
                        var dataController = this._dataController;
                        var item = dataController.items()[rowIndex];
                        var oldEditRowIndex = this._getVisibleEditRowIndex();
                        var key = item && item.key;
                        var changes = this.getChanges();
                        if (item) {
                            var editIndex = _m_utils.default.getIndexByKey(key, changes);
                            if (editIndex >= 0) {
                                var data = changes[editIndex].data;
                                if ((0, _type.isEmptyObject)(data)) {
                                    this._removeChange(editIndex)
                                } else {
                                    this._addChange({
                                        key: key,
                                        type: _const.DATA_EDIT_DATA_UPDATE_TYPE
                                    })
                                }
                                dataController.updateItems({
                                    changeType: "update",
                                    rowIndices: [oldEditRowIndex, rowIndex]
                                })
                            }
                        }
                    };
                    _proto._fireOnSaving = function() {
                        var _this20 = this;
                        var onSavingParams = {
                            cancel: false,
                            promise: null,
                            changes: _toConsumableArray(this.getChanges())
                        };
                        this.executeAction("onSaving", onSavingParams);
                        var d = new _deferred.Deferred;
                        (0, _deferred.when)((0, _deferred.fromPromise)(onSavingParams.promise)).done((function() {
                            d.resolve(onSavingParams)
                        })).fail((function(arg) {
                            (0, _m_editing_utils.createFailureHandler)(d);
                            _this20._fireDataErrorOccurred(arg);
                            d.resolve({
                                cancel: true
                            })
                        }));
                        return d
                    };
                    _proto._executeEditingAction = function(actionName, params, func) {
                        if (this.component._disposed) {
                            return null
                        }
                        var deferred = new _deferred.Deferred;
                        this.executeAction(actionName, params);
                        (0, _deferred.when)((0, _deferred.fromPromise)(params.cancel)).done((function(cancel) {
                            if (cancel) {
                                setTimeout((function() {
                                    deferred.resolve("cancel")
                                }))
                            } else {
                                func(params).done(deferred.resolve).fail((0, _m_editing_utils.createFailureHandler)(deferred))
                            }
                        })).fail((0, _m_editing_utils.createFailureHandler)(deferred));
                        return deferred
                    };
                    _proto._processChanges = function(deferreds, results, dataChanges, changes) {
                        var _this21 = this;
                        var store = this._dataController.store();
                        (0, _iterator.each)(changes, (function(index, change) {
                            var oldData = _this21._getOldData(change.key);
                            var data = change.data,
                                type = change.type;
                            var changeCopy = _extends({}, change);
                            var deferred;
                            var params;
                            if (_this21._beforeSaveEditData(change, index)) {
                                return
                            }
                            switch (type) {
                                case _const.DATA_EDIT_DATA_REMOVE_TYPE:
                                    params = {
                                        data: oldData,
                                        key: change.key,
                                        cancel: false
                                    };
                                    deferred = _this21._executeEditingAction("onRowRemoving", params, (function() {
                                        return store.remove(change.key).done((function(key) {
                                            dataChanges.push({
                                                type: "remove",
                                                key: key
                                            })
                                        }))
                                    }));
                                    break;
                                case _const.DATA_EDIT_DATA_INSERT_TYPE:
                                    params = {
                                        data: data,
                                        cancel: false
                                    };
                                    deferred = _this21._executeEditingAction("onRowInserting", params, (function() {
                                        return store.insert(params.data).done((function(data, key) {
                                            if ((0, _type.isDefined)(key)) {
                                                changeCopy.key = key
                                            }
                                            if (data && (0, _type.isObject)(data) && data !== params.data) {
                                                changeCopy.data = data
                                            }
                                            dataChanges.push({
                                                type: "insert",
                                                data: data,
                                                index: 0
                                            })
                                        }))
                                    }));
                                    break;
                                case _const.DATA_EDIT_DATA_UPDATE_TYPE:
                                    params = {
                                        newData: data,
                                        oldData: oldData,
                                        key: change.key,
                                        cancel: false
                                    };
                                    deferred = _this21._executeEditingAction("onRowUpdating", params, (function() {
                                        return store.update(change.key, params.newData).done((function(data, key) {
                                            if (data && (0, _type.isObject)(data) && data !== params.newData) {
                                                changeCopy.data = data
                                            }
                                            dataChanges.push({
                                                type: "update",
                                                key: key,
                                                data: data
                                            })
                                        }))
                                    }))
                            }
                            changes[index] = changeCopy;
                            if (deferred) {
                                var doneDeferred = new _deferred.Deferred;
                                deferred.always((function(data) {
                                    results.push({
                                        key: change.key,
                                        result: data
                                    })
                                })).always(doneDeferred.resolve);
                                deferreds.push(doneDeferred.promise())
                            }
                        }))
                    };
                    _proto._processRemoveIfError = function(changes, editIndex) {
                        var change = changes[editIndex];
                        if ((null === change || void 0 === change ? void 0 : change.type) === _const.DATA_EDIT_DATA_REMOVE_TYPE) {
                            if (editIndex >= 0) {
                                changes.splice(editIndex, 1)
                            }
                        }
                        return true
                    };
                    _proto._processRemove = function(changes, editIndex, cancel) {
                        var change = changes[editIndex];
                        if (!cancel || !change || change.type === _const.DATA_EDIT_DATA_REMOVE_TYPE) {
                            return this._processRemoveCore(changes, editIndex, !cancel || !change)
                        }
                    };
                    _proto._processRemoveCore = function(changes, editIndex, processIfBatch) {
                        if (editIndex >= 0) {
                            changes.splice(editIndex, 1)
                        }
                        return true
                    };
                    _proto._processSaveEditDataResult = function(results) {
                        var hasSavedData = false;
                        var changes = _toConsumableArray(this.getChanges());
                        var changesLength = changes.length;
                        for (var i = 0; i < results.length; i++) {
                            var arg = results[i].result;
                            var cancel = "cancel" === arg;
                            var editIndex = _m_utils.default.getIndexByKey(results[i].key, changes);
                            var change = changes[editIndex];
                            var isError = arg && arg instanceof Error;
                            if (isError) {
                                if (change) {
                                    this._addInternalData({
                                        key: change.key,
                                        error: arg
                                    })
                                }
                                this._fireDataErrorOccurred(arg);
                                if (this._processRemoveIfError(changes, editIndex)) {
                                    break
                                }
                            } else if (this._processRemove(changes, editIndex, cancel)) {
                                hasSavedData = !cancel
                            }
                        }
                        if (changes.length < changesLength) {
                            this._silentOption(_const.EDITING_CHANGES_OPTION_NAME, changes)
                        }
                        return hasSavedData
                    };
                    _proto._fireSaveEditDataEvents = function(changes) {
                        var _this22 = this;
                        (0, _iterator.each)(changes, (function(_, _ref) {
                            var data = _ref.data,
                                key = _ref.key,
                                type = _ref.type;
                            var internalData = _this22._addInternalData({
                                key: key
                            });
                            var params = {
                                key: key,
                                data: data
                            };
                            if (internalData.error) {
                                params.error = internalData.error
                            }
                            switch (type) {
                                case _const.DATA_EDIT_DATA_REMOVE_TYPE:
                                    _this22.executeAction("onRowRemoved", (0, _extend.extend)({}, params, {
                                        data: internalData.oldData
                                    }));
                                    break;
                                case _const.DATA_EDIT_DATA_INSERT_TYPE:
                                    _this22.executeAction("onRowInserted", params);
                                    break;
                                case _const.DATA_EDIT_DATA_UPDATE_TYPE:
                                    _this22.executeAction("onRowUpdated", params)
                            }
                        }));
                        this.executeAction("onSaved", {
                            changes: changes
                        })
                    };
                    _proto.saveEditData = function() {
                        var _this23 = this;
                        var deferred = new _deferred.Deferred;
                        this.waitForDeferredOperations().done((function() {
                            if (_this23.isSaving()) {
                                _this23._resolveAfterSave(deferred);
                                return
                            }(0, _deferred.when)(_this23._beforeSaveEditData()).done((function(cancel) {
                                if (cancel) {
                                    _this23._resolveAfterSave(deferred, {
                                        cancel: cancel
                                    });
                                    return
                                }
                                _this23._saving = true;
                                _this23._saveEditDataInner().always((function() {
                                    _this23._saving = false;
                                    if (_this23._refocusEditCell) {
                                        _this23._focusEditingCell()
                                    }
                                })).done(deferred.resolve).fail(deferred.reject)
                            })).fail(deferred.reject)
                        })).fail(deferred.reject);
                        return deferred.promise()
                    };
                    _proto._resolveAfterSave = function(deferred) {
                        var _ref2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                            cancel = _ref2.cancel,
                            error = _ref2.error;
                        (0, _deferred.when)(this._afterSaveEditData(cancel)).done((function() {
                            deferred.resolve(error)
                        })).fail(deferred.reject)
                    };
                    _proto._saveEditDataInner = function() {
                        var _this24 = this;
                        var result = new _deferred.Deferred;
                        var results = [];
                        var deferreds = [];
                        var dataChanges = [];
                        var dataSource = this._dataController.dataSource();
                        (0, _deferred.when)(this._fireOnSaving()).done((function(_ref3) {
                            var cancel = _ref3.cancel,
                                changes = _ref3.changes;
                            if (cancel) {
                                return result.resolve().promise()
                            }
                            _this24._processChanges(deferreds, results, dataChanges, changes);
                            if (deferreds.length) {
                                _this24._refocusEditCell = true;
                                null === dataSource || void 0 === dataSource ? void 0 : dataSource.beginLoading();
                                _deferred.when.apply(void 0, deferreds).done((function() {
                                    if (_this24._processSaveEditDataResult(results)) {
                                        _this24._endSaving(dataChanges, changes, result)
                                    } else {
                                        null === dataSource || void 0 === dataSource ? void 0 : dataSource.endLoading();
                                        result.resolve()
                                    }
                                })).fail((function(error) {
                                    null === dataSource || void 0 === dataSource ? void 0 : dataSource.endLoading();
                                    result.resolve(error)
                                }));
                                return result.always((function() {
                                    _this24._refocusEditCell = true
                                })).promise()
                            }
                            _this24._cancelSaving(result)
                        })).fail(result.reject);
                        return result.promise()
                    };
                    _proto._beforeEndSaving = function(changes) {
                        this._resetEditIndices()
                    };
                    _proto._endSaving = function(dataChanges, changes, deferred) {
                        var dataSource = this._dataController.dataSource();
                        this._beforeEndSaving(changes);
                        null === dataSource || void 0 === dataSource ? void 0 : dataSource.endLoading();
                        this._refreshDataAfterSave(dataChanges, changes, deferred)
                    };
                    _proto._cancelSaving = function(result) {
                        this.executeAction("onSaved", {
                            changes: []
                        });
                        this._resolveAfterSave(result)
                    };
                    _proto._refreshDataAfterSave = function(dataChanges, changes, deferred) {
                        var _this25 = this;
                        var dataController = this._dataController;
                        var refreshMode = this.option("editing.refreshMode");
                        var isFullRefresh = "reshape" !== refreshMode && "repaint" !== refreshMode;
                        if (!isFullRefresh) {
                            dataController.push(dataChanges)
                        }(0, _deferred.when)(dataController.refresh({
                            selection: isFullRefresh,
                            reload: isFullRefresh,
                            load: "reshape" === refreshMode,
                            changesOnly: this.option("repaintChangesOnly")
                        })).always((function() {
                            _this25._fireSaveEditDataEvents(changes)
                        })).done((function() {
                            _this25._resolveAfterSave(deferred)
                        })).fail((function(error) {
                            _this25._resolveAfterSave(deferred, {
                                error: error
                            })
                        }))
                    };
                    _proto.isSaving = function() {
                        return this._saving
                    };
                    _proto._updateEditColumn = function() {
                        var isEditColumnVisible = this._isEditColumnVisible();
                        var useIcons = this.option("editing.useIcons");
                        var cssClass = _const.COMMAND_EDIT_CLASS + (useIcons ? " ".concat(_const.COMMAND_EDIT_WITH_ICONS_CLASS) : "");
                        this._columnsController.addCommandColumn({
                            type: "buttons",
                            command: "edit",
                            visible: isEditColumnVisible,
                            cssClass: cssClass,
                            width: "auto",
                            alignment: "center",
                            cellTemplate: this._getEditCommandCellTemplate(),
                            fixedPosition: "right"
                        });
                        this._columnsController.columnOption("command:edit", {
                            visible: isEditColumnVisible,
                            cssClass: cssClass
                        })
                    };
                    _proto._isEditColumnVisible = function() {
                        var editingOptions = this.option("editing");
                        return editingOptions.allowDeleting
                    };
                    _proto._isEditButtonDisabled = function() {
                        var hasChanges = this.hasChanges();
                        var isEditRowDefined = (0, _type.isDefined)(this.option("editing.editRowKey"));
                        return !(isEditRowDefined || hasChanges)
                    };
                    _proto._updateEditButtons = function() {
                        var headerPanel = this.getView("headerPanel");
                        var isButtonDisabled = this._isEditButtonDisabled();
                        if (headerPanel) {
                            headerPanel.setToolbarItemDisabled("saveButton", isButtonDisabled);
                            headerPanel.setToolbarItemDisabled("revertButton", isButtonDisabled)
                        }
                    };
                    _proto._applyModified = function($element, options) {
                        $element && $element.addClass(_const.CELL_MODIFIED)
                    };
                    _proto._beforeCloseEditCellInBatchMode = function(rowIndices) {};
                    _proto.cancelEditData = function() {
                        var changes = this.getChanges();
                        var params = {
                            cancel: false,
                            changes: changes
                        };
                        this.executeAction("onEditCanceling", params);
                        if (!params.cancel) {
                            this._cancelEditDataCore();
                            this.executeAction("onEditCanceled", {
                                changes: changes
                            })
                        }
                    };
                    _proto._cancelEditDataCore = function() {
                        var rowIndex = this._getVisibleEditRowIndex();
                        this._beforeCancelEditData();
                        this.init();
                        this.resetChanges();
                        this._resetEditColumnName();
                        this._resetEditRowKey();
                        this._afterCancelEditData(rowIndex)
                    };
                    _proto._afterCancelEditData = function(rowIndex) {
                        var dataController = this._dataController;
                        dataController.updateItems({
                            repaintChangesOnly: this.option("repaintChangesOnly")
                        })
                    };
                    _proto._hideEditPopup = function() {};
                    _proto.hasEditData = function() {
                        return this.hasChanges()
                    };
                    _proto.update = function(changeType) {
                        var dataController = this._dataController;
                        if (dataController && this._pageIndex !== dataController.pageIndex()) {
                            if ("refresh" === changeType) {
                                this.refresh({
                                    isPageChanged: true
                                })
                            }
                            this._pageIndex = dataController.pageIndex()
                        }
                        this._updateEditButtons()
                    };
                    _proto._getRowIndicesForCascadeUpdating = function(row, skipCurrentRow) {
                        return skipCurrentRow ? [] : [row.rowIndex]
                    };
                    _proto.addDeferred = function(deferred) {
                        var _this26 = this;
                        if (!this._deferreds.includes(deferred)) {
                            this._deferreds.push(deferred);
                            deferred.always((function() {
                                var index = _this26._deferreds.indexOf(deferred);
                                if (index >= 0) {
                                    _this26._deferreds.splice(index, 1)
                                }
                            }))
                        }
                    };
                    _proto._prepareChange = function(options, value, text) {
                        var _this27 = this;
                        var _a;
                        var newData = {};
                        var oldData = null === (_a = options.row) || void 0 === _a ? void 0 : _a.data;
                        var rowKey = options.key;
                        var deferred = new _deferred.Deferred;
                        if (void 0 !== rowKey) {
                            options.value = value;
                            var setCellValueResult = (0, _deferred.fromPromise)(options.column.setCellValue(newData, value, (0, _extend.extend)(true, {}, oldData), text));
                            setCellValueResult.done((function() {
                                deferred.resolve({
                                    data: newData,
                                    key: rowKey,
                                    oldData: oldData,
                                    type: _const.DATA_EDIT_DATA_UPDATE_TYPE
                                })
                            })).fail((0, _m_editing_utils.createFailureHandler)(deferred)).fail((function(arg) {
                                return _this27._fireDataErrorOccurred(arg)
                            }));
                            if ((0, _type.isDefined)(text) && options.column.displayValueMap) {
                                options.column.displayValueMap[value] = text
                            }
                            this._updateRowValues(options);
                            this.addDeferred(deferred)
                        }
                        return deferred
                    };
                    _proto._updateRowValues = function(options) {
                        if (options.values) {
                            var dataController = this._dataController;
                            var rowIndex = dataController.getRowIndexByKey(options.key);
                            var row = dataController.getVisibleRows()[rowIndex];
                            if (row) {
                                options.row.values = row.values;
                                options.values = row.values
                            }
                            options.values[options.columnIndex] = options.value
                        }
                    };
                    _proto.updateFieldValue = function(options, value, text, forceUpdateRow) {
                        var _this28 = this;
                        var rowKey = options.key;
                        var deferred = new _deferred.Deferred;
                        if (void 0 === rowKey) {
                            this._dataController.fireError("E1043")
                        }
                        if (options.column.setCellValue) {
                            this._prepareChange(options, value, text).done((function(params) {
                                (0, _deferred.when)(_this28._applyChange(options, params, forceUpdateRow)).always((function() {
                                    deferred.resolve()
                                }))
                            }))
                        } else {
                            deferred.resolve()
                        }
                        return deferred.promise()
                    };
                    _proto._focusPreviousEditingCellIfNeed = function(options) {
                        if (this.hasEditData() && !this.isEditCell(options.rowIndex, options.columnIndex)) {
                            this._focusEditingCell();
                            this._updateEditRow(options.row, true);
                            return true
                        }
                    };
                    _proto._needUpdateRow = function(column) {
                        var visibleColumns = this._columnsController.getVisibleColumns();
                        if (!column) {
                            column = this._getEditColumn()
                        }
                        var isCustomSetCellValue = column && column.setCellValue !== column.defaultSetCellValue;
                        var isCustomCalculateCellValue = visibleColumns.some((function(visibleColumn) {
                            return visibleColumn.calculateCellValue !== visibleColumn.defaultCalculateCellValue
                        }));
                        return isCustomSetCellValue || isCustomCalculateCellValue
                    };
                    _proto._applyChange = function(options, params, forceUpdateRow) {
                        var changeOptions = _extends(_extends({}, options), {
                            forceUpdateRow: forceUpdateRow
                        });
                        this._addChange(params, changeOptions);
                        this._updateEditButtons();
                        return this._applyChangeCore(options, changeOptions.forceUpdateRow)
                    };
                    _proto._applyChangeCore = function(options, forceUpdateRow) {
                        var isCustomSetCellValue = options.column.setCellValue !== options.column.defaultSetCellValue;
                        var row = options.row;
                        if (row) {
                            if (forceUpdateRow || isCustomSetCellValue) {
                                this._updateEditRow(row, forceUpdateRow, isCustomSetCellValue)
                            } else if (row.update) {
                                row.update()
                            }
                        }
                    };
                    _proto._updateEditRowCore = function(row, skipCurrentRow, isCustomSetCellValue) {
                        this._dataController.updateItems({
                            changeType: "update",
                            rowIndices: this._getRowIndicesForCascadeUpdating(row, skipCurrentRow)
                        })
                    };
                    _proto._updateEditRow = function(row, forceUpdateRow, isCustomSetCellValue) {
                        if (forceUpdateRow) {
                            this._updateRowImmediately(row, forceUpdateRow, isCustomSetCellValue)
                        } else {
                            this._updateRowWithDelay(row, isCustomSetCellValue)
                        }
                    };
                    _proto._updateRowImmediately = function(row, forceUpdateRow, isCustomSetCellValue) {
                        this._updateEditRowCore(row, !forceUpdateRow, isCustomSetCellValue);
                        this._validateEditFormAfterUpdate(row, isCustomSetCellValue);
                        if (!forceUpdateRow) {
                            this._focusEditingCell()
                        }
                    };
                    _proto._updateRowWithDelay = function(row, isCustomSetCellValue) {
                        var _this29 = this;
                        var deferred = new _deferred.Deferred;
                        this.addDeferred(deferred);
                        setTimeout((function() {
                            var _a;
                            var elementContainer = (null === (_a = _this29._editForm) || void 0 === _a ? void 0 : _a.element()) || _this29.component.$element().get(0);
                            var $focusedElement = (0, _renderer.default)(_dom_adapter.default.getActiveElement(elementContainer));
                            var columnIndex = _this29._rowsView.getCellIndex($focusedElement, row.rowIndex);
                            var focusedElement = $focusedElement.get(0);
                            var selectionRange = _m_utils.default.getSelectionRange(focusedElement);
                            _this29._updateEditRowCore(row, false, isCustomSetCellValue);
                            _this29._validateEditFormAfterUpdate(row, isCustomSetCellValue);
                            if (columnIndex >= 0) {
                                var $focusedItem = _this29._rowsView._getCellElement(row.rowIndex, columnIndex);
                                _this29._delayedInputFocus($focusedItem, (function() {
                                    setTimeout((function() {
                                        var _a;
                                        focusedElement = _dom_adapter.default.getActiveElement(null === (_a = _this29.component.$element()) || void 0 === _a ? void 0 : _a.get(0));
                                        if (selectionRange.selectionStart >= 0) {
                                            _m_utils.default.setSelectionRange(focusedElement, selectionRange)
                                        }
                                    }))
                                }))
                            }
                            deferred.resolve()
                        }))
                    };
                    _proto._validateEditFormAfterUpdate = function() {};
                    _proto._addChange = function(changeParams, options) {
                        var _a;
                        var row = null === options || void 0 === options ? void 0 : options.row;
                        var changes = _toConsumableArray(this.getChanges());
                        var index = _m_utils.default.getIndexByKey(changeParams.key, changes);
                        if (index < 0) {
                            index = changes.length;
                            this._addInternalData({
                                key: changeParams.key,
                                oldData: changeParams.oldData
                            });
                            delete changeParams.oldData;
                            changes.push(changeParams)
                        }
                        var change = _extends({}, changes[index]);
                        if (change) {
                            if (changeParams.data) {
                                change.data = (0, _array_utils.createObjectWithChanges)(change.data, changeParams.data)
                            }
                            if ((!change.type || !changeParams.data) && changeParams.type) {
                                change.type = changeParams.type
                            }
                            if (row) {
                                row.oldData = this._getOldData(row.key);
                                row.data = (0, _array_utils.createObjectWithChanges)(row.data, changeParams.data)
                            }
                        }
                        changes[index] = change;
                        this._silentOption(_const.EDITING_CHANGES_OPTION_NAME, changes);
                        if (options && change !== (null === (_a = this.getChanges()) || void 0 === _a ? void 0 : _a[index])) {
                            options.forceUpdateRow = true
                        }
                        return change
                    };
                    _proto._getFormEditItemTemplate = function(cellOptions, column) {
                        return column.editCellTemplate || this._getDefaultEditorTemplate()
                    };
                    _proto.getColumnTemplate = function(options) {
                        var _this30 = this;
                        var column = options.column;
                        var rowIndex = options.row && options.row.rowIndex;
                        var template;
                        var isRowMode = this.isRowBasedEditMode();
                        var isRowEditing = this.isEditRow(rowIndex);
                        var isCellEditing = this.isEditCell(rowIndex, options.columnIndex);
                        var editingStartOptions;
                        if ((column.showEditorAlways || column.setCellValue && (isRowEditing && column.allowEditing || isCellEditing)) && ("data" === options.rowType || "detailAdaptive" === options.rowType) && !column.command) {
                            var allowUpdating = this.allowUpdating(options);
                            if (((allowUpdating || isRowEditing) && column.allowEditing || isCellEditing) && (isRowEditing || !isRowMode)) {
                                if (column.showEditorAlways && !isRowMode) {
                                    editingStartOptions = {
                                        cancel: false,
                                        key: options.row.isNewRow ? void 0 : options.row.key,
                                        data: options.row.data,
                                        column: column
                                    };
                                    this._isEditingStart(editingStartOptions)
                                }
                                if (!editingStartOptions || !editingStartOptions.cancel) {
                                    options.setValue = function(value, text) {
                                        _this30.updateFieldValue(options, value, text)
                                    }
                                }
                            }
                            template = column.editCellTemplate || this._getDefaultEditorTemplate()
                        } else if ("detail" === column.command && "detail" === options.rowType && isRowEditing) {
                            template = null === this || void 0 === this ? void 0 : this.getEditFormTemplate(options)
                        }
                        return template
                    };
                    _proto._createButton = function($container, button, options, change) {
                        var icon = _const.EDIT_ICON_CLASS[button.name];
                        var useIcons = this.option("editing.useIcons");
                        var useLegacyColumnButtonTemplate = this.option("useLegacyColumnButtonTemplate");
                        var $button = (0, _renderer.default)("<a>").attr("href", "#").addClass(_const.LINK_CLASS).addClass(button.cssClass);
                        if (button.template && useLegacyColumnButtonTemplate) {
                            this._rowsView.renderTemplate($container, button.template, options, true)
                        } else {
                            if (button.template) {
                                $button = (0, _renderer.default)("<span>").addClass(button.cssClass)
                            } else if (useIcons && icon || button.icon) {
                                icon = button.icon || icon;
                                var iconType = iconUtils.getImageSourceType(icon);
                                if ("image" === iconType || "svg" === iconType) {
                                    $button = iconUtils.getImageContainer(icon).addClass(button.cssClass)
                                } else {
                                    $button.addClass("dx-icon".concat("dxIcon" === iconType ? "-" : " ").concat(icon)).attr("title", button.text)
                                }
                                $button.addClass(_const.LINK_ICON_CLASS);
                                $container.addClass(_const.COMMAND_EDIT_WITH_ICONS_CLASS);
                                var localizationName = this.getButtonLocalizationNames()[button.name];
                                localizationName && $button.attr("aria-label", _message.default.format(localizationName))
                            } else {
                                $button.text(button.text)
                            }
                            if ((0, _type.isDefined)(button.hint)) {
                                $button.attr("title", button.hint)
                            }
                            if (this._isButtonDisabled(button, options)) {
                                $button.addClass("dx-state-disabled")
                            } else if (!button.template || button.onClick) {
                                _events_engine.default.on($button, (0, _index.addNamespace)("click", _const.EDITING_NAMESPACE), this.createAction((function(e) {
                                    var _a;
                                    null === (_a = button.onClick) || void 0 === _a ? void 0 : _a.call(button, (0, _extend.extend)({}, e, {
                                        row: options.row,
                                        column: options.column
                                    }));
                                    e.event.preventDefault();
                                    e.event.stopPropagation()
                                })))
                            }
                            $container.append($button, "&nbsp;");
                            if (button.template) {
                                options.renderAsync = false;
                                this._rowsView.renderTemplate($button, button.template, options, true, change)
                            }
                        }
                    };
                    _proto.getButtonLocalizationNames = function() {
                        return {
                            edit: "dxDataGrid-editingEditRow",
                            save: "dxDataGrid-editingSaveRowChanges",
                            delete: "dxDataGrid-editingDeleteRow",
                            undelete: "dxDataGrid-editingUndeleteRow",
                            cancel: "dxDataGrid-editingCancelRowChanges"
                        }
                    };
                    _proto.prepareButtonItem = function(headerPanel, name, methodName, sortIndex) {
                        var _this31 = this;
                        var _a;
                        var editingTexts = null !== (_a = this.option("editing.texts")) && void 0 !== _a ? _a : {};
                        var titleButtonTextByClassNames = {
                            revert: editingTexts.cancelAllChanges,
                            save: editingTexts.saveAllChanges,
                            addRow: editingTexts.addRow
                        };
                        var className = {
                            revert: "cancel",
                            save: "save",
                            addRow: "addrow"
                        } [name];
                        var hintText = titleButtonTextByClassNames[name];
                        var isButtonDisabled = ("save" === className || "cancel" === className) && this._isEditButtonDisabled();
                        return {
                            widget: "dxButton",
                            options: {
                                onInitialized: function(e) {
                                    (0, _renderer.default)(e.element).addClass(headerPanel._getToolbarButtonClass("".concat(_const.EDIT_BUTTON_CLASS, " ").concat(_this31.addWidgetPrefix(className), "-button")))
                                },
                                icon: "edit-button-".concat(className),
                                disabled: isButtonDisabled,
                                onClick: function() {
                                    setTimeout((function() {
                                        _this31[methodName]()
                                    }))
                                },
                                text: hintText,
                                hint: hintText
                            },
                            showText: "inMenu",
                            name: "".concat(name, "Button"),
                            location: "after",
                            locateInMenu: "auto",
                            sortIndex: sortIndex
                        }
                    };
                    _proto.prepareEditButtons = function(headerPanel) {
                        var _a;
                        var editingOptions = null !== (_a = this.option("editing")) && void 0 !== _a ? _a : {};
                        var buttonItems = [];
                        if (editingOptions.allowAdding) {
                            buttonItems.push(this.prepareButtonItem(headerPanel, "addRow", "addRow", 20))
                        }
                        return buttonItems
                    };
                    _proto.highlightDataCell = function($cell, params) {
                        this.shouldHighlightCell(params) && $cell.addClass(_const.CELL_MODIFIED)
                    };
                    _proto._afterInsertRow = function() {};
                    _proto._beforeSaveEditData = function(change) {
                        if (change && !(0, _type.isDefined)(change.key) && (0, _type.isDefined)(change.type)) {
                            return true
                        }
                    };
                    _proto._afterSaveEditData = function() {};
                    _proto._beforeCancelEditData = function() {};
                    _proto._allowEditAction = function(actionName, options) {
                        var allowEditAction = this.option("editing.".concat(actionName));
                        if ((0, _type.isFunction)(allowEditAction)) {
                            allowEditAction = allowEditAction({
                                component: this.component,
                                row: options.row
                            })
                        }
                        return allowEditAction
                    };
                    _proto.allowUpdating = function(options, eventName) {
                        var _a;
                        var startEditAction = null !== (_a = this.option("editing.startEditAction")) && void 0 !== _a ? _a : _const.DEFAULT_START_EDIT_ACTION;
                        var needCallback = arguments.length > 1 ? startEditAction === eventName || "down" === eventName : true;
                        return needCallback && this._allowEditAction("allowUpdating", options)
                    };
                    _proto.allowDeleting = function(options) {
                        return this._allowEditAction("allowDeleting", options)
                    };
                    _proto.isCellModified = function(parameters) {
                        var _a, _b, _c;
                        var columnIndex = parameters.columnIndex;
                        var modifiedValue = null === (_b = null === (_a = null === parameters || void 0 === parameters ? void 0 : parameters.row) || void 0 === _a ? void 0 : _a.modifiedValues) || void 0 === _b ? void 0 : _b[columnIndex];
                        if (null === (_c = null === parameters || void 0 === parameters ? void 0 : parameters.row) || void 0 === _c ? void 0 : _c.isNewRow) {
                            modifiedValue = parameters.value
                        }
                        return void 0 !== modifiedValue
                    };
                    _proto.isNewRowInEditMode = function() {
                        var visibleEditRowIndex = this._getVisibleEditRowIndex();
                        var rows = this._dataController.items();
                        return visibleEditRowIndex >= 0 ? rows[visibleEditRowIndex].isNewRow : false
                    };
                    _proto._isRowDeleteAllowed = function() {};
                    _proto.shouldHighlightCell = function(parameters) {
                        var cellModified = this.isCellModified(parameters);
                        return cellModified && parameters.column.setCellValue && (this.getEditMode() !== _const.EDIT_MODE_ROW || !parameters.row.isEditing)
                    };
                    return EditingControllerImpl
                }(_m_modules.default.ViewController);
                var editingModule = {
                    defaultOptions: function() {
                        return {
                            editing: {
                                mode: "row",
                                refreshMode: "full",
                                newRowPosition: _const.VIEWPORT_TOP_NEW_ROW_POSITION,
                                allowAdding: false,
                                allowUpdating: false,
                                allowDeleting: false,
                                useIcons: false,
                                selectTextOnEditStart: false,
                                confirmDelete: true,
                                texts: {
                                    editRow: _message.default.format("dxDataGrid-editingEditRow"),
                                    saveAllChanges: _message.default.format("dxDataGrid-editingSaveAllChanges"),
                                    saveRowChanges: _message.default.format("dxDataGrid-editingSaveRowChanges"),
                                    cancelAllChanges: _message.default.format("dxDataGrid-editingCancelAllChanges"),
                                    cancelRowChanges: _message.default.format("dxDataGrid-editingCancelRowChanges"),
                                    addRow: _message.default.format("dxDataGrid-editingAddRow"),
                                    deleteRow: _message.default.format("dxDataGrid-editingDeleteRow"),
                                    undeleteRow: _message.default.format("dxDataGrid-editingUndeleteRow"),
                                    confirmDeleteMessage: _message.default.format("dxDataGrid-editingConfirmDeleteMessage"),
                                    confirmDeleteTitle: ""
                                },
                                form: {
                                    colCount: 2
                                },
                                popup: {},
                                startEditAction: "click",
                                editRowKey: null,
                                editColumnName: null,
                                changes: []
                            },
                            useLegacyColumnButtonTemplate: false
                        }
                    },
                    controllers: {
                        editing: EditingControllerImpl
                    },
                    extenders: {
                        controllers: {
                            data: {
                                init: function() {
                                    this._editingController = this.getController("editing");
                                    this.callBase()
                                },
                                reload: function(full, repaintChangesOnly) {
                                    !repaintChangesOnly && this._editingController.refresh();
                                    return this.callBase.apply(this, arguments)
                                },
                                repaintRows: function() {
                                    if (this.getController("editing").isSaving()) {
                                        return
                                    }
                                    return this.callBase.apply(this, arguments)
                                },
                                _updateEditRow: function(items) {
                                    var _a;
                                    var editRowKey = this.option(_const.EDITING_EDITROWKEY_OPTION_NAME);
                                    var editRowIndex = _m_utils.default.getIndexByKey(editRowKey, items);
                                    var editItem = items[editRowIndex];
                                    if (editItem) {
                                        editItem.isEditing = true;
                                        null === (_a = this._updateEditItem) || void 0 === _a ? void 0 : _a.call(this, editItem)
                                    }
                                },
                                _updateItemsCore: function(change) {
                                    this.callBase(change);
                                    this._updateEditRow(this.items(true))
                                },
                                _applyChangeUpdate: function(change) {
                                    this._updateEditRow(change.items);
                                    this.callBase(change)
                                },
                                _applyChangesOnly: function(change) {
                                    this._updateEditRow(change.items);
                                    this.callBase(change)
                                },
                                _processItems: function(items, change) {
                                    items = this._editingController.processItems(items, change);
                                    return this.callBase(items, change)
                                },
                                _processDataItem: function(dataItem, options) {
                                    this._editingController.processDataItem(dataItem, options, this.generateDataValues);
                                    return this.callBase(dataItem, options)
                                },
                                _processItem: function(item, options) {
                                    item = this.callBase(item, options);
                                    if (item.isNewRow) {
                                        options.dataIndex--;
                                        delete item.dataIndex
                                    }
                                    return item
                                },
                                _getChangedColumnIndices: function(oldItem, newItem, rowIndex, isLiveUpdate) {
                                    if (oldItem.isNewRow !== newItem.isNewRow || oldItem.removed !== newItem.removed) {
                                        return
                                    }
                                    return this.callBase.apply(this, arguments)
                                },
                                _isCellChanged: function(oldRow, newRow, visibleRowIndex, columnIndex, isLiveUpdate) {
                                    var editingController = this.getController("editing");
                                    var cell = oldRow.cells && oldRow.cells[columnIndex];
                                    var isEditing = editingController && editingController.isEditCell(visibleRowIndex, columnIndex);
                                    if (isLiveUpdate && isEditing) {
                                        return false
                                    }
                                    if (cell && cell.column && !cell.column.showEditorAlways && cell.isEditing !== isEditing) {
                                        return true
                                    }
                                    return this.callBase.apply(this, arguments)
                                },
                                needToRefreshOnDataSourceChange: function(args) {
                                    var editingController = this.getController("editing");
                                    var isParasiteChange = Array.isArray(args.value) && args.value === args.previousValue && editingController.isSaving();
                                    return !isParasiteChange
                                },
                                _handleDataSourceChange: function(args) {
                                    var _this32 = this;
                                    var result = this.callBase(args);
                                    var changes = this.option("editing.changes");
                                    var dataSource = args.value;
                                    if (Array.isArray(dataSource) && changes.length) {
                                        var dataSourceKeys = dataSource.map((function(item) {
                                            return _this32.keyOf(item)
                                        }));
                                        var newChanges = changes.filter((function(change) {
                                            return "insert" === change.type || dataSourceKeys.some((function(key) {
                                                return (0, _common.equalByValue)(change.key, key)
                                            }))
                                        }));
                                        if (newChanges.length !== changes.length) {
                                            this.option("editing.changes", newChanges)
                                        }
                                        var editRowKey = this.option("editing.editRowKey");
                                        var isEditNewItem = newChanges.some((function(change) {
                                            return "insert" === change.type && (0, _common.equalByValue)(editRowKey, change.key)
                                        }));
                                        if (!isEditNewItem && dataSourceKeys.every((function(key) {
                                                return !(0, _common.equalByValue)(editRowKey, key)
                                            }))) {
                                            this.option("editing.editRowKey", null)
                                        }
                                    }
                                    return result
                                }
                            }
                        },
                        views: {
                            rowsView: {
                                init: function() {
                                    this.callBase();
                                    this._editingController = this.getController("editing")
                                },
                                getCellIndex: function($cell, rowIndex) {
                                    if (!$cell.is("td") && rowIndex >= 0) {
                                        var $cellElements = this.getCellElements(rowIndex);
                                        var cellIndex = -1;
                                        (0, _iterator.each)($cellElements, (function(index, cellElement) {
                                            if ((0, _renderer.default)(cellElement).find($cell).length) {
                                                cellIndex = index
                                            }
                                        }));
                                        return cellIndex
                                    }
                                    return this.callBase.apply(this, arguments)
                                },
                                publicMethods: function() {
                                    return this.callBase().concat(["cellValue"])
                                },
                                _getCellTemplate: function(options) {
                                    var template = this._editingController.getColumnTemplate(options);
                                    return template || this.callBase(options)
                                },
                                _createRow: function(row) {
                                    var $row = this.callBase.apply(this, arguments);
                                    if (row) {
                                        var isRowRemoved = !!row.removed;
                                        var isRowInserted = !!row.isNewRow;
                                        var isRowModified = !!row.modified;
                                        isRowInserted && $row.addClass(_const.ROW_INSERTED);
                                        isRowModified && $row.addClass(_const.ROW_MODIFIED);
                                        if (isRowInserted || isRowRemoved) {
                                            $row.removeClass(_const.ROW_SELECTED)
                                        }
               