/*
 * Instant Developer Cloud
 * Copyright Pro Gamma Spa 2000-2021
 * All rights reserved
 */

/* global Client */

/**
 * @class A video element
 * @param {Object} element - the element description
 * @param {View|Element} parent - the parent element
 * @param {View} view - the view containing the span
 */
Client.Video = function (element, parent, view)
{
  Client.Element.call(this, element, parent, view);
  //
  var pthis = this;
  this.domObj = document.createElement("video");
  this.domObj.setAttribute("webkit-playsinline", "");
  this.domObj.setAttribute("playsinline", "");
  this.domObj.addEventListener("play", function (ev) {
    var e = [{obj: pthis.id, id: "chgProp", content: {name: "playing", value: true, clid: Client.id}}];
    if (pthis.sendPlaying)
      e.push({obj: pthis.id, id: "onPlayingChange", content: pthis.saveEvent(ev)});
    Client.mainFrame.sendEvents(e);
  }, true);
  this.domObj.addEventListener("pause", function (ev) {
    var e = [{obj: pthis.id, id: "chgProp", content: {name: "playing", value: false, clid: Client.id}}];
    if (pthis.sendPlaying)
      e.push({obj: pthis.id, id: "onPlayingChange", content: pthis.saveEvent(ev)});
    Client.mainFrame.sendEvents(e);
  }, true);
  this.domObj.addEventListener("seeked", function (ev) {
    if (!pthis.changedTime) {
      var e = [{obj: pthis.id, id: "chgProp", content: {name: "seekTime", value: pthis.domObj.currentTime, clid: Client.id}}];
      if (pthis.sendSeek) {
        var x = pthis.saveEvent(ev);
        x.seekTime = pthis.domObj.currentTime;
        e.push({obj: pthis.id, id: "onSeek", content: x});
      }
      Client.mainFrame.sendEvents(e);
    }
    pthis.changedTime = false;
  }, true);
  this.domObj.addEventListener("volumechange", function (ev) {
    if (!pthis.changedVolume) {
      var e = [{obj: pthis.id, id: "chgProp", content: {name: "volume", value: pthis.domObj.volume, clid: Client.id}},
        {obj: pthis.id, id: "chgProp", content: {name: "muted", value: pthis.domObj.muted, clid: Client.id}}];
      if (pthis.sendVolume)
        e.push({obj: pthis.id, id: "onVolumeChange", content: pthis.saveEvent(ev)});
      Client.mainFrame.sendEvents(e);
    }
    pthis.changedVolume = false;
  }, true);
  //
  this.updateElement(element);
  this.attachEvents(element.events);
  parent.appendChildObject(this, this.domObj);
};

// Make Client.Video extend Client.Element
Client.Video.prototype = new Client.Element();


/**
 * Update element properties
 * @param {Object} el - properties to update
 */
Client.Video.prototype.updateElement = function (el)
{
  this.purgeMyProp(el);
  if (el.playing !== undefined) {
    if (el.playing)
      this.domObj.play();
    else
      this.domObj.pause();
    delete el.playing;
  }
  if (el.seekTime !== undefined) {
    this.changedTime = true;
    this.domObj.currentTime = el.seekTime;
    delete el.seekTime;
  }
  if (el.currentTime !== undefined) {
    this.changedTime = true;
  }
  if (el.volume !== undefined || el.muted !== undefined) {
    this.changedVolume = true;
  }
  //
  Client.Element.prototype.updateElement.call(this, el);
};


/**
 * Attach events handler
 * @param {Array} events - array of the events to handle
 */
Client.Video.prototype.attachEvents = function (events)
{
  if (!events)
    return;
  //
  var pos = events.indexOf("onVolumeChange");
  if (pos >= 0) {
    events.splice(pos, 1);
    this.sendVolume = true;
  }
  pos = events.indexOf("onPlayingChange");
  if (pos >= 0) {
    events.splice(pos, 1);
    this.sendPlaying = true;
  }
  pos = events.indexOf("onSeek");
  if (pos >= 0) {
    events.splice(pos, 1);
    this.sendSeek = true;
  }
  //
  Client.Element.prototype.attachEvents.call(this, events);
};
