// ****************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe PPage: Rappresenta la pagina di un pannello
// ***************************************************
function PPage(ppanel)
{
  this.VisualStyle = -1;              // Visual Style della pagina: per ora non usato
  this.Flags = 0;                     // Flag della pagine
  this.Image = "";                    // Immagine della pagina
  this.Header = "";                   // Caption della pagina
  this.Tooltip = "";                  // Tooltip della pagina
  this.Style = 0;                     // Indice dello stile CSS della linguetta della pagina
  this.Index = 0;                     // Indice della pagina
  this.Badge = "";                    // Badge della Pagina
  //
  this.Identifier = "";               // Identificatore della pagina
  //
  // Altre variabili di modello...
  this.ParentPanel = ppanel;            // L'oggetto pannello cui il gruppo appartiene
  //
  // Variabili di collegamento con il DOM
  this.Realized = false; 				        // Se vero, gli oggetti del DOM sono gia' stati creati
  //
  // Oggetti visuali relativi al gruppo
  this.PageContainer = null;      // DIV contenitore dell'intera pagina
  this.LeftSpan = null;           // Span sinistro separatore delle varie pagine
  this.CaptionContainer = null;   // Span contenitore del resto della caption, per impostare il colore di sfondo
	this.LeftImage = null;          // Immagine sinistra della caption
	this.HeaderCont = null;         // Span contenitore del nome della Tab e dell'immagine
	this.PageImg = null;            // Immagine della caption
	this.CaptionTxt = null;         // Testo della caption
	this.RightSpan = null;          // Span destro separatore delle varie pagine
	this.RightImage = null;         // Immagine destra della Caption
	this.BadgeObj = null;           // Immagine del Badge
	//
	//this.TempImg = null;          // Elemento Img attualmente mostrato nella Page (IE10+)
	//this.ImgSrc = null;           // Immagine attualmente mostrata nella Page (IE10+)
}


// *******************************************************************
// Inizializza questo PField leggendo i dati da un nodo XML
// *******************************************************************
PPage.prototype.LoadFromXml = function(node) 
{
	// Inizializzo le proprieta' locali
	this.LoadProperties(node);
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
PPage.prototype.ChangeProperties = function(node)
{
	// Normale cambio di proprieta'
  this.LoadProperties(node);
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
PPage.prototype.LoadProperties = function(node)
{
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
    	case "sty": this.SetVisualStyle(parseInt(attrnode.nodeValue)); break;
      case "flg": this.SetFlags(parseInt(attrnode.nodeValue)); break;
    	case "img": this.SetImage(attrnode.nodeValue); break;
    	case "cap": this.SetHeader(attrnode.nodeValue); break;
    	case "tip": this.SetTooltip(attrnode.nodeValue); break;
    	case "pst": this.SetStyle(parseInt(attrnode.nodeValue)); break;
    	case "ind": this.SetIndex(parseInt(attrnode.nodeValue)); break;
    	case "bdg": this.SetBadge(attrnode.nodeValue); break;
    	
    	case "id": 
    		this.Identifier = valore;
    		RD3_DesktopManager.ObjectMap.add(valore, this);
    		
    	break;
    }
  }
}


// *******************************************************************
// Setter delle proprieta' 
// ******************************************************************* 
PPage.prototype.SetVisualStyle = function(value) 
{ 
  if (value != undefined) 
    this.VisualStyle = value; 
    // 
    // Per ora il visual style non viene usato... 
}

PPage.prototype.SetFlags = function(value)
{
	var old = this.Flags;
	//
  if (value != undefined)
    this.Flags = value;
  //
  if (this.Realized)
  {
		// Vediamo cosa e' cambiato
		// Controllo visibilita'
		var wasvis = old & 0x02; // OBJ_VISIBLE
		var isvis  = this.Flags & 0x02;
		//
		if (wasvis!=isvis || value==undefined)
			this.UpdateVisibility();
		//
		// Controllo abilitazione
		var wasena = old & 0x01; // OBJ_ENABLED
		var isena  = this.Flags & 0x01;
		//
		if (wasena!=isena || value==undefined)
			this.ParentPanel.UpdatePageEnability(this.Index);
  }
}

PPage.prototype.UpdateVisibility = function()
{
	// Aggiorno la visibilita' della pagina
  var s = this.IsVisible() ? "" : "none";
  if (this.CaptionContainer)
    this.CaptionContainer.style.display = s;
  //
  if (this.ParentPanel.PanelPage == this.Index)
  	this.ParentPanel.SetPanelPage();
  //
  // In ogni caso spingo il ricalcolo del layout del pannello.
  //this.ParentPanel.RecalcLayout = true;
}

PPage.prototype.SetImage = function(value)
{
  if (value != undefined)
    this.Image = value;
  //
  if (this.Realized)
  {
    
  }
}

PPage.prototype.SetHeader = function(value)
{
  if (value != undefined)
    this.Header = value;
  //
  if (this.Realized)  {
    if (this.CaptionTxt) {
      if (RD3_Glb.IsIconString(this.Header))
        this.CaptionTxt.innerHTML = RD3_Glb.HandleIconString(this.Header);
      else
    	  this.CaptionTxt.textContent = this.Header
    }
  }
}

PPage.prototype.SetTooltip = function(value)
{
  if (value != undefined)
    this.Tooltip = value;
  //
  if (this.Realized)
    RD3_TooltipManager.SetObjTitle(this.CaptionContainer, this.Tooltip);
}

PPage.prototype.SetBadge = function(value)
{
  if (value != undefined)
    this.Badge = value;
  //
  if (this.Realized) {
    if (this.Badge == "") {
      if (this.BadgeObj != null && this.BadgeObj.parentNode)
        this.BadgeObj.parentNode.removeChild(this.BadgeObj);
      this.BadgeObj = null;
    }
    else {
      if (this.BadgeObj == null) {
        this.BadgeObj = document.createElement("span");
        this.BadgeObj.className = "badge";
        this.HeaderCont.appendChild(this.BadgeObj);
      }
      //
      this.BadgeObj.innerHTML = this.Badge;
    }
  }
}

PPage.prototype.SetStyle = function(value)
{
  if (value != undefined)
    this.Style = value;
  //
  if (this.Realized)
    this.UpdateSelection();
}

PPage.prototype.SetIndex = function(value)
{
  if (value != undefined)
    this.Index = value;
  //
  // L'indice non puo' cambiare dopo la realizzazione
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
PPage.prototype.Realize = function(parent)
{
  // Creo gli oggetti del DOM
  this.CaptionContainer = document.createElement("li");
  this.CaptionContainer.setAttribute("id", this.Identifier+":cap");
  this.HeaderCont = document.createElement("a");
  this.CaptionTxt = document.createElement("span");
  //this.PageImg = document.createElement("img");
	//
	this.CaptionContainer.onclick = function(ev) {
    this.OnClick(ev);
  }.bind(this);
	//
	// Inserisco gli elementi nel DOM
  this.HeaderCont.appendChild(this.CaptionTxt);
  this.CaptionContainer.appendChild(this.HeaderCont);
  parent.appendChild(this.CaptionContainer);
  //
	// Inizializzazione visuale
	this.Realized = true;
	//
	this.SetVisualStyle();
	this.SetFlags();
	this.SetImage();
	this.SetHeader();
	this.SetTooltip();
	this.SetBadge();
	//
	this.SetStyle(); // Questa chiamata aggiusta le classi e aggiorna la visualizzazione
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
PPage.prototype.Unrealize = function()
{ 
	// Rimuovo la pagina dal DOM
	
	//
	// Mi tolgo dalla mappa degli oggetti
	RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  //
  // Elimino i riferimenti al DOM
  
  //
  this.Realized = false; 
}


// ********************************************************************************
// Aggiorna gli stili della pagina a seconda se e' selezionata o meno
// ********************************************************************************
PPage.prototype.UpdateSelection = function()
{ 
	if (this.CaptionContainer) {
	  var s = "";
		if (this.ParentPanel.PanelPage == this.Index)
		  s = "active";
    this.CaptionContainer.className = s + " " + this.Style;
	}
}


// ********************************************************************************
// Gestore evento di click su una pagina
// ********************************************************************************
PPage.prototype.OnClick= function(evento)
{ 
	if (this.ParentPanel.PanelPage != this.Index)
	{
		// Posso lanciare il click!
		var ev = new IDEvent("panpg", this.Identifier, evento, this.ParentPanel.PageClickEventDef, this.ParentPanel.Identifier);
		//
		if (ev.ClientSide)
    {
			// Durante la gestione locale del cambio di pagina possono avvenire molte cose,
    	// e' meglio che il server sia avvertito il piu' in fretta possibile
    	RD3_DesktopManager.SendEvents();
			this.ParentPanel.SetPanelPage(this.Index, true);
		}
	}
}


// ********************************************************************************
// Restituisce true se questo pagina e' visibile
// ********************************************************************************
PPage.prototype.IsVisible = function()
{
	return (this.Flags & 0x2) != 0; // OBJ_VISIBLE
}


// ********************************************************************************
// Restituisce true se questo pagina e' visibile
// ********************************************************************************
PPage.prototype.IsEnabled = function()
{
	return (this.Flags & 0x1) != 0; // OBJ_ENABLED
}


// ********************************************************************************
// Gestore evento di mouse over su una pagina
// ********************************************************************************
PPage.prototype.OnMouseOverObj= function(evento, obj)
{ 
  
}


// ********************************************************************************
// Gestore evento di mouse out su una pagina
// ********************************************************************************
PPage.prototype.OnMouseOutObj= function(evento, obj)
{ 
  
}


// ********************************************************************************
// Gestore evento di mouse down su una pagina
// ********************************************************************************
PPage.prototype.OnMouseDownObj= function(evento, obj)
{ 
  
}


// *********************************************************
// Imposta il tooltip
// *********************************************************
PPage.prototype.GetTooltip = function(tip, obj)
{
  if (this.Tooltip == "")
    return false;
  //
  tip.SetObj(this.CaptionContainer);
  obj = this.CaptionContainer;
  //
  tip.SetTitle(this.Header);
  tip.SetText(this.Tooltip);
  tip.SetAnchor(RD3_Glb.GetScreenLeft(obj) + (obj.offsetWidth/2), RD3_Glb.GetScreenTop(obj));
  tip.SetPosition(0);
  return true;
}

// *******************************************************
// Metodo che gestisce il cambio dello stato dell'immagine
// *******************************************************
PPage.prototype.OnReadyStateChange = function()
{
  
}

// *******************************************************************
// Chiamato quando ho l'immagine da retinare
// *******************************************************************
PPage.prototype.OnAdaptRetina = function(w, h, par)
{
	
}
