// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Parametri definiti localmente che non vengono
// quindi comunicati dal server. 
// ************************************************

function ClientParams()
{
	// Animazioni
	this.GFXDef = new HashTable();
	//
	this.EnableGFX = true;      // Abilitazione globale delle animazioni
	this.UseWebKitGFX = true;   // Vero se si possono usare le animazioni weblit quando disponibili
	//
	this.GFXDef.add("menu", "fold:250");        // Supportati fold e none
	this.GFXDef.add("sidebar", "scroll:250");   // scroll, fold e none
	this.GFXDef.add("start", "fade:250");       // fade e none
	this.GFXDef.add("form", "scroll-v:250!");   // fade, scroll-v, scroll-h, fold-v, fold-h, none
	this.GFXDef.add("frame", "fold:250!");	    // fold e none
	this.GFXDef.add("tree", "fold:250");	      // fold e none
	this.GFXDef.add("modal", "zoom:250!");	    // point-tl, point-tr, point-bl, point-br, zoom e none
	this.GFXDef.add("list", "scroll-h:250!");	  // fade, scroll-v, scroll-h, fold-v, fold-h, none
	this.GFXDef.add("tab", "scroll-h:250!");	  // fade, scroll-h, fold-h,none
	this.GFXDef.add("popup", "scroll:250");	    // fold, scroll, none
	this.GFXDef.add("graph", "fade:250");	      // fade, none
	this.GFXDef.add("book", "scroll:250!");	    // fade, scroll, fold, none
	this.GFXDef.add("message", "fold:250");	    // fold, none
	this.GFXDef.add("lastmessage", "fade:250");	// fade, none
	this.GFXDef.add("qbetip", "fade:250");	    // fade, none
	this.GFXDef.add("redirect", "fade:250!");	  // fade, none
	this.GFXDef.add("preview", "scroll:250!");	// fade, scroll, fold, none
	this.GFXDef.add("docked", "scroll:250!");	  // scroll, fold, none
	this.GFXDef.add("popupres", "fold:250!");	  // fold, none
	this.GFXDef.add("tooltip", "fade:250");	    // fade, none
	this.GFXDef.add("taskbar", "fold:250");	    // fold, none
	this.GFXDef.add("combo", "scroll:250");	    // fold, scroll, none
	this.GFXDef.add("group", "fold:250");	      // fold, none
	this.GFXDef.add("zone", "scroll:250!");	    // scroll, fold, none
	this.GFXDef.add("unpinned", "scroll:250!");	// scroll

	// Souni
	this.SoundDef = new HashTable();
	//
	this.EnableSound = false;      // Abilitazione globale dei suoni
	
	// Animazioni per l'hilight dei treenode
	this.HilightTreeNodes = true;
	
	// Icona della comunicazione Ajax in corso
	this.ShowAjaxIndicator = true;

	// Parametri per il D&D
	this.DragSensibility = RD3_Glb.IsMobile()?-1:6; // Numero di pixel di cui l'oggetto deve essere spostato prima di iniziare il drag
	this.MinSize = 4;         // Minima dimensione in px degli oggetti da ridimensionare
	this.ResizeLimit = RD3_Glb.IsTouch()?12:4; // Distanza del mouse dal bordo in px per attivare resize
	this.ChgResMM = 1;        // Minima variazione (in mm) durante la trasformazione
	this.ChgResIN = 0.04;     // Minima variazione (in inch) durante la trasformazione
	this.MoveBorders = "";    // Stile dei bordi durante il movimento di una box,
														// Se stringa vuota, utilizza il bordo dell'oggetto.
														// Esempio: "2px dotted blue"
																
	// Parametri per la comunicazione con il server
	this.MaxOpenRequests = 2; // Numero di richieste al server massime contemporanee
	this.DelayDlgTime = 1500; // Tempo in ms prima di aprire una finestra modale bloccante
	this.DelayDlgShowTime = 1500; // Tempo in ms prima che la finestra modale venga visualizzata se l'utente non fa nulla
	
	// Tempi di ritardo per la trasmissione degli eventi al server
	this.SuperActiveDelay = 200;
	this.DelayTimes = new HashTable();
	this.DelayTimes.add("panscr", 50); // Ritardo standard per lo scrolling del pannello: non e' bene metterlo inferiore a 50 perche' IE lancia molti evento di scrolling!
	//
	// Parametri per le dialog popup
	this.PopupDlgMinW = 240;        // Minima larghezza in pixel assumibile da una dialog modale
	this.PopupInputMinW = 400;      // Minima larghezza in pixel assumibile da una input box
	this.PopupProgressSpeed = 2;    // Velocita' di animazione della progress bar
	//
	// Parametri per le form
	this.MaxMessagesBoxHeight = "54px";
	this.MinMessagesBoxHeight = 22; 		// Usato se ci sono pannelli infomessages
	this.StandardPadding = RD3_Glb.IsMobile()?0:2; // Margine standard per il contenuto di tutti i frame della form (in pixel)
	
	// Parametri per i pannelli
	this.RowSelWidth = 20;     // Larghezza del Row Selector
	this.ActivatorWidth = 35;  // Larghezza standard del pulsante di attivazione campi
	this.BlobButtonWidth = (RD3_Glb.IsTouch() || RD3_Glb.IsMobile())?28:22; // Larghezza standard dei bottoni della toolbar blob
	this.TabWidth = 100;       // Larghezza standard delle linguette delle tabbed view
	this.TabWidthThin = 40;    // Larghezza ridotta delle linguette delle tabbed view
	this.HLDBorderWidth = 2;   // Larghezza del bordo del DIV per evidenziare durante la cancellazione
	
	// Tasti funzionali standard
	this.FKActField = 2; 	// Attivatore del singolo campo
	this.FKEnterQBE = 3;  // Tasto entra in QBE
	this.FKFindData = 3;  // Tasto trova i dati
	this.FKFormList = 4;  // Tasto form/list
	this.FKRefresh  = 6;  // Tasto refresh
	this.FKCancel   = 6;  // Tasto cancel
	this.FKInsert   = 7;  // Tasto insert
	this.FKDelete   = 8;  // Tasto delete
	this.FKUpdate   = 9;  // Tasto salva
	this.FKLocked   = 11; // Tasto lock/unlock
	this.FKActRow   = 12; // Tasto attivatore di riga
	this.FKSelAll   = 14; // Tasto seleziona tutto SHIFT+F2
	this.FKSelNone  = 15; // Tasto annulla selezione SHIFT+F3
	this.FKSelTog   = 16; // Tasto mostra selezione SHIFT+F4
	this.FKDuplicate= 19; // Tasto Duplicate SHIFT+F7
	this.FKCloseForm= 26; // Tasto Close Form CTRL+F2 (perche' CTRL+F4 chiude il browser!)
	this.FKPrint    = 36; // Tasto Print CTRL+F12	
	
	this.DefaultButton = true;            // Pulsante di default per le MsgConfirm e MsgInput: true Yes-Ok, false No-Cancel
	
	// Parametri per le IDCombo
	this.ComboPopupMinHeight = 14;
	this.ComboPopupMaxHeight = 210;
	this.ComboActivatorSize = (RD3_Glb.IsTouch() || RD3_Glb.IsMobile())?24:15;
	this.ComboImageSize = RD3_Glb.IsMobile()?30:16;
	this.ComboNameSeparator = "; ";
	
	// Parametri per la taskbar
	this.TaskMenuAccellCode = 220;        // Keycode tasto da premere con CTRL per aprire il menu' taskbar
	
	// Parametri per la gestione dell'invio dei tasti
	this.KeyPressEventType = RD3_Glb.EVENT_ACTIVE;  // Tipo di gestione dell'evento
	this.DelayTimes.add("keypress", 350);           // Ritardo massimo con cui sono inviati gli eventi al server (solo se IMMEDIATE)

	// Parametri per la gestione del resize
	this.SideMenuResizable = true;  // Permette o meno il resize del menu laterale
	this.SideMenuMinWidth = 120;    // Dimensione minima del menu laterale (quando ridimensionato dall'utente)
	this.DockedMinResize = 100;     // Dimensione minima delle docked (quando ridimensionate dall'utente)
	this.FrameMinimumSize = 50      // Dimensione minima di un Frame (quando ridimensionato dall'utente)
	//
	this.FrameBorderTop = 1;        // Spessore del bordo superiore dei frame
	this.FrameBorderLeft = 1;       // Spessore del bordo sinistro dei frame
	
	// Parametri per la gestione degli eventi touch
	this.TouchMoveLimit = 24; // Distanza in px dopo la quale viene disattivato il click su un oggetto
	this.TouchHLDelay = 300;  // Tempo in ms per cui un tasto viene illuminato quando attivato
	
	// Parametri per la gestione del popup blocker
	this.RedirectWhenBlocked = RD3_Glb.IsTouch()?!window.navigator.standalone:true;
	this.AlertWhenBlocked = true;

  // Indica ogni quanto occorre riprovare a tornare online nel caso di offline di emergenza (sec)
	this.OWAOfflineCheck = 60;
	
	// Se vero, la scrollbar mobile aspetta ontouchup invece che essere istantanea
	this.MobileScrollbarOnTouchUp = true;
	
	// Se vero, attivo il retina
	this.MobileRetina = true;
	
	// Timer (ms) di auto-commit per la voce (se non arriva nulla entro questo tempo, il comando viene inviato al server)
	this.VoiceAutoCommitDelay = 2000;
	
	// Parametri per IDEditor
	this.AutoDefaultFormatting = false;
	this.EditorToolbarIE7Color = "rgb(230, 235, 240)";
	this.EditorHilightIE7Color = "rgb(205, 213, 221)";
	this.EditorPressIE7Color = "rgb(187, 195, 202)";

	//
	this.DefaultActImg = "fa-bars";
	this.DefaultDateActImg = "fa-calendar";

  // Parametri per tipo di contenitore principale
  this.HeaderContainerType = "container-fluid";
  this.BodyContainerType = "container-fluid";

  // Impostazione del gutter tra le colonne
  this.GridGutterLeft = 0;
  this.GridGutterRight = 0;

  // True se vogliamo ricalcolare la grigliatura del pannello quandoun gruppo viene nascosto/mostrato
  this.updateGridAtGroupChange = true;
  
  // Ritardo di invio del MouseOver (ms)
  this.MouseOverDelay = 750;

  // Larghezza minima delle celle per la ricerca in linea
  this.ListQBECellMinWidth = 100;

  // Icone Font Awesome
  this.FA_ICON_TOP = "fa-angle-double-left";       // Icona usata dai book in anteprima - prima pagina
  this.FA_ICON_PREV = "fa-chevron-left";           // Icona usata dalla toolbar di pannelli e book - pagina precedente
  this.FA_ICON_NEXT = "fa-chevron-right";          // Icona usata dalla toolbar di pannelli e book - pagina successiva
  this.FA_ICON_BOTTOM = "fa-angle-double-right";   // Icona usata dai book in anteprima - ultima pagina
  this.FA_ICON_PRINT = "fa-print";                 // Icona usata dalla toolbar di pannelli e book - stampa
  this.FA_ICON_EXPORT = "fa-file-excel-o";         // Icona usata dalla toolbar di pannelli e book - esporta dati
  this.FA_ICON_COMBOACT = "fa-chevron-down";       // attivatore delle combo
  this.FA_ICON_FILTER = "fa-filter";               // icona usata dai filtri avanzati (caption dei campi)
  this.FA_ICON_CAPTMORE = "fa-ellipsis-v";         // icona usata nel caso di modifica layout di lista
  this.FA_ICON_ROWSEL = "fa-arrow-right";          // Icona row selector
  this.FA_ICON_RSERR = "fa-exclamation";           // Row selector: Errore su documento
  this.FA_ICON_RSUPD = "fa-pencil";                // Row selector: Modifica su documento
  this.FA_ICON_RSERRINS = "fa-exclamation";        // Row selector: Errore su documento Inserted
  this.FA_ICON_RSUPDINS = "fa-pencil";             // Row selector: Modifica su documento Inserted
  this.FA_ICON_MULTISEL = "fa-check-square";       // Icona attivazione selezione multipla
  this.FA_ICON_LOCK = "fa-lock";                   // Icona usata dalla toolbar di frame - lock
  this.FA_ICON_UNLOCK = "fa-unlock";               // Icona usata dalla toolbar di frame - unlock
  this.FA_ICON_COLLAPSE = "fa-minus";              // Icona usata dalla toolbar di frame - collassamento
  this.FA_ICON_QBETIP = "fa-question-circle";      // Icona usata dalla toolbar di pannello - qbetip
  this.FA_ICON_PANTOP = "fa-step-backward";        // Icona usata dalla toolbar di pannello - top
  this.FA_ICON_PANBOTTOM = "fa-step-forward";      // Icona usata dalla toolbar di pannello - bottom
  this.FA_ICON_SEARCH = "fa-search";
  this.FA_ICON_FIND = "fa-search";
  this.FA_ICON_LIST = "fa-bars";
  this.FA_ICON_FORM = "fa-th";
  this.FA_ICON_UNDO = "fa-times";
  this.FA_ICON_REFRESH = "fa-refresh";
  this.FA_ICON_DELETE = "fa-trash";
  this.FA_ICON_INSERT = "fa-plus";
  this.FA_ICON_DUPLICATE = "fa-files-o";
  this.FA_ICON_UPDATE = "fa-floppy-o";
  this.FA_ICON_ATTACH = "fa-paperclip";

  this.FA_ICON_BLOBUPLOAD = "fa-upload";             // Icona usata dalla toolbar dei BLOB - upload
  this.FA_ICON_BLOBDELETE = "fa-trash";              // Icona usata dalla toolbar dei BLOB - delete
  this.FA_ICON_BLOBPREVIEW = "fa-search-plus";       // Icona usata dalla toolbar dei BLOB - preview
  this.FA_ICON_SORTASC = "fa-sort-asc";
  this.FA_ICON_SORTDESC = "fa-sort-desc";
  this.FA_ICON_ABORTUPLOAD = "fa-times";             // Icona usata per annullare l'upload di un file - multiupload
  this.FA_ICON_CLOSE = "fa-times";                   // Icona usata per chiudere le videate (modali, popup e MDI)
  this.FA_ICON_TREEEXP = "fa-plus";                  // Icona usata per espandere il nodo di un albero
  this.FA_ICON_TREELOAD = "fa-spinner";              // Icona usata durante il caricamento di un nodo di un albero
  this.FA_ICON_TREECOLL = "fa-minus";                // Icona usata per collassare il nodo di un albero
  this.FA_ICON_LOGOFF = "fa-sign-out";
  this.FA_ICON_DEBUG = "fa-bug";
  this.FA_ICON_HELP = "fa-question";
  this.FA_ICON_CLOSEALL = "fa-times";                // Icona usata dal comando 'chiudi tutte le videate aperte'
  this.FA_ICON_CONFIRM = "fa-check";                 // Icona usata per confermare la chiusura di una videata modale

  // Icone usate dal timepicker
  this.FA_ICON_PICKER_TIME = "fa fa-clock-o";
  this.FA_ICON_PICKER_DATE = "fa fa-calendar";
  this.FA_ICON_PICKER_DATEUP = "fa fa-chevron-up";
  this.FA_ICON_PICKER_DATEDOWN = "fa fa-chevron-down";
  this.FA_ICON_PICKER_DATEPREV = "fa fa-chevron-left";
  this.FA_ICON_PICKER_DATENEXT = "fa fa-chevron-right";
  this.FA_ICON_PICKER_DATETODAY = "fa fa-calendar-check-o";
  this.FA_ICON_PICKER_DATECLEAR = "fa fa-calendar-o";
  this.FA_ICON_PICKER_DATECLOSE = "fa fa-times";

  // Icone usate dall'editor HTML integrato
  this.FA_ICON_EDITOR_BOLD = "fa-bold";
  this.FA_ICON_EDITOR_ITALIC = "fa-italic";
  this.FA_ICON_EDITOR_UNDERLINE = "fa-underline";
  this.FA_ICON_EDITOR_STRIKE = "fa-strikethrough";
  this.FA_ICON_EDITOR_ORDLIST = "fa-list-ol";
  this.FA_ICON_EDITOR_UNORDLIST = "fa-list-ul";
  this.FA_ICON_EDITOR_ALIGNLEFT = "fa-align-left";
  this.FA_ICON_EDITOR_ALIGNCENTER = "fa-align-center";
  this.FA_ICON_EDITOR_ALIGNRIGHT = "fa-align-right";
  this.FA_ICON_EDITOR_ALIGNJUST = "fa-align-justify";
  this.FA_ICON_EDITOR_BACKCOL = "fa-pencil-square";
  this.FA_ICON_EDITOR_COLORPICKER = "fa-chevron-down";
  this.FA_ICON_EDITOR_FORECOL = "fa-font";
  this.FA_ICON_EDITOR_LINK = "fa-link";
  this.FA_ICON_EDITOR_IMAGE = "fa-file-image-o";
  this.FA_ICON_EDITOR_CODE = "fa-code";
  this.FA_ICON_EDITOR_PREVIEW = "fa-list-alt";
}


ClientParams.prototype.GetColorHL1= function()
{
	if (RD3_Glb.IsQuadro())
		return RD3_DesktopManager.WebEntryPoint.AccentColor;
  else if (RD3_Glb.IsMobile7())
		return "rgb(200, 200, 200)";
	else
		return "rgb(5, 140, 245)";
}

ClientParams.prototype.GetColorHL2= function()
{
	if (RD3_Glb.IsQuadro())
		return RD3_DesktopManager.WebEntryPoint.AccentColor;
  else if (RD3_Glb.IsMobile7())
		return "rgb(200, 200, 200)";
	else
		return "rgb(1, 95, 230)";
}

ClientParams.prototype.GetColorMenu1= function()
{
	if (RD3_Glb.IsQuadro())
		return "#777777";
	else
		return "#e8eaed";
}

ClientParams.prototype.GetColorMenu2= function()
{
	if (RD3_Glb.IsQuadro())
		return "#363636";
	else
		return "#c0c4cc";
}

ClientParams.prototype.ZoneUnpinnedSize= function(vertical)
{
  if (RD3_Glb.IsMobile())
  {
    if (vertical)
      return 72;
    else
      return 50;
  }
  else
  {
    return 25;
  }
}