-- drop the DEFAULE linked to ALLOW_PER_TF_METHOD...
DECLARE @constraintName NVARCHAR(128);

SELECT @constraintName = name
FROM sys.default_constraints
WHERE parent_object_id = OBJECT_ID('dbo.QGAP_CONFIGURATION')
AND parent_column_id = (
    SELECT column_id
    FROM sys.columns
    WHERE object_id = OBJECT_ID('dbo.QGAP_CONFIGURATION')
    AND name = 'ALLOW_PER_TF_METHOD'
);

IF @constraintName IS NOT NULL
BEGIN
    EXEC('ALTER TABLE dbo.QGAP_CONFIGURATION DROP CONSTRAINT ' + @constraintName);
END

-- ...FINALLY DROP ALLOW_PER_TF_METHOD
IF EXISTS (SELECT * FROM sys.columns 
           WHERE object_id = OBJECT_ID('dbo.QGAP_CONFIGURATION') 
           AND name = 'ALLOW_PER_TF_METHOD')
BEGIN
    ALTER TABLE QGAP_CONFIGURATION DROP COLUMN ALLOW_PER_TF_METHOD;
END
