ALTER VIEW [dbo].[V_QGAP_PERSONALE_TITOLI] AS
SELECT PA.ID_DIPENDENTE, F.ID_FUNZIONE, C.ID_CESPITE AS ID_TITOLO_FORMATIVO, PA.COGNOME, PA.NOME, F.COD_FUNZIONE, C.COD_CESPITE, 
CASE WHEN
(SELECT ISNULL(CDOreMinime, 0) FROM QGAP_CONFIGURATION) = 0 
THEN ISNULL(dbo.sf_GetIntCustomData(22, ID_CESPITE, (SELECT CDOreMinime FROM QGAP_CONFIGURATION)), 0)
ELSE ISNULL(dbo.sf_GetFloatCustomData(22, ID_CESPITE, (SELECT CDOreMinime FROM QGAP_CONFIGURATION)), 0) END AS OreMinime, 
ISNULL(dbo.sf_GetIntCustomData(22, C.ID_CESPITE, (SELECT CDEntroNGg FROM dbo.QGAP_CONFIGURATION)), 0) AS entroNGiorni,
ISNULL(dbo.sf_GetIntCustomData(22, C.ID_CESPITE, (SELECT CDRicorrenza FROM dbo.QGAP_CONFIGURATION)), 0) AS ricorrenza,
dbo.sf_QGAP_getTipoTitolo(C.ID_CESPITE) AS TipoTitolo, 
dbo.sf_QGAP_getMatchingTitoloIniziale(C.ID_CESPITE,F.ID_FUNZIONE) AS idTitoloIniziale, 
CASE dbo.sf_QGAP_getTipoTitolo(C.ID_CESPITE) 
WHEN -1 THEN 'N/A' 
WHEN 0 THEN 'iniziale'
WHEN 1 THEN 'aggiornamento' 
WHEN 2 THEN 'unico' 
WHEN 3 THEN 'periodico' ELSE 'N/A' END AS TipoTitoloDecoded
FROM dbo.EVA_REFERENCES AS R
INNER JOIN dbo.MSQ_FUNZIONI AS F ON F.ID_FUNZIONE = R.ID_FOR_ALL
INNER JOIN dbo.CES_ANAGRAFICA AS C ON C.ID_CESPITE = R.ID_EVENTO
INNER JOIN dbo.MSQ_PERS_FUNZIONI AS PF ON PF.ID_FUNZIONE = F.ID_FUNZIONE 
INNER JOIN dbo.PER_ANAGRAFICA AS PA ON PA.ID_DIPENDENTE = PF.ID_DIPENDENTE 
WHERE (R.ID_EVA_REFERENCE_TYPES = (SELECT RifTitoloFunzione FROM dbo.QGAP_CONFIGURATION))
AND C.ID_STATO_CESPITE = 1 AND PA.STATO = 1 AND F.ATTIVA = 'Y'
GO
