// ***************************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe WebFrame: rappresenta la base di tutti i frame visuali
// Le istanze di questa classe sono frame che hanno due figli
// cioe' sono dei semplici contenitori
// Tutti i frame visuali estendono questa classe
// ****************************************************************

function WebFrame(pform)
{
  // Proprieta' di questo oggetto di modello
  // Sono le proprieta' base di tutti i frame
  this.Identifier = "";         // Codice della frame (es: "xxx:3:1", dove xxx e' il tipo di oggetto, 
                                // il primo numero e' un frame index e il secondo e' il form index)
  this.Collapsible = true;      // Il frame e' collassabile
  this.Collapsed = false;       // Il frame e' collassato
  this.Lockable = false;        // Il frame gestisce il lock
  this.Locked = false;          // Il frame e' bloccato
  this.Visible = true;          // Il frame e' visibile
  this.Enabled = true;          // Il frame e' abilitato
  this.Image = "";              // Icona da mostrare nella toolbar
  this.Caption = "";            // Titolo del frame (anche HTML)
  this.OrgWidth = 0;            // Larghezza iniziale del frame
  this.OrgHeight = 0;           // Altezza iniziale del frame
  this.Width = 0;               // Larghezza attuale del frame
  this.Height = 0;              // Altezza attuale del frame
  this.MinWidth = 0;            // Larghezza minima del frame
  this.MinHeight = 0;           // Altezza minima del frame
  this.MaxWidth = 9999;         // Larghezza massima del frame
  this.MaxHeight = 9999;        // Altezza massima del frame
  this.Vertical = false;        // Disposizione verticale?
  this.ShowToolbar = true;      // Il frame mostra la toolbar?
  this.ShowStatusBar = true;    // Il frame mostra la status bar?
  this.Scrollbar = 3;           // Quali scrollbar devono essere mostrate? (default RD3_Glb.FORMSCROLL_BOTH)
  this.SmallIcons = false;      // Usare icone piccole nella toolbar?
  this.OnlyContent = false;     // Mostrare solo contenuto senza toolbar ne bordi?
  this.CanDrag = false;         // Questo frame puo' effettuare drag?
  this.CanDrop = false;         // Questo frame puo' effettuare drop?
  this.HandledKeys = 0;         // Tasti da intercettare a livello di frame
  this.FrameBorder = false;     // Mostrare il bordo tra i due frame?
  //this.ClassName = null;      // Classe specifica da applicare al frame
  //
  // Oggetti secondari gestiti da questo oggetto di modello
  this.ChildFrame1 = null; // Primo frame che suddivide questo
  this.ChildFrame2 = null; // Secondo frame che suddivide questo
  //  
  // Altre variabili legate al frame
  this.WebForm = pform;                 // Form Padre
  this.ParentFrame = null;              // Frame padre
  this.ParentTab = null;                // Tab in cui e' contenuto questo frame
  this.IsPreview = false;               // Frame in preview?
  //
  // Struttura per la definizione delle caratteristiche degli eventi di questo frame : da ridefinire in tutte le classi
  if (RD3_Glb)
  {
    // Il click sul collapse deve essere gestito lato client o lato server, asincrono o sincrono
    this.CollapseEventDef = RD3_Glb.EVENT_ACTIVE;
    //
    // Definizione eventi di mouse
    this.MouseClickEventDef = RD3_Glb.EVENT_CLIENTSIDE;
    this.MouseDoubleClickEventDef = RD3_Glb.EVENT_CLIENTSIDE;
  }
  //
  // Variabili di collegamento con il DOM
  this.Realized = false;     // Se vero, gli oggetti del DOM sono gia' stati creati
  this.RecalcLayout = false; // Se vero, al termine della richiesta verra' adattato il layout
  this.SendResize = false;   // Il recalc layout deve lanciare evento di resize?
  this.DeltaW = 0;           // Tracciano di quanto il frame si sta ridimensionando
  this.DeltaH = 0;           // Tracciano di quanto il frame si sta ridimensionando
  this.TBScrollTimer = 0;    // Timer per lo scrolling della toolbar
  this.TBScrollDir = 0;      // 1 dx, -1 sx
  //this.AlreadyResized = false;  // E' stato fatto o meno il primo resize?
  //
  this.Collapsing = false;    // Sto eseguendo una animazione di collassamento?
  this.CollapsingHeight = 0;  // Altezza attuale di collassamento
  //
  // Oggetti visuali riguardanti la form
  this.FrameBox = null;    // Div globale del frame: contiene tutta la form ed i suoi figli
  this.ToolbarBox = null;  // Div che contiene la toolbar
  this.TBScrollDx = null;  // Div che contiene l'indicazione di scrolling per la toolbarbox (appare se la toolbar ha lo scrollwidth>clientwidth)
  this.TBScrollSx = null;  // Div che contiene l'indicazione di scrolling per la toolbarbox (appare se la toolbar ha lo scrollwidth>clientwidth)
  this.ContentBox = null;  // Div che contiene il contenuto del frame
  //
  // Oggetti visuali relativi alla Toolbar
  this.CollapseButton = null;   // Immagine che contiene il pulsante del collassamento
  this.LockButton = null;       // Immagine rappresentante il pulsante di Lock
  this.SearchBox = null;        // Edit Box di ricerca
  this.IconImg = null;          // Immagine contenente l'icona del frame
  this.CaptionTxt = null;       // Testo della Caption (Span)
  //
  this.ChildBox1 = null;   // Box per il primo frame
  this.ChildBox2 = null;   // Box per il secondo frame
  //
  this.InResponse = false;  // Sto gestendo il messaggio dal server?
  //
  this.MD_XPos = 0; // Coordinata evento mouse down
  this.MD_YPos = 0; // Coordinata evento mouse down
  this.MD_Time = 0; // Istante evento mouse down
  this.MD_Button = 0; // Bottone premuto
  this.MD_Target = null; // Oggetto sorgente
  this.MD_Clicked = false; // Gia' cliccato?
  //
  this.IDScroll = null; // Oggetto scroller
  //
  this.ParentFrameIdentifier = "";  // ID del frame padre, valorizzato solo nel caso di SubPanel e SubForm contenute in Campi Statici
}


// *******************************************************************
// Inizializza questo WebFrame leggendo i dati da un nodo <wfr> XML
// *******************************************************************
WebFrame.prototype.LoadFromXml = function(node) 
{
  // Inizializzo le proprieta' locali
  this.LoadProperties(node);
  //
  // Carico gli elementi custom
  var objlist = node.childNodes;
  var n = objlist.length;
  //
  // Ciclo su tutti i nodi che rappresentano oggetti figli
  for (var i = 0; i < n; i++)
  {
    var objnode = objlist.item(i);
    var nome = objnode.nodeName;
    switch (nome)
    {
      case "cse":
        {
          var cls = objnode.getAttribute("cls");
          if (!window[cls])
            console.error("class " + cls + " not found");
          else
          {
            this.Content = CustomElement.createByName(cls, this);
            this.Content.LoadFromXml(objnode);
          }
        }
        break;
    }
  }
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
WebFrame.prototype.ChangeProperties = function(node)
{
  // Semplicemente setto le proprieta' a partire dal nodo
  this.LoadProperties(node);
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
WebFrame.prototype.LoadProperties = function(node)
{
  // Certifico che sto gestendo la risposta dal server
  this.InResponse = true;
  //
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
      case "clp": this.SetCollapsible(valore=="1"); break;
      case "col": this.SetCollapsed(valore=="1"); break;
      case "lkb": this.SetLockable(valore=="1"); break;
      case "lok": this.SetLocked(valore=="1"); break;
      case "vis": this.SetVisible(valore=="1"); break;
      case "ena": this.SetEnabled(valore=="1"); break;
      case "img": this.SetImage(valore); break;      
      case "cap": this.SetCaption(valore); break;
      case "wid": this.SetWidth(parseInt(valore)); break;
      case "hei": this.SetHeight(parseInt(valore)); break;
      case "miw": this.SetMinWidth(parseInt(valore)); break;
      case "mih": this.SetMinHeight(parseInt(valore)); break;
      case "maw": this.SetMaxWidth(parseInt(valore)); break;
      case "mah": this.SetMaxHeight(parseInt(valore)); break;
      case "orw": this.SetOrgWidth(parseInt(valore)); break;
      case "orh": this.SetOrgHeight(parseInt(valore)); break;
      case "ver": this.SetVertical(valore=="1"); break;
      case "stb": this.SetShowToolbar(valore=="1"); break;
      case "ssb": this.SetShowStatusBar(valore=="1"); break;
      case "scr": this.SetScrollbar(parseInt(valore)); break;
      case "smi": this.SetSmallIcon(valore=="1"); break;
      case "ocn": this.SetOnlyContent(valore=="1"); break;
      case "fr1": this.SetChildFrame1(valore); break;
      case "fr2": this.SetChildFrame2(valore); break;
      case "dra": this.SetCanDrag(valore=="1"); break;
      case "dro": this.SetCanDrop(valore=="1"); break;
      case "hks": this.SetHandledKeys(parseInt(valore)); break;
      case "dcl": this.DeleteFrame(valore); break;
      case "frb": this.SetFrameBorder(valore=="1"); break;
      case "cln": this.SetClassName(valore); break;
      
      case "clc": this.CollapseEventDef = parseInt(valore); break;
      case "mck": this.MouseClickEventDef = parseInt(valore); break;
      case "mdk": this.MouseDoubleClickEventDef = parseInt(valore); break;
      
      case "cla": this.CollapseAnimDef = valore; break;

      case "guid": this.SetGUID(valore); break;
      
      case "id": 
        this.Identifier = valore;
        RD3_DesktopManager.ObjectMap.add(valore, this);
      break;
    }
  }
  //
  this.InResponse = false;
}

/**
 * Imposta il GUID del frame
 */
WebFrame.prototype.SetGUID = function(guid) {
  this.Guid = guid;
};


// *******************************************************************
// Setter delle proprieta'
// *******************************************************************
WebFrame.prototype.SetCollapsible= function(value) 
{
  if (value!=undefined)
    this.Collapsible = value;
  //  
  if (this.Realized)
  {
    // Se e' contenuto in una tabbed, non e' collassabile
    var cancoll = this.Collapsible;
    if (this.ParentFrame && this.ParentFrame instanceof TabbedView)
      cancoll = false;
    //
    if (cancoll)
      this.ToolbarButtonGroup1.appendChild(this.CollapseButton);
    else if (this.CollapseButton.parentNode)
      this.CollapseButton.parentNode.removeChild(this.CollapseButton);
  }
}

WebFrame.prototype.SetCollapsed= function(value, immediate) 
{
  var old = this.Collapsed;
  //
  if (value!=undefined)
    this.Collapsed = value;
  //
  if (this.Realized && (old!=this.Collapsed || value==undefined))
  {
    // Il collapse ha senso solo per un frame contenuto
    if (!this.ChildBox1 && !this.ChildBox2)
      $(this.ContentBox).collapse(this.Collapsed ? "hide" : "show");
  }
}

WebFrame.prototype.SetLockable= function(value) 
{
  if (value!=undefined)
    this.Lockable = value;
  //
  if (this.Realized && this.LockButton) {
    if (this.Lockable && !this.Collapsed)
      this.ToolbarButtonGroup1.appendChild(this.LockButton);
    else if (this.LockButton.parentNode)
      this.LockButton.parentNode.removeChild(this.LockButton);
  }
}

WebFrame.prototype.SetLocked= function(value) 
{
  if (value!=undefined)
    this.Locked = value;
  //
  if (this.Realized && this.LockButton) {
    if (this.LockButton.firstChild)
      this.LockButton.removeChild(this.LockButton.firstChild);
    this.LockButton.appendChild(this.Locked ? RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_LOCK) : RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_UNLOCK));
    //
    // Imposto il tooltip corretto per il pulsante locked
    if (this.Locked)
      RD3_TooltipManager.SetObjTitle(this.LockButton, RD3_ServerParams.TooltipUnlock + RD3_KBManager.GetFKTip(RD3_ClientParams.FKLocked));
    else
      RD3_TooltipManager.SetObjTitle(this.LockButton, RD3_ServerParams.TooltipLock + RD3_KBManager.GetFKTip(RD3_ClientParams.FKLocked));
  }
}

WebFrame.prototype.SetVisible= function(value) 
{
  var old = this.Visible;
  //
  if (value!=undefined)
    this.Visible = value;
  //
  if (this.Realized)
  {
    if (this.Visible)
    {
      this.FrameBox.style.display = "";
      this.RecalcLayout = true;
      //
      // il cambio di visibilita' deve far ricalcolare anche la visibilita' dei commandset e delle toolbar
      if (!old)
        this.WebForm.RecalcCommands = true;
    }
    else
    {
      this.FrameBox.style.display = "none";
    }
    //
    // Avverto la form del cambiamento in modo da far riposizionare i frame: se sono invisibile il mio spazio deve 
    // essere mangiato.
    if (this.WebForm.Realized && old!=this.Visible)
      this.WebForm.RecalcGridLayout = true;
  }
  //
  // Se sono in una Tab devo nascondere anche quella
  if (this.ParentTab && this.ParentTab.Realized)
      this.ParentTab.SetVisible(this.Visible);
}

WebFrame.prototype.SetEnabled= function(value) 
{
  if (value!=undefined)
    this.Enabled = value;
  //
  // Sovrascritta nelle classi derivate
}

WebFrame.prototype.SetImage= function(value) 
{
  if (value!=undefined)
    this.Image = value;
  //
  if (this.Realized) {
    if (!this.ChildBox1 && !this.ChildBox2) {
      if (this.Image == "") {
        // Nascondo l'icona
        this.IconImg.style.display = "none";
      }
      else {
        this.IconImg.src = RD3_Glb.GetImgSrc("images/" + this.Image);
        this.IconImg.style.display = "";
      }
    }
  }
}

WebFrame.prototype.SetCaption= function(value) 
{
  if (value!=undefined)
    this.Caption = value;
  //
  if (this.Realized)
  {
    if (!this.ChildBox1 && !this.ChildBox2)
    {
      this.CaptionTxt.innerHTML = RD3_Glb.HandleIconString(this.Caption);
      //
      // Se la caption non finisce per : e non e' stringa vuota allora aggiungo i :
      if (this.Caption != "" && this.Caption.substr(this.Caption.length-1,1) != ":" && !this.Collapsed && this.ShowStatusBar && !(this instanceof Tree))
        this.CaptionTxt.innerHTML += ":";
      //
      // Chrome fa casino con gli span vuoti, meglio nasconderlo
      if (RD3_Glb.IsChrome())
        this.CaptionTxt.style.display = (this.Caption == "" ? "none" : "");
    }
  }
}

WebFrame.prototype.SetWidth= function(value)
{
  if (value!=undefined)
    this.Width = (value<0) ? 0 : value;
  //
  if (this.Realized)
  {
    // Se la richiesta di modifica dimensioni proviene dal server mi devo ricordare di adattare il layout della form
    if (this.InResponse && this.WebForm)
      this.WebForm.RecalcGridLayout = true;
  }
}

WebFrame.prototype.SetHeight= function(value)
{
  if (value!=undefined)
    this.Height = (value<0) ? 0 : value;
  //
  if (this.Realized)
  {
    // Se la richiesta di modifica dimensioni proviene dal server mi devo ricordare di adattare il layout della form
    if (this.InResponse && this.WebForm)
      this.WebForm.RecalcGridLayout = true;
  }
}


WebFrame.prototype.SetOrgHeight= function(value) 
{
  this.OrgHeight = value;
}


WebFrame.prototype.SetOrgWidth= function(value) 
{
  this.OrgWidth = value;
}


WebFrame.prototype.SetMinWidth= function(value) 
{
  if (value!=undefined)
    this.MinWidth = value;
  //
  if (this.Realized) {
    if (!this.ChildFrame1 && this.FrameBox)
        this.FrameBox.style.minWidth = this.MinWidth <=0 ? "" : this.MinWidth + "px";
    this.WebForm.RecalcGridLayout = true;
  }
}

WebFrame.prototype.SetMaxWidth= function(value) 
{
  if (value!=undefined)
    this.MaxWidth = value;
  //
  if (this.Realized) {
    if (!this.ChildFrame1 && this.FrameBox)
      this.FrameBox.style.maxWidth = this.MaxWidth <=0 ? "" : this.MaxWidth + "px";
    this.WebForm.RecalcGridLayout = true;
  }
}

WebFrame.prototype.SetMinHeight= function(value) 
{
  if (value!=undefined)
    this.MinHeight = value;
  //
  if (this.Realized) {
    if (!this.ChildFrame1 && this.FrameBox)
      this.FrameBox.style.minHeight = this.MinHeight <=0 ? "" :  this.MinHeight + "px";
    this.WebForm.RecalcGridLayout = true;
  }
}

WebFrame.prototype.SetMaxHeight= function(value) 
{
  if (value!=undefined)
    this.MaxHeight = value;
  //
  if (this.Realized) {
    if (!this.ChildFrame1 && this.FrameBox)
      this.FrameBox.style.maxHeight = this.MaxHeight <=0 ? "" :  this.MaxHeight + "px";
    this.WebForm.RecalcGridLayout = true;
  }
}

WebFrame.prototype.SetVertical= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  if (value!=undefined)
    this.Vertical = value;
}

WebFrame.prototype.SetShowToolbar= function(value) 
{
  if (value!=undefined)
    this.ShowToolbar = value;
  //
  // Non devo fare niente: verra' ridefinita dalle classi derivate
}

WebFrame.prototype.SetShowStatusBar= function(value) 
{
  if (value!=undefined)
    this.ShowStatusBar = value;
  //
  // Sovrascritta nelle classi derivate
}

WebFrame.prototype.SetScrollbar= function(value) 
{
  if (value!=undefined)
    this.Scrollbar = value;
  //
  if (this.Realized)
  {
    // Assegno i valori giusti di overflow a seconda dell'impostazione
    if (this.ContentBox)
    {
      var ofx = "";
      var ofy = "";
      //
      switch(this.Scrollbar)
      {
        case RD3_Glb.FORMSCROLL_NONE : 
        {
          ofx = "hidden";
          ofy = "hidden";
        }
        break;
        
        case RD3_Glb.FORMSCROLL_HORIZ : 
        {
          ofx = "auto";
          ofy = "hidden";
        }
        break;
        
        case RD3_Glb.FORMSCROLL_VERT : 
        {
          ofx = "hidden";
          ofy = "auto";
        }
        break;
        
        case RD3_Glb.FORMSCROLL_BOTH : 
        {
          ofx = "auto";
          ofy = "auto";
        }
        break;
      }
      //
      this.ContentBox.style.overflowX = ofx;
      this.ContentBox.style.overflowY = ofy;
    }
  }
}

WebFrame.prototype.SetSmallIcon= function(value) 
{
  if (value!=undefined)
    this.SmallIcons = value;
  //
  if (this.Realized)
  {
    if (!this.ChildBox1 && !this.ChildBox2)
    {
      if (this.SmallIcons) {
       RD3_Glb.RemoveClass(this.ToolbarButtonGroup1, "btn-group-md");
       RD3_Glb.AddClass(this.ToolbarButtonGroup1, "btn-group-xs");
      }
      else {
        RD3_Glb.RemoveClass(this.ToolbarButtonGroup1, "btn-group-xs");
        RD3_Glb.AddClass(this.ToolbarButtonGroup1, "btn-group-md");
      }
    }
  }
}

WebFrame.prototype.SetOnlyContent= function(value) 
{
  if (value!=undefined)
    this.OnlyContent = value;
  //
  if (this.Realized) {
    if (!this.ChildBox1 && !this.ChildBox2) {
      if (this.OnlyContent)
        this.ToolbarBox.style.display = "none";
      else
        this.ToolbarBox.style.display = "";
    }
  }
}

WebFrame.prototype.SetChildFrame1= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  if (value!=undefined)
    this.ChildFrame1 = value; // All'inizio e' una stringa, poi diventera' un oggetto
}

WebFrame.prototype.SetChildFrame2= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  if (value!=undefined)
    this.ChildFrame2 = value; // All'inizio e' una stringa, poi diventera' un oggetto
}

WebFrame.prototype.SetCanDrag= function(value) 
{
  // Devo solo cambiare il valore...
  if (value!=undefined)
    this.CanDrag = value;
}

WebFrame.prototype.SetCanDrop= function(value) 
{
  // Devo solo cambiare il valore...
  if (value!=undefined)
    this.CanDrop = value;
}


// ******************************************************
// Setter dei tasti intercettati dalla form
// ******************************************************
WebFrame.prototype.SetHandledKeys = function(value)
{
  if (value!=undefined)
    this.HandledKeys = value;
  //
  // Questa proprieta' non puo' variare dopo essere stata inviata, e viene gestita
  // nel KBManager
}


WebFrame.prototype.SetFrameBorder = function(value)
{
  if (value!=undefined)
    this.FrameBorder = value;
  //
  // Questa proprieta' non puo' variare dopo essere stata inviata
}


WebFrame.prototype.SetClassName = function(value)
{
  var old = this.ClassName;
  if (value!=undefined) {
    this.ClassName = value;
    //
    if (this.ClassName && this.ClassName.indexOf("{{") != -1 && this.ClassName.indexOf("}}") != -1) {
      // L'utente ha impostato una classe per la cella bootstrap, la estraggo
      var begin = this.ClassName.indexOf("{{");
      var end = this.ClassName.indexOf("}}", begin + 2);
      this.BootstrapCellClass = this.ClassName.substring(begin + 2, end);
      //
      // Rimuovo la stringa dalla classe
      this.ClassName = this.ClassName.substring(0, begin) + this.ClassName.substring(end + 2);
    }
  }
  //
  if (this.Realized && this.FrameBox && (old != this.ClassName || value == undefined))
  {
    // Se c'e' un vecchio valore lo rimuovo, poi se ce n'e' uno nuovo lo aggiungo.
    // in questo modo posso gestire correttamente il cambio da classe "a" -> ""
    if (old)
      RD3_Glb.RemoveClass(this.FrameBox, old);
    if (this.ClassName)
      RD3_Glb.AddClass(this.FrameBox, this.ClassName);
  }
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
WebFrame.prototype.Realize = function(parent)
{
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    if (this.Vertical) {
      this.ChildRow1 = document.createElement("div");
      this.ChildRow1.className = "row frame-row";
      //
      this.ChildRow2 = document.createElement("div");
      this.ChildRow2.className = "row frame-row";
      //
      this.ChildBox1 = document.createElement("div");
      this.ChildBox1.setAttribute("id", this.Identifier+":f1");
      this.ChildBox1.className = "col-xs-12 col-sm-12 col-md-12 frame-column frame-vertical-row";
      this.ChildRow1.appendChild(this.ChildBox1);
      //
      this.ChildBox2 = document.createElement("div");
      this.ChildBox2.setAttribute("id", this.Identifier+":f2");
      this.ChildBox2.className = "col-xs-12 col-sm-12 col-md-12 frame-column frame-vertical-row";
      this.ChildRow2.appendChild(this.ChildBox2);
      //
      parent.appendChild(this.ChildRow1);
      parent.appendChild(this.ChildRow2);
    }
    else {
      this.ChildRow = document.createElement("div");
      this.ChildRow.className = "row frame-row";
      //
      this.ChildBox1 = document.createElement("div");
      this.ChildBox1.setAttribute("id", this.Identifier+":f1");
      this.ChildBox1.className = "col-md-6 frame-column";
      this.ChildRow.appendChild(this.ChildBox1);
      //
      this.ChildBox2 = document.createElement("div");
      this.ChildBox2.setAttribute("id", this.Identifier+":f2");
      this.ChildBox2.className = "col-md-6 frame-column";
      this.ChildRow.appendChild(this.ChildBox2);
      //
      parent.appendChild(this.ChildRow);
    }
    //
    // Realizzo i frame secondari
    this.ChildFrame1.Realize(this.ChildBox1);
    this.ChildFrame2.Realize(this.ChildBox2);
    //
    // Mi assegno come padre dei miei figli
    this.ChildFrame1.ParentFrame = this;
    this.ChildFrame2.ParentFrame = this;
    //
    this.Realized = true;
  }
  else
  {
    // Realizzo i miei oggetti visuali
    // Creo il mio contenitore globale
    this.FrameRow = document.createElement("div");
    this.FrameRow.setAttribute("id", this.Identifier + "_fr");
    this.FrameRow.className = "row frame-row";
    //
    this.FrameCol = document.createElement("div");
    this.FrameCol.className = "col-md-12 frame-column";
    //
    this.FrameBox = document.createElement("div");
    this.FrameBox.setAttribute("id", this.Identifier);
    this.FrameBox.className = "panel panel-default";
    this.FrameBox.className += (this.WebForm.ResModeH !== RD3_Glb.FRESMODE_NONE || (this instanceof IDPanel && this.ParentFrameIdentifier)) ? " frame-box-fixed" : " frame-box-fluid";
    if (this.Guid)
      this.FrameBox.setAttribute("guid", this.Guid);
    //
    if (RD3_Glb.IsTouch()) {
      this.FrameBox.addEventListener("touchstart", function (ev) { this.OnTouchDown(ev); }.bind(this), true);
      this.FrameBox.addEventListener("touchmove",  function (ev) { this.OnTouchMove(ev); }.bind(this), true);
      this.FrameBox.addEventListener("touchend",   function (ev) { this.OnTouchUp(ev); }.bind(this), true);
    } else {
      this.FrameBox.onmousedown = this.OnMouseDown.bind(this);
      this.FrameBox.onmouseup = this.OnMouseUp.bind(this);
    }
    //
    // Realizzo la Toolbar
    this.RealizeToolbar();
    //
    this.ContentBox = document.createElement("div");
    this.ContentBox.setAttribute("id", this.Identifier+":cnt");
    this.ContentBox.className = "panel-body collapse in frame-content-box";
     //
    this.FrameBox.appendChild(this.ToolbarBox);
    this.FrameBox.appendChild(this.ContentBox);
    //
    this.FrameCol.appendChild(this.FrameBox);
    this.FrameRow.appendChild(this.FrameCol);
    parent.appendChild(this.FrameRow);
    //
    // Aggancio gli eventi per sentire il collassamento su bootsrap
    var _this = this;
    $(this.ContentBox).on("hidden.bs.collapse", function (ev) {
      // Se hai un gruppo collassabile contenuto in un pannello collassabile quando collassi il gruppo Bootstrap 
      // fa scattare anche questo evento (errore), in quel caso non dobbiamo fare nulla.
      // Lo scopriamo guardando chi ha lanciato l'evento
      if (ev.target !== _this.ContentBox)
        return;
      //
      var eve = new IDEvent("col", _this.Identifier, ev, _this.CollapseEventDef, "col");
      _this.Collapsed = true;
      //
      // Se il ridimensionamento e' NONE basta quello che fa bootstrap, altrimenti
      // devo anche reimpostare la grigliatura tenendo conto della nuova altezza
      if (_this.WebForm.ResModeH !== RD3_Glb.FRESMODE_NONE)
        _this.WebForm.RecalcGridLayout = true;
      //
      _this.FrameBox.style.overflow = "hidden";
    });
    $(this.ContentBox).on("shown.bs.collapse", function (ev) {
      // Se hai un gruppo collassabile contenuto in un pannello collassabile quando collassi il gruppo Bootstrap 
      // fa scattare anche questo evento (errore), in quel caso non dobbiamo fare nulla.
      // Lo scopriamo guardando chi ha lanciato l'evento
      if (ev.target !== _this.ContentBox)
        return;
      //
      var ev = new IDEvent("col", _this.Identifier, ev, _this.CollapseEventDef, "exp");
      _this.Collapsed = false;
      //
      // Se il ridimensionamento e' NONE basta quello che fa bootstrap, altrimenti
      // devo anche reimpostare la grigliatura tenendo conto della nuova altezza
      if (_this.WebForm.ResModeH !== RD3_Glb.FRESMODE_NONE)
        _this.WebForm.RecalcGridLayout = true;
      //
      _this.FrameBox.style.overflow = "";
    });
    //
    // Eseguo l'impostazione iniziale delle mie proprieta' (quelle che cambiano l'aspetto visuale)
    this.Realized = true;
    this.SetSmallIcon();
    this.SetCollapsible();
    this.SetCollapsed();
    this.SetLockable();
    this.SetLocked();
    this.SetVisible();
    this.SetEnabled();
    this.SetImage();  
    this.SetCaption();
    this.SetShowToolbar();
    this.SetShowStatusBar();
    this.SetScrollbar();
    this.SetOnlyContent();
    //
    this.SetHeight();
    this.SetMaxHeight();
    this.SetMinHeight();
    //
    this.SetMaxWidth();
    this.SetMinWidth();
    this.SetClassName();
    //
    if (this.Content)
      this.Content.Realize(this.ContentBox);
  }
}


// ***************************************************************
// Crea gli oggetti DOM relativi alla Toolbar
// ***************************************************************
WebFrame.prototype.RealizeToolbar = function()
{
  // Creo il contenitore esterno della toolbar
  this.ToolbarBox = document.createElement("div");
  this.ToolbarBox.setAttribute("id", "tl:" + this.Identifier);
  this.ToolbarBox.className = "panel-heading frame-toolbar-box";
  //
  // Creo il gruppo di pulsanti del frame
  this.ToolbarButtonGroup1 = document.createElement("div");
  this.ToolbarButtonGroup1.className = "btn-group";
  //
  // Creo il pulsante di collassamento
  this.CollapseButton = document.createElement("button");
  this.CollapseButton.setAttribute("id", this.Identifier+":collapse");
  if (!this.IsPreview) {
    this.CollapseButton.setAttribute("data-toggle", "collapse");
    this.CollapseButton.setAttribute("data-target", RD3_Glb.escapeID("#"+this.Identifier+":cnt"));
  }
  else {
    var pthis = this;
    this.CollapseButton.onclick = function () {
      var ev = new IDEvent("col", pthis.Identifier, null, pthis.CollapseEventDef, "col");
      pthis.WebForm.ClosePreview();
    }
  }
  this.CollapseButton.className = "btn btn-default";
  this.CollapseButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_COLLAPSE));
  //
  // Creo il pulsante di lock
  this.LockButton = document.createElement("button");
  this.LockButton.setAttribute("id", this.Identifier+":lock");
  this.LockButton.className = "btn btn-default";
  this.LockButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_LOCK));
  //
  // Creo l'immagine relativa all'cona
  this.IconImg = document.createElement("img");
  this.IconImg.className = "frame-toolbar-icon";
  //
  // Creo lo span relativo alla caption
  this.CaptionTxt = document.createElement("span");
  this.CaptionTxt.setAttribute("id", this.Identifier+":caption");
  this.CaptionTxt.className = (this.SmallIcons ? "frame-toolbarsmall-caption" : "frame-toolbar-caption");
  //
  var _this = this;
  this.LockButton.onclick = function(ev) {
    _this.OnLockClick(ev);
  };
  //
  // Inserisco gli elementi nel DOM
  this.ToolbarButtonGroup1.appendChild(this.CollapseButton);
  this.ToolbarButtonGroup1.appendChild(this.LockButton);
  this.ToolbarBox.appendChild(this.ToolbarButtonGroup1);
  this.ToolbarBox.appendChild(this.IconImg);
  this.ToolbarBox.appendChild(this.CaptionTxt);
  this.FrameBox.appendChild(this.ToolbarBox);
}

// ********************************************************************************
// Gestore eventi di mouse su un pulsante della Toolbar di frame
// Il parametro deve valere "" per bottone senza effetti, "hover" per highlight
// e "down" per effetto cliccato
// ********************************************************************************
WebFrame.prototype.OnToolMouseUse = function(evento, parametro)
{
}

// ********************************************************************************
// Il mouse e' stato mosso sulla toolbar 
// ********************************************************************************
WebFrame.prototype.OnScrollToolbar = function(evento)
{
}

// ********************************************************************************
// Effettuo scrolling della toolbar
// ********************************************************************************
WebFrame.prototype.ScrollingToolbar = function()
{
}


// ********************************************************************************
// Inizio lo scrolling
// ********************************************************************************
WebFrame.prototype.ScrollToolbar = function(dir)
{
}


// ********************************************************************************
// Calcola le dimensioni dei div in base alla dimensione del contenuto
// ********************************************************************************
WebFrame.prototype.AdaptLayout = function()
{
  if (this.Content)
    this.Content.AdaptLayout();
  //
  this.RecalcLayout = false;
}


// ********************************************************************************
// Posiziona e mostra lo scrollbox se necessario
// ********************************************************************************
WebFrame.prototype.AdaptScrollBox = function()
{
}


// ********************************************************************************
// Il resize deve essere mandato immediatamente al server?
// ********************************************************************************
WebFrame.prototype.IsResizeImmediate = function()
{
  return false; 
}

// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
WebFrame.prototype.Unrealize = function()
{ 
  // Ridefinire anche nelle classi figlie
  //
  // Rimuovo il mio frame dal DOM
  if (this.FrameBox && this.FrameBox.parentNode)
    this.FrameBox.parentNode.removeChild(this.FrameBox);
  if (this.FrameRow && this.FrameRow.parentNode)
    this.FrameRow.parentNode.removeChild(this.FrameRow);
  if (this.ChildRow1 && this.ChildRow1.parentNode)
    this.ChildRow1.parentNode.removeChild(this.ChildRow1);
  if (this.ChildRow2 && this.ChildRow2.parentNode)
    this.ChildRow2.parentNode.removeChild(this.ChildRow2);
  if (this.ChildRow && this.ChildRow.parentNode)
    this.ChildRow.parentNode.removeChild(this.ChildRow);
  //
  // Passo il messaggio ai miei figli
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    this.ChildFrame1.Unrealize();
    this.ChildFrame2.Unrealize();
  }
  else if (this.Content)
    this.Content.Unrealize();
  //
  // Mi rimuovo dalla mappa
  RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  //
  this.ScrollToolbar(0);
  //
  if (this.IDScroll)
    this.IDScroll.Unrealize();
  //
  // Annullo i riferimenti al DOM
  this.FrameBox = null;
  this.ToolbarBox = null;
  this.ContentBox = null;
  this.CollapseButton = null;
  this.IconImg = null;   
  this.CaptionTxt = null;
  this.ChildBox1 = null;
  this.ChildBox2 = null;
  this.FrameRow = null;
  this.ChildRow1 = null;
  this.ChildRow2 = null;
  this.ChildRow = null;
  //
  this.Realized = false;
  this.RealizeDone = false;
}


// ********************************************************************************
// Gestore evento di mouse over sul pulsante Collapse della Toolbar
// ********************************************************************************
WebFrame.prototype.OnCollapseMouseOver= function(evento)
{
}


// ********************************************************************************
// Gestore evento di mouse out sul pulsante Collapse della Toolbar
// ********************************************************************************
WebFrame.prototype.OnCollapseMouseOut= function(evento)
{
}


// ********************************************************************************
// Gestore evento di click sul pulsante Collapse della Toolbar
// ********************************************************************************
WebFrame.prototype.OnCollapseClick= function(evento)
{ 
  var ev = new IDEvent("col", this.Identifier, evento, this.CollapseEventDef, this.Collapsed ? "exp" : "col");
  if (ev.ClientSide)
  {
    this.CollapseButton.focus();
    //
    // L'esecuzione locale di un evento di collapse fa collassare o meno il frame
    this.SetCollapsed(!this.Collapsed, true);
  }
}


// ********************************************************************************
// Devo gestire le variazioni avvenute
// ********************************************************************************
WebFrame.prototype.AfterProcessResponse= function()
{ 
  // Non devo fare l'adapting qui durante l'animazione di resize della popup!
  if (this.RecalcLayout && !this.WebForm.PopupResAnimating)
    this.AdaptLayout();
  //
  if (this.SkippedSendResize && this.IsFrameVisible()) 
  {
    this.OnViewportResize();
    delete this.SkippedSendResize;
  }
  //
  // CustomElement
  if (this.Content && this.Content.AfterProcessResponse)
    this.Content.AfterProcessResponse();
}


// ********************************************************************************
// La classe base non esegue alcun settaggio di focus
// ********************************************************************************
WebFrame.prototype.Focus= function()
{ 
  return false;
}

// ********************************************************************************
// Tutti i webframe generici possono ricevere il fuoco tramite navigazione da 
// tastiera (pero' poi lo accettano o rifiutano in base alla loro logica specifica)
// ********************************************************************************
WebFrame.prototype.HandlesTabFocus = function()
{
  return true;
}

// ********************************************************************************
// Metodi di utilita' per gestire il resize forzato
// ********************************************************************************
WebFrame.prototype.RequestResize = function()
{
}

WebFrame.prototype.ClearRequestResize = function()
{
}

// ********************************************************************************
// Ridimensiona il frame come richiesto
// ********************************************************************************
WebFrame.prototype.Resize = function(w, h)
{
}


// ********************************************************************************
// Calcola la larghezza di questo frame tenendo conto della sua visibilita'
// ********************************************************************************
WebFrame.prototype.CalcWidth = function()
{
  // Se non sono realizzato o sono nascosto la mia larghezza e' 0
  if (!this.Realized || !this.Visible)
    return 0;
  //
  // Se ho due figli chiedo a loro la dimensione
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    if (!this.Vertical)
    {
      return this.ChildFrame1.CalcWidth() + this.ChildFrame2.CalcWidth();
    }
    else
    {
      var c1 = this.ChildFrame1.CalcWidth();
      var c2 = this.ChildFrame2.CalcWidth();
      return (c1 > c2) ? c1 : c2;
    }
  }
  else
  {
    // Altrimenti restituisco la mia larghezza
    // la larghezza viene usata solo per calcolare la colonnatura, in questo caso faccio i calcoli sempre partendo dal design time,
    // cosi' il risultato e' sempre lo stesso
    return this.OrgWidth;
  }
}


// ********************************************************************************
// Calcola l'altezza di questo frame tenendo conto della sua visibilita'
// e del suo collassamento
// @realHeight - true se voglio l'altezza attuale, altriment usa l'altezza originaria
// ********************************************************************************
WebFrame.prototype.CalcHeight = function(realHeight)
{
  // Se non sono realizzato o sono nascosto la mia altezza e' 0
  if (!this.Realized || !this.Visible)
    return 0;
  //
  // Se ho due figli chiedo a loro la dimensione
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    if (this.Vertical) {
        return this.ChildFrame1.CalcHeight(realHeight) + this.ChildFrame2.CalcHeight(realHeight);
    }
    else
    {
      var c1 = this.ChildFrame1.CalcHeight(realHeight);
      var c2 = this.ChildFrame2.CalcHeight(realHeight);
      return (c1 > c2) ? c1 : c2;
    }
  }
  else
  {
    if (this.Collapsed) 
    {
      if (this.ToolbarBox && this.ToolbarBox.offsetHeight !== 0)
        return this.ToolbarBox.offsetHeight;
      else
        return 55;
    }
    else
      return (this.OrgHeight && !realHeight ? this.OrgHeight : this.Height)
  }
}


// ********************************************************************************
// Indica quanto il contenuto deve essere piu' basso del frame per contenere
// la toolbar, le pagine...
// ********************************************************************************
WebFrame.prototype.GetContentOffset = function()
{ 
  return this.ToolbarBox.offsetHeight;
}

// ********************************************************************************
// Indica quanto il contenuto deve essere piu' stretto del frame.. (per tabbed 
// verticali)
// ********************************************************************************
WebFrame.prototype.GetHContentOffset = function()
{ 
  return 0;
}


// **********************************************************************
// Gestisco la pressione dei tasti FK a partire dal frame
// **********************************************************************
WebFrame.prototype.HandleFunctionKeys = function(eve)
{
  var code = (eve.charCode)?eve.charCode:eve.keyCode;
  var ok = false;
  //
  // Passo il mesaggio alla form
  if (!ok)
    ok = this.WebForm.HandleFunctionKeys(eve);
  //
  return ok;
}


// ********************************************************************************
// Dice se il frame ha il fuoco
// ********************************************************************************
WebFrame.prototype.HasFocus = function()
{ 
  var o = RD3_KBManager.ActiveObject;
  //
  if (o && o.GetParentFrame)
    o = o.GetParentFrame();
  //
  return o==this;
}


// **********************************************************************
// Torna true se il frame puo' avere il fuoco
// **********************************************************************
WebFrame.prototype.CanHaveFocus= function()
{
  // Se e' collassato non funziona
  if (this.Collapsed)
    return false;
  //
  if ((typeof(this)=="IDPanel") || (typeof(this)=="Book"))
    return true;
  //
  return false;
}


// ********************************************************************************
// Salva le dimensioni attuali del frame
// ********************************************************************************
WebFrame.prototype.SaveSize = function()
{ 
  this.SavedWidth = this.Width;
  this.SavedHeight = this.Height;
  //
  this.SavedDeltaW = this.DeltaW;
  this.SavedDeltaH = this.DeltaH;
}


// ********************************************************************************
// Ripristina le dimensioni del frame
// ********************************************************************************
WebFrame.prototype.ResetSize = function()
{ 
  // Nel caso di Frame Fittizi e' sufficiente rimettere a posto la Width e l'Height, mentre nel caso 
  // di frame veri e' necessario ripristinare anche le dimensioni reali
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    this.Width = this.SavedWidth;
    this.Height = this.SavedHeight;
  }
  else
  {
    var oldRec = this.WebForm.RecalcLayout;
    //
    this.SetWidth(this.SavedWidth);
    this.SetHeight(this.SavedHeight);
    //
    // Ripristino il Recalc.. non e' il punto giusto per cambiarlo..
    this.WebForm.RecalcLayout = oldRec;
  }
  //
  this.ResetDelta();
}


// ********************************************************************************
// Resetta i delta dei ridimensionamenti per i frame figli
// ********************************************************************************
WebFrame.prototype.ResetDelta = function()
{ 
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    this.ChildFrame1.ResetDelta();
    this.ChildFrame2.ResetDelta();
  }
  else
  {
    this.DeltaW = this.SavedDeltaW;
    this.DeltaH = this.SavedDeltaH;
  }
}


// *********************************************************
// Timer globale
// *********************************************************
WebFrame.prototype.Tick = function()
{
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    this.ChildFrame1.Tick();
    this.ChildFrame2.Tick();
  }
  else
  {
    // La classe base non fa nulla
  }
}


// *********************************************************
// Gestisce evento Mouse Down
// *********************************************************
WebFrame.prototype.OnMouseDown = function(evento)
{
  var x = evento.targetTouches && evento.targetTouches.length>0 ? evento.targetTouches[0].clientX : evento.clientX;
  var y = evento.targetTouches && evento.targetTouches.length>0 ? evento.targetTouches[0].clientY : evento.clientY;
  //
  var delta = RD3_Glb.IsTouch()?24:4;
  //
  // Vediamo se devo skippare l'evento perche' sto aspettando un doppio click.
  var d = new Date();
  if (d-this.MD_Time<400 && Math.abs(x-this.MD_XPos)<delta && Math.abs(y-this.MD_YPos)<delta)
    return;
  //
  // Memorizzo i dati dell'evento
  this.MD_XPos = x;
  this.MD_YPos = y;
  this.MD_Time = d;
  this.MD_Button = RD3_Glb.IsTouch() ? 0 : evento.button;
  this.MD_Target = evento.target?evento.target:evento.srcElement;
  this.MD_Clicked = false;
}


// *********************************************************
// Vediamo se e' possibile avere un raw click o raw dblclick
// *********************************************************
WebFrame.prototype.OnMouseUp = function(evento)
{
  // Se c'e' un timer impostato per il tap prolungato allora lo fermo al mouse up
  if (this.RawTouchTimer) {
    window.clearTimeout(this.RawTouchTimer);
    this.RawTouchTimer = null;
  }
  //
  var x = evento.changedTouches && evento.changedTouches.length>0 ? evento.changedTouches[0].clientX : evento.clientX;
  var y = evento.changedTouches && evento.changedTouches.length>0 ? evento.changedTouches[0].clientY : evento.clientY;
  //
  var delta = RD3_Glb.IsTouch()?24:4;
  var b = evento.button ? evento.button : 0;
  var t = evento.target?evento.target:evento.srcElement;
  var d = new Date();
  //
  // b=999 e' il tocco prolungato che simula il tasto dx
  var sm = (b==this.MD_Button || b == 999);
  if (b==999)
    b=2;
  //
  // Vediamo se il mouse up e' avvenuto nello stesso posto del down
  if (Math.abs(x-this.MD_XPos)<delta && Math.abs(y-this.MD_YPos)<delta && sm && t==this.MD_Target)
  {
    // Posso effettivamente avere un click
    var dbl = false;
    if (this.MD_Clicked && d-this.MD_Time<400)
      dbl = true;
    //
    // Aggiusto bottone per IE
    if (RD3_Glb.IsIE()) {
      if (b & 0x01)
        b=0;
      else if (b & 0x02)
        b=2;
      else if (b & 0x04)
        b=1;
    }
    //
    // Considero coordinate relative al frame
    var xp = x - RD3_Glb.GetScreenLeft(this.FrameBox);  
    var yp = y - RD3_Glb.GetScreenTop(this.FrameBox);
    //
    // Proteggo il caso negativo, potrebbe succedere in caso di browser con zoom
    if (xp<0)
      xp = 0;
    if (yp < 0)
      yp = 0;
    //
    // Prima di lanciare l'evento, verifico che esso non venga "bubblato" da un altro frame
    // a me sovrapposto.
    var ok = true;
    var tt = t;
    while (tt)
    {
      if (RD3_Glb.HasClass(tt,"frame-row")) {
        ok = (tt==this.FrameRow);
        break;
      }
      tt = tt.parentNode;
    }
    //
    if (ok)
      this.OnFrameClick(evento, dbl, b, xp, yp, x, y, t);
    //
    // Dopo aver gestito un doppio click, ritorno al tipo normale.
    this.MD_Clicked = !dbl;
  }
}

WebFrame.prototype.OnTouchDown = function(evento)
{
  this.OnMouseDown(evento);
  this.RawTouchTimer = window.setTimeout(this.OnRawRightClick.bind(this), 750);
  return true;
}

WebFrame.prototype.OnTouchUp = function(evento, click)
{
  // Se il touch up scatta auando il timer e' ancora presente allora lancio il mouse up (come se fosse un click)
  // altrimenti se il timer e' gia' scattato (quindi e' stato rimosso) non faccio nulla
  if (this.RawTouchTimer != null)
    this.OnMouseUp(evento);
  return true;
}

WebFrame.prototype.OnRawRightClick = function()
{
  this.RawTouchTimer = null;
  var evento = new Object();
  evento.clientX = this.MD_XPos;
  evento.clientY = this.MD_YPos;
  evento.button = 999;
  evento.target = this.MD_Target;
  //
  this.OnMouseUp(evento);
}

WebFrame.prototype.OnTouchMove = function(evento)
{
  // Se mi muovo troppo devo annullare il timer di tasto destro
  var x = evento.changedTouches && evento.changedTouches.length>0 ? evento.changedTouches[0].clientX : evento.clientX;
  var y = evento.changedTouches && evento.changedTouches.length>0 ? evento.changedTouches[0].clientY : evento.clientY;
  //
  if (Math.abs(x-this.MD_XPos)> 24 || Math.abs(y-this.MD_YPos) > 24 && this.RawTouchTimer) {
    window.clearTimeout(this.RawTouchTimer);
    this.RawTouchTimer = null;
  }
}

// *********************************************************
// Lancio Evento Row: sovrascritto nelle classi derivate
// *********************************************************
WebFrame.prototype.OnFrameClick = function(evento, dbl, btn, x, y, xb, yb, tget)
{
}


// *********************************************************
// Imposta il tooltip
// *********************************************************
WebFrame.prototype.GetTooltip = function(tip, obj)
{
  var ok = false;
  if (obj == this.LockButton)
  {
    if (this.Locked)
    {
      tip.SetTitle(ClientMessages.TIP_TITLE_TooltipUnlock);
      tip.SetText(RD3_ServerParams.TooltipUnlock + RD3_KBManager.GetFKTip(RD3_ClientParams.FKLocked));
    }
    else
    {
      tip.SetTitle(ClientMessages.TIP_TITLE_TooltipLock);
      tip.SetText(RD3_ServerParams.TooltipLock + RD3_KBManager.GetFKTip(RD3_ClientParams.FKLocked));
    }
    ok = true;
  }
  else if (obj == this.CollapseButton)
  {
    if (this.Collapsed)
    {
      tip.SetTitle(ClientMessages.TIP_TITLE_MostraRiquadro);
      tip.SetText(RD3_ServerParams.MostraRiquadro);
    }
    else
    {
      tip.SetTitle(ClientMessages.TIP_TITLE_NascondiRiquadro);
      tip.SetText(RD3_ServerParams.NascondiRiquadro);
    }
    ok = true;
  }
  //
  if (ok)
  {
    // Di default i bottoni di pannello mostrano il tooltip centrato sopra di essi
    tip.SetAnchor(RD3_Glb.GetScreenLeft(obj) + ((obj.offsetWidth-4)/2), RD3_Glb.GetScreenTop(obj));
    tip.SetPosition(0);
    return true;
  }
  //
  return false;
}


// *********************************************************
// Ritorna l'oggetto DOM contenente il frame
// *********************************************************
WebFrame.prototype.GetDOMObj = function()
{
  return this.ContentBox;
}

// *********************************************************
// Elimina un frame
// *********************************************************
WebFrame.prototype.DeleteFrame = function(value)
{
  // Mi cerco nell'array di mio padre
  var n = this.WebForm.Frames.length;
  for (var i=0; i<n; i++)
  {
    if (this.WebForm.Frames[i] == this)
    {
      this.WebForm.Frames.splice(i, 1);
      this.Unrealize();
      //
      break;
    }
  }
}


// ********************************************************************************
// Evento di inizio tocco sulla toolbar del frame
// ********************************************************************************
WebFrame.prototype.OnTouchStartTb = function(e)
{
}


// ********************************************************************************
// Evento di movimento del ditino sulla toolbar del frame
// ********************************************************************************
WebFrame.prototype.OnTouchMoveTb = function(e)
{
}


// ********************************************************************************
// Evento di movimento del ditino sulla toolbar del frame
// ********************************************************************************
WebFrame.prototype.OnTouchEndTb = function(e)
{
}


// ********************************************************************
// Gestione ridimensionamento Frame: questo frame e' ridimensionabile?
// ********************************************************************
WebFrame.prototype.IsTransformable = function(id)
{ 
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    // Sono ridimensionabile solo se entrambi i miei figli lo sono: verifico 
    // se uno dei due ha il flag altezza o larghezza fissa abilitato (altezza massima==altezza minima..)
    if (this.Vertical)
      return !((this.ChildFrame1.MinHeight==this.ChildFrame1.MaxHeight && this.ChildFrame1.MinHeight!=0) || (this.ChildFrame2.MinHeight==this.ChildFrame2.MaxHeight && this.ChildFrame2.MinHeight!=0) || RD3_ServerParams.EnableFrameResize==false);
    else
      return !((this.ChildFrame1.MinWidth==this.ChildFrame1.MaxWidth && this.ChildFrame1.MinWidth!=0) || (this.ChildFrame2.MinWidth==this.ChildFrame2.MaxWidth && this.ChildFrame2.MinWidth!=0) || RD3_ServerParams.EnableFrameResize==false);
  }
  else
  {
    // Non sono solo io a decidere se sono ridimensionabile; dipende anche da mio fratello, quindi chiedo a mio padre
    if (this.ParentFrame)
      return this.ParentFrame.IsTransformable(id);
    else
      return false; // Il Frame[0] non e' ridimensionabile!
  }
}

WebFrame.prototype.IsMoveable = function()
{ 
  return false;
}

WebFrame.prototype.DragObj= function(id, obj, x, y) 
{
  /*
  // Sul Frame[0] non e' permesso nessun resize
  if (!this.ParentFrame)
    return null;
  //
  var ox = x - RD3_Glb.GetScreenLeft(obj);
  var oy = y - RD3_Glb.GetScreenTop(obj);
  //
  var pos = 0;
  if (ox<=10)
    pos = 1;  // LEFT
  else if (ox>=(obj.offsetWidth-10))
    pos = 2; // RIGTH
  else if (oy<=10)
    pos = 3; // UP
  else if (oy>=(obj.offsetHeight-10))
    pos = 4; // DOWN
  //
  if (pos==0)
    return this;
  //
  // 
  if (pos ==1 && !(!this.ParentFrame.Vertical && this.ParentFrame.ChildFrame2==this))
    return this.ParentFrame.DragObj(id, obj, x, y);
  if (pos ==2 && !(!this.ParentFrame.Vertical && this.ParentFrame.ChildFrame1==this))
    return this.ParentFrame.DragObj(id, obj, x, y);
  if (pos ==3 && !(this.ParentFrame.Vertical && this.ParentFrame.ChildFrame2==this))
    return this.ParentFrame.DragObj(id, obj, x, y);  
  if (pos ==4 && !(this.ParentFrame.Vertical && this.ParentFrame.ChildFrame1==this))
    return this.ParentFrame.DragObj(id, obj, x, y);
  //
  return this;
  */
}

WebFrame.prototype.DropElement = function()
{ 
  if (this.FrameBox)
    return this.FrameBox;
  else if (this.ParentFrame && this.ParentFrame.ChildFrame1==this)
    return this.ParentFrame.ChildBox1;
  else if (this.ParentFrame && this.ParentFrame.ChildFrame2==this)
    return this.ParentFrame.ChildBox2;
}

WebFrame.prototype.ApplyCursor = function(cn)
{
}

WebFrame.prototype.CanResizeW = function()
{ 
  if (this.ParentFrame)
    return !this.ParentFrame.Vertical;
  else
    return false;  
}

WebFrame.prototype.CanResizeH = function()
{ 
  if (this.ParentFrame)
    return this.ParentFrame.Vertical;
  else
    return false;  
}

WebFrame.prototype.CanResizeL = function()
{ 
  // Posso ridimensionare a sinistra solo se mio padre e' orizzonatale ed io sono il secondo frame
  if (this.ParentFrame)
  {
    if (this.ParentFrame.ChildFrame2==this)
      return !this.ParentFrame.Vertical;
    else
    {
      return this.ParentFrame.CanResizeL();
    }
  }
  else
  {
    return false;
  }
}

WebFrame.prototype.CanResizeR = function()
{
  // Posso ridimensionare a destra solo se mio padre e' orizzonatale ed io sono il primo frame
  if (this.ParentFrame)
  {
    if (this.ParentFrame.ChildFrame1==this)
      return !this.ParentFrame.Vertical;
    else
    {
      return this.ParentFrame.CanResizeR();
    }
  }
  else
  {
    return false;
  }
}

WebFrame.prototype.CanResizeT = function()
{ 
  // Posso ridimensionare sopra solo se mio padre e' verticale ed io sono il secondo frame
  if (this.ParentFrame)
  {
    if (this.ParentFrame.ChildFrame2==this)
      return this.ParentFrame.Vertical;
    else
    {
      return this.ParentFrame.CanResizeT();
    }
  }
  else
  {
    return false;  
  }
}

WebFrame.prototype.CanResizeD = function()
{ 
  // Posso ridimensionare sotto solo se mio padre e' verticale ed io sono il primo frame
  if (this.ParentFrame)
  {
    if (this.ParentFrame.ChildFrame1==this)
      return this.ParentFrame.Vertical;
    else
    {
      return this.ParentFrame.CanResizeD();
    }
  }
  else
    return false; 
}


// ********************************************************************************
// Metodo chiamato per effettuare la trasformazione
// ********************************************************************************
WebFrame.prototype.OnTransform = function(x, y, w, h, evento)
{
}


//*************************************************************************************
// Gestore evento cambio valore della cella di ricerca: invia al server il nuovo valore
//*************************************************************************************
WebFrame.prototype.OnSearchChange= function(evento, noblur)
{
}

//*************************************************************
// Gestore evento INVIO : esegue subito la ricerca
//*************************************************************
WebFrame.prototype.OnSearchKeyPress = function(evento)
{
}

//***********************************************************
// Mostra o nasconde il pulsante per svuotare la ricerca
// ed esegue la ricerca attiva
//***********************************************************
WebFrame.prototype.OnSearchKeyUp = function(evento)
{
}

//***********************************************************
// Gestione del pulsante di svuotamento della ricerca
//***********************************************************
WebFrame.prototype.OnSearchMouseDown = function(ev)
{
}

//********************************************************
// Perdita del fuoco della cella di ricerca
//********************************************************
WebFrame.prototype.OnSearchBlur = function(ev)
{
}

WebFrame.prototype.SetSearchBoxValue = function(val)
{
}

// ********************************************************************************
// Gestore evento di click sulla caption
// ********************************************************************************
WebFrame.prototype.OnCaptionClick= function(evento)
{
}


// ********************************************************************************
// Ritorna l'oggetto DOM della toolbar custom attaccata a questo frame
// ********************************************************************************
WebFrame.prototype.GetCustomToolbar= function()
{ 
  if (!this.ToolbarBox)
    return;
  //
  var obj = this.ToolbarBox.firstChild;
  while (obj)
  {
    if (RD3_Glb.HasClass(obj,"toolbar-frame-container"))
      return obj;
    obj = obj.nextSibling;
  }
}

// ********************************************************************************
// Mouse Down riflesso da IDScroll o da un'altro frame
// ********************************************************************************
WebFrame.prototype.OnReflectMouseDown = function(ev, fromScroll, direction)
{
}

// ********************************************************************************
// Mouse Move riflesso da IDScroll o da un'altro frame
// ********************************************************************************
WebFrame.prototype.OnReflectMouseMove = function(ev, fromScroll)
{
}

// ********************************************************************************
// Mouse Up riflesso da IDScroll o da un'altro frame
// ********************************************************************************
WebFrame.prototype.OnReflectMouseUp = function(ev, fromScroll)
{
}

// ********************************************************************************
// True se sono un sotto-oggetto (contenuto in subform o in subField)
// ********************************************************************************
WebFrame.prototype.IsSubObj  = function()
{
  return ((this.WebForm.SubFormObj || this.ParentFrameIdentifier != "") ? true : false);
}

// ********************************************************************************
// True se devo riflettere lo scroll in una direzione a mio padre (non lo gestisco..)
// ********************************************************************************
WebFrame.prototype.MustReflectScrollToParent  = function(direction)
{
}


// ********************************************************************************
// Nasconde o mostra i pulsanti di Back dell'albero nel caso mobile
// ********************************************************************************
WebFrame.prototype.ChangeExpose  = function(exposed)
{
  if (exposed)
  {
    this.SetCaption();
    this.WebForm.AdaptToolbar = true;
  }
}


// *******************************************************************
// Chiamato quando cambia il colore di accento
// *******************************************************************
WebFrame.prototype.AccentColorChanged = function(reg, newc) 
{
}

// *******************************************************************
// Chiamato quando ho l'immagine da retinare
// *******************************************************************
WebFrame.prototype.OnAdaptRetina = function(w, h, par)
{
  if (this.IconImg)
  {
    this.IconImg.width = w;
    this.IconImg.height = h;
    this.IconImg.style.display = "";
  }
}

WebFrame.prototype.CalcGridLayout = function()
{
  // Modalita' di ridimensionamento con mantenimento di dimensioni in percentuale
  // in questo caso:
  // 1) se si tratta di un frame fittizio verticale: 
  //   le due righe vanno dimensionate percentualmente rispetto alle loro dimensioni a design timer
  // 2) se si tratta di un frame fittizio orizzontale: 
  //   la riga e' il 100%
  // 3) se si tratta di un frame reale
  //   la riga e' il 100% come la cella interna, poi se il contenuto sfora si prende la scrollbar
  // 
  // Lo stesso comportamento lo applico ai subframe, in quel caso si devono sempre adattare alla dimensione del campo statico che li contiene
  if (this.WebForm.ResModeH !== RD3_Glb.FRESMODE_NONE || (this instanceof IDPanel && this.ParentFrameIdentifier)) {
    if (this.ChildFrame1 && this.ChildFrame2) {
      if (this.Vertical) {
        if (!this.ChildFrame1.Collapsed && !this.ChildFrame2.Collapsed) {
         var h1 = this.ChildFrame1.CalcHeight();
         var h2 = this.ChildFrame2.CalcHeight();
         //
         var h1Perc = Math.floor((h1 / (h1+h2)) * 100);
         var h2Perc = 100 - h1Perc;
         //
         if (this.ChildFrame1.Visible && this.ChildFrame1.MinHeight == this.ChildFrame1.MaxHeight && this.ChildFrame1.MinHeight != 0) {
           // Se il primo frame ha altezza fissa la gestisco
           this.ChildRow1.style.height = h1 + "px";
           this.ChildRow2.style.height = "calc(100% - " + h1 + "px)";
         }
         else if (this.ChildFrame2.Visible && this.ChildFrame2.MinHeight == this.ChildFrame2.MaxHeight && this.ChildFrame2.MinHeight != 0) {
           // Se il secondo frame ha altezza fissa la gestisco
           this.ChildRow1.style.height = "calc(100% - " + h2 + "px)";
           this.ChildRow2.style.height = h2 + "px";
         }
         else {
           // Se nessuno dei due ha altezza fissa la imposto come percentuale
           this.ChildRow1.style.height = h1Perc + "%";
           this.ChildRow2.style.height = h2Perc + "%";
         }
         //
         this.ChildBox1.style.height = "100%";
         this.ChildBox2.style.height = "100%";
        }
        else if (this.ChildFrame1.Collapsed && this.ChildFrame2.Collapsed) {
          var h1 = this.ChildFrame1.CalcHeight();
          var h2 = this.ChildFrame2.CalcHeight();
          this.ChildRow1.style.height = h1 + "px";
          this.ChildRow2.style.height = h2 + "px";
        }
        else if (this.ChildFrame1.Collapsed) {
          var h1 = this.ChildFrame1.CalcHeight();
          this.ChildRow1.style.height = h1 + "px";
          this.ChildRow2.style.height = "calc( 100% - "+h1+"px)";
          this.ChildBox1.style.height = "100%";
          this.ChildBox2.style.height = "100%";
        }
        else if (this.ChildFrame2.Collapsed) {
          var h2 = this.ChildFrame2.CalcHeight();
          this.ChildRow2.style.height = h2 + "px";
          this.ChildRow1.style.height = "calc( 100% - "+h2+"px)";
          this.ChildBox1.style.height = "100%";
          this.ChildBox2.style.height = "100%";
        }
      }
      else {
        this.ChildRow.style.height = "100%";
        this.ChildBox1.style.height = "100%";
        this.ChildBox2.style.height = "100%";
      }
    }
    else {
      this.FrameRow.style.height = "100%";
      this.FrameCol.style.height = "100%";
      this.FrameBox.style.height = "100%";
    }
  }
  //
  if (this.ChildFrame1 && this.ChildFrame2 && !this.Vertical) {
    // Adesso imposto le dimensioni orizzontali, devo impostare 
    // la 'colonnatura' in base alla larghezza  
    var w1 = this.ChildFrame1.CalcWidth();
    var w2 = this.ChildFrame2.CalcWidth();
    var w1Col = Math.floor((w1 / (w1+w2)) * 12);
    var w2Col = 12 - w1Col;
    //
    // Rendo l'algoritmo piu' "forgiving" dato che nell'IDE non c'e' un modo per rendere uguali due frame e 
    // c'e' anche la grigliatura a 4px che puo' dare fastidio..
    if (Math.abs(w1 - w2) <= 10) {
      w1Col = 6;
      w2Col = 6;
    }
    //
    // Se il primo frame ha la classe imposta ma il secondo no allora provo a vedere se riesco ad adattare il calcolo
    // lo posso fare solo se la classe impostata sul primo e' del tipo col-md-x
    // altrimenti niente da fare
    if (this.ChildFrame1.BootstrapCellClass && !this.ChildFrame2.BootstrapCellClass && this.ChildFrame1.BootstrapCellClass.indexOf("col-md-")>=0)
    {
      try {
        var w1 = this.ChildFrame1.BootstrapCellClass.substr(this.ChildFrame1.BootstrapCellClass.indexOf("col-md-"), 9);
        w1 = w1.replace("col-md-", "");
        w1 = parseInt(w1, 10);
        if (w1 && !isNaN(w1))
          w2Col = 12 - w1;
      }
      catch (ex) {}
    }
    //
    if (this.ChildFrame2.BootstrapCellClass && !this.ChildFrame1.BootstrapCellClass && this.ChildFrame2.BootstrapCellClass.indexOf("col-md-")>=0)
    {
      try {
        var w2 = this.ChildFrame2.BootstrapCellClass.substr(this.ChildFrame2.BootstrapCellClass.indexOf("col-md-"), 9);
        w2 = w2.replace("col-md-", "");
        w2 = parseInt(w2, 10);
        if (w2 && !isNaN(w2))
          w1Col = 12 - w2;
      }
      catch (ex) {}
    }
    //
    this.ChildBox1.className = (this.ChildFrame1.BootstrapCellClass ? this.ChildFrame1.BootstrapCellClass : "col-md-" + w1Col) + " frame-column";
    this.ChildBox2.className = (this.ChildFrame2.BootstrapCellClass ? this.ChildFrame2.BootstrapCellClass :"col-md-" + w2Col) + " frame-column";
    //
    if (w1Col == 0)
      this.ChildBox1.style.display = "none";
    else
      this.ChildBox1.style.display = "";
    if (w2Col == 0)
      this.ChildBox2.style.display = "none";
    else
      this.ChildBox2.style.display = "";
  }
  //
  if (this.ChildFrame1 && this.ChildFrame2) {
    this.ChildFrame1.CalcGridLayout();
    this.ChildFrame2.CalcGridLayout();
  }
}


WebFrame.prototype.OnViewportResize = function()
{
  if (this.ChildFrame1 && this.ChildFrame2)
  {
    this.ChildFrame1.OnViewportResize();
    this.ChildFrame2.OnViewportResize();
  }
  else {
    if (!this.IsFrameVisible()) 
    {
      this.SkippedSendResize = true;
      return;
    }
    delete this.SkippedSendResize;
    //
    // Calcolo le dimensioni per informarne il server
    var clw = (this instanceof Graph || this instanceof Book) ? this.ContentBox.clientWidth - RD3_Glb.GetHorizontalTotalPadding(this.ContentBox) : this.FrameBox.clientWidth;
    var clh = (this instanceof Graph || this instanceof Book) ? this.ContentBox.clientHeight - RD3_Glb.GetVerticalTotalPadding(this.ContentBox) : this.FrameBox.clientHeight;
    //
    // Notifico l'evento di resize solo se almeno una delle dimensioni e' cambiata
    if (this.lastclw != clw || this.lastclh != clh)
    {
      var ev = new IDEvent("resize", this.Identifier, null, RD3_Glb.EVENT_ACTIVE, null, clw, clh);
      this.lastclw = clw;
      this.lastclh = clh;
    }
  }
};

/**
 * Inizializzaione iniziale per l'apertura della videata
 */
WebFrame.prototype.StartingFormAnimation = function()
{
}

/**
 * Rirorna true se il frame e' visibili
 * @returns boolean
 */
WebFrame.prototype.IsFrameVisible = function () 
{
  if (!this.Visible)
    return false;
  //
  // Se sono contenuto in un campo di pannello allora sono visibile se lui e' visibile
  if (this.ParentFrameIdentifier) {
    var par = RD3_DesktopManager.ObjectMap[this.ParentFrameIdentifier];
    if (par && par.IsVisible)
      return par.IsVisible();
  }
  //
  if (this.ParentTab && this.ParentTab.Selected)
    return true;
  //
  return true;
}
