// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe PopupError: implementa il funzionamento della
// Videate che mostra gli errori avvenuti lato server
// Estende PopupFrame
// ************************************************

function PopupError(node)
{
	// Recupero i parametri dell'errore
	this.ErrorHeader = node.getAttribute("hdr");
	this.ErrorNumber = node.getAttribute("num");
	this.ErrorDescription = node.getAttribute("des");
	this.ErrorEffects = node.getAttribute("eff");
	this.ErrorActions = node.getAttribute("act");
	this.ErrorSource = node.getAttribute("src");
	this.ErrorException = node.getAttribute("exc") ? node.getAttribute("exc") : "";
	this.ErrorMessage = node.getAttribute("erm") ? node.getAttribute("erm") : "";
	this.Identifier = "PopupError" + Math.floor(Math.random() * 100);
	//
	// Oggetti DOM riguardanti l'errore
	this.HeaderDiv = null;          // Div che contiene l'icona e l'header
	this.ErrorIcon = null;          // Elemento IMG che contiene l'icona dell'errore
	this.CaptionTxt = null;         // Elemento SPAN che contiene il testo dell'header dell'errore
	//
	this.ErrorNumTitle = null;      // SPAN del titolo della riga del numero di errore
	this.ErrorNumTxt = null;        // SPAN del numero di errore
	//
	this.ErrorDescTitle = null;      // SPAN del titolo della riga di descrizione errore
	this.ErrorDescTxt = null;        // SPAN della descrizione dell'errore
	//
	this.ErrorEffTitle = null;      // SPAN del titolo della riga di effetti errore
	this.ErrorEffTxt = null;        // SPAN degli effetti dell'errore
	//
	this.ErrorActTitle = null;      // SPAN del titolo della riga di azioni
	this.ErrorActTxt = null;        // SPAN delle azioni
	//
	this.ErrorSrcTitle = null;      // SPAN del titolo della sorgente
	this.ErrorSrcTxt = null;        // SPAN della sorgente
	//
	this.ErrorButton = null;        // Pulsante di ritorno all'applicazione: DIV se tema classic, altrimenti IMG
	//
	this.ErrorMessageTitle = null;  // SPAN del titolo del messaggio di errore
	this.ErrorMessageTxt = null;    // SPAN dello messaggio di errore
	//
	this.ErrorStackTitle = null;    // SPAN del titolo dello stack
	this.ErrorStackTxt = null;      // SPAN dello Stack
}
//
// Definisco l'estensione della classe
PopupError.prototype = new PopupFrame();


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
PopupError.prototype.Realize = function()
{
	// Chiamo la classe base
	PopupFrame.prototype.Realize.call(this);
	RD3_Glb.AddClass(this.PopupDialog, "popup-error-modal-dialog");
  //
	// Creo la caption
	this.HeaderTitle = document.createElement("h4");
  this.HeaderTitle.className = "modal-title";
	this.HeaderTitle.innerHTML = "<i class='fa fa-exclamation' aria-hidden='true'></i>         " + ClientMessages.MSG_POPUP_MsgErrorCaption;
  this.CaptionBox.appendChild(this.HeaderTitle);
	//
	// Creo la linea del numero di errore
	this.ErrorNumTitle = document.createElement("p");
	this.ErrorNumTitle.innerHTML = "<b>"+ RD3_ServerParams.ErrorNum + "</b> " + this.ErrorNumber;
	this.ContentBox.appendChild(this.ErrorNumTitle);
	//
	// Creo la linea della descrizione
	if (this.ErrorDescription.length > 0)
	{
  	this.ErrorDescTitle = document.createElement("p");
  	this.ErrorDescTitle.innerHTML = "<i>" + this.ErrorDescription + "</i>";
  	this.ContentBox.appendChild(this.ErrorDescTitle);
  }
	//
	// Creo la linea degli effetti
	if (this.ErrorEffects.length > 0)
	{
  	this.ErrorEffTitle = document.createElement("p");
  	this.ErrorEffTitle.innerHTML = "<b>"+ RD3_ServerParams.ErrorEffects + "</b> " + this.ErrorEffects;
  	this.ContentBox.appendChild(this.ErrorEffTitle);
  }
	//
	// Creo la linea delle azioni
	if (this.ErrorActions.length > 0)
	{
  	this.ErrorActTitle = document.createElement("p");
  	this.ErrorActTitle.innerHTML = "<b>" + RD3_ServerParams.ErrorAction + "</b><br/> " + this.ErrorActions;
  	this.ContentBox.appendChild(this.ErrorActTitle);
  }
	//
	// Creo la linea della sorgente
	if (this.ErrorSource.length > 0)
	{
  	this.ErrorSrcTitle = document.createElement("p");
  	this.ErrorSrcTitle.innerHTML = "<b>" + RD3_ServerParams.ErrorSrc + "</b> " + this.ErrorSource;
  	this.ContentBox.appendChild(this.ErrorSrcTitle);
  }
  // 
  // Creo il pulsante di ritorno all'applicazione
	var errP = document.createElement("p");
	this.ErrorButton = document.createElement("button");
	this.ErrorButton.innerHTML = RD3_ServerParams.ErrorButton;
  this.ErrorButton.className = "btn btn-danger";
	this.ErrorButton.onclick = function (ev) {
		this.OnClickEB(ev);
	}.bind(this);
	errP.appendChild(this.ErrorButton);
  this.ContentBox.appendChild(errP);
  //
	// Creo la linea del messaggio di errore
	if (this.ErrorMessage.length > 0)
	{
  	this.ErrorMessageTitle = document.createElement("p");
  	this.ErrorMessageTitle.innerHTML = "<b>Error Details:</b> " + this.ErrorMessage;
  	this.ContentBox.appendChild(this.ErrorMessageTitle);
  }
	//
	// Creo la linea dello stack trace
	if (this.ErrorException.length > 0)
	{
  	this.ErrorStackTitle = document.createElement("p");
  	this.ErrorStackTitle.innerHTML = "<b>Stack Trace:</b><br/>" + this.ErrorException;
  	this.ContentBox.appendChild(this.ErrorStackTitle);
  }
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
PopupError.prototype.Unrealize = function()
{
  // Chiamo la classe base
	PopupFrame.prototype.Unrealize.call(this);	
	//
	// Rimuovo i riferimenti al DOM
	this.ErrorIcon = null;     
	this.CaptionTxt = null;      
	this.ErrorNumTitle = null;   
	this.ErrorNumTxt = null;   
	this.ErrorDescTitle = null;  
	this.ErrorDescTxt = null;    
	this.ErrorEffTitle = null;    
	this.ErrorEffTxt = null;      
	this.ErrorActTitle = null;     
	this.ErrorActTxt = null;     
	this.ErrorSrcTitle = null;    
	this.ErrorSrcTxt = null;    
	this.ErrorButton = null;   
	this.ErrorMessageTitle = null;  
	this.ErrorMessageTxt = null;
	this.ErrorStackTitle = null;
	this.ErrorStackTxt = null;
}

// ***************************************************
// Posiziona gli elementi del frame e lo dimensiona
// ***************************************************
PopupError.prototype.AdaptLayout = function()
{
  /*// Posiziono il contenitore
  var hcap = RD3_Glb.CalcBottom(this.CaptionBox) + 5;
  this.ContentBox.style.top = hcap + "px";
  //
  // Posiziono correttamente i div del contenuto
  var hpos = this.HeaderDiv.offsetHeight;
  //
  this.ErrorNumTitle.style.top = hpos + "px";
  this.ErrorNumTitle.style.left = "10px";
  this.ErrorNumTxt.style.top = hpos + "px";
  this.ErrorNumTxt.style.left = "100px";
  //
  hpos = Math.max(RD3_Glb.CalcBottom(this.ErrorNumTitle), RD3_Glb.CalcBottom(this.ErrorNumTxt)) + 20;
  //
  if (this.ErrorDescription.length > 0)
  {
    this.ErrorDescTitle.style.top = hpos + "px";
    this.ErrorDescTitle.style.left = "10px";
    this.ErrorDescTxt.style.top = hpos + "px";
    this.ErrorDescTxt.style.left = "100px";
    //
    hpos = Math.max(RD3_Glb.CalcBottom(this.ErrorDescTitle), RD3_Glb.CalcBottom(this.ErrorDescTxt)) + 20;
  }
  //
  if (this.ErrorEffects.length > 0)
  {
    this.ErrorEffTitle.style.top = hpos + "px";
    this.ErrorEffTitle.style.left = "10px";
    this.ErrorEffTxt.style.top = hpos + "px";
    this.ErrorEffTxt.style.left = "100px";
    //
    hpos = Math.max(RD3_Glb.CalcBottom(this.ErrorEffTitle), RD3_Glb.CalcBottom(this.ErrorEffTxt)) + 20;
  }
  //
  if (this.ErrorActions.length > 0)
  {
    this.ErrorActTitle.style.top = hpos + "px";
    this.ErrorActTitle.style.left = "10px";
    this.ErrorActTxt.style.top = hpos + "px";
    this.ErrorActTxt.style.left = "100px";
    //
    hpos = Math.max(RD3_Glb.CalcBottom(this.ErrorActTitle), RD3_Glb.CalcBottom(this.ErrorActTxt)) + 20;
  }
  //
  if (this.ErrorSource.length > 0)
  {
    this.ErrorSrcTitle.style.top = hpos + "px";
    this.ErrorSrcTitle.style.left = "10px";
    this.ErrorSrcTxt.style.top = hpos + "px";
    this.ErrorSrcTxt.style.left = "100px";
    //
    hpos = Math.max(RD3_Glb.CalcBottom(this.ErrorSrcTitle), RD3_Glb.CalcBottom(this.ErrorSrcTxt)) + 20;
  }
  //
  this.ErrorButton.style.top = hpos + "px";
  this.ErrorButton.style.left = "10px";
  hpos = RD3_Glb.CalcBottom(this.ErrorButton) + 40;
  //
  if (this.ErrorMessage.length > 0)
  {
    this.ErrorMessageTitle.style.top = hpos + "px";
    this.ErrorMessageTitle.style.left = "10px";
    this.ErrorMessageTxt.style.top = hpos + "px";
    this.ErrorMessageTxt.style.left = "100px";
    //
    hpos = Math.max(RD3_Glb.CalcBottom(this.ErrorMessageTitle), RD3_Glb.CalcBottom(this.ErrorMessageTxt)) + 20;
  }
  //
  if (this.ErrorException.length > 0)
  {
    this.ErrorStackTitle.style.top = hpos + "px";
    this.ErrorStackTitle.style.left = "10px";
    this.ErrorStackTxt.style.top = hpos + "px";
    this.ErrorStackTxt.style.left = "100px";
    //
    hpos = Math.max(RD3_Glb.CalcBottom(this.ErrorStackTitle), RD3_Glb.CalcBottom(this.ErrorStackTxt)) + 20;
  }
  //
  this.ContentBox.style.width = "550px";
  this.ContentBox.style.height = "370px";
  //
  this.SetWidth(600);
  this.SetHeight(400);
  this.SetLeft((document.body.offsetWidth - this.Width) / 2);
  this.SetTop((document.body.offsetHeight - this.Height) / 2);
  //
  // Chiamo la classe base
  PopupFrame.prototype.AdaptLayout.call(this);
  //
  // Dopo aver aperto la form centrata, resetto il flag in modo da poter gestire
  // la videata a piacimento
  this.Centered = false;*/
}


// ********************************************************
// Gestore del click sul pulsante torna all'applicazione
// ********************************************************
PopupError.prototype.OnClickEB = function(evento)
{
  // Chiudo la popup
  this.Close();
}


// ********************************************************
// Gestore della pressione di un pulsante
// ********************************************************
PopupError.prototype.OnKeyPress = function(evento)
{
  /*var code = (evento.charCode)?evento.charCode:evento.keyCode;
  //
  // se ho premuto invio,esc o spazio faccio chiudere il popup
  if (code == 13 || code == 32 || code == 27)
  {
    this.Close();
  }
  //
  return true;*/
}

// ********************************************************************************
// Suona se deve e apre la popup
// ********************************************************************************
PopupError.prototype.Open = function()
{ 
	// Chiamo la classe base
	PopupFrame.prototype.Open.call(this);
}
