// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe Message: gestisce un messaggio di una form
// ************************************************

function Message(pform)
{
  // Proprieta' di questo oggetto di modello
  this.Code = "";               // Codice del messaggio
  this.Text = "";            		// Testo del messaggio (html)
  this.Image = "";            	// Icona specifica del messaggio
  this.Type = 3;         				// Tipo di messaggio: 1-info, 2-warn, 3-error
  this.Temporary = true;        // Messaggio temporaneo?
  this.Request = "";            // Codice della richiesta in cui e' stato realizzato o cambiato questo messaggio
  //
  this.ParentForm = pform;      // Form che possiede il messaggio
  //
  // Variabili di collegamento con il DOM
  this.Realized = false;        // Se vero, il Timer del browser e' stato creato
  this.MyBox = null;            // Div che contiene il messaggio
  this.ImgBox = null;       		// Img per l'icona
  this.SpanText = null;       	// Span per il testo
}

// *******************************************************************
// Inizializza questo Timer leggendo i dati da un nodo <tim> XML
// *******************************************************************
Message.prototype.LoadFromXml = function(node) 
{
  // Inizializzo le proprieta' locali
	this.LoadProperties(node);
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
Message.prototype.ChangeProperties = function(node)
{
	// Semplicemente setto le proprieta' a partire dal nodo
  this.LoadProperties(node);
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
Message.prototype.LoadProperties = function(node)
{
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
    	case "cod": this.SetCode(attrnode.nodeValue); break;
    	case "txt": this.SetText(attrnode.nodeValue); break;
    	case "img": this.SetImage(attrnode.nodeValue); break;
    	case "typ": this.SetType(parseInt(attrnode.nodeValue)); break;
    	case "tem": this.SetTemporary(attrnode.nodeValue=="1"); break;
    	
    	case "id": 
    		this.Identifier = valore;
    		RD3_DesktopManager.ObjectMap.add(valore, this);
    	break;
    }
  }
  //
  this.Request = RD3_DesktopManager.CurrentRequest;
  //
  // Un messaggio temporaneo vuoto viene subito cancellato
  if (this.Realized && this.Text=="" && this.Temporary)
  {
  	this.Request = "";
  	this.ParentForm.RealizeMessages();
  }
}


Message.prototype.SetCode = function(value) 
{
	if (value!=undefined)
  	this.Code = value;
  //
	if (this.Realized)
	{
		// ???
	}
}

Message.prototype.SetText = function(value) 
{
	if (value!=undefined) {
    if (value.replace) {
      // Devo sostituire eventuali immagini presenti nel testo che mi e' arrivato con le classi di FA
      // Queste valogono per la lingua INGLESE
      value = value.replace("<img align=absmiddle src='images/find_sm.gif' alt=''>", "<i class='fa fa-search'></i>");
      value = value.replace("<img align=absmiddle src=images/unlk_sm.gif>", "<i class='fa fa-unlock'></i>");
      value = value.replace("<img align=absmiddle src=images/lock_sm.gif>", "<i class='fa fa-lock'></i>");
      value = value.replace("<img align=absmiddle src=images/update_sm.gif>", "<i class='fa fa-floppy-o'></i>");
      value = value.replace("<img align=absmiddle src=images/cancel_sm.gif>", "<i class='fa fa-times'></i>");
      value = value.replace("<img align=absmiddle src=images/upload.gif>", "<i class='fa fa-upload'></i>");
      value = value.replace("<img align=absmiddle src=images/rs.gif>", "<i class='fa fa-arrow-right'></i>");
      value = value.replace("<img align=absmiddle src=images/myes_sm.gif>", "<i class='fa fa-check'></i>");
      //
      value = value.replace("<img class=abm src='images/find_sm.gif' alt=''>", "<i class='fa fa-search'></i>");
      value = value.replace("<img class=abm src=images/unlk_sm.gif>", "<i class='fa fa-unlock'></i>");
      value = value.replace("<img class=abm src=images/lock_sm.gif>", "<i class='fa fa-lock'></i>");
      value = value.replace("<img class=abm src=images/update_sm.gif>", "<i class='fa fa-floppy-o'></i>");
      value = value.replace("<img class=abm src=images/cancel_sm.gif>", "<i class='fa fa-times'></i>");
      value = value.replace("<img class=abm src=images/upload.gif>", "<i class='fa fa-upload'></i>");
      value = value.replace("<img class=abm src=images/rs.gif>", "<i class='fa fa-arrow-right'></i>");
      value = value.replace("<img class=abm src=images/myes_sm.gif>", "<i class='fa fa-check'></i>");
      //
      // Queste per i messaggi in ITALIANO
      value = value.replace('<img align=absmiddle src="images/find_sm.gif" alt="">', "<i class='fa fa-search'></i>");
      value = value.replace('<img align=absmiddle src="images/unlk_sm.gif" alt="">', "<i class='fa fa-unlock'></i>");
      value = value.replace('<img align=absmiddle src="images/lock_sm.gif" alt="">', "<i class='fa fa-lock'></i>");
      value = value.replace('<img align=absmiddle src="images/update_sm.gif" alt="">', "<i class='fa fa-floppy-o'></i>");
      value = value.replace('<img align=absmiddle src="images/cancel_sm.gif" alt="">', "<i class='fa fa-times'></i>");
      value = value.replace('<img align=absmiddle src="images/upload.gif" alt="">', "<i class='fa fa-upload'></i>");
      value = value.replace('<img align=absmiddle src="images/rs.gif" alt="">', "<i class='fa fa-arrow-right'></i>");
      value = value.replace('<img align=absmiddle src="images/myes_sm.gif" alt="">', "<i class='fa fa-check'></i>");
      //
      value = value.replace('<img class=abm src="images/find_sm.gif" alt="">', "<i class='fa fa-search'></i>");
      value = value.replace('<img class=abm src="images/unlk_sm.gif" alt="">', "<i class='fa fa-unlock'></i>");
      value = value.replace('<img class=abm src="images/lock_sm.gif" alt="">', "<i class='fa fa-lock'></i>");
      value = value.replace('<img class=abm src="images/update_sm.gif" alt="">', "<i class='fa fa-floppy-o'></i>");
      value = value.replace('<img class=abm src="images/cancel_sm.gif" alt="">', "<i class='fa fa-times'></i>");
      value = value.replace('<img class=abm src="images/upload.gif" alt="">', "<i class='fa fa-upload'></i>");
      value = value.replace('<img class=abm src="images/rs.gif" alt="">', "<i class='fa fa-arrow-right'></i>");
      value = value.replace('<img class=abm src="images/myes_sm.gif" alt="">', "<i class='fa fa-check'></i>");
    }
    //
  	this.Text = value;
  }
  //
	if (this.Realized)
	{
    this.SpanText.innerHTML = RD3_Glb.HandleIconString(this.Text);
    //
    // Chrome, in alcuni casi, fa casino con il vertical Align... non lo propaga ai sotto-figli
    // dello span qualora presenti... meglio rinforzare il concetto...
    if (RD3_Glb.IsChrome() && this.SpanText.offsetHeight<20)
      this.SpanText.innerHTML = RD3_Glb.HandleIconString(this.Text);
	}
}

Message.prototype.SetImage = function(value) 
{
	if (value!=undefined)
  	this.Image = value;
  //
	if (this.Realized)
	{
	  if (this.Image != "")
  		this.ImgBox.src = RD3_Glb.GetImgSrc("images/"+this.Image);
    else
      this.ImgBox.removeAttribute("src");
	}
}

Message.prototype.SetType = function(value) 
{
	if (value!=undefined)
  	this.Type = value;
  //
	if (this.Realized)
	{
		// Rimuovo l'IMG ed uso FontAwesome
    if (this.Image=="" && this.ImgBox.tagName.toLowerCase() === "img") {
      this.MyBox.removeChild(this.ImgBox);
      this.ImgBox = RD3_Glb.createFAImage("");
      this.MyBox.insertBefore(this.ImgBox, this.SpanText);
    }
    //
    switch(this.Type)
    {
      case 1: // INFO
        if (this.Image=="")
          RD3_Glb.AddClass(this.ImgBox, "fa-info");
        RD3_Glb.AddClass(this.MyBox, "alert-info");
      break;

      case 2: // WARN
        if (this.Image=="")
          RD3_Glb.AddClass(this.ImgBox, "fa-exclamation-triangle");
        RD3_Glb.AddClass(this.MyBox, "alert-warning");
      break;
      
      case 3: // ERR
        if (this.Image=="")
          RD3_Glb.AddClass(this.ImgBox, "fa-exclamation");
        RD3_Glb.AddClass(this.MyBox, "alert-danger");
      break;
    }
	}
}

Message.prototype.SetTemporary = function(value) 
{
	if (value!=undefined)
  	this.Temporary = value;
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// ***************************************************************
Message.prototype.Realize = function(parent)
{
  // Eseguo l'impostazione iniziale delle mie proprieta'
  this.Realized = true;
  //
	// Creo il mio contenitore globale
  this.MyBox = document.createElement("div");
  this.MyBox.setAttribute("id", this.Identifier);
  this.MyBox.className = "alert alert-dismissible fade in form-message-cnt";
  //
  if (this.Temporary) {
    this.DismissMessageButton =  document.createElement("button");
    this.DismissMessageButton.className = "close";
    this.DismissMessageButton.setAttribute("data-dismiss","alert");
    this.DismissMessageButton.setAttribute("aria-label","Close");
    this.DismissMessageButton.appendChild(RD3_Glb.createFAImage("fa-close"));
    this.MyBox.appendChild(this.DismissMessageButton);
  }
  //
  this.ImgBox = document.createElement("img");
  this.ImgBox.setAttribute("id", this.Identifier+":img");
  this.ImgBox.className = "form-message-icon";
  //
  this.SpanText = document.createElement("span");
  this.SpanText.setAttribute("id", this.Identifier+":txt");
  this.SpanText.className = "form-message-text";
  //
  this.MyBox.appendChild(this.ImgBox);
  this.MyBox.appendChild(this.SpanText);
  parent.appendChild(this.MyBox);
  //
  this.SetImage();
  this.SetType();
  this.SetText();
  //
  var _this = this;
  $(this.MyBox).on('closed.bs.alert', function () {
    // Ok, l'utente ha chiuso il messaggio temporaneo, devo: 
    // - fare la mia Unrealize
    // - togliermi dalla lista dei messaggi della form
    _this.Unrealize();
    //
    for (var i=0; i < _this.ParentForm.Messages.length; i++)
      if (_this.ParentForm.Messages[i] === _this) {
        _this.ParentForm.Messages.splice(i,1);
        break;
      }
    //
    _this.ParentForm.RealizeMessages();
  });
}

/**
 * Chiude il messaggio
 * @param {bool} immediate - se true non fa l'animazione ma lo chiude immediatamente
 */
Message.prototype.Close = function(immediate)
{
  if (this.MyBox) {
    if (immediate) {
      this.Unrealize();
    }
    else {
      var _this = this;
      $(this.MyBox).off('closed.bs.alert');
      $(this.MyBox).on('closed.bs.alert', function () {
        _this.Unrealize();
      });
      //
      $(this.MyBox).alert('close');
    }
  }
}


// ***************************************************************
// Cancella gli oggetti DOM relativi a questo oggetto
// ***************************************************************
Message.prototype.Unrealize = function()
{
  this.Realized = false;
  //
  // Tolgo il messaggio dal video
  if (this.MyBox && this.MyBox.parentNode)
  	this.MyBox.parentNode.removeChild(this.MyBox);
  //
  // Mi rimuovo dalla mappa
  RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  this.MyBox = null;
}


// ***************************************************************
// Dice se due messaggi sono uguali
// ***************************************************************
Message.prototype.EqualsTo = function(m)
{
	return m.Text == this.Text && m.Type==this.Type && m.Temporary==this.Temporary;
}

