// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe IndHandler: gestisce la lista in memoria
// di tutti gli indicatori dell'applicazione
// ************************************************

function IndHandler()
{
  // Proprieta' di questo oggetto di modello
  this.Indicators = new Array();    // Lista degli indicatori
  this.Identifier = "inh";          // Identificatore di questo oggetto
  //
  // Variabili di collegamento con il DOM
  this.Realized = false; // Se vero, gli oggetti del DOM sono gia' stati creati
}


// **************************************************************
// Inizializza questo IndHandler leggendo i dati da un nodo XML
// **************************************************************
IndHandler.prototype.LoadFromXml = function(node) 
{
	if (node.nodeName != this.Identifier)
		return;
	//
	// Inizializzo le proprieta'
  var objlist = node.childNodes;
	var n = objlist.length;
	//
	// Ciclo sui nodi figli e aggiungo tutti gli indicatori
	for (var i=0; i<n; i++) 
  {
		var objnode = objlist.item(i);
		var nome = objnode.nodeName;
		//
		switch (nome)
		{
		  // Leggo l'indicatore contenuto
			case "ind":
      {
  			var newind = new Indicator();
  			newind.LoadFromXml(objnode);
  			this.Indicators.push(newind);
  		}
  	}
	}
	//
  // Mi Aggiungo alla mappa degli oggetti 
  RD3_DesktopManager.ObjectMap.add(this.Identifier, this);
}


// ***************************************************************
// Aggiunge un nuovo figlio a questo oggetto
// ***************************************************************
IndHandler.prototype.InsertChild = function(node)
{
  var objlist = node.childNodes;
	var n = objlist.length;
	//
	// Ciclo su tutti i nodi che rappresentano oggetti figli
	for (var i=0; i<n; i++) 
  {
		var objnode = objlist.item(i);
		var nome = objnode.nodeName;
		if (nome == "ind")
		{
    	// Creo il nuovo indicatore
      var newind = new Indicator();
      newind.LoadFromXml(objnode);
      this.Indicators.push(newind);
      //
      if (this.Realized)
        newind.Realize(RD3_DesktopManager.WebEntryPoint.StatusBarBox);
    }
  }
}


// ***************************************************************
// Crea gli oggetti DOM relativi a questo oggetto:
// L'oggetto Parent indica dove devono essere contenuti i figli
// ***************************************************************
IndHandler.prototype.Realize = function(parent)
{
  // Ciclo su tutti gli indicatori
  var n = this.Indicators.length;
  for(var i = 0; i < n; i++)
  {
    var ind = this.Indicators[i];
    //
    this.Indicators[i].Realize(parent);
  }
  //
  this.Realized = true;
}


// ********************************************************************
// Distrugge gli oggetti DOM relativi a questo oggetto e ai suoi figli
// ********************************************************************
IndHandler.prototype.Unrealize = function()
{
  var n = this.Indicators.length;
  for(var i = 0; i < n; i++)
  {
    this.Indicators[i].Unrealize();
  }
  //
  // Mi rimuovo dalla mappa
  RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  this.Realized = false;
}


// ********************************************************************
// Metodo che gestisce il ridimensionamento e la dimensione
// degli indicatori dinamici
// ********************************************************************
IndHandler.prototype.AdaptLayout = function()
{
  
}


// *****************************************************************************
// Segnala che la form attiva e' cambiata: cicla su tutti i figli passandogli il 
// messaggio
// *****************************************************************************
IndHandler.prototype.ActiveFormChanged = function()
{ 
  var n = this.Indicators.length;
  for(var i = 0; i < n; i++)
  {
    this.Indicators[i].ActiveFormChanged();
  }
}
