
//################################
// NES Custom code to have the favicon
// src: http://forum.progamma.com/viewtopic.php?f=5&t=83355&p=146540&hilit=favicon#p146540
// moreover to have the favicon on the login page too in login1.htm we added in head this:
// <link href="favicon.ico" rel="shortcut icon">
//################################

function RD3_CustomInit()
{
// adding favicon
var favicon = document.createElement("link");
favicon.setAttribute("rel", "shortcut icon");
favicon.setAttribute("href", "images/favicon.ico");
document.getElementsByTagName("head")[0].appendChild(favicon);
}


WebEntryPoint.prototype.OnResize = function (evento)
{
  // Devo gestire in modo particolare la tastiera
  if (RD3_Glb.IsAndroid()) {
    // Se ho le dimensioni impostate significa che la tastiera si e' aperta, in questo caso se il resize
    // porta ad una videata più alta dell'ultimo resize signifca che si è chiusa la tastiera:
    // in questo caso togliamo le dimensioni impostate
	// ********************************************************
	//
	// Abbiamo visto che a volte arriva un resize spurio, in cui arriva l'altezza piu' alta di 30-40 px ma la testiera rimane comunque aperta...
	//
	// && (window.innerHeight - window.lastHeight > 100) aggiunto nella riga qui sotto in assistenza 001196-2021 del 29/04/2021
    if (document.body.style.width != "" && document.body.style.height != "" && window.innerHeight > window.lastHeight && (window.innerHeight - window.lastHeight > 100)) {
      document.body.style.width = "";
      document.body.style.height = "";
      document.body.style.transform = "";
      // 
      // Togliamo il fuoco all'elemento attivo
      if (document.activeElement && document.activeElement.blur)
        document.activeElement.blur();  
    }
    //
    // Ho le dimensioni impostate, un oggetto con il fuoco e l'altezza si è ridotta :
    // si è aperta la tastiera! In questo caso ho tutte le informzioni sufficienti per portare a video il campo con il fuoco
    if (document.activeElement && document.body.style.width != "" && document.body.style.height != "" && window.innerHeight < window.lastHeight) {
      var top = document.activeElement.getBoundingClientRect().top;
      if (window.currentHeight - top < window.innerHeight)
        top = top - (window.currentHeight - window.innerHeight);
      document.body.style.transform = "translate3d(0px, -"+top+"px, 0px)";
    }
    //
    // Current mi servono per fissare le dimensioni della pagina all'apertura della tastiera,
    // last mi serve per capire se la tastiera si e' aperta o chiusa
    if (document.body.style.width == "" && document.body.style.height == "") {
      window.currentHeight = window.innerHeight;
      window.currentWidth = window.innerWidth;
    }
    //
    window.lastHeight = window.innerHeight;
    window.lastWidth = window.innerWidth;
  }
  //
  // Resize, chiudo anche i popup aperti che potrebbero andare fuori posto
  this.CmdObj.ClosePopup();
  //
  // Eseguo il resize ritardato
  if (this.ResizeTimerId > 0)
    window.clearTimeout(this.ResizeTimerId);
  this.ResizeTimerId = window.setTimeout("RD3_DesktopManager.WebEntryPoint.TickResize()", 200);
}