// ***************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe IDCombo: Gestisce una Combo personalizzata
// ***************************************************

function IDCombo(owner)
{
  this.Identifier = "";           // Identificativo della combo
  this.Owner = owner;             // Possessore della combo
  //  
  this.Left = 0;
  this.Top = 0;
  this.Width = 0;
  this.Height = 0;
  this.Enabled = true;
  this.Visible = true;
  this.RightAlign = false;        // Il testo nella combo e' allineato a destra?
  this.ShowActivator = true;      // Indica se occorre mostrare l'attivatore
  this.Tooltip = "";              // Tooltip della combo
  this.Clickable = false;         // Combo cliccabile quando disabilitata?
  this.Badge = "";                // Badge della combo
  //
  this.ComboInput = null;         // Input della combo
  this.ComboActivator = null;     // Attivatore della combo
//this.ComboBadge = null;         // Badge della combo
  this.ComboImgBox = null;        // Contenitore Immagine interna alla combo
  this.ComboImg = null;           // Immagine interna alla combo
  this.ComboPopup = null;         // Popup contenente le righe della combo
  this.UsePopover = false;        // Deve sempre usare un popover?
//  this.ComboPopupInput = null;  // Input fittizio usato per editing nel caso di combo che mostra i valori
//  this.ComboPopupTimer = 0;     // Timer usato per riposizionare il popup
  //
  this.IsOpen = false;            // Indica se la combo e' "aperta"
  this.ListOwner = true;          // Indica se la combo "possiede" la sua lista o le puo' essere messa e tolta
  this.IsOptional = false;        // Indica se la combo ammette il valore vuoto
  this.AllowFreeText = false;     // Indica se la combo ammette che venga lasciato un valore non presente nella lista
  this.ShowValue = false;         // Indica se la combo mostra il valore e non il nome dell'item
  this.Writable = true;           // Indica se l'input della Combo deve essere scrivibile o meno
  this.ActImage = "";             // Immagine da utilizzare per l'eventuale attivatore presente se la combo ha un oggetto di attivazione associato
  this.ActWidth = RD3_ClientParams.ComboActivatorSize;  // Larghezza attivatore (se presente)
//  this.ActEnaIfComboDis = false;// Indica se l'attivatore della combo e' abilitato anche se la combo e' disabilitata
  //
  this.OptionList = null;         // ValueList associata alla combo
  this.VisualStyle = null;        // Stile visuale della combo
  this.SelItems = new Array();    // Items selezionati nella combo
  this.PreviousInputText = "";    // Testo presente nell'input della combo per gestire bene il delta nel KeyUp
  this.OriginalText = "";         // Testo originale presente nell'input (usato per chiusura combo con UNDO)
  //this.ComboUpper=false;      // Il popup della combo si trova sopra o sotto il valore? (inizializzato al volo quando serve..)
  //this.AnimatingCombo=false          // C'e' una animazione in corso?
  this.MultiSel = true;           // Indica se la combo e' multiselezionabile
  this.ValueSep = ";";            // Separatore dei valori
  this.HLItem = null;
  
  //this.HasWatermark = false;    // La combo ha un watermark?
  //this.ClassName;               // Classe esterna associata al campo
}

// ***************************************************
// Crea gli oggetti visuali della Combo. Puo' essere
// chiamata anche per "duplicare" la combo
// ***************************************************
IDCombo.prototype.Realize = function(container, cls) 
{
  // Se non mi hanno ancora assegnato un identificativo, lo creo e mi inserisco nella mappa
  if (this.Identifier == "") {
    this.Identifier = "cmb:" + Math.floor(Math.random() * 1000000000);
    RD3_DesktopManager.ObjectMap.add(this.Identifier, this);
  }
  //
  // L'input c'e' sempre!
  if (!this.ComboInput)
  {
    this.ComboInput = document.createElement("input");
    this.ComboInput.type = "text";
    this.ComboInput.className = "form-control";
    this.ComboInput.setAttribute("id", this.Identifier);
    RD3_Glb.AutocompleteOff(this.ComboInput);
    if (this.Owner.SetZIndex)
      this.Owner.SetZIndex(this.ComboInput);
  }
  container.appendChild(this.ComboInput);
  //
  // Attacco gli eventi
  var parentContext = this;
  this.ComboInput.onkeydown = function(ev) { parentContext.OnKeyDown(ev); };
  //
  // Se non e' IE attacco gli eventi di focus
  if (!RD3_Glb.IsIE(10, false))
  {
    this.ComboInput.onfocus = function(ev) { RD3_KBManager.IDRO_GetFocus(ev); };
    this.ComboInput.onblur = function(ev) { RD3_KBManager.IDRO_LostFocus(ev); };
    //
    // In firefox l'evento di doppio click non arriva al body
    if (RD3_Glb.IsFirefox(3))
      this.ComboInput.ondblclick = function(ev) { RD3_KBManager.IDRO_DoubleClick(ev); };
  }
  //
  // Se e' stata fornita una classe particolare, la aggiungo
  if (cls)
    RD3_Glb.AddClass(this.ComboInput, cls);
  //
  // Se deve essere mostrato l'attivatore, lo creo
  if (this.ShowActivator)
  {
    if (!this.ComboActivator)
    {
      this.ComboActivator = document.createElement("span");
      this.ComboActivator.className = "input-group-btn";
      this.ComboActivator.style.width = (this.ActWidth + 3) + "px";
      //
      // Creo il bottone interno
      this.ActButton = document.createElement("button");
      this.ActButton.className = "btn btn-default";
      this.ActButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_COMBOACT));
      this.ComboActivator.appendChild(this.ActButton);
      //
      // E' nato l'attivatore... meglio riapplicare il VS appena posso... magari mi
      // hanno clonato da una combo che non aveva il vs
      this.VisualStyle = null;
    }
    if (this.RightAlign)
      container.insertBefore(this.ComboActivator, this.ComboInput);
    else
      container.appendChild(this.ComboActivator);
    //
    // Attacco l'evento (in Mobile non serve attaccare all'attivatore l'evento perche' e' l'intera combo che e' cliccabile/toccabile)
    this.ActButton.onclick = function(ev) { parentContext.OnClickActivator(ev); };
  }
  //
  // Se ho l'immagine, aggiungo anche lei al container
  if (this.ComboImgBox)
    container.appendChild(this.ComboImgBox);
}

// ***************************************************
// Elimina gli oggetti visuali usati dalla Combo
// ***************************************************
IDCombo.prototype.Unrealize = function() 
{
  // Mi tolgo dalla mappa
  RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  //
  // Se ero aperta, mi chiudo
  if (this.IsOpen)
    this.Close();
  //
  if (this.ComboInput)
  {
    // Rimuovo il tooltip se presente
    RD3_TooltipManager.SetObjTitle(this.ComboInput, "");
    //
    if (this.ComboInput.parentNode)
      this.ComboInput.parentNode.removeChild(this.ComboInput);
    this.ComboInput = null;
  }
  if (this.ComboImg)
  {
    if (this.ComboImg.parentNode)
      this.ComboImg.parentNode.removeChild(this.ComboImg);
    this.ComboImg = null;
  }
  if (this.ComboImgBox)
  {
    if (this.ComboImgBox.parentNode)
      this.ComboImgBox.parentNode.removeChild(this.ComboImgBox);
    this.ComboImgBox = null;
  }
  if (this.ComboActivator)
  {
    if (this.ComboActivator.parentNode)
      this.ComboActivator.parentNode.removeChild(this.ComboActivator);
    this.ComboActivator = null; 
  }
  if (this.ComboPopup)
  {
    if (this.ComboPopup.parentNode)
      this.ComboPopup.parentNode.removeChild(this.ComboPopup);
    this.ComboPopup = null; 
  }
  if (this.ComboPopupInput)
  {
    if (this.ComboPopupInput.parentNode)
      this.ComboPopupInput.parentNode.removeChild(this.ComboPopupInput);
    this.ComboPopupInput = null;
  }
  if (this.IDScroll)
  {
    this.IDScroll.Unrealize();
    this.IDScroll = null;
  }
  if (this.CloneElem)
  {
    this.CloneElem.parentNode.removeChild(this.CloneElem);
    this.CloneElem = null;
  }
  //
  if (this.ComboBadge)
  {
    if (this.ComboBadge.parentNode)
      this.ComboBadge.parentNode.removeChild(this.ComboBadge);
    this.ComboBadge = null; 
  }
}


// ***************************************************
// Comunica alla combo se e' presente o meno l'attivatore
// ***************************************************
IDCombo.prototype.SetShowActivator = function(sh)
{
  this.ShowActivator = sh;
  if (!this.ShowActivator && this.ComboActivator)
    RD3_Glb.SetDisplay(this.ComboActivator, "none");
}


// ***************************************************
// Imposta lo stato di cliccabilita' della combo quando e' disabilitata
// ***************************************************
IDCombo.prototype.SetComboClickable = function(clk)
{
  // Se e' cambiato lo stato
  if (clk != this.Clickable)
  {
    // Cambio il valore
    this.Clickable = clk;
    //
    // Se sono disabilitata forse e' il caso di cambiare il cursore..
    if (!this.Enabled)
      this.UpdateCursor();
  }
}


// ***************************************************
// Imposta lo stato di abilitazione della combo
// ***************************************************
IDCombo.prototype.SetEnabled = function(value) 
{
  // Se e' cambiato lo stato
  if (value != this.Enabled)
  {
    this.Enabled = value;
    //
    if (this.Enabled)
      this.ComboInput.removeAttribute("disabled");
    else
      this.ComboInput.setAttribute("disabled",true);
    //
    if (this.Enabled)
    {
      // Mostro l'attivatore solo se la combo lo prevede
      if (this.ComboActivator && this.ShowActivator && this.ActWidth>=0  && this.Visible)
        RD3_Glb.SetDisplay(this.ComboActivator, "");
    }
    else
    {
      if (this.ComboActivator)
        RD3_Glb.SetDisplay(this.ComboActivator, (this.Visible && this.ActWidth >= 0 && this.ActImage!="" && this.ActEnaIfComboDis ? "" : "none"));
    }
    //
    // Se il VisualStyle dice che non occorre mostrare la descrizione
    if (this.SelItems.length>0 && !this.ShowDescription(this.VisualStyle)) {
      // Devo mostrare o meno il valore a seconda se sono abilitata o meno
      this.SetComboValue(this.Enabled?this.GetComboFinalName(this.ShowValue):"");
    }
    //
    // Aggiorno il cursore della combo
    this.UpdateCursor();
    //
    // Aggiorno l'immagine (cliccabile/non cliccabile?)
    this.UpdateImage();
  }
}


// ********************************************************************************
// Aggiorna il cursore della combo
// ********************************************************************************
IDCombo.prototype.UpdateCursor= function()
{
  // Se il VS non ha un suo cursor, applico il default
  if (this.VisualStyle && this.VisualStyle.GetCursor()=="")
  {
    // Se la combo e' disabilitata e cliccabile, uso POINTER
    if (!this.Enabled && this.Clickable)
      this.ComboInput.style.cursor = "pointer";
    else
      this.ComboInput.style.cursor = (this.Enabled ? "" : "default");
  }
}

// ***************************************************
// Imposta lo stato di visibilita' della combo
// ***************************************************
IDCombo.prototype.SetVisible = function(value) 
{
  // Se e' cambiato lo stato
  if (value != this.Visible)
  {
    this.Visible = value;
    //
    // Aggiorno la visibilita' degli oggetti della combo
    this.ComboInput.style.visibility = (this.Visible ? "" : "hidden");
    if (this.ComboImgBox)
      this.ComboImgBox.style.visibility = (this.Visible && this.ComboImg.src!="" ? "" : "hidden");
    //
    // Nella setEnabled c'e' anche il controllo this.ActImage!="" , qui mancava
    // pero' la logica e' strana:
    //  - se la combo e' abilitata il controllo non ci deve essere
    //  - se e' disabilitata si. credo che dipenda dal flag ActEnaIfComboDis che e' true ma vale solo se c'e' il vero attivatore, non quello delle combo
    // quindi l'ho usato per spegnere il flag in quel caso (se e' !enabled il primo ramo dell'OR torna false)
    if (this.ComboActivator)
      RD3_Glb.SetDisplay(this.ComboActivator, this.Visible && this.ShowActivator && this.ActWidth>=0 && (this.Enabled || (this.ActEnaIfComboDis && this.ActImage!="")) ? "" : "none");
    if (this.ComboPopup)
      this.ComboPopup.style.visibility = (this.Visible ? "" : "hidden");
    if (this.ComboPopupInput)
      this.ComboPopupInput.style.visibility = (this.Visible ? "" : "hidden");
  }
}


// ***************************************************
// Indica che la combo deve permettere inserimenti
// tramite maschera
// ***************************************************
IDCombo.prototype.SetMasked = function(msk)
{
  // Per gestire l'input mascherato devo girare il messaggio di change al KBManager
  // che, a sua volta, lo gira al maschedinp.js
  var oc = function(ev) { RD3_KBManager.IDRO_OnChange(ev); };
  if (RD3_Glb.IsIE(10, false))
  {
    if (msk)
      this.ComboInput.attachEvent("onchange",oc);
    else
      this.ComboInput.detachEvent("onchange",oc);
  }
  else
    this.ComboInput.onchange = (msk ? oc : null);
}


// ***************************************************
// Indica che la combo deve mostrare il valore e non
// la descrizione associata agli item della lista
// ***************************************************
IDCombo.prototype.SetShowValue = function(sh)
{
  this.ShowValue = sh;
  //
  // Se non mostro il valore, allora posso usare l'autocomplete dell'input.
  // Altrimenti devo usare il campo fittizio e l'onkeyup e' il suo
  var parentContext = this;
  if (!this.ShowValue)
    this.ComboInput.onkeyup = function(ev) { parentContext.OnKeyUp(ev); };
  else
    this.ComboInput.onkeyup = null;
}


// ***************************************************
// Assegna l'identificativo alla combo
// ***************************************************
IDCombo.prototype.SetID = function(id)
{
  this.ComboInput.setAttribute("id", id);
  if (this.Owner.SetZIndex)
  {
    this.Owner.SetZIndex(this.ComboInput);
    if (this.ComboActivator)
      this.Owner.SetZIndex(this.ComboActivator);
    if (this.ComboImgBox)
      this.Owner.SetZIndex(this.ComboImgBox);
  }
}


// ***************************************************
// Imposta il tabIndex della combo
// ***************************************************
IDCombo.prototype.SetTabIndex = function (tindex) 
{
  this.ComboInput.setAttribute("tabIndex", tindex);
}


// ***************************************************
// Imposta lo stile visuale della combo
// ***************************************************
IDCombo.prototype.SetVisualStyle = function(vs, skipinput, force)
{
  this.VisualStyle = vs;
  if (this.VisualStyle != vs || force)
  {
    // E' cambiato
    var oldvs = this.VisualStyle;
    this.VisualStyle = vs;
    //
    // Lo applico all'input se devo
    if (!skipinput)
    {
      vs.ApplyValueStyle(this.ComboInput);
      //
      // Ho toccato lo stile visuale... Devo resettare lo stato della cache per quel
      // che riguarda i padding (che sono sicuramente stati toccati)
      this.PaddingRight = undefined;
      this.PaddingLeft = undefined;
    }
    //
    // Aggiorno il cursore della combo
    this.UpdateCursor();
    //
    // Se ho l'attivatore, applico lo stile anche a lui
    if (this.ComboActivator)
      this.UpdateActivator();
    //
    // E' cambiato lo stile... se e' cambiato il valore del flag SHOWDESCRIPTION, devo tenerne conto
    if (this.SelItems.length>0)
    {
      // Devo mostrare o meno il valore a seconda se sono abilitata o meno
      if (this.ShowDescription(this.VisualStyle) && !this.ShowDescription(oldvs))
        this.SetComboValue(this.GetComboFinalName(this.ShowValue));
      else if (!this.Enabled && !this.ShowDescription(this.VisualStyle) && this.ShowDescription(oldvs))
        this.SetComboValue("");
    }
    //
    // Se sono aperta, mi aggiorno
    if (this.IsOpen)
      this.Open(true);
  }
}

// ***************************************************
// Imposta il tooltip della combo
// ***************************************************
IDCombo.prototype.SetTooltip = function(tip)
{
  if (tip != this.Tooltip)
  {
    this.Tooltip = tip;
    //
    // Calcolo il tooltip della combo tenendo conto degli item interni
    if (this.Tooltip == "" && this.SelItems.length>0)
      tip = this.SelItems[0].Tooltip;
    //
    RD3_TooltipManager.SetObjTitle(this.ComboInput, tip);
  }
}

// ***************************************************
// Imposta il right align della combo
// ***************************************************
IDCombo.prototype.SetRightAlign = function(rig)
{
  if (rig != this.RightAlign)
  {
    this.RightAlign = rig && !RD3_ServerParams.RightAlignedIcons;
    //
    this.ComboInput.style.textAlign = (rig ? "right" : "left");
    //
    // Se la combo e' gia' nel DOM sposto i valori, ma se è una combo clonata ancora non è nel DOM,
    // non faccio nulla perchè verrà ricostruita dopo e quindi andrà a posto da sola
    if (this.ComboActivator && this.ComboActivator.parentNode) {
      var container = this.ComboActivator.parentNode; 
      container.removeChild(this.ComboActivator);
      if (this.RightAlign)
        container.insertBefore(this.ComboActivator, this.ComboInput);
      else 
        container.appendChild(this.ComboActivator);
    }
  }
}

// ***************************************************
// Imposta l'immagine di attivazione della combo
// ***************************************************
IDCombo.prototype.SetHasActivator = function(actimg, actwidth, actifdisab, cloned)
{
  if (actimg != this.ActImage || (actwidth-2) != this.ActWidth)
  {
    this.ActImage = actimg;
    this.ActWidth = actwidth-2;
    this.ActEnaIfComboDis = actifdisab;
    //
    // Aggiorno l'icona dell'attivatore
    var img = (this.ActImage === "aeco.gif" || !this.ActImage) ? RD3_ClientParams.FA_ICON_COMBOACT : this.ActImage;
    if (img === "aelo.gif")
      img = RD3_ClientParams.DefaultActImg;
    if (img === "aeda.gif")
      img = RD3_ClientParams.DefaultDateActImg;
    if (this.ActButton.firstChild)
      RD3_Glb.updateFAImage(this.ActButton, img);
    else
      this.ActButton.appendChild(RD3_Glb.createFAImage(img));
    //
    // Aggiorno lo stato di visibilita' dell'attivatore
    RD3_Glb.SetDisplay(this.ComboActivator, (this.Visible && this.ActWidth >= 0 && (this.Enabled || (this.ActImage!="" && this.ActEnaIfComboDis)) ? "" : "none"));
  }
}

// ***************************************************
// Metodo necessario per fornire la lista alla combo
// ***************************************************
IDCombo.prototype.AssignValueList = function(list, created)
{
  // Se sono aperta, su mobile, non uso un popover e sono durante il resize, skippo questo aggiornamento
  if (this.IsOpen && RD3_Glb.IsMobile() && !this.UsePopover && RD3_DesktopManager.WebEntryPoint.InResize)
    return;
  //
  var oldlist = this.OptionList;
  this.OptionList = list;
  //
  // Gestione del Watermark come nome dell'item vuoto opzionale
  if (this.Owner && this.Owner.ParentField && this.Owner.ParentField.UseWatermarkAsNull() && this.OptionList)
  {
    for (var vidx=0; vidx<this.OptionList.ItemList.length; vidx++) 
    {
      var vi = this.OptionList.ItemList[vidx];
      //
      // Cerco l'item opzionale (Nome e valore vuoti oppure valore LKENULL)
      if ((vi.Name == "" && vi.Value == "") || vi.Value == "LKENULL")
      {
        // Assegno il watermark alla lista
        vi.Name = this.Owner.ParentField.WaterMark;
        vi.OrgNames = this.Owner.ParentField.WaterMark;
        break;
      }
    }
  }
  //
  var superact = this.Owner.ParentField && this.Owner.ParentField.HasValueSource && this.Owner.ParentField.SuperActive && this.ActClicked;
  //
  // Se e' cambiata la lista, la selezione e' invalida! Cerco l'item nella nuova lista
  if (oldlist != this.OptionList)
  {
    // Se ho una lista
    if (this.OptionList)
    {
      // Se avevo una selezione, cerco di mantenerla
      if (this.MultiSel && !this.ListOwner)
        this.SelItems = this.OptionList.FindItemsLKE();
      else if (this.SelItems.length>0)
        this.SelItems = this.OptionList.FindItemsByArray(this.SelItems);
      else
      {
        this.SelItems = this.OptionList.FindItemsByValue(this.ComboInput.value, !this.ShowValue, this.ValueSep, !this.ListOwner);
        //
        // Caso particolare di LKE con PREVVAL
        if (this.SelItems.length==0 && !this.ListOwner)
        {
          this.SelItems = this.OptionList.FindItemsByValue("(" + this.ComboInput.value + ")", !this.ShowValue, this.ValueSep);
          //
          // MOBILE: Scelgo il primo valore se non ho trvato nulla..
          if (RD3_Glb.IsMobile() && this.SelItems.length==0)
            this.SelItems.push(this.OptionList.ItemList[0]);
        }
      }
    }
    else
    {
      // Non ho piu' una lista... la selezione e' invalida!
      this.SelItems = new Array();
    }
  }
  //
  // Se non avevo la lista ed ora ce l'ho ma non sono stato appena creato, apro subito il popup
  if ((oldlist==null || superact) && list && !created && this.ActClicked)
  {
    // Se non ho un item selezionato e c'e' un valore nell'input, posso filtrare
    if ((this.SelItems.length==0 || this.MultiSel || superact) && this.ComboInput.value!="")
    {
      // Se sono list-owner
      if (this.ListOwner)
      {
        // Filtro. Se la selezione non mostrerebbe nessun oggetto, li mostro tutti! (ma non per valuesource superattive)
        if (superact)
          this.OptionList.FilterComboItem(this.ComboInput.value, true);
        else if (this.OptionList.FilterComboItem(this.ComboInput.value, true) == 0)
          this.OptionList.FilterComboItem("");
      }
      else
      {
        // Evidenzio solamente gli item della lista
        this.OptionList.FilterComboItem(this.ComboInput.value, true, true);
      }
      //
      // In caso di superactive, resetto la selezione
      if (superact && this.SelItems)
      	this.SelItems.length = 0;
      //
      this.HLItem = this.OptionList.GetNextVisibleItem(null);
      if (this.SelItems.length==0 && !this.MultiSel)
      {
        // Seleziono il primo item visibile della lista
        if (this.HLItem)
          this.SelItems.push(this.HLItem);
      }
      //
      // E aggiorno la lista!
      this.Open(true);
    }
    else
    {
	    // Apro la combo e basta
	    this.Open();    	
    }  	
  }
  else if (oldlist && !list)
  {
    // Se avevo la lista e non ce l'ho piu', chiudo la combo se era aperta!
    if (this.IsOpen)
      this.Close(true);
  }
  else if (oldlist && list && !oldlist.Equals(list) && this.IsOpen)
  {
    // Se mi e' arrivata una lista diversa e ero gia' aperta, apro la combo
    this.Open();
  }
  else if (oldlist && list && oldlist!=list && this.ActClicked)
  {
    // Se mi e' arrivata una lista diversa (anche se ha gli stessi valori) e avevo cliccato sull'attivatore, apro la combo
    this.Open();
  }
  else if (this.Open && oldlist && list && oldlist.Equals(list)) {
    // Mi e' stata riassegnata la stessa lista ed ero gia' aperta: puo' succedere in alcuni casi speciali
    // (evento di onfocus)
    // Per prima cosa devo spostare i TR dalla lista vecchia a quella attuale (essendo uguali gli item sono nelle stesse posizioni)
    for (var ix = 0; ix < oldlist.ItemList.length; ix++)
      list.ItemList[ix].TR = oldlist.ItemList[ix].TR;
  }
  //
  // Quand'anche avessi cliccato sulla combo, ora non mi interessa piu'
  if (this.OptionList)
    this.ActClicked = false;
}


// ***************************************************
// Imposta il testo presente nella combo
// ***************************************************
IDCombo.prototype.SetText = function(txt, isvalue, closecombo)
{
  // Eventuali svuotamenti ritardati sono stati gestiti
  this.DeferEmpty = false;
  //
  // Se ho una lista e non sono list-owner, comanda la lista che mi hanno dato
  // In questo caso non accetto modifiche al testo (solo se sono la cella fuocata!)
  if (this.OptionList && !this.ListOwner && txt!="" && closecombo && this.Owner==RD3_DesktopManager.WebEntryPoint.HilightedCell)
    return;
  //
  this.SelItems = new Array();
  //
  // Se ho una lista cerco testo tra i valori (cerco per nome/valore a seconda del parametro isvalue - anche il separatore deve essere adatto in base al tipo di ricerca)
  if (this.OptionList && !(!txt && this.Owner.PValue && this.Owner.PValue.IsNewRow()))
    this.SelItems = this.OptionList.FindItemsByValue(txt, !isvalue, isvalue ? this.ValueSep : RD3_ClientParams.ComboNameSeparator);
  //
  // Aggiorno l'immagine
  this.UpdateImage();
  //
  // Se ho un item selezionato il testo nella combo e' il nome dell'item
  if (this.SelItems.length>0)
  {
    // Se il VisualStyle dice che non occorre mostrare la descrizione
    if (!this.Enabled && !this.ShowDescription(this.VisualStyle))
      this.SetComboValue("");
    else
      this.SetComboValue(this.GetComboFinalName(this.ShowValue));
  }
  else
    this.SetComboValue(txt);
  //
  // Memorizzo il testo attualmente presente nell'input (per gestire bene il KeyUp)
  this.PreviousInputText = this.ComboInput.value;
  //
  // Memorizzo il testo originale presente nell'input
  this.OriginalText = this.ComboInput.value;
  //
  // Se mi chiedono di chiudere la combo, lo faccio
  // (forse il server ha inviato un valore diverso da prima ed io mi devo allineare)
  if (closecombo && this.IsOpen)
    this.Close();
}


// ***************************************************
// Ritorna il valore/nome corrente della combo
// ***************************************************
IDCombo.prototype.GetComboValue = function()
{
  if (!this.ListOwner && this.IsOpen)
   {
    var dummyInp = (this.ComboPopupInput && this.ComboPopupInput.style.display=="");
    if (RD3_Glb.IsMobile() && dummyInp)
    {
      var s = this.ComboPopupInput.value; 
      if (s=="") s="*";
      return s;
    }
    else
      return this.ComboInput.value;
  }
  //
  return (this.SelItems.length>0 ? this.GetComboFinalName(true) : this.ComboInput.value);
}
IDCombo.prototype.GetComboName = function()
{
  if (!this.ListOwner && this.IsOpen)
    return this.ComboInput.value;
  //
  return (this.SelItems.length>0 ? this.GetComboFinalName(this.ShowValue) : this.ComboInput.value);
}
IDCombo.prototype.GetComboFinalName = function(ShowValue)
{
  var val = "";
  var sep = (ShowValue ? this.ValueSep : RD3_ClientParams.ComboNameSeparator);
  var n = this.SelItems.length;
  for (var j=0; j<n; j++)
    val += (val.length>0 ? sep : "") + (ShowValue ? this.SelItems[j].Value : this.SelItems[j].Name);
  //
  return val;
}


// ***************************************************
// Aggiorna lo stile dell'attivatore
// ***************************************************
IDCombo.prototype.UpdateActivator = function()
{
  /*
  // Copio BackGroundColor e Border dall'INPUT
  var sa = this.ComboActivator.style;
  var si = this.ComboInput.style;
  sa.backgroundColor = si.backgroundColor;
  sa.paddingTop = si.paddingTop;  
  sa.paddingBottom = si.paddingBottom;
  //
  // I bordi left/right li devo prendere da chi ancora li ha (potrebbero averli gia' tolti)
  var bw = (this.RightAlign ? si.borderRightWidth : si.borderLeftWidth);
  var bc = (this.RightAlign ? si.borderRightColor : si.borderLeftColor);
  var bs = (this.RightAlign ? si.borderRightStyle : si.borderLeftStyle);
  sa.borderTopWidth = si.borderTopWidth;
  sa.borderBottomWidth = si.borderBottomWidth;
  sa.borderLeftWidth = bw;
  sa.borderRightWidth = bw;
  sa.borderTopStyle = si.borderTopStyle;
  sa.borderBottomStyle = si.borderBottomStyle;
  sa.borderLeftStyle = bs;
  sa.borderRightStyle = bs;
  sa.borderTopColor = si.borderTopColor;
  sa.borderBottomColor = si.borderBottomColor;
  sa.borderLeftColor = bc;
  sa.borderRightColor = bc;
  //
  // L'attivatore non ha il bordo sx/dx
  if (this.RightAlign)
    sa.borderRight = "";
  else
    sa.borderLeft = "";
    */
}


// ***************************************************
// Aggiorna l'immagine presente nella combo
// ***************************************************
IDCombo.prototype.UpdateImage = function()
{
  var oldimg = (this.ComboImgBox ? this.ComboImgBox.style.display : "none");
  //
  // Se ho un item selezionato
  if (this.SelItems.length>0)
  {
    // Se l'item ha un'immagine
    if (this.SelItems[0].Image!="")
    {
      // Se non ho ancora creato l'immagine, lo faccio ora
      if (!this.ComboImgBox)
      {
        this.ComboImgBox = document.createElement("span");
        this.ComboImgBox.className = "input-group-addon";
        if (this.Owner.SetZIndex)
          this.Owner.SetZIndex(this.ComboImgBox);
        //
        this.ComboImg = document.createElement("IMG");
        this.ComboImg.className = "combo-img";
        this.ComboImgBox.appendChild(this.ComboImg);
        //
        // Se ho gia' posizionato l'input, inserisco anche l'immagine
        if (this.ComboInput.parentNode) {
          this.ComboInput.parentNode.insertBefore(this.ComboImgBox, this.ComboInput);
          //
          // Imposto l'altezza corretta
          this.SetHeight();
        }
      }
      else
      {
        if (this.ComboImgBox.style.display == "none")
          this.ComboImgBox.style.display = "";
      }
      //
      this.ComboImg.src = RD3_Glb.GetImgSrc("images/"+this.SelItems[0].Image)
    }
    else
    {
      // L'item non ha un'immagine. Nascondo l'immagine se ce l'ho
      if (this.ComboImgBox)
        this.ComboImgBox.style.display = "none";
    }
  }
  else
  {
    // Non ho un item selezionato. Nascondo l'immagine se ce l'ho
    if (this.ComboImgBox)
      this.ComboImgBox.style.display = "none";
  }
  //
  // Se il VS non ha un suo cursor, applico il default
  if (this.ComboImg && this.VisualStyle && this.VisualStyle.GetCursor()=="")
  {
    // Se la combo e' disabilitata e cliccabile, uso POINTER
    if (!this.Enabled && this.Clickable)
      this.ComboImg.style.cursor = "pointer";
    else
      this.ComboImg.style.cursor = (this.Enabled ? "" : "default");
  }
}

// ***************************************************
// Imposta le coordinate della combo
// ***************************************************
IDCombo.prototype.SetLeft = function(x)
{
  /*
  // Per cominciare l'input
  this.Left = x;
  if (this.RightAlign && this.ComboActivator && this.ComboActivator.style.display=="")
    this.ComboInput.style.left = this.Left + this.ActWidth+1 + (RD3_ServerParams.Theme == "zen" ? (this.RightAlign && this.Owner.InList ? -4 : -10) : 0) + "px";
  else
    this.ComboInput.style.left = this.Left + "px";
  //
  // Se ho l'attivatore posiziono anche lui
  if (this.ComboActivator)
    this.ComboActivator.style.left = this.Left + (this.RightAlign ? 0 : this.Width-this.ActWidth-2 - (this.Owner instanceof BookSpan ? 2 : 0) + (RD3_ServerParams.Theme == "zen" ? (this.Owner.InList ? 7 : 1) : 0)) + "px";
  //
  // Se ho l'immagine posiziono anche lei
  if (this.ComboImg && this.ComboImg.style.display=="")
  {
    // L'immagine va a sinistra e uso il padding per rendere inaccessibile l'area coperta dall'immagine
    this.ComboImg.style.left = (this.Left + 2) + "px";
    //
    if (RD3_Glb.IsMobile())
    {
      // Applico i padding dal VS all'immagine invece che all'input, di default il tema mobile ha i padding custom applicati
      // agli Input, dato che se c'e' l'immagine questa va prima degli input e' a lei che devo dare i padding
      var pad = 0;
      if (this.VisualStyle && this.VisualStyle.GetBorders(1)==9)
      {
        pad = this.VisualStyle.GetCustomPadding(4)/4;
        this.ComboImg.style.paddingLeft = pad + "pt"; // Padding in quarti di pt
      }
      //
      this.ComboInput.style.paddingLeft = (pad + RD3_ClientParams.ComboImageSize + 3 + 4 + 4) + "px";
    }
    else
    {
      this.ComboInput.style.paddingLeft = (2+RD3_ClientParams.ComboImageSize+1) + "px";    // 2px padding + immagine
    }
  }
  else
  {
    // Immagine non presente o immagine invisibile... niente padding
    this.ComboInput.style.paddingLeft = "";
  }
  //
  // Se ho il Badge posiziono anche lui
  if (this.ComboBadge != null)
  {
    var bLeft = this.Left + (this.Width - RD3_Glb.GetBadgeWidth(this.Badge, "grey") - 2);
    if (RD3_Glb.IsMobile())
      bLeft =  bLeft + 6;
    //
    if (this.ComboActivator && this.ComboActivator.style.display == "")
      bLeft = bLeft - this.ActWidth + (RD3_Glb.IsMobile() ? 0 : -6);
    else
    {
      // Ci sono solo io... sposto il badge il piu' a destra possibile
      bLeft = bLeft + (RD3_Glb.IsMobile() ? 16 : -3);
    }
    //
    this.ComboBadge.style.left = bLeft - (this.Owner instanceof BookSpan ? 2 : -2) + "px";
  }
  */
}
IDCombo.prototype.SetTop = function(y)
{
  /*
  // Per cominciare l'input
  this.Top = y;
  this.ComboInput.style.top = this.Top + "px";
  //
  // Se ho l'attivatore posiziono anche lui
  if (this.ComboActivator)
    this.ComboActivator.style.top = this.Top + "px";
  //
  // Se ho l'immagine ed e' visibile posiziono anche lei
  if (this.ComboImg && this.ComboImg.style.display=="")
  {
    this.SetHeight(this.Height);
    this.ComboImg.style.top = (this.Top + 2) + "px";
  }
  //
  // Se ho il Badge posiziono anche lui
  if (this.ComboBadge != null)
    this.ComboBadge.style.top = (this.Top + 2) + "px";
    */
}
IDCombo.prototype.SetWidth = function(w)
{
  this.Width = w;
  /*
  // Per cominciare l'input
  this.Width = w;
  var neww = w;
  if (!RD3_Glb.IsMobile())
  {
    // In alcuni casi per gestire dei bordi strani serve un +1, 
    // ma non per l'ultimo campo in lista altrimenti copre il bordo della lista
    // e nemmeno se non c'e' l'attivatore, altrimenti il campo risulta troppo largo
    var marleft = (this.ComboActivator && this.ComboActivator.style.display=="")?1:0;
    if (marleft && this.Owner && this.Owner instanceof PCell && this.Owner.InList && RD3_ServerParams.Theme != "zen")
    {
      var pf = this.Owner.ParentField;
      if (pf.ParentPanel.GetLastListField() == pf)
        marleft = 0;
    }
    //
    this.ComboMarLeft = marleft;
    //
    neww = (this.Width-(RD3_ServerParams.Theme == "zen"?(this.Owner.InList?-2:4):4)+marleft);     // Padding 2px + mancava un px di larghezza e l'ho aggiunto
    if (this.ComboImg && this.ComboImg.style.display=="")
      neww -= RD3_ClientParams.ComboImageSize+1;   // immagine
    if (this.ComboActivator && this.ComboActivator.style.display=="")
      neww -= this.ActWidth+1 + (RD3_ServerParams.Theme == "zen"?(this.Owner.InList?-3:-9):0);
  }
  //
  // Se, non c'e' abbastanza posto nella combo, riduco il padding
  if (this.ComboImg && this.ComboImg.style.display=="" && this.Width && neww<0)
  {
    var newp = (2+RD3_ClientParams.ComboImageSize+1 + neww);    // 2px padding + immagine;
    if (newp<0) newp=0;
    this.ComboInput.style.paddingLeft = newp + "px";
  }
  //
  if (neww<0) neww=0;
  this.ComboInput.style.width = neww + "px";
  this.ComboInputW = neww;
  //
  // Se ho l'attivatore posiziono anche lui
  if (this.ComboActivator)
    this.ComboActivator.style.left = this.Left + (this.RightAlign ? 0 : this.Width-this.ActWidth-2 - (this.Owner instanceof BookSpan ? 2 : 0) + (RD3_ServerParams.Theme == "zen" ? (this.Owner.InList ? 7 : 1) : 0)) + "px";
  //
  // Se ho il Badge posiziono anche lui
  if (this.ComboBadge != null)
  {
    var bLeft = this.Left + (this.Width - RD3_Glb.GetBadgeWidth(this.Badge, "grey") - 2);
    if (RD3_Glb.IsMobile())
      bLeft = bLeft + 6;
    //
    if (this.ComboActivator && this.ComboActivator.style.display == "")
      bLeft = bLeft - this.ActWidth + (RD3_Glb.IsMobile() ? 0 : -6);
    else
    {
      // Ci sono solo io... sposto il badge il piu' a destra possibile
      bLeft = bLeft + (RD3_Glb.IsMobile() ? 16 : -3);
    }
    //
    this.ComboBadge.style.left = bLeft - (this.Owner instanceof BookSpan ? 2 : -2) + "px";
  }
  //
  // Se sono su mobile, adatto l'input
  if (RD3_Glb.IsMobile())
    this.AdaptMobileInput();
    */
}

IDCombo.prototype.SetHeight = function(h)
{
  // Per cominciare l'input
  if (h)
    this.Height = h;
  //
  // 32 e' la dimensione Dummy di Inde per grigliare a 4px
  this.ComboInput.style.height = this.Height == 32 ? "" : (this.Height + "px");
  //
  // Se ho l'attivatore, devo ridimensionare anche lui
  if (this.ComboActivator)
    this.ComboActivator.style.height = this.Height == 32 ? "" : (this.Height + "px");
  if (this.ActButton)
    this.ActButton.style.height = this.Height == 32 ? "" : (this.Height + "px");
  if (this.ComboImgBox)
    this.ComboImgBox.style.height = this.Height == 32 ? "" : (this.Height + "px");
}

// ***************************************************
// Imposta lo sfondo della combo
// ***************************************************
IDCombo.prototype.SetBackGroundImage = function(img)
{
  this.ComboInput.style.backgroundImage = img;
}

// ***************************************************
// Imposta il ridimensionamento dell'immagine di sfondo della combo
// ***************************************************
IDCombo.prototype.SetBackGroundImageRM = function(br, bp)
{
  this.ComboInput.style.backgroundRepeat = br;
  this.ComboInput.style.backgroundPosition = bp;
}

// **********************************************************************
// Mette/toglie l'evidenziazione sulla cella
// **********************************************************************
IDCombo.prototype.SetActive = function(act)
{
  // Se c'e' l'attivatore ed e' visibile, attivo/disattivo anche lui!
  /*if (this.ComboActivator && this.ComboActivator.style.display=="")
  {
    // Se mi hanno attivato
    if (act)
    {
    	var vs = this.VisualStyle;
    	var r = vs.GetBookOffset(true,(this.Owner.InList)? 1 : 6); // r contiene le dimensioni di ogni bordo
	    // r.x = bordo sinistro
	    // r.y = bordo sopra
	    // r.w = bordo destro
	    // r.h = bordo sotto
			//    	
      var s = this.ComboActivator.style;
      var si = this.ComboInput.style;
      var backCol  = vs.GetColor(10); // VISCLR_EDITING
      if (backCol != "transparent")
        s.backgroundColor = backCol;
      else if (RD3_ServerParams.Theme != "zen")
      {
        var brdColor = vs.GetColor(11); // VISCLR_BORDERS
        if (this.RightAlign)
        {
          s.borderLeft = "2px solid " + brdColor;
          si.borderLeft = "none";
          //
          // Ripristino larghezza input che e' stata modificata dalla mancanza dei bordi
          si.width = (parseInt(si.width)+2) + "px";
        }
        else
        {
          s.borderRight = "2px solid " + brdColor;
          si.borderRight = "none";
          //
          // Devo anche spostarlo in "dentro" di un po' se manca il bordo verticale
          if (r.w==0)
  	        s.left = (parseInt(s.left) - 2) + "px";
        }
        s.borderTop = "2px solid " + brdColor;
        s.borderBottom = "2px solid " + brdColor;
        //
        s.height = (parseInt(s.height)-(4-r.y-r.h)) + "px";
        //
        // Devo anche spostarlo in "dentro" di 1px
        if (!this.RightAlign)
        {
          s.left = (parseInt(s.left) - 1) + "px";
          //
          // Lasciando fermo l'attivatore!
          s.backgroundPosition = "3px center";
        }
        else
        {
          // Lascio fermo l'attivatore!
          s.backgroundPosition = "1px center";
        }
      }
    }
    else // Mi hanno disattivato, ripristino i bordi ed il colore di sfondo
    {
      // Forzo l'aggiornamento dell'attivatore
      this.UpdateActivator();
      //
      // Ripristino il background pos
      this.ComboActivator.style.backgroundPosition = "center center";
    }
  }
  //
  // Se ho l'immagine ripristino il padding sinistro che se ne va
  if (!act && this.ComboImg)
  {
    this.SetLeft(this.Left);
  }*/
  //
  // Se mi hanno disattivata e dovevo gestire lo svuotamento ritardato, 
  // lo faccio ora
  if (!act && this.DeferEmpty)
    this.SetText("", true, true);
  else if (!act && this.IsOpen)
    this.Close();
}


// ***************************************************
// Ritorna l'oggetto DOM principale della combo
// ***************************************************
IDCombo.prototype.GetDOMObj = function()
{
  return this.ComboInput;
}

// ***************************************************
// Nasconde/mostra il contenuto della combo
// ***************************************************
IDCombo.prototype.HideContent = function(hide, disable)
{
  if (hide)
  {
    // Nascondo gli oggetti
    this.SetComboValue("");
    if (this.ComboImgBox)
      this.ComboImgBox.style.display = "none";
    if (this.ComboActivator)
      RD3_Glb.SetDisplay(this.ComboActivator, "none");
    if (this.ComboPopup)
      this.ComboPopup.style.display = "none";
    if (this.ComboPopupInput)
      this.ComboPopupInput.style.display = "none";
    if (this.ComboBadge)
      this.SetBadge("");
    //
    this.Enabled = false;
    //
    this.SetComboClickable(false);
  }
  else
  {
    // Ripristino il testo dell'input.
    this.SetComboValue(this.OriginalText);
    //
    // Se abilitato, mostro l'attivatore
    if (this.Visible && this.ActWidth >= 0 && (this.Enabled || (this.ActImage!="" && this.ActEnaIfComboDis)) && this.ComboActivator)
      RD3_Glb.SetDisplay(this.ComboActivator, "");
    //
    // Aggiorno l'immagine
    this.UpdateImage();
  }
}

// ***************************************************
// Gestione click sull'attivatore
// ***************************************************
IDCombo.prototype.OnClickActivator = function(ev)
{
  if (this.Owner && (this.Owner.ListQBECell || (this.Owner.PValue && this.Owner.PValue.ListQBEValue)))
    return this.Owner.ParentField.OnClickActivator(ev);
  //
  // Se ero aperta, mi chiudo ed ho finito
  if (this.IsOpen) {
    this.Close();
    return;
  }
  //
  // Fuoco la cella attivata
  if (!RD3_Glb.IsTouch() && this.Writable)
    this.ComboInput.focus();
  //
  // Apro la combo se non ho un oggetto di attivazione associato
  // Altrimenti informo l'owner del click sull'attivatore
  if (this.Enabled && this.OptionList && this.ListOwner && (this.ActImage == "" || (this.Owner.PValue && this.Owner.PValue.ListQBEValue)))
  {
    this.Open();
  }
  else if (this.Owner.OnComboActivatorClick)
  {
    this.Owner.OnComboActivatorClick();
    //
    // Mi ricordo che ho cliccato sull'attivatore. Quando e se il server
    // mi rispondera', ne tengo conto
    // Lo faccio solo se la combo non ha un oggetto di attivazione... se ce l'ha apro la combo solo se premo F2 o ALT-FRECCIAGIU
    var comboWithAct = (this.Owner && this.Owner.ParentField && this.Owner.ParentField.CanActivate);
    if (!comboWithAct)
      this.ActClicked = true;
  }
  //
  // Specifica per IDEditor: la combo aprendosi porta via il fuoco e la selezione.. invece noi la vogliamo tenere sotto..
  if (!this.Writable && this.Owner.RestoreSelection)
    this.Owner.RestoreSelection();
}

// ***************************************************
// Metodo per forzare l'apertura della combo
// ***************************************************
IDCombo.prototype.OpenComboForced = function()
{
  // Apro la combo se non ho un oggetto di attivazione associato
  // Altrimenti informo l'owner del click sull'attivatore
  if (this.Enabled && this.OptionList && this.ListOwner)
  {
    this.Open();
  }
  else if (this.Owner.OnComboActivatorClick)
  {
    this.Owner.OnComboActivatorClick(true);
    //
    // Mi ricordo che ho cliccato sull'attivatore. Quando e se il server
    // mi rispondera', ne tengo conto
    this.ActClicked = true;
  }
}

// ***************************************************
// Apre/aggiorna la combo (il popup)
// ***************************************************
IDCombo.prototype.Open = function(update)
{
  // Se non ho la lista
  if (!this.OptionList)
  {
    // Se c'e' l'attivatore, clicco su di lui in modalita' FORCEOPEN... cosi' mi arriva la lista
    if (this.Owner.OnComboActivatorClick)
    {
      this.Owner.OnComboActivatorClick(true);
      //
      // Mi ricordo che ho cliccato sull'attivatore. Quando e se il server
      // mi rispondera', ne tengo conto
      this.ActClicked = true;
    }
    //
    return;
  }
  //
  // Se non ho ancora l'oggetto nel DOM, lo creo
  var tbody = null;
  var parentContext = this;
  if (!this.ComboPopup)
  {
    this.ComboPopup = document.createElement("DIV");
    this.ComboPopup.className = "combo-popup";
    this.ComboPopup.setAttribute("id", this.Identifier+":cap");
    var tbl = document.createElement("TABLE");
    tbl.className = "combo-popup-table";
    tbody = document.createElement("TBODY");
    tbl.appendChild(tbody);
    this.ComboPopup.appendChild(tbl);
    this.ComboTbl = tbl;
  }
  else
  {
    // L'ho gia'... lo rendo visibile se l'ho nascosto
    this.ComboPopup.style.display = "";
    if (this.CloneElem)
      this.CloneElem.style.display = "";
    //
    // E recupero il body a cui aggiungero' i TR
    var obj = this.ComboPopup.firstChild;
    while (obj && obj.tagName!="TABLE")
      obj = obj.nextSibling;
    //
    if (!obj && this.ComboTbl)
      obj = this.ComboTbl;
    //
    if (obj)
      tbody = obj.tBodies[0];
  }
  //
  // Proseguo solo se ho trovato i miei oggetti
  if (!tbody)
    return;
  //
  // Se la lista non e' in fondo al DOM / caso mobile gestito sopra
  if (this.ComboPopup.parentNode != document.body || this.ComboPopup.nextSibling)
    document.body.appendChild(this.ComboPopup);
  //
  // Nascondo temporaneamente il popup, lo mostro dopo aver fatto tutti i calcoli di posizionamento
  this.ComboPopup.style.visibility = "hidden";
  //
  // Se il mio owner e' un PCell che ha delle proprieta' dinamiche devo applicarle al VS
  if (this.Owner && this.Owner instanceof PCell && this.Owner.GetDynPropSign()!="|||-1|")
    this.Owner.ApplyDynPropToVisualStyle(this.VisualStyle);
  //
  // Applico lo stile al popup
  var backcol = this.VisualStyle.GetColor(4);
  if (backcol=="transparent")
    this.VisualStyle.SetColor("white", 4);
  var brd = this.VisualStyle.GetBorders(6);
  if (brd!=4)
    this.VisualStyle.SetBorderType(4, 6);
  // 
  // Non voglio applicare la maschera all'intero popup
  var oldMask = this.VisualStyle.Mask;
  this.VisualStyle.Mask = "";
  //
  this.VisualStyle.ApplyValueStyle(this.ComboPopup, false, false, false, false, false, false, false, null, false, false, false, true);
  //
  // Ripristino la maschera
  this.VisualStyle.Mask = oldMask;
  //
  if (backcol=="transparent")
    this.VisualStyle.SetColor("transparent", 4);
  if (brd!=4)
    this.VisualStyle.SetBorderType(brd, 6);
  //
  // Se sono in apertura (no update), rendo tutti gli item visibili
  if (!update)
  {
    this.OptionList.SetComboItemsVisible();
    //
    // Scelgo l'item da evidenziare
    if (this.SelItems.length > 0)
      this.HLItem = this.SelItems[0];
    else
      this.HLItem = this.OptionList.GetNextVisibleItem();
  }
  //
  // Popolo il popup con gli option
  this.OptionList.RealizeCombo(tbody, this.Identifier, this.VisualStyle, this.SelItems, this.MultiSel, this.HLItem, this.OptionList && !this.ListOwner);
  //
  var n = this.OptionList.ItemList.length;
  for (var i=0;i<n;i++)
  {
    var optlist = this.OptionList.ItemList[i];
    if (optlist.Image != "")
    {
      // Se devo retinare, nascondo l'immagine (cosi non si vede grande) e quando arriva la rimostro
      if (RD3_Glb.Adapt4Retina(this.Identifier, optlist.Image, 43, i))
      {
        // Nel caso debba retinare, nascondo per un attimo le immagini grandi 
        // per poi mostrarle quando saranno ridimensionate
        var it = optlist.TR;
        if (it && it.childNodes.length >= 1)
        {
          var itImg = it.childNodes[1].firstChild;
          if (itImg)
            itImg.style.display = "none";
        }
      }
    }
  }
  //
  // Se la combo mostra il valore, creo un input fittizio tramite il quale posso fare
  // l'editing con autocomplete
  if (!update && this.ShowValue)
  {
    // Se non l'ho ancora creato, lo faccio ora
    if (!this.ComboPopupInput)
    {
      this.ComboPopupInput = document.createElement("INPUT");
      this.ComboPopupInput.className = "combo-input";
      RD3_Glb.AutocompleteOff(this.ComboPopupInput);
      var border = RD3_Glb.GetIntStyleProp(this.ComboInput, "borderTopWidth") + RD3_Glb.GetIntStyleProp(this.ComboInput, "borderBottomWidth");
      this.ComboPopupInput.style.height = (this.Height - border) + "px";  // Tengo conto del bordo
      if (this.HasWatermark)
        this.ComboPopupInput.placeholder = this.WaterMark;
      document.body.appendChild(this.ComboPopupInput);
      //
      // Applico lo stile all'input fittizio
      this.VisualStyle.ApplyValueStyle(this.ComboPopupInput);
      //
      // Perche' venga bene il colore di sfondo deve essere quello del pannello
      // Colore di sfondo del pannello
      var gradDir = this.VisualStyle.GetGradDir(6); // VISCLR_BACKPANEL
      if (gradDir != 1) {
        var fromColor = this.VisualStyle.GetColor(6);  // VISCLR_BACKPANEL
        var toColor = this.VisualStyle.GetGradColor(6);  // VISCLR_BACKPANEL
        //  
        this.ComboPopupInput.style.background = "linear-gradient(" + (gradDir==2? "90deg" : "180deg") + ", "+fromColor+", "+toColor+")";
        this.ComboPopupInput.style.backgroundColor = fromColor;
      }
      else {
        this.ComboPopupInput.style.backgroundColor = this.VisualStyle.GetColor(6);  // VISCLR_BACKPANEL 
      }
      //
      // Attacco gli eventi da usare per la multi-selezione
      this.ComboPopupInput.onkeyup = function(ev) { parentContext.OnKeyUp(ev); };
    }
    else
    {
      // Lo mostro e copio il valore corrente
      this.ComboPopupInput.style.display = "";
      //
      if (this.ComboSearchArea)
        this.ComboSearchArea.style.display = "";
      //
      // Se la combo non era aperta, svuoto il valore. Non lo faccio se e' un auto-lookup
      if (!this.IsOpen && this.ListOwner)
        this.ComboPopupInput.value = "";
    }
    //
    // Aggiorno il contenuto dell'input fittizio
    this.ComboPopupInput.value = this.GetComboFinalName(false);
    //
    // Memorizzo il testo originale presente nell'input (per gestire bene il KeyUp)
    this.PreviousInputText = this.ComboPopupInput.value;
  }
  //
  // Se il mio owner e' un PCell che ha delle proprieta' dinamiche devo ripulire il VS
  if (this.Owner && this.Owner instanceof PCell && this.Owner.GetDynPropSign()!="|||-1|")
    this.Owner.CleanVisualStyle(this.VisualStyle);
  //
  // Posiziono il popup con ridimensionamento
  if (!this.AnimatingCombo)
    this.AdaptPopupLayout(true);
  //
  // Mi assicuro che l'item selezionato sia visibile
  this.EnsureItemVisible();
  //
  // Se l'input fake e' visibile
  if (this.ComboPopupInput && this.ComboPopupInput.style.display=="")
  {
    // Lo fuoco
    if (!RD3_Glb.IsTouch() && this.Writable)
      this.ComboPopupInput.focus();
    //
    // Alla fine dell'apertura della combo su !IE il fuoco viene ridato all'activeElement, che pero' e' l'input nascosto.. per correggere il problema sostituiamo
    // l'activeElement con quello corretto
    if (!RD3_Glb.IsIE(10, false))
      RD3_KBManager.ActiveElement = this.ComboPopupInput;
    //
    // Se ho appena aperto, seleziono tutto il testo
    if (!update)
      this.SelectAllDummyInpText();
  }
  //
  // Segnalo la combo aperta (usata poi anche dal pannello per aggiornare la toolbar)
  RD3_DDManager.OpenCombo = this;
  //
  // Ora se la combo non e' gia' aperta la faccio aprire con l'animazione
  if (!this.IsOpen) {
    this.ComboPopup.style.visibility = "";
    var fx = new GFX("combo", true, this, RD3_Glb.IsFirefox(3));
    RD3_GFXManager.AddEffect(fx);
  }
  else {
    this.ComboPopup.style.visibility = "";
  }
  //
  // Questa e' la combo aperta
  this.IsOpen = true;
}

// ***************************************************
// Chiude la combo (il popup)
// ***************************************************
IDCombo.prototype.Close = function(undo)
{
  // Se la combo era aperta
  if (this.ComboPopup && this.ComboPopup.style.display=="")
  {
    var fx = new GFX("combo", false, this, RD3_Glb.IsFirefox(3));
    RD3_GFXManager.AddEffect(fx);
  }
  //
  // Se il dummy input era visibile
  if (this.ComboPopupInput && !RD3_Glb.IsMobile())
    this.ComboPopupInput.style.display = "none";
  //
  // Se il timer e' in esecuzione, lo fermo
  if (this.ComboPopupTimer!=0)
  {
    window.clearInterval(this.ComboPopupTimer);
    this.ComboPopupTimer = 0;
  }
  //
  // Confermo il valore all'Owner
  if (undo)
  {
    // Cerco se nella lista c'e', per caso, il valore originale della combo
    var foundPrec = false;
    if (this.OptionList && !this.ListOwner)
    {
      var list = this.OptionList.ItemList;
      var last = list[list.length-1];
      if (last && last.Value=="LKEPREC")
      {
        this.OriginalText = (this.ShowValue ? last.Value : last.Name);
        foundPrec = true;
      }
      //
      // Non e' detto che LKEPREC sia sempre l'utimo, potrebbe anche essere il penultimo..
      last = list[list.length - 2];
      if (last && last.Value == "LKEPREC") 
      {
        this.OriginalText = (this.ShowValue ? last.Value : last.Name);
        foundPrec = true;
      }
    }
    //
    // Ripristino il valore presente al momento dell'apertura
    // Se ho un testo originale uso quello, altrimenti uso il testo vuoto
    // Se sono MultiSel e chiusa voglio acquisire comunque il valore
    if (!this.MultiSel || !this.IsOpen)
    {
      // Purtroppo se scrivo qualcosa this.OriginalText viene modificato quindi non lo posso usare per annullare il valore e tornare allo stato precedente alla chiusura
      // pero' se sono LKE e ho una lista ma non un valore precedente significa che in origine la combo era vuota,
      // quindi posso usare "" come valore. in caso contrario posso solo fidarmi di OriginalText
      if (this.OptionList && !this.ListOwner && !foundPrec)
        this.SetText("", this.ShowValue);
      else
        this.SetText(this.OriginalText!=undefined ? this.OriginalText : "", this.ShowValue);
    }
  }
  else
  {
    // Se ho un item selezionato lo valido
    if (this.SelItems.length>0)
    {
      // Aggiorno il valore dell'input
      this.SetComboValue(this.GetComboFinalName(this.ShowValue));
      //
      // Memorizzo il testo attualmente presente nell'input (per gestire bene il KeyUp)
      this.PreviousInputText = this.ComboInput.value;
      //
      // Memorizzo il testo originale presente nell'input
      this.OriginalText = this.ComboInput.value;
    }
    //
    // Se non ho un item selezionato
    if (this.SelItems.length==0)
    {
      // Non c'e' un item selezionato: se c'e' del testo dentro all'input vedo se la combo permette testo libero.
      // Se non lo permette, ripristino il valore originale (se c'e')
      if (this.ComboInput.value!="" && !this.AllowFreeText)
        this.SetText(this.OriginalText!=undefined ? this.OriginalText : "", this.ShowValue);
      //
      // Se non c'e' un valore ma la combo non ammette il valore opzionale, ripristino il valore originale
      if (this.ComboInput.value=="" && !this.IsOptional)
        this.SetText(this.OriginalText!=undefined ? this.OriginalText : "", this.ShowValue);
    }
  }
  //
  // Aggiorno l'immagine
  this.UpdateImage();
  //
  // Do' il fuoco all'input, se non sono al tocco
  if (!RD3_Glb.IsTouch() && this.Writable)
    this.ComboInput.focus();
  //
  // Ora la combo non e' piu' aperta
  RD3_DDManager.OpenCombo = null;
  this.IsOpen = false;
  //
  // Informo l'owner che e' cambiato il valore
  if (this.Owner.OnComboChange)
  {
    // Se non sono list-owner e chiudo la combo, devo comunque informare il server di quel che ho fatto/selezionato
    if (!this.ListOwner)
      this.Owner.OnComboChange(true, true);
    else
      this.Owner.OnComboChange(!undo);
  }
  //
  // Se il primo item selezionato ha uno stile lo applico
  // Devo aggiornare il VS di PValue siccome e' lui che comanda
  if (this.SelItems.length>0 && this.SelItems[0].VisualStyle && this.Owner.PValue)
  {
    this.Owner.PValue.SetVisualStyle(this.SelItems[0].VisualStyle);
    this.Owner.PValue.UpdateScreen();
  }
  //
  if (this.Owner.OnMultipleComboChange)
    this.Owner.OnMultipleComboChange(this);
  //
  // Per sicurezza tolgo il fuoco dall'input nel caso gli sia arrivato
  if (RD3_Glb.IsTouch() && this.Writable)
    this.ComboInput.blur();
}

// ***************************************************
// Adatta le dimensioni del popup e lo posiziona al posto giusto
// ***************************************************
IDCombo.prototype.AdaptPopupLayout = function(resize)
{
  // Posiziono il popup
  var firstobj;
  if (this.ComboInput.parentNode) {
    firstobj = this.ComboInput.parentNode.firstChild;
    while (firstobj.style.display == "none" && firstobj.nextSibling)
      firstobj = firstobj.nextSibling;
  }
  else {
    firstobj = this.ComboInput;
    if (this.RightAlign && this.ComboActivator && this.ComboActivator.style.display=="")
      firstobj = this.ComboActivator;
  }
  var x = RD3_Glb.GetScreenLeft(firstobj);
  var y = RD3_Glb.GetScreenTop(firstobj) + window.pageYOffset;
  this.ComboPopup.style.bottom = "";
  this.ComboPopup.style.top = (y + this.Height) + "px";
  this.ComboPopup.style.left = (x + (this.Owner instanceof BookSpan ? 1 : 0)) + "px";
  //
  // Se mi e' stato chiesto di ridimensionare
  if (resize)
  {
    // Conservo lo scrollTop
    var oldtop = this.ComboPopup.scrollTop;
    //
    // Calcolo l'altezza giusta (Min-Max)
    this.ComboPopup.style.height = "";
    var popuph = this.ComboPopup.clientHeight + 2;
    if (popuph < RD3_ClientParams.ComboPopupMinHeight)
      popuph = RD3_ClientParams.ComboPopupMinHeight;
    else if (popuph>RD3_ClientParams.ComboPopupMaxHeight)
      popuph = RD3_ClientParams.ComboPopupMaxHeight;
    this.ComboPopup.style.height = popuph + "px";
    //
    // Calcolo la larghezza giusta se non e' visibile l'input fittizio
    this.ComboPopup.firstChild.width = "";    // Sto misurando, la tabella NON deve spingere!
    this.ComboPopup.style.width = "";
    var popupw = this.ComboPopup.scrollWidth + (this.ComboPopup.offsetWidth-this.ComboPopup.clientWidth);
    //
    // Se la combo e' piu' stretta del campo, la faccio larga come il campo
    if (this.ComboInput.parentNode && popupw < this.ComboInput.parentNode.offsetWidth)
      popupw = this.ComboInput.parentNode.offsetWidth;
    this.ComboPopup.style.width = popupw + "px";
    this.ComboPopup.firstChild.width = "100%";    // La tabella deve spingere!
    //
    // Su IE ci possono essere dei problemi perche' non si tiene conto della scrollbar
    // allora rifaccio il calcolo e tutto va a posto
    if (RD3_Glb.IsIE() && popupw>this.Width) {
      var popupw = this.ComboPopup.scrollWidth + (this.ComboPopup.offsetWidth-this.ComboPopup.clientWidth);
      this.ComboPopup.style.width = popupw + "px";
    }
    //
    this.ComboPopup.scrollTop = oldtop;
    //
    // Se c'e' l'input dummy, ridimensiono anche lui
    if (this.ComboPopupInput && this.ComboPopupInput.style.display=="") {
      var border = RD3_Glb.GetIntStyleProp(this.ComboInput, "borderLeftWidth") + RD3_Glb.GetIntStyleProp(this.ComboInput, "borderRightWidth");
      this.ComboPopupInput.style.width = (this.ComboInput.offsetWidth - border - 1) + "px";   // Largo come l'input
    }
  }
  //
  // Se il popup esce da sotto, lo mostro sopra
  if (y+this.Height+this.ComboPopup.offsetHeight > document.body.clientHeight)
  {
    if (firstobj.getBoundingClientRect) 
    {
      // Qui riesco a fare i calcoli in maniera piu' precisa impostando il bottom
      this.ComboPopup.style.top = "";
      this.ComboPopup.style.bottom = (document.body.offsetHeight - firstobj.getBoundingClientRect().top - window.pageYOffset) + "px";
    }
    else
      this.ComboPopup.style.top = (y - this.ComboPopup.offsetHeight - 2) + "px";
    this.ComboUpper = true;
  }
  else
  {
    this.ComboUpper = false;
  }
  //
  // Devo controllare se sono finito fuori dallo schermo
  if (this.ComboPopup.offsetTop<0)
  {
    // Se sono finito fuori schermo metto il top a 0 e recupero sull'altezza
    var delta = this.ComboPopup.offsetTop;            // Valore <0
    this.ComboPopup.style.top = "0px";
    this.ComboPopup.style.bottom = "";
    //
    // Per sicurezza verifico che non sia troppo piccolo
    var newh = this.ComboPopup.offsetHeight + delta;
    if (newh < RD3_ClientParams.ComboPopupMinHeight)
      newh = RD3_ClientParams.ComboPopupMinHeight;
    //
    this.ComboPopup.style.height = newh + "px";
  }
  //
  // Se sono finito fuori dallo schermo in larghezza lo sposto un po' piu' a sinistra
  // nel caso di 'container' devo tenere conto che il wepbox non e' tutto a sinistra ma ha un margine
  var real_w = RD3_DesktopManager.WebEntryPoint.WepBox.offsetWidth + (RD3_ClientParams.BodyContainerType == "container" ? RD3_DesktopManager.WebEntryPoint.WepBox.offsetLeft : 0);
  if (this.ComboPopup.offsetLeft + this.ComboPopup.offsetWidth > real_w)
    this.ComboPopup.style.left = Math.max(0, RD3_DesktopManager.WebEntryPoint.WepBox.offsetWidth - this.ComboPopup.offsetWidth) + "px";
  //
  // Se c'e' l'input dummy, lo posiziono
  if (this.ComboPopupInput && this.ComboPopupInput.style.display=="")
  {
    var rightOfs = RD3_Glb.GetIntStyleProp(this.ComboInput, "borderLeftWidth");
    if (this.RightAlign && this.ComboActivator && this.ComboActivator.style.display=="")
      rightOfs = this.ComboActivator.offsetWidth;
    this.ComboPopupInput.style.left = (RD3_Glb.GetScreenLeft(firstobj) + rightOfs) + "px";
    this.ComboPopupInput.style.top = (y + RD3_Glb.GetIntStyleProp(this.ComboInput, "borderTopWidth")) + "px";
  }
}


// *********************************************************
// E' stata appena caricata un'immagine del popup, devo aggiornare le dimensioni!
// *********************************************************
IDCombo.prototype.OnComboImageLoaded = function()
{
	// Se sto animando, lo fara' il sistema alla fine dell'animazione
  if (!RD3_Glb.IsMobile() && !RD3_GFXManager.Animating())
    this.AdaptPopupLayout(true);
}

// ******************************************************************
// Click su una opzione
// ******************************************************************
IDCombo.prototype.OnOptionClick = function(ev, idxs)
{
  // Cerco l'opzione selezionata
  var sel = this.OptionList.ItemList[parseInt(idxs)];
  //
  // Se e' abilitata
  if (sel && sel.Enabled)
  {
    // Recupero l'oggetto che e' stato cliccato
    var checkObj = (window.event)?window.event.srcElement:ev.target;
    //
    // Se ho cliccato su un TD
    if (checkObj.tagName == "TD")
    {
      // Passo la palla all'eventuale check in esso contenuto
      checkObj = checkObj.childNodes[0];
      //
      // Cambio lo stato del check
      if (checkObj)
        checkObj.checked = !checkObj.checked;
    }
    //
    // Se e' stato cliccato un check di opzione
    if (checkObj && checkObj.className == "combo-option-check")
    {
      // Rido' il fuoco all'input per poter continuare a scrivere
      if (!RD3_Glb.IsTouch() && this.Writable)
      {
        if (this.ComboPopupInput)
          this.ComboPopupInput.focus();
        else
          this.ComboInput.focus();
      }
      //
      this.OnOptionCheck(sel, checkObj.checked);
    }
    else
    {
      // la seleziono e chiudo il popup
      this.SelItems = new Array();
      this.SelItems.push(sel);
      this.Close();
    }
  }
}

// ***************************************************
// Gestione del cambio selezione di un opzione
// ***************************************************
IDCombo.prototype.OnOptionCheck = function(item, checked)
{
  if (checked)
  {
    // Se era selezionata la riga vuota o LKEPREC ... la tolgo
    if (this.SelItems.length == 1 && (this.SelItems[0].Value == "" || (this.OptionList && !this.ListOwner) && this.SelItems[0].Value == "LKEPREC"))
    {
      RD3_Glb.RemoveClass(this.SelItems[0].TR, "combo-option-selected");
      this.SelItems[0].TR.style.backgroundColor = "";
      this.SelItems = new Array();
    }
    //
    // Aggiungo l'item tra quelli selezionati
    this.SelItems.push(item);
    //
    // Aggiungo lo stile "selezionato"
    // ma non se l'item e' vuoto
  	if (!this.MultiSel || item.Value!="")
  	{
	    RD3_Glb.AddClass(item.TR, "combo-option-selected");
	    item.TR.style.backgroundColor = this.VisualStyle.GetColor(9); // VISCLR_HILIGHT
	  }
  }
  else
  {
    // Rimuovo lo stile "selezionato"
    RD3_Glb.RemoveClass(item.TR, "combo-option-selected");
    item.TR.style.backgroundColor = "";
    //
    // Rimuovo l'item da quelli selezionati
    for (var i=0; i<this.SelItems.length; i++)
    {
      if (this.SelItems[i] == item)
      {
        this.SelItems.splice(i,1);
        break;
      }
    }
    //
    // Se non c'e' piu' nessun item selezionato ...
    if (this.SelItems.length == 0)
    {
      // seleziono l'opzione vuota, se c'e'
      var empty = this.OptionList.ItemList[0];
      if (empty.Name == "")
      {
        this.SelItems.push(empty);
        if (!this.MultiSel)
  			{
	        RD3_Glb.AddClass(empty.TR, "combo-option-selected");
	        empty.TR.style.backgroundColor = this.VisualStyle.GetColor(9); // VISCLR_HILIGHT
	      }
      }
    }        
  }
  //
  // Aggiorno il valore
  if (this.ComboPopupInput)
    this.ComboPopupInput.value = this.GetComboFinalName(false);
  this.SetComboValue(this.GetComboFinalName(this.ShowValue));
}

// ***************************************************
// Gestione mouse-down con combo aperta 
// (arriva da DD_Manager se vede una combo aperta)
// ***************************************************
IDCombo.prototype.OnMouseDown = function(ev)
{
  var evnt = window.event ? window.event : ev;
  var x = evnt.clientX;
  var y = evnt.clientY;
  if (evnt && evnt.targetTouches) {
    x = evnt.targetTouches[0].clientX;
    y = evnt.targetTouches[0].clientY;
  }
  //
  // Vediamo se hanno cliccato su di me
  var firstobj;
  if (this.ComboInput.parentNode) {
    firstobj = this.ComboInput.parentNode.firstChild;
    while (firstobj.style.display == "none" && firstobj.nextSibling)
      firstobj = firstobj.nextSibling;
  }
  else {
    firstobj = this.ComboInput;
    if (this.RightAlign && this.ComboActivator && this.ComboActivator.style.display=="")
      firstobj = this.ComboActivator;
  }
  var l = RD3_Glb.GetScreenLeft(firstobj);
  var t = RD3_Glb.GetScreenTop(firstobj);
  var w = this.Width;
  var h = this.Height;
  //
  // Se c'e' un input-fake (ShowValue) piu' largo del campo devo usare la sua larghezza, non quella del campo
  if (this.ComboPopupInput && this.ComboPopupInput.style.display=="" && this.ComboPopupInput.offsetWidth > w)
    w = this.ComboPopupInput.offsetWidth;
  //
  // Se ho cliccato dentro all'input della combo non faccio nulla
  if ((x>=l && x<=l+w) && (y>=t && y<=t+h))
    return;
  //
  // Se la combo e' aperta, controllo se e' stato cliccato il popup
  if (this.ComboPopup)
  {
    l = RD3_Glb.GetScreenLeft(this.ComboPopup);
    t = RD3_Glb.GetScreenTop(this.ComboPopup);
    w = this.ComboPopup.offsetWidth;
    h = this.ComboPopup.clientHeight;
  }
  //
  // Se ho cliccato dentro al popup non faccio nulla
  if ((x>=l && x<=l+w) && (y>=t && y<=t+h))
    return;
  //
  // Il click e' fuori dalla combo -> la chiudo rifuocando chi era attivo prima della CLOSE
  var focobj = (window.event)?window.event.srcElement:ev.target;
  //
  this.Close();
  //
  if (focobj)
  {
    // Attenzione: l'oggetto potrebbe non essere fuocabile
    try {
      focobj.focus();
    }
    catch (ex) {
      // Chissa' dove ha cliccato l'utente! Meglio ri-controllare il fuoco...
      RD3_KBManager.CheckFocus = true;
    }
  }
}


// ***************************************************
// Premuto un tasto (o nell'input o sul body con una combo aperta)
// ***************************************************
IDCombo.prototype.OnKeyDown = function(eve)
{
  if (window.event && eve==undefined)
    eve = window.event;
  //
  var code = (eve.charCode)?eve.charCode:eve.keyCode;
  //
  // UP(38), DOWN(40), PGUP(33), PGDOWN(34) senza ALT premuto
  if ((code==38 || code==40 || code==33 || code==34) && !eve.altKey)
  {
    // Se la combo e' aperta
    if (this.IsOpen)
    {
      // Se non ho la lista (capita moooolto di rado) meglio chiudere (con UNDO) e uscire
      if (!this.OptionList) {
        this.Close(true);
        return;
      }
      //
      // Seleziono il prossimo/precedente item
      var item = this.OptionList.GetNextVisibleItem((this.MultiSel ? this.HLItem : this.SelItems[0]), (code==38||code==33), (code==33||code==34))
      //
      if (this.MultiSel)
        this.HiligthItem(item);
      else
      {
        if (this.Owner && this.Owner instanceof PCell && this.Owner.GetDynPropSign()!="|||-1|")
          this.Owner.ApplyDynPropToVisualStyle(this.VisualStyle);
        //
        // Prima di selezionare il nuovo item deseleziono il precedente (ce n'e' uno solo) - e' OPEN quindi il TR c'e' .. 
        if (this.SelItems.length > 0)
        {
          this.SelItems[0].TR.style.backgroundColor = this.VisualStyle.GetColor(5); // VISCLR_BACKVALUE
          RD3_Glb.RemoveClass(this.SelItems[0].TR, "combo-option-selected");
        }
        //
        this.SelItems = new Array();
        this.SelItems.push(item);
        //
        // Adesso disegno l'item selezionato con la classe css giusta
        if (item.Value != "")
        {
          this.SelItems[0].TR.style.backgroundColor = this.VisualStyle.GetColor(9); // VISCLR_HILIGHT
          RD3_Glb.AddClass(this.SelItems[0].TR, "combo-option-selected");
        }
        //
        // Se il mio owner e' un PCell che ha delle proprieta' dinamiche devo ripulire il VS
        if (this.Owner && this.Owner instanceof PCell && this.Owner.GetDynPropSign()!="|||-1|")
          this.Owner.CleanVisualStyle(this.VisualStyle);
        //
        // Se c'e' un item selezionato e l'input fittizio e' aperto, aggiorno il valore
        if (this.SelItems.length>0 && this.ComboPopupInput && this.ComboPopupInput.style.display=="")
        {
          this.ComboPopupInput.value = this.SelItems[0].Name;
          //
          // Memorizzo il testo attualmente presente nell'input (per gestire bene il KeyUp)
          this.PreviousInputText = this.ComboPopupInput.value;
          //
          // Seleziono tutto il testo presente nell'input
          this.SelectAllDummyInpText();
        }
      }
      //
      // Garantisco che l'item sia visibile
      this.EnsureItemVisible();
      //
      // Ho gestito io le frecce: non lo deve fare il KBManager, se no farebbe un casino..
      RD3_Glb.StopEvent(eve);
      return;
    }
  }
  //
  // ENTER, TAB o ESC chiudono la combo
  if (code==13 || code==9 || code==27)
  {
    // Se la combo era aperta, ho gestito io i tasti: non lo deve fare il KBManager, se no farebbe un casino..
    if (this.IsOpen)
      RD3_Glb.StopEvent(eve);
    //
    if (this.IsOpen && code==13 && this.MultiSel && this.HLItem && (this.SelItems.length==0 || (this.SelItems.length==1 && this.SelItems[0].Value=="")))
    	this.OnOptionCheck(this.HLItem, true);
    //
    // ESC = undo
    this.Close(code==27);
    return;
  }
  //
  // F2 o ALT-DOWN apre la combo se non e' gia' aperta
  if ((code==113 || (eve.altKey && code==40)) && !this.IsOpen && this.Enabled)
  {
    // Se premo F2, clicco sull'attivatore, altrimenti apro la combo
    if (code==113)
      this.OnClickActivator();
    else
      this.Open();
    //
    // Ho gestito io le frecce: non lo deve fare il KBManager, se no farebbe un casino..
    RD3_Glb.StopEvent(eve);
    return;
  }
  //
  // Un qualunque altro tasto funzione chiude la combo e acquisisce il valoer
  if (((code>=114 && code<=123)||(code==112)) && this.IsOpen)
  {
    // Chiudiamo la combo acquisendo il valore
    this.Close();
    return;
  }
  //
  if (code==32 && this.IsOpen && this.MultiSel)
  {
    if (!this.HLItem)
      return;
    //
    // Recupero il check
    var check = this.HLItem.TR.childNodes[0].childNodes[0];
    if (!check)
      return;
    //
    check.checked = !check.checked;
    this.OnOptionCheck(this.HLItem, check.checked);
    //
    // Ho gestito io lo spazio: non lo deve fare il KBManager, se no farebbe un casino..
    RD3_Glb.StopEvent(eve);
    return; 
  }
}

// ***************************************************
// Premuto un tasto nell'input (ComboInput o ComboPopupInput)
// ***************************************************
IDCombo.prototype.OnKeyUp = function(eve)
{
  if (window.event && eve==undefined)
    eve = window.event;
  //
  // Se e' gia' stato gestito nel keyup
  var code = (eve.charCode)?eve.charCode:eve.keyCode;
  var pf = this.Owner.ParentField;
  //
  // Alcuni tasti sono da gestire solo nel KEYDOWN (vedi sopra)
  if (code==38 || code==40 || code==33 || code==34)   // UP(38), DOWN(40), PGUP(33), PGDOWN(34) (navigano gli item della combo)
    return;    
  if (code==13 || code==9 || code==27)    // Enter, TAB, ESC (chiudono la combo)
    return;
  if (code>=112 && code<=123)   // Tasti funzione
    return;
  if (code==32 && this.IsOpen && this.MultiSel)   // attivazione check in combo multi-selezionabile
    return;
  //
  // Se arrivo dal ComboPopupInput, leggo da li' il valore
  var val = this.ComboInput.value;
  var dummyInp = (this.ComboPopupInput && this.ComboPopupInput.style.display=="");
  if (dummyInp)
    val = this.ComboPopupInput.value;
  //
  // Se non e' cambiato il valore non faccio nulla
  if (val == this.PreviousInputText)
    return;
  //
  // Questo e' il valore corrente
  this.PreviousInputText = val;
  //
  // Non sono list owner... nessuna lista...
  if (!this.ListOwner)
  {
    // Se sono mobile voglio tutta la lista!
    if (RD3_Glb.IsMobile() && val=="")
      val = "*";
    //
    this.OptionList = null;
    if (!this.MultiSel)
      this.SelItems = new Array();
    //
    // Indico che e' come se avessi cliccato sull'attivatore
    // Cosi' quando arrivera' la lista, la combo si apre
    this.ActClicked = true;
    //
    // Se il valore e' vuoto, chiudo la combo
    // Non la voglio chiudere se sono una combo in QBE: scrivo, premo canc ma voglio che rimanga aperta
    // Se sono in QBE (this.MultiSel) invece chiamo la Close se sono gia' chiusa, in questo caso voglio far acquisire subito il valore
    if (val=="")
    {
      this.OriginalText = "";
      if (!this.MultiSel || !this.IsOpen)
        this.Close(true);
      return;
    }
    //
    // Nel caso QBECell LKE dobbiamo fare delle cose specifiche:
    // - se scrivi qualcosa va mandato un messaggio speciale al server per ottenere la lista
    // - se svuoti il campo deve rimanere la combo aperta (come in QBE), ma quando la chiudi deve svuotare il filtro
    if (this.Owner && (this.Owner.ListQBECell || (this.Owner.PValue && this.Owner.PValue.ListQBEValue))) 
    {
      var ev = new IDEvent("qbecombo", this.Owner.ParentField.Identifier, null, RD3_Glb.EVENT_URGENT, this.Owner.ParentField.Identifier, val);
      return;
    }
  }
  //
  // Se non ho una lista informo solo l'owner della variazione del testo
  var superact = pf && pf.HasValueSource && pf.SuperActive && this.ComboInput.value!="";
  if (!this.OptionList || superact)
  {
    // Comunico la modifica del testo all'owner... cosi', magari, mi manda la lista
    if (this.Owner.OnComboChange)
    {
	    var lo = this.ListOwner;
      if (superact)
				this.ListOwner = false;
      //
      if (!(this.Owner.ListQBECell && (this.Owner.PValue && this.Owner.PValue.ListQBEValue)) || ((this.Owner.ListQBECell || (this.Owner.PValue && this.Owner.PValue.ListQBEValue)) && val == ""))
        this.Owner.OnComboChange(true, this.IsOpen, true);
      //
      // Se e' una value source attiva inviare il cambiamento al server non basta, devo simulare il click sull'attivatore in modo da farmi mandare la lista
      if (superact || ((this.Owner.ListQBECell || (this.Owner.PValue && this.Owner.PValue.ListQBEValue)) && val != ""))
      {
	      this.ListOwner = lo;
	     	//
        // Simulo un click sull'attivatore, in modo da farmi mandare la combo
        this.Owner.OnComboActivatorClick();
        this.ActClicked = true;
      }
    }
    //
    return;
  }
  //
  // Filtro gli item della combo usando il valore corrente
  this.OptionList.FilterComboItem(val, true);
  //
  // Se non ho un item selezionato o quello selezionato e' invisibile, ne cerco un altro
  if (this.SelItems.length==0 || !this.SelItems[0].Visible)
  {
    this.SelItems = new Array();
    this.HLItem = this.OptionList.GetNextVisibleItem(null);
    if (this.HLItem && !this.MultiSel)
      this.SelItems.push(this.HLItem);
  }
  //
  // Se non c'e' un valore e la combo e' opzionale
  if (val=="" && this.IsOptional)
  {
    // Se il primo item della combo ha proprio il valore vuoto, allora seleziono quello
    // altrimenti perdo la selezione
    this.SelItems = new Array();
    if (this.OptionList.ItemList[0].Name == "")
      this.SelItems.push(this.OptionList.ItemList[0]);
    //
    // Se lavoro in modalita' DUMMY-INPUT il testo vuoto vuol dire seleziona la prima riga dell'opzionalita'
    // Altrimenti la combo e' opzionale e non c'e' un valore... chiudo la combo
    if (dummyInp)
      this.Open(true);
    else
      this.Close();
  }
  else
  {
    // Aggiorno la combo
    this.Open(true);
  }
  //
  // Ora posso avvisare il mio owner
  if (this.Owner.OnComboChange)
		this.Owner.OnComboChange();
}


// ***************************************************
// Assicura che l'item indicato sia visibile, scrollando
// il popup se serve
// ***************************************************
IDCombo.prototype.EnsureItemVisible = function(idx)
{
  // Se non mi hanno fornito l'indice, uso quello dell'item selezionato
  if (idx==undefined)
    idx = this.OptionList.GetItemIndex(this.MultiSel ? this.HLItem : this.SelItems[0]);
  //
  // Chiedo alla lista di farlo
  this.OptionList.EnsureItemVisible(this.ComboPopup, idx);
}


// ***************************************************
// Assicura che il popup e l'input fake siano sempre
// posizionati correttamente
// ***************************************************
IDCombo.prototype.OnTimerTick = function()
{
  // Riposiziono il popup
  this.AdaptPopupLayout();
}


// ***************************************************
// Ritorna un clone della combo
// ***************************************************
IDCombo.prototype.Clone = function(owner)
{
  // Creo la nuova istanza
  var NewCombo = new IDCombo(owner);
  //
  // La battezzo e la inserisco nella mappa
  NewCombo.Identifier = "cmb:" + Math.floor(Math.random() * 1000000000);
  RD3_DesktopManager.ObjectMap.add(NewCombo.Identifier, NewCombo);
  //
  // Copio le proprieta'
  NewCombo.Left = this.Left;
  NewCombo.Top = this.Top;
  NewCombo.Width = this.Width;
  NewCombo.Height = this.Height;
  NewCombo.Enabled = this.Enabled;
  NewCombo.Visible = this.Visible;
  NewCombo.RightAlign = this.RightAlign;
  NewCombo.Clickable = this.Clickable;
  NewCombo.Tooltip = this.Tooltip;
  //
  NewCombo.ListOwner = this.ListOwner;
  NewCombo.ShowActivator = this.ShowActivator;
  NewCombo.IsOptional = this.IsOptional;
  NewCombo.AllowFreeText = this.AllowFreeText;
  NewCombo.ShowValue = this.ShowValue;
  NewCombo.ActImage = this.ActImage;
  NewCombo.ActWidth = this.ActWidth;
  NewCombo.ActEnaIfComboDis = this.ActEnaIfComboDis;
  NewCombo.VisualStyle = this.VisualStyle;
  NewCombo.OptionList = null;
  NewCombo.SelItem = null;
  NewCombo.PreviousInputText = this.PreviousInputText;
  NewCombo.OriginalText = this.OriginalText;
  NewCombo.MultiSel = this.MultiSel;
  NewCombo.HasWatermark = this.HasWatermark;
  NewCombo.WaterMark = this.WaterMark;
  NewCombo.UsePopover = this.UsePopover;
  NewCombo.Badge = this.Badge;
  NewCombo.ClassName = this.ClassName;
  //
  // E lo stato dei padding (per mobile)
  NewCombo.PaddingLeft = this.PaddingLeft;
  NewCombo.PaddingRight = this.PaddingRight;
  //
  // Clono l'input
  NewCombo.ComboInput = this.ComboInput.cloneNode(false);
  if (RD3_Glb.IsMobile())
    NewCombo.ComboInput.value = this.ComboInput.value;
  //
  // Aggiorno il valore di autocomplete, in modo da tenerlo spento
  RD3_Glb.AutocompleteOff(NewCombo.ComboInput);
  //
  // Se c'e' l'attivatore clono anche lui
  if (this.ComboActivator) {
    NewCombo.ComboActivator = this.ComboActivator.cloneNode(true);
    NewCombo.ActButton = NewCombo.ComboActivator.firstChild;
  }
  //
  // Se c'e' l'immagine (ed e' visibile) clono anche lei
  if (this.ComboImgBox) {
    NewCombo.ComboImgBox = this.ComboImgBox.cloneNode(true);
    NewCombo.ComboImg = NewCombo.ComboImgBox.firstChild;
  }
  //
  // Se c'e' il Badge clono anche lui
  if (this.ComboBadge)
    NewCombo.ComboBadge = this.ComboBadge.cloneNode(true);
  //
  // Fatto
  return NewCombo;
}


// *********************************************************
// Seleziona tutto il testo del dummy input
// *********************************************************
IDCombo.prototype.SelectAllDummyInpText = function()
{
  // Seleziono tutto il testo
  if (this.ComboPopupInput.createTextRange)
  {
    this.ComboPopupInput.createTextRange().select();
  }
  else
  {
    this.ComboPopupInput.selectionStart = 0;
    this.ComboPopupInput.selectionEnd = this.ComboPopupInput.value.length;
  }
}

// *********************************************************
// Imposta il tooltip
// *********************************************************
IDCombo.prototype.GetTooltip = function(tip, obj)
{
  if (obj == this.ComboImg || obj == this.ComboInput || obj == this.ComboActivator)
  {
    var tp = "";
    if (this.Tooltip != "")
      tp = this.Tooltip;
    else if (this.SelItems.length>0)
      tp = this.SelItems[0].Tooltip;
    //
    if (tp == "")
      return false;
    //
    if (this.Owner.GetTooltipTitle)
      tip.SetTitle(this.Owner.GetTooltipTitle());
    //
    // Imposto il tipo in base al tipo di errore dell'Owner
    if (this.Owner.ErrorType == 1)
      tip.SetStyle("error");
    else if (this.Owner.ErrorType == 2 || this.Owner.ErrorType == 3)
      tip.SetStyle("warning");
    //
    tip.SetText(tp);
    tip.SetAutoAnchor(true);
    tip.SetPosition(2);
    //
    return true;
  }
  //
  // Proviamo a chiederlo all'OptionList
  if (this.OptionList && this.OptionList.GetTooltipCombo(this.ComboPopup, tip, obj))
  {
    // Devo impostargli il title
    if (this.Owner.GetTooltipTitle)
      tip.SetTitle(this.Owner.GetTooltipTitle());
    return true;
  }
  //
  return false;
}


// *********************************************************
// Comunica alla combo che il mio testo e' "" ma non e' stato
// ancora svuotato l'input... occorrera' farlo non appena
// l'utente cambia cella
// *********************************************************
IDCombo.prototype.DeferEmptyCombo = function()
{
  this.DeferEmpty = true;
  //
  // Se la combo e' aperta la chiudo in modo "SOFT"
  if (this.IsOpen)
  {
    if (this.ComboPopup && this.ComboPopup.style.display=="")
    {
      // Chiudiamo la combo con l'animazione..
      var fx = new GFX("combo", false, this, RD3_Glb.IsFirefox(3));
      RD3_GFXManager.AddEffect(fx);
    }
    //
    // Se il timer e' in esecuzione, lo fermo
    if (this.ComboPopupTimer!=0)
    {
      window.clearInterval(this.ComboPopupTimer);
      this.ComboPopupTimer = 0;
    }
    //
    // Ora la combo non e' piu' aperta
    RD3_DDManager.OpenCombo = null;
    this.IsOpen = false;
  }
}

// ***********************************************
// Determina se deve essere mostrata solo l'icona
// ***********************************************
IDCombo.prototype.ShowDescription = function(vs)
{
  if (this.Owner.ParentField)
    return this.Owner.ParentField.ShowDescription(vs);
  //
  if (vs)
    return vs.ShowDescription();
  //
  return true;
}

// ***********************************************
// Aggiunge una classe custom all'input
// ***********************************************
IDCombo.prototype.SetClassName = function(cls)
{
  if (cls === this.ClassName)
    return;
  //
  // Rimuovo la classe precedente
  if (this.ClassName != "")
    RD3_Glb.RemoveClass2(this.ComboInput, this.ClassName);
  //
  // Applico la nuova classe proveniente dalla Cella o dallo Span
  this.ClassName = cls;
  if (this.ClassName && this.ClassName != "")
    RD3_Glb.AddClass(this.ComboInput, this.ClassName);
}

// ***********************************************
// Toglie il WaterMark dalla Combo
// ***********************************************
IDCombo.prototype.SetWatermark = function(wat)
{
  this.HasWatermark = true;
  this.WaterMark = wat;
  this.ComboInput.placeholder = wat;
  if (this.ComboPopupInput)
    this.ComboPopupInput.placeholder = wat;
}

// ***********************************************
// Toglie il WaterMark dalla Combo
// ***********************************************
IDCombo.prototype.RemoveWatermark = function()
{
  this.HasWatermark = false;
  this.WaterMark = "";
  this.ComboInput.placeholder = "";
  if (this.ComboPopupInput)
    this.ComboPopupInput.placeholder = "";
}

// ********************************************************************************
// Eventi di tocco sul combo popup
// ********************************************************************************
IDCombo.prototype.OnTouchStart = function(e)
{ 
  
}

IDCombo.prototype.OnTouchMove = function(e)
{ 
  
}

IDCombo.prototype.OnTouchEnd = function(e)
{ 
  
}


// ********************************************************************************
// Gestisce lo scroll via touch del pannello.
// v e' la velocita' di scroll in ms, il segno indica la direzione
// n e' il numero di volte che e' stata eseguita la funzione
// ********************************************************************************
IDCombo.prototype.TouchScrollTimer = function(dummy, ap)
{ 
  
}


// ********************************************************************************
// Annulla timer di scroll
// ********************************************************************************
IDCombo.prototype.ClearTouchScrollTimer = function()
{
  
}


// ********************************************************************************
// Imposta il valore del combo input (che puo' anche essere un DIV!)
// ********************************************************************************
IDCombo.prototype.SetComboValue = function(value)
{
  this.ComboInput.value = RD3_Glb.HandleIconString(value, true);
  if (this.ComboInput.tagName == "DIV")
    this.ComboInput.innerHTML = RD3_Glb.HandleIconString(value);
}


// ********************************************************************************
// Gestione Badge
// ********************************************************************************
IDCombo.prototype.SetBadge = function(val)
{
  this.Badge = val;
}

// *******************************************************************
// Chiamato quando ho l'immagine da retinare
// *******************************************************************
IDCombo.prototype.OnAdaptRetina = function(w, h, par)
{
  
}

IDCombo.prototype.SetWritable = function(w)
{
  this.Writable = w;
  //
  if (this.ComboInput)
  {
    if (this.Writable)
      this.ComboInput.removeAttribute("readonly");
    else
      this.ComboInput.setAttribute("readonly",true);
  }
}

IDCombo.prototype.HiligthItem = function(item)
{
  if (this.OptionList)
  {
    if (this.HLItem)
      RD3_Glb.RemoveClass(this.HLItem.TR, "combo-option-hiligth");
    //
    this.HLItem = item;
    if (!this.HLItem && this.MultiSel)
      this.HLItem = this.OptionList.ItemList[0];
    //
    if (this.HLItem)
      RD3_Glb.AddClass(this.HLItem.TR, "combo-option-hiligth");
  }
}