-- 1. add new field SENSITIVE DATA

-- Aggiunge la colonna SENDATTIPASS (INT NOT NULL DEFAULT 0) se manca.
-- Se la colonna esiste già, assicura che ci sia il DEFAULT constraint.

IF OBJECT_ID(N'dbo.QASS_TIPIASSENZA', N'U') IS NOT NULL
BEGIN
    -- Colonna assente: la aggiungo con default e valorizzo le righe esistenti
    IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'SENDATTIPASS') IS NULL
    BEGIN
        ALTER TABLE dbo.QASS_TIPIASSENZA
            ADD SENDATTIPASS INT NOT NULL
                CONSTRAINT DF_QASS_TIPIASSENZA_SENDATTIPASS DEFAULT (0) WITH VALUES;
    END
END


-- 2. rename all fields to better names

IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'ID') IS NULL AND COL_LENGTH('dbo.QASS_TIPIASSENZA', 'IDTIPOASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA.IDTIPOASSENZA', 'ID', 'COLUMN';

IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'CODE') IS NULL AND COL_LENGTH('dbo.QASS_TIPIASSENZA', 'CODETIPOASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA.CODETIPOASSENZA', 'CODE', 'COLUMN';

IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'DESCRIPTION') IS NULL AND COL_LENGTH('dbo.QASS_TIPIASSENZA', 'DESCRIPTIONTIPOASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA.DESCRIPTIONTIPOASSENZA', 'DESCRIPTION', 'COLUMN';

IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'MANDATORY_DESCRIPTION') IS NULL AND COL_LENGTH('dbo.QASS_TIPIASSENZA', 'MANDATORYDESCRIPTIOTIPOASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA.MANDATORYDESCRIPTIOTIPOASSENZA', 'MANDATORY_DESCRIPTION', 'COLUMN';

IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'DEFAULT_WHOLE_DAY') IS NULL AND COL_LENGTH('dbo.QASS_TIPIASSENZA', 'DEFAULTWHOLEDAYTIPOASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA.DEFAULTWHOLEDAYTIPOASSENZA', 'DEFAULT_WHOLE_DAY', 'COLUMN';

IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'ACTIVE') IS NULL AND COL_LENGTH('dbo.QASS_TIPIASSENZA', 'ACTIVETIPOASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA.ACTIVETIPOASSENZA', 'ACTIVE', 'COLUMN';

IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'REQUIRED_WITH_EMPLOYEES') IS NULL AND COL_LENGTH('dbo.QASS_TIPIASSENZA', 'REQUIREDWITHEMPLOYEESTIPOASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA.REQUIREDWITHEMPLOYEESTIPOASSENZA', 'REQUIRED_WITH_EMPLOYEES', 'COLUMN';

IF COL_LENGTH('dbo.QASS_TIPIASSENZA', 'SENSITIVE_DATA') IS NULL AND COL_LENGTH('dbo.QASS_TIPIASSENZA', 'SENDATTIPASS') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA.SENDATTIPASS', 'SENSITIVE_DATA', 'COLUMN';

-- 3. rename table too

IF OBJECT_ID('dbo.QASS_TIPI_ASSENZA', 'U') IS NULL
   AND OBJECT_ID('dbo.QASS_TIPIASSENZA', 'U') IS NOT NULL
BEGIN
    EXEC sp_rename 'dbo.QASS_TIPIASSENZA', 'QASS_TIPI_ASSENZA';
END

-- further rename one TIPI ASSENZA COLUMN

IF COL_LENGTH('dbo.QASS_TIPI_ASSENZA', 'PERSONALE_ASSIGNMENT_MANDATORY') IS NULL AND COL_LENGTH('dbo.QASS_TIPI_ASSENZA', 'REQUIRED_WITH_EMPLOYEES') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_TIPI_ASSENZA.REQUIRED_WITH_EMPLOYEES', 'PERSONALE_ASSIGNMENT_MANDATORY', 'COLUMN';	

-- 4. rename ASSENZE too
IF COL_LENGTH('dbo.QASS_ASSENZE', 'ID') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'IDASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.IDASSENZA', 'ID', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'ID_TIPO_ASSENZA') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'IDTIPOASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.IDTIPOASSENZA', 'ID_TIPO_ASSENZA', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'ASSENZA_DATE') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'DATEASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.DATEASSENZA', 'ASSENZA_DATE', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'DESCRIPTION') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'DESCRIPTIONASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.DESCRIPTIONASSENZA', 'DESCRIPTION', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'DURATION') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'DURATIONASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.DURATIONASSENZA', 'DURATION', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'START_TIME') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'STARTTIMEASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.STARTTIMEASSENZA', 'START_TIME', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'END_TIME') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'ENDTIMEASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.ENDTIMEASSENZA', 'END_TIME', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'CREATION_DATE_TIME') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'CREATIONDATETIMEASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.CREATIONDATETIMEASSENZA', 'CREATION_DATE_TIME', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'CREATED_BY') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'CREATEDBYASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.CREATEDBYASSENZA', 'CREATED_BY', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'LAST_MODIFIED_DATE_TIME') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'LASTMODIFIEDDATETIMEASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.LASTMODIFIEDDATETIMEASSENZA', 'LAST_MODIFIED_DATE_TIME', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'LAST_MODIFIED_BY') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'LASTMODIFIEDBYASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.LASTMODIFIEDBYASSENZA', 'LAST_MODIFIED_BY', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'AUTHORIZATION_LEVEL') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'AUTHORIZATIONLEVELASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.AUTHORIZATIONLEVELASSENZA', 'AUTHORIZATION_LEVEL', 'COLUMN';

IF COL_LENGTH('dbo.QASS_ASSENZE', 'PERSONALE') IS NULL AND COL_LENGTH('dbo.QASS_ASSENZE', 'PERSONALEASSENZA') IS NOT NULL
    EXEC sp_rename 'dbo.QASS_ASSENZE.PERSONALEASSENZA', 'PERSONALE', 'COLUMN';
	
IF OBJECT_ID('dbo.TIPOASSENZA', 'F') IS NOT NULL
    EXEC sp_rename 'dbo.TIPOASSENZA', 'FK_TIPO_ASSENZA', 'OBJECT';


	-- Drop FK EMPLOYEEASSENZA id exists
IF EXISTS (
    SELECT 1
    FROM sys.foreign_keys
    WHERE name = N'EMPLOYEEASSENZA'
      AND parent_object_id = OBJECT_ID(N'dbo.QASS_ASSENZE')
)
BEGIN
    ALTER TABLE dbo.QASS_ASSENZE
        DROP CONSTRAINT EMPLOYEEASSENZA;
END
GO

-- makes ID_DIPENDENTE nullable
IF COL_LENGTH('dbo.QASS_ASSENZE', 'ID_DIPENDENTE') IS NOT NULL
    AND EXISTS (
        SELECT 1
        FROM sys.columns
        WHERE object_id = OBJECT_ID(N'dbo.QASS_ASSENZE')
          AND name = N'ID_DIPENDENTE'
          AND is_nullable = 0
    )
BEGIN
    ALTER TABLE dbo.QASS_ASSENZE
        ALTER COLUMN ID_DIPENDENTE INT NULL;
END
GO

-- recreate the DK with better name and with cascade behavior
IF OBJECT_ID('dbo.QASS_ASSENZE', 'U') IS NOT NULL
AND OBJECT_ID('dbo.PER_ANAGRAFICA', 'U') IS NOT NULL
BEGIN
    -- Crea la FK solo se non esiste già con questo nome
    IF NOT EXISTS (
        SELECT 1
        FROM sys.foreign_keys fk
        WHERE fk.name = N'FK_ASSENZE_PERSONALE_CASCADE'
          AND fk.parent_object_id = OBJECT_ID(N'dbo.QASS_ASSENZE')
    )
    BEGIN
        ALTER TABLE dbo.QASS_ASSENZE WITH CHECK
        ADD CONSTRAINT FK_ASSENZE_PERSONALE_CASCADE
            FOREIGN KEY (ID_DIPENDENTE)
            REFERENCES dbo.PER_ANAGRAFICA (ID_DIPENDENTE)
            ON DELETE CASCADE
            ON UPDATE CASCADE;

        ALTER TABLE dbo.QASS_ASSENZE
        CHECK CONSTRAINT FK_ASSENZE_PERSONALE_CASCADE;
    END
END
