// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe ButtonBar: Rappresenta un frame di tipo
// Button Bar
// ************************************************

function ButtonBar(pform)
{
  // Chiamo il costruttore superiore
  WebFrame.call(this,pform); 
  //
  // Proprieta' di questo oggetto di modello
  this.CommandSet = null;       // L'oggetto command set da mostrare come buttonbar
  this.VerticalLayout = false;  // Bottoni in verticale o in orizzontale?  
  //
  // Oggetti visuali relativi alla ButtonBar
  this.ButtonBarContainer = null;   // Contenitore esterno dell'intera Button Bar
}
//
// Definisco l'estensione della classe
ButtonBar.prototype = new WebFrame();


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
ButtonBar.prototype.LoadProperties = function(node)
{
  // Chiamo la classe base
  WebFrame.prototype.LoadProperties.call(this,node);
  //
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
      case "bvr": this.SetVerticalLayout(attrnode.nodeValue == "1"); break;
      case "cms": this.SetCommandSet(attrnode.nodeValue); break;
    }
  }
}


// *******************************************************************
// Setter delle proprieta'
// *******************************************************************
ButtonBar.prototype.SetVerticalLayout= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.VerticalLayout = value;
}

ButtonBar.prototype.SetCommandSet= function(value) 
{
  // Prendo l'oggetto command set dalla mappa
  this.CommandSet = RD3_DesktopManager.ObjectMap[value];
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
ButtonBar.prototype.Realize = function(parent)
{
  // Chiamo la classe base
  WebFrame.prototype.Realize.call(this,parent);
  //
  // Ora realizzo i bottoni nel mio frame
  this.CommandSet.RealizeButtonBar(this);
}


// ***************************************************************
// Elimino gli oggetti Dom
// ***************************************************************
ButtonBar.prototype.Unrealize = function()
{
  // Chiamo la classe base
  WebFrame.prototype.Unrealize.call(this,parent);
  //
  // Ora elimino miei figli
  this.CommandSet.UnrealizeButtonBar();
}


// ********************************************************************************
// Evento di inizio tocco sulla lista bottoni
// lo uso solo per scrollare la lista
// ********************************************************************************
ButtonBar.prototype.OnTouchStart = function(e)
{
}


// ********************************************************************************
// Evento di movimento del ditino sul pannello
// ********************************************************************************
ButtonBar.prototype.OnTouchMove = function(e)
{
}


// ********************************************************************************
// Evento di movimento del ditino sul pannello
// ********************************************************************************
ButtonBar.prototype.OnTouchEnd = function(e)
{
}


// ********************************************************************************
// Gestisce lo scroll via touch del pannello.
// v e' la velocita' di scroll in ms, il segno indica la direzione
// n e' il numero di volte che e' stata eseguita la funzione
// ********************************************************************************
ButtonBar.prototype.TouchScrollTimer = function(dummy, ap)
{
}


// ********************************************************************************
// Annulla timer di scroll
// ********************************************************************************
ButtonBar.prototype.ClearTouchScrollTimer = function()
{
}
