// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe Panel: Rappresenta un frame di tipo
// Panel
// ************************************************

function IDPanel(pform)
{
  // Chiamo il costruttore superiore
  WebFrame.call(this,pform);
  //
  // Proprieta' di questo oggetto di modello
  this.PanelMode = 0;          // LIST 0 / FORM 1: default LIST
  this.Status = 0;             // QBE, DATA, UPDATED
  this.DOMaster = false;       // Pannello DO master?
  this.DOModified = false;     // Pannello DO modificato?
  this.DOSingleDoc = false;    // Pannello DO su singolo documento?
  this.DOCanSave = true;       // Il pannello puo' salvare il documento master?
  this.IsDO = false;           // MQ DO?
  this.HasDocTemplate = false; // Il Pannello ha il docTemplate?
  this.NumRows = 0;            // Numero di righe da visualizzare
  this.MaxHRow = 0;            // Massima altezza in px di una riga nella lista
  this.PanelPage = 0;          // La pagina di pannello attualmente selezionata
  this.HeaderSize = 0;         // Dimensione dei titoli delle colonne nella lista
  this.ShowRowSelector = true; // Mostrare selettori di riga?
  this.ShowMultipleSel =false; // Mostrare selettori per la multiselezione?
  this.EnableMultipleSel=true; // Abilitare il pannello alla multiselezione?  
  this.SelAllOnlyVis = false;  // La selezione di tutte le righe deve agire solo su quelle visibili?
  this.DynamicRows = 0;        // Numero max di righe dinamiche
  this.DynamicHeight = true;   // Altezza frame dinamica?
  this.HasScrollbar = true;    // Ha una scrollbar per navigare nei record?
  this.HasList = true;         // Ha un layout lista?
  this.HasForm = true;         // Ha un layout dettaglio?
  this.CanUpdate = true;       // Puo' modificare?
  this.CanDelete = true;       // Puo' cancellare?
  this.CanInsert = true;       // Puo' inserire?
  this.CanSearch = true;       // Puo' ricercare?
  this.CanSort = true;         // Puo' ordinare?
  this.ListLeft = 0;           // Posizione della lista
  this.ListTop = 0;            // Posizione della lista
  this.ListWidth = 0;          // Dimensione della lista
  this.ListHeight = 0;         // Dimensione della lista
  this.ActualRow = 0;          // Riga selezionata (da 0 a NumRows-1)
  this.ListPos = 1;            // Actual Position in list quando e' passata in form
  this.VResMode = 3;           // Tipo di ridimensionamento verticale della lista (default = stretch)
  this.HResMode = 3;           // Tipo di ridimensionamento orizzontale della lista (default = stretch)
  this.VisStyle = 0;           // Indice dello stile visuale del pannello
  this.FixedColumns = 0;       // Numero di righe fissate (non scrollano in orizzontale)
  this.QBETip = "";            // Stringa da mostrare nei tip QBE del pannello
  this.EnabledCommands = -1;   // Maschera dei comandi abilitati
  this.ExtEnabledCommands = -1;   // Maschera dei comandi abilitati estesi
  this.HasBook = false;        // Il Pannello contiene un Book?
  this.AdvTabOrder = false;    // Advanced Tab Order attivo?
  this.ActivateRightClick = false;  // La pressione del tasto destro su di un campo deve attivarlo?
  this.InfoMessages = false;   // Sono presenti i messaggi informativi (frequenti!)
  this.ConfirmDelete = true;   // Devo chiedere conferma per il salvataggio?
  this.HighlightDelete = true; // Devo evidenziare la riga che sto per cancellare?
  this.BlockingCommands = 0;   // Maschera dei comandi che generano eventi bloccanti
  this.CanReorderColumn = false;  // Le colonne in lista possono essere riordinate dall'utente?
  this.CanResizeColumn = false;   // Le colonne in lista possono essere ridimensionate dall'utente?
  this.GroupingEnabled = false;   // Il pannello supporta i gruppi in lista?
  this.ShowGroups = false;        // Mostrare il pulsante di gestione gruppi?
  this.TooltipOnEachRow = false;  // Mostrare il tooltip del campo su ogni riga?
  this.EnableInsertWhenLocked = false; // Il bottone di inserimento puo' essere mostrato quando il pannello e' bloccato?
  this.ResOnlyVisFlds = false;         // Il Resize deve riservare lo spazio per i campi invisibili?
  this.TableName = "";            // Codice della tabella/classe utilizzata dal pannello
  this.AutomaticLayout = false;   // Gestione automatica del layout
  this.VisualFlags = 0;           // Flag visuali
  this.LoadingPolicy = 1;       // 0 = manual, 1 = auto, 2 = continuous
  this.PullToRefresh = true; 
  this.UseListQBE = 0;
  this.HasListVisibilityControl = false;
  this.AllowMasterPanelNavigation = true; // Se false i pannelli master DO non consentono la navigazione se il documento e' modificato
  //
  this.ActualPosition = 1;     // Numero del record relativo alla prima riga del pannello
  this.TotalRows = 0;          // Numero totali di record nel pannello
  this.MoreRows = false;       // Ci sono altre righe nel recordset?  
  //
  this.ListTabOrder = null;    // Ordine dei campi in lista se AdvTabOrder = true
  this.FormTabOrder = null;    // Ordine dei campi in form  se AdvTabOrder = true
  this.ListGroupRoot = null;
  //
  this.RefreshToolbar = false;      // Devo riorganizzare la toolbar al termine della richiesta?
  this.ResetPosition = false;       // Devo mostrare di nuovi i valori a video al termine della richiesta?
  this.ScrollToPos = false;         // Devo farlo in modo scrolling?
  this.DenyScroll = false;          // Impedisce modo scrolling anche se poi viene richiesto?
  this.QbeScroll = false;           // Sono passato da qbe a data e devo riposizionare la scrollbar forzando la renderizzazione? (vedi setpanelstatus per spiegazioni)
  this.UpdateListGroups = false;    // Devo far riposizionare i gruppi negli array?
  this.AutomaticPageLayout = false; // Se True nascondiamo le pagine in lista
  //this.ResVisFld = false;       // Dei campi hanno cambiato la visibilita': devo applicare il resize
  //
  this.LastResizedField = 0;   // Ultimo campo ridimensionato in lista
  this.LastListResizeW = 0;    // Dimensioni del frame in lista (ultimo ridimensionamento)
  this.LastListResizeH = 0;    // Dimensioni del frame in lista (ultimo ridimensionamento)
  this.LastFormResizeW = 0;    // Dimensioni del frame in form  (ultimo ridimensionamento)
  this.LastFormResizeH = 0;    // Dimensioni del frame in form  (ultimo ridimensionamento)
  //
  this.CompactActualPosition = 0; // Riga attuale nella visione compatta
  //
  // Variabili di collegamento con il DOM
  //  
  // Oggetti secondari gestiti da questo oggetto di modello
  this.Pages = new Array();    // Lista delle pagine di pannello
  this.Groups = new Array();   // Lista dei gruppi di pannello
  this.Fields = new Array();   // Lista dei campi di pannello
  this.MultiSelStatus = null;  // Array di valori booleani per la gestione della multiselezione
  this.MsgBox = null;          // Msg box utilizzata per chiedere le conferme
  //
  // Struttura per la definizione degli eventi di questo pannello
  this.RowSelectEventDef = RD3_Glb.EVENT_ACTIVE;
  this.ScrollEventDef = RD3_Glb.EVENT_ACTIVE;
  this.ToolbarEventDef = RD3_Glb.EVENT_ACTIVE;
  this.PageClickEventDef = RD3_Glb.EVENT_ACTIVE;  // Click su una pagina
  this.MultiSelEventDef = RD3_Glb.EVENT_SERVERSIDE|RD3_Glb.EVENT_CLIENTSIDE;  // Cambio di multiselezione
  this.FocusEventDef = RD3_Glb.EVENT_CLIENTSIDE;
  this.TextSelEventDef = RD3_Glb.EVENT_DEFERRED; // Modifica del campo
  this.MouseOverEventDef = RD3_Glb.EVENT_CLIENTSIDE;
  //
  // Oggetti DOM di questo pannello
  this.ListBox = null;         // Il DIV che contiene tutto il layout lista del pannello
  this.FormBox = null;         // Il DIV che contiene tutto il layout form del pannello
  this.ListListBox = null;     // Il Div che contiene la lista
  this.ScrollAreaBox = null;   // Il Div che contiene la parte scrollabile della lista (in caso di FixedCol>0)
  //
  this.PagesBox = null;        // Il Div che contiene le pagine, renderizzato tra la toolbar box ed il contentbox
  this.PagesFiller = null;     // Span riempitore inserito dopo le pagine
  //
  this.ScrollBox = null;       // Il DIV che contiene la scrollbar del pannello
  this.ScrollClone = null;     // Il DIV che contiene la scrollbar del pannello
  this.ScrollBoxInt = null;    // Il DIV all'interno di ScrollBox che serve per attivare e dimensionare la scrollbar
  //
  this.ScrollBoxTouch = null;  // Il DIV sovrapposto a ScrollBox per dispositivi touch
  this.ScrollIntTouch = null;  // Il DIV intero a ScrollBoxTouch per i dispositivi touch (scrollbar)
  //
  this.RowSel = null;          // Array per i row selectors (se presenti)
  this.UpdateRSel = false;     // Usato per indicare se occorre aggiornare i RowSel quando non ho ancora le righe!
  //
  // Oggetti DOM per Toolbar
  this.StatusBar = null;            // Span contenente la status bar del pannello
  this.QBETIcon = null;             // Immagine per i QBETip
  this.TopButton = null;            // IMG rappresentante il pulsante di Top
  this.PrevButton = null;           // IMG rappresentante il pulsante di Prev
  this.NextButton = null;           // IMG rappresentante il pulsante di Next
  this.BottomButton = null;         // IMG rappresentante il pulsante di Bottom
  this.SearchButton = null;         // IMG che rappresenta il pulsante di ingresso in QBE
  this.FindButton = null;           // IMG che rappresenta il pulsante FIND DATA
  this.CancelButton = null;         // IMG che rappresenta il pulsante di annullamento modifiche
  this.FormListButton = null;       // IMG che rappresenta il pulsante di cambio di modo (lista/dettaglio)
  this.RefreshButton = null;        // IMG che rappresente il pulsante di aggiornamento dei dati
  this.DelButton = null;            // IMG che rappresenta il pulsante di cancellazione dei dati
  this.NewButton = null;            // IMG che rappresenta il pulsante di inserimento
  this.DuplButton = null;           // IMG che rappresente il pulsante di duplicazione
  this.SaveButton = null;           // IMG che rappresenta il pulsante di save
  this.PrintButton = null;          // IMG che rappresenta il pulsante di stampa
  this.CsvButton = null;            // IMG che rappresenta il pulsante di esportazione
  this.AttachButton = null;         // IMG che rappresenta il pulsante degli attachments
  this.CustomButtons = null;        // IMGs che rappresentano i custom commands
  this.TBZones = null;              // SPANs che suddividono la toolbar in parti
  //
  this.MultiSelectAllCmd = null;    // IMG per selezionare tutte le righe
  this.MultiSelectNoneCmd = null;   // IMG per togliere la selezione da tutte le righe
  this.ToggleMultiSelCmd = null;    // IMG per mettere o togliere i check della multiselezione
  //
  this.Rows = null;                 // Array dei TD delle righe
  //
  // Altre variabili globali
  this.LastPositionTime = null;     // Data e ora dell'ultimo posizionamento (per evitare scrolling durante esso)
  this.OldAttR = 0;                 // Ultima riga selezionata (usata nel posizionamento ritardato)
  this.QBETipBox = null;            // Oggetto MessageTooltip che mostra i QBETip
  this.Realizing = false;           // Indica stato di realizzazione per velocizzare operazioni
  this.AnimatingPanel = false;      // Sul pannello e' attiva una animazione?
  this.ListListZIndex = -1;         // ZIndex degli oggetti ListList
  this.ScrollTimer = 0;             // Timer per programmare lo scroll finale
  this.SkipScroll = -1;             // Variabile per saltare l'onscroll quando impostato da javascript
}
//
// Definisco l'estensione della classe
IDPanel.prototype = new WebFrame();


// *******************************************************************
// Inizializza questo Tree leggendo i dati da un nodo <wfr> XML
// *******************************************************************
IDPanel.prototype.LoadFromXml = function(node) 
{
  // Chiamo la classe base
  WebFrame.prototype.LoadFromXml.call(this, node);
  //
  // Carico campi del pannello
  var objlist = node.childNodes;
  var n = objlist.length;
  //
  // Ciclo su tutti i nodi che rappresentano oggetti figli
  for (var i=0; i<n; i++) 
  {
    var objnode = objlist.item(i);
    var nome = objnode.nodeName;
    //
    // In base al tipo di oggetto, invio il messaggio di caricamento
    switch (nome)
    {
      case "fld":
      {
        var newfld = new PField(this);
        this.Fields.push(newfld);
        newfld.LoadFromXml(objnode);        
      }
      break;
      
      case "grp":
      {
        // Leggo il nodo di primo livello, e poi passo il messaggio
        // di caricamento
        var newgrp = new PGroup(this);
        newgrp.LoadFromXml(objnode);
        this.Groups.push(newgrp);
      }
      break;
      
      case "ppg":
      {
        // Leggo il nodo di primo livello, e poi passo il messaggio
        // di caricamento
        var newppg = new PPage(this);
        newppg.LoadFromXml(objnode);
        this.Pages.push(newppg);
      }
      break;
    }
  }    
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
IDPanel.prototype.LoadProperties = function(node)
{
  // Chiamo la classe base
  WebFrame.prototype.LoadProperties.call(this, node);
  //
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  // 
  // Patch: alcuni attributi vanno gestiti prima di altri altrimenti il framework non funziona correttamente
  // il panelMode e' uno di questi (numRows dipende da lui)
  if (attrlist.getNamedItem && attrlist.getNamedItem("mod")) {
    this.SetPanelMode(parseInt(attrlist.getNamedItem("mod").nodeValue));
    attrlist.removeNamedItem("mod");
  }
  //
  var n = attrlist.length;
  //
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
      case "mod": this.SetPanelMode(parseInt(attrnode.nodeValue)); break;
      case "sta": this.SetPanelStatus(parseInt(attrnode.nodeValue)); break;
      case "num": this.SetNumRows(parseInt(attrnode.nodeValue)); break;
      case "mhr": this.SetMaxHRow(parseInt(attrnode.nodeValue)); break;
      case "pag": this.SetPanelPage(parseInt(attrnode.nodeValue)); break;
      case "hds": this.SetHeaderSize(parseInt(attrnode.nodeValue)); break;
      case "srs": this.SetShowRowSelector(attrnode.nodeValue=="1"); break;
      case "sms": this.SetShowMultipleSel(attrnode.nodeValue=="1"); break;
      case "ems": this.SetEnableMultipleSel(attrnode.nodeValue=="1"); break;
      case "sov": this.SetSelAllOnlyVis(attrnode.nodeValue=="1"); break;
      case "dyr": this.SetDynamicRows(parseInt(attrnode.nodeValue)); break;
      case "dyh": this.SetDynamicHeight(attrnode.nodeValue=="1"); break;
      case "hsc": this.SetHasScrollbar(attrnode.nodeValue=="1"); break;
      case "hli": this.SetHasList(attrnode.nodeValue=="1"); break;
      case "hfo": this.SetHasForm(attrnode.nodeValue=="1"); break;
      case "upd": this.SetCanUpdate(attrnode.nodeValue=="1"); break;
      case "del": this.SetCanDelete(attrnode.nodeValue=="1"); break;
      case "ins": this.SetCanInsert(attrnode.nodeValue=="1"); break;
      case "sea": this.SetCanSearch(attrnode.nodeValue=="1"); break;
      case "sor": this.SetCanSort(attrnode.nodeValue=="1"); break;
      case "lle": this.SetListLeft(parseInt(attrnode.nodeValue)); break;
      case "lto": this.SetListTop(parseInt(attrnode.nodeValue)); break;
      case "lwi": this.SetListWidth(parseInt(attrnode.nodeValue)); break;
      case "lhe": this.SetListHeight(parseInt(attrnode.nodeValue)); break;
      case "atr": this.SetActualRow(parseInt(attrnode.nodeValue),node.attributes["ftr"]!=undefined, true); break;
      case "vre": this.SetVResMode(parseInt(attrnode.nodeValue)); break;
      case "hre": this.SetHResMode(parseInt(attrnode.nodeValue)); break;
      case "sty": this.SetVisualStyle(parseInt(attrnode.nodeValue)); break;
      case "fix": this.SetFixedColumns(parseInt(attrnode.nodeValue)); break;
      case "qtp": this.SetQbeTip(attrnode.nodeValue); break;
      case "acp": this.SetActualPosition(parseInt(attrnode.nodeValue), true, true); break;
      case "tot": this.SetTotalRows(parseInt(attrnode.nodeValue)); break;
      case "enc": this.SetEnabledCommands(parseInt(attrnode.nodeValue)); break;
      case "eec": this.SetExtEnabledCommands(parseInt(attrnode.nodeValue)); break;
      case "bok": this.SetHasBook(attrnode.nodeValue=="1"); break;
      case "dom": this.SetDOModified(attrnode.nodeValue=="1"); break;
      case "mst": this.SetDOMaster(attrnode.nodeValue=="1"); break;
      case "csa": this.SetDOCanSave(attrnode.nodeValue=="1"); break;
      case "sdo": this.SetSingleDoc(attrnode.nodeValue=="1"); break;
      case "mor": this.SetMoreRows(attrnode.nodeValue=="1"); break;
      case "ata": this.SetAdvancedTabOrder(attrnode.nodeValue=="1"); break;
      case "arc": this.SetActivateRightClick(attrnode.nodeValue=="1"); break;
      case "inf": this.SetInfoMessages(attrnode.nodeValue=="1"); break;
      case "cde": this.SetConfirmDelete(attrnode.nodeValue=="1"); break;
      case "hde": this.SetHighlightDelete(attrnode.nodeValue=="1"); break;
      case "cbk": this.SetBlockingCommands(parseInt(attrnode.nodeValue)); break;
      case "rcl": this.SetCanReorderColum(attrnode.nodeValue=="1"); break;
      case "rsc": this.SetCanResizeColum(attrnode.nodeValue=="1"); break;
      case "grn": this.SetGroupingEnabled(attrnode.nodeValue=="1"); break;
      case "sgr": this.SetShowGroups(attrnode.nodeValue=="1"); break;
      case "tor": this.SetTooltipOnEachRow(attrnode.nodeValue=="1"); break;
      case "eil": this.SetEnableInsertWhenLocked(attrnode.nodeValue=="1"); break;
      case "rvf": this.SetResOnlyVisFlds(attrnode.nodeValue=="1"); break;
      case "vfl": this.SetVisualFlags(parseInt(valore)); break;
      case "dsn": this.SetTableName(valore); break;
      case "qbf": this.SetAutomaticLayout(attrnode.nodeValue=="1"); break;
      case "ido": this.SetIsDO(attrnode.nodeValue=="1"); break;
      case "hdt": this.SetHasDocTemplate(attrnode.nodeValue=="1"); break;
      case "lpl": this.SetLoadingPolicy(parseInt(valore)); break;
      case "pre": this.SetPullToRefresh(attrnode.nodeValue=="1"); break;
      case "apl": this.SetAutomaticPageLayout(attrnode.nodeValue=="1"); break;
      case "lqb": this.SetUseListQBE(attrnode.nodeValue); break;
      case "amp": this.SetAllowMasterPanelNavigation(valore == "1"); break;
      
      case "rck": this.RowSelectEventDef = parseInt(attrnode.nodeValue); break;
      case "pck": this.PageClickEventDef = parseInt(attrnode.nodeValue); break;
      case "tck": this.ToolbarEventDef = parseInt(attrnode.nodeValue); break;
      case "sck": this.ScrollEventDef = parseInt(attrnode.nodeValue); break;
      case "mse": this.MultiSelEventDef = parseInt(attrnode.nodeValue); break;
      case "fed": this.FocusEventDef = parseInt(attrnode.nodeValue); break;
      case "tsk": this.TextSelEventDef = parseInt(valore); break;
      case "moe": this.MouseOverEventDef = parseInt(attrnode.nodeValue); break;
      
      case "cla": this.ChangeLayoutAnimDef = valore; break;
      case "qta": this.QBETipAnimDef = valore; break;
    }
  }
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
IDPanel.prototype.ChangeProperties = function(node)
{
  // Vediamo se nel nodo di cambiamento sono indicati nuovi valori per i campi
  var objlist = node.childNodes;
  var n = objlist.length;
  for (var i = 0; i<n; i++)
  {
    var fv = objlist.item(i);
    //
    if (fv.nodeName == "fvl")
    {
      this.ResetPosition = true; // Al termine dovro' mostrare i valori
      this.ScrollToPos = true;   // In modo scrolling
      //
      // Prelevo il campo correlato
      var id = fv.getAttribute("id");
      var fld = RD3_DesktopManager.ObjectMap[id];
      if (fld)
        fld.LoadFromXml(fv);
    }
  }
  //
  // Proseguo con il cambio di proprieta'
  this.LoadProperties(node);
}

// *******************************************************************
// Setter delle proprieta'
// *******************************************************************
IDPanel.prototype.SetPanelMode= function(value, immediate) 
{
  var old = this.PanelMode;
  //
  // Passaggio da list a form...
  if (this.PanelMode==RD3_Glb.PANEL_LIST && value==RD3_Glb.PANEL_FORM)
    this.ListPos = this.ActualPosition;
  //
  if (value!=undefined)
    this.PanelMode = value;
  //
  if (this.Realized && (old!=this.PanelMode || value==undefined))
  {
    // Se sto cambiando layout
    if (!this.Realizing)
    {
      // Non posso effettuare scroll
      this.DenyScroll=true;
      //
      // Devo informare i gruppi del loro stato di collassamento
      var ng = this.Groups.length;
      for (var i=0; i<ng; i++)
        this.Groups[i].SetCollapsed();
      //
      // Verifico se c'e' un ActiveElement che riguarda un PValue appartenente a me: 
      // se lo e' e riguarda il layout che ho spento lo annullo
      // Infatti puo' capitare che l'activeelement rimanga impostato
      // ad un campo dlla lista quando invece il pannello e' gia' in form
      if (RD3_KBManager.ActiveElement)
      {
        var obj = RD3_KBManager.GetObject(RD3_KBManager.ActiveElement, true);
        //
        if (obj && obj instanceof PValue && obj.ParentField.ParentPanel==this)
        {
          // Come in RD3_KBManager.GetObject devo risalire la catena per cercare il primo oggetto con l'ID
          var objEl = RD3_KBManager.ActiveElement;
          while(!objEl.id && objEl.parentNode)
            objEl = objEl.parentNode;
          //
          var isList = objEl.id.indexOf(":lv")!=0;
          if ((this.PanelMode==RD3_Glb.PANEL_LIST && !isList) || (this.PanelMode!=RD3_Glb.PANEL_LIST && isList))
            RD3_KBManager.ActiveElement = null;
        }
      }
    }
    //
    if (this.PanelMode==RD3_Glb.PANEL_LIST && !this.Realizing && !RD3_Glb.IsMobile())
      this.ListBox.style.visibility = "hidden";
    //
    if (!this.Realizing)
    {
      var n = this.Fields.length;
      for (var i=0; i<n; i++)
      {
        var f = this.Fields[i];
        f.UpdateFieldVisibility();
      }
    }
    //
    if (this.PanelMode==RD3_Glb.PANEL_LIST && !this.Realizing && !RD3_Glb.IsMobile())
      this.ListBox.style.visibility = "";
    //
    // Dato che ho cambiato il layout... meglio riposizionare le SortImages dei campi
    if (old!=this.PanelMode && this.PanelMode==RD3_Glb.PANEL_LIST) {
      this.AlignHeader = true;
      this.AdaptFieldsSortImage = true;
    }
    //
    // Se devo gestire automaticamente la visibilita' dell'elenco delle pagine la gestisco ora
    if (this.Realized && this.VisHidePages() && this.PagesBox)
      this.PagesBox.style.display = "none";
    else if (this.Realized && this.AutomaticPageLayout && this.PagesBox && old != this.PanelMode)
      this.PagesBox.style.display = (this.PanelMode==RD3_Glb.PANEL_LIST ? "" : "none");
    //
    var skip = (value==undefined) || (old ==this.PanelMode) || (this.WebForm.Animating && !RD3_Glb.IsMobile()) || !this.HasList || !this.HasForm;
    //
    // Imposto l'animazione: salto allo stato finale se non c'e' value oppure se il vecchio valore non e' cambiato
    var fx = new GFX("list", (this.PanelMode>old), this, skip, null, this.ChangeLayoutAnimDef);
    fx.Immediate = immediate;
    RD3_GFXManager.AddEffect(fx);
  }
}

IDPanel.prototype.SetPanelStatus= function(value) 
{
  var old = this.Status;
  //
  if (value!=undefined)
    this.Status = value;
  //
  if (this.Realized && (value==undefined || old!=this.Status))
  {
    this.SetStatusBarText();
    this.SetCanSort();
    this.RefreshToolbar = true;
    this.ResetPosition = true;
    //
    // Se sono passato da QBE a DATA devo far riposizionare anche la scrollbar (ho cambiato riga, negli altri casi
    // la riga attuale non cambia..)
    if ((old == RD3_Glb.PS_QBE) && this.Status == RD3_Glb.PS_DATA && this.ScrollBox)
    {
      // Non posso mettere ScrollToPos a true perche' non farei la render dei campi ma solo la renderizzazione veloce 
      // e sbaglierei a disegnare le righe.
      // non posso riposizionare qui la scrollbar perche' l'utente potrebbe cambiare la riga attiva nell'afterfind
      // quindi mi memorizzo che devo comunque spostare la scrollbar alla fine di tutto, anche se ScrollToPos e' false
      this.QbeScroll = true;
    }
    //
    this.ScrollToPos = false;
  }
}


IDPanel.prototype.SetDOMaster= function(value) 
{
  if (value!=undefined)
    this.DOMaster = value;
  //
  if (this.Realized)
  {
    this.SetStatusBarText();
    this.RefreshToolbar = true;
  }
}

IDPanel.prototype.SetDOCanSave= function(value) 
{
  if (value!=undefined)
    this.DOCanSave = value;
  //
  if (this.Realized)
    this.RefreshToolbar = true;
}

IDPanel.prototype.SetDOModified= function(value) 
{
  if (value!=undefined)
    this.DOModified = value;
  //
  if (this.Realized) {
    this.SetStatusBarText();
    this.RefreshToolbar = true;
  }
}

IDPanel.prototype.SetSingleDoc= function(value) 
{
  if (value!=undefined)
    this.DOSingleDoc = value;
  //
  if (this.Realized) {
    this.SetStatusBarText();
    this.RefreshToolbar = true;
  }
}

IDPanel.prototype.SetNumRows= function(value) 
{
  var old = this.NumRows;
  //
  // Questo valore viene inviato dal server quando il pannello
  // va in form. Io non devo cambiare il numero di righe che
  // e' invece sepcifico della lista-
  if (value==1 && this.PanelMode==RD3_Glb.PANEL_FORM)
    return;
  //
  if (value!=undefined)
    this.NumRows = value;
  //
  if (this.NumRows<1)
    this.NumRows = 1;
  //
  delete this.MoreRowsRequested;
  if (this.Realized && (this.NumRows!=old || value==undefined))
  {
    if (this.HasList) {
      if (!this.Rows)
        this.Rows = [];
      //
      if (this.NumRows > this.Rows.length) {
        // Le righe sono aumentate, creo le righe mancanti
        var toCreate = this.NumRows - this.Rows.length;
        for (var i=0; i < toCreate; i++) {
          var tr = document.createElement("tr");
          this.ListRowsTBody.appendChild(tr);
          this.Rows.push(tr);
        }
      }
      else {
        // le righe sono diminuite, rimuovo quelle in piu' dall'array
        var delRows = this.Rows.splice(this.NumRows, this.Rows.length - this.NumRows);
        for (var i=0; i < delRows.length; i++)
          this.ListRowsTBody.removeChild(delRows[i]);
      }
      //
      // Passo il messaggio anche ai campi che devono sistemare
      // Gli oggetti visuali della lista
      var visitedFlds = [];
      if (this.AdvTabOrder) 
      {
        // Per prima cosa lavoro gli oggetti delle lista nell'ordine vero della lista, cosi' nascono nell'ordine giusto
        // poi rifaccio un giro e lavoro tutti i campi saltati (in questo modo non salto nulla e non ho problemi)
        for (var j=0; j < this.Fields.length; j++) 
        {
          var fl = this.ListTabOrder[j];
          if (fl && fl.InList && fl.ListList && !fl.IsStatic()) 
          {
            fl.SetNumRows(this.NumRows);
            visitedFlds.push(fl);
          }
        }
      }
      //
      var n = this.Fields.length;
      for (var i=0; i<n; i++)
        if (visitedFlds.indexOf(this.Fields[i]) == -1)
          this.Fields[i].SetNumRows(this.NumRows);
      //
      // Sistemo i row selectors
      if (!this.Realizing)
        this.SetShowRowSelector();
      //
      // Faccio una reset Position in modo da spingere la SetActualPosition alla fine della richiesta:
      // se arrivo qui da un resize la fa lui e poi annulla il flag, se arrivo qui dal server forzare 
      // la render non fa male, perche' altrimenti non lo farebbe nessuno..
      this.ResetPosition = true;
    }
  }
}

IDPanel.prototype.SetMaxHRow= function(value) 
{
  if (value!=undefined)
    this.MaxHRow = value;
  //
  if (this.Realized)
    this.RecalcLayout = true;
}

IDPanel.prototype.SetPanelPage= function(value, immediate) 
{
  var old = this.PanelPage;
  //
  if (value!=undefined)
    this.PanelPage = value;
  //
  if (this.Realized && (value==undefined || old!=this.PanelPage))
  {
    // Ciclo su tutte le pagine e ne imposto la visibilita'
    var n = this.Pages.length;
    for (var i=0; i<n; i++)
      this.Pages[i].UpdateSelection();
    //
    // Se abbiamo il dettaglio
    var rows;
    if (this.HasForm) {
      // Verifico se i campi della pagina corrente sono stati renderizzati
      rows = this.FormBox.getElementsByClassName("row-page-"+this.PanelPage);
      //
      // Non ci sono righe relative alla pagina : le realizzo ora
      if (!rows || rows.length === 0) {
        if (!this.FormGridRows)
          this.FormGridRows = [];
        this.RealizeFormGrid(false);
      }
      //
      // adesso devo nascondere tutte le righe relative alle pagine non selezionate e mostrare quelle relative alla pagina selezionata
      rows = this.FormBox.querySelectorAll("#"+RD3_Glb.escapeID(this.FormBox.id)+">.main-row-page");
      for (var i=0; i<rows.length; i++)
        rows[i].style.display = RD3_Glb.HasClass(rows[i], "row-page-"+this.PanelPage) ? "" : "none";
    }
    //
    if (this.hasListFormFields) {
      // Verifico se i campi della pagina corrente sono stati renderizzati
      rows = this.ListBox.getElementsByClassName("row-page-"+this.PanelPage);
      //
      // Non ci sono righe relative alla pagina : le realizzo ora
      if (!rows || rows.length === 0) {
        if (!this.ListGridRows)
          this.ListGridRows = [];
        //
        this.RealizeFormGrid(true);
      }
      //
      rows = this.ListBox.querySelectorAll("#"+RD3_Glb.escapeID(this.ListBox.id)+">.main-row-page");
      for (var i=0; i<rows.length; i++)
        rows[i].style.display = RD3_Glb.HasClass(rows[i], "row-page-"+this.PanelPage) ? "" : "none";
    }
    //
    // Aggioro la visibilita' dei gruppi
    var n = this.Groups.length;
    for (var i=0; i<n; i++)
      this.Groups[i].UpdateVisibility();
    //
    // Aggioro la visibilita' dei campi
    var n = this.Fields.length;
    for (var i=0; i<n; i++)
      this.Fields[i].UpdateFieldVisibility();
    //
    // Ho nascosto campi e gruppi, devo riallineare l'header della tabella
    this.AlignListHeader();
    //
    // Al termine devo adattare il layout e mostrare i valori
    if (immediate)
      this.SetActualPosition();
    else
      this.ResetPosition= true;
  }
}

IDPanel.prototype.SetHeaderSize= function(value) 
{
  if (value!=undefined)
    this.HeaderSize = value;
  //
  if (this.Realized) {
    this.RecalcLayout = true; 
    if (this.ListCaptionBox)
      RD3_Glb.SetDisplay(this.ListCaptionBox, this.HeaderSize > 0 ? "" : "none");
  }
}

IDPanel.prototype.SetLoadingPolicy= function(value) 
{
  if (value!=undefined)
    this.LoadingPolicy = value;
  //
  if (this.Realized)
  {
    
  }
}


IDPanel.prototype.SetPullToRefresh= function(value) 
{
  if (value!=undefined)
    this.PullToRefresh = value;
  //
  if (this.Realized)
  {
    
  }
}

IDPanel.prototype.SetUseListQBE= function(value) 
{
  if (value!=undefined)
    this.UseListQBE = value;
  //
  // Non puo' cambiare a run-time, verra' usato dai campi per disegnarsi in maniera speciale
}

IDPanel.prototype.SetShowRowSelector= function(value) 
{
  var old = this.ShowRowSelector;
  if (value!=undefined)
    this.ShowRowSelector = value;
  //
  if (this.Realized)
  {
    if (!this.ShowRowSelector && this.RowSel)
    {
      // Se non ci sono i row selector, li tolgo dal video
      var n = this.RowSel.length;
      for (var i=0; i<n; i++)
        this.RowSel[i].parentNode.removeChild(this.RowSel[i]);
      this.RowSel = null;
      this.RowSelCaption.parentNode.removeChild(this.RowSelCaption);
      delete this.RowSelCaption;
    }
    //
    // Realizzo anche i row selector se non lo avevo gia' fatto
    if (this.ShowRowSelector && this.ListBodyBox)
    {
      var _this = this;
      if (!this.RowSel)
        this.RowSel = [];
      //
      // Se nella caption manca la colonna del RS la creo e la aggiungo
      if (!this.RowSelCaption) {
        this.RowSelCaption = document.createElement("td");
        this.RowSelCaption.className = "list-row-selector-caption";
        //
        if (this.ListHeadersRow.firstChild)
          this.ListHeadersRow.insertBefore(this.RowSelCaption, this.ListHeadersRow.firstChild);
        else
          this.ListHeadersRow.appendChild(this.RowSelCaption);
        //
        if (this.MultiSelDropdown)
          this.RowSelCaption.appendChild(this.MultiSelDropdown);
      }
      //
      // In questo caso devo creare un div di 'tappo' sulla sinistra
      if (this.UseListQBE == RD3_Glb.PAN_QBEROW && !this.ListQBELCap) {
        this.ListQBELCap = document.createElement("td");
        this.ListQBELCap.className = "panel-field-value-list filter-clear-btn";
        //
        if (this.ListHeadersRow.firstChild)
          this.ListQBERow.insertBefore(this.ListQBELCap, this.ListQBERow.firstChild);
        else
          this.ListQBERow.appendChild(this.ListQBELCap);
        //
        var intCap = document.createElement("i");
        intCap.className = "panel-row-selector fa " + RD3_ClientParams.FA_ICON_FILTER;
        this.ListQBELCap.appendChild(intCap);
        //
        var _this = this;
        this.ListQBELCap.onclick = function (ev) {
          var ev = new IDEvent("qbeclall", _this.Identifier, null, RD3_Glb.EVENT_URGENT);
        }
      }
      //
      //
      if (this.RowSel.length!=this.NumRows)
      {
        // Distruggo i RowSel in piu'
        var n = this.RowSel.length;
        for (var i=this.NumRows; i<n; i++)
          this.RowSel[i].parentNode.removeChild(this.RowSel[i]);
        //
        this.RowSel.length = this.NumRows;
        //
        for (var i=0; i<this.NumRows; i++)
        {
          if (!this.RowSel[i])
          {
            var rs = document.createElement("td");
            //
            if (this.ShowMultipleSel)
            {
              var checkL = document.createElement("div");
              checkL.className = "checkbox";
              rs.appendChild(checkL);
              var label = document.createElement("label");
              checkL.appendChild(label);
              var check = document.createElement("input"); 
              label.appendChild(check);
              check.type = "checkbox";
              check.setAttribute("id", this.Identifier+":rscheck"+i);
              check.onclick = function(ev) {
                _this.OnMultiSelClick(ev);
              };
            }
            else
            {
              rs.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_ROWSEL));
              rs.onclick = function(ev) {
                _this.OnRowSelectorClick(ev);
              };
            }
            rs.setAttribute("id", this.Identifier+":rs"+i);
            RD3_Glb.AddClass(rs, "panel-list-row-selector");
            //
            // Se la riga esiste già inserisco il RowSel, altrimenti si inserirà quando verrà creata
            if (this.Rows && this.Rows[i]) {
              if (this.Rows[i].firstChild)
                this.Rows[i].insertBefore(rs, this.Rows[i].firstChild);
              else
                this.Rows[i].appendChild(rs);
            }
            //
            this.RowSel[i] = rs;
          }
        }
        //
        // Aggiorno lo stato della multiselezione
        this.UpdateMultipleSel();
        //
        // Se cambio i row sel devo fare una set actual position per far si che i pvalues disegnino le immagini giuste
        // in base al loro stato
        if (!this.ShowMultipleSel && old!=this.ShowRowSelector)
          this.ResetPosition = true;
      }
    }
  }
}

IDPanel.prototype.SetAdvancedTabOrder= function(value) 
{
  if (value!=undefined)
    this.AdvTabOrder = value;
  //
  // Questa proprieta' viene modificata solo durante l'inizializzazione
}

IDPanel.prototype.SetActivateRightClick= function(value) 
{
  if (value!=undefined)
    this.ActivateRightClick = value;
  //
  // Questa proprieta' deve essere valutata quando renderizzo i controlli
}

IDPanel.prototype.SetInfoMessages= function(value) 
{
  if (value!=undefined)
    this.InfoMessage = value;
  //
  if (this.Realized && value!=undefined)
  {
    // Il server ha cambiato il valore, devo modificare il layout dei messaggi
    this.WebForm.RealizeMessages();
  }
}

IDPanel.prototype.SetConfirmDelete= function(value) 
{
  if (value!=undefined)
    this.ConfirmDelete = value;
  //
  // Questa proprieta' viene valutata solo durante il click sulla toolbar quindi non
  // sono necessarie ulteriori operazioni
}

IDPanel.prototype.SetHighlightDelete= function(value) 
{
  if (value!=undefined)
    this.HighlightDelete = value;
  //
  // Questa proprieta' viene valutata solo durante il click sulla toolbar quindi non
  // sono necessarie ulteriori operazioni
}

IDPanel.prototype.SetBlockingCommands= function(value) 
{
  if (value!=undefined)
    this.BlockingCommands = value;
  //
  // Questa proprieta' non richiede altro... da ora in poi i comandi richiesti generano eventi bloccanti
}

IDPanel.prototype.SetCanReorderColum= function(value) 
{
  if (value!=undefined)
    this.CanReorderColumn = value;
  //
  // Questa proprieta' non richiede altro...
}

IDPanel.prototype.SetCanResizeColum= function(value) 
{
  if (value!=undefined)
    this.CanResizeColumn = value;
  //
  // Questa proprieta' non richiede altro...
}

IDPanel.prototype.SetGroupingEnabled= function(value) 
{
  if (value!=undefined)
    this.GroupingEnabled = value;
  //
  // Se sono realizzato faccio aggiornare la toolbar
  if (this.Realized)
    this.RefreshToolbar = true;
}

IDPanel.prototype.SetShowGroups= function(value) 
{
  if (value!=undefined)
    this.ShowGroups = value;
  //
  // Se sono realizzato faccio aggiornare la toolbar
  if (this.Realized && this.IsGrouped())
  {
    
  }
}


IDPanel.prototype.SetShowMultipleSel= function(value) 
{
  var old = this.ShowMultipleSel;
  //
  if (value!=undefined)
    this.ShowMultipleSel = value;
  //
  if (this.Realized && this.EnableMultipleSel && (old!=this.ShowMultipleSel || value==undefined))
  {
    // Cambio i comandi nella toolbar, poi sistemo i rowselector (se mostrati)
    if (this.MultiSelectAllCmd)
    {
      if (this.MultiSelectAllCmd)
      {
        this.MultiSelectAllCmd.style.display = this.ShowMultipleSel ? "" : "none";
        this.MultiSelectNoneCmd.style.display = this.ShowMultipleSel ? "" : "none";
        this.ToggleMultiSelCmd.firstChild.textContent = this.ShowMultipleSel ? ClientMessages.TIP_TITLE_SelectPopupCmd : ClientMessages.TIP_TITLE_TooltipRowSel;
      }
      //
      // Questo serve per cambiare i rowsel da bottoni attivatori a checkboxes
      if (this.ShowRowSelector) {
        this.SetShowRowSelector(false);
        this.SetShowRowSelector(true);
        this.UpdateRSel = true;
      }
    }
  }
}

IDPanel.prototype.SetEnableMultipleSel= function(value) 
{
  if (value!=undefined)
  {
    if (!value)
      this.SetShowMultipleSel(false);
    this.EnableMultipleSel = value;
  }
  //
  if (this.Realized && this.ListBox && this.ShowRowSelector)
  {
    // Se nella caption manca la colonna del RS/MultipleSel la creo e la aggiungo
    if (!this.RowSelCaption) {
      this.RowSelCaption = document.createElement("td");
      this.RowSelCaption.className = "list-row-selector-caption";
      //
      if (this.ListHeadersRow.firstChild)
        this.ListHeadersRow.insertBefore(this.RowSelCaption, this.ListHeadersRow.firstChild);
      else
        this.ListHeadersRow.appendChild(this.RowSelCaption);
    }
    //
    // Creo/distruggo toolbar di selezione multipla
    if (!this.EnableMultipleSel)
    {
      if (this.MultiSelDropdown && this.MultiSelDropdown.parentNode)
        this.MultiSelDropdown.parentNode.removeChild(this.MultiSelDropdown);
      //
      // Annullo anche i puntatori
      this.MultiSelDropdown = null;
      this.MultiSelDropdownButton = null;
      this.MultiSelDropdownList = null;
      this.MultiSelectAllCmd = null;
      this.MultiSelectNoneCmd = null;
      this.ToggleMultiSelCmd = null;
    }
    else
    {
      if (!this.MultiSelDropdown) {
        this.MultiSelDropdown = document.createElement("div");
        this.MultiSelDropdown.className = "dropdown";
        this.RowSelCaption.appendChild(this.MultiSelDropdown);
        //
        this.MultiSelDropdownButton = RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_MULTISEL)
        this.MultiSelDropdownButton.className = this.MultiSelDropdownButton.className + " dropdown-toggle multiple-sel-dropdown";
        this.MultiSelDropdown.appendChild(this.MultiSelDropdownButton);
        //
        this.MultiSelDropdownList = document.createElement("ul");
        this.MultiSelDropdownList.className = "dropdown-menu multiple-sel-drop";
        //
        this.MultiSelBackDrop = document.createElement("div");
        this.MultiSelBackDrop.className = "multisel-dropdown-back";
        this.MultiSelBackDrop.style.display = "none";
        //
        this.ListBodyBox.appendChild(this.MultiSelBackDrop);
        this.ListBodyBox.appendChild(this.MultiSelDropdownList);
        //
        var _this = this;
        this.MultiSelDropdownButton.onclick = function () {
          if (_this.MultiSelDropdownList.style.display == "") {
            _this.MultiSelBackDrop.style.display = "";
            _this.MultiSelDropdownList.style.display = "block";
            _this.MultiSelDropdownList.style.top = _this.ListCaptionBox.clientHeight + "px";
          }
          else {
            _this.MultiSelDropdownList.style.display = "";
            _this.MultiSelBackDrop.style.display = "none";
          }
        };
        this.MultiSelBackDrop.onclick = function () {
          _this.MultiSelDropdownList.style.display = "";
          _this.MultiSelBackDrop.style.display = "none";
        };
        //
        this.MultiSelectAllCmd = document.createElement("li");
        this.MultiSelectAllCmd.setAttribute("id", this.Identifier+":ms0");
        this.MultiSelDropdownList.appendChild(this.MultiSelectAllCmd);
        var link1 = document.createElement("a");
        link1.textContent = ClientMessages.TIP_TITLE_TooltipSelectAll;
        this.MultiSelectAllCmd.appendChild(link1);
        //
        this.MultiSelectNoneCmd = document.createElement("li");
        this.MultiSelectNoneCmd.setAttribute("id", this.Identifier+":ms1");
        this.MultiSelDropdownList.appendChild(this.MultiSelectNoneCmd);
        var link2 = document.createElement("a");
        link2.textContent = ClientMessages.TIP_TITLE_TooltipDeseleziona;
        this.MultiSelectNoneCmd.appendChild(link2);
        //
        this.ToggleMultiSelCmd = document.createElement("li");
        this.ToggleMultiSelCmd.setAttribute("id", this.Identifier+":ms2");
        this.MultiSelDropdownList.appendChild(this.ToggleMultiSelCmd);
        var link3 = document.createElement("a");
        link3.textContent = ClientMessages.TIP_TITLE_SelectPopupCmd;
        this.ToggleMultiSelCmd.appendChild(link3);
        //
        this.MultiSelectAllCmd.onclick = function(ev) {
          this.OnMultiSelCmd(ev, "selall");
        }.bind(this);
        this.MultiSelectNoneCmd.onclick = function(ev) {
          this.OnMultiSelCmd(ev, "selnone");
        }.bind(this);
        this.ToggleMultiSelCmd.onclick = function(ev) {
          this.OnMultiSelCmd(ev, "seltog");
        }.bind(this);
      }
      //
      if (this.MultiSelStatus==null)
        this.MultiSelStatus = new Array();
      //
      // Devo anche gestire la visibilita' corretta: ma lo fa la SetShowMultipleSel (lo faccio qui perche' c'e'
      // bisogno dell'array MultiSelStatus)
      this.SetShowMultipleSel();
    }    
  }
}

IDPanel.prototype.SetSelAllOnlyVis = function(value) 
{
  if (value!=undefined)
    this.SelAllOnlyVis = value;
  //
  // Questa proprieta' non richiede altro...
}

IDPanel.prototype.SetDynamicRows= function(value) 
{
  if (value!=undefined)
    this.DynamicRows = value;
  //
  // Nulla da fare ora, si vedra' al prossimo cambio di righe
}

IDPanel.prototype.SetDynamicHeight= function(value) 
{
  if (value!=undefined)
    this.DynamicHeight = value;
  //
  // Nulla da fare ora, si vedra' al prossimo cambio di righe
}

IDPanel.prototype.SetHasScrollbar= function(value) 
{
  if (value!=undefined)
    this.HasScrollbar = value;
  //
  if (this.Realized)
  {
    
  }
}

IDPanel.prototype.SetHasList= function(value) 
{
  if (value!=undefined)
    this.HasList = value;
  //
  // Questo parametro viene modificato solo in fase di inizializzazione
}

IDPanel.prototype.SetHasForm= function(value) 
{
  if (value!=undefined)
    this.HasForm = value;
  //
  // Questo parametro viene modificato solo in fase di inizializzazione
}

IDPanel.prototype.SetCanUpdate= function(value) 
{
  var old = this.CanUpdate;
  if (value!=undefined)
    this.CanUpdate = value;
  //
  if (this.Realized)
  {
    // Se e' cambiato, aggiorno il pannello, dato che passo da ENABLED a DISABLED
    // Inoltre aggiorno al toolbar
    if (old != this.CanUpdate)
    {
      this.ResetPosition = true;
      this.RefreshToolbar = true;
    }
  }
}

IDPanel.prototype.SetCanDelete= function(value) 
{
  var old = this.CanDelete;
  if (value!=undefined)
    this.CanDelete = value;
  //
  if (this.Realized)
  {
    // Se e' cambiato, aggiorno il pannello, dato che passo da ENABLED a DISABLED
    // Inoltre aggiorno al toolbar
    if (old != this.CanDelete)
      this.RefreshToolbar = true;
  }
}

IDPanel.prototype.SetCanInsert= function(value) 
{
  var old = this.CanInsert;
  if (value!=undefined)
    this.CanInsert = value;
  //
  if (this.Realized)
  {
    // Se e' cambiato, aggiorno il pannello, dato che passo da ENABLED a DISABLED
    // Inoltre aggiorno al toolbar
    if (old != this.CanInsert)
    {
      this.RefreshToolbar = true;
    }
  }
}

IDPanel.prototype.SetCanSearch= function(value) 
{
  if (value!=undefined)
    this.CanSearch = value;
  //
  if (this.Realized)
  {
    this.RefreshToolbar = true;
  }
}

IDPanel.prototype.SetCanSort= function(value) 
{
  if (value!=undefined)
    this.CanSort = value;
  //
  if (this.Realized)
  {
    // Passo il messaggio a tutti i campi che sistemeranno la caption
    var n = this.Fields.length;
    for (var i=0; i<n; i++)
      this.Fields[i].SetCanSort(this.CanSort && this.Status==RD3_Glb.PS_DATA);
  }
}

IDPanel.prototype.SetListLeft= function(value) 
{
  if (value!=undefined)
    this.ListLeft = value;
}

IDPanel.prototype.SetListTop= function(value) 
{
  if (value!=undefined)
    this.ListTop = value;
}

IDPanel.prototype.SetListWidth= function(value) 
{
  if (value!=undefined)
    this.ListWidth = value;
}

IDPanel.prototype.SetListHeight= function(value) 
{
  // Nel caso mobile non modifico l'altezza della lista se sono in form
  // questo perche' con le righe dinamiche quando vado in form il sistema
  // sente di dover modificare l'altezza anche della lista e questo
  // poi rompe l'animazione di ritorno
  if (this.PanelMode==RD3_Glb.PANEL_FORM && RD3_Glb.IsMobile())
    return;
  //
  var old = this.ListHeight;
  //
  if (value!=undefined)
    this.ListHeight = value;
}

IDPanel.prototype.SetHeight= function(value)
{
  WebFrame.prototype.SetHeight.call(this, value);
}

IDPanel.prototype.SetActualRow= function(value, force, fromServer)
{
  this.OldAttR = this.ActualRow;
  //
  if (value!=undefined)
    this.ActualRow = value;
  //
  if (this.Realized && (this.ActualRow!=this.OldAttR || value==undefined) && this.HasList)
  {
    if (this.VisStyle && this.ShowRowSelector) {
      if (this.RowSel[this.OldAttR])
        this.VisStyle.ApplyValueStyle(this.RowSel[this.OldAttR], true, false, false, false, true, false, false, "", false, false, true);
      if (this.RowSel[this.ActualRow])
        this.VisStyle.ApplyValueStyle(this.RowSel[this.ActualRow], true, false, false, true, true, false, false, "", false, false, true);
    }
    //
    if (RD3_Glb.IsBZen())
    {
      // Rendo la riga selezionata
      if (this.OldAttR >= 0 && this.Rows && this.Rows[this.OldAttR])
        RD3_Glb.RemoveClass(this.Rows[this.OldAttR], "selected");
      if (this.ActualRow >= 0 && this.Rows && this.Rows[this.ActualRow])
        RD3_Glb.AddClass(this.Rows[this.ActualRow], "selected");
    }
    //
    this.RefreshToolbar = true;
    if (fromServer && !this.ResetPosition)
      this.ResetPosition = true;
    //
    // Se il cambio riga arriva dal server e noi siamo in lista dobbiamo scrollare in modo da tenere la
    // la riga a video
    if (fromServer && this.PanelMode == RD3_Glb.PANEL_LIST && this.Rows && this.Rows.length > this.ActualRow) {
      var rw = this.Rows[this.ActualRow];
      var tp = this.ListBodyBox.scrollTop;
      var btn = this.ListBodyBox.scrollTop + this.ListBodyBox.offsetHeight;
      //
      // Se la riga non e' nell'area visibile allora sposto la scrollbar in modo da renderla visibile
      if (rw.offsetTop < tp || rw.offsetTop > btn)
        this.ListBodyBox.scrollTop = rw.offsetTop;
    }
  }
}

IDPanel.prototype.SetVResMode= function(value) 
{
  if (value!=undefined)
    this.VResMode = value;
  //
  // Questa proprieta' non varia dopo l'inizializzazione
}

IDPanel.prototype.SetHResMode= function(value) 
{
  if (value!=undefined)
    this.HResMode = value;
  //
  // Questa proprieta' non varia dopo l'inizializzazione
}

IDPanel.prototype.SetVisualStyle= function(value) 
{
  var old = this.VisStyle;
  if (value!=undefined) {
    // Era gia' un visual style
    if (value.Identifier)
      this.VisStyle = value;
    else
      this.VisStyle = RD3_DesktopManager.ObjectMap["vis:"+value];
  }
  //
  if (this.Realized && this.VisStyle) {
    // Bordo dei campi
    if (this.ListRowsTable) {
      // Il bordo o c'è o non c'è.. quindi se è <=1 (NONE) tolgo la classe altrimenti la metto
      if (this.VisStyle.GetBorders(1) <= 1) {
        RD3_Glb.RemoveClass(this.ListRowsTable, "table-bordered");
        RD3_Glb.RemoveClass(this.ListBodyBox, "panel-list-bordered");
      }
      else {
        RD3_Glb.AddClass(this.ListRowsTable, "table-bordered");
        RD3_Glb.AddClass(this.ListBodyBox, "panel-list-bordered");
      }
    }
    //
    // Colore di sfondo del pannello
    var gradDir = this.VisStyle.GetGradDir(6); // VISCLR_BACKPANEL
    if (gradDir != 1) {
      var fromColor = this.VisStyle.GetColor(6);  // VISCLR_BACKPANEL
      var toColor = this.VisStyle.GetGradColor(6);  // VISCLR_BACKPANEL
      //
      if (this.FrameBox) {
        var s = this.FrameBox.style;
        if (RD3_Glb.IsIE(10, false)) {
          s.filter = "progid:DXImageTransform.Microsoft.Gradient(GradientType="+(gradDir==2?1:0)+",StartColorStr="+fromColor+",EndColorStr="+toColor+")";
          //
          // Se non c'e' un colore di sfondo lo metto comunque... 
          // altrimenti IE non gestisce il click sul div perche' lo crede trasparente!
          s.backgroundColor = fromColor;
        }
        else {
          s.background = "linear-gradient(" + (gradDir==2? "90deg" : "180deg") + ", "+fromColor+", "+toColor+")";
          s.backgroundColor = fromColor;
        }
      }
    }
    else {
      this.FrameBox.style.backgroundColor = this.VisStyle.GetColor(6);  // VISCLR_BACKPANEL 
    }
    //
    // Classe CSS da Visual Style, la applico solo se il VS e' cambiato
    if (old && old.GetClassName && old.GetClassName())
        RD3_Glb.RemoveClass(this.FrameBox, old.GetClassName());
    if (this.VisStyle.GetClassName && this.VisStyle.GetClassName())
      RD3_Glb.AddClass(this.FrameBox, this.VisStyle.GetClassName());
  }
}

IDPanel.prototype.SetFixedColumns= function(value) 
{
  var old = this.FixedColumns;
  //
  if (value!=undefined)
    this.FixedColumns = value;
  //
  if (this.Realized && (old!=this.FixedColumns || value==undefined))
    this.RecalcLayout = true;
}

IDPanel.prototype.SetQbeTip= function(value) 
{
  if (value!=undefined)
    this.QBETip = value;
  if (this.Realized)
  {
    this.QBETip = this.QBETip.replace("<table>", "<table class='qbe-tip-table'>");
    this.QBETip = this.QBETip.replace(/QBEF1/g, "qbe-field");
    this.QBETip = this.QBETip.replace(/QBEF2/g, "qbe-value");
    //
    if (RD3_Glb.IsIconString(this.QBETip))
      this.QBETip = RD3_Glb.HandleIconString(this.QBETip);
    //
    this.QBETIcon.setAttribute("data-content", this.QBETip);
    //
    // Siamo un detail DO, il server ha svuotato il QBETip, ma non va a svuotare il QBEFilter dei campi 
    // (in realta' lo fa ma non me lo dice), quindi lo tolgo io
    if (value == "" && this.IsDO && !this.DOMaster) 
    {
      for (var i = 0; i < this.Fields.length; i++) {
        var f = this.Fields[i];
        if (f.InList && f.ListList && f.QBEFilter)
          f.SetQBEFilter("");
      }
    }
  }
}

IDPanel.prototype.SetActualPosition= function(value, delay, scroll) 
{
  var old = this.ActualPosition;
  //
  if (value!=undefined)
    this.ActualPosition = value;
  //
  if (this.Realized && (old!=this.ActualPosition || value==undefined))
  {
    if (delay)
    {
      // Chiedo aggiornamento al termine delle operazioni,
      // ma solo se non era gia' stato chiesto
      if (!this.ResetPosition)
      {
        this.ResetPosition = true;
        this.ScrollToPos = scroll;
      }
    }
    else
    {
      // Su firefox, cerco di eliminare l'onda dell'aggiornamento della lista!
      // Per farlo rimuovo l'intera lista dal DOM... aggiorno tutto, poi la ripristino!
      var fctop = 0;
      var wasfoc = false;
      //
      // I dati devono essere gia' arrivati, in quanto vengono caricati prima dal ChangeProperties
      // Innanzitutto mando il messaggio ai campi
      var n = this.Fields.length;
      for (var i=0; i<n; i++)
        this.Fields[i].SetActualPosition(this.ActualPosition, undefined, undefined, scroll);
      //
      // Aggiorno lo stato della multiselezione
      this.UpdateMultipleSel();
      //    
      // Certifico che l'ho gia' fatto
      this.ResetPosition = false;
      this.DenyScroll = false;
    }
    //
    // Ho cambiato posizione: aggiorno la toolbar (se sono in list viene fatto dalla setactualrow se necessario,
    // in form e' necessario farlo qui)
    if (this.HasForm) {
      this.SetStatusBarText();
      this.RefreshToolbar = true;
    }
  }
}

IDPanel.prototype.SetTotalRows= function(value) 
{
  var old = this.TotalRows;
  if (value!=undefined)
    this.TotalRows = value;
  //
  if (this.Realized)
  {
    this.SetStatusBarText();
    this.RefreshToolbar = true;
  }
}


IDPanel.prototype.SetMoreRows= function(value) 
{
  if (value!=undefined)
    this.MoreRows = value;
}

IDPanel.prototype.SetEnabledCommands = function(value)
{
   if (value!=undefined)
    this.EnabledCommands = value; 
  //
  if (this.Realized) {
    this.RefreshToolbar = true;
  }
}

IDPanel.prototype.SetExtEnabledCommands = function(value)
{
   if (value!=undefined)
    this.ExtEnabledCommands = value; 
  //
  if (this.Realized)
    this.RefreshToolbar = true;
}

IDPanel.prototype.SetHasBook = function(value)
{
   if (value!=undefined)
    this.HasBook = value;
  //
  // Questo valore non viene modificato dopo l'inizializzazione
}

IDPanel.prototype.ResetCache= function(ev, node) 
{
  delete this.MoreRowsRequested;
  var n = this.Fields.length;
  for (var i=0; i<n; i++)
    this.Fields[i].ResetCache(node);
}


IDPanel.prototype.ResetGroups= function() 
{
  
}

IDPanel.prototype.SetVisible= function(value)
{
  var old = this.Visible;
  WebFrame.prototype.SetVisible.call(this, value);
  //
  // Se sono diventato vibili chiedo di riallineare gli header di lista
  if (this.Realized && this.Visible && old != this.Visible)
    this.AlignHeader = true;
}

IDPanel.prototype.MultipleSelection= function(ev, node) 
{
  if (this.MultiSelStatus==null)
    this.MultiSelStatus = new Array();
  //
  var row = parseInt(node.getAttribute("row"));
  var value = parseInt(node.getAttribute("value"));
  //
  if (row==-1)
  {
    // Cambia la selezione nel suo complesso...
    this.ChangeSelection(value, true);
    //
    // Tronco l'array all'attuale numero di record
    this.MultiSelStatus.length = (this.Status!=RD3_Glb.PS_QBE ? this.TotalRows+1 : 1);
  }
  else
  {
    this.MultiSelStatus[row]=(value==1);
  }
  //
  if (this.Realized)
    this.UpdateMultipleSel();
}

IDPanel.prototype.SetTooltipOnEachRow = function(value) 
{
  if (value != undefined)
    this.TooltipOnEachRow = value;
}

IDPanel.prototype.SetEnableInsertWhenLocked = function(value) 
{
  if (value != undefined)
    this.EnableInsertWhenLocked = value;
  //
  if (this.Realized)
  {
    // TODO: ottimizzare
    this.RefreshToolbar = true;
  }
}

IDPanel.prototype.SetResOnlyVisFlds = function(value) 
{
  if (value != undefined)
    this.ResOnlyVisFlds = value;
}
 
IDPanel.prototype.SetVisualFlags = function(value) 
{
  this.VisualFlags = value;
}
 
IDPanel.prototype.VisHiliteRow = function()
{
  return this.VisualFlags & 0x2000;
}
 
IDPanel.prototype.VisHidePages = function()
{
  return this.VisualFlags & 0x4000;
}
 
IDPanel.prototype.SetTableName = function(value) 
{
  if (value != undefined)
    this.TableName = value;
}

IDPanel.prototype.SetAutomaticLayout = function(value) 
{
  if (value != undefined)
    this.AutomaticLayout = value;
}

IDPanel.prototype.SetIsDO = function(value) 
{
  if (value != undefined)
    this.IsDO = value;
}

IDPanel.prototype.SetHasDocTemplate = function(value) 
{
  if (value != undefined)
    this.HasDocTemplate = value;
  //
  if (this.Realized)
    this.RefreshToolbar = true;
}

IDPanel.prototype.SetAutomaticPageLayout = function(value) 
{
  if (value != undefined)
    this.AutomaticPageLayout = value;
  // 
  // Il valore non puo' cambiare dopo la realizzazione
}

// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
IDPanel.prototype.Realize = function(parent)
{
  // Chiamo la classe base
  if (!this.Realized)
    WebFrame.prototype.Realize.call(this, parent);
  this.Realizing = true;
  //
  // La classe base mette Realized=true, io lo resetto e poi lo rimetto
  this.Realized = false;
  var _this = this;
  //
  for (var fi = 0; fi < this.Fields.length; fi++)
    if (this.Fields[fi].CanHideInList()) {
      this.HasListVisibilityControl = true;
      break;
    }
  //
  this.CompileFieldList();
  //
  // Imposto il tabIndex per poter intercettare i tasti funzione
  this.FrameRow.setAttribute("tabindex", "0");
  //
  if (this.HasForm)
  { 
    this.FormBox = document.createElement("div");
    this.FormBox.setAttribute("id", this.Identifier+":fb");
    this.FormBox.className = "panel-form-container";
    this.ContentBox.appendChild(this.FormBox);
  }
  //
  if (this.HasList)
  {
    this.ListBox = document.createElement("div");
    this.ListBox.setAttribute("id", this.Identifier+":lb");
    this.ListBox.className = "panel-list-container";
    this.ContentBox.appendChild(this.ListBox);
    //
    // Creo i div in cui andranno le caption dei campi e le righe
    this.ListCaptionBox = document.createElement("div");
    this.ListCaptionBox.className = "panel-list-caption-box" + (!this.EnableMultipleSel || !this.ShowRowSelector ? " panel-list-caption-box-can-scroll" : "");
    this.ListBodyBox = document.createElement("div");
    this.ListBodyBox.className = "panel-list-body-box";
    if (this.WebForm.ResModeH === RD3_Glb.FRESMODE_NONE && !this.ParentFrameIdentifier)
      this.ListBodyBox.className += " panel-list-body-no-resize";
    this.ListBox.appendChild(this.ListCaptionBox);
    this.ListBox.appendChild(this.ListBodyBox);
    //
    // Creo le due table, la prima per gli header e la seconda per le righe (in modo da poter scrollare avendo l'header fissato)
    this.ListHeadersTable = document.createElement("table");
    this.ListHeadersTable.className = "table panel-list-header-table  table-condensed";
    this.ListRowsTable = document.createElement("table");
    this.ListRowsTable.className = "table table-striped table-hover panel-list-rows-table table-condensed";
    this.ListCaptionBox.appendChild(this.ListHeadersTable);
    this.ListBodyBox.appendChild(this.ListRowsTable);
    this.ListRowsTBody = document.createElement("tbody");
    this.ListRowsTable.appendChild(this.ListRowsTBody);
    //
    // Creo la riga per l'header (serve il TBODY)
    var headerTBody = document.createElement("thead");
    this.ListHeadersTable.appendChild(headerTBody);
    this.ListHeadersRow = document.createElement("tr");
    headerTBody.appendChild(this.ListHeadersRow);
    //
    this.ListBodyBox.onscroll = function(ev) {
      _this.OnScroll(ev);
    };
    this.ListBodyBox.addEventListener("wheel", function (ev) {
      _this.OnMouseWheel(ev);
    }, true);
    //
    // Creo una colonna in piu' che servira' per allineare intestazioni e campi nel caso di scrollbar visibile
    // (la scrollbar viene mostrata solo sulla tabella sotto , quindi o sopra la tabella la facciamo rientrare di 18px 
    // - ma e' brutto - oppure mostriamo una colonna in piu' che si sovrapporra' alla scrollbar)
    this.ListHeaderScroller = document.createElement("td");
    this.ListHeaderScroller.className = "filler-list-col"
    this.ListHeaderScroller.style.display = "none";
    this.ListHeaderScroller.style.width = "18px";
    //
    if (this.UseListQBE == RD3_Glb.PAN_QBEROW) 
    {
      // Devo creare la nuova riga per la ricerca in lista
      this.ListQBERow = document.createElement("tr");
      this.ListQBERow.className = "list-qbe-row"
      headerTBody.appendChild(this.ListQBERow);
    }
  }
  //
  var n = this.Pages.length;
  if (n > 0)
  {
    // Creo il div in cui vengono contenute le pagine
    this.PagesBox = document.createElement("ul");
    this.PagesBox.className = "nav nav-tabs";
    this.PagesBox.id = this.Identifier + ":pgb";    
    //
    // Lo inserisco nel DOM
    this.FrameBox.insertBefore(this.PagesBox, this.ContentBox);
    //
    // Faccio realizzare le pagine
    for (var i=0; i<n; i++)
      this.Pages[i].Realize(this.PagesBox);
  }
  //
  // Ora realizzo tutte i fields non ancora realizzati
  n = this.Fields.length;
  for (var i=0; i<n; i++)
    this.Fields[i].Realize();
  //
  // Ora realizzo tutte i gruppi non ancora realizzati
  n = this.Groups.length;
  for (var i=0; i<n; i++)
    this.Groups[i].Realize();
  //
  //
  // Ora che ho sia i gruppi che i campi posso gestire il layout form: devo per prima cosa creare
  // la griglia
  this.FormGridRows = [];
  if (this.Pages.length > 0) {
    // Devo realizzere le righe relative alle varie pagine, lo faccio qui spostando temporaneamente la 
    // pagina
    var oldSel = this.PanelPage;
    for (var i=-1; i<this.Pages.length; i++) {
      this.PanelPage = i;
      this.RealizeFormGrid(false);
    }
    this.PanelPage = oldSel;
  }
  else
    this.RealizeFormGrid(false);
  this.RealizeListTable();
  if (this.ListHeaderScroller)
    this.ListHeadersRow.appendChild(this.ListHeaderScroller);
  //
  for (var i = 0; i < this.Fields.length; i++)
    if (this.Fields[i].SubFrame && !this.Fields[i].SubFrame.Realized)
      this.Fields[i].UpdateSubFrameVisibility();
  //
  this.Realized = true;
  //
  this.SetPanelStatus();
  this.SetPanelMode();
  this.SetNumRows();
  this.SetMaxHRow();
  this.SetHeaderSize();
  this.SetShowRowSelector();
  this.SetEnableMultipleSel();
  this.SetShowMultipleSel();
  this.SetDynamicRows();
  this.SetDynamicHeight();
  this.SetHasScrollbar();
  this.SetHasList();
  this.SetHasForm();
  this.SetCanUpdate();
  this.SetCanDelete();
  this.SetCanInsert();
  this.SetCanSearch();
  this.SetCanSort();
  this.SetListLeft();
  this.SetListTop();
  this.SetListWidth();
  this.SetListHeight();
  this.SetActualRow();
  this.SetVResMode();
  this.SetHResMode();
  this.SetVisualStyle();
  this.SetFixedColumns();
  this.SetQbeTip();
  this.SetTotalRows();
  this.SetPanelPage();
  this.SetLoadingPolicy();
  this.SetHeight();
  //
  this.OldOriginalPanelMode = this.PanelMode;
  //
  // Con questa impostazione spingo l'aggiornamento di entrambi i layout
  this.PanelMode = -1;
  this.SetActualPosition();
  this.AlignHeader = true;
  //
  // Ho fatto io il SetActualPosition, non c'e' bisogno di spingerlo alla fine della richiesta
  this.ResetPosition = false;
  this.PanelMode = this.OldOriginalPanelMode;
  delete this.OldOriginalPanelMode;
  //
  this.Realizing = false;
  //
  this.UpdateToolbar();
  this.SetStatusBarText();
  //
  // impostando this.PanelMode = -1; i calcoli della visibilita' potrebbero essere saltati, quindi adesso li faccio rifare
  this.AdaptLayout();
  //
  this.RecalcLayout = false;
  this.ResetPosition = false;
  //
  if (this.MouseOverEventDef != RD3_Glb.EVENT_CLIENTSIDE)
  {
    var _this = this;
    var movf = function(ev) {
      _this.HandleOnMouseOver(ev);
    };
    //
    if (document.addEventListener)
      this.ContentBox.addEventListener("mouseover", movf, false); 
    else
      this.ContentBox.attachEvent("onmouseover", movf);
  }
}


// ***************************************************************
// Crea gli oggetti DOM relativi alla Toolbar
// ***************************************************************
IDPanel.prototype.RealizeToolbar = function()
{
  // Chiamo la classe base
  WebFrame.prototype.RealizeToolbar.call(this);
  //
  // Creo le zone
  this.TBZones = new Array();
  for (var i=0;i<=10;i++) // MAX TB ZONES
  {
    this.TBZones[i] = document.createElement("div");
    this.TBZones[i].className = "btn-group";
    this.ToolbarBox.appendChild(this.TBZones[i]);
  }
  //
  // La zona ZERO e' invisibile...
  this.TBZones[0].style.display = "none";
  //
  // Il Gruppo standard lo nascondiamo 
  this.ToolbarButtonGroup1.style.display = "none";
  //
  // Sposto i bottoni standard nelle zone
  this.ToolbarButtonGroup1.removeChild(this.CollapseButton);
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_COLLAPSE];
  this.TBZones[i].appendChild(this.CollapseButton);
  //
  this.ToolbarButtonGroup1.removeChild(this.LockButton);
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_LOCK];
  this.TBZones[i].appendChild(this.LockButton);
  //  
  this.ToolbarBox.removeChild(this.IconImg);
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_STATUSBAR];
  this.TBZones[i].appendChild(this.IconImg);
  //  
  this.ToolbarBox.removeChild(this.CaptionTxt);
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_STATUSBAR];
  this.TBZones[i].appendChild(this.CaptionTxt);
  //
  // Creo la Status Bar
  this.StatusBar = document.createElement("span");
  this.StatusBar.setAttribute("id", this.Identifier+":status");
  this.StatusBar.className = "panel-toolbar-status";
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_STATUSBAR];
  this.TBZones[i].appendChild(this.StatusBar);
  //
  // Creo l'immagine per i QBETip e il MessageTooltip
  this.QBETIcon = document.createElement("i");
  this.QBETIcon.setAttribute("id", this.Identifier+":qbetip");
  this.QBETIcon.className = "fa " + RD3_ClientParams.FA_ICON_QBETIP + " panel-qbe-icon";
  //
  this.QBETIcon.setAttribute("data-toggle", "popover");
  this.QBETIcon.setAttribute("data-trigger", RD3_Glb.IsTouch() ? "click" : "hover");
  this.QBETIcon.setAttribute("data-title", ClientMessages.TIP_TITLE_QBETIP);
  this.QBETIcon.setAttribute("data-content", "");
  this.QBETIcon.setAttribute("data-html", "true");
  this.QBETIcon.setAttribute("data-placement", "bottom");
  $(this.QBETIcon).popover({ sanitize: false });
  //
  this.TBZones[i].appendChild(this.QBETIcon);
  //
  // Pulsanti di navigazione
  this.TopButton = document.createElement("button");
  this.TopButton.setAttribute("id", this.Identifier+":top");
  this.TopButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_PANTOP));
  this.TopButton.className = "btn btn-default panel-toolbar-button panel-top-button";
  this.TopButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'top')");
  RD3_TooltipManager.SetObjTitle(this.TopButton, RD3_ServerParams.PanelInizio);
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_NAVIGATE];
  this.TBZones[i].appendChild(this.TopButton);
  //
  this.PrevButton = document.createElement("button");
  this.PrevButton.setAttribute("id", this.Identifier+":prev");
  this.PrevButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_PREV));
  this.PrevButton.className = "btn btn-default panel-toolbar-button panel-prev-button";
  this.PrevButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'prev')");
  RD3_TooltipManager.SetObjTitle(this.PrevButton, RD3_ServerParams.PanelPaginaPrec);
  this.TBZones[i].appendChild(this.PrevButton);
  //
  this.NextButton = document.createElement("button");
  this.NextButton.setAttribute("id", this.Identifier+":next");
  this.NextButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_NEXT));
  this.NextButton.className = "btn btn-default panel-toolbar-button panel-next-button";
  this.NextButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'next')");
  RD3_TooltipManager.SetObjTitle(this.NextButton, RD3_ServerParams.PanelPaginaSucc);
  this.TBZones[i].appendChild(this.NextButton);
  //
  this.BottomButton = document.createElement("button");
  this.BottomButton.setAttribute("id", this.Identifier+":bottom");
  this.BottomButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_PANBOTTOM));
  this.BottomButton.className = "btn btn-default panel-toolbar-button panel-bottom-button";
  this.BottomButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'bottom')");
  RD3_TooltipManager.SetObjTitle(this.BottomButton, RD3_ServerParams.PanelFine);
  this.TBZones[i].appendChild(this.BottomButton);
  //
  // Pulsante di cerca
  this.SearchButton = document.createElement("button");
  this.SearchButton.setAttribute("id", this.Identifier+":search");
  this.SearchButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_SEARCH));
  this.SearchButton.className = "btn btn-default panel-toolbar-button panel-search-button";
  this.SearchButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'search')");
  RD3_TooltipManager.SetObjTitle(this.SearchButton, RD3_ServerParams.TooltipCerca + RD3_KBManager.GetFKTip(RD3_ClientParams.FKEnterQBE));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_SEARCH];
  this.TBZones[i].appendChild(this.SearchButton);
  //
  // Pulsante di trova
  this.FindButton = document.createElement("button");
  this.FindButton.setAttribute("id", this.Identifier+":find");
  this.FindButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_FIND));
  this.FindButton.className = "btn btn-default panel-toolbar-button panel-find-button";
  this.FindButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'find')");
  RD3_TooltipManager.SetObjTitle(this.FindButton, RD3_ServerParams.TooltipTrova + RD3_KBManager.GetFKTip(RD3_ClientParams.FKFindData));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_FIND];
  this.TBZones[i].appendChild(this.FindButton);
  //
  // Pulsante di form/list
  this.FormListButton = document.createElement("button");
  this.FormListButton.setAttribute("id", this.Identifier+":formlist");
  this.FormListButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_LIST));
  this.FormListButton.className = "btn btn-default panel-toolbar-button panel-formlist-button";
  this.FormListButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'list')");
  RD3_TooltipManager.SetObjTitle(this.FormListButton, RD3_ServerParams.TooltipFormList + RD3_KBManager.GetFKTip(RD3_ClientParams.FKFormList));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_FORMLIST];
  this.TBZones[i].appendChild(this.FormListButton);
  //
  // Pulsante di CANCEL
  this.CancelButton = document.createElement("button");
  this.CancelButton.setAttribute("id", this.Identifier+":cancel");
  this.CancelButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_UNDO));
  this.CancelButton.className = "btn btn-default panel-toolbar-button panel-cancel-button";
  this.CancelButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'cancel')");
  RD3_TooltipManager.SetObjTitle(this.CancelButton, RD3_ServerParams.TooltipCancel + RD3_KBManager.GetFKTip(RD3_ClientParams.FKCancel));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_CANCEL];
  this.TBZones[i].appendChild(this.CancelButton);
  //
  // Pulsante di refresh
  this.RefreshButton = document.createElement("button");
  this.RefreshButton.setAttribute("id", this.Identifier+":refresh");
  this.RefreshButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_REFRESH));
  this.RefreshButton.className = "btn btn-default panel-toolbar-button panel-refresh-button";
  this.RefreshButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'refresh')");
  RD3_TooltipManager.SetObjTitle(this.RefreshButton, RD3_ServerParams.TooltipRefresh + RD3_KBManager.GetFKTip(RD3_ClientParams.FKRefresh));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_REQUERY];
  this.TBZones[i].appendChild(this.RefreshButton);
  //
   // Pulsante di cancellazione
  this.DelButton = document.createElement("button");
  this.DelButton.setAttribute("id", this.Identifier+":del");
  this.DelButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_DELETE));
  this.DelButton.className = "btn btn-default panel-toolbar-button panel-delete-button";
  this.DelButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'delete')");  
  RD3_TooltipManager.SetObjTitle(this.DelButton, RD3_ServerParams.TooltipDelete + RD3_KBManager.GetFKTip(RD3_ClientParams.FKDelete));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_DELETE];
  this.TBZones[i].appendChild(this.DelButton);
  //
  // Pulsante di inserimento
  this.NewButton = document.createElement("button");
  this.NewButton.setAttribute("id", this.Identifier+":new");
  this.NewButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_INSERT));
  this.NewButton.className = "btn btn-default panel-toolbar-button panel-insert-button";
  this.NewButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'insert')");
  RD3_TooltipManager.SetObjTitle(this.NewButton, RD3_ServerParams.TooltipInsert + RD3_KBManager.GetFKTip(RD3_ClientParams.FKInsert));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_INSERT];
  this.TBZones[i].appendChild(this.NewButton);
  //
  // Pulsante di duplicazione
  this.DuplButton = document.createElement("button");
  this.DuplButton.setAttribute("id", this.Identifier+":dupl");
  this.DuplButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_DUPLICATE));
  this.DuplButton.className = "btn btn-default panel-toolbar-button panel-duplicate-button";
  this.DuplButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'dupl')");
  RD3_TooltipManager.SetObjTitle(this.DuplButton, RD3_ServerParams.TooltipDuplicate + RD3_KBManager.GetFKTip(RD3_ClientParams.FKDuplicate));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_DUPLICATE];
  this.TBZones[i].appendChild(this.DuplButton);
  //
  // Pulsante di salvataggio
  this.SaveButton = document.createElement("button");
  this.SaveButton.setAttribute("id", this.Identifier+":save");
  this.SaveButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_UPDATE));
  this.SaveButton.className = "btn btn-default panel-toolbar-button panel-save-button";
  this.SaveButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'save')");
  RD3_TooltipManager.SetObjTitle(this.SaveButton, RD3_ServerParams.TooltipUpdate + RD3_KBManager.GetFKTip(RD3_ClientParams.FKUpdate));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_UPDATE];
  this.TBZones[i].appendChild(this.SaveButton);
  //
  this.PrintButton = document.createElement("button");
  this.PrintButton.setAttribute("id", this.Identifier+":print");
  this.PrintButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_PRINT));
  this.PrintButton.className = "btn btn-default panel-toolbar-button panel-print-button";
  this.PrintButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'print')");
  RD3_TooltipManager.SetObjTitle(this.PrintButton, RD3_ServerParams.Print + RD3_KBManager.GetFKTip(RD3_ClientParams.FKPrint));
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_PRINT];
  this.TBZones[i].appendChild(this.PrintButton);
  //
  // Imposto il pulsante di Esportazione
  this.CsvButton = document.createElement("button");
  this.CsvButton.setAttribute("id", this.Identifier+":csv");
  this.CsvButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_EXPORT));
  this.CsvButton.className = "btn btn-default panel-toolbar-button panel-export-button";
  this.CsvButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'csv')");
  RD3_TooltipManager.SetObjTitle(this.CsvButton, RD3_ServerParams.TooltipExport);
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_CSV];
  this.TBZones[i].appendChild(this.CsvButton);
  //
  // Imposto il pulsante di Allegati
  this.AttachButton = document.createElement("button");
  this.AttachButton.setAttribute("id", this.Identifier+":attach");
  this.AttachButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_ATTACH));
  this.AttachButton.className = "btn btn-default panel-toolbar-button panel-attach-button";
  this.AttachButton.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'attach')");
  RD3_TooltipManager.SetObjTitle(this.AttachButton, RD3_ServerParams.ComandoAllegati);
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_ATTACH];
  this.TBZones[i].appendChild(this.AttachButton);
  //
  // Imposto i custom commands
  var a = RD3_DesktopManager.WebEntryPoint.CustomCommands;
  var n = a.length;
  //
  if (n>0) 
    this.CustomButtons = new Array();
  //
  for (var i=0; i<n; i++)
  {
    var cb = document.createElement("button");
    cb.setAttribute("id", this.Identifier+":custom"+i);
    cb.className = "btn btn-default panel-toolbar-button";
    cb.onclick = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnToolbarClick', ev, 'cb"+ i +"')");
    if (a[i].Image) 
    {
      // Se c'e' "fa-" allora usiamo le immagini di tipo stringa, altrimenti usiamo le img. Ci potrebbero essere dei casi in cui l'utente vuole proprio usare le img
      if (a[i].Image.indexOf("fa-") >= 0)
        cb.appendChild(RD3_Glb.createFAImage(a[i].Image));
      else {
        var ccImg = document.createElement("img");
        ccImg.className = "toolbar-image";
        ccImg.src = RD3_Glb.GetImgSrc("images/" + a[i].Image + ".gif");
        cb.appendChild(ccImg);
      }
    }
    RD3_TooltipManager.SetObjTitle(cb, a[i].Tooltip + RD3_KBManager.GetFKTip(a[i].FKNum));
    var ofs = 18+i
    if (i>=8)
      ofs = 37 + i - 8; // I comandi custom da 9 a 16 sono nelle posizioni 37 - 45
    var j = RD3_DesktopManager.WebEntryPoint.CommandZones[ofs];
    this.TBZones[j].appendChild(cb);
    this.CustomButtons[i] = cb;
  }
  //
  // Tolgo le zone vuote
  var n = this.TBZones.length;
  for (var i=0; i<n; i++) {
    if (!this.TBZones[i].hasChildNodes())
      this.ToolbarBox.removeChild(this.TBZones[i]);
  }
}

// ************************************************************************************
// Calcola l'altezza di questo frame tenendo conto della sua visibilita'
// e del suo collassamento
// @realHeight - true se voglio l'altezza attuale, altriment usa l'altezza originaria
// ************************************************************************************
IDPanel.prototype.CalcHeight = function (realHeight) {
  var h = WebFrame.prototype.CalcHeight.call(this, realHeight);
  //
  if (this.WebForm.Modal && !RD3_Glb.IsBZen() && this.HasForm && !this.Collapsed) {
    // Nel caso modale devo tenere conto del padding, infatti se l'utente ha disegnato la videata troppo piccola dato che l'editor non ha il padding che invece 
    // ha bootstrap (15+15) compaiono le scrollbar. Mi interessa solo il dettaglio. Non mi interessa BZen (le modali si comportano diversamente)
    // Per sapere cosa fare ciclo sui campi e vedo se un campo ha il FormTop <= 15 o FormTop+FormHeight > h-15.
    // se una delle due si verifica aggiungo un padding di 30.
    for (var i = 0; i < this.Fields.length; i++) {
      var f = this.Fields[i];
      if (f.InForm && (f.FormTop <= 15 || f.FormTop + f.FormHeight > h - 15)) {
        h += 36;
        break;
      }
    }
  }
  //
  return h;
}

// ********************************************************************************
// Calcola le dimensioni dei div in base alla dimensione del contenuto
// ********************************************************************************
IDPanel.prototype.AdaptLayout = function()
{
  // Chiamo la classe base
  WebFrame.prototype.AdaptLayout.call(this);
  //
  var n = this.Fields.length;
  for (var i = 0; i < n; i++)
  {
    var f = this.Fields[i];
    f.UpdateFieldVisibility();
    f.AdaptLayout();
  }
}

// *******************************************************************************
// Dimensione e dispone le linguette delle pagine del pannello
// *******************************************************************************
IDPanel.prototype.AdaptPagesLayout = function()
{
}

// ********************************************************************************
// Calcola le dimensioni dei div che contengono il pannello in lista o in form
// in base al contenuto
// ********************************************************************************
IDPanel.prototype.AdaptFormListLayout = function()
{
}

// ********************************************************************************
// Calcola le dimensioni dei div in base alla dimensione del contenuto (LIST)
// ********************************************************************************
IDPanel.prototype.CalcListLayout = function(flDontCheckSB)
{
}

// ********************************************************************************
// Calcola le dimensioni dei gruppi in base alla dimensione del loro contenuto
// ********************************************************************************
IDPanel.prototype.CalcGroupsLayout= function()
{
}


// ********************************************************************************
// Ritorna il primo campo in lista
// ********************************************************************************
IDPanel.prototype.GetFirstListField= function()
{
  var n = this.Fields.length;
  for (var i=0; i<n; i++)
  {
    var f = this.Fields[i];
    //
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_LIST)
      f = this.ListTabOrder[i];
    //
    if (f.IsVisible() && f.InList && f.ListList)
      return f;
  }  
  //
  return null;
}


// ********************************************************************************
// Evento di scrolling della lista del pannello
// ********************************************************************************
IDPanel.prototype.OnScroll = function(ev)
{ 
  // In questo caso mi interessa sapere quando sono arrivato in fondo alla lista
  var isBottom = this.ListBodyBox.scrollTop + this.ListBodyBox.offsetHeight >=  this.ListBodyBox.scrollHeight - 10;
  if (isBottom) {
    this.OnMoreButton();
  }
  //
  if (this.ListBodyBox.scrollLeft != this.ListCaptionBox.scrollLeft)
    this.ListCaptionBox.scrollLeft = this.ListBodyBox.scrollLeft;
}


// ********************************************************************************
// Gestisce scrollbar clonata in IE
// ********************************************************************************
IDPanel.prototype.OnScrollMouseEnter = function(ev)
{
}


// ********************************************************************************
// Gestisce scrollbar clonata in IE
// ********************************************************************************
IDPanel.prototype.OnScrollMouseLeave = function(ev)
{
}


// ********************************************************************************
// Evento di scrolling della lista del pannello
// ********************************************************************************
IDPanel.prototype.OnMouseWheel = function(ev)
{ 
  // Se c'e' una cella aperta allo scroll con la rotella del mouse sulla lista la faccio scomparire 
  // (solo se e' del mio pannello..) 
  if (RD3_DDManager.OpenListFormCell) {
    // Faccio il blur, poi per sicurezza chiamo anche l'onChange in modo da mandare il messaggio al server e l'UpdaeScreen in modo da aggiornare la cella in lista
    // che sta sotto la cella in FormList
    var parentContainer = RD3_DDManager.OpenListFormCell.GetDOMObj().parentNode;
    var tgtObj = parentContainer;
    var isChild = false;
    while (tgtObj.parentNode) {
      if (tgtObj == this.ListBox) {
        isChild = true;
        break;
      }
      tgtObj = tgtObj.parentNode;
    }
    //
    if (isChild) {
      var openCell = RD3_DDManager.OpenListFormCell;
      if (openCell.GetDOMObj().blur)
        openCell.GetDOMObj().blur();
      RD3_KBManager.IDRO_OnChange(openCell.GetDOMObj(), true);
      openCell.PValue.UpdateScreen();
      if (openCell.ControlType == 3 && openCell.IntCtrl && openCell.IntCtrl.IsOpen) 
        openCell.IntCtrl.Close(true);
      delete RD3_DDManager.OpenListFormCell;
      RD3_KBManager.ActiveElement = null;
      //
      window.setTimeout(function () {
        if (parentContainer && parentContainer.parentNode)
          parentContainer.parentNode.removeChild(parentContainer);
      }, 0);
    }
  }
}


// ********************************************************************************
// Gestisco lo scrolling (da scrollbar o tasti) verso una specifica posizione di
// pannello
// ********************************************************************************
IDPanel.prototype.ScrollTo = function(n, evento, delayms)
{
}


// ********************************************************************************
// Gestisco lo scrolling (da scrollbar o tasti) verso una specifica posizione di
// pannello
// ********************************************************************************
IDPanel.prototype.DelayScroll = function(evento, n)
{
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
IDPanel.prototype.Unrealize = function()
{ 
  // Se ci sono aggiornamenti in background, li fermo... e' inutile proseguire
  this.DelayedListUpdate = false;
  //
  // Chiamo la classe base
  WebFrame.prototype.Unrealize.call(this);
  //
  // Se ho il clone della scrollbar devo togliere anche lui dal DOM
  if (this.ScrollClone)
    document.body.removeChild(this.ScrollClone);
  //
  // Passo il messaggio anche ai campi che cosi' possono gestire i subframes
  var n = this.Fields.length;
  for (var i=0; i<n; i++)
  {
    this.Fields[i].Unrealize();
  }
  //
  // Devo togliere anche i gruppi e le pagine
  var n = this.Groups.length;
  for (var i=0; i<n; i++)
  {
    this.Groups[i].Unrealize();
  }
  var n = this.Pages.length;
  for (var i=0; i<n; i++)
  {
    this.Pages[i].Unrealize();
  }
  //
  if (this.QBETipBox)
    this.QBETipBox.Unrealize();
  //
  if (this.MultiSelCommand)
  {
    RD3_DesktopManager.WebEntryPoint.CmdObj.ClientCommands.remove(this.Identifier+":cms:0");
    this.MultiSelCommand.Unrealize();
    this.MultiSelCommand = null;
  }
  //
  this.Realized = false;
}


IDPanel.prototype.SetSmallIcon= function(value) 
{
}

IDPanel.prototype.SetShowToolbar= function(value) 
{
  // Chiamo la classe base
  WebFrame.prototype.SetShowToolbar.call(this, value);
  //
  if (this.Realized)
    this.UpdateToolbar();
}

IDPanel.prototype.SetShowStatusBar= function(value) 
{
  // Chiamo la classe base
  WebFrame.prototype.SetShowStatusBar.call(this, value);
  //
  if (this.Realized)
  {
    this.StatusBar.style.display = ((this.ShowStatusBar && !this.Collapsed) ? "" : "none");
    this.QBETIcon.style.visibility = ((this.ShowStatusBar && !this.Collapsed) ? "" : "hidden");
    //
    // Aggiusto il testo della caption, se finisce per ":"
    var s = this.CaptionTxt.innerHTML;
    var s1 = s.substr(s.length-1,1);
    if (this.ShowStatusBar && !this.Collapsed)
    {
      // Se la caption non finisce per : e non e' stringa vuota allora aggiungo i :
      if (s1!=":" && s!="")
        this.CaptionTxt.innerHTML = s+":";
    }
    else
    {
      if (s1==":")
        this.CaptionTxt.innerHTML = s.substr(0,s.length-1);
    }
    
  }
}

IDPanel.prototype.SetLocked= function(value) 
{
  var old = this.Locked;
  //
  // Chiamo la classe base
  WebFrame.prototype.SetLocked.call(this, value);
  //
  if (this.Realized && (value==undefined || old!=this.Locked))
  {
    this.ResetPosition = true;
    this.RefreshToolbar = true;
  }
}


IDPanel.prototype.SetCollapsible= function(value) 
{
  if (value!=undefined)
    this.Collapsible = value;
  //  
  if (this.Realized)
  {
    // Se e' contenuto in una tabbed, non e' collassabile
    var cancoll = this.Collapsible;
    if (this.ParentFrame && this.ParentFrame instanceof TabbedView)
      cancoll = false;
    //
    var i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_COLLAPSE];
    if (cancoll)
      this.TBZones[i].appendChild(this.CollapseButton);
    else if (this.CollapseButton.parentNode)
      this.CollapseButton.parentNode.removeChild(this.CollapseButton);
  }
}

IDPanel.prototype.SetLockable= function(value) 
{
  if (value!=undefined)
    this.Lockable = value;
  //
  if (this.Realized && this.LockButton) {
    var i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_LOCK];
    if (this.Lockable && !this.Collapsed)
      this.TBZones[i].appendChild(this.LockButton);
    else if (this.LockButton.parentNode)
      this.LockButton.parentNode.removeChild(this.LockButton);
  }
}


// ********************************************************************************
// Collassamento del pannello... a differenza di cio' che fanno i frames normali
// io mi devo occupare anche dei miei sub-frames... dato che il server fa cosi'...
// ********************************************************************************
IDPanel.prototype.SetCollapsed= function(value, immediate) 
{
  WebFrame.prototype.SetCollapsed.call(this, value, immediate);
  //
  if (this.Realized) 
  {
    // All'espansione verifichiamo di allineare gli header della lista
    if (!this.Collpased)
      this.AlignHeader = true;
    //
    this.RefreshToolbar = true;
    RD3_DesktopManager.WebEntryPoint.RefreshCommands = true;
  }
}


// ********************************************************************************
// Gestore evento di click su un pulsante della Toolbar
// ********************************************************************************
IDPanel.prototype.OnToolbarClick= function(evento, button)
{
  var ok = true;
  var ev = null;
  //
  if (button == "delete" && this.ConfirmDelete)
  {
    this.DoHighlightDelete(true);
    //
    // Decido quale messaggio mostrare
    var count = 1;
    var msg = "";
    if (!this.ShowMultipleSel || this.PanelMode==RD3_Glb.PANEL_FORM)
      msg = RD3_Glb.FormatMessage(ClientMessages.PAN_MSG_ConfirmDeleteRS, this.Caption);
    else
    {
      count = 0;
      for (var i=1; i<=this.TotalRows; i++)
      {
        if (this.MultiSelStatus[i])
          count++;
      }
      //
      if (count == 0)
        msg = RD3_Glb.FormatMessage(ClientMessages.PAN_MSG_ConfirmDeleteNR, this.Caption);
      else if (count == 1)
        msg = RD3_Glb.FormatMessage(ClientMessages.PAN_MSG_ConfirmDeleteRS, this.Caption);
      else if (count < this.TotalRows)
        msg = RD3_Glb.FormatMessage(ClientMessages.PAN_MSG_ConfirmDeleteRR, this.Caption, count);
      else
        msg = RD3_Glb.FormatMessage(ClientMessages.PAN_MSG_ConfirmDeleteAR, this.Caption);
    }
    // Chiedo conferma per la cancellazione
    this.MsgBox = new MessageBox(msg, count > 0 ? RD3_Glb.MSG_CONFIRM : RD3_Glb.MSG_BOX, false);
    if (count > 0) {
      this.MsgBox.CallBackFunction = function (ev) {
        this.OnDeleteConfirm(ev, "delete");
      }.bind(this);
    }
    this.MsgBox.Open();
    ok = false;
  }
  //
  // Se sto duplicando o esportando con la multiselezione attiva verifico che ci sia almeno una riga selezionata,
  // altrimenti chiedo conferma all'utente
  if (button == "csv" && this.ShowMultipleSel)
  {
    var count = 0;
    for (var i=1; i<=this.TotalRows; i++)
    {
      if (this.MultiSelStatus[i])
        count++;
    }
    //
    if (count == 0)
    {
      var msg = button == "dupl" ? ClientMessages.PAN_MSG_ConfirmDuplicateNR : ClientMessages.PAN_MSG_ConfirmExportNR;
      msg = RD3_Glb.FormatMessage(msg, this.Caption);
      //
      // Chiedo conferma per l'operazione
      this.MsgBox = new MessageBox(msg, RD3_Glb.MSG_CONFIRM, false);
      this.MsgBox.CallBackFunction = function (ev) {
        this.OnDeleteConfirm(ev, button);
      }.bind(this);
      this.MsgBox.Open();
      ok = false;
    }
  }
  //
  if (ok)
  {
    // Vediamo se questo comando e' bloccante
    var blk = 0;
    switch (button)
    {
      case "list" : blk = (this.BlockingCommands & RD3_Glb.PCM_FORMLIST); break;
      case "search" : blk = (this.BlockingCommands & RD3_Glb.PCM_SEARCH); break;
      case "find" : blk = (this.BlockingCommands & RD3_Glb.PCM_FIND); break;
      case "insert" : blk = (this.BlockingCommands & RD3_Glb.PCM_INSERT); break;
      case "delete" : blk = (this.BlockingCommands & RD3_Glb.PCM_DELETE); break;
      case "cancel" : blk = (this.BlockingCommands & RD3_Glb.PCM_CANCEL); break;
      case "refresh" : blk = (this.BlockingCommands & RD3_Glb.PCM_REQUERY); break;
      case "save" : blk = (this.BlockingCommands & RD3_Glb.PCM_UPDATE); break;
      case "dupl" : blk = (this.BlockingCommands & RD3_Glb.PCM_DUPLICATE); break;
      case "print" : blk = (this.BlockingCommands & RD3_Glb.PCM_PRINT); break;
      case "attach" : blk = (this.BlockingCommands & RD3_Glb.PCM_ATTACH); break;
      case "group" : blk = (this.BlockingCommands & RD3_Glb.PCM_ATTACH); break;
      case "csv" : blk = (this.BlockingCommands & RD3_Glb.PCM_CSV); break;
      case "cb0" : blk = (this.BlockingCommands & RD3_Glb.PCM_CUSTOM1); break;
      case "cb1" : blk = (this.BlockingCommands & RD3_Glb.PCM_CUSTOM2); break;
      case "cb2" : blk = (this.BlockingCommands & RD3_Glb.PCM_CUSTOM3); break;
      case "cb3" : blk = (this.BlockingCommands & RD3_Glb.PCM_CUSTOM4); break;
      case "cb4" : blk = (this.BlockingCommands & RD3_Glb.PCM_CUSTOM5); break;
      case "cb5" : blk = (this.BlockingCommands & RD3_Glb.PCM_CUSTOM6); break;
      case "cb6" : blk = (this.BlockingCommands & RD3_Glb.PCM_CUSTOM7); break;
      case "cb7" : blk = (this.BlockingCommands & RD3_Glb.PCM_CUSTOM8); break;
      
      case "top": 
      case "prev": 
      case "next": 
      case "bottom": 
        blk = (this.BlockingCommands & RD3_Glb.PCM_NAVIGATION);
        break;
    }
    //    
    ev = new IDEvent("pantb", this.Identifier, evento, this.ToolbarEventDef|(blk ? RD3_Glb.EVENT_BLOCKING : 0), button);
  }
  //
  if (ok && ev.ClientSide && !blk)
  {
    switch (button)
    {
      case "lock" :   this.SetLocked(true); break;
      case "unlock" : this.SetLocked(false); break;
      case "insert" : if (this.Locked) this.SetLocked(false); break;
      
      case "list"   :
        RD3_DesktopManager.SendEvents(); 
      break;
      
      case "top"    : 
        this.ChangeActualRow(0, null); 
        this.SetActualPosition(1, false, false); 
        this.UpdateScrollPos();
        RD3_KBManager.CheckFocus = false;
      break;
      
      case "bottom" : 
        this.ChangeActualRow(this.NumRows-1, null); 
        this.SetActualPosition(this.TotalRows-this.NumRows+1, false, false); 
        this.UpdateScrollPos();
        RD3_KBManager.CheckFocus = false;
      break;
      
      case "next"   :
      {
        var n = (this.PanelMode==RD3_Glb.PANEL_LIST)? this.NumRows : 1;
        var nr = this.ActualPosition + n - 1;
        if (nr > this.TotalRows-n+1)
          nr = this.TotalRows-n+1;
        this.SetActualPosition(nr, false, true); 
        this.UpdateScrollPos();
      }
      break;
      
      case "prev"   :
      {
        var n = (this.PanelMode==RD3_Glb.PANEL_LIST)? this.NumRows : 1;
        var nr = this.ActualPosition - n + 1;
        if (nr < 1)
          nr = 1;
        this.SetActualPosition(nr, false, true); 
        this.UpdateScrollPos();
      }
      break;
    }
  }
}


// ********************************************************************************
// Gestore evento di click su un pulsante per la gestione della multiselezione
// ********************************************************************************
IDPanel.prototype.OnMultiSelCmd= function(evento, button)
{ 
  var ev = new IDEvent("pantb", this.Identifier, evento, this.ToolbarEventDef, button);
  if (ev.ClientSide)
  {
    switch (button)
    {
      case "seltog":
        this.SetShowMultipleSel(!this.ShowMultipleSel); 
      break;
      
      case "selall":
        this.ChangeSelection(2, false); // 0 = NONE, 1 = INVERT, 2 = ALL
        this.UpdateMultipleSel();
      break;

      case "selnone":
        this.ChangeSelection(0, false); // 0 = NONE, 1 = INVERT, 2 = ALL
        this.UpdateMultipleSel();
      break;
    }
  }
  //
  // nascondo i controlli della multiselezione
  if (this.MultiSelDropdownList)
    this.MultiSelDropdownList.style.display = "";
  if (this.MultiSelBackDrop)
    this.MultiSelBackDrop.style.display = "none";
}


// **************************************************************
// Imposta il testo della Status Bar
// **************************************************************
IDPanel.prototype.SetStatusBarText = function()
{
  if (this.Realizing)
    return;
  //
  var st = "";
  var cn = "panel-toolbar-status";
  var ist = (this.DOModified && this.DOMaster)? RD3_Glb.PS_UPDATED :  this.Status;
  //
  switch(ist)
  {
    case RD3_Glb.PS_QBE:
      st = RD3_ServerParams.SBP_QBE;
      cn = "panel-status-qbe";
    break;
    
    case RD3_Glb.PS_DATA:
    {
      if (this.IsNewRow(this.ActualPosition, this.ActualRow))
      {
        if (this.CanInsert)
          st = RD3_ServerParams.SBP_INSERT;
        else
          st = RD3_ServerParams.SBP_DATA1.replace("|1", this.ActualPosition + this.ActualRow);
      }
      else
      {
        if (!this.ShowMultipleSel || this.PanelMode==RD3_Glb.PANEL_FORM)
        {
          st = RD3_ServerParams.RigaNM;
          st = st.replace("|1", (this.ActualPosition + this.ActualRow));
          st = st.replace("|2", this.TotalRows);
        } 
        else
        {
          var count = 0;
          if (this.MultiSelStatus) {
            for (var i=1; i<=this.TotalRows; i++) {
              if (this.MultiSelStatus[i])
                count++;
            }
          }
          //
          if (count == 1)
            st = RD3_Glb.FormatMessage(ClientMessages.PAN_STBAR_SelRow, this.TotalRows);
          else
            st = RD3_Glb.FormatMessage(ClientMessages.PAN_STBAR_SelRows, this.TotalRows, count);
        }
        //
        // Se ci sono piu' righe
        if (this.MoreRows)
          st += "+";
      }
      cn = "panel-status-data";
    }
    break;
    
    case RD3_Glb.PS_UPDATED:
      st = RD3_ServerParams.SBP_UPD;
      cn = "panel-status-updated";
    break;
  }
  //
  // Se non lavoro SingleDoc aggiorno la statusbar
  // altrimenti la svuoto (cosi' compare solo il nome del documento e non "Riga 1 di 1")
  if (!this.DOSingleDoc)
  {
    this.StatusBar.className = cn;
    this.StatusBar.innerHTML = "&nbsp;"+st;
    //
    // Se il testo della caption non finisce per ":" lo aggiungo (solo se la caption non e' stringa vuota e non siamo collassati e la status bar non e' nascosta)
    var s = this.CaptionTxt.innerHTML;
    if (s!= "" && s.substr(s.length-1,1) != ":" && !this.Collapsed && this.ShowStatusBar)
      this.CaptionTxt.innerHTML += ":";
  }
  else
  {
    this.StatusBar.className = "";
    this.StatusBar.innerHTML = "";
    //
    // Se il testo della caption finisce per ":" lo tolgo
    var s = this.CaptionTxt.innerHTML;
    if (s.substr(s.length-1,1) == ":")
      this.CaptionTxt.innerHTML = s.substr(0, s.length-1);
  }
}


// *********************************************************************************
// Gestisce la visualizzazione o meno dei pulsanti della Toolbar
// *********************************************************************************
IDPanel.prototype.UpdateToolbar = function()
{
  // Lo devo fare dopo...
  if (this.AnimatingToolbar)
    return;
  //
  // Il numero di righe visualizzate del pannello e' 1 se sono in form, numrows se sono in list
  var nr = (this.PanelMode==RD3_Glb.PANEL_LIST)?this.NumRows:1;
  //
  // Posso navigare se il pannello e' in stato data e se ci sono abbastanza righe
  var cannav = this.CanNavigate();
  //
  var newrow = this.IsNewRow(this.ActualPosition, this.ActualRow);
  var mob = RD3_Glb.IsMobile();
  //
  // verifico se c'e' una combo aperta
  var comboopen = (RD3_DDManager.OpenCombo && RD3_DDManager.OpenCombo.Owner.ParentField.ParentPanel==this);
  //
  // Mostro i comandi di navigazione solo in dettaglio e non in lista
  var cannav2 = cannav && this.IsCommandEnabled(RD3_Glb.PCM_NAVIGATION) && (this.GetTotalRows()>nr || this.ActualPosition>1) && this.PanelMode!== RD3_Glb.PANEL_LIST;
  //
  this.TopButton.style.display = cannav2 ? "" : "none";
  this.PrevButton.style.display = cannav2 ? "" : "none";
  this.NextButton.style.display = cannav2 ? "" : "none";
  this.BottomButton.style.display = cannav2 ? "" : "none";
  var ix = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_NAVIGATE];
  if (cannav2)
    RD3_Glb.RemoveClass(this.TBZones[ix], "hidden-toolbar-group");
  else
    RD3_Glb.AddClass(this.TBZones[ix], "hidden-toolbar-group");
  //
  var canqbet = this.Status==RD3_Glb.PS_DATA && this.QBETip.length>0 && this.ShowStatusBar && !this.Collapsed;
  this.QBETIcon.style.display = canqbet ? "" : "none";
  //
  // Usando i button-group la grafica viene male se gli oggetti vengono nascosti, non devono proprio essere nel DOM.
  // Quindi invece di nasconderli devo staccarli tutti dai loro padri e poi rimettere nel posto giusto solo quelli visibili
  if (this.SearchButton.parentNode) {
    if ($(this.SearchButton).tooltip)
      $(this.SearchButton).tooltip('hide');
    this.SearchButton.parentNode.removeChild(this.SearchButton);
  }
  if (this.FindButton.parentNode) {
    if ($(this.FindButton).tooltip)
      $(this.FindButton).tooltip('hide');
    this.FindButton.parentNode.removeChild(this.FindButton);
  }
  if (this.FormListButton.parentNode) {
    if ($(this.FormListButton).tooltip)
      $(this.FormListButton).tooltip('hide');
    this.FormListButton.parentNode.removeChild(this.FormListButton);
  }
  if (this.CancelButton.parentNode) {
    if ($(this.CancelButton).tooltip)
      $(this.CancelButton).tooltip('hide');
    this.CancelButton.parentNode.removeChild(this.CancelButton);
  }
  if (this.RefreshButton.parentNode){
    if ($(this.RefreshButton).tooltip)
      $(this.RefreshButton).tooltip('hide');
    this.RefreshButton.parentNode.removeChild(this.RefreshButton);
  }
  if (this.DelButton.parentNode) {
    if ($(this.DelButton).tooltip)
      $(this.DelButton).tooltip('hide');
    this.DelButton.parentNode.removeChild(this.DelButton);
  }
  if (this.NewButton.parentNode) {
    if ($(this.NewButton).tooltip)
      $(this.NewButton).tooltip('hide');
    this.NewButton.parentNode.removeChild(this.NewButton);
  }
  if (this.DuplButton.parentNode) {
    if ($(this.DuplButton).tooltip)
      $(this.DuplButton).tooltip('hide');
    this.DuplButton.parentNode.removeChild(this.DuplButton);
  }
  if (this.SaveButton.parentNode) {
    if ($(this.SaveButton).tooltip)
      $(this.SaveButton).tooltip('hide');
    this.SaveButton.parentNode.removeChild(this.SaveButton);
  }
  if (this.PrintButton.parentNode) {
    if ($(this.PrintButton).tooltip)
      $(this.PrintButton).tooltip('hide');
    this.PrintButton.parentNode.removeChild(this.PrintButton);
  }
  if (this.CsvButton.parentNode) {
    if ($(this.CsvButton).tooltip)
      $(this.CsvButton).tooltip('hide');
    this.CsvButton.parentNode.removeChild(this.CsvButton);
  }
  if (this.AttachButton.parentNode) {
    if ($(this.AttachButton).tooltip)
      $(this.AttachButton).tooltip('hide');
    this.AttachButton.parentNode.removeChild(this.AttachButton);
  }
  //
  var i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_SEARCH];
  var cansrc = this.IsCommandEnabled(RD3_Glb.PCM_SEARCH) && cannav && this.CanSearch && this.UseListQBE == RD3_Glb.PAN_NOQBELIST;
  if (cansrc)
    this.TBZones[i].appendChild(this.SearchButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_FIND];
  var canfnd = this.IsCommandEnabled(RD3_Glb.PCM_FIND) && this.Status==RD3_Glb.PS_QBE && this.CanSearch;
  if (canfnd)
    this.TBZones[i].appendChild(this.FindButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_FORMLIST];
  var canchg = this.IsCommandEnabled(RD3_Glb.PCM_FORMLIST) && (this.Status != RD3_Glb.PS_QBE || !this.AutomaticLayout) && (this.Status == RD3_Glb.PS_QBE || cannav) && this.HasList && this.HasForm;
  if (canchg)
    this.TBZones[i].appendChild(this.FormListButton);
  RD3_Glb.updateFAImage(this.FormListButton, this.PanelMode == RD3_Glb.PANEL_LIST ? RD3_ClientParams.FA_ICON_FORM : RD3_ClientParams.FA_ICON_LIST);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_CANCEL];
  var cancan = this.IsCommandEnabled(RD3_Glb.PCM_CANCEL) && ((this.Status==RD3_Glb.PS_UPDATED || (mob && !this.Locked && this.Lockable)) && (this.CanUpdate || this.CanInsert) || this.Status == RD3_Glb.PS_QBE || this.DOModified);  
  if (cancan)
    this.TBZones[i].appendChild(this.CancelButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_REQUERY];
  var canref = this.IsCommandEnabled(RD3_Glb.PCM_REQUERY) && this.Status!=RD3_Glb.PS_QBE && (!this.IsDO || this.HasDocTemplate);
  if (canref)
    this.TBZones[i].appendChild(this.RefreshButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_DELETE];
  var candel = this.IsCommandEnabled(RD3_Glb.PCM_DELETE) && (!this.Locked || mob) && this.Status==RD3_Glb.PS_DATA && this.CanDelete;
  if (candel)
    this.TBZones[i].appendChild(this.DelButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_INSERT];
  var canins = this.IsCommandEnabled(RD3_Glb.PCM_INSERT) && (!this.Locked || this.EnableInsertWhenLocked || (this.IsDO && this.DOSingleDoc && newrow)) && (this.Status == RD3_Glb.PS_QBE || cannav) && this.CanInsert && this.HasForm;
  if (canins)
    this.TBZones[i].appendChild(this.NewButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_DUPLICATE];
  var candup = this.IsCommandEnabled(RD3_Glb.PCM_DUPLICATE) && !this.Locked && cannav && this.CanInsert && !newrow && this.PanelMode == RD3_Glb.PANEL_FORM;
  if (candup)
    this.TBZones[i].appendChild(this.DuplButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_UPDATE];
  var canupd = this.IsCommandEnabled(RD3_Glb.PCM_UPDATE) && !this.Locked && this.Status!=RD3_Glb.PS_QBE && (this.CanInsert || this.CanUpdate || (this.DOModified && this.DOCanSave));
  if (canupd)
    this.TBZones[i].appendChild(this.SaveButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_PRINT];
  var canprn = this.IsCommandEnabled(RD3_Glb.PCM_PRINT) && cannav && this.HasBook;
  if (canprn)
    this.TBZones[i].appendChild(this.PrintButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_CSV];
  var canexp = this.IsCommandEnabled(RD3_Glb.PCM_CSV) && cannav && this.PanelMode==RD3_Glb.PANEL_LIST;
  if (canexp)
    this.TBZones[i].appendChild(this.CsvButton);
  //
  i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_ATTACH];
  var canattach = this.IsCommandEnabled(RD3_Glb.PCM_ATTACH);
  if (canattach)
    this.TBZones[i].appendChild(this.AttachButton);
  //
  // Mostro o nascondo i custom commands
  if (this.CustomButtons)
  {
    var a = 262144; // CUSTOM1
    var n = this.CustomButtons.length;
    for (var i=0; i<n; i++)
    {
      // Custom 9 deve ricominciare da 0 (perche' cambia intero) ed essere <0 (in modo da poter decidere di andare sui nuovi flag)
      if (i == 8)
       a = -0x1;
      //
      this.CustomButtons[i].style.display=(this.IsCommandEnabled(a))?"":"none";
      a *= 2;
    }
  }
  //
  // Se la Toolbar e' nascosta devo nascondere anche le zone, altrimenti rimangono i padding che spingono eventuali toolbar di pannello
  // Parto da 3 perche' le zone 0,1,2 devono rimanere visibili..
  var n = this.TBZones.length;
  for (var i=3; i<n; i++) {
    // La zona che contiene i command set personalizati deve sempre essere visibile; se e' vuota non e' nel DOM quindi non da fastidio;
    // se ci sono rimane sempre visibile. Se li vuoi nascondere devi nascondere i comandi o la toolbar.
    if (i != RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_CMDSET])
      this.TBZones[i].style.display = (this.ShowToolbar) ? "" : "none";
  }
  //
  // Passo il messaggio ai campi
  var n = this.Fields.length;
  for (var i=0; i<n; i++)
    this.Fields[i].UpdateToolbar();
  //
  // Certifico che l'ho gia' fatto
  this.RefreshToolbar = false;
}


// ****************************************************************
// Torna TRUE se il comando e' abilitato
// ****************************************************************
IDPanel.prototype.IsCommandEnabled = function(cmd)
{
  // (Se e' un comando riguardante i blob showtoolbar non conta)
  if (cmd > 0)
    return (this.EnabledCommands & cmd) && (this.ShowToolbar || cmd==RD3_Glb.PCM_BLOBEDIT || cmd==RD3_Glb.PCM_BLOBDELETE || cmd==RD3_Glb.PCM_BLOBNEW || cmd==RD3_Glb.PCM_BLOBSAVEAS) && !this.Collapsed;
  else
    return (this.ExtEnabledCommands & Math.abs(cmd)) && this.ShowToolbar && !this.Collapsed;
}


// *********************************************************************************
// Metodo chiamato da un gruppo quando la sua visibilita' cambia
// *********************************************************************************
IDPanel.prototype.UpdateGroupVisibility = function(group)
{
  if (this.Realizing || !this.Realized)
    return;
  //
  if (RD3_ClientParams.updateGridAtGroupChange)
    this.UpdateFormGrid();
  //
  // Mando il messaggio a tutti i campi di questo gruppo
  var n = this.Fields.length;
  for (var i=0; i<n; i++)
  {
    if (this.Fields[i].Group == group && group.IsVisible()) {
      this.Fields[i].UpdateFieldVisibility();
      this.Fields[i].SetActualPosition(this.ActualPosition, undefined, undefined, scroll);
    }
  }
}


// *********************************************************************************
// Metodo chiamato da un gruppo quando la sua abilitazione cambia
// *********************************************************************************
IDPanel.prototype.UpdateGroupEnability = function(group)
{
}


// *********************************************************************************
// Metodo chiamato da una pagina quando la sua abilitazione cambia
// *********************************************************************************
IDPanel.prototype.UpdatePageEnability = function(page)
{
  if (this.Realized)
  {
    // Mando il messaggio a tutti i campi di questo gruppo
    var n = this.Fields.length;
    for (var i=0; i<n; i++) {
      if (this.Fields[i].Page == page) 
        this.Fields[i].SetEnabled();
    }
  }
}


// ********************************************************************************
// Restituisce la larghezza del row selector
// ********************************************************************************
IDPanel.prototype.RowSelWidth = function()
{
  var rsw = RD3_ClientParams.RowSelWidth;
  return (this.ShowRowSelector? rsw : 0);
}

// ********************************************************************************
// Restituisce l'altezza complessiva delle righe, compreso il gap
// ********************************************************************************
IDPanel.prototype.GetRowHeight = function()
{
  return this.MaxHRow + this.VisStyle.GetRowOffset();
}


// ********************************************************************************
// Evento di click sul rowsel del pannello
// ********************************************************************************
IDPanel.prototype.OnRowSelectorClick = function(evento, nrow)
{ 
  var row = undefined;
  //
  // Passato da pvalue?
  if (nrow!=undefined)
    row = nrow;
  else {
    var eve = (window.event)?window.event:evento;
    var obj = (window.event)?window.event.srcElement:evento.target;
    if (!obj.id && obj.parentNode && obj.parentNode.id)
      obj = obj.parentNode;
    var p = obj.id.indexOf(":rs");
    row = parseInt(obj.id.substring(p+3));
  }    
  //
  var ev = new IDEvent("panrs", this.Identifier, eve, this.RowSelectEventDef, row, 0);
  if (ev.ClientSide)
    this.ChangeActualRow(row);
  return true;
}


// ********************************************************************************
// Evento di click sul rowsel del pannello
// ********************************************************************************
IDPanel.prototype.OnMultiSelClick = function(evento, nrow)
{ 
  var eve = (window.event)?window.event:evento;
  var obj = (window.event)?window.event.srcElement:evento.target;
  var p = obj.id.indexOf(":rscheck");
  var row = parseInt(obj.id.substring(p+8));
  //
  // Passato da pvalue?
  if (nrow!=undefined)
    row = nrow;
  //
  if (this.ShowMultipleSel) {
    var selr = row;
    //
    var ch = obj.checked;
    var ev = new IDEvent("panms", this.Identifier, eve, this.MultiSelEventDef, selr, ch ? "-1" : "0");
    if (ev.ClientSide) {
      this.MultiSelStatus[this.ActualPosition+row] = ch;
      this.SetStatusBarText();
    }
  }  
  return true;
}


// ********************************************************************************
// Devo gestire le variazioni avvenute
// ********************************************************************************
IDPanel.prototype.AfterProcessResponse= function()
{ 
  // Chiamo la classe base che esegue un recalc layout se richiesto
  WebFrame.prototype.AfterProcessResponse.call(this);
  //
  // Gestisco ulteriori aggiustamenti
  if (this.AlignHeader) {
    this.AlignListHeader();
    this.AlignHeader = false;
  }
  if (this.ResetPosition) {
    this.SetActualPosition(undefined, undefined, this.ScrollToPos && !this.DenyScroll);
    this.ResetPosition = false;
    this.ScrollToPos = false;
  }
  //
  if (this.QbeScroll) {
    this.QbeScroll = false;
    this.UpdateScrollPos();
  }
  //
  if (this.RefreshToolbar)
    this.UpdateToolbar();
  //
  if (this.UpdateRSel)
  {
    this.UpdateRSel = false;
    this.UpdateRowSel();
  }
  //
  if (this.AdaptFieldsSortImage)
  {
    // Una o piu' immagini di SORT sono cambiate. Le riposiziono
    this.AdaptFieldsSortImage = false;
    //
    var n = this.Fields.length;
    for (var i=0; i<n; i++)
    {
      var f = this.Fields[i];
      f.AdaptSortImage();
    }
  }
  //
  this.OldAttR = this.ActualRow;
  //
  // Invio il messaggio di fine richiesta ai campi
  var n = this.Fields.length;
  for (var i=0; i<n; i++)
  {
    this.Fields[i].AfterProcessResponse();
  }
  //
  //  Ripristino il margin top della scrollarea se avevo usato il pull to refresh
  if (this.OrgMarginTop!=undefined)
  {
    var x = this.IDScroll.PullTrigger;
    this.IDScroll.PullTrigger = 0;
    this.IDScroll.MarginTop = 0;
    this.IDScroll.ChangeSize(true);
    //
    this.IDScroll.PullTrigger = x;
    this.IDScroll.MarginTop = this.OrgMarginTop;
    this.OrgMarginTop = undefined;
  }
}


// ********************************************************************************
// Gestore evento di click sul pulsante Lock della Toolbar
// ********************************************************************************
IDPanel.prototype.OnLockClick= function(evento)
{ 
  // Chiamo il corrispondente pulsante della toolbar
  this.OnToolbarClick(evento, this.Locked ? "unlock" : "lock");
}


// ********************************************************************************
// Bisogna dare il fuoco al pannello
// ********************************************************************************
IDPanel.prototype.Focus= function(gotop)
{ 
  /*
  // Pannello invisibile o collassato... niente da fare
  if (this.Collapsed || !this.Visible)
    return false;
  //
  // Se sono in una tabbed, controllo che io sia visibile
  if (this.ParentTab && this.ParentFrame && this.ParentFrame.GetSelectedFrame()!=this)
    return false;
  //
  // Do il fuoco al primo campo che lo vuole
  var n = this.Fields.length;
  for (var i=0; i<n; i++)
  {
    if (this.Fields[i].Focus(null, (gotop ? 0 : this.ActualRow)))
      return true;
  }
  //
  return false;
  */
}

IDPanel.prototype.HandlesTabFocus = function()
{
  // Non permetto la navigazione con il tab su un sottopannello che non puo' ne' 
  // aggiornare ne' inserire
  if (this.ParentFrameIdentifier && (!this.CanUpdate && !this.CanUpdate))
    return false;
  //  
  return true;
}


// ********************************************************************************
// Cambio riga dovuto a movimento del cursore
// ********************************************************************************
IDPanel.prototype.ChangeActualRow= function(newrow, evento)
{ 
  var oldrow = this.ActualRow;
  if (newrow != oldrow)
  {
    var evt = this.ScrollEventDef;
    //
    // Creo l'evento (che si aggiunge all'elenco se deve)
    if (evento)
      var ev = new IDEvent("chgrow", this.Identifier, evento, evt, null, newrow, 0);
    //
    // Se l'evento ha le caratteristiche per essere gestito lato client,
    // lo faccio ora
    if (!evento || ev.ClientSide)
    {
      this.SetActualRow(newrow);
      //
      var n = this.Fields.length;
      for (var i=0; i<n; i++)
        this.Fields[i].SetActualPosition(this.ActualPosition,oldrow,newrow);
      //
      this.SetStatusBarText();
      //
      this.ResetPosition = false;
    }    
  }
}


// ********************************************************************************
// Dimensiona la scrollbare tenendo conto delle righe totali o quelle visibili 
// nella visione gruppata
// ********************************************************************************
IDPanel.prototype.UpdateScrollBox = function()
{
}


// ********************************************************************************
// Dimensiona la scrollint in base alla posizione e al numero di righe
// nella visione gruppata
// ********************************************************************************
IDPanel.prototype.UpdateScrollTouch = function()
{
}


// ********************************************************************************
// Muove il pannello in base alla posizione del ditino
// ********************************************************************************
IDPanel.prototype.MoveScrollTouch = function(yscr)
{
}


// ********************************************************************************
// Aggiorna la posizione della scrollbar
// ********************************************************************************
IDPanel.prototype.UpdateScrollPos= function()
{
}


// **********************************************************************
// Gestisco la pressione dei tasti FK a partire dal pannello
// **********************************************************************
IDPanel.prototype.HandleFunctionKeys = function(eve)
{
  // Vediamo se il tasto e' attivo...
  var code = (eve.charCode)?eve.charCode:eve.keyCode;
  var ok = false;
  //
  // Verifico i comandi legati ai campi
  var n = this.Fields.length;
  for (var i=0; i < n && !ok; i++)
    ok = this.Fields[i].FieldFunctionKeys(eve);
  //
  if (ok)
    return ok;
  //
  // Innanzitutto verifico la toolbar di frame
  ok = RD3_DesktopManager.WebEntryPoint.CmdObj.HandleFunctionKeys(eve, this.WebForm.IdxForm, this.WebForm.GetFrameIndex(this)+1);
  if (ok)
    return ok; // Nel caso esco subito perche' non devo fare verifiche ulteriori
  //
  // Calcolo il numero di FK da 1 a 48
  var fkn = (code-111) + (eve.shiftKey? 12 : 0)  + (eve.ctrlKey? 24 : 0);
  //
  // La mia toolbar e' visibile?
  var IsToolbarVisible = (this.ToolbarBox!=null && this.ToolbarBox.style.display!="none");
  //
  // Vediamo se corrisponde ad uno dei miei tasti predefiniti
  if (fkn == RD3_ClientParams.FKEnterQBE && IsToolbarVisible && this.SearchButton.style.display == "" && this.SearchButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "search");
  }
  if (fkn == RD3_ClientParams.FKFindData && IsToolbarVisible && this.FindButton.style.display == "" && this.FindButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "find");
  }
  if (fkn == RD3_ClientParams.FKFormList && IsToolbarVisible && this.FormListButton.style.display == "" && this.FormListButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "list");
  }
  if (fkn == RD3_ClientParams.FKRefresh && IsToolbarVisible && this.RefreshButton.style.display == "" && this.RefreshButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "refresh");
  }
  if (fkn == RD3_ClientParams.FKCancel && IsToolbarVisible && this.CancelButton.style.display == "" && this.CancelButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "cancel");
  }
  if (fkn == RD3_ClientParams.FKInsert && IsToolbarVisible && this.NewButton.style.display == "" && this.NewButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "insert");
  }
  if (fkn == RD3_ClientParams.FKDelete && IsToolbarVisible && this.DelButton.style.display == "" && this.DelButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "delete");
  }
  if (fkn == RD3_ClientParams.FKUpdate && IsToolbarVisible && this.SaveButton.style.display == "" && this.SaveButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "save");
  }
  if (fkn == RD3_ClientParams.FKDuplicate && IsToolbarVisible && this.DuplButton.style.display == "" && this.DuplButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "dupl");
  }
  if (fkn == RD3_ClientParams.FKPrint && IsToolbarVisible && this.PrintButton.style.display == "" && this.PrintButton.parentNode)
  {
    ok = true;
    this.OnToolbarClick(eve, "print");
  }
  if (fkn == RD3_ClientParams.FKSelAll && this.MultiSelectAllCmd.style.display == "")
  {
    ok = true;
    this.OnMultiSelCmd(eve, "selall");
  }
  if (fkn == RD3_ClientParams.FKSelNone && this.MultiSelectNoneCmd.style.display == "")
  {
    ok = true;
    this.OnMultiSelCmd(eve, "selnone");
  }  
  if (fkn == RD3_ClientParams.FKSelTog && this.ToggleMultiSelCmd.style.display == "")
  {
    ok = true;
    this.OnMultiSelCmd(eve, "seltog");
  }  
  if (fkn == RD3_ClientParams.FKLocked && IsToolbarVisible && this.LockButton.style.display == "" && this.LockButton.parentNode)
  {
    ok = true;
    this.OnLockClick(eve);
  }
  if (fkn==RD3_ClientParams.FKActRow)
  {
    ok = true;
    this.OnRowSelectorClick(eve, this.ActualRow);
  }
  if (fkn==RD3_ClientParams.FKActField && RD3_KBManager.ActiveObject && RD3_KBManager.ActiveObject.ParentPanel==this)
  {
    ok = true;
    RD3_KBManager.ActiveObject.OnClickActivator(eve);
  }
  //
  var a = RD3_Glb.PCM_CUSTOM1;
  for (var i = 0; i < RD3_DesktopManager.WebEntryPoint.CustomCommands.length; i++)
  {
    // Custom 9 deve ricominciare da 0 (perche' cambia intero) ed essere <0 (in modo da poter decidere di andare sui nuovi flag)
    if (i == 8)
     a = -0x1;
    //
    var cm = RD3_DesktopManager.WebEntryPoint.CustomCommands[i];
    if (cm.FKNum == fkn && this.IsCommandEnabled(a))
    {
      this.OnToolbarClick(eve, "cb" + i);
      ok = true;
      break;
    }
    //
    a *= 2;
  }
  //
  // Se il tasto non e' stato identificato, chiamo la classe base
  if (!ok)
    ok = WebFrame.prototype.HandleFunctionKeys.call(this, eve);
  //
  return ok;
}


// **********************************************************************
// Da il fuoco al campo successivo, eventualmente scrolla in giu' il pannello
// **********************************************************************
IDPanel.prototype.FocusNextField = function(fld, eve, focusQBEList)
{
  var panelCompleted = false;
  var f;
  var nr = this.ActualRow;
  var scrolla = false;
  //
  if (!this.Locked)
  {  
    // Vado sul prossimo campo utile
    f = this.GetNextField(fld);
    if (!f)
    {
      panelCompleted = true;
      //
      f = this.GetFirstField();
      if (this.ActualRow < this.NumRows - 1 && !focusQBEList)
        nr++;
      else
        scrolla = true;
    }
    //  
    // Verifico se e' fuocabile
    while (f != fld && f && !f.CanHaveFocus(undefined, focusQBEList) && nr<=this.NumRows)
    {
      f = this.GetNextField(f, nr);
      if (!f)
      {
        panelCompleted = true;
        //
        f = this.GetFirstField();
        if (this.ActualRow < this.NumRows - 1 && !focusQBEList)
          nr++;
        else
          scrolla = true;
      }
    }
    if (focusQBEList)
      scrolla = false;
  }
  //
  // Se posso ancora scrollare allora vado avanti.. altrimenti se sono tornato all'inizio del pannello
  // passo al prossimo
  var cannotScroll = scrolla && this.ActualPosition+this.NumRows-1 >= this.TotalRows;
  if (this.Locked || (panelCompleted && (cannotScroll || this.Status == RD3_Glb.PS_QBE || this.PanelMode==RD3_Glb.PANEL_FORM)))
  {
    this.WebForm.Focus(this, true);
    return;
  }
  //
  // Se sono in form, non eseguo alcun scrolling
  if (this.PanelMode==RD3_Glb.PANEL_FORM)
    scrolla = false;
  //  
  if (f)
  {
    // Se la cella e' attiva, seleziono tutto il testo
    var selall = f.IsEnabled();
    //
    // Adesso posso cambiare riga e mostrare il nuovo input
    if (nr > this.ActualRow && this.PanelMode==RD3_Glb.PANEL_LIST)
      this.ChangeActualRow(this.ActualRow + (nr - this.ActualRow), eve);
    f.Focus(eve, nr, selall, focusQBEList);
    this.FieldFocus(f.Index, true);
  }
  //
  if (scrolla && this.ActualPosition<this.TotalRows-this.NumRows+1)
  {
    this.ScrollTo(this.ActualPosition+1,eve);
    this.UpdateScrollPos();
  }
}


// **********************************************************************
// Da il fuoco al campo precedente, eventualmente scrolla in su il pannello
// **********************************************************************
IDPanel.prototype.FocusPrevField = function (fld, eve, focusQBEList)
{
  var panelCompleted = false;
  var f;
  var nr = this.ActualRow;
  var scrolla = false;
  //
  if (!this.Locked)
  {
    f = this.GetPrevField(fld);
    if (!f)
    {
      panelCompleted = true;
      //
      f = this.GetLastField();
      if (this.ActualRow > 0 && !focusQBEList)
        nr--;
      else
        scrolla = true;
    }
    //  
    // Verifico se e' fuocabile
    while (f!=fld && f && !f.CanHaveFocus(undefined, focusQBEList) && nr>0)
    {
      f = this.GetPrevField(f, nr);
      if (!f)
      {
        panelCompleted = true;
        //
        f = this.GetLastField();
        if (this.ActualRow > 0 && !focusQBEList)
          nr--;
        else
          scrolla = true;
      }
    }
    if (focusQBEList)
      scrolla = false;
  }
  //
  // Se posso ancora scrollare allora vado avanti.. altrimenti se sono tornato all'inizio del pannello
  // passo al prossimo
  var cannotScroll = scrolla && this.ActualPosition==1;
  if (this.Locked || (panelCompleted && (cannotScroll || this.Status == RD3_Glb.PS_QBE || this.PanelMode==RD3_Glb.PANEL_FORM)))
  {
    this.WebForm.Focus(this, false);
    return;
  }
  //
  // Se sono in form, non eseguo alcun scrolling
  if (this.PanelMode==RD3_Glb.PANEL_FORM)
    scrolla = false;
  //  
  if (f)
  {
    // Se la cella e' attiva, seleziono tutto il testo
    var selall = f.IsEnabled();
    //
    // Adesso posso cambiare riga e mostrare il nuovo input
    if (nr < this.ActualRow && this.PanelMode==RD3_Glb.PANEL_LIST)
      this.ChangeActualRow(this.ActualRow - (this.ActualRow - nr), eve);
    f.Focus(eve, nr, selall, focusQBEList);
    this.FieldFocus(f.Index, true);
  }
  //
  if (scrolla && this.ActualPosition>1)
  {
    this.ScrollTo(this.ActualPosition-1,eve);
    this.UpdateScrollPos();
  }
}


// **********************************************************************
// Ritorna il primo campo del pannello
// **********************************************************************
IDPanel.prototype.GetFirstField = function()
{
  var n = this.Fields.length;
  for (var i = 0; i<n; i++)
  {
    var f = this.Fields[i];
    //
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_LIST)
      f = this.ListTabOrder[i];
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_FORM)
      f = this.FormTabOrder[i];
    //
    if (!f.IsStatic() && f.IsVisible())
      return f;
  }
  //
  // Nessun campo visibile
  return null;
}


// **********************************************************************
// Ritorna l'ultimo campo del pannello
// **********************************************************************
IDPanel.prototype.GetLastField = function()
{
  var n = this.Fields.length;
  for (var i = n-1; i>=0; i--)
  {
    var f = this.Fields[i];
    //
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_LIST)
      f = this.ListTabOrder[i];
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_FORM)
      f = this.FormTabOrder[i];
    //
    if (!f.IsStatic() && f.IsVisible())
      return f;
  }
  //
  // Nessun campo visibile
  return null;
}

// **********************************************************************
// Ritorna l'ultimo campo del pannello
// **********************************************************************
IDPanel.prototype.GetLastListField = function()
{
  var n = this.Fields.length;
  for (var i = n-1; i>=0; i--)
  {
    var f = this.Fields[i];
    //
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_LIST)
      f = this.ListTabOrder[i];
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_FORM)
      f = this.FormTabOrder[i];
    //
    if (!f.IsStatic() && f.IsVisible() && f.InList && f.ListList)
      return f;
  }
  //
  // Nessun campo visibile
  return null;
}

// **********************************************************************
// Ritorna il prossimo campo del pannello
// **********************************************************************
IDPanel.prototype.GetNextField = function(fld, rw)
{
  if (rw == undefined)
    rw = this.ActualRow;
  //
  var n = this.Fields.length;
  //
  for (var x = 0; x<n; x++)
  {
    var f = this.Fields[x];
    //
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_LIST)
      f = this.ListTabOrder[x];
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_FORM)
      f = this.FormTabOrder[x];
    //
    if (f.Index==fld.Index)
      break;
  }
  //
  for (var i = x+1; i<n; i++)
  {
    var f = this.Fields[i];
    //
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_LIST)
      f = this.ListTabOrder[i];
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_FORM)
      f = this.FormTabOrder[i];
    //
    // Il campo e' valido se non e' disabilitato, uso il +1 perche' la IsEnabled ha un -1 (il PValue 0 non esiste)
    if (f && (!f.IsStatic() || f.IsButton()) && f.IsVisible() && f.HandlesTabOrder() && f.IsEnabled(this.ActualPosition + rw + 1))
      return f;
  }
  //
  // Nessun campo successivo
  return null;
}


// **********************************************************************
// Ritorna il campo precedente del pannello
// **********************************************************************
IDPanel.prototype.GetPrevField = function(fld, rw)
{
  if (rw == undefined)
    rw = this.ActualRow;
  //
  var n = this.Fields.length;
  //
  for (var x = 0; x<n; x++)
  {
    var f = this.Fields[x];
    //
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_LIST)
      f = this.ListTabOrder[x];
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_FORM)
      f = this.FormTabOrder[x];
    //
    if (f.Index==fld.Index)
      break;
  }
  //
  for (var i = x-1; i>=0; i--)
  {
    var f = this.Fields[i];
    //
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_LIST)
      f = this.ListTabOrder[i];
    if (this.AdvTabOrder && this.PanelMode==RD3_Glb.PANEL_FORM)
      f = this.FormTabOrder[i];
    //
    // Il campo e' valido se non e' disabilitato, uso il +1 perche' la IsEnabled ha un -1 (il PValue 0 non esiste)
    if ((!f.IsStatic() || f.IsButton()) && f.IsVisible() && f.HandlesTabOrder() && f.IsEnabled(this.ActualPosition + rw + 1))
      return f;
  }
  //
  // Nessun campo precedente
  return null;
}


// ********************************************************************************
// Cambia la multiselezione
// 0 = NONE, 1 = INVERT, 2 = ALL
// ********************************************************************************
IDPanel.prototype.ChangeSelection= function(sel, force)
{
  var begin = (this.SelAllOnlyVis && !force ? this.ActualPosition : 1);
  var end = (this.SelAllOnlyVis && !force ? this.ActualPosition + this.NumRows -1 : this.TotalRows);
  for (var i=begin; i<=end; i++)
  {
    switch (sel)
    {
      case 0:
        this.MultiSelStatus[i]= false;
      break;
      
      case 1:
        this.MultiSelStatus[i]= !this.MultiSelStatus[i];
      break;

      case 2:
        this.MultiSelStatus[i]= true;
      break;
    }
  }
}


// ********************************************************************************
// Aggiorna lo stato degli indicatori della multiselezione
// ********************************************************************************
IDPanel.prototype.UpdateMultipleSel= function()
{
  if (this.ShowMultipleSel && this.MultiSelStatus && this.RowSel)
  {
    var n = this.RowSel.length;
    for (var i=0; i<n; i++)
    {
      var disabled = (this.ActualPosition + i > this.TotalRows || this.Status == RD3_Glb.PS_QBE);
      //
      var rs = this.RowSel[i].firstChild.firstChild.firstChild;
      rs.disabled = disabled;
      if (!disabled)
        rs.checked = this.MultiSelStatus[this.ActualPosition+i];
      else
        rs.checked = false; 
    }
  }
  //
  // Occorre aggiornare il testo della StatusBar
  this.SetStatusBarText();
  
}

// **********************************************************************
// Gestore dell'evento di MouseOver
// **********************************************************************
IDPanel.prototype.OnMouseOverObj = function(ev)
{
}

// **********************************************************************
// Gestore dell'evento di MouseOut
// **********************************************************************
IDPanel.prototype.OnMouseOutObj = function(ev)
{
}

// ********************************************************************************
// Gestore eventi di mouse su un pulsante della Toolbar di pannello
// Il parametro deve valere "" per bottone senza effetti, "hover" per highlight
// e "down" per effetto cliccato
// ********************************************************************************
IDPanel.prototype.OnToolMouseUse = function(evento, parametro)
{
}

// *******************************************************************
// Funzione Callback chiamata dopo la pressione di uno dei pulsanti
// della confirm per cancellare i dati
// -> utilizzata anche come callback per la confirm della duplicazione
// o esportazione senza righe multiselezionate (vedi OnToolbarClick)
// *******************************************************************
IDPanel.prototype.OnDeleteConfirm = function(ev, button)
{
  if (this.MsgBox)
  {
    if (button == "delete")
      this.DoHighlightDelete(false);
    //
    // Se l'utente ha dato l'ok mando il delete
    if (this.MsgBox.UserResponse == "Y")
      var ev = new IDEvent("pantb", this.Identifier, ev, this.ToolbarEventDef, button);
    //
    // Elimino il riferimento alla confirm
    this.MsgBox = null;
  }
}


// ********************************************************************************
// Indica quanto il contenuto deve essere piu' basso del frame per contenere
// la toolbar, le pagine...
// ********************************************************************************
IDPanel.prototype.GetContentOffset = function()
{ 
  var ofs = this.ToolbarBox.offsetHeight;
  if (this.PagesBox)
  {
    var val = 0;
    //
    // Se non sono mobile oppure se sono Mobile ed in Form (ma non durante l'animazione)
    // dimensiono il content-container tenendo conto della toolbar delle pagine (quindi in lista oppure durante il passaggio
    // da lista a form il contenitore occupa l'intero spazio)
    if (!RD3_Glb.IsMobile() || (this.PanelMode==RD3_Glb.PANEL_FORM && !this.AnimatingPanel))
      val = this.PagesBox.offsetHeight;
    //
    ofs += val;
  }
  return ofs;
}


// ********************************************************************************
// Aggiorna il visual style dei campi obbligatori (la caption potrebbe cambiare)
// ********************************************************************************
IDPanel.prototype.UpdateNotNullFields = function()
{
}


// ********************************************************************************
// Evento di scrolling della lista interna del pannello (errore...)
// ********************************************************************************
IDPanel.prototype.NoScroll = function(ev)
{ 
  var targetEl = ev.target ? ev.target : ev.srcElement;
  //
  // Elimino effetto spostamento strambo
  targetEl.scrollTop = 0;
  targetEl.scrollLeft = 0;
}


// ********************************************************************************
// Gestore del mouse down su uno degli elementi del pannello
// ********************************************************************************
IDPanel.prototype.OnMouseDownObj = function(evento, obj)
{
}

// ********************************************************************************
// Aggiornamento RowSelector
// ********************************************************************************
IDPanel.prototype.UpdateRowSel = function()
{
  // Se il pannello non ha campi... non c'e' niente da aggiornare...
  if (!this.Fields[0])
    return;
  //
  var n = this.NumRows;
  for (var i=0; i < n; i++) {
    var v = this.Fields[0].PValues[this.ActualPosition+i];
    if (v)
      v.UpdateRowSel();
  }
}

// *********************************************************
// Timer globale
// *********************************************************
IDPanel.prototype.Tick = function()
{
}


// *********************************************************
// E' arrivato un click a livello di frame
// *********************************************************
IDPanel.prototype.OnFrameClick = function(evento, dbl, btn, x, y, xb, yb, tget)
{
   // calcolo la colonna / riga alla quale e' avvenuto il click
  var row = -1;
  var col = -1;
  //
  var id = RD3_Glb.GetRD3ObjectId(tget);
  if (id == undefined)
    return;
  //
  // Ho cliccato su un campo...
  if (id.substr(0,4)=="fld:")
  {
    col = parseInt(id.substr(4),10);
    if (id.indexOf(":fv")>0)
      row = 0;
    if (id.indexOf(":lv")>0)
      row = parseInt(id.substr(id.indexOf(":lv")+3),10);
  }
  //
  // Uso il timer per creare l'evento, in questo modo il changerow arriva prima del mouseclick
  window.setTimeout(function() {
    var ev = new IDEvent("rawclk", this.Identifier, evento, dbl?this.MouseDoubleClickEventDef:this.MouseClickEventDef, dbl, btn, Math.floor(xb)+"-"+Math.floor(yb), Math.floor(x)+"-"+Math.floor(y), col, null, false, row);
  }.bind(this), RD3_Glb.IsTouch() ? 50 : 2);
}

// *********************************************************
// Imposta il tooltip
// *********************************************************
IDPanel.prototype.GetTooltip = function(tip, obj)
{
  // Guardiamo se e' un bottone della tooltbar di pannello
  var ok = false;
  if (obj == this.TopButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_PanelInizio);
    tip.SetText(RD3_ServerParams.PanelInizio);
    ok = true;
  }
  else if (obj == this.PrevButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_PanelPaginaPrec);
    tip.SetText(RD3_ServerParams.PanelPaginaPrec);
    ok = true;
  }
  else if (obj == this.NextButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_PanelPaginaSucc);
    tip.SetText(RD3_ServerParams.PanelPaginaSucc);
    ok = true;
  }
  else if (obj == this.BottomButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_PanelFine);
    tip.SetText(RD3_ServerParams.PanelFine);
    ok = true;
  }
  else if (obj == this.SearchButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipCerca);
    tip.SetText(RD3_ServerParams.TooltipCerca + RD3_KBManager.GetFKTip(RD3_ClientParams.FKEnterQBE));
    ok = true;
  }
  else if (obj == this.FindButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipTrova);
    tip.SetText(RD3_ServerParams.TooltipTrova + RD3_KBManager.GetFKTip(RD3_ClientParams.FKFindData));
    ok = true;
  }
  else if (obj == this.FormListButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipFormList);
    tip.SetText(RD3_ServerParams.TooltipFormList + RD3_KBManager.GetFKTip(RD3_ClientParams.FKFormList));
    ok = true;
  }
  else if (obj == this.CancelButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipCancel);
    tip.SetText(RD3_ServerParams.TooltipCancel + RD3_KBManager.GetFKTip(RD3_ClientParams.FKCancel));
    ok = true;
  }
  else if (obj == this.RefreshButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipRefresh);
    tip.SetText(RD3_ServerParams.TooltipRefresh + RD3_KBManager.GetFKTip(RD3_ClientParams.FKRefresh));
    ok = true;
  }
  else if (obj == this.DelButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipDelete);
    tip.SetText(RD3_ServerParams.TooltipDelete + RD3_KBManager.GetFKTip(RD3_ClientParams.FKDelete));
    ok = true;
  }
  else if (obj == this.NewButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipInsert);
    tip.SetText(RD3_ServerParams.TooltipInsert + RD3_KBManager.GetFKTip(RD3_ClientParams.FKInsert));
    ok = true;
  }
  else if (obj == this.DuplButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipDuplicate);
    tip.SetText(RD3_ServerParams.TooltipDuplicate + RD3_KBManager.GetFKTip(RD3_ClientParams.FKDuplicate));
    ok = true;
  }
  else if (obj == this.SaveButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipUpdate);
    tip.SetText(RD3_ServerParams.TooltipUpdate + RD3_KBManager.GetFKTip(RD3_ClientParams.FKUpdate));
    ok = true;
  }
  else if (obj == this.PrintButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_Print);
    tip.SetText(RD3_ServerParams.Print + RD3_KBManager.GetFKTip(RD3_ClientParams.FKPrint));
    ok = true;
  }
  else if (obj == this.CsvButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipExport);
    tip.SetText(RD3_ServerParams.TooltipExport);
    ok = true;
  }
  else if (obj == this.AttachButton)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_ComandoAllegati);
    tip.SetText(RD3_ServerParams.ComandoAllegati);
    ok = true;
  }
  else // Comando custom
  {
    var a = RD3_DesktopManager.WebEntryPoint.CustomCommands;
    var n = a.length;
    for (var i=0; i<n; i++)
    {
      if (obj == this.CustomButtons[i])
      {
        tip.SetTitle(a[i].Caption);
        tip.SetText(a[i].Tooltip + RD3_KBManager.GetFKTip(a[i].FKNum));
        ok = true;
        break;
      }
    }
  }
  //
  if (obj == this.ToggleMultiSelCmd)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipRowSel);
    if (RD3_ServerParams.CompletePanelBorders && this.ShowMultipleSel)
      tip.SetText(RD3_ServerParams.TooltipMultipleCommandset + RD3_KBManager.GetFKTip(RD3_ClientParams.FKSelTog));
    else
      tip.SetText((this.ShowMultipleSel)?RD3_ServerParams.TooltipShowRowSel:RD3_ServerParams.TooltipShowCheck) + RD3_KBManager.GetFKTip(RD3_ClientParams.FKSelTog);
    ok = true;
  }
  else if (obj == this.MultiSelectAllCmd)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipSelectAll);
    tip.SetText(RD3_ServerParams.TooltipSelectAll + RD3_KBManager.GetFKTip(RD3_ClientParams.FKSelAll));
    ok = true;
  }
  else if (obj == this.MultiSelectNoneCmd)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipDeseleziona);
    tip.SetText(RD3_ServerParams.TooltipDeseleziona + RD3_KBManager.GetFKTip(RD3_ClientParams.FKSelNone));
    ok = true;
  }
  //
  if (ok)
  {
    // Di default i bottoni di pannello mostrano il tooltip centrato sopra di essi
    tip.SetAnchor(RD3_Glb.GetScreenLeft(obj) + ((obj.offsetWidth-4)/2), RD3_Glb.GetScreenTop(obj));
    tip.SetPosition(0);
    return true;
  }
  else
    return WebFrame.prototype.GetTooltip.call(this, tip, obj);
}


// ********************************************************************************
// Su quali celle e' possibile droppare?
// ********************************************************************************
IDPanel.prototype.ComputeDropList = function(list,dragobj)
{
  // Se non sono stato realizzato... o non posso... niente DropList
  if (!this.Realized)
    return;
  //
  // Anch'io voglio essere droppabile...
  // Controllo prima dei campi perche' la drop list viene poi analizzata al contrario
  // Se non e' attivo il Drop non aggiungo
  if (!this.CanDrop && !this.CanReorderColumn)
    return;
  //
  // Se e' un D&D di un PField ed il pannello ammette il riordino delle colonne
  // non aggiungo me stesso... dato che non posso tirare una colonna sul pannello
  var isColDD = (this.CanReorderColumn && (dragobj instanceof PField));
  if (!isColDD)
    list.push(this);
  //
  // Calcolo le coordinate assolute...
  var o = this.ContentBox;
  this.AbsLeft = RD3_Glb.GetScreenLeft(o,true);
  this.AbsTop = RD3_Glb.GetScreenTop(o,true);
  if (!RD3_Glb.IsIE())
  {
    // Sugli altri browser devo tenere conto della scrollbar...
    this.AbsLeft -= this.ContentBox.scrollLeft;
    this.AbsTop -= this.ContentBox.scrollTop;
  }
  //
  this.AbsRight = this.AbsLeft + o.offsetWidth - 1;
  this.AbsBottom = this.AbsTop + o.offsetHeight - 1;
  //
  // Giro su tutti i campi e lo chiedo a loro
  var n = this.Fields.length;
  for (var i=0; i<n; i++)
  {
    var f = this.Fields[i];
    f.ComputeDropList(list,dragobj);
  }
}


// ***************************************************************************************
// Restituisce il numero di righe totali del pannello, tenendo conto della gestione dei 
// gruppi
// ***************************************************************************************
IDPanel.prototype.GetTotalRows = function()
{
  if (this.ListGroupRoot==null || this.PanelMode==RD3_Glb.PANEL_FORM || this.Status==RD3_Glb.PS_QBE)
    return this.TotalRows;
}


// ***************************************************************************************
// Ritorna true se il pannello ha i raggruppamenti attivi e li sta mostrando
// ***************************************************************************************
IDPanel.prototype.IsGrouped = function()
{
  return false;
}


// ******************************************************************************************************
// Restituisce l'indice nell'array dei PValues relativo alla riga specificata del pannello
// nrow, da 0 a visibleRow-1
// layout : layout di cui si desidera sapere l'indice, se undefined viene preso quello del pannello
// act: actual position, se null si prende quella del pannello
// *******************************************************************************************************
IDPanel.prototype.GetRowIndex = function(nrow, layout, act)
{
  if (!this.IsGrouped())
    return this.ActualPosition + nrow;
  //
  if (layout==undefined||layout==null)
    layout = this.PanelMode;
  //
  if (layout == RD3_Glb.PANEL_LIST)
  {
    if (act==undefined||act==null||act==this.ActualPosition)
      act = this.CompactActualPosition;
    else
      act = this.ListGroupRoot.GetRowPos(act);
    //  
    return this.ListGroupRoot.GetRowIndex(act, nrow);
  }
  //
  if (layout == RD3_Glb.PANEL_FORM)
  {
    if (act==undefined||act==null)
      act = this.ActualPosition;
    //
    var idx = act + nrow;
    return this.ListGroupRoot.GetPValOffset(idx) + idx;
  }
}


// *************************************************
// Dato un indice restituisce la riga visibile a cui si trova nel pannello,
// se e' fuori dal buffer video restituisce -1
// *************************************************
IDPanel.prototype.GetRowForIndex = function(idx)
{
  if (!this.IsGrouped())
    return -1;
  //
  var rw = this.ListGroupRoot.GetRowPos(idx, false);
  rw = rw - this.CompactActualPosition;
  //
  if (rw<0 || rw>this.NumRows)
    return -1;
  //
  return rw;
}


// *****************************************************
// Data una riga del buffer video (0<=row<=NumRows)
// restituisce l'index del PValue lato server
// ******************************************************
IDPanel.prototype.GetServerIndex = function(row)
{
  if (!this.IsGrouped())
    return -1;
  //
  return this.ListGroupRoot.GetServerIndex(this.CompactActualPosition+row, true);
}


// ********************************************************
//  Restituisce true se la la riga selezionata da actpos e row
// e' una nuova riga, sia in visione reale che gruppata 
// (in visione gruppata va passata la riga reale, senza fare
// conversioni)
// ********************************************************
IDPanel.prototype.IsNewRow = function(actpos, row)
{
  if (!this.IsGrouped())
    return actpos+row > this.TotalRows;
  //
  // Passo in modalita' gruppata: scopro a quale Index corrisponde la riga selezionata, se e' maggiore di TotalRows sono in una nuova riga
  return this.GetServerIndex(row)>this.TotalRows;
}


// *****************************************************
// Data una riga del buffer video restituisce -1
// se e' un header di gruppo oppure l'indice della riga reale
// ******************************************************
IDPanel.prototype.IsHeader = function(row)
{
  return false;
}


// *****************************************************
// Ridimensiono correttamente la label dei gruppi
// ******************************************************
IDPanel.prototype.CalcListGroupLayout = function()
{
}


// *****************************************************
// Una cella ha preso o perso il fuoco..
// ******************************************************
IDPanel.prototype.FieldFocus = function(fldidx, getfocus)
{
  var ev = new IDEvent("fev", this.Identifier , null, this.FocusEventDef, fldidx, getfocus ? "1" : "0", null, null, null, this.FocusEventDef==RD3_Glb.EVENT_ACTIVE ? 250 : null);
}

// *****************************************************
// De/Evidenzio le righe che sto per cancellare
// ******************************************************
IDPanel.prototype.DoHighlightDelete = function(highlight)
{
  // Se il pannello non vuole l'evidenziazione non faccio nulla
  if (!this.HighlightDelete)
    return;
  //
  // Se devo evidenziare
  if (highlight)
  {
    this.HLDelObjects = new Array();
    //
    // Se sono in lista
    if (this.PanelMode==RD3_Glb.PANEL_LIST)
    {
      // Se mostro la multiselezione
      var fromRow = this.ActualPosition + (this.ShowMultipleSel ? 0 : this.ActualRow);
      var toRow = this.ActualPosition + (this.ShowMultipleSel ? this.ActualPosition + this.NumRows -1 : this.ActualRow);
      for (var i = fromRow-1 ; i < toRow; i++) {
        if (!this.ShowMultipleSel || this.MultiSelStatus[i + 1]) {
          this.HLDelObjects.push(this.Rows[i]);
          RD3_Glb.AddClass(this.Rows[i], "delete-row-outline");
        }
      }
    }
    else // Sono in form
    {
      RD3_Glb.AddClass(this.ContentBox, "delete-row-outline");
      this.HLDelObjects.push(this.ContentBox);
    }
  }
  else // Devo togliere l'evidenziazione
  {
    while (this.HLDelObjects.length > 0) {
      var hl = this.HLDelObjects.pop();
      RD3_Glb.RemoveClass(hl, "delete-row-outline");
    }
    //
    this.HLDelObjects = undefined;
  }
}

// ********************************************************************************
// Ritorna l'ID dell'oggetto toccato (curato)
// ********************************************************************************
IDPanel.prototype.GetTouchID = function(theTarget)
{
  // Per la struttura delle combo disabilitate, posso andare a prendere l'ID
  // anche al livello superiore.
  var tid = theTarget.id;
  if (tid=="" && theTarget.tagName=="SPAN")
    tid = theTarget.parentNode.id;
  //
  // Se non trovo ancora l'ID scavo piu' profondamente
  var tt = theTarget;
  while (tt && tid=="")
  {
    tt = tt.parentNode;
    tid = tt.id;
  }  
  //
  return tid;
}


// *******************************************************************
// Evidenzia la riga indicata (da 1 a TotalRows)
// *******************************************************************
IDPanel.prototype.HiliteRow = function(nr) 
{
}

IDPanel.prototype.HiliteRow2 = function(nr, fl) 
{
}


// *******************************************************************
// Gestisce animazione lista/form
// e anche bottone torna alla lista e search box
// *******************************************************************
IDPanel.prototype.OnFormListAni = function() 
{
}


// *******************************************************************
// Gestisce animazione lista/form
// *******************************************************************
IDPanel.prototype.OnEndAnimation = function(ev) 
{
}


// *********************************************************************************
// Aggiorno le classi del primo e ultimo campo in form di questo gruppo
// *********************************************************************************
IDPanel.prototype.UpdateFieldClass = function(group)
{
}


// ********************************************************************************
// Il pannello e' stato scrollato oltre l'ultima riga... ce ne sono altre?
// ********************************************************************************
IDPanel.prototype.OnScrollBottom= function()
{
}


// ********************************************************************************
// Ho premuto il pulsante ancora righe... effettuo il caricamento
// ********************************************************************************
IDPanel.prototype.OnMoreButton= function()
{ 
  if (this.PanelMode==RD3_Glb.PANEL_LIST && !this.MoreRowsRequested)
  {
    var ev = new IDEvent("more", this.Identifier, null, RD3_Glb.EVENT_ACTIVE);
    this.MoreRowsRequested = true;
  }
}


// ********************************************************************************
// Ho scrollato fino in fondo... carico ancora righe?
// ********************************************************************************
IDPanel.prototype.OnEndScroll= function(d)
{ 
  if (d==1 && this.LoadingPolicy==1 && this.WasToBottom)
  {
    // Azzero i dati per la velocita' se no riparte lo scroll
    this.OnMoreButton();
  }
  this.WasToBottom = false;
}


// ********************************************************************************
// Inizia il pull to refresh
// ********************************************************************************
IDPanel.prototype.OnPullTrigger= function(active, dy, click, ev)
{
}


// ********************************************************************************
// Ho finito di usare la scrollbar mobile...
// ********************************************************************************
IDPanel.prototype.OnScrollMobileUp= function(ev)
{
}

// ********************************************************************************
// Sto usando la scrollbar mobile...
// ********************************************************************************
IDPanel.prototype.OnScrollMobile= function(ev)
{
}


// *******************************************************************************
// TOrna true se IDScroll e' attaccato al mio pannello adesso
// *******************************************************************************
IDPanel.prototype.IsMyScroll = function()
{
  return (this.IDScroll && (this.IDScroll.MyBox==this.FormBox || this.IDScroll.MyBox==this.ListBox))
}


// *******************************************************************************
// Sistema questo pannello per essere a posto come subframe
// *******************************************************************************
IDPanel.prototype.AdjustSubFrame = function(pf,pobj)
{
}


// ********************************************************************************
// Gestore swipe su pannello
// ********************************************************************************
IDPanel.prototype.SetSwipe= function(attivo, campo, riga, evento)
{
}

// ********************************************************************************
// Nasconde o mostra i pulsanti di Back dell'albero nel caso mobile
// ********************************************************************************
IDPanel.prototype.ChangeExpose  = function(exposed)
{
}


// *******************************************************************
// Chiamato quando cambia il colore di accento
// *******************************************************************
IDPanel.prototype.AccentColorChanged = function(reg, newc) 
{
}

// *****************************************************************
// Chiamata da Command.js quando un commando di toolbar si vuole 
// aggiungere al pannello; lo dobbiamo mettere nella zona giusta
// *****************************************************************
IDPanel.prototype.AppendCmsToToolbar = function(toolObj) 
{
  // Appendo il tool alla zona giusta
  var i = RD3_DesktopManager.WebEntryPoint.CommandZones[RD3_Glb.CZ_CMDSET];
  this.TBZones[i].appendChild(toolObj);
  //
  // Adesso devo verificare se la zona e' realmente nella toolbar (su IE7 devo usare parentElement, perche' parentNode non e' mai nullo ma e' il document..)
  var par = (RD3_Glb.IsIE(10, false) ? this.TBZones[i].parentElement : this.TBZones[i].parentNode);
  //
  if (par == null)
  {
    // Se non e' nella toolbar (perche' era vuota) la devo mettere.. per farlo ciclo avanti sulle zone fino a trovare la prima che appartiene alla toolbar..
    // poi mi metto prima di lei.. se ho finito le zone allora la appendo in fondo..
    for (var itz = i+1; itz < this.TBZones.length; itz++)
    {
      var parTz = (RD3_Glb.IsIE(10, false) ? this.TBZones[itz].parentElement : this.TBZones[itz].parentNode);
      //
      if (parTz != null)
      {
        parTz.insertBefore(this.TBZones[i], this.TBZones[itz]);
        break;
      }
    }
    //
    // Se e' ancora staccata allora la aggiungo in fondo
    par = (RD3_Glb.IsIE(10, false) ? this.TBZones[i].parentElement : this.TBZones[i].parentNode);
    //
    if (par == null)
      this.ToolbarBox.appendChild(this.TBZones[i]);
  }
}

// *******************************************************************
// Chiamato quando ho l'immagine da retinare
// *******************************************************************
IDPanel.prototype.OnAdaptRetina = function(w, h, par)
{
}

/**
 * Crea la griglia per il dettaglio o per i campi fuori lista
 */
IDPanel.prototype.RealizeFormGrid = function(list)
{
  if ((!list && !this.HasForm) || (list && !this.HasList))
    return;
  //
  var hasPages = this.Pages && this.Pages.length > 0;
  //
  // Devo lavorare su una copia dell'array dei fields, perchè devo ordinare i campi in base al loro TOP
  var handledGroups = [];
  var rows = [];
  var nf = this.Fields.length;
  var fldList = this.Fields.slice(0, nf);
  fldList.sort(function(a, b) { 
    var aTop = list ? a.ListTop : a.FormTop;
    var bTop = list ? b.ListTop : b.FormTop;
    //
    // Gestisco i gruppi, devo usare la loro posizione
    if (a.Group)
      aTop = list ? a.Group.ListTop : a.Group.FormTop;
    if (b.Group)
      bTop = list ? b.Group.ListTop : b.Group.FormTop;
    //
    return aTop - bTop; 
  });
  for (var i=0; i<nf; i++) {
    var f = fldList[i];
    //
    // I campi fuori pagina li mostro nella pagina 0 (le linee guida dicono di non farli)
    if (((!list && f.InForm) || (list && f.InList && !f.ListList)) && ((f.Page === -1 && this.PanelPage == 0 && !hasPages) || f.Page === this.PanelPage)) {
     if (f.Group) {
        // Il campo appartiene ad un gruppo, dobbiamo usare quello per
        // dimensionarlo e poi inserirlo nella riga (sempre che non sia stato già 
        // gestito)
        if (handledGroups.indexOf(f.Group) >= 0 || !f.Group.IsVisible())
          continue;
        //
        var gr = {
          t: list ? f.Group.ListTop : f.Group.FormTop, 
          b: list ? f.Group.ListTop + f.Group.ListHeight : f.Group.FormTop + f.Group.FormHeight, 
          l: list ? f.Group.ListLeft : f.Group.FormLeft, 
          r: list ? f.Group.ListLeft + f.Group.ListWidth : f.Group.FormLeft + f.Group.FormWidth
        };
        //
        // Cerco una riga in cui inserire il gruppo
        var fnd = false;
        for (var r = 0; r < rows.length; r++) {
          var rw = rows[r];
          if (RD3_Glb.RectIntersection(rw.rect, gr, 1)) {
            // Se c'e' un intersezione allora devo 
            // - estendere il rect della riga in modo da coprire tutti e due i campi
            // - inserire il campo nella riga
            if (rw.rect.t > gr.t)
              rw.rect.t = gr.t;
            if (rw.rect.b < gr.b)
              rw.rect.b = gr.b;
            rw.groups.push(f.Group);
            fnd = true;
            break;
          }
        }
        //
        if (!fnd) {
          rows.push({
            rect: gr,
            fields: [],
            cols: [],
            groups: [ f.Group ]
          });
        }
        //
        handledGroups.push(f.Group);
      }
      else {
        // Cerchiamo una riga in cui infilare il campo: deve sovrapporsi in Verticale
        // alle coordinate del campo
        var fr = {
          t: list ? f.ListTop : f.FormTop, 
          b: list ? f.ListTop + f.ListHeight : f.FormTop + f.FormHeight, 
          l: list ? f.ListLeft : f.FormLeft, 
          r: list ? f.ListLeft + f.ListWidth : f.FormLeft + f.FormWidth
        };
        //
        var fnd = false;
        for (var r = 0; r < rows.length; r++) {
          var rw = rows[r];
          if (RD3_Glb.RectIntersection(rw.rect, fr, 1)) {
            // Se c'e' un intersezione allora devo 
            // - estendere il rect della riga in modo da coprire tutti e due i campi
            // - inserire il campo nella riga
            if (rw.rect.t > fr.t)
              rw.rect.t = fr.t;
            if (rw.rect.b < fr.b)
              rw.rect.b = fr.b;
            rw.fields.push(f);
            fnd = true;
            break;
          }
        }
        //
        // Se non ho trovato una riga che si intersechi con il campo 
        // allora ne aggiungo una
        if (!fnd) {
          rows.push({
            rect: fr,
            fields: [ f ],
            cols: [],
            groups: []
          });
        }
      }
    }
  }
  //
  // Adesso per ogni riga assegnamo i vari campi/gruppi alle colonne
  for (var r = 0; r < rows.length; r++) {
    var rdiv = document.createElement("div");
    rdiv.className = "row " + (this.PanelPage == -1 && hasPages ? "" : "main-row-page ") +"row-page-"+this.PanelPage + (list ? " list-row-out" : "");
    if (list)
      this.ListBox.appendChild(rdiv);
    else
      this.FormBox.appendChild(rdiv);
    rows[r].rdiv = rdiv;
    this.AssignFieldsToColumns(rows[r], list);
  }
  //
  // Adesso posso dire ai campi in form di realizzarsi nel loro FormGridContainer (stessa cosa per i gruppi
  // poi saranno loro a crearsi la loro griglia e chiedere ai figli di realizzarsi)
  for (var ri = 0; ri < rows.length; ri++) {
    if (list)
      this.ListGridRows.push(rows[ri]);
    else
      this.FormGridRows.push(rows[ri]);
  }
  //
  // Lavoro solo per la pagina corrente
  nf = this.Fields.length;
  for (var i=0; i<nf; i++) {
    var f = this.Fields[i];
    if (((!list && f.InForm && !f.Group && f.FormGridContainer) || (list && f.InList && !f.ListList && !f.Group && f.ListGridContainer)) && ((f.Page === -1 && !hasPages) || f.Page === this.PanelPage))
      f.RealizeFormField(list);
  }
  nf = this.Groups.length;
  for (var i=0; i<nf; i++) {
    var g = this.Groups[i];
    if (((!list && g.FormGridContainer) || (list && g.ListGridContainer)) && ((g.Page === -1 && !hasPages) || g.Page === this.PanelPage))
      g.RealizeFormGroup(list);
  }
};


/**
 * Data una riga con dei campi/gruppi ne assegna le colonne.
 */
IDPanel.prototype.AssignFieldsToColumns = function(row, list)
{
  var cols = [];
  //
  var nf = row.fields.length;
  row.fields.sort(function(a, b) { return list ? a.ListLeft - b.ListLeft : a.FormLeft - b.FormLeft; });
  row.groups.sort(function(a, b) { return list ? a.ListLeft - b.ListLeft : a.FormLeft - b.FormLeft; });
  //
  for (var i=0; i<nf; i++) {
    var f = row.fields[i];
    //
    if ((!list && f.InForm) || (list && f.InList && !f.ListList)) {
      // Cerchiamo una colonna in cui infilare il campo: deve sovrapporsi in Orizzontale
      // alle coordinate del campo
      var fr = {
        t: list ? f.ListTop : f.FormTop, 
        b: list ? f.ListTop + f.ListHeight : f.FormTop + f.FormHeight, 
        l: list ? f.ListLeft : f.FormLeft, 
        r: list ? f.ListLeft + f.ListWidth : f.FormLeft + f.FormWidth
      };
      //
      var fnd = false;
      for (var r = 0; r < cols.length; r++) {
        var clm = cols[r];
        if (RD3_Glb.RectIntersection(clm.rect, fr, 2)) {
          // Se c'e' un intersezione allora devo 
          // - estendere il rect della colonna in modo da coprire tutti e due i campi
          // - inserire il campo nella colonna
          if (fr.l < clm.rect.l)
            clm.rect.l = fr.l;
          if (fr.r > clm.rect.r)
            clm.rect.r = fr.r;
          clm.fields.push(f);
          fnd = true;
          break;
        }
      }
      //
      // Se non ho trovato una colonna che si intersechi con il campo 
      // allora ne aggiungo una
      if (!fnd) {
        cols.push({
          rect: fr,
          fields: [ f ],
          rows: [],
          groups: []
        });
      }
    }
  }
  //
  // Ora i gruppi in form
  nf = row.groups.length;
  for (var i=0; i<nf; i++) {
    var g = row.groups[i];
    //
    // Cerchiamo una colonna in cui infilare il campo: deve sovrapporsi in Orizzontale
    // alle coordinate del campo
    var gr = {
      t: list ? g.ListTop : g.FormTop, 
      b: list ? g.ListTop + g.ListHeight : g.FormTop + g.FormHeight, 
      l: list ? g.ListLeft : g.FormLeft, 
      r: list ? g.ListLeft + g.ListWidth : g.FormLeft + g.FormWidth
    };
    //
    var fnd = false;
    for (var r = 0; r < cols.length; r++) {
      var clm = cols[r];
      if (RD3_Glb.RectIntersection(clm.rect, gr, 2)) {
        // Se c'è un intersezione allora devo 
        // - estendere il rect della colonna in modo da coprire tutto
        // - inserire il gruppo nella colonna
        if (gr.l < clm.rect.l)
          clm.rect.l = gr.l;
        if (gr.r > clm.rect.r)
          clm.rect.r = gr.r;
        clm.groups.push(g);
        fnd = true;
        break;
      }
    }
    //
    // Se non ho trovato una riga che si intersechi con il gruppo 
    // allora ne aggiungo una
    if (!fnd) {
      cols.push({
        rect: gr,
        fields: [],
        rows: [],
        groups: [ g ]
      });
    }
  }
  //
  // Per calcolare il column space (larghezza delle colonne) devo calcolare lo spazio totale occupato,
  // ordinando le colonne per posizione
  cols.sort(function(a, b) {
    var la = a.rect.l;
    var lb = b.rect.l;
    //
    if (la === lb)
      return 0;
    else if (lb > la)
      return -1;
    else
      return 1;
  });
  //
  // Se ho piu' di 12 colonne ne devo accoppiare alcune
  if (cols.length > 12) {
    for (r = 0; r < cols.length; r++) {
      var c1 = cols[r];
      var c2 = cols[r + 1];
      //
      // Unisco i campi ed i gruppi
      c1.fields.concat(c2.fields);
      c1.groups.concat(c2.groups);
      //
      // Estendo la prima colonna a coprire lo spazio occupato dalla seconda (le ho messe in ordine di l, quindi mi devo preoccupare solo del r)
      if (c2.rect.r > c1.rect.r)
        c1.rect.r = c2.rect.r;
      //
      // Rimuovo la seconda colonna e verifico se adesso ne ho 12 o meno, in quel caso ho finito
      cols.splice(r + 1, 1);
      if (cols.length<=12)
        break;
    }
  }
  //
  // Calcolo la larghezza totale occupata dalle colonne (data dallo spazio dei campi)
  // Considero anche il Gutter, di default e' 0, in questo modo lato Inde posso disegnare i campi in maniera semplificata
  // per rendere piu' allineato il disegno un programmatore potrebbe mettere 15/15 come in bootstrap
  var w = 0;
  for (r = 0; r < cols.length; r++)
    w += (cols[r].rect.r - cols[r].rect.l + RD3_ClientParams.GridGutterLeft + RD3_ClientParams.GridGutterRight);
  //
  // Per ogni colonna devo calcolare il suo spazio occupato in proporzione e poi dividerla in righe se contiene piu' campi
  row.cols = cols;
  var leftSpace = 12;
  for (r = 0; r < cols.length; r++) {
    var cdiv = document.createElement("div");
    //
    // Almeno una colonna, poi verifico la larghezza della colonna rispetto allo spazio totale e
    // cerco di distribuire lo spazio vuoto
    var cspace = 1;
    if (leftSpace > 0) {
      // Calcolo la larghezza in proporzione
      var fldSpace = Math.floor(((cols[r].rect.r - cols[r].rect.l + RD3_ClientParams.GridGutterLeft + RD3_ClientParams.GridGutterRight)/w)*12);
      if (fldSpace > 1)
        cspace = fldSpace;
      if (r == cols.length - 1) // L'ultima colonna si prende quello che resta
        cspace = leftSpace;
    }
    leftSpace -= cspace;
    //
    cols[r].cspace = cspace;
    cdiv.className = "col-md-" + cspace;
    row.rdiv.appendChild(cdiv);
    cols[r].cdiv = cdiv;
    //
    // Adesso se una colonna contiene piu' campi/gruppi bisogna dividerla in righe
    if (cols[r].fields.length > 1 || cols[r].groups.length > 1 || (cols[r].fields.length >= 1 && cols[r].groups.length >= 1))
      this.AssignFieldsToRow(cols[r], list);
    else {
      // La colonna contiene un solo campo/gruppo : gli assegno il suo container
      if (cols[r].fields.length === 1)
      {
        if (list)
          cols[r].fields[0].ListGridContainer = cdiv;
        else
          cols[r].fields[0].FormGridContainer = cdiv;
      }
      if (cols[r].groups.length === 1)
      {
        if (list)
          cols[r].groups[0].ListGridContainer = cdiv;
        else
          cols[r].groups[0].FormGridContainer = cdiv;
      }
    }
  }
}

/**
 * Data una colonna la divido in righe
 */
IDPanel.prototype.AssignFieldsToRow = function(col, list)
{
  var rows = [];
  //
  var nf = col.fields.length;
  col.fields.sort(function(a, b) { return list ? a.ListTop - b.ListTop : a.FormTop - b.FormTop; });
  col.groups.sort(function(a, b) { return list ? a.ListTop - b.ListTop : a.FormTop - b.FormTop; });
  for (var i=0; i<nf; i++) {
    var f = col.fields[i];
    //
    if ((!list && f.InForm) || (list && f.InList && !f.ListList)) {
      // Cerchiamo una colonna in cui infilare il campo: deve sovrapporsi in Orizzontale
      // alle coordinate del campo
      var fr = {
        t: list ? f.ListTop : f.FormTop, 
        b: list ? f.ListTop + f.ListHeight :f.FormTop + f.FormHeight, 
        l: list ? f.ListLeft : f.FormLeft, 
        r: list ? f.ListLeft + f.ListWidth : f.FormLeft + f.FormWidth
      };
      //
      var fnd = false;
      for (var r = 0; r < rows.length; r++) {
        var rw = rows[r];
        if (RD3_Glb.RectIntersection(rw.rect, fr, 1)) {
          // Se c'è un intersezione allora devo 
          // - estendere il rect della colonna in modo da coprire tutti e due i campi
          // - inserire il campo nella colonna
          if (rw.rect.t > fr.t)
            rw.rect.t = fr.l;
          if (rw.rect.b < fr.b)
            rw.rect.b = fr.b;
          rw.fields.push(f);
          fnd = true;
          break;
        }
      }
      //
      // Se non ho trovato una riga che si intersechi con il campo 
      // allora ne aggiungo una
      if (!fnd) {
        rows.push({
          rect: fr,
          fields: [ f ],
          cols: [],
          groups: []
        });
      }
    }
  }
  //
  // Ora i gruppi in form
  nf = col.groups.length;
  for (var i=0; i<nf; i++) {
    var g = col.groups[i];
    //
    // Cerchiamo una colonna in cui infilare il campo: deve sovrapporsi in Orizzontale
    // alle coordinate del campo
    var gr = {
      t: list ? g.ListTop : g.FormTop, 
      b: list ? g.ListTop + g.ListHeight : g.FormTop + g.FormHeight, 
      l: list ? g.ListLeft : g.FormLeft, 
      r: list ? g.ListLeft + g.ListWidth : g.FormLeft + g.FormWidth
    };
    //
    var fnd = false;
    for (var r = 0; r < rows.length; r++) {
      var rw = rows[r];
      if (RD3_Glb.RectIntersection(rw.rect, gr, 1)) {
        // Se c'e' un intersezione allora devo 
        // - estendere il rect della colonna in modo da coprire tutto
        // - inserire il gruppo nella colonna
        if (rw.rect.t > gr.t)
          rw.rect.t = gr.l;
        if (rw.rect.b < gr.b)
          rw.rect.b = gr.r;
        rw.groups.push(g);
        fnd = true;
        break;
      }
    }
    //
    // Se non ho trovato una riga che si intersechi con il gruppo 
    // allora ne aggiungo una
    if (!fnd) {
      rows.push({
        rect: gr,
        fields: [],
        cols: [],
        groups: [ g ]
      });
    }
  }
  //
  // Ho definito le righe usando il loro rect, adesso pero' devo riordinarle
  rows.sort(function(a, b) { return (a.rect && b.rect) ? a.rect.t - b.rect.t : 0; });
  //
  // Controllo : ci potrebbero essere campi/gruppi completamente sovrapposti, in quel caso li sposto su due righe differenti
  var r;
  for (r = 0; r < rows.length; r++) {
    var rw = rows[r];
    //
    // Se una riga contiene piu' campi e sono tutti sovrapposti la devo dividere in tante righe
    if (rw.fields.length + rw.groups.length > 1) {
      var cnt = [];
      cnt = cnt.concat(rw.fields);
      cnt = cnt.concat(rw.groups);
      cnt.sort(function(a, b) { return list ? a.ListLeft - b.ListLeft : a.FormLeft - b.FormLeft; });
      //
      var fldIdx;
      var fldIdx2;
      var hasOverlay = false;
      //
      // Per ogni campo controllo se si sovrappone con i campi successivi (il primo lo confronto con tutti, il secondo con quelli dopo e cosi' via)
      for (fldIdx = 0; fldIdx < cnt.length && !hasOverlay; fldIdx++) {
        var o1 = cnt[fldIdx];
        var o1rect = {
          t: list ? o1.ListTop :  o1.FormTop, 
          b: list ? o1.ListTop + o1.ListHeight : o1.FormTop + o1.FormHeight, 
          l: list ? o1.ListLeft : o1.FormLeft, 
          r: list ? o1.ListLeft + o1.ListWidth : o1.FormLeft + o1.FormWidth
        }
        //
        for (fldIdx2 = fldIdx + 1; fldIdx2 < cnt.length && !hasOverlay; fldIdx2++) { 
          var o2 = cnt[fldIdx2];
          var o2rect = {
            t: list ? o2.ListTop : o2.FormTop, 
            b: list ? o2.ListTop + o2.ListHeight : o2.FormTop + o2.FormHeight, 
            l: list ? o2.ListLeft : o2.FormLeft, 
            r: list ? o2.ListLeft + o2.ListWidth : o2.FormLeft + o2.FormWidth
          }
          if (RD3_Glb.RectIntersection(o1rect, o2rect, 2) && RD3_Glb.RectIntersection(o1rect, o2rect, 1))
            hasOverlay = true;
        }
      }
      //
      if (hasOverlay) {
        // Spezzo la riga in tante righe : prima di tutto la devo riordinare in verticale 
        cnt.sort(function(a, b) { return a.FormTop - b.FormTop; });
        //
        //lascio il primo campo in questa riga
        o1 = cnt[0];
        var o1rect = {
          t: list ? o1.ListTop : o1.FormTop, 
          b: list ? o1.ListTop + o1.ListHeight : o1.FormTop + o1.FormHeight, 
          l: list ? o1.ListLeft : o1.FormLeft, 
          r: list ? o1.ListLeft + o1.ListWidth : o1.FormLeft + o1.FormWidth
        }
        //
        rw.fields = [];
        rw.groups = [];
        rw.rect = o1rect;
        if (o1 instanceof PField)
          rw.fields.push(o1);
        else if (o1 instanceof PGroup)
          rw.groups.push(o1);
        //
        // Adesso metto gli altri campi in tante righe da soli
        for (ii = cnt.length - 1; ii > 0; ii--) {
          var o2 = cnt[ii];
          var o2rect = {
            t: list ? o2.ListTop : o2.FormTop, 
            b: list ? o2.ListTop + o2.ListHeight : o2.FormTop + o2.FormHeight, 
            l: list ? o2.ListLeft : o2.FormLeft, 
            r: list ? o2.ListLeft + o2.ListWidth : o2.FormLeft + o2.FormWidth
          }
          var newRow = {
            rect: o2rect,
            fields: [],
            cols: [],
            groups: []
          }
          rows.splice(r + 1, 0, newRow);
          if (o2 instanceof PField)
            newRow.fields.push(o2);
          else if (o2 instanceof PGroup)
            newRow.groups.push(o2);
        }
      }
    }
  }
  //
  // Adesso divido le righe in colonne
  col.rows = rows;
  for (r = 0; r < rows.length; r++) {
    var rdiv = document.createElement("div");
    rdiv.className = "row";
    col.cdiv.appendChild(rdiv);
    rows[r].rdiv = rdiv;
    this.AssignFieldsToColumns(rows[r], list);
  }
};

IDPanel.prototype.RealizeListTable = function()
{
  if (!this.HasList)
    return;
  //
  var n = this.Fields.length;
  var i;
  var pos = 0;
  var hasListFormFields = false;
  //
  for (i=0; i<n; i++) {
    // Ciclo su tutti i campi in lista, imposto la loro dimensione
    var f = this.Fields[i];
    if (this.AdvTabOrder)
      f = this.ListTabOrder[i];
    //
    if (f.InList && f.ListList && !f.IsStatic()) {
      f.ListIndex = pos++;
      f.SetListDimension(f.ListWidth);
      //
      if (f.ListCaptionBox)
        this.ListHeadersRow.appendChild(f.ListCaptionBox);
    }
    if (f.InList && !f.ListList)
      hasListFormFields = true;
  }
  //
  // Se ho dei campi fuori lista chiamo la funzione per creare la loro griglia
  if (hasListFormFields) {
    // Memorizzo che dei campi fuori lista, cosi' non devo fare i cicli per saperlo
    this.hasListFormFields = true;
    this.ListGridRows = [];
    //
    if (this.Pages.length > 0) {
      // Devo realizzere le righe relative alle varie pagine, lo faccio qui spostando temporaneamente la 
      // pagina
      var oldSel = this.PanelPage;
      for (var i=-1; i<this.Pages.length; i++) {
        this.PanelPage = i;
        this.RealizeFormGrid(true);
      }
      this.PanelPage = oldSel;
    }
    else
      this.RealizeFormGrid(true);
  }
};


/**
 * Alline al alarghezza dell'header di lista con quella della lista stessa,
 * tenendo conto della scrollbar
 */
IDPanel.prototype.AlignListHeader = function(ev)
{
  if (!this.HasList)
    return;
  //
  // Se sono nella fase di apertura modale e la lista mi risulta larga 0 provo a usare la larghezza di design time (poi alla fine dell'animazione 
  // verra' tutto riadattato correttamente )
  if (this.WebForm.Modal != 0 && this.WebForm.Realized && this.WebForm.FormBox.style.overflow == "hidden")
    this.ListHeadersTable.style.width = (this.ListRowsTable.clientWidth == 0 ? this.ListWidth : this.ListRowsTable.clientWidth) + "px";
  else {
    if (RD3_Glb.IsBZen() && RD3_Glb.IsChrome() && !RD3_Glb.IsMac() && this.ListRowsTable.clientWidth == this.ListBodyBox.offsetWidth && this.ListRowsTable.offsetHeight >= this.ListBodyBox.offsetHeight)
      this.ListHeadersTable.style.width =  (this.ListRowsTable.clientWidth - 17) + "px";
    else  
      this.ListHeadersTable.style.width =  this.ListRowsTable.clientWidth + "px";
  }
  //
  // Se c'e' la scrollbar orizzontale restringiamo gli header
  if (this.ListHeaderScroller)
    this.ListHeaderScroller.style.display = this.ListBodyBox.scrollWidth > this.ListBodyBox.offsetWidth ? "" : "none";
};


/**
 * Resize della viewport
 */
IDPanel.prototype.OnViewportResize = function()
{
  // Chiamo la classe base
  WebFrame.prototype.OnViewportResize.call(this);
  //
  this.AlignListHeader();
  //
  for (var i = 0; i<this.Fields.length; i++)
    this.Fields[i].OnViewportResize();
};

/**
 * Inizializzaione iniziale per l'apertura della videata
 */
IDPanel.prototype.StartingFormAnimation = function()
{
  // Potrei aver perso un resize, quindi riallineo gli header
  if (this.Realized)
    this.AlignListHeader();
};


/**
 * Aggiorna la grigliatura per la lista ed il dettaglio se necessario
 */
IDPanel.prototype.UpdateFormGrid = function()
{
  if (this.FormGridRows) {
    // Cancello la vecchia grigliatura
    for (var i=0; i < this.FormGridRows.length; i++)
      this.FormGridRows[i].rdiv.parentNode.removeChild(this.FormGridRows[i].rdiv);
    //
    // Creo la nuova grigliatura
    this.FormGridRows = [];
    if (this.Pages.length > 0) {
      // Devo realizzere le righe relative alle varie pagine, lo faccio qui spostando temporaneamente la 
      // pagina
      var oldSel = this.PanelPage;
      for (var i=-1; i<this.Pages.length; i++) {
        this.PanelPage = i;
        this.RealizeFormGrid(false);
      }
      this.PanelPage = oldSel;
    }
    else
      this.RealizeFormGrid(false);
  }
  //
  if (this.ListGridRows) {
    // Cancello la vecchia grigliatura
    for (var i=0; i < this.ListGridRows.length; i++)
      this.ListGridRows[i].rdiv.parentNode.removeChild(this.ListGridRows[i].rdiv);
    //
    // Creo la nuova grigliatura
    this.ListGridRows = [];
    if (this.Pages.length > 0) {
      // Devo realizzere le righe relative alle varie pagine, lo faccio qui spostando temporaneamente la 
      // pagina
      var oldSel = this.PanelPage;
      for (var i=-1; i<this.Pages.length; i++) {
        this.PanelPage = i;
        this.RealizeFormGrid(true);
      }
      this.PanelPage = oldSel;
    }
    else
      this.RealizeFormGrid(true);
  }
  //
  // Dopo aver ricreato tutte le pagine devo nascondere quelle invisibili
  if (this.Pages.length > 0)
    this.SetPanelPage();
}


// ********************************************************************************
// Metodo chiamato quando deve essere modificato il layout della lista:
// sourcefield e' il field tirato o modificato
// targetfield e' il field su cui eseguire il drop
// ********************************************************************************
IDPanel.prototype.ChangeListConfiguration = function(sourcefield, targetfield, evento)
{
  // Non devo fare nulla se:
  // - e' lo stesso campo
  // - il campo source e' quello subito prima di target
  if (sourcefield == targetfield)
    return;
  //
  var i, n;
  if (this.AdvTabOrder)
  {
    if (sourcefield.ListTabOrder == targetfield.ListTabOrder-1)
      return;
  }
  else
  {
    // Devo andare a cercare i campi nell'array dei pfield.. non posso usare l'index perche' se il Tab order non e' avanzato
    // riordino i campi nell'array ma non tocco i loro index..
    var srcidx = -1;
    var taridx = -1;
    //
    n = this.Fields.length;
    for (i = 0; i<n; i++)
    {
      if (this.Fields[i]==sourcefield)
        srcidx = i;
      if (this.Fields[i]==targetfield)
        taridx = i;
    }
    //
    // Esco se non trovo uno dei due campi oppure sono successivi..
    if (srcidx==-1 || taridx==-1 || srcidx==taridx-1)
      return;
  }
  // Gestione gruppi: se i due campi appartengono allo stesso gruppo non c'e' bisogno di fare nulla, altrimenti:
  // - se il campo di destinazione appartiene ad un gruppo applichiamo il drop al primo campo del gruppo (quindi spostiamo il campo trascinato prima del gruppo di destinazione)
  // - se il campo trascinato appartiene ad un gruppo dobbiamo trascinare tutti i campi del gruppo sul campo di destinazione (così spostiamo l'intero gruppo e non lo spezziamo)
  // Lo faccio solo se il gruppo trascinato/destinazione e' visibile (ListHeaderPost != 1)
  if (targetfield.Group && targetfield.Group.ListHeaderPos!=1 && sourcefield.Group !== targetfield.Group) 
  { 
    // Ho trascinato un campo non gruppato o appartenente ad un altro gruppo su un campo di un gruppo: devo prendere il primo campo appartenente al gruppo e considerare quello il 
    // campo di destinazione
    n = this.Fields.length;
    for (i=0; i<n; i++)
    {
      var fg = this.Fields[i];
      if (this.AdvTabOrder)
        fg = this.ListTabOrder[i];
      if (fg.Group == targetfield.Group) {
        targetfield = fg;
        break; 
      }
    }  
  }
  //
  var srcList = [];
  if (sourcefield.Group && sourcefield.Group.ListHeaderPos!=1 && sourcefield.Group !== targetfield.Group) 
  {
    // Se ho trascinato un campo appartenente ad un gruppo su un campo senza gruppo o con un gruppo differente devo 
    // trascinare l'intero gruppo: popolo un array con i campi del gruppo nell'ordine giusto e poi applico il riordinamento
    // su tutti loro
    n = this.Fields.length;
    for (i=0; i<n; i++)
    {
      var fg = this.Fields[i];
      if (this.AdvTabOrder)
        fg = this.ListTabOrder[i];
      if (fg.Group == sourcefield.Group)
        srcList.push(fg);
    }  
  }
  else
    srcList.push(sourcefield);
  //
  for (i = 0; i<srcList.length; i++) 
  {
    // Creo l'evento (che si aggiunge all'elenco se deve)
    var ev = new IDEvent("rdcol", this.Identifier, evento, RD3_Glb.EVENT_ACTIVE, "", srcList[i].Identifier, targetfield.Identifier);
    this.ReorderList(srcList[i], targetfield); 
  }
}


// ********************************************************************************
// Chiamato quando la un campo e' droppato su di un altro: riordina la lista
// di conseguenza
// ********************************************************************************
IDPanel.prototype.ReorderList = function(sourcefield, targetfield)
{
  // Se non sono realizzato non faccio nulla..
  if (!this.Realized || !this.CanReorderColumn)
    return;
  //
  var oldidx = -1;
  var newidx = -1;
  //
  if (this.AdvTabOrder)
  {
    // Tolgo il campo tirato dall'array del taborder
    var n  = this.ListTabOrder.length;
    for (var i = 0; i<n; i++)
    {
      if (sourcefield == this.ListTabOrder[i])
      {
        this.ListTabOrder.splice(i, 1);
        oldidx = i+1;
        break;
      }
    }
    //
    // Adesso rimetto a posto la lista: inserisco il campo tirato prima di quello di destinazione
    n  = this.ListTabOrder.length;
    for (var i = 0; i<n; i++)
    {
      if (targetfield == this.ListTabOrder[i])
      {
        this.ListTabOrder.splice(i, 1, sourcefield, targetfield);
        newidx = i+1;
        break;
      }
    }
    //
    // Adesso devo rimettere a posto gli indici dei tabOrder nei campi
    n  = this.ListTabOrder.length;
    for (var i = 0; i<n; i++)
      this.ListTabOrder[i].ListTabOrder = i;
  }
  else
  {
    // Tolgo il campo tirato dall'array dei campi
    var listFields = this.Fields.slice();
    var n  = listFields.length;
    for (var i = 0; i < n; i++)
    {
      if (sourcefield == listFields[i])
      {
        listFields.splice(i, 1);
        oldidx = i+1;
        break;
      }
    }
    //
    // Adesso rimetto a posto la lista: inserisco il campo tirato prima di quello di destinazione
    n  = listFields.length;
    for (var i = 0; i < n; i++)
    {
      if (targetfield == listFields[i])
      {
        listFields.splice(i, 1, sourcefield, targetfield);
        newidx = i+1;
        break;
      }
    }
    //
    // Attivo il tabOrder avanzato
    n  = listFields.length;
    for (var i = 0; i < n; i++)
    {
      this.Fields[i].FormTabOrder = i;
      listFields[i].ListTabOrder = i;
    }
    //
    this.AdvTabOrder = true;
    this.CompileFieldList();
  }
  //
  // Adesso che ho rimesso a posto la lista devo:
  // - rimettere a posto il ListIndex
  // - spostare la caption in lista
  // - spostare tutte le celle del campo nella nuova posizione
  var n = this.Fields.length;
  var i;
  var pos = 0;
  //
  for (i=0; i<n; i++) {
    var f = this.Fields[i];
    if (this.AdvTabOrder)
      f = this.ListTabOrder[i];
    //
    if (f.InList && f.ListList && !f.IsStatic()) {
      f.ListIndex = pos++;
      if (f.ListCaptionBox)
        this.ListHeadersRow.appendChild(f.ListCaptionBox);
      //
      if (f == sourcefield && f.PListCells) {
        // Per il campo spostato vado a modificare anche le celle
        for (var j=0; j < this.NumRows; j++) {
          var cell = f.PListCells[j];
          if (cell && cell.IntCtrl) {
            if (cell.IntCtrl.parentNode)
              cell.IntCtrl.parentNode.removeChild(cell.IntCtrl);
            cell.appendCellToParent(this.Rows[j]);
          }
        }
      }
    }
  }
  //
  // Se ho lo scroller lo metto in fondo alle caption, in corrispondenza della scrollbar
  if (this.ListHeaderScroller)
    this.ListHeadersRow.appendChild(this.ListHeaderScroller);
}


// ********************************************************************************
// Calcola l'elenco dei campi in caso di advtaborder
// ********************************************************************************
IDPanel.prototype.CompileFieldList = function()
{ 
  if (this.AdvTabOrder)
  {
    this.ListTabOrder = new Array();
    this.FormTabOrder = new Array();
    //
    var n = this.Fields.length;
    for (var i=0; i<n; i++)
    {
      var f = this.Fields[i];
      this.ListTabOrder[f.ListTabOrder] = f;
      this.FormTabOrder[f.FormTabOrder] = f;
    }
  }
}

// *******************************************************************
// Gestisce l'invio al server del mouseOver
// *******************************************************************
IDPanel.prototype.HandleOnMouseOver = function(ev)
{
  var targetEl = ev.target;
  //
  // Primo controllo, se ho gia' un elemento in hover devo verificare che il target non sia suo figlio,
  // in quel caso non mi interessa gestirlo
  if (targetEl && this.MouseOverElement && RD3_Glb.IsNodeChildOf(this.MouseOverElement, targetEl))
    return;
  //
  // Se ho un timer di attivazione e l'elemento su cui sono e' diverso dal vecchio disattivo il timer, il mouseover sul vecchio elemento non mi serve
  if (this.MouseOverTimer && this.MouseOverElement != targetEl)
  {
    window.clearTimeout(this.MouseOverTimer);
    this.MouseOverTimer = null;
  }
  //
  // A questo punto devo verificare se l'elemento su cui sono mi interessa.
  // Mi interessa solo se:
  // -> e' una PCell, quindi risalgo  all'Id del padre e poi cerco l'oggetto di modello, se e' un PValue ho trovato il giusto
  var rd3Obj = RD3_Glb.GetParentRD3Object(targetEl);
  var modelObj = RD3_DDManager.GetObject(rd3Obj ? rd3Obj.id : "", true);
  if (modelObj && modelObj instanceof PValue) {
    this.MouseOverElement = rd3Obj;
    var _this = this;
    this.MouseOverTimer = window.setTimeout(function() {
      var id = _this.MouseOverElement.id;
      var row = id.indexOf(":lv") > 0 ? parseInt(id.substr(id.indexOf(":lv")+3,9999)) : 0;
      var ev = new IDEvent("moev", _this.Identifier, null, _this.MouseOverEventDef, modelObj.ParentField.Index, row);
    }, RD3_ClientParams.MouseOverDelay);
  }
}

// *******************************************************************
// Se il pannello deve mostrare la riga QBE in lista nello stato DATA
// torna il gap da applicare
// *******************************************************************
IDPanel.prototype.GetHeaderSearchOffset = function () {
  if (this.UseListQBE == RD3_Glb.PAN_QBEROW)
    return this.GetRowHeight();
  //
  return 0;
}


/**
* Imposta il flag AlignHeader in maniera ricorsiva su tutti i subframe
*/
IDPanel.prototype.SetAlignHeader = function () {
  this.AlignHeader = true;
  //
  for (var i = 0; i < this.Fields.length; i++)
    if (this.Fields[i].SubFrame && this.Fields[i].SubFrame.Realized && this.Fields[i].SubFrame.SetAlignHeader)
      this.Fields[i].SubFrame.SetAlignHeader();
};

// *******************************************************************
// Chiamato quando cambia il colore di accento
// *******************************************************************
IDPanel.prototype.ListVisibilityCtrlToggleClicked = function (ev, fld) {
  var pthis = this;
  //
  var backcontainer = document.createElement("DIV");
  backcontainer.className = "list-configurator-backdrop";
  var listContainer = document.createElement("DIV");
  listContainer.className = "list-configurator-container";
  backcontainer.appendChild(listContainer);
  //
  // Verifico se devo mostrare il popup di filtro (solo se il campo puo' cercare e sono in PAN_QBEHEADER)
  if (fld && !RD3_Glb.IsMobile() && (this.UseListQBE == RD3_Glb.PAN_QBEHEADER) && this.CanSearch && (fld.QBEEnabled && (fld.IdxPanel <= 0 || (fld.IdxPanel > 0 && (fld.AutoLookup || fld.LKE)))) && (fld.DataType != 10) && (this.Status == RD3_Glb.PS_DATA && !this.DOModified)) {
    var fFilter = document.createElement("DIV");
    fFilter.className = "list-configurator-field-line filter";
    fFilter.textContent = ClientMessages.LFIL_FILTER_CAPT;
    //
    fFilter.onclick = function (ev) {
      backcontainer.click();
      fld.OnClickFilterQBE(ev);
    }
    //
    listContainer.appendChild(fFilter);
  }
  // 
  // Verifico se devo mostrare anche i comandi di ordinamento (se il campo puo' ordinare)
  if (this.CanSort && fld && !RD3_Glb.IsMobile() && (fld.CanSort && fld.VisCanSort())) {
    var fSortUp = document.createElement("DIV");
    fSortUp.className = "list-configurator-field-line sort_down";
    fSortUp.textContent = ClientMessages.LFIL_SORT_DESC;
    listContainer.appendChild(fSortUp);
    //
    var fSortDown = document.createElement("DIV");
    fSortDown.className = "list-configurator-field-line sort_up";
    fSortDown.textContent = ClientMessages.LFIL_SORT_ASC;
    listContainer.appendChild(fSortDown);
    //
    var fSortClear = document.createElement("DIV");
    fSortClear.className = "list-configurator-field-line sort_clear";
    fSortClear.textContent = ClientMessages.LFIL_SORT_CLEAR;
    listContainer.appendChild(fSortClear);
    //
    if (this.GroupingEnabled && this.ShowGroups) {
      var fGroupUp = document.createElement("DIV");
      fGroupUp.className = "list-configurator-field-line group_down";
      fGroupUp.textContent = ClientMessages.LFIL_GROUP_LBL_D;
      listContainer.appendChild(fGroupUp);
      //
      var fGroupDown = document.createElement("DIV");
      fGroupDown.className = "list-configurator-field-line group_up";
      fGroupDown.textContent = ClientMessages.LFIL_GROUP_LBL;
      listContainer.appendChild(fGroupDown);
      //
      var fGroupClear = document.createElement("DIV");
      fGroupClear.className = "list-configurator-field-line group_clear";
      fGroupClear.textContent = ClientMessages.LFIL_DEGROUP_LBL;
      listContainer.appendChild(fGroupClear);
      //
      var groupFn = function (ev) {
        backcontainer.click();
        var ev = new IDEvent("clk", fld.Identifier, ev, fld.ClickEventDef, null, "cap");
        if (RD3_Glb.HasClass(this, "group_up"))
          ev.YPos = 1;
        else if (RD3_Glb.HasClass(this, "group_down"))
          ev.YPos = 30;
        else
          ev.YPos = 2;
        ev.ShiftPress = true;
      };
      fGroupUp.onclick = groupFn;
      fGroupDown.onclick = groupFn;
      fGroupClear.onclick = groupFn;
    }
    //
    var sortFn = function (ev) {
      backcontainer.click();
      var ev = new IDEvent("clk", fld.Identifier, ev, fld.ClickEventDef, null, "cap");
      if (RD3_Glb.HasClass(this, "sort_up"))
        ev.YPos = 10;
      else if (RD3_Glb.HasClass(this, "sort_down"))
        ev.YPos = 20;
      else
        ev.CtrlPress = true;
      ev.ShiftPress = true;
    };
    fSortUp.onclick = sortFn;
    fSortDown.onclick = sortFn;
    fSortClear.onclick = sortFn;
  }
  //
  for (var i = 0; i < this.Fields.length; i++) {
    var f = this.Fields[i];
    if (this.AdvTabOrder)
      f = this.ListTabOrder[i];
    //
    if (f.InList && f.ListList && f.Visible && f.CanHideInList()) {
      var fLine = document.createElement("DIV");
      fLine.className = "list-configurator-field-line" + (!f.HiddenInList() ? " inlist" : " notlist");
      //
      fLine.linkedField = f;
      fLine.innerHTML = RD3_Glb.HandleIconString(f.ListHeader);
      //
      fLine.onclick = function (ev) {
        ev.stopPropagation();
        //
        // Se io sono visibile in lista e il primo elemento della lista e' uguale all'ultimo signifa che sono l'unico campo visibile della lista
        // in questo caso non mi posso nascondere perche' altrimenti non ci sarebbe modo di rimostrare altri campi
        if (!this.linkedField.HiddenInList() && this.linkedField.ParentPanel.GetFirstListField() == this.linkedField.ParentPanel.GetLastListField())
          return;
        //
        this.linkedField.SetVisualFlags((this.linkedField.VisualFlags & (~0x00002000)) | (!this.linkedField.HiddenInList() ? 0x00002000 : 0));
        RD3_Glb.RemoveClass2(this, "inlist");
        RD3_Glb.RemoveClass2(this, "notlist");
        RD3_Glb.AddClass(this, !this.linkedField.HiddenInList() ? " inlist" : " notlist");
        //
        var ev = new IDEvent("fldlistvis", this.linkedField.Identifier, null, RD3_Glb.EVENT_DEFERRED, this.linkedField.Identifier, (this.linkedField.HiddenInList() ? "-1" : "0"));
      }
      //
      listContainer.appendChild(fLine);
    }
  }
  //
  document.body.appendChild(backcontainer);
  //
  // Lo posiziono
  var rootEl = fld.ListCaptionBox;
  if (listContainer.offsetWidth >= rootEl.offsetWidth)
    listContainer.style.left = (RD3_Glb.GetScreenLeft(rootEl)) + "px";
  else
    listContainer.style.left = ev.clientX + "px";
  listContainer.style.top = (RD3_Glb.GetScreenTop(rootEl) + rootEl.offsetHeight + 5) + "px";
  if (listContainer.offsetTop + listContainer.offsetHeight >= document.body.offsetHeight)
    listContainer.style.top = (listContainer.offsetTop - (listContainer.offsetTop + listContainer.offsetHeight - document.body.offsetHeight)) + "px";
  if (listContainer.offsetLeft + listContainer.offsetWidth >= document.body.offsetWidth)
    listContainer.style.left = (listContainer.offsetLeft - (listContainer.offsetLeft + listContainer.offsetWidth - document.body.offsetWidth + 4)) + "px";
  //
  listContainer.onclick = function (ev) { ev.stopPropagation(); };
  backcontainer.onclick = function () {
    this.parentNode.removeChild(this);
    //
    // Stacco i riferimenti agli oggetti javascript (evitiamo problemi di memoria)
    for (var cc = 0; cc < this.childNodes; cc++)
      delete this.childNodes[cc].linkedField;
    //
    // Aggiorno la lista con le nuove impostazioni
    for (var j = 0; j < pthis.Fields.length; j++)
      pthis.Fields[j].UpdateFieldVisibility();
    pthis.SetActualPosition(undefined, undefined, pthis.ScrollToPos && !pthis.DenyScroll);
    pthis.ResetPosition = false;
    pthis.RecalcLayout = false;
    //
    // Mando al server le nuove impostazioni
    if (RD3_DesktopManager.MessagePump)
      RD3_DesktopManager.MessagePump.SendEvents();
  }
}

IDPanel.prototype.SetAllowMasterPanelNavigation = function(value)
{
  this.AllowMasterPanelNavigation = value;
}

IDPanel.prototype.CanNavigate = function ()
{
  return this.Status == RD3_Glb.PS_DATA && (this.AllowMasterPanelNavigation || !this.DOMaster || !this.DOModified);
}
