// ************************************************
// Nord Est Systemls S.r.l.
// (c) 2020 - Customizzazioni per RD3 Framework for Bootstrap
// 
// Elenco dei metodi modificati
// Aggiornato al:		21.09.2021
// [=] WebEntryPoint.prototype.OnResize (L'apertura della tastiera su Android era gestita male e la tastiera scompariva immediatamente)
// [=] WebForm.prototype.Realize
// [=] WebForm.prototype.AttachToolbar
//
// ************************************************

// Ritardo l'apparizione di "Attendere prego..." - il default è 1500 ms, mettiamo 3000 intanto
function RD3_CustomInit()
{
RD3_ClientParams.DelayDlgTime = 3000; // Tempo in ms prima di aprire la progress bar bloccante
// adding favicon
var favicon = document.createElement("link");
favicon.setAttribute("rel", "shortcut icon");
favicon.setAttribute("href", "images/favicon.ico");
document.getElementsByTagName("head")[0].appendChild(favicon);
}


WebEntryPoint.prototype.CustomizeHeader = function (parent)
{
	rightHeaders = parent.getElementsByClassName("navbar-header pull-right");
	rightHeader = rightHeaders[0];
	RD3_Glb.RemoveClass(rightHeader, "pull-right");
	rightHeader = rightHeaders[1];
	RD3_Glb.RemoveClass(rightHeader, "pull-right");
}


WebEntryPoint.prototype.OnResize = function (evento)
{
  // Devo gestire in modo particolare la tastiera
  if (RD3_Glb.IsAndroid()) {
    // Se ho le dimensioni impostate significa che la tastiera si e' aperta, in questo caso se il resize
    // porta ad una videata più alta dell'ultimo resize signifca che si è chiusa la tastiera:
    // in questo caso togliamo le dimensioni impostate
	// ********************************************************
	//
	// Abbiamo visto che a volte arriva un resize spurio, in cui arriva l'altezza piu' alta di 30-40 px ma la testiera rimane comunque aperta...
	//
	// && (window.innerHeight - window.lastHeight > 100) aggiunto nella riga qui sotto in assistenza 001196-2021 del 29/04/2021
    if (document.body.style.width != "" && document.body.style.height != "" && window.innerHeight > window.lastHeight && (window.innerHeight - window.lastHeight > 100)) {
      document.body.style.width = "";
      document.body.style.height = "";
      document.body.style.transform = "";
      // 
      // Togliamo il fuoco all'elemento attivo
      if (document.activeElement && document.activeElement.blur)
        document.activeElement.blur();  
    }
    //
    // Ho le dimensioni impostate, un oggetto con il fuoco e l'altezza si è ridotta :
    // si è aperta la tastiera! In questo caso ho tutte le informzioni sufficienti per portare a video il campo con il fuoco
    if (document.activeElement && document.body.style.width != "" && document.body.style.height != "" && window.innerHeight < window.lastHeight) {
      var top = document.activeElement.getBoundingClientRect().top;
      if (window.currentHeight - top < window.innerHeight)
        top = top - (window.currentHeight - window.innerHeight);
      document.body.style.transform = "translate3d(0px, -"+top+"px, 0px)";
    }
    //
    // Current mi servono per fissare le dimensioni della pagina all'apertura della tastiera,
    // last mi serve per capire se la tastiera si e' aperta o chiusa
    if (document.body.style.width == "" && document.body.style.height == "") {
      window.currentHeight = window.innerHeight;
      window.currentWidth = window.innerWidth;
    }
    //
    window.lastHeight = window.innerHeight;
    window.lastWidth = window.innerWidth;
  }
  //
  // Resize, chiudo anche i popup aperti che potrebbero andare fuori posto
  this.CmdObj.ClosePopup();
  //
  // Eseguo il resize ritardato
  if (this.ResizeTimerId > 0)
    window.clearTimeout(this.ResizeTimerId);
  this.ResizeTimerId = window.setTimeout("RD3_DesktopManager.WebEntryPoint.TickResize()", 200);
}





// ********************************************************************************
// Prende un CommandSet di tipo 
// ********************************************************************************
WebForm.prototype.AttachToolbar= function(cmd)
{
  if (!cmd.MyToolBox)
    return;
  //
  if (cmd.MyToolBox.parentNode)
  {
    // La toolbar fa gia' parte della mia caption: non c'e' bisogno che me la riprenda...
    if (cmd.MyToolBox.parentNode == this.CaptionBox)
      return;
    //
    // Stacco la toolbar dal contenitore precedente
    cmd.MyToolBox.parentNode.removeChild(cmd.MyToolBox);
  }
  //
  // In base al tipo di toolbar, vediamo dove metterla
  switch(this.ToolbarPosition)
  {
    case RD3_Glb.FORMTOOL_NONE:
    case RD3_Glb.FORMTOOL_LEFT:
    case RD3_Glb.FORMTOOL_DISTRIB:
      this.CaptionBox.appendChild(cmd.MyToolBox);
	  //######START CUSTOM CODE##########
	  //I always want commands on the right
	  RD3_Glb.AddClass(cmd.MyToolBox, "pull-right");
	  //######END CUSTOM CODE##########
	break;
    
    case RD3_Glb.FORMTOOL_RIGHT:
      this.CaptionBox.appendChild(cmd.MyToolBox);
	  //######START CUSTOM CODE##########
	  if (cmd.MyToolBox.className.indexOf("pull-right") != -1) {
		 RD3_Glb.RemoveClass(cmd.MyToolBox, "pull-left");
		RD3_Glb.AddClass(cmd.MyToolBox, "pull-right");
	  } else {
		RD3_Glb.RemoveClass(cmd.MyToolBox, "pull-right");
		RD3_Glb.AddClass(cmd.MyToolBox, "pull-left");
	  }
	  //######END CUSTOM CODE##########
    break;
  }
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
WebForm.prototype.Realize = function()
{
  // Calcolo dove dovro' inserire questa form
  var parent;
  var _this = this;
  var mob = RD3_Glb.IsMobile();
  var mob7 = RD3_Glb.IsMobile7();
	//
  if (this.SubFormObj)
  {
    if (this.SubFormObj instanceof SubForm)
      parent = this.SubFormObj.ContentBox;
    else if (this.SubFormObj instanceof BookBox)
      parent = this.SubFormObj.BoxBox;
  }
  else
    parent = RD3_DesktopManager.WebEntryPoint.FormsBox;
  //
  // Gestione apertura finestra modale
  if (this.Modal)
  {
    this.PopupFrame = new PopupFrame(this);
    //
    if (this.Modal == 2)
      this.PopupFrame.AutoClose = true;
    //
    this.PopupFrame.HasCaption = false;
    this.PopupFrame.Realize(this.Modal==2?"-popover":"-modal");
    parent = this.PopupFrame.ContentBox;
    //
    var addLg = true;
    if (this.ClassName && this.ClassName.indexOf("modal-sm") != -1) 
    {
      RD3_Glb.AddClass(this.PopupFrame.PopupDialog, "modal-sm");
      addLg = false;
    }
    else if (this.ClassName && this.ClassName.indexOf("modal-md") != -1)
      addLg = false;
	//######START CUSTOM CODE##########
	else if (this.ClassName && this.ClassName.indexOf("modal-xlg") != -1){
		RD3_Glb.AddClass(this.PopupFrame.PopupDialog, "modal-xlg");
		addLg = false;
	}
	//######END CUSTOM CODE##########
    if (addLg)
      RD3_Glb.AddClass(this.PopupFrame.PopupDialog, "modal-lg");
  }
  //
  if (this.Docked)
  {
    if (this.DockType==RD3_Glb.FORMDOCK_LEFT)
      parent = RD3_DesktopManager.WebEntryPoint.LeftDockedBox;
    if (this.DockType==RD3_Glb.FORMDOCK_TOP)
      parent = RD3_DesktopManager.WebEntryPoint.TopDockedBox;
    if (this.DockType==RD3_Glb.FORMDOCK_RIGHT)
      parent = RD3_DesktopManager.WebEntryPoint.RightDockedBox;
    if (this.DockType==RD3_Glb.FORMDOCK_BOTTOM)
      parent = RD3_DesktopManager.WebEntryPoint.BottomDockedBox;
    //
    // Devo far scattare l'aggiornamento dei comandi (per mostrare le mie toolbar) solo
    // se io non sono la form attiva, dato che in quel caso scatterebbe automaticamente
    var actf = RD3_DesktopManager.WebEntryPoint.ActiveForm;
    if (!actf || (actf && actf.IdxForm != this.IdxForm))
      RD3_DesktopManager.WebEntryPoint.RefreshCommands = true;
  }
  //
  // Realizzo i miei oggetti visuali
  // Creo il mio contenitore globale
  this.FormBox = document.createElement("div");
  this.FormBox.setAttribute("id", this.Identifier);
  this.FormBox.className = "panel panel-default form-main-box";
  //
  // Creo la box per i frames
  this.FramesBox = document.createElement("div");
  this.FramesBox.setAttribute("id", this.Identifier+":frs");
  this.FramesBox.className = "panel-body form-body"+ (this.ResModeH === RD3_Glb.FRESMODE_NONE ? " form-body-fluid" : "");
  //
  // Creo la lista dei messaggi
  this.MessagesBox = document.createElement("div");
  this.MessagesBox.setAttribute("id", this.Identifier+":msg");
  this.MessagesBox.className = "form-message-container";
  //
  // Creo la box della caption
  var cptBox = document.createElement("div");
  cptBox.className = "panel-heading form-caption";
  //
  this.CaptionBox = document.createElement("h3");
  this.CaptionBox.setAttribute("id", this.Identifier+":cap");
  this.CaptionBox.className = "panel-title clearfix";
  cptBox.appendChild(this.CaptionBox);
  //
  // INIZIO GESTIONE TOOLBAR
  if (this.HasCloseButton())
  {
    this.CloseBtn = document.createElement("a");
    this.CloseBtn.setAttribute("id", this.Identifier+":clo");
    this.CloseBtn.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_CLOSE, "fa-lg"));
    this.CloseBtn.className = "panel-caption-image";
    RD3_TooltipManager.SetObjTitle(this.CloseBtn, RD3_ServerParams.ChiudiForm + RD3_KBManager.GetFKTip(RD3_ClientParams.FKCloseForm), null, "auto right");
    this.CloseBtn.onclick = function(ev) {
      _this.OnClose(ev);
    };
  }
  //
  if (this.HasIcon())
  {
    this.ImgIcon = document.createElement("img");
    this.ImgIcon.setAttribute("id", this.Identifier+":ico");
    this.ImgIcon.className = "panel-caption-image";
    this.ImgIcon.ondblclick = function(ev) {
      _this.OnClose(ev);
    };
  }  
  //
  if (this.Modal)
  {
    if (this.HasConfirmButton())
    {
      this.ConfirmBtn = document.createElement("a");
      this.ConfirmBtn.setAttribute("id", this.Identifier+":con");
      this.ConfirmBtn.className = "panel-caption-image";
      this.ConfirmBtn.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_CONFIRM, "fa-lg"));
      RD3_TooltipManager.SetObjTitle(this.ConfirmBtn, RD3_ServerParams.ModalConfirm);
      this.ConfirmBtn.onclick = function(ev) {
        _this.OnConfirm(ev);
      };
    }
    //
    if (this.HasHelpButton())
    {
      this.HelpBtn = document.createElement("a");
      this.HelpBtn.setAttribute("id", this.Identifier+":hlp");
      this.HelpBtn.className = "panel-caption-image";
      this.HelpBtn.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_HELP, "fa-lg"));
      this.HelpBtn.onclick = function(ev) {
        RD3_DesktopManager.WebEntryPoint.OnHelpButton(ev);
      };
    }
    //
    if (this.HasDebugButton())
    {
      this.DebugBtn = document.createElement("a");
      this.DebugBtn.setAttribute("id", this.Identifier+":dbg");
      this.DebugBtn.className = "panel-caption-image";
      this.DebugBtn.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_DEBUG, "fa-lg"));
      this.DebugBtn.onclick = function(ev) {
        RD3_DesktopManager.WebEntryPoint.OnDebug(ev);
      };
    }
  }
  //
  // Ecco il testo  
  this.CaptionTxt = document.createElement("span");  
  //
  // Aggiungo gli oggetti al DOM
  this.RealizeToolbar();
  //
  this.FormBox.appendChild(cptBox);
  //
  //this.FormBox.appendChild(this.MessagesBox);
  this.FormBox.appendChild(this.FramesBox);
  this.RealizeFormList();
  //
  // Realizzo i frames... devo farlo seguendo la gerarchia.
  if (this.Frames[0])
   this.Frames[0].Realize(this.FramesBox);
  //
  // Realizzo i messaggi
  this.RealizeMessages();
  //
  // Eseguo l'impostazione iniziale delle mie proprieta' (quelle che cambiano l'aspetto visuale)
  this.Realized = true;
  this.SetImage();
  this.SetCaption();
  this.SetWebCaption();
  this.SetVisible();
  this.SetWindowState();
  this.SetFormLeft(null, true);   // In questo caso devo far saltarre l'animazione!
  this.SetFormTop(null, true);
  this.SetFormWidth(null, true);
  this.SetFormHeight(null, true);
  this.SetBackButtonText();
  this.SetClassName();
  //
  // SOLO alla fine attacco la form al DOM,
  // cosi' si fa prima
  parent.appendChild(this.FormBox);
  //
  // Ora che ho la form a video posso impostare la griglia
  this.CalcGridLayout();
  if (this.Modal) {
    if (this.FormHeight!=-1) 
      this.PopupFrame.SetHeight(this.FormHeight);
    else if (!RD3_Glb.IsBZen())
      this.PopupFrame.SetHeight(this.Frames[0].CalcHeight(true) + 70); // altezza caption + padding (15/15)
    else {
      // Se il contenuto e' piu' alto del massimale bootstrap (maxH-120px) oppure il contenuto non ha altezze esplicite 
      // fisso l'altezza alla massima altezza consentita da bootstrap
      // (solo BZEN)
      var hh = this.Frames[0].CalcHeight(true) + 70;
      if (hh > window.innerHeight - 122 || this.ResModeH != RD3_Glb.FRESMODE_NONE)
        this.PopupFrame.SetHeight(window.innerHeight - 122);
    }
    this.FormBox.style.height = "100%";
    this.PopupFrame.Open();
  }
}


//################################
// NES Custom code to have a right menu BOx for the UserMenu
// This is obtained adding a RightSideMenuBox object SetRefreshLocation
// works as a second navbar
//################################

// ********************************************************************************
// Questa funzione crea gli oggetti DOM per il WEP
// ********************************************************************************
WebEntryPoint.prototype.RealizeWep = function (parent)
{
  var _this = this;
  //
  // Creo il div globale del wep
  // Questo e' il div grande come tutta la pagina
  this.WepBox = document.createElement("div");
  this.WepBox.setAttribute("id", this.Identifier);
  this.WepBox.className = RD3_ClientParams.BodyContainerType;
  this.WepBox.style.visibility = "hidden";
  //
  // Creo il div destinato a contenere l'header
  // L'header e' posizionato in alto
  this.HeaderBox = document.createElement("nav");
  this.HeaderBox.setAttribute("id", "header-container");
  this.HeaderBox.className = "navbar navbar-default";
  //
  // Creo il div destinato a contenere il menu
  if (this.HasSideMenu()) {
    this.SideMenuBox = document.createElement("div");
    this.SideMenuBox.setAttribute("id", "sidebar");
    this.SideMenuBox.className = "sidebar-offcanvas";
    if (this.SideMenuWidth > 0)
      this.SideMenuBox.style.width = this.SideMenuWidth + "px";
    //
    // Creo il contenitore del menu
    this.MenuBox = document.createElement("div");
    this.MenuBox.setAttribute("id", "menu-accordion");
    this.MenuBox.className = "panel-group";
    this.SideMenuBox.appendChild(this.MenuBox);
  }
  else {
    this.SideCollapseContainer = document.createElement("div");
    this.SideCollapseContainer.className = "navbar-collapse";
    this.SideCollapseContainer.setAttribute("id", "navbar-collapse-menu");
    this.SideMenuBox = document.createElement("ul");
    this.SideMenuBox.className = "nav navbar-nav navbar-left";
    this.SideCollapseContainer.appendChild(this.SideMenuBox);

 //########START CUSTOM CODE#############
    this.RightSideMenuBox = document.createElement("ul");
    this.RightSideMenuBox.className = "nav navbar-nav navbar-right";
    this.RightSideMenuBox.setAttribute("id", "right-navbar");
    this.SideCollapseContainer.appendChild(this.RightSideMenuBox);

    this.companyUL = document.createElement("ul");
    this.companyUL.className = "nav navbar-right";
    this.SideCollapseContainer.appendChild(this.companyUL);
    this.companyLI = document.createElement("li");
    this.companyUL .appendChild(this.companyLI);
    this.companyLI.setAttribute("id", "companyPlaceholder");
	this.helpUL = document.createElement("ul");
    this.helpUL.className = "nav navbar-right";
    this.SideCollapseContainer.appendChild(this.helpUL);
    this.helpLI = document.createElement("li");
    this.helpUL .appendChild(this.helpLI);
    this.helpLI.setAttribute("id", "helpPointer");
 //#######END CUSTOM CODE##############
  }
  //
  // Creo la grigliatura con la struttura della pagina
  var mainRow = document.createElement("div");
  mainRow.setAttribute("id", "wep-main-row");
  mainRow.className = "row" + (this.HasSideMenu() ? " row-offcanvas" : "");
  //
  this.MainGridContainer = document.createElement("div");
  this.MainGridContainer.setAttribute("id", "wep-main-container");
  if (this.HasSideMenu()) {
    this.MainGridContainer.className = "col-sm-12 main-side-" + (this.MenuType == RD3_Glb.MENUTYPE_LEFTSB ? "left" : "right");
    if (this.SideMenuWidth > 0) {
      if (this.MenuType == RD3_Glb.MENUTYPE_LEFTSB)
        this.MainGridContainer.style.paddingLeft = (this.SideMenuWidth + 30) + "px";
      else
        this.MainGridContainer.style.paddingRight = (this.SideMenuWidth + 30) + "px";
    }
  }
  else
    this.MainGridContainer.className = "col-xs-12 col-sm-12 col-md-12";
  mainRow.appendChild(this.MainGridContainer);
  //
  if (this.HasSideMenu()) {
    mainRow.className += " row-offcanvas-" + (this.MenuType == RD3_Glb.MENUTYPE_LEFTSB ? "left" : "right");
    if (this.MenuType == RD3_Glb.MENUTYPE_RIGHTSB)
      mainRow.appendChild(this.SideMenuBox);
    else
      mainRow.insertBefore(this.SideMenuBox, this.MainGridContainer);
  }
  //
  // Creata la struttura principale per il menu e la main area creo la grigliatura per le docked e la MainForm
  // Griglia base : 3 righe
  var gridRow1 = document.createElement("div");
  gridRow1.className = "row";
  this.MainGridRow2 = document.createElement("div");
  this.MainGridRow2.className = "row main-grid-row";
  var gridRow3 = document.createElement("div");
  gridRow3.className = "row";
  this.MainGridContainer.appendChild(gridRow1);
  this.MainGridContainer.appendChild(this.MainGridRow2);
  this.MainGridContainer.appendChild(gridRow3);
  //
  // Nella prima riga va creato il container delle docked superiori
  this.TopDockedBox = document.createElement("div");
  this.TopDockedBox.className = "col-xs-12 col-sm-12 col-md-12";
  this.TopDockedBox.setAttribute("id", "wep-top-docked-container");
  gridRow1.appendChild(this.TopDockedBox);
  //
  // Nella seconda riga vanno inseriti i container delle videate docked destra, sinistra e centrale
  // In AdaptLayout vengono modificate le classi e nascoste in base al contenuto
  this.LeftDockedBox = document.createElement("div");
  this.LeftDockedBox.className = "col-xs-12 col-sm-3 col-md-3";
  this.LeftDockedBox.setAttribute("id", "wep-left-docked-container");
  this.RightDockedBox = document.createElement("div");
  this.RightDockedBox.className = "col-xs-12 col-sm-3 col-md-3";
  this.RightDockedBox.setAttribute("id", "wep-right-docked-container");
  this.FormsBox = document.createElement("div");
  this.FormsBox.className = "col-xs-12 col-sm-4 col-md-4"
  this.FormsBox.setAttribute("id", "wep-main-forms-container");
  this.MainGridRow2.appendChild(this.LeftDockedBox);
  this.MainGridRow2.appendChild(this.FormsBox);
  this.MainGridRow2.appendChild(this.RightDockedBox);
  //
  // Nella terza riga mettiamo il contenitore delle docked inferiori
  this.BottomDockedBox = document.createElement("div");
  this.BottomDockedBox.className = "col-xs-12 col-sm-12 col-md-12";
  this.BottomDockedBox.setAttribute("id", "wep-bottom-docked-container");
  gridRow3.appendChild(this.BottomDockedBox);
  //
  // Creo l'iframe per la welcome page
  // Protezione per applicazioni embeddate dentro Inde.. noi forziamo la compatibilita' ad IE7 in quel caso, eppure le righe di codice sotto
  // non funzionano (non si sa perche')... quindi se sono fallite non facciamo uscire l'eccezione e proviamo nell'altro modo
  var done = false;
  try
  {
    if (RD3_Glb.IsIE(10, false))
    {
      this.WelcomeBox = document.createElement("<iframe id='welcome-container' frameBorder='0' onload='RD3_DesktopManager.WebEntryPoint.OnWelcomeBoxLoad();'></iframe>");
      done = true;
    }
  }
  catch (ex) {
  }
  //
  if (!done)
  {
    this.WelcomeBox = document.createElement("iframe");
    this.WelcomeBox.setAttribute("id", "welcome-container");
    this.WelcomeBox.frameBorder = 0;
    this.WelcomeBox.onload = new Function("RD3_DesktopManager.WebEntryPoint.OnWelcomeBoxLoad();");
  }
  //
  // Aggiungo i div al dom nell'ordine corretto
  document.body.appendChild(this.HeaderBox);
  this.WepBox.appendChild(mainRow);
  //
  if (this.WelcomeBox)
    this.FormsBox.appendChild(this.WelcomeBox); // Deve essere il primo cosi' appare solo se non ci sono form aperte
  //
  // Gestione del resize
  var rf = function (ev) {
    _this.OnResize(ev);
  };
  if (window.addEventListener)
    window.addEventListener("resize", rf, false);
  else
    window.onresize = rf;
  //
  // Nel mobile il resize non e' sempre lanciato, ma l'orientation change si'
  if (RD3_Glb.IsTouch()) {
    window.addEventListener("orientationchange", rf, false);
    //
    if (RD3_Glb.IsAndroid()) {
      window.addEventListener("orientationchange", function() {
        // Ho cambiato l'orientamento, potrebbe dipendere da:
        // - apertura tastiera
        // - rotazione
        // nel secondo caso devo aggiornare la dimensione della width e della height a quelle correnti
        // così quando aprirò la tastiera (focus) posso fissarle.
        // mi memorizzo le dimensioni se non sono fissate nello style del body (in quel caso significa che c'è la tastiera aperta, perchè
        // nel blur le tolgo..)
        if (document.body.style.width == "" && document.body.style.height == "")
          window.setTimeout(function() {
            window.currentHeight = window.innerHeight;
            window.currentWidth = window.innerWidth;
          }, 250);
      }, false);
      //
      // Impostazione valori iniziali
      window.currentHeight = window.innerHeight;
      window.currentWidth = window.innerWidth;
    }
  }
  //
  var cf = function (ev) {
    _this.OnClick(ev);
  };
  this.WepBox.onclick = cf;
  //
  var uf = function (ev) {
    _this.OnBeforeUnload(ev);
  };
  if (document.body.addEventListener)
    document.body.addEventListener("beforeunload", uf, false);
  else
    document.body.onbeforeunload = uf;
  //
  // Adesso il frame per il caricamento dei blob
  // Protezione per applicazioni embeddate dentro Inde.. noi forziamo la compatibilita' ad IE7 in quel caso, eppure le righe di codice sotto
  // non funzionano (non si sa perche')... quindi se sono fallite non facciamo uscire l'eccezione e proviamo nell'altro modo
  var done = false;
  try
  {
    if (RD3_Glb.IsIE(10, false))
    {
      this.BlobFrame = document.createElement("<iframe name='blobframe' onload='RD3_DesktopManager.WebEntryPoint.OnBlobUpload();'></iframe>");
      done = true;
    }
  }
  catch (ex) {
  }
  //
  if (!done)
  {
    this.BlobFrame = document.createElement("iframe");
    this.BlobFrame.setAttribute("id", "blobframe");
    this.BlobFrame.setAttribute("name", "blobframe");
    this.BlobFrame.onload = new Function("RD3_DesktopManager.WebEntryPoint.OnBlobUpload();");
  }
  //
  this.BlobFrame.style.display = "none";
  this.BlobFrame.src = "about:blank";
  document.body.appendChild(this.BlobFrame);
  //
  // Gestisco la FormList
  if (this.HasSideMenu())
  {
    // Creo la FormList
    this.FormListBox = document.createElement("div");
    this.FormListBox.setAttribute("id","form-list-box-container");
    this.FormListBox.className = "panel panel-default";
    //
    // Creo il div per la testata
    this.FormListHeader = document.createElement("div");
    this.FormListHeader.className = "panel-heading has-pointer";
    this.FormListHeader.setAttribute("data-toggle", "collapse");
    //this.FormListHeader.setAttribute("data-parent", "#menu-accordion");
    this.FormListHeader.setAttribute("data-target", "#form-list-entry-container");
    this.FormListBox.appendChild(this.FormListHeader);
    //
    var formListTitle = document.createElement("h4");
    formListTitle.className = "panel-title";
    this.FormListHeader.appendChild(formListTitle);
    //
    this.FormListLink = document.createElement("div");
    this.FormListLink.textContent = RD3_ServerParams.VideateAperte;
    formListTitle.appendChild(this.FormListLink);
    //
    // Creo il box che conterra' l'elenco
    this.FormsListCollapsePanel = document.createElement("div");
    this.FormsListCollapsePanel.setAttribute("id", "form-list-entry-container");
    this.FormsListCollapsePanel.className = "panel-collapse collapse in";
    this.FormListBox.appendChild(this.FormsListCollapsePanel);
    //
    this.FormsListCollapsePanelBody = document.createElement("div");
    this.FormsListCollapsePanelBody.className = "panel-body";
    this.FormsListCollapsePanel.appendChild(this.FormsListCollapsePanelBody);
    //
    var ptable = document.createElement("table");
    ptable.className = "table";
    this.FormsListCollapsePanelBody.appendChild(ptable);
    //
    this.FormsListBodyBox = document.createElement("tbody");
    ptable.appendChild(this.FormsListBodyBox);
    //
    this.RealizeCloseAll(this.FormsListBodyBox);
    //
    // E l'aggiungo al side menu box
    this.SideMenuBox.appendChild(this.FormListBox);
  }
}

// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
WebEntryPoint.prototype.Realize = function (parent)
{
  // Creo i miei oggetti visuali
  this.RealizeWep(parent);
  this.RealizeHeader(this.HeaderBox);
  //
  // A questo punto devo cominciare a fare realizzare i miei figli
  this.VSList.Realize();
  //######START CUSTOM CODE##########
  for(var j = this.CmdObj.CommandSets.length - 1; j>=0 ;j--){
    if (this.CmdObj.CommandSets[j].ClassName.indexOf("right-commandset") != -1)
    {
      let rightObject =this.CmdObj.CommandSets.splice(j,1)[0];
      rightObject.Realize(this.HasSideMenu() ? this.MenuBox : this.RightSideMenuBox, this.RightHeaderCommandsList);
    }
  }
  //#####END CUSTOM CODE#############
  this.CmdObj.Realize(this.HasSideMenu() ? this.MenuBox : this.SideMenuBox, this.RightHeaderCommandsList);
  this.TimerObj.Realize();
  this.VoiceObj.Realize();
  //
  var ns = this.ScreenZones.length;
  for (var t = 0; t < ns; t++)
    this.ScreenZones[t].Realize();
  //
  // Anche le form aperte devono essere realizzate
  var n = this.StackForm.length;
  for (var i = 0; i < n; i++)
  {
    if (!this.StackForm[i].Modal)
      this.StackForm[i].Realize();
  }
  //
  // Eseguo l'impostazione iniziale delle mie proprieta'
  this.Realized = true;
  this.SetMainCaption();
  this.SetMainImage();
  this.SetHelpFile();
  this.SetDebugType();
  this.SetCmdPrompt();
  this.SetRefreshInterval();
  this.SetWidgetMode();
  this.SetWelcomePage();
  this.SetShowLogoff();
  this.SetSideMenuWidth();
  this.SetRefreshLocation();
  this.SetMotionThreshold();
  this.SetVisualFlags();
  //
  // Al termine della realizzazione aggiungo tutto al DOM
  parent.appendChild(this.WepBox);
  //
  // Solo ora realizzo le form modali
  var n = this.StackForm.length;
  for (var i = 0; i < n; i++)
  {
    if (this.StackForm[i].Modal)
      this.StackForm[i].Realize();
  }
  //
  if (this.ActiveForm == null)
    this.ActiveForm = this.GetLastForm();
  //
  this.ActivateForm(this.ActiveForm);
  this.RecalcLayout = true;
}

// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
WebEntryPoint.prototype.Unrealize = function ()
{
  // Tolgo gli eventi motion
  if (window.removeEventListener)
  {
    window.removeEventListener("devicemotion", RD3_DeviceMotion);
    window.removeEventListener("deviceorientation", RD3_DeviceOrientation);
  }
  //
  // Tolgo WepBox dal DOM
  this.WepBox.parentNode.removeChild(this.WepBox);
  //
  // Mi tolgo dalla mappa degli oggetti
  RD3_DesktopManager.ObjectMap[this.Identifier] = null;
  //
  // Passo il comando a tutti i miei figli
  this.IndObj.Unrealize();
  this.CmdObj.Unrealize();
  this.TimerObj.Unrealize();
  this.VSList.Unrealize();
  this.VoiceObj.Unrealize();
  //
  var n = this.StackForm.length;
  for (var i = 0; i < n; i++)
  {
    this.StackForm[i].Unrealize();
  }
  //
  // Distruggo la DelayDialog
  this.DelayDialog.Unrealize();
  //
  // Rimuovo i collegamenti al DOM
  this.WepBox = null;
  this.HeaderBox = null;
  this.SideMenuBox = null;
  //#########START CUSTOM CODE##########
  this.RightSideMenuBox
  //##########END CUSTOM CODE##########
  this.FormsBox = null;
  this.MenuBox = null;
  this.FormListBox = null;
  this.FormListHeader = null;
  this.FormListTitle = null;
  this.CloseAllBox = null;
  this.CloseAllButton = null;
  //
  this.Realized = false;
}
