// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe PopupPreview: Implementa una finestra modale
// da utilizzare per mostrare un'URL
// Estende PopupFrame
// ************************************************

function PopupPreview(address, capt)
{
  this.PreviewUrl = address;       // L'URL da mostrare nel frame
  this.PreviewCaption = capt;   // Il testo della caption
  //
  this.Identifier = "POPPRE" + Math.floor(Math.random() * 100);  // Identificatore per gestire il click sul pulsante di chiusura 
                                                                 // (ci puo' essere un solo Msgbox attivo per volta, basterebbe anche una stringa fissa per identificatore)
  //
  // Altre variabili di questo oggetto di modello
  this.Loaded = false;            // L'iframe e' stato caricato?
  this.IE = false;                // Caching del tipo di browser
  //
  // Elementi visuali della PopupPreview
  this.CloseButton = null;        // IMG che contiene il pulsante di chiusura
  this.CaptionTxt = null;         // SPAN che contiene il testo della caption
  this.PreviewFrame = null;       // IFrame che contiene il documento esterno
}

// Definisco l'estensione della classe
PopupPreview.prototype = new PopupFrame();


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// ***************************************************************
PopupPreview.prototype.Realize = function(cls)
{
  PopupFrame.prototype.Realize.call(this, cls);
  RD3_Glb.AddClass(this.ContentBox, "popup-preview-body")
  //
  // Close 
  this.CloseButton = document.createElement("button");
  this.CloseButton.className = "close";
  this.CloseButton.setAttribute("data-dismiss", "modal");
  this.CloseButton.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_CLOSE));
  this.CaptionBox.appendChild(this.CloseButton);
  //
  // Caption
  this.TitleBox = document.createElement("h4");
  this.TitleBox.className = "modal-title";
  this.CaptionBox.appendChild(this.TitleBox);
  // 
  // Testo
  this.MsgTxt = document.createElement("span");
  this.MsgTxt.innerHTML = this.PreviewCaption;
  this.MsgTxt.className = "popup-text";
  this.TitleBox.appendChild(this.MsgTxt);
  //
  // iFrame
  this.PreviewFrame = document.createElement("iframe");
	this.PreviewFrame.src = this.PreviewUrl;
	this.PreviewFrame.className = "popup-preview-iframe";
  this.ContentBox.appendChild(this.PreviewFrame);
  //
  // Eventi
  this.IE = RD3_Glb.IsIE(10, false);
  var _this = this;
  var readyFunction = function (ev) {
    _this.OnReadyStateChange(ev);
  }
  //
	if (this.IE)
	  this.PreviewFrame.onreadystatechange = readyFunction;
	else
	  this.PreviewFrame.onload = readyFunction;
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
PopupPreview.prototype.Unrealize = function()
{
	// Chiamo la classe base
	PopupFrame.prototype.Unrealize.call(this);	
	//
	// Rimuovo i riferimenti al DOM
	this.CloseButton = null;
	this.CaptionTxt = null;
  this.PreviewFrame = null;
}

PopupPreview.prototype.AdaptLayout = function()
{
  
}


// *******************************************************
// Metodo che gestisce il cambio dello stato dell'IFrame
// e dimensiona il frame come il suo contenuto
// *******************************************************
PopupPreview.prototype.OnReadyStateChange = function()
{
  var ok = true;
  if (this.IE && this.PreviewFrame.readyState != "complete")
    ok = false;
  //
	if (ok)
	{
	  this.Loaded = true;
	  //
    var maxw = RD3_DesktopManager.WebEntryPoint.WepBox.clientWidth;
    var maxh = RD3_DesktopManager.WebEntryPoint.WepBox.clientHeight;
    maxw = Math.floor((maxw/3)*2);
    maxh = Math.floor((maxh/10)*9);

    //
    // tento di leggere le dimensioni del contenuto
    var w = -1;
    var h = -1;
    //
    try {
      w = this.PreviewFrame.contentWindow.document.body.scrollWidth+15;
      h = this.PreviewFrame.contentWindow.document.body.scrollHeight+15;
    }
    catch(ex) {
    }
    //
    // Se non le ho reperite oppure sono troppo grandi...
    if (w==-1 || w>maxw)
    	w = maxw;
    if (h==-1 || h>maxh)
    	h = maxh;
    if (w < 250)
      w = 250;
    if (h < 250)
      h = 250;
    //
    this.PreviewFrame.style.width = w + "px";
    this.PreviewFrame.style.height = h + "px";
	}
}
