// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe MessageBox: implementa il funzionamento della
// MessageBox, della MessageConfirm e della InputBox
// Estende PopupFrame
// ************************************************

function MessageBox(text, type, snd, options)
{
  this.MessageText = text;  // Il testo del messaggio da mostrare
  this.Type = type;      		// Il tipo di box (vedi GlobalObj)
  this.Send = true;         // True se la risposta deve andare al server, false se e' una confirm lato client
  if (snd != undefined)
    this.Send = snd;
  this.Options = "";        // Eventuali bottoni impostati dall'utente
  if (options != undefined && options != null)
    this.Options = options;
  //
  this.Identifier = "MSGBOX" + Math.floor(Math.random() * 100);  // Identificatore per gestire il click 
                                                                 // (ci puo' essere un solo Msgbox attivo per volta, basterebbe anche una stringa fissa per identificatore)
  //
  // Variabili interne della MessageBox
  this.CallBackFunction = null;       // Funzione Callback da chiamare alla pressione di uno dei tasti
  this.UserResponse = "";             // Risposta dell'utente (Y o N se MsgConfirm, Stringa se MsgInput)
  this.Blocking = false;              // Il messaggio inviato al server deve essere bloccante?
  //
  // Elementi visuali delle messageBox
  this.MsgTxt = null;                 // DIV contenente il messaggio
  this.ButtonBox = null;              // DIV contenente i pulsanti
  this.ConfirmButton = null;          // Pulsante di OK o di CONFIRM
  this.CancelButton = null;           // Pulsante di Cancel
  this.MsgInputDiv = null;            // DIV contenente l'input del messaggio
  this.MsgInput = null;               // Input del messaggio
  this.MsgIconDiv = null;             // DIV contenente l'icona
  this.MsgIcon = null;                // IMG dell'icona da associare al messaggio
  //this.OptionsButtons = new Array() // Array dei bottoni personalizzati
}

// Definisco l'estensione della classe
MessageBox.prototype = new PopupFrame();


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
MessageBox.prototype.Realize = function()
{
	// Chiamo la classe base
	PopupFrame.prototype.Realize.call(this, "-message-box");
  //
  // Imposto lo zIndex per fare in modo che i tooltip rimangano sotto
  // this.PopupBox.style.zIndex = 300;
	//
	// Creo gli oggetti nel DOM uguali per tutti i tipi di Message Box
	// DIV per l'immagine e immagine stessa
  this.TitleBox = document.createElement("h4");
  this.TitleBox.className = "modal-title";
  this.CaptionBox.appendChild(this.TitleBox);
  //
  // Testo del messaggio vero e proprio (per gli input usiamo la Label)
  if (this.Type !== RD3_Glb.MSG_INPUT) {
    this.MsgTxt = document.createElement("span");
    this.MsgTxt.className = "popup-text";
    //
    if (this.MessageText.indexOf("cls=") == 0 && this.MessageText.indexOf(",") != -1)
    {
      // Il testo contiene una classe CSS, la uso
      var cls = this.MessageText.split(",")[0].substring(4);
      this.MsgTxt.innerHTML = RD3_Glb.HandleIconString(this.MessageText.split(",")[1]);
      RD3_Glb.AddClass(this.PopupBox, cls);
    }
    else
      this.MsgTxt.innerHTML = RD3_Glb.HandleIconString(this.MessageText);
  }  
  //
  // Se c'e' un solo nodo di tipo TEXT allora e' testo puro. Cambio i \n in <br/>
  if (this.MsgTxt && this.MsgTxt.childNodes.length==1 && !this.MsgTxt.childNodes[0].tagName)
    this.MsgTxt.innerHTML = this.MsgTxt.innerHTML.replace(/\n/g, "<br/>");
  //
  // DIV contenente l'eventuale input per l'InputBox
  this.MsgInputDiv = document.createElement("div");
  this.MsgInputDiv.style.height = "10px";
  //
  // DIV che contiene i bottone del message box
  this.ButtonBox = document.createElement("div");
  this.ButtonBox.className = "modal-footer";
	//
	// Devo renderizzarmi in maniera differente in base al tipo, inserisco alcuni oggetti
	// diversi e modifico alcune proprieta' di oggetti esistenti
	//
	// Devo creare una message confirm con due pulsanti: Yes e Annulla
  var _this = this;
	if (this.Type == RD3_Glb.MSG_CONFIRM)
	{
	  this.TitleBox.innerHTML = ClientMessages.MSG_POPUP_MsgConfirmCaption;
	  //
	  if (this.Options == "")
	  {
  	  // Creo i pulsanti per confermare o annullare
  	  this.ConfirmButton = document.createElement("button");
  	  this.ConfirmButton.innerHTML = ClientMessages.MSG_POPUP_YesButton;
  	  this.ConfirmButton.className = "btn btn-primary popup-button-yes";
  	  this.ConfirmButton.id = this.Identifier + ":yes";
  	  //
  	  this.CancelButton = document.createElement("button");
  	  this.CancelButton.innerHTML = ClientMessages.MSG_POPUP_NoButton;
  	  this.CancelButton.className = "btn btn-default popup-button-no";
  	  this.CancelButton.id = this.Identifier + ":no";
  	  //
  	  RD3_Glb.AddClass(RD3_ClientParams.DefaultButton?this.ConfirmButton:this.CancelButton,"popup-button-default");
      //
      this.ConfirmButton.onclick = function (ev) {
        _this.OnOKClick(ev);
      };
      this.CancelButton.onclick = function (ev) {
        _this.OnCancelClick(ev);
      };
  	  //
  	  // Inserisco gli elementi nel DOM
      this.ButtonBox.appendChild(this.CancelButton);
  	  this.ButtonBox.appendChild(this.ConfirmButton);
  	}
    else
    {
      this.OptionsButtons = new Array();
      var opts = this.Options.split(";");
      //
      for (var i=0; i<opts.length; i++)
      {
        var optButton = document.createElement("button");
    	  optButton.innerHTML = opts[i];
    	  optButton.className = "btn "+ (i==0 ? "btn-primary " : "btn-default ") +"popup-button-optn";
        optButton.setAttribute("btn-idx", i+1);
    	  optButton.id = this.Identifier + ":opt" + i;
    	  //
    	  // Gestisco il click sui pulsanti
        optButton.onclick = function (ev) {
          _this.OnOptionClick(ev, this.getAttribute("btn-idx"));
        };
    	  //
    	  // Inserisco gli elementi nel DOM
    	  this.ButtonBox.appendChild(optButton);
    	  this.OptionsButtons[i] = optButton;
      }
    }
	}
  else if (this.Type == RD3_Glb.MSG_INPUT) // Devo creare una Input Box con due pulsanti: CONFIRM e CANCEL e un input
  {
    this.TitleBox.innerHTML = ClientMessages.MSG_POPUP_MsgInputCaption;
    //
	  this.MsgLabel = document.createElement("p");
    if (this.MessageText.indexOf("cls=") == 0 && this.MessageText.indexOf(",") != -1)
    {
      // Il testo contiene una classe CSS, la uso
      var cls = this.MessageText.split(",")[0].substring(4);
      this.MsgLabel.innerHTML = RD3_Glb.HandleIconString(this.MessageText.split(",")[1]);
      RD3_Glb.AddClass(this.PopupBox, cls);
    }
    else
      this.MsgLabel.innerHTML = RD3_Glb.HandleIconString(this.MessageText);
    //
    // Creo l'input
    this.MsgInput = document.createElement("input");
    this.MsgInput.type = "text";
	  this.MsgInput.id = this.Identifier + ":inp";
    this.MsgInput.className = "form-control";
    RD3_Glb.AutocompleteOff(this.MsgInput);
    //
    this.MsgInputDiv.className = "form-group";
    this.MsgInputDiv.appendChild(this.MsgLabel);
    this.MsgInputDiv.appendChild(this.MsgInput);
    this.MsgInputDiv.style.height = "";
    //
	  // Creo i pulsanti  per confermare o annullare
	  this.ConfirmButton = document.createElement("button");
	  this.ConfirmButton.innerHTML = ClientMessages.MSG_POPUP_OkButton;
	  this.ConfirmButton.className = "btn btn-primary popup-button-yes";
	  this.ConfirmButton.id = this.Identifier + ":yes";
	  //
	  this.CancelButton = document.createElement("button");
	  this.CancelButton.innerHTML = ClientMessages.MSG_POPUP_CancelButton;
	  this.CancelButton.className = "btn btn-default popup-button-no";
	  this.CancelButton.id = this.Identifier + ":no";
	  //
	  RD3_Glb.AddClass(RD3_ClientParams.DefaultButton?this.ConfirmButton:this.CancelButton,"popup-button-default");
	  //
	  // Gestisco il click sui pulsanti
    this.ConfirmButton.onclick = function (ev) {
      _this.OnOKClick(ev);
    };
    this.CancelButton.onclick = function (ev) {
      _this.OnCancelClick(ev);
    };
    this.MsgInput.onkeypress = function (ev) {
      var code = (ev.charCode) ? ev.charCode : ev.keyCode;
      if (code == 13)
        _this.OnOKClick(ev);
    };
	  //
	  // Inserisco gli elementi nel DOM
    this.ButtonBox.appendChild(this.CancelButton);
	  this.ButtonBox.appendChild(this.ConfirmButton);
    //
    if (RD3_Glb.IsBZen())
      this.ContentBox.className += " modal-input-box";
  }
  else // Devo creare una semplice MessageBox
	{
	  this.TitleBox.innerHTML = ClientMessages.MSG_POPUP_MsgBoxCaption;
	  //
	  // Creo il pulsante di chiusura message box
	  this.ConfirmButton = document.createElement("button");
	  this.ConfirmButton.innerHTML = ClientMessages.MSG_POPUP_OkButton;
	  this.ConfirmButton.className = "btn btn-primary  popup-button-yes";
	  this.ConfirmButton.id = this.Identifier + ":yes";
	  //
	  // Gestisco il click sul pulsante
    this.ConfirmButton.onclick = function (ev) {
      _this.OnOKClick(ev);
    };
	  //
	  // Inserisco gli elementi nel DOM
	  this.ButtonBox.appendChild(this.ConfirmButton);
	}
	//
	// Inserisco nel DOM tutta la gerarchia
  if (this.MsgTxt)
    this.ContentBox.appendChild(this.MsgTxt);
  this.ContentBox.appendChild(this.MsgInputDiv);
  this.PopupContent.appendChild(this.ButtonBox);
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
MessageBox.prototype.Unrealize = function()
{
	// Chiamo la classe base
	PopupFrame.prototype.Unrealize.call(this);	
	//
	// Rimuovo i riferimenti al DOM
	this.MsgTxt = null;
  this.ButtonBox = null;
  this.ConfirmButton = null;
  this.MsgInput = null;
  if (this.OptionsButtons)
    this.OptionsButtons = null;
  //
  // Avviso il VoiceObj che una messagebox e' stata chiusa
  RD3_DesktopManager.WebEntryPoint.VoiceObj.OnCloseMessageBox(this);
}

// ***************************************************
// Dimensiono la Box in base al contenuto
// ***************************************************
MessageBox.prototype.AdaptLayout = function()
{

}


// ********************************************************
// Gestore del click sul pulsante Ok o di conferma
// ********************************************************
MessageBox.prototype.OnOKClick = function(evento)
{
  // Leggo il risultato
  var msg = "";
  if (this.Type == RD3_Glb.MSG_CONFIRM)
    msg = "Y";
  if (this.Type == RD3_Glb.MSG_INPUT)
    msg = this.MsgInput.value;
  //
  if (this.Type != RD3_Glb.MSG_BOX && this.Send) {
    // Devo mandare un messaggio al server prima di chiudermi 
    var ev = new IDEvent("msgcfr", this.Identifier, evento, (this.Blocking? RD3_Glb.EVENT_URGENT : RD3_Glb.EVENT_ACTIVE), this.MessageText, msg);
  }
  //
  // Gestione lato client
  if (this.CallBackFunction) {
    this.UserResponse = msg;
    this.CallBackFunction();
  }
  //
  // Chiudo la popup
  this.Close();
}


// ********************************************************
// Gestore del click sul pulsante Annulla o No
// ********************************************************
MessageBox.prototype.OnCancelClick = function(evento)
{
  var msg = "";
  if (this.Type == RD3_Glb.MSG_CONFIRM)
    msg = "N";
  //
  if (this.Type != RD3_Glb.MSG_BOX && this.Send) {
    // Devo mandare un messaggio al server prima di chiudermi
    var ev = new IDEvent("msgcfr", this.Identifier, evento, (this.Blocking? RD3_Glb.EVENT_URGENT : RD3_Glb.EVENT_ACTIVE), this.MessageText, msg);
  }
  //
  // Gestione lato client
  if (this.CallBackFunction) {
    this.UserResponse = msg;
    this.CallBackFunction();
  }
  //
  // Chiudo la popup
  this.Close();
}

// ********************************************************
// Gestore del click su di una opzione generica
// ********************************************************
MessageBox.prototype.OnOptionClick = function(evento, optIndex)
{
  if (this.Type == RD3_Glb.MSG_CONFIRM && this.Send) {
    // Devo mandare un messaggio al server prima di chiudermi
    var ev = new IDEvent("msgcfr", this.Identifier, evento, (this.Blocking? RD3_Glb.EVENT_URGENT : RD3_Glb.EVENT_ACTIVE), this.MessageText, optIndex);
  }
  //
  // Gestione lato client
  if (this.CallBackFunction) {
    this.UserResponse = optIndex;
    this.CallBackFunction();
  }
  //
  // Chiudo la popup
  this.Close();
}


// ********************************************************
// Gestore della pressione di un pulsante
// ********************************************************
MessageBox.prototype.OnKeyPress = function(evento)
{
  
}


// ********************************************************************************
// Suona se deve e apre la popup
// ********************************************************************************
MessageBox.prototype.Open = function()
{ 
  // Chiamo la classe base
  PopupFrame.prototype.Open.call(this);
  //
  // Eseguo il blur dell'input attivo se presente
  if (RD3_KBManager.ActiveElement && RD3_KBManager.ActiveElement.blur)
    RD3_KBManager.ActiveElement.blur();
  //
  // Uso un timer per dare il fuoco al pulsante predefinito
  var _this = this;
  window.setTimeout(function() {
    if (_this.MsgInput)
      _this.MsgInput.focus();
    else if (_this.ConfirmButton)
      _this.ConfirmButton.focus();
    else if (_this.CancelButton)
      _this.CancelButton.focus();
    else if (_this.OptionsButtons && _this.OptionsButtons.length > 0)
      _this.OptionsButtons[0].focus();
  }, 500);
}


// ********************************************************************************
// Chiude la finestra
// ********************************************************************************
MessageBox.prototype.Close = function()
{ 
	// Metto il fuoco fuori dall'input, per sperare di chiudere la tastiera
	if(this.Type==RD3_Glb.MSG_INPUT) {
		this.MsgInput.blur();
		//
		// Non lo faccio per android se no il bottone si illumina
		// anche se in questo momento non deve
		if (!RD3_Glb.IsAndroid())
			this.ConfirmButton.focus();
	}
	//
	// Chiamo la classe base
	PopupFrame.prototype.Close.call(this);
}

// ********************************************************************************
// Arrivato comando vocale
// ********************************************************************************
MessageBox.prototype.OnVoiceCommand = function(text)
{
  if (this.Type == RD3_Glb.MSG_CONFIRM) {
    // Tolgo lo spazio in piu' all'inizio e rendo maiuscola la prima lettera
    var t = text.trim().charAt(0).toUpperCase() + text.trim().slice(1);
    //
    if (this.Options == "") {
      if (this.ConfirmButton && this.ConfirmButton.value == t)
        this.ConfirmButton.click();
      else if (this.CancelButton && this.CancelButton.value == t)
        this.CancelButton.click();
    }
    else {
      this.OptionsButtons = new Array();
      var opts = this.Options.split(";");
      //
      for (var i=0; i<opts.length; i++)
      {
        var optButton = document.createElement("input");
        if (optButton.value == t)
        {
          optButton.click();
          break;
        }
      }
    }
  }
  else if (this.Type == RD3_Glb.MSG_INPUT) // Devo creare una Input Box con due pulsanti: CONFIRM e CANCEL e un input
  {
    if (this.CancelButton && this.CancelButton.value == t)
      this.CancelButton.click();
    else {
      this.MsgInput.value = t;
      this.ConfirmButton.click();
    }
  }
  else // Devo creare una semplice MessageBox
  {
    // Non faccio nulla poiche' e' gia' stata gestita prima dal VoiceObj
    // (vedi Desktop::HandleMessageBox)
  }
}